# Generated by Django 4.1.9 on 2023-08-07 15:48

from django.db import migrations, models


def update_first_enrolled_at(apps, schema_editor):
    ReEnrollmentSession = apps.get_model("mdm", "ReEnrollmentSession")
    for res in ReEnrollmentSession.objects.all():
        enrollment = None
        for attr, s_attr in (("dep_enrollment", "depenrollmentsession_set"),
                             ("ota_enrollment", "otaenrollmentsession_set"),
                             ("user_enrollment", "userenrollmentsession_set")):
            enrollment = getattr(res, attr, None)
            if enrollment:
                break
        es = None
        if enrollment:
            es = (
                getattr(enrollment, s_attr)
                .filter(enrolled_device__serial_number=res.enrolled_device.serial_number)
                .order_by("-created_at")
                .first()
            )
        if es:
            res.first_enrolled_at = es.created_at
        else:
            res.first_enrolled_at = res.created_at
        res.save()


class Migration(migrations.Migration):

    dependencies = [
        ('mdm', '0067_recoverypasswordconfig_and_more'),
    ]

    operations = [
        migrations.AddField(
            model_name='reenrollmentsession',
            name='first_enrolled_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.RunPython(update_first_enrolled_at),
        migrations.AlterField(
            model_name='reenrollmentsession',
            name='first_enrolled_at',
            field=models.DateTimeField(),
        ),
    ]
