# Generated by Django 4.1.9 on 2023-08-03 14:57

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('mdm', '0066_filevaultconfig_alter_blueprint_options_and_more'),
    ]

    operations = [
        migrations.CreateModel(
            name='RecoveryPasswordConfig',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.CharField(max_length=256, unique=True)),
                ('dynamic_password', models.BooleanField(default=True)),
                ('static_password', models.TextField(editable=False, null=True)),
                ('rotation_interval_days', models.IntegerField(default=0, help_text='Interval in days after which the recovery password will be automatically rotated.', validators=[django.core.validators.MinValueValidator(0), django.core.validators.MaxValueValidator(366)], verbose_name='Rotation interval (days)')),
                ('rotate_firmware_password', models.BooleanField(default=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.AddField(
            model_name='enrolleddevice',
            name='recovery_password',
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name='enrolleddevice',
            name='recovery_password_updated_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='blueprint',
            name='recovery_password_config',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.SET_NULL, to='mdm.recoverypasswordconfig'),
        ),
        migrations.AlterModelOptions(
            name='enrolleddevice',
            options={'permissions': [('view_filevault_prk', 'Can view FileVault PRK'), ('view_recovery_password', 'Can view recovery password')]},
        ),
    ]
