# Generated by Django 3.2.17 on 2023-02-21 15:18

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import zentral.contrib.mdm.models


class Migration(migrations.Migration):
    dependencies = [
        ("inventory", "0076_remove_currentmachinesnapshot_tree"),
        ("mdm", "0059_auto_20230502_1855"),
    ]

    operations = [
        migrations.RemoveField(
            model_name="blueprintartifact",
            name="auto_update",
        ),
        migrations.RemoveField(
            model_name="blueprintartifact",
            name="install_before_setup_assistant",
        ),
        migrations.RemoveField(
            model_name="blueprintartifact",
            name="priority",
        ),
        migrations.AddField(
            model_name="artifact",
            name="auto_update",
            field=models.BooleanField(default=True),
        ),
        migrations.AddField(
            model_name="artifact",
            name="install_during_setup_assistant",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="artifact",
            name="reinstall_interval",
            field=models.IntegerField(
                default=0,
                help_text="In days, the time interval after which the artifact will be reinstalled. "
                "If 0, the artifact will not be reinstalled. Defaults to 0.",
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(366),
                ],
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="reinstall_on_os_update",
            field=models.CharField(
                choices=[
                    ("No", "No"),
                    ("Major", "Major"),
                    ("Minor", "Minor"),
                    ("Patch", "Patch"),
                ],
                default="No",
                max_length=5,
            ),
        ),
        migrations.AddField(
            model_name="artifact",
            name="requires",
            field=models.ManyToManyField(
                related_name="requiredby_set", to="mdm.Artifact", blank=True
            ),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="default_shard",
            field=models.IntegerField(
                default=100,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
            ),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="excluded_tags",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="inventory.tag",
            ),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="ios",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="ios_max_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="ios_min_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="ipados",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="ipados_max_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="ipados_min_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="macos",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="macos_max_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="macos_min_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="shard_modulo",
            field=models.IntegerField(
                default=100,
                validators=[
                    django.core.validators.MinValueValidator(2),
                    django.core.validators.MaxValueValidator(100),
                ],
            ),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="tvos",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="tvos_max_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="artifactversion",
            name="tvos_min_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name='artifactversion',
            name='updated_at',
            field=models.DateTimeField(auto_now=True),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="default_shard",
            field=models.IntegerField(
                default=100,
                validators=[
                    django.core.validators.MinValueValidator(0),
                    django.core.validators.MaxValueValidator(100),
                ],
            ),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="excluded_tags",
            field=models.ManyToManyField(
                blank=True,
                related_name="+",
                to="inventory.tag",
            ),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="ios",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="ios_max_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="ios_min_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="ipados",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="ipados_max_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="ipados_min_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="macos",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="macos_max_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="macos_min_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="shard_modulo",
            field=models.IntegerField(
                default=100,
                validators=[
                    django.core.validators.MinValueValidator(2),
                    django.core.validators.MaxValueValidator(100),
                ],
            ),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="tvos",
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="tvos_max_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="blueprintartifact",
            name="tvos_min_version",
            field=models.CharField(blank=True, max_length=32),
        ),
        migrations.AddField(
            model_name="deviceartifact",
            name="extra_info",
            field=models.JSONField(default=dict),
        ),
        migrations.AddField(
            model_name="deviceartifact",
            name="installed_at",
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name="deviceartifact",
            name="os_version_at_install_time",
            field=models.CharField(max_length=64, null=True),
        ),
        migrations.AddField(
            model_name="userartifact",
            name="extra_info",
            field=models.JSONField(default=dict),
        ),
        migrations.AddField(
            model_name="userartifact",
            name="installed_at",
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name="userartifact",
            name="os_version_at_install_time",
            field=models.CharField(max_length=64, null=True),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="platforms",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(
                    choices=[
                        ("iOS", "Ios"),
                        ("iPadOS", "Ipados"),
                        ("macOS", "Macos"),
                        ("tvOS", "Tvos"),
                    ],
                    max_length=64,
                ),
                default=zentral.contrib.mdm.models.get_platform_values,
                size=None,
            ),
        ),
        migrations.AlterField(
            model_name="artifact",
            name="type",
            field=models.CharField(
                choices=[
                    ("Enterprise App", "Enterprise App"),
                    ("Profile", "Profile"),
                    ("Store App", "Store App"),
                ],
                editable=False,
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="asset",
            name="supported_platforms",
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(
                    choices=[
                        ("iOS", "Ios"),
                        ("iPadOS", "Ipados"),
                        ("macOS", "Macos"),
                        ("tvOS", "Tvos"),
                    ],
                    max_length=64,
                ),
                size=None,
            ),
        ),
        migrations.AlterField(
            model_name="deviceartifact",
            name="status",
            field=models.CharField(
                choices=[
                    ("Acknowledged", "Acknowledged"),
                    ("AwaitingConfirmation", "Awaiting Confirmation"),
                    ("Installed", "Installed"),
                    ("Uninstalled", "Uninstalled"),
                    ("Failed", "Failed"),
                ],
                default="Acknowledged",
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="devicecommand",
            name="status",
            field=models.CharField(
                choices=[
                    ("Acknowledged", "Acknowledged"),
                    ("CommandFormatError", "Command Format Error"),
                    ("Error", "Error"),
                    ("NotNow", "Not Now"),
                ],
                max_length=64,
                null=True,
            ),
        ),
        migrations.AlterField(
            model_name="enrolleddevice",
            name="platform",
            field=models.CharField(
                choices=[
                    ("iOS", "Ios"),
                    ("iPadOS", "Ipados"),
                    ("macOS", "Macos"),
                    ("tvOS", "Tvos"),
                ],
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="softwareupdate",
            name="platform",
            field=models.CharField(
                choices=[
                    ("iOS", "Ios"),
                    ("iPadOS", "Ipados"),
                    ("macOS", "Macos"),
                    ("tvOS", "Tvos"),
                ],
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="userartifact",
            name="status",
            field=models.CharField(
                choices=[
                    ("Acknowledged", "Acknowledged"),
                    ("AwaitingConfirmation", "Awaiting Confirmation"),
                    ("Installed", "Installed"),
                    ("Uninstalled", "Uninstalled"),
                    ("Failed", "Failed"),
                ],
                default="Acknowledged",
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="usercommand",
            name="status",
            field=models.CharField(
                choices=[
                    ("Acknowledged", "Acknowledged"),
                    ("CommandFormatError", "Command Format Error"),
                    ("Error", "Error"),
                    ("NotNow", "Not Now"),
                ],
                max_length=64,
                null=True,
            ),
        ),
        migrations.CreateModel(
            name="BlueprintArtifactTag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "shard",
                    models.IntegerField(
                        default=100,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "blueprint_artifact",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mdm.blueprintartifact",
                    ),
                ),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="inventory.tag",
                    ),
                ),
            ],
            options={
                "unique_together": {("blueprint_artifact", "tag")},
            },
        ),
        migrations.CreateModel(
            name="ArtifactVersionTag",
            fields=[
                (
                    "id",
                    models.AutoField(
                        auto_created=True,
                        primary_key=True,
                        serialize=False,
                        verbose_name="ID",
                    ),
                ),
                (
                    "shard",
                    models.IntegerField(
                        default=100,
                        validators=[
                            django.core.validators.MinValueValidator(1),
                            django.core.validators.MaxValueValidator(100),
                        ],
                    ),
                ),
                (
                    "artifact_version",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        to="mdm.artifactversion",
                    ),
                ),
                (
                    "tag",
                    models.ForeignKey(
                        on_delete=django.db.models.deletion.CASCADE,
                        related_name="+",
                        to="inventory.tag",
                    ),
                ),
            ],
            options={
                "unique_together": {("artifact_version", "tag")},
            },
        ),
        migrations.AlterModelOptions(
            name="artifactversion",
            options={"ordering": ("-version",)},
        ),
        migrations.RemoveField(
            model_name="blueprint",
            name="activation",
        ),
        migrations.RemoveField(
            model_name="blueprint",
            name="declaration_items",
        ),
        migrations.AddField(
            model_name="blueprint",
            name="serialized_artifacts",
            field=models.JSONField(default=dict, editable=False),
        ),
        migrations.AlterField(
            model_name="artifactversiontag",
            name="artifact_version",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="item_tags",
                to="mdm.artifactversion",
            ),
        ),
        migrations.AlterField(
            model_name="blueprintartifacttag",
            name="blueprint_artifact",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="item_tags",
                to="mdm.blueprintartifact",
            ),
        ),
        migrations.AlterField(
            model_name="deviceartifact",
            name="enrolled_device",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="target_artifacts",
                to="mdm.enrolleddevice",
            ),
        ),
        migrations.AlterField(
            model_name="deviceartifact",
            name="status",
            field=models.CharField(
                choices=[
                    ("Acknowledged", "Acknowledged"),
                    ("AwaitingConfirmation", "Awaiting Confirmation"),
                    ("Installed", "Installed"),
                    ("Uninstalled", "Uninstalled"),
                    ("Failed", "Failed"),
                    ("RemovalFailed", "Removal Failed"),
                ],
                default="Acknowledged",
                max_length=64,
            ),
        ),
        migrations.AlterField(
            model_name="userartifact",
            name="enrolled_user",
            field=models.ForeignKey(
                on_delete=django.db.models.deletion.CASCADE,
                related_name="target_artifacts",
                to="mdm.enrolleduser",
            ),
        ),
        migrations.AlterField(
            model_name="userartifact",
            name="status",
            field=models.CharField(
                choices=[
                    ("Acknowledged", "Acknowledged"),
                    ("AwaitingConfirmation", "Awaiting Confirmation"),
                    ("Installed", "Installed"),
                    ("Uninstalled", "Uninstalled"),
                    ("Failed", "Failed"),
                    ("RemovalFailed", "Removal Failed"),
                ],
                default="Acknowledged",
                max_length=64,
            ),
        ),
        migrations.AddField(
            model_name="enrolleduser",
            name="declarations_token",
            field=models.CharField(default="", max_length=40),
        ),
        migrations.AddField(
            model_name="enrolleduser",
            name="declarative_management",
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name="enrolleddevice",
            name="declarations_token",
            field=models.CharField(default="", max_length=40),
        ),
        migrations.AddField(
            model_name="deviceartifact",
            name="unique_install_identifier",
            field=models.CharField(default="", max_length=256),
        ),
        migrations.AddField(
            model_name="userartifact",
            name="unique_install_identifier",
            field=models.CharField(default="", max_length=256),
        ),
        migrations.RemoveField(
            model_name='artifact',
            name='trashed_at',
        ),
        migrations.AlterUniqueTogether(
            name='blueprintartifact',
            unique_together={('blueprint', 'artifact')},
        ),
        migrations.AddField(
            model_name='enterpriseapp',
            name='configuration',
            field=models.BinaryField(null=True),
        ),
        migrations.AddField(
            model_name='enterpriseapp',
            name='install_as_managed',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='enterpriseapp',
            name='ios_app',
            field=models.BooleanField(default=False),
        ),
        migrations.AddField(
            model_name='enterpriseapp',
            name='remove_on_unenroll',
            field=models.BooleanField(default=False),
        ),
        migrations.AlterField(
            model_name='artifact',
            name='channel',
            field=models.CharField(choices=[('Device', 'Device'), ('User', 'User')], max_length=64),
        ),
        migrations.AlterField(
            model_name='artifact',
            name='type',
            field=models.CharField(choices=[('Enterprise App', 'Enterprise App'),
                                            ('Profile', 'Profile'),
                                            ('Store App', 'Store App')], max_length=64),
        ),
    ]
