# Generated by Django 3.2.14 on 2023-01-08 11:28

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import uuid


class Migration(migrations.Migration):

    dependencies = [
        ('mdm', '0055_auto_20220919_0939'),
    ]

    operations = [
        migrations.CreateModel(
            name='Asset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('adam_id', models.CharField(max_length=64)),
                ('pricing_param', models.CharField(max_length=16)),
                ('product_type', models.CharField(choices=[('App', 'App'), ('Book', 'Book')], max_length=4)),
                ('device_assignable', models.BooleanField()),
                ('revocable', models.BooleanField()),
                ('supported_platforms', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(choices=[('iOS', 'iOS'), ('iPadOS', 'iPadOS'), ('macOS', 'macOS'), ('tvOS', 'tvOS')], max_length=64), size=None)),
                ('metadata', models.JSONField(null=True)),
                ('name', models.TextField(null=True)),
                ('bundle_id', models.TextField(null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'unique_together': {('adam_id', 'pricing_param')},
            },
        ),
        migrations.CreateModel(
            name='Location',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('server_token_hash', models.CharField(max_length=40, unique=True)),
                ('server_token', models.TextField(null=True)),
                ('server_token_expiration_date', models.DateTimeField()),
                ('organization_name', models.TextField()),
                ('name', models.TextField()),
                ('country_code', models.CharField(max_length=2)),
                ('library_uid', models.TextField()),
                ('platform', models.TextField()),
                ('website_url', models.URLField()),
                ('mdm_info_id', models.UUIDField(default=uuid.uuid4, editable=False, unique=True)),
                ('notification_auth_token_hash', models.CharField(editable=False, max_length=64)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ('name', 'organization_name'),
            },
        ),
        migrations.CreateModel(
            name='LocationAsset',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('assigned_count', models.IntegerField(default=0)),
                ('available_count', models.IntegerField(default=0)),
                ('retired_count', models.IntegerField(default=0)),
                ('total_count', models.IntegerField(default=0)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('asset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mdm.asset')),
                ('location', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mdm.location')),
            ],
            options={
                'unique_together': {('asset', 'location')},
            },
        ),
        migrations.AlterField(
            model_name='artifact',
            name='type',
            field=models.CharField(choices=[('EnterpriseApp', 'Enterprise App'), ('Profile', 'Profile'), ('StoreApp', 'Store App')], editable=False, max_length=64),
        ),
        migrations.CreateModel(
            name='StoreApp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('associated_domains', django.contrib.postgres.fields.ArrayField(base_field=models.CharField(max_length=256, validators=[django.core.validators.MinLengthValidator(3)]), blank=True, default=list, size=None)),
                ('associated_domains_enable_direct_downloads', models.BooleanField(default=False)),
                ('removable', models.BooleanField(default=False)),
                ('vpn_uuid', models.TextField(blank=True, null=True)),
                ('content_filter_uuid', models.TextField(blank=True, null=True)),
                ('dns_proxy_uuid', models.TextField(blank=True, null=True)),
                ('configuration', models.BinaryField(null=True)),
                ('remove_on_unenroll', models.BooleanField(default=True)),
                ('prevent_backup', models.BooleanField(default=False)),
                ('artifact_version', models.OneToOneField(on_delete=django.db.models.deletion.CASCADE, related_name='store_app', to='mdm.artifactversion')),
                ('location_asset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mdm.locationasset')),
            ],
        ),
        migrations.CreateModel(
            name='EnrolledDeviceLocationAssetAssociation',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('attempts', models.IntegerField(default=0)),
                ('last_attempted_at', models.DateTimeField(null=True)),
                ('enrolled_device', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mdm.enrolleddevice')),
                ('location_asset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mdm.locationasset')),
            ],
            options={
                'unique_together': {('enrolled_device', 'location_asset')},
            },
        ),
        migrations.CreateModel(
            name='DeviceAssignment',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('serial_number', models.TextField(db_index=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('location_asset', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='mdm.locationasset')),
            ],
            options={
                'unique_together': {('location_asset', 'serial_number')},
            },
        ),
    ]
