# Generated by Django 3.2.14 on 2022-08-04 17:41

from django.db import migrations, models
from django.db.models import F


def update_enrolled_devices(apps, schema_editor):
    EnrolledDevice = apps.get_model("mdm", "EnrolledDevice")
    EnrolledDevice.objects.update(
        last_notified_at=F("created_at"),
        last_seen_at=F("updated_at"),
    )


def update_enrolled_users(apps, schema_editor):
    EnrolledUser = apps.get_model("mdm", "EnrolledUser")
    EnrolledUser.objects.update(
        last_notified_at=F("created_at"),
        last_seen_at=F("updated_at"),
    )


class Migration(migrations.Migration):

    dependencies = [
        ('mdm', '0052_auto_20220908_1608'),
    ]

    operations = [
        migrations.AddField(
            model_name='enrolleddevice',
            name='last_notified_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='enrolleddevice',
            name='last_seen_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='enrolleddevice',
            name='notification_queued_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.RunPython(update_enrolled_devices),
        migrations.AddField(
            model_name='enrolleduser',
            name='last_notified_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='enrolleduser',
            name='last_seen_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.AddField(
            model_name='enrolleduser',
            name='notification_queued_at',
            field=models.DateTimeField(null=True),
        ),
        migrations.RunPython(update_enrolled_users),
    ]
