# Generated by Django 3.2.14 on 2022-07-29 16:28

import base64
from django.db import migrations, models
import django.db.models.deletion
from zentral.conf import settings


def get_or_create_legacy_scep_config(apps):
    SCEPConfig = apps.get_model("mdm", "SCEPConfig")
    name = "Legacy Zentral MDM"
    try:
        return SCEPConfig.objects.get(name=name)
    except Exception:
        pass
    scep_config = SCEPConfig(
        name=name,
        url=settings["api"]["tls_hostname"] + "/scep",
        key_usage=5,
        key_is_extractable=False,
        keysize=2048,
        allow_all_apps_access=False,
        challenge_type="STATIC",
        challenge_kwargs={"challenge": base64.b64encode("/mdm/verify_scep_csr/".encode("utf-8")).decode("ascii")}
    )
    scep_config.save()
    return scep_config


def add_legacy_scep_config(apps, schema_editor):
    DEPEnrollment = apps.get_model("mdm", "DEPEnrollment")
    for dep_enrollment in DEPEnrollment.objects.all():
        dep_enrollment.scep_config = get_or_create_legacy_scep_config(apps)
        dep_enrollment.save()
    OTAEnrollment = apps.get_model("mdm", "OTAEnrollment")
    for ota_enrollment in OTAEnrollment.objects.all():
        ota_enrollment.scep_config = get_or_create_legacy_scep_config(apps)
        ota_enrollment.save()
    UserEnrollment = apps.get_model("mdm", "UserEnrollment")
    for user_enrollment in UserEnrollment.objects.all():
        user_enrollment.scep_config = get_or_create_legacy_scep_config(apps)
        user_enrollment.save()


class Migration(migrations.Migration):

    dependencies = [
        ('mdm', '0048_auto_20220329_0649'),
    ]

    operations = [
        migrations.AddField(
            model_name='depenrollment',
            name='scep_config',
            field=models.ForeignKey(blank=True, null=True,
                                    on_delete=django.db.models.deletion.PROTECT, to='mdm.scepconfig'),
        ),
        migrations.AddField(
            model_name='otaenrollment',
            name='scep_config',
            field=models.ForeignKey(blank=True, null=True,
                                    on_delete=django.db.models.deletion.PROTECT, to='mdm.scepconfig'),
        ),
        migrations.AddField(
            model_name='userenrollment',
            name='scep_config',
            field=models.ForeignKey(blank=True, null=True,
                                    on_delete=django.db.models.deletion.PROTECT, to='mdm.scepconfig'),
        ),
        # It used to be OK to have no Push certificate. It was a mistake.
        # If this migration fails because of this step, please set the push certificate manually.
        migrations.AlterField(
            model_name='depenrollment',
            name='push_certificate',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='mdm.pushcertificate'),
        ),
        migrations.RunPython(add_legacy_scep_config),
        migrations.AlterField(
            model_name='depenrollment',
            name='scep_config',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='mdm.scepconfig'),
        ),
        migrations.AlterField(
            model_name='otaenrollment',
            name='scep_config',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='mdm.scepconfig'),
        ),
        migrations.AlterField(
            model_name='userenrollment',
            name='scep_config',
            field=models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='mdm.scepconfig'),
        ),
    ]
