# Generated by Django 2.2.10 on 2020-03-05 19:26

from django.db import migrations
from django.urls import reverse
from zentral.conf import settings
from zentral.contrib.mdm.payloads import build_payload, build_profile, get_payload_identifier


def create_device_command(apps, schema_editor):
    DeviceCommand = apps.get_model("mdm", "DeviceCommand")
    DeviceArtifactCommand = apps.get_model("mdm", "DeviceArtifactCommand")
    for dac in DeviceArtifactCommand.objects.all():
        dc = DeviceCommand(enrolled_device=dac.enrolled_device,
                           uuid=dac.command_uuid,
                           time=dac.command_time,
                           result_time=dac.result_time,
                           status_code=dac.status_code,
                           # defaults
                           request_type="Unknown",
                           dictionary={})
        # reconstruct the command
        if dac.action == "REMOVE":
            dc.request_type = "RemoveProfile"
            artifact_suffix = dac.artifact.get_configuration_profile_payload_identifier_suffix()
            identifier = get_payload_identifier(artifact_suffix)
            dc.dictionary = {"Identifier": identifier}
        elif dac.action == "INSTALL":
            artifact_type = dac.artifact_type
            if artifact_type == "ConfigurationProfile":
                dc.request_type = "InstallProfile"
                artifact_suffix = dac.artifact.get_configuration_profile_payload_identifier_suffix()
                payloads = []
                for idx, (payload_type, payload_name, payload_content) in enumerate(dac.artifact.get_payloads()):
                    payloads.append(build_payload(payload_type, payload_name,
                                                  "{}.{}".format(artifact_suffix, idx + 1), payload_content,
                                                  payload_version=dac.artifact.version))
                command_payload = build_profile(str(dac.artifact), artifact_suffix, payloads)
                dc.dictionary = {"Payload": command_payload}
            elif artifact_type == "Application":
                dc.request_type = "InstallApplication"
                manifest_url = "{}{}".format(settings["api"]["tls_hostname"],
                                             reverse("mdm:install_application_manifest", args=(str(dc.uuid),)))
                dc.dictionary = {"ManifestURL": manifest_url, "ManagementFlags": 1}
        dc.save()
        dac.command = dc
        dac.save()


class Migration(migrations.Migration):

    dependencies = [
        ('mdm', '0029_auto_20200305_1925'),
    ]

    operations = [
        migrations.RunPython(create_device_command)
    ]
