# Generated by Django 2.2.24 on 2021-10-08 10:59

from django.db import migrations, models
from zentral.core.secret_engines import encrypt_str


def encrypt_passwords(apps, schema_editor):
    JamfInstance = apps.get_model("jamf", "JamfInstance")
    for jamf_instance in JamfInstance.objects.all():
        jamf_instance.password = encrypt_str(
            jamf_instance.password,
            field="password",
            model="jamf.jamfinstance",
            pk=jamf_instance.pk
        )
        jamf_instance.save()


class Migration(migrations.Migration):

    dependencies = [
        ('jamf', '0003_jamfinstance_inventory_apps_shard'),
    ]

    operations = [
        migrations.AlterField(
            model_name='jamfinstance',
            name='password',
            field=models.TextField(editable=False, help_text='API user password'),
        ),
        migrations.RunPython(encrypt_passwords),
    ]
