# -*- coding: utf-8 -*-
# Generated by Django 1.10.4 on 2017-01-25 17:36
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models
import django.db.models.deletion
import zentral.contrib.jamf.models


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('inventory', '0020_machinesnapshotcommit_last_seen'),
    ]

    operations = [
        migrations.CreateModel(
            name='JamfInstance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('version', models.PositiveIntegerField(editable=False)),
                ('host', models.CharField(help_text='host name of the server', max_length=256)),
                ('port', models.IntegerField(default=8443, help_text='server port number',
                                             validators=[django.core.validators.MinValueValidator(1),
                                                         django.core.validators.MaxValueValidator(65535)])),
                ('path', models.CharField(default='/JSSResource', help_text='path of the server API', max_length=64)),
                ('user', models.CharField(help_text='API user name', max_length=64)),
                ('password', models.CharField(help_text='API user password', max_length=256)),
                ('secret', models.CharField(default=zentral.contrib.jamf.models.make_secret,
                                            editable=False, max_length=256, unique=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('business_unit', models.ForeignKey(blank=True, null=True,
                                                    on_delete=django.db.models.deletion.PROTECT,
                                                    to='inventory.BusinessUnit')),
            ],
        ),
        migrations.AlterUniqueTogether(
            name='jamfinstance',
            unique_together=set([('host', 'port', 'path')]),
        ),
    ]
