# Generated by Django 3.2.12 on 2022-04-27 05:27

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0068_auto_20220329_0641'),
    ]

    operations = [
        migrations.CreateModel(
            name='EC2InstanceMetadata',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('instance_id', models.TextField()),
                ('instance_type', models.TextField()),
                ('architecture', models.TextField()),
                ('region', models.TextField()),
                ('availability_zone', models.TextField()),
                ('local_hostname', models.TextField()),
                ('local_ipv4', models.GenericIPAddressField(blank=True, null=True, protocol='IPv4')),
                ('mac', models.CharField(max_length=23)),
                ('security_groups', models.TextField(blank=True, null=True)),
                ('iam_arn', models.TextField(blank=True, null=True)),
                ('ami_id', models.TextField()),
                ('reservation_id', models.TextField()),
                ('account_id', models.TextField()),
                ('ssh_public_key', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='EC2InstanceTag',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('key', models.TextField()),
                ('value', models.TextField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterField(
            model_name='machinesnapshot',
            name='type',
            field=models.CharField(blank=True, choices=[
                ('DESKTOP', 'Desktop'), ('EC2', 'EC2 instance'), ('LAPTOP', 'Laptop'), ('MOBILE', 'Mobile'),
                ('SERVER', 'Server'), ('TABLET', 'Tablet'), ('TV', 'TV'), ('VM', 'Virtual machine')
            ], max_length=32, null=True),
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='ec2_instance_metadata',
            field=models.ForeignKey(blank=True, null=True,
                                    on_delete=django.db.models.deletion.PROTECT, to='inventory.ec2instancemetadata'),
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='ec2_instance_tags',
            field=models.ManyToManyField(to='inventory.EC2InstanceTag'),
        ),
    ]
