# Generated by Django 2.2.27 on 2022-02-21 08:43

import django.contrib.postgres.fields
from django.db import migrations, models


def add_default_platforms(apps, schema_editor):
    JMESPathCheck = apps.get_model("inventory", "JMESPathCheck")
    for check in JMESPathCheck.objects.all():
        check.platforms = ["LINUX", "MACOS", "WINDOWS", "ANDROID", "IOS", "IPADOS", "TVOS"]
        check.save()


class Migration(migrations.Migration):
    dependencies = [
        ('inventory', '0065_auto_20220216_0615'),
    ]

    operations = [
        migrations.AddField(
            model_name='jmespathcheck',
            name='platforms',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(choices=[('LINUX', 'Linux'),
                                                     ('MACOS', 'macOS'),
                                                     ('WINDOWS', 'Windows'),
                                                     ('ANDROID', 'Android'),
                                                     ('IOS', 'iOS'),
                                                     ('IPADOS', 'iPadOS'),
                                                     ('TVOS', 'tvOS')], max_length=32),
                blank=True, default=list, help_text='Restrict this check to some platforms', size=None),
        ),
        migrations.RunPython(add_default_platforms)
    ]
