# Generated by Django 2.2.24 on 2022-01-29 08:05

from django.db import migrations, models, connection


def set_last_seen(apps, schema_editor):
    query1 = (
        "with locked_rows as ("
        "  select * from inventory_machinesnapshotcommit for update"
        "), calculated_last_seen as ("
        "  select machine_snapshot_id, max(last_seen) as max_last_seen"
        "  from inventory_machinesnapshotcommit"
        "  group by machine_snapshot_id"
        ") "
        "update inventory_currentmachinesnapshot cms "
        "set last_seen = cls.max_last_seen "
        "from calculated_last_seen cls "
        "where cms.machine_snapshot_id = cls.machine_snapshot_id"
    )
    # should not be necessary, only there so that the not null constraint applies
    query2 = (
        "delete from inventory_currentmachinesnapshot where last_seen is null;"
    )
    with connection.cursor() as cursor:
        cursor.execute(query1)
        cursor.execute(query2)


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0062_machinesnapshot_extra_facts'),
    ]

    operations = [
        migrations.AddField(
            model_name='currentmachinesnapshot',
            name='last_seen',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.RunPython(set_last_seen),
        migrations.AlterField(
            model_name='currentmachinesnapshot',
            name='last_seen',
            field=models.DateTimeField(),
        )
    ]
