# Generated by Django 2.2.17 on 2021-01-21 11:40

from django.db import migrations, models
import django.db.models.deletion
from zentral.contrib.inventory.models import File


def copy_santa_collected_apps(apps, schema_editor):
    try:
        from zentral.contrib.santa.models import CollectedApplication
    except Exception:
        return
    else:
        source = {"module": "zentral.contrib.santa",
                  "name": "Santa events"}
        for ca in CollectedApplication.objects.all():
            serialized_ca = ca.serialize()
            serialized_ca["source"] = source.copy()
            File.objects.commit(serialized_ca)


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0051_auto_20201202_1025'),
    ]

    operations = [
        migrations.CreateModel(
            name='File',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('name', models.TextField()),
                ('path', models.TextField()),
                ('sha_256', models.CharField(db_index=True, max_length=64)),
                ('bundle_path', models.TextField(blank=True, null=True)),
                ('bundle', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='inventory.OSXApp')),
                ('signed_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='inventory.Certificate')),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inventory.Source')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AlterField(
            model_name='principalusersource',
            name='type',
            field=models.CharField(choices=[('COMPANY_PORTAL', 'Company portal'), ('GOOGLE_CHROME', 'Google Chrome'), ('LOGGED_IN_USER', 'Logged-in user'), ('SANTA_MACHINE_OWNER', 'Santa machine owner')], max_length=64),
        ),
        migrations.RunPython(copy_santa_collected_apps),
    ]
