# Generated by Django 2.2.3 on 2019-09-30 12:44

from django.db import migrations, transaction, IntegrityError
from zentral.contrib.inventory.models import MachineSnapshot


def remove_azure_ad_info(apps, schema_editor):
    MachineSnapshotMigrationModel = apps.get_model("inventory", "MachineSnapshot")
    for msmm in MachineSnapshotMigrationModel.objects.select_for_update().filter(azure_ad_info__isnull=False):
        try:
            with transaction.atomic():
                print("UPDATE", msmm.pk)
                msmm.azure_ad_info = None
                msmm.save()
                # rehash
                ms = MachineSnapshot.objects.get(pk=msmm.pk)
                ms.mt_hash = ms.hash(recursive=False)
                ms.save()
        except IntegrityError:
            # there is a similar ms now
            msmm.delete()


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0046_auto_20190930_1206'),
    ]

    operations = [
        migrations.RunPython(remove_azure_ad_info),
    ]
