# Generated by Django 2.2.3 on 2019-09-30 12:06

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0045_auto_20190426_1611'),
    ]

    operations = [
        migrations.CreateModel(
            name='PrincipalUserSource',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('type', models.CharField(choices=[('COMPANY_PORTAL', 'Company portal')], max_length=64)),
                ('properties', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='certificate',
            name='domain',
            field=models.TextField(blank=True, null=True),
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='certificates',
            field=models.ManyToManyField(to='inventory.Certificate'),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='sha_256',
            field=models.CharField(blank=True, db_index=True, max_length=64, null=True),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='valid_from',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='certificate',
            name='valid_until',
            field=models.DateTimeField(blank=True, null=True),
        ),
        migrations.AlterField(
            model_name='machinesnapshot',
            name='platform',
            field=models.CharField(blank=True, choices=[('LINUX', 'Linux'), ('MACOS', 'macOS'), ('WINDOWS', 'Windows'), ('ANDROID', 'Android'), ('IOS', 'iOS'), ('IPADOS', 'iPadOS'), ('TVOS', 'tvOS')], max_length=32, null=True),
        ),
        migrations.AlterField(
            model_name='machinesnapshot',
            name='type',
            field=models.CharField(blank=True, choices=[('DESKTOP', 'Desktop'), ('LAPTOP', 'Laptop'), ('MOBILE', 'Mobile'), ('SERVER', 'Server'), ('TABLET', 'Tablet'), ('TV', 'TV'), ('VM', 'Virtual machine')], max_length=32, null=True),
        ),
        migrations.CreateModel(
            name='PrincipalUser',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('unique_id', models.TextField(db_index=True)),
                ('principal_name', models.TextField(db_index=True)),
                ('display_name', models.TextField(blank=True, null=True)),
                ('source', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT, to='inventory.PrincipalUserSource')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='principal_user',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.PROTECT, to='inventory.PrincipalUser'),
        ),
    ]
