# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-10-25 11:00
from __future__ import unicode_literals

import django.core.validators
from django.db import migrations, models


def update_request_count(apps, schema_editor):
    EnrollmentSecret = apps.get_model("inventory", "EnrollmentSecret")
    for er in EnrollmentSecret.objects.all():
        er.request_count = er.enrollmentsecretrequest_set.count()
        er.save()


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0029_auto_20171016_1602'),
    ]

    operations = [
        migrations.AddField(
            model_name='enrollmentsecret',
            name='request_count',
            field=models.IntegerField(default=0, validators=[django.core.validators.MinValueValidator(0)]),
        ),
        migrations.RunPython(update_request_count)
    ]
