# -*- coding: utf-8 -*-
# Generated by Django 1.10.8 on 2017-10-15 18:58
from __future__ import unicode_literals

import django.contrib.postgres.fields
import django.contrib.postgres.fields.jsonb
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0026_auto_20171001_1047'),
    ]

    operations = [
        migrations.CreateModel(
            name='EnrollmentSecret',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('secret', models.CharField(max_length=256, unique=True)),
                ('module', models.CharField(db_index=True, max_length=256)),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('serial_numbers', django.contrib.postgres.fields.ArrayField(base_field=models.TextField(), size=None)),
                ('udids', django.contrib.postgres.fields.ArrayField(base_field=models.TextField(), size=None)),
                ('quota', models.IntegerField(blank=True, null=True, validators=[django.core.validators.MinValueValidator(1), django.core.validators.MaxValueValidator(200000)])),
                ('revoked_at', models.DateTimeField(blank=True, null=True)),
                ('expired_at', models.DateTimeField(blank=True, null=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('meta_business_unit', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.MetaBusinessUnit')),
                ('tags', models.ManyToManyField(to='inventory.Tag')),
            ],
        ),
        migrations.CreateModel(
            name='EnrollmentSecretRequest',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('public_ip_address', models.GenericIPAddressField()),
                ('user_agent', models.TextField()),
                ('udid', models.TextField(blank=True)),
                ('serial_number', models.TextField(blank=True)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('enrollment_secret', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.EnrollmentSecret')),
            ],
        ),
    ]
