# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-06-08 18:10
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0023_puppetdb'),
    ]

    operations = [
        migrations.CreateModel(
            name='PuppetCoreFacts',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('aio_agent_version', models.TextField(blank=True, null=True)),
                ('augeas_version', models.TextField(blank=True, null=True)),
                ('client_version', models.TextField(blank=True, null=True)),
                ('facter_version', models.TextField(blank=True, null=True)),
                ('ruby_sitedir', models.TextField(blank=True, null=True)),
                ('ruby_version', models.TextField(blank=True, null=True)),
                ('ruby_platform', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PuppetNode',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('environment', models.TextField()),
                ('extra_facts', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('core_facts', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.PuppetCoreFacts')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PuppetTrustedFacts',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('authenticated', models.CharField(choices=[('remote', 'remote'), ('local', 'local'), ('false', 'false')], max_length=16)),
                ('extensions', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
                ('certname', models.TextField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.RemoveField(
            model_name='puppetdbinventory',
            name='extensions',
        ),
        migrations.RemoveField(
            model_name='puppetdbinventory',
            name='facts',
        ),
        migrations.RemoveField(
            model_name='machinesnapshot',
            name='puppetdb_inventory',
        ),
        migrations.DeleteModel(
            name='PuppetCertificateExtension',
        ),
        migrations.DeleteModel(
            name='PuppetDBInventory',
        ),
        migrations.DeleteModel(
            name='PuppetFact',
        ),
        migrations.AddField(
            model_name='puppetnode',
            name='trusted_facts',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.PuppetTrustedFacts'),
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='puppet_node',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.PuppetNode'),
        ),
    ]
