# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-05-15 13:16
from __future__ import unicode_literals

from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    dependencies = [
        ('inventory', '0022_auto_20170530_0724'),
    ]

    operations = [
        migrations.CreateModel(
            name='PuppetCertificateExtension',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('extension_key', models.TextField()),
                ('extension_value', models.TextField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PuppetDBInventory',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('certname_trusted', models.TextField()),
                ('authenticated', models.TextField()),
                ('aio_agent_version', models.TextField(blank=True, null=True)),
                ('environment', models.TextField(blank=True, null=True)),
                ('timestamp', models.DateTimeField()),
                ('agent_specified_environment', models.TextField(blank=True, null=True)),
                ('clientversion', models.TextField(blank=True, null=True)),
                ('extensions', models.ManyToManyField(to='inventory.PuppetCertificateExtension')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='PuppetFact',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(max_length=40, unique=True)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('fact_key', models.TextField()),
                ('fact_key_display_name', models.TextField()),
                ('fact_value', models.TextField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='puppetdbinventory',
            name='facts',
            field=models.ManyToManyField(to='inventory.PuppetFact'),
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='puppetdb_inventory',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.PuppetDBInventory'),
        ),
    ]
