# -*- coding: utf-8 -*-
# Generated by Django 1.9.2 on 2016-02-06 21:01
from __future__ import unicode_literals

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
    ]

    operations = [
        migrations.CreateModel(
            name='BusinessUnit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('reference', models.TextField()),
                ('key', models.CharField(db_index=True, max_length=40)),
                ('name', models.TextField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Certificate',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('common_name', models.TextField()),
                ('organization', models.TextField(blank=True, null=True)),
                ('organizational_unit', models.TextField(blank=True, null=True)),
                ('sha_1', models.CharField(max_length=40)),
                ('sha_256', models.CharField(db_index=True, max_length=64)),
                ('valid_from', models.DateTimeField()),
                ('valid_until', models.DateTimeField()),
                ('signed_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.Certificate')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Link',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('anchor_text', models.TextField()),
                ('url', models.URLField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Machine',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('serial_number', models.TextField(unique=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MachineGroup',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('reference', models.TextField()),
                ('key', models.CharField(db_index=True, max_length=40)),
                ('name', models.TextField()),
                ('links', models.ManyToManyField(to='inventory.Link')),
                ('machine_links', models.ManyToManyField(related_name='+', to='inventory.link')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MachineSnapshot',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('reference', models.TextField(blank=True, null=True)),
                ('business_unit', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.BusinessUnit')),
                ('groups', models.ManyToManyField(to='inventory.MachineGroup')),
                ('links', models.ManyToManyField(to='inventory.Link')),
                ('machine', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.Machine')),
                ('mt_next', models.OneToOneField(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, related_name='mt_previous', to='inventory.MachineSnapshot')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='MetaBusinessUnit',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('name', models.TextField()),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
            ],
            options={
                'ordering': ('name',),
            },
        ),
        migrations.CreateModel(
            name='OSVersion',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('name', models.TextField(blank=True, null=True)),
                ('major', models.PositiveIntegerField()),
                ('minor', models.PositiveIntegerField()),
                ('patch', models.PositiveIntegerField(blank=True, null=True)),
                ('build', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OSXApp',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('bundle_id', models.TextField(blank=True, db_index=True, null=True)),
                ('bundle_name', models.TextField(blank=True, db_index=True, null=True)),
                ('bundle_version', models.TextField(blank=True, null=True)),
                ('bundle_version_str', models.TextField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='OSXAppInstance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('bundle_path', models.TextField(blank=True, null=True)),
                ('path', models.TextField(blank=True, null=True)),
                ('sha_1', models.CharField(blank=True, max_length=40, null=True)),
                ('sha_256', models.CharField(blank=True, db_index=True, max_length=64, null=True)),
                ('type', models.TextField(blank=True, null=True)),
                ('app', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.OSXApp')),
                ('signed_by', models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.Certificate')),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='Source',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('module', models.TextField()),
                ('name', models.TextField()),
                ('config', django.contrib.postgres.fields.jsonb.JSONField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='SystemInfo',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('computer_name', models.TextField(blank=True, null=True)),
                ('hostname', models.TextField(blank=True, null=True)),
                ('hardware_model', models.TextField(blank=True, null=True)),
                ('hardware_serial', models.TextField(blank=True, null=True)),
                ('cpu_type', models.TextField(blank=True, null=True)),
                ('cpu_subtype', models.TextField(blank=True, null=True)),
                ('cpu_brand', models.TextField(blank=True, null=True)),
                ('cpu_physical_cores', models.PositiveIntegerField(blank=True, null=True)),
                ('cpu_logical_cores', models.PositiveIntegerField(blank=True, null=True)),
                ('physical_memory', models.BigIntegerField(blank=True, null=True)),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.CreateModel(
            name='TeamViewer',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('mt_hash', models.CharField(db_index=True, max_length=40)),
                ('mt_created_at', models.DateTimeField(auto_now_add=True)),
                ('teamviewer_id', models.TextField()),
                ('release', models.TextField(blank=True, null=True)),
                ('unattended', models.NullBooleanField()),
            ],
            options={
                'abstract': False,
            },
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='os_version',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.OSVersion'),
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='osx_app_instances',
            field=models.ManyToManyField(to='inventory.OSXAppInstance'),
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='source',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.Source'),
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='system_info',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.SystemInfo'),
        ),
        migrations.AddField(
            model_name='machinesnapshot',
            name='teamviewer',
            field=models.ForeignKey(blank=True, null=True, on_delete=django.db.models.deletion.CASCADE, to='inventory.TeamViewer'),
        ),
        migrations.AddField(
            model_name='machinegroup',
            name='source',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.Source'),
        ),
        migrations.AddField(
            model_name='businessunit',
            name='links',
            field=models.ManyToManyField(to='inventory.Link'),
        ),
        migrations.AddField(
            model_name='businessunit',
            name='meta_business_unit',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.MetaBusinessUnit'),
        ),
        migrations.AddField(
            model_name='businessunit',
            name='source',
            field=models.ForeignKey(on_delete=django.db.models.deletion.CASCADE, to='inventory.Source'),
        ),
    ]
