# Generated by Django 4.2.16 on 2024-09-10 10:32

from django.db import migrations, models
import django.db.models.deletion
import uuid


def migrate_realm_group_mappings(apps, schema_editor):
    RealmGroup = apps.get_model("realms", "RealmGroup")
    RealmGroupMapping = apps.get_model("realms", "RealmGroupMapping")
    RoleMapping = apps.get_model("realms", "RoleMapping")
    for rgm in RealmGroupMapping.objects.all():
        group = rgm.group
        realm_group, _ = RealmGroup.objects.get_or_create(realm=rgm.realm, display_name=group.name)
        rgm.realm_group = realm_group
        rgm.save()
        RoleMapping.objects.get_or_create(realm_group=realm_group, group=group)


class Migration(migrations.Migration):

    dependencies = [
        ('auth', '0012_alter_user_first_name_max_length'),
        ('realms', '0011_realm_user_portal_alter_realm_enabled_for_login'),
    ]

    operations = [
        migrations.AddField(
            model_name='realmgroupmapping',
            name='realm_group',
            field=models.ForeignKey(null=True, on_delete=django.db.models.deletion.CASCADE,
                                    to='realms.realmgroup', verbose_name='Group'),
        ),
        migrations.CreateModel(
            name='RoleMapping',
            fields=[
                ('uuid', models.UUIDField(default=uuid.uuid4, editable=False, primary_key=True, serialize=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                            to='auth.group', verbose_name='Role')),
                ('realm_group', models.ForeignKey(on_delete=django.db.models.deletion.CASCADE,
                                                  to='realms.realmgroup', verbose_name='Group')),
            ],
            options={
                'unique_together': {('realm_group', 'group')},
            },
        ),
        migrations.RunPython(migrate_realm_group_mappings),
        migrations.AlterUniqueTogether(
            name='realmgroupmapping',
            unique_together={('claim', 'value', 'realm_group')},
        ),
        migrations.RemoveField(
            model_name='realmgroupmapping',
            name='group',
        ),
        migrations.RemoveField(
            model_name='realmgroupmapping',
            name='realm',
        ),
    ]
