# Generated by Django 2.2.24 on 2022-01-26 07:38

import django.contrib.postgres.fields.jsonb
from django.db import migrations, models
from zentral.conf import settings
from zentral.utils.base64 import trimmed_urlsafe_b64decode


def update_user_webauthn(apps, schema_editor):
    UserWebAuthn = apps.get_model("accounts", "UserWebAuthn")
    for d in UserWebAuthn.objects.all():
        device = d.device
        d.key_handle = device["keyHandle"].rstrip("=")
        d.public_key = trimmed_urlsafe_b64decode(device["publicKey"])
        d.transports = device.get("transports", [])
        d.rp_id = device.get("appId", settings["api"]["fqdn"])
        d.save()


class Migration(migrations.Migration):

    dependencies = [
        ('accounts', '0013_auto_20210128_2317'),
    ]

    operations = [
        migrations.RenameModel(
            old_name='UserU2F',
            new_name='UserWebAuthn',
        ),
        migrations.AddField(
            model_name='userwebauthn',
            name='key_handle',
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name='userwebauthn',
            name='public_key',
            field=models.BinaryField(null=True),
        ),
        migrations.AddField(
            model_name='userwebauthn',
            name='rp_id',
            field=models.TextField(null=True),
        ),
        migrations.AddField(
            model_name='userwebauthn',
            name='sign_count',
            field=models.PositiveIntegerField(default=0),
        ),
        migrations.AddField(
            model_name='userwebauthn',
            name='transports',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(
                    choices=[('usb', 'usb'), ('nfc', 'nfc'), ('ble', 'ble'), ('internal', 'internal')],
                    max_length=8),
                default=list,
                size=None
            ),
        ),
        migrations.RunPython(update_user_webauthn),
        migrations.AlterField(
            model_name='userwebauthn',
            name='key_handle',
            field=models.TextField(),
        ),
        migrations.AlterField(
            model_name='userwebauthn',
            name='public_key',
            field=models.BinaryField(),
        ),
        migrations.AlterField(
            model_name='userwebauthn',
            name='rp_id',
            field=models.TextField(),
        ),
        migrations.AlterField(
            model_name='userwebauthn',
            name='sign_count',
            field=models.PositiveIntegerField(),
        ),
        migrations.AlterField(
            model_name='userwebauthn',
            name='transports',
            field=django.contrib.postgres.fields.ArrayField(
                base_field=models.CharField(
                    choices=[('usb', 'usb'), ('nfc', 'nfc'), ('ble', 'ble'), ('internal', 'internal')],
                    max_length=8
                ),
                size=None
            ),
        ),
        migrations.AlterUniqueTogether(
            name='userwebauthn',
            unique_together={('user', 'key_handle'), ('user', 'name')},
        ),
        migrations.RemoveField(
            model_name='userwebauthn',
            name='device',
        ),
    ]
