# -*- coding: utf-8 -*-
# Generated by Django 1.10.7 on 2017-09-27 11:44
from __future__ import unicode_literals

from django.contrib.auth.hashers import is_password_usable
from django.db import migrations


def set_password_updated_at(apps, schema_editor):
    User = apps.get_model("accounts", "User")
    for u in User.objects.all():
        if is_password_usable(u.password):
            u.password_updated_at = u.date_joined
            u.save()


class Migration(migrations.Migration):

    dependencies = [
        ('accounts', '0005_auto_20170927_1140'),
    ]

    operations = [
        migrations.RunPython(set_password_updated_at),
    ]
