# Generated by Django 2.2.27 on 2022-02-07 14:35

import django.contrib.postgres.fields
import django.core.validators
from django.db import migrations, models
import django.db.models.deletion


class Migration(migrations.Migration):

    initial = True

    dependencies = [
        ('inventory', '0062_machinesnapshot_extra_facts'),
    ]

    operations = [
        migrations.CreateModel(
            name='Instance',
            fields=[
                ('id', models.AutoField(auto_created=True, primary_key=True, serialize=False, verbose_name='ID')),
                ('server_url', models.URLField(unique=True)),
                ('api_key', models.TextField()),
                ('client_id', models.TextField(help_text='OAuth 2.0 client ID')),
                ('client_secret', models.TextField(help_text='OAuth 2.0 client secret')),
                ('token_url', models.URLField()),
                ('username', models.TextField(help_text='Event notifications username')),
                ('password', models.TextField(help_text='Event notifications password')),
                ('excluded_groups', django.contrib.postgres.fields.ArrayField(
                    base_field=models.CharField(
                        max_length=256, validators=[django.core.validators.MinLengthValidator(1)]
                    ), blank=True, default=list,
                    help_text='Comma separated list of the names of the organization groups to exclude. '
                              'All children groups will be excluded as well.', size=None)),
                ('version', models.PositiveIntegerField(editable=False)),
                ('created_at', models.DateTimeField(auto_now_add=True)),
                ('updated_at', models.DateTimeField(auto_now=True)),
                ('business_unit', models.ForeignKey(on_delete=django.db.models.deletion.PROTECT,
                 to='inventory.BusinessUnit')),
            ],
        ),
    ]
