# API configuration section

Root key: `api`

In this [section](../#sections), we give Zentral information about its deployment: where it is running, which certificates and keys are used. We also define a secret to authenticate some API requests.

You need to define at least `api.fqdn`, `api.secret`, and set the server certificate fullchain using some of the `api.tls_*` keys.

## FQDNs

### `api.fqdn`

**MANDATORY**

The FQDN where the Zentral web app is served.

### `api.fqdn_mtls`

The FQDN where the Zentral web app is served, with mandatory mTLS authentication. Not mandatory.

## API secret

### `api.secret`

**MANDATORY**

A random string that **must be kept secret and unique for all deployments**. Used to verify some API requests. You could use the ouput of the following command for example:

```
base64 /dev/random | head -c100
```

## Certificates

Either `api.tls_cert` and `api.tls_chain` or `api.tls_fullchain`. `api.tls_privkey` only needed to sign the configuration profiles.

### `api.tls_cert`

The PEM encoded server certificate used to serve the Zentral web app.

### `api.tls_chain`

The concatenated list of PEM encoded intermediary certificates used to issue the server certificate. The last certificate in the chain must be trusted by the clients.

### `api.tls_fullchain`

An alternative to `api.tls_cert` and `api.tls_chain`. List of PEM encoded certificates, the first one being the server certificate, concatenated with the chain.

### `api.tls_privkey`

The PEM encoded server certificate private key. This is used to sign the configuration profiles generated by Zentral.

### `api.distribute_tls_server_certs`

A boolean. `false` by default. If set to `true`, Zentral will ship the server certificate chain in the enrollment packages or scripts. This can be used during development or testing, when working with self-signed certificates, or certificates not trusted by the clients. **WARNING** those certificates might expire, and the enrollment packages with the new certificates must be deployed every time those certificates are renewed. In production, it is better to not use this option, and distribute the root certificate via MDM, if it is not already trusted by the clients.

## Deprecated configuration keys

### `api.tls_hostname`

**DEPRECATED**

The base URL, with scheme, without `/` path, where the Zentral web app is mounted. Use [`api.fqdn`](#apifqdn) instead.

### `api.tls_hostname_for_client_cert_auth`

**DEPRECATED**

The base URL, with scheme, without `/` path, where the Zentral web app is mounted with required mTLS authentication. Use [`api.fqdn_mtls`](#apifqdn_mtls)  instead.

### `api.tls_server_certs`

**DEPRECATED**

Path to the file containing the full chain of certificates. Use [`api.tls_fullchain`](#apitls_fullchain) instead.

### `api.tls_server_key`

**DEPRECATED**

Path to the file containing the certificate private key. Use [`api.tls_privkey`](#apitls_privkey) instead.
