import React from "react";

import Layout from "../components/layout";
import SEO from "../components/seo";

import "./terms.css";

const IndexPage = () => (
  <Layout noHero>
    <SEO title="OSS by Zenika" keywords={["gatsby", "application", "react"]} />
    <article className="terms__body">
      <h2>
        <strong>Mentions Légales</strong>
      </h2>

      <p>Zenika SAS de conseil en systèmes et logiciels informatiques.</p>
      <p>10 rue de Milan 75009 Paris</p>
      <p>Capital de 130 000 euros</p>
      <p>RCS : Paris B 489 682 005</p>
      <p>
        Créé en 2006, Zenika est un cabinet d'innovation technologique,
        managériale et organisationnelle, qui accompagne les entreprises dans
        leur transformation numérique. Zenika fait le lien entre le monde
        organique et le monde numérique et se positionne comme un "One Stop
        Shop" pour ses clients.
      </p>
      <p>
        Depuis l'interface (Web, Mobile, Voix, Objet Connecté, RA/RV) jusqu'à la
        data et son usage, le tout en mode agile, Zenika regroupe des profils
        variés sur les domaines d'expertise suivants : Java, Big Data, Web,
        Mobilité, IoT, DevOps, Craftsmanship, Agilité, sécurité et
        transformation des organisations. Après les ouvertures successives des
        agences de Paris, Lyon, Rennes, Nantes, Lille, Bordeaux, Singapour et
        Montréal, le groupe souhaite renforcer son rayonnement national et
        international.
      </p>
      <p>Directeur de publication : Carl Azoury, CEO Zenika</p>
      <p>Hébergement : Netlify © 2019</p>
      <h2>
        <strong>Propriété Intellectuelle</strong>
      </h2>

      <p>
        La structure générale, les textes, images animées ou non, les
        savoir-faire, les programmes et logiciels ainsi que tout autre élément
        composant ce site sont la propriété exclusive de Zenika et sont protégés
        par le droit d’auteur. Toute représentation totale ou partielle de ce
        site, par quelque procédé que ce soit, sans l’autorisation expresse de
        Zenika est donc interdite et constituerait une contrefaçon. Il en est de
        même des bases de données figurant sur le site training.zenika.com qui
        sont protégées.
      </p>
      <p>
        Les marques, les noms commerciaux, les logos figurant sur ce site sont
        des marques déposées de Zenika sauf mention contraire. Toute
        reproduction totale ou partielle des marques ou logos, effectuée à
        partir des éléments du site et sans l’autorisation de Zenika est donc
        prohibée.
      </p>
      <h2>
        <strong>Conditions d’utilisation</strong>
      </h2>

      <p>
        Tout lien avec ce site doit faire l’objet d’une autorisation préalable
        écrite de Zenika et ne pourra être réalisé que vers l’adresse de la page
        d’accueil du site <a href="http://www.zenika.com/">www.zenika.com</a>{" "}
        avec l’intégration d’un logo.
      </p>
      <p>
        Malgré les soins apportés par Zenika, les informations contenues dans ce
        site sont données à titre indicatif et sont sujettes à changement sans
        préavis. En conséquence, l’utilisateur reconnaît utiliser ces
        informations sous sa responsabilité exclusive.
      </p>
      <p>
        Il accepte les présentes conditions d’utilisation. Tout litige portant
        sur l’interprétation ou l’exécution des présentes mentions sera de la
        compétence exclusive des tribunaux français faisant l’application de la
        loi française. L’ensemble des éléments de ce site est protégé par
        copyright Zenika.
      </p>
      <h2>
        <strong>Cookies</strong>
      </h2>

      <p>
        Ce site Web utilise des cookies. Les cookies nous permettent d'analyser
        notre trafic. Nous partageons également des informations sur
        l'utilisation de notre site avec nos partenaires d'analyse, qui peuvent
        combiner celles-ci avec d'autres informations que vous leur avez
        fournies ou qu'ils ont collectées lors de votre utilisation de leurs
        services. Vous consentez à nos cookies si vous continuez à utiliser
        notre site Web.
      </p>
      <p>
        Les cookies sont des petits fichiers textes qui peuvent être utilisés
        par les sites Web pour rendre l'expérience utilisateur plus efficace.
      </p>
      <p>
        La loi stipule que nous ne pouvons stocker des cookies sur votre
        appareil que s’ils sont strictement nécessaires au fonctionnement de ce
        site. Pour tous les autres types de cookies, nous avons besoin de votre
        permission.
      </p>
      <p>
        Ce site utilise différents types de cookies. Certains cookies sont
        placés par les services tiers qui apparaissent sur nos pages.
      </p>
      <p>
        À tout moment, vous pouvez modifier ou retirer votre consentement dès la
        Déclaration relative aux cookies sur notre site Web.
      </p>
      <p>
        En savoir plus sur qui nous sommes, comment vous pouvez nous contacter
        et comment nous traitons les données personnelles veuillez voir notre
        Politique confidentialité.
      </p>
      <p>Votre consentement s'applique au domaine suivant : oss.zenika.com</p>
      <p>Votre état actuel: Utiliser uniquement les cookies nécessaires .</p>
      <p>Modifiez votre consentement</p>
      <p>
        Déclaration relative aux cookies mise à jour le 26/06/2019 par{" "}
        <a href="https://www.cookiebot.com/">Cookiebot</a>:
      </p>
      <p>
        <strong>Optionnel (1)</strong>
      </p>
      <p>
        Les cookies nécessaires contribuent à rendre un site Web utilisable en
        activant des fonctions de base comme la navigation de page et l'accès
        aux zones sécurisées du site Web. Le site Web ne peut pas fonctionner
        correctement sans ces cookies.
      </p>

      <table>
        <tr>
          <td>
            <strong>Nom</strong>
          </td>
          <td>
            <strong>Fournisseur</strong>
          </td>
          <td>
            <strong>Finalité</strong>
          </td>
          <td>
            <strong>Expiration</strong>
          </td>
          <td>
            <strong>Type</strong>
          </td>
        </tr>
        <tr>
          <td>Google Analytics</td>
          <td>Google</td>
          <td>
            Enregistre un identifiant unique utilisé pour générer des données
            statistiques sur la façon dont l e visiteur utilise le site
          </td>
          <td>2 années</td>
          <td>HTTP Cookie</td>
        </tr>
        <tr>
          <td>CookieConsent</td>
          <td>oss.zenika.com</td>
          <td>
            Stocke l'autorisation d'utilisation de cookies pour le domaine
            actuel par l'utilisateur
          </td>
          <td>1 année</td>
          <td>HTTP Cookie</td>
        </tr>
      </table>

      <p>
        <strong>Transmission des données</strong>
      </p>
      <p>
        Lorsque vous nous fournissez vos données afin d’être recontacté par nos
        services, celles-ci sont traitées uniquement par le personnel interne et
        habilité de Zenika et ne font l’objet d’aucune transmission à des tiers
        extérieurs.
      </p>
      <p>
        <strong>Vos droits</strong>
      </p>
      <p>
        Vous disposez d’un droit d’accès aux données vous concernant ou pouvez
        demander leur effacement. Vous disposez également d’un droit
        d’opposition pour motif légitime, d’un droit de rectification, de
        portabilité et d’un droit à la limitation du traitement de vos données
        (cf. cnil.fr pour plus d’informations sur vos droits).
      </p>
      <p>
        Pour exercer ces droits ou pour toute question sur le traitement de vos
        données, vous pouvez contacter notre Délégué à la protection des données
        (DPO) :
      </p>
      <ul>
        <li>Par email : mydata@zenika.com</li>

        <li>Par voie postale : 10 rue de Milan 75009 Paris</li>
      </ul>
      <p>
        Lorsque vous exercez vos droits, vous devrez nous fournir une preuve de
        votre identité. A défaut nous ne serons pas en mesure de traiter votre
        demande et nous nous réservons le droit de ne pas faire droit à votre
        demande.
      </p>
      <p>
        Si vous estimez après nous avoir contactés que vos droits ne sont pas
        respectés, vous pourrez à tout moment saisir l’
        <a href="https://www.cnil.fr/">autorité de contrôle</a>.
      </p>
      <p>
        <strong>Sécurité</strong>
      </p>
      <p>
        Notre préoccupation est de préserver la qualité et l’intégrité de vos
        données personnelles. Les technologies ainsi que les politiques de
        sécurité appliquées par nous-mêmes et nos prestataires techniques
        permettent de protéger vos données contre tout accès non autorisé, toute
        altération, toute destruction malveillante ou accidentelle et toute
        perte involontaire de données. Nous améliorons sans cesse nos procédures
        de sécurité au fur et à mesure de l’évolution des technologies afin de
        maintenir un niveau de protection maximum. Notre personnel et celui de
        nos sous-traitants ayant accès aux données personnelles sont soumis
        contractuellement à une obligation de confidentialité.
      </p>
    </article>
  </Layout>
);

export default IndexPage;
