---
title: "Chapter 3: Open source promotion cheat sheet"
date: 2019-09-18T12:00:00.284Z
author: Franck Abgrall, Thomas Betous
path: "/white-paper/promotion/"
---

> This cheat sheet summarizes important steps you should follow to promote your open source project in the best conditions. You can click items to expand and get more information from a topic. 

List of available languages:

- [English](https://github.com/zenika-open-source/open-source-promotion-cheat-sheet/blob/master/README.md)
- [Français](https://github.com/zenika-open-source/open-source-promotion-cheat-sheet/blob/master/README-fr.md)
- [Deutsch](https://github.com/zenika-open-source/open-source-promotion-cheat-sheet/blob/master/README-de.md)

A language is missing? Want to improve this cheat sheet? [Contributions are welcome](https://github.com/zenika-open-source/open-source-promotion-cheat-sheet/blob/master/CONTRIBUTING.md)!


## 1. 🎢 Preparation step

<br />

<details>
<summary>👌 Make sure your project is mature enough</summary>
<p>

> Your project must be stable enough with minimum viables features in order to hook users.

</p>
</details>

<details>
<summary>😎 Choose a cool name for your project</summary>
<p>

> Choose a name users can easily remember.

</p>
</details>

<details>
<summary>💅 Make your README pretty</summary>
<p>

> README is the first thing your vistors will see. Make it simple, pretty and easy to read. [Here is a list of beautiful READMEs](https://github.com/matiassingers/awesome-readme).

</p>
</details>

<details>
<summary>💪 Highlight strong points of your project</summary>
<p>

> Identify your project strengths and make sure visitors see them first.

</p>
</details>

<details>
<summary>✨ Provide a demo of your project</summary>
<p>

> Visitors will want to quickly understand the purpose of your project, how it works and how to use it. Providing a demo is the best way to satisfy users. It could be:
>
>  - An animated GIF demonstrating how your project works
>  - A link to a live demo

</p>
</details>

<details>
<summary>👌 Install/Usage must be super easy</summary>
<p>

> You'll probably lose visitors if your project is not user-friendly.

</p>
</details>

<details>
<summary>📘 Create a clean and well structured documentation</summary>
<p>

> Creating a good documentation is probably the most important step. If you have a small documentation, you can include it within your README. Otherwise, you should probably host it in a separate website. Some open source projects like [vuepress](https://v1.vuepress.vuejs.org) can help you creating clean documentation in a simple way.

 </p>
</details>

<br />

## 2. 📢 Spread the word about your hard works

<br />

<details>
<summary>⭐ Make your project trustable before publishing it on social networks</summary>
<p>

> Most visitors will check how many stars the project has before considering using it. A minimum amount of stars makes your project more trustable than a project with zero star. This is why you should ask people you know to support your project before doing a public announcement on social media.

</p>
</details>

<details>
<summary>↗️ Share the project on social media and specialized platforms</summary>
<p>

> Tell the World about your awesome work! Publish on social media and specialized platforms:
>
> - [Twitter](https://twitter.com)
> - [Linkedin](https://www.linkedin.com/)
> - [Facebook](https://www.facebook.com/)
> - [Reddit](https://www.reddit.com/)
> - [Dev.to](https://dev.to/)
> - [Lobsters](https://lobste.rs/)
> - [Hacker News](https://news.ycombinator.com/)
> - [Product Hunt](https://www.producthunt.com/)
> - [Beta page](https://betapage.co/)
> - [Human Coders](https://news.humancoders.com/)

</p>
</details>

<details>
<summary>📃 Write articles that mention your project</summary>
<p>

> Write articles about your project. Purpose can be the technical stack you used, how your project works, problems you encountered, etc. Post to publishing platforms:
>
> - [medium](https://medium.com/)
> - [dev.to](https://dev.to/)
</p>
</details>

<details>
<summary>🎤 Present your project at conferences/meetups</summary>
<p>

> Presenting your project at conferences or meetups is a good way to improve its visibility.

</p>
</details>

<details>
<summary>🎥 Record and publish videos presenting your project, how it works, etc</summary>
<p>

> Recording a video is not an easy exercise. However it's probably the most efficient way to make your project famous.

</p>
</details>

<details>
<summary>🕐 Choose the best time to publish on social media</summary>
<p>

> Don't publish during holidays period or weekends. Usually the best time to publish on social networks is mid-week.

</p>
</details>

<details>
<summary>🗑 Don't spam platforms with your promotion</summary>
<p>

> Don't publish twice on the same platform. It will be considered as spam and might cause bad publicity for your project.

</p>
</details>

<br />

## 3. 🤝 Keep your users

<br />

<details>
<summary>🆕 Try to regularly release new versions of your project</summary>
<p>

> Maintain and improve your project with new releases and generate changelogs.

</p>
</details>

<details>
<summary>❗ Maintain your project, process opened issues</summary>
<p>

> Do not let opened issues without response. Be nice with people that took time to open issues. 😉

</p>
</details>

<details>
<summary>🙏 Invite users to contribute</summary>
<p>

> A healthy project is a project with a community and contributors. Let your users know that you need help by tagging some issues with `contribution welcome` or `good first issue` labels. [See github labels](https://help.github.com/en/articles/about-labels).

</p>
</details>

<details>
<summary>🏆 Reward contributors</summary>
<p>

> Be nice with people that helped you! Some open source projects like [gatsby](https://github.com/gatsbyjs/gatsby) reward contributors with goodies. If you can't afford that, do a public post (on twitter or other platforms) about the contribution and mention the author ([here is an example of public thanks](https://twitter.com/FranckAbgrall/status/1139470547492978688)). Open a `Contributors` section in your README to publicly thank them or showcase them on your project documentation or website. Here are some examples:
>
> - [vuepress (contributors README section)](https://github.com/vuejs/vuepress#code-contributors)
> - [Rythm.js (random highlighted contributor on demo page)](https://okazari.github.io/Rythm.js/)

</p>
</details>

<details>
<summary>💬 Open a community chat platform</summary>
<p>

> Github issues are not always the best way to communicate with your users. If necessary, you can use chat platforms to discuss with them:
>
> - [Discord](https://discordapp.com)
> - [Slack](https://slack.com)
> - [Gitter](https://gitter.im/)

</p>
</details>

<details>
<summary>🔙 Ask for feedback</summary>
<p>

> User feedback is the best way to improve your project. They probably have features and ideas that could make your project better.

</p>
</details>

<details>
<summary>❤️ Open a use case gallery to show what users built with your project</summary>
<p>

> Visitors will trust your project if they see concrete use cases and success stories, e.g., [the vuepress gallery](https://vuepress.gallery/)).

</p>
</details>

<br />
