---
title: "Chapter 1: Getting Started 🥚"
date: 2019-07-02T12:00:00.284Z
author: Benjamin Petetot
path: "/white-paper/getting-started/"
---

The world of open source is vast, it is very easy to get lost. When starting, this world can feel unaccessible and intimidating. Where to start? What are the rules and codes to follow? Can I contribute even if I do not code?
No worries, in this article we will give you all the tips you need to start well, choose the right project and submit your first contribution.


## First steps 🐣

First of all, you have to decide on which project you want to start your first contribution. Since there are millions of open source projects, it can be difficult to find one's way.

A first idea, which is perhaps the simplest, is **to identify projects that you like, that you often use or projects that mean a lot to you.** It will be easier to start in a familiar environment which will keep you motivated in the long term.

It is also important to take into account the maturity of the project and its size. It is tempting to start with large frameworks, libraries or tools like VS Code, MongoDB, Android, React…. These kind of projects have many contributors, many bugs to fix or features to add. Contributions on these projects bring some satisfaction when they are merged. But these projects, with millions of lines of code, are not the best choice to get started in open source. Their communities are already well developed and many people are offering contributions for a limited number of maintainers. It can take a while before your contribution is studied and potentially accepted.

**Starting on smaller projects with potential is a better way to get started.** Keep an eye out for growing projects, on the [GitHub trending](https://github.com/trending/javascript?since=monthly) for example,and find the ones that match your interests.

Another good way to identify a suitable project is to **select those which are actively looking for contributors.** Several websites and tools can help:

* [Awesome for beginners](https://github.com/MunGell/awesome-for-beginners) is a list of projects looking for contributors (beginners or not) by listing their *"Good First Issues"*. In the same way, the website [Up for grabs](https://up-for-grabs.net) makes it possible to find projects in need of contributors.

* [CodeTriage](https://www.codetriage.com/) is a tool for subscribing to open source projects and receiving new requests for contributions every day.

* [First contributions](https://firstcontributions.github.io/) is a little different, it is a workshop to make your first contribution in less than five minutes. It introduces the basis of the Git workflow to make contributions on GitHub. In addition to this tutorial, the website offers links to *"Good First Issues"* of large GitHub projects.

* Evenings or community events like [HacktoberFest](https://hacktoberfest.digitalocean.com/) are also a good way to get started on projects looking for contributors. For example, the [hack.commit.push](https://hack-commit-pu.sh/) organizes an open source development day, open to everyone, regardless of your level. At the beginning of the day, introductory workshops are presented, followed by open source contributions with mentors.

Once you have found your dream project(s), you will need to start reading up on these projects, The README is a good entry point for project overview. The Code of Conduct and the Contribution Guide are more focused on how to interact with the project and its community. It doesn’t take long, but it is mandatory before starting a contribution. It will give you the tips, rules and procedures you need to follow, allowing consistency and maintenance of the project.

**Code of conduct**

**Most open source projects have a code of conduct.** It allows maintainers to define rules and behaviors to adopt on their project.

The essential points of this code define the rules to be followed by the participants. Learn to respect different points of view, listen and accept feedback on your contributions. Potential disagreements are to be expected. Do not take them personally. Sometimes, during reviews, it is possible that individuals do not agree on some decisions or approaches taken. It is therefore very important to stay professional and respect the code of conduct. Any feedback is valuable and it is during these discussions that we learn the most.

**It is also very important to be patient.** Many open source projects are maintained on personal time. It may take some time before your contribution is reviewed or accepted.

Here is an example of a code of conduct used by many projects: [*Contributor convenant*](https://www.contributor-covenant.org/). The rules it defines should be applied in both open source and professional environment.

**The contribution guide**

It defines workflows and ways of coding on the project, it helps understanding the standards and expectations of the community. For example:
* How to set up my development environment?
* How to post an issue?
* What are the commit standards?
* What are the expectations on the tests?

If a contribution does not follow these recommended practices, it may be rejected before it has even been reviewed. These standards serve to maintain coherence in the project but also to save time for the project maintainers. So read it carefully.

**Join the community**

A project is not limited to documentation and source code. It is also important to understand and interact with the project community. There are different roles in an open source project, the three main ones are:
* The maintainers or core contributors, who are at the origin of the project or have been invited to this role thanks to all the contributions they have made.
* Contributors, who participate in the life of the project by offering contributions (documentation, bug fixes...), answering questions or opening user tickets.
* And users, who will of course use the project but mostly give feedback, post bugs, propose improvements or ask questions on forums.

The means of communication in the community vary based on the project. It can be a mailing list, a Slack, a Discord or any other tool of this kind. You will be able to ask questions, help defining roadmaps, or simply discussing amongst enthusiasts.


## First contribution 🐥

Now that you have identified a project that interests you and you have read the necessary documentation to get started, you are ready to offer your first contribution.

Above all, you do not need to know how to code to contribute to open source projects:
* Do you like to write? Correct or develop the project’s documentation.
* Do you master design? Create the logo or project website.
* Do you like to communicate? Answer questions from the community.

All contributions are good and help the project. Here is a non-exhaustive list of tasks you can do to help open source projects:

**Documenting**

* Write and correct the project’s documentation;
* Translate the documentation.

**Organizing**

* Submit bugs or new features;
* Answer issues, file them and close them if necessary;
* Answer questions (e.g. on GitHub, Stack Overflow...).

**Communicating**

* Write articles or tutorials;
* Organize meetups or conferences about the project;
* Communicate on Twitter (new releases, contributions...);
* Create a design for the project (logo, colors...);
* Develop a website for the project.

**Coding**

* Conduct code reviews;
* Develop tests;
* Automate the project (CI...);
* Fix bugs;
* Add new features.

If you do not know where to start, go through the list of open issues on the project. In many projects, some tickets are identified as *"Good First Issues"* or *"Beginner"*. They are identified by the main contributors as simple contributions and good entry points into the project. Also look out for *"Help needed/wanted"* categorized tickets waiting for a contributor to assign themselves.

When you have identified an issue or a ticket you wish to contribute to, you must position yourself on it. Do not hesitate to ask other contributors for information. Discussions and exchange are essential to properly start a new contribution. They will guide you towards the expectations of the community, validate a technical solution or identify potential constraints or difficulties.

Before you publish your first contribution, check your code and do not forget to test it before submitting. Do not hesitate to explain the context and document your contribution. Anything that will help other contributors and maintainers to review it will speed up its integration.

Finally, when you have made your first contribution, do not forget to communicate on it and share it with the world on Twitter, Facebook, or your favorite social network.
