"""Support for store types and related indexes

Revision ID: b7d862d599fe
Revises: 0bb7d192c063
Create Date: 2024-03-11 01:24:12.500330

"""

from typing import Sequence, Union
from datetime import datetime

from alembic import op
import sqlalchemy as sa


# revision identifiers, used by Alembic.
revision: str = "b7d862d599fe"
down_revision: Union[str, None] = "0bb7d192c063"
branch_labels: Union[str, Sequence[str], None] = None
depends_on: Union[str, Sequence[str], None] = None


def upgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    store_table = op.create_table(
        "store",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(length=100), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.PrimaryKeyConstraint("id"),
    )
    op.create_table(
        "index",
        sa.Column("id", sa.Integer(), autoincrement=True, nullable=False),
        sa.Column("name", sa.String(length=100), nullable=False),
        sa.Column("store_id", sa.Integer(), nullable=False),
        sa.Column("created_at", sa.DateTime(), nullable=True),
        sa.ForeignKeyConstraint(
            ["store_id"],
            ["store.id"],
        ),
        sa.PrimaryKeyConstraint("id"),
    )
    now = datetime.now()
    op.bulk_insert(store_table, [{"name": "chroma", "created_at": now}, {"name": "pinecone", "created_at": now}])

    with op.batch_alter_table("sources", schema=None) as batch_op:
        batch_op.add_column(sa.Column("index_id", sa.Integer(), nullable=False))
        batch_op.create_foreign_key("indexFK", "index", ["index_id"], ["id"])

    # ### end Alembic commands ###


def downgrade() -> None:
    # ### commands auto generated by Alembic - please adjust! ###
    with op.batch_alter_table("sources", schema=None) as batch_op:
        batch_op.drop_constraint("indexFK", type_="foreignkey")
        batch_op.drop_column("index_id")

    op.drop_table("index")
    op.drop_table("store")
    # ### end Alembic commands ###
