<script src="https://cdn.bootcss.com/jquery/3.0.0/jquery.min.js"></script>
<script type="text/javascript" src="https://assets.pyecharts.org/assets/echarts.min.js"></script>
<script type="text/javascript" src="https://assets.pyecharts.org/assets/maps/world.js"></script>
<script type="text/javascript" src="https://assets.pyecharts.org/assets/echarts-wordcloud.min.js"></script>
<script type="text/javascript" src="https://assets.pyecharts.org/assets/maps/china.js"></script>

<div id="links" style="line-height: 36px; background-color:black;">
    <a href="/" style="display: inline-block; text-align: center;text-decoration: none;color: azure;" >数据分析与可视化</a>
    <a href="/document" style="display: inline-block; text-align: center;text-decoration: none;color: azure;" >技术文档</a>
</div>

# 疫情空间数据与舆情数据分析可视化

新型冠状病毒肺炎（COVID-19，简称“新冠肺炎”）疫情肆虐全球多个国家，2020年3月11日，世界卫生组织 (WHO) 正式宣布将新冠肺炎列为全球性大流行病。

在全球抗击新型冠状病毒疫情的过程中，产生了前所未有的大规模疫情数据，利用大数据分析技术和方法能够协助发现病毒传染源、监测疫情发展、调配救援物资，从而更好地进行疫情防控工作。空间数据分析作为大数据分析的重要组成，将数据智能处理、直观展示和交互分析有机地结合，使机器智能和人类智慧深度融合、优势互补，为疫情防控中的分析、指挥和决策提供有效依据和指南。

本项目希望能利用交互式空间数据分析技术，感知和预测疫情发展趋势与关键节点、分析社交媒体话题与情感的动态演变、对社会舆情进行态势感知。

## 所使用的数据集：

- 疫情统计时空数据，分为国内各省市疫情统计数据及世界各国疫情统计数据，包括从1.19至5.19四个月时间的确诊人数、现存确诊人数、治愈人数、死亡人数等
- 中国社会组织公共服务平台疫情防控专区新闻1400+篇，包含时间、标题、正文内容、作者等
- 依据与“新冠肺炎”相关的230个主题关键词进行数据采集的2020年1月1日—2020年2月20日期间共计100万条微博数据

部分数据经爬虫采集，部分数据采用公开数据集；可视化部分采用pyecharts+flask实现动态交互

## Part 1：疫情空间数据数据可视化态势感知、趋势分析：

### 疫情数据动态交互可视化地图

共有三种地图类型：现存确诊率地图、累计死亡人数地图、死亡率（累计死亡人数/累计确诊人数）地图，可以通过下拉框进行选择；

可以拖动时间轴上的滑块改变地图显示日期，范围为 1.19-5.19；

<div id="current-maps" >
    <div>
        <label>请选择地图类型:     </label>
        <select name="select-map" id="mapselecter">
            <option value="0" >现存确诊人数</option>
            <option value="1" >累计死亡人数</option>
            <option value="2" >死亡率（死亡/确诊）</option>
        </select>
    </div>
    <div>
        <label>拖动滑块即可切换日期:</label>
        <input id='slider' style="width: 400px;vertical-align: middle;" type='range' min='0' max='121' step='1'/>
    </div>
    <div id="worldMap" class="maps" style="width:800px; height:600px;display: inline-block;"></div>
    <div id="chinaMap" class="maps" style="width:800px; height:600px;display: inline-block;"></div>
</div>

通过交互分析可以发现：

- 现存确诊人数图
  - 在1.20日左右，全国公布的疫情一开始出现在广东、湖北、北京上海等地，此时湖北的疫情确诊人数已经突破200；
  - 此后，疫情从湖北开始向四周身份成扩散趋势，在1.26日湖北的确诊人数已经突破1000；除湖北外，浙江与广东确诊人数也到达三位数；国外在美国、澳大利亚、法国和泰国等东南亚国家也出现确诊病例；
  - 在2.2日前后，湖北的确诊人数突破五位数，其他地区疫情人数继续增加；国外疫情也在欧洲、东南亚、美洲呈缓慢扩散趋势
  - 在2月中旬，西藏成为国内首个清零的省份；国外继续缓慢增长；国内疫情迎来拐点，现存确诊人数趋于平缓、不再增加，并开始缓慢减少；现存确诊人数约为50000左右，其中大部分集中在湖北；
  - 二月底三月初，国内确诊人数逐渐减少，国外此时开始大规模出现感染并扩散到多个国家；此时意大利、伊朗疫情较为严重；疫情开始扩散到非洲、南美洲；
  - 三月中旬后，国内疫情已经基本得到控制，大多省份恢复到个位数或清零，绝大多数现存确诊病例集中在湖北；而世界上大部分国家都已出现确诊报告，许多国家突破五位数确诊；其中欧洲和伊朗、美国较为严重；
  - 四月初，国内确诊人数继续减少，但有部分省份出现略微反扑；国外疫情几乎已经扩散到世界所有国家，其中美国确诊人数已经突破20万，是世界最严重的地区；
  - 从四月中旬开始，由于外来输入原因，国内黑龙江及东北地区出现了一次比较严重的疫情反扑，确诊人数接近500，但在五月初逐步得到控制；
  - 国外疫情在四五月份继续趋向严重，在5.8美国的确诊人数突破百万；但部分早期疫情严重的国家由于采取了有效的控制手段导致疫情缓解；
  
- 累计死亡人数
  - 二月初，世界各国开始出现死亡病例；
  - 国内的死亡病例数在二月中旬趋向平缓；
  - 在三月中旬，世界各国死亡病例陆续出现或开始明显增多；
  - 在五月份，报告的死亡数以美国、欧洲最为严重，许多国家死亡人数已经远远超过了中国；

- 死亡率：
  - 死亡率也可以反应出疫情的控制程度，死亡率越低表明患者得到救治的概率越大；
  - 在医疗资源充足的地区，死亡率可以降低到1%左右；医疗资源不足的地区，死亡率可以高达10%；
  - 国内死亡率数据分析：
    - 在一月下旬，中国的死亡率以黑龙江、湖北、湖南河南较为严重，但在一月底二月初除湖北外，其他省份呈下降趋势；
    - 在国内疫情确诊人数峰值的二月中旬，国内平均死亡率为2.5，死亡率相对较高的是湖北、黑龙江、海南、台湾等地；
    - 此后，国内湖北的死亡率继续升高，可能是由于医疗资源不足，无法给予患者有效救治，同时此前积累的确诊患者也陆续出现死亡；同样升高的有新疆、黑龙江；
    - 三月中旬后，在国内疫情基本得到控制的情况下，全国平均死亡率在4%，湖北死亡率达到4.7左右；
    - 在四月中旬补统计了一下之前因为新冠去世但未计入死亡率数据的死亡人数，最后湖北的死亡率为6.6，国内平均死亡率在5.5
  - 国外死亡率数据分析：
    - 从三月下旬开始，伴随着疫情的大规模扩散，各国疫情死亡率也逐步增高；
    - 值得注意的是，许多国家的统计数据表明在其疫情刚开始出现的数日内死亡率是一个高峰，可能表明了在初始阶段未能对患者作出良好的检测和发现，只能从新冠重症患者处得到资料；
    - 虽然非洲等某些不发达国家的疫情报告数据较少，但死亡率较高；可能表明了对于新冠的轻症患者，并没有良好的检测能力；
    - 死亡率较高的国家显著集中在欧洲地区，表明了医疗资源的相对短缺；墨西哥的死亡率也较高；

总体来看：
- 中国在三月份就逐步控制住了疫情趋势，为世界抗疫事业做出了卓越的典范；
- 欧洲和美洲等发达国家疫情数据较为严重，可能是发达国家在世界范围内流动的人口较大，但更可能是发达国家能得到有效的检测并报告病例；

### 世界疫情数据曲线图

通过曲线图可直观地表现出确诊数据、死亡数据、治愈数据等的变化趋势，可以通过下拉框进行选择所显示的国家：

<div>
    <label>请选择国家：    </label>
    <select id="selectCountrys">
    {% for cate in cates %}
        <option value="{{cate}}" >{{cate}}</option>
    {% endfor %}
    </select>
    <div id="lines" style="width:1000px; height:600px;"></div>
</div>

通过交互分析，可以将疫情数据趋势分为几种类别：

- 疫情已经得到控制，如中国：
- 疫情数据还在保持增长趋势，如美国、俄罗斯；
- 疫情基本得到控制，现存确诊数在逐步减少，如意大利；
- 数据太少，如多米尼克；

同时也可以发现：

- 由于检测技术或标准变化，可能出现确诊数据在短时间内的大量增多，也有的国家是每隔一段时间集中增加一次确诊数据；
- 截止5.20，大多数国家的疫情还在上升趋势；

### 全国疫情新增确诊人数日历图

日历图也可以直观的反映出当日疫情新增人数的多少；

<div id="04cd225d9bb642288bef9788ed998f30" class="chart-container" style="width:500px; height:300px;display: inline-block;"></div>
<script type="text/javascript" src="{{ url_for('static',filename='calendar.js') }}"></script>

可以看到，确诊人数的增多从一月底开始，在二月中旬达到高峰后逐步回落；而三月下旬增加人数又有一次较小的上升。

### 疫情趋势预测分析

#### logistic回归算法

（1）模型描述：当一个物种迁入到一个新生态系统中后，其数量会发生变化。假设该物种的起始数量小于环境的最大容纳量，则数量会增长。该物种在此生态系统中有天敌、食物、空间等资源也不足（非理想环境），则增长函数满足逻辑斯谛方程，图像呈S形，此方程是描述在资源有限的条件下种群增长规律的一个最佳数学模型。

（2）一般疾病的传播是S型增长的过程，因为疾病传播的过程中会受到一定的阻力（医治、切断传播途径等措施）。

此处采用最小二乘法，对logistic增长函数进行拟合。以下将检验最小二乘法拟合的逻辑斯蒂模型是否能贴合实际。

<img src="{{ url_for('static',filename='results/logistic_china.png') }}" style="width:600px; height:500px;">

本次拟合采用了1月11日到1月27日的累计确诊病例数据作为原始数据，采用最小二乘法拟合逻辑斯蒂曲线，最后经过对逻辑斯蒂模型中R值（增长速率，到达K值的速度）的拟合调整，发现在0.45附近得到的曲线比较贴合我国1月至2月疫情实际情况。从短期来看，2月9日的预测值在4万左右，与实际情况十分贴近，也证明了模型的一定可靠性；但从长期来看，最终值还是相对偏低。

可以将本模型推广，进行全球范围内典型新冠肺炎爆发国家的疫情拟合与未来疫情预测，同时将通过R值的大小反应出该国疫情应对的有效程度：

以下分别是对日本、美国、中国、德国从1.19至5.19的疫情数据进行的拟合和预测：

<div>
<img src="{{ url_for('static',filename='results/logistic_world.png') }}" style="width:400px; height:300px;display: inline-block;">
<img src="{{ url_for('static',filename='results/logistic_american.png') }}" style="width:400px; height:300px;display: inline-block;">
<img src="{{ url_for('static',filename='results/logistic_china1.png') }}" style="width:400px; height:300px;display: inline-block;">
<img src="{{ url_for('static',filename='results/logistic_german.png') }}" style="width:400px; height:300px;display: inline-block;">
</div>

R值：

国家 | 中国 |美国 |英国 |德国 |意大利 |韩国| 日本
- | :-: | :-: | :-: | :-: | :-: | :-: | -:
R |0.25 | 0.05 |0.08 |0.09 |0.08 |0.11 |0.08

关于R值的补充说明：逻辑斯蒂模型中R值代表的增长速率不是传统意义上理解的种群增长速度，而是接近种群数量达到环境承载力K值的速度。强烈的人为干预可以**大幅度降低K值**，使得种群数量快速达到最大值附近，疫情扩散得以控制。所以本模型在预测各国最终累计感染人数的功能之外，拟合过程中R值的大小可以反映某个国家面对新冠肺炎采取措施的**有效性和效率**。一般来说，R值越大，该国防疫措施越有效。

#### SEITR模型：

（1）模型简介：SEITR模型是基于动力学SEIR模型不断调试模拟的结果，能够比较合理贴合传染病传播的一般规律。

我们先来看看SEIR模型：

1）模型中的4类人群：N为总人数
SUSCEPTIBLES: 用S表示，为易感者, 潜在的可感染人群
EXPOSED：用E表示，为潜伏者, 已经被感染但是没有表现出来的人群
INFECTIVES: 用I表示，为感染者, 表现出感染症状的人
RESISTANCES: 用R表示，为抵抗者, 感染者痊愈后获得抗性的人

2）模型中的3种参数：
αß：易感人群（S) 被感染人员（I) 传染的传染率，相当于单人次易感者接触感染者而被感染的几率（ß）与易感者单位时间内接触的感染者人数（α）的乘积
γ：感染人群（I) 以固定平均速率恢复（R) 或死亡的恢复率
Ω：潜伏人群（E) 变为感染者的平均速率，通常数值取潜伏期的倒数

3）增加修正的参数：
“T”：已被感染且正处于接受治疗时期的人群，主要特征表现为已被感染，已过潜伏期，但不会进行传染，且正在被治疗。
同时也将I人群严格定义为被感染，已过潜伏期但未被医院收治无法接受治疗的人群。
δ，表示I变为T的速率，主要受医院接诊速率及收治能力影响，也受发病后及时就医的时间影响。

以下使用SEITR模型对美国疫情基本得到控制的时间进行预测。

<img src="{{ url_for('static',filename='results/seir.png') }}" style="width:600px; height:500px;">

模型拟合评价：

（1）参数的设置：

1）传染率系数与人与人之间的社交距离和社交频率息息相关，美国在疫情早期未及时向民众宣传保持社交距离和戴口罩、减少出行的建议，导致传染率系数会比参数设置的更高；

2）治疗系数与当地医疗水平、卫生设施数量、医疗物资等息息相关，疫情中期各州的医疗设备全面告急，医护人员感染率上升，同时中产阶级及以下家庭因为无法支付高昂医疗费选择在家隔离，错过最佳治疗期，使得治疗系数要低于已经有雷神山火神山的武汉对应时期的治疗系数；

（2）结果分析：
主要的预测在于感染人数逐渐趋于0的时间节点，本次预测得到的结果是今年秋季美国的疫情能够基本得到控制。

（3）拟合分析；
本模型在尝试同时拟合现有病例（正在接受治疗人群）和治愈人数曲线时，发现无法做到相对同时拟合的比较贴合实际的结果。分析可知，（1）中的参数对拟合结果的影响非常大，而模型参数的选择需要结合美国实际疫情情况才能推算，目前使用的计算手段过于粗糙；同时该模型的假设条件是，美国的0号病人出现在今年1月11日，但是目前的报告陆续显示早在2019年美国就有社区性传播，因此本模型的可靠性大大下降。由于具体的时间目前国际上无法追溯，所以进一步的研究很难继续进行。

## part 2: 疫情舆情数据分析与可视化

### 新闻数据分析与可视化

#### 中国社会组织公共服务平台疫情防控专区新闻词云可视化：

我们通过爬虫技术，对中国社会组织公共服务平台疫情防控专区新闻进行了抓取，共计获得了 1-26 至 5-19 时间段内共1400+新闻；

词云图，也叫文字云，是对文本中出现频率较高的“关键词”予以视觉化的展现，词云图过滤掉大量的低频低质的文本信息，使得浏览者只要一眼扫过文本就可领略文本的主旨。

对该平台上发布的所有文章使用jieba进行分词、获取主题词（取排名前00位），并渲染词云图：

<div>
    <div id="c61d88ede2df46799724e4ef261fa76f" class="chart-container" style="width:900px; height:500px;"></div>
    <script type="text/javascript" src="{{ url_for('static',filename='wordcloud.js') }}"></script>
</div>

可以看到，“疫情”、“防控”、“组织”、“工作”等词语较为突出，这也和平台的主旨相吻合；

对不同日期的文章集合分别渲染词云图，可以直观地看出新闻主题随着时间的变化；

可通过拖动滑块改变日期范围，每个日期范围内有约100篇新闻；

<div>
    <div>
        <label>拖动滑块即可切换日期:</label>
        <input id='sliderWord' style="width: 400px;vertical-align: middle;" type='range' min='0' max='90' step='1'/>
    </div>
    <div id="wordcloud" style="width:1000px; height:600px;"></div>
</div>

- 疫情前期主题词以“防控”、“组织”、“工作”、“社会”为主，对应于主要的抗疫力量为政府动员工作和社会组织捐赠
- 后期“企业”，“复工”等词语占比越来越大，也对应着复工成为主要需求；

### TF-IDF值

TF-IDF（Term Frequency-InversDocument Frequency）是一种常用于信息处理和数据挖掘的加权技术。该技术采用一种统计方法，根据字词的在文本中出现的次数和在整个语料中出现的文档频率来计算一个字词在整个语料中的重要程度。它的优点是能过滤掉一些常见的却无关紧要本的词语，同时保留影响整个文本的重要字词。

TF - IDF = TF * IDF

TF（Term Frequency）表示某个关键词在整篇文章中出现的频率。IDF（InversDocument Frequency）表示计算倒文本频率。文本频率是指某个关键词在整个语料所有文章中出现的次数。倒文档频率又称为逆文档频率，它是文档频率的倒数，主要用于降低所有文档中一些常见却对文档影响不大的词语的作用。

<img src="{{ url_for('static',filename='results/tfidf.png') }}" style="width:600px; height:500px;">

输出结果如下图所示，可以看到“疫情”、“组织”、“捐赠”、“社会”、“协会”、“肺炎”、“物资”等都是高频词，也是大众普
遍关心的主题。

# 层次聚类分析

对主题词进行层次聚类分析，层次聚类法的基本过程如下：

- 每一个样本点视为一个簇；
- 计算各个簇之间的距离，最近的两个簇聚合成一个新簇；
- 重复以上过程直至最后只有一簇。

层次聚类不指定具体的簇数，而只关注簇之间的远近，最终会形成一个树形图，可以表明相应关键词间的联系：

<img src="{{ url_for('static',filename='results/tree_word_50.png') }}" style="width:1000px;">

可以明显地观察到，主题词可以分为三类，大致对应于三个主题板块：
- 医院获取物资捐款、志愿者行动
- 企业复工复产
- 社会组织抗击疫情

### 微博舆情分析与数据可视化

#### 微博主题词词云图：

依据与“新冠肺炎”相关的230个主题关键词进行随机数据采集的2020年1月1日—2020年2月20日期间共计100万条微博数据进行主题词计算，可绘制微博主题词词云图：

<script type="text/javascript" src="{{ url_for('static',filename='render.js') }}"></script>

分别对于每日的微博主题词进行分析，可绘制微博每日主题词词云图：

<div>
    <div>
        <label>拖动滑块即可切换日期:</label>
        <input id='sliderWeibo' style="width: 400px;vertical-align: middle;" type='range' min='0' max='49' step='1'/>
    </div>
    <div id="weibocloud" style="width:1000px; height:600px;"></div>
</div>

通过可视化交互分析可以发现：

- 在疫情尚未大面积出现的前期，收集到的疫情相关主题词主要为2020、发烧、肺炎、穿山甲等等，疫情有关词语占主题词比例相对较少，主题词相对较为分散；其中也夹杂部分早期出现的如病毒性等描述；
- 在1月12号左右，冠状病毒、肺炎等词语数量开始远大于其他非疫情相关词语；
- 在1.23，随着武汉封城，武汉这一词汇提及次数也显著增大；
- 在1月底二月初，疫情、新冠等词语也频繁被提及；加油这一词语也十分显著，表明了全国人民同疫情斗争的决心和对武汉的美好祝愿；
- 该词云图也可以显著的反应出舆论热点，如2.6左右的李文亮医生去世事件就可以观察到李文亮一词在词云图中显著展示；
- 肖战一词占比较少，但始终在词云图中出现，也许表明了在疫情期间仍然对于明星有一定的关注流量；

#### 微博情感分析

对微博数据采用snowNLP进行情感分析得出的情感数值，范围为-0.5 ~ 0.5，大于0为正面情感，小于0为负面情感；

绘制每日平均情感数值曲线图：

<div>
    <div id="9d2779b5eb384c2793ed26055a81879d" class="chart-container" style="width:900px; height:500px;"></div>
    <script type="text/javascript" src="{{ url_for('static',filename='weibolines.js') }}"></script>
</div>

总体而言，疫情相关的微博情感倾向还是偏正面或中性；在1.19前，情感平均值较高，约为0.2；在1.19，疫情开始在全国扩散开来并且钟南山宣布人传人之后，情感平均值下降到了0，1附近；在2.18、2.19时，可能由于疫情国内接近拐点，情感分析数值又有显著提高；

其他分析和代码详见notebook；

## 政策建议

结合对新冠肺炎的扩散趋势和传染系数的分析，以及疫情期间出现的一系列问题，提出5点建议。

（1）加强舆论引导和监督。政府相关部门要积极引导舆论，发布真实、可靠的消息，做到信息及时公开，避免被动辟谣。同时，警惕国内外资本夸大疫情、借机炒作中国市场，扰乱中国经济秩序。媒体发布相关疫情信息之前，多询问相关领域的专业人士，确保信息真实、可靠。

（2）改善信任危机。疫情期间折射出的信任危机，相关部门要敢于承认、敢于担当、敢于问责。如果一味地回避只会加重信任危机。科研人员要对自己的研究负责，谨慎发表一些可能带来不利于社会团结稳定的信息，疫情期间更应加强监督和同行评议。

（3）加强公众心理疏导，减少恐惧。针对公众的恐慌心理应及时进行科普和心理疏导。疫情期间的科普要以解决实际问题为第一要义，不能为了吸引眼球去科普。此外，科普要接地气，要主动出击去解决问题，要以公众通俗易懂的语言去讲述。如果讲清楚新冠病毒的起源、发病机制、致死率等问题，就可以大幅减少恐慌。同时，要警惕一些打着科普旗号，捕风捉影、制造恐慌的行为。

（4）科学开展防控。针对过度防控问题，首先应对各个城市面临的疫情危机进行正确、科学地评估。本文结论表明，目前各个城市的新冠肺炎的病例数和城市的人口规模高度相关。基于此，城市的疫情防控不能只看新增确诊病例数和累计确诊病例数，还要结合城市人口和面积综合考虑其传染的危险等级。对于一些疫情威胁低的地区，如一些西部城市，当每日增加确诊病例数趋于稳定或停止，当地医疗条件足以应对的情况下，应重点管控人员的跨省流动，适度放松本省内城市间的人员流动，在做好个人防控的基础上及时恢复正常的生产、生活秩序。

（5）完善治理体系。此次疫情是对我国治理体系和能力的一个考验，政府的作为有令人赞叹之处，也有让人痛心之时。应尽早完善应急体系的职责、社会管理机制，以及和政府各部门的联动机制。当前，应尽快将中国应急体系中已经成建制的力量纳入抗击疫情工作中[26]。各级卫生健康委员会系统，包括疾病控制中心、医院及政府其他职能部门应尽快建立和完善稳定健全的协调机制，使应急管理部门的作用充分、有效、合理发挥。