# MVC开发规则

## 1. 介绍

1. MVC开发规则制定了互联网通信开发过程中必须出现角色有哪些
2. MVC开发规则制定了互联网通信开发过程中必须出现角色担负职责
3. MVC开发规则制定了互联网通信开发过程中必须出现角色的出场顺序

## 2. 角色

- DOA对象：DOA对象提供某张表文件的操作细节，降低了对表文件操作难度。

  ​					避免反复开发表文件操作的代码，提高代码复用性。

- Service对象：服务对象，提供【业务】的具体解决方案。

  ​						Service对象一个方法指定一个业务的解决方案

  ​						避免业务开发重复性开发行为，提供复用性。

  ​						网站中的每一个业务都有一个独立标准解决方案。

## 3. 业务

- 浏览器向Http服务器发送请求
- 用户向网站发送请求

![](https://gitee.com/YunboCheng/imageBad/raw/master/image/20210725110514.png)

## 4.业务特征

1. 在真实的业务场景中，一个业务里边包含多个分支任务。因此解决业务开发工作量往往巨大。
2. 真实业务场景中，只有当所有的分支任务都能够顺利成功解决，才可以认为当前业务处理成功

## 5. 解决业务开发困扰

1. 一个业务可能在网站中的多个地方重复出现，如果不进行【封装】，增加开发难度，

   进行业务解决代码重复性开发。

2. 【百人百味】，不同程序员面对同一个业务时，给出的解决方案往往有偏差，

   导致最终解决的数据会出现偏差。

## 6.MVC开发规则--互联网通信开发过程中必须出现的角色



一次互联网的开发过程中必须出现的角色有三个：

- C   controller  object   :    控制层对象        (servlet对象)
- M  model        object   :   业务模型对象     (Service对象)
- V   view           object   ： 视图层对象         (jsp  or  HttpServletResponse)

## 7.MVC开发规则--互联网通信开发过程中必须出现的角色担负的职责

- C (servlet对象)：
  1. 【可以】调用【请求对象】读取【请求包】参数信息 （可以的意思代表可以不调用）
  2. 【必须】调用【Servlet对象】处理业务
  3. 【必须】调用【视图层对象】将结果写入到响应体
- M (service对象)：
  1. 处理业务中所有的分支任务
  2. 根据分支业务执行情况判断业务是否处理成功
  3. 必须通过return将处理结果返回给【控制层对象】
- V (jsp/HttpServletResponse ):
  1. 【禁止参与业务处理】
  2. 唯一任务将处理结果写入到响应体

## 8.MVC开发规则--互联网通信开发过程中必须出现的角色的出场顺序

### 8.1请求调用顺序

**当浏览器向服务端发起请求必须交给控制层对象 （Servlet对象）**

**Servlet【不进行】业务的处理，此时会调用【业务模型对象 】(service对象)**

**【service对象】有权利调用DOA对象对表文件进行增删改查**

![](https://gitee.com/YunboCheng/imageBad/raw/master/image/20210725115144.png)

### 8.2 响应顺序

**分支任务执行完毕之后全部交给【service对象】，service对象只能将结果交给【Servlet对象】**

**【Servlet对象】此时将结果交给【View对象】，【View对象】将结果写入的响应体中进行输出**

![](https://gitee.com/YunboCheng/imageBad/raw/master/image/20210725114705.png)

**黑色箭头代表调用，红色箭头代表响应**

<img src="https://gitee.com/YunboCheng/imageBad/raw/master/image/20210725114756.png" style="zoom:67%;" />







 