# コントリビュートの流れ

開発を始める前に[一般的な OSS コントリビューション](https://note.com/samurai_se/n/ncde3bb14066e?magazine_key=md5321f66534d)をご一読ください。

コントリビュートに際しての大まかな流れは以下の通りです。

## 1. このリポジトリをフォークします。

github の"Fork"から、自身のリポジトリに本家リポジトリを Fork してください。

## 2. 自分のリポジトリにフォークしたリポジトリをローカルにクローンします。

この作業は、誤ってオリジナルブランチへ push したりするのを防ぐために行います。

```
git clone https://github.com/<あなたのユーザー名>/booby.git
```

## 3. 本家リポジトリの URL を Upstream として登録します。

```
git remote add upstream https://github.com/ysknsid25/booby
```

## 4. 環境構築

[README](./README.md)を参考に環境構築を行ってください。

## 5. issue から開発内容を事前共有

競合や無意味な修正を防ぐために、あらかじめ修正の内容を issue からご連絡ください。

無意味な修正とは、本質的な改善が得られない自己満足(開発者の好み)なコードリファクタリングやドキュメントの一部表現を変えただけのコミットを指します。

## 6. dev ブランチをベースに開発用ブランチを切ります。

```
git branch <issue番号>
```

## 7. 開発を進めていきます

開発を進めるにあたって、必ずテストコードも書いてコミット・push までしてください。

既存のコードに新たな処理を追加した場合は、必ずテストコードも追加してください。

新規でコードを作成した場合はいわずもがなテストコードも作成してください。

また、コミットを行う際には適切なプレフィックスをつけたコミットメッセージを書いてください。

コミットメッセージの書き方は[こちら](https://qiita.com/konatsu_p/items/dfe199ebe3a7d2010b3e)を参考にしてください。

## 8. 開発が終わったら(できれば開発途中でも)、ローカルでテストコードを実行します

以下のコマンドを実行して、テストコードがエラーにならないかを確認してください。

```
npm run test:all
```

テスト駆動で開発を進めることが望ましいです。

また、コンポーネントを修正・追加した場合はテストコードも修正・追加してください。

テストコードはプルリクを出した場合にも実行されます。

**そこでエラーがでないようにしてください。**

同様に Linter エラーがないかも事前に確認してください。

```
npm run lint
```

## 9. プルリクを送る

プルリクのマージ先ブランチに**dev**を選択してください。

プルリクのタイトルは「#issue-番号 issue 名」の形にしてください。

issue を出していない場合、プルリクのタイトルは修正内容が分かる内容にしてください。その際のプルリクのタイトルには、適切なプレフィックスをつけてください。

## 10. プルリクがマージされたら、自身のリポジトリに最新のソースを反映します。

オリジナルの dev への変更を自身のローカルの dev ブランチへ取り込み、自身のリモートリポジトリの dev ブランチへ反映させて、ソースを最新化します。

```
git checkout dev
git fetch upstream
git merge upstream/dev --ff-only
git push origin dev -u
```

さらに開発を行う場合は、手順 6 へ戻ります。
