//go:build plugins

package main

import (
	"bufio"
	"bytes"
	"fmt"
	"os"
	"strings"
	"text/template"
)

//go:generate go run generate.go

var tpl = `// Code generated by wxbot project. DO NOT EDIT.
// Source: github.com/yqchilde/wxbot/engine/plugins/generate.go

package plugins

import (
	{{- range .Imports }}
	{{ . }}
	{{- end -}}
)
`

type tplData struct {
	Imports []string
}

func main() {
	f, err := os.Open("../../plugins.yaml")
	if err != nil {
		fmt.Printf("error opening file: %v", err)
		os.Exit(1)
	}
	defer f.Close()

	scanner := bufio.NewScanner(f)
	imports := []string{}
	for scanner.Scan() {
		line := strings.TrimSpace(scanner.Text())
		if line == "" {
			continue
		}
		split := strings.Split(line, "#")
		line = "//" + split[1] + "\n\t" + strings.TrimSpace(split[0]) + "\n"
		line = strings.Replace(line, "-", "_", 1)
		imports = append(imports, line)
	}

	tmpl, err := template.New("plugins").Parse(tpl)
	if err != nil {
		fmt.Printf("error parsing template: %v", err)
		os.Exit(1)
	}

	data := tplData{
		Imports: imports,
	}

	var buf bytes.Buffer
	if err := tmpl.Execute(&buf, data); err != nil {
		fmt.Printf("error executing template: %v", err)
		os.Exit(1)
	}

	f, err = os.Create("plugins.go")
	if err != nil {
		fmt.Printf("error creating file: %v", err)
		os.Exit(1)
	}
	defer f.Close()

	if _, err := buf.WriteTo(f); err != nil {
		fmt.Printf("error writing to file: %v", err)
		os.Exit(1)
	}
}
