# pipeline

写管道时：

向管道中写入数据：
向管道中写入数据时，linux将不保证写入的原子性，管道缓冲区一有空闲区域，写进程就会试图向管道写入数据。如果读进程不读走管道缓冲区中的数据，那么写操作将一直阻塞。
对于没有设置阻塞标志的写操作：（1）当要写入的数据量不大于PIPE_BUF时，Linux将保证写入的原子性。如果当前FIFO空闲缓冲区能够容纳请求写入的字节数，写完后成功返回；如果当前FIFO空闲缓冲区不能够容纳请求写入的字节数，则返回EAGAIN错误，提醒以后再写。（2）当要写入的数据量大于PIPE_BUF时，Linux将不再保证写入的原子性。在写满所有FIFO空闲缓冲区后，写操作返回。
注：只有在管道的读端存在时，向管道中写入数据才有意义。否则，向管道中写入数据的进程将收到内核传来的SIFPIPE信号，应用程序可以处理该信号，也可以忽略（默认动作则是应用程序终止）。
管道写端关闭后，写入的数据将一直存在，直到读出为止。

读管道时：
如果管道的写端不存在，则认为已经读到了数据的末尾，读函数返回的读出字节数为0； 
当管道的写端存在时，如果请求的字节数目大于PIPE_BUF，则返回管道中现有的数据字节数，如果请求的字节数目不大于PIPE_BUF，则返回管道中现有数据字节数（此时，管道中数据量小于请求的数据量）；或者返回请求的字节数（此时，管道中数据量不小于请求的数据量）。
注：（PIPE_BUF在include/linux/limits.h中定义，不同的内核版本可能会有所不同。Posix.1要求PIPE_BUF至少为512字节，red hat 7.2中为4096）。
以下的转载：http://blog.csdn.net/MONKEY_D_MENG/article/details/5570468
1.从FIFO中读取数据：

约定：如果一个进程为了从FIFO中读取数据而阻塞打开了FIFO，那么称该进程内的读操作为设置了阻塞标志的读操作。

（1）如果有进程写打开FIFO，且当前FIFO为空，则对于设置了阻塞标志的读操作来说，将一直阻塞下去，直到有数据可以读时才继续执行；对于没有设置阻塞标志的读操作来说，则返回0个字节，当前errno值为EAGAIN，提醒以后再试。

（2）对于设置了阻塞标志的读操作来说，造成阻塞的原因有两种：一、当前FIFO内有数据，但有其它进程在读这些数据；二、FIFO本身为空。

解阻塞的原因是：FIFO中有新的数据写入，不论写入数据量的大小，也不论读操作请求多少数据量，只要有数据写入即可。

（3）读打开的阻塞标志只对本进程第一个读操作施加作用，如果本进程中有多个读操作序列，则在第一个读操作被唤醒并完成读操作后，其它将要执行的读操作将不再阻塞，即使在执行读操作时，FIFO中没有数据也一样（此时，读操作返回0）。

（4）如果没有进程写打开FIFO，则设置了阻塞标志的读操作会阻塞。

（5）如果FIFO中有数据，则设置了阻塞标志的读操作不会因为FIFO中的字节数少于请求的字节数而阻塞，此时，读操作会返回FIFO中现有的数据量。

 

2.从FIFO中写入数据：

约定：如果一个进程为了向FIFO中写入数据而阻塞打开FIFO，那么称该进程内的写操作为设置了阻塞标志的写操作。

FIFO的长度是需要考虑的一个很重要因素。系统对任一时刻在一个FIFO中可以存在的数据长度是有限制的。它由#define PIPE_BUF定义，在头文件limits.h中。在Linux和许多其他类UNIX系统中，它的值通常是4096字节，Red Hat Fedora9下是4096，但在某些系统中它可能会小到512字节。

虽然对于只有一个FIFO写进程和一个FIFO的读进程而言，这个限制并不重要，但只使用一个FIFO并允许多个不同进程向一个FIFO读进程发送请求的情况是很常见的。如果几个不同的程序尝试同时向FIFO写数据，能否保证来自不同程序的数据块不相互交错就非常关键了à也就是说，每个写操作必须“原子化”。

 

一、对于设置了阻塞标志的写操作：

（1）当要写入的数据量不大于PIPE_BUF时，Linux将保证写入的原子性。如果此时管道空闲缓冲区不足以容纳要写入的字节数，则进入睡眠，直到当缓冲区中能够容纳要写入的字节数时，才开始进行一次性写操作。即写入的数据长度小于等于PIPE_BUF时，那么或者写入全部字节，或者一个字节都不写入，它属于一个一次性行为，具体要看FIFO中是否有足够的缓冲区。

（2）当要写入的数据量大于PIPE_BUF时，Linux将不再保证写入的原子性。FIFO缓冲区一有空闲区域，写进程就会试图向管道写入数据，写操作在写完所有请求写的数据后返回。

 

二、对于没有设置阻塞标志的写操作：

（1）当要写入的数据量不大于PIPE_BUF时，Linux将保证写入的原子性。如果当前FIFO空闲缓冲区能够容纳请求写入的字节数，写完后成功返回；如果当前FIFO空闲缓冲区不能够容纳请求写入的字节数，则返回EAGAIN错误，提醒以后再写。

（2）当要写入的数据量大于PIPE_BUF时，Linux将不再保证写入的原子性。在写满所有FIFO空闲缓冲区后，写操作返回