# Adapted from https://github.com/LongSoft/UEFITool/blob/new_engine/common/guids.csv

UEFI_GUIDS = {
    "00026AEB-F334-4C15-A7F0-E1E897E9FE91": "NvmeRecovery",
    "00160F8D-2B35-4DF2-BBE0-B272A8D631F0": "FirmwarePerformanceDxe",
    "0029DE6A-E024-4EB8-A91D-9F23AA1F4E92": "NetworkStackSetupScreen",
    "00364A4C-6A0A-4F08-8FFD-0937F3DBB13E": "IdeBusBoard",
    "0049858F-8CA7-4CCD-918B-D952CBF32975": "VirtioFdtDxe",
    "00504624-8A59-4EEB-BD0F-6B36E96128E0": "FpNvStorage",
    "0053D9D6-2659-4599-A26B-EF4536E631A9": "ShellAliasGuid",
    "0065D394-9951-4144-82A3-0AFC8579C251": "EfiPeiRscHandlerPpiGuid",
    "00720665-67EB-4A99-BAF7-D3C33A1C7CC9": "EfiTcp4ServiceBindingProtocolGuid",
    "00B46EC9-2712-486B-A6A4-E2933581C28B": "HstiPlatformDxe",
    "00C86DB8-013B-4FF4-B8E9-208F4FCF1C00": "LibSignal",
    "00CA959F-6CFA-4DB1-95BC-E46C47514390": "EfiTlsProtocolGuid",
    "00D6B14B-7DD0-4062-8821-E5F96A2A1B00": "FspReservedMemoryResourceHobMiscGuid",
    "00DBD91D-55E9-420F-9639-5E9F8437B44F": "EfiExtendedSalStatusCodeServicesProtocolGuid",
    "010216CD-9C09-4EB5-B7DA-D0A2865092D4": "ProjectDXE",
    "01359D99-9446-456D-ADA4-50A711C03ADA": "CpuInitPei",
    "01359D99-9446-456D-ADA4-50A711C03ADB": "CpuPeim",
    "0154DD51-9079-4A10-895C-9C0772815788": "PlatformBootManagerStringPackGuid",
    "01631791-F34E-4C0A-B15D-0B6CE22B27A8": "TcgPeiAfterMem",
    "0167CCC4-D0F7-4F21-A3EF-9E64B7CDCE8B": "ScsiBus",
    "0170F60C-1D40-4651-956D-F0BD9879D527": "Virtio10",
    "0174B2B5-F505-4B12-AA60-59DFF8D6EA37": "ShellNetwork2HiiGuid",
    "0182244E-F95D-43FC-91EC-60594EF47599": "Lpc47m18xDxe",
    "018A5C7A-12EB-429D-9DEF-6FCC410B04E8": "IioCfgUpdateDxeLightningRidgeEXECB4",
    "018E1925-D6A2-4A2A-8958-817610A15ADF": "PeiS3LibNull",
    "01D127EA-F6F1-4EF6-9415-8A000093F89D": "UEfiCorebootPayloadPkgTokenSpaceGuid",
    "01F34D25-4DE2-23AD-3FF3-36353FF323F1": "EfiPeiPcdPpiGuid",
    "020BC7C9-80E5-476D-B187-0FB754850CAB": "PvnvramDxe",
    "021722D8-522B-4079-852A-FE44C2C13F49": "SataController",
    "021BD2CA-51D2-11E3-8E56-B75417C70B44": "UsbDeviceProtocolGuid",
    "022218B8-FE5E-4EBC-BC96-74058A4E7E83": "ErrorGlobeBorder",
    "024DEE41-33E7-11D3-9D69-0008C781F39F": "EfiPartTypeLegacyMbrGuid",
    "025BBFC7-E6A9-4B8B-82AD-6815A1AEAF4A": "MnpDxe",
    "025F738B-4EBD-4D55-B728-5F421B601F1F": "PlatformInfoDxe",
    "025F738B-4EBD-4D55-B728-5F421B601F20": "PlatformCpuInfoDxe",
    "0284F846-2CB7-4960-8DB2-47AA71513AD5": "menu_selection",
    "02B01AD5-7E59-43E8-A6D8-238180613A5A": "EmuVariableRuntimeDxe",
    "02BD55C2-AB1D-4B75-B0FD-9A63AE09B31D": "BaseMemoryLibOptDxe",
    "02CE967A-DD7E-4FFC-9EE7-810CF0470880": "EfiEndOfDxeEventGroupGuid",
    "02EEA107-98DB-400E-9830-460A1542D799": "Ip6ConfigNvDataGuid",
    "02F04694-2C0A-4F1E-B0CE-64BE25890B03": "DebugAgentTimerLibNull",
    "0325B5A1-0937-4A4F-B8AF-EC3F80EE6B35": "SataControllerDxe",
    "03583FF6-CB36-4940-947E-B9B39F4AFAF7": "EfiSmbiosProtocolGuid",
    "036F84E1-7F37-428C-A79E-575FDFAA84EC": "EfiIommuDMArErrorSectionGuid",
    "0379BE4E-D706-437D-B037-EDB82FB772A4": "EfiDevicePathUtilitiesProtocolGuid",
    "0397B0C9-22E8-459E-A4FF-99BC65270929": "Tpm2StartupLocalityHobGuid",
    "03AF477A-8336-0142-8A65-B4BD93B1A1A9": "FirmwareExtension",
    "03C4E603-AC28-11D3-9A2D-0090273FC14D": "EfiPxeBaseCodeProtocolGuid",
    "03C70B0D-67E6-5C16-8E57-312DF246A961": "BootChimeAudio",
    "03DA99B3-DDF4-4C7E-8CCA-216FC3F1F311": "BaseFspSecPlatformLibNull",
    "03DBB540-E186-4615-8A7F-A427863B4E56": "PoofAnimationState1",
    "03FDF171-1D67-4ACE-A904-3E36D338FA74": "SeCPlatformReadyToBootGuid",
    "0412A7A1-C050-42C2-877A-77C379F9F5F1": "FirewireOhciDxe",
    "0419F582-0625-4531-8A33-85A9965C95BC": "WinNtBusDriverGuid",
    "041FD986-B016-47CE-AFC5-2269EDD4AD64": "ACPIS4Dxe",
    "044310AB-77FD-402A-AF1A-87D4120E7329": "FirmwarePerformanceSmm",
    "0468A601-C535-46FD-A95D-BBAB991B178C": "EfiPowerOnHobGuid",
    "046C44DB-59DF-41B3-AF53-EF707B930E9A": "FtRecovery",
    "04877BE8-FAC0-448E-801D-F0F895CCB012": "SmbiosDmiEditSsi",
    "04A76C80-06B9-445E-B73E-CB8C61A6A964": "SIO791",
    "04B37FE8-F6AE-480B-BDD5-37D98C5E89AA": "EdkiiVarErrorFlagGuid",
    "04EAAAA1-29A1-11D7-8838-00500473D4EB": "USBRT",
    "04F75442-A593-4281-BD4B-095935B7D2F8": "wifi_1bar",
    "050EB8C6-C12E-4B86-892B-40985E8B3137": "UefiDevicePathLibDevicePathProtocol",
    "0515BC05-2959-4E91-89C6-6B3A3F1FCB65": "TCG_MPDriver",
    "0541150C-E33B-4DAF-A263-02E4BB4BF1CF": "SecurityErrorHandlingDxe",
    "054F2504-E2BC-4641-83FC-502588FE1F28": "CpuInitDxe",
    "0565365C-2FE1-4F88-B3BE-624C04623A20": "MicrocodeUpdateDxe",
    "056BCA18-2F19-41EE-84EA-83746CB5069A": "CrystalRidgeSMM",
    "056E7324-A718-465B-9A84-228F06642B4F": "PlatformDxe",
    "057A449A-1FDC-4C06-BFC9-F53F6A99BB92": "EfiPciCfg2PpiGuid",
    "0584FC67-72B9-4D46-AE3E-AD330452D9B4": "InputDeviceAggregatorDxe",
    "05984E1A-D8BB-5D8A-A8E6-90E6FB2AB7DA": "AlertUI",
    "05AD34BA-6F02-4214-952E-4DA0398E2BB9": "EfiDxeServicesTableGuid",
    "05C99A21-C70F-4AD2-8A5F-35DF3343F51E": "EfiDevicePathFromTextProtocolGuid",
    "05DFCA46-141F-11DF-8508-E38C0891C4E2": "HfsPlusDxe",
    "05FFB44D-EE01-40E1-9866-FD27FD4FBE92": "ThunderboltDeviceDxe",
    "060CC026-4C0D-4DDA-8F41-595FEF00A502": "MemoryStatusCodeRecordGuid",
    "0619F5C2-4858-4CAA-A86A-73A21A18DF6B": "GenericWatchdogDxe",
    "062ACC82-1D1E-4F61-AA94-8B0C47236A3D": "BootScriptSaveOnS3SaveStateThunk",
    "0639408B-19A6-4B5D-BAFB-12A2F5114032": "Acoustic",
    "0650F140-439A-2D4F-9807-C92669339399": "AppleEvent",
    "06B5947E-FF53-457D-98BC-C5ABC777FD5A": "SetupMouseDxe",
    "06D20D84-A032-4E25-969A-346D255E46D1": "CpuCsrAccess",
    "06E81C58-4AD7-44BC-8390-F10265F72480": "PcdPpiGuid",
    "0718AD81-F26A-4850-A6EC-F268E309D707": "Tpm20PlatformDxe",
    "071A3DBE-CFF4-4B73-83F0-598C13DCFDD5": "Slp21Markers",
    "073E2576-F6C1-4B91-92A9-D4675DDA34B1": "PttPassThruProtocolGuid",
    "074993A4-19A1-4E0D-B892-8FBCC6D79F35": "SaveMemoryConfig",
    "074E1E48-8132-47A1-8C2C-3F14AD9A66DC": "EfiGlobalNvsAreaProtocolGuid",
    "07525079-2616-4599-93FA-5EE9E3F0295C": "CsmPolicy",
    "07709C98-414A-4039-B7D0-29C21F105E92": "AcpiPlatformFeatures",
    "077A3100-1667-45FA-B98C-37651B5073EE": "TpmSmbiosDxe",
    "078485F1-0C1F-4B1B-AFB3-4A09C0EF87A1": "It8728SmmFeatures",
    "0784924F-E296-11D4-9A49-0090273FC14D": "EfiDriverDiagnosticsProtocolGuid",
    "078F54D4-CC22-4048-9E94-879C214D562F": "DefaultFvPadFileNameGuid",
    "079E8E98-AE93-4B9A-8A71-1DC869F23E09": "ShellSortTestApp",
    "07A50B13-7539-41CB-B924-9E72B870C6D3": "UsbVhcDxe",
    "07A9330A-F347-11D4-9A49-0090273FC14D": "LegacyMetronome",
    "07B37006-9302-408E-B416-B524D110DD7F": "AppleHidInterface",
    "07D75280-27D4-4D69-90D0-5643E238B341": "EfiPciPlatformProtocolGuid",
    "08018188-42CD-BB48-100F-5387D53DED3D": "EfiPersistentVirtualCdGuid",
    "081CCA80-AE21-AFC8-1AC8-3091A8F1CBC5": "SmcOobPlatformPolicySmm",
    "0823A088-1248-4285-9616-0111CC76D3C5": "SmbusRecovery",
    "0833A84D-8A39-431F-BD1C-30965AAE71DD": "ProcessorStartup",
    "08464531-4C99-4C4C-A887-8D8BA4BBB063": "Ps2MouseDxe",
    "08497E75-0BF6-40E2-8ABF-B98DFB464C93": "SpiFlashPeiLibNull",
    "085DDD80-CE41-4FA8-B298-6071E8F62BC5": "SmcOobPlatformPolicyDxe",
    "08A2CA63-3B65-472C-874E-5E138E947324": "ASUSITERT",
    "08A92691-926C-414F-A0B5-E785D90B9853": "Memory_OK_DXE",
    "08B2E586-35A8-4A3F-A9ED-E48134891601": "SmcInBandSmm",
    "08B97689-86AF-4A36-9E35-117B4D2EF26A": "AfscDxe",
    "08EFD15D-EC55-4023-B648-7BA40DF7D05D": "PeiRamBoot",
    "08F2C63B-08DE-4CCD-8670-ACFE644A1C48": "PchS3Support",
    "08F74BAA-EA36-41D9-9521-21A70F8780BC": "EfiDiskInfoScsiInterfaceGuid",
    "0922E604-F5EC-42EF-980D-A35E9A2B1844": "IpSecConfig",
    "093E0FAE-A6C4-4F50-9F1B-D41E2B89C19A": "EfiCertSha512Guid",
    "09576E91-6D3F-11D2-8E39-00A0C969723B": "EfiDevicePathProtocolGuid",
    "09576E92-6D3F-11D2-8E39-00A0C969723B": "EfiFileInfoGuid",
    "09576E93-6D3F-11D2-8E39-00A0C969723B": "EfiFileSystemInfoGuid",
    "09831032-6FA3-4484-AF4F-0A000A8D3A82": "PL180MciDxe",
    "09D13410-2718-463A-8B15-DA93C3CA0A64": "UsbCdcEcm",
    "09EA8911-BE0D-4230-A003-EDC693B48E11": "VlvPeiInitPpiGuid",
    "09EA894A-BE0D-4230-A003-EDC693B48E95": "PchInitPpiGuid",
    "0A1D4FD8-4704-4501-85EB-93399492CBED": "DevShell",
    "0A2FBD15-1C25-407E-8915-60C5652BC2AA": "SystemFirmwareUpdateDxe",
    "0A5EA2E1-BE0B-44A0-A775-F429C9A018A0": "PlatformEarlyInit",
    "0A66E322-3740-4CCE-AD62-BD172CECCA35": "ScsiDisk",
    "0A8BADD5-03B8-4D19-B128-7B8F0EDAA596": "EfiConfigKeywordHandlerProtocolGuid",
    "0AA31BC6-3379-41E8-825A-53F82CC0F254": "AmiTpm32Bin",
    "0ABD8284-6DA3-4616-971A-83A5148067BA": "IsaFloppyDxe",
    "0AC12AB3-DD33-4460-87F5-82694D3D7402": "SmcOFBDNull",
    "0AC2D35D-1C77-1033-A6F8-7CA55DF7D0AA": "CpuPolicyPei",
    "0AD3D31B-B3D8-4506-AE71-2EF11006D90F": "UefiAcpiBoardInfoGuid",
    "0AE8CE5D-E448-4437-A8D7-EBF5F194F731": "EfiDxeIplPpiGuid",
    "0AF0B742-63EC-45BD-8DB6-71AD7F2FE8E8": "ShellDriver1HiiGuid",
    "0AF7C79C-65B5-4319-B0AE-44EC484E4AD7": "EfiHashAlgorithmMD5Guid",
    "0B04B2ED-861C-42CD-A22F-C3AAFACCB896": "BiosVideoDxe",
    "0B2CFBF2-3E08-4C4E-A74D-59748A9F930F": "LegacyRegionDxe",
    "0B4AE6BE-6DA6-4908-8A71-7E6A8A33B11C": "MeFwVersion",
    "0B4BDCFF-74B2-45AD-91E1-8F6634C8A1DC": "SIOBasicIOPei",
    "0B64AAB0-5429-11D4-9816-00A0C91FADCF": "EfiBisProtocolGuid",
    "0B6E5233-A65C-44C9-9407-D9AB83BFC8BD": "EfiCertSha224Guid",
    "0B6F5CA7-4F53-445A-B76E-2E365B806366": "ArmVirtTokenSpaceGuid",
    "0BB51CDD-A750-442F-A15E-7DEADFBA30FF": "Mtftp4Dxe2",
    "0BCB2808-FEA5-6047-9A60-8767A46A72A1": "AppleUdp4Dxe",
    "0BF70067-D53B-42DF-B770-E92C91C61411": "EfiTdtProtocolGuid",
    "0C0F3B43-44DE-4907-B478-225F6F6289DC": "UsbKeyboardLayoutPackageGuid",
    "0C34B372-2622-4A13-A46E-BFD0DEB48BFF": "I2cBusDxe",
    "0C375A90-4C4C-4428-8EA0-531BE8959BF7": "FlashDriverSmm",
    "0C3798AA-D22E-4DD6-8CB4-3C9CFB1D86D3": "SIOSLPSMI",
    "0C3B7B59-28E5-4C99-85E5-D0116DBFAAF2": "IsctWakeReason",
    "0C5FCE90-1C03-4ED2-9EFE-B1D02E72B3B0": "menu_bottom_mid",
    "0C85DF8A-4212-4CC1-A4AA-1A7A36E8DA97": "FpgaPlatformEarlyInit",
    "0C95A916-A006-11D4-BCFA-0080C73C8881": "WinNtThunkDxe",
    "0C95A928-A006-11D4-BCFA-0080C73C8881": "EfiWinNtVirtualDisksGuid",
    "0C95A92F-A006-11D4-BCFA-0080C73C8881": "EfiWinNtPhysicalDisksGuid",
    "0C95A935-A006-11D4-BCFA-0080C73C8881": "EfiWinNtFileSystemGuid",
    "0C95A93D-A006-11D4-BCFA-0080C73C8881": "EfiWinNtSerialPortGuid",
    "0C95A940-A006-11D4-BCFA-0080C73C8881": "WinNtBusDriverDxe",
    "0C989D41-F4B4-4244-9D7F-E9FFB4163273": "FastBootOption",
    "0CDA5D94-951A-4C61-8DD5-E5BF34BA69EC": "SlotDataUpdateDxeLightningRidgeEXECB1",
    "0D1ED2F7-E92B-4562-92DD-5C82EC917EAE": "CRBPei",
    "0D244DF9-6CE3-4133-A1CF-53200AB663AC": "FspsWrapperPeim",
    "0D3FB176-9569-4D51-A3EF-7D61C64FEABA": "EfiSecurityPkgTokenSpaceGuid",
    "0D51905B-B77E-452A-A2C0-ECA0CC8D514A": "EdkiiNonDiscoverableDeviceProtocolGuid",
    "0D79A645-1D91-40A6-A81F-61E6982B32B4": "EfiNt32PkgTokenSpaceGuid",
    "0D8039FF-49E9-4CC9-A806-BB7C31B0BCB0": "AmiTpm20PlatformPei",
    "0D82A9EC-1289-4FD4-AC0B-4C6B1A25ABC6": "SwitchableGraphicsDxe",
    "0D8E6E4E-B029-475F-9122-60A3FEDBA8C0": "DxeIoLibEsal",
    "0D9A1427-E02A-437D-926B-AA521FD722BA": "EfiPciLanInfoGuid",
    "0DA55BC9-45F8-4BB4-8719-5224F18A4D45": "EfiWiFiProtocolGuid",
    "0DB48A36-4E54-EA9C-9B09-1EA5BE3A660B": "EfiRestProtocolGuid",
    "0DBF0B49-604C-40D4-9121-77AC41942626": "FixedBootOrder",
    "0DC65ADC-A973-4130-8DF0-2ADBEB9E4A31": "FirmwarePerformanceS3PointerGuid",
    "0DC73AED-CBF6-4A25-A68D-59C80F44C7C3": "EfiDFUVerGuid",
    "0DCA793A-EA96-42D8-BD7B-DC7F684E38C1": "LegacyRomLayout",
    "0DCE384D-007C-4BA5-94BD-0F6EB64D2AA9": "PeiNtAutoScanPpiGuid",
    "0DCF3594-318C-4596-B00F-BE61842DE3E2": "SystemBootTypePeiPei",
    "0DE2CE25-446A-45A7-BFC9-37DA26344B37": "EfiPeiDeviceRecoveryModulePpiGuid",
    "0DED86EE-6E79-4764-AA83-37A472F48123": "FtBbUpdate",
    "0E00B084-2D16-4A27-B172-B1F68C2CC55D": "MicrocodeUpdates",
    "0E1D2972-65AF-4AC1-BFA3-CEF4AB0C38FE": "EfiCapsuleCrashGuid",
    "0E2DAF63-8A4F-4026-A899-DE2D7F46E5EC": "SgTpvPei",
    "0E84FC69-29CC-4C6D-92AC-6D476921850F": "UpdateDriverDxe",
    "0E8C545B-A2EE-470D-8E26-BDA1A13C0AA3": "LastEnumLangGuid",
    "0E93C52B-4B73-5C32-86D5-69250A0BA723": "AppleThemeFileNames",
    "0EB84DA1-267A-40B4-8347-1F48694C8B47": "PeCoffExtraActionLibNull",
    "0ECC666B-4662-47F9-9DD5-D096FF7DA49E": "PeiSecPerformancePpiGuid",
    "0EDC9494-2743-4BA5-8818-0AEF5213F188": "EfiExtendedSalCacheServicesProtocolGuid",
    "0EEC96BC-0B82-4573-9791-C414E4DCEE64": "IhisiService",
    "0EF53039-3A38-42D1-BCEC-CE966E87061A": "PeiFrb",
    "0EF8A3B1-388A-4B62-8BE6-C7877D50AEDF": "UefiPxeBcDxe",
    "0EF98D3A-3E33-497A-A401-77BE3EB74F38": "EfiAcpiS3ContextGuid",
    "0EFC6282-F1E5-469A-8A70-194A8761F9AA": "XenAcpiPlatformDxe",
    "0F0B1735-87A0-4193-B266-538C38AF48CE": "EfiIfrTianoGuid",
    "0F17CECC-653A-C343-9CFA-FAA27A07EFE5": "AppleCrypto",
    "0F6499B1-E9AD-493D-B9C2-2F90815C6CBC": "EfiPhysicalPresenceGuid",
    "0F69F6D7-0E4B-43A6-BFC2-6871694369B0": "WdtAppPei",
    "0F729F33-25C1-41A7-86B2-23A737A91823": "IntelSnbGopVbt",
    "0F7EC77A-1EE1-400F-A99D-7CBD1FEB181E": "PcatPciRootBridge",
    "0F886E75-3029-4ECF-B694-22894D3F2143": "PLEDDXE",
    "0F99E33C-CA0C-4AA2-887D-B57EC9050278": "SaveMemoryConfig",
    "0F9D89E8-9259-4F76-A5AF-0C89E34023DF": "EfiFirmwareContentsSignedGuid",
    "0FAAECB1-226E-4782-AACE-7DB9BCBF4DAF": "EfiFtp4ServiceBindingProtocolGuid",
    "0FAD5644-7BDF-4A75-B568-287AE2EBD3A6": "SmcSwSmiFlashSmm",
    "0FB7C852-ADCA-4853-8D0F-FBA71B1CE11A": "EfiFormBrowserCompatibilityProtocolGuid",
    "0FC9013A-0568-4BA9-9B7E-C9C390A6609B": "EfiLegacyRegionProtocolGuid",
    "0FD96974-23AA-4CDC-B9CB-98D17750322A": "EfiHiiStringProtocolGuid",
    "0FDB764B-E669-4C69-83AC-5EDD99A2711E": "ReadOnlyVariableOnReadOnlyVariable2Thunk",
    "0FE9DA53-043D-4265-A94D-FD77FEDE2EB4": "TcgPlatformSetupPeiPolicy",
    "0FFBCE19-324C-4690-A009-98C6AE2EB186": "RecoveryOnFatUsbDiskGuid",
    "100C2CFA-B586-4198-9B4C-1683D195B1DA": "MMC",
    "1015EA63-7421-417D-BB51-E5193061C551": "DxeIpmiUsb",
    "102287B4-6B12-4D41-91E1-EBEE1F3AA614": "UefiDebugLibDebugPortProtocol",
    "1051EC65-F6FC-41EA-BA51-344C37F60CDF": "BoardConfigInitPreMem",
    "105FF0EA-A0C0-48A8-B8F7-E8B4D62A1019": "FmpAuthenticationLibRsa2048Sha256",
    "106A2FD5-11FF-42EA-AFBA-B4969A702616": "BaseOobLibrary",
    "106C877F-C2BA-4C46-876C-BDFE6171CD7E": "DebugCommunicationLibUsb3Pei",
    "106F3545-B788-4CB5-9D2A-CE0CDB208DF5": "EfiHiiThunkProducerGuid",
    "107A772B-D5E1-11D4-9A46-0090273FC14D": "EfiDriverConfigurationProtocolGuid",
    "107A772C-D5E1-11D4-9A46-0090273FC14D": "EfiComponentNameProtocolGuid",
    "10952220-AA32-11DF-A438-0002A5D5C51B": "PL35xSmc",
    "10B12ADD-F5E2-CC78-5CA0-B77F76223ACD": "AmiCpuFeaturesDxe",
    "10BA6BBE-A97E-41C3-9A07-607AD9BD60E5": "EfiVlv2VariableGuid",
    "10C22623-DB6F-4721-AA30-4C12AF4230A7": "IdeRecovery",
    "10C22623-DB6F-4721-AA30-9C12AF4230F8": "ExtRecovery",
    "10E26DF1-8775-4EE1-B50A-3AE82893703A": "SeCfTPMPpiGuid",
    "10EE5462-B207-4A4F-ABD8-CB522ECAA3A4": "Udp4Dxe",
    "10EE54AE-B207-4A4F-ABD8-CB522ECAA3A4": "Udp6Dxe",
    "113B2126-FC8A-11E3-BD6C-B8E8562CBAFA": "EfiBootManagerPolicyConnectAllGuid",
    "114B7105-6CC9-453C-BADC-16DF227BB4EF": "TrEESmm",
    "114DA5EF-2CF1-4E12-9BBB-C470B55205D9": "EfiAdapterInfoSanMacAddressGuid",
    "11527125-78B2-4D3E-A0DF-41E75C221F5A": "CpuS3",
    "1156EFC6-EA32-4396-B5D5-26932E83C313": "EfiSpiProtocolGuid",
    "116E1ACF-2533-4CC2-820A-BBC10A2AB07C": "CpuSpSmi",
    "11777581-2B67-4075-8EB4-F691A47ECEC7": "ProcMemInit",
    "1188F1FC-06E9-49B8-A615-F5A0886FCF89": "UhciInitPei",
    "1191BBF5-DCB9-44F4-827E-95359744C987": "PlatformStage2Pei",
    "11A6EDF6-A9BE-426D-A6CC-B22FE51D9224": "PciHotPlugInitDxe",
    "11B34006-D85B-4D0A-A290-D5A571310EF7": "PcdProtocolGuid",
    "11D8AC35-FB8A-44D1-8D09-0B5606D321B9": "DSDT",
    "11D92DFB-3CA9-4F93-BA2E-4780ED3E03B5": "VirtioBlkDxe",
    "11FBFDFB-10D2-43E6-B5B1-B4386EDCCB9A": "EfiSeCRcInfoProtocolGuid",
    "1206F7CA-A475-4624-A83E-E6FC9BB38E49": "SmmControl2Dxe",
    "1216BD2A-C05E-4C6D-91E7-EB8E37AD3B7A": "aDefaultDXE",
    "12345678-930A-4A95-AB04-2E6CFDFF6631": "TcgPeiAftermem",
    "1259F60D-B754-468E-A789-4DB85D55E87E": "EfiSwapAddressRangeProtocolGuid",
    "125F2DE1-FB85-440C-A54C-4D99358A8D38": "EfiAcpiS3SaveProtocolGuid",
    "127C1C4E-9135-46E3-B006-F9808B0559A5": "Slp20Markers",
    "128FB770-5E79-4176-9E51-9BB268A17DD1": "PciHostBridgeDxe",
    "129F6AA7-AB69-4CB8-AED1-40985001115E": "SerialMuxControl",
    "12AEDBEA-392D-4E2A-8789-5F6DC6B23661": "OemBadgingSupportDxe",
    "12C67BE1-AD2E-4F13-A95F-6EDC2C4392DE": "MePolicyInitPei",
    "12D1D3A2-99F7-420B-BC69-8BB1D492A355": "Logoid",
    "12E2306C-1EBD-3140-B92E-EFA9099E82D2": "CacheManager",
    "12F38E73-B34D-4559-99E5-AE2DCD002156": "BaseFspWrapperPlatformLibSample",
    "12F75401-5415-4FF3-A981-A39BEE9F369E": "SerialRecovery",
    "130B8BA5-E63E-44A0-85DB-4D4E571C526A": "IioCfgUpdateDxeNeonCityEPECB",
    "1310BA34-D7B4-4A80-A645-8C0417C6AA55": "AmiMemoryInfoConfig",
    "1314216C-CB8D-421C-B854-06231386E642": "PlatformInfoDxe",
    "1317F0D5-7842-475C-B1CA-6EDC20DCBE7D": "HashLibTpm2",
    "131AAC21-2145-49E6-A3E1-A97BCE090020": "AcpiSpcr",
    "1323C7F8-DAD5-4126-A54B-7A05FBF41515": "SmmAccess",
    "132EC73B-3025-4FBF-B193-8ACB50EFBD89": "QFlash",
    "132EC73B-BD26-4FBF-B193-8ACB50EFBD89": "UserDefSetupDxe",
    "1353DE63-B74A-4BEF-80FD-2C5CFA83040B": "GifDecoderDxe",
    "136A3048-752A-4BF6-A757-0936119538ED": "UiStringPackGuid",
    "137B3044-F6D7-473E-A625-9FB92505C180": "EfiSpiBusProtocolGuid",
    "1388066E-3A57-4EFA-98F3-C12F3A958A29": "EfiPeiSecurityPpiGuid",
    "1390954D-DA95-4227-9328-7282C217DAA8": "EfiSmmBaseProtocolGuid",
    "13A3F0F6-264A-3EF0-F2E0-DEC512342F34": "EfiPcdProtocolGuid",
    "13AC6DD0-73D0-11D4-B06B-00AA00BD6DE7": "EbcDxe",
    "13AC6DD1-73D0-11D4-B06B-00AA00BD6DE7": "EfiEbcProtocolGuid",
    "13B00AAE-4FD2-964E-B30F-94627017370A": "BmpConvert",
    "13C5506E-8231-415E-9EBC-88DD115E3818": "SmbiosElog",
    "13ECD928-87AB-4460-BBE0-B520F9EB1D32": "IconNetBoot",
    "13F4EA8E-BFF1-43BF-8F44-80BCC96040F1": "FpgaDxe",
    "13FA7698-C831-49C7-87EA-8F43FCC25196": "EfiEventVirtualAddressChangeGuid",
    "1400F9E6-4BAB-4B68-A53F-58FD240818E6": "Reset_Modify",
    "14045170-CA65-47BC-9C15-2DE36D44AEE9": "SmcInBandDxe",
    "140E8004-16E1-4DE1-A352-C6EF51110ECF": "ArmSmcLibNull",
    "1410C6AC-9F4B-495B-9C23-8A5AEB0165E9": "SmmSwDispatch2OnSmmSwDispatchThunk",
    "142204E2-C7B1-4AF9-A729-923758D96D03": "AmiLegx16Bin",
    "14257B56-BDA2-4FAF-8E4F-C885DF75583C": "IccPlatform",
    "143B7632-B81B-4CB7-ABD3-B625A5B9BFFE": "EfiExtScsiPassThruProtocolGuid",
    "1448C340-0202-4711-9C4B-2D063AA6475B": "ProgressBarEmptyLeftEndcap",
    "145372BC-66B9-476D-81BC-2127C376BB66": "FFS.pad",
    "145971E9-AD52-4094-A8C8-BE5B3FECC82D": "CpuPeim",
    "14610837-4E97-4427-96E0-21D9B2956996": "EsalVariableDxeSal",
    "1484EBE8-2681-45F1-A2E5-12ECAD893B62": "ArmJunoDxe",
    "14982A4F-B0ED-45B8-A811-5A7A9BC232DF": "EfiHiiKeyBoardLayoutGuid",
    "14A7C46F-BC02-4047-9F18-A5D725D8BD19": "EfiDFUResultGuid",
    "14BB6DA5-0C47-4F2C-9348-8DC272619998": "VmwSvgaDxe",
    "14F95E01-D562-432E-844A-95A43905107E": "GuidBase",
    "14FC52BE-01DC-426C-91AE-A23C3E220AE8": "EfiSmmSxDispatchProtocolGuid",
    "14FF38A8-ACBA-4228-A7D7-A73260C7559B": "PiSmmStatusCodeOnFrameworkSmmStatusCodeThunk",
    "151C8EAE-7F2C-472C-9E54-9828194F6A88": "EfiDiskIo2ProtocolGuid",
    "15344673-D365-4BE2-8513-1497CC07611D": "PchPlatformPolicyPpiGuid",
    "1547B4F3-3E8A-4FEF-81C8-328ED647AB1A": "Csm16",
    "154CAB4A-52B5-46CD-99C3-4368ABBACFFD": "MetronomeDxe",
    "1551A247-BB31-4393-8BB4-10509AE2F18F": "ChargeLedDebugPei",
    "1555ACF3-BD07-4685-B668-A86945A4124D": "CpuPeiBeforeMem",
    "157C666C-7C74-4E4A-B639-7BBA21487CE1": "QFanDXE",
    "15853D7C-3DDF-43E0-A1CB-EBF85B8F872C": "EfiDeferredImageLoadProtocolGuid",
    "158DC712-F15A-44DC-93BB-1675045BE066": "HashLibBaseCryptoRouterDxe",
    "158DEF5A-F656-419C-B027-7A3192C079D2": "ShellVariableGuid",
    "15B9B6DA-00A9-4DE7-B8E8-ED7AFB88F16E": "CpuPolicyInitDxe",
    "15C5E761-58D8-461A-9173-CAB020916264": "VgaMiniPort",
    "15CCACBE-2A4A-45ED-9EC2-53135F98AB24": "BmcAcpi",
    "15FE2940-B426-479A-A002-5454A34C7A6E": "FlashMapBin",
    "1601E050-BE0C-41B7-8F96-9F48F72B7E26": "OnboardControllerCtrl",
    "16036A73-E8EF-46D0-953C-9B8E96527D13": "Reset",
    "1612CCDF-2549-466A-BF6F-D06DAAE60958": "AppleKeyMapAggregator",
    "161BE597-E9C5-49DB-AE50-C462AB54EEDA": "PowerManagementAcpiTables2",
    "16271FCA-55D9-4A33-93FC-5A3EB128DE21": "MiscSubclassDxe",
    "16271FCA-55D9-4A33-93FC-5A3EB128DEB6": "CRBDxe",
    "166C533A-8F1E-4D34-A60E-0F68D8D61308": "OemKey",
    "1682FE44-BD7A-4407-B7C7-DCA37CA3922D": "EfiTlsConfigurationProtocolGuid",
    "168D1A6E-F4A5-448A-9E95-795661BB3067": "ArmPciCpuIo2Dxe",
    "16958446-19B7-480B-B047-7485AD3F716D": "FdtHobGuid",
    "16A4ADD0-EF11-4C86-B159-88A2A8C4501C": "wifi_3bars",
    "16AD4FE0-B5B1-11DF-8CBF-0002A5D5C51B": "PL310L2Cache",
    "16B45DA2-7D70-4AEA-A58D-760E9ECB841D": "FD_Drv_X86",
    "16C58600-554B-4587-8C62-A40997CFE206": "ASRockNetSmtpBin",
    "16C8A6D0-FE8A-4082-A208-CF89C4290433": "UefiSystemTableInfoGuid",
    "16D0A23E-C09C-407D-A14A-AD058FDD0CA1": "ACPI",
    "16DBCD0A-ED77-442C-A4AB-3DCADE378A1C": "ThunderboltNhi",
    "17088572-377F-44EF-8F4E-B09FFF46A070": "Microcode",
    "170E13C0-BF1B-4218-871D-2ABDC6F887BC": "EfiOEMBadgingProtocolGuid",
    "171E9188-31D3-40F5-B10C-539B2DB940CD": "EfiShellPkgTokenSpaceGuid",
    "171F43DC-C4D9-47A6-9641-65DDCDD5AA30": "UsbRtDxe",
    "174CF46D-B167-4E6A-B1CD-D41E24EFA0F9": "ASUSBackupSmm",
    "17689034-F11B-468B-8CC4-E114C77F41B1": "AsusPTTDxe",
    "17772369-D262-4B90-9F31-BDC41F2663A5": "mebx_main",
    "177B2C74-9674-45F4-AAEB-43F5506AE0FE": "ASUSPOSTMessage",
    "17851FBF-45C4-4FF7-A2A0-C3B12D63C27E": "SdBlockIoPei",
    "17985E6F-E778-4D94-AEFA-C5DD2B77E186": "QemuFwCfgAcpiPlatform",
    "17A0A3D7-C0A5-4635-BBD5-072187DFE2EE": "EmbeddedGpioProtocolGuid",
    "17D09362-326C-4920-A50C-76F8A116A093": "SeCPolicyInitDxe",
    "17EE496A-D8E4-4B9A-94D1-CE8272300850": "EfiPeiBootInRecoveryModePpiGuid",
    "180636A5-871B-496D-B8F3-E83EF196D100": "menu_top_right",
    "1807040D-5934-41A2-A088-8E0F777F71AB": "NvramDxe",
    "1810AB4A-2314-4DF6-81EB-67C6EC058591": "BootScriptTableBaseGuid",
    "18435CD7-8003-4CED-AFA4-ECBC440C0F30": "FwBlockServiceDxe",
    "18A031AB-B443-4D1A-A5C0-0C09261E9F71": "EfiDriverBindingProtocolGuid",
    "18A3C6DC-5EEA-48C8-A1C1-B53389F98999": "EfiSmmSwDispatch2ProtocolGuid",
    "18EF8946-68F5-49E6-B202-CE90C3EEF1C9": "IchSmmDispatcherDxe",
    "196CA3D8-9A5A-4735-B328-8FFC1D93D188": "TcgPlatformSetupPolicy",
    "197DB236-F856-4924-90F8-CDF12FB875F3": "Microcode",
    "1988A1D8-04FC-4D68-B58D-636F36F30D82": "SoftStrapsPeim",
    "199C1EF0-6400-41C5-B0A4-FFBF219DCBAE": "QuarkPlatformTokenSpaceGuid",
    "199FD111-0785-4132-A9B3-1F66573F0060": "GenericComponentsSmm",
    "19A84692-4AAD-C04B-90E9-E017360A9860": "DiskImage",
    "19CB87AB-2CB9-4665-8360-DDCF6054F79D": "EfiPciHotPlugRequestProtocolGuid",
    "19D17940-BA8D-4FA7-A704-F33D9FAFAB9D": "LibStringlist",
    "19DBBDC1-DEDF-4DED-8684-2476B99FAC91": "AST2500DxeInit",
    "19DF145A-B1D4-453F-8507-38816676D7F6": "AtaBusDxe",
    "19E3BBBA-BEB1-43E8-B32D-9ACBB22C7639": "BasePostCodeLibDebug",
    "1A10742F-FA80-4B79-9DA6-357058CC397B": "ArrowCursor",
    "1A1241E6-8F19-41A9-BC0E-E8EF39E06546": "EfiHiiImageExProtocolGuid",
    "1A1E4886-9517-440E-9FDE-3BE44CEE2136": "CpuDxe",
    "1A345BC0-CC35-9ABC-1CEA-1CAD7D33ADDF": "SmcLsiRaidOOBSetup",
    "1A3558EC-13BB-4451-A589-74DFBD9A27AD": "LidPoller",
    "1A36E4E7-FAB6-476A-8E75-695A0576FDD7": "EfiPeiDecompressPpiGuid",
    "1A481E8E-342F-40AA-AF31-F4FB7C99D428": "AmtInt16",
    "1A6853C8-F362-4F68-A77E-0B304A194C05": "UseSocketDxe",
    "1A7E4468-2F55-4A56-903C-01265EB7622B": "TcpDxe",
    "1A819E49-D8EE-48CB-9A9C-0AA0D2810A38": "DxePchPolicyUpdateProtocolGuid",
    "1A8E9D96-66E6-461B-95D6-882C984D0B00": "TbtPei",
    "1A931FB8-C466-454A-B684-73ADA2CB050B": "ASUSPOSTMessagePEI",
    "1AA6D900-89D1-4C21-9C50-EDC7390A67C3": "SlotDataUpdateDxeNeonCityFPGA",
    "1ACED566-76ED-4218-BC81-767F1F977A89": "1",
    "1B0FB9BF-699D-4FDD-A7C3-2546681BF63B": "EfiWiFi2ProtocolGuid",
    "1B1183FA-1823-46A7-8872-9C578755409D": "EfiSmmPowerButtonDispatch2ProtocolGuid",
    "1B2C4952-D778-4B64-BDA1-15A36F5FA545": "Slp20PubKey",
    "1B45CC0A-156A-428A-AF62-49864DA0E6E6": "AprioriPei",
    "1B59CCDA-7DB2-4A55-AFC2-4364F824D288": "McBankErrorInjection",
    "1B6E9D50-12E4-4B55-81D9-1ABFEC59D4FC": "WakeupCtrlSmm",
    "1BA0062E-C779-4582-8566-336AE8F78F09": "Volume Top File",
    "1BB737EF-427A-4144-8B3B-B76EF38515E6": "SdMmcPciHcPei",
    "1BE65202-9318-492D-A551-08DF2BD60AEE": "AmtPlatformPolicy",
    "1BF06AEA-5BEC-4A8D-9576-749B09562D30": "ProcessorProducerGuid",
    "1BFC532E-F48A-4EBE-B2FB-2B286D70A6EB": "IconUsbHD",
    "1C0C34F6-D380-41FA-A049-8AD06C1A66AA": "EfiEdidDiscoveredProtocolGuid",
    "1C178237-6897-459E-9D36-67CE8EF94F76": "EfiKmsFormatMd5sha128Guid",
    "1C58AAC6-76C9-D94D-A14C-0059E13B96A3": "AppleMtftp4Dxe",
    "1C6B2FAF-D8BD-44D1-A91E-7321B4C2F3D1": "ScriptSaveDxe",
    "1C8B7F78-1699-40E6-AF33-9B995D16B043": "PiSmmCommunicationPei",
    "1C98780A-C67D-4D9B-A9D8-4AC0487A6D6E": "PcdRecoveryPei",
    "1CE12314-AFBC-11F0-8A3E-AB44B8EE3120": "PpmPolicyInitDxe",
    "1CF3F8B3-C5B1-49A2-AA59-5EEF92FFA63C": "EfiIa32X64ErrorTypeBusCheckGuid",
    "1CF40D19-EEAD-4C73-93DB-BBB8B6ACF929": "UserIdentificationDxe",
    "1D000AE9-756B-4937-B736-1F3D96A5A8F0": "Dptf",
    "1D0CFB9B-EB00-43A6-819C-D218DF8DC4B4": "BootMode",
    "1D202CAB-C8AB-4D5C-94F7-3CFCC0D3D335": "EfiSmmCpuServiceProtocolGuid",
    "1D292105-2653-11E5-B46F-B8E8562CBAFA": "AppleCapsuleRuntimeDxe",
    "1D3DE7F0-0807-424F-AA69-11A54E19A46F": "EfiExtScsiPassThruProtocolGuid",
    "1D3E9CB8-43AF-490B-830A-3516AA532047": "EdkiiFaultTolerantWriteGuid",
    "1D57B5D5-BAB4-4D2B-B7EB-0EB41D7B189C": "LibGlob",
    "1D6F730F-5A55-4078-869B-E0A18324BDC8": "TemplateSec",
    "1D85CD7F-F43D-11D2-9A0C-0090273FC14D": "EfiUnicodeCollationProtocolGuid",
    "1D88C542-9DF7-424A-AA90-02B61F286938": "WdtPei",
    "1DA353A3-6400-4241-9AB0-E3E65C690EF7": "IchSmbusArpDisabled",
    "1DA97072-BDDC-4B30-99F1-72A0B56FFF2A": "EfiMonotonicCounterArchProtocolGuid",
    "1DACE8EE-CD97-491E-8A0C-305D6437323C": "OnBrdDevDXE",
    "1DB29AE0-9DCB-43BC-8D87-5DA14964DDE2": "EfiUserInfoAccessSetupNormalGuid",
    "1DB43EC9-DF5F-4CF5-AAF0-0E85DB4E149A": "BootGuardDxe",
    "1DCFF17C-AA53-4B78-B234-864027555035": "LibUefi",
    "1DD1D619-F9B8-463E-8681-D1DC7C07B72C": "EdkiiNonDiscoverableSdhciDeviceGuid",
    "1DDBFD6A-3423-462F-9150-A7FFA66FF0CA": "StaticSkuDataDxeLightningRidgeEXRP",
    "1DE0B8C2-FFB6-4BDF-97F5-0FFB33979038": "BaseReportStatusCodeLibNull",
    "1DF18DA0-A18B-11DF-8C3A-0002A5D5C51B": "SataSiI3132",
    "1E2ACC41-E26A-483D-AFC7-A056C34E087B": "EfiPlatformInfoGuid",
    "1E2ED096-30E2-4254-BD89-863BBEF82325": "EfiTcg2FinalEventsTableGuid",
    "1E43298F-3478-41A7-B577-86064635C728": "OptionRomPkgTokenSpaceGuid",
    "1E4EAAB1-E637-443E-A5D6-56E60D97C619": "UsbComboPeimPei",
    "1E5668E2-8481-11D4-BCF1-0080C73C8881": "EfiVariableArchProtocolGuid",
    "1E75E77F-8A15-4653-964D-542C157EF40A": "SgPeiPolicyInit",
    "1E82B556-4EB6-479F-955A-78A5FE0C0CB2": "BroadcomWirelessDxe",
    "1E843AD6-E237-42FC-BDA2-DE78542E16DD": "SstSpiFlash",
    "1E93E633-D65A-459E-AB84-93D9EC266D18": "EfiTapeIoProtocolGuid",
    "1E93F29B-A3B2-F340-A605-DE31EE3DA031": "EdkTerminal",
    "1EA81BEC-F01A-4D98-A201-4A61CE2FC022": "PerformanceExProtocolGuid",
    "1EBE5AB9-2129-49E7-84D7-EEB9FCE5DEDD": "EfiEmmcCardInfoProtocolGuid",
    "1EC0EFC9-C93A-4B62-9B27-C059ABD80E92": "VlvPlatformInitDxe",
    "1EC0F53A-FDE0-4576-8F25-7A1A410F58EB": "StatusCodePei",
    "1EDC318F-4005-488D-AF3A-9BB5179BC6F1": "GmchMbiDxe",
    "1EEA2BFE-01CB-40CC-A34E-CB224C800AA2": "Tpm2DeviceLibSeC",
    "1F18C5B3-29ED-4D9E-A504-6D978E7ED569": "QncS3CodeInLockBoxGuid",
    "1F2CCB4F-D817-404E-98E7-80E4851FB33E": "GdbStub",
    "1F2D63E1-FEBD-4DC7-9CC5-BA2B1CEF9C5B": "FileExploreFormSetGuid",
    "1F36527E-A97C-45F8-B24A-9D95B0A940FE": "AppleBrightnessControl",
    "1F3CDFBE-F7AE-4453-8C48-C1AD35A4FD98": "SmbiosDmiEditProtocol",
    "1F4C6F90-B06B-48D8-A201-BAE5F1CD7D56": "EfiPeiStallPpiGuid",
    "1F73B18D-4630-43C1-A1DE-6F80855D7DA4": "EfiFormBrowserExProtocolGuid",
    "1F77FFD9-C00D-4245-B2AC-F5F43E333C39": "PtuLoader",
    "1F78349D-7FBA-4686-8098-FA017EDA35FB": "ArmShellCmdRunAxf",
    "1FA1F39E-FEFF-4AAE-BD7B-38A070A3B609": "PartitionDxe",
    "1FA4DAFE-FA5D-4D75-BEA6-5863862C520A": "TcgConfigDxe",
    "1FBD2960-4130-41E5-94AC-D2CF037FB37C": "EfiAdapterInfoNetworkBootGuid",
    "1FFF93C2-8C76-49E4-8AB3-43D92F5445EF": "LogoJpg",
    "201A92E1-2D0F-48E9-A3AB-93E1695A92F2": "AppleHDA",
    "202A2922-8C27-4943-9855-26180BF9F113": "VariableInfo",
    "202A2B0E-9A31-4812-B291-8747DF152439": "Ps2MouseDxe",
    "204810E0-4941-4C66-B99A-6BEE4F84453C": "AtherosWiFi",
    "20605BBA-7FB9-4279-959F-8DBF74CDB0C6": "VideoBios",
    "208117F2-25F8-479D-B726-10C10BED6DC1": "AppleLegacyRegion",
    "20830080-CC28-4169-9836-7F42B8D0C8C9": "GraphicsOutputDxe",
    "20B181E2-33E8-4211-B9D7-9B8696764E66": "WheaElog",
    "20D8FFFE-15C3-4EA9-9D28-CFE2745D78F3": "CryptoDxe",
    "21094ECB-9F20-4781-AE4B-50728B389A6E": "IchInit",
    "210DCB72-BC14-4A19-A29B-F696EB7DE12B": "EzSetup",
    "2119BBD7-9432-4F47-B5E2-5C4EA31B6BDC": "DxeIpl",
    "21429B90-5F67-4E93-AF55-1D314D646E12": "MemoryProfileInfo",
    "2145F72F-E6F1-4440-A828-59DC9AAB5F89": "EmmcDxe",
    "215FDD18-BD50-4FEB-890B-58CA0B4739E9": "EfiSioProtocolGuid",
    "2167F964-7298-4A8F-9A2A-BFE498D600A8": "HddReadySmi",
    "21891A9E-763E-4377-8841-8D5C90D88C51": "NetworkStackSetupScreen",
    "21A05FD5-DB4A-4CFC-B84B-EB0DBB569934": "IconGenericCD",
    "21ADC483-021F-4F3B-8DCE-613CC981A269": "menu_dots_selected",
    "21AF95E1-371F-4712-9C07-798E3CB019E4": "LockSMRAMEntryDxe",
    "21CCF0B7-246B-412C-A334-0B65A07B28DF": "SmmBaseOnSmmBase2Thunk",
    "21E34727-3881-4DEE-8020-D8908A980311": "EpuHwModeDxe",
    "21F302AD-6E94-471B-84BC-B14800403A1D": "EfiSmmCpuSaveStateProtocolGuid",
    "21FF1FEE-D33A-4FCE-A65E-955EA3C41F40": "QNCMemoryInitPpiGuid",
    "22046D50-F390-498C-92E5-5BA4F8E7F8B6": "SBSATAIDE",
    "220E73B6-6BDB-4413-8405-B974B108619A": "EfiFirmwareVolume2ProtocolGuid",
    "221521AE-0A35-44CD-B580-5AEDBB770B1D": "glyphs",
    "22198FD5-4835-4842-BF31-EB957C7DD70D": "GetNetByAddr",
    "221F1D4F-034C-4BEA-B2BB-B7A9672B06D7": "CRBSMI",
    "222C386D-5ABC-4FB4-B124-FBB82488ACF4": "PlatformPei",
    "224FBFE4-ADB6-4DF2-B835-602182AEEF20": "Clock",
    "22597239-6107-DF44-AD3F-5F053E92222E": "EmuSnpDxe",
    "228F344D-B3DE-43BB-A4D7-EA200B1B1482": "EfiSmMonitorInitProtocolGuid",
    "229832D3-7A30-4B36-B827-F40CB7D45436": "EfiPeiStatusCodePpiGuid",
    "22B194B4-CC0E-46C7-9FCE-DA10D6ED1731": "PchSmbusArpEnabled",
    "22BDEE84-C807-452E-B56E-F683FD76C989": "BuslogicDxe",
    "22DC2B60-FE40-42AC-B01F-3AB1FAD9AAD8": "EmuVariableFvbRuntimeDxe",
    "22EA234F-E72A-11E4-91F9-28D2447C4829": "HttpUtilitiesDxe",
    "233C2592-1CEC-494A-A097-15DC96379777": "FwVolDxe",
    "2342CA44-3B35-4A34-995B-CEDEEB1A9576": "Intel945Uga",
    "2354D320-3EB3-4C81-99F4-CC4AE143463E": "EfiEdkCompatibilityPkgTokenSpaceGuid",
    "2366C20F-E15A-11E3-8BF1-E4115B28BC50": "HttpDxe",
    "2374EDDF-F203-4FC0-A20E-61BAD73089D6": "IoTrap",
    "2383608E-C6D0-4E3E-858D-45DFAC3543D5": "PciHostBridgeDxe",
    "23A089B3-EED5-4AC5-B2AB-43E3298C2343": "VariableSmm",
    "23A464AD-CB83-48B8-94AB-1A6FEFCFE522": "EfiSioPpiGuid",
    "23D1280D-43F0-4713-90B2-0E5E4221AF4C": "BatteryState1",
    "23EED05D-1B93-4A1A-8E1B-931D69E37952": "Omap35xxBoardInterruptDxe",
    "240612B5-A063-11D4-9A3A-0090273FC14D": "IsaBusDxe",
    "240612B5-A063-11D4-9A3A-0090273FC18E": "SmmCoreDispatcher",
    "240612B7-A063-11D4-9A3A-0090273FC14D": "UsbBusDxe",
    "24169E35-2454-4940-92BC-82321A2C7562": "VlvInitPeim",
    "24486226-F8C2-41F5-B9DD-783E9E56DEA0": "EfiMmioDeviceProtocolGuid",
    "245DCA21-FB7B-11D3-8F01-00A0C969723B": "EfiPxeBaseCodeCallbackProtocolGuid",
    "2480271C-09C6-4F36-AD75-5E1390BD9929": "QNCSmmDispatcher",
    "2486829B-D3F3-47EC-827A-FC104907FC5C": "SmmGenericSio",
    "24A2D66F-EEDD-4086-9042-F26E4797EE69": "RootBridgesConnectedEventGroupGuid",
    "24A44CAF-0BF2-4514-90C4-C794B3E778F5": "MePolicyInitDxe",
    "24B09ABE-4E47-481C-A9AD-CEF12C392327": "Omap35xxTokenSpaceGuid",
    "24C5DC2F-53E2-40CA-9ED6-A5D9A49F463B": "EfiHashAlgorithmSha1NoPadGuid",
    "24C6F3E2-6ACD-436B-A604-56A5CF742A55": "BaseFspPlatformInfoLibSample",
    "24CCD374-3DF6-4181-86F6-E3C66920A145": "UpdateMemoryRecord",
    "24E70042-D5C5-4260-8C39-0AD3AA32E93D": "EfiSmmEndOfDxeProtocolGuid",
    "24E9A512-3A25-4CBA-A0AE-67C053BDF3B6": "DxeVideoTextOut",
    "253E85E9-993B-439B-B74C-6120F77B4723": "PlatformReset",
    "254901AD-7DB7-45F8-93C8-93D579398D9F": "PeiPciSegmentLibPciCfg2",
    "25566B03-B577-4CBF-958C-ED663EA24380": "EfiSmmGpiDispatch2ProtocolGuid",
    "25A4FD4A-9703-4BA9-A190-B7C84EFB3E57": "FdtVariableGuid",
    "25ACF158-DD61-4E64-9A49-55851E9A26C7": "CsmBlockIo",
    "25F200AA-D3CB-470A-BF51-E7D162D22E6F": "ShellDebug1HiiGuid",
    "25F49067-A65B-48F5-BBBE-35418C488836": "TcgDxeMainDxe",
    "263631D7-5836-4B74-BE48-EE22E92CE5D3": "WinNtConsoleDxe",
    "26452F27-45DE-4A94-807A-0E6FDC1CB962": "EmuPeiGateDxe",
    "26841BDE-920A-4E7A-9FBE-637F477143A6": "Ip4ConfigDxe",
    "2686340E-665C-427F-8819-05BA54F030F5": "IdeController2",
    "2688B232-9C02-4C12-BE1F-857C0FF2AAE3": "TcgDxeplatform",
    "268F33A9-CCCD-48BE-8817-86053AC32ED6": "PeiSmmAccessPpiGuid",
    "26A2481E-4424-46A2-9943-CC4039EAD8F8": "S3Save",
    "26BACCB1-6F42-11D4-BCE7-0080C73C8881": "EfiCpuArchProtocolGuid",
    "26BACCB2-6F42-11D4-BCE7-0080C73C8881": "EfiMetronomeArchProtocolGuid",
    "26BACCB3-6F42-11D4-BCE7-0080C73C8881": "EfiTimerArchProtocolGuid",
    "26C628F2-CED5-466C-8237-433CA4D24241": "MemoryEvContent",
    "26CC0FAD-BEB3-478A-91B2-0C188F726198": "EfiPeiVirtualBlockIo2PpiGuid",
    "26EEB3DE-B689-492E-80F0-BE8BD7DA4BA7": "EfiSmmConfigurationProtocolGuid",
    "26FDEB7E-B8AF-4CCF-AA97-02633CE48CA7": "EfiProcessorSubClassGuid",
    "2700F72F-E0EA-4767-9A1E-D172F0704778": "PeiSelStatusCode",
    "2707E46D-DBD7-41C2-9C04-C9FDB8BAD86C": "JpegDecoderDxe",
    "271B424E-A4CC-4E0E-90A2-7EA4841F12F3": "ExportHiiDb",
    "271DD6F2-54CB-45E6-8585-8C923C1AC706": "PchS3Peim",
    "271F1343-20D6-4E14-9B62-3C0297F56F07": "SmmPowerManagement",
    "274F0C8F-9E57-41D8-9966-29CCD48D31C2": "SmmAccess",
    "2755590C-6F3C-42FA-9EA4-A3BA543CDA25": "EfiDebugSupportProtocolGuid",
    "27ABF055-B1B8-4C26-8048-748F37BAA2DF": "EfiEventExitBootServicesGuid",
    "27BEDA18-AE2B-43C2-AF6B-74952441DE28": "MonitorKeyDxe",
    "27CFAC87-46CC-11D4-9A38-0090273FC14D": "EfiRealTimeClockArchProtocolGuid",
    "27CFAC88-46CC-11D4-9A38-0090273FC14D": "EfiResetArchProtocolGuid",
    "27E569D5-0AFC-4D8F-8C90-783AC4A318AB": "SaAcpiTables",
    "27F05AF5-1644-4EF4-8944-48C4F75675A0": "RealTimeClockDxe",
    "27F4917B-A707-4AAD-9676-26DF168CBF0D": "PchSpiSmm",
    "283FA2EE-532C-484D-9383-9F93B36F0B7E": "EfiUpdateDataFileGuid",
    "286BF25A-C2C3-408C-B3B4-25E6758B7317": "EfiTpmDeviceInstanceTpm20DtpmGuid",
    "2890B3EA-053D-1643-AD0C-D64808DA3FF1": "HardwareInterruptProtocolGuid",
    "2894EC46-C67A-4256-87DE-34A741D85982": "MctPei",
    "2899C94A-1FB6-4B1A-B96B-8364975303E0": "Ps2MouseAbsolutePointerDxe",
    "28A03FF4-12B3-4305-A417-BB1A4F94081E": "RamDiskDxe",
    "28A88A39-DD84-483F-9BEF-BA1168C2F850": "UbaInitPei",
    "28BDE99C-E8A7-4E3E-9A8A-E66CD64F31C6": "BasePciLibCf8",
    "2906CC1F-09CA-4457-9A4F-C212C545D3D3": "AppleEpidGroupPublicKeysRl",
    "290B026F-6905-4612-BA0F-F635DDE35285": "ErrorTriangle",
    "290EA249-6E88-423C-B0DA-75CDDE7920CC": "AmtPetAlert",
    "29142FB2-26D9-4C3A-A4BA-7BBD0364EEAE": "BaseSmbusLibNull",
    "291A3B75-C685-475E-876B-2E40A6A7E18A": "SetTimerPeriodDxe",
    "29206FC2-9EAB-4612-ACA1-1E3D098FB1B3": "LegacyVideoRom",
    "2928D39C-917D-4F2F-9510-16AB73F204B2": "BiosAcm_Field",
    "294B196A-A3CC-4A43-857F-EEC26147857B": "Tpm2DeviceLibSeC",
    "294B1CEF-9BEB-42D5-9971-0C8963CDAF02": "SmLogo",
    "296EB418-C4C8-4E05-AB59-39E8AF56F00A": "EdkiiSmmExitBootServicesProtocolGuid",
    "2977064F-AB96-4FA9-8545-F9C40251E07F": "EfiPlatformPolicyProtocolGuid",
    "299141BB-211A-48A5-92C0-6F9A0A3A006E": "PowerManagementAcpiTables2",
    "29926D4A-E531-490C-A529-C05E8A1D60D3": "FwhFlashLibNull",
    "299D6F8B-2EC9-4E40-9EC6-DDAA7EBF5FD9": "SiInit",
    "29B3C4C6-E5AA-49E4-8CE0-2772F782DDC2": "WinNtGopDxe",
    "29BE380A-FBC0-462B-A6C2-5C5A076CAFDE": "ProjectPEI",
    "29CBB005-C972-49F3-960F-292E2202CECD": "FspNotifyPhasePeim",
    "29CF55F8-B675-4F5D-8F2F-B87A3ECFD063": "CsmVideo",
    "29D8DD19-C836-45D9-8F05-322C27129C2A": "SecureVariable",
    "29E0564F-B702-4352-A3A1-15FABD4A4E4A": "IioCfgUpdateDxeLightningRidgeEXECB3",
    "29E3DB8C-3B30-49D7-9262-53FB917B9A6B": "BochsVga",
    "2A1E1C92-AABA-4D62-AC40-F3A4C3387356": "PeiSmbusLibSmbus2Ppi",
    "2A205AA9-F7EA-47BE-B3BD-7631E99B4351": "G3WakeupPei",
    "2A32CCEA-5D78-46D7-BAED-8E53A1B31357": "AcpiPlatformDxe",
    "2A3CFEBD-27E8-4D0A-8B79-D688C2A3E1C0": "EfiSmmLockBoxCommunicationGuid",
    "2A43BA5F-AC29-4FDC-8A3B-0328D0256F8C": "SocketDxe",
    "2A46715F-3581-4A55-8E73-2B769AAA30C5": "RamDiskFormSetGuid",
    "2A4D1ADF-21DC-4B81-A42F-8B8EE2380060": "EfiSmartCardReaderProtocolGuid",
    "2A500CFB-920E-49F4-9988-5CE4C0EFD3AB": "SmbiosDmiEditAfriSmi",
    "2A534210-9280-41D8-AE79-CADA01A2B127": "EfiDriverHealthProtocolGuid",
    "2A571201-4966-47F6-8B86-F31E41F32F10": "EfiEventLegacyBootGuid",
    "2A591128-6CC7-42B1-8AF0-58933B682DBB": "EfiExtendedSalMcaServicesProtocolGuid",
    "2A72D11E-7376-40F6-9C68-23FA2FE363F1": "EfiEbcSimpleDebuggerProtocolGuid",
    "2A7946E3-1AB2-49A9-ACCB-C6275139C1A5": "TrEEDxe",
    "2A9D5E7F-A43A-4FC7-A25E-6E28D412FA6F": "efi_pop_RT",
    "2AB86EF5-ECB5-4134-B556-3854CA1FE1B4": "EfiPeiReadOnlyVariable2PpiGuid",
    "2AD0FC59-2314-4BF3-8633-13FA22A624A0": "PlatformPei",
    "2AD511C7-1B60-4002-841D-2998DDC138EE": "CryptoSMM",
    "2ADB8F5B-C7D4-4E7E-BE2A-23634DF668A1": "MouseDriver",
    "2AE9D80F-3FB2-4095-B7B1-E93157B946B6": "EfiHashAlgorithmSha1Guid",
    "2B0585EB-D8B8-49A9-8B8C-E21B01AEF2B7": "AppleLegacyLoad",
    "2B1D0832-2184-4C8F-A90D-8E4AF9DE5BCD": "BootModePeim",
    "2B2F68D6-0CD2-44CF-8E8B-BBA20B1B5B75": "EfiUsbIoProtocolGuid",
    "2B341C7B-0B32-4A65-9D46-E1B3ABD4C25C": "Smbios131",
    "2B3685C5-CF90-4A67-8A48-9134BA32D677": "PlatformStage1Pei",
    "2B4034AE-8566-412F-9CA5-67FD698FC261": "TcoSmi",
    "2B73B074-2E67-498B-82AC-CE38FB770FFC": "DxeSalLibEsal",
    "2B8A4061-9131-4D2A-A20B-D845D0EB1D83": "Smbrun",
    "2B9FFB52-1B13-416F-A87B-BC930DEF92A8": "TcgEventEntryHobGuid",
    "2BB5AFA9-FF33-417B-8497-CB773C2B93BF": "CpuPei",
    "2BC1C74A-122F-40B2-B223-082B7465225D": "FspWrapperTokenSpaceGuid",
    "2BDED685-F733-455F-A840-43A22B791FB3": "AcpiS3SaveDxe",
    "2BE1E4A6-6505-43B3-9FFC-A3C8330E0432": "TcgPei",
    "2C03C536-4594-4515-9E7A-D3D204FE1363": "EfiFileExplorerProtocolGuid",
    "2C181BE1-8BAC-4433-873C-E5074CB5A723": "UbaConfigDatabasePei",
    "2C29929E-27CF-4DD5-BB97-E5525791F5BA": "DRYDXE",
    "2C6CACC6-6C3C-4AA7-B2DE-384DAE2B0352": "RegAccessPeim",
    "2C8759D5-5C2D-66EF-925F-B66C101957E2": "EfiIp6ProtocolGuid",
    "2C878DFE-F92E-4D00-BCED-146AFE099841": "MemCacheInit",
    "2CA88B53-D296-4080-A4A5-CAD9BAE24B09": "LoadFixedAddressConfigurationTableGuid",
    "2CB4F37A-0026-43AF-A948-D71976A96860": "CpuIoDxe",
    "2CE5604F-A982-4D2E-8FD0-D1600C2E1515": "PciDynamicSetup",
    "2D1E361C-7B3F-4D15-8B1F-66E551FABDC7": "SaLateInitSmm",
    "2D27C618-7DCD-41F5-BB10-21166BE7E143": "BiosAc",
    "2D2E62AA-9ECF-43B7-8219-94E7FC713DFE": "UsbMouseDxe",
    "2D2E62CF-9ECF-43B7-8219-94E7FC713DFE": "UsbKbDxe",
    "2D3F7085-BA63-4739-A15F-C8802B6B807B": "NCT3933Pei",
    "2D408713-4023-4324-B8EA-53C02A83D941": "PeCoffExtraActionLibSmm",
    "2D59F041-53A4-40D0-A6CD-844DC0DFEF17": "SmmS3SaveState",
    "2D61B52A-69EF-497D-8317-5574AEC89BE4": "FirmwarePassword",
    "2D6BB83D-84A2-404A-B4CA-3E7AC0EFB3D2": "BootOptionPolicyDxe",
    "2D6F6BCC-9681-8E42-8579-B57DCD0060F0": "AutoScanPei",
    "2D9BD72A-B238-4BFF-9BB9-B51E0D4D553C": "SlotDataUpdateDxeLightningRidgeEXECB3",
    "2DA064D8-5A52-4DAC-B60F-54471A7FC372": "CspFlashLibNull",
    "2DCBE49A-1E5B-486E-BC23-48156B8282C9": "X11DxeDriver",
    "2DCE8BB1-BDD7-450E-B9AD-9CF4EBD4F890": "EfiEventNotificationTypeCmcGuid",
    "2DDFEDFE-C2D5-43E3-9E10-46DB2C7C1F26": "SmbiosElogSetupScreen",
    "2DE648CB-3102-43CA-A02E-42E38EA5E789": "ProcessorErrorHandler",
    "2DEAE482-5796-40F2-8DF5-D87419D6F362": "ASUSHDDPW",
    "2DED8109-2355-41F8-A657-D608D5CC1022": "SdxcDxe",
    "2DF10014-CF21-4280-8C3F-E539B8EE5150": "PpmPolicyInitDxe",
    "2E3044AC-879F-490F-9760-BBDFAF695F50": "EfiLegacyBiosGuid",
    "2E3AB8B6-AC9D-4D70-A675-54F52FB22D66": "AtaPassThru",
    "2E3D2E75-9B2E-412D-B4B1-70416B8700FF": "RecoveryOnFatFloppyDiskGuid",
    "2E5CFC2C-9CC0-4D78-BEAF-D84CBF20D1C8": "efi_pop_LF",
    "2E6A521C-F697-402D-9774-98B2B7E140F3": "PlatformInitDxe",
    "2E6FECFB-B0E1-4580-8966-29178C72022E": "SmmS3BootScriptLibS3SmmSaveStateProtocol",
    "2E7D322C-0E5C-11DF-A0DE-1BF2A44EDC7E": "VmwExtCfgDevDxe",
    "2E7DB7A7-608E-4041-B45F-00359E0766C6": "FvbServicesSmm",
    "2E8CD01A-BDB7-40B4-8376-E7C26EAC21FF": "PciPlatform",
    "2EA77912-80A8-4947-BE69-CDD00AFBE556": "EdkiiNonDiscoverableUfsDeviceGuid",
    "2EA84160-ABA0-11DF-9896-0002A5D5C51B": "PL301Axi",
    "2EAA04AA-5EED-4C27-B9EE-26916EC25A8F": "RtkUndiDxeX64_011",
    "2EBE0275-6458-4AF9-91ED-D3F4EDB100AA": "SignOn",
    "2EC3760F-B7FC-4FC7-B8B4-CF371C9628FF": "ThunderboltXDomainDevice",
    "2EC499F9-0337-4DA1-91CA-6BC4E8C03DA2": "Mtftp6Dxe2",
    "2EC9DA37-EE35-4DE9-86C5-6D9A81DC38A7": "AmdSevDxe",
    "2ECED69B-2793-4388-BA3C-823040EBCCD2": "EfiOSInfo",
    "2EE72E7C-FB9E-4318-B888-33A315C7A91D": "PpmPolicy",
    "2F08C089-2073-4BD9-9E7E-308A18327B53": "IconWirelessSmall",
    "2F240E12-E14D-475C-83B0-EFFF22D77BE7": "EfiKmsFormatSha512512Guid",
    "2F3962B2-57C5-44EC-9EFC-A69FD302032B": "TopOfTemporaryRamPpiGuid",
    "2F4DDD35-F8C0-46D2-B0E3-A701360D7499": "PcieLaneDXE",
    "2F62A818-4A72-CD40-90B9-FF00DAABEE7B": "EmuThunk",
    "2F707EBB-4A1A-11D4-9A38-0090273FC14D": "EfiPciRootBridgeIoProtocolGuid",
    "2F72309E-D5B0-4A9D-84A9-1AB38C698F78": "EcPs2Kbd",
    "2F87BA6A-5C04-4385-A780-F3BF78A97BEC": "EfiBlockIoCryptoAlgoAesXtsGuid",
    "2FA2A6DA-11D5-4DC3-999A-749648B03C56": "PiSmmIpl",
    "2FB92EFA-2EE0-4BAE-9EB6-7464125E1EF7": "UhciDxe",
    "2FC3B2D3-6EBA-42B0-A4A7-14C7A84B5D22": "EslIp6ServiceGuid",
    "2FD21CF6-E6E8-4FF2-A9CA-3B9F00E92889": "rmHwA9x4Guid",
    "2FD8B7AD-F8FA-4021-9FC0-0AA572147CDC": "CpuPei",
    "2FDACAF6-669D-4F8C-8368-C3B3E6E32535": "UsbBbs",
    "2FE800BE-8F01-4AA6-946B-D71388E1833F": "EfiMtftp4ServiceBindingProtocolGuid",
    "2FF29FA7-5E80-4ED9-B380-017D3C554FF4": "EfiSmmRscHandlerProtocolGuid",
    "300DE6C5-765C-4F89-BD6D-A623785ABC27": "PchLibNull",
    "3022E512-B94A-4F12-806D-7EF1177899D8": "PciHotPlug",
    "3073D8AC-EFAB-4055-9B37-F62CD93A200A": "IrqAllocatorDxe",
    "3079818C-46D4-4A73-AEF3-E3E46CF1EEDB": "EfiBootScriptExecutorVariableGuid",
    "309DE7F1-7F5E-4ACE-B49C-531BE5AA95EF": "EfiGenericMemTestProtocolGuid",
    "30AC275E-BB30-4B84-A1CD-0AF1322C89C0": "PeiSpeakerInterfacePpiGuid",
    "30CC8A21-0476-4C80-B5C5-B26947E1891D": "XhciDebugger",
    "30CFE3E7-3DE1-4586-BE20-DEABA1B3B793": "EfiPciEnumerationCompleteProtocolGuid",
    "30EB0F26-FC0A-4FD2-B9C9-751EA2BB1980": "DataSource",
    "30FD316A-6728-2E41-A690-0D1333D8CAC1": "EmuGraphicsWindowProtocolGuid",
    "310B3904-0728-4977-A90C-06B8ECD85A9F": "BootOptionService",
    "3137130C-D0A7-467E-9E8F-513816F159D8": "OpromUpdateDxeNeonCityEPRP",
    "3138C825-83ED-064A-A62A-CD13674E3F89": "AppleDhcp4",
    "31401EE7-1600-437C-A11C-B1035D8E6070": "PchAcpiTables",
    "3141FD4D-EA02-4A70-9BCE-97EE837319AC": "TrEEConfigDxe",
    "3152BCA5-EADE-433D-862E-C01CDC291F44": "EfiRngProtocolGuid",
    "316B1230-0500-4592-8C09-EABA0FB6B07F": "SmmHddSecurity",
    "316C608A-4429-49FC-9E2C-0B814D5EE4F3": "PlatformPolicyManagerDxe",
    "316C618A-4429-493C-9E2C-0BA14D5EE4F3": "SstSpiChipDxe",
    "3175E6B9-4B01-496A-9A2B-64AF02D87E34": "CpuExceptionHandlerLibNull",
    "31878C87-0B75-11D5-9A4F-0090273FC14D": "EfiSimplePointerProtocolGuid",
    "31A0B6EF-A400-4419-8327-0FB134AA59E7": "Mxm30Dxe",
    "31A6406A-6BDF-4E46-B2A2-EBAA89C40920": "EfiHiiImageProtocolGuid",
    "31CA5D1A-D511-4931-B782-AE6B2B178CD7": "EfiIfrFrameworkGuid",
    "31CE593D-108A-485D-ADB2-78F21F2966BE": "EfiLegacyInterruptProtocolGuid",
    "31E147A6-D39A-4147-9DA3-BEFD4D523243": "CdExpressPei",
    "31F5B262-7D9E-4FCC-9BB8-0E415D0CD748": "BFGPei",
    "31FD7EAF-80A7-435E-8E0A-3F185F8667DD": "UsbCoreDxe",
    "320AFE62-E593-49CB-A9F1-D4C2F4AF014C": "EfiS3SmmSaveStateProtocolGuid",
    "320E0C11-B5FE-4C20-B8A8-815A20700CEF": "AppleIpAgentDxe",
    "3233B6B9-F4AC-4FE1-9021-71D0B4F0AD82": "BiosMeFwLayout",
    "3237418A-478C-4700-B59F-768E2CCBC726": "CmosDxe",
    "3242A9D8-CE70-4AA0-955D-5E7B140DE4D2": "EfiSmmCpuIo2ProtocolGuid",
    "3262D1AD-A8A8-4597-825E-DE6F167C3407": "PlatformErrorHandler",
    "326AE723-AE32-4589-98B8-CAC23CDCC1B1": "PcAtChipsetPkgTokenSpaceGuid",
    "326E7ACE-2133-1BA2-800A-B9C00ACCB17D": "CpuSmmSaveRes",
    "326E9CC6-9839-4885-B2ED-275903B668E1": "SmmAccess2",
    "32C1C9F8-D53F-41C8-94D0-F6739F231011": "BiosExtensionLoader",
    "32CBA21F-F308-4CBC-9AB5-F5A3699F044A": "EfiUserCredentialClassFingerprintGuid",
    "32D2963A-FE5D-4F30-B633-6E5DC55803CC": "EfiUsbFunctionIoProtocolGuid",
    "32FF59CD-0C33-48D0-A244-4BB811336403": "EslUdp6ServiceGuid",
    "330D4706-F2A0-4E4F-A369-B66FA8D54385": "EfiHiiConfigAccessProtocolGuid",
    "3316A5D0-FE16-40E2-8114-75E5724449F8": "IntelLANDxe",
    "331DEB15-454B-48D8-9B74-70D01F3F3556": "UefiDriverEntryPoint",
    "332A0926-429B-4624-9211-A36B23DF0389": "OhciPei",
    "333BB2A3-4F20-4C8B-AC38-0672D74315F8": "AcpiPlatformPei",
    "333BB2A3-4F20-4CCC-AC38-0672D7412345": "FastBootPei",
    "335984BD-E805-409A-B8F8-D27ECE5FF7A6": "EfiStatusCodeSpecificDataGuid",
    "335B0F6A-FCBD-402A-B4BB-0C3EEDAAF9D3": "EhciRouting",
    "3370A4BD-8C23-4565-A2A2-065FEEDE6080": "SecSMIFlash",
    "337F4407-5AEE-4B83-B2A7-4EADCA3088CD": "EfiHiiUserCredentialFormsetGuid",
    "338695EA-CA84-4FA2-9DA8-5C4BB87905C6": "XenioFdtDxe",
    "339370BD-CFC6-4454-8EF7-704653120818": "ThunderboltDROM",
    "3399DA41-CE44-4FDD-8D32-E578381FEBE0": "menu_bottom_right",
    "339EC458-9B6A-4CEC-A47A-712873653299": "StdFlashLibNull",
    "33C6406D-2F6B-41B5-8705-52BAFB633C09": "AlertStandardFormatDxe",
    "33CB97AF-6C33-4C42-986B-07581FA366D4": "BlockMmioToBlockIoDxe",
    "33D33BF3-349E-4768-9459-836A9F7558FB": "DxeIoLibCpuIo2",
    "33FB3535-F15E-4C17-B303-5EB94595ECB6": "SmmLockBox",
    "340436B0-EBFA-408A-9B8B-565B1F77CF2C": "Lpc47N20x",
    "345ECC0E-0CB6-4B75-BB57-1B129C47333E": "EfiPlatformToDriverConfigurationClpGuid",
    "3470CCF0-6054-11DD-AD8B-0800200C9A66": "EzFlash",
    "348C4D62-BFBD-4882-9ECE-C80BB1C4783B": "HiiDatabase",
    "348CA223-637B-4430-BAF3-1CE5D322B3FD": "SetupBoot",
    "34989D8E-930A-4A95-AB04-2E6CFDFF6631": "TcgPei",
    "349CF818-C0BA-4C43-929A-C8A1B1B3D255": "InternalTpm2DeviceInterfaceGuid",
    "34C8C28F-B61C-45A2-8F2E-89E46BECC63B": "PeiVariablePei",
    "34CC6167-7AE7-403E-8AB2-23837F398A30": "PlatformInfo",
    "34E5798E-F44F-4526-A08C-39BCA6E8D7D5": "ProgramGPIOPei",
    "34FB5A1B-E3CD-4893-9403-0A39BA62FDA0": "SvSmmSupport",
    "35034CE2-A6E5-4FB4-BABE-A0156E9B2549": "PlatDriOverrideDxe",
    "3513C4E2-06D6-4921-9C2B-E938777BA79E": "EblCmdLibNull",
    "352C6AF8-315B-4BD6-B04F-31D4ED1EBE57": "CbSupportPeim",
    "3543EC9D-4B27-4FA9-ADBD-1DF118078FA7": "AmdSb800_PeiPei",
    "355FBDA9-4572-49BC-95B9-545E71DEF9F9": "FpgaSmm",
    "35628CFC-3CFF-444F-99C1-D5F06A069914": "EfiDevicePathPropertyDatabase",
    "356C2B12-3124-4451-BF66-B502D88A0074": "XhciDxe_",
    "35B72237-3926-CF4A-A7F3-1449F9E0E4BD": "EmuSimpleFileSystem",
    "35B898CA-B6A9-49CE-8C72-904735CC49B7": "DxeMainDxe",
    "35C0C168-2607-4E51-BB53-448E3ED1A87F": "PciBusNoEnumerationDxe",
    "35C5AB3E-B77A-450C-8854-159B2F0D32A5": "Ich7MSmmDispatcher",
    "35D13CFD-0BAF-11E8-AE0A-B8E8562CBAFA": "AppleHpetTimerDxe",
    "36164812-A023-44E5-BD85-05BF3C7700AA": "EfiFindFvPpiGuid",
    "3629DDB1-228C-452E-B616-09ED316A9700": "EfiPaddingNoneGuid",
    "362C7275-4D8F-4607-8D8F-28893A8ACD60": "EpuHwModePei",
    "36544866-6D93-7A48-88FB-669582D2516B": "ApplePlatformInfoDatabaseDxe",
    "3672557A-06A7-43EF-60C3-1964F3DD1198": "SmcOutBand",
    "3677D529-326F-4603-A926-EAACE01DCBB0": "EfiPciExpressBaseAddressGuid",
    "368B3649-F204-4CD0-89A8-091077C070FA": "AcpiPlatform",
    "3698D2B0-E727-4537-A636-A8770736ABFB": "GetHostByDns",
    "36B37F21-9D04-44B5-95EC-4DE4CB2FE6FB": "menu_locked_selected",
    "37347E20-5C3D-47B7-B233-1E353A7E0145": "AppleHttpClient",
    "37499A9D-542F-4C89-A026-35DA142094E4": "EfiUartDevicePathGuid",
    "374DE830-81C5-4CC8-B2AB-28F0AB73710B": "SmmCpuFeaturesLibStm",
    "377C66A3-8FE7-4EE8-85B8-F1A282569E3B": "EfiPlatformIdeInitProtocolGuid",
    "378D7B65-8DA9-4773-B6E4-A47826A833E1": "PcRtcDxe",
    "378D7B65-8DA9-4773-B6E4-A47826A833E2": "PcRtcSmm",
    "3792095A-E309-4C1E-AA01-85F5655A17F1": "EfiSmmAccessProtocolGuid",
    "3792FF94-8614-45ED-902B-1207BF1490A8": "PrintThunk",
    "37A01080-2346-4A54-9900-D22B7B687C22": "SmmPciRbIo",
    "37DA43A1-BB9A-4805-9B92-0BDE11191149": "ACPIRAM",
    "3812723D-7E48-4E29-BC27-F5A39AC94EF1": "ItkDataVarGuid",
    "38321DBA-4FE0-4E17-8AEC-413055EAEDC1": "EfiLegacy8259ProtocolGuid",
    "3868FC3B-7E45-43A7-906C-4BA47DE1754D": "EfiSmmFaultTolerantWriteProtocolGuid",
    "386A4B1C-DDE4-4FC5-9B03-9C928FCC6FD2": "gear1",
    "38705437-5697-4715-85C6-29933073C212": "SystemBoardPpi",
    "387477C1-69C7-11D2-8E39-00A0C969723B": "EfiSimpleTextInProtocolGuid",
    "387477C2-69C7-11D2-8E39-00A0C969723B": "EfiSimpleTextOutProtocolGuid",
    "388278D3-7B85-42F0-ABA9-FB4BFD69F5AB": "EfiBluetoothIoServiceBindingProtocolGuid",
    "389F751F-1838-4388-8390-CD8154BD27F8": "EfiFirmwareVolumeProtocolGuid",
    "38A0EC22-FBE7-4911-8BC1-176E0D6C1DBD": "IsaAcpi",
    "38DDFE8F-8991-44AA-9889-83F4918465B0": "EfiGpioOperationProtocolGuid",
    "38E93FAE-C5F4-4700-940D-DC10E2FDB6C0": "OemPeiRuntime",
    "39045756-FCA3-49BD-8DAE-C7BAE8389AFF": "Tcg2Dxe",
    "3915886B-D833-4C23-B3ED-1453CCE7C5F2": "IioCfgUpdateDxeLightningRidgeEXECB2",
    "3920405B-C897-44DA-88F3-4C498A6FF736": "EfiSmmIchnDispatchExProtocolGuid",
    "398262C1-5165-4725-87FC-BB786A972582": "IchPowerButton",
    "399CF3A7-82C7-4D9B-9123-DB11842986D3": "DpcDxe",
    "39B3CE2B-82D0-4C7E-B949-D5E65181B98A": "IshFwLayout",
    "39B68C46-F7FB-441B-B6EC-16B0F69821F3": "EfiCapsuleReportGuid",
    "39B7902B-2377-4F73-9835-B35128ABB8D1": "AppleUpdateMTRR",
    "39C8FAEE-FBEE-41A3-9282-123F18C48CD9": "BroadwaterMemoryInitPei",
    "39D1EDC0-C9ED-4663-90DB-7457FF0548C5": "AmiErrorHandlerMain",
    "39E8CA1A-7A69-4A73-834A-D06381933286": "UsbPei",
    "39F62CCE-6825-4669-BB56-541ABA753A07": "EfiGraphicsInfoHobGuid",
    "39FD1631-64CB-410C-874D-240F88AED5F1": "IGD",
    "3A3300AB-C929-487D-AB34-159BC13562C0": "PchResetCallbackProtocolGuid",
    "3A4D7A7C-018A-4B42-81B3-DC10E3B591BD": "UsbKeyboardLayoutKeyGuid",
    "3A53114D-5673-4DD9-B5B3-CB72C347669B": "BFGSmm",
    "3A61FD45-69A0-42AD-B261-24DA451BF442": "ForceRecovery",
    "3AB14680-5D3F-4A4D-BCDC-CC380018C7F7": "EfiDiskInfoNvmeInterfaceGuid",
    "3AB6529E-6F90-4863-AFFA-F5BA08DEA9AA": "SbBeepLibPcAt",
    "3ACC966D-8E33-45C6-B4FE-62724BCD15A9": "AhciBusDxe",
    "3ACEB0C0-3C72-11E4-9A56-74D435052646": "TlsDxe",
    "3ACF33EE-D892-40F4-A2FC-3854D2E1323D": "EfiPeiCapsulePpiGuid",
    "3AD9DF29-4501-478D-B1F8-7F7FE70E50F3": "EfiUdp4ProtocolGuid",
    "3AE3D6F0-6483-45D6-9395-303C9789208D": "TrEEConfigPei",
    "3AF9647D-C46B-11E4-AA1D-B8E8562CBAFA": "ChunkManager",
    "3B0673A3-5197-454C-BA76-E2D0C8C48EFD": "GenericElog",
    "3B1DEAB5-C75D-442E-9238-8E2FFB62B0BB": "UefiPxe4BcDxe",
    "3B1E4B7C-09D8-944F-A408-1309EB8B4427": "EmuThreadThunkProtocolGuid",
    "3B24F79D-91A0-46FF-BE29-458AE211FAC5": "KbcEmul",
    "3B42EF57-16D3-44CB-8632-9FDB06B41451": "MemoryInit",
    "3B43161F-AEB4-43EC-9E1B-8050171B4899": "BiosGuardRecoveryHook",
    "3B4D9B23-95AC-44F6-9FCD-0E9594586C72": "BdsLibStringPackageGuid",
    "3B6686BD-0D76-4030-B70E-B5519E2FC5A0": "EfiCapsuleGuid",
    "3B8C8162-188C-46A4-AEC9-BE43F1D65697": "EfiFwDisplayCapsuleGuid",
    "3B95AA31-3793-434B-8667-C8070892E05E": "EfiIp4ConfigProtocolGuid",
    "3BBCB209-26C8-4BA9-AD25-B95B45A04D26": "BatteryState3",
    "3BC1B285-8A15-4A82-AABF-4D7D13FB3265": "EfiBusSpecificDriverOverrideProtocolGuid",
    "3BC1F6DE-693E-4547-A300-21823CA420B2": "PeiUsbControllerPpiGuid",
    "3BD2A492-96C0-4079-B420-FCF98EF103ED": "EfiCertX509Sha256Guid",
    "3BD2F4EC-E524-46E4-A9D8-510117425562": "EfiHiiStandardFormGuid",
    "3BEB6B06-09CE-4386-8884-F323ADD04F1F": "GlobeTile",
    "3BF4AF16-AB7C-4B43-898D-AB26AC5DDC6C": "SecSMIFlash",
    "3BF66866-3F8B-4CD8-B74C-B994111F535F": "FfsIntegrityCheckDxe",
    "3C0ED5E2-91EA-4B94-820D-9DAF9A3BB4A2": "DmarAcpiTable",
    "3C1DE39F-D207-408A-AACC-731CFB7F1DD7": "PciBus",
    "3C35B99D-D4B7-4885-ABD9-2BEA4B9F3A01": "ASUSFTMDXE",
    "3C485EA4-449A-46CE-BB08-2A336EA96B4E": "EfiCk505ClockPlatformInfoGuid",
    "3C5766E8-269C-4E34-AA14-ED776E85B3B6": "EfiCertRsa2048Guid",
    "3C5C631D-7995-4415-8B16-9F4A8AD36FCF": "Int10ToSmi",
    "3C699197-093C-4C69-B06B-128AE3481DC9": "EfiAcpiDescriptionGuid",
    "3C7200E9-005F-4EA4-87DE-A3DFAC8A27C3": "EfiShellDynamicCommandProtocolGuid",
    "3C7D193C-682C-4C14-A68F-552DEA4F437E": "PcdDataBaseSignatureGuid",
    "3C8B9970-870A-11E4-B7C6-B8E8562CBAFA": "ChipsetGpioDxe",
    "3C8D294C-5FC3-4451-BB31-C4C032295E6C": "IdleLoopEventGuid",
    "3CCD3DD8-8D45-4FED-962D-2B38CD82B3C4": "UserIdentifyManagerGuid",
    "3CD652B4-6D33-4DCE-89DB-83DF9766FCCA": "EfiVectorHandoffInfoPpiGuid",
    "3CDC90C6-13FB-4A75-9E79-59E9DD78B9FA": "EfiPeiReadOnlyVariablePpiGuid",
    "3CEF354A-3B7A-4519-AD70-72A134698311": "Ebl",
    "3D3CA290-B9A5-11E3-B75D-B8AC6F7D65E6": "XenBusProtocolGuid",
    "3D5ABD30-4175-87CE-6D64-D2ADE523C4BB": "EfiVirtualCdGuid",
    "3D61A466-AB40-409A-A698-F362D464B38F": "EfiEventNotificationTypeBootGuid",
    "3D9FC54D-19E5-4AD0-B986-02D687D760E5": "ASRLOGODXE",
    "3DC5DC4A-824A-44C5-89D0-D4547191E3F4": "RstOneClickEnable",
    "3DC82376-637B-40A6-A8FC-A565417F2C38": "Ps2KeyboardDxe",
    "3DD406D4-5EC9-4198-9907-F674E60B2994": "BaseTraceHubInitLibNull",
    "3DD7A87B-D5BD-44AF-986F-2E13DB5D274C": "SnpDxe",
    "3DE30DC2-D84E-48EA-8E38-A9C17D743F10": "TimerSMISmm",
    "3DFE0FAB-70C7-4B53-9855-985F14DB2DDA": "RawIp4Tx",
    "3E197E9C-D8DC-42D3-89CE-B04FA9833756": "RegularExpressionDxe",
    "3E1C696D-FCF0-45A7-85A7-E86C2A1C1080": "UefiDevicePathLibOptionalDevicePathProtocol",
    "3E3099F5-CBCC-4AE8-AEA0-2B7D1E7F8294": "LpssDxe",
    "3E35C163-4074-45DD-431E-23989DD86B32": "EfiHttpUtilitiesProtocolGuid",
    "3E4817FD-2742-4351-B59F-91493280329C": "AlertStandardFormatPei",
    "3E591C00-9E4A-11DF-9244-0002A5D5C51B": "EfiMmcHostProtocolGuid",
    "3E625104-1920-44B1-AE2C-1BDA57ED73EA": "KtiRas",
    "3E745226-9818-45B6-A2AC-D7CD0E8BA2BC": "EfiUsb2HcProtocolGuid",
    "3EAF5E3A-E4B2-48E6-A9F1-B75CF204BCC8": "PeiBoardConfigInit",
    "3EB9F0D3-40D0-435B-B692-809151807FF4": "TCM_MPDriver",
    "3EBD8C7C-733B-4667-8FD1-4ABEA366C95B": "ASUSDirectKeyPEI",
    "3EBD9E82-2C78-4DE6-9786-8D4BFCB7C881": "EfiFaultTolerantWriteProtocolGuid",
    "3EBFA8E6-511D-4B5B-A95F-FB38260F1C27": "DeviceManagerFormSetGuid",
    "3F7753EF-D36F-45CC-8A1A-2EAAFF1038B6": "PciPlatform",
    "3F78CB8D-72EE-414E-B023-DACA003BDDF5": "ProjectSxSMI",
    "3F78CB8D-72EE-414E-B023-DACA003EFCDE": "APM",
    "3FA0BB4A-180B-4458-9F12-6EA68F69E6CC": "PxeRomB571699",
    "3FA4F847-D8EB-4DF4-BD49-103A0A847BBC": "EfiKmsFormatMdc4128Guid",
    "3FD1D3A2-99F7-420B-BC69-8BB1D492A332": "Fid",
    "3FDDA605-A76E-4F46-AD29-12F4531B3D08": "EfiMpServiceProtocolGuid",
    "3FE2A8A3-C400-48F8-832F-7881A394C250": "IohInitDxe",
    "3FE57AC2-C675-46B1-8458-AC6206588424": "SgTpvDxe",
    "3FE72C6D-3612-4061-84AF-80C5B7AC6E25": "PeiIpmiCmosClear",
    "3FEEC852-F14C-4E7F-97FD-4C3A8C5BBECC": "FWkey",
    "3FFCAE95-23CF-4967-94F5-16352F68E43B": "PpmInitialize",
    "3FFFB2AA-4692-42E8-865E-7E111986FABE": "wifi_2bars",
    "40008162-93D0-48F2-80DA-7E32F4C98F8B": "Udp6Dxe_",
    "4004DE5A-09A5-4F0C-94D7-82322E096AA7": "DxeCapsuleLibNull",
    "4004E454-89A0-11E3-89AA-97EF9D942ABC": "ArmVExpressFastBootDxe",
    "4006C0C1-FCB3-403E-996D-4A6C8724E06D": "EfiLoadFile2ProtocolGuid",
    "40093F23-630C-4626-9C48-40373B19CBBE": "EfiKmsFormatGeneric2048Guid",
    "40096A3A-5C2A-4FBC-AEF7-5475DD7AB334": "BasePcdLibNull",
    "400B4476-3081-11D6-87ED-00062945C3B9": "EfiSpeakerInterfaceProtocolGuid",
    "405B2307-6839-4D52-AEB9-BECE64252800": "ArmFvpDxe",
    "405DA936-3737-4C0C-8E3F-E6172A568592": "FileExplorerDxe",
    "405F8FE6-5213-4B85-B821-97B77AFF795B": "ASM104X_DXE",
    "407B4008-BF5B-11DF-9547-CF16E0D72085": "PL111LcdGraphicsDxe",
    "408EDCEC-CF6D-477C-A5A8-B4844E3DE281": "ConSplitterDxe",
    "40B09B5A-F0EF-4627-93D5-27F04B754D05": "AmtReadyToBootGuid",
    "40BEAB40-CECE-4909-B133-20A413AE19E9": "CpuMpDxe",
    "40E064B2-0AE0-48B1-A07D-F8CF1E1A2310": "EfiNetworkPkgTokenSpaceGuid",
    "40FDF4FC-B7CC-4AC5-9BA2-A050D26656A7": "SmcOptimizePei",
    "410C1D0C-656F-4769-8DFB-90F9A0303E9F": "IconFireWireHD",
    "4110465D-5FF3-4F4B-B580-24ED0D06747A": "SmbiosPlatformDxe",
    "41292206-4069-42A6-AC38-C4A5C123C6E5": "BaseTraceHubLibNull",
    "41401688-2862-431B-BAAC-6ECADAC384AB": "PciCfg2OnPciCfgThunk",
    "414E6BDD-E47B-47CC-B244-BB61020CF516": "EfiHardwareErrorVariableGuid",
    "41789FB9-02AC-4484-BD40-A3147D7EDA25": "PeiRecoveryLibNull",
    "41A4631C-BB02-45AF-BEDD-AEDC56E53E79": "SuperMPei",
    "41D94CD2-35B6-455A-8258-D4E51334AADD": "EfiIp4ProtocolGuid",
    "41E26B9C-ADA6-45B3-808E-2357A35B60D6": "ArmBootMonFsFileInfoGuid",
    "41E89AB0-BD3D-44B6-A431-E4836EFBF2CB": "PowerManagement2_",
    "42293093-76B9-4482-8C02-3BEFDEA9B35D": "TcgSmm",
    "4278A574-4769-4D60-B090-DD4916691590": "RecoveryModuleLoadPei",
    "42857F0A-13F2-4B21-8A23-53D3F714B840": "CapsuleRuntimeDxe",
    "42881C98-A4F3-44B0-A39D-DFA18667D8CD": "EfiHashServiceBindingProtocolGuid",
    "42BB673D-09F3-4E2E-9FEE-D081131DED5B": "BootScriptSaveDxe",
    "42C078EF-14A8-4E30-9329-6F12D796E54A": "LibWchar",
    "42EF76CE-A606-4881-BEA6-AD3F3EC9F754": "Memory_OK_PEI",
    "42F58B27-5DC3-4FA7-844D-5A7DBFF06432": "Enquire",
    "42F5F135-3F50-4319-98A2-3B22DF559D20": "SmbiosMemory",
    "42FCB444-B881-49D8-A6E9-5A1695FC9F3E": "SysPassword",
    "4308B1F6-60F0-49FE-9E51-3A25992515BF": "PoofAnimationState0",
    "430AC2F7-EEC6-4093-94F7-9F825A7C1C40": "SdDxe",
    "43172851-CF7E-4345-9FE0-D7012BB17B88": "iFfsSmm",
    "4344558D-4EF9-4725-B1E4-3376E8D6974F": "ShellLevel3HiiGuid",
    "4356B162-D0B2-11E1-8952-4437E6A60EA5": "Lan9118Dxe",
    "435CB0E4-7C9A-4BB7-9907-8FD4643E978A": "AuthVariableLibNull",
    "43679142-87C4-44AD-AF02-B47F782D6CF3": "PeiIpmiLibIpmiPpi",
    "43788BEB-638F-434C-8A84-46D33A589E76": "BmcElog",
    "4391AA92-6644-4D8A-9A84-DDD405C312F3": "AppleBootPolicy",
    "43A110CE-9CCD-402B-8C29-4A6D8AF77990": "EslUdp4ServiceGuid",
    "43A4C605-C66D-473E-A06A-37E9143FC439": "PcRtc",
    "43AC4333-472C-4B91-8C5C-52A8B4374256": "IioCfgUpdateDxeNeonCityFPGA",
    "43B93232-AFBE-11D4-BD0F-0080C73C8881": "PartitionDxe",
    "43BE0B44-874B-4EAD-B09C-241A4FBD7EB3": "EfiKmsFormatGeneric1024Guid",
    "43E7ABDD-E352-4CFB-A230-4CDC1D350E5C": "GraphicsConsole",
    "4414D6D8-232C-4972-A4F7-2B21D4298786": "I2cHost",
    "4426CCB2-E684-4A8A-AE40-20D4B025B710": "EfiPeiS3ResumePpiGuid",
    "442BE18B-CA6E-4A23-9A99-9AFE8A213A32": "PlatformPeiSystemInformation",
    "44640C32-33D7-4FB0-B1F9-6C7B232E994D": "SpsPei",
    "446DBF63-2502-4CDA-BCFA-2465D2B0FE9D": "EfiCertX509Sha512Guid",
    "447559F0-D02E-4CF1-99BC-CA11654054C2": "StdLibTokenSpaceGuid",
    "447A1B58-8F3E-4658-ABAA-9E7B2280B90A": "NvramSmm",
    "44883EC1-C77C-1749-B73D-30C7B468B556": "ExFatDxe",
    "448F5DA4-6DD7-4FE1-9307-69224192215D": "EfiSectionExtractionProtocolGuid",
    "4495E47E-42A9-4007-8C17-B6664F909D04": "BlockIoDxe",
    "44A20657-10B8-4049-A148-ACD8812AF257": "Tcg2Smm",
    "44A2AD5D-612C-47B3-B06E-C8F50BFBF07D": "OpalExtraInfoVariableGuid",
    "44CDFA70-2C7C-4791-9AA3-EAE8777F0A8B": "X11PeiDriver",
    "44F0DE6E-4D8C-4045-A8C7-4DD168856B9E": "EfiRngAlgorithmSp80090Ctr256Guid",
    "44FE07D3-C312-4AD4-B892-269AB069C8E1": "BiosGuardSmm",
    "45055A79-B385-4705-A3AC-11CE99A1CB47": "StaticSkuDataDxeNeonCityEPRP",
    "453368F6-7C85-434A-A98A-72D1B7FFA926": "EmuIoThunkProtocolGuid",
    "453C5E5A-482D-43F0-87C9-5941F3A38AC2": "EfiKmsFormatSha1160Guid",
    "45424D0C-E6AF-4AF2-AD99-FA77168742D1": "SmartTimerDxe",
    "4549AB47-6E60-4293-B91D-31B610AD8056": "EfiEsrtOperationProtocolGuid",
    "4551F2F5-C684-4F27-936F-C7B04A5C5FF1": "SecureBootDXE",
    "455D16DC-E3AF-4B5F-A9AD-A4BC198085BD": "BaseDebugDeviceLibNull",
    "456D2859-A84B-4E47-A2EE-3276D886997D": "EfiSmmSxDispatch2ProtocolGuid",
    "4579B72D-7EC4-4DD4-8486-083C86B182A7": "IScsi4Dxe",
    "459504D7-72D7-4BB2-956D-C9FA899920E8": "OemFwLnk",
    "459C70C3-9344-4484-9F93-7822530D0D11": "MePciPlatform",
    "45BCD98E-59AD-4174-9546-344A07485898": "EfiSupplicantServiceBindingProtocolGuid",
    "45D68DB9-8B4E-48C0-99E9-F21F262DB653": "XhciPei",
    "45F9602A-3475-4D1E-9FE9-BAC99F42AD49": "AppleBacklightController",
    "461B2833-3DA5-4556-95F2-BA506131051B": "ExtCfgDevDrvDxe",
    "462CAA21-7614-4503-836E-8AB6F4662331": "UiApp",
    "46310243-7B03-4132-BE44-2243FACA7CDD": "CMDB",
    "465FDE84-E8B0-B04B-A843-A03F68F617A9": "ThunkPpiList",
    "467313DE-4E30-43F1-943E-323F89845DB5": "EfiBluetoothIoProtocolGuid",
    "46805D61-0BB8-4680-A9BE-C96C751AB5A4": "BaseIpmiLibNull",
    "469FC080-AEC1-11DF-927C-0002A5D5C51B": "ArmPlatformPrePeiCore",
    "46B94C2D-AF5D-4915-814D-159323AE780A": "PowerButtonHandler",
    "46E3256A-E5C1-4D2A-8282-505AFB41CE65": "DuetFwh",
    "46E44855-BD60-4AB7-AB0D-A679B9447D77": "EfiTcp6ProtocolGuid",
    "46F9D8DA-2670-44B2-9E42-C9B130CE2465": "SmbiosMisc",
    "470CB248-E8AC-473C-BB4F-81069A1FE6FD": "SmmFaultTolerantWriteDxe",
    "470E1529-B79E-4E32-A0FE-6A156D29F9B2": "EfiBootScriptSaveProtocolGuid",
    "472A583E-70CF-465A-BB77-53ADFCDB5883": "OCMR_DXE",
    "4776E33F-DB47-479A-A25F-A1CD0AFAB38B": "EfiKmsFormatAesxts128Guid",
    "47889FB2-D671-4FAB-A0CA-DF0E44DF70D6": "EfiPkcs7VerifyProtocolGuid",
    "47970A28-8F4A-4CB2-91DE-BF344153189A": "AmiCspFlashLibNull",
    "47AA8FEE-48D0-11E4-A6D3-B8E8562CBAFA": "SpiLockDxe",
    "47B7FA8C-F4BD-4AF6-8200-333086F0D2C8": "EfiSmmReadyToLockProtocolGuid",
    "47C7B221-C42A-11D2-8E57-00A0C969723B": "EfiShellEnvironment2Guid",
    "47C7B223-C42A-11D2-8E57-00A0C969723B": "EfiShellInterfaceGuid",
    "47F48C99-CB23-4CF8-9D7D-CE7C86EF22A3": "UsbTouchPanelDxe",
    "47FD99EB-C1E6-4F77-A31A-9F7FB4A8E7DE": "menu_down_arrow",
    "480F8AE9-0C46-4AA9-BC89-DB9FBA619806": "EfiDpcProtocolGuid",
    "4839023B-4C12-4EB2-B2B8-C91B42D878A0": "IsctAcpi",
    "4862AFF3-667C-5458-B274-A1C62DF8BA80": "HeciInit",
    "4896840D-46BB-412B-A30A-A62ABFB3682F": "SpsAcpiSsdt",
    "48AB7F57-DC34-4F6C-A7D3-B0B5B0A74314": "EfiIa32X64ErrorTypeMsCheckGuid",
    "48D51913-F340-4798-83D7-5CAB3D5C6DA7": "AppleEffaceableBCENOR",
    "48ECB431-FB72-45C0-A922-F458FE040BD5": "EfiEdidOverrideProtocolGuid",
    "48FB21BF-47E5-406C-A73E-D83D00767214": "FwhFlashPeiLibNull",
    "4904B42F-9FC0-4C2E-BB3F-A2AB35123530": "DebugAgentLibNull",
    "490D0119-4448-440D-8F5C-F58FB53EE057": "PolicyInitDxe",
    "490E9D85-8AEF-4193-8E56-F734A9FFAC8B": "PeiSerialPortPpiGuid",
    "49152E77-1ADA-4764-B7A2-7AFEFED95E8B": "EfiDebugImageInfoTableGuid",
    "492CB3AE-66DB-4F1E-91AE-534C48F2F83D": "WheaSupport",
    "4953F720-006D-41F5-990D-0AC7742ABB60": "IntelGigabitLan",
    "4953F720-006D-41F5-990D-0AC7742ABB61": "Intel10GLan",
    "495AA584-63D4-45F0-A4EF-36042B19A201": "AppleVariablePolicy",
    "49970331-E3FA-4637-9ABC-3B7868676970": "AcpiPlatform",
    "49B7F3E1-6C08-4A5B-911C-E9E397ED4178": "AcpiVariableHobOnSmramReserveHobThunk",
    "49EA041E-6752-42CA-B0B1-7344FE2546B7": "ArmTimerDxe",
    "49EDB1C1-BF21-4761-BB12-EB0031AABB39": "EfiPeiFirmwareVolumeInfoPpiGuid",
    "4A3602BC-1A05-4C82-99B4-588CD2A32CD5": "LEGACYSREDIR",
    "4A37320B-3FB3-4365-9730-9E89C600395D": "SmmDispatcher",
    "4A4ECE10-61EB-4FC4-8839-F7CFDD962074": "IccPei",
    "4A538818-5AE0-4EB2-B2EB-488B23657022": "FvMainCompact",
    "4A6D890F-93C3-4B6D-A67D-5F2C4DCE347B": "RuntimeSmm",
    "4A9B9DB8-EC62-4A92-818F-8AA0246D246E": "MiscSubclassDxe",
    "4AAFD29D-68DF-49EE-8AA9-347D375665A7": "EfiCertPkcs7Guid",
    "4AAFE3AA-DEEE-4D81-80F3-82D226C71C4B": "PvScsiPassThruDxe",
    "4AC94F68-E651-4B38-A1D8-2D5DEFFA0F60": "HDAudioSmi",
    "4AC99A7C-1DCF-4A51-8F06-5EEDFE8A8864": "CryptoServiceRuntimeDxe",
    "4ACA697E-F883-446F-98F7-096416FFFFFF": "OhciDxe",
    "4AE7E1E8-9DFE-4E3E-85B4-A5F6ABD470FB": "Cpuid",
    "4B0165A9-61D6-4E23-A0B5-3EC79C2E30D5": "DxePchPlatformPolicyProtocolGuid",
    "4B28E4C7-FF36-4E10-93CF-A82159E777C5": "ResetSystemRuntimeDxe",
    "4B3029CC-6B98-47FB-BC96-76DCB80441F0": "EfiDiskInfoUfsInterfaceGuid",
    "4B3828AE-0ACE-45B6-8CDB-DAFC28BBF8C5": "VAROEM",
    "4B47D616-A8D6-4552-9D44-CCAD2E0F4CF9": "IScsiConfigGuid",
    "4B680E2D-0D63-4F62-B930-7AE995B9B3A3": "SmBusDxe",
    "4B837B03-6587-4D19-B82B-EDFAD836C0A0": "SecMain",
    "4BB346D2-8076-4671-8BC9-7B95CBB9A6DF": "MonoStatusCode",
    "4BC80B15-255D-4858-8072-51D6D98CF90E": "SetHostName",
    "4BD56BE3-4975-4D8A-A0AD-C491204B5D4D": "EfiAdapterInfoUndiIpv6SupportGuid",
    "4C006CD9-19BA-4617-8483-609194A1ACFC": "UsbInt13",
    "4C19049F-4137-4DD3-9C10-8B97A83FFDFA": "EfiMemoryTypeInformationGuid",
    "4C26DF71-EBE7-4DEA-B5E2-0B5980433908": "GetAddrInfo",
    "4C494E55-5849-5342-4554-544552212121": "SlpSupport",
    "4C5C6A74-BAB7-46D6-8688-3B2E7F246E3F": "SataController_",
    "4C6E0267-C77D-410D-8100-1495911A989D": "MetronomeDxe",
    "4C862FC6-0E54-4E36-8C8F-FF6F3167951F": "FtwLiteDxe",
    "4C8A2451-C207-405B-9694-99EA13251341": "EfiDebugMaskProtocolGuid",
    "4C8BDF60-2085-4577-8A46-96CB180967BC": "Tpm20Acpi",
    "4CBB6611-3608-492B-92A7-DD92FD6FE4FE": "OEMBOARDPei",
    "4CC14F19-C626-4AB6-9DEA-CA6C01FD10CD": "ASUSHeaderPEI",
    "4CE9D7AE-61B2-4461-9446-AB0376B4A7F7": "FboSce",
    "4CEC368E-8E8E-4D71-8BE1-958C45FC8A53": "EfiSmmPeriodicTimerDispatch2ProtocolGuid",
    "4CEF31DA-8682-4274-9CC4-AEE7516A5E7B": "CapsuleApp",
    "4CF484CD-135F-4FDC-BAFB-1AA104B48D36": "HfsPlusDxe",
    "4CF5B200-68B8-4CA5-9EEC-B23E3F50029A": "EfiPciIoProtocolGuid",
    "4D00EF14-C4E0-426B-81B7-30A00A14AAD6": "NandFlash",
    "4D06B832-6987-40F2-B76D-D170B42DB182": "TrEEPhysicalPresenceDxe",
    "4D20583A-7765-4E7A-8A67-DCDE74EE3EC5": "HttpBootConfigGuid",
    "4D2E57EE-0E3F-44DD-93C4-D3B57E96945D": "CpuS3DataDxe",
    "4D330321-025F-4AAC-90D8-5ED900173B63": "EfiDriverDiagnostics2ProtocolGuid",
    "4D35A5A7-622E-4955-A5D2-CDA812940D74": "FwBlockService",
    "4D37DA42-3A0C-4EDA-B9EB-BC0E1DB4713B": "PpisNeededByDxeCorePei",
    "4D7267F0-F48C-4050-AE55-8FE1708096A0": "ASRockNetFtpBin",
    "4D8B155B-C059-4C8F-8926-06FD4331DB8A": "GetPcdInfoPpiGuid",
    "4D8B77D9-E923-48F8-B070-4053D78B7E56": "Tpm12DeviceLibTcg",
    "4D9CBEF0-15A0-4D0C-83DB-5213E710C23F": "Tcg2ConfigDxe",
    "4DCAAB0A-1990-4352-8D2F-2D8F135598A5": "EslTcp4ServiceGuid",
    "4DCBF9BA-DEC1-42B0-8A09-01555694F6CF": "GbtCustomizeButtonSmm",
    "4DE01DE6-7CBB-4786-9F2A-9B9C7C97AC06": "S3RestoreAcpiPei",
    "4DF19259-DC71-4D46-BEF1-357BB578C418": "EfiPs2PolicyProtocolGuid",
    "4DF53F89-D421-4F9D-8392-BE3BECC6288E": "AhciInt13Dxe",
    "4E11E955-CCCA-11D4-BD0D-0080C73C8881": "EfiWinNtGopGuid",
    "4E1356C2-0EED-463F-8147-9933ABDBC7D5": "EfiKmsFormatRsasha2563072Guid",
    "4E1C4F95-90EA-47DE-9ACC-B8920189A1F5": "SecPeiFspPlatformSecLibSample",
    "4E28CA50-D582-44AC-A11F-E3D56526DB34": "EdkiiPiSmmCommunicationRegionTableGuid",
    "4E292F96-D843-4A55-A8C2-D481F27EBEEE": "EfiEventNotificationTypeCpeGuid",
    "4E304BC0-3B03-4A97-BB55-91375189A31D": "iFlashDxeBin",
    "4E3A82E6-E43F-460A-866E-9B5AAB804448": "EslIp4ServiceGuid",
    "4E76928F-50AD-4334-B06B-A84213108A57": "NtFwhPpiGuid",
    "4E82091E-32A1-4689-8A00-CDE41ED63CDD": "SioDxeInit",
    "4E8F4EBB-64B9-4E05-9B18-4CFE49235097": "EfiMemorySubClassGuid",
    "4EA43463-747C-46EB-97FB-B0E5C5F05306": "UsbMouseAbsolutePointerDxe",
    "4EA97C46-7491-4DFD-B442-747010F3CE5F": "Main",
    "4EB6E09C-D256-4E1E-B50A-874BD284B3DE": "FspSiliconInitDonePpiGuid",
    "4EC8B120-8307-11E0-BC91-0002A5D5C51B": "PL011Uart",
    "4ECB6C53-C641-4370-8CB2-3B0E496E8378": "EfiExtendedSalVariableServicesProtocolGuid",
    "4ED4BF27-4092-42E9-807D-527B1D00C9BD": "EfiHobMemoryAllocStackGuid",
    "4EFFB560-B28B-4E57-9DAD-4344E32EA3BA": "MiscSubclass",
    "4F1F379F-2A62-48BB-AC34-D3F135C6E2B7": "PcatSingleSegmentPciCfg2Pei",
    "4F4EF7F0-AA29-4CE9-BA41-643E0123A99F": "HiiResourceSamleFormSetGuid",
    "4F4FF580-B8A0-4332-A6B0-E2E568E36C9C": "ASFVerbosity",
    "4F6C5507-232F-4787-B95E-72F862490CB1": "EventExitBootServicesFailedGuid",
    "4F792E68-E8C8-794E-B1D8-3703F3F2D5A5": "EmulatorPkgTokenSpaceGuid",
    "4F821C7C-8E33-412A-AE63-D149F376CD1B": "SmmWheaDxe",
    "4F89E208-E144-4804-9EC8-0F894F7E36D7": "EfiPeiSectionExtractionPpiGuid",
    "4F921013-4F71-4C6C-BCF8-419B2B801932": "SetupBrowser2",
    "4F948815-B4B9-43CB-8A33-90E060B34955": "EfiUdp6ProtocolGuid",
    "4FA7E1F2-CE8B-4D38-A3F8-342DC4515446": "IioCfgUpdateDxeNeonCityEPRP",
    "4FB2CE1F-1A3A-42E3-BD0C-7B84F954189A": "AcpiCallbacksSmm",
    "4FD1BA49-8F90-471A-A2C9-173C7A732FD0": "SeCfTPMPolicyPpiGuid",
    "4FE772E8-FE3E-4086-B638-8C493C490488": "PhysicalPresencePei",
    "4FF2E88A-A404-46F7-9A2A-35E00844F6E6": "SpiDeviceDxe",
    "4FFF2014-2086-4EE6-9B58-886D1967861C": "SecPeiDxeTimerLibUefiCpu",
    "5007A40E-A5E0-44F7-86AE-662F9A91DA26": "FvOnFv2Thunk",
    "5011522C-7B0E-4ACB-8E30-9B1D133CF2E0": "FmpAuthenticationLibNull",
    "501F30E9-D14F-47DA-AE60-B101E4189D07": "AhciInt13Smm",
    "502B04F3-71AB-47B4-BEAE-4736EA190AA4": "PciDxeInit",
    "503E70FE-047A-410B-A55F-4F63C9382C1E": "CpuIo2OnCpuIoThunk",
    "5053697E-2CBC-4819-90D9-0580DEEE5754": "EfiCapsuleArchProtocolGuid",
    "5058F21C-BC34-11D4-BD18-0080C73C8881": "Fat2",
    "506533A6-E626-4500-B14F-17939C0E5B60": "AcpiSupportDxe",
    "5074C00E-698B-4763-91E6-41663F6CC7C9": "PBSPeiInitPei",
    "508A61DC-2C57-4848-A54A-58015179C94A": "ApplePowerState",
    "50A18017-37AD-8743-BCF2-DF1A8FF12FAB": "EmuReset",
    "50B4FAD4-9D0D-440B-812C-D8E3EC21244D": "XhciHandlerCommon",
    "50F6096D-7C98-4C78-9A1D-C5A1833B6A88": "AmiTcgNvflagSample",
    "51116915-C34B-4D8E-86DB-6A70F2E60DAA": "NVMe",
    "51116915-C34B-4D8E-86DB-6A70F2E60DAC": "IOBufferCopyController",
    "5112A2AA-E175-477E-A4E4-D0B7E689BA9F": "EventLogDxe",
    "5122FA7B-17A3-4A8B-89AE-A93ADE92EADF": "DigitalThermalSensor",
    "51271E13-7DE3-43AF-8BC2-71AD3B824325": "ShellMapGuid",
    "5167FD5D-AAA2-4FE1-9D0D-5CFCAB36C14C": "LegacyRegion2OnLegacyRegionThunk",
    "5169AF60-8C5A-4243-B3E9-56C56D18EE26": "SmmIpmiProtocolGuid",
    "51739E2A-A022-4D73-ADB9-91F0C9BC7142": "MpServicesOnFrameworkMpServicesThunk",
    "51924AE9-BE81-4820-94BA-7C9546E702D0": "Tcg2PpVendorLibNull",
    "5199296F-2808-4AFA-94C4-99F6B06C871E": "ACPIS4Smm",
    "51AA59DE-FDF2-4EA3-BC63-875FB7842EE9": "EfiHashAlgorithmSha256Guid",
    "51C4C059-67F0-4E3C-9A55-FF42A8291C8C": "PeiSmbusLibSmbusPpi",
    "51C9F40C-5243-4473-B265-B3C8FFAFF9FA": "Crc32SectionExtractDxe",
    "51CCF399-4FDF-4E55-A45B-E123F84D456A": "ConPlatformDxe",
    "523FA0E8-8639-47BB-B859-939A450DBF77": "EnhancedFat",
    "5242AADB-BDAB-4B92-B7D5-A58B6E0EEE6B": "IchSmbusArpDisabledPei",
    "524685A0-89A0-11E3-9D4D-BFA9F6A40308": "AndroidFastbootPlatformProtocolGuid",
    "52715B77-04A5-487A-B980-CDC371B5BEC8": "AsusPostErrPei",
    "529D3F93-E8E9-4E73-B1E1-BDF6A9D50113": "ArpDxe",
    "52B3DBA7-9565-48E8-8E13-EC7196721B3C": "PlatformInfoPei",
    "52C05B14-0B98-496C-BC3B-04B50211D680": "PeiCore",
    "52C78312-8EDC-4233-98F2-1A1AA5E388A5": "EfiNvmExpressPassThruProtocolGuid",
    "52C877FD-C27C-4779-B750-7880B28B4306": "SetupConfigUpdateDxeNeonCityEPRP",
    "52CE9845-5AF4-43E2-BAFD-230812547AC2": "PlatformGpioProtocolGuid",
    "52DAA304-DEB3-449B-AFB8-A88A54F28F95": "OhciPei",
    "52F934EE-7F15-4723-90CF-4E37127718A5": "TcgPeiPei",
    "534A6A34-CF78-4A56-BEDB-CB49A8D8060C": "RTCWakeup",
    "534BA4FD-D74C-1E41-AA7D-BB551364FBAD": "AppleDebugSupportDxe",
    "53531469-558E-4AF1-803A-F966F27C573B": "BatteryState2",
    "535A720E-06C0-4BB9-B563-452216ABBED4": "HdLcdArmVExpress",
    "5360BFF6-3911-4495-AE3C-B02FF004B585": "DxePciLibI440FxQ35",
    "536DF136-BD96-4E1E-ADF5-6B637C139063": "UuidDxe",
    "53A58D06-AC27-4D8C-B5E9-F08A80654170": "EfiExtendedSalStallServicesProtocolGuid",
    "53AB1ACD-EDB1-4E3A-A2C7-978D721D179D": "FspSecCoreS",
    "53BCC14F-C24F-434C-B294-8ED2D4CC1860": "DataHubDxe",
    "53CD299F-2BC1-40C0-8C07-23F64FDB30E0": "EdkiiPlatformLogoProtocolGuid",
    "53F019E9-BB0C-424B-870A-1FAF10B1CB4C": "iFfsPei",
    "543323CE-9F0C-4DDF-A33C-BC3B3A5AC227": "SmmBmcElog",
    "5446C293-339B-47CD-B719-585DE39408CC": "PostReport",
    "5473C07A-3DCB-4DCA-BD6F-1E9689E7349A": "EfiFirmwareFileSystem3Guid",
    "547957B2-D791-4CFF-8808-8024897B4D98": "PLX8605PEI",
    "5479662B-6AE4-49E8-A6BD-6DE4B625811F": "BiosKeyboardDxe",
    "5479E09C-2E74-481B-89F8-B0172E388D1F": "StartWatchDog",
    "547C5CAE-2640-4ACF-9532-0E25B3F03F05": "WheaDxe",
    "54891A9E-763E-4377-8841-8D5C90D88CDE": "TerminalSrc",
    "54975633-0945-4D9C-97C2-E0CC6469A5A3": "MeLibPei",
    "54A85D82-3A54-4006-9C0E-E527295C4FA8": "SetupLangService",
    "54AB7A17-AD08-4F86-83C2-4CF398EBC0AD": "AsusPostErrDxe",
    "54CE6010-2A6D-42AA-B1E2-FD97DE9C4DA8": "AppleDebugSupportFireWireInit",
    "54D2878F-25CD-4A2B-8420-EBD18E609C76": "OemHookStatusCodeLibNull",
    "54FCC43E-AA89-4333-9A85-CDEA24051E9E": "EfiSupplicantProtocolGuid",
    "5507247A-846B-4F22-B55F-72B4049435EF": "AmtLockKBD",
    "5507E3F0-9C84-47DC-8CEA-C29A01B7CD5D": "SioBdsPlugin",
    "553087F6-BAAC-4D7F-97B4-31D8179AAE15": "GetNameInfo",
    "5542CCE1-DF5C-4D1B-ABCA-364F77D399FB": "EfiHiiCompatibilityProtocolGuid",
    "5552575A-7E00-4D61-A3A4-F7547351B49E": "SmmBaseRuntime",
    "555F76EA-785F-40D7-9174-153C43636C68": "CirrusLogic5430Dxe",
    "5568E42E-DD33-4F6C-867F-7E73451104FE": "StaticSkuDataDxeLightningRidgeEXECB4",
    "55961E20-B0D9-4553-9948-E3ECF0BE0889": "PlatformConfigPei",
    "55B1D734-C5E1-49DB-9647-B16AFB0E305B": "EfiHash2ProtocolGuid",
    "55B71FB5-17C6-410E-B5BD-5FA2E3D4466B": "EfiI2cBusConfigurationManagementProtocolGuid",
    "55D460DB-8FEA-415A-B95D-70145AE0675C": "DxePrintLibPrint2Protocol",
    "55E76644-78A5-4A82-A900-7126A5798892": "HeciInitDxe",
    "5604D863-BF24-439B-BBF6-636D72036E07": "SpiUtil",
    "560BF58A-1E0D-4D7E-953F-2980A261E031": "EfiSioVariableGuid",
    "563C75D2-045D-43FD-A7C0-A472B0AD0255": "gear6",
    "56417BED-6BBE-4882-86A0-3AE8BB17F8F9": "EfiKmsFormatRsasha11024Guid",
    "564B33CD-C92A-4593-90BF-2473E43C6322": "EfiHobMemoryAllocBspStoreGuid",
    "565D3FCA-F06D-4FED-95EB-370EDFFA9E57": "AsrBootOptionDxe",
    "565EC8BA-A484-11E3-802B-B8AC6F7D65E6": "XenBusDxe",
    "56B70419-7103-4D0E-83F4-F3546BD21E40": "EzFileBrowser",
    "56BF094C-69F6-49DD-8C1C-1ECEFF71C9E5": "CsmRt32",
    "56D60EE4-5CCF-485C-BBBB-FEDAE2B24146": "RegAccessDxe",
    "56EC3091-954C-11D2-8E3F-00A0C969723B": "EfiLoadFileProtocolGuid",
    "56ED21B6-BA23-429E-8932-376D8E182EE3": "FspPerformanceDataGuid",
    "571A2DDE-E141-4D73-927D-85F5A7BB187E": "AmiTcgLibDxe",
    "577D959C-E967-4546-8620-C778FAE5DA05": "EfiDebuggerConfigurationProtocolGuid",
    "5788464F-3773-4A29-8AF7-E81BBEE419C3": "ATAIdentify",
    "578C315A-68CF-4E81-B5C6-22DB40D010BC": "EfiI2cMasterProtocolGuid",
    "57E56594-CE95-46AD-9531-3C49310CA7CE": "OFBD",
    "57F55732-CF55-43C7-B66B-216CE2282888": "MonoStatusCodePei",
    "5802BCE4-EEEE-4E33-A130-EBAD27F0E439": "MsegSmramGuid",
    "580DD900-385D-11D7-883A-00500473D4EB": "UHCD",
    "5810798A-ED30-4080-8DD7-B9667A748C02": "HashInstanceLibSha256",
    "5820EEB4-C135-4854-9D2A-AA9EFC4475E9": "MeFwDowngrade",
    "587E72D7-CC50-4F79-8209-CA291FC1A10F": "EfiHiiConfigRoutingProtocolGuid",
    "58830DE7-9739-4869-88BE-DC8CA24CE9C1": "AutoMeud",
    "58A90A52-929F-44F8-AC35-A7E1AB18AC91": "FPVARBAK",
    "58C518B1-76F3-11D4-BCEA-0080C73C8881": "EfiWinNtThunkProtocolGuid",
    "58DC368D-7BFA-4E77-ABBC-0E29418DF930": "EfiSmmIoTrapDispatch2ProtocolGuid",
    "58E26F0D-CBAC-4BBA-B70F-18221415665A": "VirtioRngDxe",
    "58E6ED63-1694-440B-9388-E98FED6B65AF": "EfiSocketProtocolGuid",
    "5917EF16-F723-4BB9-A64B-D8C532F4D8B5": "EfiUserCredentialClassHandprintGuid",
    "591F64F9-1CB8-4029-8868-F5A2C0CF3600": "I2cMmioDeviceDxe",
    "59242DD8-E7CF-4979-B60E-A6067E2A185F": "LegacyRegion",
    "59287178-59B2-49CA-BC63-532B12EA2C53": "PchSmbusSmm",
    "59324945-EC44-4C0D-B1CD-9DB139DF070C": "EfiIScsiInitiatorNameProtocolGuid",
    "5959E027-BAB0-4342-AA4B-8F73F017B485": "OemRuntimeFunction",
    "597F29A1-F354-4FBB-AFF4-BCBDA6A87C2C": "LpcFlashPeiLibNull",
    "59ADD62D-A1C0-44C5-A90F-A1168770468C": "PlatformInit",
    "59AF16B0-661D-4865-A381-38DE68385D8D": "OpalSecurity",
    "59B90A53-461B-4C50-A79F-A32773C319AE": "IdeBusSrc",
    "59D1C24F-50F1-401A-B101-F33E0DAED443": "EfiGenericVariableGuid",
    "5A235B65-4BA0-4A97-89A2-C127DEA193A2": "AsusOnBoardDimm",
    "5A38B969-CD6A-4814-82E6-559F840BBC58": "ISPDxe",
    "5AAB83E5-F027-4CA7-BFD0-16358CC9E453": "WdtDxe",
    "5AC804F2-7D19-5B5C-A22D-FAF4A8FE5178": "AcpiVariableHobOnSmramReserveHob",
    "5AE0C053-C2B3-4E7D-ADD9-FD3CEBC6D3D9": "SlotDataUpdateDxeLightningRidgeEXRP",
    "5AE3F37E-4EAE-41AE-8240-35465B5E81EB": "CORE_DXE",
    "5AEA42B5-31E1-4515-BC31-B8D5257565A6": "EfiExtendedSalBaseIoServicesProtocolGuid",
    "5B02E5E0-C169-49F9-879A-CE1806F0357A": "IpmiBoot",
    "5B1B31A1-9562-11D2-8E3F-00A0C969723B": "EfiLoadedImageProtocolGuid",
    "5B232086-350A-42C7-A70E-3497B5765D85": "OEMSSDT",
    "5B446ED1-E30B-4FAA-871A-3654ECA36080": "EfiIp4Config2ProtocolGuid",
    "5B51FEF7-C79D-4434-8F1B-AA62DE3E2C64": "EfiDMArGenericErrorSectionGuid",
    "5B60CCFD-1011-4BCF-B7D1-BB99CA96A603": "FatPei",
    "5B6DAB96-195D-4D24-9727-A7D0E93665C6": "IconSD",
    "5B94E419-C795-414D-A0D4-B80A877BE5FE": "FspSecCoreT",
    "5BAB88BA-E0E2-4674-B6AD-B812F6881CD6": "DxeVlvPlatformPolicyGuid",
    "5BAD89FF-B7E6-42C9-814A-CF2485D6E98A": "EfiEventNotificationTypeNmiGuid",
    "5BBA83E5-F027-4CA7-BFD0-16358CC9E123": "IccOverClocking",
    "5BBA83E6-F027-4CA7-BFD0-16358CC9E123": "IntelIvbGopDriver",
    "5BDDE605-B107-419E-9510-AA3C434EBBE4": "PlatformCsmDxe",
    "5BE3BDF4-53CF-46A3-A6A9-73C34A6E5EE3": "NvmExpressDxe",
    "5BE40F57-FA68-4610-BBBF-E9C5FCDAD365": "GetPcdInfoProtocolGuid",
    "5BEDB5CC-D830-4EB2-8742-2D4CC9B54F2C": "Ip6Dxe",
    "5BF3654C-7E7D-4FBA-8BC6-2AEBCD6F68EB": "Apple80211",
    "5C08E2E2-AD70-4C99-94A2-AE604EA033DA": "IcnsConvert",
    "5C0FB3B9-F7BB-467B-A4DC-89D7D5A58432": "ResLoader",
    "5C198761-16A8-4E69-972C-89D67954F81D": "EfiDriverSupportedEfiVersionProtocolGuid",
    "5C1997D7-8D45-4F21-AF3C-2206B8ED8BEC": "PL061GpioDxe",
    "5C266089-E103-4D43-9AB5-12D7095BE2AF": "IntelSaGopDriver",
    "5C44EAF7-FF0B-462E-87F4-2D46460BF48F": "TraceHubStatusCodeHandlerSmm",
    "5C7F8702-838F-43DF-91E6-7833B6F2A067": "DxeCoreReportStatusCodeLibFromHob",
    "5C98DE6E-CB69-465F-B6B9-F661E26E6F9D": "LibGdtoa",
    "5CAC0099-0DC9-48E5-8068-BB95F5400A9F": "RecoveryOnDataCdGuid",
    "5CB5C776-60D5-45EE-883C-452708CD743F": "EfiLoadPeImageProtocolGuid",
    "5CDDFAF3-E9A7-4D16-BDCE-1E002DF475BB": "UefiDebugLibConOut",
    "5CDEEC47-2538-11E7-A438-B8E8562CBAFA": "AppleVoiceOver",
    "5CEA02C9-4D07-69D3-269F-4496FBE096F9": "EfiPersistentVirtualDiskGuid",
    "5CF32E0B-8EDF-2E44-9CDA-93205E99EC1C": "EmuThunkProtocolGuid",
    "5CF32E68-7660-449B-80E6-7EA36E03F6A8": "EfiUserCredentialClassUnknownGuid",
    "5D1F3F9E-8CEE-4299-93C2-4C64EBB58977": "GetServByName",
    "5D337D63-2677-4868-8251-B97C6D1F0E90": "YukonEthernet",
    "5D8111C9-B4F9-46F3-9DDB-73A41AC696C5": "password_capslock_indicator",
    "5D9F96DB-E731-4CAA-A00D-72E187CD7762": "EfiEapProtocolGuid",
    "5DAF50A5-EA81-4DE2-8F9B-CABDA9CF5C14": "SecureBootConfigFormSetGuid",
    "5DC03827-C9CB-4C83-B15F-6EAFBF86476C": "AppleUartDxe",
    "5DEF82D2-6ED7-47DE-B0AC-11E55BAFFB05": "LpcFlashLibNull",
    "5DF9946D-8170-4FB5-854F-A98865F9878F": "gear5",
    "5E523CB4-D397-4986-87BD-A6DD8B22F455": "AtaAtapiPassThruDxe",
    "5E559C23-1FAA-4AE1-8D4A-C6CF026C766F": "FirmwareIdGuid",
    "5E93C847-456D-40B3-A6B4-78B0C9CF7F20": "EfiEapManagement2ProtocolGuid",
    "5E948FE3-26D3-42B5-AF17-610287188DEC": "EfiDiskInfoIdeInterfaceGuid",
    "5E975522-176F-4E2D-BB25-64ADCC7792A4": "BaseDebugDeviceLibNull",
    "5E9CABA3-F2B1-497A-ADAC-24F575E9CDE9": "TcgDxe",
    "5EC9DF0F-9FB9-4CD5-9BAE-12872F032A6A": "PeiIpmiUsb",
    "5F03BA33-8C6B-4C24-AA2E-14A2657BD454": "EfiUserCredentialClassSmartCardGuid",
    "5F05B20F-4A56-C231-FA0B-A7B1F110041D": "EfiRegexSyntaxTypePosixExtendedGuid",
    "5F439A0B-45D8-4682-A4F4-F0576B513441": "EfiSmmCpuIoGuid",
    "5F4735F7-DCF9-40FD-8858-026F931942A9": "DxeIchInit",
    "5F5F605D-1583-4A2D-A6B2-EB12DAB4A2B6": "ShellBcfgHiiGuid",
    "5F6A843E-D188-41A3-BA3C-A83D8997DC7F": "BootPriority",
    "5F82BC22-85E1-489D-93A1-42BBD664B434": "IioCfgUpdateDxeLightningRidgeEXECB1",
    "5FAD2389-2BC7-4BD2-83D3-429FB6AEA33F": "EfiSerialPortTokenSpaceGuid",
    "5FB81FA3-BF65-43AD-A47B-DF70C3112B5A": "SvSmmHandler",
    "5FCEA791-516E-4B61-892C-7229D4FF23D4": "Int15ActiveLFP",
    "5FECEF6B-5FA4-4570-8163-0CF72A9C04C5": "Ps2Main",
    "6010BEA0-A051-408D-9A6E-B744D468A05D": "WinCapsuleUpdate",
    "602160C7-E080-4AFE-BE4A-BB5D9B87042D": "AcpiTableDxe",
    "6046E678-24EF-4005-BA39-BDA11F6D555D": "AmtInt16_csm",
    "6048B8EC-6D17-45C0-9BCF-63D164B41AB3": "LanRom",
    "605CED2C-583B-4171-9311-AA6E146B1A4B": "I2cPortA0Pio",
    "605EA650-C65C-42E1-BA80-91A52AB618C6": "EfiEndOfPeiSignalPpiGuid",
    "60740CF3-D428-4500-80E6-04A5798241ED": "HstiIhvProviderDxe",
    "6074610C-93C6-4A50-9AAA-0927DE7C6975": "FirewireDeviceDxe",
    "60798953-1E91-46C9-B521-316623424522": "WheaErrorLog",
    "607F766C-7455-42BE-930B-E4D76DB2720F": "EfiTrEEProtocolGuid",
    "60812E8C-505B-4D3E-A5B7-1715656CE362": "ProjectDxeDriver",
    "60A14F6F-55B9-47A3-B067-01A93027F3FE": "AppleMemoryTest",
    "60AC3A8F-4D66-4CD4-895A-C3F06E6665EE": "iFfsAcpiTables",
    "60B5E939-0FCF-4227-BA83-6BBED45BC0E3": "EfiBootStateGuid",
    "60EC7720-512B-4490-9FD1-A336769AE01F": "SmmControlPei",
    "60FABA47-419B-4E50-85C7-20E86AEE00FC": "ASRockNetTcpWrapper",
    "60FF8964-E906-41D0-AFED-F241E974E08E": "EfiDxeSmmReadyToLockProtocolGuid",
    "6107BE23-5BAA-4FC9-8FC9-F2AEA77B07A7": "FireWireOhci",
    "61422D26-81EC-47FF-B6CF-939EAEE73FBA": "StatusCodeDxe",
    "617076FC-65EE-4340-9B18-7E72FEC05D5A": "SmcAOCPei",
    "6195F786-D7B1-45F1-9AC7-82EF976ADF4C": "SmcNVDIMMSmmDriver",
    "61A4D49E-6F68-4F1B-B922-A86EED0B07A2": "EfiUgaIoProtocolGuid",
    "61AD3083-DCAD-4850-A50C-73B23B3B14F9": "IsaIoDxe",
    "61AFA223-8AC8-4440-9AB5-762B1BF05156": "Mtftp4Dxe",
    "61AFA251-8AC8-4440-9AB5-762B1BF05156": "Mtftp6Dxe",
    "61C68702-4D7E-4F43-8DEF-A74305CE74C5": "PeiSmmControlPpiGuid",
    "61EC04FC-48E6-D813-25C9-8DAA44750B12": "EfiPlatformMemory2ErrorSectionGuid",
    "61ED3D94-30D8-408C-97DF-DEDF2740F630": "AmtLockPbtn",
    "621734D8-8B5E-4C01-B330-9F89A1081710": "PlatformHookLibSerialPortPpi",
    "62408AD5-4EAC-432B-AB9B-C4B85BFAED02": "DxeIpmiLibIpmiProtocol",
    "627EE2DA-3BF9-439B-929F-2E0E6E9DBA62": "BootScriptSmmPrivateDataGuid",
    "628A497D-2BF6-4264-8741-069DBD3399D6": "ConSplitter",
    "62960CF3-40FF-4263-A77C-DFDEBD191B4B": "EfiBluetoothConfigProtocolGuid",
    "6298FE18-D5EF-42B7-BB0C-2953283F5704": "SleepSmi",
    "62C1E22F-BF7A-462E-A037-BF97BBC3ADF9": "EzConfigDxe",
    "62D171CB-78CD-4480-8678-C6A2A797A8DE": "CpuInitDxe",
    "62DC08AC-A651-4EE9-AF81-EAA9261E9780": "S3NvramSave",
    "62E135CA-88C1-4F15-93E1-01193B3499F4": "ASiXUsbEthernet",
    "62FC1B9A-8851-4654-90AD-CEA8C07FE259": "IchSpi",
    "63017E66-D790-4EE6-A0AC-6192AA74ACF7": "UCR",
    "6302D008-7F9B-4F30-87AC-60C9FEF5DA4E": "EfiShellProtocolGuid",
    "630AEB10-2106-4234-9DB3-836A3663F50D": "BaseCacheAsRamLibNull",
    "63296C52-01CF-4EEA-A47C-782A14DA6894": "SmramSaveInfoHandlerSmm",
    "632D5625-B73D-43B8-AF30-8D225D96168E": "BasePalLibNull",
    "6339D487-26BA-424B-9A5D-687E25D740BC": "Tcg2ConfigFormSetGuid",
    "634E8DB5-C432-43BE-A653-9CA2922CC458": "Nvme",
    "6372357A-06D7-43EF-B55C-1964F3DD6916": "DxeIpmiBmcInitialize",
    "637E0BA6-C5BB-41B7-A23B-3A65CFC3E9DB": "BatteryState5",
    "63809859-F029-41C3-9F34-EEEB9EA787A5": "IioInit",
    "63811871-CCD2-1042-AACB-5E5B88FF6E68": "DiagAccess",
    "63819805-67BB-46EF-AA8D-1524A19A01E4": "SmallLogo",
    "63819805-DDDD-46EF-AA8D-1524A19A01E4": "SmallLogo",
    "6388CB0C-CD3A-4D1E-B26C-4D823D8B4BDF": "PciExpressDxe",
    "639707CE-F961-4F3D-99BD-7DFAFFCB1D54": "PlatformInit",
    "63AAAFFA-53BD-4ED1-B5A3-A8A5619C563F": "SlotDataUpdateDxeLightningRidgeEXECB2",
    "63B2BC2D-DF5D-419B-873C-2C78A6604A7A": "SgDxePolicyInit",
    "63B6E435-32BC-49C6-81BD-B7A1A0FE1A6C": "PeiSmbusPolicyPpiGuid",
    "63C4785A-CA34-4012-A3C8-0B6A324F5546": "EfiRngAlgorithmX9313DesGuid",
    "63DAB9CE-5D03-4560-8A89-D81366363A2C": "ChipsetErrReporting",
    "63E3BDCF-2AC7-4AC0-9B92-03A7541422FF": "Hash2DxeCrypto",
    "63E60A51-497D-D427-C4A5-B8ABDC3AAEB6": "EfiRegexSyntaxTypePerlGuid",
    "63EA1463-FBFA-428A-B97F-E222755852D7": "HighMemDxe",
    "63FA7900-6DD2-4BB3-9976-870FE27A53C2": "BackButtonSmall",
    "64196C76-58E3-0B4D-9484-B54F7C4349CA": "BootModePei",
    "642237C7-35D4-472D-8365-12E0CCF27A22": "BootMaintFormSetGuid",
    "642CD590-8059-4C0A-A958-C5EC07D23C4B": "EfiPlatformToDriverConfigurationProtocolGuid",
    "643DF777-F312-42ED-81CC-1B1F57E18AD6": "PchSmbusArpDisabled",
    "6441F818-6362-4E44-B570-7DBA31DD2453": "EfiVariableWriteArchProtocolGuid",
    "645462F4-AF50-4FC5-838F-1DFBE3225511": "UsbCdcNcm",
    "6456ED61-3579-41C9-8A26-0A0BD62B78FC": "Ip4IScsiConfigGuid",
    "64980BB9-7BA3-4CB0-AA83-FE396A7F6724": "UbaMainPeim",
    "64A11188-5B86-4F59-A702-73365896E65E": "AcpiVTD",
    "64A892DC-5561-4536-92C7-799BFC183355": "EfiIsaAcpiProtocolGuid",
    "64AAEAE0-92DF-4980-8668-6EB5EAAF4393": "FvInfoPei",
    "650DFE73-6AC8-45E6-9215-9872BEC8B276": "ICCDXE",
    "652B38A9-77F4-453F-89D5-E7BDC352FC53": "PeiUsbHostControllerPpiGuid",
    "654FE61A-2EDA-4749-A76A-56ED7ADE1CBE": "CmosPei",
    "65530BC7-A359-410F-B010-5AADC7EC2B62": "EfiTcp4ProtocolGuid",
    "655E4C19-9D7B-4491-AD10-A49FF355C00A": "FastBootOptionBds",
    "6568A3D6-015F-4B4A-9C89-1D146314130A": "EfiSmmBaseThunkCommunicationGuid",
    "65A18235-5096-4032-8C63-214F0249CE8D": "BaseMemoryLibSse2",
    "65E5746E-9C14-467D-B5B3-932A66D59F79": "XhciPei",
    "6653876C-F6A1-45BB-A027-20455093BC6D": "SecPeiFspPlatformSecLibVlv2",
    "66595A32-1877-4AE1-8748-809666EDADC7": "AppleVTdDxe",
    "665E3FF5-46CC-11D4-9A38-0090273FC14D": "EfiWatchdogTimerArchProtocolGuid",
    "665E3FF6-46CC-11D4-9A38-0090273FC14D": "EfiBdsArchProtocolGuid",
    "667A8B1C-9C97-4B2A-AE7E-568772FE45F3": "BaseResetSystemLibNull",
    "667DD791-C6B3-4C27-8A6B-0F8E722DEB41": "EfiEventNotificationTypeDmarGuid",
    "669346EF-FDAD-4AEB-08A6-21462D3FEF7D": "PerformancePkgTokenSpaceGuid",
    "6695974D-968C-420B-80B9-7870CD20118F": "PlatformSecLibNull",
    "6696936D-3637-467C-87CB-14EA8248948C": "SimpleTextInOutSerial",
    "66BF079F-2A14-47ED-A0F2-90CAF356E088": "ASM108XPEI",
    "66DE8584-DE01-4BAB-B5D0-8B99594372FC": "IchUhciPei",
    "66ED4721-3C98-4D3E-81E3-D03DD39A7254": "EfiUdp6ServiceBindingProtocolGuid",
    "6707536E-46AF-42D3-8F6C-15F2F202C234": "MXMdat",
    "672A0C68-2BF0-46F9-93C3-C4E7DC0FA555": "UsbCredentialProvider",
    "67439E94-FD37-4A32-BD53-3B97386432E4": "Ahci",
    "67451698-1825-4AC5-999D-F350CC7D5D72": "CryptoPPI",
    "6776572C-FE56-42CA-9B93-3D0960E7583A": "IconBrokenBoot",
    "67791E00-0C05-4AE7-A921-FC4057221653": "TxtOneTouchDxe",
    "67820532-7613-4DD3-9ED7-3D9BE3A7DA63": "Aint13",
    "67AC0B1E-54C2-41A6-B57E-C2A321416ABC": "ActiveBios2",
    "67C4F112-3385-4E55-9C5B-C05B717C4228": "EfiSmmSwapAddressRangeProtocolGuid",
    "67C53648-DA56-4726-AE21-FBA4D04686B3": "RsdpPlus",
    "67C63A11-F89D-4500-8270-D9DB251EB2AF": "Ps2KeyboardPei",
    "67F8444F-8743-48F1-A328-1EAAB8736080": "EfiCertRsa2048Sha1Guid",
    "67FA951E-4FA2-9F4E-A658-4DBD954AC22E": "PlatformSmbiosDxe",
    "6806C45F-13C4-4274-B8A3-055EF641A060": "DxeFileExplorerProtocol",
    "6807217E-E8DE-42D0-91D9-60AECED7420D": "Stall",
    "681F3771-6F1D-42DE-9AA2-F82BBCDBC5F9": "WinNtFlashMapPei",
    "682FC854-D0CB-4C9F-A8C4-F4F97A39EF3E": "OemProcMemInitLibPpi",
    "6834FE45-4AEE-4FC6-BCB5-FF45B7A871E2": "BeagleBoardTokenSpaceGuid",
    "6847CC74-E9EC-4F8F-A29D-AB44E754A8FC": "ArmMpCoreInfoPpiGuid",
    "68501047-111F-4BD2-AA33-6C1ECE271259": "ApplePlatformInitDxe",
    "6869C5B3-AC8D-4973-8B37-E354DBF34ADD": "CmosManagerSmm",
    "6877BA45-7E87-449F-984F-FD04503D7A28": "SmcSetPowerStatusSmm",
    "687A830D-55FB-415A-9520-182789353284": "SetupExit",
    "6888A4AE-AFCE-E84B-9102-F7B9DAE6A030": "EmuBlockIoProtocolGuid",
    "6895F6F0-8879-45B8-A9D9-9639E532319E": "UhciPeiUsb",
    "689CDA29-29A8-42F6-93FC-46BA5F180651": "ImagePasswordProceed",
    "689E4C62-70BF-4CF3-88BB-33B318268670": "EfiBlockIoCryptoAlgoAesCbcMsBitlockerGuid",
    "68D076CD-D8F3-409B-987F-1012CDB88242": "SlotDataUpdateDxeLightningRidgeEXECB4",
    "68D89864-C0A8-490D-BE18-C83D67240928": "SmbiosDataUpdateDxeNeonCityFPGA",
    "6903A447-CB4F-45F6-89A2-7E7E2F9EE14C": "InstallMsdm",
    "69282DF3-778F-4269-91AA-D7DF6E193317": "Uc2OnUcThunk",
    "695BEC93-82AE-4C17-BDAD-7F184F4E651D": "LibC",
    "695D8AA1-42EE-4C46-805C-6EA6BCE799E3": "EfiPeiVirtualBlockIoPpiGuid",
    "69735520-DA83-444A-93DC-BDDD59E59182": "Heci3Smm",
    "697D81A2-CF18-4DC0-9E0D-06113B618A3F": "EfiExtendedSalMpServicesProtocolGuid",
    "6987936E-ED34-44DB-AE97-1FA5E4ED2116": "HelloWorld",
    "69A79759-1373-4367-A6C4-C7F59EFD986E": "FspReservedMemoryResourceHobGuid",
    "69D13BF0-AF91-4D96-AA9F-2184C5CE3BC0": "PlatformModuleTokenSpaceGuid",
    "69E1A19F-BC8C-4021-B3D9-E0B2545092C6": "OC_Tuner",
    "69E6DD6D-F09E-485F-9627-EB70E9CFC82A": "UbaInitDxe",
    "69FD8E47-A161-4550-B01A-5594CEB2B2B2": "IdeBusDxe",
    "6A056C67-3128-4102-9EC7-265E73AAB860": "GopCardEnabler",
    "6A061113-FE54-4A07-A28E-0A69359EB069": "SgTpvACPI",
    "6A1EE763-D47A-43B4-AABE-EF1DE2AB56FC": "EfiHiiPackageListProtocolGuid",
    "6A3DEF38-0A45-4107-A74E-ABF2B8EAED86": "MemorySubClass",
    "6A7A5CFF-E8D9-4F70-BADA-75AB3025CE14": "EfiComponentName2ProtocolGuid",
    "6AC5D123-C6E5-41BA-9BE3-A0371EE54B78": "SetupConfigUpdateDxeNeonCityFPGA",
    "6ADFFA83-55AE-4C9F-94A4-800C469BDABC": "StaticSkuDataDxeLightningRidgeEXECB2",
    "6AFD2B77-98C1-4ACD-A6F9-8A9439DE0FB1": "EfiSmmStatusCodeProtocolGuid",
    "6B1AB225-2E47-4A61-8FF5-B8EA42EE3EA8": "SecureFlashDxe",
    "6B1C5323-297E-4720-B959-56D6F30FEE00": "YieldingDelayDxe",
    "6B1EFA14-06B8-4127-975A-5B2DCF5392E2": "SmcPostMsgHotKey_DXE",
    "6B26DE1E-3DF2-4A1D-9B7F-B816B8C90872": "ComputraceSmm",
    "6B309956-6617-472B-BBC7-2A09E55E3E52": "ProgressBarFullLeftEndcap",
    "6B30C738-A391-11D4-9A3B-0090273FC14D": "EfiPlatformDriverOverrideProtocolGuid",
    "6B38F7B4-AD98-40E9-9093-ACA2B5A253C4": "DiskIoDxe",
    "6B41B553-A649-11D4-BD02-0080C73C8881": "WinNtSerialIoDxe",
    "6B4FDBD2-47E1-4A09-BA8E-8E041F208B95": "PchUsbPei",
    "6B558CE3-69E5-4C67-A634-F7FE72ADBE84": "BlockMmioProtocolGuid",
    "6B6FD380-2C55-42C6-98BF-CBBC5A9AA666": "SocketSetup",
    "6B7067C7-A843-A34C-9530-48446963B740": "KeyMapLibNull",
    "6B789215-B063-45FD-868A-668A49F00EC6": "TXTWrapperPei",
    "6B844C5B-6B75-42CA-8E8E-1CB94412B59B": "TcgPeiplatform",
    "6B8947C2-4287-4D91-8FE0-A381EA5B568F": "rmHwA15Guid",
    "6B9FD3F7-16DF-45E8-BD39-B94A66541A5D": "EdkiiPiSmmMemoryAttributesTableGuid",
    "6BB4F5CD-8022-448D-BC6D-771BAE935FC6": "EfiKmsFormatSha256256Guid",
    "6BE18C9C-BF61-499E-88EC-5CD57430460C": "PchSmiDispatcher_",
    "6BE272C7-1320-4CCD-9017-D4612C012B25": "AdapterInfoPlatformSecurityGuid",
    "6C077FAF-8258-4C08-B86D-B8DC632632B4": "SmmPlatform",
    "6C0E75B4-B0B9-44D1-8210-3377D7B4E066": "SmmAccessPei",
    "6C160B26-E04C-4098-A6AC-C8C7B6471A86": "SetupConfigUpdateDxeLightningRidgeEXECB2",
    "6C2004EF-4E0E-4BE4-B14C-340EB4AA5891": "StatusCodeHandlerRuntimeDxe",
    "6C289241-E240-483F-9E3E-872C0396B599": "FlashSmiSmm",
    "6C79BA9B-5926-4295-A450-46B3401D95A5": "AcpiPlatform1",
    "6CC094E8-8278-47AB-868C-D826539968C1": "AsusPcie2ClkReqMapping",
    "6CC45765-CCE4-42FD-BC56-011AAAC6C9A8": "EfiPeiReset2PpiGuid",
    "6CDDBF28-89AC-4E01-9692-616B8A1009C8": "FvFileLoaderOnLoadFileThunk",
    "6CE6B0DE-781C-4F6C-B42D-98346C614BEC": "HpetTimerDxe",
    "6D1D13B3-8874-4E92-AED5-22FC7C4F7391": "BiosGuardDxe",
    "6D33944A-EC75-4855-A54D-809C75241F6C": "BdsDxe",
    "6D497A7A-D7DA-467C-B485-B7FB3493C41F": "DxePciSegementLibEsal",
    "6D4BAA0B-F431-4370-AF19-99D6209239F6": "BiosGuardServices",
    "6D582DBC-DB85-4514-8FCC-5ADF6227B147": "EfiPeiS3Resume2PpiGuid",
    "6D5C61C2-7694-4775-9F03-ED1E80DEC318": "menu_top_mid",
    "6D6963AB-906D-4A65-A7CA-BD40E5D6AF2B": "Udp4Dxe",
    "6D6963AB-906D-4A65-A7CA-BD40E5D6AF4D": "Tcp4Dxe",
    "6D86FB36-BA90-472C-B583-3FBED3FB209A": "FspHobGuid",
    "6DADA47D-645A-4128-B292-57A475E1456A": "AppleSecureBootDxe",
    "6DADF1D1-D4CC-4910-BB6E-82B1FD80FF3D": "EfiSmmPeiSmramMemoryReserveGuid",
    "6DB075DE-449E-2644-96D0-CC5A1B4C3B2A": "FirmwareVolumePei",
    "6DB9486F-6AF6-4090-984D-238482CE3EA4": "BdatAccessHandler",
    "6DCBD5ED-E82D-4C44-BDA1-7194199AD92A": "EfiFmpCapsuleGuid",
    "6DDBF08B-CFC9-43CC-9E81-0784BA312CA0": "BeagleBoardTimerDxe",
    "6DFD6E9F-9278-48D8-8F45-B6CFF2C2B69C": "TpmMeasurementLibNull",
    "6E056FF9-C695-4364-9E2C-6126F5CEEAAE": "EfiPeiFirmwareVolumeInfoMeasurementExcludedPpiGuid",
    "6E057ECF-FA99-4F39-95BC-59F9921D17E4": "EdkiiSmmReadyToBootProtocolGuid",
    "6E2FFCF4-6899-414C-9B55-3A08842E650C": "AppleIvyBridgeGop",
    "6E53E391-40FC-4539-9055-06469C50AFBC": "AmiPciAccessCspBaseLibOverride",
    "6E59DF06-62D3-40B0-82B5-175CF84A94E4": "OEMPEI",
    "6E5ED30F-EC52-4136-8A41-3F4324218E41": "DeviceIoOnPciRootBridgeIoThunk",
    "6E66DAE5-4108-40B5-89A9-C6103F0639EC": "GlobeBorder",
    "6E72A82C-14A5-4F02-A377-4A423BB1817F": "WindowsNameLabel",
    "6E851687-A7A9-4AA2-8DD0-673E03E51433": "SetSockOpt",
    "6E9A4C69-57C6-4FCD-B083-4F2C3BDB6051": "FdtPlatformDxe",
    "6EB44D26-1D39-4FEB-A993-4DAAFB5F8D85": "HybridDriver",
    "6ECD1463-4A4A-461B-AF5F-5A33E3B2162B": "EfiPeiGraphicsPpiGuid",
    "6ECEFFFD-614D-452E-A81D-25E56B0DEF98": "BatteryState0",
    "6ECFCE51-5724-450C-A38A-58553E954422": "SmmAccessPeim",
    "6EEDE20E-8F32-4FE2-BEB7-7A00F3CCDBC3": "OpromUpdateDxeLightningRidgeEXRP",
    "6EFAC84F-0AB0-4747-81BE-855562590449": "XenIoProtocolGuid",
    "6F0198AA-1F1D-426D-AE3E-39AB633FCC28": "Cf9ResetDxe",
    "6F0CF054-AE6A-418C-A7CE-3C7A7CD74EC0": "LogoPcx",
    "6F20F7C8-E5EF-4F21-8D19-EDC5F0C496AE": "MemInfoProtocolGuid",
    "6F71926E-60CE-428D-AA58-A3D9FB879429": "IfConfig6",
    "6F871ADD-9D86-4676-8BAD-68E2E451FC5B": "MicrocodeFlashAccessLibNull",
    "6F8C2B35-FEF4-448D-8256-E11B19D61077": "EfiSecPlatformInformationPpiGuid",
    "6F92E393-03C0-427B-BBEB-4EF807B55BD8": "IconNetworkRecovery",
    "6FD1DCC5-B5B9-4A82-8728-8D854428A4A3": "DxeFfsGfxDriver",
    "6FD5B00C-D426-4283-9887-6CF5CF1CB1FE": "EfiUserManagerProtocolGuid",
    "6FE38843-6500-42C2-A535-7769DEA56AA4": "FpgaLoaderPeim",
    "6FF23F1D-877C-4B1B-93FC-F142B2EEA6A7": "EfiGopDisplayBrightnessProtocolGuid",
    "6FF479F5-6120-4A41-A8C9-D9500F7DF594": "Mdot2Driver",
    "70101EAF-0085-440C-B356-8EE36FEF24F0": "EfiLegacyRegion2ProtocolGuid",
    "704EA695-F373-42D4-BF1B-44BB7F60C295": "menu_bottom_left",
    "7064F130-846E-4CE2-83C1-4BBCBCBF1AE5": "AppleBootPolicy",
    "7076876E-80C2-4EE6-AAD2-28B349A6865B": "EfiCertX509Sha384Guid",
    "707BE83E-0BF6-40A5-BE64-34C03AA0B8E2": "EfiSmbusArpMapGuid",
    "7081E22F-CAC6-4053-9468-675782CF88E5": "EfiEventDxeDispatchGuid",
    "709E6472-1BCD-43BD-8B6B-CD2D6D08B967": "AcpiAtd",
    "70A4D159-1F01-4203-A598-7C2794151CE6": "EfiOsBootOptionNames",
    "70AEBF01-9EA0-48D8-AE17-3A184B12DBFE": "TseDefaultBootOrder",
    "70B221AF-FDFF-4FDE-9968-1AF623A956D9": "EfiI2cHostProtocolGuid",
    "70E1A818-0BE1-4449-BFD4-9EF68C7F02A8": "ReFlash",
    "70E56C5E-280C-44B0-A497-09681ABC375E": "DmiDataGuid",
    "70F64793-C323-4261-AC2C-D876F27C5345": "EfiKmsFormatGeneric256Guid",
    "70FB9CE0-2CB1-4FD7-80EE-AB4B6CF4B43F": "GetHostByName",
    "710E415A-6A5B-4AEA-973F-6DD3F9CB0056": "PLEDPEI",
    "711C703F-C285-4B10-A3B0-36ECBD3C8BE2": "EfiCapsuleVendorGuid",
    "71298B1B-26AA-44D8-87CD-91A087C3481A": "SmbiosDataUpdateDxeLightningRidgeEXECB3",
    "714845FE-F8B8-4B45-9AAE-708ECDDFCB77": "ExFatDxe",
    "716EF0D9-FF83-4F69-81E9-518BD39A8E70": "EfiSdMmcPassThruProtocolGuid",
    "71761D37-32B2-45CD-A7D0-B0FEDD93E8CF": "EfiDirectedIoDMArErrorSectionGuid",
    "717886AB-C40A-44CF-9114-4119E84B0DC7": "PciCfgOnPciCfg2Thunk",
    "71E218BA-0F3F-46B6-A42E-93A2C1195A31": "AmdRadeonDriver",
    "71ED12D1-250B-42FB-8C17-10DCFA771701": "LegacyInterrupt",
    "71EE5E94-65B9-45D5-821A-3A4D86CFE6BE": "EfiUserCredentialProtocolGuid",
    "71F3B066-936A-4C84-9228-23230FD47C79": "ImagePasswordFill",
    "71FD84CD-353B-464D-B7A4-6EA7B96995CB": "NonDiscoverablePciDeviceDxe",
    "71FE861A-5450-48B6-BFB0-B93522616F99": "TPS65950",
    "721ACF02-4D77-4C2A-B3DC-270B7BA9E4B0": "FspNonVolatileStorageHobGuid",
    "721C8B66-426C-4E86-8E99-3457C46AB0B9": "TextSetupDxe",
    "72234213-0FD7-48A1-A59F-B41BC107FBCD": "ACPIOSFRVariableGuid",
    "7235C51C-0C80-4CAB-87AC-3B084A6304B1": "OvmfPlatformConfigGuid",
    "7279D04D-AAAE-994A-8A5C-5AEA41D1FE3A": "AppleArpDxe",
    "728CAE6C-1FFC-449B-8681-BB2A621E0022": "ContinueButtonSmall",
    "72D78EA6-4DEE-11E3-8100-F3842A48D0A0": "Isp1761PeriphDxe",
    "72E40094-2EE1-497A-8F33-4C934A9E9C0C": "EfiSmmSmbusProtocolGuid",
    "72FE44FF-44FC-4653-918A-0D5E76C416D2": "SetupConfigUpdateDxeLightningRidgeEXECB3",
    "7300C4A1-43F2-4017-A51B-C81A7F40585B": "EfiSmmStandbyButtonDispatch2ProtocolGuid",
    "733CBAC2-B23F-4B92-BC8E-FB01CE5907B7": "FvbServicesRuntimeDxe",
    "734F8167-996B-4C5D-BBA3-815A72167FF8": "BFGDxe",
    "735F8C64-D696-44D0-BDF2-447FD05A5406": "EmbeddedExternalDeviceProtocolGuid",
    "736D8886-6D2B-4684-ADDE-84BFAB0F2737": "SmiFlashLibs",
    "737FE1C2-15E7-45D6-B37B-319FE880F733": "SmmBase",
    "7385DBBE-8050-4FAF-8B64-4C386E1FAA88": "CodeAccessCheckS3Pei",
    "738A9314-82C1-4592-8FF7-C1BDF1B20ED4": "ShellTftpHiiGuid",
    "738C6917-71F0-4D45-AB68-91744136AEEA": "AppleIpAgent",
    "739C2226-3264-4454-991C-8DC44A73D6AF": "ProjectPeiDriver",
    "73ADAAC0-9857-4D74-B0D7-EC6094882D99": "BaseTraceHubDebugLibNull",
    "73E6F6B4-D029-4E87-8405-6067C8BD02A6": "UsbPei",
    "73E9457A-CEA1-4917-9A9C-9F1F0F0FD322": "DebugPortDxe",
    "73F70B77-943B-4090-99E8-4F8E4D824A43": "wifi_none",
    "73FF4F56-AA8E-4451-B316-36353667AD44": "FspBootLoaderTolumHobGuid",
    "7408D748-FC8C-4EE6-9288-C4BEC092A410": "EfiPeiMasterBootModePpiGuid",
    "742F95A8-714A-5C43-88BA-B3361F12EEE6": "BootRomFlash",
    "74346897-9E0C-4B41-BF1F-BAA1ECB85DA6": "IioCfgUpdateDxeLightningRidgeEXRP",
    "744C9DBD-74DE-424D-AB59-AA398305871F": "EDIDParserDriver",
    "7462660F-1CBD-48DA-AD11-91717913831C": "EfiPciOptionRomTableGuid",
    "7474A4C6-7F30-4DE1-BC68-DA5EFE615B52": "SmbiosDataUpdateDxeNeonCityEPRP",
    "748221BC-2BA9-1545-8AA9-A03A8591999E": "AppleNetVolume",
    "7497B957-20C3-4E47-A2C0-594966FD28FD": "UefiDriverPolicyDXE",
    "74BD9FE0-8902-11E3-B9D3-F72238FC9A31": "AndroidFastbootTransportProtocolGuid",
    "74CBEC3C-8190-42A0-9C02-D1C5ADC706D7": "AppleAirport",
    "74D3B506-EE9C-47ED-B749-41261401DA78": "QNCInitDxe",
    "74D936FA-D8BD-4633-B64D-6424BDD23D24": "FwBlockServiceSmm",
    "75032015-D156-423E-BFA3-7A65ABA47105": "EfiI2cBusConfigurationManagementProtocolGuid",
    "750890A6-7ACF-4F4F-81BD-B400C2BEA95A": "AcpiModeEnable",
    "750D5755-A0C9-42D3-A326-B5D465413523": "AppleSEPDxe",
    "752F3136-4E16-4FDC-A22A-E5F46812F4CA": "EfiShellParametersProtocolGuid",
    "753630C9-FAE5-47A9-BBBF-88D621CD7282": "SmmChildDispatcher",
    "754AAF56-099B-440D-8DCD-626F4E2C52F4": "RsaIScsiSupport",
    "755877A6-4F10-4A5C-9B2E-852123B9682C": "FlashSmiDxe",
    "7585C771-3CE4-41FE-B780-845CD85BA444": "FirmwarePassword",
    "75FBCDBA-28C4-455A-A71D-536C9AB65093": "SmcSetupModify",
    "760F874E-B8CB-405E-AA32-A46AE2F3D680": "VariableDefaultUpdate",
    "7671D9D0-53DB-4173-AA69-2327F21F0BC7": "EfiAuthenticationInfoProtocolGuid",
    "768BEDFD-7B4B-4C9F-B2FF-6377E3387243": "NTFS",
    "76A7B4FC-C8D5-462D-A4D2-6E88338A772A": "PlatformCpuPolicy",
    "76B6BDFA-2ACD-4462-9E3F-CB58C969D937": "PerformanceProtocolGuid",
    "76D5CF91-0C55-434E-97C2-D2825C82E610": "OemActivation",
    "76FDC1AE-A42A-416A-98E3-A2F29146DAC3": "AppleDhcpProtocolDxe",
    "7701D7E5-7D1D-4432-A468-673DAB8ADE60": "LdrMemoryDescriptorGuid",
    "77148690-7E43-4673-AFAE-34532CDD4248": "SmmControlDxe",
    "772484B2-7482-4B91-9F9A-AD43F81C5881": "EfiMiscSubClassGuid",
    "7739F24C-93D7-11D4-9A3A-0090273FC14D": "EfiHobListGuid",
    "773CB08B-511A-4BD5-85AD-41D4F4B64A52": "AmtSetup",
    "77475D4F-7965-4038-B970-863FC73E0761": "BSDP",
    "77786445-99AC-4C2E-9FF1-990965770530": "NCT3933Smm",
    "77892615-7C7A-4AEF-A320-2A0C15C44B95": "BiosRegionLock",
    "77A6009E-116E-464D-8EF8-B35201A022DD": "DigitalThermalSensorSmm",
    "77AB535A-45FC-624B-5560-F7B281D1F96E": "EfiVirtualDiskGuid",
    "77B35E10-AC21-4DFB-B094-DDA8878A6521": "ASM1061Pei",
    "77C0B0CB-0406-4868-AEB5-C36B01D42FF6": "MemoryInitWrapper",
    "77CB5A2E-59C8-490E-B69D-A3862BE5B3A0": "EobonPriorityMap",
    "77E5B618-2612-4C28-BCDF-A2B14D8A3EFE": "IFlashDxe",
    "77EB6C06-FD48-488B-A1B3-AE0A70801369": "CryptoDXE",
    "78247C57-63DB-4708-99C2-A8B4A9A61F6B": "EfiMtftp4ProtocolGuid",
    "7827D4B0-926E-48F9-8ABD-69816EF86D16": "AppleDmgBootDxe",
    "7833616E-AE0D-594F-870C-80E68682D587": "ThunkProtocolList",
    "783658A3-4172-4421-A299-E009079C0CB4": "EfiLegacyBiosPlatformProtocolGuid",
    "783AA974-DFB0-487B-906F-120FB9486E88": "SetupConfigUpdateDxeLightningRidgeEXECB4",
    "783D7527-85EE-4A95-A909-03F745E4E91D": "TimerSmiDxe",
    "786DA51A-86A5-47C5-BF8D-04877BE47260": "AmiPciExpressGen3LibNull",
    "786EC0AC-65AE-4D1B-B137-0D110A483797": "IScsiCHAPAuthInfoGuid",
    "788DD6A1-F1EE-4BBA-A925-C0E7D66271BD": "SystemBoardDxe",
    "788E1D9F-1EAB-47D2-A2F3-78CAE87D6012": "IdccDataHubGuid",
    "78941450-90AB-4FB1-B75F-589214E24A0C": "FontPackageGuid",
    "78965B98-B0BF-449E-8B22-D2914E498A98": "EfiSmmStandbyButtonDispatchProtocolGuid",
    "78B9EC8B-C000-46C5-AC93-24A0C1BB00CE": "PwdCredentialProviderGuid",
    "78BE11C4-EE44-4A22-9F05-03852EC5C978": "EfiKmsFormatMd2128Guid",
    "78BEE926-692F-48FD-9EDB-01422EF0D7AB": "EfiEventMemoryMapChangeGuid",
    "78BF418F-559B-43D5-940A-EFFA174217F7": "DrySMI",
    "78E4D245-CD4D-4A05-A2BA-4743E86CFCAB": "EfiSecurityPolicyProtocolGuid",
    "7914C493-F439-4C6C-AB23-7F72150E72D4": "ImageAppleLogo",
    "79263F9A-1701-4382-98C2-573F3558E6C8": "PlatformFvbLibNull",
    "7942EDD0-C023-4357-93ED-F6626D711E9E": "PeiIpmiBmcInitialize",
    "795231E2-A205-4B8D-8C8D-7353B713DF7D": "efi_pop_mid_pressed",
    "798E722E-15B2-4E13-8AE9-6BA30FF7F167": "IntelSmbiosDataHobGuid",
    "79971BCB-D5C6-4D5A-9C24-BCA46C2ADBBE": "BdsDriverProxy",
    "79AA6086-035A-4AD9-A89A-A6D5AA27F0E2": "NBPEI",
    "79C3AC4A-DEC6-48F1-AFFE-E7B95A1CCB32": "PoofAnimationState2",
    "79C5C7B7-1083-42A6-AD15-2A4E7C4274D7": "DxeSmmDriverEntryPoint",
    "79CA4208-BBA1-4A9A-8456-E1E66A81484E": "Legacy8259Dxe",
    "79CB58C4-AC51-442F-AFD7-98E47D2E9908": "EfiBootScriptExecutorContextGuid",
    "79CD78D8-6EDC-4978-BD02-3299C387AB17": "StatusCodeHandlerSmm",
    "79DED328-7FCE-4909-9AFD-D66176AF97A6": "OobRx",
    "79E4A61C-ED73-4312-94FE-E3E7563362A9": "PrintDxe",
    "7A08CB98-E9BC-41C3-BE19-B302F3F1F595": "Terminal",
    "7A1CC2C0-7AF6-4F68-A564-CC03558FC3C5": "SuperMDxe",
    "7A54B36F-F745-462C-B11F-16E03E52B617": "AsusSpdTransfer",
    "7A59B29B-910B-4171-8242-A85A0DF25B5B": "EfiHttpProtocolGuid",
    "7A5DBC75-5B2B-4E67-BDE1-D48EEE761562": "EfiSmmSpiReadyProtocolGuid",
    "7A627E16-679D-4814-8F82-EEAF3881F098": "BatteryState6",
    "7A699129-DAA0-4224-8629-7338DE5D45ED": "TpmDriver",
    "7A6CA3B8-EE1B-489C-B300-24544A7BD418": "ShellCTestApp",
    "7A9354D9-0468-444A-81CE-0BF617D890DF": "EfiFirmwareFileSystemGuid",
    "7A9A372D-3487-402E-B489-5FC551A43BD1": "X11DPHDxeDriver",
    "7AB22C56-2510-4FD2-AC18-57394419FBAB": "UsbOcUpdateDxeNeonCityFPGA",
    "7AB33A91-ACE5-4326-B572-E7EE33D39F16": "EfiManagedNetworkProtocolGuid",
    "7ABBC454-F737-4322-931C-B1BB62A01D6F": "BootMonFs",
    "7ADBAD98-7FE1-4774-9260-747327435E6D": "SpsAcpiHooks",
    "7AE3CEB7-2EE2-48FA-AA49-3510BC83CABF": "PeiSeCPlatformPolicyPpiGuid",
    "7AF77F94-4C38-4FF1-8CCD-3E084F2FFEC0": "SkylakeGraphics",
    "7B2349E0-522D-4F8E-B927-69D97C9E795F": "EfiPaddingRsassaPssGuid",
    "7B7B65B6-E350-4139-8FE4-665772D32A45": "IhisiSmm",
    "7B8DB049-C7C7-4D3B-809F-926DEE47CCA2": "SBSMI",
    "7BAC95D3-0DDF-42F3-9E24-7C644940379A": "BdsStringPackGuid",
    "7BAEC70B-57E0-4C76-8E87-2F9E28088343": "EfiVT100PlusGuid",
    "7BB28B99-61BB-11D5-9A5D-0090273FC14D": "Logo",
    "7BBC4123-5D5E-4C1C-95D1-30EBA48701CA": "S4SlpDelaySmm",
    "7C04A583-9E3E-4F1C-AD65-E05268D0B4D1": "UefiShellFileGuid",
    "7C069ADA-DE4E-488C-B0FC-4F2E057D96D8": "DUFontDriver",
    "7C29785C-66B9-49FC-B797-1CA5550EF283": "PeiUsbIoPpiGuid",
    "7C81C66A-4F11-47AB-82D3-67C4D635AED1": "LegacyMebxLaunch",
    "7C9E5A63-B987-435E-B17F-9E9CFA53F880": "SmmPlatform",
    "7CA1024F-EB17-11E5-9DBA-28D2447C4829": "TlsAuthConfigDxe",
    "7CC1567C-CCB8-4C50-80BA-D44A3B667415": "AmdSb800_PeiInterfacePei",
    "7CCB2D7E-CD15-417E-A5C8-003DA6325B9F": "PowerStateManager",
    "7CE75114-8272-45AF-B536-761BD38852CE": "Slp21PubKey",
    "7CE88FB3-4BD7-4679-87A8-A8D8DEE50D2B": "EfiEventReadyToBootGuid",
    "7D019990-8CE1-46F5-A776-3C5198676AA0": "EfiExtendedSalResetServicesProtocolGuid",
    "7D113AA9-6280-48C6-BACE-DFE7668E8307": "AmiMpTpmBin",
    "7D17EF81-57C8-4210-957C-6FDAA8EA1DD6": "PciHotPlugDxe",
    "7D24A234-A8C2-4718-BF60-A2EF070F414E": "OpalPasswordSmm",
    "7D2BD134-500D-4F42-AEE2-26ACCFB6CB1D": "LibStdio",
    "7D574D54-D364-4D4A-95E3-4945DB7AD3EE": "ShellInstall1HiiGuid",
    "7D5FF0E3-2FB7-4E19-8419-44266CB60000": "DP",
    "7D77B32E-BAB2-4CC7-8378-7550513F3FCA": "UsbOcUpdateDxeLightningRidgeEXECB4",
    "7D84B2C2-22A1-4372-B12C-EBB232D3A6A3": "VlvPolicyPpiGuid",
    "7D916D80-5BB1-458C-A48F-E25FDD51EF94": "EfiTtyTermGuid",
    "7D9DDBFB-FB67-4303-90B0-9A7A7FF29B57": "OpromUpdateDxeLightningRidgeEXECB1",
    "7DADBC98-6489-4D1C-907A-8EE243AF805B": "ASUS_EUPPEI",
    "7E0C6E3E-C80F-47D1-8ADA-554926B2B6B3": "GenericMemoryTestDxe",
    "7E1F0D85-04FF-4BB2-866A-31A2996A48A8": "EfiPeiFvFileLoaderPpiGuid",
    "7E374E25-8E01-4FEE-87F2-390C23C606CD": "PlatformAcpiTable",
    "7E3D95E4-89F8-41B9-B788-5FB22D77F9A3": "SmcNVDIMMDxeDriver",
    "7E631AA5-AFCE-437B-81FA-FA34EA14B3C3": "ExFatRecovery",
    "7E97A470-EFDB-4D02-8FCE-6190D27BA296": "EfiExtendedSalRtcServicesProtocolGuid",
    "7E983BCE-5C99-4BE0-B3D0-210E8FDDD3C0": "VlanceDxe",
    "7EB7126D-C45E-4BD0-9357-7F507C5C9CF9": "RomLayoutPei",
    "7EB88C46-22FF-4CBD-8FE7-495383FAB1E4": "PciBoardDxeInit",
    "7ECD9C20-68B9-4A6F-B515-D64FF500B109": "FsRecovery",
    "7ED59FC2-3395-5DD2-A31C-1EF2F098E166": "GopConsole",
    "7EDE6A1F-548E-453E-A95C-66939FE0295C": "SwitchableGraphicsPei",
    "7EE2BD44-3DA0-11D4-9A38-0090273FC14D": "EfiIsaIoProtocolGuid",
    "7EF21E8C-2FC1-4BC3-A84A-73025EAAB896": "ProgressBarFullMiddle",
    "7F0013A7-DC79-4B22-8099-11F75FDC829D": "EfiCacheSubClassGuid",
    "7F06A90F-AE0D-4887-82C0-FEC7F4F68B29": "EmmcBlockIoPei",
    "7F1647C8-B76E-44B2-A565-F70FF19CD19E": "EfiDns6ServiceBindingProtocolGuid",
    "7F4158D3-074D-456D-8CB2-01F9C8F79DAA": "EfiTpmDeviceSelectedGuid",
    "7F480A20-7A19-4764-A5CA-4E9B8AECAF1E": "PchPciBus",
    "7F6E0A24-DBFD-43DF-9755-0292D7D3DD48": "IsaFloppyPei",
    "7F8D35BD-0CE3-4654-B5D3-73FC4B38AABF": "PlatformEarlyDxe",
    "7FA68D82-10A4-4E71-9524-D3D9500D3CDF": "PlatformSecureLibNull",
    "7FD082A9-3D6B-44E3-9C31-74D6B80F965C": "SetupConfigUpdateDxeLightningRidgeEXECB1",
    "7FED72EE-0170-4814-9878-A8FB1864DFAF": "SmmRelocateDxe",
    "7FFF52C8-82DE-4820-8960-5093102E484D": "IncompatiblePciDevice",
    "80023209-6386-4C1D-909B-63506A2146FF": "HWM_SetupDXE",
    "801ADCA0-815E-46A4-84F7-657F53621A57": "SectionExtractionDxe",
    "805B032B-6A00-46F5-8501-CB88A21D5321": "BcmDhd",
    "80897901-91F6-4EFE-9579-3353A0C02DAB": "SDMediaDevice",
    "809FBBFD-127A-4249-88BC-FD0E767F4FFD": "IconInternalHD",
    "80CF7257-87AB-47F9-A3FE-D50B76D89541": "PcdDxe",
    "80D7491A-F7D9-479D-A8F7-1B393B02ED66": "FastBootRuntime",
    "80DBD530-B74C-4F11-8C03-418665532831": "EfiMemoryConfigDataGuid",
    "80E66E0A-CCD1-43FA-A7B1-2D5EE0F13910": "PciRootBridge",
    "8108AC4E-9F11-4D59-850E-E21A522C59B2": "BmAutoCreateBootOptionGuid",
    "81212A96-09ED-4996-9471-8D729C8E69ED": "EfiFirmwareErrorSectionGuid",
    "812136D3-4D3A-433A-9418-29BB9BF78F6E": "EdkiiSystemFmpCapsuleConfigFileGuid",
    "81A4F912-E72F-44ED-8931-16A9FE9650E0": "KbcEmulDxe",
    "81CD3462-6A1A-42F8-829B-8D77481DDB64": "AmiPciExpressGen2LibNull",
    "81E4B34A-268C-4FCC-8E39-1C1D3E6F6E69": "HddReadyDXE",
    "81E67795-D8A3-43B2-8B5F-E0326F76AB91": "wifi_4bars",
    "820C59BB-274C-43B2-83EA-DAC673035A59": "SataController",
    "821C9A09-541A-40F6-9F43-0AD193A12CFE": "EdkiiMemoryProfileGuid",
    "821D8B77-246D-4E96-8E10-3467D56AB1BA": "SetupAdvanced",
    "821D8B77-246D-4E96-8E10-3467D56AB1BB": "SetupMain",
    "823B8A1A-6D01-45A6-8098-20DDD1C7B3D0": "PlatformLtDxeLibNull",
    "825880CC-DBB5-4955-8AFF-B26FA33C84AA": "AppleFirmwareFeatures",
    "826CA512-CF10-4AC9-B187-BE01496631BD": "EfiCertSha1Guid",
    "82805649-7247-4DA4-8643-C8144D27E2E5": "ProcMemErrReporting",
    "8296AF37-D183-4416-B3B6-19D2A80AD4A8": "EbcDebugger",
    "829FDCA9-6917-4713-A3AD-F04CF3E1B25F": "S4SlpDelayDxe",
    "82ECEE48-9571-4427-8485-85A5A45A0F39": "DxeSmmReadyToLockOnExitPmAuthThunk",
    "82EF44E3-2C70-11E7-8DF1-B8E8562CBAFA": "AppleVariableRuntimeDxe",
    "83381B06-2EEA-4CF3-9B5F-D75B9B5C93DE": "GetServByPort",
    "834C0C5F-ADB3-4372-AEEB-03E4E9E6C591": "IntelFspPkgTokenSpaceGuid",
    "8378AB1E-4147-400A-8D84-E3DE981C0453": "TamperResistantBoot",
    "837DCA9E-E874-4D82-B29A-23FE0E23D1E2": "VirtioMmioTransportGuid",
    "838DCF34-907B-4D55-9A4B-A0EF7167B5F4": "NvramPei",
    "83C30E53-7A4C-4273-A686-65E9DC09D75B": "AcpiDebugTable",
    "83DD3B39-7CAF-4FAC-A542-E050B767E3A7": "VirtioPciDeviceDxe",
    "83F01464-99BD-45E5-B383-AF6305D8E9E6": "EfiUdp4ServiceBindingProtocolGuid",
    "83FA5AED-5171-4949-BDC9-0CBC9E123663": "FwCapsuleRecoveryPPI",
    "8401A045-6F70-4505-8471-7015B40355E3": "UsbBusPei",
    "8401A046-6F70-4505-8471-7015B40355E3": "UsbBotPei",
    "842A454A-75E5-408B-8B1C-36420E4E3F21": "NvramSmi",
    "8434DA1F-5CEB-402E-A93C-038CBE0F3F0E": "SmmOemActivation",
    "843DC720-AB1E-42CB-9357-8A0078F3561B": "EfiSmmControl2ProtocolGuid",
    "84562A94-1CFF-11DF-AB3F-FB61AA51C41C": "PmRuntimeDxe",
    "847BC3FE-B974-446D-9449-5AD5412E993B": "BootManagerFormSetGuid",
    "8489334D-4219-4CA1-9B42-1D46B0B75861": "TcgPpVendorLibNull",
    "848E908E-BD11-428E-94F9-7A0EEFCD37A6": "BaseCsrToPcieLibNull",
    "84DDA68C-CA5A-4C30-9261-DD6DE7E45A95": "EzSetupPortingDxe",
    "84E7016D-1EB8-4637-B01E-9EED018C7AE0": "BiosGuardNvs",
    "84FA65AF-21BC-43BE-85FF-8AA7E7832A1D": "AmiPciExpressLibNull",
    "855328E7-F96F-4398-9E7F-1F0A8C014E2C": "AppleMeDriverDxe",
    "85768E4A-6CDC-444E-93DF-936685B5DFCC": "VlvRefCodePkgTokenSpaceGuid",
    "858031F3-96A2-406E-ABCC-ED264A3A31D6": "CryptRuntimeDxe",
    "858EBE6F-360F-415B-B7DC-463AAEB03412": "TcgLegacy",
    "85A084FA-6B0E-BD4C-A20E-156E46103155": "Legacy8259",
    "85A8AB57-0644-4110-850F-981322047070": "EdkiiSmmLegacyBootProtocolGuid",
    "85B75607-F7CE-471E-B7E4-2AEA5F7232EE": "EfiUserInfoAccessSetupAdminGuid",
    "8600C3A8-4213-456E-832A-D51E8E5F4AB1": "AppleHeciDxe",
    "8614567D-35BE-4415-8D88-BD7D0C9C70C0": "PlatformOverridesManagerGuid",
    "86212936-0E76-41C8-A03A-2AF2FC1C39E2": "EfiRscHandlerProtocolGuid",
    "8628752A-6CB7-4814-96FC-24A815AC2226": "EfiHashAlgorithmSha256NoPadGuid",
    "863D214F-0920-437B-8CAD-88EA83A24E97": "DatahubStatusCodeHandlerDxe",
    "864693E2-EDE8-4DF8-8871-38C0BAA157EB": "PeiFspWrapperHobProcessLibSample",
    "8650A9D0-3A80-43F2-85D8-6D10CDBF611E": "SuperMSmm",
    "8657015B-EA43-440D-949A-AF3BE365C0FC": "IoMmuDxe",
    "865A5A9B-B85D-474C-8455-65D1BE844BE2": "EfiDebugAgentGuid",
    "865A5AAB-B85D-474C-8455-65D1BE844BE2": "EfiSourceLevelDebugPkgTokenSpaceGuid",
    "86787704-8FED-11E3-B3FF-F33B73ACFEC2": "TcpFastbootTransportDxe",
    "86843F56-675D-40A5-9530-BC858372F103": "OsSelectionVariableGuid",
    "86C77A67-0B97-4633-A187-49104D0685C7": "EfiFirmwareManagementProtocolGuid",
    "86CDDF93-4872-4597-8AF9-A35AE4D3725F": "IScsiDxe",
    "86D70125-BAA3-4296-A62F-602BEBBB9081": "DxeIplPei",
    "86F61BDF-5BFD-46D3-B0F9-E43728DA1D2E": "OCMR_CPU_POWER_MANAGEMENT_DXE",
    "870E0F5A-1981-45F6-AE26-0391425CC46F": "CpuCsrAccessSMM",
    "8714C537-6D4B-4247-AA6C-29E8495F9100": "FspNotifyDxe",
    "87438836-AD8D-4E3E-9249-895120A67240": "DebugCommunicationLibUsb",
    "878AC2CC-5343-46F2-B563-51F89DAF56BA": "IntelIGopVbt",
    "87AB821C-79B8-4EF6-A913-21D22063F55F": "AcpiPlatform",
    "87C8BAD7-0595-4053-8297-DEDE395F5D5B": "EfiDhcp6ProtocolGuid",
    "87D402CD-8B07-4B93-B38B-F8799F28B033": "TXTWrapperDxe",
    "87E1BB14-4D5C-7C4E-A90E-E1415687D062": "EmuTimer",
    "87E36301-0406-44DB-AAF3-9E0E591F3725": "VConfig",
    "8803FA9A-0D33-4022-856B-AB5932A0F8BF": "AmdInitPostPeimPei",
    "880AACA3-4ADC-4A04-9079-B747340825E5": "EfiPropertiesTableGuid",
    "882C5E65-D37B-441B-A1D9-6C89C5CC3AE1": "UsbDonglePei",
    "8863C0AD-7724-C84B-88E5-A33B116D1485": "Host",
    "8868E871-E4F1-11D3-BC22-0080C73C8881": "EfiAcpi20TableGuid",
    "88888888-8888-8888-8888-888888888888": "WholeFv",
    "88A15A4F-977D-4682-B17C-DA1F316C1F32": "RomLayout",
    "88B468B3-A48B-4B87-ABE2-8E56DFFDAF8D": "DualBiosSMM",
    "88B49226-A63F-4505-9D3C-B5A67B846133": "FrameworkSmmStatusCodeOnPiSmmStatusCodeThunk",
    "88C61F0D-DFA9-4087-8687-626A8B010E0C": "PasswordLockSmall",
    "88C9D306-0900-4EB5-8260-3E2DBEDA1F89": "PeiPostScriptTablePpiGuid",
    "890A3508-E816-41CF-B7E6-ED28E5BB5C28": "AmtCompatiblity",
    "893BF598-FA5D-4B6C-8829-6016ECC443E7": "MainErrorHandler",
    "8958EDFF-02F7-4E49-87B1-FBA4BE4E8768": "SmbiosDataUpdateDxeLightningRidgeEXECB4",
    "8962C28B-0DFE-4739-A73F-092D374A7A13": "efi_pop_RT_pressed",
    "8977B212-0A43-4048-993B-B39AC7B0FE21": "gear9",
    "8987081E-DAEB-44A9-8BEF-A195B22D9417": "BasePciLibPciExpress",
    "899407D7-99FE-43D8-9A21-79EC328CAC21": "Setup",
    "899AFD18-75E8-408B-A41A-6E2E7ECDF454": "EfiExtendedSalMtcServicesProtocolGuid",
    "89A1B278-A1A1-4DF7-B137-DE5AD7C47913": "EfiPchTokenSpaceGuid",
    "89E549B0-7CFE-449D-9BA3-10D8B2312D71": "S3Resume2Pei",
    "89F09528-C33A-47FB-BA19-FADE80A39F76": "DxePlatformDxe",
    "8A002AF2-EC39-4B01-BC64-84284267DF44": "ASM104X_PEI",
    "8A107CC5-DCDA-4FB7-A272-4243B41AFBFE": "AppleGraphicsPolicy",
    "8A219718-4EF5-4761-91C8-C0F04BDA9E56": "EfiDhcp4ProtocolGuid",
    "8A4E8240-74F8-4024-AE2B-B39221C9FA59": "NvOptimusSMM",
    "8A6B4A83-42FE-45D2-A2EF-46F06C7D9852": "EfiUserCredentialClassSecureCardGuid",
    "8A78B107-0FDD-4CC8-B7BA-DC3E13CB8524": "PeiCpuIoPei",
    "8A97B11E-EE8E-11E2-B664-047D7B99E097": "AcpiOverride",
    "8AAEDB2A-A6BB-47C6-94CE-1B8096423F2A": "EfiSocketServiceBindingProtocolGuid",
    "8AC88C0F-6220-F243-8E27-56E17CC503DB": "AppleNetLoadFile2",
    "8B01E5B6-4F19-46E8-AB93-1C53671B90CC": "EfiTpmDeviceInstanceTpm12Guid",
    "8B24E4D4-C84C-4FFC-81E5-D3EACC3F08DD": "ApplePlatformInfoDB",
    "8B5FBABD-F51F-4942-BF16-16AAA38AE52B": "AcpiPlatform",
    "8B7E5420-1B71-442A-9916-C13A4FE02482": "SmbiosDataUpdateDxeLightningRidgeEXRP",
    "8B8214F9-4ADB-47DD-AC62-8313C537E9FA": "SmmBasePeim",
    "8B843E20-8132-4852-90CC-551A4E4A7F1C": "EfiDevicePathToTextProtocolGuid",
    "8B9D3EE0-4BA4-433B-9C48-4E830B3B40FD": "FloppyCtrl",
    "8BA65DE3-39E1-4AFD-A8FE-7DD0BAFEFCC0": "DxePalLibEsal",
    "8BBE7DE7-6FFB-4128-8C33-23852EBC7920": "EarlyVideoPei",
    "8BC1714D-FFCB-41C3-89DC-6C74D06D98EA": "EfiSmmPciRootBridgeIoProtocolGuid",
    "8BCEDDD7-E285-4168-9B3F-09AF66C93FFE": "S3ResumePei",
    "8BE4DF61-93CA-11D2-AA0D-00E098032B8C": "EfiGlobalVariableGuid",
    "8BEEDB0D-A31A-0361-A312-5DC8574C65F1": "AzaliaPolicyPei",
    "8C2487EA-9AF3-11E3-B966-B8AC6F7D65E6": "XenPvBlkDxe",
    "8C376010-2400-4D7D-B47B-9D851DF3C9D1": "PchMeUma",
    "8C3CFB87-F7AE-4A36-AAFF-931FDC5F436E": "AzaliaInitPei",
    "8C439043-85CA-467A-96F1-CB14F4D0DCDA": "LegacyRegionDxe",
    "8C542316-A1E5-4001-89E7-15EDFF12577D": "gear11",
    "8C783970-F02A-4A4D-AF09-8797A51EEC8D": "PowerManagement",
    "8C87E0A0-B390-4BE3-819C-7C6C83CAE4EB": "SmmBaseHelper",
    "8C8CE578-8A3D-4F1C-9935-896185C32DD3": "EfiFirmwareFileSystem2Guid",
    "8C927876-EC71-4DE4-A91D-8AD478CA9539": "CpuRas",
    "8C9D8537-9479-40F4-8C82-70D1EF5F7353": "UsbOcUpdateDxeLightningRidgeEXECB2",
    "8CB71915-531F-4AF5-82BF-A09140817BAA": "FLASHMAPBIN",
    "8CC435C5-6330-4269-B0C3-E3BD05C86FB8": "DebugCommunicationLibSerialPort",
    "8CE0E1E9-26DC-4F24-ADBD-6871B8223703": "PciSdxcDxe",
    "8CE65FC0-8F33-42A7-A2EA-46DEBE231EA6": "XhciDxe",
    "8CFC5233-23C6-49E3-8A2D-7E581AB305BA": "EdbCfg",
    "8CFDB8C8-D6B2-40F3-8E97-02307CC98B7C": "EfiVariableIndexTableGuid",
    "8D12E231-C667-4FD1-98F2-2449A7E7B2E5": "EfiSmmControlProtocolGuid",
    "8D1933CD-E806-4D83-9F9D-FF10E64D76D5": "ISL95856Pei",
    "8D1AE715-7F82-449D-A26C-62AC650AF73F": "Int15PanelType",
    "8D1F8D27-31C2-4B5B-B736-4BB5B4A25FBA": "ASRGetDLSiteWrapper",
    "8D25EF2C-2015-416E-B8AA-2369FECD4BDA": "CTA9x4ArmVExpressLibSec",
    "8D3BE215-D6F6-4264-BEA6-28073FB13AEA": "SmmThunk",
    "8D463051-692F-4924-9AEC-0A833B1BA49B": "PxeRomAr8132",
    "8D48BD70-C8A3-4C06-901B-747946AAC358": "EfiIsaHcPpiGuid",
    "8D4A8276-1994-4E82-983A-A71753617797": "menu_checked_selected",
    "8D59D32B-C655-4AE9-9B15-F25904992A43": "EfiAbsolutePointerProtocolGuid",
    "8D59EBC8-B85E-400E-970A-1F995D1DB91E": "IntelSnbGopDriver",
    "8D6756B9-E55E-4D6A-A3A5-5E4D72DDF772": "PciHostBridge",
    "8D7AE6A9-B490-45E1-8795-C2BEAADC3814": "RawIp4Rx",
    "8DD9176D-EE87-4F0E-8A84-3F998311F930": "Dhcp6Dxe",
    "8DD9176E-EE87-4F0E-8A84-3F998311F930": "Dhcp4Dxe",
    "8DD91798-EE87-4F0E-8A84-3F998311F930": "ArpDxe",
    "8DE287AC-9460-465C-B8FA-F6E9866AE56D": "xgbe_atl",
    "8DF01A06-9BD5-4BF7-B021-DB4FD9CCF45B": "EfiHashAlgorithmSha224Guid",
    "8DFAE5D4-B50E-4C10-96E6-F2C266CACBB6": "VideoRom",
    "8E325979-3FE1-4927-AAE2-8F5C4BD2AF0D": "SdMmcPciHcDxe",
    "8E477676-55FD-48CF-9210-15A99B27D740": "Slp10",
    "8E61FD6B-7A8B-404F-B83F-AA90A47CABDF": "SmmSmbiosElog",
    "8E68E3C5-FC59-4280-8467-3800D31A8162": "IccOverClocking9_5",
    "8EB48F19-CC92-4031-8D3D-EE473CCC87EB": "SystemPrivateKey",
    "8EE41730-CD91-FE40-A83A-F60F1ECB492D": "IcnsConvert",
    "8EEF9AD2-463E-425F-A4FE-2F6783D6F97E": "GenericSio",
    "8EF61509-890B-4FF2-B352-1C0E9CDDEC8B": "I2CLibPei",
    "8F0B5301-C79B-44F1-8FD3-26D73E316700": "PowerMgmtSmm",
    "8F1AC44A-CE7E-4E29-95BB-92E321BB1573": "SecFspWrapperPlatformSecLibSample",
    "8F26EF0A-4F7F-4E4B-9802-8C22B700FFAC": "EnglishDxe",
    "8F2C127E-117D-484B-8A44-FBD911BE125E": "IpmiRedirFru",
    "8F3F1DE2-2FE4-4D5C-A8EC-49E8CCA17EBC": "RsdpPlus",
    "8F4B8F82-9B91-4028-86E6-F4DB7D4C1DFF": "Bds",
    "8F4CD826-A5A0-4E93-9522-CFB0AB72926C": "SataController",
    "8F5A2E02-538C-4D59-B920-C4786ACBC552": "Ahci",
    "8F5C2D02-AF2B-49DE-B8D8-DF90130A2512": "FlashMeDxe",
    "8F644FA9-E850-4DB1-9CE2-0B44698E8DA4": "EfiFirmwareVolumeBlock2ProtocolGuid",
    "8F7D7B1D-0E1C-4C98-B12E-4EC99C4081AC": "EmptyApplication",
    "8F92960E-2880-4659-B857-915A8901BDC8": "Ip6Dxe",
    "8F92960F-2880-4659-B857-915A8901BDC8": "Ip4Dxe",
    "8F9296EF-2880-4659-B857-915A8901BDC8": "Ip4Config",
    "8F98528C-F736-4A84-AAA3-376A8E43BF51": "ImagePasswordEmpty",
    "8FAAD0A7-02B4-432F-8F5C-B880965D8B41": "SmmCommunicationBufferDxe",
    "8FBECFE2-1313-4CF6-AD2C-D3B9472F62D3": "SmartTimer",
    "9006872D-3A86-4BAE-A2F0-E527B9D7119E": "IntelLanUefiDriver",
    "9029F23E-E1EE-40D1-9382-36DD61A63EAA": "NCT6683DPeiInit",
    "9042A9DE-23DC-4A38-96FB-7ADED080516A": "EfiGraphicsOutputProtocolGuid",
    "905CF1B3-32F8-489C-A641-46A714583262": "PcieErrorEnable",
    "905DC1AD-C44D-4965-98AC-B6B4444BFD65": "UfsPciHcPei",
    "9069C144-0A7E-41EF-9C07-418BCA9BF939": "AcpiDebugSmm",
    "907125C0-A5F1-11E3-A3FE-A3198B49350C": "FvSimpleFileSystem",
    "9073E4E0-60EC-4B6E-9903-4C223C260F3C": "EfiVendorKeysNvGuid",
    "908C3852-B61B-4F26-AB66-F74F97E7DC1C": "AMTbypass",
    "90A330BD-6F89-4900-933A-C25EB4356348": "SDController",
    "90B2B846-CA6D-4D6E-A8D3-C140A8E110AC": "SystemFirmwareDescriptor",
    "90C8D394-4E04-439C-BA55-2D8CFCB414ED": "SataDriver",
    "90CB75DB-71FC-489D-AACF-943477EC7212": "SmartTimer",
    "90EC42CB-B780-4EB8-8E99-C8E3E5F37530": "UefiPciLibPciRootBridgeIo",
    "90FAE0B9-AC26-4482-B532-9BED052A8F8B": "VmwVariableDxe",
    "9100696B-368F-4F9A-984A-D606E578CCC1": "SetupConfigUpdateDxeLightningRidgeEXRP",
    "910DCA07-1F94-4EE7-AF2F-FF72F3154353": "EfiSmmBaseHelperReadyProtocolGuid",
    "911D584C-35F7-4955-BEF9-B452769DDC3A": "DebugSupportDxe",
    "912740BE-2284-4734-B971-84B027353F0C": "FspHeaderFileGuid",
    "914AEBE7-4635-459B-AA1C-11E219B03A10": "EfiMdePkgTokenSpaceGuid",
    "91538AC9-A5D3-4DEF-9A70-28A087DEFA79": "AppleDataHubUpdate",
    "9168384A-5F66-4CF7-AEB6-845BDEBD3012": "PlatformFlashAccessLibDxe",
    "9173C39B-08DA-429A-BE15-0F7481CF72CE": "AMTLockUsbKBD",
    "918211CE-A1D2-43A0-A04E-75B5BF44500E": "EfiCPTokenSpaceGuid",
    "918ABA30-3D8D-4BB5-B849-45CC4FC7DE7C": "DptfDxe",
    "919B9699-8DD0-4376-AA0B-0E54CCA47D8F": "FPVARIABLE",
    "91A1DDCF-5374-4939-8951-D7293F1A786F": "EnhancedSpeedstepProtocolGuid",
    "91A737E6-7B54-4B5F-A491-ED5EF5C5A732": "LastBootErrorLog",
    "91B4D9C1-141C-4824-8D02-3C298E36EB3F": "SataDriver",
    "91B886FD-2636-4FA8-A4A9-2EB04F235E09": "CpuPeiBeforeMem",
    "91F6E9EB-9902-44B3-A487-C8E148D0F4EE": "EmcaErrorLog",
    "9204A71D-2050-4AB7-AD42-749CF9ADB4EB": "Lpc47N20x",
    "9205CDE5-5AE5-4A4B-BFBF-F6211967EEF9": "LibLocale",
    "921B35BF-0255-4722-BF5A-5B8B69093593": "IchInitPei",
    "921CD783-3E22-4579-A71F-00D74197FCC8": "HeciSmm",
    "921CD783-3E22-4579-A71F-00D74197FCC9": "SpsSmm",
    "9221315B-30BB-46B5-813E-1B1BF4712BD3": "Defaults",
    "9257B1B6-82DF-4B69-A83B-C16D671B9A9F": "ScreenCap",
    "92685943-D810-47FF-A112-CC8490776A1F": "CORE_PEI",
    "926C9CD0-4BB8-479B-9AC4-8A2A23F85307": "BaseIoLibIntrinsic",
    "9282ED2E-F8CE-CA47-AF50-3542332F7D53": "AppleDnsResolver",
    "928EF6D4-72BC-4686-B57B-1EEB6ABD4F93": "AcpiReset",
    "929189C9-0670-4C0B-AF7D-135D1550C8C0": "RecvDgram",
    "929E8A68-0FB6-4F20-AC5E-D294C50B1CBB": "TcpConnect_DXE",
    "92BA9255-2819-4479-867A-1C58F072C5B2": "TCG_MADriver",
    "92C6033D-A685-BB41-AA2F-6F6E2CD374A2": "AppleSmbios",
    "92D11080-496F-4D95-BE7E-037488382B0A": "EfiStatusCodeDataTypeStringGuid",
    "92E33E65-20F0-455D-9D71-02C09D5060AE": "PciPort",
    "92F7436E-7395-4DA1-A7BE-F352F0BCD79C": "LibContainer",
    "93022F8C-1F09-47EF-BBB2-5814FF609DF5": "FileSystem",
    "93039971-8545-4B04-B45E-32EB8326040E": "EfiHiiPlatformSetupFormsetGuid",
    "9317EC24-7CB0-4D0E-8B32-2ED9209CD8AF": "EfiPaddingRsassaPkcs1V1P5Guid",
    "931FC048-C71D-4455-8930-470630E30EE5": "SmmPerformanceExProtocolGuid",
    "932C56C9-EB98-43C6-8514-2EB8A31B5277": "HpIOXAccess",
    "932F47E6-2362-4002-803E-3CD54B138F85": "EfiScsiIoProtocolGuid",
    "93390241-7D4D-4986-8A06-D46C982F5ECD": "CrystalRidgePeim",
    "935D2F78-3A1F-4DE6-B28D-123A40DD2DEC": "SmmGenericElog",
    "937FE521-95AE-4D1A-8929-48BCD90AD31A": "EfiIp6ConfigProtocolGuid",
    "93B80003-9FB3-11D4-9A3A-0090273FC14D": "IsaSerialDxe",
    "93B80004-9FB3-11D4-9A3A-0090273FC14D": "PciBusDxe",
    "93BA1826-DFFB-45DD-82A7-E7DCAA3BBDF3": "SmmVariableWriteGuid",
    "93BB96AF-B9F2-4EB8-9462-E0BA74564236": "UefiOvmfPkgTokenSpaceGuid",
    "93C81A74-B648-4F7F-925E-E4A0CDCC776D": "VlvInitDxe",
    "93C95FC4-B741-4587-9304-1C5A2BE6F742": "ApplePlatformSecurityPolicy",
    "93E34C7E-B50E-11DF-9223-2443DFD72085": "ArmVeNorFlashDxe",
    "93F1025B-B6D4-4F2F-A4A9-A4ABA0CF604F": "aDefaultDxe",
    "9437D7F5-6D31-4494-9A4B-F6EEB21B6CC3": "SioScriptPEI",
    "943D6B8B-D4D0-4005-81A0-AF26E5E07F03": "MeFwLayout",
    "94440339-CC93-4506-B4C6-EE8D0F4CA191": "EdkiiNonDiscoverableAmbaDeviceGuid",
    "945A0C97-4882-410A-9F30-E31C99398F7B": "DxeIchSpiDxe",
    "94621F9E-B5CA-4CFD-82BE-0C542EB0D9BE": "TftpServer",
    "94734718-0BBC-47FB-96A5-EE7A5AE6A2AD": "Dhcp4Dxe",
    "94796E10-7CF6-4A20-A3A0-4CF1A8341A16": "menu_dots",
    "94AB2F58-1438-4EF1-9152-18941A3A0E68": "EfiSecurity2ArchProtocolGuid",
    "94B9E8AE-8877-479A-9842-F5974B82CED3": "EfiBoardFeaturesGuid",
    "94E24C26-80FA-427D-80FB-E374E9E9BF85": "Dhcp6",
    "94ED2946-24EA-11DF-AF40-4300B0D2BA57": "LegacyMemoryAllocatorDxe",
    "950216A2-A621-479C-A13D-2990617BDFE7": "ReadOnlyVariable2OnReadOnlyVariableThunk",
    "950E191B-8524-4F51-80A1-5C4F1B03F35C": "PeiSha256HashPpiGuid",
    "951B65E5-8872-41ED-AD1D-D5681F4AF033": "EfiSpiHostProtocolGuid",
    "952821AA-EACD-465B-B478-5429DFC9A747": "OA2",
    "952CB795-FF36-48CF-A249-4DF486D6AB8D": "EfiTlsServiceBindingProtocolGuid",
    "9546E07C-2CBB-4C88-986C-CD341086F044": "EfiDebugSupportPeriodicCallbackProtocolGuid",
    "9588502A-5370-11E3-8631-D7C5951364C8": "AndroidFastbootApp",
    "95A1046F-5EA7-4C6D-86A7-AA91B7421E68": "CspFlashPeiLibNull",
    "95A9A93E-A86E-4926-AAEF-9918E772D987": "EfiEraseBlockProtocolGuid",
    "95AF7E4D-C45D-47FF-AEB2-D9BC13466B3F": "AppleAhciController",
    "95C3AB19-59C2-4418-A35F-CAB8724F8028": "USRATraceLibNull",
    "95C894B4-DAEC-46E1-8600-3C4C7FC985D6": "BiosGuardRecovery",
    "95C8D770-E1A4-4422-B263-E32F14FD8186": "Ax88772b",
    "95DFCAE5-BB28-4D6B-B1E2-3AF3A6BF434F": "PTID",
    "95E3669D-34BE-4775-A651-7EA41B69D89E": "Dhcp6Dxe",
    "96107C8E-9490-4767-9D0D-5590F1F6E1FC": "PhysicalPresenceDxe",
    "961578FE-B6B7-44C3-AF35-6BC705CD2B1F": "FatDxe",
    "961578FE-B6B7-44C3-AF35-6BC705CD3B3F": "MacMiscDxe",
    "9618C0DC-50A4-496C-994F-7241F282ED01": "PlatformEarlyInitPei",
    "961C19BE-D1AC-4BA7-87AF-4AE0F09DF2A6": "TrEEPei",
    "9622E42C-8E38-4A08-9E8F-54F784652F6B": "AcpiTableDxe",
    "964E5B21-6459-11D2-8E39-00A0C969723B": "EfiBlockIoProtocolGuid",
    "964E5B22-6459-11D2-8E39-00A0C969723B": "EfiSimpleFileSystemProtocolGuid",
    "966DFABF-A140-4BBA-83CA-12021090BB44": "DxeIchSmbusLightDxe",
    "968C1D9F-80C4-43B7-8CAE-668AA56C4E71": "SmbiosPeim",
    "96B5C032-DF4C-4B6E-8232-438DCF448D0E": "NullMemoryTestDxe",
    "96BDEA61-C364-4513-B6B3-037E9AD54CE4": "SetSsidSvidDxe",
    "96D4FDCD-1502-424D-9D4C-9B12D2DCAE5C": "MicrocodeFmpImageTypeIdGuid",
    "96DED71A-B9E7-4EAD-962C-01693CED2A64": "I2CPeiInitGuid",
    "96E198EC-CDBC-4C21-9743-EB4577648E59": "IccDxe",
    "96EB4AD6-A32A-11D4-BCFD-0080C73C8881": "EfiWinNtIoProtocolGuid",
    "96F1AC24-2B21-45FA-A0B5-67010C95E9D8": "AhciMmioSmm",
    "97159409-CE5F-4C1C-BDAE-7BD6981C2C11": "SmcSetPowerStatus",
    "97159409-CE5F-4C1C-BDAE-7BD6981C2C4F": "SmcOpromCtl",
    "9727502C-034E-472B-8E1B-67BB28C6CFDB": "DebugAgentDxe",
    "9737D7CA-D869-45E5-A5EF-75D9438688DE": "PlatformGOPPolicy",
    "9759BD61-F11E-4FEE-9004-1E8C88E72223": "gear10",
    "978D7247-98EA-4A14-BF98-32A35F34566B": "AcpiPowerButton",
    "978FE043-D7AF-422E-8A92-2B48E463BDE6": "EfiKmsFormatGeneric512Guid",
    "97AF1D95-203C-42DE-8D6B-D13EB7E5A55A": "PEfirmwareupdateEfi",
    "97B97368-1831-434C-A9D8-A20440A91C48": "Vmxnet2Dxe",
    "97BB442B-F9FE-45E3-8A28-439EEDCD1813": "DualBiosPei",
    "97CC7188-79C9-449F-B969-065B64BF9C69": "BiosExtensionLoader",
    "97CDCF04-4C8E-42FE-8015-11CC8A6E9D81": "Tpm2DeviceLibRouterPei",
    "97E35ADE-233D-4F18-828A-8A0524EBEDDE": "menu_none_selected",
    "982C298B-F4FA-41CB-B838-77AA688FB839": "EfiUgaDrawProtocolGuid",
    "982DDBE9-2B79-485F-9AC3-FA67B508C913": "Vmxnet3Dxe",
    "9842073D-95D9-9F49-BD3F-2E29525125DF": "EmuBusDriver",
    "98584C0B-49D6-4BAF-B542-ECEE2582409C": "ASUSBackup",
    "9876CCAD-47B4-4BDB-B65E-16F193C4F3DB": "EfiProcessorGenericErrorSectionGuid",
    "98948C4A-70F2-4035-8E9F-5927493CFC07": "FaultTolerantWriteSmmDxe",
    "989B6C1C-6FE1-D64E-A292-1313C410F0F2": "Ip4Config",
    "98B8D59B-E8BA-48EE-98DD-C295392F1EDB": "EfiConfigFileNameGuid",
    "98BBCDA4-18B4-46D3-BD1F-6A3A52D44CF8": "SmmAccess2OnSmmAccessThunk",
    "98C281E5-F906-43DD-A92B-B003BF2765DA": "PeiNtThunkPpiGuid",
    "98C8588C-640A-4BB4-AEA0-3F81CDE17524": "FspDxeIpl",
    "9950A4C8-F315-4FCE-ADC8-E1BB61F1CCCB": "PeiHeciPei",
    "99549F44-49BB-4820-B9D2-901329412D67": "IdeController",
    "9962883C-C025-4EBB-B699-4EA4D147C8A8": "AmiTxtTcgPeim",
    "996EC11C-5397-4E73-B58F-827E52906DEF": "EfiVectorHandoffTableGuid",
    "99796403-CF03-42EC-A817-7183411D79E2": "PchSmbusDxe_",
    "999BD818-7DF7-4A9A-A502-9B75033E6A0F": "EsrtDxe",
    "99C20A37-042A-46E2-80F4-E4027FDBC86F": "PlatformSmm",
    "99E7FEA1-9A6F-4D68-A754-30793B78A738": "RasInit",
    "99E87DCF-6162-40C5-9FA1-32111F5197F7": "WebServer",
    "99F03B99-98D8-49DD-A8D3-3219D0FFE41E": "Mtftp6Dxe",
    "99F2839C-57C3-411E-ABC3-ADE5267D960D": "OzmosisDefaults",
    "99FDC8FD-849B-4EBA-AD13-FB9699C90A4D": "CustomizedDisplayLibGuid",
    "9A08BC1A-7561-4A68-8875-C0977C91573C": "NetBootUI",
    "9A473A4A-4CEB-B95A-415E-5BA0BC639B2E": "EfiRegexSyntaxTypeEcma262Guid",
    "9A4E9246-D553-11D5-87E2-00062945C3B9": "EfiStatusCodeDataTypeDebugGuid",
    "9A55DA14-D845-4B3D-92DC-332143CC5C1C": "HDAudioDxe",
    "9A6DC1AC-94C0-43B1-8714-4C70FD58A815": "BaseS3BootScriptLibNull",
    "9A7A6AB4-9DA6-4AA4-90CB-6D4B79EDA7B9": "HashInstanceLibSha1",
    "9A871B00-1C16-4F61-8D2C-93B6654B5AD6": "FdtClientDxe",
    "9A8D3433-9FE8-42B6-870B-1E31C84EBE3B": "BootScriptExecutorImageGuid",
    "9A9A912B-5F53-4586-8820-704485A29D21": "MePlatformReset",
    "9AADE345-E064-4355-A815-874564DCA760": "AccessPoint80211",
    "9AB047AF-C26E-4DBF-B468-27AC6536482E": "TraceHubStatusCodeHandlerPei",
    "9AB9A129-B8FA-4045-BB05-48DBCE724F82": "HWMINIT",
    "9AE51047-E0B9-4A50-9E72-84E359D20189": "OpromUpdateDxeLightningRidgeEXECB2",
    "9B0FF2C0-E245-11E1-8EFF-D0DF9A35C106": "ChipsetSvcDxe",
    "9B182CEE-AED5-4D95-B2A9-A2CF6CDFEAA8": "OemAcpiPlatform",
    "9B3ADA4F-AE56-4C24-8DEA-F03B7558AE50": "PcdPeim",
    "9B3F28D5-10A6-46C8-BA72-BD40B847A71A": "AmiTcgPlatformPeiAfterMem",
    "9B680FCE-AD6B-4F3A-B60B-F59899003443": "DevicePathDriverDxe",
    "9B942747-154E-4D29-A436-BF7100C8B53B": "Ip4Config2NvDataGuid",
    "9BA1D976-0624-41A3-8650-28165E8D9AE8": "BaseDebugLibNull",
    "9BA21891-7E7D-4E94-B8DF-F4D2D320801C": "ROMss",
    "9BB65D37-8CA8-4789-BE45-EE18536EE089": "UsbOcUpdateDxeNeonCityEPECB",
    "9BBE29E9-FDA1-41EC-AD52-452213742D2E": "EdkiiFormDisplayEngineProtocolGuid",
    "9C0AAED4-74C5-4043-B417-A3223814CE76": "ArmPlatformTokenSpaceGuid",
    "9C1080EE-D02E-487F-9432-F3BF086EC180": "GenericMemoryTestDxe",
    "9C25E18B-76BA-43DA-A132-DBB0997CEFEF": "WinNtSimpleFileSystemDxe",
    "9C5FA4C6-746B-40A3-91CE-EC045F9D3716": "SmbiosRecoveryDmiEdit",
    "9C76C900-1E8C-11E0-8766-0002A5D5C51B": "L2X0CacheLibNull",
    "9C7C3AA7-5332-4917-82B9-56A5F3E62A07": "FspReservedMemoryResourceHobGfxGuid",
    "9C7CCB02-9154-4864-9E4B-DC0487E37660": "DhcpDummyDxe",
    "9CA93627-B65B-4324-A202-C0B461764543": "EfiPeiSmbus2PpiGuid",
    "9CB0F5CC-B0F3-4ADD-8583-3C8AF6C00DE0": "DxeS3BootScriptLibS3SaveStateProtocol",
    "9CBA9D12-A029-4366-AB1E-172B81914757": "OntarioGenericVBios",
    "9CC55D7D-FBFF-431C-BC14-334EAEA6052B": "SmmCoreDispatcherDxe",
    "9CCA03FC-4C9E-4A19-9B06-ED7B479BDE55": "EfiSmmPeriodicTimerDispatchProtocolGuid",
    "9CF30325-DC5C-4556-A8B0-74215C5F7FC4": "HeciPei",
    "9CFD802C-09A1-43D6-8217-AA49C1F90D2C": "Mebx",
    "9D0CEA63-745B-417D-BBA4-E5193061C907": "DxeFrb",
    "9D1A8B60-6CB0-11DE-8E91-0002A5D5C51B": "ThunderboltNhiDxe",
    "9D225237-FA01-464C-A949-BAABC02D31D0": "StatusCodeHandlerPei",
    "9D52E46E-F07E-44E8-9A90-F8576C91C211": "BaseFspDebugLibSerialPort",
    "9D60F495-DBF2-4B06-AFCA-F62C1C89647F": "PasswordLockWhite",
    "9D7A05E9-F740-44C3-858B-75586A8F9C8E": "dbxVar",
    "9D9A39D8-BD42-4A73-A4D5-8EE94BE11380": "EfiDhcp4ServiceBindingProtocolGuid",
    "9DC0DDAA-56BD-447A-95CC-5180433110F9": "menu_top_left",
    "9E0C30BC-3F06-4BA6-8288-09179B855DBE": "FrameworkBdsFrontPageFormsetGuid",
    "9E23D768-D2F3-4366-9FC3-3A7ABA864374": "EfiVlanConfigProtocolGuid",
    "9E498932-4ABC-45AF-A34D-0247787BE7C6": "EfiDiskInfoAhciInterfaceGuid",
    "9E5628D5-ECD5-41A2-868B-99EB933A326E": "AhciRom",
    "9E58292B-7C68-497D-A0CE-6500FD9F1B95": "EdkiiWorkingBlockSignatureGuid",
    "9E625A27-4840-47CC-A6B5-1E9311CFC60E": "Pkpub",
    "9E6584F1-FB33-4BD0-922D-47E5B7F5DBF1": "GMUXDriver",
    "9E66F251-727C-418C-BFD6-C2B4252818EA": "EfiHiiImageDecoderProtocolGuid",
    "9E7C00CF-355A-4D4E-BF60-0428CFF95540": "BaseSerialPortLib16550",
    "9E85F0D5-5185-482B-8D50-5671307FEA80": "AppleDiagnosticVault",
    "9E863906-A40F-4875-977F-5B93FF237FC6": "TerminalDxe",
    "9E8AD3F4-383D-4EC3-816E-7A4749371290": "FvbSmmDxe",
    "9E8DD95D-868B-41A4-966C-107338C291BB": "SmbiosDataUpdateDxeLightningRidgeEXECB2",
    "9E9F374B-8F16-4230-9824-5846EE766A97": "EfiSecPlatformInformation2PpiGuid",
    "9EA28D33-0175-4788-BEA8-6950516030A5": "SmBusPei",
    "9EBA2D25-BBE3-4AC2-A2C6-C87F44A1278C": "PasswordUI",
    "9EDCBD06-3C78-4822-BD6E-A6847F7531C4": "FastBootTseHook",
    "9EE4CD62-7FA7-4183-9012-F6C4CF6E2C7D": "NVBIOSINFO",
    "9EF8C276-B3E6-4AD9-8FE7-C74F71C47248": "AAFTblSMI",
    "9EFE0B7E-27E8-46D5-8387-CDDAFD2C3A67": "ASRockNetDnsBin",
    "9F3A0016-AE55-4288-829D-D22FD344C347": "AmiBoardInfo",
    "9F3A0016-AE55-4288-829D-D55FD3AAC347": "AmiBoardInfo2",
    "9F455D3B-2B8A-4C06-960B-A71B9714B9CD": "StatusCodeDxe",
    "9F49A879-3D71-42B3-A0AD-DDB1F33010A3": "EfiSpiAcpiProtocolGuid",
    "9F53EC68-49A7-7F4B-88DE-C41A96FDBAA6": "Ip4Dxe",
    "9F7DCADE-11EA-448A-A46F-76E003657DD1": "VariableSmmRuntimeDxe",
    "9F8B12CF-E796-408F-9D59-3ACDDC0AFBE3": "Datahub2SmbiosThunk",
    "9FA1B225-3346-461B-A069-ED01B673D240": "EfiI2cBusProtocolGuid",
    "9FAAD0FF-0E0C-4885-A738-BAB4E4FA1E66": "FspmWrapperPeim",
    "9FB1A1F3-3B71-4324-B39A-745CBB015FFF": "Ip4Dxe",
    "9FB4B4A7-42C0-4BCD-8540-9BCC6711F83E": "UsbMassStorageDxe",
    "9FB9A8A1-2F4A-43A6-889C-D0F7B6C47AD5": "EfiDhcp6ServiceBindingProtocolGuid",
    "9FD2360E-6B48-11D5-8E71-00902707B35E": "PciHostBridge1",
    "9FE0FCFF-B023-49A1-A2C8-ACCE1AA010BB": "FboSmiFlashLink",
    "9FE1D71B-3F91-4103-AE62-3FEECA4D2BAA": "SpiFlash",
    "9FE7DE69-0AEA-470A-B50A-139813649189": "KekVar",
    "A00490BA-3F1A-4B4C-AB90-4FA99726A1E8": "EfiBlockIoCryptoProtocolGuid",
    "A01E498C-96E8-2A4C-95F4-85248F989753": "FwBlockService",
    "A023D3F6-F297-4307-8552-E6572B30B520": "menu_mid_mid",
    "A023D4A1-05A1-4797-B84F-03B854FD05F1": "EneDXE",
    "A030D115-54DD-447B-9064-F206883D7CCC": "PeiTpmInitializationDonePpiGuid",
    "A03A9429-C570-4EF9-9E00-C7A673976E5F": "SmmControlDxe",
    "A04A27F4-DF00-4D42-B552-39511302113D": "DriverSampleFormSetGuid",
    "A0534D92-9776-4E4E-9234-C9DC1849DBB5": "PlatformFlashAccessLibNull",
    "A053F561-F56B-4140-8901-B4CB5D70929E": "BootScriptThunkGuid",
    "A05B6FFD-87AF-4E42-95C9-6228B63CF3F3": "EfiSmmUsbDispatchProtocolGuid",
    "A05ECE52-15A8-424E-BFD3-FCF3D566A09C": "AmtPeiPolicyInit",
    "A05F5C06-1782-48AA-962A-86A0892022B6": "ASM1061Dxe",
    "A062CF1F-8473-4AA3-8793-600BC4FFE9A8": "CsmDxe",
    "A071C476-F78C-41C2-A173-B43D699A2C80": "AppleEfiSocShutdown",
    "A08276EC-A0FE-4E06-8670-385336C7D093": "x86Thunk",
    "A0AAFF71-35DA-41EE-863F-A24F429E59E4": "IconSelected",
    "A0BAD9F7-AB78-491B-B583-C52B7F84B9E0": "SmmControl",
    "A0C0B7EF-99FF-417F-8B9F-5AD4701D90D6": "Tpm12DeviceLibAtmelI2c",
    "A0C98B77-CBA5-4BB8-993B-4AF6CE33ECE4": "Tcg2Pei",
    "A0E8E04C-9B5A-43BE-8B7D-C98760492B68": "SectionExtractionDxe",
    "A0E8EE6A-0E92-44D4-861B-0EAA4ACA44A2": "EfiKmsFormatAescbc128Guid",
    "A0EF80E3-F9AB-4CBA-98FD-704620F4048D": "SecFlashUpdDxe",
    "A1147A20-3144-4F8D-8295-B48311C8E4A4": "ArmJunoTokenSpaceGuid",
    "A14694E4-78DF-4EF1-A118-7654FF6CFA9D": "IpmiSdrReader",
    "A16BA302-6514-4287-BEE3-6223B7DE2C21": "NVRAMID",
    "A17F4A89-5F19-444F-B7BE-48195E0575DB": "SmbiosGenDxe",
    "A18596AC-1FC5-478D-BF14-0B415813D71F": "Ohci",
    "A1902AB9-5394-45F2-857A-12824213EEFB": "MSOA",
    "A19832B9-AC25-11D3-9A2D-0090273FC14D": "EfiSimpleNetworkProtocolGuid",
    "A19A6C36-7053-4E2C-8BD0-E8286230E473": "PciHostBridgeLibNull",
    "A19B1FE7-C1BC-49F8-875F-54A5D542443F": "CpuIo2Dxe",
    "A19FB0EE-05F4-4CD6-8F28-59B782FF95C6": "PciExpress",
    "A1AFF049-FDEB-442A-B320-13AB4CB72BBC": "EfiMdeModulePkgTokenSpaceGuid",
    "A1B0B230-67DC-431E-A94A-A96AF1EBE637": "Tpm2DeviceLibTcg2",
    "A1DD808E-1E95-4399-ABC0-653C82E8530C": "JunoAcpiTableFile",
    "A1E37052-80D9-4E65-A317-3E9A55C43EC9": "EfiIdeControllerInitProtocolGuid",
    "A1F436EA-A127-4EF8-957C-8048606FF670": "UndiRuntimeDxe",
    "A210F973-229D-4F4D-AA37-9895E6C9EABA": "DpcDxe",
    "A216E8AB-19A4-43FF-86A3-C57938F03B06": "FireWireDevice",
    "A2271DF1-BCBB-4F1D-98A9-06BC172F071A": "EfiExtendedSalFvBlockServicesProtocolGuid",
    "A29A63E3-E4E7-495F-8A6A-07738300CBB3": "AmiTcgPlatformDXE",
    "A2AB9D42-967A-45B3-9507-28CCC7021F51": "UnknownBoot",
    "A2CC7663-4D7C-448A-AAB5-4C034B6FDAB7": "rmHwA5Guid",
    "A2CF63C6-D44F-4CD0-8AF6-722A0138C021": "ArmPlatformLibSecNull",
    "A2DE77BB-797D-4BB5-80C4-19AEB8B5CD29": "ASUSFAKESMI",
    "A2F436EA-A127-4EF8-957C-8048606FF670": "SnpDxe",
    "A30D9B7C-DED3-48D6-83A6-3FF43444C37A": "AppleDxeManufacturingFixture",
    "A31280AD-481E-41B6-95E8-127F4C984779": "TianoCustomDecompressGuid",
    "A31B1AF7-3A9B-424A-8636-9885E9DE06F6": "ASUSPei",
    "A340C064-723C-4A9C-A4DD-D5B47A26FBB0": "EsrtManagementProtocolGuid",
    "A34CF082-0F50-4F0D-898A-3D39302BC51E": "IntelFsp2WrapperTokenSpaceGuid",
    "A3527D16-E6CC-42F5-BADB-BF3DE177742B": "UsbCbi0Dxe",
    "A3610442-E69F-4DF3-82CA-2360C4031A23": "ReportStatusCodeRouterPei",
    "A36495C1-C205-414E-B71F-4BE3476D699C": "FSVariable",
    "A368D636-4C77-4B50-AAE8-F99E2DA40440": "PnpRuntimeDxe",
    "A38C6898-2B5C-4FF6-9326-2E63212E56C2": "PeiSpiPpiGuid",
    "A3979E64-ACE8-4DDC-BC07-4D66B8FD0977": "EfiIpSec2ProtocolGuid",
    "A3AD355A-13D0-4DCF-9C21-3D2C5F1BAD5F": "FboGroupForm",
    "A3B3E6F8-EFCA-4BC1-88FB-CB87339B2579": "EfiKmsFormatGeneric160Guid",
    "A3BC19A6-3572-4AF4-BCE4-CD43A8D1F6AF": "ASUSITEBS",
    "A3CD8EAC-B4E6-4B68-9641-0D3763799890": "Int15Backlight",
    "A3CF349D-639C-4D08-AC4A-C95341FB4F94": "AppleIrRemoteDxe",
    "A3EAAB3C-BA3A-4524-9DC7-7E339996F496": "ASUSRT",
    "A3F436EA-A127-4EF8-957C-8048606FF670": "BCDxe",
    "A3FF0EF5-0C28-42F5-B544-8C7DE1E80014": "PiSmmCpuDxeSmm",
    "A40DAE55-2F33-42F5-B064-C8D62CCF3B87": "AppleSystemInitialization",
    "A42F4ACF-5A88-4DE3-A54D-EE7CA94C1246": "AppleSpiIoCnl",
    "A45E60D1-C719-44AA-B07A-AA777F85906D": "PeiAtaControllerPpiGuid",
    "A46423E3-4617-49F1-B9FF-D1BFA9115839": "EfiSecurityArchProtocolGuid",
    "A469DDBD-16D0-4535-BAE3-77274BD70B4C": "FwBlockServiceSmm",
    "A46B1A31-AD66-4905-92F6-2B4659DC3063": "EfiExtendedSalPciServicesProtocolGuid",
    "A46BA67D-B169-4E04-9AAC-1845CBDEE0AA": "AcpiMetronomeDxe",
    "A46C3330-BE36-4977-9D24-A7CF92EEF0FE": "PxeDhcp4Dxe",
    "A477AF13-877D-4060-BAA1-25D1BEA08AD3": "EfiKmsFormatRsasha2562048Guid",
    "A47EE2D8-F60E-42FD-8E58-7BD65EE4C29B": "CpuIo2Smm",
    "A487A478-51EF-48AA-8794-7BEE2A0562F1": "tftpDynamicCommand",
    "A4C751FC-23AE-4C3E-92E9-4964CF63F349": "EfiUnicodeCollation2ProtocolGuid",
    "A4E7949F-F818-49DE-AEC0-08B0DB6E250C": "T23SmbiosOverride",
    "A4EC8ADB-B7A8-47D1-8E52-EC820D0ACF6F": "FvbSmm",
    "A4EE0728-E5D7-4AC5-B21E-658ED857E834": "ArmMpCoreInfoGuid",
    "A4F2909C-5E2A-438A-91BA-272B0923049A": "PlatformSetup",
    "A510A614-2192-11DF-AF29-2754E86B3594": "PciExpressHostBridge",
    "A5288050-8828-46C4-8F72-1CD735A56520": "Slp20Dxe",
    "A55701F5-E3EF-43DE-AC72-249B573FAD2C": "EfiIa32X64ErrorTypeCacheCheckGuid",
    "A56074DB-65FE-45F7-BD21-2D2BDD8E9652": "EfiLegacyDevOrderVariableGuid",
    "A5683620-7998-4BB2-A377-1C1E31E1E215": "TcgDxe",
    "A56897A1-A77F-4600-84DB-22B0A801FA9A": "SmmRuntime",
    "A56FAD72-A264-4370-85C5-00584654DCE2": "InstallVerbTablePei",
    "A58C5D1D-C22B-4845-90BC-8C94FCE96457": "FastBootOption",
    "A59A0056-3341-44B5-9C9C-6D76F7673817": "SignOn",
    "A59E8FCF-BDA0-43BB-90B1-D3732ECAA877": "EfiScsiPassThruProtocolGuid",
    "A5AAB9E3-C727-48CD-8BBF-427233854948": "EfiI2cHostProtocolGuid",
    "A5BC1114-6F64-4EDE-B863-3E83ED7C83B1": "EfiPlatformMemoryErrorSectionGuid",
    "A5C059A1-94E4-4AA7-87B5-AB155C2BF072": "EfiCertX509Guid",
    "A5C1EF72-9379-4370-B4C7-0F5126CAC38E": "TrEEConfigPei",
    "A5C6D68B-E78A-4426-9278-A8F0D9EB4D8F": "UsbMassStorageDxe",
    "A6077307-B297-4051-9AC0-A0DC8147E601": "menu_locked",
    "A60C6B59-E459-425D-9C69-0BCC9CB27D81": "EfiGetPcdInfoPpiGuid",
    "A62D933A-9293-4D9F-9A16-CE81994CC4F2": "AppleDebugSupport",
    "A630B937-3AB3-4263-85B1-A63E98F29949": "PcieErrorHandler",
    "A673005A-69F6-4597-8AF9-7AACA0039296": "Int15BootDisplay",
    "A6885402-D022-4B0E-A509-4711B90F2A39": "ReportStatusCodeRouterSmm",
    "A6A72875-2962-4C18-9F46-8DA644CCFE00": "EfiIScsiInitiatorNameProtocolGuid",
    "A6A79162-E325-4C30-BCC3-59373064EFB3": "EfiTcoResetProtocolGuid",
    "A6AEF1F6-F25A-4082-AF39-2229BCF5A6E1": "AmtStatusCodePei",
    "A6F691AC-31C8-4444-854C-E2C1A6950F92": "DuetBds",
    "A732241F-383D-4D9C-8AE1-8E09837589D7": "XenBusRootDeviceGuid",
    "A73D663D-A491-4278-9A69-9521BE3379F2": "ArmVeTimerDxe",
    "A770C357-B693-4E6D-A6CF-D21C728E550B": "EdkiiFormBrowserEx2ProtocolGuid",
    "A7717414-C616-4977-9420-844712A735BF": "EfiCertTypeRsa2048Sha256Guid",
    "A77B2472-E282-4E9F-A245-C2C0E27BBCC1": "EfiBlockIo2ProtocolGuid",
    "A79EED97-4B98-4974-9690-37B32D6A5B56": "RTSMArmVExpressLibSec",
    "A7AF67CB-603B-4D42-BA21-70BFB6293F96": "EfiRngAlgorithmSp80090Hash256Guid",
    "A7C0687A-E8B9-42EC-B8A5-A950DF6EF94A": "AlternativeDefaultMemoryQuota",
    "A7C619FF-9A64-4A89-947B-E7953E2427CB": "ASUSBS",
    "A7CED760-C71C-4E1A-ACB1-89604D5216CB": "EfiIioUdsProtocolGuid",
    "A8154B55-2021-4D40-AE81-2E23A02DCC46": "FtdiUsbSerialDxe",
    "A8499E65-A6F6-48B0-96DB-45C266030D83": "SiInitPreMem",
    "A85027FC-0E09-4FA9-A407-CAD206FB4F1D": "PlatformStage1Pei",
    "A85DCA1B-198F-4E14-A673-874264687E85": "DataSink",
    "A883FD70-4E7E-4B17-8EBB-C5646FF154CA": "SpiMouseDxe",
    "A8913EC1-C00C-4C3A-A245-077C0CA35738": "AspmOverrideDxe",
    "A89EC8E0-0BA1-40AA-A03E-ABDDA5295CDE": "PciExpressDxe",
    "A8BC51CC-5A30-41D5-8B1A-EB46ABC527FA": "IioRas",
    "A8C67255-E029-4B1A-968E-ECA6E9C11C73": "AmtSmbios",
    "A8CDA0A2-4F37-4A1B-8E10-8EF3CC3BF3A8": "EdkiiNonDiscoverableUhciDeviceGuid",
    "A8CF6278-8758-458D-ADFB-3471F5AD50B1": "HdPwdPeimPei",
    "A912F198-7F0E-4803-B908-B757B806EC83": "Hello",
    "A92CDB4B-82F1-4E0B-A516-8A655D371524": "VirtioNetDxe",
    "A95C1D60-CB9F-4BD8-A030-3F1C4A185156": "SecureBootMod",
    "A9620E5C-5FA1-40B7-8B21-50B632F88F38": "EfiLoader",
    "A9731431-D968-4277-B752-A3A9A6AE1898": "PeiIpmiPpiGuid",
    "A9759271-49CD-49BE-8764-5DEBFBE68F73": "AmdResetManagerPei",
    "A9ACE824-4486-44E6-915A-8FBAED0799B9": "SetupDataProviderDxe",
    "A9B700CF-019E-4D8B-A3A7-88E1EA01699E": "HddSecurity",
    "A9CE66D5-6D37-451E-A9BF-F58F7A0B3CC2": "ASM1061_DXE",
    "A9DC6F60-F861-47D1-8751-ECAAE7D27291": "LibMath",
    "A9F634A5-29F1-4456-A9D5-6E24B88BDB65": "BmpDecoderDxe",
    "A9F8D54E-1107-4F0A-ADD0-4587E7A4A735": "IntelSiliconPkgTokenSpaceGuid",
    "AA0E8BC1-DABC-46B0-A844-37B8169B2BEA": "EfiPciHotPlugInitProtocolGuid",
    "AA48FBB2-9F87-4DFD-B416-575938F0C8F4": "PropertiesTableAttributesDxe",
    "AA5324ED-DC11-4D5D-A52B-FABDD7E80634": "PlacementDxe",
    "AA652CB9-2D52-4624-9FAE-D4E58B67CA46": "PchSpiPeim",
    "AA6E8785-726E-441D-ACB8-F75FB0B2B9F2": "CoreEG2",
    "AA7B4695-00B4-4468-AD92-99370AC031C5": "LegacyRegion2",
    "AA893E19-A641-4819-AD23-011B7C24250D": "IT8728SioAcBackSmm",
    "AABF95D6-F40C-405F-8360-6A59794B8040": "BasePciSegmentLibPci",
    "AAC33064-9ED0-4B89-A5AD-3EA767960B22": "FaultTolerantWritePei",
    "AAC9B0AF-A46A-49D8-8016-9B9DAD2C7F5E": "DxeBoardConfigInit",
    "AAD10051-5D94-4B9F-B778-E4555EE3CCCA": "IioSmm",
    "AAD8B9F8-2C83-4E4B-96E8-C5B8B8AC56BF": "JedecNvDimmSMM",
    "AAE65279-0761-41D1-BA13-4A3C1383603F": "Ozmosis",
    "AAEACCFD-F27B-4C17-B610-75CA1F2DFB52": "EfiEbcVmTestProtocolGuid",
    "AAECDC89-2A49-46F1-A163-F7979C039998": "IdeBusSrc",
    "AAF32C78-947B-439A-A180-2E144EC37792": "EfiAuthenticatedVariableGuid",
    "AB248E8D-ABE1-11D4-BD0D-0080C73C8881": "WinNtUgaDxe",
    "AB248E99-ABE1-11D4-BD0D-0080C73C8881": "EfiWinNtUgaGuid",
    "AB294A92-EAF5-4CF3-AB2B-2D4BED4DB63D": "PeiMfgMemoryTestPpiGuid",
    "AB2BEE2F-C1A6-4399-853D-C07C774FFD0D": "EfiLpcWpce791PolicyProtocolGuid",
    "AB38A0DF-6873-44A9-87E6-D4EB56148449": "EfiRamDiskProtocolGuid",
    "AB7ED12E-1D78-4635-AB87-23F00A911EC7": "RomLayoutDxe",
    "AB8F1705-7EB6-4D08-A9B3-918BDE24F479": "UpdatePcdPei",
    "ABAA46B8-84A3-4E74-882F-6368F6EDC9B8": "HddPwdDxe",
    "ABB74F50-FD2D-4072-A321-CAFC72977EFA": "SmmRelocatePei",
    "ABBCE13D-E25A-4D9F-A1F9-2F7710786892": "Platform",
    "ABC36AAC-2031-4422-896E-0A3B899AD0B4": "Microcode",
    "ABD42895-78CF-4872-8444-1B5C180BFBDA": "EfiPeiSmbusPpiGuid",
    "ABD42895-78CF-4872-8444-1B5C180BFBFF": "EfiPeiBootScriptExecuterPpiGuid",
    "AC05BF33-995A-4ED4-AAB8-EF7AE80F5CB0": "UefiCpuPkgTokenSpaceGuid",
    "AC255206-DCF9-4837-8353-72BBBC0AC849": "OzmosisTheme",
    "AC3435BB-B1D3-4EF8-957C-8048606FF671": "FrameworkHiiOnUefiHiiThunk",
    "AC3DA503-65E7-4153-96FC-8707FB7594FB": "ASUSBIOSInfo",
    "AC4CE557-F5CD-439E-963C-40F09683DAC5": "AppleKeyMapAggregator",
    "AC5E14DD-4567-41F7-9E29-5F52CD314214": "X11DPHSmmDriver",
    "AC6993CF-43C8-4FCB-840C-B7CF2E079977": "PciHotPlug2",
    "AC874606-8727-41A0-BCCD-43A4237466DD": "EneUpdDXE",
    "AC95AD3D-4366-44BF-9A62-E4B29D7A2206": "SmmAccess2Dxe",
    "ACA24109-6C7A-4CEC-9133-5FB9D8274910": "IntelLtsxFit",
    "ACAEAA7A-C039-4424-88DA-F42212EA0E55": "PchPcieSmm",
    "ACB93B08-5CDC-4A8F-93D4-06E342DF182E": "PchPeiInitPpiGuid",
    "ACD03321-777E-4D3D-B1C8-20CFD88820C9": "EfiRngAlgorithmX931AesGuid",
    "ACD28235-075B-48B5-98A1-DA04FCAF84F3": "SiInitDxe",
    "AD0D149F-BA67-4E0B-A6A2-4E8853673EA5": "ErrorGlobeTile",
    "AD15A0D6-8BEC-4ACF-A073-D01DE77E2D88": "EfiVTUTF8Guid",
    "AD1F487A-BA56-48DC-8EAA-E8FBEA74B8F2": "ASM104X_SMI",
    "AD21F7A0-7F5B-47FE-8CC0-241F318CABF5": "AppleLegacyStartup",
    "AD3D267D-50E1-4B94-95D3-1025EF5B8391": "SecFlashUpdDXE",
    "AD414DD9-076F-40FA-8B6A-1B6779ADECA3": "AcpiDebugTables",
    "AD416CE3-A483-45B1-94C2-4B4E4D575562": "TcgMor",
    "AD49E1DA-5E83-4A0F-ACC7-67F08CAEAA78": "TrEEPei",
    "AD608272-D07F-4964-801E-7BD3B7888652": "MonotonicCounterRuntimeDxe",
    "AD61999A-507E-47E6-BA28-79CC609FA1A4": "FspWrapperNotifyDxe",
    "AD61F191-AE5F-4C0E-B9FA-E869D288C64F": "EfiCpuIo2ProtocolGuid",
    "AD651C7D-3C22-4DBF-92E8-38A7CDAE87B2": "VirtualUncachedPagesProtocolGuid",
    "AD70855E-0CC5-4ABF-8979-BE762A949EA3": "IncompatiblePciDeviceSupport",
    "AD9C4381-1EDE-430C-8D42-23767C465D52": "EfiUsbKeyboardConnectGuid",
    "ADF01BF6-47D6-495D-B95B-687777807214": "FirmwarePerformancePei",
    "ADF3A128-416D-4060-8DDF-30A1D7AAB699": "EfiSmmIchnDispatch2ProtocolGuid",
    "AE2020DF-C175-4344-B755-BBA47744F8B1": "PeiVideoTextOut",
    "AE265864-CF5D-41A8-913D-71C155E76442": "CpuIoPei",
    "AE3356F4-F95B-404B-B1DE-64EB5D5E5BBE": "MemRas",
    "AE3D28CC-E05B-4FA1-A011-7EB55A3F1401": "EfiDns4ProtocolGuid",
    "AE4C11C8-1D6C-F24E-A183-E1CA36D1A8A9": "HfsPlus",
    "AE587172-CA15-48E1-8BE1-29DDF05C6A1E": "OemSpecVtdRmrr",
    "AE587172-CC15-48E1-8BE0-29DDF05C6A1F": "DxeSelStatusCode",
    "AE587172-CC15-48E1-8BE1-29DDF05C6A1E": "OemVtdRmrr",
    "AE717C2F-1A42-4F2B-8861-78B79CA07E07": "FV_MAIN_NESTED",
    "AE724F8D-62C6-4638-A065-0138F47B6D23": "UefiPxeBcDxe_",
    "AE80D021-618E-11D4-BCD7-0080C73C8881": "EfiDataHubProtocolGuid",
    "AE933E1C-CC47-4E38-8F0E-E2F61D2605DF": "EfiPeiSmmCommunicationPpiGuid",
    "AEA6B965-DCF5-4311-B4B8-0F12464494D2": "BootScriptDataGuid",
    "AEB9C5C1-94F1-4D02-BFD9-4602DB2D3C54": "EfiTcg2PhysicalPresenceGuid",
    "AEC4159D-F2FC-4090-95CE-38317A8ED64C": "FirmwarePerformanceTable",
    "AED6AA78-D5BF-4BC5-8CC5-F9EE47CF9299": "CapsuleRuntimeDxe",
    "AEDA2428-9A22-4637-9B21-545E28FBB829": "EfiEblAddCommandProtocolGuid",
    "AEE17FF6-B810-4A8A-9D4D-8B9C3289C1AC": "SmcSwSMI",
    "AEF82756-87F2-4CF6-BE80-E59055295AA1": "PEbiosinterface",
    "AEFAF26C-FB6D-4FEF-AF7A-9D78FF201FCA": "FirmwareUpdate",
    "AF060190-5E3A-4025-AFBD-E1F905BFAA4C": "EfiHiiImageDecoderNamePngGuid",
    "AF23B340-97B4-4685-8D4F-A3F28169B21D": "EdkiiVarCheckProtocolGuid",
    "AF382531-52E6-4CC4-B247-DB8E320CBBA3": "SmbiosDMIEditBoard",
    "AF43E178-C2E9-4712-A7CD-08BFDAC7482C": "UfsPciHcDxe",
    "AF4CC162-D41C-455A-AB45-6DBCC1CD32F3": "LpssDummyProtocolGuid",
    "AF59F2F5-5E28-4E03-80E2-4727545AF811": "PchReset",
    "AF6AC311-84C3-11D2-8E3C-00A0C969723B": "EfiDeviceIoProtocolGuid",
    "AF9FFD67-EC10-488A-9DFC-6CBF5EE22C2E": "EfiAcpiVariableGuid",
    "AFBFDE41-2E6E-4262-BA65-62B9236E5495": "EfiTimestampProtocolGuid",
    "AFFC90DD-B014-4737-89E9-D1A0F50CD25E": "CPLDPEI",
    "B017C09D-EDC1-4940-B13E-57E95660C90F": "AhciRom",
    "B03ABACF-A532-5E78-ACA0-B11F765B3AFD": "CpuDxe",
    "B0732526-38C8-4B40-8877-61C7B06AAC45": "EfiCpuIoProtocolGuid",
    "B0792197-ABC3-4BB1-9FD3-CBEA8FD41373": "BaseAmiBeepLibNull",
    "B091E7D2-05A0-4198-94F0-74B7B8C55459": "EfiFlashMapHobGuid",
    "B09CB87C-67D8-412B-BB9D-9F4B214D720A": "VTd",
    "B0C2372B-9393-4CBC-9CAF-53913C9DCE29": "FlashDeviceFvbRuntimeDxe",
    "B0D6ED53-B844-43F5-BD2F-61095264E77E": "PchSmiDispatcher",
    "B0D8F3C1-B7DE-4C11-BC89-2FB562C8C411": "EdkiiSmmVarCheckProtocolGuid",
    "B0E11362-00DA-4611-8D7D-10EF2527F653": "VideoBiosDataBlock",
    "B0EAE4F8-9A04-4C6D-A748-793DAA0F65DF": "TlsAuthConfigGuid",
    "B0EE53D4-A049-4A79-B2FF-19D9FAEFAA94": "EcpPeiPciCfgPpiGuid",
    "B0F901E4-C424-45DE-9081-95E20BDE6FB5": "TcgConfigFormSetGuid",
    "B1095967-FCF4-4C53-BC16-7E3DF9C247EB": "StdFlashPeiLibNull",
    "B10ADFA1-9E43-487F-AAF3-A7A9BDEAF4AC": "ProgressBarFullRightEndcap",
    "B11216C5-44E4-472C-ACB7-128A5A3AD7A1": "OpromUpdateDxeNeonCityFPGA",
    "B122A262-3551-4F48-8892-55F6C0614290": "EfiFirmwareClassGuid",
    "B122A263-3661-4F68-9929-78F8B0D62180": "EfiSystemResourceTableGuid",
    "B13EDD38-684C-41ED-A305-D7B7E32497DF": "SMBios",
    "B144E169-AFB1-4426-B0EC-099728909342": "MuxGraphicsSwitch",
    "B15239D6-6A01-4808-A0F7-B7F20F073555": "Ax88772",
    "B1625D3C-9D2D-4E0D-B864-8A763EE4EC50": "TcpDxe",
    "B1659B1F-F74E-4866-9D66-2930900391A5": "FwBlockService",
    "B180019E-9820-4DC0-8B40-A773E23D4F35": "RamDisk",
    "B199DEA9-FD5C-4A84-8082-2F4170780305": "EarlyPL011BaseAddressGuid",
    "B1B621D5-F19C-41A5-830B-D9152C69AAE0": "FdtTableGuid",
    "B1BE0BC5-6C28-442D-AA37-151B4257BD78": "EdkiiNonDiscoverableXhciDeviceGuid",
    "B1CAA183-FA67-44F5-8D77-B528C309207E": "DxeDbgModuleLocator",
    "B1CD7448-319C-41AA-821D-3E606BF6F90D": "SmcOemActivation",
    "B1DA0ADF-4F77-4070-A88E-BFFE1C60529A": "AMITSE",
    "B1E9E2CA-B078-4070-BCCD-87449AC7D2A6": "CpuS3Pei",
    "B1EE129E-DA36-4181-91F8-04A4923766A7": "EfiDriverFamilyOverrideProtocolGuid",
    "B20005B0-BB2D-496F-869C-230B4479E7D1": "EdkiiNonDiscoverableOhciDeviceGuid",
    "B219E140-DFFC-11E3-B956-0022681E6906": "DnsDxe",
    "B2360B42-7173-420A-8696-46CA6BAB1060": "MeasuredFvHobGuid",
    "B2585B69-FB63-4220-844A-8FBEA8BF01AF": "PeiIoLibCpuIo",
    "B26B30A8-2172-4A46-9B4F-4D5B08DD6E40": "T23OwnerStringService",
    "B273CC44-E62A-41DC-9CAD-BDB4235459D8": "UnicodeCollationDxe",
    "B2A191A9-9BAC-4C83-A2F3-D5F6E71EFD03": "ArmPlatformSysConfigLibNull",
    "B2CD74DE-11F9-418C-BF2E-DAC3035AAB7A": "IsPlatformSupportWhea",
    "B2DEDC91-D59F-48D2-898A-12490C74A4E0": "EfiIfrBootMaintenanceGuid",
    "B30DFEED-947F-4396-B15A-DFBDB916DC24": "EdkiiPeiSdMmcHostControllerPpiGuid",
    "B323179B-97FB-477E-B0FE-D88591FA11AB": "PeCoffLoaderProtocolGuid",
    "B336F62D-4135-4A55-AE4E-4971BBF0885D": "RealTimeClock",
    "B347F047-AF8C-490E-AC07-0AA9B7E53858": "EfiWinNtSystemConfigGuid",
    "B34E5765-2E04-4DAF-867F-7F40BE6FC33D": "ExtFs",
    "B35AD166-FCBA-4D4D-89C7-4B47104E3AFD": "AppleSpiIoSkl",
    "B3738534-9051-40D1-9333-91284A5990CE": "AmiPciHotPlugLibNull",
    "B3762FA2-54D6-4EBC-84DE-4CFA9340FCB3": "AcpiAMLDxe",
    "B38573B6-6200-4AC5-B51D-82E65938D783": "RecoveryOnFatIdeDiskGuid",
    "B3930571-BEBA-4FC5-9203-9427242E6A43": "EfiBluetoothHcProtocolGuid",
    "B3B0654A-969D-4096-86CB-27E262A02083": "PeiCoreEntryPoint",
    "B3B88F4B-7042-488E-A255-66F965E8D435": "PasswordPopupDxe",
    "B3BFAB9B-9F9C-4E8B-AD37-7F8C51FC6280": "EfiPeiI2cMasterPpiGuid",
    "B3D3502E-CB82-4017-AB34-2F17D2D7035F": "PepBccdSmm",
    "B3F56470-6141-4621-8F19-704E577AA9E8": "DriverSampleInventoryGuid",
    "B3F79D9A-436C-DC11-B052-CD85DF524CE6": "EfiRegularExpressionProtocolGuid",
    "B40612B2-A063-11D4-9A3A-0090273FC14D": "UsbCbi1Dxe",
    "B40612B9-A063-11D4-9A3A-0090273FC14D": "UsbBotDxe",
    "B41956E1-7CA2-42DB-9562-168389F0F066": "BootGuardPei",
    "B422FB70-E835-448D-A921-EBA460E105B6": "SmmIpmiLibSmmIpmiProtocol",
    "B4339807-7CAC-49BA-9FB7-6231C622F270": "BeginStickyBootButton",
    "B4598C09-DA08-5F75-A956-2CFF901B1C24": "MonacoFont",
    "B47417C7-E21F-4AC9-B0A2-7A158223A137": "SetupConfigUpdateDxeNeonCityEPECB",
    "B494DF39-A5F8-48A1-B2D0-EF523AD91C55": "PeiPolicyInit",
    "B4C26857-8FE5-42BE-968B-39F45E921D45": "AppleDxePState",
    "B4DE05C0-1BD0-11E1-8F0E-77F34724019B": "TbtOemBoard",
    "B4E0CDFC-30CD-4B29-A445-B0AA95A532E4": "SmmAccessPei",
    "B50AB2CA-48D0-11E4-A6D3-B8E8562CBAFA": "SerialMojoDxe",
    "B535ABF6-967D-43F2-B494-A1EB8E21A28E": "AppleRomInformation",
    "B55A4515-5895-4EA8-845B-75B7480F6502": "SmmControl2OnSmmControlThunk",
    "B579B530-C797-4839-883E-EFCABD7756E9": "VerbTable",
    "B57A1DF6-FFDB-4247-A3DF-3A562176751A": "UefiDebugLibStdErr",
    "B5A05743-9B71-489B-A0ED-A0EB3950D23B": "SecPeiDxeTimerLibCpu",
    "B5AF1D7A-B8CF-4EB3-8925-A820E16B687D": "BootScriptDataBootTimeGuid",
    "B5B35764-460C-4A06-99FC-77A17C1B5CEB": "EfiPciOverrideProtocolGuid",
    "B601F8C4-43B7-4784-95B1-F4226CB40CEE": "RuntimeDxe",
    "B60A3E6B-18C4-46E5-A29A-C9A10665A28E": "EfiI2cIoProtocolGuid",
    "B60DC6E8-3B6F-11D5-AF09-00A0C944A05B": "EfiSalMcaInitPmiProtocolGuid",
    "B619A1FF-3B3F-4941-B0F4-2B053BBD1720": "FpgaFvDataLibPei",
    "B625B186-E063-44F7-8905-6A74DC6F52B4": "EfiDns4ServiceBindingProtocolGuid",
    "B62EFBBB-3923-4CB9-A6E8-DB818E828A80": "MebxSetupBrowser",
    "B63F8EC7-A9C9-4472-A4C0-4D8BF365CC51": "EfiSdHostIoProtocolGuid",
    "B65BF670-FC37-4225-AB85-EC960A7A1ED9": "UsraRegisterFilterLibNull",
    "B6A2AFF3-767C-5658-C37A-D1C82EF76543": "MeUma",
    "B6B5FAB9-75C4-4AAE-8314-7FFFA7156EAA": "VARBAK",
    "B6B9295F-CABF-4CEC-BB14-FE4246F2173A": "iFfsDxe",
    "B6C0DCB6-434E-4BEC-BDAC-8EE7ED8A4EC8": "ArithChk",
    "B6E9A733-EB75-41B6-B30C-009BCF3801C8": "BasePostCodeLibPort80",
    "B6F44CC0-9E45-11DF-BE21-0002A5D5C51B": "MmcDxe",
    "B703C820-4D3D-4658-8EED-5B2F9DE54711": "efi_pop_LF_pressed",
    "B709EFA0-47A6-4B41-B931-12ECE7A8EE56": "EfiSmmPowerButtonDispatchProtocolGuid",
    "B7139637-C114-447C-B73E-CDBCD307BEBB": "WinCSMDxe",
    "B716A6F8-F3A1-4B8E-8582-5A303F1CDD64": "PchSpiWrap",
    "B7358BEB-6A52-4D50-98F9-7EDD70B4B320": "CommonPciPlatformDxe",
    "B7611005-1F26-45BA-A3DB-01F39DDB2785": "BootMode",
    "B7A5041A-78BA-49E3-B73B-54C757811FB6": "IdeBusPei",
    "B7A5041B-78BA-48E3-B63B-44C7578113B6": "FloppyPeimPei",
    "B7BC0E96-57D2-4310-AEEF-74AC77DF0DAF": "SetupXpBoot",
    "B7D19491-E55A-470D-8508-85A5DFA41974": "SBDXE",
    "B7D9F0D7-EBDB-4EE4-AB77-B30C4B9093CC": "TbtSmm",
    "B7DDFF7A-1726-11E6-B12F-B8E8562CBAFA": "WiFiPlatformDxe",
    "B7DFB4E1-052F-449F-87BE-9818FC91B733": "EfiRuntimeArchProtocolGuid",
    "B7E329EC-AD60-4D61-86E3-01A7904E223D": "gear7",
    "B7EE4835-84CE-4B15-BF52-2D11574CE470": "HardwareSignatureEntry",
    "B7F50E91-A759-412C-ADE4-DCD03E7F7C28": "XhciDxe",
    "B8502C59-B268-4BE8-ADD6-601AFEAA4BC9": "SpiKeyboard",
    "B85C7FEA-AEBF-492B-96C6-42EA133BCF29": "AmiTseHddSecurity",
    "B894C949-A1F8-41C1-A7C0-DF523AD91C15": "MrcOemHooksPeim",
    "B8969637-81DE-43AF-BC9A-24D98913F2F6": "HandleParsingHiiGuid",
    "B8AC7FB2-4211-4C2B-B62F-504421666C87": "RngTest",
    "B8B8B609-0B6C-4B8C-A731-DE03A6C3F3DC": "PchBiosWriteProtect",
    "B8D62377-7970-4CE1-87F4-9DDE56AE8982": "BiosGuardMeudVerifyMeCapsule",
    "B8D9777E-D72A-451F-9BDB-BAFB52A68415": "ArmCpuDxe",
    "B8E62775-BB0A-43F0-A843-5BE8B14F8CCD": "BootGraphicsResourceTableDxe",
    "B90510C4-A6DE-4E45-A50C-A46CCAFEEF91": "BaseBoardDXE",
    "B912F198-7F0E-4803-B908-B757B806EC83": "AppleImg4VerificationDxe",
    "B91978DF-9FC1-427D-BB05-4C828455CA27": "EfiSioControlProtocolGuid",
    "B9237513-6C44-4411-A990-21E556E05ADE": "EfiKmsFormatGeneric3072Guid",
    "B95E9FDA-26DE-48D2-8807-1F9107AC5E3A": "UefiPxeBcDxe",
    "B981A835-6EE8-4F4C-AE0B-210AA0BFBF01": "RngDxe",
    "B9846521-FF99-4953-8FA2-85C9ADCCE5AF": "PeiGfxDriver",
    "B98999A4-E96F-475A-99FC-762126F50F5A": "SMBIOSUpdateData",
    "B9B20B00-2FE5-8445-ACC5-8E29EF01A3E6": "AppleMemoryTest",
    "B9C464F5-E8DF-49FB-8FE5-86DA958D8133": "ASRockHDAudioDxe",
    "B9D4C360-BCFB-4F9B-9298-53C136982258": "EfiFormBrowser2ProtocolGuid",
    "B9E0ABFE-5979-4914-977F-6DEE78C278A6": "EfiPeiLoadFilePpiGuid",
    "B9F10C17-6CA0-40B5-9B44-6253CFC7D24B": "GdbDebugAgent",
    "BA05B97C-8EBF-48B7-858D-4B0AFBF0D7DA": "BiosGuardRecoveryWorker",
    "BA102EAD-5308-4F9B-9E22-C1CE4DC44F49": "RSAKey",
    "BA246BC7-7E2F-4AE4-817A-FFDE572E39DE": "AppleSmc2",
    "BA51887A-BEB9-45DA-8E37-98A6B46E7C58": "IeHeciInit",
    "BA5B13F3-8B83-4871-8C3D-44CE683EAC1E": "AmtLibPei",
    "BA658945-DEE1-42B3-9FA4-BB6B22FB03E4": "efi_pop_mid",
    "BA67550C-3628-4137-A53E-42660E081604": "MePlatformPolicy",
    "BA73672C-A5D3-11D4-BD00-0080C73C8881": "EfiWinNtConsoleGuid",
    "BA7BE337-6CFB-4DBB-B26C-21EC2FC16073": "SecCore",
    "BA87DD62-AB60-46DE-8FD8-023510D52D11": "gear12",
    "BA929954-35B0-4DD3-90CD-9634BD7E1CF1": "ResetDxe",
    "BAB4F20F-0981-4B5F-A047-6EF83BEEAB3C": "EhciPei",
    "BAE7599F-3C6B-43B7-BDF0-9CE07AA91AA6": "CpuIoDxe",
    "BAF1E6DE-209E-4ADB-8D96-FD8B71F3F683": "EfiEventUserProfileChangedGuid",
    "BB11ECFE-820F-4968-BBA6-F76AFE302596": "ArmTokenSpaceGuid",
    "BB1A3984-D171-4003-9094-46AF866B45A2": "IconPasswordLock",
    "BB1FBD4F-2E30-4793-9BED-74F672BC8FFE": "PchResetRuntime",
    "BB25CF6F-F1D4-11D2-9A0C-0090273FC1FD": "EfiSerialIoProtocolGuid",
    "BB2F0636-B0DD-489B-ADB6-606FE3A47258": "CpuHotAdd",
    "BB3BF734-D640-4CF5-AFEA-CA8CFA6020D1": "ASUS_USBFLASHBACK",
    "BB5B5907-5F8E-42AD-915D-5D98B52ED697": "PlatformStage2",
    "BB62E663-625D-40B2-A088-BBE83623A245": "EfiEapManagementProtocolGuid",
    "BB65942B-521F-4EC3-BAF9-A92540CF60D2": "SataController",
    "BB83F95F-EDBC-4884-A520-CD42AF388FAE": "BaseDebugLibSerialPort",
    "BB8C2CF3-A5E3-49EF-941B-4A01FAC6FD5F": "SmiFlashDxe",
    "BB929DA9-68F7-4035-B22C-A3BB3F23DA55": "SataControllerDriverGuid",
    "BB983CCF-151D-40E1-A07B-4A17BE168292": "EfiMemoryOverwriteRequestControlLockGuid",
    "BB9C7AB7-B8D9-4BF3-9C29-9BF341E217BC": "EfiPlatformCpuInfoGuid",
    "BBB31581-855A-44D7-A550-8A585D9B2DE9": "BaseCryptLibRuntimeCryptProtocol",
    "BBCB6F85-303C-4EB9-8182-AF98D4B3020C": "Tpm2DeviceLibTrEE",
    "BBCFF46C-C8D3-4113-8985-B9D4F3B3F64E": "FspBootLoaderTemporaryMemoryGuid",
    "BC0B9FB8-97CF-4B17-9A9E-F574E62CBCC4": "BmcLanConfig",
    "BC1A046C-7DBD-41F2-94E5-D7595554CAF4": "SystemFirmwareReportDxe",
    "BC2B7672-A48B-4D58-B39E-AEE3707B5A23": "Tpm12DeviceLibDTpm",
    "BC3245BD-B982-4F55-9F79-056AD7E987C5": "AhciSmm",
    "BC327DBD-B982-4F55-9F79-056AD7E987C5": "SMIFlash",
    "BC468182-0C0B-D645-A8AC-FB5D81076AE8": "UserInterfaceThemeDriver",
    "BC52476E-F67E-4301-B262-369C4878AAC2": "PlatformSeCHookProtocolGuid",
    "BC559DEA-2681-9345-9BE9-07850AF39E6E": "ShaHash",
    "BC59E2E1-7492-4031-806E-C48DCCC3A026": "FspInitPeim",
    "BC5FA650-EDBB-4D0D-B3A3-D98907F847DF": "PeiBlockIoPpiGuid",
    "BC62157E-3E33-4FEC-9920-2D3B36D750DF": "EfiLoadedImageDevicePathProtocolGuid",
    "BCAF98C9-22B0-3B4F-9CBD-C8A6B4DBCEE9": "EmuSec",
    "BCC87E0D-86D6-4D4D-8040-2D983D368BD1": "EmuGopDxe",
    "BCCAD460-4F7D-4E51-8A5D-3BBA236D9EBB": "AppleBootBeep",
    "BCCDE9D2-BABD-44F5-BB3F-D7B16174F64B": "AsfDxe",
    "BCD9DF8C-BE89-4007-986F-FA401A4AF94E": "Int15PanelColor",
    "BCDAF080-1BDE-4E22-AE6A-43541E128EC4": "EfiIsaHcProtocolGuid",
    "BCEA6548-E204-4486-8F2A-36E13C7838CE": "FpgaSocketSetup",
    "BD1C1A1C-04EC-47ED-8AB7-D19319C64138": "FastBoot",
    "BD22D0BF-4818-4EF8-BDCD-B3478F52A802": "HeavyPciBusDebug",
    "BD26CDC9-A092-462A-877A-5AB6ADCE4812": "EfiPlatformCpuProtocolGuid",
    "BD445D79-B7AD-4F04-9AD8-29BD2040EB3C": "EfiLockBoxProtocolGuid",
    "BD44F629-EAE7-4198-87F1-39FAB0FD717E": "FspEventEndOfFirmwareGuid",
    "BD712601-082F-4C59-8677-2C8A3C297948": "LoadFileOnFv2",
    "BD7E9A27-D6C5-416A-B245-5F507D95B2BD": "WinNtBusDriverDxe",
    "BD87394D-465C-40A9-9657-FBED21789860": "BinConvert",
    "BD8C1056-9F36-44EC-92A8-A6337F817986": "EfiEdidActiveProtocolGuid",
    "BD9320EB-7BB9-4AED-A682-CF4F96BE244C": "IntelMchFieldAcpiTables",
    "BDA39D3A-451B-4350-8266-81AB10FA0523": "PeiDxeDebugLibReportStatusCode",
    "BDAD7D1A-4C48-4C75-B5BC-D002D17F6397": "AhciRecovery",
    "BDB38125-4D63-49F4-8212-61CF5A190AF8": "EfiUserInfoAccessSetupRestrictedGuid",
    "BDC8E6AF-D9BC-4379-A72A-E0C4E75DAE1C": "EfiHttpServiceBindingProtocolGuid",
    "BDCE85BB-FBAA-4F4E-9264-501A2C249581": "S3SaveStateDxe",
    "BDFDE060-7E41-4EAE-AD9B-E5BBA7A48A3A": "EfiDevicePathPropertyDatabase",
    "BDFE430E-8F2A-4DB0-9991-6F856594777E": "EhciDxe",
    "BDFE5FAA-2A35-44BB-B17A-8084D4E2B9E9": "FvbServicesRuntimeDxe",
    "BE0FEABA-3443-4919-9F3A-2D4216329EA9": "WinNtAutoScan",
    "BE189D38-C963-41CF-B695-D90E9E545A13": "UfsBlockIoPei",
    "BE216BA8-38C4-4535-A6CA-5DCA5B43ADDF": "SmiVariable",
    "BE731247-5FA2-4D5B-9DB6-5385CCCD59E1": "UsbOcUpdateDxeLightningRidgeEXECB3",
    "BEA39084-044A-4C88-8763-2BFAFFA8950C": "LTEB",
    "BF0A78BA-EC29-49CF-A1C9-7AE54EAB6A51": "EfiMtftp6ProtocolGuid",
    "BF4B9D10-13EC-43DD-8880-E90B718F27DE": "EmbeddedDeviceGuid",
    "BF89F10D-B205-474F-96E3-7A7BB1B4A407": "VgaClassDxe",
    "BFD59D42-FE0F-4251-B772-4B098A1AEC85": "ActiveBios",
    "BFD7DC1D-24F1-40D9-82E7-2E09BB6B4EBE": "EfiDriverConfiguration2ProtocolGuid",
    "BFE205C9-5B17-4F8F-9375-89614AF8E199": "OEMDXE",
    "C020489E-6DB2-4EF2-9AA5-CA06FC11D36A": "EfiAcpiVariableCompatiblityGuid",
    "C02B0573-2B4E-4A31-A31A-94567B50442C": "PchUsbPolicyPpiGuid",
    "C0512F00-0181-48C0-8B71-90504B8F991E": "EfiBootNameLabel",
    "C05ED2D1-5DDE-4B6E-A1AE-0B306ACB42BC": "TrEEDxe",
    "C06C5A03-704C-45D6-808E-4D9E867897D3": "AppleEffaceableLocker",
    "C0734D12-7927-432B-986B-A7E3A35BA005": "LightPciBusPciBusDxe",
    "C076EC0C-7028-4399-A072-71EE5C448B9F": "EfiCustomModeEnableGuid",
    "C07A1EB5-5C04-4100-817B-0A11BB5F15DC": "CppcDxe",
    "C095791A-3001-47B2-80C9-EAC7319F2FA4": "EfiFirmwarePerformanceGuid",
    "C0CC43BD-C920-4064-935B-93B447379470": "PowerManagementAcpiTableStorageGuid",
    "C10194E7-DEB2-4AF4-9EEE-BFFDE4D7D4C7": "TimestampDxe",
    "C118F50D-391D-45F4-B3D3-11BC931AA56D": "DsdtAsl",
    "C128CADC-623E-4E41-97CB-A7138E627460": "BaseFspSecPlatformLibNull",
    "C12A7328-F81F-11D2-BA4B-00A0C93EC93B": "EfiPartTypeSystemPartGuid",
    "C12C4E6A-BC3D-4A91-8299-7E0A4D5B5289": "SmcOemID",
    "C144476F-F118-4C84-A936-417C8AFBD437": "GenericUSBDebugger",
    "C18B8105-AB89-44DE-8D37-50B31FAE5D1E": "SgTpvAcpiS3Save",
    "C194C6EA-B68C-4981-B64B-9BD271474B20": "PchSpiRuntime",
    "C19783FD-E21E-451A-830E-C7CB23DB52CC": "menu_mid_left",
    "C1A69A12-8653-4FDE-A215-48FCD95288C3": "PlatformSetupDxe",
    "C1C41626-504C-4092-ACA9-41F936934328": "EfiCertSha256Guid",
    "C1C418F9-591D-461C-82A2-B9CD96DFEA86": "IntelLegacyInterrupt",
    "C1D61CB0-78B0-42F0-BC3F-F54DFEC65DB2": "PartialMirrorHandler",
    "C1E63AC4-D0CF-4CE6-835B-EED0E6A8A45B": "EfiPaddingRsaesOaepGuid",
    "C1E9FFFB-5557-4CB5-A5F5-1FBD902A74ED": "LibIIO",
    "C1FBD624-27EA-40D1-AA48-94C3DC5C7E0D": "SBPEI",
    "C1FCD448-6300-4458-B864-28DF015364BC": "EfiPeiLoadedImagePpiGuid",
    "C21CF0E2-6ABC-4C3B-9DE6-3ABA8C3F83C9": "DxeIchSmbus",
    "C2239ACD-21D0-4CB0-B7DB-6D35EE7B0CC1": "FirmwareRevisionSyncPei",
    "C22E6B8A-8159-49A3-B353-E84B79DF19C0": "VARIABLE",
    "C2702B74-800C-4131-8746-8FB5B89CE4AC": "EfiSmmAccess2ProtocolGuid",
    "C280C73E-15CA-11DA-B0CA-001083FFCA4D": "EfiAuthenticationChapLocalGuid",
    "C2891AB9-9D96-475D-BE55-9EDF18F4D5EF": "UsbIrq",
    "C2998CC8-A0AA-46E6-A634-EE32BF113188": "AmtDriverPeimPei",
    "C2A743FE-9951-4299-9817-71DB147570D9": "SmmPlatformDxe",
    "C2C79FD0-313C-4C4D-B9F1-ED26F00CA955": "XhciDxe",
    "C2F9AE46-3437-4FEF-9CB1-9A568B282FEE": "FspSecCoreM",
    "C3069C81-6717-4FB6-B646-04214894BAB4": "SmcSwSmiFlashDxe",
    "C30B94E3-C8F2-4AB0-91AB-FA8DF621B1C9": "MnpDxe",
    "C3158ABD-DB62-460F-B64C-FC258BB94A83": "BiosLiveUpdateDxe",
    "C31A6189-639A-458B-B040-D7D506CA8F4F": "GetHostByAddr",
    "C32A66D5-D8B7-2640-B768-082C8F083C37": "ThunkPpiToProtocolPei",
    "C35F272C-97C2-465A-A216-696B668A8CFE": "UserProfileManagerGuid",
    "C3811036-710B-4E39-8CF1-0AF9BE3A8198": "TimerDxe",
    "C38FB0E2-0C43-49C9-B544-9B17AA4DCBA3": "PowerManagementAcpiTables",
    "C39B4C90-CB56-49BC-9534-012F69A1C2CC": "UuidPeiInit",
    "C3D69D87-5200-4AAB-A6DB-2569BA1A92FC": "Tpm2DeviceLibRouterDxe",
    "C3E36D09-8294-4B97-A857-D5288FE33E28": "EfiBiosIdGuid",
    "C41E9862-D078-4E7D-9062-00E3FAC34C19": "AsusEcPei",
    "C41F8C82-B3E6-47E0-A61D-0F9E429E6996": "DebugCommunicationLibUsb3Dxe",
    "C463CEAC-FC57-4F36-88B7-356C750C3BCA": "UhciPei",
    "C4A58D6D-3677-49CB-A00A-9470765FB55E": "AddPerfRecordProtocolGuid",
    "C4B50EB2-ED16-4283-A5B0-A7341C3F997B": "ArmTrustedMonitorLibNull",
    "C4B8C7FB-D2E2-441C-BAD6-E5D46B1E1AA6": "T23HookResetSystem",
    "C4D1F932-821F-4744-BF06-6D30F7730F8D": "Ps2KeyboardDxe",
    "C4EB3614-4986-42B9-8C0D-9FE118278908": "CrystalRidge",
    "C4F2D007-37FD-422D-B63D-7ED73886E6CA": "IdeRControllerDxe",
    "C5046EFD-7BC3-4206-987C-32DA45026E6D": "PlatformInitDxe",
    "C5068BAC-A7DC-42F1-AE80-CAA24BB4904B": "PttPassThruPpiGuid",
    "C50B323E-9075-4F2A-AC8E-D2596A1085CC": "EfiSmmIchnDispatchProtocolGuid",
    "C5149B43-AE85-4F53-9982-B94335D3A9E7": "EfiRngAlgorithmSp80090Hmac256Guid",
    "C516673C-6C71-4F0E-83B5-57FC662376EC": "LibPosix",
    "C51711E7-B4BF-404A-BFB8-0A048EF1FFE4": "EfiIp4ServiceBindingProtocolGuid",
    "C5184932-DBA5-46DB-A5BA-CC0BDA9C1435": "EfiHashProtocolGuid",
    "C54B425F-AA79-48B4-981F-998B3C4B641C": "TrEEConfigFormSetGuid",
    "C54F4B67-E527-4379-BF61-193C7A68C661": "menu_none",
    "C5753963-3B84-4095-BF78-EDDAD3F9C9DD": "EfiPciBusErrorSectionGuid",
    "C57AD6B7-0515-40A8-9D21-551652854E37": "Shell",
    "C5847038-FF75-4074-9E4C-C36A2EB398A5": "LibTime",
    "C5B9C74A-6D72-4719-99AB-C59F199091EB": "SemihostFs",
    "C5D3191B-27D5-4873-8DF2-628136991A21": "UserIdentifyManager",
    "C5F25542-2A79-4A26-81BB-4EA63233B309": "EdkiiNonDiscoverableNvmeDeviceGuid",
    "C6068612-B6E0-48A3-BB92-60E4A4F89EDF": "UefiPciSegmentLibPciRootBridgeIo",
    "C613EC78-63ED-4B93-ACD4-54B3D4CCC268": "NetworkLockerDxe",
    "C61EF796-B50D-4F98-9F78-4F6F79D800D5": "MemoryInit",
    "C62CEB80-FB40-4A46-A5E5-C1D997C36DFC": "CapsuleLoaderTriggerDxe",
    "C62F4B20-681E-11DF-8F0D-0002A5D5C51B": "PciHostBridge",
    "C642C14C-0E9C-4AEF-94A5-A213BAA35DE0": "HstiResultDxe",
    "C65A623F-2768-4700-BE2C-1D8BA2C43998": "Inside",
    "C6760651-A38D-5F4F-AEAF-F6661549DF75": "EmuBlockIo",
    "C68DAA4E-7AB5-41E8-A91D-5954421053F3": "CbSupportDxe",
    "C68ED8E2-9DC6-4CBD-9D94-DB65ACC5C332": "EfiSmmCommunicationProtocolGuid",
    "C6A957E4-8303-4761-A084-92C0692D90F9": "PoofAnimationState3",
    "C6BB86C0-16F5-4535-953E-E6C7CB6E4CB6": "FpgaErrorHandler",
    "C74D1B0B-91B1-484A-A038-FE7A0847AA07": "DualBiosDxe",
    "C7542254-A8F7-40BA-9BB9-390D31977775": "OCMR_PEI",
    "C7735A2F-88F5-4882-AE63-FAAC8C8B86B3": "EfiVgaMiniPortProtocolGuid",
    "C776AEA2-AA27-446E-975B-E0BEA9078BD9": "BiosGuardPeiApRecoveryCapsule",
    "C779F6D8-7113-4AA1-9648-EB1633C7D53B": "CapsulePei",
    "C7A7030C-C3D8-45EE-BED9-5D9E76762953": "MouseDriver",
    "C7B7070B-E5A8-4B86-9110-BDCA1095F496": "PeiFspHobProcessLibSample",
    "C7D35798-E4D2-4A93-B145-54889F02584B": "EdkiiNonDiscoverableAhciDeviceGuid",
    "C7D4BBCF-EB0A-4C91-BD8B-FCA99F28B011": "AmiTxtPei",
    "C7D4F4E3-DAEA-40B0-8846-F4CAF3135CE8": "BiosProtectDxe",
    "C7DF48CC-063E-4FD4-B775-75C00D9F19F6": "SmbusDebugPei",
    "C7E6800D-9566-1143-81A8-B8C566AF3556": "SNP",
    "C7EA9787-CA0A-43B4-B1E5-25EF87391F8D": "QncS3Support",
    "C7EA9F94-1547-44F0-863F-563EAE79E1C0": "TianoCompressSmm",
    "C810485E-D0EC-4E98-AAB5-120C7E554428": "TdtAm",
    "C81FFCBF-BB77-400B-BC86-C9B16CF95EAE": "AppleUsbNotify",
    "C8339973-A563-4561-B858-D8476F9DEFC4": "Metronome",
    "C85903B6-84B5-4D78-B59D-D2D6B97580F3": "PngConvertDxe",
    "C866BD71-7C79-4BF1-A93B-066B830D8F9A": "CpuS3Pei",
    "C88B0B6D-0DFC-49A7-9CB4-49074B4C3A78": "EfiStorageSecurityCommandProtocolGuid",
    "C89D72CE-E21A-4C71-BA79-770EF373D6DA": "BootSector",
    "C8B36958-00A7-4678-83EF-E5525A8CE4A4": "OemFixedBootOrderIpmi",
    "C8B64E46-9819-45AB-875D-09DFDA6D8B1B": "Firewire",
    "C8CA0BB8-67DA-4883-8CFC-9180CB9EEC68": "OemActivation",
    "C8F23B39-C95C-4318-9233-53FB3AC44592": "VariableVsr",
    "C9122295-56ED-4D4E-06A6-508D894D3E40": "FspApiPerformanceGuid",
    "C99E42D0-4964-4B09-B924-4A59E13E4F04": "SbRunSmm",
    "C9A6DE36-FDFF-4FAF-8343-85D9E3470F43": "NvmeInt13",
    "C9E057D7-3B6D-475C-B8C2-7C955D2F58B3": "gear4",
    "C9FAF091-57F8-A64C-A07A-445B124F0D93": "FlashMapPei",
    "CA0D6FF6-62A7-4B1F-BB90-52EECA01A99F": "TCM_MADriver",
    "CA1BCAD9-E021-4547-A1B0-5B22C7F687F4": "ACPIOSFRModelStringVariableGuid",
    "CA261A26-7718-4B9B-8A07-5178B1AE3A02": "DiskIoDxe",
    "CA3668C7-AE4E-454B-9E46-DA97AAAE0FF5": "X11SmmDriver",
    "CA37BC1F-A327-4AE9-828A-8C40D8506A17": "EfiDns6ProtocolGuid",
    "CA4233AD-847E-4E5D-AD3F-21CABFE5E23C": "WinNtOemHookStatusCodeHandlerDxe",
    "CA452C68-DF0C-45C9-82FB-EAE42B312946": "EfiVLVTokenSpaceGuid",
    "CA452C6A-DF0C-4DC9-82FB-EAE2AB312946": "EfiQuarkNcSocIdTokenSpaceGuid",
    "CA49B5C8-E977-4612-8706-91B82CD14C87": "IntelMchAcpiTables",
    "CA515306-00CE-4032-874E-11B755FF6866": "DataHubStdErrDxe",
    "CA5627C4-51BA-4DCB-AC62-C076EBD37DDB": "Python",
    "CA599759-90A7-4FE4-BC8B-4B71C350DCAC": "LibGen",
    "CA5A1928-6523-409D-A9FE-5DCC87387222": "TrEEPei",
    "CA5D7EB0-1B67-4B0B-964A-F2A861F0D640": "IccOverclockingDxe",
    "CA5E3DF0-940A-48F1-8C14-DB2FB5998B36": "TdtWrapper",
    "CA9D8617-D652-403B-B6C5-BA47570116AD": "TxtPei",
    "CAA4381E-750C-4770-B870-7A23B4E42130": "EfiHashAlgorithmSha512Guid",
    "CAB0E94C-E15F-11E3-918D-B8E8562CBAFA": "EfiBootManagerPolicyConsoleGuid",
    "CAC3FB95-33F5-4596-818B-68E024DDB67B": "IsSecRecoveryPEI",
    "CACB3817-81E6-497E-87FF-C8FA8F24EC28": "SgACPI",
    "CAE0AD55-47B7-4E03-A714-95E1711CC279": "BcpBootOrder",
    "CAEE2F3B-3191-4DA0-AD10-A5C07E636CD1": "LibString",
    "CB3FD86E-38A3-4C03-9A5C-90CFA3A2AB7A": "EfiExtendedSalMcaLogServicesProtocolGuid",
    "CB494BAD-23FF-427E-8608-D7E138D3363B": "ArmPlatformLibNull",
    "CB49CE50-3A75-11DE-8A39-0800200C9A66": "PerfTuneSmm",
    "CB537AA2-F727-440B-9702-ADE9D0A293F1": "PlatformStage2Pei",
    "CB73C3D9-2F01-4342-AE67-04DDE5264092": "PlatformSmm",
    "CB871572-C11A-47B5-B492-675EAFA77727": "EfiDiskInfoUsbInterfaceGuid",
    "CB933912-DF8F-4305-B1F9-7B44FA11395C": "AcpiPlatform",
    "CBC59C4A-383A-41EB-A8EE-4498AEA567E4": "FlashDriver",
    "CBC91F44-A4BC-4A5B-8696-703451D0B053": "ReserveBootGuardFvMainHashKey",
    "CBD2E4D5-7068-4FF5-B462-9822B4AD8D60": "VariableRuntimeDxe",
    "CBD86677-362F-4C04-9459-A741326E05CF": "SeCUmaPpiGuid",
    "CBF486B7-D196-4C03-AFE2-33F38E64DA16": "IntegratedTouch",
    "CC0F8A3F-3DEA-4376-9679-5426BA0A907E": "PkVar",
    "CC1BAA36-11EB-45CC-9ADC-7565E273AC70": "PnpSmm",
    "CC1FC04E-0B3D-4E0E-AED7-5898541E2683": "CSMLinkerDxe",
    "CC322E80-6A08-4E80-8BCA-01A84BA6CFE4": "PciHostBridge2",
    "CC5263E8-9308-454A-89D0-340BD39BC98E": "EfiEventNotificationTypeInitGuid",
    "CC54F583-3F9E-4AB0-9F7C-D2C7ED1C87A5": "AppleRtcRam",
    "CC582C73-F48F-4B62-83E8-A586B4C88F84": "AppleFirmwareFeatures",
    "CC664EB8-3C24-4086-B6F6-34E856BCE36E": "EfiWinNtPassThroughGuid",
    "CCC5C136-ACD3-4251-9BDC-F663CD2297B7": "AppleAudioDecoder",
    "CCCB0C28-4B24-11D5-9A5A-0090273FC14D": "GraphicsConsoleDxe",
    "CCEC84CD-CDC5-4C75-8637-D4508FC79CCD": "PngConvert",
    "CD2B6EB3-EA11-4848-B687-AFE57D3D1C0F": "ApplePpiPlatformInfoDB",
    "CD3BAFB6-50FB-4FE8-8E4E-AB74D2C1A600": "EnglishDxe",
    "CD3D0A05-9E24-437C-A891-1EE053DB7638": "EdkiiVariableLockProtocolGuid",
    "CD51358D-6E7E-45CA-B450-57C046BDFDDC": "BmpConvert",
    "CD554A69-EE4D-404F-855A-84A6A39755D7": "AmiSriovLibNull",
    "CD72881F-45B5-4FEB-98C8-313DA8117462": "EfiI2cMasterProtocolGuid",
    "CD7C839D-0521-4B26-9476-9FF2CB70649A": "OpromUpdateDxeNeonCityEPECB",
    "CD84562C-6864-40A3-A081-C8D35E82B920": "CspLibDxe",
    "CDC1C80D-E6D3-4A42-9229-75F3BEFCF109": "PciOutOfResourceSetupPage",
    "CDC5DDDF-E79D-41EC-A9B0-6565490DB9D3": "IgdOpRegionProtocolGuid",
    "CDE1A697-5BEB-7E4A-95D8-4078E564E70C": "PngConvert",
    "CDEA2BD3-FC25-4C1C-B97C-B31186064990": "EfiBootLogoProtocolGuid",
    "CDEC3671-816E-43DC-A002-DCD645229338": "I2cHostDxe",
    "CE033449-3D90-9644-862E-2D7D9AA3F06A": "BinConvert",
    "CE12B236-17E5-47B4-96AE-C85BBAC1E5BF": "SmcAssetInfo",
    "CE345171-BA0B-11D2-8E4F-00A0C969723B": "EfiDiskIoProtocolGuid",
    "CE366D33-B057-4C03-8561-CAF17738B66F": "WdtAppDxe",
    "CE3DA938-6AD6-458A-8831-6B0A03DF6C86": "Pentium4Base",
    "CE57B167-B0E4-41E8-A897-5F4FEB781D40": "EdkiiSystemFmpCapsuleDriverFvFileGuid",
    "CE5E5929-C7A3-4602-AD9E-C9DAF94EBFCF": "EfiIpSecConfigProtocolGuid",
    "CE660500-824D-11E0-AC72-0002A5D5C51B": "HdLcdGraphicsDxe",
    "CE76670A-55C0-484B-962E-84A2F65210A6": "MEMPATCHPEI",
    "CE7CD764-A1D9-44E5-9857-14FEFAAE96DD": "PnpDxe",
    "CE845704-1683-4D38-A4F9-7D0B50775793": "EfiPlatformBootModeGuid",
    "CEA4FF9C-D7BC-4F07-96F1-03F41F2B17AE": "BaseFspDebugLibSerialPort",
    "CEAB683C-EC56-4A2D-A906-4053FA4E9C16": "EfiTemporaryRamDonePpiGuid",
    "CEE19373-FB2A-4B8E-BEF5-B6D7731F4939": "I2cBus",
    "CEEC2EE9-BF2D-45D9-B96A-1144B062395D": "UsraQuiesceLibNull",
    "CEF5B9A3-476D-497F-9FDC-E98143E0422C": "NVRAM",
    "CEF68C66-06AB-4FB3-A3ED-5FFA885B5725": "SMBiosBoard",
    "CF2F5574-3C73-4D2F-976D-665CAD2E5381": "ASUSDirectKeyDXE",
    "CF31FAC5-C24E-11D2-85F3-00A0C93EC93B": "BlockIoVendorGuid",
    "CF569F50-DE44-4F54-B4D7-F4AE25CDA599": "XenIoPciDxe",
    "CF6BCADD-D4C4-4095-B2BC-417D7247890A": "StaticSkuDataDxeNeonCityFPGA",
    "CF7A379E-F788-44D4-AF65-165CE1E0ED68": "SmcOptimizeDxe",
    "CF8034BE-6768-4D8B-B739-7CCE683A9FBE": "EfiPciHostBridgeResourceAllocationProtocolGuid",
    "CF93C01F-1A16-4DFC-B8BC-9C4DAF67C104": "EfiEventNotificationTypePcieGuid",
    "CFB33810-6E87-4284-B203-A66ABE07F6E8": "EfiHeciProtocolGuid",
    "CFFB32F4-C2A8-48BB-A0EB-6C3CCA3FE847": "ApfsJumpStart",
    "D00752EA-A49C-40AD-A6DA-921C030C4B2F": "DxeIchInitDxe",
    "D024BCD2-59EA-48AC-A17F-B3221EC23A11": "Int15GetMisc",
    "D038747C-D00C-4980-B319-490199A47D55": "FspReservedMemoryResourceHobTsegGuid",
    "D04159DC-E15F-11E3-B261-B8E8562CBAFA": "EfiBootManagerPolicyNetworkGuid",
    "D0632C90-AFD7-4492-B186-257C63143C61": "SmmBase",
    "D083E94C-6560-42E4-B6D4-2DF75ADF6A2A": "EfiDataHubStatusCodeRecordGuid",
    "D0849ED1-A88C-4BA6-B1D6-AB50E280B7A9": "UsbCredentialProviderGuid",
    "D088A413-0A70-4217-BA55-9A3CB65C41B3": "ExitPmAuthProtocolGuid",
    "D0893F05-B06D-4161-B947-9BE9B85AC3A1": "SnpNt32Dxe",
    "D0CAA91E-2DE4-4B0D-B3DC-09C67E854E34": "BiosSnp16",
    "D0CAF5CA-3DF0-3D4F-89C5-66105356D61B": "AppleBds",
    "D1150ED7-E582-4192-84A2-71B4EBA9A7C6": "AcpiPlatformDxe",
    "D122882C-DA73-438B-A6B3-E07B7D18DB6F": "FastBootSmi",
    "D124DFA7-D784-C64E-8106-29411A7F59DB": "MnpDxe",
    "D1A26C1F-ABF5-4806-BB24-68D317E071D5": "AppleEpidCertificate",
    "D1C17AA1-CAC5-400F-BE17-E2A2AE06677C": "EfiKmsFormatMd4128Guid",
    "D1C4AAF9-AAB1-4AEE-ACAC-D68AEF05F0D5": "UsraLibNull",
    "D1E59F50-E8C3-4545-BF61-11F002233C97": "TxtPeiAp",
    "D233D6BD-F1B1-425A-BF45-5CAF2B88EDDC": "WinNtOemHookStatusCodeHandlerPei",
    "D258D6AF-2FC0-4019-9C1F-1101C3DD19B5": "DxeCoreEntryPoint",
    "D25F555A-30EF-49EE-8FB5-C76B5817CC2A": "AppleBootUI",
    "D26374A5-7716-4708-AD9F-9C4F2C02547E": "IchS3Save",
    "D26697EE-9983-48B0-8F85-7D3E66528B07": "LegacyBiosDxe",
    "D26C221E-2430-4C8A-9170-3FCB4500413F": "TcgEvent2EntryHobGuid",
    "D27FED59-ABB4-4FED-BEAD-2A878C7E4A7E": "SmbiosMeasurementDxe",
    "D2846ADB-B41B-4103-871F-E2235F4778C7": "SmcPostMsgHotKey_PEI",
    "D2B2B828-0826-48A7-B3DF-983C006024F0": "EfiStatusCodeRuntimeProtocolGuid",
    "D2BC3092-92BB-4B21-A26B-CE6F7C3E9857": "AtAmUi",
    "D2C18636-40E5-4EB5-A31B-36695FD42C87": "EfiShellEnvironment2ExtGuid",
    "D2C69B26-82E1-4A1B-AD35-ED0261B9F347": "MemoryInitPei",
    "D317F29B-A325-4712-9BF1-C61954DC198C": "EfiSmartCardEdgeProtocolGuid",
    "D31EAA20-8436-4E34-9A06-C47C78E19F18": "SIOBasicIODxe",
    "D31F0400-7D16-4316-BF88-6065883B402B": "EfiPchInfoProtocolGuid",
    "D3231048-B7D7-46FC-80F8-2F7B229586C5": "UTDMUIApp",
    "D326D041-BD31-4C01-B5A8-628BE87F0653": "EfiSmmFirmwareVolumeBlockProtocolGuid",
    "D3300D09-B70F-4315-9785-FE37209EFDCB": "HddSecurityBdsCall",
    "D359DE86-0A1B-47BC-95D2-1D1F8FFF0AD8": "ChipsetSvcSmm",
    "D36DDD2D-1C66-4210-B77A-2FD9F920E51F": "ASUS_EUPSxSMI",
    "D3705011-BC19-4AF7-BE16-F68030378C15": "EfiIntelFrameworkModulePkgTokenSpaceGuid",
    "D3709BB4-B194-4B71-B9C0-DBD8D2DA97AD": "IntelIchLegacyInterruptDxe",
    "D3790CB3-A890-4A5A-A42E-ECB6B140D814": "UHESerial",
    "D3987D4B-971A-435F-8CAF-4967EB627241": "SerialDxe",
    "D398E61C-2A9C-4A6D-B265-47696CF9E442": "ASUSFS2",
    "D3AAD8DC-3A48-46AC-B1C7-28A9D3CF6755": "WinNtThunkPPIToProtocolPei",
    "D3B36F2B-D551-11D4-9A46-0090273FC14D": "EfiConsoleInDeviceGuid",
    "D3B36F2C-D551-11D4-9A46-0090273FC14D": "EfiConsoleOutDeviceGuid",
    "D3B36F2D-D551-11D4-9A46-0090273FC14D": "EfiStandardErrorDeviceGuid",
    "D3B46F3B-D441-1244-9A12-0012273FC14D": "EfiXenInfoGuid",
    "D3ECC567-9FD5-44C1-86CF-5DA7A24F4B5D": "EfiLpcWpc83627PolicyProtocolGuid",
    "D400D1E4-A314-442B-89ED-A92E4C8197CB": "EfiQuarkCapsuleGuid",
    "D42AE6BD-1352-4BFB-909A-CA72A6EAE889": "LzmaF86CustomDecompressGuid",
    "D42F8F9A-9B96-4F47-B045-A8F3CD1FD9D3": "SecureVariable",
    "D432A67F-14DC-484B-B3BB-3F0291849327": "EfiDiskInfoProtocolGuid",
    "D450A69D-D8E4-C048-8E7E-0024EB541C79": "NetworkInterfacePolicyDriver",
    "D458A654-F64C-49DB-B8D1-3821306BF1F6": "BaseMemoryLibMmx",
    "D462AE45-FF5A-4448-A474-B986E2A0D5B1": "G3WakeupDxe",
    "D487DDB4-008B-11D9-AFDC-001083FFCA4D": "EfiSasDevicePathGuid",
    "D49D2EB0-44D5-4621-9FD6-1A92C9109B99": "HiiResourcesSample",
    "D4A88838-EBF4-48D7-9D97-CE6789FDE0B7": "CryptoPkgTest",
    "D4BECF5B-190D-46DB-92CC-3F5D74904DDA": "SmmAccessDxe",
    "D4EE25EA-0B48-43AE-A016-4D6E8B6C43B3": "MemoryInit_",
    "D5125E0F-1226-444F-A218-0085996ED5DA": "Smbus",
    "D52B0965-681A-4DC6-92C6-B20A30208598": "AAFTblPEI",
    "D56A4094-570F-4D3D-8F5F-8D8AA0B396CB": "EhciPei",
    "D57C852E-809F-45CF-A377-D77BC0CB78EE": "IdeSmart",
    "D58EBCE1-AF26-488D-BE66-C164417F8C13": "PciHostBridge",
    "D5919FF6-D708-4918-87A0-1BB21B157C08": "CaseOpenDxe",
    "D5B06D16-2EA1-4DEF-98D0-A05D40728417": "EfiWatchdogTimerDriverProtocolGuid",
    "D5B366C7-DB85-455F-B50B-900A694E4C8C": "SlingShot",
    "D5D52FED-F8A6-49AC-97AC-7291A60405A6": "FsIso9660",
    "D5E606EB-83DF-4E90-81E8-C3DB2F77179A": "rmHwA15x2A7x3Guid",
    "D6062B50-15CA-11DA-9219-001083FFCA4D": "EfiAuthenticationChapRadiusGuid",
    "D6099B94-CD97-4CC5-8714-7F6312701A8A": "VirtioGpuDxe",
    "D6207835-B7E3-4FF8-B276-CDE3E52206BC": "SmbiosDataUpdateDxeLightningRidgeEXECB1",
    "D6294C9B-0866-4753-AAAD-7699AFC4BEE4": "DefaultFixedBootOrder",
    "D62C96E9-D7D7-4D28-B0F9-BF2CA151DDEF": "IePolicyInitPei",
    "D6405DAC-92D7-4BB2-A9C9-CB7C749023F5": "BIOSLD",
    "D6494E1B-E06F-4AB5-B64D-48B25AA9EB33": "SmmCpuPlatformHookLibNull",
    "D65D9F72-7BCE-4F73-A673-47AF446A1A31": "SmmRuntimeDxeReportStatusCodeLibFramework",
    "D6A2CB7F-6A18-4E2F-B43B-9920A733700A": "DxeCore",
    "D6A9928C-3397-4DD1-818F-C664BA6DCAAF": "DevUtility",
    "D6A9A1B9-4BFD-D61E-F037-3FA4CA06E046": "Lua",
    "D6AC4AC2-8BC2-4CDD-8776-280E1469DE02": "PchPolicyInitDxe",
    "D6C589EA-DD29-49EF-97F6-1A9FE19A04E0": "PwdCredentialProvider",
    "D6D2FBA6-EF60-4C38-A83E-6769814D23B0": "CryptoPei",
    "D6F43B1B-0F21-462B-B8B7-A033C3EB4261": "BaseMemoryLibOptPei",
    "D719B2CB-3D3A-4596-A3BC-DAD00E67656F": "EfiImageSecurityDatabaseGuid",
    "D71C8BA4-4AF2-4D0D-B1BA-F2409F0C20D3": "UncoreInitPeim",
    "D71C9263-2E64-40F9-82B8-F25B27069D4F": "EnePEI",
    "D739F969-FB2D-4BC2-AFE7-081327D3FEDE": "AMTDxe",
    "D74CC5E6-B169-456E-91D2-BE2C2D1343A6": "SpiFlashLibNull",
    "D77C900D-A1C7-41C5-B989-0C3D37FCA432": "AmtWrapperDxe",
    "D79DF6B0-EF44-43BD-9797-43E93BCF5FA8": "VlanConfigFormSetGuid",
    "D7AD636E-B997-459B-BF3F-8846897980E1": "EfiHiiProtocolGuid",
    "D7B10D4E-67E6-4C74-83E9-F9AF0ACC33CC": "PchInitSmm",
    "D7C74207-A831-4A26-B1F5-D193065CE8B6": "EfiAdapterInfoMediaStateGuid",
    "D7E31ECB-0A17-4529-9B84-C529DE8E1C0E": "AcpiFvi",
    "D7E69789-1F68-45E8-96EF-3B6407A5B2DC": "EfiKmsFormatAescbc256Guid",
    "D8117CFE-94A6-11D4-9A3A-0090273FC14D": "EfiDecompressProtocolGuid",
    "D81D1706-BE6F-4734-B2AF-F885FFDCB16D": "AsixUsbEthernetDxe",
    "D872AEFA-7C5F-4C66-8836-AA57EFF0D9F8": "IconGenericExternalHardDrive",
    "D8A6F4A6-0E97-4A8B-A475-39F1B28B5AEC": "Fv2OnFvThunk",
    "D8AAB432-93CC-48D2-9F34-3496CAF92185": "SmartFanCtrlDXE",
    "D8AB1072-4B45-4828-837D-A4214377802E": "BCLANDXE",
    "D8D282C4-4478-4D75-B10B-B08F5E59B5E8": "BasicDiagnostics",
    "D9072C35-EB8F-43AD-A220-34D40E2A8285": "EfiSmmSpiProtocolGuid",
    "D912C7BC-F098-4367-92BA-E911083C7B0E": "Udp6Dxe",
    "D933DEDE-0260-4E76-A7D9-2F9F2440E5A5": "NBSMI",
    "D93CE3D8-A7EB-4730-8C8E-CC466A9ECC3C": "ReportStatusCodeRouterRuntimeDxe",
    "D93DE2E3-3727-4D5B-B49F-777C93A971D3": "OpromUpdateDxeLightningRidgeEXECB3",
    "D959E387-7B91-452C-90E0-A1DBAC90DDB8": "ArmPlatformPrePiUniCore",
    "D96A2393-8790-4BAA-9CEB-42533F016EE9": "RegAccessSMM",
    "D97435DE-E680-41FC-93BE-4A76A5C82F7F": "SerialDebugInitPei",
    "D9760FF3-3CCA-4267-80F9-7527FAFA4223": "EfiMtftp6ServiceBindingProtocolGuid",
    "D995E954-BBC1-430F-AD91-B44DCB3C6F35": "EfiPcieErrorSectionGuid",
    "D9B07611-4ED7-38BF-B304-42116E7C966A": "OSRecovery",
    "D9BEE56E-75DC-49D9-B4D7-B534210F637A": "EfiCertDbGuid",
    "D9D114EF-F40B-4D48-AAA0-A3DC99C9F5BD": "DebugAgentPei",
    "D9DCC5DF-4007-435E-9098-8970935504B2": "PlatformDxe",
    "D9E9FA06-0FE0-41C3-96FB-83425A3394F8": "EfiExtendedSalBaseServicesProtocolGuid",
    "D9F11A26-249C-46AC-9CB5-E4F77E035C90": "NetworkRecoveryNameLabel",
    "D9F5B28C-9FF1-47D6-B503-3DC23BD345FF": "PchEarlyInitPeim",
    "DA6855BD-07B7-4C05-9ED8-E259FD360E22": "EfiPei144FloppyBlockIoPpiGuid",
    "DA7CAF76-CB17-4D80-AE21-2BD3AE421C76": "RuntimeAmiFlashLibCompat",
    "DA836F8D-217F-4CA0-99C2-1CA4E16077EA": "EfiHash2ServiceBindingProtocolGuid",
    "DA8CD7C4-1C00-49E2-803E-5214E701894C": "EfiI2cEnumerateProtocolGuid",
    "DA964524-D0E5-4C32-90D0-010021CFB2DC": "PMBUSDXE",
    "DA9F192F-BAE4-4F20-8C6C-55C1ACDE80B0": "menu_checked",
    "DAA55048-BC3F-4DD9-999B-F58ABF2BBFCC": "DxePlatform",
    "DAC2B117-B5FB-4964-A312-0DCC77061B9B": "Font",
    "DACF705C-71DF-497D-AABE-10186B2E1DDE": "Recovery",
    "DADE1003-1B31-4FE4-8557-26FCEFC78275": "InjectorKext",
    "DADE8301-CB29-4FD5-8148-56FD246C5B88": "UefiApplicationEntryPoint",
    "DAF4BF89-CE71-4917-B522-C89D32FBC59F": "SMBiosStaticData",
    "DAF7B0E6-32DE-4619-B63A-2B9173A75B14": "GetNetByName",
    "DB08F6CA-3048-4CD8-9B1F-20BED33ECFE7": "StatusCodeSmm",
    "DB1C3561-4F9E-4748-A807-BCBE7FA92FC9": "EzConfig",
    "DB47D7D3-FE81-11D3-9A35-0090273FC14D": "EfiFileSystemVolumeLabelInfoIdGuid",
    "DB4E8151-57ED-4BED-8833-6751B5D1A8D7": "ConnectConInEventGuid",
    "DB63592C-B8CC-44C8-918C-51F534598A5A": "PchResetProtocolGuid",
    "DB8AF09A-34E3-4A7B-8225-8C5B0C059EB8": "AppleSmc",
    "DB9A1E3D-45CB-4ABB-853B-E5387FDB2E2D": "EfiLegacyBiosProtocolGuid",
    "DBA6A7E3-BB57-4BE7-8AF8-D578DB7E5687": "EfiTscFrequencyGuid",
    "DBC6381F-5554-4D14-8FFD-76D787B8ACBF": "IpmiProtocolGuid",
    "DBD5B6BA-6734-4C5D-BF53-2C210D93A012": "IsctSmm",
    "DBE23AA9-A345-4B97-85B6-B226F1617389": "EfiTemporaryRamSupportPpiGuid",
    "DBE37563-AFEF-4B41-BDCE-B01B6D1E8690": "Tpm12DeviceLibInfineonI2c",
    "DBFF9D55-89B7-46DA-BDDF-677D3DC0241D": "EfiAcpiSupportProtocolGuid",
    "DC2CD8BD-402C-4DC4-9BE0-0C432B07FA34": "UefiFrameBufferInfoGuid",
    "DC3641B8-2FA8-4ED3-BC1F-F9962A03454B": "Mtftp4Dxe",
    "DC38DF16-8280-49C1-B253-D7DBB301CF78": "UserCredentialPwdDxe",
    "DC3EA0B0-A144-4797-B95B-53FA242B6E1D": "EfiProcessorSpecificErrorSectionGuid",
    "DC54B283-1A77-4CD6-83BB-FDDA469A2EC6": "EdkiiPeiUfsHostControllerPpiGuid",
    "DC7E8613-C4BB-4DB0-8462-13511357ABE2": "EfiKmsFormatAesxts256Guid",
    "DC92A37B-4AC5-4117-AABB-019FFC0FD06A": "FpkSetup",
    "DC952D08-C62B-41C6-BAC7-70ED054F91E5": "Pkcs7VerifyDxe",
    "DCAA4B60-408F-4BAD-99B9-B880D4EF0950": "TdtDxe",
    "DCBC3662-9CDA-4B52-A04C-82EB1D2348C7": "EfiKmsFormatMd5128Guid",
    "DCBE6D66-D928-4138-8041-358F35CBCF80": "IsaBusDxe",
    "DCC64575-FA7D-4B7B-B1AD-48427C97C74D": "LibCtype",
    "DCD0BE23-9586-40F4-B643-06522CED4EDE": "EfiPeiSecurity2PpiGuid",
    "DCDF614D-930E-4FDF-AFCD-F4A8A408E077": "EarlyVideoDxe",
    "DCFA911D-26EB-469F-A220-38B7DC461220": "EfiMemoryAttributesTableGuid",
    "DD455A69-EC75-456C-84D2-95CAE7D3C6D3": "EslTcp6ServiceGuid",
    "DD5E92D1-DDAC-48CB-907A-882D8610E89E": "SavePegConfig",
    "DD787473-07CE-4C63-82CE-930B33F39C09": "SmmControl2",
    "DD9E7534-7762-4698-8C14-F58517A625AA": "EfiSimpleTextInputExProtocolGuid",
    "DDABFEAC-EF63-452C-8F39-ED7FAED8265E": "PpmPlatformPolicyProtocolGuid",
    "DDADFC93-FBC5-4389-B20F-EC99E4A6AE52": "SmmLibNull",
    "DDB412A6-E3F3-4E9E-90A3-2A991270219C": "iFfsDxePolicyInit",
    "DDCBCFBA-8EEB-488A-96D6-097831A6E50B": "HashLibBaseCryptoRouterPei",
    "DDCF3616-3275-4164-98B6-FE85707FFE7D": "EfiVariableInfoGuid",
    "DE0EE9A4-3C7A-44F2-B78B-E3CCD69C3AF7": "EfiExtendedSalBootServiceProtocolGuid",
    "DE141A05-FA40-432D-9631-5E3E990F44D5": "SlotDataUpdateDxeNeonCityEPRP",
    "DE161CFE-1E60-42A1-8CC3-EE7EF0735212": "EfiTpmMpDriverProtocolGuid",
    "DE23ACEE-CF55-4FB6-AA77-984AB53DE811": "SaInitDxe",
    "DE23ACEE-CF55-4FB6-AA77-984AB53DE823": "PchInitDxe",
    "DE28BC59-6228-41BD-BDF6-A3B9ADB58DA1": "FramerworkEfiFirmwareVolumeBlockProtocolGuid",
    "DE371F7C-DEC4-4D21-ADF1-593ABCC15882": "ArmGicDxe",
    "DE3E049C-A218-4891-8658-5FC06A84C783": "SBCbsPEIEntryPei",
    "DE3E049C-A218-4891-8658-5FC0FA84C788": "AmdProcessorInitPeimPei",
    "DE498C70-1EDA-466B-ABCF-DD3ABC3D24B4": "DummyMSOA",
    "DE5FC8BF-06ED-4DC5-BA9D-29F711699A85": "TraceHubStatusCodeHandlerRuntimeDxe",
    "DEA652B0-D587-4C54-B5B4-C682E7A0AA3D": "AcpiS3IdtrProfileGuid",
    "DEB0EE00-18DF-415C-AF03-74D09B0AAD87": "JedecNvDimm",
    "DEC5DAA4-6781-4820-9C63-A7B0E4F1DB31": "ShellLevel1HiiGuid",
    "DED3F743-CE2C-4BA6-92A2-FFCE2A6D72D9": "PeiServicesTablePointerLibIdt",
    "DED7956D-7E20-4F20-91A1-190439B04D5B": "SmbiosGetFlashData",
    "DEEEA15E-4A77-4513-BA75-71D26FEF78A1": "SmmIoLibSmmCpuIo2",
    "DEF30E37-7AEC-4F69-91A2-CF099E2729F2": "PciTableInit",
    "DF1CCEF6-F301-4A63-9661-FC6030DCC880": "SecMain",
    "DF2D868E-32FC-4CF0-8E6B-FFD95D1343D0": "EfiPrintProtocolGuid",
    "DF4F6190-42B8-4CA9-BA51-7A801B565F08": "b57undix64",
    "DF5CD25A-8E55-46BA-8CDA-BC7DB7BF9C64": "MdesStatusCodeDrv",
    "DF636282-5EED-11DF-A9D6-B334FBA24BB0": "IntelHdAudioDxe",
    "DF8556F0-3A61-11DE-8A39-0800200C9A66": "PerfTunePei",
    "DF934DA3-CD31-49FE-AF50-B3C87C79325F": "PlatformDebugLibIoPort",
    "DF9A9591-B646-4621-AF0D-18143A73289F": "AppleLegacyBootFS",
    "DFA66065-B419-11D3-9A2D-0090273FC14D": "EfiVT100Guid",
    "DFB386F7-E100-43AD-9C9A-ED90D08A5E12": "EfiIpSecProtocolGuid",
    "DFD8D5CC-5AED-4820-A2B6-5C55E4E640EF": "AcpiPlatformSmi",
    "E008B434-0E73-440C-8612-A143F6A07BCB": "Recovery",
    "E01FDFD3-48C8-432C-9555-4409DDBC6C6A": "AmiFlashLibDxe",
    "E029BADD-E270-467E-9C0F-D7586C33850A": "Runtime",
    "E03ABADF-E536-4E88-B3A0-B77F78EB34FE": "CpuDxe",
    "E03E6451-297A-4FE9-B1F7-639B70327C52": "EnhancePeiVariable",
    "E0471A15-76DC-4203-8B27-6DB4F8BA644A": "UbaConfigDatabaseDxe",
    "E052D8A6-224A-4C32-8D37-2E0AE162364D": "PchSmbusDxe",
    "E062C52D-78DC-4CC5-B246-B13497A8123C": "PeiDxePostCodeLibReportStatusCode",
    "E0744B81-9513-49CD-8CEA-E9245E7039DA": "EfiSmmGpiDispatchProtocolGuid",
    "E07A890D-7CC3-D042-A74B-12F117DDDF15": "AppleGraphicsConsole",
    "E0BEC4CC-8AE8-4D15-92E5-9755A08987BB": "NCT3933UPEI",
    "E0C14753-F9BE-11D2-9A0C-0090273FC14D": "EfiPcAnsiGuid",
    "E0D8CA17-4276-4386-BB79-48CB813D3C4F": "EmbeddedTokenSpaceGuid",
    "E0E7D776-E7EB-4E5F-9AA8-54CF3AA64A43": "PeiServicesTablePointerLibKr7",
    "E0ECBEC9-B193-4351-A488-36A655F22F9F": "SaveMemoryConfigDxe",
    "E0FF720B-0140-43FE-9528-7A781357E42E": "UsbOhciDxe",
    "E113F896-75CF-F640-817F-C85A79E8AE67": "EmuThunkPpiGuid",
    "E11FACA0-4710-4C8E-A7A2-01BAA2591B4C": "FdtClientProtocolGuid",
    "E121EC07-9C42-45EE-B0B6-FFF8EF03C521": "AppleRtcRam",
    "E143C542-4FC4-4DD9-99F2-75715C44E41C": "IePolicyInitDxe",
    "E1475E0C-1746-4802-862E-011C2C2D9D86": "EfiRuntimeCryptProtocolGuid",
    "E1628C66-2A2D-4DC5-BD41-B20F3538AAF7": "BootPicker",
    "E18541CD-F755-4F73-928D-643C8A79B229": "EfiNetworkInterfaceIdentifierProtocolGuid",
    "E19E3D16-BC11-11E4-9CAA-C2051D5D46B0": "EfiArmProcessorErrorSectionGuid",
    "E1AF9F5B-7CDE-4F98-91ED-5E67868282B8": "BBVideo",
    "E1C1D0A9-40B1-4632-BDCC-D9D6E5295631": "EfiPaddingRsaesPkcs1V1P5Guid",
    "E1CD9D21-0FC2-438D-9703-04E66D961E57": "EfiExtendedSalPalServicesProtocolGuid",
    "E1CEE6E3-6C42-4A4F-916E-38385290A556": "SnpDxe_",
    "E1CF12E4-762B-4576-A158-9B255A828AA7": "gear2",
    "E1E1685A-7ABC-450F-882A-4E692CC6AF7E": "FpgaConfigDataDxeNeonCityFPGA",
    "E1EB612F-1C6C-485D-9D06-650844881569": "EfiSignedCapsulePkgTokenSpaceGuid",
    "E1F2EBA0-F7B9-4A26-8620-131221642A90": "EfiPciCfgPpiInServiceTableGuid",
    "E20939BE-32D4-41BE-A150-897F85D49829": "EfiMemoryOverwriteControlDataGuid",
    "E20BE735-E059-4CD5-A927-FF7D528EC650": "DescriptorUpdate",
    "E21F35A8-42FF-4050-82D6-93F7CDFA7073": "PiSmmCommunicationSmm",
    "E227C522-D5FE-4A53-87B1-0FBE570F98E9": "ObservableProtocolGuid",
    "E22BBCCA-516A-46A8-80E2-6745E83693BD": "EdkiiSmmMemoryProfileGuid",
    "E23F86E1-056E-4888-B685-CFCD67C179D4": "SBRun",
    "E2441B64-7EF4-41FE-B3A3-8CAA7F8D3017": "PciPlatformDxe",
    "E2657A19-7CD8-5389-98BC-6E201BBF4F70": "MonacoFont2x",
    "E2775B47-D453-4EE3-ADA7-391A1B05AC17": "PciSioSerialDxe",
    "E287D20B-D897-4E1E-A5D9-977763936A04": "EfiPchS3SupportProtocolGuid",
    "E2A74738-8934-48F5-8412-99E948C8DC1B": "SmbiosDmiEdit",
    "E2B36190-879B-4A3D-AD8D-F2E7BBA32784": "EfiCertRsa2048Sha256Guid",
    "E2EA6F47-E678-47FA-8C1B-02A03E825C6E": "TcgMorLockSmm",
    "E2ECA273-A1C0-407E-9A5C-F10C55142196": "BaseSmbusLibNull",
    "E3007647-798F-FF48-AC61-E0B8D1B66327": "PlatformDataRegion",
    "E3441740-3B41-4C90-9C9D-964056C7417D": "DxePciLibEsal",
    "E352725A-B84A-4EBC-A994-228E19224816": "SmcBMCSMI",
    "E360BDBA-C3CE-46BE-8F37-B231E5CB9F35": "FD_Drv_X64",
    "E364A338-2842-4F57-A7C7-CDC8CFDF6CD7": "AppleEvent",
    "E3752948-B9A1-4770-90C4-DF41C38986BE": "QemuVideoDxe",
    "E3830347-4844-49F1-9570-18AA377B711C": "AppleDiagnosticVault",
    "E38A1C3C-928C-4BF7-B6C1-7F0EF163FAA5": "FlashDeviceLibRuntimeSmm",
    "E38C1029-E38F-45B9-8F0D-E2E60BC9B262": "DisplayEngineGuid",
    "E38C11E3-968F-47B8-ACEF-ACC0693DB9FF": "EfiIchTokenSpaceGuid",
    "E38CB52D-A74D-45DB-A8D0-290C9B21BBF2": "UserProfileManager",
    "E3932A34-5729-4F24-9FB1-D7409B456A15": "OemBadgingSupportDxe",
    "E3E4048D-6C0C-43E4-AE1C-FFB579D8EF41": "OpalPasswordDxe",
    "E424C009-CD92-4FEC-8029-D79D3F1CF3DE": "IntelIchReset",
    "E43176D7-B6E8-4827-B784-7FFDC4B68561": "EfiRngAlgorithmRaw",
    "E4541241-8897-411A-91F8-7D7E45837146": "BaseSerialPortLibNull",
    "E469AA26-9268-4EB0-A087-DD4CEE37404B": "SecuritySelectDXE",
    "E472DF6D-2B4F-44AC-9165-CA2FCD5AB1F5": "AmiCspFlashPeiLibNull",
    "E49061CE-99A7-41D3-AB3A-36E5CFBAD63E": "AtapiPassThruDxe",
    "E49061CE-99A7-41D3-AB3A-36E5CFFEDCBA": "LsiLogicPassThruDxe",
    "E49D33ED-513D-4634-B698-6F55AA751C1B": "EfiSmbusHcProtocolGuid",
    "E4A88140-8E28-461D-91BC-A90FF015717C": "UsbOcUpdateDxeLightningRidgeEXRP",
    "E4C9411C-1268-404C-9E90-2573EF04F43F": "StaticSkuDataDxeNeonCityEPECB",
    "E4ECD0B2-E277-4F2B-BECB-E4D75C9A812E": "NBDXE",
    "E4F61863-FE2C-4B56-A8F4-08519BC439DF": "VlanConfigDxe",
    "E53734A3-E594-4C25-B1A2-081445650F7F": "SmmChildDispatcher2",
    "E541B773-DD11-420C-B026-DF993653F8BF": "EfiSmmSwDispatchProtocolGuid",
    "E54A3327-A345-4068-8842-70AC0D519855": "Tpm2DeviceLibDTpm",
    "E566B097-4378-485F-91D0-1C097C190CE2": "PowerButton",
    "E5769EA9-E706-454B-957F-AFC6DB4B8A0D": "QncS3ContextInLockBoxGuid",
    "E58809F8-FBC1-48E2-883A-A30FDC4B441E": "EfiIfrFrontPageGuid",
    "E5A1333E-E1B4-4D55-CEEB-35C3EF133443": "EfiFormBrowserProtocolGuid",
    "E5B58DBB-7688-44B4-97BF-5F1D4B7CC8DB": "EfiEapConfigurationProtocolGuid",
    "E5CB2AC9-D35D-4430-936E-1DE332478DE7": "EfiGraphicsDeviceInfoHobGuid",
    "E5DAFE50-10CB-41B5-9CB5-274E1CF1A8D7": "Ip6BmcLanConfig",
    "E5DD1403-D622-C24E-8488-C71B17F5E802": "EfiAdapterInformationProtocolGuid",
    "E5E2C9D9-5BF5-497E-8860-94F81A09ADE0": "NvmeSmm",
    "E60A79D5-DC9B-47F1-87D3-51BF697B6121": "CpuPei",
    "E6186D9E-2797-423D-B075-970A2C5FC338": "DmiArrayVarProtect",
    "E622443C-284E-4B47-A984-FD66B482DAC0": "BootManagerPolicyDxe",
    "E62F9F2F-4895-4AB5-1234-399D0D9C1234": "ComputraceDxe",
    "E633E57C-BBB1-4C6A-9F45-22C49378ADD0": "BootScriptThunkHelper",
    "E646C3A8-C7E2-4DC2-A7F2-E32A270B0B26": "LogoThunderbolt",
    "E64ACA85-F2CF-2246-87F4-92B839CCBB78": "SingleFile",
    "E660EA85-058E-4B55-A54B-F02F83A24707": "DisplayEngine",
    "E68088EF-D1A4-4336-C1DB-4D3A204730A6": "LcdGraphicsDxe",
    "E68DC11A-A5F4-4AC3-AA2E-29E298BFF645": "BCP",
    "E69562F2-C982-4E73-87B4-63BC79CDA110": "CPLDDXE",
    "E6AF1F7B-FC3F-46DA-A828-A3B457A44282": "EfiPeiCpuIoPpiInstalledGuid",
    "E6C2F70A-B604-4877-85BA-DEEC89E117EB": "PchInitVariableGuid",
    "E6C7EBB7-1604-4FCB-8F87-B3A6F48730AE": "OrderedCollectionTest",
    "E6DC9900-CCF6-452B-85FA-C7F1E52F0152": "SlotDataUpdateDxeNeonCityEPECB",
    "E6F4F8F7-4992-47B2-8302-8508745E4A23": "OemPir",
    "E6F930E0-BAE5-40E6-98C9-4CD2298278E7": "IconNetworkVolume",
    "E6FF49A0-15DF-48FD-9ACF-D7DC271B39D5": "UefiCorebootModulePkgTokenSpaceGuid",
    "E701458C-4900-4CA5-B772-3D37949F7927": "StatusCodeCallbackGuid",
    "E706CB54-84B8-40BD-832F-7FB2D5CB87B3": "FileExplorerLite",
    "E72527CF-505B-4B50-99CD-A32467FA4AA4": "AsfTable",
    "E764500B-E398-4AB7-BBBC-99A8E683681F": "MeSmbios",
    "E767BF7F-4DB6-5B34-1011-4FBE4CA7AFD2": "VlvMmioPolicyPpiGuid",
    "E7884BF4-51A1-485B-982A-FF89129983BC": "BaseMemoryLibRepStr",
    "E79A7050-8109-40D1-B3C0-2A3C74C40204": "AGI",
    "E7D9CAE1-6930-46E3-BDF9-0027446E7DF2": "Gpio",
    "E7E1EFA6-7607-4A78-A7DD-43E4BD72C099": "AppPkgTokenSpaceGuid",
    "E7E96F88-017B-417C-8DC8-B84C2B877020": "BaseFspWrapperApiTestLibNull",
    "E7F1DFF9-DAB6-498A-9ADF-57F344EDDF57": "UfsPassThruDxe",
    "E82F99DE-74ED-4E56-BBA1-B143FCA3F69A": "DebugAgentTimerLibNull",
    "E83C2C69-31E2-4557-A96F-0ADAB9EB7353": "SmbiosDataUpdateDxeNeonCityEPECB",
    "E84D8EAE-0151-41F0-9874-2F838DB47106": "PMBUSPEI",
    "E8571188-00C1-4ED4-B14E-E38451351EC4": "HddPassword",
    "E857CAF6-C046-45DC-BE3F-EE0765FBA887": "EfiS3SaveStateProtocolGuid",
    "E8A59290-A2AF-4099-B0AF-323FF9B7AB41": "BeginBootButton",
    "E8C729FE-FB0A-4344-AD7E-48784116C9EF": "SmmIpmiBmcInitialize",
    "E8DDEB8B-82D7-4B6E-A2B4-D5EAEC2B8976": "IrsiRegistrationRuntimeDxe",
    "E8F56FFE-919C-4CC5-BA88-65ABE14913BB": "EfiEventNotificationTypeMceGuid",
    "E8F6A75C-3CDA-4B00-9837-8CA2A1F34EAC": "SpsDxe",
    "E92BAE14-3DFD-4C70-9FE6-3899F36C7846": "PLEDSMM",
    "E92C4950-A483-445A-B6A8-B7029CA910AA": "PlatformStage1Pei",
    "E9312938-E56B-4614-A252-CF7D2F377E26": "AmiTcgPlatformPeiBeforeMem",
    "E94CD42A-3AAD-4EA0-9B09-945891C60CCD": "DxeIoLibCpuIo",
    "E94F54CD-81EB-47ED-AEC3-856F5DC157A9": "PiSmmCore",
    "E954929C-5BAC-4494-B963-3B23D4A13AD2": "QuiesceSupport",
    "E974833F-A4AE-4E39-BE37-8B6780DFAD01": "Int15PanelFitting",
    "E98ADB03-B8B9-4AF8-BA20-26E9114CBCE5": "EfiUserCredential2ProtocolGuid",
    "E9CA4775-8657-47FC-97E7-7ED65A084324": "EfiHiiFontProtocolGuid",
    "E9DB0D58-D48D-47F6-9C6E-6F40E86C7B41": "PeiTpmInitializedPpiGuid",
    "E9DD7F62-25EC-4F9D-A4AB-AAD20BF59A10": "StatusCodePei",
    "E9DEB2B3-88E4-46D2-B9A4-F60CACB918DC": "SmcRiserCardPei",
    "E9F05D70-9946-4AB9-A7F7-070E92C415BD": "Int15BootTV",
    "E9F4B929-EE33-4B70-8E90-17D283AF508C": "LibSoftfloat",
    "EA1D58A2-EA3D-4C14-928A-80A14545E681": "WheaPlatformBoot",
    "EA296D92-0B69-423C-8C28-33B4E0A91268": "PcdDataBaseHobGuid",
    "EA449C41-8236-4B97-9FF9-084E4BA70020": "ProgressBarEmptyMiddle",
    "EA5D72C1-4455-4FF8-91A1-4352DC1EE112": "gear8",
    "EA7CA24B-DED5-4DAD-A389-BF827E8F9B38": "EfiPeiFirmwareVolumeInfo2PpiGuid",
    "EAA006CD-3256-789B-BD20-EBABCD02583F": "SecureFlashPei",
    "EAA96391-9BE3-4488-8AF3-B3E6EFD157D5": "EmuSecPei",
    "EAD039A6-7390-411D-A9DE-E5294B25B897": "ASUSEZFlash",
    "EADD5061-93EF-4CCC-8450-F78A7F0820F0": "Tcg2ConfigPei",
    "EAEE5615-0CFD-45FC-8769-A0D85695AF85": "EdkiiNonDiscoverableEhciDeviceGuid",
    "EAF59C0E-BD46-413A-9AE9-DD9F6D1A927D": "SmbiosDxe",
    "EB23F55A-7863-4AC2-8D3D-956535DE0375": "EfiIncompatiblePciDeviceSupportProtocolGuid",
    "EB338826-681B-4295-B356-2B364C757B09": "EfiFtp4ProtocolGuid",
    "EB346B97-975F-4A9F-8B22-F8E92BB3D569": "EfiSmmCpuProtocolGuid",
    "EB5E4685-CA66-4769-B6A2-26068B001326": "EfiPciDevErrorSectionGuid",
    "EB704011-1402-11D3-8E77-00A0C969723B": "EfiMtcGuid",
    "EB740091-A494-44D7-8D96-C192F95A6394": "OobTx",
    "EB97088E-CFDF-49C6-BE4B-D906A5B20E86": "EfiAcpiSdtProtocolGuid",
    "EB9D2D2F-2D88-11D3-9A16-0090273FC14D": "EfiMpsTableGuid",
    "EB9D2D30-2D88-11D3-9A16-0090273FC14D": "EfiAcpi10TableGuid",
    "EB9D2D31-2D88-11D3-9A16-0090273FC14D": "EfiSmbiosTableGuid",
    "EB9D2D32-2D88-11D3-9A16-0090273FC14D": "EfiSalSystemTableGuid",
    "EBA4E8D2-3858-41EC-A281-2647BA9660D0": "EfiDebugPortProtocolGuid",
    "EBBE2D1B-1647-4BDA-AB9A-7863E396D41A": "EfiActiveBiosProtocolGuid",
    "EBC01AF5-07A9-489E-B7CE-DC089E459B2F": "EdkiiUfsHostControllerProtocolGuid",
    "EBC3AEAD-CC13-49B0-A678-5BED93956955": "BasePlatformHookLibNull",
    "EBD705FB-FA92-46A7-B32B-7F566D944614": "SP805WatchdogDxe",
    "EBF342FE-B1D3-4EF8-957C-8048606FF670": "SetupBrowserDxe",
    "EBF342FE-B1D3-4EF8-957C-8048606FF671": "SetupBrowser",
    "EBF8ED7C-0DD1-4787-84F1-F48D537DCACF": "DriverHealthManagerDxe",
    "EBFE50DA-14AE-4E5F-9E21-ADB76B320541": "AppleMcaDumpDxe",
    "EC20EB79-6C1A-4664-9A0D-D2E4CC16D664": "EfiTcp6ServiceBindingProtocolGuid",
    "EC2BEECA-E84A-445B-869B-F7A73C96F58A": "LegacyRegion2Dxe",
    "EC2E931B-3281-48A5-8107-DF8A8BED3C5D": "PlatformGOPPolicyGuid",
    "EC3A978D-7C4E-48FA-9ABE-6AD91CC8F811": "EfiKmsProtocolGuid",
    "EC835DD3-FE0F-617B-A621-B350C3E13388": "EfiIp6ServiceBindingProtocolGuid",
    "EC87D643-EBA4-4BB5-A1E5-3F3E36B20DA9": "EfiSetupVariableGuid",
    "EC8A3D69-6DDF-4108-9476-7337FC522136": "EfiKmsFormatGeneric128Guid",
    "ECA2AE9E-7594-4901-871C-449DA1A11660": "I2cDxe",
    "ECEBCB00-D9C8-11E4-AF3D-8CDCD426C973": "HttpBootDxe",
    "ED150714-DF30-407D-B24A-4B742FD5CEA2": "DuetConsoleOutConfigGuid",
    "ED2DE537-7823-4CB1-B687-85BA9BBEF0B4": "RaidRom",
    "ED32D533-99E6-4209-9CC0-2D72CDD998A7": "EfiSmmVariableProtocolGuid",
    "ED443008-3F06-46DB-927E-7AB2F02AF9D9": "ApplePciCameraDxe",
    "ED52984E-6ED7-4445-9D5D-200C3201F51E": "PlatformStage0Pei",
    "ED6E0531-F715-4A3D-9B12-C1CA5EF698A2": "IntelFsp2PkgTokenSpaceGuid",
    "ED888C65-2D84-4595-9086-A15A1F66DE2B": "EnableLsiDecoding",
    "ED8B5E2B-6622-4D14-9069-9BDEC54C9491": "TcgPwdTseHook",
    "ED8DCDD5-D037-4B1F-98DD-BDFDAD4DD7DD": "BatteryState4",
    "EDA39402-F375-4496-92D3-83B43CB8A76A": "SmBiosMemory",
    "EDADEB9D-DDBA-48BD-9D22-C1C169C8C5C6": "CpuMpPei",
    "EDBEDF47-6EA3-4512-83C1-70F4769D4BDE": "Capsule_A.fvi",
    "EDD35E31-07B9-11D2-83A3-00A0C91FADCF": "BootObjectAuthorizationParmsetGuid",
    "EDF8DA40-AAD1-11DF-A1F4-0002A5D5C51B": "PL341Dmc",
    "EE0BFF80-2B33-4005-8EF1-3F9B23C25136": "GetCpuInfoDxe",
    "EE0EA811-FBD9-4777-B95A-BA4F71101F74": "PeiHeciPpiGuid",
    "EE16160A-E8BE-47A6-820A-C6900DB0250A": "EfiPeiMpServicesPpiGuid",
    "EE1BB93E-54C5-4B17-9496-A20085950561": "SmmUsbDispatch2OnSmmUsbDispatchThunk",
    "EE4E5898-3914-4259-9D6E-DC7BD79403CF": "LzmaCustomDecompressGuid",
    "EE685731-CFF3-4EE7-9388-7E63FC5A59B0": "PlatformEarlyInit",
    "EE8367C0-A1D6-4565-8F89-EF628547B722": "IpSecDxe",
    "EE89F590-A816-4AC5-B3A9-1BC759B12439": "VerifyFwBootGuard",
    "EE90D8FC-6181-4B15-83C4-7D1CA0C36E2A": "DramTweakerDxe",
    "EE993080-5197-4D4E-B63C-F1F7413E33CE": "CpuDxe",
    "EE9B8D90-C5A6-40A2-BDE2-52558D33CCA1": "EfiSmmUsbDispatch2ProtocolGuid",
    "EEC25BDC-67F2-4D95-B1D5-F81B2039D11D": "BootManagerMenuApp",
    "EED5EA31-38E2-463D-B623-2C57702B8A1C": "SectionExtractionPei",
    "EEEE611D-F78F-4FB9-B868-55907F169280": "PlatformInitPreMem",
    "EEF749C2-C047-4D6E-B1BC-D36EB3A5559C": "QuarkVariableLockGuid",
    "EF0C99B6-B1D3-4025-9405-BF6A560FE0E0": "SmbiosMiscDxe",
    "EF0E795C-749A-4B41-B994-7DDC6B594388": "UsbOcUpdateDxeNeonCityEPRP",
    "EF14FD78-0793-4E2B-AC6D-062847E01791": "MfgModeVariableGuid",
    "EF17CEE7-267D-4BFD-A257-4A6AB3EE8591": "MemorySubClassDxe",
    "EF22F8A9-267E-4840-BC32-F0CFDFDFA426": "PeiSmmControlPei",
    "EF251B71-CEED-484E-82E3-3A1F34F512E2": "EfiQuarkSCSocIdTokenSpaceGuid",
    "EF33C296-F64C-4146-AD04-347899702C84": "SmmUsbLegacyDxe",
    "EF3468E0-1B0A-46D7-842C-928E67EFE0B8": "X11DPHPeiDriver",
    "EF398D58-9DFD-4103-BF94-78C6F4FE712F": "EfiPeiResetPpiGuid",
    "EF598499-B25E-473A-BFAF-E7E57DCE82C4": "TpmErrorHobGuid",
    "EF6619EE-F77D-4A8C-8693-D60D6AA56702": "SetupSecurity",
    "EF7BF7D6-F8FF-4A76-8247-C0D0D1CC49C0": "EfiSmbiosSlotPopulationGuid",
    "EF9AEFE5-2BD3-4031-AF7D-5EFE5ABB9A0D": "PeiLockPhysicalPresencePpiGuid",
    "EF9FC172-A1B2-4693-B327-6D32FC416042": "EfiHiiDatabaseProtocolGuid",
    "EFA96432-DE33-4DD2-AEE6-328C33DF777A": "EfiHashAlgorithmSha384Guid",
    "EFB7F614-BC8B-4DDD-B09A-22079FC1512F": "TbtDxe",
    "EFCB2FDB-0662-4A59-A5D7-03033EA97CAE": "GTSE",
    "EFD652CC-0E99-40F0-96C0-E08C089070FC": "S3Restore",
    "EFEFD093-0D9B-46EB-A856-48350700C908": "EfiHiiImageDecoderNameJpegGuid",
    "EFFC8F05-B526-4EB5-B36B-8CD889923C0C": "LegacyRegion",
    "F0384FFD-8633-452F-9010-F6B7D2EAE2F1": "WinNtFirmwareVolumePei",
    "F05976EF-83F1-4F3D-8619-F7595D41E538": "EfiPrint2ProtocolGuid",
    "F099D67F-71AE-4C36-B2A3-DCEB0EB2B7D8": "WatchDogTimerDxe",
    "F0A30BC7-AF08-4556-99C4-001009C93A44": "EfiSecureBootEnableDisableGuid",
    "F0ADC5A7-F86A-45A5-9D16-37323FCD77EE": "SmcPostMsgHotKey_SMM",
    "F0B79D0F-CE2B-D148-9ACE-F204E9393CAA": "Tcp4",
    "F0BBFCA0-684E-48B3-BAE2-6C84B89E5339": "EfiPchExtendedResetProtocolGuid",
    "F0D7222F-FD43-4A5D-B8BF-A259C87AE3B2": "FlashDeviceLibDxe",
    "F0E6A44F-7195-41C3-AC64-54F202CD0A21": "SecureBootConfigDxe",
    "F0F6F006-DAB4-44B2-A7A1-0F72EEDCA716": "AcpiPlatform",
    "F103A5A5-9345-4C3F-B496-DA14F41B6269": "PlatformStage1",
    "F10CF621-1502-4130-A860-D300459E2C08": "MEbxInvokeDxe",
    "F1143A53-CBEB-4833-A4DC-0826E063EC08": "MeRegionUpdateVolume",
    "F122A15C-C10B-4D54-8F48-60F4F06DD1AD": "LegacyBiosDxe",
    "F12DF3A4-6A2E-44BD-A3F9-2135A04E19E2": "AsusEcPeiBiosReady",
    "F15B92A8-6B4C-4EA3-A380-2F352AD15417": "RealTekLanDriver",
    "F16BDBF0-3A61-11DE-8A39-0800200C9A66": "PerfTuneDxe",
    "F18BA2F3-053D-408D-9E28-96CDA65272A8": "FfsIntegrityCheckPei",
    "F19B5EA5-7CDF-4CB2-9C37-F1BE08AC588B": "BroadcomGigabitEthernetDxe",
    "F19E8ED6-442B-4194-AF8E-C91435E36320": "SmcTpmProvisionDxe",
    "F1A25221-A98B-4189-85F2-0BA226A370DA": "FTP_DXE",
    "F1EFB523-3D59-4888-BB71-EAA5A96628FA": "SecurityStubDxe",
    "F1FCD66F-8966-441E-909C-77F211AB9C3E": "MERecoveryDxe",
    "F2074EA5-B8C9-4EBC-881E-30102260703E": "ACPI_FACS_MODIFY",
    "F21173FE-DF86-4B8B-AFF9-C7CB77B9C7DD": "PeiIchInit",
    "F22FC20C-8CF4-45EB-8E06-AD4E50B95DD3": "EfiHiiDriverHealthFormsetGuid",
    "F24643C2-C622-494E-8A0D-4632579C2D5B": "EfiTrEEPhysicalPresenceGuid",
    "F2765DEC-6B41-11D5-8E71-00902707B35E": "Timer",
    "F282DD45-CA7B-40EC-9618-99381C08F409": "OpaPlatCfg",
    "F2BA331A-8985-11DB-A406-0040D02B1835": "EmuVirtualDisksGuid",
    "F2BDCC96-8985-11DB-8719-0040D02B1835": "EmuPhysicalDisksGuid",
    "F2C1819D-10F5-4223-9236-9B4EBF1B9AE7": "Logo1394",
    "F2C1910E-F5C9-4B72-B243-6D59096A79F0": "EfiI2cSlaveProtocolGuid",
    "F2FBD108-8985-11DB-B06A-0040D02B1835": "MiscSubclass",
    "F2FD1544-9794-4A2C-992E-E5BBCF20E394": "EfiSmbios3TableGuid",
    "F303AF22-6804-494B-A28A-A03BE7D5C742": "CsmRt32Asm",
    "F30C2915-5782-4E6A-A846-05BABCE7B6A0": "EfiI2cAcpiProtocolGuid",
    "F328E36C-23B6-4A95-854B-32E19534CD75": "SmmCommunicateHeaderGuid",
    "F33261E7-23CB-11D5-BD5C-0080C73C8881": "FrameworkEfiMpServiceProtocolGuid",
    "F3331DE6-4A55-44E4-B767-7453F7A1A021": "MicrocodeUpdate",
    "F342BE75-274C-433C-A24D-2816F5433D50": "VmwSmbios",
    "F3552032-8985-11DB-8429-0040D02B1835": "RealTimeClock",
    "F35F733F-5235-4D7B-83FA-97780CEBCB20": "Ping6",
    "F36FF770-A7E1-42CF-9ED2-56F0F271F44C": "EfiManagedNetworkServiceBindingProtocolGuid",
    "F3749E2C-5139-4E7A-B53A-4F5080B68B8F": "PciSerialDxe",
    "F3794B60-8985-11DB-8E53-0040D02B1835": "Cpu",
    "F38C34DE-9C38-438C-9AF6-69F584F17EC0": "PoofAnimationState4",
    "F3C9667B-C50C-4E9C-A1F1-78C3B1DDF2C2": "LibNetUtil",
    "F3D301BB-F4A5-45A8-B0B7-FA999C6237AE": "ShellNetwork1HiiGuid",
    "F3E4543D-CF35-6CEF-35C4-4FE6344DFC54": "EfiFormCallbackProtocolGuid",
    "F3FF1468-04BA-4966-9FB2-E4A790054650": "EfiCapsuleCrashLogVarGuid",
    "F44875AB-B9FC-4578-A280-AA335B49967C": "CmosSmm",
    "F44C00EE-1F2C-4A00-AA09-1C9F3E0800A3": "EfiArpServiceBindingProtocolGuid",
    "F46998C9-DD30-4C64-966C-E17777B2568A": "AppleSmc",
    "F4731D79-537E-4505-BD52-C03F9B1F6B89": "BaseTimerLibNullTemplate",
    "F479E147-A125-11D4-BCFC-0080C73C8881": "WinNtBlockIoDxe",
    "F495F038-71E6-49DB-9A80-B2E98F7BA718": "PeiDbgModuleLocator",
    "F4B427BB-BA21-4F16-BC4E-43E416AB619C": "EfiArpProtocolGuid",
    "F4CCBFB7-F6E0-47FD-9DD4-10A8F150C191": "EfiSmmBase2ProtocolGuid",
    "F4EA205B-7345-452C-9D62-53BA6F3B8910": "FmpAuthenticationLibPkcs7",
    "F4EF9D7A-98C5-4C1A-B4D9-D8D87265BE0C": "PeiSdhcPpiGuid",
    "F5042177-1D29-45C5-BA4D-4D0EB2E88575": "IT8728SioAcBack",
    "F5089266-1AA0-4953-97D8-562F8A73B519": "EfiUsbHcProtocolGuid",
    "F541796D-A62E-4954-A775-9584F61B9CDD": "EfiTcgProtocolGuid",
    "F5513824-BA68-0145-AED9-E0A89FAB40B9": "DpcDxe",
    "F5699255-115A-4F7D-BB0C-658E9A1F42C6": "PspfTpmLibNull",
    "F57D1C2E-3879-11DF-9118-931B1E0F29B0": "VmwLogRuntimeDxe",
    "F5883FC5-F8EE-4E44-B386-6021FB320C9B": "PchReset2",
    "F5AC7057-5650-466E-B692-76A47223EFB0": "AcpiSmmPlatform",
    "F5D14DB5-2F0C-4611-9DDC-7C182B173A71": "ProgressBarEmptyRightEndcap",
    "F5E655D9-02A6-46F2-9E76-B8BE8E60AB22": "EfiIfrRefreshIdOpGuid",
    "F5EF05E4-D538-4774-8F1B-E9773011E038": "FspInitDonePpiGuid",
    "F5F219D3-7006-4648-AC8D-D61DFB7BC6AD": "FontPackageListGuid",
    "F617B358-12CF-414A-A069-60677BDA13B3": "DxeIchPlatformPolicyProtocolGuid",
    "F617B358-12CF-414A-A069-60677BDA13B4": "UsbPolicyGuid",
    "F65354B9-1FF0-46D7-A5F7-0926CB238048": "MonoStatusCodePei",
    "F65ABA32-76FD-49C6-A1C4-CD7FADF96659": "AmiReportFvLibCompatibility",
    "F66447D4-75A6-463E-A819-077F2DDA05E9": "EfiKmsFormatRsasha12048Guid",
    "F6697AC4-A776-4EE1-B643-1FEFF2B615BB": "IncompatiblePciDeviceSupportDxe",
    "F672AE85-3769-4FB8-A5A0-70B38FB0A7C4": "DxeTimerLibEsal",
    "F6937495-1F44-4A8A-8A1B-5A669F9396F6": "DevConsole",
    "F6994CBA-2351-4EBC-A2DA-20BAC2FE2CF3": "SmmPciLibPciRootBridgeIo",
    "F6A59595-BB9F-415B-A7F3-DC7C09387BE6": "SmBusMemoryDown",
    "F6BEC3FE-88FB-11E3-AE84-E73B77561C35": "FastbootTransportUsbDxe",
    "F6D35FBB-63EA-4B25-81A5-5E62B4886292": "PlatformSetup",
    "F6EE6DBB-D67F-4EA0-8B96-6A71B19D84AD": "EdkiiStatusCodeDataTypeVariableGuid",
    "F74D20EE-37E7-48FC-97F7-9B1047749C69": "LogoDxe",
    "F75BD2CD-F473-4BA1-89B3-1E69EFC8BA70": "ASUS_HW_FastBootDXE",
    "F76E0A70-B5ED-4C38-AC9A-E5F54BF16E34": "DriverHealthFormSetGuid",
    "F7731B4C-58A2-4DF4-8980-5645D39ECE58": "PowerMgmtDxe",
    "F7763316-8C04-41D8-A87D-45B73C13C43C": "BltLibSample",
    "F77CB08E-6682-4DF7-82A3-BBBB52704C1F": "AppleNetLoadFileDxe",
    "F78153D0-870D-4EEE-A684-741499C9A8CE": "EistDxe",
    "F78285FD-121E-49F4-9716-44E307656586": "Python2710",
    "F7A1F48E-0F6A-4F12-A74D-ED6F5B6B00F2": "OpromUpdateDxeLightningRidgeEXECB4",
    "F7AD60F8-EFA8-44A3-9113-231F399EB4C7": "EfiKmsFormatMdc2128Guid",
    "F7D22BCA-1BCA-5591-CC8B-1CA98F2890FE": "AmiCpuS3Pei",
    "F7D6D25E-6243-4D5C-9BA5-C2DC48F003B0": "AmiFlashLibPei",
    "F7D9FD14-9335-4389-80C5-334D6ABFCCED": "ArmVirtPrePiUniCoreRelocatable",
    "F7FDE4A6-294C-493C-B50F-9734553BB757": "CapsuleX64",
    "F80697E9-7FD6-4665-8646-88E33EF71DFC": "SecurityStubDxe",
    "F821665C-0137-4F34-A7A1-57A0BD256D62": "IntelPchLegacyInterrupt",
    "F84CFFF4-511E-41C8-B829-519F5152F444": "LegacyBiosPlatformDxe",
    "F84D8725-5ADF-48D2-8819-1B0331AEB719": "DRYPEI",
    "F8626165-6CEB-924A-BAFC-F13AB9D65728": "EmuSystemConfigGuid",
    "F866226A-EAA5-4F5A-A90A-6CFBA57C588E": "SmmPerformanceProtocolGuid",
    "F866AD0F-1FBB-4D52-813D-7EB95E2F19D4": "menu_mid_right",
    "F88BB993-9230-4CDF-916A-7A2D3BDEE690": "AppleStartupManagerPolicyDxe",
    "F894643D-C449-42D1-8EA8-85BDD8C65BDE": "EfiPeiMemoryDiscoveredPpiGuid",
    "F8BFF014-18FB-4EF9-B10C-AE22738DBEED": "DxePlatformSeCPolicyGuid",
    "F8C6FEDE-EE15-47ED-99A4-60798A3C7DC4": "StaticSkuDataDxeLightningRidgeEXECB3",
    "F8E21975-0899-4F58-A4BE-5525A9C6D77A": "EfiHobMemoryAllocModuleGuid",
    "F8E5058C-CCB6-4714-B220-3F7E3A640BD1": "EfiUserCredentialClassPasswordGuid",
    "F9229745-981C-4E07-9FC6-789545CB8818": "AcpiSupportDxe",
    "F9383ECA-8566-491E-8533-ED7D2EFEA80D": "SmcNVDIMMPeiDriver",
    "F95A7CCC-4C55-4426-A7B4-DC8961950BAE": "ShellLevel2HiiGuid",
    "F9D88642-0737-49BC-81B5-6889CD57D9EA": "SmbiosDxe",
    "F9F1020C-CC31-4203-8850-EEC07A52A5B5": "SecPchLibFsp",
    "FA177FF7-1FC7-458D-A358-D9D62AE61CEC": "PeimEntryPoint",
    "FA20568B-548B-4B2B-81EF-1BA08D4A3CEC": "BootScriptExecutorDxe",
    "FA3AD693-D58A-4619-960B-8EE85C914870": "PeiPciLibPciCfg2",
    "FA4585F1-303B-4725-80E4-BB42BBD0249C": "SupportURL",
    "FA528024-59A6-4689-BEA0-B555D87D7DBE": "FpgaFvDataLibDxe",
    "FA920010-6785-4941-B6EC-498C579F160A": "VirtioDeviceProtocolGuid",
    "FAB5D4F4-83C0-4AAF-8480-442D11DF6CEA": "VirtioScsiDxe",
    "FAB7E9E1-39DD-4F2B-8408-E20E906CB6DE": "HdBootDevicePathVariablGuid",
    "FABDD96B-2DDD-4747-9612-F9E777C84A38": "SetupUtility",
    "FAC2EFAD-8511-4E34-9CAE-16A257BA9488": "Capsule",
    "FACFB110-7BFD-4EFB-873E-88B6B23B97EA": "PhDefEfiVar",
    "FAD7933A-6C21-4234-A434-0A8A0D2B0781": "EfiIsaHcServiceBindingProtocolGuid",
    "FAE06C19-0F1C-47D3-832D-E3B9C25AD020": "aDefaultPEI",
    "FAF79E9F-4D40-4F02-8AC9-4B5512708F7F": "BiosGuardCpuPolicyOverride",
    "FB045DB2-598E-485A-BA30-5D7B1B1BD54D": "AOAC",
    "FB142B99-DF57-46CB-BC69-0BF858A734F9": "SerialOverLan",
    "FB15CB3F-D373-45A1-B9B1-0079D4E9D6B2": "menu_seperator",
    "FB3D20EE-CB5D-45EE-BBAE-C5AAA9C0FDFA": "ChipsetSvcPeiBB",
    "FB547927-DAEC-4884-A12E-94109FEDF18C": "gear3",
    "FB62F7F0-5433-11E4-B810-402CF41D8A90": "SecureEraseDxe",
    "FB6D36A2-EF7D-4B74-99AC-80B31F6BE9B1": "WheaErrorInj",
    "FB6D9542-612D-4F45-872F-5CFF52E93DCF": "EfiPeiRecoveryModulePpiGuid",
    "FB74A690-DE1A-4BF4-97C0-170B3535FC98": "PciThunderbolt",
    "FB76E42B-EA77-48F3-A61D-208FF0535F92": "TrEEPpVendorLibNull",
    "FB85101D-F422-4C8C-82C4-EF4DCD05E1BF": "SmcSmBios",
    "FB925AC7-192A-9567-8586-7C6F5F710607": "Cryptest",
    "FBA34BC8-4E37-451D-A7FF-5469F52064C6": "UUDriver",
    "FBB4A01B-947E-4D82-B27D-1E207C070053": "BaseCacheAsRamLibNull",
    "FBF95065-427F-47B3-8077-D13C60710998": "dbVar",
    "FC06B535-5E1F-4562-9F25-0A3B9ADB63C3": "EfiIa32X64ErrorTypeTlbCheckGuid",
    "FC120ED3-40E1-46DC-8C9C-AAE3CA139ACF": "BasePerformanceLibNull",
    "FC1B7640-3466-4C06-B1CC-1C935394B5C2": "PchSerialGpio",
    "FC1BCDB0-7D31-49AA-936A-A4600D9DD083": "EfiCrc32GuidedSectionExtractionGuid",
    "FC1D4706-88FB-42B0-98B0-A4B2E607EBAA": "LibErr",
    "FC4285A7-EBB5-45D2-8541-EBA3318FC2C2": "UsbOcUpdateDxeLightningRidgeEXECB1",
    "FC510EE7-FFDC-11D4-BD41-0080C73C8881": "AprioriDxe",
    "FC5C7020-1A48-4198-9BE2-EAD5ABC8CF2F": "BdsDxe",
    "FC63ED62-949D-4FB0-B754-D558A6367C56": "EzFlashDxe",
    "FC740D58-59BA-429B-99EF-627051737B76": "ImageDecoder",
    "FC788727-C2D0-469C-BD03-5AEA03323C67": "GlobeMask",
    "FC90EB7A-3E0A-483C-A26C-484D36593FF4": "AcpiPlatform",
    "FCABE6A7-7953-4A84-B7EC-D29E89B62E87": "EmbeddedMonotonicCounter",
    "FCCCE259-07E1-417A-A755-E0F2CF39295E": "CpuInitDxe",
    "FCD337AB-B1D3-4EF8-957C-8048606FF670": "HiiDatabaseDxe",
    "FCD6562A-253A-40D7-87DE-28CFF25898C6": "InsideHT",
    "FCF94301-9763-4A64-AA84-7892C4712367": "IpSecDxe",
    "FD023012-19F4-4235-ADCF-D924DBE246FE": "StaticSkuDataDxeLightningRidgeEXECB1",
    "FD0C65EB-0405-4CD2-8AEE-F400EF13BAC2": "NtPeiLoadFilePpiGuid",
    "FD0F4478-0EFD-461D-BA2D-E58C45FD5F5E": "EfiGetPcdInfoProtocolGuid",
    "FD2340D0-3DAB-4349-A6C7-3B4F12B48EAE": "EfiTlsCaCertificateGuid",
    "FD236AE7-0791-48C4-B29E-29BDEEE1A811": "SaInitPeim",
    "FD236AE7-0791-48C4-B29E-29BDEEE1A838": "PchInitPeim",
    "FD27652D-F758-4EFC-B1A9-283EFE51F4E9": "MeFwCapsulePei",
    "FD301BA4-5E62-4679-A06F-E09AABDD2A91": "EfiTdtOperationProtocolGuid",
    "FD36FEE3-7B33-4C9E-836E-9AA26A9E3149": "BiosAcm_Dale",
    "FD3B7E55-FA7B-4E07-AE1D-208B81FB0BAD": "FvbRuntimeDxe",
    "FD3F690E-B4B0-4D68-89DB-19A1A3318F90": "MICROCODE",
    "FD44820B-F1AB-41C0-AE4E-0C55556EB9BD": "SMBiosFlashData",
    "FD5FBE54-8C35-B345-8A0F-7AC8A5FD0521": "EmuSnpProtocolGuid",
    "FD76FF8E-665F-4AFC-AF75-724EF5A569E5": "UcOnUc2Thunk",
    "FD93F9E1-3C73-46E0-B7B8-2BBA3F718F6C": "TCGSmm",
    "FDC50ED1-ACB8-8048-8735-8098B7A13E5E": "ApplePowerState",
    "FDFF263D-5F68-4591-87BA-B768F445A9AF": "Tcg2Dxe",
    "FE3542FE-C1D3-4EF8-657C-8048606FF670": "DriverSampleDxe",
    "FE3542FE-C1D3-4EF8-657C-8048606FF671": "DriverSample",
    "FE5CEA76-4F72-49E8-986F-2CD899DFFE5D": "FaultTolerantWriteDxe",
    "FE612B72-203C-47B1-8560-A66D946EB371": "setupdata",
    "FE61BB5F-1B67-4C24-B346-73DB42E873E5": "ArmHwDxe",
    "FE6F8ACD-55A6-4C6B-B448-64E659DE94B3": "LegacyRegion2",
    "FEAA2E2B-53AC-4D5E-AE10-1EFD5DA4A2BA": "BeagleBoardPciEmulation",
    "FED6583D-2418-4760-AC96-B5E18F0A6326": "SmmCorePlatformHookLibNull",
    "FEDD6305-E2D7-4ED5-9FAA-DA080E336C22": "PeiUsb2HostControllerPpiGuid",
    "FEDE0A1B-BCA2-4A9F-BB2B-D9FD7DEC2E9F": "StatusCodeRuntimeDxe",
    "FEDF8E0C-E147-11E3-9903-B8E8562CBAFA": "EfiBootManagerPolicyProtocolGuid",
    "FF0C8745-3270-4439-B74F-3E45F8C77064": "IntelGopDriver",
    "FF11E702-8923-47CC-AD30-D9E0E240DD10": "AAFTblDXE",
    "FF259F16-18D1-4298-8DD2-BD87FF2894A9": "PchResetPeim",
    "FF3E5307-9FD0-48C9-85F1-8AD56C701E01": "EfiCertSha384Guid",
    "FF456B9C-0DC7-4682-9E92-0DE84B6E4067": "PeiSmmControl",
    "FF478412-38C3-4770-85F6-5D076C62125F": "TargetDiskModeUI",
    "FF917E22-A228-448D-BDAA-68EFCCDDA5D3": "TxtDxe",
    "FFE06BDD-6107-46A6-7BB2-5A9C7EC5275C": "EfiAcpiTableProtocolGuid",
    "FFF12B8D-7696-4C8B-A985-2747075B4F50": "EfiSystemNvDataFvGuid",
}
