# GUIDs from https://github.com/theopolis/uefi-firmware-parser/blob/master/uefi_firmware/guids/efiguids_lenovo.py

# pylint: disable=duplicate-key
lenovo_guids = {
    "LENOVO_SYSTEM_USB_SWITCH_DXE_GUID": [
        1293931,
        8600,
        17393,
        147,
        186,
        42,
        126,
        215,
        177,
        225,
        204,
    ],
    "LENOVO_SYSTEM_SCSI_BUS_DXE_GUID": [
        23579844,
        53495,
        20257,
        163,
        239,
        158,
        100,
        183,
        205,
        206,
        139,
    ],
    "LENOVO_SYSTEM_AHCI_BUS_DXE_GUID": [
        23579844,
        53495,
        20257,
        163,
        239,
        158,
        100,
        183,
        205,
        206,
        140,
    ],
    "LENOVO_MNP_DXE_BIN_GUID": [
        39567303,
        59049,
        19339,
        130,
        173,
        104,
        21,
        161,
        174,
        175,
        74,
    ],
    "LENOVO_ISSC_SMM_GUID": [
        62871161,
        22345,
        19397,
        165,
        63,
        71,
        71,
        29,
        167,
        103,
        200,
    ],
    "LENOVO_EC_IO_SMM_GUID": [
        65788747,
        38586,
        20288,
        131,
        41,
        127,
        58,
        168,
        134,
        87,
        7,
    ],
    "LENOVO_EN25_QH32_FLASH_PART_DXE_GUID": [
        85592951,
        49254,
        17936,
        153,
        4,
        191,
        37,
        194,
        150,
        214,
        230,
    ],
    "LENOVO_MTM_FORMAT_SMM_GUID": [
        104351088,
        5760,
        17952,
        157,
        0,
        106,
        217,
        227,
        204,
        177,
        159,
    ],
    "LENOVO_DXE_RICOH_INIT_GUID": [
        110529390,
        63008,
        20109,
        166,
        166,
        82,
        85,
        35,
        84,
        221,
        117,
    ],
    "LENOVO_SECURITY_VARIABLE_DXE_GUID": [
        115245642,
        42210,
        17045,
        163,
        246,
        3,
        179,
        254,
        245,
        177,
        9,
    ],
    "LENOVO_IBEX_PEAK_FLASH_CONTROLLER_DXE_GUID": [
        119797899,
        33039,
        20036,
        146,
        160,
        165,
        200,
        59,
        67,
        54,
        152,
    ],
    "LENOVO_BOARD_INFO_SMM_GUID": [
        124839840,
        39994,
        18844,
        163,
        17,
        47,
        131,
        133,
        8,
        5,
        86,
    ],
    "LENOVO_SYSTEM_METRONOME_DXE_GUID": [
        128529162,
        62279,
        4564,
        154,
        73,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_SLP2_DXE_GUID": [
        142514016,
        8117,
        18935,
        135,
        154,
        133,
        61,
        43,
        33,
        76,
        199,
    ],
    "LENOVO_CRYPT_SERVICE_SMM_GUID": [
        150721327,
        34431,
        17707,
        177,
        52,
        112,
        81,
        97,
        247,
        51,
        51,
    ],
    "LENOVO_SYSTEM_SCSI_DISK_DXE_GUID": [
        174514978,
        14144,
        19662,
        173,
        98,
        189,
        23,
        44,
        236,
        202,
        53,
    ],
    "LENOVO_SYSTEM_USB_SWITCH_SMM_GUID": [
        191532512,
        25217,
        16546,
        142,
        154,
        9,
        241,
        161,
        138,
        109,
        64,
    ],
    "LENOVO_EC_FW_UPDATE_DXE_GUID": [
        205090762,
        27610,
        18965,
        182,
        163,
        166,
        250,
        69,
        68,
        189,
        183,
    ],
    "LENOVO_SETUP_UNDER_OS_DXE_GUID": [
        224691302,
        14013,
        17094,
        178,
        135,
        124,
        59,
        170,
        37,
        117,
        192,
    ],
    "LENOVO_BDS_CTRL_GUID": [
        266426805,
        1903,
        19510,
        191,
        38,
        215,
        36,
        242,
        131,
        18,
        82,
    ],
    "LENOVO_SYSTEM_FIRMWARE_DEVICE_DXE_GUID": [
        269784614,
        21891,
        17252,
        130,
        47,
        164,
        89,
        184,
        18,
        19,
        2,
    ],
    "LENOVO_EC_IO_DXE_GUID": [
        290235916,
        55653,
        19475,
        190,
        247,
        196,
        6,
        34,
        72,
        225,
        250,
    ],
    "LENOVO_SYSTEM_SMM_AHCI_ASPI_LEGACY_RT_GUID": [
        306851450,
        6473,
        18494,
        137,
        159,
        96,
        50,
        144,
        76,
        160,
        167,
    ],
    "LENOVO_BOOT_MENU_DXE_GUID": [
        308966957,
        22360,
        20426,
        133,
        49,
        32,
        26,
        127,
        87,
        248,
        80,
    ],
    "LENOVO_FP_PBA_GUID": [317155615, 7918, 20180, 135, 147, 105, 226, 128, 29, 96, 42],
    "LENOVO_SYSTEM_EBC_DXE_GUID": [
        330067408,
        29648,
        4564,
        176,
        107,
        0,
        170,
        0,
        189,
        109,
        231,
    ],
    "LENOVO_SYSTEM_SMM_SERVICES_SMM_GUID": [
        352631419,
        22776,
        19730,
        150,
        56,
        180,
        148,
        167,
        4,
        67,
        118,
    ],
    "LENOVO_EC_SERVICE_GUID": [
        365429572,
        63872,
        19445,
        170,
        160,
        191,
        190,
        2,
        122,
        239,
        22,
    ],
    "LENOVO_SECURE_FLASH_VERIFY_SMM_GUID": [
        366827126,
        9849,
        20004,
        156,
        170,
        133,
        178,
        45,
        216,
        147,
        235,
    ],
    "LENOVO_EN25_QH128_FLASH_PART_SMM_GUID": [
        386766184,
        51561,
        20385,
        165,
        51,
        219,
        103,
        121,
        191,
        190,
        98,
    ],
    "LENOVO_COMPUTRACE_SMI_SERVICES_GUID": [
        408391285,
        53363,
        16899,
        144,
        210,
        135,
        136,
        168,
        113,
        228,
        77,
    ],
    "LENOVO_SMM_VIDEO_INT10_GUID": [
        431419749,
        30805,
        17128,
        170,
        111,
        35,
        97,
        202,
        135,
        224,
        36,
    ],
    "LENOVO_TCP_DXE_BIN_GUID": [
        444482664,
        12117,
        19030,
        144,
        60,
        1,
        38,
        94,
        183,
        98,
        43,
    ],
    "LENOVO_SYSTEM_BOOT_SCRIPT_SAVE_DXE_GUID": [
        476786607,
        55485,
        17617,
        169,
        30,
        115,
        33,
        180,
        194,
        243,
        209,
    ],
    "LENOVO_EAIA_DXE_GUID": [488641077, 12096, 20412, 134, 80, 133, 2, 9, 45, 98, 171],
    "LENOVO_SYSTEM_PS2_MOUSE_DXE_GUID": [
        539634446,
        39473,
        18450,
        178,
        145,
        135,
        71,
        223,
        21,
        36,
        57,
    ],
    "LENOVO_SMART_CARD_DETECT_DXE_GUID": [
        582945669,
        20147,
        18331,
        169,
        233,
        165,
        247,
        207,
        204,
        167,
        135,
    ],
    "LENOVO_PLATFORM_FLASH_DXE_GUID": [
        590885754,
        18352,
        19521,
        156,
        167,
        1,
        96,
        251,
        148,
        223,
        244,
    ],
    "LENOVO_MX25_L3206_EFLASH_PART_SMM_GUID": [
        596469069,
        42669,
        16840,
        163,
        27,
        103,
        163,
        32,
        134,
        37,
        195,
    ],
    "LENOVO_TPM_ENABLER_DXE_GUID": [
        601439914,
        1827,
        17753,
        183,
        104,
        94,
        34,
        223,
        118,
        45,
        228,
    ],
    "LENOVO_SYSTEM_USB_SUPPORT_POLICY_SMM_GUID": [
        604377783,
        41059,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        76,
    ],
    "LENOVO_SYSTEM_USB_BUS_DXE_GUID": [
        604377783,
        41059,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_SYSTEM_USB_SUPPORT_POLICY_DXE_GUID": [
        604377783,
        41059,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        78,
    ],
    "LENOVO_SMM_OEMINT15_GUID": [
        607947914,
        48080,
        19113,
        190,
        23,
        207,
        155,
        88,
        49,
        48,
        236,
    ],
    "LENOVO_SYSTEM_STATUS_CODE_GENERIC_RT_GUID": [
        611294986,
        4579,
        17818,
        174,
        6,
        55,
        43,
        220,
        77,
        232,
        6,
    ],
    "LENOVO_CRYPT_SERVICE_GUID": [
        626323294,
        51658,
        19016,
        157,
        148,
        36,
        158,
        177,
        232,
        124,
        45,
    ],
    "LENOVO_TCG_SERVICES_DXE_GUID": [
        636784743,
        42587,
        18677,
        187,
        190,
        53,
        65,
        140,
        72,
        136,
        54,
    ],
    "LENOVO_FDISK_OEM_GUID": [
        652065439,
        23309,
        20096,
        134,
        178,
        128,
        218,
        228,
        208,
        27,
        14,
    ],
    "LENOVO_PCH_SPI_SMM_GUID": [
        670339451,
        42759,
        19117,
        150,
        118,
        38,
        223,
        22,
        140,
        191,
        13,
    ],
    "LENOVO_IVB_GOP_DRIVER_GUID": [
        682992732,
        52317,
        16929,
        157,
        255,
        134,
        176,
        244,
        45,
        220,
        1,
    ],
    "LENOVO_SYSTEM_STATUS_CODE_PORT80_RT_GUID": [
        698459927,
        14057,
        18912,
        179,
        129,
        234,
        59,
        95,
        247,
        9,
        66,
    ],
    "LENOVO_W25_Q64_FLASH_PART_DXE_GUID": [
        708977825,
        9737,
        16551,
        136,
        226,
        166,
        141,
        192,
        241,
        209,
        128,
    ],
    "LENOVO_SYSTEM_USB_MEMORY_MANAGER_SMM_GUID": [
        717954629,
        57252,
        20467,
        143,
        129,
        145,
        247,
        215,
        135,
        210,
        45,
    ],
    "LENOVO_SYSTEM_ACPI_S3_SAVE_DXE_GUID": [
        736024197,
        63283,
        17759,
        168,
        64,
        67,
        162,
        43,
        121,
        31,
        179,
    ],
    "LENOVO_SA_LATE_INIT_SMM_GUID": [
        756954652,
        31551,
        19733,
        139,
        31,
        102,
        229,
        81,
        250,
        189,
        199,
    ],
    "LENOVO_SYSTEM_USB_MOUSE_DXE_GUID": [
        758014634,
        40655,
        17335,
        130,
        25,
        148,
        231,
        252,
        113,
        61,
        254,
    ],
    "LENOVO_SYSTEM_USB_KB_DXE_GUID": [
        758014671,
        40655,
        17335,
        130,
        25,
        148,
        231,
        252,
        113,
        61,
        254,
    ],
    "LENOVO_PLATFORM_DXE_GUID": [
        762263487,
        39676,
        19109,
        160,
        38,
        50,
        178,
        252,
        243,
        15,
        185,
    ],
    "LENOVO_PCH_BIOS_WRITE_PROTECT_GUID": [
        786963147,
        25778,
        16814,
        134,
        53,
        112,
        48,
        209,
        108,
        74,
        168,
    ],
    "LENOVO_TP_ACPI_NVS_INIT_DXE_GUID": [
        807013315,
        47638,
        18937,
        133,
        139,
        222,
        224,
        95,
        145,
        231,
        184,
    ],
    "LENOVO_SNB_GOP_DRIVER_GUID": [
        823145156,
        39078,
        19974,
        140,
        3,
        216,
        21,
        253,
        31,
        231,
        9,
    ],
    "LENOVO_SYSTEM_USB_DATABASE_SMM_GUID": [
        828477649,
        24136,
        19477,
        172,
        114,
        55,
        83,
        47,
        58,
        30,
        193,
    ],
    "LENOVO_SYSTEM_FORM_BROWSER_CORE_DXE_GUID": [
        843328777,
        7441,
        20007,
        138,
        171,
        144,
        254,
        106,
        203,
        4,
        137,
    ],
    "LENOVO_BIOS_EXTENSION_LOADER_GUID": [
        851560952,
        54591,
        16840,
        148,
        208,
        246,
        115,
        159,
        35,
        16,
        17,
    ],
    "LENOVO_SYSTEM_HII_DATABASE_DXE_GUID": [
        881610082,
        49085,
        18562,
        158,
        206,
        200,
        11,
        177,
        196,
        120,
        59,
    ],
    "LENOVO_ATP_DXE_GUID": [
        886382265,
        30427,
        19631,
        148,
        174,
        147,
        72,
        86,
        232,
        149,
        246,
    ],
    "LENOVO_DXE_MAIN_GUID": [
        901290186,
        46761,
        18894,
        140,
        114,
        144,
        71,
        53,
        204,
        73,
        183,
    ],
    "LENOVO_SYSTEM_SPLASH_DXE_GUID": [
        923302804,
        61249,
        18807,
        147,
        226,
        63,
        106,
        223,
        221,
        6,
        225,
    ],
    "LENOVO_SYSTEM_IMAGE_DISPLAY_DXE_GUID": [
        924820664,
        32834,
        20182,
        173,
        167,
        169,
        135,
        189,
        44,
        223,
        10,
    ],
    "LENOVO_SYSTEM_RTC_RT_GUID": [
        932019045,
        36265,
        18291,
        182,
        228,
        164,
        120,
        38,
        168,
        51,
        225,
    ],
    "LENOVO_SYSTEM_IDE_ATA_ATAPI_PASS_THRU_DXE_GUID": [
        933285920,
        52433,
        4573,
        173,
        139,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_SETUP_MAIN_DXE_GUID": [
        934268757,
        11916,
        18210,
        185,
        80,
        180,
        139,
        145,
        101,
        197,
        107,
    ],
    "LENOVO_ME_PCI_UPDATE_GUID": [
        937281513,
        31773,
        19995,
        178,
        203,
        78,
        213,
        209,
        37,
        39,
        179,
    ],
    "LENOVO_PHX_GOP_DXE_GUID": [
        938270500,
        33875,
        18282,
        171,
        88,
        244,
        207,
        139,
        254,
        103,
        66,
    ],
    "LENOVO_MX25_L64_XFLASH_PART_DXE_GUID": [
        949109979,
        15726,
        20048,
        131,
        93,
        90,
        119,
        90,
        50,
        93,
        137,
    ],
    "LENOVO_AOAC_SMM_GUID": [
        975891559,
        30648,
        16558,
        146,
        129,
        3,
        81,
        156,
        158,
        127,
        8,
    ],
    "LENOVO_SYSTEM_HII_IMAGE_DISPLAY_DXE_GUID": [
        1007992985,
        12611,
        18159,
        175,
        24,
        222,
        74,
        210,
        195,
        167,
        153,
    ],
    "LENOVO_SYSTEM_PS2_KEYBOARD_DXE_GUID": [
        1036526454,
        25467,
        16550,
        168,
        252,
        165,
        101,
        65,
        127,
        44,
        56,
    ],
    "LENOVO_REBOOT_CP_GUID": [
        1039934815,
        40070,
        18620,
        151,
        45,
        229,
        34,
        83,
        55,
        104,
        219,
    ],
    "LENOVO_SYSTEM_CRYPT_SVC_RT_GUID": [
        1044688137,
        55435,
        19538,
        180,
        27,
        184,
        192,
        5,
        54,
        71,
        74,
    ],
    "LENOVO_PLATFORM_PCI_DXE_GUID": [
        1064784879,
        54127,
        17868,
        138,
        26,
        46,
        170,
        255,
        16,
        56,
        182,
    ],
    "LENOVO_FIT_DIAGNOSTICS_LOADER_GUID": [
        1065247067,
        3397,
        20352,
        136,
        220,
        38,
        178,
        52,
        149,
        133,
        96,
    ],
    "LENOVO_IBEX_PEAK_GLOBAL_SMI_CONTROL_GUID": [
        1069045413,
        51376,
        18272,
        180,
        154,
        46,
        221,
        79,
        163,
        91,
        250,
    ],
    "LENOVO_VPRO_IDER_ASF_BOOT_GUID": [
        1075081700,
        40569,
        18020,
        191,
        176,
        23,
        149,
        36,
        35,
        5,
        103,
    ],
    "LENOVO_SYSTEM_CON_SPLITTER_DXE_GUID": [
        1083104492,
        53101,
        18300,
        165,
        168,
        180,
        132,
        78,
        61,
        226,
        129,
    ],
    "LENOVO_I_FFS_SMM_GUID": [
        1125591121,
        53118,
        17221,
        159,
        224,
        215,
        1,
        43,
        177,
        123,
        136,
    ],
    "LENOVO_SYSTEM_PARTITION_DXE_GUID": [
        1136210482,
        44990,
        4564,
        189,
        15,
        0,
        128,
        199,
        60,
        136,
        129,
    ],
    "LENOVO_MAIL_BOX_DXE_GUID": [
        1136369323,
        32087,
        19951,
        176,
        162,
        163,
        169,
        249,
        198,
        234,
        227,
    ],
    "LENOVO_VARIABLE_INIT_SMM_GUID": [
        1154448672,
        57334,
        16905,
        154,
        31,
        246,
        205,
        95,
        92,
        232,
        139,
    ],
    "LENOVO_SYSTEM_AHCI_ATA_ATAPI_PASS_THRU_DXE_GUID": [
        1156724112,
        56456,
        4573,
        173,
        139,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_COMPUTRACE_LOADER_DXE_GUID": [
        1166658547,
        1017,
        18840,
        157,
        111,
        38,
        52,
        60,
        105,
        86,
        42,
    ],
    "LENOVO_SYSTEM_CMOS_SMM_GUID": [
        1188605149,
        10691,
        16403,
        129,
        232,
        55,
        164,
        37,
        171,
        79,
        153,
    ],
    "LENOVO_MISC_GA_IO_DXE_GUID": [
        1246898131,
        3055,
        19626,
        172,
        189,
        236,
        132,
        68,
        108,
        92,
        108,
    ],
    "LENOVO_AT24_RF08_EEPROM_SMM_GUID": [
        1265312161,
        62059,
        16463,
        134,
        148,
        219,
        28,
        99,
        161,
        217,
        42,
    ],
    "LENOVO_SECURITY_SMI_DISPATCH_GUID": [
        1283265896,
        53107,
        18038,
        160,
        121,
        22,
        247,
        249,
        96,
        12,
        204,
    ],
    "LENOVO_SYSTEM_PPIS_NEEDED_BY_DXE_CORE_GUID": [
        1295505986,
        14860,
        20186,
        185,
        235,
        188,
        14,
        29,
        180,
        113,
        59,
    ],
    "LENOVO_SYSTEM_ERROR_LOG_SMM_GUID": [
        1298314729,
        29128,
        16682,
        134,
        4,
        135,
        140,
        146,
        29,
        154,
        209,
    ],
    "LENOVO_VPRO_HII_DXE_GUID": [
        1322172828,
        28255,
        18453,
        131,
        66,
        181,
        95,
        44,
        197,
        223,
        193,
    ],
    "LENOVO_COMPUTRACE_ENABLER_DXE_GUID": [
        1325158874,
        9126,
        18320,
        162,
        146,
        73,
        133,
        199,
        245,
        205,
        239,
    ],
    "LENOVO_EN25_QH64_FLASH_PART_SMM_GUID": [
        1344002362,
        61865,
        20300,
        169,
        70,
        120,
        103,
        223,
        151,
        85,
        55,
    ],
    "LENOVO_PCH_EMULATE_KBC_GUID": [
        1359302880,
        48078,
        20159,
        187,
        160,
        148,
        110,
        61,
        24,
        231,
        5,
    ],
    "LENOVO_SYSTEM_SMBIOS_EVENT_LOG_DXE_GUID": [
        1360175786,
        57717,
        18302,
        164,
        228,
        208,
        183,
        230,
        137,
        186,
        159,
    ],
    "LENOVO_HPM_SMM_GUID": [
        1364927051,
        45145,
        17931,
        133,
        199,
        194,
        134,
        88,
        244,
        184,
        152,
    ],
    "LENOVO_SYSTEM_CRC32_SECTION_EXTRACT_DXE_GUID": [
        1372189708,
        21059,
        17523,
        178,
        101,
        179,
        200,
        255,
        175,
        249,
        250,
    ],
    "LENOVO_SYSTEM_CON_PLATFORM_DXE_GUID": [
        1372386201,
        20447,
        20053,
        164,
        91,
        225,
        35,
        248,
        77,
        69,
        106,
    ],
    "LENOVO_PLATFORM_S3_SAVE_DXE_GUID": [
        1372895948,
        59146,
        16694,
        148,
        38,
        84,
        105,
        115,
        237,
        147,
        140,
    ],
    "LENOVO_TDT_AM_GUID": [
        1376754776,
        40861,
        18630,
        160,
        160,
        217,
        254,
        109,
        143,
        222,
        119,
    ],
    "LENOVO_ARP_DXE_BIN_GUID": [
        1386037139,
        59625,
        20083,
        177,
        225,
        189,
        246,
        169,
        213,
        1,
        19,
    ],
    "LENOVO_HPM_DXE_GUID": [
        1402833581,
        50860,
        17004,
        182,
        31,
        34,
        142,
        109,
        21,
        1,
        182,
    ],
    "LENOVO_SYSTEM_DATA_HUB_DXE_GUID": [
        1404879183,
        49743,
        17228,
        178,
        148,
        142,
        210,
        212,
        204,
        24,
        96,
    ],
    "LENOVO_SYSTEM_FLASH_COMMUNICATION_DXE_GUID": [
        1416286869,
        3172,
        19686,
        160,
        111,
        251,
        156,
        208,
        75,
        65,
        205,
    ],
    "LENOVO_SYSTEM_FIRMWARE_DEVICE_SMM_GUID": [
        1422077119,
        41913,
        19662,
        156,
        67,
        224,
        89,
        227,
        34,
        85,
        223,
    ],
    "LENOVO_DRIVE_ERASE_DXE_GUID": [
        1426260946,
        61491,
        17512,
        133,
        122,
        68,
        44,
        16,
        225,
        153,
        233,
    ],
    "LENOVO_SMM_BASE_RUNTIME_GUID": [
        1431459674,
        32256,
        19809,
        163,
        164,
        247,
        84,
        115,
        81,
        180,
        158,
    ],
    "LENOVO_DRIVE_ERASE_SMM_GUID": [
        1442418698,
        49072,
        19248,
        131,
        238,
        127,
        67,
        127,
        175,
        174,
        51,
    ],
    "LENOVO_PRIOR_BOOT_GUID": [
        1475642899,
        12298,
        16641,
        167,
        109,
        79,
        115,
        197,
        51,
        181,
        184,
    ],
    "LENOVO_DISK_CONTROLLER_SMBIOS_GUID": [
        1514093521,
        47014,
        16459,
        160,
        247,
        40,
        94,
        27,
        137,
        139,
        0,
    ],
    "LENOVO_DXE_REALTEK_CRC_INIT_GUID": [
        1534379841,
        19039,
        19086,
        182,
        137,
        216,
        4,
        171,
        67,
        104,
        253,
    ],
    "LENOVO_PLATFORM_CSM_DXE_GUID": [
        1541268997,
        45319,
        16798,
        149,
        16,
        170,
        60,
        67,
        78,
        187,
        228,
    ],
    "LENOVO_SECURE_ERROR_MANAGER_DXE_GUID": [
        1541333558,
        3253,
        19846,
        166,
        8,
        238,
        123,
        12,
        95,
        41,
        86,
    ],
    "LENOVO_IP6_DXE_BIN_GUID": [
        1542305228,
        55344,
        20146,
        135,
        66,
        45,
        76,
        201,
        181,
        79,
        44,
    ],
    "LENOVO_SETUP_RESTART_DXE_GUID": [
        1567984635,
        45859,
        20332,
        144,
        23,
        163,
        35,
        140,
        230,
        81,
        99,
    ],
    "LENOVO_SYSTEM_IMAGE_DECODER_DXE_GUID": [
        1600508442,
        34919,
        17875,
        164,
        26,
        82,
        111,
        159,
        226,
        197,
        152,
    ],
    "LENOVO_SETUP_CONFIG_DXE_GUID": [
        1607003872,
        39922,
        18831,
        180,
        211,
        197,
        30,
        212,
        200,
        123,
        180,
    ],
    "LENOVO_SMBIOS_COMPATI_INFO_GUID": [
        1616789944,
        59683,
        18380,
        135,
        177,
        166,
        227,
        133,
        38,
        231,
        141,
    ],
    "LENOVO_SYSTEM_KBC_INIT_DXE_GUID": [
        1628708000,
        5188,
        19534,
        161,
        109,
        182,
        1,
        224,
        160,
        148,
        102,
    ],
    "LENOVO_REMOTE_CONFIG_UPDATE_DXE_GUID": [
        1646126790,
        3934,
        20195,
        161,
        2,
        11,
        222,
        118,
        154,
        10,
        212,
    ],
    "LENOVO_CPU_INIT_DXE_GUID": [
        1657893323,
        30925,
        17536,
        134,
        120,
        198,
        162,
        167,
        151,
        168,
        222,
    ],
    "LENOVO_CPU_INIT_PHNX_DXE_GUID": [
        1665371246,
        38684,
        20032,
        143,
        11,
        17,
        9,
        69,
        123,
        227,
        51,
    ],
    "LENOVO_SYSTEM_VARIABLE_SMM_GUID": [
        1696885307,
        13295,
        20350,
        182,
        87,
        164,
        166,
        51,
        241,
        48,
        176,
    ],
    "LENOVO_SETUP_UNDER_OS_SMM_GUID": [
        1705451568,
        45102,
        19443,
        132,
        36,
        186,
        95,
        47,
        197,
        109,
        231,
    ],
    "LENOVO_RN_RCONFIG_GUID": [
        1717387104,
        44350,
        19629,
        142,
        38,
        219,
        70,
        238,
        233,
        241,
        181,
    ],
    "LENOVO_VARIABLE_DXE_GUID": [
        1726926656,
        25362,
        18970,
        168,
        58,
        179,
        178,
        248,
        216,
        167,
        26,
    ],
    "LENOVO_MISC_GA_IO_SMM_GUID": [
        1739578975,
        61206,
        18360,
        186,
        25,
        194,
        27,
        57,
        7,
        219,
        241,
    ],
    "LENOVO_W25_Q32_FLASH_PART_DXE_GUID": [
        1757163669,
        34873,
        19095,
        143,
        234,
        190,
        224,
        110,
        202,
        123,
        187,
    ],
    "LENOVO_SYSTEM_IDE_BUS_DXE_GUID": [
        1778224711,
        41313,
        17744,
        176,
        26,
        85,
        148,
        206,
        178,
        178,
        178,
    ],
    "LENOVO_OEM_MILESTONE_GUID": [
        1784844030,
        13954,
        20444,
        163,
        30,
        198,
        53,
        189,
        241,
        140,
        200,
    ],
    "LENOVO_SETUP_SECURITY_DXE_GUID": [
        1786453126,
        22798,
        18343,
        151,
        26,
        196,
        155,
        64,
        141,
        94,
        215,
    ],
    "LENOVO_SECURE_KEY_DXE_GUID": [
        1787443551,
        19463,
        18897,
        185,
        76,
        34,
        237,
        80,
        212,
        37,
        248,
    ],
    "LENOVO_UDP4_DXE_BIN_GUID": [
        1835623339,
        36973,
        19045,
        167,
        202,
        189,
        64,
        229,
        214,
        175,
        43,
    ],
    "LENOVO_N25_Q064_FLASH_PART_SMM_GUID": [
        1848830710,
        13009,
        17376,
        182,
        225,
        220,
        246,
        218,
        129,
        223,
        118,
    ],
    "LENOVO_SMBIOS_VPRO_GUID": [
        1850878195,
        37694,
        18785,
        149,
        115,
        15,
        30,
        97,
        181,
        34,
        172,
    ],
    "LENOVO_W25_Q64_FLASH_PART_SMM_GUID": [
        1852721781,
        61204,
        18427,
        180,
        58,
        103,
        236,
        67,
        184,
        125,
        34,
    ],
    "LENOVO_SYSTEM_ISA_KBC_DXE_GUID": [
        1852769708,
        9035,
        18011,
        148,
        80,
        195,
        110,
        109,
        117,
        102,
        197,
    ],
    "LENOVO_PLATFORM_FLASH_SMM_GUID": [
        1886133772,
        17660,
        16402,
        155,
        113,
        61,
        191,
        236,
        118,
        47,
        53,
    ],
    "LENOVO_PI_SAVE_STATE_ACCESS_GUID": [
        1887124590,
        39334,
        19991,
        132,
        160,
        64,
        40,
        76,
        27,
        63,
        56,
    ],
    "LENOVO_SYSTEM_ACPI_SUPPORT_DXE_GUID": [
        1903824554,
        39704,
        17946,
        182,
        236,
        172,
        9,
        121,
        76,
        166,
        49,
    ],
    "LENOVO_SYSTEM_SETUP2_DXE_GUID": [
        1914473318,
        17004,
        20102,
        142,
        153,
        52,
        87,
        196,
        106,
        176,
        185,
    ],
    "LENOVO_SYSTEM_IDE_ATA_ATAPI_PASS_THRU_SMM_GUID": [
        1938925920,
        52433,
        4573,
        173,
        139,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_SYSTEM_BOOT_MANAGER_DXE_GUID": [
        1943712527,
        16284,
        16736,
        176,
        100,
        67,
        156,
        225,
        108,
        62,
        222,
    ],
    "LENOVO_BLOCK_POWER_BUTTON_DXE_GUID": [
        1956648660,
        20043,
        17845,
        174,
        151,
        78,
        110,
        51,
        214,
        81,
        37,
    ],
    "LENOVO_SYSTEM_ACPI_NUMA_DXE_GUID": [
        1972041895,
        10756,
        18743,
        153,
        224,
        131,
        125,
        31,
        151,
        199,
        111,
    ],
    "LENOVO_SYSTEM_ACPI_TABLE_LOADER_DXE_GUID": [
        2002878155,
        57897,
        20000,
        184,
        249,
        223,
        130,
        69,
        98,
        77,
        122,
    ],
    "LENOVO_DIGITAL_THERMAL_SENSOR_SMM_GUID": [
        2007367838,
        4462,
        17997,
        142,
        248,
        179,
        82,
        1,
        160,
        34,
        221,
    ],
    "LENOVO_SYSTEM_FIXED_BUS_NUMBERS_DXE_GUID": [
        2030029397,
        18537,
        17299,
        190,
        233,
        114,
        229,
        139,
        211,
        190,
        56,
    ],
    "LENOVO_SYSTEM_VARIABLE_DXE_GUID": [
        2034024096,
        55894,
        18418,
        130,
        100,
        36,
        49,
        12,
        183,
        81,
        150,
    ],
    "LENOVO_SYSTEM_SW_SMI_ALLOCATOR_RT_GUID": [
        2034634970,
        53486,
        18027,
        129,
        179,
        129,
        151,
        33,
        58,
        105,
        120,
    ],
    "LENOVO_SYSTEM8259_INTERRUPT_CONTROLLER_DXE_GUID": [
        2043298312,
        48033,
        19098,
        132,
        86,
        225,
        230,
        106,
        129,
        72,
        78,
    ],
    "LENOVO_WMA_POLICY_DXE_GUID": [
        2044784087,
        40221,
        20289,
        174,
        26,
        248,
        150,
        22,
        158,
        82,
        22,
    ],
    "LENOVO_LAN_UEFI_GUID": [
        2046361940,
        33780,
        18316,
        128,
        191,
        135,
        138,
        195,
        46,
        10,
        44,
    ],
    "LENOVO_POP_MANAGER_DXE_GUID": [
        2070879654,
        59983,
        18744,
        167,
        159,
        12,
        88,
        225,
        68,
        42,
        161,
    ],
    "LENOVO_SYSTEM_USB_MEMORY_MANAGER_DXE_GUID": [
        2078746034,
        62828,
        16839,
        159,
        3,
        30,
        123,
        86,
        182,
        89,
        113,
    ],
    "LENOVO_ATP_SMI_SERVICES_GUID": [
        2091593354,
        47001,
        17728,
        133,
        23,
        88,
        100,
        77,
        3,
        204,
        159,
    ],
    "LENOVO_MODULES_SMM_THUNK_SMM_GUID": [
        2121356880,
        4326,
        19323,
        137,
        106,
        77,
        197,
        252,
        116,
        43,
        197,
    ],
    "LENOVO_VPRO_PET_ALERT_GUID": [
        2124901688,
        50554,
        16685,
        175,
        29,
        213,
        139,
        238,
        43,
        133,
        177,
    ],
    "LENOVO_SMM_RELOC_DXE_GUID": [
        2146267886,
        368,
        18452,
        152,
        120,
        168,
        251,
        24,
        100,
        223,
        175,
    ],
    "LENOVO_IGD_CUSTOMIZE_GUID": [
        2167621142,
        34510,
        18882,
        182,
        249,
        24,
        4,
        230,
        28,
        115,
        246,
    ],
    "LENOVO_SETUP_DATE_TIME_DXE_GUID": [
        2182649437,
        8384,
        19926,
        129,
        160,
        132,
        92,
        82,
        39,
        7,
        67,
    ],
    "LENOVO_TRANSLATE_SERVICE_GUID": [
        2188103510,
        47812,
        17396,
        142,
        161,
        140,
        223,
        10,
        18,
        26,
        189,
    ],
    "LENOVO_ME_CONFIG_GUID": [
        2191033376,
        29799,
        17552,
        144,
        89,
        254,
        180,
        72,
        221,
        25,
        99,
    ],
    "LENOVO_SYSTEM_OEM_ACTIVATION_DXE_GUID": [
        2233099093,
        52752,
        20327,
        157,
        19,
        145,
        179,
        40,
        26,
        149,
        211,
    ],
    "LENOVO_SYSTEM_PCI_ISA_BUS_DXE_GUID": [
        2253066494,
        15710,
        18696,
        136,
        204,
        240,
        141,
        78,
        220,
        0,
        80,
    ],
    "LENOVO_LEGACY_BIOS_MISC_SMM_GUID": [
        2263362243,
        54959,
        18340,
        140,
        147,
        12,
        118,
        199,
        179,
        204,
        211,
    ],
    "LENOVO_INIT_ME_POLICY_GUID": [
        2279811321,
        37797,
        17269,
        186,
        105,
        147,
        167,
        167,
        122,
        93,
        155,
    ],
    "LENOVO_SETUP_AUTOMATION_SMM_GUID": [
        2282586559,
        55944,
        18913,
        149,
        67,
        165,
        130,
        71,
        254,
        173,
        26,
    ],
    "LENOVO_N25_Q064_FLASH_PART_DXE_GUID": [
        2288700192,
        30912,
        20360,
        157,
        60,
        186,
        220,
        227,
        126,
        218,
        71,
    ],
    "LENOVO_HDP_MANAGER_SMM_GUID": [
        2299999890,
        39618,
        19590,
        158,
        204,
        243,
        119,
        130,
        221,
        235,
        170,
    ],
    "LENOVO_SYSTEM_XHCI_RESET_SYSTEM_GUID": [
        2388413418,
        13567,
        20018,
        131,
        88,
        51,
        99,
        218,
        1,
        230,
        40,
    ],
    "LENOVO_NATIONAL_LPC_PC87393_GUID": [
        2392276867,
        43978,
        18916,
        169,
        64,
        78,
        173,
        90,
        109,
        138,
        30,
    ],
    "LENOVO_SYSTEM_ENGLISH_DXE_GUID": [
        2401693450,
        20351,
        20043,
        152,
        2,
        140,
        34,
        183,
        0,
        255,
        172,
    ],
    "LENOVO_ABSOLUTE_COMPUTRACE_INSTALLER_WIN8_GUID": [
        2414800113,
        48381,
        19064,
        146,
        49,
        72,
        1,
        86,
        107,
        53,
        103,
    ],
    "LENOVO_WMA_PCI_DXE_GUID": [
        2430603523,
        63364,
        16416,
        145,
        172,
        197,
        30,
        139,
        245,
        83,
        178,
    ],
    "LENOVO_DPTF_GUID": [2441787952, 15757, 19381, 184, 73, 69, 204, 79, 199, 222, 124],
    "LENOVO_SYSTEM_ISA_SERIAL_DXE_GUID": [
        2478309379,
        40883,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_SYSTEM_PCI_BUS_DXE_GUID": [
        2478309380,
        40883,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_DHCP4_DXE_BIN_GUID": [
        2490582808,
        3004,
        18427,
        150,
        165,
        238,
        122,
        90,
        230,
        162,
        173,
    ],
    "LENOVO_SYSTEM_XHCI_DXE_GUID": [
        2492998332,
        9939,
        19398,
        149,
        75,
        242,
        197,
        129,
        52,
        45,
        225,
    ],
    "LENOVO_DXE_CMOS_INIT_GUID": [
        2512357037,
        41440,
        16707,
        180,
        135,
        0,
        75,
        28,
        46,
        5,
        250,
    ],
    "LENOVO_TCG_SERVICES_SMM_GUID": [
        2512409029,
        61731,
        17198,
        147,
        131,
        185,
        207,
        17,
        63,
        8,
        46,
    ],
    "LENOVO_DHCP6_DXE_BIN_GUID": [
        2514708125,
        13502,
        18293,
        166,
        81,
        126,
        164,
        27,
        105,
        216,
        158,
    ],
    "LENOVO_SYSTEM_ENHANCED_FAT_DXE_GUID": [
        2517989630,
        46775,
        17603,
        175,
        53,
        107,
        199,
        5,
        205,
        43,
        31,
    ],
    "LENOVO_SYSTEM_NULL_MEMORY_TEST_DXE_GUID": [
        2528493618,
        57164,
        19310,
        130,
        50,
        67,
        141,
        207,
        68,
        141,
        14,
    ],
    "LENOVO_SMM_CF9_TRAP_GUID": [
        2534382554,
        35068,
        18764,
        158,
        161,
        38,
        65,
        150,
        99,
        206,
        17,
    ],
    "LENOVO_MTFTP6_DXE_BIN_GUID": [
        2582657945,
        39128,
        18909,
        168,
        211,
        50,
        25,
        208,
        255,
        228,
        30,
    ],
    "LENOVO_PLATFORM_RESET_RUNTIME_DXE_GUID": [
        2593820971,
        24403,
        17798,
        136,
        32,
        112,
        68,
        133,
        162,
        157,
        33,
    ],
    "LENOVO_SYSTEM_DEVICE_PATH_DXE_GUID": [
        2607288270,
        44395,
        20282,
        182,
        11,
        245,
        152,
        153,
        0,
        52,
        67,
    ],
    "LENOVO_SMM_CORE_DISPATCHER_GUID": [
        2630180221,
        64511,
        17180,
        188,
        20,
        51,
        78,
        174,
        166,
        5,
        43,
    ],
    "LENOVO_MEBX_GUID": [2633859116, 2465, 17366, 130, 23, 170, 73, 193, 249, 13, 44],
    "LENOVO_EN25_QH128_FLASH_PART_DXE_GUID": [
        2639791502,
        51421,
        19103,
        177,
        118,
        223,
        203,
        146,
        53,
        72,
        21,
    ],
    "LENOVO_ISSC_DXE_GUID": [
        2640230712,
        39492,
        17768,
        129,
        146,
        193,
        86,
        59,
        235,
        170,
        1,
    ],
    "LENOVO_SYSTEM_TERMINAL_DXE_GUID": [
        2659596550,
        41999,
        18549,
        151,
        127,
        91,
        147,
        255,
        35,
        127,
        198,
    ],
    "LENOVO_SYSTEM_CAPSULE_RT_GUID": [
        2661670671,
        41820,
        18625,
        186,
        201,
        246,
        52,
        82,
        180,
        124,
        62,
    ],
    "LENOVO_PCH_CONFIG_GUID": [
        2678257669,
        15750,
        17084,
        169,
        195,
        43,
        38,
        165,
        223,
        9,
        249,
    ],
    "LENOVO_IP4_DXE_BIN_GUID": [
        2679218675,
        15217,
        17188,
        179,
        154,
        116,
        92,
        187,
        1,
        95,
        255,
    ],
    "LENOVO_SYSTEM_USB_MASS_STORAGE_DXE_GUID": [
        2679420071,
        17088,
        19405,
        133,
        64,
        155,
        204,
        103,
        17,
        248,
        62,
    ],
    "LENOVO_SYSTEM_ERROR_LOG_DXE_GUID": [
        2711009863,
        36563,
        16776,
        167,
        101,
        250,
        150,
        77,
        215,
        237,
        122,
    ],
    "LENOVO_DPC_DXE_BIN_GUID": [
        2719021427,
        8861,
        20301,
        170,
        55,
        152,
        149,
        230,
        201,
        234,
        186,
    ],
    "LENOVO_SNP_DXE_BIN_GUID": [
        2733913834,
        41255,
        20216,
        149,
        124,
        128,
        72,
        96,
        111,
        246,
        112,
    ],
    "LENOVO_SECURE_UPDATE_DXE_GUID": [
        2761067649,
        1795,
        19159,
        163,
        43,
        117,
        37,
        188,
        63,
        225,
        245,
    ],
    "LENOVO_OEM_HOOK_SMM_GUID": [
        2763630598,
        46452,
        17236,
        191,
        199,
        5,
        33,
        125,
        192,
        250,
        244,
    ],
    "LENOVO_PLATFORM_SETUP_DXE_GUID": [
        2767360156,
        24106,
        17290,
        145,
        186,
        39,
        43,
        9,
        35,
        4,
        154,
    ],
    "LENOVO_MX25_L3206_EFLASH_PART_DXE_GUID": [
        2768044243,
        33306,
        17689,
        133,
        187,
        46,
        25,
        135,
        166,
        244,
        225,
    ],
    "LENOVO_SYSTEM_ACPI_TABLES_DXE_GUID": [
        2791868560,
        49136,
        20227,
        155,
        30,
        118,
        174,
        134,
        238,
        197,
        171,
    ],
    "LENOVO_SM_BIOS_HOLE_GUID": [
        2795618352,
        63830,
        19102,
        149,
        64,
        208,
        232,
        29,
        46,
        51,
        242,
    ],
    "LENOVO_SYSTEM_DIAGNOSTIC_SPLASH_SCREEN_APP_GUID": [
        2816006566,
        27312,
        19179,
        173,
        157,
        22,
        62,
        89,
        167,
        163,
        128,
    ],
    "LENOVO_PCI_EXPRESS_GUID": [
        2828978400,
        2977,
        16554,
        160,
        62,
        171,
        221,
        165,
        41,
        92,
        222,
    ],
    "LENOVO_SYSTEM_SECURE_BOOT_DXE_GUID": [
        2840226543,
        54939,
        16400,
        186,
        36,
        249,
        30,
        31,
        230,
        42,
        218,
    ],
    "LENOVO_PROMPT_SERVICE_GUID": [
        2855807077,
        4784,
        17637,
        167,
        49,
        109,
        239,
        77,
        243,
        76,
        231,
    ],
    "LENOVO_SYSTEM_FORM_BROWSER_SIMPLE_TEXT_VIEW_LAYOUT_DXE_GUID": [
        2866782636,
        59683,
        18035,
        177,
        184,
        113,
        74,
        216,
        73,
        247,
        144,
    ],
    "LENOVO_SMM_RELOC_PEIM_GUID": [
        2880917328,
        64813,
        16498,
        163,
        33,
        202,
        252,
        114,
        151,
        126,
        250,
    ],
    "LENOVO_SYSTEM_FRAMEWORK_HII_DATABASE_DXE_GUID": [
        2889102779,
        45523,
        20216,
        149,
        124,
        128,
        72,
        96,
        111,
        246,
        113,
    ],
    "LENOVO_INIT_VPRO_POLICY_GUID": [
        2891520473,
        61751,
        20359,
        134,
        159,
        216,
        99,
        237,
        168,
        142,
        210,
    ],
    "LENOVO_VARIABLE_INIT_DXE_GUID": [
        2892033439,
        21054,
        20315,
        148,
        202,
        57,
        97,
        52,
        106,
        0,
        186,
    ],
    "LENOVO_VPRO_MEBX_HOTKEY_GUID": [
        2893010282,
        15681,
        20221,
        161,
        185,
        135,
        2,
        147,
        129,
        26,
        40,
    ],
    "LENOVO_EN25_QH64_FLASH_PART_DXE_GUID": [
        2896228620,
        1225,
        19534,
        157,
        123,
        183,
        160,
        151,
        245,
        225,
        236,
    ],
    "LENOVO_PCH_PCIE_SMM_GUID": [
        2897128058,
        49209,
        17444,
        136,
        218,
        244,
        34,
        18,
        234,
        14,
        85,
    ],
    "LENOVO_SYSTEM_MONOTONIC_COUNTER_RT_GUID": [
        2908783218,
        53375,
        18788,
        128,
        30,
        123,
        211,
        183,
        136,
        134,
        82,
    ],
    "LENOVO_INCOMPATIBLE_PCI_DEVICE_GUID": [
        2909832542,
        3269,
        19135,
        137,
        121,
        190,
        118,
        42,
        148,
        158,
        163,
    ],
    "LENOVO_PCH_RESET_GUID": [
        2941907701,
        24104,
        19971,
        128,
        226,
        71,
        39,
        84,
        90,
        248,
        17,
    ],
    "LENOVO_AOAC_DXE_GUID": [
        2996974341,
        37973,
        18588,
        170,
        129,
        33,
        219,
        72,
        196,
        30,
        171,
    ],
    "LENOVO_SYSTEM_AHCI_BUS_SMM_GUID": [
        3005214816,
        33635,
        4575,
        131,
        149,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_SYSTEM_RUNTIME_DXE_GUID": [
        3053582532,
        17335,
        18308,
        149,
        177,
        244,
        34,
        108,
        180,
        12,
        238,
    ],
    "LENOVO_MEBX_SETUP_BROWSER_GUID": [
        3056532411,
        14627,
        19641,
        166,
        232,
        219,
        129,
        142,
        130,
        138,
        128,
    ],
    "LENOVO_OS_OPT_DEFAULT_DXE_GUID": [
        3057565518,
        53654,
        16570,
        171,
        99,
        31,
        169,
        166,
        6,
        142,
        132,
    ],
    "LENOVO_SOUND_SERVICE_GUID": [
        3059315134,
        47807,
        18925,
        157,
        210,
        72,
        236,
        141,
        180,
        171,
        211,
    ],
    "LENOVO_I_FFS_DXE_GUID": [
        3065588063,
        51903,
        19692,
        187,
        20,
        254,
        66,
        70,
        242,
        23,
        58,
    ],
    "LENOVO_SYSTEM_SMM_COMMUNICATION_SMM_GUID": [
        3075191674,
        60578,
        20345,
        165,
        68,
        144,
        86,
        154,
        190,
        107,
        153,
    ],
    "LENOVO_USER_MANAGER_DXE_GUID": [
        3097946053,
        47357,
        16988,
        166,
        126,
        16,
        9,
        223,
        31,
        16,
        181,
    ],
    "LENOVO_UEFI_PXE_BC_DXE_BIN_GUID": [
        3109986266,
        9950,
        18642,
        136,
        7,
        31,
        145,
        7,
        172,
        94,
        58,
    ],
    "LENOVO_BOARD_INFO_DXE_GUID": [
        3114529140,
        6966,
        19180,
        153,
        226,
        242,
        133,
        94,
        180,
        195,
        222,
    ],
    "LENOVO_SYSTEM_FLASH_COMMUNICATION_SMM_GUID": [
        3117071003,
        58821,
        16860,
        134,
        226,
        231,
        206,
        248,
        123,
        129,
        203,
    ],
    "LENOVO_SMBIOS_TCG_DXE_GUID": [
        3120117304,
        13813,
        17533,
        185,
        8,
        162,
        184,
        82,
        170,
        11,
        137,
    ],
    "LENOVO_CPU_IO_GUID": [
        3135723935,
        15467,
        17335,
        189,
        240,
        156,
        224,
        122,
        169,
        26,
        166,
    ],
    "LENOVO_OS_OPT_DEFAULT_SMM_GUID": [
        3136301472,
        45811,
        17902,
        139,
        82,
        212,
        2,
        23,
        123,
        230,
        184,
    ],
    "LENOVO_SYSTEM_AHCI_ATA_ATAPI_PASS_THRU_SMM_GUID": [
        3166018704,
        56454,
        4573,
        173,
        139,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_SYSTEM_ERROR_MENU_DXE_GUID": [
        3177658028,
        45350,
        20458,
        157,
        29,
        23,
        77,
        74,
        137,
        159,
        34,
    ],
    "LENOVO_SYSTEM_EHCI_DXE_GUID": [
        3187557134,
        36650,
        19888,
        153,
        145,
        111,
        133,
        101,
        148,
        119,
        126,
    ],
    "LENOVO_STATUS_CODE_ME_DEBUG_DXE_GUID": [
        3212038847,
        44172,
        19843,
        163,
        185,
        74,
        15,
        66,
        0,
        116,
        179,
    ],
    "LENOVO_SYSTEM_TEXT_CONSOLE_VGA_DXE_GUID": [
        3213488397,
        45573,
        18255,
        150,
        227,
        122,
        123,
        177,
        180,
        164,
        7,
    ],
    "LENOVO_MAIL_BOX_SMM_GUID": [
        3220075714,
        24765,
        18043,
        146,
        97,
        183,
        42,
        136,
        30,
        73,
        238,
    ],
    "LENOVO_SMM_FDISK_OEM_GUID": [
        3229404412,
        46271,
        18992,
        162,
        95,
        31,
        87,
        192,
        82,
        38,
        41,
    ],
    "LENOVO_SYSTEM_STATUS_CODE_PORT80_SMM_GUID": [
        3234851723,
        28385,
        17467,
        188,
        201,
        133,
        78,
        124,
        155,
        65,
        109,
    ],
    "LENOVO_PCH_SPI_RUNTIME_GUID": [
        3247752938,
        46732,
        18817,
        182,
        75,
        155,
        210,
        113,
        71,
        75,
        32,
    ],
    "LENOVO_SMM_ASL_SMI_GUID": [
        3287170800,
        25574,
        20313,
        164,
        55,
        175,
        166,
        60,
        70,
        200,
        53,
    ],
    "LENOVO_VARIABLE_DEFAULT_GUID": [
        3332108939,
        5827,
        17231,
        164,
        164,
        41,
        43,
        219,
        15,
        77,
        18,
    ],
    "LENOVO_PCH_S3_SUPPORT_GUID": [
        3354040199,
        51722,
        17332,
        177,
        229,
        37,
        239,
        135,
        57,
        31,
        141,
    ],
    "LENOVO_SVP_MANAGER_DXE_GUID": [
        3356403955,
        41929,
        16933,
        170,
        96,
        118,
        157,
        212,
        199,
        78,
        67,
    ],
    "LENOVO_SYSTEM_DIAGNOSTIC_SUMMARY_SCREEN_DXE_GUID": [
        3358136790,
        13309,
        17389,
        128,
        12,
        99,
        90,
        51,
        105,
        208,
        243,
    ],
    "LENOVO_SYSTEM_ACCELERATOR_KEY_DXE_GUID": [
        3365425629,
        24224,
        17102,
        137,
        52,
        235,
        142,
        166,
        8,
        251,
        169,
    ],
    "LENOVO_SYSTEM_FLASH_UPDATE_DRIVER_DXE_GUID": [
        3366653774,
        9982,
        16625,
        149,
        121,
        234,
        141,
        48,
        213,
        3,
        164,
    ],
    "LENOVO_SMAPI_SMM_GUID": [
        3380087232,
        24464,
        17510,
        139,
        56,
        52,
        29,
        122,
        103,
        207,
        84,
    ],
    "LENOVO_SYSTEM_DISK_IO_DXE_GUID": [
        3391494694,
        30488,
        19355,
        138,
        7,
        81,
        120,
        177,
        174,
        58,
        2,
    ],
    "LENOVO_SYSTEM_DATA_HUB_STD_ERR_DXE_GUID": [
        3394327302,
        206,
        16434,
        135,
        78,
        17,
        183,
        85,
        255,
        104,
        102,
    ],
    "LENOVO_SYSTEM_KEY_DESC_DXE_GUID": [
        3397046003,
        4481,
        19168,
        149,
        167,
        15,
        31,
        216,
        175,
        210,
        237,
    ],
    "LENOVO_HDP_MANAGER_DXE_GUID": [
        3398903232,
        4837,
        20396,
        173,
        88,
        217,
        170,
        176,
        59,
        143,
        17,
    ],
    "LENOVO_PLATFORM_SMM_GUID": [
        3413361625,
        12033,
        17218,
        174,
        103,
        4,
        221,
        229,
        38,
        64,
        146,
    ],
    "LENOVO_EN25_QH32_FLASH_PART_SMM_GUID": [
        3419028872,
        51998,
        18883,
        180,
        72,
        95,
        242,
        135,
        197,
        141,
        64,
    ],
    "LENOVO_VIDEO_INIT_DXE_GUID": [
        3430002758,
        52999,
        19886,
        174,
        173,
        112,
        70,
        132,
        91,
        205,
        138,
    ],
    "LENOVO_SYSTEM_FONT_DXE_GUID": [
        3431257893,
        55838,
        18087,
        158,
        117,
        75,
        172,
        241,
        253,
        57,
        2,
    ],
    "LENOVO_SYSTEM_SETUP_ADVANCED_DXE_GUID": [
        3433812521,
        20932,
        19943,
        174,
        47,
        58,
        175,
        113,
        249,
        236,
        229,
    ],
    "LENOVO_SYSTEM_GRAPHICS_CONSOLE_DXE_GUID": [
        3435858984,
        19236,
        4565,
        154,
        90,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_SYSTEM_SM_BIOS_SMM_GUID": [
        3448945081,
        11596,
        18027,
        132,
        88,
        149,
        68,
        125,
        142,
        74,
        254,
    ],
    "LENOVO_SYSTEM_BUS_ISA_RTC_SMM_GUID": [
        3451918622,
        6289,
        16665,
        129,
        126,
        11,
        106,
        54,
        133,
        165,
        17,
    ],
    "LENOVO_SYSTEM_ACPI_SMI_SERVICES_DXE2_GUID": [
        3482740983,
        45296,
        19839,
        180,
        30,
        174,
        199,
        148,
        238,
        199,
        252,
    ],
    "LENOVO_PLATFORM_HII_ADVANCED_DXE_GUID": [
        3488584900,
        16743,
        18026,
        136,
        147,
        135,
        121,
        69,
        157,
        250,
        134,
    ],
    "LENOVO_VARIABLE_SMM_GUID": [
        3575212162,
        43376,
        17680,
        143,
        185,
        215,
        88,
        59,
        105,
        6,
        231,
    ],
    "LENOVO_SYSTEM_FORM_BROWSER_SIMPLE_TEXT_VIEW_DXE_GUID": [
        3599230073,
        56119,
        19406,
        134,
        74,
        2,
        238,
        246,
        129,
        157,
        241,
    ],
    "LENOVO_N25_Q032_FLASH_PART_SMM_GUID": [
        3599366343,
        50004,
        16917,
        170,
        72,
        182,
        173,
        102,
        199,
        126,
        175,
    ],
    "LENOVO_MFG_BENCH_EVENT_DXE_GUID": [
        3627644895,
        13507,
        18977,
        161,
        4,
        54,
        155,
        141,
        79,
        167,
        183,
    ],
    "LENOVO_UDP6_DXE_BIN_GUID": [
        3641886652,
        61592,
        17255,
        146,
        186,
        233,
        17,
        8,
        60,
        123,
        14,
    ],
    "LENOVO_SYSTEM_STATUS_CODE_GENERIC_SMM_GUID": [
        3663567235,
        828,
        18467,
        147,
        73,
        139,
        27,
        106,
        121,
        128,
        48,
    ],
    "LENOVO_MX25_L64_XFLASH_PART_SMM_GUID": [
        3679301914,
        3676,
        16565,
        142,
        70,
        23,
        208,
        68,
        134,
        162,
        27,
    ],
    "LENOVO_MTFTP4_DXE_BIN_GUID": [
        3694543288,
        12200,
        20179,
        188,
        31,
        249,
        150,
        42,
        3,
        69,
        75,
    ],
    "LENOVO_I_FFS_DXE_POLICY_INIT_GUID": [
        3719565990,
        58355,
        20126,
        144,
        163,
        42,
        153,
        18,
        112,
        33,
        156,
    ],
    "LENOVO_WMA_USB_DXE_GUID": [
        3769480574,
        57782,
        17644,
        191,
        46,
        132,
        40,
        116,
        162,
        108,
        131,
    ],
    "LENOVO_SYSTEM_SCSI_OPROM_PASS_THRU_DXE_GUID": [
        3786228562,
        9744,
        19926,
        187,
        143,
        139,
        178,
        176,
        51,
        131,
        163,
    ],
    "LENOVO_PASSWORD_CP_GUID": [
        3841094362,
        9087,
        17740,
        136,
        104,
        252,
        240,
        150,
        207,
        28,
        108,
    ],
    "LENOVO_SYSTEM_DIAGNOSTIC_SPLASH_SCREEN_DXE_GUID": [
        3855662044,
        7100,
        18871,
        168,
        182,
        103,
        170,
        240,
        161,
        205,
        158,
    ],
    "LENOVO_IBEX_PEAK_FLASH_CONTROLLER_SMM_GUID": [
        3897225109,
        31910,
        19247,
        163,
        152,
        177,
        77,
        28,
        103,
        160,
        177,
    ],
    "LENOVO_SMM_SLEEP_EVENT_GUID": [
        3906732218,
        16671,
        19794,
        185,
        37,
        80,
        120,
        84,
        54,
        172,
        129,
    ],
    "LENOVO_AT24_RF08_EEPROM_DXE_GUID": [
        3914184057,
        1563,
        17275,
        131,
        194,
        101,
        192,
        174,
        124,
        20,
        226,
    ],
    "LENOVO_KBD_CONFIG_GUID": [
        3920933158,
        19987,
        16885,
        158,
        76,
        155,
        248,
        139,
        60,
        27,
        12,
    ],
    "LENOVO_SYSTEM_LEGACY_BIOS_DXE_GUID": [
        3928933378,
        12245,
        18271,
        146,
        44,
        152,
        234,
        224,
        55,
        99,
        18,
    ],
    "LENOVO_VPRO_CIRA_HOT_KEY_GUID": [
        3936260833,
        8943,
        19295,
        165,
        238,
        19,
        23,
        177,
        231,
        123,
        16,
    ],
    "LENOVO_OEM_HOOK_GUID": [3937366281, 60461, 18992, 191, 79, 98, 20, 8, 99, 14, 76],
    "LENOVO_SYSTEM_SMBIOS_DXE_GUID": [
        3941964814,
        48454,
        16698,
        154,
        233,
        221,
        159,
        109,
        26,
        146,
        125,
    ],
    "LENOVO_SECURE_KEY_SMM_GUID": [
        3949915124,
        7875,
        19817,
        157,
        130,
        101,
        191,
        108,
        87,
        155,
        52,
    ],
    "LENOVO_ME_CON_OUT_READY_GUID": [
        3965343067,
        25476,
        19456,
        134,
        37,
        44,
        23,
        104,
        185,
        91,
        56,
    ],
    "LENOVO_FINGERPRINT_CP_GUID": [
        3996187942,
        5412,
        19618,
        181,
        109,
        52,
        88,
        48,
        220,
        156,
        219,
    ],
    "LENOVO_SYSTEM_SMM_USB_LEGACY_SMM_GUID": [
        4013146774,
        63052,
        16710,
        173,
        4,
        52,
        120,
        153,
        112,
        44,
        132,
    ],
    "LENOVO_SYSTEM_WATCHDOG_TIMER_DXE_GUID": [
        4036613759,
        29102,
        19510,
        178,
        163,
        220,
        235,
        14,
        178,
        183,
        216,
    ],
    "LENOVO_N25_Q032_FLASH_PART_DXE_GUID": [
        4055748295,
        12753,
        20239,
        175,
        98,
        208,
        42,
        68,
        7,
        96,
        38,
    ],
    "LENOVO_SYSTEM_SECURITY_STUB_DXE_GUID": [
        4059018531,
        15705,
        18568,
        187,
        113,
        234,
        165,
        169,
        102,
        40,
        250,
    ],
    "LENOVO_SVP_MANAGER_SMM_GUID": [
        4100820646,
        19047,
        18546,
        176,
        209,
        212,
        253,
        234,
        11,
        105,
        47,
    ],
    "LENOVO_STARTUP_MENU_DXE_GUID": [
        4100908788,
        18309,
        17315,
        146,
        61,
        127,
        120,
        108,
        60,
        132,
        121,
    ],
    "LENOVO_PLATFORM_S3_SAVE_SMM_GUID": [
        4121718871,
        22096,
        18030,
        182,
        146,
        118,
        164,
        114,
        35,
        239,
        176,
    ],
    "LENOVO_SYSTEM_CMOS_DXE_GUID": [
        4131563991,
        9911,
        18379,
        172,
        200,
        19,
        89,
        81,
        172,
        147,
        248,
    ],
    "LENOVO_FINGERPRINT_SMM_GUID": [
        4148614015,
        63174,
        17344,
        148,
        219,
        70,
        111,
        95,
        16,
        224,
        48,
    ],
    "LENOVO_POWER_MANAGEMENT2_GUID": [
        4151515980,
        22690,
        19956,
        137,
        128,
        86,
        69,
        211,
        158,
        206,
        88,
    ],
    "LENOVO_W25_Q32_FLASH_PART_SMM_GUID": [
        4174016692,
        27269,
        17942,
        139,
        222,
        62,
        197,
        105,
        100,
        74,
        195,
    ],
    "LENOVO_SYSTEM_USB_DATABASE_DXE_GUID": [
        4182180003,
        62623,
        19666,
        191,
        37,
        25,
        226,
        128,
        183,
        46,
        59,
    ],
    "LENOVO_TCG_SMM_GUID": [
        4182377611,
        32708,
        19132,
        133,
        166,
        134,
        22,
        166,
        211,
        205,
        206,
    ],
    "LENOVO_SLP2_SMM_GUID": [
        4199507776,
        47450,
        17401,
        144,
        181,
        120,
        216,
        20,
        124,
        2,
        25,
    ],
    "LENOVO_FIT_DIAGNOSTICS_GUID": [
        4222873731,
        22407,
        17839,
        186,
        220,
        102,
        72,
        84,
        16,
        15,
        32,
    ],
    "LENOVO_SYSTEM_SECURE_FLASH_SLEEP_TRAP_SMM_GUID": [
        4242832462,
        24268,
        19009,
        185,
        14,
        11,
        171,
        9,
        150,
        141,
        2,
    ],
    "LENOVO_TXT_DXE_GUID": [
        4287725090,
        41512,
        17549,
        189,
        170,
        104,
        239,
        204,
        221,
        165,
        211,
    ],
    "LENOVO_SYSTEM_USB_SWITCH_DXE_GUID": [
        1293931,
        8600,
        17393,
        147,
        186,
        42,
        126,
        215,
        177,
        225,
        204,
    ],
    "LENOVO_SYSTEM_SCSI_BUS_DXE_GUID": [
        23579844,
        53495,
        20257,
        163,
        239,
        158,
        100,
        183,
        205,
        206,
        139,
    ],
    "LENOVO_SYSTEM_AHCI_BUS_DXE_GUID": [
        23579844,
        53495,
        20257,
        163,
        239,
        158,
        100,
        183,
        205,
        206,
        140,
    ],
    "LENOVO_MNP_DXE_BIN_GUID": [
        39567303,
        59049,
        19339,
        130,
        173,
        104,
        21,
        161,
        174,
        175,
        74,
    ],
    "LENOVO_ISSC_SMM_GUID": [
        62871161,
        22345,
        19397,
        165,
        63,
        71,
        71,
        29,
        167,
        103,
        200,
    ],
    "LENOVO_EC_IO_SMM_GUID": [
        65788747,
        38586,
        20288,
        131,
        41,
        127,
        58,
        168,
        134,
        87,
        7,
    ],
    "LENOVO_EN25_QH32_FLASH_PART_DXE_GUID": [
        85592951,
        49254,
        17936,
        153,
        4,
        191,
        37,
        194,
        150,
        214,
        230,
    ],
    "LENOVO_MTM_FORMAT_SMM_GUID": [
        104351088,
        5760,
        17952,
        157,
        0,
        106,
        217,
        227,
        204,
        177,
        159,
    ],
    "LENOVO_DXE_RICOH_INIT_GUID": [
        110529390,
        63008,
        20109,
        166,
        166,
        82,
        85,
        35,
        84,
        221,
        117,
    ],
    "LENOVO_SECURITY_VARIABLE_DXE_GUID": [
        115245642,
        42210,
        17045,
        163,
        246,
        3,
        179,
        254,
        245,
        177,
        9,
    ],
    "LENOVO_IBEX_PEAK_FLASH_CONTROLLER_DXE_GUID": [
        119797899,
        33039,
        20036,
        146,
        160,
        165,
        200,
        59,
        67,
        54,
        152,
    ],
    "LENOVO_BOARD_INFO_SMM_GUID": [
        124839840,
        39994,
        18844,
        163,
        17,
        47,
        131,
        133,
        8,
        5,
        86,
    ],
    "LENOVO_SYSTEM_METRONOME_DXE_GUID": [
        128529162,
        62279,
        4564,
        154,
        73,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_SLP2_DXE_GUID": [
        142514016,
        8117,
        18935,
        135,
        154,
        133,
        61,
        43,
        33,
        76,
        199,
    ],
    "LENOVO_CRYPT_SERVICE_SMM_GUID": [
        150721327,
        34431,
        17707,
        177,
        52,
        112,
        81,
        97,
        247,
        51,
        51,
    ],
    "LENOVO_SYSTEM_SCSI_DISK_DXE_GUID": [
        174514978,
        14144,
        19662,
        173,
        98,
        189,
        23,
        44,
        236,
        202,
        53,
    ],
    "LENOVO_SYSTEM_USB_SWITCH_SMM_GUID": [
        191532512,
        25217,
        16546,
        142,
        154,
        9,
        241,
        161,
        138,
        109,
        64,
    ],
    "LENOVO_EC_FW_UPDATE_DXE_GUID": [
        205090762,
        27610,
        18965,
        182,
        163,
        166,
        250,
        69,
        68,
        189,
        183,
    ],
    "LENOVO_SETUP_UNDER_OS_DXE_GUID": [
        224691302,
        14013,
        17094,
        178,
        135,
        124,
        59,
        170,
        37,
        117,
        192,
    ],
    "LENOVO_BDS_CTRL_GUID": [
        266426805,
        1903,
        19510,
        191,
        38,
        215,
        36,
        242,
        131,
        18,
        82,
    ],
    "LENOVO_SYSTEM_FIRMWARE_DEVICE_DXE_GUID": [
        269784614,
        21891,
        17252,
        130,
        47,
        164,
        89,
        184,
        18,
        19,
        2,
    ],
    "LENOVO_EC_IO_DXE_GUID": [
        290235916,
        55653,
        19475,
        190,
        247,
        196,
        6,
        34,
        72,
        225,
        250,
    ],
    "LENOVO_SYSTEM_SMM_AHCI_ASPI_LEGACY_RT_GUID": [
        306851450,
        6473,
        18494,
        137,
        159,
        96,
        50,
        144,
        76,
        160,
        167,
    ],
    "LENOVO_BOOT_MENU_DXE_GUID": [
        308966957,
        22360,
        20426,
        133,
        49,
        32,
        26,
        127,
        87,
        248,
        80,
    ],
    "LENOVO_FP_PBA_GUID": [317155615, 7918, 20180, 135, 147, 105, 226, 128, 29, 96, 42],
    "LENOVO_SYSTEM_EBC_DXE_GUID": [
        330067408,
        29648,
        4564,
        176,
        107,
        0,
        170,
        0,
        189,
        109,
        231,
    ],
    "LENOVO_SYSTEM_SMM_SERVICES_SMM_GUID": [
        352631419,
        22776,
        19730,
        150,
        56,
        180,
        148,
        167,
        4,
        67,
        118,
    ],
    "LENOVO_EC_SERVICE_GUID": [
        365429572,
        63872,
        19445,
        170,
        160,
        191,
        190,
        2,
        122,
        239,
        22,
    ],
    "LENOVO_SECURE_FLASH_VERIFY_SMM_GUID": [
        366827126,
        9849,
        20004,
        156,
        170,
        133,
        178,
        45,
        216,
        147,
        235,
    ],
    "LENOVO_EN25_QH128_FLASH_PART_SMM_GUID": [
        386766184,
        51561,
        20385,
        165,
        51,
        219,
        103,
        121,
        191,
        190,
        98,
    ],
    "LENOVO_COMPUTRACE_SMI_SERVICES_GUID": [
        408391285,
        53363,
        16899,
        144,
        210,
        135,
        136,
        168,
        113,
        228,
        77,
    ],
    "LENOVO_SMM_VIDEO_INT10_GUID": [
        431419749,
        30805,
        17128,
        170,
        111,
        35,
        97,
        202,
        135,
        224,
        36,
    ],
    "LENOVO_TCP_DXE_BIN_GUID": [
        444482664,
        12117,
        19030,
        144,
        60,
        1,
        38,
        94,
        183,
        98,
        43,
    ],
    "LENOVO_SYSTEM_BOOT_SCRIPT_SAVE_DXE_GUID": [
        476786607,
        55485,
        17617,
        169,
        30,
        115,
        33,
        180,
        194,
        243,
        209,
    ],
    "LENOVO_EAIA_DXE_GUID": [488641077, 12096, 20412, 134, 80, 133, 2, 9, 45, 98, 171],
    "LENOVO_SYSTEM_PS2_MOUSE_DXE_GUID": [
        539634446,
        39473,
        18450,
        178,
        145,
        135,
        71,
        223,
        21,
        36,
        57,
    ],
    "LENOVO_SMART_CARD_DETECT_DXE_GUID": [
        582945669,
        20147,
        18331,
        169,
        233,
        165,
        247,
        207,
        204,
        167,
        135,
    ],
    "LENOVO_PLATFORM_FLASH_DXE_GUID": [
        590885754,
        18352,
        19521,
        156,
        167,
        1,
        96,
        251,
        148,
        223,
        244,
    ],
    "LENOVO_MX25_L3206_EFLASH_PART_SMM_GUID": [
        596469069,
        42669,
        16840,
        163,
        27,
        103,
        163,
        32,
        134,
        37,
        195,
    ],
    "LENOVO_TPM_ENABLER_DXE_GUID": [
        601439914,
        1827,
        17753,
        183,
        104,
        94,
        34,
        223,
        118,
        45,
        228,
    ],
    "LENOVO_SYSTEM_USB_SUPPORT_POLICY_SMM_GUID": [
        604377783,
        41059,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        76,
    ],
    "LENOVO_SYSTEM_USB_BUS_DXE_GUID": [
        604377783,
        41059,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_SYSTEM_USB_SUPPORT_POLICY_DXE_GUID": [
        604377783,
        41059,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        78,
    ],
    "LENOVO_SMM_OEMINT15_GUID": [
        607947914,
        48080,
        19113,
        190,
        23,
        207,
        155,
        88,
        49,
        48,
        236,
    ],
    "LENOVO_SYSTEM_STATUS_CODE_GENERIC_RT_GUID": [
        611294986,
        4579,
        17818,
        174,
        6,
        55,
        43,
        220,
        77,
        232,
        6,
    ],
    "LENOVO_CRYPT_SERVICE_GUID": [
        626323294,
        51658,
        19016,
        157,
        148,
        36,
        158,
        177,
        232,
        124,
        45,
    ],
    "LENOVO_TCG_SERVICES_DXE_GUID": [
        636784743,
        42587,
        18677,
        187,
        190,
        53,
        65,
        140,
        72,
        136,
        54,
    ],
    "LENOVO_FDISK_OEM_GUID": [
        652065439,
        23309,
        20096,
        134,
        178,
        128,
        218,
        228,
        208,
        27,
        14,
    ],
    "LENOVO_PCH_SPI_SMM_GUID": [
        670339451,
        42759,
        19117,
        150,
        118,
        38,
        223,
        22,
        140,
        191,
        13,
    ],
    "LENOVO_IVB_GOP_DRIVER_GUID": [
        682992732,
        52317,
        16929,
        157,
        255,
        134,
        176,
        244,
        45,
        220,
        1,
    ],
    "LENOVO_SYSTEM_STATUS_CODE_PORT80_RT_GUID": [
        698459927,
        14057,
        18912,
        179,
        129,
        234,
        59,
        95,
        247,
        9,
        66,
    ],
    "LENOVO_W25_Q64_FLASH_PART_DXE_GUID": [
        708977825,
        9737,
        16551,
        136,
        226,
        166,
        141,
        192,
        241,
        209,
        128,
    ],
    "LENOVO_SYSTEM_USB_MEMORY_MANAGER_SMM_GUID": [
        717954629,
        57252,
        20467,
        143,
        129,
        145,
        247,
        215,
        135,
        210,
        45,
    ],
    "LENOVO_SYSTEM_ACPI_S3_SAVE_DXE_GUID": [
        736024197,
        63283,
        17759,
        168,
        64,
        67,
        162,
        43,
        121,
        31,
        179,
    ],
    "LENOVO_SA_LATE_INIT_SMM_GUID": [
        756954652,
        31551,
        19733,
        139,
        31,
        102,
        229,
        81,
        250,
        189,
        199,
    ],
    "LENOVO_SYSTEM_USB_MOUSE_DXE_GUID": [
        758014634,
        40655,
        17335,
        130,
        25,
        148,
        231,
        252,
        113,
        61,
        254,
    ],
    "LENOVO_SYSTEM_USB_KB_DXE_GUID": [
        758014671,
        40655,
        17335,
        130,
        25,
        148,
        231,
        252,
        113,
        61,
        254,
    ],
    "LENOVO_PLATFORM_DXE_GUID": [
        762263487,
        39676,
        19109,
        160,
        38,
        50,
        178,
        252,
        243,
        15,
        185,
    ],
    "LENOVO_PCH_BIOS_WRITE_PROTECT_GUID": [
        786963147,
        25778,
        16814,
        134,
        53,
        112,
        48,
        209,
        108,
        74,
        168,
    ],
    "LENOVO_TP_ACPI_NVS_INIT_DXE_GUID": [
        807013315,
        47638,
        18937,
        133,
        139,
        222,
        224,
        95,
        145,
        231,
        184,
    ],
    "LENOVO_SNB_GOP_DRIVER_GUID": [
        823145156,
        39078,
        19974,
        140,
        3,
        216,
        21,
        253,
        31,
        231,
        9,
    ],
    "LENOVO_SYSTEM_USB_DATABASE_SMM_GUID": [
        828477649,
        24136,
        19477,
        172,
        114,
        55,
        83,
        47,
        58,
        30,
        193,
    ],
    "LENOVO_SYSTEM_FORM_BROWSER_CORE_DXE_GUID": [
        843328777,
        7441,
        20007,
        138,
        171,
        144,
        254,
        106,
        203,
        4,
        137,
    ],
    "LENOVO_BIOS_EXTENSION_LOADER_GUID": [
        851560952,
        54591,
        16840,
        148,
        208,
        246,
        115,
        159,
        35,
        16,
        17,
    ],
    "LENOVO_SYSTEM_HII_DATABASE_DXE_GUID": [
        881610082,
        49085,
        18562,
        158,
        206,
        200,
        11,
        177,
        196,
        120,
        59,
    ],
    "LENOVO_ATP_DXE_GUID": [
        886382265,
        30427,
        19631,
        148,
        174,
        147,
        72,
        86,
        232,
        149,
        246,
    ],
    "LENOVO_DXE_MAIN_GUID": [
        901290186,
        46761,
        18894,
        140,
        114,
        144,
        71,
        53,
        204,
        73,
        183,
    ],
    "LENOVO_SYSTEM_SPLASH_DXE_GUID": [
        923302804,
        61249,
        18807,
        147,
        226,
        63,
        106,
        223,
        221,
        6,
        225,
    ],
    "LENOVO_SYSTEM_IMAGE_DISPLAY_DXE_GUID": [
        924820664,
        32834,
        20182,
        173,
        167,
        169,
        135,
        189,
        44,
        223,
        10,
    ],
    "LENOVO_SYSTEM_RTC_RT_GUID": [
        932019045,
        36265,
        18291,
        182,
        228,
        164,
        120,
        38,
        168,
        51,
        225,
    ],
    "LENOVO_SYSTEM_IDE_ATA_ATAPI_PASS_THRU_DXE_GUID": [
        933285920,
        52433,
        4573,
        173,
        139,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_SETUP_MAIN_DXE_GUID": [
        934268757,
        11916,
        18210,
        185,
        80,
        180,
        139,
        145,
        101,
        197,
        107,
    ],
    "LENOVO_ME_PCI_UPDATE_GUID": [
        937281513,
        31773,
        19995,
        178,
        203,
        78,
        213,
        209,
        37,
        39,
        179,
    ],
    "LENOVO_PHX_GOP_DXE_GUID": [
        938270500,
        33875,
        18282,
        171,
        88,
        244,
        207,
        139,
        254,
        103,
        66,
    ],
    "LENOVO_MX25_L64_XFLASH_PART_DXE_GUID": [
        949109979,
        15726,
        20048,
        131,
        93,
        90,
        119,
        90,
        50,
        93,
        137,
    ],
    "LENOVO_AOAC_SMM_GUID": [
        975891559,
        30648,
        16558,
        146,
        129,
        3,
        81,
        156,
        158,
        127,
        8,
    ],
    "LENOVO_SYSTEM_HII_IMAGE_DISPLAY_DXE_GUID": [
        1007992985,
        12611,
        18159,
        175,
        24,
        222,
        74,
        210,
        195,
        167,
        153,
    ],
    "LENOVO_SYSTEM_PS2_KEYBOARD_DXE_GUID": [
        1036526454,
        25467,
        16550,
        168,
        252,
        165,
        101,
        65,
        127,
        44,
        56,
    ],
    "LENOVO_REBOOT_CP_GUID": [
        1039934815,
        40070,
        18620,
        151,
        45,
        229,
        34,
        83,
        55,
        104,
        219,
    ],
    "LENOVO_SYSTEM_CRYPT_SVC_RT_GUID": [
        1044688137,
        55435,
        19538,
        180,
        27,
        184,
        192,
        5,
        54,
        71,
        74,
    ],
    "LENOVO_PLATFORM_PCI_DXE_GUID": [
        1064784879,
        54127,
        17868,
        138,
        26,
        46,
        170,
        255,
        16,
        56,
        182,
    ],
    "LENOVO_FIT_DIAGNOSTICS_LOADER_GUID": [
        1065247067,
        3397,
        20352,
        136,
        220,
        38,
        178,
        52,
        149,
        133,
        96,
    ],
    "LENOVO_IBEX_PEAK_GLOBAL_SMI_CONTROL_GUID": [
        1069045413,
        51376,
        18272,
        180,
        154,
        46,
        221,
        79,
        163,
        91,
        250,
    ],
    "LENOVO_VPRO_IDER_ASF_BOOT_GUID": [
        1075081700,
        40569,
        18020,
        191,
        176,
        23,
        149,
        36,
        35,
        5,
        103,
    ],
    "LENOVO_SYSTEM_CON_SPLITTER_DXE_GUID": [
        1083104492,
        53101,
        18300,
        165,
        168,
        180,
        132,
        78,
        61,
        226,
        129,
    ],
    "LENOVO_I_FFS_SMM_GUID": [
        1125591121,
        53118,
        17221,
        159,
        224,
        215,
        1,
        43,
        177,
        123,
        136,
    ],
    "LENOVO_SYSTEM_PARTITION_DXE_GUID": [
        1136210482,
        44990,
        4564,
        189,
        15,
        0,
        128,
        199,
        60,
        136,
        129,
    ],
    "LENOVO_MAIL_BOX_DXE_GUID": [
        1136369323,
        32087,
        19951,
        176,
        162,
        163,
        169,
        249,
        198,
        234,
        227,
    ],
    "LENOVO_VARIABLE_INIT_SMM_GUID": [
        1154448672,
        57334,
        16905,
        154,
        31,
        246,
        205,
        95,
        92,
        232,
        139,
    ],
    "LENOVO_SYSTEM_AHCI_ATA_ATAPI_PASS_THRU_DXE_GUID": [
        1156724112,
        56456,
        4573,
        173,
        139,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_COMPUTRACE_LOADER_DXE_GUID": [
        1166658547,
        1017,
        18840,
        157,
        111,
        38,
        52,
        60,
        105,
        86,
        42,
    ],
    "LENOVO_SYSTEM_CMOS_SMM_GUID": [
        1188605149,
        10691,
        16403,
        129,
        232,
        55,
        164,
        37,
        171,
        79,
        153,
    ],
    "LENOVO_MISC_GA_IO_DXE_GUID": [
        1246898131,
        3055,
        19626,
        172,
        189,
        236,
        132,
        68,
        108,
        92,
        108,
    ],
    "LENOVO_AT24_RF08_EEPROM_SMM_GUID": [
        1265312161,
        62059,
        16463,
        134,
        148,
        219,
        28,
        99,
        161,
        217,
        42,
    ],
    "LENOVO_SECURITY_SMI_DISPATCH_GUID": [
        1283265896,
        53107,
        18038,
        160,
        121,
        22,
        247,
        249,
        96,
        12,
        204,
    ],
    "LENOVO_SYSTEM_PPIS_NEEDED_BY_DXE_CORE_GUID": [
        1295505986,
        14860,
        20186,
        185,
        235,
        188,
        14,
        29,
        180,
        113,
        59,
    ],
    "LENOVO_SYSTEM_ERROR_LOG_SMM_GUID": [
        1298314729,
        29128,
        16682,
        134,
        4,
        135,
        140,
        146,
        29,
        154,
        209,
    ],
    "LENOVO_VPRO_HII_DXE_GUID": [
        1322172828,
        28255,
        18453,
        131,
        66,
        181,
        95,
        44,
        197,
        223,
        193,
    ],
    "LENOVO_COMPUTRACE_ENABLER_DXE_GUID": [
        1325158874,
        9126,
        18320,
        162,
        146,
        73,
        133,
        199,
        245,
        205,
        239,
    ],
    "LENOVO_EN25_QH64_FLASH_PART_SMM_GUID": [
        1344002362,
        61865,
        20300,
        169,
        70,
        120,
        103,
        223,
        151,
        85,
        55,
    ],
    "LENOVO_PCH_EMULATE_KBC_GUID": [
        1359302880,
        48078,
        20159,
        187,
        160,
        148,
        110,
        61,
        24,
        231,
        5,
    ],
    "LENOVO_SYSTEM_SMBIOS_EVENT_LOG_DXE_GUID": [
        1360175786,
        57717,
        18302,
        164,
        228,
        208,
        183,
        230,
        137,
        186,
        159,
    ],
    "LENOVO_HPM_SMM_GUID": [
        1364927051,
        45145,
        17931,
        133,
        199,
        194,
        134,
        88,
        244,
        184,
        152,
    ],
    "LENOVO_SYSTEM_CRC32_SECTION_EXTRACT_DXE_GUID": [
        1372189708,
        21059,
        17523,
        178,
        101,
        179,
        200,
        255,
        175,
        249,
        250,
    ],
    "LENOVO_SYSTEM_CON_PLATFORM_DXE_GUID": [
        1372386201,
        20447,
        20053,
        164,
        91,
        225,
        35,
        248,
        77,
        69,
        106,
    ],
    "LENOVO_PLATFORM_S3_SAVE_DXE_GUID": [
        1372895948,
        59146,
        16694,
        148,
        38,
        84,
        105,
        115,
        237,
        147,
        140,
    ],
    "LENOVO_TDT_AM_GUID": [
        1376754776,
        40861,
        18630,
        160,
        160,
        217,
        254,
        109,
        143,
        222,
        119,
    ],
    "LENOVO_ARP_DXE_BIN_GUID": [
        1386037139,
        59625,
        20083,
        177,
        225,
        189,
        246,
        169,
        213,
        1,
        19,
    ],
    "LENOVO_HPM_DXE_GUID": [
        1402833581,
        50860,
        17004,
        182,
        31,
        34,
        142,
        109,
        21,
        1,
        182,
    ],
    "LENOVO_SYSTEM_DATA_HUB_DXE_GUID": [
        1404879183,
        49743,
        17228,
        178,
        148,
        142,
        210,
        212,
        204,
        24,
        96,
    ],
    "LENOVO_SYSTEM_FLASH_COMMUNICATION_DXE_GUID": [
        1416286869,
        3172,
        19686,
        160,
        111,
        251,
        156,
        208,
        75,
        65,
        205,
    ],
    "LENOVO_SYSTEM_FIRMWARE_DEVICE_SMM_GUID": [
        1422077119,
        41913,
        19662,
        156,
        67,
        224,
        89,
        227,
        34,
        85,
        223,
    ],
    "LENOVO_DRIVE_ERASE_DXE_GUID": [
        1426260946,
        61491,
        17512,
        133,
        122,
        68,
        44,
        16,
        225,
        153,
        233,
    ],
    "LENOVO_SMM_BASE_RUNTIME_GUID": [
        1431459674,
        32256,
        19809,
        163,
        164,
        247,
        84,
        115,
        81,
        180,
        158,
    ],
    "LENOVO_DRIVE_ERASE_SMM_GUID": [
        1442418698,
        49072,
        19248,
        131,
        238,
        127,
        67,
        127,
        175,
        174,
        51,
    ],
    "LENOVO_PRIOR_BOOT_GUID": [
        1475642899,
        12298,
        16641,
        167,
        109,
        79,
        115,
        197,
        51,
        181,
        184,
    ],
    "LENOVO_DISK_CONTROLLER_SMBIOS_GUID": [
        1514093521,
        47014,
        16459,
        160,
        247,
        40,
        94,
        27,
        137,
        139,
        0,
    ],
    "LENOVO_DXE_REALTEK_CRC_INIT_GUID": [
        1534379841,
        19039,
        19086,
        182,
        137,
        216,
        4,
        171,
        67,
        104,
        253,
    ],
    "LENOVO_PLATFORM_CSM_DXE_GUID": [
        1541268997,
        45319,
        16798,
        149,
        16,
        170,
        60,
        67,
        78,
        187,
        228,
    ],
    "LENOVO_SECURE_ERROR_MANAGER_DXE_GUID": [
        1541333558,
        3253,
        19846,
        166,
        8,
        238,
        123,
        12,
        95,
        41,
        86,
    ],
    "LENOVO_IP6_DXE_BIN_GUID": [
        1542305228,
        55344,
        20146,
        135,
        66,
        45,
        76,
        201,
        181,
        79,
        44,
    ],
    "LENOVO_SETUP_RESTART_DXE_GUID": [
        1567984635,
        45859,
        20332,
        144,
        23,
        163,
        35,
        140,
        230,
        81,
        99,
    ],
    "LENOVO_SYSTEM_IMAGE_DECODER_DXE_GUID": [
        1600508442,
        34919,
        17875,
        164,
        26,
        82,
        111,
        159,
        226,
        197,
        152,
    ],
    "LENOVO_SETUP_CONFIG_DXE_GUID": [
        1607003872,
        39922,
        18831,
        180,
        211,
        197,
        30,
        212,
        200,
        123,
        180,
    ],
    "LENOVO_SMBIOS_COMPATI_INFO_GUID": [
        1616789944,
        59683,
        18380,
        135,
        177,
        166,
        227,
        133,
        38,
        231,
        141,
    ],
    "LENOVO_SYSTEM_KBC_INIT_DXE_GUID": [
        1628708000,
        5188,
        19534,
        161,
        109,
        182,
        1,
        224,
        160,
        148,
        102,
    ],
    "LENOVO_REMOTE_CONFIG_UPDATE_DXE_GUID": [
        1646126790,
        3934,
        20195,
        161,
        2,
        11,
        222,
        118,
        154,
        10,
        212,
    ],
    "LENOVO_CPU_INIT_DXE_GUID": [
        1657893323,
        30925,
        17536,
        134,
        120,
        198,
        162,
        167,
        151,
        168,
        222,
    ],
    "LENOVO_CPU_INIT_PHNX_DXE_GUID": [
        1665371246,
        38684,
        20032,
        143,
        11,
        17,
        9,
        69,
        123,
        227,
        51,
    ],
    "LENOVO_SYSTEM_VARIABLE_SMM_GUID": [
        1696885307,
        13295,
        20350,
        182,
        87,
        164,
        166,
        51,
        241,
        48,
        176,
    ],
    "LENOVO_SETUP_UNDER_OS_SMM_GUID": [
        1705451568,
        45102,
        19443,
        132,
        36,
        186,
        95,
        47,
        197,
        109,
        231,
    ],
    "LENOVO_RN_RCONFIG_GUID": [
        1717387104,
        44350,
        19629,
        142,
        38,
        219,
        70,
        238,
        233,
        241,
        181,
    ],
    "LENOVO_VARIABLE_DXE_GUID": [
        1726926656,
        25362,
        18970,
        168,
        58,
        179,
        178,
        248,
        216,
        167,
        26,
    ],
    "LENOVO_MISC_GA_IO_SMM_GUID": [
        1739578975,
        61206,
        18360,
        186,
        25,
        194,
        27,
        57,
        7,
        219,
        241,
    ],
    "LENOVO_W25_Q32_FLASH_PART_DXE_GUID": [
        1757163669,
        34873,
        19095,
        143,
        234,
        190,
        224,
        110,
        202,
        123,
        187,
    ],
    "LENOVO_SYSTEM_IDE_BUS_DXE_GUID": [
        1778224711,
        41313,
        17744,
        176,
        26,
        85,
        148,
        206,
        178,
        178,
        178,
    ],
    "LENOVO_OEM_MILESTONE_GUID": [
        1784844030,
        13954,
        20444,
        163,
        30,
        198,
        53,
        189,
        241,
        140,
        200,
    ],
    "LENOVO_SETUP_SECURITY_DXE_GUID": [
        1786453126,
        22798,
        18343,
        151,
        26,
        196,
        155,
        64,
        141,
        94,
        215,
    ],
    "LENOVO_SECURE_KEY_DXE_GUID": [
        1787443551,
        19463,
        18897,
        185,
        76,
        34,
        237,
        80,
        212,
        37,
        248,
    ],
    "LENOVO_UDP4_DXE_BIN_GUID": [
        1835623339,
        36973,
        19045,
        167,
        202,
        189,
        64,
        229,
        214,
        175,
        43,
    ],
    "LENOVO_N25_Q064_FLASH_PART_SMM_GUID": [
        1848830710,
        13009,
        17376,
        182,
        225,
        220,
        246,
        218,
        129,
        223,
        118,
    ],
    "LENOVO_SMBIOS_VPRO_GUID": [
        1850878195,
        37694,
        18785,
        149,
        115,
        15,
        30,
        97,
        181,
        34,
        172,
    ],
    "LENOVO_W25_Q64_FLASH_PART_SMM_GUID": [
        1852721781,
        61204,
        18427,
        180,
        58,
        103,
        236,
        67,
        184,
        125,
        34,
    ],
    "LENOVO_SYSTEM_ISA_KBC_DXE_GUID": [
        1852769708,
        9035,
        18011,
        148,
        80,
        195,
        110,
        109,
        117,
        102,
        197,
    ],
    "LENOVO_PLATFORM_FLASH_SMM_GUID": [
        1886133772,
        17660,
        16402,
        155,
        113,
        61,
        191,
        236,
        118,
        47,
        53,
    ],
    "LENOVO_PI_SAVE_STATE_ACCESS_GUID": [
        1887124590,
        39334,
        19991,
        132,
        160,
        64,
        40,
        76,
        27,
        63,
        56,
    ],
    "LENOVO_SYSTEM_ACPI_SUPPORT_DXE_GUID": [
        1903824554,
        39704,
        17946,
        182,
        236,
        172,
        9,
        121,
        76,
        166,
        49,
    ],
    "LENOVO_SYSTEM_SETUP2_DXE_GUID": [
        1914473318,
        17004,
        20102,
        142,
        153,
        52,
        87,
        196,
        106,
        176,
        185,
    ],
    "LENOVO_SYSTEM_IDE_ATA_ATAPI_PASS_THRU_SMM_GUID": [
        1938925920,
        52433,
        4573,
        173,
        139,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_SYSTEM_BOOT_MANAGER_DXE_GUID": [
        1943712527,
        16284,
        16736,
        176,
        100,
        67,
        156,
        225,
        108,
        62,
        222,
    ],
    "LENOVO_BLOCK_POWER_BUTTON_DXE_GUID": [
        1956648660,
        20043,
        17845,
        174,
        151,
        78,
        110,
        51,
        214,
        81,
        37,
    ],
    "LENOVO_SYSTEM_ACPI_NUMA_DXE_GUID": [
        1972041895,
        10756,
        18743,
        153,
        224,
        131,
        125,
        31,
        151,
        199,
        111,
    ],
    "LENOVO_SYSTEM_ACPI_TABLE_LOADER_DXE_GUID": [
        2002878155,
        57897,
        20000,
        184,
        249,
        223,
        130,
        69,
        98,
        77,
        122,
    ],
    "LENOVO_DIGITAL_THERMAL_SENSOR_SMM_GUID": [
        2007367838,
        4462,
        17997,
        142,
        248,
        179,
        82,
        1,
        160,
        34,
        221,
    ],
    "LENOVO_SYSTEM_FIXED_BUS_NUMBERS_DXE_GUID": [
        2030029397,
        18537,
        17299,
        190,
        233,
        114,
        229,
        139,
        211,
        190,
        56,
    ],
    "LENOVO_SYSTEM_VARIABLE_DXE_GUID": [
        2034024096,
        55894,
        18418,
        130,
        100,
        36,
        49,
        12,
        183,
        81,
        150,
    ],
    "LENOVO_SYSTEM_SW_SMI_ALLOCATOR_RT_GUID": [
        2034634970,
        53486,
        18027,
        129,
        179,
        129,
        151,
        33,
        58,
        105,
        120,
    ],
    "LENOVO_SYSTEM8259_INTERRUPT_CONTROLLER_DXE_GUID": [
        2043298312,
        48033,
        19098,
        132,
        86,
        225,
        230,
        106,
        129,
        72,
        78,
    ],
    "LENOVO_WMA_POLICY_DXE_GUID": [
        2044784087,
        40221,
        20289,
        174,
        26,
        248,
        150,
        22,
        158,
        82,
        22,
    ],
    "LENOVO_LAN_UEFI_GUID": [
        2046361940,
        33780,
        18316,
        128,
        191,
        135,
        138,
        195,
        46,
        10,
        44,
    ],
    "LENOVO_POP_MANAGER_DXE_GUID": [
        2070879654,
        59983,
        18744,
        167,
        159,
        12,
        88,
        225,
        68,
        42,
        161,
    ],
    "LENOVO_SYSTEM_USB_MEMORY_MANAGER_DXE_GUID": [
        2078746034,
        62828,
        16839,
        159,
        3,
        30,
        123,
        86,
        182,
        89,
        113,
    ],
    "LENOVO_ATP_SMI_SERVICES_GUID": [
        2091593354,
        47001,
        17728,
        133,
        23,
        88,
        100,
        77,
        3,
        204,
        159,
    ],
    "LENOVO_MODULES_SMM_THUNK_SMM_GUID": [
        2121356880,
        4326,
        19323,
        137,
        106,
        77,
        197,
        252,
        116,
        43,
        197,
    ],
    "LENOVO_VPRO_PET_ALERT_GUID": [
        2124901688,
        50554,
        16685,
        175,
        29,
        213,
        139,
        238,
        43,
        133,
        177,
    ],
    "LENOVO_SMM_RELOC_DXE_GUID": [
        2146267886,
        368,
        18452,
        152,
        120,
        168,
        251,
        24,
        100,
        223,
        175,
    ],
    "LENOVO_IGD_CUSTOMIZE_GUID": [
        2167621142,
        34510,
        18882,
        182,
        249,
        24,
        4,
        230,
        28,
        115,
        246,
    ],
    "LENOVO_SETUP_DATE_TIME_DXE_GUID": [
        2182649437,
        8384,
        19926,
        129,
        160,
        132,
        92,
        82,
        39,
        7,
        67,
    ],
    "LENOVO_TRANSLATE_SERVICE_GUID": [
        2188103510,
        47812,
        17396,
        142,
        161,
        140,
        223,
        10,
        18,
        26,
        189,
    ],
    "LENOVO_ME_CONFIG_GUID": [
        2191033376,
        29799,
        17552,
        144,
        89,
        254,
        180,
        72,
        221,
        25,
        99,
    ],
    "LENOVO_SYSTEM_OEM_ACTIVATION_DXE_GUID": [
        2233099093,
        52752,
        20327,
        157,
        19,
        145,
        179,
        40,
        26,
        149,
        211,
    ],
    "LENOVO_SYSTEM_PCI_ISA_BUS_DXE_GUID": [
        2253066494,
        15710,
        18696,
        136,
        204,
        240,
        141,
        78,
        220,
        0,
        80,
    ],
    "LENOVO_LEGACY_BIOS_MISC_SMM_GUID": [
        2263362243,
        54959,
        18340,
        140,
        147,
        12,
        118,
        199,
        179,
        204,
        211,
    ],
    "LENOVO_INIT_ME_POLICY_GUID": [
        2279811321,
        37797,
        17269,
        186,
        105,
        147,
        167,
        167,
        122,
        93,
        155,
    ],
    "LENOVO_SETUP_AUTOMATION_SMM_GUID": [
        2282586559,
        55944,
        18913,
        149,
        67,
        165,
        130,
        71,
        254,
        173,
        26,
    ],
    "LENOVO_N25_Q064_FLASH_PART_DXE_GUID": [
        2288700192,
        30912,
        20360,
        157,
        60,
        186,
        220,
        227,
        126,
        218,
        71,
    ],
    "LENOVO_HDP_MANAGER_SMM_GUID": [
        2299999890,
        39618,
        19590,
        158,
        204,
        243,
        119,
        130,
        221,
        235,
        170,
    ],
    "LENOVO_SYSTEM_XHCI_RESET_SYSTEM_GUID": [
        2388413418,
        13567,
        20018,
        131,
        88,
        51,
        99,
        218,
        1,
        230,
        40,
    ],
    "LENOVO_NATIONAL_LPC_PC87393_GUID": [
        2392276867,
        43978,
        18916,
        169,
        64,
        78,
        173,
        90,
        109,
        138,
        30,
    ],
    "LENOVO_SYSTEM_ENGLISH_DXE_GUID": [
        2401693450,
        20351,
        20043,
        152,
        2,
        140,
        34,
        183,
        0,
        255,
        172,
    ],
    "LENOVO_ABSOLUTE_COMPUTRACE_INSTALLER_WIN8_GUID": [
        2414800113,
        48381,
        19064,
        146,
        49,
        72,
        1,
        86,
        107,
        53,
        103,
    ],
    "LENOVO_WMA_PCI_DXE_GUID": [
        2430603523,
        63364,
        16416,
        145,
        172,
        197,
        30,
        139,
        245,
        83,
        178,
    ],
    "LENOVO_DPTF_GUID": [2441787952, 15757, 19381, 184, 73, 69, 204, 79, 199, 222, 124],
    "LENOVO_SYSTEM_ISA_SERIAL_DXE_GUID": [
        2478309379,
        40883,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_SYSTEM_PCI_BUS_DXE_GUID": [
        2478309380,
        40883,
        4564,
        154,
        58,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_DHCP4_DXE_BIN_GUID": [
        2490582808,
        3004,
        18427,
        150,
        165,
        238,
        122,
        90,
        230,
        162,
        173,
    ],
    "LENOVO_SYSTEM_XHCI_DXE_GUID": [
        2492998332,
        9939,
        19398,
        149,
        75,
        242,
        197,
        129,
        52,
        45,
        225,
    ],
    "LENOVO_DXE_CMOS_INIT_GUID": [
        2512357037,
        41440,
        16707,
        180,
        135,
        0,
        75,
        28,
        46,
        5,
        250,
    ],
    "LENOVO_TCG_SERVICES_SMM_GUID": [
        2512409029,
        61731,
        17198,
        147,
        131,
        185,
        207,
        17,
        63,
        8,
        46,
    ],
    "LENOVO_DHCP6_DXE_BIN_GUID": [
        2514708125,
        13502,
        18293,
        166,
        81,
        126,
        164,
        27,
        105,
        216,
        158,
    ],
    "LENOVO_SYSTEM_ENHANCED_FAT_DXE_GUID": [
        2517989630,
        46775,
        17603,
        175,
        53,
        107,
        199,
        5,
        205,
        43,
        31,
    ],
    "LENOVO_SYSTEM_NULL_MEMORY_TEST_DXE_GUID": [
        2528493618,
        57164,
        19310,
        130,
        50,
        67,
        141,
        207,
        68,
        141,
        14,
    ],
    "LENOVO_SMM_CF9_TRAP_GUID": [
        2534382554,
        35068,
        18764,
        158,
        161,
        38,
        65,
        150,
        99,
        206,
        17,
    ],
    "LENOVO_MTFTP6_DXE_BIN_GUID": [
        2582657945,
        39128,
        18909,
        168,
        211,
        50,
        25,
        208,
        255,
        228,
        30,
    ],
    "LENOVO_PLATFORM_RESET_RUNTIME_DXE_GUID": [
        2593820971,
        24403,
        17798,
        136,
        32,
        112,
        68,
        133,
        162,
        157,
        33,
    ],
    "LENOVO_SYSTEM_DEVICE_PATH_DXE_GUID": [
        2607288270,
        44395,
        20282,
        182,
        11,
        245,
        152,
        153,
        0,
        52,
        67,
    ],
    "LENOVO_SMM_CORE_DISPATCHER_GUID": [
        2630180221,
        64511,
        17180,
        188,
        20,
        51,
        78,
        174,
        166,
        5,
        43,
    ],
    "LENOVO_MEBX_GUID": [2633859116, 2465, 17366, 130, 23, 170, 73, 193, 249, 13, 44],
    "LENOVO_EN25_QH128_FLASH_PART_DXE_GUID": [
        2639791502,
        51421,
        19103,
        177,
        118,
        223,
        203,
        146,
        53,
        72,
        21,
    ],
    "LENOVO_ISSC_DXE_GUID": [
        2640230712,
        39492,
        17768,
        129,
        146,
        193,
        86,
        59,
        235,
        170,
        1,
    ],
    "LENOVO_SYSTEM_TERMINAL_DXE_GUID": [
        2659596550,
        41999,
        18549,
        151,
        127,
        91,
        147,
        255,
        35,
        127,
        198,
    ],
    "LENOVO_SYSTEM_CAPSULE_RT_GUID": [
        2661670671,
        41820,
        18625,
        186,
        201,
        246,
        52,
        82,
        180,
        124,
        62,
    ],
    "LENOVO_PCH_CONFIG_GUID": [
        2678257669,
        15750,
        17084,
        169,
        195,
        43,
        38,
        165,
        223,
        9,
        249,
    ],
    "LENOVO_IP4_DXE_BIN_GUID": [
        2679218675,
        15217,
        17188,
        179,
        154,
        116,
        92,
        187,
        1,
        95,
        255,
    ],
    "LENOVO_SYSTEM_USB_MASS_STORAGE_DXE_GUID": [
        2679420071,
        17088,
        19405,
        133,
        64,
        155,
        204,
        103,
        17,
        248,
        62,
    ],
    "LENOVO_SYSTEM_ERROR_LOG_DXE_GUID": [
        2711009863,
        36563,
        16776,
        167,
        101,
        250,
        150,
        77,
        215,
        237,
        122,
    ],
    "LENOVO_DPC_DXE_BIN_GUID": [
        2719021427,
        8861,
        20301,
        170,
        55,
        152,
        149,
        230,
        201,
        234,
        186,
    ],
    "LENOVO_SNP_DXE_BIN_GUID": [
        2733913834,
        41255,
        20216,
        149,
        124,
        128,
        72,
        96,
        111,
        246,
        112,
    ],
    "LENOVO_SECURE_UPDATE_DXE_GUID": [
        2761067649,
        1795,
        19159,
        163,
        43,
        117,
        37,
        188,
        63,
        225,
        245,
    ],
    "LENOVO_OEM_HOOK_SMM_GUID": [
        2763630598,
        46452,
        17236,
        191,
        199,
        5,
        33,
        125,
        192,
        250,
        244,
    ],
    "LENOVO_PLATFORM_SETUP_DXE_GUID": [
        2767360156,
        24106,
        17290,
        145,
        186,
        39,
        43,
        9,
        35,
        4,
        154,
    ],
    "LENOVO_MX25_L3206_EFLASH_PART_DXE_GUID": [
        2768044243,
        33306,
        17689,
        133,
        187,
        46,
        25,
        135,
        166,
        244,
        225,
    ],
    "LENOVO_SYSTEM_ACPI_TABLES_DXE_GUID": [
        2791868560,
        49136,
        20227,
        155,
        30,
        118,
        174,
        134,
        238,
        197,
        171,
    ],
    "LENOVO_SM_BIOS_HOLE_GUID": [
        2795618352,
        63830,
        19102,
        149,
        64,
        208,
        232,
        29,
        46,
        51,
        242,
    ],
    "LENOVO_SYSTEM_DIAGNOSTIC_SPLASH_SCREEN_APP_GUID": [
        2816006566,
        27312,
        19179,
        173,
        157,
        22,
        62,
        89,
        167,
        163,
        128,
    ],
    "LENOVO_PCI_EXPRESS_GUID": [
        2828978400,
        2977,
        16554,
        160,
        62,
        171,
        221,
        165,
        41,
        92,
        222,
    ],
    "LENOVO_SYSTEM_SECURE_BOOT_DXE_GUID": [
        2840226543,
        54939,
        16400,
        186,
        36,
        249,
        30,
        31,
        230,
        42,
        218,
    ],
    "LENOVO_PROMPT_SERVICE_GUID": [
        2855807077,
        4784,
        17637,
        167,
        49,
        109,
        239,
        77,
        243,
        76,
        231,
    ],
    "LENOVO_SYSTEM_FORM_BROWSER_SIMPLE_TEXT_VIEW_LAYOUT_DXE_GUID": [
        2866782636,
        59683,
        18035,
        177,
        184,
        113,
        74,
        216,
        73,
        247,
        144,
    ],
    "LENOVO_SMM_RELOC_PEIM_GUID": [
        2880917328,
        64813,
        16498,
        163,
        33,
        202,
        252,
        114,
        151,
        126,
        250,
    ],
    "LENOVO_SYSTEM_FRAMEWORK_HII_DATABASE_DXE_GUID": [
        2889102779,
        45523,
        20216,
        149,
        124,
        128,
        72,
        96,
        111,
        246,
        113,
    ],
    "LENOVO_INIT_VPRO_POLICY_GUID": [
        2891520473,
        61751,
        20359,
        134,
        159,
        216,
        99,
        237,
        168,
        142,
        210,
    ],
    "LENOVO_VARIABLE_INIT_DXE_GUID": [
        2892033439,
        21054,
        20315,
        148,
        202,
        57,
        97,
        52,
        106,
        0,
        186,
    ],
    "LENOVO_VPRO_MEBX_HOTKEY_GUID": [
        2893010282,
        15681,
        20221,
        161,
        185,
        135,
        2,
        147,
        129,
        26,
        40,
    ],
    "LENOVO_EN25_QH64_FLASH_PART_DXE_GUID": [
        2896228620,
        1225,
        19534,
        157,
        123,
        183,
        160,
        151,
        245,
        225,
        236,
    ],
    "LENOVO_PCH_PCIE_SMM_GUID": [
        2897128058,
        49209,
        17444,
        136,
        218,
        244,
        34,
        18,
        234,
        14,
        85,
    ],
    "LENOVO_SYSTEM_MONOTONIC_COUNTER_RT_GUID": [
        2908783218,
        53375,
        18788,
        128,
        30,
        123,
        211,
        183,
        136,
        134,
        82,
    ],
    "LENOVO_INCOMPATIBLE_PCI_DEVICE_GUID": [
        2909832542,
        3269,
        19135,
        137,
        121,
        190,
        118,
        42,
        148,
        158,
        163,
    ],
    "LENOVO_PCH_RESET_GUID": [
        2941907701,
        24104,
        19971,
        128,
        226,
        71,
        39,
        84,
        90,
        248,
        17,
    ],
    "LENOVO_AOAC_DXE_GUID": [
        2996974341,
        37973,
        18588,
        170,
        129,
        33,
        219,
        72,
        196,
        30,
        171,
    ],
    "LENOVO_SYSTEM_AHCI_BUS_SMM_GUID": [
        3005214816,
        33635,
        4575,
        131,
        149,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_SYSTEM_RUNTIME_DXE_GUID": [
        3053582532,
        17335,
        18308,
        149,
        177,
        244,
        34,
        108,
        180,
        12,
        238,
    ],
    "LENOVO_MEBX_SETUP_BROWSER_GUID": [
        3056532411,
        14627,
        19641,
        166,
        232,
        219,
        129,
        142,
        130,
        138,
        128,
    ],
    "LENOVO_OS_OPT_DEFAULT_DXE_GUID": [
        3057565518,
        53654,
        16570,
        171,
        99,
        31,
        169,
        166,
        6,
        142,
        132,
    ],
    "LENOVO_SOUND_SERVICE_GUID": [
        3059315134,
        47807,
        18925,
        157,
        210,
        72,
        236,
        141,
        180,
        171,
        211,
    ],
    "LENOVO_I_FFS_DXE_GUID": [
        3065588063,
        51903,
        19692,
        187,
        20,
        254,
        66,
        70,
        242,
        23,
        58,
    ],
    "LENOVO_SYSTEM_SMM_COMMUNICATION_SMM_GUID": [
        3075191674,
        60578,
        20345,
        165,
        68,
        144,
        86,
        154,
        190,
        107,
        153,
    ],
    "LENOVO_USER_MANAGER_DXE_GUID": [
        3097946053,
        47357,
        16988,
        166,
        126,
        16,
        9,
        223,
        31,
        16,
        181,
    ],
    "LENOVO_UEFI_PXE_BC_DXE_BIN_GUID": [
        3109986266,
        9950,
        18642,
        136,
        7,
        31,
        145,
        7,
        172,
        94,
        58,
    ],
    "LENOVO_BOARD_INFO_DXE_GUID": [
        3114529140,
        6966,
        19180,
        153,
        226,
        242,
        133,
        94,
        180,
        195,
        222,
    ],
    "LENOVO_SYSTEM_FLASH_COMMUNICATION_SMM_GUID": [
        3117071003,
        58821,
        16860,
        134,
        226,
        231,
        206,
        248,
        123,
        129,
        203,
    ],
    "LENOVO_SMBIOS_TCG_DXE_GUID": [
        3120117304,
        13813,
        17533,
        185,
        8,
        162,
        184,
        82,
        170,
        11,
        137,
    ],
    "LENOVO_CPU_IO_GUID": [
        3135723935,
        15467,
        17335,
        189,
        240,
        156,
        224,
        122,
        169,
        26,
        166,
    ],
    "LENOVO_OS_OPT_DEFAULT_SMM_GUID": [
        3136301472,
        45811,
        17902,
        139,
        82,
        212,
        2,
        23,
        123,
        230,
        184,
    ],
    "LENOVO_SYSTEM_AHCI_ATA_ATAPI_PASS_THRU_SMM_GUID": [
        3166018704,
        56454,
        4573,
        173,
        139,
        8,
        0,
        32,
        12,
        154,
        102,
    ],
    "LENOVO_SYSTEM_ERROR_MENU_DXE_GUID": [
        3177658028,
        45350,
        20458,
        157,
        29,
        23,
        77,
        74,
        137,
        159,
        34,
    ],
    "LENOVO_SYSTEM_EHCI_DXE_GUID": [
        3187557134,
        36650,
        19888,
        153,
        145,
        111,
        133,
        101,
        148,
        119,
        126,
    ],
    "LENOVO_STATUS_CODE_ME_DEBUG_DXE_GUID": [
        3212038847,
        44172,
        19843,
        163,
        185,
        74,
        15,
        66,
        0,
        116,
        179,
    ],
    "LENOVO_SYSTEM_TEXT_CONSOLE_VGA_DXE_GUID": [
        3213488397,
        45573,
        18255,
        150,
        227,
        122,
        123,
        177,
        180,
        164,
        7,
    ],
    "LENOVO_MAIL_BOX_SMM_GUID": [
        3220075714,
        24765,
        18043,
        146,
        97,
        183,
        42,
        136,
        30,
        73,
        238,
    ],
    "LENOVO_SMM_FDISK_OEM_GUID": [
        3229404412,
        46271,
        18992,
        162,
        95,
        31,
        87,
        192,
        82,
        38,
        41,
    ],
    "LENOVO_SYSTEM_STATUS_CODE_PORT80_SMM_GUID": [
        3234851723,
        28385,
        17467,
        188,
        201,
        133,
        78,
        124,
        155,
        65,
        109,
    ],
    "LENOVO_PCH_SPI_RUNTIME_GUID": [
        3247752938,
        46732,
        18817,
        182,
        75,
        155,
        210,
        113,
        71,
        75,
        32,
    ],
    "LENOVO_SMM_ASL_SMI_GUID": [
        3287170800,
        25574,
        20313,
        164,
        55,
        175,
        166,
        60,
        70,
        200,
        53,
    ],
    "LENOVO_VARIABLE_DEFAULT_GUID": [
        3332108939,
        5827,
        17231,
        164,
        164,
        41,
        43,
        219,
        15,
        77,
        18,
    ],
    "LENOVO_PCH_S3_SUPPORT_GUID": [
        3354040199,
        51722,
        17332,
        177,
        229,
        37,
        239,
        135,
        57,
        31,
        141,
    ],
    "LENOVO_SVP_MANAGER_DXE_GUID": [
        3356403955,
        41929,
        16933,
        170,
        96,
        118,
        157,
        212,
        199,
        78,
        67,
    ],
    "LENOVO_SYSTEM_DIAGNOSTIC_SUMMARY_SCREEN_DXE_GUID": [
        3358136790,
        13309,
        17389,
        128,
        12,
        99,
        90,
        51,
        105,
        208,
        243,
    ],
    "LENOVO_SYSTEM_ACCELERATOR_KEY_DXE_GUID": [
        3365425629,
        24224,
        17102,
        137,
        52,
        235,
        142,
        166,
        8,
        251,
        169,
    ],
    "LENOVO_SMAPI_SMM_GUID": [
        3380087232,
        24464,
        17510,
        139,
        56,
        52,
        29,
        122,
        103,
        207,
        84,
    ],
    "LENOVO_SYSTEM_DISK_IO_DXE_GUID": [
        3391494694,
        30488,
        19355,
        138,
        7,
        81,
        120,
        177,
        174,
        58,
        2,
    ],
    "LENOVO_SYSTEM_DATA_HUB_STD_ERR_DXE_GUID": [
        3394327302,
        206,
        16434,
        135,
        78,
        17,
        183,
        85,
        255,
        104,
        102,
    ],
    "LENOVO_SYSTEM_KEY_DESC_DXE_GUID": [
        3397046003,
        4481,
        19168,
        149,
        167,
        15,
        31,
        216,
        175,
        210,
        237,
    ],
    "LENOVO_HDP_MANAGER_DXE_GUID": [
        3398903232,
        4837,
        20396,
        173,
        88,
        217,
        170,
        176,
        59,
        143,
        17,
    ],
    "LENOVO_PLATFORM_SMM_GUID": [
        3413361625,
        12033,
        17218,
        174,
        103,
        4,
        221,
        229,
        38,
        64,
        146,
    ],
    "LENOVO_EN25_QH32_FLASH_PART_SMM_GUID": [
        3419028872,
        51998,
        18883,
        180,
        72,
        95,
        242,
        135,
        197,
        141,
        64,
    ],
    "LENOVO_VIDEO_INIT_DXE_GUID": [
        3430002758,
        52999,
        19886,
        174,
        173,
        112,
        70,
        132,
        91,
        205,
        138,
    ],
    "LENOVO_SYSTEM_FONT_DXE_GUID": [
        3431257893,
        55838,
        18087,
        158,
        117,
        75,
        172,
        241,
        253,
        57,
        2,
    ],
    "LENOVO_SYSTEM_SETUP_ADVANCED_DXE_GUID": [
        3433812521,
        20932,
        19943,
        174,
        47,
        58,
        175,
        113,
        249,
        236,
        229,
    ],
    "LENOVO_SYSTEM_GRAPHICS_CONSOLE_DXE_GUID": [
        3435858984,
        19236,
        4565,
        154,
        90,
        0,
        144,
        39,
        63,
        193,
        77,
    ],
    "LENOVO_SYSTEM_SM_BIOS_SMM_GUID": [
        3448945081,
        11596,
        18027,
        132,
        88,
        149,
        68,
        125,
        142,
        74,
        254,
    ],
    "LENOVO_SYSTEM_BUS_ISA_RTC_SMM_GUID": [
        3451918622,
        6289,
        16665,
        129,
        126,
        11,
        106,
        54,
        133,
        165,
        17,
    ],
    "LENOVO_SYSTEM_ACPI_SMI_SERVICES_DXE2_GUID": [
        3482740983,
        45296,
        19839,
        180,
        30,
        174,
        199,
        148,
        238,
        199,
        252,
    ],
    "LENOVO_PLATFORM_HII_ADVANCED_DXE_GUID": [
        3488584900,
        16743,
        18026,
        136,
        147,
        135,
        121,
        69,
        157,
        250,
        134,
    ],
    "LENOVO_VARIABLE_SMM_GUID": [
        3575212162,
        43376,
        17680,
        143,
        185,
        215,
        88,
        59,
        105,
        6,
        231,
    ],
    "LENOVO_SYSTEM_FORM_BROWSER_SIMPLE_TEXT_VIEW_DXE_GUID": [
        3599230073,
        56119,
        19406,
        134,
        74,
        2,
        238,
        246,
        129,
        157,
        241,
    ],
    "LENOVO_N25_Q032_FLASH_PART_SMM_GUID": [
        3599366343,
        50004,
        16917,
        170,
        72,
        182,
        173,
        102,
        199,
        126,
        175,
    ],
    "LENOVO_MFG_BENCH_EVENT_DXE_GUID": [
        3627644895,
        13507,
        18977,
        161,
        4,
        54,
        155,
        141,
        79,
        167,
        183,
    ],
    "LENOVO_UDP6_DXE_BIN_GUID": [
        3641886652,
        61592,
        17255,
        146,
        186,
        233,
        17,
        8,
        60,
        123,
        14,
    ],
    "LENOVO_SYSTEM_STATUS_CODE_GENERIC_SMM_GUID": [
        3663567235,
        828,
        18467,
        147,
        73,
        139,
        27,
        106,
        121,
        128,
        48,
    ],
    "LENOVO_MX25_L64_XFLASH_PART_SMM_GUID": [
        3679301914,
        3676,
        16565,
        142,
        70,
        23,
        208,
        68,
        134,
        162,
        27,
    ],
    "LENOVO_MTFTP4_DXE_BIN_GUID": [
        3694543288,
        12200,
        20179,
        188,
        31,
        249,
        150,
        42,
        3,
        69,
        75,
    ],
    "LENOVO_I_FFS_DXE_POLICY_INIT_GUID": [
        3719565990,
        58355,
        20126,
        144,
        163,
        42,
        153,
        18,
        112,
        33,
        156,
    ],
    "LENOVO_WMA_USB_DXE_GUID": [
        3769480574,
        57782,
        17644,
        191,
        46,
        132,
        40,
        116,
        162,
        108,
        131,
    ],
    "LENOVO_SYSTEM_SCSI_OPROM_PASS_THRU_DXE_GUID": [
        3786228562,
        9744,
        19926,
        187,
        143,
        139,
        178,
        176,
        51,
        131,
        163,
    ],
    "LENOVO_PASSWORD_CP_GUID": [
        3841094362,
        9087,
        17740,
        136,
        104,
        252,
        240,
        150,
        207,
        28,
        108,
    ],
    "LENOVO_SYSTEM_DIAGNOSTIC_SPLASH_SCREEN_DXE_GUID": [
        3855662044,
        7100,
        18871,
        168,
        182,
        103,
        170,
        240,
        161,
        205,
        158,
    ],
    "LENOVO_IBEX_PEAK_FLASH_CONTROLLER_SMM_GUID": [
        3897225109,
        31910,
        19247,
        163,
        152,
        177,
        77,
        28,
        103,
        160,
        177,
    ],
    "LENOVO_SMM_SLEEP_EVENT_GUID": [
        3906732218,
        16671,
        19794,
        185,
        37,
        80,
        120,
        84,
        54,
        172,
        129,
    ],
    "LENOVO_AT24_RF08_EEPROM_DXE_GUID": [
        3914184057,
        1563,
        17275,
        131,
        194,
        101,
        192,
        174,
        124,
        20,
        226,
    ],
    "LENOVO_KBD_CONFIG_GUID": [
        3920933158,
        19987,
        16885,
        158,
        76,
        155,
        248,
        139,
        60,
        27,
        12,
    ],
    "LENOVO_SYSTEM_LEGACY_BIOS_DXE_GUID": [
        3928933378,
        12245,
        18271,
        146,
        44,
        152,
        234,
        224,
        55,
        99,
        18,
    ],
    "LENOVO_VPRO_CIRA_HOT_KEY_GUID": [
        3936260833,
        8943,
        19295,
        165,
        238,
        19,
        23,
        177,
        231,
        123,
        16,
    ],
    "LENOVO_OEM_HOOK_GUID": [3937366281, 60461, 18992, 191, 79, 98, 20, 8, 99, 14, 76],
    "LENOVO_SYSTEM_SMBIOS_DXE_GUID": [
        3941964814,
        48454,
        16698,
        154,
        233,
        221,
        159,
        109,
        26,
        146,
        125,
    ],
    "LENOVO_SECURE_KEY_SMM_GUID": [
        3949915124,
        7875,
        19817,
        157,
        130,
        101,
        191,
        108,
        87,
        155,
        52,
    ],
    "LENOVO_ME_CON_OUT_READY_GUID": [
        3965343067,
        25476,
        19456,
        134,
        37,
        44,
        23,
        104,
        185,
        91,
        56,
    ],
    "LENOVO_FINGERPRINT_CP_GUID": [
        3996187942,
        5412,
        19618,
        181,
        109,
        52,
        88,
        48,
        220,
        156,
        219,
    ],
    "LENOVO_SYSTEM_SMM_USB_LEGACY_SMM_GUID": [
        4013146774,
        63052,
        16710,
        173,
        4,
        52,
        120,
        153,
        112,
        44,
        132,
    ],
    "LENOVO_SYSTEM_WATCHDOG_TIMER_DXE_GUID": [
        4036613759,
        29102,
        19510,
        178,
        163,
        220,
        235,
        14,
        178,
        183,
        216,
    ],
    "LENOVO_N25_Q032_FLASH_PART_DXE_GUID": [
        4055748295,
        12753,
        20239,
        175,
        98,
        208,
        42,
        68,
        7,
        96,
        38,
    ],
    "LENOVO_SYSTEM_SECURITY_STUB_DXE_GUID": [
        4059018531,
        15705,
        18568,
        187,
        113,
        234,
        165,
        169,
        102,
        40,
        250,
    ],
    "LENOVO_SVP_MANAGER_SMM_GUID": [
        4100820646,
        19047,
        18546,
        176,
        209,
        212,
        253,
        234,
        11,
        105,
        47,
    ],
    "LENOVO_STARTUP_MENU_DXE_GUID": [
        4100908788,
        18309,
        17315,
        146,
        61,
        127,
        120,
        108,
        60,
        132,
        121,
    ],
    "LENOVO_PLATFORM_S3_SAVE_SMM_GUID": [
        4121718871,
        22096,
        18030,
        182,
        146,
        118,
        164,
        114,
        35,
        239,
        176,
    ],
    "LENOVO_SYSTEM_CMOS_DXE_GUID": [
        4131563991,
        9911,
        18379,
        172,
        200,
        19,
        89,
        81,
        172,
        147,
        248,
    ],
    "LENOVO_FINGERPRINT_SMM_GUID": [
        4148614015,
        63174,
        17344,
        148,
        219,
        70,
        111,
        95,
        16,
        224,
        48,
    ],
    "LENOVO_POWER_MANAGEMENT2_GUID": [
        4151515980,
        22690,
        19956,
        137,
        128,
        86,
        69,
        211,
        158,
        206,
        88,
    ],
    "LENOVO_W25_Q32_FLASH_PART_SMM_GUID": [
        4174016692,
        27269,
        17942,
        139,
        222,
        62,
        197,
        105,
        100,
        74,
        195,
    ],
    "LENOVO_SYSTEM_USB_DATABASE_DXE_GUID": [
        4182180003,
        62623,
        19666,
        191,
        37,
        25,
        226,
        128,
        183,
        46,
        59,
    ],
    "LENOVO_TCG_SMM_GUID": [
        4182377611,
        32708,
        19132,
        133,
        166,
        134,
        22,
        166,
        211,
        205,
        206,
    ],
    "LENOVO_SLP2_SMM_GUID": [
        4199507776,
        47450,
        17401,
        144,
        181,
        120,
        216,
        20,
        124,
        2,
        25,
    ],
    "LENOVO_FIT_DIAGNOSTICS_GUID": [
        4222873731,
        22407,
        17839,
        186,
        220,
        102,
        72,
        84,
        16,
        15,
        32,
    ],
    "LENOVO_SYSTEM_SECURE_FLASH_SLEEP_TRAP_SMM_GUID": [
        4242832462,
        24268,
        19009,
        185,
        14,
        11,
        171,
        9,
        150,
        141,
        2,
    ],
    "LENOVO_TXT_DXE_GUID": [
        4287725090,
        41512,
        17549,
        189,
        170,
        104,
        239,
        204,
        221,
        165,
        211,
    ],
    "LENOVO_EAIA_PEI_GUID": [
        512609513,
        13340,
        16921,
        167,
        144,
        241,
        76,
        40,
        181,
        28,
        238,
    ],
    "LENOVO_PLATFORM_STAGE2_PEI_GUID": [
        591261847,
        12824,
        18354,
        158,
        9,
        254,
        88,
        194,
        178,
        13,
        34,
    ],
    "LENOVO_MISC_GA_IO_PEIM_GUID": [
        913773309,
        27738,
        17920,
        190,
        162,
        154,
        31,
        129,
        170,
        204,
        8,
    ],
    "LENOVO_PEI_MAIN_GUID": [1388337940, 2968, 18796, 188, 59, 4, 181, 2, 17, 214, 128],
    "LENOVO_PLATFORM_STAGE1_PEI_GUID": [
        1402489962,
        6986,
        16756,
        149,
        18,
        166,
        94,
        91,
        200,
        178,
        120,
    ],
    "LENOVO_FLASH_PROTECT_PEI_GUID": [
        1403787592,
        3792,
        17034,
        180,
        221,
        210,
        255,
        242,
        245,
        119,
        111,
    ],
    "LENOVO_SYSTEM_ACPI_TABLES_PEI_GUID": [
        1436701486,
        10618,
        19197,
        144,
        191,
        19,
        155,
        255,
        91,
        180,
        215,
    ],
    "LENOVO_OEM_SEC_PEI_GUID": [
        1495331846,
        22632,
        17653,
        169,
        185,
        109,
        64,
        49,
        72,
        28,
        201,
    ],
    "LENOVO_SYSTEM_USB_BOT_PEI_GUID": [
        2214699078,
        28528,
        17669,
        132,
        113,
        112,
        21,
        180,
        3,
        85,
        227,
    ],
    "LENOVO_SYSTEM_BOOT_MODE_PEI_GUID": [
        2251331032,
        15348,
        17532,
        174,
        16,
        21,
        179,
        174,
        153,
        54,
        253,
    ],
    "LENOVO_PEI_CPU_IO_GUID": [
        2323165447,
        4061,
        19656,
        183,
        186,
        220,
        62,
        19,
        203,
        133,
        36,
    ],
    "LENOVO_SYSTEM_S3_RESUME_PEI_GUID": [
        2345590231,
        57989,
        16744,
        155,
        63,
        9,
        175,
        102,
        201,
        63,
        254,
    ],
    "LENOVO_VIDEO_INIT_PEIM_GUID": [
        2630869420,
        30796,
        17981,
        177,
        69,
        57,
        109,
        112,
        20,
        213,
        89,
    ],
    "LENOVO_AT24_RF08_EEPROM_PEI_GUID": [
        2648253477,
        26423,
        17869,
        130,
        156,
        26,
        194,
        205,
        32,
        200,
        115,
    ],
    "LENOVO_POST_VALIDATOR_PEI_GUID": [
        3116595505,
        61545,
        16780,
        158,
        25,
        49,
        176,
        188,
        3,
        24,
        135,
    ],
    "LENOVO_SYSTEM_FV_FILE_LOADER_GUID": [
        3257022987,
        32979,
        19509,
        137,
        31,
        189,
        12,
        196,
        233,
        144,
        240,
    ],
    "LENOVO_MAIL_BOX_PEI_GUID": [
        3272721920,
        34025,
        20254,
        191,
        68,
        191,
        54,
        227,
        65,
        81,
        88,
    ],
    "LENOVO_EC_IO_PEIM_GUID": [
        3279067084,
        16345,
        16422,
        152,
        144,
        122,
        22,
        40,
        24,
        70,
        32,
    ],
    "LENOVO_MODULE_S3_RESUME_PEIM_GUID": [
        3350021305,
        42869,
        18433,
        183,
        114,
        169,
        100,
        38,
        43,
        185,
        46,
    ],
    "LENOVO_CPU_S3_PEIM_GUID": [
        3362176369,
        31865,
        19441,
        169,
        59,
        6,
        107,
        131,
        13,
        143,
        154,
    ],
    "LENOVO_USER_MANAGER_PEI_GUID": [
        3759193290,
        14907,
        19203,
        188,
        244,
        174,
        31,
        100,
        168,
        92,
        137,
    ],
    "LENOVO_PROTECT_PBPEI_GUID": [
        3930240486,
        24065,
        19566,
        129,
        137,
        193,
        239,
        166,
        172,
        253,
        1,
    ],
    "LENOVO_ISSC_PEI_GUID": [
        3972789634,
        61153,
        17848,
        137,
        38,
        6,
        127,
        64,
        179,
        229,
        94,
    ],
    "LENOVO_PLATFORM_STAGE0_PEI_GUID": [
        3981613134,
        28375,
        17477,
        157,
        93,
        32,
        12,
        50,
        1,
        245,
        30,
    ],
}
