# GUIDs from https://github.com/snare/ida-efiutils/blob/master/efiguids.py

# pylint: disable=duplicate-key
edk_guids = {
    "ACPI_TABLE_GUID": [
        0xEB9D2D30,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "APPLE_REMOVABLE_MEDIA_PROTOCOL_GUID": [
        0x2EA9743A,
        0x23D9,
        0x425E,
        0x87,
        0x2C,
        0xF6,
        0x15,
        0xAA,
        0x19,
        0x57,
        0x88,
    ],
    "ARM_GLOBAL_VARIABLE_PPI_GUID": [
        0xAB1C1816,
        0xD542,
        0x4E6F,
        0x9B,
        0x1E,
        0x8E,
        0xCD,
        0x92,
        0x53,
        0xE2,
        0xE7,
    ],
    "ARM_HOB_GLOBAL_VARIABLE_GUID": [
        0xC3253C90,
        0xA24F,
        0x4599,
        0xA6,
        0x64,
        0x1F,
        0x88,
        0x13,
        0x77,
        0x8F,
        0xC9,
    ],
    "ARM_MP_CORE_INFO_GUID": [
        0xA4EE0728,
        0xE5D7,
        0x4AC5,
        0xB2,
        0x1E,
        0x65,
        0x8E,
        0xD8,
        0x57,
        0xE8,
        0x34,
    ],
    "ARM_MP_CORE_INFO_PPI_GUID": [
        0x6847CC74,
        0xE9EC,
        0x4F8F,
        0xA2,
        0x9D,
        0xAB,
        0x44,
        0xE7,
        0x54,
        0xA8,
        0xFC,
    ],
    "BDS_LIB_STRING_PACKAGE_GUID": [
        0x3B4D9B23,
        0x95AC,
        0x44F6,
        0x9F,
        0xCD,
        0xE,
        0x95,
        0x94,
        0x58,
        0x6C,
        0x72,
    ],
    "BLOCKIO_VENDOR_GUID": [
        0xCF31FAC5,
        0xC24E,
        0x11D2,
        0x85,
        0xF3,
        0x0,
        0xA0,
        0xC9,
        0x3E,
        0xC9,
        0x3B,
    ],
    "BLOCK_MMIO_PROTOCOL_GUID": [
        0x6B558CE3,
        0x69E5,
        0x4C67,
        0xA6,
        0x34,
        0xF7,
        0xFE,
        0x72,
        0xAD,
        0xBE,
        0x84,
    ],
    "BOOT_MAINT_FORMSET_GUID": [
        0x642237C7,
        0x35D4,
        0x472D,
        0x83,
        0x65,
        0x12,
        0xE0,
        0xCC,
        0xF2,
        0x7A,
        0x22,
    ],
    "BOOT_MANAGER_FORMSET_GUID": [
        0x847BC3FE,
        0xB974,
        0x446D,
        0x94,
        0x49,
        0x5A,
        0xD5,
        0x41,
        0x2E,
        0x99,
        0x3B,
    ],
    "CONNECT_CONIN_EVENT_GUID": [
        0xDB4E8151,
        0x57ED,
        0x4BED,
        0x88,
        0x33,
        0x67,
        0x51,
        0xB5,
        0xD1,
        0xA8,
        0xD7,
    ],
    "DEVICE_MANAGER_FORMSET_GUID": [
        0x3EBFA8E6,
        0x511D,
        0x4B5B,
        0xA9,
        0x5F,
        0xFB,
        0x38,
        0x26,
        0xF,
        0x1C,
        0x27,
    ],
    "DP_HII_GUID": [
        0xEB832FD9,
        0x9089,
        0x4898,
        0x83,
        0xC9,
        0x41,
        0x61,
        0x8F,
        0x5C,
        0x48,
        0xB9,
    ],
    "DRIVER_HEALTH_FORMSET_GUID": [
        0xF76E0A70,
        0xB5ED,
        0x4C38,
        0xAC,
        0x9A,
        0xE5,
        0xF5,
        0x4B,
        0xF1,
        0x6E,
        0x34,
    ],
    "DRIVER_SAMPLE_FORMSET_GUID": [
        0xA04A27F4,
        0xDF00,
        0x4D42,
        0xB5,
        0x52,
        0x39,
        0x51,
        0x13,
        0x02,
        0x11,
        0x3D,
    ],
    "DRIVER_SAMPLE_INVENTORY_GUID": [
        0xB3F56470,
        0x6141,
        0x4621,
        0x8F,
        0x19,
        0x70,
        0x4E,
        0x57,
        0x7A,
        0xA9,
        0xE8,
    ],
    "DUET_CONSOLEOUT_CONFIG_GUID": [
        0xED150714,
        0xDF30,
        0x407D,
        0xB2,
        0x4A,
        0x4B,
        0x74,
        0x2F,
        0xD5,
        0xCE,
        0xA2,
    ],
    "DXE_CORE_FILE_NAME_GUID": [
        0xD6A2CB7F,
        0x6A18,
        0x4E2F,
        0xB4,
        0x3B,
        0x99,
        0x20,
        0xA7,
        0x33,
        0x70,
        0x0A,
    ],
    "DXE_SERVICES_TABLE_GUID": [
        0x5AD34BA,
        0x6F02,
        0x4214,
        0x95,
        0x2E,
        0x4D,
        0xA0,
        0x39,
        0x8E,
        0x2B,
        0xB9,
    ],
    "EBL_ADD_COMMAND_PROTOCOL_GUID": [
        0xAEDA2428,
        0x9A22,
        0x4637,
        0x9B,
        0x21,
        0x54,
        0x5E,
        0x28,
        0xFB,
        0xB8,
        0x29,
    ],
    "ECP_PEI_PCI_CFG_PPI_GUID": [
        0xB0EE53D4,
        0xA049,
        0x4A79,
        0xB2,
        0xFF,
        0x19,
        0xD9,
        0xFA,
        0xEF,
        0xAA,
        0x94,
    ],
    "EFI_ABSOLUTE_POINTER_PROTOCOL_GUID": [
        0x8D59D32B,
        0xC655,
        0x4AE9,
        0x9B,
        0x15,
        0xF2,
        0x59,
        0x04,
        0x99,
        0x2A,
        0x43,
    ],
    "EFI_ACPI_20_TABLE_GUID": [
        0x8868E871,
        0xE4F1,
        0x11D3,
        0xBC,
        0x22,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_ACPI_S3_CONTEXT_GUID": [
        0xEF98D3A,
        0x3E33,
        0x497A,
        0xA4,
        0x1,
        0x77,
        0xBE,
        0x3E,
        0xB7,
        0x4F,
        0x38,
    ],
    "EFI_ACPI_S3_SAVE_GUID": [
        0x125F2DE1,
        0xFB85,
        0x440C,
        0xA5,
        0x4C,
        0x4D,
        0x99,
        0x35,
        0x8A,
        0x8D,
        0x38,
    ],
    "EFI_ACPI_SDT_PROTOCOL_GUID": [
        0xEB97088E,
        0xCFDF,
        0x49C6,
        0xBE,
        0x4B,
        0xD9,
        0x6,
        0xA5,
        0xB2,
        0xE,
        0x86,
    ],
    "EFI_ACPI_SUPPORT_GUID": [
        0xDBFF9D55,
        0x89B7,
        0x46DA,
        0xBD,
        0xDF,
        0x67,
        0x7D,
        0x3D,
        0xC0,
        0x24,
        0x1D,
    ],
    "EFI_ACPI_TABLE_GUID": [
        0x8868E871,
        0xE4F1,
        0x11D3,
        0xBC,
        0x22,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_ACPI_TABLE_GUID": [
        0xEB9D2D30,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_ACPI_TABLE_PROTOCOL_GUID": [
        0xFFE06BDD,
        0x6107,
        0x46A6,
        0x7B,
        0xB2,
        0x5A,
        0x9C,
        0x7E,
        0xC5,
        0x27,
        0x5C,
    ],
    "EFI_ACPI_TABLE_STORAGE_GUID": [
        0x7E374E25,
        0x8E01,
        0x4FEE,
        0x87,
        0xF2,
        0x39,
        0xC,
        0x23,
        0xC6,
        0x6,
        0xCD,
    ],
    "EFI_ACPI_VARIABLE_COMPATIBILITY_GUID": [
        0xC020489E,
        0x6DB2,
        0x4EF2,
        0x9A,
        0xA5,
        0xCA,
        0x6,
        0xFC,
        0x11,
        0xD3,
        0x6A,
    ],
    "EFI_ALTERNATE_FV_BLOCK_GUID": [
        0xF496922D,
        0x172F,
        0x4BBC,
        0xA1,
        0xEB,
        0xE,
        0xEB,
        0x94,
        0x9C,
        0x34,
        0x86,
    ],
    "EFI_APRIORI_GUID": [
        0xFC510EE7,
        0xFFDC,
        0x11D4,
        0xBD,
        0x41,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_ARP_PROTOCOL_GUID": [
        0xF4B427BB,
        0xBA21,
        0x4F16,
        0xBC,
        0x4E,
        0x43,
        0xE4,
        0x16,
        0xAB,
        0x61,
        0x9C,
    ],
    "EFI_ARP_SERVICE_BINDING_PROTOCOL_GUID": [
        0xF44C00EE,
        0x1F2C,
        0x4A00,
        0xAA,
        0x9,
        0x1C,
        0x9F,
        0x3E,
        0x8,
        0x0,
        0xA3,
    ],
    "EFI_ATA_PASS_THRU_PROTOCOL_GUID": [
        0x1D3DE7F0,
        0x807,
        0x424F,
        0xAA,
        0x69,
        0x11,
        0xA5,
        0x4E,
        0x19,
        0xA4,
        0x6F,
    ],
    "EFI_AUTHENTICATED_VARIABLE_GUID": [
        0xAAF32C78,
        0x947B,
        0x439A,
        0xA1,
        0x80,
        0x2E,
        0x14,
        0x4E,
        0xC3,
        0x77,
        0x92,
    ],
    "EFI_AUTHENTICATION_CHAP_LOCAL_GUID": [
        0xC280C73E,
        0x15CA,
        0x11DA,
        0xB0,
        0xCA,
        0x00,
        0x10,
        0x83,
        0xFF,
        0xCA,
        0x4D,
    ],
    "EFI_AUTHENTICATION_CHAP_RADIUS_GUID": [
        0xD6062B50,
        0x15CA,
        0x11DA,
        0x92,
        0x19,
        0x00,
        0x10,
        0x83,
        0xFF,
        0xCA,
        0x4D,
    ],
    "EFI_AUTHENTICATION_INFO_PROTOCOL_GUID": [
        0x7671D9D0,
        0x53DB,
        0x4173,
        0xAA,
        0x69,
        0x23,
        0x27,
        0xF2,
        0x1F,
        0x0B,
        0xC7,
    ],
    "EFI_BDS_ARCH_PROTOCOL_GUID": [
        0x665E3FF6,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_BIS_PROTOCOL_GUID": [
        0x0B64AAB0,
        0x5429,
        0x11D4,
        0x98,
        0x16,
        0x00,
        0xA0,
        0xC9,
        0x1F,
        0xAD,
        0xCF,
    ],
    "EFI_BLOCK_IO2_PROTOCOL_GUID": [
        0xA77B2472,
        0xE282,
        0x4E9F,
        0xA2,
        0x45,
        0xC2,
        0xC0,
        0xE2,
        0x7B,
        0xBC,
        0xC1,
    ],
    "EFI_BLOCK_IO_PROTOCOL_GUID": [
        0x964E5B21,
        0x6459,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_BOOT_LOGO_PROTOCOL_GUID": [
        0xCDEA2BD3,
        0xFC25,
        0x4C1C,
        0xB9,
        0x7C,
        0xB3,
        0x11,
        0x86,
        0x6,
        0x49,
        0x90,
    ],
    "EFI_BOOT_SCRIPT_EXECUTOR_CONTEXT_GUID": [
        0x79CB58C4,
        0xAC51,
        0x442F,
        0xAF,
        0xD7,
        0x98,
        0xE4,
        0x7D,
        0x2E,
        0x99,
        0x8,
    ],
    "EFI_BOOT_SCRIPT_EXECUTOR_VARIABLE_GUID": [
        0x3079818C,
        0x46D4,
        0x4A73,
        0xAE,
        0xF3,
        0xE3,
        0xE4,
        0x6C,
        0xF1,
        0xEE,
        0xDB,
    ],
    "EFI_BOOT_SCRIPT_SAVE_PROTOCOL_GUID": [
        0x470E1529,
        0xB79E,
        0x4E32,
        0xA0,
        0xFE,
        0x6A,
        0x15,
        0x6D,
        0x29,
        0xF9,
        0xB2,
    ],
    "EFI_BUS_SPECIFIC_DRIVER_OVERRIDE_PROTOCOL_GUID": [
        0x3BC1B285,
        0x8A15,
        0x4A82,
        0xAA,
        0xBF,
        0x4D,
        0x7D,
        0x13,
        0xFB,
        0x32,
        0x65,
    ],
    "EFI_CACHE_SUBCLASS_GUID": [
        0x7F0013A7,
        0xDC79,
        0x4B22,
        0x80,
        0x99,
        0x11,
        0xF7,
        0x5F,
        0xDC,
        0x82,
        0x9D,
    ],
    "EFI_CAPSULE_ARCH_PROTOCOL_GUID": [
        0x5053697E,
        0x2CBC,
        0x4819,
        0x90,
        0xD9,
        0x05,
        0x80,
        0xDE,
        0xEE,
        0x57,
        0x54,
    ],
    "EFI_CAPSULE_ARCH_PROTOCOL_GUID": [
        0x5053697E,
        0x2CBC,
        0x4819,
        0x90,
        0xD9,
        0x5,
        0x80,
        0xDE,
        0xEE,
        0x57,
        0x54,
    ],
    "EFI_CAPSULE_GUID": [
        0x3B6686BD,
        0x0D76,
        0x4030,
        0xB7,
        0x0E,
        0xB5,
        0x51,
        0x9E,
        0x2F,
        0xC5,
        0xA0,
    ],
    "EFI_CAPSULE_INFO_GUID": [
        0x8B34EAC7,
        0x2690,
        0x460B,
        0x8B,
        0xA5,
        0xD5,
        0xCF,
        0x32,
        0x83,
        0x17,
        0x35,
    ],
    "EFI_CAPSULE_VENDOR_GUID": [
        0x711C703F,
        0xC285,
        0x4B10,
        0xA3,
        0xB0,
        0x36,
        0xEC,
        0xBD,
        0x3C,
        0x8B,
        0xE2,
    ],
    "EFI_CERT_RSA2048_GUID": [
        0x3C5766E8,
        0x269C,
        0x4E34,
        0xAA,
        0x14,
        0xED,
        0x77,
        0x6E,
        0x85,
        0xB3,
        0xB6,
    ],
    "EFI_CERT_RSA2048_SHA1_GUID": [
        0x67F8444F,
        0x8743,
        0x48F1,
        0xA3,
        0x28,
        0x1E,
        0xAA,
        0xB8,
        0x73,
        0x60,
        0x80,
    ],
    "EFI_CERT_RSA2048_SHA256_GUID": [
        0xE2B36190,
        0x879B,
        0x4A3D,
        0xAD,
        0x8D,
        0xF2,
        0xE7,
        0xBB,
        0xA3,
        0x27,
        0x84,
    ],
    "EFI_CERT_SHA1_GUID": [
        0x826CA512,
        0xCF10,
        0x4AC9,
        0xB1,
        0x87,
        0xBE,
        0x1,
        0x49,
        0x66,
        0x31,
        0xBD,
    ],
    "EFI_CERT_SHA224_GUID": [
        0xB6E5233,
        0xA65C,
        0x44C9,
        0x94,
        0x7,
        0xD9,
        0xAB,
        0x83,
        0xBF,
        0xC8,
        0xBD,
    ],
    "EFI_CERT_SHA256_GUID": [
        0xC1C41626,
        0x504C,
        0x4092,
        0xAC,
        0xA9,
        0x41,
        0xF9,
        0x36,
        0x93,
        0x43,
        0x28,
    ],
    "EFI_CERT_SHA384_GUID": [
        0xFF3E5307,
        0x9FD0,
        0x48C9,
        0x85,
        0xF1,
        0x8A,
        0xD5,
        0x6C,
        0x70,
        0x1E,
        0x1,
    ],
    "EFI_CERT_SHA512_GUID": [
        0x93E0FAE,
        0xA6C4,
        0x4F50,
        0x9F,
        0x1B,
        0xD4,
        0x1E,
        0x2B,
        0x89,
        0xC1,
        0x9A,
    ],
    "EFI_CERT_TYPE_PKCS7_GUID": [
        0x4AAFD29D,
        0x68DF,
        0x49EE,
        0x8A,
        0xA9,
        0x34,
        0x7D,
        0x37,
        0x56,
        0x65,
        0xA7,
    ],
    "EFI_CERT_TYPE_RSA2048_SHA256_GUID": [
        0xA7717414,
        0xC616,
        0x4977,
        0x94,
        0x20,
        0x84,
        0x47,
        0x12,
        0xA7,
        0x35,
        0xBF,
    ],
    "EFI_CERT_X509_GUID": [
        0xA5C059A1,
        0x94E4,
        0x4AA7,
        0x87,
        0xB5,
        0xAB,
        0x15,
        0x5C,
        0x2B,
        0xF0,
        0x72,
    ],
    "EFI_COMPATIBLE_MEMORY_TESTED_PROTOCOL_GUID": [
        0x64C475EF,
        0x344B,
        0x492C,
        0x93,
        0xAD,
        0xAB,
        0x9E,
        0xB4,
        0x39,
        0x50,
        0x4,
    ],
    "EFI_COMPONENT_NAME2_PROTOCOL_GUID": [
        0x6A7A5CFF,
        0xE8D9,
        0x4F70,
        0xBA,
        0xDA,
        0x75,
        0xAB,
        0x30,
        0x25,
        0xCE,
        0x14,
    ],
    "EFI_COMPONENT_NAME_PROTOCOL_GUID": [
        0x107A772C,
        0xD5E1,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_CONFIG_FILE_NAME_GUID": [
        0x98B8D59B,
        0xE8BA,
        0x48EE,
        0x98,
        0xDD,
        0xC2,
        0x95,
        0x39,
        0x2F,
        0x1E,
        0xDB,
    ],
    "EFI_CONSOLE_CONTROL_PROTOCOL_GUID": [
        0xF42F7782,
        0x12E,
        0x4C12,
        0x99,
        0x56,
        0x49,
        0xF9,
        0x43,
        0x4,
        0xF7,
        0x21,
    ],
    "EFI_CONSOLE_IN_DEVICE_GUID": [
        0xD3B36F2B,
        0xD551,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_CONSOLE_OUT_DEVICE_GUID": [
        0xD3B36F2C,
        0xD551,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_CPU_ARCH_PROTOCOL_GUID": [
        0x26BACCB1,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_CPU_IO2_PROTOCOL_GUID": [
        0xAD61F191,
        0xAE5F,
        0x4C0E,
        0xB9,
        0xFA,
        0xE8,
        0x69,
        0xD2,
        0x88,
        0xC6,
        0x4F,
    ],
    "EFI_CPU_IO_PROTOCOL_GUID": [
        0xB0732526,
        0x38C8,
        0x4B40,
        0x88,
        0x77,
        0x61,
        0xC7,
        0xB0,
        0x6A,
        0xAC,
        0x45,
    ],
    "EFI_CRC32_GUIDED_SECTION_EXTRACTION_GUID": [
        0xFC1BCDB0,
        0x7D31,
        0x49AA,
        0x93,
        0x6A,
        0xA4,
        0x60,
        0x0D,
        0x9D,
        0xD0,
        0x83,
    ],
    "EFI_CRC32_GUIDED_SECTION_EXTRACTION_PROTOCOL_GUID": [
        0xFC1BCDB0,
        0x7D31,
        0x49AA,
        0x93,
        0x6A,
        0xA4,
        0x60,
        0x0D,
        0x9D,
        0xD0,
        0x83,
    ],
    "EFI_CUSTOMIZED_DECOMPRESS_PROTOCOL_GUID": [
        0x9A44198E,
        0xA4A2,
        0x44E6,
        0x8A,
        0x1F,
        0x39,
        0xBE,
        0xFD,
        0xAC,
        0x89,
        0x6F,
    ],
    "EFI_DATA_HUB_PROTOCOL_GUID": [
        0xAE80D021,
        0x618E,
        0x11D4,
        0xBC,
        0xD7,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_DATA_HUB_STATUS_CODE_RECORD_GUID": [
        0xD083E94C,
        0x6560,
        0x42E4,
        0xB6,
        0xD4,
        0x2D,
        0xF7,
        0x5A,
        0xDF,
        0x6A,
        0x2A,
    ],
    "EFI_DEBUGPORT_PROTOCOL_GUID": [
        0xEBA4E8D2,
        0x3858,
        0x41EC,
        0xA2,
        0x81,
        0x26,
        0x47,
        0xBA,
        0x96,
        0x60,
        0xD0,
    ],
    "EFI_DEBUG_AGENT_GUID": [
        0x865A5A9B,
        0xB85D,
        0x474C,
        0x84,
        0x55,
        0x65,
        0xD1,
        0xBE,
        0x84,
        0x4B,
        0xE2,
    ],
    "EFI_DEBUG_ASSERT_PROTOCOL_GUID": [
        0xBE499C92,
        0x7D4B,
        0x11D4,
        0xBC,
        0xEE,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_DEBUG_IMAGE_INFO_TABLE_GUID": [
        0x49152E77,
        0x1ADA,
        0x4764,
        0xB7,
        0xA2,
        0x7A,
        0xFE,
        0xFE,
        0xD9,
        0x5E,
        0x8B,
    ],
    "EFI_DEBUG_MASK_PROTOCOL_GUID": [
        0x4C8A2451,
        0xC207,
        0x405B,
        0x96,
        0x94,
        0x99,
        0xEA,
        0x13,
        0x25,
        0x13,
        0x41,
    ],
    "EFI_DEBUG_SERIAL_IO_PROTOCOL_GUID": [
        0xE683DC4F,
        0x9ED,
        0x4F22,
        0x86,
        0x6B,
        0x8E,
        0x40,
        0x46,
        0x94,
        0x7C,
        0x6C,
    ],
    "EFI_DEBUG_SUPPORT_PERIODIC_CALLBACK_PROTOCOL_GUID": [
        0x9546E07C,
        0x2CBB,
        0x4C88,
        0x98,
        0x6C,
        0xCD,
        0x34,
        0x10,
        0x86,
        0xF0,
        0x44,
    ],
    "EFI_DEBUG_SUPPORT_PROTOCOL_GUID": [
        0x2755590C,
        0x6F3C,
        0x42FA,
        0x9E,
        0xA4,
        0xA3,
        0xBA,
        0x54,
        0x3C,
        0xDA,
        0x25,
    ],
    "EFI_DECOMPRESS_PROTOCOL_GUID": [
        0xD8117CFE,
        0x94A6,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_DEFAULT_BMP_LOGO_GUID": [
        0x7BB28B99,
        0x61BB,
        0x11D5,
        0x9A,
        0x5D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_DEFERRED_IMAGE_LOAD_PROTOCOL_GUID": [
        0x15853D7C,
        0x3DDF,
        0x43E0,
        0xA1,
        0xCB,
        0xEB,
        0xF8,
        0x5B,
        0x8F,
        0x87,
        0x2C,
    ],
    "EFI_DEVICE_IO_PROTOCOL_GUID": [
        0xAF6AC311,
        0x84C3,
        0x11D2,
        0x8E,
        0x3C,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_DEVICE_PATH_FROM_TEXT_PROTOCOL_GUID": [
        0x5C99A21,
        0xC70F,
        0x4AD2,
        0x8A,
        0x5F,
        0x35,
        0xDF,
        0x33,
        0x43,
        0xF5,
        0x1E,
    ],
    "EFI_DEVICE_PATH_PROTOCOL_GUID": [
        0x9576E91,
        0x6D3F,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_DEVICE_PATH_TO_TEXT_PROTOCOL_GUID": [
        0x8B843E20,
        0x8132,
        0x4852,
        0x90,
        0xCC,
        0x55,
        0x1A,
        0x4E,
        0x4A,
        0x7F,
        0x1C,
    ],
    "EFI_DEVICE_PATH_UTILITIES_PROTOCOL_GUID": [
        0x379BE4E,
        0xD706,
        0x437D,
        0xB0,
        0x37,
        0xED,
        0xB8,
        0x2F,
        0xB7,
        0x72,
        0xA4,
    ],
    "EFI_DHCP4_PROTOCOL_GUID": [
        0x8A219718,
        0x4EF5,
        0x4761,
        0x91,
        0xC8,
        0xC0,
        0xF0,
        0x4B,
        0xDA,
        0x9E,
        0x56,
    ],
    "EFI_DHCP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0x9D9A39D8,
        0xBD42,
        0x4A73,
        0xA4,
        0xD5,
        0x8E,
        0xE9,
        0x4B,
        0xE1,
        0x13,
        0x80,
    ],
    "EFI_DHCP6_PROTOCOL_GUID": [
        0x87C8BAD7,
        0x595,
        0x4053,
        0x82,
        0x97,
        0xDE,
        0xDE,
        0x39,
        0x5F,
        0x5D,
        0x5B,
    ],
    "EFI_DHCP6_SERVICE_BINDING_PROTOCOL_GUID": [
        0x9FB9A8A1,
        0x2F4A,
        0x43A6,
        0x88,
        0x9C,
        0xD0,
        0xF7,
        0xB6,
        0xC4,
        0x7A,
        0xD5,
    ],
    "EFI_DISK_INFO_AHCI_INTERFACE_GUID": [
        0x9E498932,
        0x4ABC,
        0x45AF,
        0xA3,
        0x4D,
        0x2,
        0x47,
        0x78,
        0x7B,
        0xE7,
        0xC6,
    ],
    "EFI_DISK_INFO_IDE_INTERFACE_GUID": [
        0x5E948FE3,
        0x26D3,
        0x42B5,
        0xAF,
        0x17,
        0x61,
        0x2,
        0x87,
        0x18,
        0x8D,
        0xEC,
    ],
    "EFI_DISK_INFO_PROTOCOL_GUID": [
        0xD432A67F,
        0x14DC,
        0x484B,
        0xB3,
        0xBB,
        0x3F,
        0x2,
        0x91,
        0x84,
        0x93,
        0x27,
    ],
    "EFI_DISK_INFO_SCSI_INTERFACE_GUID": [
        0x8F74BAA,
        0xEA36,
        0x41D9,
        0x95,
        0x21,
        0x21,
        0xA7,
        0xF,
        0x87,
        0x80,
        0xBC,
    ],
    "EFI_DISK_INFO_USB_INTERFACE_GUID": [
        0xCB871572,
        0xC11A,
        0x47B5,
        0xB4,
        0x92,
        0x67,
        0x5E,
        0xAF,
        0xA7,
        0x77,
        0x27,
    ],
    "EFI_DISK_IO_PROTOCOL_GUID": [
        0xCE345171,
        0xBA0B,
        0x11D2,
        0x8E,
        0x4F,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_DPC_PROTOCOL_GUID": [
        0x480F8AE9,
        0xC46,
        0x4AA9,
        0xBC,
        0x89,
        0xDB,
        0x9F,
        0xBA,
        0x61,
        0x98,
        0x6,
    ],
    "EFI_DRIVER_BINDING_PROTOCOL_GUID": [
        0x18A031AB,
        0xB443,
        0x4D1A,
        0xA5,
        0xC0,
        0xC,
        0x9,
        0x26,
        0x1E,
        0x9F,
        0x71,
    ],
    "EFI_DRIVER_CONFIGURATION2_PROTOCOL_GUID": [
        0xBFD7DC1D,
        0x24F1,
        0x40D9,
        0x82,
        0xE7,
        0x2E,
        0x09,
        0xBB,
        0x6B,
        0x4E,
        0xBE,
    ],
    "EFI_DRIVER_CONFIGURATION_PROTOCOL_GUID": [
        0x107A772B,
        0xD5E1,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_DRIVER_DIAGNOSTICS2_PROTOCOL_GUID": [
        0x4D330321,
        0x025F,
        0x4AAC,
        0x90,
        0xD8,
        0x5E,
        0xD9,
        0x0,
        0x17,
        0x3B,
        0x63,
    ],
    "EFI_DRIVER_DIAGNOSTICS2_PROTOCOL_GUID": [
        0x4D330321,
        0x025F,
        0x4AAC,
        0x90,
        0xD8,
        0x5E,
        0xD9,
        0x00,
        0x17,
        0x3B,
        0x63,
    ],
    "EFI_DRIVER_DIAGNOSTICS_PROTOCOL_GUID": [
        0x0784924F,
        0xE296,
        0x11D4,
        0x9A,
        0x49,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_DRIVER_FAMILY_OVERRIDE_PROTOCOL_GUID": [
        0xB1EE129E,
        0xDA36,
        0x4181,
        0x91,
        0xF8,
        0x4,
        0xA4,
        0x92,
        0x37,
        0x66,
        0xA7,
    ],
    "EFI_DRIVER_HEALTH_PROTOCOL_GUID": [
        0x2A534210,
        0x9280,
        0x41D8,
        0xAE,
        0x79,
        0xCA,
        0xDA,
        0x1,
        0xA2,
        0xB1,
        0x27,
    ],
    "EFI_DRIVER_SUPPORTED_EFI_VERSION_PROTOCOL_GUID": [
        0x5C198761,
        0x16A8,
        0x4E69,
        0x97,
        0x2C,
        0x89,
        0xD6,
        0x79,
        0x54,
        0xF8,
        0x1D,
    ],
    "EFI_DXE_IPL_PPI_GUID": [
        0xAE8CE5D,
        0xE448,
        0x4437,
        0xA8,
        0xD7,
        0xEB,
        0xF5,
        0xF1,
        0x94,
        0xF7,
        0x31,
    ],
    "EFI_DXE_SERVICES_TABLE_GUID": [
        0x5AD34BA,
        0x6F02,
        0x4214,
        0x95,
        0x2E,
        0x4D,
        0xA0,
        0x39,
        0x8E,
        0x2B,
        0xB9,
    ],
    "EFI_DXE_SMM_READY_TO_LOCK_PROTOCOL_GUID": [
        0x60FF8964,
        0xE906,
        0x41D0,
        0xAF,
        0xED,
        0xF2,
        0x41,
        0xE9,
        0x74,
        0xE0,
        0x8E,
    ],
    "EFI_EAP_MANAGEMENT_PROTOCOL_GUID": [
        0xBB62E663,
        0x625D,
        0x40B2,
        0xA0,
        0x88,
        0xBB,
        0xE8,
        0x36,
        0x23,
        0xA2,
        0x45,
    ],
    "EFI_EAP_PROTOCOL_GUID": [
        0x5D9F96DB,
        0xE731,
        0x4CAA,
        0xA0,
        0xD,
        0x72,
        0xE1,
        0x87,
        0xCD,
        0x77,
        0x62,
    ],
    "EFI_EBC_INTERPRETER_PROTOCOL_GUID": [
        0x13AC6DD1,
        0x73D0,
        0x11D4,
        0xB0,
        0x6B,
        0x00,
        0xAA,
        0x00,
        0xBD,
        0x6D,
        0xE7,
    ],
    "EFI_EBC_SIMPLE_DEBUGGER_PROTOCOL_GUID": [
        0x2A72D11E,
        0x7376,
        0x40F6,
        0x9C,
        0x68,
        0x23,
        0xFA,
        0x2F,
        0xE3,
        0x63,
        0xF1,
    ],
    "EFI_EBC_VM_TEST_PROTOCOL_GUID": [
        0xAAEACCFD,
        0xF27B,
        0x4C17,
        0xB6,
        0x10,
        0x75,
        0xCA,
        0x1F,
        0x2D,
        0xFB,
        0x52,
    ],
    "EFI_EBC_VM_TEST_PROTOCOL_GUID": [
        0xAAEACCFD,
        0xF27B,
        0x4C17,
        0xB6,
        0x10,
        0x75,
        0xCA,
        0x1F,
        0x2D,
        0xFB,
        0x52,
    ],
    "EFI_EDID_ACTIVE_PROTOCOL_GUID": [
        0xBD8C1056,
        0x9F36,
        0x44EC,
        0x92,
        0xA8,
        0xA6,
        0x33,
        0x7F,
        0x81,
        0x79,
        0x86,
    ],
    "EFI_EDID_DISCOVERED_PROTOCOL_GUID": [
        0x1C0C34F6,
        0xD380,
        0x41FA,
        0xA0,
        0x49,
        0x8A,
        0xD0,
        0x6C,
        0x1A,
        0x66,
        0xAA,
    ],
    "EFI_EDID_DISCOVERED_PROTOCOL_GUID": [
        0x1C0C34F6,
        0xD380,
        0x41FA,
        0xA0,
        0x49,
        0x8A,
        0xD0,
        0x6C,
        0x1A,
        0x66,
        0xAA,
    ],
    "EFI_EDID_OVERRIDE_PROTOCOL_GUID": [
        0x48ECB431,
        0xFB72,
        0x45C0,
        0xA9,
        0x22,
        0xF4,
        0x58,
        0xFE,
        0x4,
        0xB,
        0xD5,
    ],
    "EFI_EMU_PHYSICAL_DISK_GUID": [
        0xF2BA331A,
        0x8985,
        0x11DB,
        0xA4,
        0x06,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_EMU_SYSTEM_CONFIG_GUID": [
        0x9C4FB516,
        0x3A1E,
        0xD847,
        0xA1,
        0xA1,
        0x70,
        0x58,
        0xB6,
        0x98,
        0x67,
        0x32,
    ],
    "EFI_EMU_VIRTUAL_DISK_GUID": [
        0xF2BA331A,
        0x8985,
        0x11DB,
        0xA4,
        0x06,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_END_OF_DXE_EVENT_GROUP_GUID": [
        0x2CE967A,
        0xDD7E,
        0x4FFC,
        0x9E,
        0xE7,
        0x81,
        0x0C,
        0xF0,
        0x47,
        0x8,
        0x80,
    ],
    "EFI_END_OF_DXE_EVENT_GROUP_GUID": [
        0x2CE967A,
        0xDD7E,
        0x4FFC,
        0x9E,
        0xE7,
        0x81,
        0xC,
        0xF0,
        0x47,
        0x8,
        0x80,
    ],
    "EFI_ERROR_SECTION_DIRECTED_IO_DMAR_GUID": [
        0x71761D37,
        0x32B2,
        0x45CD,
        0xA7,
        0xD0,
        0xB0,
        0xFE,
        0xDD,
        0x93,
        0xE8,
        0xCF,
    ],
    "EFI_ERROR_SECTION_DMAR_GENERIC_GUID": [
        0x5B51FEF7,
        0xC79D,
        0x4434,
        0x8F,
        0x1B,
        0xAA,
        0x62,
        0xDE,
        0x3E,
        0x2C,
        0x64,
    ],
    "EFI_ERROR_SECTION_FW_ERROR_RECORD_GUID": [
        0x81212A96,
        0x09ED,
        0x4996,
        0x94,
        0x71,
        0x8D,
        0x72,
        0x9C,
        0x8E,
        0x69,
        0xED,
    ],
    "EFI_ERROR_SECTION_IOMMU_DMAR_GUID": [
        0x036F84E1,
        0x7F37,
        0x428C,
        0xA7,
        0x9E,
        0x57,
        0x5F,
        0xDF,
        0xAA,
        0x84,
        0xEC,
    ],
    "EFI_ERROR_SECTION_PCIE_GUID": [
        0xD995E954,
        0xBBC1,
        0x430F,
        0xAD,
        0x91,
        0xB4,
        0x4D,
        0xCB,
        0x3C,
        0x6F,
        0x35,
    ],
    "EFI_ERROR_SECTION_PCI_DEVICE_GUID": [
        0xEB5E4685,
        0xCA66,
        0x4769,
        0xB6,
        0xA2,
        0x26,
        0x06,
        0x8B,
        0x00,
        0x13,
        0x26,
    ],
    "EFI_ERROR_SECTION_PCI_PCIX_BUS_GUID": [
        0xC5753963,
        0x3B84,
        0x4095,
        0xBF,
        0x78,
        0xED,
        0xDA,
        0xD3,
        0xF9,
        0xC9,
        0xDD,
    ],
    "EFI_ERROR_SECTION_PLATFORM_MEMORY_GUID": [
        0xA5BC1114,
        0x6F64,
        0x4EDE,
        0xB8,
        0x63,
        0x3E,
        0x83,
        0xED,
        0x7C,
        0x83,
        0xB1,
    ],
    "EFI_ERROR_SECTION_PROCESSOR_GENERIC_GUID": [
        0x9876CCAD,
        0x47B4,
        0x4BDB,
        0xB6,
        0x5E,
        0x16,
        0xF1,
        0x93,
        0xC4,
        0xF3,
        0xDB,
    ],
    "EFI_ERROR_SECTION_PROCESSOR_SPECIFIC_GUID": [
        0xDC3EA0B0,
        0xA144,
        0x4797,
        0xB9,
        0x5B,
        0x53,
        0xFA,
        0x24,
        0x2B,
        0x6E,
        0x1D,
    ],
    "EFI_EVENT_GROUP_DXE_DISPATCH_GUID": [
        0x7081E22F,
        0xCAC6,
        0x4053,
        0x94,
        0x68,
        0x67,
        0x57,
        0x82,
        0xCF,
        0x88,
        0xE5,
    ],
    "EFI_EVENT_LEGACY_BOOT_GUID": [
        0x2A571201,
        0x4966,
        0x47F6,
        0x8B,
        0x86,
        0xF3,
        0x1E,
        0x41,
        0xF3,
        0x2F,
        0x10,
    ],
    "EFI_EVENT_NOTIFICATION_TYEP_BOOT_GUID": [
        0x3D61A466,
        0xAB40,
        0x409A,
        0xA6,
        0x98,
        0xF3,
        0x62,
        0xD4,
        0x64,
        0xB3,
        0x8F,
    ],
    "EFI_EVENT_NOTIFICATION_TYEP_CMC_GUID": [
        0x2DCE8BB1,
        0xBDD7,
        0x450E,
        0xB9,
        0xAD,
        0x9C,
        0xF4,
        0xEB,
        0xD4,
        0xF8,
        0x90,
    ],
    "EFI_EVENT_NOTIFICATION_TYEP_CPE_GUID": [
        0x4E292F96,
        0xD843,
        0x4A55,
        0xA8,
        0xC2,
        0xD4,
        0x81,
        0xF2,
        0x7E,
        0xBE,
        0xEE,
    ],
    "EFI_EVENT_NOTIFICATION_TYEP_DMAR_GUID": [
        0x667DD791,
        0xC6B3,
        0x4C27,
        0x8A,
        0x6B,
        0x0F,
        0x8E,
        0x72,
        0x2D,
        0xEB,
        0x41,
    ],
    "EFI_EVENT_NOTIFICATION_TYEP_INIT_GUID": [
        0xCC5263E8,
        0x9308,
        0x454A,
        0x89,
        0xD0,
        0x34,
        0x0B,
        0xD3,
        0x9B,
        0xC9,
        0x8E,
    ],
    "EFI_EVENT_NOTIFICATION_TYEP_MCE_GUID": [
        0xE8F56FFE,
        0x919C,
        0x4CC5,
        0xBA,
        0x88,
        0x65,
        0xAB,
        0xE1,
        0x49,
        0x13,
        0xBB,
    ],
    "EFI_EVENT_NOTIFICATION_TYEP_NMI_GUID": [
        0x5BAD89FF,
        0xB7E6,
        0x42C9,
        0x81,
        0x4A,
        0xCF,
        0x24,
        0x85,
        0xD6,
        0xE9,
        0x8A,
    ],
    "EFI_EVENT_NOTIFICATION_TYEP_PCIE_GUID": [
        0xCF93C01F,
        0x1A16,
        0x4DFC,
        0xB8,
        0xBC,
        0x9C,
        0x4D,
        0xAF,
        0x67,
        0xC1,
        0x04,
    ],
    "EFI_EXTENDED_SAL_BASE_IO_SERVICES_PROTOCOL_GUID": [
        0x5AEA42B5,
        0x31E1,
        0x4515,
        0xBC,
        0x31,
        0xB8,
        0xD5,
        0x25,
        0x75,
        0x65,
        0xA6,
    ],
    "EFI_EXTENDED_SAL_BASE_SERVICES_PROTOCOL_GUID": [
        0xD9E9FA06,
        0x0FE0,
        0x41C3,
        0x96,
        0xFB,
        0x83,
        0x42,
        0x5A,
        0x33,
        0x94,
        0xF8,
    ],
    "EFI_EXTENDED_SAL_CACHE_SERVICES_PROTOCOL_GUID": [
        0xEDC9494,
        0x2743,
        0x4BA5,
        0x88,
        0x18,
        0x0A,
        0xEF,
        0x52,
        0x13,
        0xF1,
        0x88,
    ],
    "EFI_EXTENDED_SAL_ELOG_SERVICES_PROTOCOL_GUID": [
        0xD5E4EE5F,
        0x3E0A,
        0x453C,
        0xA7,
        0x25,
        0xB6,
        0x92,
        0xBB,
        0x6,
        0x36,
        0x5A,
    ],
    "EFI_EXTENDED_SAL_FV_BLOCK_SERVICES_PROTOCOL_GUID": [
        0xA2271DF1,
        0xBCBB,
        0x4F1D,
        0x98,
        0xA9,
        0x06,
        0xBC,
        0x17,
        0x2F,
        0x07,
        0x1A,
    ],
    "EFI_EXTENDED_SAL_LOCK_SERVICES_PROTOCOL_GUID": [
        0x76B75C23,
        0xFE4F,
        0x4E17,
        0xA2,
        0xAD,
        0x1A,
        0x65,
        0x3D,
        0xBB,
        0x49,
        0x4A,
    ],
    "EFI_EXTENDED_SAL_MCA_LOG_SERVICES_PROTOCOL_GUID": [
        0xCB3FD86E,
        0x38A3,
        0x4C03,
        0x9A,
        0x5C,
        0x90,
        0xCF,
        0xA3,
        0xA2,
        0xAB,
        0x7A,
    ],
    "EFI_EXTENDED_SAL_MCA_SERVICES_PROTOCOL_GUID": [
        0x2A591128,
        0x6CC7,
        0x42B1,
        0x8A,
        0xF0,
        0x58,
        0x93,
        0x3B,
        0x68,
        0x2D,
        0xBB,
    ],
    "EFI_EXTENDED_SAL_MP_SERVICES_PROTOCOL_GUID": [
        0x697D81A2,
        0xCF18,
        0x4DC0,
        0x9E,
        0x0D,
        0x06,
        0x11,
        0x3B,
        0x61,
        0x8A,
        0x3F,
    ],
    "EFI_EXTENDED_SAL_MTC_SERVICES_PROTOCOL_GUID": [
        0x899AFD18,
        0x75E8,
        0x408B,
        0xA4,
        0x1A,
        0x6E,
        0x2E,
        0x7E,
        0xCD,
        0xF4,
        0x54,
    ],
    "EFI_EXTENDED_SAL_PAL_SERVICES_PROTOCOL_GUID": [
        0xE1CD9D21,
        0x0FC2,
        0x438D,
        0x97,
        0x03,
        0x04,
        0xE6,
        0x6D,
        0x96,
        0x1E,
        0x57,
    ],
    "EFI_EXTENDED_SAL_PCI_SERVICES_PROTOCOL_GUID": [
        0xA46B1A31,
        0xAD66,
        0x4905,
        0x92,
        0xF6,
        0x2B,
        0x46,
        0x59,
        0xDC,
        0x30,
        0x63,
    ],
    "EFI_EXTENDED_SAL_RESET_SERVICES_PROTOCOL_GUID": [
        0x7D019990,
        0x8CE1,
        0x46F5,
        0xA7,
        0x76,
        0x3C,
        0x51,
        0x98,
        0x67,
        0x6A,
        0xA0,
    ],
    "EFI_EXTENDED_SAL_RTC_SERVICES_PROTOCOL_GUID": [
        0x7E97A470,
        0xEFDB,
        0x4D02,
        0x8F,
        0xCE,
        0x61,
        0x90,
        0xD2,
        0x7B,
        0xA2,
        0x96,
    ],
    "EFI_EXTENDED_SAL_SENSOR_SERVICES_PROTOCOL_GUID": [
        0x4A153B6E,
        0x85A1,
        0x4982,
        0x98,
        0xF4,
        0x6A,
        0x8C,
        0xFC,
        0xA4,
        0xAB,
        0xA1,
    ],
    "EFI_EXTENDED_SAL_SM_COM_LAYER_SERVICES_PROTOCOL_GUID": [
        0x4356799,
        0x81B7,
        0x4E08,
        0xA3,
        0x8D,
        0xD9,
        0x78,
        0xFA,
        0x47,
        0xBA,
        0x42,
    ],
    "EFI_EXTENDED_SAL_SST_GUID": [
        0x38802700,
        0x868A,
        0x4B4E,
        0x81,
        0xD4,
        0x4F,
        0x1B,
        0xDC,
        0xCF,
        0xB4,
        0x6F,
    ],
    "EFI_EXTENDED_SAL_STALL_SERVICES_PROTOCOL_GUID": [
        0x53A58D06,
        0xAC27,
        0x4D8C,
        0xB5,
        0xE9,
        0xF0,
        0x8A,
        0x80,
        0x65,
        0x41,
        0x70,
    ],
    "EFI_EXTENDED_SAL_STATUS_CODE_SERVICES_PROTOCOL_GUID": [
        0xDBD91D,
        0x55E9,
        0x420F,
        0x96,
        0x39,
        0x5E,
        0x9F,
        0x84,
        0x37,
        0xB4,
        0x4F,
    ],
    "EFI_EXTENDED_SAL_VARIABLE_SERVICES_PROTOCOL_GUID": [
        0x4ECB6C53,
        0xC641,
        0x4370,
        0x8C,
        0xB2,
        0x3B,
        0x0E,
        0x49,
        0x6E,
        0x83,
        0x78,
    ],
    "EFI_EXTENDED_SAL_VIRTUAL_SERVICES_PROTOCOL_GUID": [
        0xC1A74056,
        0x260E,
        0x4871,
        0xA0,
        0x31,
        0xE6,
        0x45,
        0xA6,
        0x5B,
        0x6E,
        0x11,
    ],
    "EFI_EXT_SCSI_PASS_THRU_PROTOCOL_GUID": [
        0x143B7632,
        0xB81B,
        0x4CB7,
        0xAB,
        0xD3,
        0xB6,
        0x25,
        0xA5,
        0xB9,
        0xBF,
        0xFE,
    ],
    "EFI_FAULT_TOLERANT_WRITE_PROTOCOL_GUID": [
        0x3EBD9E82,
        0x2C78,
        0x4DE6,
        0x97,
        0x86,
        0x8D,
        0x4B,
        0xFC,
        0xB7,
        0xC8,
        0x81,
    ],
    "EFI_FFS_VOLUME_TOP_FILE_GUID": [
        0x1BA0062E,
        0xC779,
        0x4582,
        0x85,
        0x66,
        0x33,
        0x6A,
        0xE8,
        0xF7,
        0x8F,
        0x09,
    ],
    "EFI_FILE_SYSTEM_INFO_ID_GUID": [
        0x9576E93,
        0x6D3F,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_FILE_SYSTEM_VOLUME_LABEL_INFO_ID_GUID": [
        0xDB47D7D3,
        0xFE81,
        0x11D3,
        0x9A,
        0x35,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_FIND_FV_PPI_GUID": [
        0x36164812,
        0xA023,
        0x44E5,
        0xBD,
        0x85,
        0x5,
        0xBF,
        0x3C,
        0x77,
        0x0,
        0xAA,
    ],
    "EFI_FIRMWARE_CONTENTS_SIGNED_GUID": [
        0xF9D89E8,
        0x9259,
        0x4F76,
        0xA5,
        0xAF,
        0xC,
        0x89,
        0xE3,
        0x40,
        0x23,
        0xDF,
    ],
    "EFI_FIRMWARE_FILE_SYSTEM2_GUID": [
        0x8C8CE578,
        0x8A3D,
        0x4F1C,
        0x99,
        0x35,
        0x89,
        0x61,
        0x85,
        0xC3,
        0x2D,
        0xD3,
    ],
    "EFI_FIRMWARE_FILE_SYSTEM3_GUID": [
        0x5473C07A,
        0x3DCB,
        0x4DCA,
        0xBD,
        0x6F,
        0x1E,
        0x96,
        0x89,
        0xE7,
        0x34,
        0x9A,
    ],
    "EFI_FIRMWARE_FILE_SYSTEM_GUID": [
        0x7A9354D9,
        0x0468,
        0x444A,
        0x81,
        0xCE,
        0x0B,
        0xF6,
        0x17,
        0xD8,
        0x90,
        0xDF,
    ],
    "EFI_FIRMWARE_MANAGEMENT_PROTOCOL_GUID": [
        0x86C77A67,
        0xB97,
        0x4633,
        0xA1,
        0x87,
        0x49,
        0x10,
        0x4D,
        0x6,
        0x85,
        0xC7,
    ],
    "EFI_FIRMWARE_PERFORMANCE_GUID": [
        0xC095791A,
        0x3001,
        0x47B2,
        0x80,
        0xC9,
        0xEA,
        0xC7,
        0x31,
        0x9F,
        0x2F,
        0xA4,
    ],
    "EFI_FIRMWARE_VOLUME2_PROTOCOL_GUID": [
        0x220E73B6,
        0x6BDB,
        0x4413,
        0x84,
        0x5,
        0xB9,
        0x74,
        0xB1,
        0x8,
        0x61,
        0x9A,
    ],
    "EFI_FIRMWARE_VOLUME_BLOCK2_PROTOCOL_GUID": [
        0x8F644FA9,
        0xE850,
        0x4DB1,
        0x9C,
        0xE2,
        0xB,
        0x44,
        0x69,
        0x8E,
        0x8D,
        0xA4,
    ],
    "EFI_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID": [
        0x8F644FA9,
        0xE850,
        0x4DB1,
        0x9C,
        0xE2,
        0xB,
        0x44,
        0x69,
        0x8E,
        0x8D,
        0xA4,
    ],
    "EFI_FIRMWARE_VOLUME_DISPATCH_PROTOCOL_GUID": [
        0x7AA35A69,
        0x506C,
        0x444F,
        0xA7,
        0xAF,
        0x69,
        0x4B,
        0xF5,
        0x6F,
        0x71,
        0xC8,
    ],
    "EFI_FIRMWARE_VOLUME_PROTOCOL_GUID": [
        0x389F751F,
        0x1838,
        0x4388,
        0x83,
        0x90,
        0xCD,
        0x81,
        0x54,
        0xBD,
        0x27,
        0xF8,
    ],
    "EFI_FORM_BROWSER2_PROTOCOL_GUID": [
        0xB9D4C360,
        0xBCFB,
        0x4F9B,
        0x92,
        0x98,
        0x53,
        0xC1,
        0x36,
        0x98,
        0x22,
        0x58,
    ],
    "EFI_FORM_BROWSER_COMPATIBILITY_PROTOCOL_GUID": [
        0xFB7C852,
        0xADCA,
        0x4853,
        0x8D,
        0xF,
        0xFB,
        0xA7,
        0x1B,
        0x1C,
        0xE1,
        0x1A,
    ],
    "EFI_FORM_BROWSER_PROTOCOL_GUID": [
        0xE5A1333E,
        0xE1B4,
        0x4D55,
        0xCE,
        0xEB,
        0x35,
        0xC3,
        0xEF,
        0x13,
        0x34,
        0x43,
    ],
    "EFI_FORM_BROWSER_PROTOCOL_GUID": [
        0xFB7C852,
        0xADCA,
        0x4853,
        0x8D,
        0xF,
        0xFB,
        0xA7,
        0x1B,
        0x1C,
        0xE1,
        0x1A,
    ],
    "EFI_FORM_CALLBACK_PROTOCOL_GUID": [
        0xF3E4543D,
        0xCF35,
        0x6CEF,
        0x35,
        0xC4,
        0x4F,
        0xE6,
        0x34,
        0x4D,
        0xFC,
        0x54,
    ],
    "EFI_FRAMEWORK_DEVICE_PATH_GUID": [
        0xB7084E63,
        0x46B7,
        0x4D1A,
        0x86,
        0x77,
        0xE3,
        0x0B,
        0x53,
        0xDB,
        0xF0,
        0x50,
    ],
    "EFI_FTP4_PROTOCOL_GUID": [
        0xEB338826,
        0x681B,
        0x4295,
        0xB3,
        0x56,
        0x2B,
        0x36,
        0x4C,
        0x75,
        0x7B,
        0x9,
    ],
    "EFI_FTP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0xFAAECB1,
        0x226E,
        0x4782,
        0xAA,
        0xCE,
        0x7D,
        0xB9,
        0xBC,
        0xBF,
        0x4D,
        0xAF,
    ],
    "EFI_FTW_LITE_PROTOCOL_GUID": [
        0x3F557189,
        0x8DAE,
        0x45AE,
        0xA0,
        0xB3,
        0x2B,
        0x99,
        0xCA,
        0x7A,
        0xA7,
        0xA0,
    ],
    "EFI_FVB_EXTENSION_PROTOCOL_GUID": [
        0x53A4C71B,
        0xB581,
        0x4170,
        0x91,
        0xB3,
        0x8D,
        0xB8,
        0x7A,
        0x4B,
        0x5C,
        0x46,
    ],
    "EFI_GENERIC_MEMORY_TEST_PROTOCOL_GUID": [
        0x309DE7F1,
        0x7F5E,
        0x4ACE,
        0xB4,
        0x9C,
        0x53,
        0x1B,
        0xE5,
        0xAA,
        0x95,
        0xEF,
    ],
    "EFI_GENERIC_VARIABLE_GUID": [
        0x59D1C24F,
        0x50F1,
        0x401A,
        0xB1,
        0x01,
        0xF3,
        0x3E,
        0x0D,
        0xAE,
        0xD4,
        0x43,
    ],
    "EFI_GLOBAL_VARIABLE_GUID": [
        0x8BE4DF61,
        0x93CA,
        0x11D2,
        0xAA,
        0x0D,
        0x00,
        0xE0,
        0x98,
        0x03,
        0x2B,
        0x8C,
    ],
    "EFI_GRAPHICS_OUTPUT_PROTOCOL_GUID": [
        0x9042A9DE,
        0x23DC,
        0x4A38,
        0x96,
        0xFB,
        0x7A,
        0xDE,
        0xD0,
        0x80,
        0x51,
        0x6A,
    ],
    "EFI_HARDWARE_ERROR_VARIABLE_GUID": [
        0x414E6BDD,
        0xE47B,
        0x47CC,
        0xB2,
        0x44,
        0xBB,
        0x61,
        0x02,
        0x0C,
        0xF5,
        0x16,
    ],
    "EFI_HASH_ALGORITHM_SHA1_GUID": [
        0x2AE9D80F,
        0x3FB2,
        0x4095,
        0xB7,
        0xB1,
        0xE9,
        0x31,
        0x57,
        0xB9,
        0x46,
        0xB6,
    ],
    "EFI_HASH_ALGORITHM_SHA1_NOPAD_GUID": [
        0x24C5DC2F,
        0x53E2,
        0x40CA,
        0x9E,
        0xD6,
        0xA5,
        0xD9,
        0xA4,
        0x9F,
        0x46,
        0x3B,
    ],
    "EFI_HASH_ALGORITHM_SHA224_GUID": [
        0x8DF01A06,
        0x9BD5,
        0x4BF7,
        0xB0,
        0x21,
        0xDB,
        0x4F,
        0xD9,
        0xCC,
        0xF4,
        0x5B,
    ],
    "EFI_HASH_ALGORITHM_SHA256_GUID": [
        0x51AA59DE,
        0xFDF2,
        0x4EA3,
        0xBC,
        0x63,
        0x87,
        0x5F,
        0xB7,
        0x84,
        0x2E,
        0xE9,
    ],
    "EFI_HASH_ALGORITHM_SHA256_NOPAD_GUID": [
        0x8628752A,
        0x6CB7,
        0x4814,
        0x96,
        0xFC,
        0x24,
        0xA8,
        0x15,
        0xAC,
        0x22,
        0x26,
    ],
    "EFI_HASH_ALGORITHM_SHA384_GUID": [
        0xEFA96432,
        0xDE33,
        0x4DD2,
        0xAE,
        0xE6,
        0x32,
        0x8C,
        0x33,
        0xDF,
        0x77,
        0x7A,
    ],
    "EFI_HASH_ALGORITHM_SHA512_GUID": [
        0xCAA4381E,
        0x750C,
        0x4770,
        0xB8,
        0x70,
        0x7A,
        0x23,
        0xB4,
        0xE4,
        0x21,
        0x30,
    ],
    "EFI_HASH_ALGORTIHM_MD5_GUID": [
        0xAF7C79C,
        0x65B5,
        0x4319,
        0xB0,
        0xAE,
        0x44,
        0xEC,
        0x48,
        0x4E,
        0x4A,
        0xD7,
    ],
    "EFI_HASH_PROTOCOL_GUID": [
        0xC5184932,
        0xDBA5,
        0x46DB,
        0xA5,
        0xBA,
        0xCC,
        0x0B,
        0xDA,
        0x9C,
        0x14,
        0x35,
    ],
    "EFI_HASH_SERVICE_BINDING_PROTOCOL_GUID": [
        0x42881C98,
        0xA4F3,
        0x44B0,
        0xA3,
        0x9D,
        0xDF,
        0xA1,
        0x86,
        0x67,
        0xD8,
        0xCD,
    ],
    "EFI_HII_COMPATIBILITY_PROTOCOL_GUID": [
        0x5542CCE1,
        0xDF5C,
        0x4D1B,
        0xAB,
        0xCA,
        0x36,
        0x4F,
        0x77,
        0xD3,
        0x99,
        0xFB,
    ],
    "EFI_HII_CONFIG_ACCESS_PROTOCOL_GUID": [
        0x330D4706,
        0xF2A0,
        0x4E4F,
        0xA3,
        0x69,
        0xB6,
        0x6F,
        0xA8,
        0xD5,
        0x43,
        0x85,
    ],
    "EFI_HII_CONFIG_ROUTING_PROTOCOL_GUID": [
        0x587E72D7,
        0xCC50,
        0x4F79,
        0x82,
        0x09,
        0xCA,
        0x29,
        0x1F,
        0xC1,
        0xA1,
        0x0F,
    ],
    "EFI_HII_DATABASE_PROTOCOL_GUID": [
        0xEF9FC172,
        0xA1B2,
        0x4693,
        0xB3,
        0x27,
        0x6D,
        0x32,
        0xFC,
        0x41,
        0x60,
        0x42,
    ],
    "EFI_HII_DRIVER_HEALTH_FORMSET_GUID": [
        0xF22FC20C,
        0x8CF4,
        0x45EB,
        0x8E,
        0x6,
        0xAD,
        0x4E,
        0x50,
        0xB9,
        0x5D,
        0xD3,
    ],
    "EFI_HII_FONT_PROTOCOL_GUID": [
        0xE9CA4775,
        0x8657,
        0x47FC,
        0x97,
        0xE7,
        0x7E,
        0xD6,
        0x5A,
        0x8,
        0x43,
        0x24,
    ],
    "EFI_HII_FRONT_PAGE_CLASS_GUID": [
        0x94D411B7,
        0x7669,
        0x45C3,
        0xBA,
        0x3B,
        0xF3,
        0xA5,
        0x8A,
        0x71,
        0x56,
        0x81,
    ],
    "EFI_HII_IMAGE_PROTOCOL_GUID": [
        0x31A6406A,
        0x6BDF,
        0x4E46,
        0xB2,
        0xA2,
        0xEB,
        0xAA,
        0x89,
        0xC4,
        0x9,
        0x20,
    ],
    "EFI_HII_PACKAGE_LIST_PROTOCOL_GUID": [
        0x6A1EE763,
        0xD47A,
        0x43B4,
        0xAA,
        0xBE,
        0xEF,
        0x1D,
        0xE2,
        0xAB,
        0x56,
        0xFC,
    ],
    "EFI_HII_PLATFORM_SETUP_FORMSET_GUID": [
        0x93039971,
        0x8545,
        0x4B04,
        0xB4,
        0x5E,
        0x32,
        0xEB,
        0x83,
        0x26,
        0x4,
        0xE,
    ],
    "EFI_HII_PROTOCOL_GUID": [
        0x5542CCE1,
        0xDF5C,
        0x4D1B,
        0xAB,
        0xCA,
        0x36,
        0x4F,
        0x77,
        0xD3,
        0x99,
        0xFB,
    ],
    "EFI_HII_PROTOCOL_GUID": [
        0xD7AD636E,
        0xB997,
        0x459B,
        0xBF,
        0x3F,
        0x88,
        0x46,
        0x89,
        0x79,
        0x80,
        0xE1,
    ],
    "EFI_HII_SET_KEYBOARD_LAYOUT_EVENT_GUID": [
        0x14982A4F,
        0xB0ED,
        0x45B8,
        0xA8,
        0x11,
        0x5A,
        0x7A,
        0x9B,
        0xC2,
        0x32,
        0xDF,
    ],
    "EFI_HII_STANDARD_FORM_GUID": [
        0x3BD2F4EC,
        0xE524,
        0x46E4,
        0xA9,
        0xD8,
        0x51,
        0x1,
        0x17,
        0x42,
        0x55,
        0x62,
    ],
    "EFI_HII_STRING_PROTOCOL_GUID": [
        0xFD96974,
        0x23AA,
        0x4CDC,
        0xB9,
        0xCB,
        0x98,
        0xD1,
        0x77,
        0x50,
        0x32,
        0x2A,
    ],
    "EFI_HII_USER_CREDENTIAL_FORMSET_GUID": [
        0x337F4407,
        0x5AEE,
        0x4B83,
        0xB2,
        0xA7,
        0x4E,
        0xAD,
        0xCA,
        0x30,
        0x88,
        0xCD,
    ],
    "EFI_HOB_LIST_GUID": [
        0x7739F24C,
        0x93D7,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_HOB_MEMORY_ALLOC_BSP_STORE_GUID": [
        0x564B33CD,
        0xC92A,
        0x4593,
        0x90,
        0xBF,
        0x24,
        0x73,
        0xE4,
        0x3C,
        0x63,
        0x22,
    ],
    "EFI_HOB_MEMORY_ALLOC_STACK_GUID": [
        0x4ED4BF27,
        0x4092,
        0x42E9,
        0x80,
        0x7D,
        0x52,
        0x7B,
        0x1D,
        0x0,
        0xC9,
        0xBD,
    ],
    "EFI_IA32_X64_ERROR_TYPE_BUS_CHECK_GUID": [
        0x1CF3F8B3,
        0xC5B1,
        0x49A2,
        0xAA,
        0x59,
        0x5E,
        0xEF,
        0x92,
        0xFF,
        0xA6,
        0x3C,
    ],
    "EFI_IA32_X64_ERROR_TYPE_CACHE_CHECK_GUID": [
        0xA55701F5,
        0xE3EF,
        0x43DE,
        0xAC,
        0x72,
        0x24,
        0x9B,
        0x57,
        0x3F,
        0xAD,
        0x2C,
    ],
    "EFI_IA32_X64_ERROR_TYPE_MS_CHECK_GUID": [
        0x48AB7F57,
        0xDC34,
        0x4F6C,
        0xA7,
        0xD3,
        0xB0,
        0xB5,
        0xB0,
        0xA7,
        0x43,
        0x14,
    ],
    "EFI_IA32_X64_ERROR_TYPE_TLB_CHECK_GUID": [
        0xFC06B535,
        0x5E1F,
        0x4562,
        0x9F,
        0x25,
        0x0A,
        0x3B,
        0x9A,
        0xDB,
        0x63,
        0xC3,
    ],
    "EFI_IDE_CONTROLLER_INIT_PROTOCOL_GUID": [
        0xA1E37052,
        0x80D9,
        0x4E65,
        0xA3,
        0x17,
        0x3E,
        0x9A,
        0x55,
        0xC4,
        0x3E,
        0xC9,
    ],
    "EFI_IFR_FRAMEWORK_GUID": [
        0x31CA5D1A,
        0xD511,
        0x4931,
        0xB7,
        0x82,
        0xAE,
        0x6B,
        0x2B,
        0x17,
        0x8C,
        0xD7,
    ],
    "EFI_IFR_REFRESH_ID_OP_GUID": [
        0xF5E655D9,
        0x02A6,
        0x46F2,
        0x9E,
        0x76,
        0xB8,
        0xBE,
        0x8E,
        0x60,
        0xAB,
        0x22,
    ],
    "EFI_IFR_TIANO_GUID": [
        0xF0B1735,
        0x87A0,
        0x4193,
        0xB2,
        0x66,
        0x53,
        0x8C,
        0x38,
        0xAF,
        0x48,
        0xCE,
    ],
    "EFI_IMAGE_SECURITY_DATABASE_GUID": [
        0xD719B2CB,
        0x3D3A,
        0x4596,
        0xA3,
        0xBC,
        0xDA,
        0xD0,
        0xE,
        0x67,
        0x65,
        0x6F,
    ],
    "EFI_INCOMPATIBLE_PCI_DEVICE_SUPPORT_PROTOCOL_GUID": [
        0xEB23F55A,
        0x7863,
        0x4AC2,
        0x8D,
        0x3D,
        0x95,
        0x65,
        0x35,
        0xDE,
        0x03,
        0x75,
    ],
    "EFI_IOBASE_HOB_GUID": [
        0xD4A28A3E,
        0xDCF2,
        0x43CF,
        0xA2,
        0xB7,
        0xF3,
        0x57,
        0x2A,
        0x7C,
        0xAB,
        0x9,
    ],
    "EFI_IP4_CONFIG_PROTOCOL_GUID": [
        0x3B95AA31,
        0x3793,
        0x434B,
        0x86,
        0x67,
        0xC8,
        0x07,
        0x08,
        0x92,
        0xE0,
        0x5E,
    ],
    "EFI_IP4_PROTOCOL_GUID": [
        0x41D94CD2,
        0x35B6,
        0x455A,
        0x82,
        0x58,
        0xD4,
        0xE5,
        0x13,
        0x34,
        0xAA,
        0xDD,
    ],
    "EFI_IP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0xC51711E7,
        0xB4BF,
        0x404A,
        0xBF,
        0xB8,
        0x0A,
        0x04,
        0x8E,
        0xF1,
        0xFF,
        0xE4,
    ],
    "EFI_IP6_CONFIG_PROTOCOL_GUID": [
        0x937FE521,
        0x95AE,
        0x4D1A,
        0x89,
        0x29,
        0x48,
        0xBC,
        0xD9,
        0x0A,
        0xD3,
        0x1A,
    ],
    "EFI_IP6_PROTOCOL_GUID": [
        0x2C8759D5,
        0x5C2D,
        0x66EF,
        0x92,
        0x5F,
        0xB6,
        0x6C,
        0x10,
        0x19,
        0x57,
        0xE2,
    ],
    "EFI_IP6_SERVICE_BINDING_PROTOCOL_GUID": [
        0xEC835DD3,
        0xFE0F,
        0x617B,
        0xA6,
        0x21,
        0xB3,
        0x50,
        0xC3,
        0xE1,
        0x33,
        0x88,
    ],
    "EFI_IPSEC2_PROTOCOL_GUID": [
        0xA3979E64,
        0xACE8,
        0x4DDC,
        0xBC,
        0x7,
        0x4D,
        0x66,
        0xB8,
        0xFD,
        0x9,
        0x77,
    ],
    "EFI_IPSEC_CONFIG_PROTOCOL_GUID": [
        0xCE5E5929,
        0xC7A3,
        0x4602,
        0xAD,
        0x9E,
        0xC9,
        0xDA,
        0xF9,
        0x4E,
        0xBF,
        0xCF,
    ],
    "EFI_IPSEC_PROTOCOL_GUID": [
        0xDFB386F7,
        0xE100,
        0x43AD,
        0x9C,
        0x9A,
        0xED,
        0x90,
        0xD0,
        0x8A,
        0x5E,
        0x12,
    ],
    "EFI_ISA_ACPI_PROTOCOL_GUID": [
        0x64A892DC,
        0x5561,
        0x4536,
        0x92,
        0xC7,
        0x79,
        0x9B,
        0xFC,
        0x18,
        0x33,
        0x55,
    ],
    "EFI_ISA_IO_PROTOCOL_GUID": [
        0x7EE2BD44,
        0x3DA0,
        0x11D4,
        0x9A,
        0x38,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_ISCSI_INITIATOR_NAME_PROTOCOL_GUID": [
        0x59324945,
        0xEC44,
        0x4C0D,
        0xB1,
        0xCD,
        0x9D,
        0xB1,
        0x39,
        0xDF,
        0x7,
        0xC,
    ],
    "EFI_KMS_FORMAT_AESCBC_128_GUID": [
        0xA0E8EE6A,
        0x0E92,
        0x44D4,
        0x86,
        0x1B,
        0x0E,
        0xAA,
        0x4A,
        0xCA,
        0x44,
        0xA2,
    ],
    "EFI_KMS_FORMAT_AESCBC_256_GUID": [
        0xD7E69789,
        0x1F68,
        0x45E8,
        0x96,
        0xEF,
        0x3B,
        0x64,
        0x07,
        0xA5,
        0xB2,
        0xDC,
    ],
    "EFI_KMS_FORMAT_AESXTS_128_GUID": [
        0x4776E33F,
        0xDB47,
        0x479A,
        0xA2,
        0x5F,
        0xA1,
        0xCD,
        0x0A,
        0xFA,
        0xB3,
        0x8B,
    ],
    "EFI_KMS_FORMAT_AESXTS_256_GUID": [
        0xDC7E8613,
        0xC4BB,
        0x4DB0,
        0x84,
        0x62,
        0x13,
        0x51,
        0x13,
        0x57,
        0xAB,
        0xE2,
    ],
    "EFI_KMS_FORMAT_GENERIC_1024_GUID": [
        0x43BE0B44,
        0x874B,
        0x4EAD,
        0xB0,
        0x9C,
        0x24,
        0x1A,
        0x4F,
        0xBD,
        0x7E,
        0xB3,
    ],
    "EFI_KMS_FORMAT_GENERIC_128_GUID": [
        0xEC8A3D69,
        0x6DDF,
        0x4108,
        0x94,
        0x76,
        0x73,
        0x37,
        0xFC,
        0x52,
        0x21,
        0x36,
    ],
    "EFI_KMS_FORMAT_GENERIC_160_GUID": [
        0xA3B3E6F8,
        0xEFCA,
        0x4BC1,
        0x88,
        0xFB,
        0xCB,
        0x87,
        0x33,
        0x9B,
        0x25,
        0x79,
    ],
    "EFI_KMS_FORMAT_GENERIC_2048_GUID": [
        0x40093F23,
        0x630C,
        0x4626,
        0x9C,
        0x48,
        0x40,
        0x37,
        0x3B,
        0x19,
        0xCB,
        0xBE,
    ],
    "EFI_KMS_FORMAT_GENERIC_256_GUID": [
        0x70F64793,
        0xC323,
        0x4261,
        0xAC,
        0x2C,
        0xD8,
        0x76,
        0xF2,
        0x7C,
        0x53,
        0x45,
    ],
    "EFI_KMS_FORMAT_GENERIC_3072_GUID": [
        0xB9237513,
        0x6C44,
        0x4411,
        0xA9,
        0x90,
        0x21,
        0xE5,
        0x56,
        0xE0,
        0x5A,
        0xDE,
    ],
    "EFI_KMS_FORMAT_GENERIC_512_GUID": [
        0x978FE043,
        0xD7AF,
        0x422E,
        0x8A,
        0x92,
        0x2B,
        0x48,
        0xE4,
        0x63,
        0xBD,
        0xE6,
    ],
    "EFI_KMS_FORMAT_MD2_128_GUID": [
        0x78BE11C4,
        0xEE44,
        0x4A22,
        0x9F,
        0x05,
        0x03,
        0x85,
        0x2E,
        0xC5,
        0xC9,
        0x78,
    ],
    "EFI_KMS_FORMAT_MD4_128_GUID": [
        0xD1C17AA1,
        0xCAC5,
        0x400F,
        0xBE,
        0x17,
        0xE2,
        0xA2,
        0xAE,
        0x06,
        0x67,
        0x7C,
    ],
    "EFI_KMS_FORMAT_MD5SHA_128_GUID": [
        0x1C178237,
        0x6897,
        0x459E,
        0x9D,
        0x36,
        0x67,
        0xCE,
        0x8E,
        0xF9,
        0x4F,
        0x76,
    ],
    "EFI_KMS_FORMAT_MD5_128_GUID": [
        0xDCBC3662,
        0x9CDA,
        0x4B52,
        0xA0,
        0x4C,
        0x82,
        0xEB,
        0x1D,
        0x23,
        0x48,
        0xC7,
    ],
    "EFI_KMS_FORMAT_MDC2_128_GUID": [
        0xF7AD60F8,
        0xEFA8,
        0x44A3,
        0x91,
        0x13,
        0x23,
        0x1F,
        0x39,
        0x9E,
        0xB4,
        0xC7,
    ],
    "EFI_KMS_FORMAT_MDC4_128_GUID": [
        0x3FA4F847,
        0xD8EB,
        0x4DF4,
        0xBD,
        0x49,
        0x10,
        0x3A,
        0x0A,
        0x84,
        0x7B,
        0xBC,
    ],
    "EFI_KMS_FORMAT_RSASHA1_1024_GUID": [
        0x56417BED,
        0x6BBE,
        0x4882,
        0x86,
        0xA0,
        0x3A,
        0xE8,
        0xBB,
        0x17,
        0xF8,
        0xF9,
    ],
    "EFI_KMS_FORMAT_RSASHA1_2048_GUID": [
        0xF66447D4,
        0x75A6,
        0x463E,
        0xA8,
        0x19,
        0x07,
        0x7F,
        0x2D,
        0xDA,
        0x05,
        0xE9,
    ],
    "EFI_KMS_FORMAT_RSASHA256_2048_GUID": [
        0xA477AF13,
        0x877D,
        0x4060,
        0xBA,
        0xA1,
        0x25,
        0xD1,
        0xBE,
        0xA0,
        0x8A,
        0xD3,
    ],
    "EFI_KMS_FORMAT_SHA1_160_GUID": [
        0x453C5E5A,
        0x482D,
        0x43F0,
        0x87,
        0xC9,
        0x59,
        0x41,
        0xF3,
        0xA3,
        0x8A,
        0xC2,
    ],
    "EFI_KMS_FORMAT_SHA256_256_GUID": [
        0x6BB4F5CD,
        0x8022,
        0x448D,
        0xBC,
        0x6D,
        0x77,
        0x1B,
        0xAE,
        0x93,
        0x5F,
        0xC6,
    ],
    "EFI_KMS_FORMAT_SHA512_512_GUID": [
        0x2F240E12,
        0xE14D,
        0x475C,
        0x83,
        0xB0,
        0xEF,
        0xFF,
        0x22,
        0xD7,
        0x7B,
        0xE7,
    ],
    "EFI_KMS_PROTOCOL_GUID": [
        0xEC3A978D,
        0x7C4E,
        0x48FA,
        0x9A,
        0xBE,
        0x6A,
        0xD9,
        0x1C,
        0xC8,
        0xF8,
        0x11,
    ],
    "EFI_LEGACY_8259_PROTOCOL_GUID": [
        0x38321DBA,
        0x4FE0,
        0x4E17,
        0x8A,
        0xEC,
        0x41,
        0x30,
        0x55,
        0xEA,
        0xED,
        0xC1,
    ],
    "EFI_LEGACY_BIOS_GUID": [
        0x2E3044AC,
        0x879F,
        0x490F,
        0x97,
        0x60,
        0xBB,
        0xDF,
        0xAF,
        0x69,
        0x5F,
        0x50,
    ],
    "EFI_LEGACY_BIOS_PLATFORM_PROTOCOL_GUID": [
        0x783658A3,
        0x4172,
        0x4421,
        0xA2,
        0x99,
        0xE0,
        0x9,
        0x7,
        0x9C,
        0xC,
        0xB4,
    ],
    "EFI_LEGACY_BIOS_PROTOCOL_GUID": [
        0xDB9A1E3D,
        0x45CB,
        0x4ABB,
        0x85,
        0x3B,
        0xE5,
        0x38,
        0x7F,
        0xDB,
        0x2E,
        0x2D,
    ],
    "EFI_LEGACY_BIOS_THUNK_PROTOCOL_GUID": [
        0x4C51A7BA,
        0x7195,
        0x442D,
        0x87,
        0x92,
        0xBE,
        0xEA,
        0x6E,
        0x2F,
        0xF6,
        0xEC,
    ],
    "EFI_LEGACY_DEV_ORDER_VARIABLE_GUID": [
        0xA56074DB,
        0x65FE,
        0x45F7,
        0xBD,
        0x21,
        0x2D,
        0x2B,
        0xDD,
        0x8E,
        0x96,
        0x52,
    ],
    "EFI_LEGACY_INTERRUPT_PROTOCOL_GUID": [
        0x31CE593D,
        0x108A,
        0x485D,
        0xAD,
        0xB2,
        0x78,
        0xF2,
        0x1F,
        0x29,
        0x66,
        0xBE,
    ],
    "EFI_LEGACY_REGION2_PROTOCOL_GUID": [
        0x70101EAF,
        0x85,
        0x440C,
        0xB3,
        0x56,
        0x8E,
        0xE3,
        0x6F,
        0xEF,
        0x24,
        0xF0,
    ],
    "EFI_LEGACY_REGION_PROTOCOL_GUID": [
        0xFC9013A,
        0x568,
        0x4BA9,
        0x9B,
        0x7E,
        0xC9,
        0xC3,
        0x90,
        0xA6,
        0x60,
        0x9B,
    ],
    "EFI_LOADED_IMAGE_DEVICE_PATH_PROTOCOL_GUID": [
        0xBC62157E,
        0x3E33,
        0x4FEC,
        0x99,
        0x20,
        0x2D,
        0x3B,
        0x36,
        0xD7,
        0x50,
        0xDF,
    ],
    "EFI_LOADED_IMAGE_PROTOCOL_GUID": [
        0x5B1B31A1,
        0x9562,
        0x11D2,
        0x8E,
        0x3F,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_LOAD_FILE2_PROTOCOL_GUID": [
        0x4006C0C1,
        0xFCB3,
        0x403E,
        0x99,
        0x6D,
        0x4A,
        0x6C,
        0x87,
        0x24,
        0xE0,
        0x6D,
    ],
    "EFI_LOAD_FILE_PROTOCOL_GUID": [
        0x56EC3091,
        0x954C,
        0x11D2,
        0x8E,
        0x3F,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_LOAD_FIXED_ADDRESS_CONFIGURATION_TABLE_GUID": [
        0x2CA88B53,
        0xD296,
        0x4080,
        0xA4,
        0xA5,
        0xCA,
        0xD9,
        0xBA,
        0xE2,
        0x4B,
        0x9,
    ],
    "EFI_LOCK_BOX_PROTOCOL_GUID": [
        0xBD445D79,
        0xB7AD,
        0x4F04,
        0x9A,
        0xD8,
        0x29,
        0xBD,
        0x20,
        0x40,
        0xEB,
        0x3C,
    ],
    "EFI_MANAGED_NETWORK_PROTOCOL_GUID": [
        0x7AB33A91,
        0xACE5,
        0x4326,
        0xB5,
        0x72,
        0xE7,
        0xEE,
        0x33,
        0xD3,
        0x9F,
        0x16,
    ],
    "EFI_MANAGED_NETWORK_SERVICE_BINDING_PROTOCOL_GUID": [
        0xF36FF770,
        0xA7E1,
        0x42CF,
        0x9E,
        0xD2,
        0x56,
        0xF0,
        0xF2,
        0x71,
        0xF4,
        0x4C,
    ],
    "EFI_MEASURED_FV_HOB_GUID": [
        0xB2360B42,
        0x7173,
        0x420A,
        0x86,
        0x96,
        0x46,
        0xCA,
        0x6B,
        0xAB,
        0x10,
        0x60,
    ],
    "EFI_MEMORY_PRODUCER_GUID": [
        0x1D7ADD6E,
        0xB2DA,
        0x4B0B,
        0xB2,
        0x9F,
        0x49,
        0xCB,
        0x42,
        0xF4,
        0x63,
        0x56,
    ],
    "EFI_MEMORY_SUBCLASS_GUID": [
        0x4E8F4EBB,
        0x64B9,
        0x4E05,
        0x9B,
        0x18,
        0x4C,
        0xFE,
        0x49,
        0x23,
        0x50,
        0x97,
    ],
    "EFI_MEMORY_TYPE_INFORMATION_GUID": [
        0x4C19049F,
        0x4137,
        0x4DD3,
        0x9C,
        0x10,
        0x8B,
        0x97,
        0xA8,
        0x3F,
        0xFD,
        0xFA,
    ],
    "EFI_METRONOME_ARCH_PROTOCOL_GUID": [
        0x26BACCB2,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_MINI_SHELL_FILE_GUID": [
        0x86AD232B,
        0xD33A,
        0x465C,
        0xBF,
        0x5F,
        0x41,
        0x37,
        0xB,
        0xA9,
        0x2F,
        0xE2,
    ],
    "EFI_MISC_PRODUCER_GUID": [
        0x62512C92,
        0x63C4,
        0x4D80,
        0x82,
        0xB1,
        0xC1,
        0xA4,
        0xDC,
        0x44,
        0x80,
        0xE5,
    ],
    "EFI_MISC_SUBCLASS_GUID": [
        0x772484B2,
        0x7482,
        0x4B91,
        0x9F,
        0x9A,
        0xAD,
        0x43,
        0xF8,
        0x1C,
        0x58,
        0x81,
    ],
    "EFI_MMC_HOST_PROTOCOL_GUID": [
        0x3E591C00,
        0x9E4A,
        0x11DF,
        0x92,
        0x44,
        0x00,
        0x02,
        0xA5,
        0xD5,
        0xC5,
        0x1B,
    ],
    "EFI_MONOTONIC_COUNTER_ARCH_PROTOCOL_GUID": [
        0x1DA97072,
        0xBDDC,
        0x4B30,
        0x99,
        0xF1,
        0x72,
        0xA0,
        0xB5,
        0x6F,
        0xFF,
        0x2A,
    ],
    "EFI_MONTONIC_COUNTER_ARCH_PROTOCOL_GUID": [
        0x1DA97072,
        0xBDDC,
        0x4B30,
        0x99,
        0xF1,
        0x72,
        0xA0,
        0xB5,
        0x6F,
        0xFF,
        0x2A,
    ],
    "EFI_MPS_TABLE_GUID": [
        0xEB9D2D2F,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_MP_SERVICES_PROTOCOL_GUID": [
        0x3FDDA605,
        0xA76E,
        0x4F46,
        0xAD,
        0x29,
        0x12,
        0xF4,
        0x53,
        0x1B,
        0x3D,
        0x08,
    ],
    "EFI_MTFTP4_PROTOCOL_GUID": [
        0x78247C57,
        0x63DB,
        0x4708,
        0x99,
        0xC2,
        0xA8,
        0xB4,
        0xA9,
        0xA6,
        0x1F,
        0x6B,
    ],
    "EFI_MTFTP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0x2FE800BE,
        0x8F01,
        0x4AA6,
        0x94,
        0x6B,
        0xD7,
        0x13,
        0x88,
        0xE1,
        0x83,
        0x3F,
    ],
    "EFI_MTFTP6_PROTOCOL_GUID": [
        0xBF0A78BA,
        0xEC29,
        0x49CF,
        0xA1,
        0xC9,
        0x7A,
        0xE5,
        0x4E,
        0xAB,
        0x6A,
        0x51,
    ],
    "EFI_MTFTP6_SERVICE_BINDING_PROTOCOL_GUID": [
        0xD9760FF3,
        0x3CCA,
        0x4267,
        0x80,
        0xF9,
        0x75,
        0x27,
        0xFA,
        0xFA,
        0x42,
        0x23,
    ],
    "EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL_GUID": [
        0x1ACED566,
        0x76ED,
        0x4218,
        0xBC,
        0x81,
        0x76,
        0x7F,
        0x1F,
        0x97,
        0x7A,
        0x89,
    ],
    "EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL_GUID": [
        0xE18541CD,
        0xF755,
        0x4F73,
        0x92,
        0x8D,
        0x64,
        0x3C,
        0x8A,
        0x79,
        0xB2,
        0x29,
    ],
    "EFI_NIC_IP4_CONFIG_NVDATA_GUID": [
        0x9D5B53F,
        0xF4B0,
        0x4F59,
        0xA0,
        0xB1,
        0x7B,
        0x57,
        0xD3,
        0x5C,
        0xE,
        0x5,
    ],
    "EFI_NIC_IP4_CONFIG_PROTOCOL_GUID": [
        0xDCA3D4D,
        0x12DA,
        0x4728,
        0xBF,
        0x7E,
        0x86,
        0xCE,
        0xB9,
        0x28,
        0xD0,
        0x67,
    ],
    "EFI_NIC_IP4_CONFIG_VARIABLE_GUID": [
        0xD8944553,
        0xC4DD,
        0x41F4,
        0x9B,
        0x30,
        0xE1,
        0x39,
        0x7C,
        0xFB,
        0x26,
        0x7B,
    ],
    "EFI_NT_LOAD_AS_DLL_PPI_GUID": [
        0xCCC53F6B,
        0xA03A,
        0x4ED8,
        0x83,
        0x9A,
        0x3,
        0xD9,
        0x9C,
        0x2,
        0xB4,
        0xE3,
    ],
    "EFI_OEM_BADGING_PROTOCOL_GUID": [
        0x170E13C0,
        0xBF1B,
        0x4218,
        0x87,
        0x1D,
        0x2A,
        0xBD,
        0xC6,
        0xF8,
        0x87,
        0xBC,
    ],
    "EFI_PART_TYPE_EFI_SYSTEM_PART_GUID": [
        0xC12A7328,
        0xF81F,
        0x11D2,
        0xBA,
        0x4B,
        0x00,
        0xA0,
        0xC9,
        0x3E,
        0xC9,
        0x3B,
    ],
    "EFI_PART_TYPE_LEGACY_MBR_GUID": [
        0x024DEE41,
        0x33E7,
        0x11D3,
        0x9D,
        0x69,
        0x00,
        0x08,
        0xC7,
        0x81,
        0xF3,
        0x9F,
    ],
    "EFI_PATH_FILE_NAME_GUID": [
        0x7644C181,
        0xFA6E,
        0x46DA,
        0x80,
        0xCB,
        0x04,
        0xB9,
        0x90,
        0x40,
        0x62,
        0xE8,
    ],
    "EFI_PCD_PROTOCOL_GUID": [
        0x13A3F0F6,
        0x264A,
        0x3EF0,
        0xF2,
        0xE0,
        0xDE,
        0xC5,
        0x12,
        0x34,
        0x2F,
        0x34,
    ],
    "EFI_PCI_ENUMERATION_COMPLETE_GUID": [
        0x30CFE3E7,
        0x3DE1,
        0x4586,
        0xBE,
        0x20,
        0xDE,
        0xAB,
        0xA1,
        0xB3,
        0xB7,
        0x93,
    ],
    "EFI_PCI_EXPRESS_BASE_ADDRESS_GUID": [
        0x3677D529,
        0x326F,
        0x4603,
        0xA9,
        0x26,
        0xEA,
        0xAC,
        0xE0,
        0x1D,
        0xCB,
        0xB0,
    ],
    "EFI_PCI_HOST_BRIDGE_RESOURCE_ALLOCATION_PROTOCOL_GUID": [
        0xCF8034BE,
        0x6768,
        0x4D8B,
        0xB7,
        0x39,
        0x7C,
        0xCE,
        0x68,
        0x3A,
        0x9F,
        0xBE,
    ],
    "EFI_PCI_HOTPLUG_DEVICE_GUID": [
        0x0B280816,
        0x52E7,
        0x4E51,
        0xAA,
        0x57,
        0x11,
        0xBD,
        0x41,
        0xCB,
        0xEF,
        0xC3,
    ],
    "EFI_PCI_HOTPLUG_REQUEST_PROTOCOL_GUID": [
        0x19CB87AB,
        0x2CB9,
        0x4665,
        0x83,
        0x60,
        0xDD,
        0xCF,
        0x60,
        0x54,
        0xF7,
        0x9D,
    ],
    "EFI_PCI_HOT_PLUG_INIT_PROTOCOL_GUID": [
        0xAA0E8BC1,
        0xDABC,
        0x46B0,
        0xA8,
        0x44,
        0x37,
        0xB8,
        0x16,
        0x9B,
        0x2B,
        0xEA,
    ],
    "EFI_PCI_IO_PROTOCOL_GUID": [
        0x4CF5B200,
        0x68B8,
        0x4CA5,
        0x9E,
        0xEC,
        0xB2,
        0x3E,
        0x3F,
        0x50,
        0x2,
        0x9A,
    ],
    "EFI_PCI_OPTION_ROM_TABLE_GUID": [
        0x7462660F,
        0x1CBD,
        0x48DA,
        0xAD,
        0x11,
        0x91,
        0x71,
        0x79,
        0x13,
        0x83,
        0x1C,
    ],
    "EFI_PCI_OVERRIDE_GUID": [
        0xB5B35764,
        0x460C,
        0x4A06,
        0x99,
        0xFC,
        0x77,
        0xA1,
        0x7C,
        0x1B,
        0x5C,
        0xEB,
    ],
    "EFI_PCI_PLATFORM_PROTOCOL_GUID": [
        0x7D75280,
        0x27D4,
        0x4D69,
        0x90,
        0xD0,
        0x56,
        0x43,
        0xE2,
        0x38,
        0xB3,
        0x41,
    ],
    "EFI_PCI_ROOT_BRIDGE_IO_PROTOCOL_GUID": [
        0x2F707EBB,
        0x4A1A,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PC_ANSI_GUID": [
        0xE0C14753,
        0xF9BE,
        0x11D2,
        0x9A,
        0x0C,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PEI_APRIORI_FILE_NAME_GUID": [
        0x1B45CC0A,
        0x156A,
        0x428A,
        0xAF,
        0x62,
        0x49,
        0x86,
        0x4D,
        0xA0,
        0xE6,
        0xE6,
    ],
    "EFI_PEI_BOOT_SCRIPT_EXECUTER_PPI_GUID": [
        0xABD42895,
        0x78CF,
        0x4872,
        0x84,
        0x44,
        0x1B,
        0x5C,
        0x18,
        0x0B,
        0xFB,
        0xFF,
    ],
    "EFI_PEI_CPU_IO_PPI_INSTALLED_GUID": [
        0xE6AF1F7B,
        0xFC3F,
        0x46DA,
        0xA8,
        0x28,
        0xA3,
        0xB4,
        0x57,
        0xA4,
        0x42,
        0x82,
    ],
    "EFI_PEI_DECOMPRESS_PPI_GUID": [
        0x1A36E4E7,
        0xFAB6,
        0x476A,
        0x8E,
        0x75,
        0x69,
        0x5A,
        0x5,
        0x76,
        0xFD,
        0xD7,
    ],
    "EFI_PEI_DEVICE_RECOVERY_MODULE_PPI_GUID": [
        0x0DE2CE25,
        0x446A,
        0x45A7,
        0xBF,
        0xC9,
        0x37,
        0xDA,
        0x26,
        0x34,
        0x4B,
        0x37,
    ],
    "EFI_PEI_END_OF_PEI_PHASE_PPI_GUID": [
        0x605EA650,
        0xC65C,
        0x42E1,
        0xBA,
        0x80,
        0x91,
        0xA5,
        0x2A,
        0xB6,
        0x18,
        0xC6,
    ],
    "EFI_PEI_FIND_FV_PPI_GUID": [
        0x36164812,
        0xA023,
        0x44E5,
        0xBD,
        0x85,
        0x5,
        0xBF,
        0x3C,
        0x77,
        0x0,
        0xAA,
    ],
    "EFI_PEI_FIRMWARE_VOLUME_INFO_PPI_GUID": [
        0x49EDB1C1,
        0xBF21,
        0x4761,
        0xBB,
        0x12,
        0xEB,
        0x0,
        0x31,
        0xAA,
        0xBB,
        0x39,
    ],
    "EFI_PEI_FLUSH_INSTRUCTION_CACHE_GUID": [
        0xD8117CFC,
        0x94A6,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PEI_LOADED_IMAGE_PPI_GUID": [
        0xC1FCD448,
        0x6300,
        0x4458,
        0xB8,
        0x64,
        0x28,
        0xDF,
        0x01,
        0x53,
        0x64,
        0xBC,
    ],
    "EFI_PEI_LOAD_FILE_GUID": [
        0xB9E0ABFE,
        0x5979,
        0x4914,
        0x97,
        0x7F,
        0x6D,
        0xEE,
        0x78,
        0xC2,
        0x78,
        0xA6,
    ],
    "EFI_PEI_LOAD_FILE_PPI_GUID": [
        0xB9E0ABFE,
        0x5979,
        0x4914,
        0x97,
        0x7F,
        0x6D,
        0xEE,
        0x78,
        0xC2,
        0x78,
        0xA6,
    ],
    "EFI_PEI_PCD_PPI_GUID": [
        0x1F34D25,
        0x4DE2,
        0x23AD,
        0x3F,
        0xF3,
        0x36,
        0x35,
        0x3F,
        0xF3,
        0x23,
        0xF1,
    ],
    "EFI_PEI_PCI_CFG2_PPI_GUID": [
        0x57A449A,
        0x1FDC,
        0x4C06,
        0xBF,
        0xC9,
        0xF5,
        0x3F,
        0x6A,
        0x99,
        0xBB,
        0x92,
    ],
    "EFI_PEI_PCI_CFG_PPI_INSTALLED_GUID": [
        0xE1F2EBA0,
        0xF7B9,
        0x4A26,
        0x86,
        0x20,
        0x13,
        0x12,
        0x21,
        0x64,
        0x2A,
        0x90,
    ],
    "EFI_PEI_PERFORMANCE_HOB_GUID": [
        0x10F432DE,
        0xDEEC,
        0x4631,
        0x80,
        0xCD,
        0x47,
        0xF6,
        0x5D,
        0x8F,
        0x80,
        0xBB,
    ],
    "EFI_PEI_PERMANENT_MEMORY_INSTALLED_PPI_GUID": [
        0xF894643D,
        0xC449,
        0x42D1,
        0x8E,
        0xA8,
        0x85,
        0xBD,
        0xD8,
        0xC6,
        0x5B,
        0xDE,
    ],
    "EFI_PEI_PE_COFF_LOADER_GUID": [
        0xD8117CFF,
        0x94A6,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PEI_READ_ONLY_VARIABLE2_PPI_GUID": [
        0x2AB86EF5,
        0xECB5,
        0x4134,
        0xB5,
        0x56,
        0x38,
        0x54,
        0xCA,
        0x1F,
        0xE1,
        0xB4,
    ],
    "EFI_PEI_READ_ONLY_VARIABLE_ACCESS_PPI_GUID": [
        0x3CDC90C6,
        0x13FB,
        0x4A75,
        0x9E,
        0x79,
        0x59,
        0xE9,
        0xDD,
        0x78,
        0xB9,
        0xFA,
    ],
    "EFI_PEI_RECOVERY_BLOCK_IO_PPI_GUID": [
        0x695D8AA1,
        0x42EE,
        0x4C46,
        0x80,
        0x5C,
        0x6E,
        0xA6,
        0xBC,
        0xE7,
        0x99,
        0xE3,
    ],
    "EFI_PEI_RECOVERY_MODULE_PPI_GUID": [
        0xFB6D9542,
        0x612D,
        0x4F45,
        0x87,
        0x2F,
        0x5C,
        0xFF,
        0x52,
        0xE9,
        0x3D,
        0xCF,
    ],
    "EFI_PEI_REPORT_PROGRESS_CODE_PPI_GUID": [
        0x229832D3,
        0x7A30,
        0x4B36,
        0xB8,
        0x27,
        0xF4,
        0xC,
        0xB7,
        0xD4,
        0x54,
        0x36,
    ],
    "EFI_PEI_RESET_PPI_GUID": [
        0xEF398D58,
        0x9DFD,
        0x4103,
        0xBF,
        0x94,
        0x78,
        0xC6,
        0xF4,
        0xFE,
        0x71,
        0x2F,
    ],
    "EFI_PEI_RSC_HANDLER_PPI_GUID": [
        0x65D394,
        0x9951,
        0x4144,
        0x82,
        0xA3,
        0xA,
        0xFC,
        0x85,
        0x79,
        0xC2,
        0x51,
    ],
    "EFI_PEI_S3_RESUME2_PPI_GUID": [
        0x6D582DBC,
        0xDB85,
        0x4514,
        0x8F,
        0xCC,
        0x5A,
        0xDF,
        0x62,
        0x27,
        0xB1,
        0x47,
    ],
    "EFI_PEI_S3_RESUME_PPI_GUID": [
        0x4426CCB2,
        0xE684,
        0x4A8A,
        0xAE,
        0x40,
        0x20,
        0xD4,
        0xB0,
        0x25,
        0xB7,
        0x10,
    ],
    "EFI_PEI_SECTION_EXTRACTION_PPI_GUID": [
        0x4F89E208,
        0xE144,
        0x4804,
        0x9E,
        0xC8,
        0x0F,
        0x89,
        0x4F,
        0x7E,
        0x36,
        0xD7,
    ],
    "EFI_PEI_SECURITY2_PPI_GUID": [
        0xDCD0BE23,
        0x9586,
        0x40F4,
        0xB6,
        0x43,
        0x06,
        0x52,
        0x2C,
        0xED,
        0x4E,
        0xDE,
    ],
    "EFI_PEI_SECURITY_PPI_GUID": [
        0x1388066E,
        0x3A57,
        0x4EFA,
        0x98,
        0xF3,
        0xC1,
        0x2F,
        0x3A,
        0x95,
        0x8A,
        0x29,
    ],
    "EFI_PEI_SMBUS2_PPI_GUID": [
        0x9CA93627,
        0xB65B,
        0x4324,
        0xA2,
        0x2,
        0xC0,
        0xB4,
        0x61,
        0x76,
        0x45,
        0x43,
    ],
    "EFI_PEI_SMBUS_PPI_GUID": [
        0xABD42895,
        0x78CF,
        0x4872,
        0x84,
        0x44,
        0x1B,
        0x5C,
        0x18,
        0xB,
        0xFB,
        0xDA,
    ],
    "EFI_PEI_SMM_COMMUNICATION_PPI_GUID": [
        0xAE933E1C,
        0xCC47,
        0x4E38,
        0x8F,
        0xE,
        0xE2,
        0xF6,
        0x1D,
        0x26,
        0x5,
        0xDF,
    ],
    "EFI_PEI_STALL_PPI_GUID": [
        0x1F4C6F90,
        0xB06B,
        0x48D8,
        0xA2,
        0x01,
        0xBA,
        0xE5,
        0xF1,
        0xCD,
        0x7D,
        0x56,
    ],
    "EFI_PEI_TEMPORARY_RAM_DONE_PPI_GUID": [
        0xCEAB683C,
        0xEC56,
        0x4A2D,
        0xA9,
        0x06,
        0x40,
        0x53,
        0xFA,
        0x4E,
        0x9C,
        0x16,
    ],
    "EFI_PEI_TEMPORARY_RAM_SUPPORT_PPI_GUID": [
        0xDBE23AA9,
        0xA345,
        0x4B97,
        0x85,
        0xB6,
        0xB2,
        0x26,
        0xF1,
        0x61,
        0x73,
        0x89,
    ],
    "EFI_PEI_TRANSFER_CONTROL_GUID": [
        0xD8117D02,
        0x94A6,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PEI_VECTOR_HANDOFF_INFO_PPI_GUID": [
        0x3CD652B4,
        0x6D33,
        0x4DCE,
        0x89,
        0xDB,
        0x83,
        0xDF,
        0x97,
        0x66,
        0xFC,
        0xCA,
    ],
    "EFI_PERFORMANCE_PROTOCOL_GUID": [
        0xFFECFFFF,
        0x923C,
        0x14D2,
        0x9E,
        0x3F,
        0x22,
        0xA0,
        0xC9,
        0x69,
        0x56,
        0x3B,
    ],
    "EFI_PHYSICAL_PRESENCE_DATA_GUID": [
        0xF6499B1,
        0xE9AD,
        0x493D,
        0xB9,
        0xC2,
        0x2F,
        0x90,
        0x81,
        0x5C,
        0x6C,
        0xBC,
    ],
    "EFI_PLATFORM_DRIVER_OVERRIDE_PROTOCOL_GUID": [
        0x6B30C738,
        0xA391,
        0x11D4,
        0x9A,
        0x3B,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PLATFORM_MEMTEST_PROTOCOL_GUID": [
        0x859BA18,
        0x7DD7,
        0x4ED7,
        0xA8,
        0x8E,
        0x10,
        0x9C,
        0x63,
        0x91,
        0x7B,
        0xDD,
    ],
    "EFI_PLATFORM_TO_DRIVER_CONFIGURATION_CLP_GUID": [
        0x345ECC0E,
        0x0CB6,
        0x4B75,
        0xBB,
        0x57,
        0x1B,
        0x12,
        0x9C,
        0x47,
        0x33,
        0x3E,
    ],
    "EFI_PLATFORM_TO_DRIVER_CONFIGURATION_PROTOCOL_GUID": [
        0x642CD590,
        0x8059,
        0x4C0A,
        0xA9,
        0x58,
        0xC5,
        0xEC,
        0x07,
        0xD2,
        0x3C,
        0x4B,
    ],
    "EFI_PRIMARY_CONSOLE_IN_DEVICE_GUID": [
        0xE451DCBE,
        0x96A1,
        0x4729,
        0xA5,
        0xCF,
        0x6B,
        0x9C,
        0x2C,
        0xFF,
        0x47,
        0xFD,
    ],
    "EFI_PRIMARY_CONSOLE_OUT_DEVICE_GUID": [
        0x62BDF38A,
        0xE3D5,
        0x492C,
        0x95,
        0xC,
        0x23,
        0xA7,
        0xF6,
        0x6E,
        0x67,
        0x2E,
    ],
    "EFI_PRIMARY_STANDARD_ERROR_DEVICE_GUID": [
        0x5A68191B,
        0x9B97,
        0x4752,
        0x99,
        0x46,
        0xE3,
        0x6A,
        0x5D,
        0xA9,
        0x42,
        0xB1,
    ],
    "EFI_PRINT2_PROTOCOL_GUID": [
        0xF05976EF,
        0x83F1,
        0x4F3D,
        0x86,
        0x19,
        0xF7,
        0x59,
        0x5D,
        0x41,
        0xE5,
        0x38,
    ],
    "EFI_PRINT_PROTOCOL_GUID": [
        0xDF2D868E,
        0x32FC,
        0x4CF0,
        0x8E,
        0x6B,
        0xFF,
        0xD9,
        0x5D,
        0x13,
        0x43,
        0xD0,
    ],
    "EFI_PROCESSOR_PRODUCER_GUID": [
        0x1BF06AEA,
        0x5BEC,
        0x4A8D,
        0x95,
        0x76,
        0x74,
        0x9B,
        0x09,
        0x56,
        0x2D,
        0x30,
    ],
    "EFI_PROCESSOR_SUBCLASS_GUID": [
        0x26FDEB7E,
        0xB8AF,
        0x4CCF,
        0xAA,
        0x97,
        0x02,
        0x63,
        0x3C,
        0xE4,
        0x8C,
        0xA7,
    ],
    "EFI_PS2_POLICY_PROTOCOL_GUID": [
        0x4DF19259,
        0xDC71,
        0x4D46,
        0xBE,
        0xF1,
        0x35,
        0x7B,
        0xB5,
        0x78,
        0xC4,
        0x18,
    ],
    "EFI_PXE_BASE_CODE_CALLBACK_PROTOCOL_GUID": [
        0x245DCA21,
        0xFB7B,
        0x11D3,
        0x8F,
        0x01,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_PXE_BASE_CODE_PROTOCOL_GUID": [
        0x03C4E603,
        0xAC28,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PXE_DHCP4_CALLBACK_PROTOCOL_GUID": [
        0xC1544C01,
        0x92A4,
        0x4198,
        0x8A,
        0x84,
        0x77,
        0x85,
        0x83,
        0xC2,
        0x36,
        0x21,
    ],
    "EFI_PXE_DHCP4_PROTOCOL_GUID": [
        0x03C4E624,
        0xAC28,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x29,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_REAL_TIME_CLOCK_ARCH_PROTOCOL_GUID": [
        0x27CFAC87,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_RESET_ARCH_PROTOCOL_GUID": [
        0x27CFAC88,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_RSC_HANDLER_PROTOCOL_GUID": [
        0x86212936,
        0xE76,
        0x41C8,
        0xA0,
        0x3A,
        0x2A,
        0xF2,
        0xFC,
        0x1C,
        0x39,
        0xE2,
    ],
    "EFI_RUNTIME_ARCH_PROTOCOL_GUID": [
        0xB7DFB4E1,
        0x52F,
        0x449F,
        0x87,
        0xBE,
        0x98,
        0x18,
        0xFC,
        0x91,
        0xB7,
        0x33,
    ],
    "EFI_RUNTIME_CRYPT_PROTOCOL_GUID": [
        0xE1475E0C,
        0x1746,
        0x4802,
        0x86,
        0x2E,
        0x1,
        0x1C,
        0x2C,
        0x2D,
        0x9D,
        0x86,
    ],
    "EFI_S3_SAVE_STATE_PROTOCOL_GUID": [
        0xE857CAF6,
        0xC046,
        0x45DC,
        0xBE,
        0x3F,
        0xEE,
        0x7,
        0x65,
        0xFB,
        0xA8,
        0x87,
    ],
    "EFI_S3_SMM_SAVE_STATE_PROTOCOL_GUID": [
        0x320AFE62,
        0xE593,
        0x49CB,
        0xA9,
        0xF1,
        0xD4,
        0xC2,
        0xF4,
        0xAF,
        0x1,
        0x4C,
    ],
    "EFI_SAL_MCA_INIT_PMI_PROTOCOL_GUID": [
        0xB60DC6E8,
        0x3B6F,
        0x11D5,
        0xAF,
        0x9,
        0x0,
        0xA0,
        0xC9,
        0x44,
        0xA0,
        0x5B,
    ],
    "EFI_SAL_SYSTEM_TABLE_GUID": [
        0xEB9D2D32,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_SAS_DEVICE_PATH_GUID": [
        0xD487DDB4,
        0x008B,
        0x11D9,
        0xAF,
        0xDC,
        0x00,
        0x10,
        0x83,
        0xFF,
        0xCA,
        0x4D,
    ],
    "EFI_SCSI_BUS_PROTOCOL_GUID": [
        0x5261213D,
        0x3A3D,
        0x441E,
        0xB3,
        0xAF,
        0x21,
        0xD3,
        0xF7,
        0xA4,
        0xCA,
        0x17,
    ],
    "EFI_SCSI_IO_PROTOCOL_GUID": [
        0x932F47E6,
        0x2362,
        0x4002,
        0x80,
        0x3E,
        0x3C,
        0xD5,
        0x4B,
        0x13,
        0x8F,
        0x85,
    ],
    "EFI_SCSI_PASS_THRU_PROTOCOL_GUID": [
        0xA59E8FCF,
        0xBDA0,
        0x43BB,
        0x90,
        0xB1,
        0xD3,
        0x73,
        0x2E,
        0xCA,
        0xA8,
        0x77,
    ],
    "EFI_SECTION_EXTRACTION_PROTOCOL_GUID": [
        0x448F5DA4,
        0x6DD7,
        0x4FE1,
        0x93,
        0x07,
        0x69,
        0x22,
        0x41,
        0x92,
        0x21,
        0x5D,
    ],
    "EFI_SECURITY2_ARCH_PROTOCOL_GUID": [
        0x94AB2F58,
        0x1438,
        0x4EF1,
        0x91,
        0x52,
        0x18,
        0x94,
        0x1A,
        0x3A,
        0x0E,
        0x68,
    ],
    "EFI_SECURITY_ARCH_PROTOCOL_GUID": [
        0xA46423E3,
        0x4617,
        0x49F1,
        0xB9,
        0xFF,
        0xD1,
        0xBF,
        0xA9,
        0x11,
        0x58,
        0x39,
    ],
    "EFI_SECURITY_POLICY_PROTOCOL_GUID": [
        0x78E4D245,
        0xCD4D,
        0x4A05,
        0xA2,
        0xBA,
        0x47,
        0x43,
        0xE8,
        0x6C,
        0xFC,
        0xAB,
    ],
    "EFI_SEC_PLATFORM_INFORMATION_GUID": [
        0x6F8C2B35,
        0xFEF4,
        0x448D,
        0x82,
        0x56,
        0xE1,
        0x1B,
        0x19,
        0xD6,
        0x10,
        0x77,
    ],
    "EFI_SERIAL_IO_PROTOCOL_GUID": [
        0xBB25CF6F,
        0xF1D4,
        0x11D2,
        0x9A,
        0x0C,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0xFD,
    ],
    "EFI_SE_EXT_SIGNATURE_GUID": [
        0xD2C18636,
        0x40E5,
        0x4EB5,
        0xA3,
        0x1B,
        0x36,
        0x69,
        0x5F,
        0xD4,
        0x2C,
        0x87,
    ],
    "EFI_SHELLPKG_TOKEN_SPACE_GUID": [
        0x171E9188,
        0x31D3,
        0x40F5,
        0xB1,
        0xC,
        0x53,
        0x9B,
        0x2D,
        0xB9,
        0x40,
        0xCD,
    ],
    "EFI_SHELL_FILE_GUID": [
        0xC57AD6B7,
        0x0515,
        0x40A8,
        0x9D,
        0x21,
        0x55,
        0x16,
        0x52,
        0x85,
        0x4E,
        0x37,
    ],
    "EFI_SHELL_PARAMETERS_PROTOCOL_GUID": [
        0x752F3136,
        0x4E16,
        0x4FDC,
        0xA2,
        0x2A,
        0xE5,
        0xF4,
        0x68,
        0x12,
        0xF4,
        0xCA,
    ],
    "EFI_SHELL_PROTOCOL_GUID": [
        0x6302D008,
        0x7F9B,
        0x4F30,
        0x87,
        0xAC,
        0x60,
        0xC9,
        0xFE,
        0xF5,
        0xDA,
        0x4E,
    ],
    "EFI_SIMPLE_FILE_SYSTEM_PROTOCOL_GUID": [
        0x964E5B22,
        0x6459,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_SIMPLE_NETWORK_PROTOCOL_GUID": [
        0xA19832B9,
        0xAC25,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_SIMPLE_POINTER_PROTOCOL_GUID": [
        0x31878C87,
        0xB75,
        0x11D5,
        0x9A,
        0x4F,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_SIMPLE_TEXT_INPUT_EX_PROTOCOL_GUID": [
        0xDD9E7534,
        0x7762,
        0x4698,
        0x8C,
        0x14,
        0xF5,
        0x85,
        0x17,
        0xA6,
        0x25,
        0xAA,
    ],
    "EFI_SIMPLE_TEXT_INPUT_PROTOCOL_GUID": [
        0x387477C1,
        0x69C7,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_SIMPLE_TEXT_IN_PROTOCOL_GUID": [
        0x387477C1,
        0x69C7,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_SIMPLE_TEXT_OUTPUT_PROTOCOL_GUID": [
        0x387477C2,
        0x69C7,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_SIMPLE_TEXT_OUT_PROTOCOL_GUID": [
        0x387477C2,
        0x69C7,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_SIO_PROTOCOL_GUID": [
        0x215FDD18,
        0xBD50,
        0x4FEB,
        0x89,
        0xB,
        0x58,
        0xCA,
        0xB,
        0x47,
        0x39,
        0xE9,
    ],
    "EFI_SMBIOS_PROTOCOL_GUID": [
        0x3583FF6,
        0xCB36,
        0x4940,
        0x94,
        0x7E,
        0xB9,
        0xB3,
        0x9F,
        0x4A,
        0xFA,
        0xF7,
    ],
    "EFI_SMBIOS_TABLE_GUID": [
        0xEB9D2D31,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_SMBUS_HC_PROTOCOL_GUID": [
        0xE49D33ED,
        0x513D,
        0x4634,
        0xB6,
        0x98,
        0x6F,
        0x55,
        0xAA,
        0x75,
        0x1C,
        0x1B,
    ],
    "EFI_SMM_ACCESS2_PROTOCOL_GUID": [
        0xC2702B74,
        0x800C,
        0x4131,
        0x87,
        0x46,
        0x8F,
        0xB5,
        0xB8,
        0x9C,
        0xE4,
        0xAC,
    ],
    "EFI_SMM_ACCESS_PROTOCOL_GUID": [
        0x3792095A,
        0xE309,
        0x4C1E,
        0xAA,
        0x01,
        0x85,
        0xF5,
        0x65,
        0x5A,
        0x17,
        0xF1,
    ],
    "EFI_SMM_BASE2_PROTOCOL_GUID": [
        0xF4CCBFB7,
        0xF6E0,
        0x47FD,
        0x9D,
        0xD4,
        0x10,
        0xA8,
        0xF1,
        0x50,
        0xC1,
        0x91,
    ],
    "EFI_SMM_BASE_HELPER_READY_PROTOCOL_GUID": [
        0x910DCA07,
        0x1F94,
        0x4EE7,
        0xAF,
        0x2F,
        0xFF,
        0x72,
        0xF3,
        0x15,
        0x43,
        0x53,
    ],
    "EFI_SMM_BASE_PROTOCOL_GUID": [
        0x1390954D,
        0xDA95,
        0x4227,
        0x93,
        0x28,
        0x72,
        0x82,
        0xC2,
        0x17,
        0xDA,
        0xA8,
    ],
    "EFI_SMM_COMMUNICATION_PROTOCOL_GUID": [
        0xC68ED8E2,
        0x9DC6,
        0x4CBD,
        0x9D,
        0x94,
        0xDB,
        0x65,
        0xAC,
        0xC5,
        0xC3,
        0x32,
    ],
    "EFI_SMM_CONFIGURATION_PROTOCOL_GUID": [
        0x26EEB3DE,
        0xB689,
        0x492E,
        0x80,
        0xF0,
        0xBE,
        0x8B,
        0xD7,
        0xDA,
        0x4B,
        0xA7,
    ],
    "EFI_SMM_CONTROL2_PROTOCOL_GUID": [
        0x843DC720,
        0xAB1E,
        0x42CB,
        0x93,
        0x57,
        0x8A,
        0x0,
        0x78,
        0xF3,
        0x56,
        0x1B,
    ],
    "EFI_SMM_CONTROL_PROTOCOL_GUID": [
        0x8D12E231,
        0xC667,
        0x4FD1,
        0x98,
        0xF2,
        0x24,
        0x49,
        0xA7,
        0xE7,
        0xB2,
        0xE5,
    ],
    "EFI_SMM_CPU_IO2_PROTOCOL_GUID": [
        0x3242A9D8,
        0xCE70,
        0x4AA0,
        0x95,
        0x5D,
        0x5E,
        0x7B,
        0x14,
        0x0D,
        0xE4,
        0xD2,
    ],
    "EFI_SMM_CPU_IO_GUID": [
        0x5F439A0B,
        0x45D8,
        0x4682,
        0xA4,
        0xF4,
        0xF0,
        0x57,
        0x6B,
        0x51,
        0x34,
        0x41,
    ],
    "EFI_SMM_CPU_PROTOCOL_GUID": [
        0xEB346B97,
        0x975F,
        0x4A9F,
        0x8B,
        0x22,
        0xF8,
        0xE9,
        0x2B,
        0xB3,
        0xD5,
        0x69,
    ],
    "EFI_SMM_CPU_SAVE_STATE_PROTOCOL_GUID": [
        0x21F302AD,
        0x6E94,
        0x471B,
        0x84,
        0xBC,
        0xB1,
        0x48,
        0x0,
        0x40,
        0x3A,
        0x1D,
    ],
    "EFI_SMM_END_OF_DXE_PROTOCOL_GUID": [
        0x24E70042,
        0xD5C5,
        0x4260,
        0x8C,
        0x39,
        0xA,
        0xD3,
        0xAA,
        0x32,
        0xE9,
        0x3D,
    ],
    "EFI_SMM_FAULT_TOLERANT_WRITE_PROTOCOL_GUID": [
        0x3868FC3B,
        0x7E45,
        0x43A7,
        0x90,
        0x6C,
        0x4B,
        0xA4,
        0x7D,
        0xE1,
        0x75,
        0x4D,
    ],
    "EFI_SMM_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID": [
        0xD326D041,
        0xBD31,
        0x4C01,
        0xB5,
        0xA8,
        0x62,
        0x8B,
        0xE8,
        0x7F,
        0x6,
        0x53,
    ],
    "EFI_SMM_GPI_DISPATCH2_PROTOCOL_GUID": [
        0x25566B03,
        0xB577,
        0x4CBF,
        0x95,
        0x8C,
        0xED,
        0x66,
        0x3E,
        0xA2,
        0x43,
        0x80,
    ],
    "EFI_SMM_GPI_DISPATCH_PROTOCOL_GUID": [
        0xE0744B81,
        0x9513,
        0x49CD,
        0x8C,
        0xEA,
        0xE9,
        0x24,
        0x5E,
        0x70,
        0x39,
        0xDA,
    ],
    "EFI_SMM_ICHN_DISPATCH_PROTOCOL_GUID": [
        0xC50B323E,
        0x9075,
        0x4F2A,
        0xAC,
        0x8E,
        0xD2,
        0x59,
        0x6A,
        0x10,
        0x85,
        0xCC,
    ],
    "EFI_SMM_IO_TRAP_DISPATCH2_PROTOCOL_GUID": [
        0x58DC368D,
        0x7BFA,
        0x4E77,
        0xAB,
        0xBC,
        0xE,
        0x29,
        0x41,
        0x8D,
        0xF9,
        0x30,
    ],
    "EFI_SMM_LOCK_BOX_COMMUNICATION_GUID": [
        0x2A3CFEBD,
        0x27E8,
        0x4D0A,
        0x8B,
        0x79,
        0xD6,
        0x88,
        0xC2,
        0xA3,
        0xE1,
        0xC0,
    ],
    "EFI_SMM_PCI_ROOT_BRIDGE_IO_PROTOCOL_GUID": [
        0x8BC1714D,
        0xFFCB,
        0x41C3,
        0x89,
        0xDC,
        0x6C,
        0x74,
        0xD0,
        0x6D,
        0x98,
        0xEA,
    ],
    "EFI_SMM_PERIODIC_TIMER_DISPATCH2_PROTOCOL_GUID": [
        0x4CEC368E,
        0x8E8E,
        0x4D71,
        0x8B,
        0xE1,
        0x95,
        0x8C,
        0x45,
        0xFC,
        0x8A,
        0x53,
    ],
    "EFI_SMM_PERIODIC_TIMER_DISPATCH_PROTOCOL_GUID": [
        0x9CCA03FC,
        0x4C9E,
        0x4A19,
        0x9B,
        0x6,
        0xED,
        0x7B,
        0x47,
        0x9B,
        0xDE,
        0x55,
    ],
    "EFI_SMM_POWER_BUTTON_DISPATCH2_PROTOCOL_GUID": [
        0x1B1183FA,
        0x1823,
        0x46A7,
        0x88,
        0x72,
        0x9C,
        0x57,
        0x87,
        0x55,
        0x40,
        0x9D,
    ],
    "EFI_SMM_POWER_BUTTON_DISPATCH_PROTOCOL_GUID": [
        0xB709EFA0,
        0x47A6,
        0x4B41,
        0xB9,
        0x31,
        0x12,
        0xEC,
        0xE7,
        0xA8,
        0xEE,
        0x56,
    ],
    "EFI_SMM_READY_TO_LOCK_PROTOCOL_GUID": [
        0x47B7FA8C,
        0xF4BD,
        0x4AF6,
        0x82,
        0x00,
        0x33,
        0x30,
        0x86,
        0xF0,
        0xD2,
        0xC8,
    ],
    "EFI_SMM_RSC_HANDLER_PROTOCOL_GUID": [
        0x2FF29FA7,
        0x5E80,
        0x4ED9,
        0xB3,
        0x80,
        0x1,
        0x7D,
        0x3C,
        0x55,
        0x4F,
        0xF4,
    ],
    "EFI_SMM_STANDBY_BUTTON_DISPATCH2_PROTOCOL_GUID": [
        0x7300C4A1,
        0x43F2,
        0x4017,
        0xA5,
        0x1B,
        0xC8,
        0x1A,
        0x7F,
        0x40,
        0x58,
        0x5B,
    ],
    "EFI_SMM_STANDBY_BUTTON_DISPATCH_PROTOCOL_GUID": [
        0x78965B98,
        0xB0BF,
        0x449E,
        0x8B,
        0x22,
        0xD2,
        0x91,
        0x4E,
        0x49,
        0x8A,
        0x98,
    ],
    "EFI_SMM_STATUS_CODE_PROTOCOL_GUID": [
        0x6AFD2B77,
        0x98C1,
        0x4ACD,
        0xA6,
        0xF9,
        0x8A,
        0x94,
        0x39,
        0xDE,
        0xF,
        0xB1,
    ],
    "EFI_SMM_SWAP_ADDRESS_RANGE_PROTOCOL_GUID": [
        0x67C4F112,
        0x3385,
        0x4E55,
        0x9C,
        0x5B,
        0xC0,
        0x5B,
        0x71,
        0x7C,
        0x42,
        0x28,
    ],
    "EFI_SMM_SW_DISPATCH2_PROTOCOL_GUID": [
        0x18A3C6DC,
        0x5EEA,
        0x48C8,
        0xA1,
        0xC1,
        0xB5,
        0x33,
        0x89,
        0xF9,
        0x89,
        0x99,
    ],
    "EFI_SMM_SW_DISPATCH_PROTOCOL_GUID": [
        0xE541B773,
        0xDD11,
        0x420C,
        0xB0,
        0x26,
        0xDF,
        0x99,
        0x36,
        0x53,
        0xF8,
        0xBF,
    ],
    "EFI_SMM_SX_DISPATCH2_PROTOCOL_GUID": [
        0x456D2859,
        0xA84B,
        0x4E47,
        0xA2,
        0xEE,
        0x32,
        0x76,
        0xD8,
        0x86,
        0x99,
        0x7D,
    ],
    "EFI_SMM_SX_DISPATCH_PROTOCOL_GUID": [
        0x14FC52BE,
        0x1DC,
        0x426C,
        0x91,
        0xAE,
        0xA2,
        0x3C,
        0x3E,
        0x22,
        0xA,
        0xE8,
    ],
    "EFI_SMM_USB_DISPATCH2_PROTOCOL_GUID": [
        0xEE9B8D90,
        0xC5A6,
        0x40A2,
        0xBD,
        0xE2,
        0x52,
        0x55,
        0x8D,
        0x33,
        0xCC,
        0xA1,
    ],
    "EFI_SMM_USB_DISPATCH_PROTOCOL_GUID": [
        0xA05B6FFD,
        0x87AF,
        0x4E42,
        0x95,
        0xC9,
        0x62,
        0x28,
        0xB6,
        0x3C,
        0xF3,
        0xF3,
    ],
    "EFI_SMM_VARIABLE_PROTOCOL_GUID": [
        0xED32D533,
        0x99E6,
        0x4209,
        0x9C,
        0xC0,
        0x2D,
        0x72,
        0xCD,
        0xD9,
        0x98,
        0xA7,
    ],
    "EFI_SMM_VARIABLE_WRITE_GUID": [
        0x93BA1826,
        0xDFFB,
        0x45DD,
        0x82,
        0xA7,
        0xE7,
        0xDC,
        0xAA,
        0x3B,
        0xBD,
        0xF3,
    ],
    "EFI_STANDARD_CALLER_ID_GUID": [
        0xC9DCF469,
        0xA7C4,
        0x11D5,
        0x87,
        0xDA,
        0x00,
        0x06,
        0x29,
        0x45,
        0xC3,
        0xB9,
    ],
    "EFI_STANDARD_ERROR_DEVICE_GUID": [
        0xD3B36F2D,
        0xD551,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_ASSERT_GUID": [
        0xDA571595,
        0x4D99,
        0x487C,
        0x82,
        0x7C,
        0x26,
        0x22,
        0x67,
        0x7D,
        0x33,
        0x07,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_DEBUG_GUID": [
        0x9A4E9246,
        0xD553,
        0x11D5,
        0x87,
        0xE2,
        0x00,
        0x06,
        0x29,
        0x45,
        0xC3,
        0xB9,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_ERROR_GUID": [
        0xAB359CE3,
        0x99B3,
        0xAE18,
        0xC8,
        0x9D,
        0x95,
        0xD3,
        0xB0,
        0x72,
        0xE1,
        0x9B,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_EXCEPTION_HANDLER_GUID": [
        0x3BC2BD12,
        0xAD2E,
        0x11D5,
        0x87,
        0xDD,
        0x00,
        0x06,
        0x29,
        0x45,
        0xC3,
        0xB9,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_PROGRESS_CODE_GUID": [
        0xA356AB39,
        0x35C4,
        0x35DA,
        0xB3,
        0x7A,
        0xF8,
        0xEA,
        0x9E,
        0x8B,
        0x36,
        0xA3,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_STRING_GUID": [
        0x92D11080,
        0x496F,
        0x4D95,
        0xBE,
        0x7E,
        0x03,
        0x74,
        0x88,
        0x38,
        0x2B,
        0x0A,
    ],
    "EFI_STATUS_CODE_GUID": [
        0xD083E94C,
        0x6560,
        0x42E4,
        0xB6,
        0xD4,
        0x2D,
        0xF7,
        0x5A,
        0xDF,
        0x6A,
        0x2A,
    ],
    "EFI_STATUS_CODE_RUNTIME_PROTOCOL_GUID": [
        0xD2B2B828,
        0x826,
        0x48A7,
        0xB3,
        0xDF,
        0x98,
        0x3C,
        0x0,
        0x60,
        0x24,
        0xF0,
    ],
    "EFI_STATUS_CODE_SPECIFIC_DATA_GUID": [
        0x335984BD,
        0xE805,
        0x409A,
        0xB8,
        0xF8,
        0xD2,
        0x7E,
        0xCE,
        0x5F,
        0xF7,
        0xA6,
    ],
    "EFI_STORAGE_SECURITY_COMMAND_PROTOCOL_GUID": [
        0xC88B0B6D,
        0x0DFC,
        0x49A7,
        0x9C,
        0xB4,
        0x49,
        0x07,
        0x4B,
        0x4C,
        0x3A,
        0x78,
    ],
    "EFI_SWAP_ADDRESS_RANGE_PROTOCOL_GUID": [
        0x1259F60D,
        0xB754,
        0x468E,
        0xA7,
        0x89,
        0x4D,
        0xB8,
        0x5D,
        0x55,
        0xE8,
        0x7E,
    ],
    "EFI_SYSTEM_NV_DATA_FV_GUID": [
        0xFFF12B8D,
        0x7696,
        0x4C8B,
        0xA9,
        0x85,
        0x27,
        0x47,
        0x7,
        0x5B,
        0x4F,
        0x50,
    ],
    "EFI_SYSTEM_NV_DATA_HOB_GUID": [
        0xD6E5092D,
        0xC7B2,
        0x4872,
        0xAF,
        0x66,
        0xFD,
        0xC0,
        0xE6,
        0xF9,
        0x5E,
        0x78,
    ],
    "EFI_TAPE_IO_PROTOCOL_GUID": [
        0x1E93E633,
        0xD65A,
        0x459E,
        0xAB,
        0x84,
        0x93,
        0xD9,
        0xEC,
        0x26,
        0x6D,
        0x18,
    ],
    "EFI_TCG_EVENT_HOB_GUID": [
        0x2E3044AC,
        0x879F,
        0x490F,
        0x97,
        0x60,
        0xBB,
        0xDF,
        0xAF,
        0x69,
        0x5F,
        0x50,
    ],
    "EFI_TCG_PLATFORM_PROTOCOL_GUID": [
        0x8C4C9A41,
        0xBF56,
        0x4627,
        0x9E,
        0xA,
        0xC8,
        0x38,
        0x6D,
        0x66,
        0x11,
        0x5C,
    ],
    "EFI_TCG_PROTOCOL_GUID": [
        0xF541796D,
        0xA62E,
        0x4954,
        0xA7,
        0x75,
        0x95,
        0x84,
        0xF6,
        0x1B,
        0x9C,
        0xDD,
    ],
    "EFI_TCP4_PROTOCOL_GUID": [
        0x65530BC7,
        0xA359,
        0x410F,
        0xB0,
        0x10,
        0x5A,
        0xAD,
        0xC7,
        0xEC,
        0x2B,
        0x62,
    ],
    "EFI_TCP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0x00720665,
        0x67EB,
        0x4A99,
        0xBA,
        0xF7,
        0xD3,
        0xC3,
        0x3A,
        0x1C,
        0x7C,
        0xC9,
    ],
    "EFI_TCP6_PROTOCOL_GUID": [
        0x46E44855,
        0xBD60,
        0x4AB7,
        0xAB,
        0x0D,
        0xA6,
        0x79,
        0xB9,
        0x44,
        0x7D,
        0x77,
    ],
    "EFI_TCP6_SERVICE_BINDING_PROTOCOL_GUID": [
        0xEC20EB79,
        0x6C1A,
        0x4664,
        0x9A,
        0x0D,
        0xD2,
        0xE4,
        0xCC,
        0x16,
        0xD6,
        0x64,
    ],
    "EFI_TCP_PROTOCOL_GUID": [
        0x02B3D5F2,
        0xAC28,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_TIANO_DECOMPRESS_PROTOCOL_GUID": [
        0xE84CF29C,
        0x191F,
        0x4EAE,
        0x96,
        0xE1,
        0xF4,
        0x6A,
        0xEC,
        0xEA,
        0xEA,
        0x0B,
    ],
    "EFI_TIMER_ARCH_PROTOCOL_GUID": [
        0x26BACCB3,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_TSC_FREQUENCY_GUID": [
        0xDBA6A7E3,
        0xBB57,
        0x4BE7,
        0x8A,
        0xF8,
        0xD5,
        0x78,
        0xDB,
        0x7E,
        0x56,
        0x87,
    ],
    "EFI_UART_DEVICE_PATH_GUID": [
        0x37499A9D,
        0x542F,
        0x4C89,
        0xA0,
        0x26,
        0x35,
        0xDA,
        0x14,
        0x20,
        0x94,
        0xE4,
    ],
    "EFI_UDP4_PROTOCOL_GUID": [
        0x3AD9DF29,
        0x4501,
        0x478D,
        0xB1,
        0xF8,
        0x7F,
        0x7F,
        0xE7,
        0x0E,
        0x50,
        0xF3,
    ],
    "EFI_UDP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0x83F01464,
        0x99BD,
        0x45E5,
        0xB3,
        0x83,
        0xAF,
        0x63,
        0x05,
        0xD8,
        0xE9,
        0xE6,
    ],
    "EFI_UDP6_PROTOCOL_GUID": [
        0x4F948815,
        0xB4B9,
        0x43CB,
        0x8A,
        0x33,
        0x90,
        0xE0,
        0x60,
        0xB3,
        0x49,
        0x55,
    ],
    "EFI_UDP6_SERVICE_BINDING_PROTOCOL_GUID": [
        0x66ED4721,
        0x3C98,
        0x4D3E,
        0x81,
        0xE3,
        0xD0,
        0x3D,
        0xD3,
        0x9A,
        0x72,
        0x54,
    ],
    "EFI_UGA_DRAW_PROTOCOL_GUID": [
        0x982C298B,
        0xF4FA,
        0x41CB,
        0xB8,
        0x38,
        0x77,
        0xAA,
        0x68,
        0x8F,
        0xB8,
        0x39,
    ],
    "EFI_UGA_IO_PROTOCOL_GUID": [
        0x61A4D49E,
        0x6F68,
        0x4F1B,
        0xB9,
        0x22,
        0xA8,
        0x6E,
        0xED,
        0xB,
        0x7,
        0xA2,
    ],
    "EFI_UGA_SPLASH_PROTOCOL_GUID": [
        0xA45B3A0D,
        0x2E55,
        0x4C03,
        0xAD,
        0x9C,
        0x27,
        0xD4,
        0x82,
        0xB,
        0x50,
        0x7E,
    ],
    "EFI_UNICODE_COLLATION2_PROTOCOL_GUID": [
        0xA4C751FC,
        0x23AE,
        0x4C3E,
        0x92,
        0xE9,
        0x49,
        0x64,
        0xCF,
        0x63,
        0xF3,
        0x49,
    ],
    "EFI_UNICODE_COLLATION_PROTOCOL2_GUID": [
        0xA4C751FC,
        0x23AE,
        0x4C3E,
        0x92,
        0xE9,
        0x49,
        0x64,
        0xCF,
        0x63,
        0xF3,
        0x49,
    ],
    "EFI_UNICODE_COLLATION_PROTOCOL_GUID": [
        0x1D85CD7F,
        0xF43D,
        0x11D2,
        0x9A,
        0xC,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_UNIX_CONSOLE_GUID": [
        0xF2CC5D06,
        0x8985,
        0x11DB,
        0xBB,
        0x19,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_CPU_MODEL_GUID": [
        0xF2D3B330,
        0x8985,
        0x11DB,
        0x8A,
        0xA3,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_CPU_SPEED_GUID": [
        0xF2D74E5A,
        0x8985,
        0x11DB,
        0x97,
        0x05,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_FILE_SYSTEM_GUID": [
        0xF2C16B9E,
        0x8985,
        0x11DB,
        0x92,
        0xC8,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_GOP_GUID": [
        0xBACE07C2,
        0x8987,
        0x11DB,
        0xA5,
        0x9A,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_IO_PROTOCOL_GUID": [
        0xF2E23F54,
        0x8985,
        0x11DB,
        0xAC,
        0x79,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_MEMORY_GUID": [
        0xF2D006CC,
        0x8985,
        0x11DB,
        0xA4,
        0x72,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_NETWORK_GUID": [
        0x081603B4,
        0x0F1D,
        0x4022,
        0xB6,
        0xFD,
        0x4C,
        0xE3,
        0x5E,
        0x09,
        0xA1,
        0xA6,
    ],
    "EFI_UNIX_PHYSICAL_DISKS_GUID": [
        0xF2BDCC96,
        0x8985,
        0x11DB,
        0x87,
        0x19,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_SERIAL_PORT_GUID": [
        0x6D3A727D,
        0x66C8,
        0x4D19,
        0x87,
        0xE6,
        0x2,
        0x15,
        0x86,
        0x14,
        0x90,
        0xF3,
    ],
    "EFI_UNIX_THUNK_PROTOCOL_GUID": [
        0xF2E98868,
        0x8985,
        0x11DB,
        0x9A,
        0x59,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_UGA_GUID": [
        0xF2C8B80E,
        0x8985,
        0x11DB,
        0x93,
        0xF1,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_UGA_IO_PROTOCOL_GUID": [
        0xF2E5E2C6,
        0x8985,
        0x11DB,
        0xA1,
        0x91,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UNIX_VIRTUAL_DISKS_GUID": [
        0xF2BA331A,
        0x8985,
        0x11DB,
        0xA4,
        0x06,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "EFI_UPDATE_DATA_FILE_GUID": [
        0x283FA2EE,
        0x532C,
        0x484D,
        0x93,
        0x83,
        0x9F,
        0x93,
        0xB3,
        0x6F,
        0xB,
        0x7E,
    ],
    "EFI_USB2_HC_PROTOCOL_GUID": [
        0x3E745226,
        0x9818,
        0x45B6,
        0xA2,
        0xAC,
        0xD7,
        0xCD,
        0xE,
        0x8B,
        0xA2,
        0xBC,
    ],
    "EFI_USB_ATAPI_PROTOCOL_GUID": [
        0x2B2F68DA,
        0x0CD2,
        0x44CF,
        0x8E,
        0x8B,
        0xBB,
        0xA2,
        0x0B,
        0x1B,
        0x5B,
        0x75,
    ],
    "EFI_USB_BUS_PROTOCOL_GUID": [
        0x2B2F68CC,
        0x0CD2,
        0x44CF,
        0x8E,
        0x8B,
        0xBB,
        0xA2,
        0x0B,
        0x1B,
        0x5B,
        0x75,
    ],
    "EFI_USB_HC_PROTOCOL_GUID": [
        0xF5089266,
        0x1AA0,
        0x4953,
        0x97,
        0xD8,
        0x56,
        0x2F,
        0x8A,
        0x73,
        0xB5,
        0x19,
    ],
    "EFI_USB_IO_PROTOCOL_GUID": [
        0x2B2F68D6,
        0x0CD2,
        0x44CF,
        0x8E,
        0x8B,
        0xBB,
        0xA2,
        0x0B,
        0x1B,
        0x5B,
        0x75,
    ],
    "EFI_USER_CREDENTIAL2_PROTOCOL_GUID": [
        0xE98ADB03,
        0xB8B9,
        0x4AF8,
        0xBA,
        0x20,
        0x26,
        0xE9,
        0x11,
        0x4C,
        0xBC,
        0xE5,
    ],
    "EFI_USER_CREDENTIAL_PROTOCOL_GUID": [
        0x71EE5E94,
        0x65B9,
        0x45D5,
        0x82,
        0x1A,
        0x3A,
        0x4D,
        0x86,
        0xCF,
        0xE6,
        0xBE,
    ],
    "EFI_USER_INFO_ACCESS_SETUP_ADMIN_GUID": [
        0x85B75607,
        0xF7CE,
        0x471E,
        0xB7,
        0xE4,
        0x2A,
        0xEA,
        0x5F,
        0x72,
        0x32,
        0xEE,
    ],
    "EFI_USER_INFO_ACCESS_SETUP_NORMAL_GUID": [
        0x1DB29AE0,
        0x9DCB,
        0x43BC,
        0x8D,
        0x87,
        0x5D,
        0xA1,
        0x49,
        0x64,
        0xDD,
        0xE2,
    ],
    "EFI_USER_INFO_ACCESS_SETUP_RESTRICTED_GUID": [
        0xBDB38125,
        0x4D63,
        0x49F4,
        0x82,
        0x12,
        0x61,
        0xCF,
        0x5A,
        0x19,
        0xA,
        0xF8,
    ],
    "EFI_USER_MANAGER_PROTOCOL_GUID": [
        0x6FD5B00C,
        0xD426,
        0x4283,
        0x98,
        0x87,
        0x6C,
        0xF5,
        0xCF,
        0x1C,
        0xB1,
        0xFE,
    ],
    "EFI_UXIX_SYSTEM_CONFIG_GUID": [
        0x375EA976,
        0x3CCD,
        0x4E74,
        0xA8,
        0x45,
        0x26,
        0xB9,
        0xB3,
        0x24,
        0xB1,
        0x3C,
    ],
    "EFI_VARIABLE_ARCH_PROTOCOL_GUID": [
        0x1E5668E2,
        0x8481,
        0x11D4,
        0xBC,
        0xF1,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_VARIABLE_GUID": [
        0xDDCF3616,
        0x3275,
        0x4164,
        0x98,
        0xB6,
        0xFE,
        0x85,
        0x70,
        0x7F,
        0xFE,
        0x7D,
    ],
    "EFI_VARIABLE_INDEX_TABLE_GUID": [
        0x8CFDB8C8,
        0xD6B2,
        0x40F3,
        0x8E,
        0x97,
        0x02,
        0x30,
        0x7C,
        0xC9,
        0x8B,
        0x7C,
    ],
    "EFI_VARIABLE_STORE_PROTOCOL_GUID": [
        0xF088CD91,
        0xA046,
        0x11D2,
        0x8E,
        0x42,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_VARIABLE_WRITE_ARCH_PROTOCOL_GUID": [
        0x6441F818,
        0x6362,
        0x4E44,
        0xB5,
        0x70,
        0x7D,
        0xBA,
        0x31,
        0xDD,
        0x24,
        0x53,
    ],
    "EFI_VGA_MINI_PORT_PROTOCOL_GUID": [
        0xC7735A2F,
        0x88F5,
        0x4882,
        0xAE,
        0x63,
        0xFA,
        0xAC,
        0x8C,
        0x8B,
        0x86,
        0xB3,
    ],
    "EFI_VIRTUAL_MEMORY_ACCESS_PROTOCOL_GUID": [
        0x745D377A,
        0xB988,
        0x47B2,
        0xB1,
        0x8F,
        0xBB,
        0xC8,
        0xD,
        0xC5,
        0x66,
        0x98,
    ],
    "EFI_VLAN_CONFIG_PROTOCOL_GUID": [
        0x9E23D768,
        0xD2F3,
        0x4366,
        0x9F,
        0xC3,
        0x3A,
        0x7A,
        0xBA,
        0x86,
        0x43,
        0x74,
    ],
    "EFI_VT_100_GUID": [
        0xDFA66065,
        0xB419,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_VT_100_PLUS_GUID": [
        0x7BAEC70B,
        0x57E0,
        0x4C76,
        0x8E,
        0x87,
        0x2F,
        0x9E,
        0x28,
        0x08,
        0x83,
        0x43,
    ],
    "EFI_VT_UTF8_GUID": [
        0xAD15A0D6,
        0x8BEC,
        0x4ACF,
        0xA0,
        0x73,
        0xD0,
        0x1D,
        0xE7,
        0x7E,
        0x2D,
        0x88,
    ],
    "EFI_WATCHDOG_TIMER_ARCH_PROTOCOL_GUID": [
        0x665E3FF5,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_WIN_NT_CONSOLE_GUID": [
        0xBA73672C,
        0xA5D3,
        0x11D4,
        0xBD,
        0x0,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_CPU_MODEL_GUID": [
        0xBEE9B6CE,
        0x2F8A,
        0x11D4,
        0xBD,
        0xD,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_CPU_SPEED_GUID": [
        0xD4F29055,
        0xE1FB,
        0x11D4,
        0xBD,
        0xD,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_FILE_SYSTEM_GUID": [
        0xC95A935,
        0xA006,
        0x11D4,
        0xBC,
        0xFA,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_GOP_GUID": [
        0x4E11E955,
        0xCCCA,
        0x11D4,
        0xBD,
        0xD,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_IO_PROTOCOL_GUID": [
        0x96EB4AD6,
        0xA32A,
        0x11D4,
        0xBC,
        0xFD,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_MEMORY_GUID": [
        0x99042912,
        0x122A,
        0x11D4,
        0xBD,
        0xD,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_PASS_THROUGH_GUID": [
        0xCC664EB8,
        0x3C24,
        0x4086,
        0xB6,
        0xF6,
        0x34,
        0xE8,
        0x56,
        0xBC,
        0xE3,
        0x6E,
    ],
    "EFI_WIN_NT_PHYSICAL_DISKS_GUID": [
        0xC95A92F,
        0xA006,
        0x11D4,
        0xBC,
        0xFA,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_SERIAL_PORT_GUID": [
        0xC95A93D,
        0xA006,
        0x11D4,
        0xBC,
        0xFA,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_SYSTEM_CONFIG_GUID": [
        0xB347F047,
        0xAF8C,
        0x490E,
        0xAC,
        0x07,
        0x0A,
        0xA9,
        0xB7,
        0xE5,
        0x38,
        0x58,
    ],
    "EFI_WIN_NT_THUNK_PROTOCOL_GUID": [
        0x58C518B1,
        0x76F3,
        0x11D4,
        0xBC,
        0xEA,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_UGA_GUID": [
        0xAB248E99,
        0xABE1,
        0x11D4,
        0xBD,
        0xD,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_VIRTUAL_DISKS_GUID": [
        0xC95A928,
        0xA006,
        0x11D4,
        0xBC,
        0xFA,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_XEN_INFO_GUID": [
        0xD3B46F3B,
        0xD441,
        0x1244,
        0x9A,
        0x12,
        0x0,
        0x12,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EMBEDDED_DEVICE_PROTOCOL_GUID": [
        0xBF4B9D10,
        0x13EC,
        0x43DD,
        0x88,
        0x80,
        0xE9,
        0xB,
        0x71,
        0x8F,
        0x27,
        0xDE,
    ],
    "EMBEDDED_EXTERNAL_DEVICE_PROTOCOL_GUID": [
        0x735F8C64,
        0xD696,
        0x44D0,
        0xBD,
        0xF2,
        0x44,
        0x7F,
        0xD0,
        0x5A,
        0x54,
        0x06,
    ],
    "EMU_BLOCK_IO_PROTOCOL_GUID": [
        0x6888A4AE,
        0xAFCE,
        0xE84B,
        0x91,
        0x02,
        0xF7,
        0xB9,
        0xDA,
        0xE6,
        0xA0,
        0x30,
    ],
    "EMU_GRAPHICS_WINDOW_PROTOCOL_GUID": [
        0x30FD316A,
        0x6728,
        0x2E41,
        0xA6,
        0x90,
        0x0D,
        0x13,
        0x33,
        0xD8,
        0xCA,
        0xC1,
    ],
    "EMU_IO_THUNK_PROTOCO_GUID": [
        0x453368F6,
        0x7C85,
        0x434A,
        0xA9,
        0x8A,
        0x72,
        0xD1,
        0xB7,
        0xFF,
        0xA9,
        0x26,
    ],
    "EMU_SNP_PROTOCOL_GUID": [
        0xFD5FBE54,
        0x8C35,
        0xB345,
        0x8A,
        0x0F,
        0x7A,
        0xC8,
        0xA5,
        0xFD,
        0x05,
        0x21,
    ],
    "EMU_THUNK_PPI_GUID": [
        0xB958B78C,
        0x1D3E,
        0xEE40,
        0x8B,
        0xF4,
        0xF0,
        0x63,
        0x2D,
        0x06,
        0x39,
        0x16,
    ],
    "EMU_THUNK_PROTOCOL_GUID": [
        0x5CF32E0B,
        0x8EDF,
        0x2E44,
        0x9C,
        0xDA,
        0x93,
        0x20,
        0x5E,
        0x99,
        0xEC,
        0x1C,
    ],
    "EXTENDED_SAL_BOOT_SERVICE_PROTOCOL_GUID": [
        0xDE0EE9A4,
        0x3C7A,
        0x44F2,
        0xB7,
        0x8B,
        0xE3,
        0xCC,
        0xD6,
        0x9C,
        0x3A,
        0xF7,
    ],
    "EXTENDED_SAL_BOOT_SERVICE_PROTOCOL_GUID": [
        0xDE0EE9A4,
        0x3C7A,
        0x44F2,
        0xB7,
        0x8B,
        0xE3,
        0xCC,
        0xD6,
        0x9C,
        0x3A,
        0xF7,
    ],
    "FFS_GUID": [
        0xAC05BF33,
        0x995A,
        0x4ED4,
        0xAA,
        0xB8,
        0xEF,
        0x7A,
        0xE8,
        0xF,
        0x5C,
        0xB0,
    ],
    "FILE_EXPLORE_FORMSET_GUID": [
        0x1F2D63E1,
        0xFEBD,
        0x4DC7,
        0x9C,
        0xC5,
        0xBA,
        0x2B,
        0x1C,
        0xEF,
        0x9C,
        0x5B,
    ],
    "FILE_GUID": [
        0xCBD2E4D5,
        0x7068,
        0x4FF5,
        0xB4,
        0x62,
        0x98,
        0x22,
        0xB4,
        0xAD,
        0x8D,
        0x60,
    ],
    "FORM_BROWSER_EXTENSION_PROTOCOL_GUID": [
        0x1F73B18D,
        0x4630,
        0x43C1,
        0xA1,
        0xDE,
        0x6F,
        0x80,
        0x85,
        0x5D,
        0x7D,
        0xA4,
    ],
    "FRAMEWORK_BDS_FRONTPAGE_FORMSET_GUID": [
        0x9E0C30BC,
        0x3F06,
        0x4BA6,
        0x82,
        0x88,
        0x9,
        0x17,
        0x9B,
        0x85,
        0x5D,
        0xBE,
    ],
    "FRAMEWORK_EFI_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID": [
        0xDE28BC59,
        0x6228,
        0x41BD,
        0xBD,
        0xF6,
        0xA3,
        0xB9,
        0xAD,
        0xB5,
        0x8D,
        0xA1,
    ],
    "FRAMEWORK_EFI_MP_SERVICES_PROTOCOL_GUID": [
        0xF33261E7,
        0x23CB,
        0x11D5,
        0xBD,
        0x5C,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "FRONT_PAGE_FORMSET_GUID": [
        0x9E0C30BC,
        0x3F06,
        0x4BA6,
        0x82,
        0x88,
        0x9,
        0x17,
        0x9B,
        0x85,
        0x5D,
        0xBE,
    ],
    "HANDLE_PARSING_HII_GUID": [
        0xB8969637,
        0x81DE,
        0x43AF,
        0xBC,
        0x9A,
        0x24,
        0xD9,
        0x89,
        0x13,
        0xF2,
        0xF6,
    ],
    "HD_BOOT_DEVICE_PATH_VARIABLE_GUID": [
        0xFAB7E9E1,
        0x39DD,
        0x4F2B,
        0x84,
        0x8,
        0xE2,
        0xE,
        0x90,
        0x6C,
        0xB6,
        0xDE,
    ],
    "HII_RESOURCE_SAMPLE_FORM_SET_GUID": [
        0x4F4EF7F0,
        0xAA29,
        0x4CE9,
        0xBA,
        0x41,
        0x64,
        0x3E,
        0x1,
        0x23,
        0xA9,
        0x9F,
    ],
    "HOB_LIST_GUID": [
        0x7739F24C,
        0x93D7,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "HOT_PLUG_DEVICE_GUID": [
        0x220AC432,
        0x1D43,
        0x49E5,
        0xA7,
        0x4F,
        0x4C,
        0x9D,
        0xA6,
        0x7A,
        0xD2,
        0x3B,
    ],
    "IDLE_LOOP_EVENT_GUID": [
        0x3C8D294C,
        0x5FC3,
        0x4451,
        0xBB,
        0x31,
        0xC4,
        0xC0,
        0x32,
        0x29,
        0x5E,
        0x6C,
    ],
    "INTEL_FRAMEWORK_MODULEPKG_TOKEN_SPACE_GUID": [
        0xD3705011,
        0xBC19,
        0x4AF7,
        0xBE,
        0x16,
        0xF6,
        0x80,
        0x30,
        0x37,
        0x8C,
        0x15,
    ],
    "IP4_ISCSI_CONFIG_GUID": [
        0x6456ED61,
        0x3579,
        0x41C9,
        0x8A,
        0x26,
        0x0A,
        0x0B,
        0xD6,
        0x2B,
        0x78,
        0xFC,
    ],
    "IP6_CONFIG_NVDATA_GUID": [
        0x2EEA107,
        0x98DB,
        0x400E,
        0x98,
        0x30,
        0x46,
        0xA,
        0x15,
        0x42,
        0xD7,
        0x99,
    ],
    "ISCSI_CHAP_AUTH_INFO_GUID": [
        0x786EC0AC,
        0x65AE,
        0x4D1B,
        0xB1,
        0x37,
        0xD,
        0x11,
        0xA,
        0x48,
        0x37,
        0x97,
    ],
    "ISCSI_CONFIG_GUID": [
        0x4B47D616,
        0xA8D6,
        0x4552,
        0x9D,
        0x44,
        0xCC,
        0xAD,
        0x2E,
        0xF,
        0x4C,
        0xF9,
    ],
    "ISCSI_V4_PRIVATE_GUID": [
        0xFA3CDE4C,
        0x87C2,
        0x427D,
        0xAE,
        0xDE,
        0x7D,
        0xD0,
        0x96,
        0xC8,
        0x8C,
        0x58,
    ],
    "ISCSI_V6_PRIVATE_GUID": [
        0x28BE27E5,
        0x66CC,
        0x4A31,
        0xA3,
        0x15,
        0xDB,
        0x14,
        0xC3,
        0x74,
        0x4D,
        0x85,
    ],
    "LAST_ENUM_LANGUAGE_GUID": [
        0xE8C545B,
        0xA2EE,
        0x470D,
        0x8E,
        0x26,
        0xBD,
        0xA1,
        0xA1,
        0x3C,
        0xA,
        0xA3,
    ],
    "LDR_MEMORY_DESCRIPTOR_GUID": [
        0x7701D7E5,
        0x7D1D,
        0x4432,
        0xA4,
        0x68,
        0x67,
        0x3D,
        0xAB,
        0x8A,
        0xDE,
        0x60,
    ],
    "LOAD_FILE_PROTOCOL_GUID": [
        0x56EC3091,
        0x954C,
        0x11D2,
        0x8E,
        0x3F,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "LOCAL_EFI_WIN_NT_BUS_DRIVER_IO_PROTOCOL_GUID": [
        0x96EB4AD6,
        0xA32A,
        0x11D4,
        0xBC,
        0xFD,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "LOCAL_EFI_WIN_NT_SERIAL_PORT_GUID": [
        0xC95A93D,
        0xA006,
        0x11D4,
        0xBC,
        0xFA,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "LOCAL_EFI_WIN_NT_THUNK_PROTOCOL_GUID": [
        0x58C518B1,
        0x76F3,
        0x11D4,
        0xBC,
        0xEA,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "LZMAF86_CUSTOM_DECOMPRESS_GUID": [
        0xD42AE6BD,
        0x1352,
        0x4BFB,
        0x90,
        0x9A,
        0xCA,
        0x72,
        0xA6,
        0xEA,
        0xE8,
        0x89,
    ],
    "LZMA_CUSTOM_DECOMPRESS_GUID": [
        0xEE4E5898,
        0x3914,
        0x4259,
        0x9D,
        0x6E,
        0xDC,
        0x7B,
        0xD7,
        0x94,
        0x03,
        0xCF,
    ],
    "MDEMODULEPKG_TOKEN_SPACE_GUID": [
        0xA1AFF049,
        0xFDEB,
        0x442A,
        0xB3,
        0x20,
        0x13,
        0xAB,
        0x4C,
        0xB7,
        0x2B,
        0xBC,
    ],
    "MDEPKG_TOKEN_SPACE_GUID": [
        0x914AEBE7,
        0x4635,
        0x459B,
        0xAA,
        0x1C,
        0x11,
        0xE2,
        0x19,
        0xB0,
        0x3A,
        0x10,
    ],
    "MEMORY_ONLY_RESET_CONTROL_GUID": [
        0xE20939BE,
        0x32D4,
        0x41BE,
        0xA1,
        0x50,
        0x89,
        0x7F,
        0x85,
        0xD4,
        0x98,
        0x29,
    ],
    "MEMORY_STATUS_CODE_RECORD_GUID": [
        0x60CC026,
        0x4C0D,
        0x4DDA,
        0x8F,
        0x41,
        0x59,
        0x5F,
        0xEF,
        0x0,
        0xA5,
        0x2,
    ],
    "MTC_VENDOR_GUID": [
        0xEB704011,
        0x1402,
        0x11D3,
        0x8E,
        0x77,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "MY_GUID": [
        0x12345678,
        0xAABB,
        0xCCDD,
        0xEE,
        0xFF,
        0x11,
        0x22,
        0x33,
        0x44,
        0x55,
        0x66,
    ],
    "NT_FWH_PPI_GUID": [
        0x4E76928F,
        0x50AD,
        0x4334,
        0xB0,
        0x6B,
        0xA8,
        0x42,
        0x13,
        0x10,
        0x8A,
        0x57,
    ],
    "PCATCHIPSET_TOKEN_SPACE_GUID": [
        0x326AE723,
        0xAE32,
        0x4589,
        0x98,
        0xB8,
        0xCA,
        0xC2,
        0x3C,
        0xDC,
        0xC1,
        0xB1,
    ],
    "PCD_DATABASE_HOB_GUID": [
        0xEA296D92,
        0x0B69,
        0x423C,
        0x8C,
        0x28,
        0x33,
        0xB4,
        0xE0,
        0xA9,
        0x12,
        0x68,
    ],
    "PCD_PPI_GUID": [
        0x6E81C58,
        0x4AD7,
        0x44BC,
        0x83,
        0x90,
        0xF1,
        0x2,
        0x65,
        0xF7,
        0x24,
        0x80,
    ],
    "PCD_PROTOCOL_GUID": [
        0x11B34006,
        0xD85B,
        0x4D0A,
        0xA2,
        0x90,
        0xD5,
        0xA5,
        0x71,
        0x31,
        0xE,
        0xF7,
    ],
    "PE32_IMAGE_PROTOCOL_GUID": [
        0x5CB5C776,
        0x60D5,
        0x45EE,
        0x88,
        0x3C,
        0x45,
        0x27,
        0x8,
        0xCD,
        0x74,
        0x3F,
    ],
    "PEI_ATA_CONTROLLER_PPI_GUID": [
        0xA45E60D1,
        0xC719,
        0x44AA,
        0xB0,
        0x7A,
        0xAA,
        0x77,
        0x7F,
        0x85,
        0x90,
        0x6D,
    ],
    "PEI_BASE_MEMORY_TEST_GUID": [
        0xB6EC423C,
        0x21D2,
        0x490D,
        0x85,
        0xC6,
        0xDD,
        0x58,
        0x64,
        0xEA,
        0xA6,
        0x74,
    ],
    "PEI_BLOCK_IO_PPI_GUID": [
        0x695D8AA1,
        0x42EE,
        0x4C46,
        0x80,
        0x5C,
        0x6E,
        0xA6,
        0xBC,
        0xE7,
        0x99,
        0xE3,
    ],
    "PEI_BOOT_SCRIPT_EXECUTER_PPI_GUID": [
        0xABD42895,
        0x78CF,
        0x4872,
        0x84,
        0x44,
        0x1B,
        0x5C,
        0x18,
        0x0B,
        0xFB,
        0xFF,
    ],
    "PEI_CAPSULE_PPI_GUID": [
        0x3ACF33EE,
        0xD892,
        0x40F4,
        0xA2,
        0xFC,
        0x38,
        0x54,
        0xD2,
        0xE1,
        0x32,
        0x3D,
    ],
    "PEI_CPU_IO_PPI_GUID": [
        0xE6AF1F7B,
        0xFC3F,
        0x46DA,
        0xA8,
        0x28,
        0xA3,
        0xB4,
        0x57,
        0xA4,
        0x42,
        0x82,
    ],
    "PEI_END_OF_PEI_PHASE_PPI_GUID": [
        0x605EA650,
        0xC65C,
        0x42E1,
        0xBA,
        0x80,
        0x91,
        0xA5,
        0x2A,
        0xB6,
        0x18,
        0xC6,
    ],
    "PEI_FLASH_MAP_PPI_GUID": [
        0xF34C2FA0,
        0xDE88,
        0x4270,
        0x84,
        0x14,
        0x96,
        0x12,
        0x22,
        0xF4,
        0x52,
        0x1C,
    ],
    "PEI_IN_MEMORY_GUID": [
        0x643B8786,
        0xB417,
        0x48D2,
        0x8F,
        0x5E,
        0x78,
        0x19,
        0x93,
        0x1C,
        0xAE,
        0xD8,
    ],
    "PEI_LOCK_PHYSICAL_PRESENCE_PPI_GUID": [
        0xEF9AEFE5,
        0x2BD3,
        0x4031,
        0xAF,
        0x7D,
        0x5E,
        0xFE,
        0x5A,
        0xBB,
        0x9A,
        0xD,
    ],
    "PEI_NT_THUNK_GUID": [
        0x98C281E5,
        0xF906,
        0x43DD,
        0xA9,
        0x2B,
        0xB0,
        0x3,
        0xBF,
        0x27,
        0x65,
        0xDA,
    ],
    "PEI_NT_THUNK_PPI_GUID": [
        0x98C281E5,
        0xF906,
        0x43DD,
        0xA9,
        0x2B,
        0xB0,
        0x3,
        0xBF,
        0x27,
        0x65,
        0xDA,
    ],
    "PEI_OPERATOR_PRESENCE_PPI_GUID": [
        0x20A7378C,
        0xAA83,
        0x4CE1,
        0x82,
        0x1F,
        0x47,
        0x40,
        0xEE,
        0x1B,
        0x3F,
        0x9F,
    ],
    "PEI_PCI_CFG_PPI_GUID": [
        0xE1F2EBA0,
        0xF7B9,
        0x4A26,
        0x86,
        0x20,
        0x13,
        0x12,
        0x21,
        0x64,
        0x2A,
        0x90,
    ],
    "PEI_PERMANENT_MEMORY_INSTALLED_PPI_GUID": [
        0xF894643D,
        0xC449,
        0x42D1,
        0x8E,
        0xA8,
        0x85,
        0xBD,
        0xD8,
        0xC6,
        0x5B,
        0xDE,
    ],
    "PEI_READ_ONLY_VARIABLE_ACCESS_PPI_GUID": [
        0x3CDC90C6,
        0x13FB,
        0x4A75,
        0x9E,
        0x79,
        0x59,
        0xE9,
        0xDD,
        0x78,
        0xB9,
        0xFA,
    ],
    "PEI_RESET_PPI_GUID": [
        0xEF398D58,
        0x9DFD,
        0x4103,
        0xBF,
        0x94,
        0x78,
        0xC6,
        0xF4,
        0xFE,
        0x71,
        0x2F,
    ],
    "PEI_S3_RESUME_PPI_GUID": [
        0x4426CCB2,
        0xE684,
        0x4A8A,
        0xAE,
        0x40,
        0x20,
        0xD4,
        0xB0,
        0x25,
        0xB7,
        0x10,
    ],
    "PEI_SECURITY_PPI_GUID": [
        0x1388066E,
        0x3A57,
        0x4EFA,
        0x98,
        0xF3,
        0xC1,
        0x2F,
        0x3A,
        0x95,
        0x8A,
        0x29,
    ],
    "PEI_SEC_PERFORMANCE_PPI_GUID": [
        0x0ECC666B,
        0x4662,
        0x47F9,
        0x9D,
        0xD5,
        0xD0,
        0x96,
        0xFF,
        0x7D,
        0xA4,
        0x9E,
    ],
    "PEI_SMBUS2_PPI_GUID": [
        0x9CA93627,
        0xB65B,
        0x4324,
        0xA2,
        0x2,
        0xC0,
        0xB4,
        0x61,
        0x76,
        0x45,
        0x43,
    ],
    "PEI_SMBUS_PPI_GUID": [
        0xABD42895,
        0x78CF,
        0x4872,
        0x84,
        0x44,
        0x1B,
        0x5C,
        0x18,
        0xB,
        0xFB,
        0xDA,
    ],
    "PEI_SMM_ACCESS_PPI_GUID": [
        0x268F33A9,
        0xCCCD,
        0x48BE,
        0x88,
        0x17,
        0x86,
        0x5,
        0x3A,
        0xC3,
        0x2E,
        0xD6,
    ],
    "PEI_SMM_CONTROL_PPI_GUID": [
        0x61C68702,
        0x4D7E,
        0x4F43,
        0x8D,
        0xEF,
        0xA7,
        0x43,
        0x5,
        0xCE,
        0x74,
        0xC5,
    ],
    "PEI_STALL_PPI_GUID": [
        0x1F4C6F90,
        0xB06B,
        0x48D8,
        0xA2,
        0x01,
        0xBA,
        0xE5,
        0xF1,
        0xCD,
        0x7D,
        0x56,
    ],
    "PEI_STATUS_CODE_MEMORY_PPI_GUID": [
        0x26F8AB01,
        0xD3CD,
        0x489C,
        0x98,
        0x4F,
        0xDF,
        0xDE,
        0xF7,
        0x68,
        0x39,
        0x5B,
    ],
    "PEI_STATUS_CODE_PPI_GUID": [
        0x229832D3,
        0x7A30,
        0x4B36,
        0xB8,
        0x27,
        0xF4,
        0xC,
        0xB7,
        0xD4,
        0x54,
        0x36,
    ],
    "PEI_TPM_INITIALIZED_PPI_GUID": [
        0xE9DB0D58,
        0xD48D,
        0x47F6,
        0x9C,
        0x6E,
        0x6F,
        0x40,
        0xE8,
        0x6C,
        0x7B,
        0x41,
    ],
    "PEI_UNIX_AUTOSCAN_PPI_GUID": [
        0xF2ED3D14,
        0x8985,
        0x11DB,
        0xB0,
        0x57,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "PEI_UNIX_THUNK_PPI_GUID": [
        0xF2F830F2,
        0x8985,
        0x11DB,
        0x80,
        0x6B,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "PEI_USB2_HOST_CONTROLLER_PPI_GUID": [
        0xA7D09FE1,
        0x74D4,
        0x4BA5,
        0x84,
        0x7C,
        0x12,
        0xED,
        0x5B,
        0x19,
        0xAD,
        0xE4,
    ],
    "PEI_USB_CONTROLLER_PPI_GUID": [
        0x3BC1F6DE,
        0x693E,
        0x4547,
        0xA3,
        0x0,
        0x21,
        0x82,
        0x3C,
        0xA4,
        0x20,
        0xB2,
    ],
    "PEI_USB_HOST_CONTROLLER_PPI_GUID": [
        0x652B38A9,
        0x77F4,
        0x453F,
        0x89,
        0xD5,
        0xE7,
        0xBD,
        0xC3,
        0x52,
        0xFC,
        0x53,
    ],
    "PEI_USB_IO_PPI_GUID": [
        0x7C29785C,
        0x66B9,
        0x49FC,
        0xB7,
        0x97,
        0x1C,
        0xA5,
        0x55,
        0xE,
        0xF2,
        0x83,
    ],
    "PERFORMANCEPKG_TOKEN_SPACE_GUID": [
        0x669346EF,
        0xFDAD,
        0x4AEB,
        0x08,
        0xA6,
        0x21,
        0x46,
        0x2D,
        0x3F,
        0xEF,
        0x7D,
    ],
    "PERFORMANCE_EX_PROTOCOL_GUID": [
        0x1EA81BEC,
        0xF01A,
        0x4D98,
        0xA2,
        0x1,
        0x4A,
        0x61,
        0xCE,
        0x2F,
        0xC0,
        0x22,
    ],
    "PERFORMANCE_PROTOCOL_GUID": [
        0x76B6BDFA,
        0x2ACD,
        0x4462,
        0x9E,
        0x3F,
        0xCB,
        0x58,
        0xC9,
        0x69,
        0xD9,
        0x37,
    ],
    "PE_COFF_LOADER_PROTOCOL_GUID": [
        0xB323179B,
        0x97FB,
        0x477E,
        0xB0,
        0xFE,
        0xD8,
        0x85,
        0x91,
        0xFA,
        0x11,
        0xAB,
    ],
    "PLAT_OVER_MNGR_GUID": [
        0x8614567D,
        0x35BE,
        0x4415,
        0x8D,
        0x88,
        0xBD,
        0x7D,
        0xC,
        0x9C,
        0x70,
        0xC0,
    ],
    "PRE_PI_EXTRACT_GUIDED_SECTION_DATA_GUID": [
        0x385A982C,
        0x2F49,
        0x4043,
        0xA5,
        0x1E,
        0x49,
        0x01,
        0x02,
        0x5C,
        0x8B,
        0x6B,
    ],
    "PWD_CREDENTIAL_PROVIDER_GUID": [
        0x78B9EC8B,
        0xC000,
        0x46C5,
        0xAC,
        0x93,
        0x24,
        0xA0,
        0xC1,
        0xBB,
        0x0,
        0xCE,
    ],
    "RECOVERY_ON_DATA_CD_GUID": [
        0x5CAC0099,
        0x0DC9,
        0x48E5,
        0x80,
        0x68,
        0xBB,
        0x95,
        0xF5,
        0x40,
        0x0A,
        0x9F,
    ],
    "RECOVERY_ON_FAT_FLOPPY_DISK_GUID": [
        0x2E3D2E75,
        0x9B2E,
        0x412D,
        0xB4,
        0xB1,
        0x70,
        0x41,
        0x6B,
        0x87,
        0x0,
        0xFF,
    ],
    "RECOVERY_ON_FAT_IDE_DISK_GUID": [
        0xB38573B6,
        0x6200,
        0x4AC5,
        0xB5,
        0x1D,
        0x82,
        0xE6,
        0x59,
        0x38,
        0xD7,
        0x83,
    ],
    "RECOVERY_ON_FAT_USB_DISK_GUID": [
        0x0FFBCE19,
        0x324C,
        0x4690,
        0xA0,
        0x09,
        0x98,
        0xC6,
        0xAE,
        0x2E,
        0xB1,
        0x86,
    ],
    "SAL_SYSTEM_TABLE_GUID": [
        0xEB9D2D32,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "SECUREBOOT_CONFIG_FORM_SET_GUID": [
        0x5DAF50A5,
        0xEA81,
        0x4DE2,
        0x8F,
        0x9B,
        0xCA,
        0xBD,
        0xA9,
        0xCF,
        0x5C,
        0x14,
    ],
    "SECURITYPKG_TOKEN_SPACE_GUID": [
        0xD3FB176,
        0x9569,
        0x4D51,
        0xA3,
        0xEF,
        0x7D,
        0x61,
        0xC6,
        0x4F,
        0xEA,
        0xBA,
    ],
    "SHELLPKG_SHELL_ENV2_EXT_GUID": [
        0xD2C18636,
        0x40E5,
        0x4EB5,
        0xA3,
        0x1B,
        0x36,
        0x69,
        0x5F,
        0xD4,
        0x2C,
        0x87,
    ],
    "SHELL_ALIAS_VARIABLE_GUID": [
        0x0053D9D6,
        0x2659,
        0x4599,
        0xA2,
        0x6B,
        0xEF,
        0x45,
        0x36,
        0xE6,
        0x31,
        0xA9,
    ],
    "SHELL_DEBUG1_HII_GUID": [
        0x25F200AA,
        0xD3CB,
        0x470A,
        0xBF,
        0x51,
        0xE7,
        0xD1,
        0x62,
        0xD2,
        0x2E,
        0x6F,
    ],
    "SHELL_DRIVER1_HII_GUID": [
        0xAF0B742,
        0x63EC,
        0x45BD,
        0x8D,
        0xB6,
        0x71,
        0xAD,
        0x7F,
        0x2F,
        0xE8,
        0xE8,
    ],
    "SHELL_ENVIRONMENT_PROTOCOL_GUID": [
        0x47C7B221,
        0xC42A,
        0x11D2,
        0x8E,
        0x57,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "SHELL_INSTALL1_HII_GUID": [
        0x7D574D54,
        0xD364,
        0x4D4A,
        0x95,
        0xE3,
        0x49,
        0x45,
        0xDB,
        0x7A,
        0xD3,
        0xEE,
    ],
    "SHELL_INTERFACE_PROTOCOL_GUID": [
        0x47C7B223,
        0xC42A,
        0x11D2,
        0x8E,
        0x57,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "SHELL_LEVEL1_HII_GUID": [
        0xDEC5DAA4,
        0x6781,
        0x4820,
        0x9C,
        0x63,
        0xA7,
        0xB0,
        0xE4,
        0xF1,
        0xDB,
        0x31,
    ],
    "SHELL_LEVEL2_HII_GUID": [
        0xF95A7CCC,
        0x4C55,
        0x4426,
        0xA7,
        0xB4,
        0xDC,
        0x89,
        0x61,
        0x95,
        0xB,
        0xAE,
    ],
    "SHELL_LEVEL3_HII_GUID": [
        0x4344558D,
        0x4EF9,
        0x4725,
        0xB1,
        0xE4,
        0x33,
        0x76,
        0xE8,
        0xD6,
        0x97,
        0x4F,
    ],
    "SHELL_MAP_GUID": [
        0x51271E13,
        0x7DE3,
        0x43AF,
        0x8B,
        0xC2,
        0x71,
        0xAD,
        0x3B,
        0x82,
        0x43,
        0x25,
    ],
    "SHELL_NETWORK1_HII_GUID": [
        0xF3D301BB,
        0xF4A5,
        0x45A8,
        0xB0,
        0xB7,
        0xFA,
        0x99,
        0x9C,
        0x62,
        0x37,
        0xAE,
    ],
    "SHELL_VARIABLE_GUID": [
        0x158DEF5A,
        0xF656,
        0x419C,
        0xB0,
        0x27,
        0x7A,
        0x31,
        0x92,
        0xC0,
        0x79,
        0xD2,
    ],
    "SMBIOS_TABLE_GUID": [
        0xEB9D2D31,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "SMM_COMMUNICATE_HEADER_GUID": [
        0xF328E36C,
        0x23B6,
        0x4A95,
        0x85,
        0x4B,
        0x32,
        0xE1,
        0x95,
        0x34,
        0xCD,
        0x75,
    ],
    "SMM_PERFORMANCE_EX_PROTOCOL_GUID": [
        0x931FC048,
        0xC71D,
        0x4455,
        0x89,
        0x30,
        0x47,
        0x6,
        0x30,
        0xE3,
        0xE,
        0xE5,
    ],
    "SMM_PERFORMANCE_PROTOCOL_GUID": [
        0xF866226A,
        0xEAA5,
        0x4F5A,
        0xA9,
        0xA,
        0x6C,
        0xFB,
        0xA5,
        0x7C,
        0x58,
        0x8E,
    ],
    "STATUS_CODE_CALLBACK_GUID": [
        0xE701458C,
        0x4900,
        0x4CA5,
        0xB7,
        0x72,
        0x3D,
        0x37,
        0x94,
        0x9F,
        0x79,
        0x27,
    ],
    "SYSTEM_ROM_FILE_GUID": [
        0x1547B4F3,
        0x3E8A,
        0x4FEF,
        0x81,
        0xC8,
        0x32,
        0x8E,
        0xD6,
        0x47,
        0xAB,
        0x1A,
    ],
    "TCG_CONFIG_FORM_SET_GUID": [
        0xB0F901E4,
        0xC424,
        0x45DE,
        0x90,
        0x81,
        0x95,
        0xE2,
        0xB,
        0xDE,
        0x6F,
        0xB5,
    ],
    "TEMPORARY_RAM_SUPPORT_PPI_GUID": [
        0xDBE23AA9,
        0xA345,
        0x4B97,
        0x85,
        0xB6,
        0xB2,
        0x26,
        0xF1,
        0x61,
        0x73,
        0x89,
    ],
    "TIANO_CUSTOM_DECOMPRESS_GUID": [
        0xA31280AD,
        0x481E,
        0x41B6,
        0x95,
        0xE8,
        0x12,
        0x7F,
        0x4C,
        0x98,
        0x47,
        0x79,
    ],
    "UNIX_FWH_PPI_GUID": [
        0xF2F0DC30,
        0x8985,
        0x11DB,
        0xA1,
        0x5B,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "UNIX_PEI_LOAD_FILE_GUID": [
        0xF2F48768,
        0x8985,
        0x11DB,
        0xB8,
        0xDA,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "UNKNOWN_DEVICE_GUID": [
        0xCF31FAC5,
        0xC24E,
        0x11D2,
        0x85,
        0xF3,
        0x0,
        0xA0,
        0xC9,
        0x3E,
        0xC9,
        0x3B,
    ],
    "USB_CREDENTIAL_PROVIDER_GUID": [
        0xD0849ED1,
        0xA88C,
        0x4BA6,
        0xB1,
        0xD6,
        0xAB,
        0x50,
        0xE2,
        0x80,
        0xB7,
        0xA9,
    ],
    "USB_KEYBOARD_LAYOUT_PACKAGE_GUID": [
        0xC0F3B43,
        0x44DE,
        0x4907,
        0xB4,
        0x78,
        0x22,
        0x5F,
        0x6F,
        0x62,
        0x89,
        0xDC,
    ],
    "USER_IDENTIFY_MANAGER_GUID": [
        0x3CCD3DD8,
        0x8D45,
        0x4FED,
        0x96,
        0x2D,
        0x2B,
        0x38,
        0xCD,
        0x82,
        0xB3,
        0xC4,
    ],
    "USER_PROFILE_MANAGER_GUID": [
        0xC35F272C,
        0x97C2,
        0x465A,
        0xA2,
        0x16,
        0x69,
        0x6B,
        0x66,
        0x8A,
        0x8C,
        0xFE,
    ],
    "VIRTUAL_UNCACHED_PAGES_PROTOCOL_GUID": [
        0xAD651C7D,
        0x3C22,
        0x4DBF,
        0x92,
        0xE8,
        0x38,
        0xA7,
        0xCD,
        0xAE,
        0x87,
        0xB2,
    ],
    "VLAN_CONFIG_FORM_SET_GUID": [
        0xD79DF6B0,
        0xEF44,
        0x43BD,
        0x97,
        0x97,
        0x43,
        0xE9,
        0x3B,
        0xCF,
        0x5F,
        0xA8,
    ],
}
