# GUIDs from https://github.com/theopolis/uefi-firmware-parser/blob/master/uefi_firmware/guids/efiguids_dell.py

# pylint: disable=duplicate-key
dell_guids = {
    "DELL_COMPUTRACE_BINARY_GUID": [
        623147636,
        37952,
        18389,
        191,
        10,
        237,
        146,
        164,
        214,
        235,
        164,
    ],
    "DELL_MEBX_SETUP_BINARY_GUID": [
        393683817,
        53858,
        19344,
        159,
        49,
        189,
        196,
        31,
        38,
        99,
        165,
    ],
    "DELL_ERROR_LOG_CONFIG_GUID": [
        59564679,
        47110,
        17846,
        168,
        25,
        81,
        77,
        175,
        75,
        145,
        185,
    ],
    "DELL_FP_THUNK_GUID": [69003667, 26231, 18208, 166, 101, 55, 91, 128, 255, 224, 18],
    "DELL_INTEL_LOM_SMM_GUID": [
        145481829,
        50009,
        19349,
        141,
        89,
        193,
        181,
        142,
        182,
        87,
        181,
    ],
    "DELL_LEGACY_VIDEO_ROM_GUID": [
        149252656,
        25325,
        16838,
        146,
        64,
        183,
        69,
        94,
        230,
        83,
        215,
    ],
    "DELL_PCH_S3_SUPPORT_GUID": [
        150128187,
        2270,
        19661,
        134,
        112,
        172,
        254,
        100,
        74,
        28,
        72,
    ],
    "DELL_SPI_PART_MICRON_GUID": [
        152362504,
        17229,
        20383,
        147,
        179,
        111,
        164,
        138,
        234,
        247,
        224,
    ],
    "DELL_DCP_REGISTER_GUID": [
        161470591,
        19257,
        17398,
        171,
        71,
        248,
        1,
        249,
        146,
        9,
        247,
    ],
    "DELL_AHCI_DXE_GUID": [163151961, 11636, 17349, 151, 9, 173, 10, 0, 81, 134, 125],
    "DELL_SIMPLE_BOOT_FLAG_SRC_GUID": [
        175448545,
        2545,
        17582,
        155,
        95,
        39,
        129,
        183,
        137,
        113,
        214,
    ],
    "DELL_EDIAGS_DXE_GUID": [
        186863089,
        128,
        16683,
        135,
        22,
        138,
        129,
        163,
        161,
        31,
        170,
    ],
    "DELL_ACPI_OEM_CONFIG_GUID": [
        187580522,
        60763,
        18024,
        188,
        209,
        43,
        29,
        176,
        24,
        65,
        252,
    ],
    "DELL_SPI_PART_MXIC_GUID": [
        192673644,
        29210,
        17659,
        167,
        88,
        82,
        225,
        60,
        164,
        87,
        241,
    ],
    "DELL_DTWLAN_SMM_GUID": [
        195268242,
        5450,
        19426,
        165,
        224,
        190,
        128,
        87,
        28,
        219,
        113,
    ],
    "DELL_LEGACY16_ROM_GUID": [
        196160684,
        53161,
        18489,
        164,
        194,
        23,
        151,
        36,
        129,
        9,
        208,
    ],
    "DELL_DEVICE_NAME_CONFIG_GUID": [
        197273096,
        60613,
        18361,
        160,
        56,
        79,
        10,
        104,
        55,
        46,
        68,
    ],
    "DELL_AI13_ROM_GUID": [
        215208698,
        45597,
        18357,
        186,
        149,
        216,
        192,
        11,
        56,
        243,
        36,
    ],
    "DELL_JPEG_DECODER_GUID": [
        220504629,
        39954,
        17516,
        142,
        203,
        239,
        193,
        245,
        40,
        2,
        9,
    ],
    "DELL_DA_HDD_PROTECTION_GUID": [
        220775721,
        34772,
        17048,
        138,
        84,
        64,
        242,
        42,
        159,
        226,
        74,
    ],
    "DELL_DCCS_SMM_DRIVER_GUID": [
        226622917,
        52120,
        19359,
        185,
        59,
        112,
        169,
        192,
        102,
        58,
        190,
    ],
    "DELL_INTRUSION_DETECT_SMM_GUID": [
        232691254,
        33569,
        20191,
        159,
        20,
        11,
        252,
        163,
        180,
        115,
        245,
    ],
    "DELL_VIRT_RTC_SMM_GUID": [
        242451377,
        33774,
        16804,
        147,
        158,
        36,
        200,
        134,
        240,
        58,
        214,
    ],
    "DELL_SMM_HWM_DRIVER_GUID": [
        245618257,
        18868,
        18393,
        189,
        195,
        228,
        163,
        121,
        243,
        222,
        118,
    ],
    "DELL_SM_BIOS_STRUC_DB_GUID": [
        246741696,
        41964,
        20461,
        151,
        131,
        168,
        208,
        255,
        209,
        174,
        51,
    ],
    "DELL_CENTURY_ROLLOVER_SMM_GUID": [
        293724525,
        44817,
        19538,
        132,
        126,
        81,
        109,
        208,
        155,
        211,
        118,
    ],
    "DELL_SMM_SECURITY_VAULT_GUID": [
        295647076,
        42946,
        17193,
        178,
        92,
        230,
        48,
        94,
        116,
        48,
        73,
    ],
    "DELL_DXE_SW_SMI_GUID": [
        299700076,
        8347,
        18382,
        138,
        152,
        65,
        140,
        155,
        124,
        199,
        86,
    ],
    "DELL_SMM_SB_ACPI_GUID": [
        311836245,
        22566,
        18078,
        169,
        52,
        163,
        203,
        179,
        7,
        110,
        197,
    ],
    "DELL_SMM_ACCESS_GUID": [
        321112056,
        56021,
        16678,
        165,
        75,
        122,
        5,
        251,
        244,
        21,
        21,
    ],
    "DELL_MFG_MODE_SMM_DRIVER_GUID": [
        343426378,
        17796,
        19658,
        176,
        210,
        18,
        10,
        206,
        18,
        157,
        187,
    ],
    "DELL_SPI_PART_ATMEL_GUID": [
        350738878,
        30772,
        18302,
        169,
        66,
        255,
        95,
        130,
        62,
        226,
        73,
    ],
    "DELL_EDIAGS_CONFIG_GUID": [
        353288559,
        2998,
        17064,
        182,
        5,
        121,
        121,
        75,
        137,
        209,
        91,
    ],
    "DELL_VARIABLE_SMM_GUID": [
        376426563,
        59923,
        18504,
        187,
        60,
        111,
        162,
        149,
        185,
        70,
        39,
    ],
    "DELL_SMM_GPIO_POLICY_GUID": [
        381905150,
        61812,
        18561,
        146,
        206,
        56,
        134,
        153,
        211,
        77,
        149,
    ],
    "DELL_ACPI_GUID": [382771774, 49308, 16509, 161, 74, 173, 5, 143, 221, 12, 161],
    "DELL_RUNTIME_ACPI_DXE_GUID": [
        389612339,
        19686,
        18600,
        175,
        185,
        14,
        245,
        91,
        102,
        107,
        116,
    ],
    "DELL_SERVICE_MENU_GUID": [
        420935486,
        51236,
        20369,
        172,
        156,
        191,
        31,
        210,
        142,
        68,
        49,
    ],
    "DELL_MONOTONIC_COUNTER_GUID": [
        424600875,
        766,
        16781,
        170,
        16,
        46,
        97,
        229,
        28,
        184,
        148,
    ],
    "DELL_CSM_OEM_ROM_GUID": [
        438112772,
        58245,
        18755,
        168,
        146,
        83,
        52,
        206,
        56,
        9,
        172,
    ],
    "DELL_DIAGS_SB_CONTROL_SMM_GUID": [
        452881360,
        51653,
        17620,
        183,
        189,
        143,
        94,
        125,
        15,
        37,
        96,
    ],
    "DELL_AMT_PLATFORM_POLICY_GUID": [
        468079106,
        37656,
        18733,
        165,
        81,
        8,
        223,
        43,
        214,
        10,
        238,
    ],
    "DELL_MFG_AUTHENTICATION_GUID": [
        473155928,
        65188,
        17247,
        147,
        239,
        10,
        156,
        20,
        174,
        135,
        228,
    ],
    "DELL_SM_BIOS_STRUC_DA_GUID": [
        477314229,
        19599,
        17625,
        187,
        240,
        149,
        71,
        112,
        137,
        235,
        8,
    ],
    "DELL_DXE_COMPUTRACE_GUID": [
        484872944,
        13079,
        17780,
        139,
        87,
        72,
        0,
        237,
        9,
        31,
        64,
    ],
    "DELL_SMM_STATUS_CODE_GUID": [
        495067551,
        14447,
        20262,
        175,
        172,
        97,
        63,
        36,
        44,
        7,
        96,
    ],
    "DELL_POWER_BUTTON_CONFIG_GUID": [
        519056625,
        49001,
        18883,
        143,
        220,
        91,
        181,
        93,
        34,
        76,
        250,
    ],
    "DELL_REBOOT_DXE_GUID": [
        536913970,
        50804,
        18538,
        129,
        190,
        203,
        70,
        112,
        164,
        247,
        253,
    ],
    "DELL_FLASH_IO_DXE_GUID": [
        560621596,
        40529,
        16735,
        154,
        218,
        203,
        159,
        188,
        208,
        95,
        93,
    ],
    "DELL_SM_BIOS_STRUC_B1_GUID": [
        589118053,
        37954,
        17671,
        164,
        228,
        233,
        210,
        23,
        101,
        120,
        241,
    ],
    "DELL_IO_TRAP_GUID": [594865631, 61955, 20416, 162, 14, 97, 186, 215, 48, 137, 214],
    "DELL_SM_BIOS_DXE_DRIVER_GUID": [
        596042289,
        43471,
        20306,
        148,
        106,
        111,
        107,
        108,
        19,
        59,
        70,
    ],
    "DELL_UPDATE_MEMORY_RECORD_GUID": [
        617403252,
        15862,
        16769,
        134,
        246,
        227,
        198,
        105,
        32,
        161,
        69,
    ],
    "DELL_BIOS_BLK_IO_SRC_GUID": [
        632090968,
        56673,
        20068,
        154,
        73,
        85,
        133,
        30,
        154,
        38,
        199,
    ],
    "DELL_ACPIS3_SAVE_GUID": [
        648169502,
        17444,
        18082,
        153,
        67,
        204,
        64,
        57,
        234,
        216,
        248,
    ],
    "DELL_SB_SERVICES_SMM_GUID": [
        650136819,
        62971,
        18792,
        141,
        87,
        199,
        250,
        10,
        147,
        39,
        131,
    ],
    "DELL_SYSTEM_ID_CONFIG_DXE_GUID": [
        656963409,
        34426,
        18125,
        145,
        175,
        65,
        111,
        246,
        174,
        61,
        254,
    ],
    "DELL_OROM_KB_ACCESS_GUID": [
        660110193,
        14329,
        19016,
        181,
        112,
        88,
        182,
        209,
        79,
        109,
        236,
    ],
    "DELL_SMSC5544_DXE_GUID": [
        670270351,
        47655,
        20474,
        179,
        116,
        53,
        190,
        162,
        138,
        67,
        27,
    ],
    "DELL_AMT_PET_ALERT_GUID": [
        688824905,
        28296,
        16956,
        176,
        218,
        117,
        205,
        222,
        121,
        32,
        204,
    ],
    "DELL_CSM_VIDEO_GUID": [
        701453816,
        46709,
        20317,
        143,
        47,
        184,
        122,
        62,
        207,
        208,
        99,
    ],
    "DELL_BINDINGS_SMM_GUID": [
        720216299,
        5010,
        16946,
        164,
        249,
        197,
        122,
        60,
        47,
        162,
        217,
    ],
    "DELL_EDIAGS_SMM_GUID": [
        762170232,
        51938,
        17497,
        146,
        124,
        100,
        166,
        183,
        230,
        74,
        117,
    ],
    "DELL_PBA_UPEK_DPBA_GUID": [
        762651386,
        26608,
        18280,
        182,
        224,
        253,
        118,
        241,
        127,
        75,
        4,
    ],
    "DELL_PPM_POLICY_INIT_DXE_GUID": [
        770768916,
        53025,
        17024,
        140,
        63,
        229,
        57,
        184,
        238,
        81,
        80,
    ],
    "DELL_GENERIC_SIO_DXE_GUID": [
        771101699,
        49536,
        17829,
        162,
        43,
        26,
        61,
        184,
        143,
        233,
        186,
    ],
    "DELL_SM_BIOS_SMM_DA_CI_GUID": [
        775889525,
        35277,
        19940,
        189,
        132,
        190,
        191,
        217,
        75,
        205,
        204,
    ],
    "DELL_USB_MOUSE_GUID": [
        788490211,
        22919,
        18152,
        129,
        17,
        128,
        255,
        166,
        122,
        235,
        147,
    ],
    "DELL_DXE_GPIO_POLICY_GUID": [
        800200429,
        19047,
        18483,
        159,
        92,
        36,
        129,
        36,
        205,
        154,
        172,
    ],
    "DELL_GSET_GUID": [800665338, 12000, 19374, 158, 182, 116, 68, 18, 94, 30, 247],
    "DELL_UHCI_GUID": [800665338, 12000, 19374, 158, 182, 116, 100, 18, 94, 30, 247],
    "DELL_SPI_PART_PROM_JET_GUID": [
        805154634,
        43445,
        20214,
        170,
        59,
        168,
        150,
        17,
        170,
        178,
        132,
    ],
    "DELL_PCI_HOT_PLUG_GUID": [
        807593234,
        47434,
        20242,
        128,
        109,
        126,
        241,
        23,
        120,
        153,
        216,
    ],
    "DELL_SMB_PROTOCOL_ACCESS_GUID": [
        849285743,
        10654,
        19397,
        131,
        16,
        23,
        159,
        16,
        235,
        70,
        201,
    ],
    "DELL_ALERT_STANDARD_FORMAT_DXE_GUID": [
        868630637,
        12139,
        16821,
        135,
        5,
        82,
        186,
        251,
        99,
        60,
        9,
    ],
    "DELL_LEG_USB_MEM_SMM_GUID": [
        917420886,
        8075,
        19393,
        142,
        254,
        64,
        133,
        165,
        212,
        196,
        10,
    ],
    "DELL_ERROR_HANDLER_SMM_GUID": [
        925400203,
        56467,
        17877,
        154,
        175,
        60,
        210,
        233,
        6,
        177,
        43,
    ],
    "DELL_DEFAULT_BOOT_LIST_SMM_GUID": [
        925400203,
        56467,
        17877,
        154,
        175,
        60,
        210,
        233,
        6,
        255,
        255,
    ],
    "DELL_TPMDXE_GUID": [946780090, 25412, 17640, 152, 92, 57, 120, 253, 71, 145, 107],
    "DELL_OEM_SX_SMM_GUID": [
        948378608,
        50762,
        18582,
        184,
        228,
        98,
        212,
        133,
        12,
        126,
        104,
    ],
    "DELL_AC_LOSS_SMM_GUID": [
        948378608,
        50762,
        18582,
        184,
        228,
        98,
        215,
        117,
        12,
        125,
        104,
    ],
    "DELL_DIAGS_SB_CONTROL_DXE_GUID": [
        955198347,
        53053,
        18402,
        151,
        227,
        85,
        113,
        21,
        228,
        57,
        133,
    ],
    "DELL_SMM_LEGACY_REGION_GUID": [
        962780853,
        65014,
        18473,
        136,
        156,
        213,
        68,
        145,
        142,
        132,
        217,
    ],
    "DELL_PS2_EMUL_GUID": [
        967310044,
        39460,
        17747,
        140,
        189,
        155,
        114,
        178,
        76,
        34,
        253,
    ],
    "DELL_MEMORY_S4_GUID": [
        975822105,
        11396,
        19056,
        154,
        1,
        251,
        221,
        175,
        251,
        100,
        97,
    ],
    "DELL_SB_SERVICES_DXE_GUID": [
        977290450,
        62996,
        16676,
        167,
        114,
        32,
        123,
        205,
        190,
        61,
        176,
    ],
    "DELL_STOP_SHIP_CONFIG_GUID": [
        993507108,
        19191,
        18997,
        151,
        179,
        210,
        251,
        143,
        79,
        86,
        60,
    ],
    "DELL_BLOCK_IO_GUID": [
        1002555495,
        8820,
        17400,
        164,
        186,
        147,
        154,
        91,
        214,
        212,
        115,
    ],
    "DELL_PCI_BUS_GUID": [
        1008591775,
        53767,
        16522,
        170,
        204,
        115,
        28,
        251,
        127,
        29,
        215,
    ],
    "DELL_TX_TDXE_GUID": [1029076176, 44661, 18211, 145, 89, 29, 101, 59, 64, 64, 47],
    "DELL_SM_BIOS_STRUC_D3_GUID": [
        1037980905,
        36120,
        20136,
        148,
        35,
        194,
        232,
        70,
        225,
        142,
        35,
    ],
    "DELL_SMB_BOOT_PRIORITY_GUID": [
        1099196974,
        31402,
        17560,
        188,
        38,
        181,
        172,
        212,
        159,
        146,
        225,
    ],
    "DELL_SPI_CONTROLLER_SMM_GUID": [
        1099935596,
        11215,
        16705,
        137,
        131,
        157,
        51,
        225,
        182,
        123,
        76,
    ],
    "DELL_ME_PCI_PLATFORM_CONFIG_DXE_GUID": [
        1106536082,
        38163,
        19740,
        139,
        179,
        182,
        161,
        104,
        24,
        45,
        228,
    ],
    "DELL_PBA_UPEK_DXE_GUID": [
        1120087503,
        62042,
        18419,
        143,
        76,
        171,
        212,
        120,
        215,
        127,
        80,
    ],
    "DELL_GPE_CONFIG_GUID": [
        1174254635,
        8085,
        19027,
        155,
        164,
        28,
        139,
        251,
        139,
        203,
        1,
    ],
    "DELL_POWER_OFF_SMM_GUID": [
        1190974936,
        43443,
        17123,
        144,
        74,
        1,
        47,
        7,
        188,
        95,
        92,
    ],
    "DELL_GPE_GUID": [1198704346, 20589, 19605, 172, 23, 174, 102, 136, 95, 109, 83],
    "DELL_PASSWORD_MGR_SMM_GUID": [
        1202852751,
        23147,
        19557,
        145,
        103,
        135,
        64,
        89,
        93,
        22,
        173,
    ],
    "DELL_SMM_SB_GPIO_CONTROL_GUID": [
        1206402316,
        10996,
        18061,
        145,
        145,
        156,
        228,
        104,
        193,
        142,
        158,
    ],
    "DELL_RAID_ROM_GUID": [
        1226990052,
        1625,
        16972,
        130,
        182,
        115,
        39,
        67,
        137,
        231,
        167,
    ],
    "DELL_SMM_DISPATCHER_GUID": [
        1245131275,
        16307,
        17253,
        151,
        48,
        158,
        137,
        198,
        0,
        57,
        93,
    ],
    "DELL_DXE_SIO_GPIO_CONTROL_GUID": [
        1248129536,
        63900,
        17139,
        128,
        199,
        13,
        145,
        226,
        211,
        235,
        93,
    ],
    "DELL_VARIABLE_DXE_GUID": [
        1267189915,
        14761,
        18319,
        164,
        182,
        129,
        106,
        158,
        220,
        80,
        135,
    ],
    "DELL_CPU_SMM_GUID": [
        1318627838,
        57178,
        16694,
        185,
        34,
        79,
        185,
        112,
        203,
        215,
        51,
    ],
    "DELL_CHASSIS_CONFIG_SMM_GUID": [
        1373013960,
        6510,
        19710,
        138,
        12,
        131,
        104,
        152,
        14,
        168,
        182,
    ],
    "DELL_SMM_DELAY_GUID": [
        1378954463,
        54441,
        17726,
        169,
        223,
        159,
        218,
        245,
        28,
        214,
        34,
    ],
    "DELL_SPI_PART_EON_GUID": [
        1386777386,
        26109,
        18769,
        139,
        37,
        6,
        251,
        101,
        152,
        18,
        139,
    ],
    "DELL_CHASSIS_CONFIG_DXE_GUID": [
        1421699677,
        14578,
        17597,
        132,
        171,
        16,
        139,
        228,
        244,
        89,
        20,
    ],
    "DELL_HIIPARSER_DXE_DRIVER_GUID": [
        1436706812,
        26119,
        16419,
        136,
        78,
        72,
        229,
        211,
        211,
        244,
        226,
    ],
    "DELL_BINDINGS_DXE_GUID": [
        1438341707,
        15167,
        17452,
        191,
        9,
        15,
        135,
        166,
        126,
        142,
        231,
    ],
    "DELL_HECI_DXE_GUID": [
        1441228356,
        30885,
        19074,
        169,
        0,
        113,
        38,
        165,
        121,
        136,
        146,
    ],
    "DELL_SMM_BBSMANAGER_LEGACY_GUID": [
        1442227219,
        10255,
        16867,
        147,
        148,
        101,
        128,
        242,
        157,
        215,
        208,
    ],
    "DELL_GRASSLAKE_CONFIG_GUID": [
        1458496326,
        20492,
        18742,
        149,
        26,
        45,
        165,
        240,
        255,
        57,
        187,
    ],
    "DELL_IDE_SMM_GUID": [
        1461526225,
        49881,
        16782,
        149,
        58,
        36,
        142,
        188,
        104,
        112,
        72,
    ],
    "DELL_PASSWORD_MGR_DXE_GUID": [
        1475622312,
        7223,
        18484,
        173,
        97,
        176,
        61,
        148,
        221,
        206,
        243,
    ],
    "DELL_ME_FW_DOWNGRADE_GUID": [
        1478553268,
        49461,
        18516,
        157,
        42,
        170,
        158,
        252,
        68,
        117,
        233,
    ],
    "DELL_CSM_CONFIG_GUID": [
        1484687255,
        49915,
        16823,
        174,
        155,
        245,
        58,
        108,
        86,
        45,
        245,
    ],
    "DELL_GPE_OROM_GUID": [
        1489880953,
        56460,
        18715,
        186,
        195,
        248,
        110,
        6,
        209,
        134,
        95,
    ],
    "DELL_SM_BIOS_SMM_DRIVER_GUID": [
        1493767628,
        34338,
        19809,
        190,
        100,
        195,
        62,
        231,
        96,
        20,
        31,
    ],
    "DELL_PCH_SMBUS_SMM_GUID": [
        1495822712,
        22962,
        18890,
        188,
        99,
        83,
        43,
        18,
        234,
        44,
        83,
    ],
    "DELL_DASH_BIOS_MANAGER_GUID": [
        1496809990,
        34331,
        17280,
        163,
        73,
        47,
        47,
        79,
        3,
        12,
        75,
    ],
    "DELL_WDT_DXE_GUID": [
        1521189861,
        61479,
        19623,
        191,
        208,
        22,
        53,
        140,
        201,
        228,
        83,
    ],
    "DELL_CORE_DXE_GUID": [1524888446, 20142, 16814, 130, 64, 53, 70, 91, 94, 129, 235],
    "DELL_PASSWORD_UI_GUID": [
        1564786295,
        22121,
        16848,
        182,
        133,
        27,
        243,
        248,
        62,
        251,
        152,
    ],
    "DELL_HOT_SOS_SMM_DRIVER_GUID": [
        1571415364,
        56365,
        18032,
        163,
        213,
        152,
        82,
        54,
        213,
        222,
        69,
    ],
    "DELL_SIO_CONFIG_DXE_GUID": [
        1572044380,
        12011,
        17400,
        173,
        160,
        36,
        55,
        2,
        211,
        148,
        93,
    ],
    "DELL_TCG_DXE_GUID": [
        1587325859,
        62129,
        18810,
        173,
        172,
        36,
        245,
        117,
        233,
        205,
        233,
    ],
    "DELL_ACPI_CONFIG_GUID": [
        1591357731,
        2112,
        17911,
        173,
        171,
        19,
        166,
        85,
        239,
        59,
        183,
    ],
    "DELL_FLASH_SCREEN_DXE_GUID": [
        1626069668,
        5477,
        19866,
        153,
        200,
        136,
        223,
        166,
        85,
        73,
        165,
    ],
    "DELL_TXT_DXE_GUID": [1630407945, 23825, 17686, 130, 238, 109, 214, 5, 254, 38, 95],
    "DELL_DIAGS_DXE_DRIVER_GUID": [
        1662733815,
        47850,
        19487,
        160,
        97,
        91,
        100,
        98,
        101,
        40,
        34,
    ],
    "DELL_FLASH_UPDATE_DXE_GUID": [
        1680263188,
        24602,
        16662,
        158,
        159,
        191,
        157,
        111,
        143,
        37,
        79,
    ],
    "DELL_SMM_GPE_GUID": [
        1709829021,
        33069,
        16737,
        153,
        197,
        5,
        172,
        75,
        204,
        164,
        148,
    ],
    "DELL_RTC_AUTO_ON_SMM_GUID": [
        1732878212,
        62181,
        19922,
        158,
        86,
        198,
        227,
        137,
        221,
        97,
        115,
    ],
    "DELL_SMM_FLASH_WRITE_PROTECT_GUID": [
        1777301692,
        15217,
        20172,
        131,
        79,
        59,
        116,
        249,
        20,
        132,
        48,
    ],
    "DELL_DIAGS_CONFIG_GUID": [
        1777957454,
        5013,
        17226,
        165,
        211,
        255,
        156,
        234,
        40,
        72,
        133,
    ],
    "DELL_AUDIO_CONFIG_DXE_GUID": [
        1788978124,
        21188,
        19203,
        153,
        247,
        40,
        143,
        52,
        92,
        29,
        179,
    ],
    "DELL_SPECIAL_BOOT_STUB_GUID": [
        1797814372,
        30108,
        17092,
        180,
        53,
        167,
        74,
        182,
        148,
        205,
        59,
    ],
    "DELL_DA_SERVICE_TAG_GUID": [
        1854722743,
        46646,
        18521,
        133,
        237,
        198,
        55,
        189,
        202,
        89,
        25,
    ],
    "DELL_DXE_SB_ACPI_GUID": [
        1855444212,
        6296,
        17416,
        166,
        45,
        153,
        202,
        222,
        211,
        47,
        216,
    ],
    "DELL_MONOTONIC_COUNTER_SMM_GUID": [
        1898086669,
        52435,
        19209,
        160,
        171,
        141,
        16,
        118,
        69,
        201,
        120,
    ],
    "DELL_SMM_SB_GENERIC_GUID": [
        1898475784,
        48984,
        16874,
        183,
        28,
        179,
        98,
        45,
        235,
        202,
        157,
    ],
    "DELL_ACPI_MODE_ENABLE_GUID": [
        1963495590,
        31439,
        20303,
        129,
        189,
        180,
        0,
        194,
        190,
        169,
        90,
    ],
    "DELL_SMM_SIO_EMI_GUID": [
        1971880107,
        19618,
        19882,
        168,
        62,
        209,
        249,
        173,
        242,
        194,
        241,
    ],
    "DELL_PSTATE_CONTROL_GUID": [
        1975412348,
        18657,
        17709,
        176,
        252,
        54,
        49,
        56,
        237,
        135,
        255,
    ],
    "DELL_DA_EPPID_GUID": [
        1990319997,
        30028,
        16609,
        188,
        114,
        63,
        202,
        216,
        66,
        222,
        246,
    ],
    "DELL_PROGRESS_BAR_GUID": [
        1992170175,
        7710,
        12829,
        183,
        240,
        158,
        9,
        132,
        253,
        218,
        188,
    ],
    "DELL_PBA_MGR_SMM_GUID": [
        1994516974,
        24519,
        17939,
        185,
        111,
        250,
        121,
        119,
        150,
        87,
        58,
    ],
    "DELL_AMT_SETUP_GUID": [
        2000466059,
        20762,
        19413,
        133,
        173,
        65,
        212,
        244,
        182,
        74,
        82,
    ],
    "DELL_STORAGE_AGENTS_DXE_GUID": [
        2013853122,
        40112,
        17929,
        144,
        127,
        177,
        132,
        83,
        195,
        99,
        180,
    ],
    "DELL_VARIABLE_RUNTIME_DXE_GUID": [
        2021476419,
        26796,
        19496,
        190,
        83,
        186,
        194,
        114,
        186,
        236,
        249,
    ],
    "DELL_PBA_SCARD_DXE_GUID": [
        2044959363,
        53267,
        19246,
        131,
        106,
        169,
        154,
        113,
        71,
        53,
        28,
    ],
    "DELL_SOL_POST_MESSAGE_GUID": [
        2047396760,
        59836,
        16835,
        190,
        25,
        179,
        2,
        243,
        241,
        245,
        35,
    ],
    "DELL_TERMINAL_GUID": [
        2047396760,
        59836,
        16835,
        190,
        25,
        179,
        2,
        243,
        241,
        245,
        149,
    ],
    "DELL_SM_BIOS_STRUC_D0_GUID": [
        2075890981,
        38842,
        17686,
        182,
        96,
        27,
        14,
        183,
        135,
        68,
        165,
    ],
    "DELL_SMM_RUNTIME_GUID": [
        2088348812,
        24172,
        20029,
        186,
        111,
        194,
        96,
        238,
        124,
        23,
        46,
    ],
    "DELL_FLASH_IO_SMM_GUID": [
        2092505544,
        54425,
        17961,
        172,
        179,
        34,
        118,
        158,
        52,
        61,
        219,
    ],
    "DELL_SYSTEM_PW_SMM_GUID": [
        2158681357,
        32851,
        19367,
        148,
        27,
        54,
        244,
        139,
        178,
        48,
        1,
    ],
    "DELL_PCI_ROOT_BRIDGE_GUID": [
        2162585098,
        52433,
        17402,
        167,
        177,
        45,
        94,
        224,
        241,
        57,
        16,
    ],
    "DELL_POWER_OFF_CONFIG_GUID": [
        2163227679,
        35261,
        16960,
        147,
        168,
        172,
        153,
        233,
        169,
        41,
        252,
    ],
    "DELL_DXE_HWM_DRIVER_GUID": [
        2189636628,
        51444,
        19298,
        171,
        106,
        228,
        213,
        218,
        171,
        19,
        15,
    ],
    "DELL_PXE_UNDI_ROM_GUID": [
        2197545579,
        21460,
        17551,
        146,
        76,
        123,
        224,
        18,
        110,
        202,
        79,
    ],
    "DELL_PW_BY_PASS_SMM_GUID": [
        2209781945,
        520,
        20175,
        187,
        131,
        206,
        66,
        208,
        190,
        252,
        74,
    ],
    "DELL_HOT_KEY_HANDLER_SMM_GUID": [
        2221392131,
        28662,
        19814,
        134,
        246,
        225,
        18,
        76,
        17,
        30,
        148,
    ],
    "DELL_POWER_MANAGEMENT_DXE_GUID": [
        2224624263,
        16368,
        20428,
        156,
        17,
        199,
        224,
        65,
        134,
        44,
        118,
    ],
    "DELL_AC_RECOVERY_SMM_GUID": [
        2239859116,
        3786,
        18022,
        186,
        184,
        153,
        114,
        64,
        153,
        83,
        200,
    ],
    "DELL_SMM_SIO_DASH_GUID": [
        2277981212,
        5417,
        20213,
        163,
        250,
        8,
        215,
        62,
        248,
        200,
        39,
    ],
    "DELL_SMM_EVENT_DXE_GUID": [
        2295339961,
        9338,
        18166,
        187,
        110,
        187,
        164,
        159,
        17,
        36,
        248,
    ],
    "DELL_SETUP_PREP_GUID": [
        2308179927,
        39422,
        17368,
        154,
        33,
        121,
        236,
        50,
        140,
        172,
        33,
    ],
    "DELL_DXE_PREREQ_GUID": [
        2311005263,
        58729,
        16751,
        177,
        16,
        138,
        229,
        239,
        213,
        23,
        28,
    ],
    "DELL_SPI_PART_ST_MICRO_GUID": [
        2325708028,
        23548,
        17807,
        152,
        111,
        188,
        61,
        27,
        167,
        172,
        137,
    ],
    "DELL_DIAGS_LEGACY_GUID": [
        2337444691,
        8140,
        19136,
        161,
        33,
        144,
        190,
        159,
        156,
        191,
        122,
    ],
    "DELL_ACPI_PLATFORM_GUID": [
        2338306749,
        62751,
        18754,
        191,
        22,
        22,
        170,
        163,
        138,
        229,
        43,
    ],
    "DELL_POWER_MANAGEMENT_GUID": [
        2356689264,
        61482,
        19021,
        175,
        9,
        135,
        151,
        165,
        30,
        236,
        141,
    ],
    "DELL_AHCI_SMM_GUID": [
        2364933421,
        33107,
        17247,
        171,
        164,
        17,
        75,
        106,
        63,
        181,
        61,
    ],
    "DELL_ME_PLATFORM_CONFIG_DXE_GUID": [
        2368893290,
        24799,
        19422,
        134,
        71,
        61,
        23,
        140,
        200,
        43,
        108,
    ],
    "DELL_PCI_HOST_BRIDGE_GUID": [
        2372359865,
        58718,
        19818,
        163,
        165,
        94,
        77,
        114,
        221,
        247,
        114,
    ],
    "DELL_SMM_SERVICES_GUID": [
        2379094359,
        55156,
        20442,
        185,
        15,
        11,
        35,
        28,
        178,
        224,
        204,
    ],
    "DELL_MOD_BAY_CONFIG_GUID": [
        2384466983,
        17978,
        19748,
        160,
        244,
        37,
        168,
        117,
        246,
        27,
        170,
    ],
    "DELL_SERVICE_RESET_SMM_GUID": [
        2395179049,
        42399,
        16611,
        186,
        208,
        133,
        248,
        21,
        161,
        87,
        209,
    ],
    "DELL_EC_CONFIG_DXE_GUID": [
        2395213747,
        16901,
        19799,
        144,
        57,
        161,
        146,
        131,
        44,
        124,
        237,
    ],
    "DELL_ERROR_HANDLER_DXE_GUID": [
        2403573131,
        1970,
        16673,
        170,
        149,
        138,
        201,
        21,
        113,
        170,
        117,
    ],
    "DELL_DEFAULT_BOOT_LIST_DXE_GUID": [
        2403573131,
        1970,
        16673,
        170,
        149,
        138,
        201,
        21,
        113,
        255,
        255,
    ],
    "DELL_AHCISRC_GUID": [
        2405051906,
        21388,
        19801,
        185,
        32,
        196,
        120,
        106,
        203,
        197,
        82,
    ],
    "DELL_SB_ACCESS_SMM_GUID": [
        2411212196,
        50110,
        17062,
        138,
        112,
        123,
        148,
        214,
        9,
        114,
        166,
    ],
    "DELL_IMG_SRV_BASE_ROM_GUID": [
        2419529971,
        22365,
        19868,
        188,
        120,
        101,
        161,
        19,
        129,
        160,
        38,
    ],
    "DELL_SMART_TIMER_GUID": [
        2429253083,
        29180,
        18589,
        170,
        207,
        148,
        52,
        119,
        236,
        114,
        18,
    ],
    "DELL_PBA_FP_DXE_GUID": [
        2444894238,
        5665,
        18172,
        130,
        90,
        176,
        54,
        62,
        202,
        212,
        188,
    ],
    "DELL_HECI_SMM_GUID": [
        2451363715,
        15906,
        17785,
        167,
        31,
        0,
        215,
        65,
        151,
        252,
        200,
    ],
    "DELL_SMM_COMPUTRACE_GUID": [
        2462551630,
        51604,
        20382,
        130,
        171,
        175,
        29,
        186,
        104,
        88,
        201,
    ],
    "DELL_FILE_SYSTEM_GUID": [
        2466393996,
        7945,
        18415,
        187,
        178,
        88,
        20,
        255,
        96,
        157,
        245,
    ],
    "DELL_DIRTY_SHUTDOWN_DXE_GUID": [
        2474053840,
        61200,
        17086,
        146,
        225,
        132,
        148,
        114,
        43,
        23,
        181,
    ],
    "DELL_SB_ACPI_CONFIG_GUID": [
        2492620721,
        61172,
        16877,
        189,
        122,
        205,
        176,
        74,
        170,
        129,
        199,
    ],
    "DELL_TCG_SETUP_GUID": [
        2498613546,
        16795,
        17535,
        148,
        52,
        155,
        59,
        112,
        120,
        57,
        3,
    ],
    "DELL_SERVICE_RESET_DXE_GUID": [
        2537284199,
        2400,
        16583,
        152,
        86,
        250,
        115,
        201,
        42,
        70,
        186,
    ],
    "DELL_BIOS_EXTENSION_LOADER_GUID": [
        2546758024,
        31177,
        17567,
        185,
        105,
        6,
        91,
        100,
        191,
        156,
        105,
    ],
    "DELL_HOT_SOS_DXE_DRIVER_GUID": [
        2564335444,
        33922,
        18146,
        130,
        140,
        187,
        99,
        47,
        52,
        217,
        247,
    ],
    "DELL_SM_BIOS_STRUC_DE_GUID": [
        2573047489,
        26193,
        18096,
        191,
        62,
        131,
        192,
        23,
        180,
        59,
        29,
    ],
    "DELL_SB_SMM_HOOKS_GUID": [
        2577523701,
        2183,
        17351,
        176,
        10,
        241,
        74,
        100,
        107,
        193,
        66,
    ],
    "DELL_BBSMANAGER_DXE_GUID": [
        2595435247,
        33241,
        17361,
        134,
        122,
        3,
        221,
        87,
        78,
        133,
        102,
    ],
    "DELL_GSET_CONFIG_GUID": [
        2599541285,
        61548,
        17339,
        190,
        136,
        131,
        69,
        80,
        191,
        118,
        91,
    ],
    "DELL_MULTI_DISPLAY_DXE_GUID": [
        2617192461,
        54855,
        18446,
        159,
        243,
        32,
        6,
        211,
        215,
        204,
        198,
    ],
    "DELL_AMI_BOARD_INFO_GUID": [
        2671378454,
        44629,
        17032,
        130,
        157,
        210,
        47,
        211,
        68,
        195,
        71,
    ],
    "DELL_DA_NON_VOLITILE_STORAGE_GUID": [
        2679520249,
        46370,
        16899,
        154,
        83,
        32,
        236,
        133,
        74,
        49,
        42,
    ],
    "DELL_DXE_MAIN_GUID": [
        2681197550,
        14531,
        19119,
        149,
        18,
        236,
        65,
        99,
        113,
        246,
        74,
    ],
    "DELL_SIO_POLICY_CONFIG_DXE_GUID": [
        2688661718,
        16151,
        17794,
        170,
        199,
        90,
        97,
        86,
        114,
        226,
        149,
    ],
    "DELL_CSMCORE_GUID": [
        2690830111,
        33907,
        19107,
        135,
        147,
        96,
        11,
        196,
        255,
        233,
        168,
    ],
    "DELL_HDD_PW_SMM_GUID": [
        2696445586,
        25490,
        18430,
        154,
        160,
        144,
        32,
        49,
        71,
        236,
        4,
    ],
    "DELL_SMM_CONTROL_GUID": [
        2696600055,
        43896,
        18715,
        181,
        131,
        197,
        43,
        127,
        132,
        185,
        224,
    ],
    "DELL_PCI_EXPRESS_DXE_GUID": [
        2711597294,
        1524,
        19670,
        143,
        40,
        89,
        183,
        130,
        255,
        149,
        198,
    ],
    "DELL_SPI_PART_SST_GUID": [
        2726778251,
        55773,
        17947,
        169,
        41,
        236,
        42,
        210,
        254,
        245,
        145,
    ],
    "DELL_SPI_CONTROLLER_DXE_GUID": [
        2742722115,
        36983,
        17721,
        155,
        144,
        189,
        113,
        155,
        3,
        43,
        35,
    ],
    "DELL_SMB_FACT_DEFAULT_GUID": [
        2748922409,
        20507,
        20334,
        134,
        154,
        111,
        212,
        188,
        239,
        144,
        167,
    ],
    "DELL_SMM_SIO_GPIO_CONTROL_GUID": [
        2806725359,
        9474,
        16581,
        131,
        169,
        53,
        36,
        119,
        98,
        115,
        234,
    ],
    "DELL_IMAGE_SERVER_SMM_GUID": [
        2812134215,
        57012,
        19022,
        132,
        151,
        202,
        95,
        142,
        127,
        6,
        1,
    ],
    "DELL_PBA_MGR_DXE_GUID": [
        2813554127,
        51034,
        19432,
        190,
        47,
        228,
        132,
        12,
        190,
        22,
        59,
    ],
    "DELL_IMAGE_SERVER_DXE_GUID": [
        2821932058,
        3232,
        16434,
        133,
        154,
        60,
        255,
        123,
        102,
        70,
        167,
    ],
    "DELL_LOM_CONFIG_GUID": [
        2826249488,
        55358,
        16394,
        133,
        222,
        253,
        21,
        135,
        136,
        42,
        254,
    ],
    "DELL_LEGACY_USB_SMM_GUID": [
        2829252321,
        28514,
        19707,
        158,
        71,
        147,
        207,
        214,
        214,
        228,
        118,
    ],
    "DELL_AMT_SMBIOS_GUID": [
        2831577685,
        57385,
        19226,
        150,
        142,
        236,
        166,
        233,
        193,
        28,
        115,
    ],
    "DELL_TCG_MOR_GUID": [2906746083, 42115, 17841, 148, 194, 75, 78, 77, 87, 85, 98],
    "DELL_DO_SIODIAG_LED_DXE_GUID": [
        2907311365,
        32877,
        20452,
        150,
        173,
        59,
        214,
        45,
        140,
        76,
        224,
    ],
    "DELL_AUDIO_DXE_GUID": [
        2921628957,
        58388,
        16482,
        149,
        157,
        95,
        67,
        234,
        153,
        54,
        60,
    ],
    "DELL_FV_MAINNESTED_GUID": [
        2926672943,
        6722,
        20267,
        136,
        97,
        120,
        183,
        156,
        160,
        126,
        7,
    ],
    "DELL_SMM_CRYPTO_ALGORITHM_GUID": [
        2951172549,
        1492,
        18584,
        191,
        148,
        26,
        75,
        80,
        243,
        95,
        212,
    ],
    "DELL_PCH_SMI_DISPATCHER_GUID": [
        2966875475,
        47172,
        17397,
        189,
        47,
        97,
        9,
        82,
        100,
        231,
        126,
    ],
    "DELL_SMBIOS64_GUID": [
        2973687096,
        26700,
        16877,
        163,
        5,
        215,
        183,
        227,
        36,
        151,
        223,
    ],
    "DELL_AMITSE_GUID": [2983856863, 20343, 16496, 168, 142, 191, 254, 28, 96, 82, 154],
    "DELL_DXE_DELAY_GUID": [
        3021497697,
        35175,
        16659,
        188,
        95,
        40,
        75,
        118,
        112,
        196,
        160,
    ],
    "DELL_LEG_USB_MEM_INFO_DXE_GUID": [
        3025887172,
        54950,
        17699,
        162,
        41,
        231,
        119,
        32,
        151,
        239,
        20,
    ],
    "DELL_SECURITY_CONFIG_GUID": [
        3072249106,
        57374,
        17419,
        170,
        82,
        77,
        110,
        89,
        212,
        91,
        60,
    ],
    "DELL_SMB_VERSION_MANIFEST_GUID": [
        3108097809,
        58952,
        16412,
        146,
        161,
        52,
        42,
        112,
        198,
        183,
        66,
    ],
    "DELL_SMBIOSUPDATE_DATA_GUID": [
        3112802724,
        59759,
        18266,
        153,
        252,
        118,
        33,
        38,
        245,
        15,
        90,
    ],
    "DELL_PCH_RESET_GUID": [
        3139419471,
        11824,
        18323,
        155,
        237,
        116,
        246,
        114,
        188,
        143,
        254,
    ],
    "DELL_SATA_CONTROLLER_GUID": [
        3143996459,
        21023,
        20163,
        186,
        249,
        169,
        37,
        64,
        207,
        96,
        210,
    ],
    "DELL_ALERT_STANDARD_FORMAT_SMM_GUID": [
        3146232605,
        62310,
        18409,
        136,
        94,
        232,
        22,
        176,
        155,
        151,
        182,
    ],
    "DELL_AHCI_SMM_GUID": [
        3157411261,
        47490,
        20309,
        159,
        121,
        5,
        106,
        215,
        233,
        135,
        197,
    ],
    "DELL_DA_TAA_MAC_GUID": [
        3165370077,
        16031,
        18402,
        184,
        251,
        16,
        179,
        154,
        246,
        52,
        44,
    ],
    "DELL_HOT_KEY_HANDLER_DXE_GUID": [
        3166386450,
        10746,
        19237,
        182,
        25,
        60,
        13,
        115,
        159,
        239,
        81,
    ],
    "DELL_CMOS_MANAGER_DXE_SRC_GUID": [
        3175457368,
        51133,
        19440,
        178,
        84,
        208,
        212,
        94,
        2,
        248,
        119,
    ],
    "DELL_DXE_GPIO_CONTROL_GUID": [
        3184242748,
        21598,
        17345,
        138,
        168,
        240,
        88,
        196,
        250,
        129,
        168,
    ],
    "DELL_DT_LEG_USB_POLICY_GUID": [
        3186172457,
        63909,
        18583,
        129,
        228,
        139,
        171,
        103,
        146,
        163,
        149,
    ],
    "DELL_PXE_BASE_ROM_GUID": [
        3187322150,
        19839,
        17574,
        135,
        25,
        55,
        94,
        203,
        74,
        164,
        7,
    ],
    "DELL_SMI_VARIABLE_GUID": [
        3189861288,
        14532,
        17717,
        166,
        202,
        93,
        202,
        91,
        67,
        173,
        223,
    ],
    "DELL_POWER_BUTTON_DXE_GUID": [
        3207045736,
        62313,
        17314,
        178,
        149,
        36,
        45,
        238,
        127,
        60,
        41,
    ],
    "DELL_ACTIVE_BIOS_GUID": [
        3218447682,
        65039,
        16977,
        183,
        114,
        75,
        9,
        138,
        26,
        236,
        133,
    ],
    "DELL_D010_ALEGACY_VIDEO_ROM_GUID": [
        3233357934,
        46763,
        19952,
        179,
        214,
        40,
        106,
        199,
        102,
        152,
        189,
    ],
    "DELL_SMM_DIAG_LEDS_GUID": [
        3238698573,
        48564,
        19226,
        130,
        204,
        217,
        1,
        248,
        111,
        87,
        57,
    ],
    "DELL_FLASH_WRITE_PROTECT_GUID": [
        3242472502,
        47444,
        17338,
        130,
        120,
        193,
        228,
        66,
        194,
        21,
        57,
    ],
    "DELL_LEGACY_INTERRUPT_GUID": [
        3250854137,
        22813,
        17948,
        130,
        162,
        185,
        205,
        150,
        223,
        234,
        134,
    ],
    "DELL_SAVE_MEMORY_CONFIG_DXE_GUID": [
        3289668034,
        41601,
        16595,
        179,
        10,
        43,
        157,
        255,
        63,
        61,
        160,
    ],
    "DELL_SPI_PART_WINBOND_GUID": [
        3291682642,
        35756,
        20266,
        169,
        195,
        65,
        138,
        223,
        176,
        51,
        196,
    ],
    "DELL_DA_ASSET_TAG_GUID": [
        3301417385,
        54841,
        17453,
        179,
        88,
        9,
        208,
        106,
        225,
        139,
        252,
    ],
    "DELL_IDE_RCONTROLLER_GUID": [
        3304247303,
        14333,
        16941,
        182,
        61,
        126,
        215,
        56,
        134,
        230,
        202,
    ],
    "DELL_PBA_USH_GUID": [3327848673, 33459, 16746, 143, 10, 221, 208, 211, 9, 140, 88],
    "DELL_LEGACY_TCG_SUPPORT_GUID": [
        3330062921,
        46022,
        19642,
        150,
        113,
        191,
        39,
        136,
        113,
        33,
        40,
    ],
    "DELL_SMB_STRUC_B2_CONFIG_GUID": [
        3350273852,
        35305,
        17503,
        169,
        114,
        103,
        27,
        139,
        23,
        88,
        13,
    ],
    "DELL_TDT_AM_GUID": [3356510302, 53484, 20120, 170, 181, 18, 12, 126, 85, 68, 40],
    "DELL_HOT_KEYS_CONFIG_GUID": [
        3361833421,
        45964,
        18909,
        161,
        118,
        125,
        195,
        89,
        24,
        22,
        169,
    ],
    "DELL_SMM_EVENT_SMM_GUID": [
        3363683096,
        39645,
        16853,
        128,
        215,
        76,
        141,
        121,
        90,
        217,
        66,
    ],
    "DELL_DASH_CONFIG_GUID": [
        3365727239,
        50414,
        17420,
        191,
        197,
        162,
        47,
        67,
        55,
        47,
        34,
    ],
    "DELL_SMM_MULTI_PLATFORM_GUID": [
        3386494532,
        28813,
        20007,
        185,
        137,
        227,
        90,
        51,
        153,
        156,
        40,
    ],
    "DELL_RUNTIME_GUID": [
        3418725450,
        14394,
        16875,
        168,
        238,
        68,
        152,
        174,
        165,
        103,
        228,
    ],
    "DELL_SM_BIOS_STRUC_D2_GUID": [
        3435955970,
        48488,
        17841,
        130,
        55,
        199,
        221,
        0,
        76,
        219,
        55,
    ],
    "DELL_CSP_LIB_DXE_GUID": [
        3448002092,
        26724,
        16547,
        160,
        129,
        200,
        211,
        94,
        130,
        185,
        32,
    ],
    "DELL_TCG_SMM_GUID": [
        3451984617,
        487,
        17099,
        136,
        235,
        253,
        255,
        216,
        129,
        152,
        147,
    ],
    "DELL_SMBIOS_BOARD_GUID": [
        3472264294,
        1707,
        20403,
        163,
        237,
        95,
        250,
        136,
        91,
        87,
        37,
    ],
    "DELL_SMM_BASE_GUID": [3496160400, 45015, 17554, 177, 134, 37, 124, 99, 20, 60, 97],
    "DELL_SLP_MARKER_CTRL_GUID": [
        3511775422,
        54546,
        18580,
        184,
        99,
        157,
        14,
        111,
        245,
        197,
        97,
    ],
    "DELL_THROTTLING_DRIVER_GUID": [
        3564284724,
        36385,
        17219,
        139,
        255,
        1,
        236,
        222,
        41,
        35,
        117,
    ],
    "DELL_TERMINAL_PLATFORM_POLICY_GUID": [
        3567753741,
        46717,
        20099,
        142,
        251,
        69,
        89,
        36,
        55,
        41,
        52,
    ],
    "DELL_DIAGS_SMM_GUID": [
        3568703808,
        29611,
        18597,
        158,
        38,
        83,
        164,
        202,
        74,
        44,
        55,
    ],
    "DELL_HDD_SMART_SMM_GUID": [
        3592121466,
        25914,
        17833,
        138,
        243,
        99,
        168,
        165,
        7,
        102,
        57,
    ],
    "DELL_PCH_POLICY_INIT_DXE_GUID": [
        3601615554,
        35778,
        19677,
        135,
        118,
        40,
        14,
        20,
        105,
        222,
        2,
    ],
    "DELL_NB_CONFIG_DXE_GUID": [
        3607159740,
        17041,
        18249,
        135,
        175,
        67,
        42,
        2,
        61,
        230,
        88,
    ],
    "DELL_I_AMTDXE_GUID": [
        3610900841,
        64301,
        19394,
        175,
        231,
        8,
        19,
        39,
        211,
        254,
        222,
    ],
    "DELL_AMT_WRAPPER_DXE_GUID": [
        3615264781,
        41415,
        16837,
        185,
        137,
        12,
        61,
        55,
        252,
        164,
        50,
    ],
    "DELL_PHYSICAL_PRESENCE_GUID": [
        3629795852,
        11891,
        17553,
        146,
        225,
        220,
        239,
        195,
        136,
        42,
        104,
    ],
    "DELL_SMM_GPIO_CONTROL_GUID": [
        3644366586,
        11418,
        18070,
        139,
        182,
        252,
        95,
        57,
        141,
        141,
        243,
    ],
    "DELL_SM_BIOS_STRUC_D9_GUID": [
        3654093472,
        49679,
        18448,
        153,
        158,
        217,
        145,
        253,
        4,
        132,
        217,
    ],
    "DELL_STORAGE_AGENTS_SMM_GUID": [
        3661961974,
        35025,
        20439,
        184,
        110,
        68,
        188,
        71,
        238,
        31,
        126,
    ],
    "DELL_SMB_BBS_INFO_GUID": [
        3698353148,
        57373,
        18287,
        155,
        243,
        222,
        1,
        8,
        132,
        188,
        83,
    ],
    "DELL_SM_BIOS_STRUC_B2_GUID": [
        3701255400,
        35886,
        20455,
        158,
        65,
        225,
        140,
        117,
        254,
        155,
        102,
    ],
    "DELL_TDT_DXE_GUID": [
        3702147936,
        16527,
        19373,
        153,
        185,
        184,
        128,
        212,
        239,
        9,
        80,
    ],
    "DELL_SA_INIT_DXE_GUID": [
        3726879982,
        53077,
        20406,
        170,
        119,
        152,
        74,
        181,
        61,
        232,
        17,
    ],
    "DELL_PCH_INIT_DXE_GUID": [
        3726879982,
        53077,
        20406,
        170,
        119,
        152,
        74,
        181,
        61,
        232,
        35,
    ],
    "DELL_SMBIOS_GET_FLASH_DATA64_GUID": [
        3738670445,
        32288,
        20256,
        145,
        161,
        25,
        4,
        57,
        176,
        77,
        91,
    ],
    "DELL_IDE_DXE_GUID": [3741056122, 52226, 16933, 136, 173, 60, 65, 230, 33, 120, 91],
    "DELL_MFG_MODE_DXE_DRIVER_GUID": [
        3756519012,
        54525,
        17444,
        191,
        31,
        133,
        218,
        82,
        66,
        54,
        251,
    ],
    "DELL_DA_OWNER_TAG_GUID": [
        3757369032,
        9036,
        17726,
        169,
        45,
        250,
        80,
        94,
        144,
        213,
        57,
    ],
    "DELL_DA_BFA_GUID": [3761655790, 5184, 19009, 173, 62, 80, 224, 177, 6, 168, 61],
    "DELL_CPU_DXE_GUID": [
        3761945311,
        58678,
        20104,
        179,
        160,
        183,
        127,
        120,
        235,
        52,
        254,
    ],
    "DELL_PCH_SMBUS_DXE_GUID": [
        3763525798,
        8778,
        19506,
        141,
        55,
        46,
        10,
        225,
        98,
        54,
        77,
    ],
    "DELL_DA_PASSWORDS_GUID": [
        3775216056,
        7221,
        19332,
        133,
        147,
        129,
        85,
        93,
        6,
        93,
        213,
    ],
    "DELL_SLP_CONFIG_GUID": [
        3805262678,
        14761,
        18811,
        182,
        177,
        149,
        185,
        210,
        235,
        40,
        23,
    ],
    "DELL_DXE_SB_GPIO_CONTROL_GUID": [
        3808813313,
        37178,
        19025,
        142,
        14,
        180,
        97,
        140,
        93,
        179,
        38,
    ],
    "DELL_SMB_DA_TOKENS_CONFIG_GUID": [
        3816052554,
        10975,
        17371,
        167,
        120,
        136,
        167,
        95,
        192,
        128,
        38,
    ],
    "DELL_OEM_BADGING_SUPPORT_GUID": [
        3818072628,
        22313,
        20260,
        159,
        177,
        215,
        64,
        155,
        69,
        106,
        21,
    ],
    "DELL_SMM_CIRC_BUFF_GUID": [
        3823991841,
        40376,
        18375,
        142,
        125,
        125,
        185,
        127,
        226,
        6,
        62,
    ],
    "DELL_POWER_BUTTON_GUID": [
        3848712343,
        17272,
        18527,
        145,
        208,
        28,
        9,
        124,
        25,
        12,
        226,
    ],
    "DELL_ASF_TABLE_GUID": [
        3877971919,
        20571,
        19280,
        153,
        205,
        163,
        36,
        103,
        250,
        74,
        164,
    ],
    "DELL_RUNTIME_ACPI_SMM_GUID": [
        3883815845,
        42424,
        17884,
        186,
        235,
        102,
        200,
        111,
        26,
        200,
        17,
    ],
    "DELL_TAGS_CONFIG_GUID": [
        3892811838,
        54118,
        16585,
        132,
        106,
        14,
        215,
        230,
        2,
        44,
        150,
    ],
    "DELL_SM_BIOS_STRUC_FAN_GUID": [
        3916771658,
        5220,
        16671,
        133,
        228,
        4,
        29,
        144,
        60,
        182,
        196,
    ],
    "DELL_SMM_ASF_INIT_GUID": [
        3950562942,
        16647,
        20213,
        134,
        203,
        34,
        232,
        216,
        172,
        73,
        80,
    ],
    "DELL_SM_BIOS_STRUC_D8_GUID": [
        3973583987,
        1331,
        18500,
        188,
        119,
        72,
        240,
        222,
        39,
        81,
        155,
    ],
    "DELL_SM_BIOS_MEMORY_GUID": [
        3986920450,
        62325,
        17558,
        146,
        211,
        131,
        180,
        60,
        184,
        167,
        106,
    ],
    "DELL_S3_RESUME_GUID": [
        4023800524,
        3737,
        16624,
        150,
        192,
        224,
        140,
        8,
        144,
        112,
        252,
    ],
    "DELL_DXE_DIAG_LEDS_GUID": [
        4040744618,
        50325,
        16697,
        177,
        252,
        120,
        183,
        1,
        104,
        38,
        10,
    ],
    "DELL_WARM_BOOT_SMM_GUID": [
        4043307108,
        33876,
        18149,
        159,
        43,
        207,
        20,
        240,
        164,
        26,
        72,
    ],
    "DELL_BOOT_SCRIPT_SMI_HANDLER_GUID": [
        4053894950,
        64889,
        19957,
        163,
        38,
        226,
        11,
        140,
        196,
        107,
        6,
    ],
    "DELL_TPM_SMM_GUID": [
        4078416539,
        32201,
        16660,
        144,
        134,
        215,
        19,
        126,
        244,
        241,
        24,
    ],
    "DELL_DXE_SIO_EMI_GUID": [
        4078728889,
        2901,
        17494,
        153,
        254,
        80,
        169,
        197,
        236,
        17,
        108,
    ],
    "DELL_GT2_LEGACY_VIDEO_ROM_GUID": [
        4132371130,
        53417,
        17091,
        181,
        232,
        57,
        27,
        72,
        100,
        123,
        241,
    ],
    "DELL_SM_BIOS_STRUC_THERM_GUID": [
        4140673760,
        45825,
        16898,
        137,
        246,
        134,
        35,
        230,
        174,
        210,
        110,
    ],
    "DELL_VIDEO_CONFIG_DXE_GUID": [
        4158125896,
        52446,
        18463,
        155,
        134,
        46,
        245,
        237,
        172,
        194,
        29,
    ],
    "DELL_SMB_RUN_ROM_GUID": [
        4173021602,
        18526,
        19357,
        136,
        207,
        21,
        30,
        98,
        248,
        77,
        222,
    ],
    "DELL_BBSMANAGER_SMM_GUID": [
        4178613140,
        58787,
        20065,
        177,
        104,
        220,
        52,
        213,
        52,
        69,
        30,
    ],
    "DELL_PHYSICAL_PRESENCE_SMM_GUID": [
        4181065499,
        45040,
        16627,
        183,
        122,
        183,
        149,
        167,
        167,
        215,
        20,
    ],
    "DELL_ME_LOCAL_FW_UPDATE_DXE_GUID": [
        4182422346,
        32873,
        19103,
        173,
        8,
        149,
        52,
        239,
        55,
        217,
        190,
    ],
    "DELL_PCI_SERIAL_GUID": [
        4212403097,
        57175,
        18123,
        188,
        105,
        11,
        248,
        88,
        167,
        52,
        249,
    ],
    "DELL_PCH_SERIAL_GPIO_GUID": [
        4229658176,
        13414,
        19462,
        177,
        204,
        28,
        147,
        83,
        148,
        181,
        194,
    ],
    "DELL_SMI_CPU_DECODE_GUID": [
        4236726303,
        63239,
        18850,
        182,
        118,
        119,
        113,
        125,
        217,
        4,
        220,
    ],
    "DELL_SMM_S3_GUID": [160950128, 30062, 16697, 191, 63, 127, 194, 163, 8, 23, 126],
    "DELL_CPU_PEI_BEFORE_MEM_GUID": [
        357936371,
        48391,
        18053,
        182,
        104,
        168,
        105,
        69,
        164,
        18,
        77,
    ],
    "DELL_WDT_PEI_GUID": [495502658, 40439, 16970, 170, 144, 2, 182, 31, 40, 105, 56],
    "DELL_PEI_HWM_INIT_GUID": [
        572352352,
        19136,
        19474,
        186,
        150,
        156,
        99,
        228,
        217,
        193,
        200,
    ],
    "DELL_CPU_PEI_GUID": [
        733327273,
        65331,
        16763,
        132,
        151,
        203,
        119,
        60,
        43,
        147,
        191,
    ],
    "DELL_AUDIO_CONFIG_PEI_GUID": [
        862772714,
        43816,
        19532,
        159,
        100,
        95,
        224,
        57,
        31,
        235,
        184,
    ],
    "DELL_TCG_PEI_GUID": [882417038, 37642, 19093, 171, 4, 46, 108, 253, 255, 102, 49],
    "DELL_MEMORY_INIT_GUID": [
        994242391,
        5843,
        17611,
        134,
        50,
        159,
        219,
        6,
        180,
        20,
        81,
    ],
    "DELL_ALERT_STANDARD_FORMAT_PEI_GUID": [
        1044912125,
        10050,
        17233,
        181,
        159,
        145,
        73,
        50,
        128,
        50,
        156,
    ],
    "DELL_AMT_CONFIG_PEI_GUID": [
        1240117670,
        44847,
        16484,
        155,
        41,
        217,
        101,
        91,
        59,
        141,
        237,
    ],
    "DELL_OP_PRESENCE_GUID": [
        1340568296,
        65086,
        16518,
        182,
        56,
        140,
        73,
        60,
        73,
        4,
        136,
    ],
    "DELL_START_WATCH_DOG_GUID": [
        1417273500,
        11892,
        18459,
        137,
        248,
        176,
        23,
        46,
        56,
        141,
        31,
    ],
    "DELL_ERROR_HANDLER_PEI_GUID": [
        1495580163,
        40408,
        19371,
        128,
        143,
        194,
        28,
        171,
        254,
        11,
        75,
    ],
    "DELL_PCH_SMBUS_ARP_DISABLED_GUID": [
        1681782647,
        62226,
        17133,
        129,
        204,
        27,
        31,
        87,
        225,
        138,
        214,
    ],
    "DELL_PCH_USB_GUID": [1800395730, 18401, 18953, 186, 142, 142, 4, 31, 32, 139, 149],
    "DELL_TCG_PEI2_GUID": [
        1894142482,
        62381,
        18783,
        179,
        161,
        122,
        99,
        84,
        46,
        215,
        213,
    ],
    "DELL_SB_POWER_OFF_PEI_GUID": [
        2035578841,
        6022,
        19850,
        139,
        137,
        63,
        167,
        98,
        63,
        126,
        248,
    ],
    "DELL_CMOS_MANAGER_PEI_SRC_GUID": [
        2104986061,
        64800,
        19461,
        165,
        121,
        145,
        37,
        61,
        94,
        61,
        158,
    ],
    "DELL_MFG_MODE_PEI_DRIVER_GUID": [
        2180037874,
        61869,
        19934,
        158,
        91,
        117,
        235,
        52,
        39,
        171,
        196,
    ],
    "DELL_CORE_PEI_GUID": [
        2456312131,
        55312,
        18431,
        161,
        18,
        204,
        132,
        144,
        119,
        106,
        31,
    ],
    "DELL_HECI_PEI_GUID": [
        2633171749,
        56412,
        17750,
        168,
        176,
        116,
        33,
        92,
        95,
        127,
        196,
    ],
    "DELL_AUDIO_PEI_GUID": [
        2698503429,
        24020,
        17497,
        164,
        211,
        54,
        17,
        149,
        99,
        196,
        249,
    ],
    "DELL_FLASH_UPDATE_PEI_GUID": [
        2726198370,
        9375,
        19323,
        189,
        92,
        128,
        114,
        2,
        3,
        93,
        236,
    ],
    "DELL_WARM_BOOT_PEI_GUID": [
        2977490346,
        2166,
        16906,
        180,
        15,
        227,
        155,
        78,
        110,
        224,
        91,
    ],
    "DELL_PEI_MAIN_GUID": [
        2981029912,
        47449,
        18555,
        167,
        149,
        22,
        194,
        165,
        76,
        179,
        110,
    ],
    "DELL_DO_SIODIAG_LED_PEI_GUID": [
        3062824394,
        48866,
        19446,
        184,
        110,
        69,
        220,
        60,
        203,
        254,
        60,
    ],
    "DELL_PCH_ME_UMA_GUID": [
        3064115187,
        30332,
        22104,
        195,
        122,
        209,
        200,
        46,
        247,
        101,
        67,
    ],
    "DELL_PEI_DIAG_LEDS_GUID": [
        3355234115,
        22617,
        19134,
        188,
        181,
        76,
        22,
        38,
        237,
        139,
        3,
    ],
    "DELL_TXT_PEI_GUID": [3399321111, 54866, 16443, 182, 197, 186, 71, 87, 1, 22, 173],
    "DELL_TXT_CONFIG_PEI_GUID": [
        3451279361,
        18765,
        18222,
        166,
        168,
        175,
        245,
        183,
        110,
        141,
        31,
    ],
    "DELL_PEI_SIO_EMI_GUID": [
        3493973952,
        30320,
        17242,
        165,
        18,
        244,
        92,
        146,
        59,
        40,
        93,
    ],
    "DELL_SYSTEM_ID_CONFIG_PEI_GUID": [
        3733609004,
        55176,
        18427,
        160,
        181,
        32,
        202,
        142,
        88,
        223,
        236,
    ],
    "DELL_NB_CONFIG_PEI_GUID": [
        3844102995,
        38744,
        17579,
        164,
        77,
        219,
        59,
        228,
        29,
        103,
        66,
    ],
    "DELL_DIRTY_SHUTDOWN_PEI_GUID": [
        3848613761,
        60425,
        18332,
        186,
        255,
        231,
        86,
        241,
        130,
        144,
        22,
    ],
    "DELL_SIO_POLICY_CONFIG_PEI_GUID": [
        3880245503,
        6036,
        18630,
        150,
        215,
        164,
        25,
        217,
        198,
        15,
        17,
    ],
    "DELL_ACLOSS_PEI_GUID": [
        3919974292,
        31371,
        17850,
        156,
        50,
        52,
        133,
        82,
        107,
        87,
        22,
    ],
    "DELL_SB_CONFIG_PEI_GUID": [
        3921022868,
        31243,
        18637,
        156,
        136,
        132,
        132,
        82,
        108,
        87,
        25,
    ],
    "DELL_VIDEO_CONFIG_PEI_GUID": [
        4133865501,
        61406,
        19295,
        136,
        232,
        33,
        96,
        183,
        72,
        210,
        180,
    ],
    "DELL_EC_CONFIG_PEI_GUID": [
        4219737527,
        60030,
        20077,
        147,
        129,
        0,
        92,
        59,
        209,
        218,
        215,
    ],
    "DELL_SA_INIT_PEIM_GUID": [
        4246956775,
        1937,
        18628,
        178,
        158,
        41,
        189,
        238,
        225,
        168,
        17,
    ],
    "DELL_PCH_INIT_PEIM_GUID": [
        4246956775,
        1937,
        18628,
        178,
        158,
        41,
        189,
        238,
        225,
        168,
        56,
    ],
}
