# GUIDs from https://github.com/snare/ida-efiutils/blob/master/efiguids_ami.py

# pylint: disable=duplicate-key
ami_guids = {
    "ACOUSTIC_SETUP_PROTOCOL_GUID": [
        0xC1D7859D,
        0x5719,
        0x46C3,
        0xA2,
        0x98,
        0xD0,
        0x71,
        0xE3,
        0x2,
        0x64,
        0xD1,
    ],
    "ADD_BOOT_OPTION_GUID": [
        0x19D96D3F,
        0x6A6A,
        0x47D2,
        0xB1,
        0x95,
        0x7B,
        0x24,
        0x32,
        0xDA,
        0x3B,
        0xE2,
    ],
    "ADVANCED_FORM_SET_GUID": [
        0xE14F04FA,
        0x8706,
        0x4353,
        0x92,
        0xF2,
        0x9C,
        0x24,
        0x24,
        0x74,
        0x6F,
        0x9F,
    ],
    "AHCI_BUS_INIT_PROTOCOL_GUID": [
        0xB2FA4764,
        0x3B6E,
        0x43D3,
        0x91,
        0xDF,
        0x87,
        0xD1,
        0x5A,
        0x3E,
        0x56,
        0x68,
    ],
    "AHCI_SMM_PROTOCOL_GUID": [
        0xB2FA5764,
        0x3B6E,
        0x43D3,
        0x91,
        0xDF,
        0x87,
        0xD1,
        0x5A,
        0x3E,
        0x56,
        0x68,
    ],
    "AMICSM_PCIBUSNUM_XLAT_PROTOCOL_GUID": [
        0xCB5C54C0,
        0x230D,
        0x43DB,
        0x92,
        0x2C,
        0x24,
        0xD3,
        0x4F,
        0x8C,
        0x91,
        0x5C,
    ],
    "AMITSESETUP_GUID": [
        0xC811FA38,
        0x42C8,
        0x4579,
        0xA9,
        0xBB,
        0x60,
        0xE9,
        0x4E,
        0xDD,
        0xFB,
        0x34,
    ],
    "AMITSE_ADMIN_PASSWORD_VALID_GUID": [
        0x541D5A75,
        0x95EE,
        0x43C7,
        0x9E,
        0x5D,
        0x23,
        0x94,
        0xDC,
        0x48,
        0x62,
        0x49,
    ],
    "AMITSE_AFTER_FIRST_BOOT_OPTION_GUID": [
        0xC48D651C,
        0x9D0E,
        0x4CE7,
        0xAD,
        0x39,
        0xED,
        0xD1,
        0xAB,
        0x83,
        0x6B,
        0x30,
    ],
    "AMITSE_BOOT_ORDER_CHANGE_GUID": [
        0x1B6BC809,
        0xC986,
        0x4937,
        0x93,
        0x4F,
        0x1E,
        0xA5,
        0x86,
        0x22,
        0xFE,
        0x50,
    ],
    "AMITSE_DRIVER_HEALTH_CTRL_GUID": [
        0x58279C2D,
        0xFB19,
        0x466E,
        0xB4,
        0x2E,
        0xCD,
        0x43,
        0x70,
        0x16,
        0xDC,
        0x25,
    ],
    "AMITSE_DRIVER_HEALTH_ENB_GUID": [
        0x885F288,
        0x418C,
        0x4BE1,
        0xA6,
        0xAF,
        0x8B,
        0xAD,
        0x61,
        0xDA,
        0x8,
        0xFE,
    ],
    "AMITSE_DRIVER_HEALTH_GUID": [
        0x7459A7D4,
        0x6533,
        0x4480,
        0xBB,
        0xA7,
        0x79,
        0xE2,
        0x5A,
        0x44,
        0x43,
        0xC9,
    ],
    "AMITSE_EVENT_BEFORE_BOOT_GUID": [
        0x3677770F,
        0xEFB2,
        0x43B2,
        0xB8,
        0xAE,
        0xB3,
        0x2,
        0xE9,
        0x60,
        0x48,
        0x82,
    ],
    "AMITSE_INVALID_PASSWORD_GUID": [
        0xD69240C0,
        0xDD40,
        0x4F2D,
        0x98,
        0x63,
        0x48,
        0x48,
        0xDA,
        0x6E,
        0x61,
        0x5F,
    ],
    "AMITSE_NVRAM_UPDATE_GUID": [
        0xD84BEFF0,
        0x159A,
        0x4B60,
        0x9A,
        0xB9,
        0xAC,
        0x5C,
        0x47,
        0x4B,
        0xD3,
        0xB1,
    ],
    "AMITSE_PASSWORD_PROMPT_ENTER_GUID": [
        0x73E7E01,
        0x2611,
        0x4E85,
        0xB8,
        0x96,
        0xA3,
        0xB6,
        0x76,
        0x7C,
        0xBA,
        0x0,
    ],
    "AMITSE_PASSWORD_PROMPT_EXIT_GUID": [
        0xB9B038B0,
        0xE2B6,
        0x4AAB,
        0x94,
        0x35,
        0x41,
        0x65,
        0xEC,
        0xFE,
        0xD0,
        0x32,
    ],
    "AMITSE_SETUP_ENTER_GUID": [
        0x71202EEE,
        0x5F53,
        0x40D9,
        0xAB,
        0x3D,
        0x9E,
        0x0C,
        0x26,
        0xD9,
        0x66,
        0x57,
    ],
    "AMITSE_USER_PASSWORD_VALID_GUID": [
        0xAB1404CA,
        0x4801,
        0x4208,
        0x98,
        0xBF,
        0x30,
        0xD5,
        0x21,
        0xDA,
        0xD4,
        0xD3,
    ],
    "AMI_APTIO_SIG_OWNER_GUID": [
        0x26DC4851,
        0x195F,
        0x4AE1,
        0x9A,
        0x19,
        0xFB,
        0xF8,
        0x83,
        0xBB,
        0xB3,
        0x5E,
    ],
    "AMI_BBS_DEVICE_PATH_GUID": [
        0x1DB184AE,
        0x81F5,
        0x4E72,
        0x85,
        0x44,
        0x2B,
        0xAB,
        0xC,
        0x2C,
        0xAC,
        0x5C,
    ],
    "AMI_BEFORE_CPU_RC_PROTOCOL_GUID": [
        0x1D26ADC3,
        0xB011,
        0xEE2C,
        0x21,
        0x77,
        0x89,
        0xBB,
        0xAA,
        0xCC,
        0x33,
        0x92,
    ],
    "AMI_BIOSPPI_FLAGS_MANAGEMENT_GUID": [
        0xE9008D70,
        0x2A4E,
        0x47EA,
        0x8E,
        0xC4,
        0x72,
        0xE2,
        0x57,
        0x67,
        0xE5,
        0xEF,
    ],
    "AMI_BOARD_INFO_PROTOCOL_GUID": [
        0x0273146C,
        0x96C4,
        0x45A1,
        0xA7,
        0xAF,
        0x78,
        0xE0,
        0x52,
        0x4A,
        0x0A,
        0xE2,
    ],
    "AMI_BOARD_INFO_SECTION_GUID": [
        0xE6F4F8F7,
        0x4992,
        0x47B2,
        0x83,
        0x02,
        0x85,
        0x08,
        0x74,
        0x5E,
        0x4A,
        0x23,
    ],
    "AMI_CALLBACK_GUID": [
        0x9CF0F18E,
        0x7C7D,
        0x49DE,
        0xB5,
        0xAA,
        0xBB,
        0xBA,
        0xD6,
        0xB2,
        0x10,
        0x07,
    ],
    "AMI_CAPSULE_HOB_GUID": [
        0xBF66FDF7,
        0xF64C,
        0x4B11,
        0x8A,
        0xB7,
        0xF8,
        0x43,
        0xAA,
        0x2A,
        0x8B,
        0xEA,
    ],
    "AMI_CCID_IO_PROTOCOL_GUID": [
        0xB167C2F5,
        0xE26A,
        0x4DFF,
        0x8E,
        0x1C,
        0x08,
        0x07,
        0xC7,
        0xF0,
        0x2A,
        0x88,
    ],
    "AMI_CCID_PRESENCE_GUID": [
        0x5FDEE00D,
        0xDA40,
        0x405A,
        0xB9,
        0x2E,
        0xCF,
        0x4A,
        0x80,
        0xEA,
        0x8F,
        0x76,
    ],
    "AMI_CMOS_BAD_FLAG_HOB_GUID": [
        0xB098F766,
        0xB17A,
        0x4005,
        0x83,
        0x9,
        0xEB,
        0x23,
        0xF1,
        0x44,
        0x8C,
        0x15,
    ],
    "AMI_CPUID_CKSUM_HOB_GUID": [
        0xD4CA32B1,
        0xB1F2,
        0x4FF3,
        0xB4,
        0x75,
        0x66,
        0xE7,
        0xB8,
        0x19,
        0x2A,
        0x3B,
    ],
    "AMI_CPU_INFO_2_PROTOCOL_GUID": [
        0xAC9CF0A8,
        0xE551,
        0x4BE2,
        0xAD,
        0xA,
        0xE1,
        0xB5,
        0x64,
        0xEE,
        0xA2,
        0x73,
    ],
    "AMI_CSM_DRIVER_STARTED_GUID": [
        0x3EA824D1,
        0x81E3,
        0x4FF5,
        0xBD,
        0x43,
        0xBB,
        0x9C,
        0x65,
        0xDF,
        0x7C,
        0x46,
    ],
    "AMI_CSM_THUNK_PROTOCOL_GUID": [
        0x2362EA9C,
        0x84E5,
        0x4DFF,
        0x83,
        0xBC,
        0xB5,
        0xAC,
        0xEC,
        0xB5,
        0x7C,
        0xBB,
    ],
    "AMI_DDDT_PRESENT_FLAG_HOB_GUID": [
        0x4E7AF417,
        0xC200,
        0x400A,
        0x9D,
        0x18,
        0x86,
        0x5A,
        0xDA,
        0xD3,
        0x8,
        0x96,
    ],
    "AMI_DEBUGGER_CPU_PROTOCOL_GUID": [
        0xAB21ACC3,
        0xBA33,
        0xEE2C,
        0x66,
        0xBC,
        0x12,
        0x56,
        0x77,
        0x11,
        0x1A,
        0xB2,
    ],
    "AMI_DEBUGPORT_HOB_GUID": [
        0xE894B313,
        0x54CA,
        0x4BB2,
        0x8C,
        0xDD,
        0x85,
        0x1E,
        0x8A,
        0xC9,
        0x2,
        0x7C,
    ],
    "AMI_DEVICE_NAME_DEVICE_PATH_GUID": [
        0x2D6447EF,
        0x3BC9,
        0x41A0,
        0xAC,
        0x19,
        0x4D,
        0x51,
        0xD0,
        0x1B,
        0x4C,
        0xE6,
    ],
    "AMI_DIGITAL_SIGNATURE_PROTOCOL_GUID": [
        0x5F87BA17,
        0x957D,
        0x433D,
        0x9E,
        0x15,
        0xC0,
        0xE7,
        0xC8,
        0x79,
        0x88,
        0x99,
    ],
    "AMI_DIMM_SPD_DATA_HOB_GUID": [
        0xD4CA32B3,
        0xB1FE,
        0x4FF7,
        0xB0,
        0x73,
        0x60,
        0xED,
        0xBB,
        0x16,
        0x22,
        0x33,
    ],
    "AMI_EARLY_BIST_PPI_GUID": [
        0xA7E2CE72,
        0xDC32,
        0x4BC0,
        0x9E,
        0x35,
        0xFE,
        0xB3,
        0xA,
        0xE5,
        0xCC,
        0x47,
    ],
    "AMI_EFIKEYCODE_PROTOCOL_GUID": [
        0x0ADFB62D,
        0xFF74,
        0x484C,
        0x89,
        0x44,
        0xF8,
        0x5C,
        0x4B,
        0xEA,
        0x87,
        0xA8,
    ],
    "AMI_FAST_BOOT_PROTOCOL_GUID": [
        0x3496A19A,
        0x2E99,
        0x41BA,
        0x83,
        0x3E,
        0xF,
        0xDE,
        0x2E,
        0xBF,
        0x2A,
        0x55,
    ],
    "AMI_FW_RECOVERY_CAPSULE_GUID": [
        0x5E794317,
        0xA07E,
        0x45DF,
        0x94,
        0xBB,
        0x1C,
        0x99,
        0x7D,
        0x62,
        0x32,
        0xCA,
    ],
    "AMI_HECI_SMM_GUID": [
        0xFC9A50C1,
        0x8B3D,
        0x40D0,
        0x99,
        0x12,
        0x6E,
        0x26,
        0xD7,
        0x89,
        0x6C,
        0xBA,
    ],
    "AMI_INTERNAL_FACTORY_TDC_TDP_HOB_GUID": [
        0x982D8C6F,
        0xF6F6,
        0x4135,
        0xA3,
        0x9,
        0xA4,
        0x59,
        0x3E,
        0xA5,
        0x64,
        0x17,
    ],
    "AMI_INTERNAL_UCODE_HOB_GUID": [
        0x94567C6F,
        0xF7A9,
        0x4229,
        0x13,
        0x30,
        0xFE,
        0x11,
        0xCC,
        0xAB,
        0x3A,
        0x11,
    ],
    "AMI_INT_SMM_COMM_PROTOCOL_GUID": [
        0xB27DAB38,
        0x9814,
        0x4E06,
        0xA5,
        0xA2,
        0x65,
        0xAE,
        0x9A,
        0x14,
        0x25,
        0x8F,
    ],
    "AMI_IRQ_DMA_MASK_VARIABLE_GUID": [
        0xFC8BE767,
        0x89F1,
        0x4D6E,
        0x80,
        0x99,
        0x6F,
        0x2,
        0x1E,
        0xBC,
        0x87,
        0xCC,
    ],
    "AMI_ISO9660_MEDIA_GUID": [
        0xBA7C46D1,
        0x9C5E,
        0x4FC8,
        0x94,
        0x3D,
        0x1A,
        0x49,
        0x1F,
        0x23,
        0xFE,
        0x1,
    ],
    "AMI_LOAD_CSM_GUID": [
        0x16287BA4,
        0x5B9D,
        0x4D98,
        0x91,
        0x9F,
        0x7B,
        0x7B,
        0x78,
        0xCB,
        0x2B,
        0xE0,
    ],
    "AMI_MASKED_DEVICE_PATH_GUID": [
        0x99E275E7,
        0x75A0,
        0x4B37,
        0xA2,
        0xE6,
        0xC5,
        0x38,
        0x5E,
        0x6C,
        0x0,
        0xCB,
    ],
    "AMI_MEASURE_PCIOPROM_GUID": [
        0xB3DAE700,
        0x2A77,
        0x4EA4,
        0xAF,
        0x79,
        0x32,
        0x97,
        0xB4,
        0x84,
        0xBE,
        0x61,
    ],
    "AMI_MEDIA_DEVICE_PATH_GUID": [
        0x5023B95C,
        0xDB26,
        0x429B,
        0xA6,
        0x48,
        0xBD,
        0x47,
        0x66,
        0x4C,
        0x80,
        0x12,
    ],
    "AMI_MEMORY_ERROR_REPORT_PPI_GUID": [
        0x85226559,
        0x0DEF,
        0x48D8,
        0xA8,
        0xC9,
        0xB7,
        0x46,
        0xD6,
        0xA4,
        0xDF,
        0x01,
    ],
    "AMI_MRC_INFO_HOB_GUID": [
        0xA6351A87,
        0x2965,
        0x4718,
        0x88,
        0xC7,
        0x0B,
        0x5B,
        0x5A,
        0xC0,
        0xB5,
        0xE4,
    ],
    "AMI_NB_MRC_INFO_GUID": [
        0x6737934B,
        0xA27E,
        0x4C05,
        0xAD,
        0x5B,
        0x6A,
        0xB8,
        0x62,
        0x73,
        0x68,
        0x0B,
    ],
    "AMI_NVRAM_SPD_MAP_GUID": [
        0x717FC150,
        0xABD9,
        0x4614,
        0x80,
        0x15,
        0xB,
        0x33,
        0x23,
        0xEA,
        0xB9,
        0x5C,
    ],
    "AMI_OPROM_POLICY_PROTOCOL_GUID": [
        0x542D6248,
        0x4198,
        0x4960,
        0x9F,
        0x59,
        0x23,
        0x84,
        0x64,
        0x6D,
        0x63,
        0xB4,
    ],
    "AMI_OS_PPI_CONFIRMATION_OVERRIDE_GUID": [
        0x5F171F5F,
        0x8385,
        0x4086,
        0xA6,
        0x9B,
        0x1F,
        0xCF,
        0x6,
        0xAE,
        0x4A,
        0x3D,
    ],
    "AMI_PB_KEY_RSA2048_GUID": [
        0x04627B9B,
        0x385E,
        0x4744,
        0x90,
        0x21,
        0xE6,
        0x63,
        0x19,
        0xF2,
        0x03,
        0x94,
    ],
    "AMI_PCI_BUS_EXT_PROTOCOL_GUID": [
        0xF42A009D,
        0x977F,
        0x4F08,
        0x94,
        0x40,
        0xBC,
        0xA5,
        0xA3,
        0xBE,
        0xD9,
        0xAF,
    ],
    "AMI_PEIM_HOB_GUID": [
        0xF4491BA4,
        0x7672,
        0x486F,
        0xB4,
        0xD7,
        0x99,
        0x89,
        0x9D,
        0x22,
        0xDA,
        0x57,
    ],
    "AMI_PEIM_LOAD_HOB_GUID": [
        0xEC9C36FD,
        0x1642,
        0x4B84,
        0x91,
        0xFA,
        0x91,
        0x9C,
        0x2D,
        0x6,
        0x6F,
        0xB4,
    ],
    "AMI_PEI_AFTER_MRC_GUID": [
        0x64C96700,
        0x6B4C,
        0x480C,
        0xA3,
        0xE1,
        0xB8,
        0xBD,
        0xE8,
        0xF6,
        0x2,
        0xB2,
    ],
    "AMI_PEI_CPUINIT_POLICY_PPI_GUID": [
        0xF824CCBB,
        0xD8E0,
        0x4522,
        0x8A,
        0xA8,
        0x65,
        0xF0,
        0x4B,
        0x46,
        0x3D,
        0xB5,
    ],
    "AMI_PEI_END_MEMORY_DETECT_GUID": [
        0x9F58E424,
        0xB96B,
        0x45A5,
        0xAD,
        0xDC,
        0xD2,
        0xFE,
        0x39,
        0x4A,
        0x99,
        0xD9,
    ],
    "AMI_PEI_END_OF_MRC_GUID": [
        0x633194BE,
        0x1697,
        0x11E1,
        0xB5,
        0xF0,
        0x2C,
        0xB2,
        0x48,
        0x24,
        0x01,
        0x9B,
    ],
    "AMI_PEI_MRC_DEFAULT_GUID": [
        0xE813E116,
        0xC099,
        0x4D21,
        0x9C,
        0x34,
        0xA5,
        0x52,
        0xD5,
        0xE9,
        0xA5,
        0xD0,
    ],
    "AMI_PEI_NBINIT_POLICY_PPI_GUID": [
        0x9CE4D938,
        0x9C87,
        0x41D0,
        0x9E,
        0x55,
        0x34,
        0x92,
        0x3F,
        0xAF,
        0x8B,
        0x4F,
    ],
    "AMI_PEI_NB_CPU_ONLY_RESET_PPI_GUID": [
        0x1F0F049E,
        0x3A68,
        0x4C97,
        0x86,
        0x5A,
        0xBC,
        0x5E,
        0xED,
        0x79,
        0x20,
        0xE7,
    ],
    "AMI_PEI_NB_CUSTOM_PPI_GUID": [
        0x584CC99F,
        0x4BE8,
        0x43D1,
        0xA4,
        0x5A,
        0x93,
        0x3D,
        0xC3,
        0x94,
        0x79,
        0xFC,
    ],
    "AMI_PEI_PCI_TABLE_INIT_PPI_GUID": [
        0x97F91E78,
        0xEA12,
        0x4EA6,
        0xB7,
        0xB3,
        0x7B,
        0x6,
        0x78,
        0xC2,
        0x86,
        0x73,
    ],
    "AMI_PEI_SBINIT_POLICY_PPI_GUID": [
        0x95E8152B,
        0x1B98,
        0x4F11,
        0x8A,
        0x77,
        0xDB,
        0x26,
        0x58,
        0x3E,
        0xBC,
        0x42,
    ],
    "AMI_PEI_SB_CUSTOM_PPI_GUID": [
        0x38965BB5,
        0x8097,
        0x40F5,
        0xB7,
        0x42,
        0x8C,
        0xC1,
        0x4A,
        0x64,
        0x9B,
        0x64,
    ],
    "AMI_PEI_SB_OEM_PLATFORM_POLICY_OVERRIDE_PPI_GUID": [
        0x61187967,
        0x9A77,
        0x419D,
        0xAA,
        0xEA,
        0x64,
        0xDD,
        0x56,
        0x19,
        0x08,
        0x15,
    ],
    "AMI_PEI_SET_NB_SUBID_PPI_GUID": [
        0x584CC99F,
        0x4BE8,
        0x43D1,
        0xA4,
        0x5A,
        0x93,
        0x3D,
        0xC3,
        0x94,
        0x79,
        0xFC,
    ],
    "AMI_PERF_TUNE_DATA_HOB_GUID": [
        0x4D6C0496,
        0x8DE4,
        0x4AF2,
        0x9A,
        0x2E,
        0x9B,
        0xE5,
        0xB9,
        0x15,
        0x6A,
        0xC5,
    ],
    "AMI_PLL_OVER_VOTAGE_FLAG_HOB_GUID": [
        0x181E874D,
        0xC089,
        0x4C99,
        0x8E,
        0xC2,
        0x6D,
        0x67,
        0x61,
        0x34,
        0x82,
        0x20,
    ],
    "AMI_POST_MANAGER_PROTOCOL_GUID": [
        0x8A91B1E1,
        0x56C7,
        0x4ADC,
        0xAB,
        0xEB,
        0x1C,
        0x2C,
        0xA1,
        0x72,
        0x9E,
        0xFF,
    ],
    "AMI_RECOVERY_IMAGE_HOB_GUID": [
        0xDAC3CB98,
        0x2295,
        0x412E,
        0x82,
        0x6D,
        0xFD,
        0xEE,
        0xA3,
        0x20,
        0xCF,
        0x31,
    ],
    "AMI_RESET_TYPE_HOB_GUID": [
        0x39E8CDA1,
        0x6A35,
        0x4CDD,
        0xA9,
        0x2,
        0xD1,
        0xA7,
        0x95,
        0xF7,
        0x3,
        0x80,
    ],
    "AMI_RESET_TYPE_VARIABLE_GUID": [
        0x308DD02C,
        0x092B,
        0x4123,
        0xA2,
        0xAF,
        0x3E,
        0xF4,
        0x44,
        0x0A,
        0x6B,
        0x4A,
    ],
    "AMI_ROM_LAYOUT_HOB_GUID": [
        0xD7642443,
        0x87B7,
        0x4832,
        0x96,
        0x7,
        0xE,
        0x1E,
        0xA8,
        0x1C,
        0x1D,
        0x86,
    ],
    "AMI_SB_SMI_PROTOCOL_GUID": [
        0x589BC616,
        0xBB4F,
        0x47ED,
        0x92,
        0xF7,
        0x93,
        0x39,
        0x3C,
        0x69,
        0x7E,
        0x25,
    ],
    "AMI_SETUP_NVRAM_UPDATE_GUID": [
        0xD84BEFF0,
        0x159A,
        0x4B60,
        0x9A,
        0xB9,
        0xAC,
        0x5C,
        0x47,
        0x4B,
        0xD3,
        0xB1,
    ],
    "AMI_SMBIOS_CPU_INFO_PROTOCOL_GUID": [
        0x3D6CDB0A,
        0x5B1F,
        0x43A3,
        0xA4,
        0x3B,
        0x44,
        0x12,
        0x67,
        0xF9,
        0xDA,
        0xB5,
    ],
    "AMI_SMBIOS_MEMORY_INFO_HOB_GUID": [
        0x7D6B8734,
        0xB754,
        0x443F,
        0xB5,
        0x88,
        0x77,
        0x43,
        0x84,
        0x3A,
        0xD3,
        0xF1,
    ],
    "AMI_SMBUS_HOB_GUID": [
        0x17CB4B7,
        0xB80C,
        0x4040,
        0xB6,
        0xC8,
        0xEA,
        0x98,
        0x2B,
        0xBB,
        0x25,
        0xB7,
    ],
    "AMI_SMBUS_SMM_PROTOCOL_GUID": [
        0x72E40094,
        0x2EE1,
        0x497A,
        0x8F,
        0x33,
        0x4C,
        0x93,
        0x4A,
        0x9E,
        0x9C,
        0xC,
    ],
    "AMI_SMM_DIGITAL_SIGNATURE_PROTOCOL_GUID": [
        0x91ABC830,
        0x16FC,
        0x4D9E,
        0xA1,
        0x89,
        0x5F,
        0xC8,
        0xBB,
        0x41,
        0x14,
        0x02,
    ],
    "AMI_SMM_INFO_PROTOCOL_GUID": [
        0xEB5198EB,
        0xE7F5,
        0x45A1,
        0x9C,
        0xCB,
        0xE5,
        0x33,
        0x64,
        0xBB,
        0x49,
        0x92,
    ],
    "AMI_STANDARD_DEFAULTS_VARIABLE_GUID": [
        0x4599D26F,
        0x1A11,
        0x49B8,
        0xB9,
        0x1F,
        0x85,
        0x87,
        0x45,
        0xCF,
        0xF8,
        0x24,
    ],
    "AMI_STATUS_CODE_CPU_BIST_DATA_GUID": [
        0xCD541D77,
        0x6699,
        0x4B36,
        0xA3,
        0x1E,
        0x1A,
        0xA4,
        0xC5,
        0xD5,
        0xB9,
        0x46,
    ],
    "AMI_TCG_CONFIRMATION_FLAGS_GUID": [
        0x7D3DCEEE,
        0xCBCE,
        0x4EA7,
        0x87,
        0x09,
        0x6E,
        0x55,
        0x2F,
        0x1E,
        0xDB,
        0xDE,
    ],
    "AMI_TCG_EFI_OS_VARIABLE_GUID": [
        0xA8A2093B,
        0xFEFA,
        0x43C1,
        0x8E,
        0x62,
        0xCE,
        0x52,
        0x68,
        0x47,
        0x26,
        0x5E,
    ],
    "AMI_TCG_PERM_FLAGS_GUID": [
        0x2325F2FC,
        0x5683,
        0x4648,
        0x97,
        0xC4,
        0x9A,
        0x52,
        0x0D,
        0xFB,
        0xE3,
        0x25,
    ],
    "AMI_TCG_PLATFORM_PPI_AFTER_MEM_GUID": [
        0x890C2CEF,
        0x43C8,
        0x4209,
        0xA7,
        0x8D,
        0xAE,
        0x14,
        0xAA,
        0x17,
        0x98,
        0xB4,
    ],
    "AMI_TCG_PLATFORM_PPI_BEFORE_MEM_GUID": [
        0xC1E6791D,
        0xF35B,
        0x43EF,
        0x92,
        0xA,
        0xBE,
        0x6,
        0xBA,
        0x7F,
        0x86,
        0xA1,
    ],
    "AMI_TCG_PLATFORM_PPI_GUID": [
        0x5687F4A,
        0x3CA7,
        0x4D19,
        0x9B,
        0xC5,
        0xE1,
        0x80,
        0xCE,
        0xA3,
        0x56,
        0x9F,
    ],
    "AMI_TCG_PLATFORM_PROTOCOL_GUID": [
        0x320BDC39,
        0x3FA0,
        0x4BA9,
        0xBF,
        0x2D,
        0xB3,
        0x3F,
        0x72,
        0xBA,
        0x9C,
        0xA1,
    ],
    "AMI_TCG_RESETVAR_HOB_GUID": [
        0xA8A2093B,
        0xFEFA,
        0x43C1,
        0x8E,
        0x62,
        0xCE,
        0x52,
        0x68,
        0x47,
        0x26,
        0x5E,
    ],
    "AMI_USB_SMM_PROTOCOL_GUID": [
        0x3EF7500E,
        0xCF55,
        0x474F,
        0x8E,
        0x7E,
        0x0,
        0x9E,
        0xE,
        0xAC,
        0xEC,
        0xD2,
    ],
    "AMT_FORCE_PUSH_PET_HOB_GUID": [
        0x4EFA0DB6,
        0x26DC,
        0x4BB1,
        0xA7,
        0x6F,
        0x14,
        0xBC,
        0x63,
        0x0C,
        0x7B,
        0x3C,
    ],
    "AMT_FORCE_PUSH_PET_POLICY_GUID": [
        0xACC8E1E4,
        0x9F9F,
        0x4E40,
        0xA5,
        0x7E,
        0xF9,
        0x9E,
        0x52,
        0xF3,
        0x4C,
        0xA5,
    ],
    "AMT_FORCE_PUSH_PET_VARIABLE_GUID": [
        0xD7AC94AF,
        0xA498,
        0x45EC,
        0xBF,
        0xA2,
        0xA5,
        0x6E,
        0x95,
        0x34,
        0x61,
        0x8B,
    ],
    "AMT_INT16_CSM_GUID": [
        0x6046E678,
        0x24EF,
        0x4005,
        0xBA,
        0x39,
        0xBD,
        0xA1,
        0x1F,
        0x6D,
        0x55,
        0x5D,
    ],
    "AMT_READY_TO_BOOT_PROTOCOL_GUID": [
        0x40B09B5A,
        0xF0EF,
        0x4627,
        0x93,
        0xD5,
        0x27,
        0xF0,
        0x4B,
        0x75,
        0x4D,
        0x5,
    ],
    "AOAC_EC_WAKEUP_CUSTOM_PPI_GUID": [
        0x82627ACF,
        0xD92D,
        0x416D,
        0x8A,
        0x6F,
        0x78,
        0x3C,
        0xAC,
        0xD9,
        0x12,
        0x23,
    ],
    "AOAC_FFS_TABLE_STORAGE_GUID": [
        0xFB045DB2,
        0x598E,
        0x485A,
        0xBA,
        0x30,
        0x5D,
        0x7B,
        0x1B,
        0x1B,
        0xD5,
        0x4D,
    ],
    "APTIO_FW_CAPSULE_GUID": [
        0x4A3CA68B,
        0x7723,
        0x48FB,
        0x80,
        0x3D,
        0x57,
        0x8C,
        0xC1,
        0xFE,
        0xC4,
        0x4D,
    ],
    "APTIO_HII_PROTOCOL_GUID": [
        0xEA816D2C,
        0xCEE5,
        0x4F02,
        0x99,
        0xB5,
        0xD3,
        0x90,
        0x5C,
        0xBB,
        0xD0,
        0x77,
    ],
    "AUTHVAR_MAILBOX_VARIABLE_GUID": [
        0x532B6532,
        0x6499,
        0x428D,
        0xAC,
        0xB1,
        0xF6,
        0xF7,
        0x79,
        0xC9,
        0x4D,
        0xF9,
    ],
    "BDS_ALL_DRIVERS_CONNECTED_PROTOCOL_GUID": [
        0xDBC9FD21,
        0xFAD8,
        0x45B0,
        0x9E,
        0x78,
        0x27,
        0x15,
        0x88,
        0x67,
        0xCC,
        0x93,
    ],
    "BDS_CONNECT_DRIVERS_PROTOCOL_GUID": [
        0x3AA83745,
        0x9454,
        0x4F7A,
        0xA7,
        0xC0,
        0x90,
        0xDB,
        0xD0,
        0x2F,
        0xAB,
        0x8E,
    ],
    "BLOCK_DEVICE_RECOVERY_CAPSULE_GUID": [
        0xBA8263C,
        0xA8BD,
        0x4AAD,
        0xB4,
        0x2,
        0x6A,
        0x6A,
        0xF2,
        0xF7,
        0xE7,
        0x7D,
    ],
    "BOOT_FLOW_VARIABLE_GUID": [
        0xEF152FB4,
        0x7B2F,
        0x427D,
        0xBD,
        0xB4,
        0x7E,
        0x0A,
        0x05,
        0x82,
        0x6E,
        0x64,
    ],
    "BOOT_FORM_SET_GUID": [
        0x8B33FFE0,
        0xD71C,
        0x4F82,
        0x9C,
        0xEB,
        0xC9,
        0x70,
        0x58,
        0xC1,
        0x3F,
        0x8E,
    ],
    "BOOT_MANAGER_GUID": [
        0xB4909CF3,
        0x7B93,
        0x4751,
        0x9B,
        0xD8,
        0x5B,
        0xA8,
        0x22,
        0x0B,
        0x9B,
        0xB2,
    ],
    "BOOT_NOW_COUNT_GUID": [
        0x052E6EB0,
        0xF240,
        0x42C5,
        0x83,
        0x09,
        0x45,
        0x87,
        0x45,
        0x45,
        0xC6,
        0xB4,
    ],
    "CHIPSET_FORM_SET_GUID": [
        0xADFE34C8,
        0x9AE1,
        0x4F8F,
        0xBE,
        0x13,
        0xCF,
        0x96,
        0xA2,
        0xCB,
        0x2C,
        0x5B,
    ],
    "CMOS_MANAGER_HOB_GUID": [
        0xD5367802,
        0xB873,
        0x4C0F,
        0xB5,
        0x44,
        0x31,
        0xB7,
        0xCC,
        0xF5,
        0xC5,
        0x55,
    ],
    "CONSOLE_IN_DEVICES_STARTED_PROTOCOL_GUID": [
        0x2DF1E051,
        0x906D,
        0x4EFF,
        0x86,
        0x9D,
        0x24,
        0xE6,
        0x53,
        0x78,
        0xFB,
        0x9E,
    ],
    "CONSOLE_OUT_DEVICES_STARTED_PROTOCOL_GUID": [
        0xEF9A3971,
        0xC1A0,
        0x4A93,
        0xBD,
        0x40,
        0x5A,
        0xA1,
        0x65,
        0xF2,
        0xDC,
        0x3A,
    ],
    "CPU_MICROCODE_FILE_GUID": [
        0x17088572,
        0x377F,
        0x44EF,
        0x8F,
        0x4E,
        0xB0,
        0x9F,
        0xFF,
        0x46,
        0xA0,
        0x70,
    ],
    "CPU_WAKE_UP_BUFFER_VARIABLE_GUID": [
        0xDF665292,
        0x79D7,
        0x40E2,
        0xBA,
        0x51,
        0xF7,
        0xD4,
        0x94,
        0x62,
        0x81,
        0x85,
    ],
    "CSM_VIDEO_POLICY_PROTOCOL_GUID": [
        0x3A4E4376,
        0x4871,
        0x4B0E,
        0xA0,
        0x2F,
        0xED,
        0x36,
        0xF2,
        0xAE,
        0xCD,
        0x0,
    ],
    "DCA_HOB_GUID": [
        0x6865C455,
        0x8626,
        0x40D8,
        0x90,
        0xF4,
        0xA6,
        0x94,
        0x60,
        0xA4,
        0xAB,
        0x5A,
    ],
    "DEBUGGER_TERMINAL_VAR_GUID": [
        0x97CA1A5B,
        0xB760,
        0x4D1F,
        0xA5,
        0x4B,
        0xD1,
        0x90,
        0x92,
        0x3,
        0x2C,
        0x90,
    ],
    "DEFINE_GUID_CRBDXEBin_GUID": [
        0x16271FCA,
        0x55D9,
        0x4A33,
        0x93,
        0xFC,
        0x5A,
        0x3E,
        0xB1,
        0x28,
        0xDE,
        0xB6,
    ],
    "DEFINE_GUID_CRBSMIBin_GUID": [
        0x221F1D4F,
        0x034C,
        0x4BEA,
        0xB2,
        0xBB,
        0xB7,
        0xA9,
        0x67,
        0x2B,
        0x06,
        0xD7,
    ],
    "DEFINE_GUID_AcpiPlatformPeiBin_GUID": [
        0x333BB2A3,
        0x4F20,
        0x4C8B,
        0xAC,
        0x38,
        0x6,
        0x72,
        0xD7,
        0x43,
        0x15,
        0xF8,
    ],
    "DEFINE_GUID_OEMPEIBin_GUID": [
        0x6E59DF06,
        0x62D3,
        0x40B0,
        0x82,
        0xB5,
        0x17,
        0x5C,
        0xF8,
        0x4A,
        0x94,
        0xE4,
    ],
    "DEFINE_GUID_SBDXEBin_GUID": [
        0xB7D19491,
        0xE55A,
        0x470D,
        0x85,
        0x8,
        0x85,
        0xA5,
        0xDF,
        0xA4,
        0x19,
        0x74,
    ],
    "DEFINE_GUID_OEMDXEBin_GUID": [
        0xBFE205C9,
        0x5B17,
        0x4F8F,
        0x93,
        0x75,
        0x89,
        0x61,
        0x4A,
        0xF8,
        0xE1,
        0x99,
    ],
    "DEFINE_GUID_SBPEIBin_GUID": [
        0xC1FBD624,
        0x27EA,
        0x40D1,
        0xAA,
        0x48,
        0x94,
        0xC3,
        0xDC,
        0x5C,
        0x7E,
        0xD,
    ],
    "DEFINE_GUID_CRBPEIBin_GUID": [
        0xD1ED2F7,
        0xE92B,
        0x4562,
        0x92,
        0xDD,
        0x5C,
        0x82,
        0xEC,
        0x91,
        0x7E,
        0xAE,
    ],
    "DEFINE_GUID_AcpiPlatformSmiBin_GUID": [
        0xDFD8D5CC,
        0x5AED,
        0x4820,
        0xA2,
        0xB6,
        0x5C,
        0x55,
        0xE4,
        0xE6,
        0x40,
        0xEF,
    ],
    "DEFINE_GUID_NBPEIBin_GUID": [
        0x79AA6086,
        0x035A,
        0x4AD9,
        0xA8,
        0x9A,
        0xA6,
        0xD5,
        0xAA,
        0x27,
        0xF0,
        0xE2,
    ],
    "DEFINE_GUID_NBDXEBin_GUID": [
        0xE4ECD0B2,
        0xE277,
        0x4F2B,
        0xBE,
        0xCB,
        0xE4,
        0xD7,
        0x5C,
        0x9A,
        0x81,
        0x2E,
    ],
    "DEFINE_GUID_SBRunBin_GUID": [
        0xE23F86E1,
        0x056E,
        0x4888,
        0xB6,
        0x85,
        0xCF,
        0xCD,
        0x67,
        0xC1,
        0x79,
        0xD4,
    ],
    "DEL_BOOT_OPTION_GUID": [
        0xF6C73719,
        0xF34C,
        0x479C,
        0xB3,
        0x2F,
        0x27,
        0x7F,
        0xCB,
        0xBC,
        0xFE,
        0x4F,
    ],
    "DIMM_TS_INFO_GUID": [
        0xCE673A28,
        0x800D,
        0x4B4A,
        0x83,
        0x16,
        0x26,
        0x61,
        0xF9,
        0xB3,
        0xD9,
        0xC6,
    ],
    "DXE_CPU_CACHE_PROTOCOL_GUID": [
        0x5C6FA2C9,
        0x9768,
        0x45F6,
        0x8E,
        0x64,
        0x5A,
        0xEC,
        0xCA,
        0xDA,
        0xB4,
        0x81,
    ],
    "DXE_CPU_INFO_PROTOCOL_GUID": [
        0xE223CF65,
        0xF6CE,
        0x4122,
        0xB3,
        0xAF,
        0x4B,
        0xD1,
        0x8A,
        0xFF,
        0x40,
        0xA1,
    ],
    "DXE_CPU_PLATFORM_POLICY_PROTOCOL_GUID": [
        0xBD26CDC9,
        0xA092,
        0x462A,
        0x87,
        0x7A,
        0x5A,
        0xB6,
        0xAD,
        0xCE,
        0x48,
        0x12,
    ],
    "DXE_ENHANCED_SPEEDSTEP_PROTOCOL_GUID": [
        0xE98021,
        0xF4FE,
        0x46CC,
        0xAB,
        0x2D,
        0x89,
        0x4C,
        0x37,
        0x3A,
        0xFA,
        0x1,
    ],
    "DXE_PCH_PLATFORM_POLICY_PROTOCOL_GUID": [
        0xE0A31DBE,
        0xF20E,
        0x4E2A,
        0x9F,
        0x2B,
        0x9F,
        0x2,
        0xA2,
        0x7D,
        0x3D,
        0x69,
    ],
    "DXE_PLATFORM_AMT_POLICY_GUID": [
        0xB2AB115E,
        0xC8B6,
        0x4036,
        0xBF,
        0x31,
        0xE7,
        0x4B,
        0xD8,
        0x92,
        0x6C,
        0xCE,
    ],
    "DXE_PLATFORM_ME_POLICY_GUID": [
        0xF8BFF014,
        0x18FB,
        0x4EF9,
        0xB1,
        0xC,
        0xAE,
        0x22,
        0x73,
        0x8D,
        0xBE,
        0xED,
    ],
    "DXE_PLATFORM_SA_POLICY_GUID": [
        0xCD2333D7,
        0x6A0A,
        0x4C76,
        0x83,
        0x50,
        0x24,
        0xA,
        0xDA,
        0x36,
        0xA2,
        0xC7,
    ],
    "DXE_PLATFORM_SG_POLICY_GUID": [
        0x6199DC36,
        0xE114,
        0x4E0D,
        0x80,
        0x99,
        0x99,
        0xA0,
        0xBD,
        0x80,
        0xA9,
        0x71,
    ],
    "DXE_PLATFORM_TDT_POLICY_GUID": [
        0x20DAF0FC,
        0x5548,
        0x44DC,
        0xA4,
        0x2A,
        0x60,
        0xEA,
        0xF0,
        0xA2,
        0x2E,
        0x47,
    ],
    "DXE_TXT_POLICY_PROTOCOL_GUID": [
        0x43F66FFD,
        0xB288,
        0x4139,
        0xBA,
        0xD5,
        0xB8,
        0x98,
        0x3,
        0xE7,
        0x30,
        0xA2,
    ],
    "DYNAMIC_PAGE_COUNT_GUID": [
        0xB63BF800,
        0xF267,
        0x4F55,
        0x92,
        0x17,
        0xE9,
        0x7F,
        0xB3,
        0xB6,
        0x98,
        0x46,
    ],
    "EFI_ABSOLUTE_POINTER_PROTOCOL_GUID": [
        0x8D59D32B,
        0xC655,
        0x4AE9,
        0x9B,
        0x15,
        0xF2,
        0x59,
        0x04,
        0x99,
        0x2A,
        0x43,
    ],
    "EFI_ACPI_20_TABLE_GUID": [
        0x8868E871,
        0xE4F1,
        0x11D3,
        0xBC,
        0x22,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_ACPI_20_TABLE_GUID": [
        0x8868E871,
        0xE4F1,
        0x11D3,
        0xBC,
        0x22,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_ACPI_S3_SAVE_GUID": [
        0x125F2DE1,
        0xFB85,
        0x440C,
        0xA5,
        0x4C,
        0x4D,
        0x99,
        0x35,
        0x8A,
        0x8D,
        0x38,
    ],
    "EFI_ACPI_SDT_PROTOCOL_GUID": [
        0xEB97088E,
        0xCFDF,
        0x49C6,
        0xBE,
        0x4B,
        0xD9,
        0x6,
        0xA5,
        0xB2,
        0xE,
        0x86,
    ],
    "EFI_ACPI_SUPPORT_GUID": [
        0xDBFF9D55,
        0x89B7,
        0x46DA,
        0xBD,
        0xDF,
        0x67,
        0x7D,
        0x3D,
        0xC0,
        0x24,
        0x1D,
    ],
    "EFI_ACPI_TABLE_GUID": [
        0xEB9D2D30,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_ACPI_TABLE_PROTOCOL_GUID": [
        0xFFE06BDD,
        0x6107,
        0x46A6,
        0x7B,
        0xB2,
        0x5A,
        0x9C,
        0x7E,
        0xC5,
        0x27,
        0x5C,
    ],
    "EFI_ACPI_TABLE_STORAGE_GUID": [
        0x7E374E25,
        0x8E01,
        0x4FEE,
        0x87,
        0xF2,
        0x39,
        0xC,
        0x23,
        0xC6,
        0x6,
        0xCD,
    ],
    "EFI_ACPI_VARIABLE_GUID": [
        0xAF9FFD67,
        0xEC10,
        0x488A,
        0x9D,
        0xFC,
        0x6C,
        0xBF,
        0x5E,
        0xE2,
        0x2C,
        0x2E,
    ],
    "EFI_ACTIVE_BIOS_PROTOCOL_GUID": [
        0xEBBE2D1B,
        0x1647,
        0x4BDA,
        0xAB,
        0x9A,
        0x78,
        0x63,
        0xE3,
        0x96,
        0xD4,
        0x1A,
    ],
    "EFI_ACTIVE_MANAGEMENT_PROTOCOL_GUID": [
        0x8555FD40,
        0x140B,
        0x4F3C,
        0x90,
        0x5E,
        0x3B,
        0xF3,
        0x78,
        0xA0,
        0x99,
        0xFA,
    ],
    "EFI_AHCI_INT13_INIT_PROTOCOL_GUID": [
        0x67820532,
        0x7613,
        0x4DD3,
        0x9E,
        0xD7,
        0x3D,
        0x9B,
        0xE3,
        0xA7,
        0xDA,
        0x63,
    ],
    "EFI_ALERT_STANDARD_FORMAT_PROTOCOL_GUID": [
        0xCC93A70B,
        0xEC27,
        0x49C5,
        0x8B,
        0x34,
        0x13,
        0x93,
        0x1E,
        0xFE,
        0xD6,
        0xE2,
    ],
    "EFI_ALTERNATE_FV_BLOCK_GUID": [
        0xF496922D,
        0x172F,
        0x4BBC,
        0xA1,
        0xEB,
        0xE,
        0xEB,
        0x94,
        0x9C,
        0x34,
        0x86,
    ],
    "EFI_AMI_LEGACYBOOT_PROTOCOL_GUID": [
        0x120D28AA,
        0x6630,
        0x46F0,
        0x81,
        0x57,
        0xC0,
        0xAD,
        0xC2,
        0x38,
        0x3B,
        0xF5,
    ],
    "EFI_APRIORI_GUID": [
        0xFC510EE7,
        0xFFDC,
        0x11D4,
        0xBD,
        0x41,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_ARP_PROTOCOL_GUID": [
        0xF4B427BB,
        0xBA21,
        0x4F16,
        0xBC,
        0x4E,
        0x43,
        0xE4,
        0x16,
        0xAB,
        0x61,
        0x9C,
    ],
    "EFI_ARP_SERVICE_BINDING_PROTOCOL_GUID": [
        0xF44C00EE,
        0x1F2C,
        0x4A00,
        0xAA,
        0x9,
        0x1C,
        0x9F,
        0x3E,
        0x8,
        0x0,
        0xA3,
    ],
    "EFI_AUTHENTICATION_INFO_PROTOCOL_GUID": [
        0x7671D9D0,
        0x53DB,
        0x4173,
        0xAA,
        0x69,
        0x23,
        0x27,
        0xF2,
        0x1F,
        0x0B,
        0xC7,
    ],
    "EFI_AUTHENTICATION_INFO_PROTOCOL_GUID": [
        0x7671D9D0,
        0x53DB,
        0x4173,
        0xAA,
        0x69,
        0x23,
        0x27,
        0xF2,
        0x1F,
        0xB,
        0xC7,
    ],
    "EFI_AUTHORIZATION_PROTOCOL_GUID": [
        0x995188B1,
        0x9F96,
        0x11D4,
        0x87,
        0xAE,
        0x00,
        0x06,
        0x29,
        0x2E,
        0x8A,
        0x3B,
    ],
    "EFI_BDAT_ACCESS_GUID": [
        0xB979746A,
        0x8C1F,
        0x4A2B,
        0x97,
        0xE4,
        0x78,
        0xE9,
        0x3A,
        0x71,
        0xA7,
        0xA,
    ],
    "EFI_BDS_ARCH_PROTOCOL_GUID": [
        0x665E3FF6,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_BIS_PROTOCOL_GUID": [
        0x0B64AAB0,
        0x5429,
        0x11D4,
        0x98,
        0x16,
        0x00,
        0xA0,
        0xC9,
        0x1F,
        0xAD,
        0xCF,
    ],
    "EFI_BLOCK_IO_PROTOCOL_GUID": [
        0x964E5B21,
        0x6459,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_BOOT_SCRIPT_SAVE_PROTOCOL_GUID": [
        0x470E1529,
        0xB79E,
        0x4E32,
        0xA0,
        0xFE,
        0x6A,
        0x15,
        0x6D,
        0x29,
        0xF9,
        0xB2,
    ],
    "EFI_BUS_SPECIFIC_DRIVER_OVERRIDE_PROTOCOL_GUID": [
        0x3BC1B285,
        0x8A15,
        0x4A82,
        0xAA,
        0xBF,
        0x4D,
        0x7D,
        0x13,
        0xFB,
        0x32,
        0x65,
    ],
    "EFI_CACHE_INSTALL_PPI_GUID": [
        0xBB628AE0,
        0xCD4F,
        0x49FE,
        0x8D,
        0x60,
        0x63,
        0x18,
        0x6F,
        0xD1,
        0xE0,
        0x5B,
    ],
    "EFI_CACHE_SUBCLASS_GUID": [
        0x7F0013A7,
        0xDC79,
        0x4B22,
        0x80,
        0x99,
        0x11,
        0xF7,
        0x5F,
        0xDC,
        0x82,
        0x9D,
    ],
    "EFI_CAPSULE_AMI_GUID": [
        0xFAC2EFAD,
        0x8511,
        0x4E34,
        0x9C,
        0xAE,
        0x16,
        0xA2,
        0x57,
        0xBA,
        0x94,
        0x88,
    ],
    "EFI_CAPSULE_ARCH_PROTOCOL_GUID": [
        0x5053697E,
        0x2CBC,
        0x4819,
        0x90,
        0xD9,
        0x5,
        0x80,
        0xDE,
        0xEE,
        0x57,
        0x54,
    ],
    "EFI_CAPSULE_GUID": [
        0x3B6686BD,
        0x0D76,
        0x4030,
        0xB7,
        0x0E,
        0xB5,
        0x51,
        0x9E,
        0x2F,
        0xC5,
        0xA0,
    ],
    "EFI_CAPSULE_INFO_GUID": [
        0x8B34EAC7,
        0x2690,
        0x460B,
        0x8B,
        0xA5,
        0xD5,
        0xCF,
        0x32,
        0x83,
        0x17,
        0x35,
    ],
    "EFI_CAPSULE_VENDOR_GUID": [
        0x711C703F,
        0xC285,
        0x4B10,
        0xA3,
        0xB0,
        0x36,
        0xEC,
        0xBD,
        0x3C,
        0x8B,
        0xE2,
    ],
    "EFI_CERT_RSA2048_GUID": [
        0x3C5766E8,
        0x269C,
        0x4E34,
        0xAA,
        0x14,
        0xED,
        0x77,
        0x6E,
        0x85,
        0xB3,
        0xB6,
    ],
    "EFI_CERT_RSA2048_SHA1_GUID": [
        0x67F8444F,
        0x8743,
        0x48F1,
        0xA3,
        0x28,
        0x1E,
        0xAA,
        0xB8,
        0x73,
        0x60,
        0x80,
    ],
    "EFI_CERT_RSA2048_SHA256_GUID": [
        0xE2B36190,
        0x879B,
        0x4A3D,
        0xAD,
        0x8D,
        0xF2,
        0xE7,
        0xBB,
        0xA3,
        0x27,
        0x84,
    ],
    "EFI_CERT_SHA1_GUID": [
        0x826CA512,
        0xCF10,
        0x4AC9,
        0xB1,
        0x87,
        0xBE,
        0x01,
        0x49,
        0x66,
        0x31,
        0xBD,
    ],
    "EFI_CERT_SHA256_GUID": [
        0xC1C41626,
        0x504C,
        0x4092,
        0xAC,
        0xA9,
        0x41,
        0xF9,
        0x36,
        0x93,
        0x43,
        0x28,
    ],
    "EFI_CERT_TYPE_PKCS7_GUID": [
        0x4AAFD29D,
        0x68DF,
        0x49EE,
        0x8A,
        0xA9,
        0x34,
        0x7D,
        0x37,
        0x56,
        0x65,
        0xA7,
    ],
    "EFI_CERT_TYPE_RSA2048_SHA256_GUID": [
        0xA7717414,
        0xC616,
        0x4977,
        0x94,
        0x20,
        0x84,
        0x47,
        0x12,
        0xA7,
        0x35,
        0xBF,
    ],
    "EFI_CLP_PROTOCOL_GUID": [
        0xCBBEE336,
        0x2682,
        0x4CD6,
        0x81,
        0x8B,
        0xA,
        0xD,
        0x96,
        0x7E,
        0x5A,
        0x67,
    ],
    "EFI_CMOS_DATA_HOB_INSTALLED_GUID": [
        0x5A6A93F4,
        0x2907,
        0x4A34,
        0xBD,
        0x11,
        0x6C,
        0xA8,
        0xA0,
        0x95,
        0x9E,
        0x9,
    ],
    "EFI_COMPATIBLE_MEMORY_TESTED_PROTOCOL_GUID": [
        0x64C475EF,
        0x344B,
        0x492C,
        0x93,
        0xAD,
        0xAB,
        0x9E,
        0xB4,
        0x39,
        0x50,
        0x4,
    ],
    "EFI_COMPONENT_NAME2_PROTOCOL_GUID": [
        0x6A7A5CFF,
        0xE8D9,
        0x4F70,
        0xBA,
        0xDA,
        0x75,
        0xAB,
        0x30,
        0x25,
        0xCE,
        0x14,
    ],
    "EFI_COMPONENT_NAME_PROTOCOL_GUID": [
        0x107A772C,
        0xD5E1,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_CONFIG_FILE_NAME_GUID": [
        0x98B8D59B,
        0xE8BA,
        0x48EE,
        0x98,
        0xDD,
        0xC2,
        0x95,
        0x39,
        0x2F,
        0x1E,
        0xDB,
    ],
    "EFI_CONSOLE_IN_DEVICE_GUID": [
        0xD3B36F2B,
        0xD551,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_CONSOLE_LOCK_GUID": [
        0x368CDA0D,
        0xCF31,
        0x4B9B,
        0x8C,
        0xF6,
        0xE7,
        0xD1,
        0xBF,
        0xFF,
        0x15,
        0x7E,
    ],
    "EFI_CONSOLE_OUT_DEVICE_GUID": [
        0xD3B36F2C,
        0xD551,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_CPU_ARCH_PROTOCOL_GUID": [
        0x26BACCB1,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_CPU_IO2_PROTOCOL_GUID": [
        0xB0732526,
        0x38C8,
        0x4B40,
        0x88,
        0x77,
        0x61,
        0xC7,
        0xB0,
        0x6A,
        0xAC,
        0x45,
    ],
    "EFI_CPU_IO2_PROTOCOL_GUID": [
        0xAD61F191,
        0xAE5F,
        0x4C0E,
        0xB9,
        0xFA,
        0xE8,
        0x69,
        0xD2,
        0x88,
        0xC6,
        0x4F,
    ],
    "EFI_CPU_IO_PROTOCOL_GUID": [
        0xB0732526,
        0x38C8,
        0x4B40,
        0x88,
        0x77,
        0x61,
        0xC7,
        0xB0,
        0x6A,
        0xAC,
        0x45,
    ],
    "EFI_CPU_TYPE_FRU_GUID": [
        0xF064C91F,
        0x188C,
        0x4F56,
        0xB7,
        0xFD,
        0x30,
        0xA9,
        0xB8,
        0x6A,
        0x29,
        0xF3,
    ],
    "EFI_CRC32_GUIDED_SECTION_EXTRACTION_PROTOCOL_GUID": [
        0xFC1BCDB0,
        0x7D31,
        0x49AA,
        0x93,
        0x6A,
        0xA4,
        0x60,
        0x0D,
        0x9D,
        0xD0,
        0x83,
    ],
    "EFI_CUSTOMIZED_DECOMPRESS_PROTOCOL_GUID": [
        0x9A44198E,
        0xA4A2,
        0x44E6,
        0x8A,
        0x1F,
        0x39,
        0xBE,
        0xFD,
        0xAC,
        0x89,
        0x6F,
    ],
    "EFI_DATA_HUB_PROTOCOL_GUID": [
        0xAE80D021,
        0x618E,
        0x11D4,
        0xBC,
        0xD7,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_DEBUGPORT_PROTOCOL_GUID": [
        0xEBA4E8D2,
        0x3858,
        0x41EC,
        0xA2,
        0x81,
        0x26,
        0x47,
        0xBA,
        0x96,
        0x60,
        0xD0,
    ],
    "EFI_DEBUG_ASSERT_PROTOCOL_GUID": [
        0xBE499C92,
        0x7D4B,
        0x11D4,
        0xBC,
        0xEE,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_DEBUG_IMAGE_INFO_TABLE_GUID": [
        0x49152E77,
        0x1ADA,
        0x4764,
        0xB7,
        0xA2,
        0x7A,
        0xFE,
        0xFE,
        0xD9,
        0x5E,
        0x8B,
    ],
    "EFI_DEBUG_MASK_PPI_GUID": [
        0x3BD930FD,
        0xF823,
        0x4948,
        0x86,
        0x91,
        0x98,
        0xE6,
        0xFE,
        0x36,
        0xAC,
        0xE2,
    ],
    "EFI_DEBUG_MASK_PROTOCOL_GUID": [
        0x4C8A2451,
        0xC207,
        0x405B,
        0x96,
        0x94,
        0x99,
        0xEA,
        0x13,
        0x25,
        0x13,
        0x41,
    ],
    "EFI_DEBUG_SUPPORT_PROTOCOL_GUID": [
        0x2755590C,
        0x6F3C,
        0x42FA,
        0x9E,
        0xA4,
        0xA3,
        0xBA,
        0x54,
        0x3C,
        0xDA,
        0x25,
    ],
    "EFI_DECOMPRESS_PROTOCOL_GUID": [
        0xD8117CFE,
        0x94A6,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_DEFERRED_IMAGE_LOAD_PROTOCOL_GUID": [
        0x15853D7C,
        0x3DDF,
        0x43E0,
        0xA1,
        0xCB,
        0xEB,
        0xF8,
        0x5B,
        0x8F,
        0x87,
        0x2C,
    ],
    "EFI_DEVICE_IO_PROTOCOL_GUID": [
        0xAF6AC311,
        0x84C3,
        0x11D2,
        0x8E,
        0x3C,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_DEVICE_PATH_FROM_TEXT_PROTOCOL_GUID": [
        0x5C99A21,
        0xC70F,
        0x4AD2,
        0x8A,
        0x5F,
        0x35,
        0xDF,
        0x33,
        0x43,
        0xF5,
        0x1E,
    ],
    "EFI_DEVICE_PATH_PROTOCOL_GUID": [
        0x09576E91,
        0x6D3F,
        0x11D2,
        0x8E,
        0x39,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_DEVICE_PATH_PROTOCOL_GUID": [
        0x9576E91,
        0x6D3F,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_DEVICE_PATH_TO_TEXT_PROTOCOL_GUID": [
        0x8B843E20,
        0x8132,
        0x4852,
        0x90,
        0xCC,
        0x55,
        0x1A,
        0x4E,
        0x4A,
        0x7F,
        0x1C,
    ],
    "EFI_DEVICE_PATH_UTILITIES_PROTOCOL_GUID": [
        0x379BE4E,
        0xD706,
        0x437D,
        0xB0,
        0x37,
        0xED,
        0xB8,
        0x2F,
        0xB7,
        0x72,
        0xA4,
    ],
    "EFI_DHCP4_PROTOCOL_GUID": [
        0x8A219718,
        0x4EF5,
        0x4761,
        0x91,
        0xC8,
        0xC0,
        0xF0,
        0x4B,
        0xDA,
        0x9E,
        0x56,
    ],
    "EFI_DHCP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0x9D9A39D8,
        0xBD42,
        0x4A73,
        0xA4,
        0xD5,
        0x8E,
        0xE9,
        0x4B,
        0xE1,
        0x13,
        0x80,
    ],
    "EFI_DISK_INFO_AHCI_INTERFACE_GUID": [
        0x9E498932,
        0x4ABC,
        0x45AF,
        0xA3,
        0x4D,
        0x2,
        0x47,
        0x78,
        0x7B,
        0xE7,
        0xC6,
    ],
    "EFI_DISK_INFO_IDE_INTERFACE_GUID": [
        0x5E948FE3,
        0x26D3,
        0x42B5,
        0xAF,
        0x17,
        0x61,
        0x2,
        0x87,
        0x18,
        0x8D,
        0xEC,
    ],
    "EFI_DISK_INFO_PROTOCOL_GUID": [
        0xD432A67F,
        0x14DC,
        0x484B,
        0xB3,
        0xBB,
        0x3F,
        0x2,
        0x91,
        0x84,
        0x93,
        0x27,
    ],
    "EFI_DISK_INFO_SCSI_INTERFACE_GUID": [
        0x8F74BAA,
        0xEA36,
        0x41D9,
        0x95,
        0x21,
        0x21,
        0xA7,
        0xF,
        0x87,
        0x80,
        0xBC,
    ],
    "EFI_DISK_INFO_USB_INTERFACE_GUID": [
        0xCB871572,
        0xC11A,
        0x47B5,
        0xB4,
        0x92,
        0x67,
        0x5E,
        0xAF,
        0xA7,
        0x77,
        0x27,
    ],
    "EFI_DISK_IO_PROTOCOL_GUID": [
        0xCE345171,
        0xBA0B,
        0x11D2,
        0x8E,
        0x4F,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_DISK_IO_PROTOCOL_GUID": [
        0xCE345171,
        0xBA0B,
        0x11D2,
        0x8E,
        0x4F,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_DMI_FORMAT_FRU_GUID": [
        0x67EF7A73,
        0x2594,
        0x4A5E,
        0x93,
        0xA,
        0xE1,
        0x66,
        0xFA,
        0xBC,
        0xD2,
        0xC8,
    ],
    "EFI_DRIVER_BINDING_PROTOCOL_GUID": [
        0x18A031AB,
        0xB443,
        0x4D1A,
        0xA5,
        0xC0,
        0xC,
        0x9,
        0x26,
        0x1E,
        0x9F,
        0x71,
    ],
    "EFI_DRIVER_CONFIGURATION2_PROTOCOL_GUID": [
        0xBFD7DC1D,
        0x24F1,
        0x40D9,
        0x82,
        0xE7,
        0x2E,
        0x09,
        0xBB,
        0x6B,
        0x4E,
        0xBE,
    ],
    "EFI_DRIVER_CONFIGURATION_PROTOCOL_GUID": [
        0x107A772B,
        0xD5E1,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_DRIVER_DIAGNOSTICS2_PROTOCOL_GUID": [
        0x4D330321,
        0x025F,
        0x4AAC,
        0x90,
        0xD8,
        0x5E,
        0xD9,
        0x0,
        0x17,
        0x3B,
        0x63,
    ],
    "EFI_DRIVER_DIAGNOSTICS_PROTOCOL_GUID": [
        0x0784924F,
        0xE296,
        0x11D4,
        0x9A,
        0x49,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_DRIVER_DIAGNOSTICS_PROTOCOL_GUID": [
        0x4D330321,
        0x025F,
        0x4AAC,
        0x90,
        0xD8,
        0x5E,
        0xD9,
        0x00,
        0x17,
        0x3B,
        0x63,
    ],
    "EFI_DRIVER_FAMILY_OVERRIDE_PROTOCOL_GUID": [
        0xB1EE129E,
        0xDA36,
        0x4181,
        0x91,
        0xF8,
        0x4,
        0xA4,
        0x92,
        0x37,
        0x66,
        0xA7,
    ],
    "EFI_DRIVER_HEALTH_PROTOCOL_GUID": [
        0x2A534210,
        0x9280,
        0x41D8,
        0xAE,
        0x79,
        0xCA,
        0xDA,
        0x1,
        0xA2,
        0xB1,
        0x27,
    ],
    "EFI_DRIVER_SUPPORTED_EFI_VERSION_PROTOCOL_GUID": [
        0x5C198761,
        0x16A8,
        0x4E69,
        0x97,
        0x2C,
        0x89,
        0xD6,
        0x79,
        0x54,
        0xF8,
        0x1D,
    ],
    "EFI_DXE_CMOS_ACCESS_GUID": [
        0x9851740C,
        0x22E0,
        0x440D,
        0x90,
        0x90,
        0xEF,
        0x2D,
        0x71,
        0xC2,
        0x51,
        0xC9,
    ],
    "EFI_DXE_IPL_PPI_GUID": [
        0xAE8CE5D,
        0xE448,
        0x4437,
        0xA8,
        0xD7,
        0xEB,
        0xF5,
        0xF1,
        0x94,
        0xF7,
        0x31,
    ],
    "EFI_DXE_SERVICES_TABLE_GUID": [
        0x5AD34BA,
        0x6F02,
        0x4214,
        0x95,
        0x2E,
        0x4D,
        0xA0,
        0x39,
        0x8E,
        0x2B,
        0xB9,
    ],
    "EFI_DXE_SMM_READY_TO_LOCK_PROTOCOL_GUID": [
        0x60FF8964,
        0xE906,
        0x41D0,
        0xAF,
        0xED,
        0xF2,
        0x41,
        0xE9,
        0x74,
        0xE0,
        0x8E,
    ],
    "EFI_EBC_INTERPRETER_PROTOCOL_GUID": [
        0x13AC6DD1,
        0x73D0,
        0x11D4,
        0xB0,
        0x6B,
        0x00,
        0xAA,
        0x00,
        0xBD,
        0x6D,
        0xE7,
    ],
    "EFI_EDID_ACTIVE_PROTOCOL_GUID": [
        0xBD8C1056,
        0x9F36,
        0x44EC,
        0x92,
        0xA8,
        0xA6,
        0x33,
        0x7F,
        0x81,
        0x79,
        0x86,
    ],
    "EFI_EDID_DISCOVERED_PROTOCOL_GUID": [
        0x1C0C34F6,
        0xD380,
        0x41FA,
        0xA0,
        0x49,
        0x8A,
        0xD0,
        0x6C,
        0x1A,
        0x66,
        0xAA,
    ],
    "EFI_EDID_OVERRIDE_PROTOCOL_GUID": [
        0x48ECB431,
        0xFB72,
        0x45C0,
        0xA9,
        0x22,
        0xF4,
        0x58,
        0xFE,
        0x4,
        0xB,
        0xD5,
    ],
    "EFI_EMUL6064KBDINPUT_PROTOCOL_GUID": [
        0x62CEEF5A,
        0x1D7C,
        0x4943,
        0x9B,
        0x3A,
        0x95,
        0xE2,
        0x49,
        0x4C,
        0x89,
        0x90,
    ],
    "EFI_EMUL6064MSINPUT_PROTOCOL_GUID": [
        0x7578B307,
        0xB25B,
        0x44F9,
        0x89,
        0x2E,
        0x20,
        0x9B,
        0x0E,
        0x39,
        0x93,
        0xC6,
    ],
    "EFI_EMUL6064TRAP_PROTOCOL_GUID": [
        0x6EA0F71C,
        0x614A,
        0x437E,
        0x8F,
        0x49,
        0x24,
        0x3A,
        0xD4,
        0xE8,
        0x32,
        0x68,
    ],
    "EFI_EVENT_LEGACY_BOOT_GUID": [
        0x2A571201,
        0x4966,
        0x47F6,
        0x8B,
        0x86,
        0xF3,
        0x1E,
        0x41,
        0xF3,
        0x2F,
        0x10,
    ],
    "EFI_EXTENDED_SAL_BASE_IO_SERVICES_PROTOCOL_GUID": [
        0x5AEA42B5,
        0x31E1,
        0x4515,
        0xBC,
        0x31,
        0xB8,
        0xD5,
        0x25,
        0x75,
        0x65,
        0xA6,
    ],
    "EFI_EXTENDED_SAL_BASE_SERVICES_PROTOCOL_GUID": [
        0xD9E9FA06,
        0x0FE0,
        0x41C3,
        0x96,
        0xFB,
        0x83,
        0x42,
        0x5A,
        0x33,
        0x94,
        0xF8,
    ],
    "EFI_EXTENDED_SAL_CACHE_SERVICES_PROTOCOL_GUID": [
        0xEDC9494,
        0x2743,
        0x4BA5,
        0x88,
        0x18,
        0x0A,
        0xEF,
        0x52,
        0x13,
        0xF1,
        0x88,
    ],
    "EFI_EXTENDED_SAL_ELOG_SERVICES_PROTOCOL_GUID": [
        0xD5E4EE5F,
        0x3E0A,
        0x453C,
        0xA7,
        0x25,
        0xB6,
        0x92,
        0xBB,
        0x6,
        0x36,
        0x5A,
    ],
    "EFI_EXTENDED_SAL_FV_BLOCK_SERVICES_PROTOCOL_GUID": [
        0xA2271DF1,
        0xBCBB,
        0x4F1D,
        0x98,
        0xA9,
        0x06,
        0xBC,
        0x17,
        0x2F,
        0x07,
        0x1A,
    ],
    "EFI_EXTENDED_SAL_LOCK_SERVICES_PROTOCOL_GUID": [
        0x76B75C23,
        0xFE4F,
        0x4E17,
        0xA2,
        0xAD,
        0x1A,
        0x65,
        0x3D,
        0xBB,
        0x49,
        0x4A,
    ],
    "EFI_EXTENDED_SAL_MCA_LOG_SERVICES_PROTOCOL_GUID": [
        0xCB3FD86E,
        0x38A3,
        0x4C03,
        0x9A,
        0x5C,
        0x90,
        0xCF,
        0xA3,
        0xA2,
        0xAB,
        0x7A,
    ],
    "EFI_EXTENDED_SAL_MCA_SERVICES_PROTOCOL_GUID": [
        0x2A591128,
        0x6CC7,
        0x42B1,
        0x8A,
        0xF0,
        0x58,
        0x93,
        0x3B,
        0x68,
        0x2D,
        0xBB,
    ],
    "EFI_EXTENDED_SAL_MP_SERVICES_PROTOCOL_GUID": [
        0x697D81A2,
        0xCF18,
        0x4DC0,
        0x9E,
        0x0D,
        0x06,
        0x11,
        0x3B,
        0x61,
        0x8A,
        0x3F,
    ],
    "EFI_EXTENDED_SAL_MTC_SERVICES_PROTOCOL_GUID": [
        0x899AFD18,
        0x75E8,
        0x408B,
        0xA4,
        0x1A,
        0x6E,
        0x2E,
        0x7E,
        0xCD,
        0xF4,
        0x54,
    ],
    "EFI_EXTENDED_SAL_PAL_SERVICES_PROTOCOL_GUID": [
        0xE1CD9D21,
        0x0FC2,
        0x438D,
        0x97,
        0x03,
        0x04,
        0xE6,
        0x6D,
        0x96,
        0x1E,
        0x57,
    ],
    "EFI_EXTENDED_SAL_PCI_SERVICES_PROTOCOL_GUID": [
        0xA46B1A31,
        0xAD66,
        0x4905,
        0x92,
        0xF6,
        0x2B,
        0x46,
        0x59,
        0xDC,
        0x30,
        0x63,
    ],
    "EFI_EXTENDED_SAL_RESET_SERVICES_PROTOCOL_GUID": [
        0x7D019990,
        0x8CE1,
        0x46F5,
        0xA7,
        0x76,
        0x3C,
        0x51,
        0x98,
        0x67,
        0x6A,
        0xA0,
    ],
    "EFI_EXTENDED_SAL_RTC_SERVICES_PROTOCOL_GUID": [
        0x7E97A470,
        0xEFDB,
        0x4D02,
        0x8F,
        0xCE,
        0x61,
        0x90,
        0xD2,
        0x7B,
        0xA2,
        0x96,
    ],
    "EFI_EXTENDED_SAL_SENSOR_SERVICES_PROTOCOL_GUID": [
        0x4A153B6E,
        0x85A1,
        0x4982,
        0x98,
        0xF4,
        0x6A,
        0x8C,
        0xFC,
        0xA4,
        0xAB,
        0xA1,
    ],
    "EFI_EXTENDED_SAL_SM_COM_LAYER_SERVICES_PROTOCOL_GUID": [
        0x4356799,
        0x81B7,
        0x4E08,
        0xA3,
        0x8D,
        0xD9,
        0x78,
        0xFA,
        0x47,
        0xBA,
        0x42,
    ],
    "EFI_EXTENDED_SAL_SST_GUID": [
        0x38802700,
        0x868A,
        0x4B4E,
        0x81,
        0xD4,
        0x4F,
        0x1B,
        0xDC,
        0xCF,
        0xB4,
        0x6F,
    ],
    "EFI_EXTENDED_SAL_STALL_SERVICES_PROTOCOL_GUID": [
        0x53A58D06,
        0xAC27,
        0x4D8C,
        0xB5,
        0xE9,
        0xF0,
        0x8A,
        0x80,
        0x65,
        0x41,
        0x70,
    ],
    "EFI_EXTENDED_SAL_STATUS_CODE_SERVICES_PROTOCOL_GUID": [
        0xDBD91D,
        0x55E9,
        0x420F,
        0x96,
        0x39,
        0x5E,
        0x9F,
        0x84,
        0x37,
        0xB4,
        0x4F,
    ],
    "EFI_EXTENDED_SAL_VARIABLE_SERVICES_PROTOCOL_GUID": [
        0x4ECB6C53,
        0xC641,
        0x4370,
        0x8C,
        0xB2,
        0x3B,
        0x0E,
        0x49,
        0x6E,
        0x83,
        0x78,
    ],
    "EFI_EXTENDED_SAL_VIRTUAL_SERVICES_PROTOCOL_GUID": [
        0xC1A74056,
        0x260E,
        0x4871,
        0xA0,
        0x31,
        0xE6,
        0x45,
        0xA6,
        0x5B,
        0x6E,
        0x11,
    ],
    "EFI_EXT_SCSI_PASS_THRU_PROTOCOL_GUID": [
        0x143B7632,
        0xB81B,
        0x4CB7,
        0xAB,
        0xD3,
        0xB6,
        0x25,
        0xA5,
        0xB9,
        0xBF,
        0xFE,
    ],
    "EFI_FAULT_TOLERANT_WRITE_PROTOCOL_GUID": [
        0x3EBD9E82,
        0x2C78,
        0x4DE6,
        0x97,
        0x86,
        0x8D,
        0x4B,
        0xFC,
        0xB7,
        0xC8,
        0x81,
    ],
    "EFI_FFS_VOLUME_TOP_FILE_GUID": [
        0x1BA0062E,
        0xC779,
        0x4582,
        0x85,
        0x66,
        0x33,
        0x6A,
        0xE8,
        0xF7,
        0x8F,
        0x9,
    ],
    "EFI_FILE_SYSTEM_INFO_ID_GUID": [
        0x9576E93,
        0x6D3F,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_FILE_SYSTEM_VOLUME_LABEL_INFO_ID_GUID": [
        0xDB47D7D3,
        0xFE81,
        0x11D3,
        0x9A,
        0x35,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_FIND_FV_PPI_GUID": [
        0x36164812,
        0xA023,
        0x44E5,
        0xBD,
        0x85,
        0x5,
        0xBF,
        0x3C,
        0x77,
        0x0,
        0xAA,
    ],
    "EFI_FIRMWARE_FILE_SYSTEM2_GUID": [
        0x8C8CE578,
        0x8A3D,
        0x4F1C,
        0x99,
        0x35,
        0x89,
        0x61,
        0x85,
        0xC3,
        0x2D,
        0xD3,
    ],
    "EFI_FIRMWARE_FILE_SYSTEM_GUID": [
        0x7A9354D9,
        0x0468,
        0x444A,
        0x81,
        0xCE,
        0x0B,
        0xF6,
        0x17,
        0xD8,
        0x90,
        0xDF,
    ],
    "EFI_FIRMWARE_VOLUME2_PROTOCOL_GUID": [
        0x220E73B6,
        0x6BDB,
        0x4413,
        0x84,
        0x5,
        0xB9,
        0x74,
        0xB1,
        0x8,
        0x61,
        0x9A,
    ],
    "EFI_FIRMWARE_VOLUME_BLOCK2_PROTOCOL_GUID": [
        0x8F644FA9,
        0xE850,
        0x4DB1,
        0x9C,
        0xE2,
        0xB,
        0x44,
        0x69,
        0x8E,
        0x8D,
        0xA4,
    ],
    "EFI_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID": [
        0x8F644FA9,
        0xE850,
        0x4DB1,
        0x9C,
        0xE2,
        0xB,
        0x44,
        0x69,
        0x8E,
        0x8D,
        0xA4,
    ],
    "EFI_FIRMWARE_VOLUME_DISPATCH_PROTOCOL_GUID": [
        0x7AA35A69,
        0x506C,
        0x444F,
        0xA7,
        0xAF,
        0x69,
        0x4B,
        0xF5,
        0x6F,
        0x71,
        0xC8,
    ],
    "EFI_FIRMWARE_VOLUME_PROTOCOL_GUID": [
        0x389F751F,
        0x1838,
        0x4388,
        0x83,
        0x90,
        0xCD,
        0x81,
        0x54,
        0xBD,
        0x27,
        0xF8,
    ],
    "EFI_FORM_BROWSER2_PROTOCOL_GUID": [
        0xB9D4C360,
        0xBCFB,
        0x4F9B,
        0x92,
        0x98,
        0x53,
        0xC1,
        0x36,
        0x98,
        0x22,
        0x58,
    ],
    "EFI_FORM_BROWSER_PROTOCOL_GUID": [
        0xE5A1333E,
        0xE1B4,
        0x4D55,
        0xCE,
        0xEB,
        0x35,
        0xC3,
        0xEF,
        0x13,
        0x34,
        0x43,
    ],
    "EFI_FORM_CALLBACK_PROTOCOL_GUID": [
        0xF3E4543D,
        0xCF35,
        0x6CEF,
        0x35,
        0xC4,
        0x4F,
        0xE6,
        0x34,
        0x4D,
        0xFC,
        0x54,
    ],
    "EFI_FRAMEWORK_DEVICE_PATH_GUID": [
        0xB7084E63,
        0x46B7,
        0x4D1A,
        0x86,
        0x77,
        0xE3,
        0x0B,
        0x53,
        0xDB,
        0xF0,
        0x50,
    ],
    "EFI_FTW_LITE_PROTOCOL_GUID": [
        0x3F557189,
        0x8DAE,
        0x45AE,
        0xA0,
        0xB3,
        0x2B,
        0x99,
        0xCA,
        0x7A,
        0xA7,
        0xA0,
    ],
    "EFI_FVB_EXTENSION_PROTOCOL_GUID": [
        0x53A4C71B,
        0xB581,
        0x4170,
        0x91,
        0xB3,
        0x8D,
        0xB8,
        0x7A,
        0x4B,
        0x5C,
        0x46,
    ],
    "EFI_GENERIC_MEMORY_TEST_PROTOCOL_GUID": [
        0x309DE7F1,
        0x7F5E,
        0x4ACE,
        0xB4,
        0x9C,
        0x53,
        0x1B,
        0xE5,
        0xAA,
        0x95,
        0xEF,
    ],
    "EFI_GENERIC_VARIABLE_GUID": [
        0x59D1C24F,
        0x50F1,
        0x401A,
        0xB1,
        0x01,
        0xF3,
        0x3E,
        0x0D,
        0xAE,
        0xD4,
        0x43,
    ],
    "EFI_GLOBAL_NVS_AREA_PROTOCOL_GUID": [
        0x74E1E48,
        0x8132,
        0x47A1,
        0x8C,
        0x2C,
        0x3F,
        0x14,
        0xAD,
        0x9A,
        0x66,
        0xDC,
    ],
    "EFI_GLOBAL_VARIABLE_GUID": [
        0x8BE4DF61,
        0x93CA,
        0x11D2,
        0xAA,
        0x0D,
        0x00,
        0xE0,
        0x98,
        0x03,
        0x2B,
        0x8C,
    ],
    "EFI_GLOBAL_VARIABLE_GUID": [
        0x8BE4DF61,
        0x93CA,
        0x11D2,
        0xAA,
        0x0D,
        0x00,
        0xE0,
        0x98,
        0x03,
        0x2B,
        0x8C,
    ],
    "EFI_GPIO_PROTOCOL_GUID": [
        0xB5D09084,
        0x80AD,
        0x4759,
        0xB5,
        0x1C,
        0x27,
        0x54,
        0x8A,
        0xFB,
        0x8B,
        0x8D,
    ],
    "EFI_GRAPHICS_OUTPUT_PROTOCOL_GUID": [
        0x9042A9DE,
        0x23DC,
        0x4A38,
        0x96,
        0xFB,
        0x7A,
        0xDE,
        0xD0,
        0x80,
        0x51,
        0x6A,
    ],
    "EFI_GUID": [
        0x00720665,
        0x67EB,
        0x4A99,
        0xBA,
        0xF7,
        0xD3,
        0xC3,
        0x3A,
        0x1C,
        0x7C,
        0xC9,
    ],
    "EFI_GUID": [
        0x0F729F33,
        0x25C1,
        0x41A7,
        0x86,
        0xB2,
        0x23,
        0xA7,
        0x37,
        0xA9,
        0x18,
        0x23,
    ],
    "EFI_GUID": [
        0x142204E2,
        0xC7B1,
        0x4AF9,
        0xA7,
        0x29,
        0x92,
        0x37,
        0x58,
        0xD9,
        0x6D,
        0x3,
    ],
    "EFI_GUID": [
        0x17088572,
        0x377F,
        0x44EF,
        0x8F,
        0x4E,
        0xB0,
        0x9F,
        0xFF,
        0x46,
        0xA0,
        0x70,
    ],
    "EFI_GUID": [
        0x17088572,
        0x377F,
        0x44EF,
        0x8F,
        0x4E,
        0xB0,
        0x9F,
        0xFF,
        0x46,
        0xA0,
        0x70,
    ],
    "EFI_GUID": [
        0x1E753E16,
        0xDCEF,
        0x47D0,
        0x9A,
        0x38,
        0x7A,
        0xDE,
        0xCD,
        0xB9,
        0x83,
        0xED,
    ],
    "EFI_GUID": [
        0x1D3DE7F0,
        0x0807,
        0x424F,
        0xAA,
        0x69,
        0x11,
        0xA5,
        0x4E,
        0x19,
        0xA4,
        0x6F,
    ],
    "EFI_GUID": [
        0x1E93E633,
        0xD65A,
        0x459E,
        0xAB,
        0x84,
        0x93,
        0xD9,
        0xEC,
        0x26,
        0x6D,
        0x18,
    ],
    "EFI_GUID": [
        0x220AC432,
        0x1D43,
        0x49E5,
        0xA7,
        0x4F,
        0x4C,
        0x9D,
        0xA6,
        0x7A,
        0xD2,
        0x3B,
    ],
    "EFI_GUID": [
        0x2362EA9C,
        0x84E5,
        0x4DFF,
        0x83,
        0xBC,
        0xB5,
        0xAC,
        0xEC,
        0xB5,
        0x7C,
        0xBB,
    ],
    "EFI_GUID": [
        0x2FE800BE,
        0x8F01,
        0x4AA6,
        0x94,
        0x6B,
        0xD7,
        0x13,
        0x88,
        0xE1,
        0x83,
        0x3F,
    ],
    "EFI_GUID": [
        0x2AE9D80F,
        0x3FB2,
        0x4095,
        0xB7,
        0xB1,
        0xE9,
        0x31,
        0x57,
        0xB9,
        0x46,
        0xB6,
    ],
    "EFI_GUID": [
        0x379BE4E,
        0xD706,
        0x437D,
        0xB0,
        0x37,
        0xED,
        0xB8,
        0x2F,
        0xB7,
        0x72,
        0xA4,
    ],
    "EFI_GUID": [
        0x3B6686BD,
        0x0D76,
        0x4030,
        0xB7,
        0x0E,
        0xB5,
        0x51,
        0x9E,
        0x2F,
        0xC5,
        0xA0,
    ],
    "EFI_GUID": [
        0x3AD9DF29,
        0x4501,
        0x478D,
        0xB1,
        0xF8,
        0x7F,
        0x7F,
        0xE7,
        0x0E,
        0x50,
        0xF3,
    ],
    "EFI_GUID": [
        0x3B95AA31,
        0x3793,
        0x434B,
        0x86,
        0x67,
        0xC8,
        0x07,
        0x08,
        0x92,
        0xE0,
        0x5E,
    ],
    "EFI_GUID": [
        0x3E745226,
        0x9818,
        0x45B6,
        0xA2,
        0xAC,
        0xD7,
        0xCD,
        0x0E,
        0x8B,
        0xA2,
        0xBC,
    ],
    "EFI_GUID": [
        0x41D94CD2,
        0x35B6,
        0x455A,
        0x82,
        0x58,
        0xD4,
        0xE5,
        0x13,
        0x34,
        0xAA,
        0xDD,
    ],
    "EFI_GUID": [
        0x42881C98,
        0xA4F3,
        0x44B0,
        0xA3,
        0x9D,
        0xDF,
        0xA1,
        0x86,
        0x67,
        0xD8,
        0xCD,
    ],
    "EFI_GUID": [
        0x4599D26F,
        0x1A11,
        0x49B8,
        0xB9,
        0x1F,
        0x85,
        0x87,
        0x45,
        0xCF,
        0xF8,
        0x24,
    ],
    "EFI_GUID": [
        0x45D68DB9,
        0x8B4E,
        0x48C0,
        0x99,
        0xE9,
        0xF2,
        0x1F,
        0x26,
        0x2D,
        0xB6,
        0x53,
    ],
    "EFI_GUID": [
        0x4D330321,
        0x025F,
        0x4AAC,
        0x90,
        0xD8,
        0x5E,
        0xD9,
        0x00,
        0x17,
        0x3B,
        0x63,
    ],
    "EFI_GUID": [
        0x4EAAAA1,
        0x29A1,
        0x11D7,
        0x88,
        0x38,
        0x0,
        0x50,
        0x4,
        0x73,
        0xD4,
        0xEB,
    ],
    "EFI_GUID": [
        0x4ED4BF27,
        0x4092,
        0x42E9,
        0x80,
        0x7D,
        0x52,
        0x7B,
        0x1D,
        0x00,
        0xC9,
        0xBD,
    ],
    "EFI_GUID": [
        0x51AA59DE,
        0xFDF2,
        0x4EA3,
        0xBC,
        0x63,
        0x87,
        0x5F,
        0xB7,
        0x84,
        0x2E,
        0xE9,
    ],
    "EFI_GUID": [
        0x560BF58A,
        0x1E0D,
        0x4D7E,
        0x95,
        0x3F,
        0x29,
        0x80,
        0xA2,
        0x61,
        0xE0,
        0x31,
    ],
    "EFI_GUID": [
        0x564B33CD,
        0xC92A,
        0x4593,
        0x90,
        0xBF,
        0x24,
        0x73,
        0xE4,
        0x3C,
        0x63,
        0x22,
    ],
    "EFI_GUID": [
        0x5C99A21,
        0xC70F,
        0x4AD2,
        0x8A,
        0x5F,
        0x35,
        0xDF,
        0x33,
        0x43,
        0xF5,
        0x1E,
    ],
    "EFI_GUID": [
        0x6298FE18,
        0xD5EF,
        0x42B7,
        0xBB,
        0xC,
        0x29,
        0x53,
        0x28,
        0x3F,
        0x57,
        0x4,
    ],
    "EFI_GUID": [
        0x65530BC7,
        0xA359,
        0x410F,
        0xB0,
        0x10,
        0x5A,
        0xAD,
        0xC7,
        0xEC,
        0x2B,
        0x62,
    ],
    "EFI_GUID": [
        0x7671D9D0,
        0x53DB,
        0x4173,
        0xAA,
        0x69,
        0x23,
        0x27,
        0xF2,
        0x1F,
        0x0B,
        0xC7,
    ],
    "EFI_GUID": [
        0x7D113AA9,
        0x6280,
        0x48C6,
        0xBA,
        0xCE,
        0xDF,
        0xE7,
        0x66,
        0x8E,
        0x83,
        0x7,
    ],
    "EFI_GUID": [
        0x83F01464,
        0x99BD,
        0x45E5,
        0xB3,
        0x83,
        0xAF,
        0x63,
        0x05,
        0xD8,
        0xE9,
        0xE6,
    ],
    "EFI_GUID": [
        0x878AC2CC,
        0x5343,
        0x46F2,
        0xB5,
        0x63,
        0x51,
        0xF8,
        0x9D,
        0xAF,
        0x56,
        0xBA,
    ],
    "EFI_GUID": [
        0x8983FD2D,
        0x113C,
        0x4E2B,
        0x8F,
        0x47,
        0xA,
        0xBF,
        0xEB,
        0x20,
        0xA4,
        0x1A,
    ],
    "EFI_GUID": [
        0x8A219718,
        0x4EF5,
        0x4761,
        0x91,
        0xC8,
        0xC0,
        0xF0,
        0x4B,
        0xDA,
        0x9E,
        0x56,
    ],
    "EFI_GUID": [
        0x8B843E20,
        0x8132,
        0x4852,
        0x90,
        0xCC,
        0x55,
        0x1A,
        0x4E,
        0x4A,
        0x7F,
        0x1C,
    ],
    "EFI_GUID": [
        0x8DF01A06,
        0x9BD5,
        0x4BF7,
        0xB0,
        0x21,
        0xDB,
        0x4F,
        0xD9,
        0xCC,
        0xF4,
        0x5B,
    ],
    "EFI_GUID": [
        0x8FF925F1,
        0x8624,
        0x4D38,
        0x9E,
        0xD2,
        0xF8,
        0xF5,
        0xAA,
        0x94,
        0xF8,
        0x4A,
    ],
    "EFI_GUID": [0x97E409E6, 0x4CC1, 0x11D9, 0x81, 0xF6, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
    "EFI_GUID": [
        0x98B8D59B,
        0xE8BA,
        0x48EE,
        0x98,
        0xDD,
        0xC2,
        0x95,
        0x39,
        0x2F,
        0x1E,
        0xDB,
    ],
    "EFI_GUID": [
        0x9CC55D7D,
        0xFBFF,
        0x431C,
        0xBC,
        0x14,
        0x33,
        0x4E,
        0xAE,
        0xA6,
        0x5,
        0x2B,
    ],
    "EFI_GUID": [
        0x9D7A05E9,
        0xF740,
        0x44C3,
        0x85,
        0x8B,
        0x75,
        0x58,
        0x6A,
        0x8F,
        0x9C,
        0x8E,
    ],
    "EFI_GUID": [
        0x9D9A39D8,
        0xBD42,
        0x4A73,
        0xA4,
        0xD5,
        0x8E,
        0xE9,
        0x4B,
        0xE1,
        0x13,
        0x80,
    ],
    "EFI_GUID": [
        0x9FE7DE69,
        0xAEA,
        0x470A,
        0xB5,
        0xA,
        0x13,
        0x98,
        0x13,
        0x64,
        0x91,
        0x89,
    ],
    "EFI_GUID": [
        0xCC0F8A3F,
        0x3DEA,
        0x4376,
        0x96,
        0x79,
        0x54,
        0x26,
        0xBA,
        0x0A,
        0x90,
        0x7E,
    ],
    "EFI_GUID": [
        0xA6A72875,
        0x2962,
        0x4C18,
        0x9F,
        0x46,
        0x8D,
        0xA6,
        0x44,
        0xCC,
        0xFE,
        0x00,
    ],
    "EFI_GUID": [
        0xAA31BC6,
        0x3379,
        0x41E8,
        0x82,
        0x5A,
        0x53,
        0xF8,
        0x2C,
        0xC0,
        0xF2,
        0x54,
    ],
    "EFI_GUID": [
        0xABB74F50,
        0xFD2D,
        0x4072,
        0xA3,
        0x21,
        0xCA,
        0xFC,
        0x72,
        0x97,
        0x7E,
        0xFA,
    ],
    "EFI_GUID": [
        0xAF7C79C,
        0x65B5,
        0x4319,
        0xB0,
        0xAE,
        0x44,
        0xEC,
        0x48,
        0x4E,
        0x4A,
        0xD7,
    ],
    "EFI_GUID": [
        0xBB2F3C9D,
        0xC7A1,
        0x4283,
        0x8A,
        0xE2,
        0x4F,
        0x43,
        0x62,
        0x99,
        0x0E,
        0x2E,
    ],
    "EFI_GUID": [
        0xBFD7DC1D,
        0x24F1,
        0x40D9,
        0x82,
        0xE7,
        0x2E,
        0x09,
        0xBB,
        0x6B,
        0x4E,
        0xBE,
    ],
    "EFI_GUID": [
        0xC1BDD34E,
        0x9EC0,
        0x48AA,
        0x80,
        0x6A,
        0x6C,
        0x2E,
        0xBA,
        0x0D,
        0xC4,
        0x45,
    ],
    "EFI_GUID": [
        0xC280C73E,
        0x15CA,
        0x11DA,
        0xB0,
        0xCA,
        0x00,
        0x10,
        0x83,
        0xFF,
        0xCA,
        0x4D,
    ],
    "EFI_GUID": [
        0xC51711E7,
        0xB4BF,
        0x404A,
        0xBF,
        0xB8,
        0x0A,
        0x04,
        0x8E,
        0xF1,
        0xFF,
        0xE4,
    ],
    "EFI_GUID": [
        0xC5184932,
        0xDBA5,
        0x46DB,
        0xA5,
        0xBA,
        0xCC,
        0x0B,
        0xDA,
        0x9C,
        0x14,
        0x35,
    ],
    "EFI_GUID": [
        0xCAA4381E,
        0x750C,
        0x4770,
        0xB8,
        0x70,
        0x7A,
        0x23,
        0xB4,
        0xE4,
        0x21,
        0x30,
    ],
    "EFI_GUID": [
        0xD6062B50,
        0x15CA,
        0x11DA,
        0x92,
        0x19,
        0x00,
        0x10,
        0x83,
        0xFF,
        0xCA,
        0x4D,
    ],
    "EFI_GUID": [
        0xD84BEFF0,
        0x159A,
        0x4B60,
        0x9A,
        0xB9,
        0xAC,
        0x5C,
        0x47,
        0x4B,
        0xD3,
        0xB1,
    ],
    "EFI_GUID": [
        0xDBC9FD21,
        0xFAD8,
        0x45B0,
        0x9E,
        0x78,
        0x27,
        0x15,
        0x88,
        0x67,
        0xCC,
        0x93,
    ],
    "EFI_GUID": [
        0xE6F4F8F7,
        0x4992,
        0x47B2,
        0x83,
        0x2,
        0x85,
        0x8,
        0x74,
        0x5E,
        0x4A,
        0x23,
    ],
    "EFI_GUID": [
        0xEDD35E31,
        0x7B9,
        0x11D2,
        0x83,
        0xA3,
        0x00,
        0xA0,
        0xC9,
        0x1F,
        0xAD,
        0xCF,
    ],
    "EFI_GUID": [
        0xEFA96432,
        0xDE33,
        0x4DD2,
        0xAE,
        0xE6,
        0x32,
        0x8C,
        0x33,
        0xDF,
        0x77,
        0x7A,
    ],
    "EFI_GUID": [
        0xF328E36C,
        0x23B6,
        0x4A95,
        0x85,
        0x4B,
        0x32,
        0xE1,
        0x95,
        0x34,
        0xCD,
        0x75,
    ],
    "EFI_GUID": [
        0xF36FF770,
        0xA7E1,
        0x42CF,
        0x9E,
        0xD2,
        0x56,
        0xF0,
        0xF2,
        0x71,
        0xF4,
        0x4C,
    ],
    "EFI_GUID": [
        0xF44C00EE,
        0x1F2C,
        0x4A00,
        0xAA,
        0x09,
        0x1C,
        0x9F,
        0x3E,
        0x08,
        0x00,
        0xA3,
    ],
    "EFI_GUID": [
        0xF4B427BB,
        0xBA21,
        0x4F16,
        0xBC,
        0x4E,
        0x43,
        0xE4,
        0x16,
        0xAB,
        0x61,
        0x9C,
    ],
    "EFI_GUID": [
        0xF8E21975,
        0x0899,
        0x4F58,
        0xA4,
        0xBE,
        0x55,
        0x25,
        0xA9,
        0xC6,
        0xD7,
        0x7A,
    ],
    "EFI_GUID": [
        0xFBF95065,
        0x427F,
        0x47B3,
        0x80,
        0x77,
        0xD1,
        0x3C,
        0x60,
        0x71,
        0x9,
        0x98,
    ],
    "EFI_GUID": [
        0xFD44820B,
        0xF1AB,
        0x41C0,
        0xAE,
        0x4E,
        0x0C,
        0x55,
        0x55,
        0x6E,
        0xB9,
        0xBD,
    ],
    "EFI_HARDWARE_ERROR_VARIABLE_GUID": [
        0x414E6BDD,
        0xE47B,
        0x47CC,
        0xB2,
        0x44,
        0xBB,
        0x61,
        0x02,
        0x0C,
        0xF5,
        0x16,
    ],
    "EFI_HASH_ALGORITHM_SHA1_GUID": [
        0x2AE9D80F,
        0x3FB2,
        0x4095,
        0xB7,
        0xB1,
        0xE9,
        0x31,
        0x57,
        0xB9,
        0x46,
        0xB6,
    ],
    "EFI_HASH_ALGORITHM_SHA224_GUID": [
        0x8DF01A06,
        0x9BD5,
        0x4BF7,
        0xB0,
        0x21,
        0xDB,
        0x4F,
        0xD9,
        0xCC,
        0xF4,
        0x5B,
    ],
    "EFI_HASH_ALGORITHM_SHA256_GUID": [
        0x51AA59DE,
        0xFDF2,
        0x4EA3,
        0xBC,
        0x63,
        0x87,
        0x5F,
        0xB7,
        0x84,
        0x2E,
        0xE9,
    ],
    "EFI_HASH_ALGORITHM_SHA384_GUID": [
        0xEFA96432,
        0xDE33,
        0x4DD2,
        0xAE,
        0xE6,
        0x32,
        0x8C,
        0x33,
        0xDF,
        0x77,
        0x7A,
    ],
    "EFI_HASH_ALGORITHM_SHA512_GUID": [
        0xCAA4381E,
        0x750C,
        0x4770,
        0xB8,
        0x70,
        0x7A,
        0x23,
        0xB4,
        0xE4,
        0x21,
        0x30,
    ],
    "EFI_HASH_ALGORTIHM_MD5_GUID": [
        0xAF7C79C,
        0x65B5,
        0x4319,
        0xB0,
        0xAE,
        0x44,
        0xEC,
        0x48,
        0x4E,
        0x4A,
        0xD7,
    ],
    "EFI_HASH_PROTOCOL_GUID": [
        0xC5184932,
        0xDBA5,
        0x46DB,
        0xA5,
        0xBA,
        0xCC,
        0x0B,
        0xDA,
        0x9C,
        0x14,
        0x35,
    ],
    "EFI_HASH_SERVICE_BINDING_PROTOCOL_GUID": [
        0x42881C98,
        0xA4F3,
        0x44B0,
        0xA3,
        0x9D,
        0xDF,
        0xA1,
        0x86,
        0x67,
        0xD8,
        0xCD,
    ],
    "EFI_HII_CONFIG_ACCESS_PROTOCOL_GUID": [
        0x330D4706,
        0xF2A0,
        0x4E4F,
        0xA3,
        0x69,
        0xB6,
        0x6F,
        0xA8,
        0xD5,
        0x43,
        0x85,
    ],
    "EFI_HII_CONFIG_ROUTING_PROTOCOL_GUID": [
        0x587E72D7,
        0xCC50,
        0x4F79,
        0x82,
        0x09,
        0xCA,
        0x29,
        0x1F,
        0xC1,
        0xA1,
        0x0F,
    ],
    "EFI_HII_DATABASE_PROTOCOL_GUID": [
        0xEF9FC172,
        0xA1B2,
        0x4693,
        0xB3,
        0x27,
        0x6D,
        0x32,
        0xFC,
        0x41,
        0x60,
        0x42,
    ],
    "EFI_HII_DRIVER_HEALTH_FORMSET_GUID": [
        0xF22FC20C,
        0x8CF4,
        0x45EB,
        0x8E,
        0x6,
        0xAD,
        0x4E,
        0x50,
        0xB9,
        0x5D,
        0xD3,
    ],
    "EFI_HII_EXT_PROTOCOL_GUID": [
        0x2A57AE75,
        0x8B7A,
        0x4C64,
        0x86,
        0x56,
        0xDB,
        0x51,
        0xDD,
        0xC3,
        0x6F,
        0x7B,
    ],
    "EFI_HII_FONT_PROTOCOL_GUID": [
        0xE9CA4775,
        0x8657,
        0x47FC,
        0x97,
        0xE7,
        0x7E,
        0xD6,
        0x5A,
        0x8,
        0x43,
        0x24,
    ],
    "EFI_HII_FRONT_PAGE_CLASS_GUID": [
        0x94D411B7,
        0x7669,
        0x45C3,
        0xBA,
        0x3B,
        0xF3,
        0xA5,
        0x8A,
        0x71,
        0x56,
        0x81,
    ],
    "EFI_HII_IMAGE_PROTOCOL_GUID": [
        0x31A6406A,
        0x6BDF,
        0x4E46,
        0xB2,
        0xA2,
        0xEB,
        0xAA,
        0x89,
        0xC4,
        0x9,
        0x20,
    ],
    "EFI_HII_NEW_PROTOCOL_GUID": [
        0xEA816D2C,
        0xCEE5,
        0x4F02,
        0x99,
        0xB5,
        0xD3,
        0x90,
        0x5C,
        0xBB,
        0xD0,
        0x77,
    ],
    "EFI_HII_OLD_PROTOCOL_GUID": [
        0xCD361957,
        0xAFBE,
        0x425E,
        0xA3,
        0x58,
        0x5F,
        0x58,
        0x89,
        0xCF,
        0xFE,
        0x7B,
    ],
    "EFI_HII_PACKAGE_LIST_PROTOCOL_GUID": [
        0x6A1EE763,
        0xD47A,
        0x43B4,
        0xAA,
        0xBE,
        0xEF,
        0x1D,
        0xE2,
        0xAB,
        0x56,
        0xFC,
    ],
    "EFI_HII_PLATFORM_SETUP_FORMSET_GUID": [
        0x93039971,
        0x8545,
        0x4B04,
        0xB4,
        0x5E,
        0x32,
        0xEB,
        0x83,
        0x26,
        0x4,
        0xE,
    ],
    "EFI_HII_PLATFORM_SETUP_FORMSET_GUID": [
        0x93039971,
        0x8545,
        0x4B04,
        0xB4,
        0x5E,
        0x32,
        0xEB,
        0x83,
        0x26,
        0x4,
        0xE,
    ],
    "EFI_HII_PROTOCOL_GUID": [
        0xD7AD636E,
        0xB997,
        0x459B,
        0xBF,
        0x3F,
        0x88,
        0x46,
        0x89,
        0x79,
        0x80,
        0xE1,
    ],
    "EFI_HII_SET_KEYBOARD_LAYOUT_EVENT_GUID": [
        0x14982A4F,
        0xB0ED,
        0x45B8,
        0xA8,
        0x11,
        0x5A,
        0x7A,
        0x9B,
        0xC2,
        0x32,
        0xDF,
    ],
    "EFI_HII_STRING_PROTOCOL_GUID": [
        0xFD96974,
        0x23AA,
        0x4CDC,
        0xB9,
        0xCB,
        0x98,
        0xD1,
        0x77,
        0x50,
        0x32,
        0x2A,
    ],
    "EFI_HII_USER_CREDENTIAL_FORMSET_GUID": [
        0x337F4407,
        0x5AEE,
        0x4B83,
        0xB2,
        0xA7,
        0x4E,
        0xAD,
        0xCA,
        0x30,
        0x88,
        0xCD,
    ],
    "EFI_HOB_LIST_GUID": [
        0x7739F24C,
        0x93D7,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_HOB_MEMORY_ALLOC_BSP_STORE_GUID": [
        0x564B33CD,
        0xC92A,
        0x4593,
        0x90,
        0xBF,
        0x24,
        0x73,
        0xE4,
        0x3C,
        0x63,
        0x22,
    ],
    "EFI_HOB_MEMORY_ALLOC_BSP_STORE_GUID": [
        0x564B33CD,
        0xC92A,
        0x4593,
        0x90,
        0xBF,
        0x24,
        0x73,
        0xE4,
        0x3C,
        0x63,
        0x22,
    ],
    "EFI_HOB_MEMORY_ALLOC_STACK_GUID": [
        0x4ED4BF27,
        0x4092,
        0x42E9,
        0x80,
        0x7D,
        0x52,
        0x7B,
        0x1D,
        0x0,
        0xC9,
        0xBD,
    ],
    "EFI_HOB_MEMORY_ALLOC_STACK_GUID": [
        0x4ED4BF27,
        0x4092,
        0x42E9,
        0x80,
        0x7D,
        0x52,
        0x7B,
        0x1D,
        0x0,
        0xC9,
        0xBD,
    ],
    "EFI_HOT_KEYS_PROTOCOL_GUID": [
        0xF1E48287,
        0x3FE1,
        0x4535,
        0x89,
        0xAB,
        0x48,
        0xD6,
        0xC3,
        0xDA,
        0x27,
        0x59,
    ],
    "EFI_HT_BIST_HOB_GUID": [
        0xBE644001,
        0xE7D4,
        0x48B1,
        0xB0,
        0x96,
        0x8B,
        0xA0,
        0x47,
        0xBC,
        0x7A,
        0xE7,
    ],
    "EFI_IDER_CONTROLLER_DRIVER_PROTOCOL_GUID": [
        0x956A2ED0,
        0xA6CF,
        0x409A,
        0xB8,
        0xF5,
        0x35,
        0xF1,
        0x4C,
        0x3E,
        0x3C,
        0x2,
    ],
    "EFI_IDE_CONTROLLER_INIT_PROTOCOL_GUID": [
        0xA1E37052,
        0x80D9,
        0x4E65,
        0xA3,
        0x17,
        0x3E,
        0x9A,
        0x55,
        0xC4,
        0x3E,
        0xC9,
    ],
    "EFI_IFR_TIANO_GUID": [
        0xF0B1735,
        0x87A0,
        0x4193,
        0xB2,
        0x66,
        0x53,
        0x8C,
        0x38,
        0xAF,
        0x48,
        0xCE,
    ],
    "EFI_IMAGE_SECURITY_DATABASE_GUID": [
        0xD719B2CB,
        0x3D3A,
        0x4596,
        0xA3,
        0xBC,
        0xDA,
        0xD0,
        0xE,
        0x67,
        0x65,
        0x6F,
    ],
    "EFI_INCOMPATIBLE_PCI_DEVICE_SUPPORT_PROTOCOL_GUID": [
        0xEB23F55A,
        0x7863,
        0x4AC2,
        0x8D,
        0x3D,
        0x95,
        0x65,
        0x35,
        0xDE,
        0x03,
        0x75,
    ],
    "EFI_INTEL_MFG_FORMAT_FRU_GUID": [
        0x79E8C9C7,
        0x1152,
        0x4F00,
        0xB8,
        0x31,
        0x14,
        0xF1,
        0xC4,
        0x4,
        0x1A,
        0xE0,
    ],
    "EFI_IOBASE_HOB_GUID": [
        0xD4A28A3E,
        0xDCF2,
        0x43CF,
        0xA2,
        0xB7,
        0xF3,
        0x57,
        0x2A,
        0x7C,
        0xAB,
        0x9,
    ],
    "EFI_IP4_CONFIG_PROTOCOL_GUID": [
        0x3B95AA31,
        0x3793,
        0x434B,
        0x86,
        0x67,
        0xC8,
        0x07,
        0x08,
        0x92,
        0xE0,
        0x5E,
    ],
    "EFI_IP4_PROTOCOL_GUID": [
        0x41D94CD2,
        0x35B6,
        0x455A,
        0x82,
        0x58,
        0xD4,
        0xE5,
        0x13,
        0x34,
        0xAA,
        0xDD,
    ],
    "EFI_IP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0xC51711E7,
        0xB4BF,
        0x404A,
        0xBF,
        0xB8,
        0x0A,
        0x04,
        0x8E,
        0xF1,
        0xFF,
        0xE4,
    ],
    "EFI_IP_PROTOCOL_GUID": [
        0x89DEEF37,
        0x31D8,
        0x469C,
        0x95,
        0xB6,
        0x01,
        0x69,
        0xBC,
        0x86,
        0x6C,
        0xFB,
    ],
    "EFI_ISA_ACPI_PROTOCOL_GUID": [
        0x64A892DC,
        0x5561,
        0x4536,
        0x92,
        0xC7,
        0x79,
        0x9B,
        0xFC,
        0x18,
        0x33,
        0x55,
    ],
    "EFI_ISA_IO_PROTOCOL_GUID": [
        0x7EE2BD44,
        0x3DA0,
        0x11D4,
        0x9A,
        0x38,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_ISCSI_INITIATOR_NAME_PROTOCOL_GUID": [
        0x59324945,
        0xEC44,
        0x4C0D,
        0xB1,
        0xCD,
        0x9D,
        0xB1,
        0x39,
        0xDF,
        0x7,
        0xC,
    ],
    "EFI_LEGACY_8259_PROTOCOL_GUID": [
        0x38321DBA,
        0x4FE0,
        0x4E17,
        0x8A,
        0xEC,
        0x41,
        0x30,
        0x55,
        0xEA,
        0xED,
        0xC1,
    ],
    "EFI_LEGACY_BIOS_EXT_PROTOCOL_GUID": [
        0x8E008510,
        0x9BB1,
        0x457D,
        0x9F,
        0x70,
        0x89,
        0x7A,
        0xBA,
        0x86,
        0x5D,
        0xB9,
    ],
    "EFI_LEGACY_BIOS_GUID": [
        0x2E3044AC,
        0x879F,
        0x490F,
        0x97,
        0x60,
        0xBB,
        0xDF,
        0xAF,
        0x69,
        0x5F,
        0x50,
    ],
    "EFI_LEGACY_BIOS_PLATFORM_PROTOCOL_GUID": [
        0x783658A3,
        0x4172,
        0x4421,
        0xA2,
        0x99,
        0xE0,
        0x9,
        0x7,
        0x9C,
        0xC,
        0xB4,
    ],
    "EFI_LEGACY_BIOS_PROTOCOL_GUID": [
        0xDB9A1E3D,
        0x45CB,
        0x4ABB,
        0x85,
        0x3B,
        0xE5,
        0x38,
        0x7F,
        0xDB,
        0x2E,
        0x2D,
    ],
    "EFI_LEGACY_BIOS_THUNK_PROTOCOL_GUID": [
        0x4C51A7BA,
        0x7195,
        0x442D,
        0x87,
        0x92,
        0xBE,
        0xEA,
        0x6E,
        0x2F,
        0xF6,
        0xEC,
    ],
    "EFI_LEGACY_INTERRUPT_PROTOCOL_GUID": [
        0x31CE593D,
        0x108A,
        0x485D,
        0xAD,
        0xB2,
        0x78,
        0xF2,
        0x1F,
        0x29,
        0x66,
        0xBE,
    ],
    "EFI_LEGACY_SREDIR_PROTOCOL_GUID": [
        0xA062CF1F,
        0x8473,
        0x4AA3,
        0x87,
        0x93,
        0x60,
        0x0B,
        0xC4,
        0xFF,
        0xA9,
        0xA9,
    ],
    "EFI_LIGHT_ISA_IO_PROTOCOL_GUID": [
        0x7CC7ED80,
        0x9A68,
        0x4781,
        0x80,
        0xE4,
        0xDA,
        0x16,
        0x99,
        0x10,
        0x5A,
        0xFE,
    ],
    "EFI_LOADED_IMAGE_DEVICE_PATH_PROTOCOL_GUID": [
        0xBC62157E,
        0x3E33,
        0x4FEC,
        0x99,
        0x20,
        0x2D,
        0x3B,
        0x36,
        0xD7,
        0x50,
        0xDF,
    ],
    "EFI_LOADED_IMAGE_PROTOCOL_GUID": [
        0x5B1B31A1,
        0x9562,
        0x11D2,
        0x8E,
        0x3F,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_LOAD_FILE2_PROTOCOL_GUID": [
        0x4006C0C1,
        0xFCB3,
        0x403E,
        0x99,
        0x6D,
        0x4A,
        0x6C,
        0x87,
        0x24,
        0xE0,
        0x6D,
    ],
    "EFI_MANAGED_NETWORK_PROTOCOL_GUID": [
        0x7AB33A91,
        0xACE5,
        0x4326,
        0xB5,
        0x72,
        0xE7,
        0xEE,
        0x33,
        0xD3,
        0x9F,
        0x16,
    ],
    "EFI_MANAGED_NETWORK_SERVICE_BINDING_PROTOCOL_GUID": [
        0xF36FF770,
        0xA7E1,
        0x42CF,
        0x9E,
        0xD2,
        0x56,
        0xF0,
        0xF2,
        0x71,
        0xF4,
        0x4C,
    ],
    "EFI_MEMORY_CONFIG_DATA_GUID": [
        0x80DBD530,
        0xB74C,
        0x4F11,
        0x8C,
        0x03,
        0x41,
        0x86,
        0x65,
        0x53,
        0x28,
        0x31,
    ],
    "EFI_MEMORY_PRODUCER_GUID": [
        0x1D7ADD6E,
        0xB2DA,
        0x4B0B,
        0xB2,
        0x9F,
        0x49,
        0xCB,
        0x42,
        0xF4,
        0x63,
        0x56,
    ],
    "EFI_MEMORY_SUBCLASS_DRIVER_GUID": [
        0x1767CEED,
        0xDB82,
        0x47CD,
        0xBF,
        0x2B,
        0x68,
        0x45,
        0x8A,
        0x8C,
        0xCF,
        0xFF,
    ],
    "EFI_MEMORY_SUBCLASS_GUID": [
        0x4E8F4EBB,
        0x64B9,
        0x4E05,
        0x9B,
        0x18,
        0x4C,
        0xFE,
        0x49,
        0x23,
        0x50,
        0x97,
    ],
    "EFI_MEMORY_TYPE_FRU_GUID": [
        0xD50234F4,
        0x6F4B,
        0x43E8,
        0xA0,
        0x13,
        0x3C,
        0x1E,
        0x33,
        0xD9,
        0xB9,
        0xB1,
    ],
    "EFI_METRONOME_ARCH_PROTOCOL_GUID": [
        0x26BACCB2,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_ME_BIOS_EXTENSION_SETUP_GUID": [
        0x1BAD711C,
        0xD451,
        0x4241,
        0xB1,
        0xF3,
        0x85,
        0x37,
        0x81,
        0x2E,
        0xC,
        0x70,
    ],
    "EFI_ME_FW_SKU_VARIABLE_GUID": [
        0xE1A21D94,
        0x4A20,
        0x4E0E,
        0xAE,
        0x9,
        0xA9,
        0xA2,
        0x1F,
        0x24,
        0xBB,
        0x9E,
    ],
    "EFI_ME_RC_INFO_PROTOCOL_GUID": [
        0x11FBFDFB,
        0x10D2,
        0x43E6,
        0xB5,
        0xB1,
        0xB4,
        0x38,
        0x6E,
        0xDC,
        0xCB,
        0x9A,
    ],
    "EFI_MINI_SHELL_FILE_GUID": [
        0x86AD232B,
        0xD33A,
        0x465C,
        0xBF,
        0x5F,
        0x41,
        0x37,
        0xB,
        0xA9,
        0x2F,
        0xE2,
    ],
    "EFI_MISC_PRODUCER_GUID": [
        0x62512C92,
        0x63C4,
        0x4D80,
        0x82,
        0xB1,
        0xC1,
        0xA4,
        0xDC,
        0x44,
        0x80,
        0xE5,
    ],
    "EFI_MISC_SUBCLASS_DRIVER_GUID": [
        0xF50E702C,
        0x8653,
        0x4CDE,
        0xBB,
        0xCE,
        0x43,
        0xB4,
        0xD5,
        0x5B,
        0x34,
        0xB8,
    ],
    "EFI_MISC_SUBCLASS_GUID": [
        0x772484B2,
        0x7482,
        0x4B91,
        0x9F,
        0x9A,
        0xAD,
        0x43,
        0xF8,
        0x1C,
        0x58,
        0x81,
    ],
    "EFI_MONTONIC_COUNTER_ARCH_PROTOCOL_GUID": [
        0x1DA97072,
        0xBDDC,
        0x4B30,
        0x99,
        0xF1,
        0x72,
        0xA0,
        0xB5,
        0x6F,
        0xFF,
        0x2A,
    ],
    "EFI_MPS_TABLE_GUID": [
        0xEB9D2D2F,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_MP_SERVICES_PROTOCOL_GUID": [
        0x3FDDA605,
        0xA76E,
        0x4F46,
        0xAD,
        0x29,
        0x12,
        0xF4,
        0x53,
        0x1B,
        0x3D,
        0x08,
    ],
    "EFI_MP_SERVICES_PROTOCOL_GUID": [
        0xF33261E7,
        0x23CB,
        0x11D5,
        0xBD,
        0x5C,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_MTFTP4_PROTOCOL_GUID": [
        0x78247C57,
        0x63DB,
        0x4708,
        0x99,
        0xC2,
        0xA8,
        0xB4,
        0xA9,
        0xA6,
        0x1F,
        0x6B,
    ],
    "EFI_MTFTP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0x2FE800BE,
        0x8F01,
        0x4AA6,
        0x94,
        0x6B,
        0xD7,
        0x13,
        0x88,
        0xE1,
        0x83,
        0x3F,
    ],
    "EFI_NB_ERROR_LOG_DISPATCH_PROTOCOL_GUID": [
        0xFF2D54D4,
        0x5C55,
        0x4C06,
        0x85,
        0x49,
        0xC3,
        0x62,
        0x7C,
        0xB8,
        0xB9,
        0x95,
    ],
    "EFI_NB_MRC_INFO_GUID": [
        0xD7BD52B0,
        0xB2DC,
        0x4F08,
        0xB4,
        0x67,
        0xDE,
        0x50,
        0xD7,
        0x28,
        0xF6,
        0xBD,
    ],
    "EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL_GUID": [
        0x1ACED566,
        0x76ED,
        0x4218,
        0xBC,
        0x81,
        0x76,
        0x7F,
        0x1F,
        0x97,
        0x7A,
        0x89,
    ],
    "EFI_NETWORK_INTERFACE_IDENTIFIER_PROTOCOL_GUID": [
        0xE18541CD,
        0xF755,
        0x4F73,
        0x92,
        0x8D,
        0x64,
        0x3C,
        0x8A,
        0x79,
        0xB2,
        0x29,
    ],
    "EFI_NIC_IP4_CONFIG_PROTOCOL_GUID": [
        0xDCA3D4D,
        0x12DA,
        0x4728,
        0xBF,
        0x7E,
        0x86,
        0xCE,
        0xB9,
        0x28,
        0xD0,
        0x67,
    ],
    "EFI_NIC_IP4_CONFIG_VARIABLE_GUID": [
        0xD8944553,
        0xC4DD,
        0x41F4,
        0x9B,
        0x30,
        0xE1,
        0x39,
        0x7C,
        0xFB,
        0x26,
        0x7B,
    ],
    "EFI_NONSMMEMUL6064TRAP_PROTOCOL_GUID": [
        0x68B81E51,
        0x2583,
        0x4582,
        0x95,
        0xDB,
        0xC5,
        0x72,
        0x32,
        0x36,
        0xC4,
        0xF1,
    ],
    "EFI_OEM_BADGING_PROTOCOL_GUID": [
        0x170E13C0,
        0xBF1B,
        0x4218,
        0x87,
        0x1D,
        0x2A,
        0xBD,
        0xC6,
        0xF8,
        0x87,
        0xBC,
    ],
    "EFI_PART_TYPE_EFI_SYSTEM_PART_GUID": [
        0xC12A7328,
        0xF81F,
        0x11D2,
        0xBA,
        0x4B,
        0x00,
        0xA0,
        0xC9,
        0x3E,
        0xC9,
        0x3B,
    ],
    "EFI_PART_TYPE_LEGACY_MBR_GUID": [
        0x024DEE41,
        0x33E7,
        0x11D3,
        0x9D,
        0x69,
        0x00,
        0x08,
        0xC7,
        0x81,
        0xF3,
        0x9F,
    ],
    "EFI_PATH_FILE_NAME_GUID": [
        0x7644C181,
        0xFA6E,
        0x46DA,
        0x80,
        0xCB,
        0x04,
        0xB9,
        0x90,
        0x40,
        0x62,
        0xE8,
    ],
    "EFI_PCCARD_CS_PROTOCOL_GUID": [
        0xCA54F443,
        0x1EF2,
        0x4DAB,
        0x9E,
        0x7E,
        0x6D,
        0xB7,
        0xB7,
        0x20,
        0xB5,
        0x87,
    ],
    "EFI_PCCARD_SS_PROTOCOL_GUID": [
        0xC38E6D34,
        0x5A7F,
        0x4BF9,
        0xBE,
        0x57,
        0x94,
        0xDD,
        0x30,
        0x38,
        0x02,
        0x76,
    ],
    "EFI_PCH_INFO_PROTOCOL_GUID": [
        0x984EB4E9,
        0x5A95,
        0x41DE,
        0xAA,
        0xD0,
        0x53,
        0x66,
        0x8C,
        0xA5,
        0x13,
        0xC0,
    ],
    "EFI_PCH_S3_IMAGE_GUID": [
        0x271DD6F2,
        0x54CB,
        0x45E6,
        0x85,
        0x85,
        0x8C,
        0x92,
        0x3C,
        0x1A,
        0xC7,
        0x6,
    ],
    "EFI_PCH_S3_SUPPORT_PROTOCOL_GUID": [
        0xE287D20B,
        0xD897,
        0x4E1E,
        0xA5,
        0xD9,
        0x97,
        0x77,
        0x63,
        0x93,
        0x6A,
        0x4,
    ],
    "EFI_PCI_EXPRESS_BASE_ADDRESS_GUID": [
        0x3677D529,
        0x326F,
        0x4603,
        0xA9,
        0x26,
        0xEA,
        0xAC,
        0xE0,
        0x1D,
        0xCB,
        0xB0,
    ],
    "EFI_PCI_HOTPLUG_DEVICE_GUID": [
        0x0B280816,
        0x52E7,
        0x4E51,
        0xAA,
        0x57,
        0x11,
        0xBD,
        0x41,
        0xCB,
        0xEF,
        0xC3,
    ],
    "EFI_PCI_HOT_PLUG_INIT_PROTOCOL_GUID": [
        0xAA0E8BC1,
        0xDABC,
        0x46B0,
        0xA8,
        0x44,
        0x37,
        0xB8,
        0x16,
        0x9B,
        0x2B,
        0xEA,
    ],
    "EFI_PCI_IO_PROTOCOL_GUID": [
        0x4CF5B200,
        0x68B8,
        0x4CA5,
        0x9E,
        0xEC,
        0xB2,
        0x3E,
        0x3F,
        0x50,
        0x2,
        0x9A,
    ],
    "EFI_PCI_OPTION_ROM_TABLE_GUID": [
        0x7462660F,
        0x1CBD,
        0x48DA,
        0xAD,
        0x11,
        0x91,
        0x71,
        0x79,
        0x13,
        0x83,
        0x1C,
    ],
    "EFI_PCI_PLATFORM_PROTOCOL_GUID": [
        0x7D75280,
        0x27D4,
        0x4D69,
        0x90,
        0xD0,
        0x56,
        0x43,
        0xE2,
        0x38,
        0xB3,
        0x41,
    ],
    "EFI_PCI_ROOT_BRIDGE_IO_PROTOCOL_GUID": [
        0x2F707EBB,
        0x4A1A,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PCMCIA_REQUEST_PROTOCOL_GUID": [
        0xF238F47C,
        0x1DE9,
        0x4E8B,
        0x81,
        0xB9,
        0xCC,
        0x92,
        0x4E,
        0x6B,
        0x5B,
        0xE5,
    ],
    "EFI_PC_ANSI_GUID": [
        0xE0C14753,
        0xF9BE,
        0x11D2,
        0x9A,
        0x0C,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PEI_AMI_KEYCODE_PPI_GUID": [
        0x20B0F1C2,
        0xB0D8,
        0x4C5D,
        0xAA,
        0xD9,
        0xF4,
        0x45,
        0x80,
        0xDF,
        0xDF,
        0x8B,
    ],
    "EFI_PEI_APRIORI_FILE_NAME_GUID": [
        0x1B45CC0A,
        0x156A,
        0x428A,
        0xAF,
        0x62,
        0x49,
        0x86,
        0x4D,
        0xA0,
        0xE6,
        0xE6,
    ],
    "EFI_PEI_CAPSULE_PPI_GUID": [
        0x66785B1,
        0xEDB8,
        0x46DC,
        0x84,
        0x2F,
        0x57,
        0x44,
        0x4,
        0xB8,
        0x69,
        0x2F,
    ],
    "EFI_PEI_CMOS_ACCESS_GUID": [
        0xCCBF2786,
        0xCD6C,
        0x4308,
        0xBD,
        0xFA,
        0x62,
        0x58,
        0x70,
        0xCE,
        0xBF,
        0x81,
    ],
    "EFI_PEI_CONSPLIT_AMI_KEYCODE_PPI_GUID": [
        0x73DDB5E1,
        0x5FB4,
        0x4751,
        0xAF,
        0x1E,
        0x83,
        0xCF,
        0x75,
        0xBE,
        0xCB,
        0xB6,
    ],
    "EFI_PEI_CORE_PRIVATE_GUID": [
        0xD641A0F5,
        0xCB7C,
        0x4846,
        0xA3,
        0x80,
        0x1D,
        0x01,
        0xB4,
        0xD9,
        0xE3,
        0xB9,
    ],
    "EFI_PEI_CPU_IO_PPI_INSTALLED_GUID": [
        0xE6AF1F7B,
        0xFC3F,
        0x46DA,
        0xA8,
        0x28,
        0xA3,
        0xB4,
        0x57,
        0xA4,
        0x42,
        0x82,
    ],
    "EFI_PEI_DECOMPRESS_PPI_GUID": [
        0x1A36E4E7,
        0xFAB6,
        0x476A,
        0x8E,
        0x75,
        0x69,
        0x5A,
        0x5,
        0x76,
        0xFD,
        0xD7,
    ],
    "EFI_PEI_DEVICE_RECOVERY_MODULE_PPI_GUID": [
        0x0DE2CE25,
        0x446A,
        0x45A7,
        0xBF,
        0xC9,
        0x37,
        0xDA,
        0x26,
        0x34,
        0x4B,
        0x37,
    ],
    "EFI_PEI_END_OF_PEI_PHASE_PPI_GUID": [
        0x605EA650,
        0xC65C,
        0x42E1,
        0xBA,
        0x80,
        0x91,
        0xA5,
        0x2A,
        0xB6,
        0x18,
        0xC6,
    ],
    "EFI_PEI_FIRMWARE_VOLUME_INFO_PPI_GUID": [
        0x49EDB1C1,
        0xBF21,
        0x4761,
        0xBB,
        0x12,
        0xEB,
        0x0,
        0x31,
        0xAA,
        0xBB,
        0x39,
    ],
    "EFI_PEI_FLUSH_INSTRUCTION_CACHE_GUID": [
        0xD8117CFC,
        0x94A6,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PEI_LOADED_IMAGE_PPI_GUID": [
        0xA62A3FFF,
        0x97F0,
        0x4332,
        0x8C,
        0xFD,
        0x1E,
        0x34,
        0x3D,
        0x36,
        0x31,
        0xF2,
    ],
    "EFI_PEI_LOADED_IMAGE_PPI_GUID": [
        0xC1FCD448,
        0x6300,
        0x4458,
        0xB8,
        0x64,
        0x28,
        0xDF,
        0x01,
        0x53,
        0x64,
        0xBC,
    ],
    "EFI_PEI_LOAD_FILE_GUID": [
        0xB9E0ABFE,
        0x5979,
        0x4914,
        0x97,
        0x7F,
        0x6D,
        0xEE,
        0x78,
        0xC2,
        0x78,
        0xA6,
    ],
    "EFI_PEI_LOAD_FILE_PPI_GUID": [
        0xB9E0ABFE,
        0x5979,
        0x4914,
        0x97,
        0x7F,
        0x6D,
        0xEE,
        0x78,
        0xC2,
        0x78,
        0xA6,
    ],
    "EFI_PEI_PCI_CFG2_PPI_GUID": [
        0x57A449A,
        0x1FDC,
        0x4C06,
        0xBF,
        0xC9,
        0xF5,
        0x3F,
        0x6A,
        0x99,
        0xBB,
        0x92,
    ],
    "EFI_PEI_PCI_CFG2_PPI_GUID": [
        0xE1F2EBA0,
        0xF7B9,
        0x4A26,
        0x86,
        0x20,
        0x13,
        0x12,
        0x21,
        0x64,
        0x2A,
        0x90,
    ],
    "EFI_PEI_PCI_CFG_PPI_INSTALLED_GUID": [
        0xE1F2EBA0,
        0xF7B9,
        0x4A26,
        0x86,
        0x20,
        0x13,
        0x12,
        0x21,
        0x64,
        0x2A,
        0x90,
    ],
    "EFI_PEI_PERFORMANCE_HOB_GUID": [
        0x10F432DE,
        0xDEEC,
        0x4631,
        0x80,
        0xCD,
        0x47,
        0xF6,
        0x5D,
        0x8F,
        0x80,
        0xBB,
    ],
    "EFI_PEI_PE_COFF_LOADER_GUID": [
        0xD8117CFF,
        0x94A6,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PEI_PLATFORMPEI_EXECUTED_PPI_GUID": [
        0x8C72C36E,
        0xDACC,
        0x4E81,
        0x8D,
        0x60,
        0xFF,
        0xA6,
        0x1D,
        0x88,
        0xFF,
        0x54,
    ],
    "EFI_PEI_READ_ONLY_VARIABLE2_PPI_GUID": [
        0x2AB86EF5,
        0xECB5,
        0x4134,
        0xB5,
        0x56,
        0x38,
        0x54,
        0xCA,
        0x1F,
        0xE1,
        0xB4,
    ],
    "EFI_PEI_READ_ONLY_VARIABLE_PPI_GUID": [
        0x3CDC90C6,
        0x13FB,
        0x4A75,
        0x9E,
        0x79,
        0x59,
        0xE9,
        0xDD,
        0x78,
        0xB9,
        0xFA,
    ],
    "EFI_PEI_RECOVERY_MODULE_PPI_GUID": [
        0xFB6D9542,
        0x612D,
        0x4F45,
        0x87,
        0x2F,
        0x5C,
        0xFF,
        0x52,
        0xE9,
        0x3D,
        0xCF,
    ],
    "EFI_PEI_REPORT_PROGRESS_CODE_PPI_GUID": [
        0x229832D3,
        0x7A30,
        0x4B36,
        0xB8,
        0x27,
        0xF4,
        0xC,
        0xB7,
        0xD4,
        0x54,
        0x36,
    ],
    "EFI_PEI_RESET_PPI_GUID": [
        0xEF398D58,
        0x9DFD,
        0x4103,
        0xBF,
        0x94,
        0x78,
        0xC6,
        0xF4,
        0xFE,
        0x71,
        0x2F,
    ],
    "EFI_PEI_RSC_HANDLER_PPI_GUID": [
        0x65D394,
        0x9951,
        0x4144,
        0x82,
        0xA3,
        0xA,
        0xFC,
        0x85,
        0x79,
        0xC2,
        0x51,
    ],
    "EFI_PEI_S3_RESUME2_PPI_GUID": [
        0x6D582DBC,
        0xDB85,
        0x4514,
        0x8F,
        0xCC,
        0x5A,
        0xDF,
        0x62,
        0x27,
        0xB1,
        0x47,
    ],
    "EFI_PEI_SECTION_EXTRACTION_PPI_GUID": [
        0x4F89E208,
        0xE144,
        0x4804,
        0x9E,
        0xC8,
        0x0F,
        0x89,
        0x4F,
        0x7E,
        0x36,
        0xD7,
    ],
    "EFI_PEI_SECURITY2_PPI_GUID": [
        0xDCD0BE23,
        0x9586,
        0x40F4,
        0xB6,
        0x43,
        0x6,
        0x52,
        0x2C,
        0xED,
        0x4E,
        0xDE,
    ],
    "EFI_PEI_STALL_PPI_GUID": [
        0x1F4C6F90,
        0xB06B,
        0x48D8,
        0xA2,
        0x01,
        0xBA,
        0xE5,
        0xF1,
        0xCD,
        0x7D,
        0x56,
    ],
    "EFI_PEI_TEMPORARY_RAM_SUPPORT_PPI_GUID": [
        0xDBE23AA9,
        0xA345,
        0x4B97,
        0x85,
        0xB6,
        0xB2,
        0x26,
        0xF1,
        0x61,
        0x73,
        0x89,
    ],
    "EFI_PEI_TRANSFER_CONTROL_GUID": [
        0xD8117D02,
        0x94A6,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PERFORMANCE_PROTOCOL_GUID": [
        0xFFECFFFF,
        0x923C,
        0x14D2,
        0x9E,
        0x3F,
        0x22,
        0xA0,
        0xC9,
        0x69,
        0x56,
        0x3B,
    ],
    "EFI_PI_MP_SERVICES_PROTOCOL_GUID": [
        0x3FDDA605,
        0xA76E,
        0x4F46,
        0xAD,
        0x29,
        0x12,
        0xF4,
        0x53,
        0x1B,
        0x3D,
        0x08,
    ],
    "EFI_PLATFORM_DRIVER_OVERRIDE_PROTOCOL_GUID": [
        0x6B30C738,
        0xA391,
        0x11D4,
        0x9A,
        0x3B,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PLATFORM_GOP_POLICY_PROTOCOL_GUID": [
        0xEC2E931B,
        0x3281,
        0x48A5,
        0x81,
        0x7,
        0xDF,
        0x8A,
        0x8B,
        0xED,
        0x3C,
        0x5D,
    ],
    "EFI_PLATFORM_INFO_PROTOCOL_GUID": [
        0xD9035175,
        0x8CE2,
        0x47DE,
        0xA8,
        0xB8,
        0xCC,
        0x98,
        0xE5,
        0xE2,
        0xA8,
        0x85,
    ],
    "EFI_PLATFORM_MEMTEST_PROTOCOL_GUID": [
        0x859BA18,
        0x7DD7,
        0x4ED7,
        0xA8,
        0x8E,
        0x10,
        0x9C,
        0x63,
        0x91,
        0x7B,
        0xDD,
    ],
    "EFI_PLATFORM_TO_DRIVER_CONFIGURATION_CLP_GUID": [
        0x345ECC0E,
        0x0CB6,
        0x4B75,
        0xBB,
        0x57,
        0x1B,
        0x12,
        0x9C,
        0x47,
        0x33,
        0x3E,
    ],
    "EFI_PLATFORM_TO_DRIVER_CONFIGURATION_PROTOCOL_GUID": [
        0x642CD590,
        0x8059,
        0x4C0A,
        0xA9,
        0x58,
        0xC5,
        0xEC,
        0x07,
        0xD2,
        0x3C,
        0x4B,
    ],
    "EFI_PLATFORM_TO_DRIVER_CONFIGURATION_PROTOCOL_GUID": [
        0x642CD590,
        0x8059,
        0x4C0A,
        0xA9,
        0x58,
        0xC5,
        0xEC,
        0x7,
        0xD2,
        0x3C,
        0x4B,
    ],
    "EFI_POWER_ON_HOB_GUID": [
        0x468A601,
        0xC535,
        0x46FD,
        0xA9,
        0x5D,
        0xBB,
        0xAB,
        0x99,
        0x1B,
        0x17,
        0x8C,
    ],
    "EFI_PPM_GLOBAL_NVS_AREA_PROTOCOL_GUID": [
        0x6C50CDCB,
        0x7F46,
        0x4DCC,
        0x8D,
        0xDD,
        0xD9,
        0xF0,
        0xA3,
        0xC6,
        0x11,
        0x28,
    ],
    "EFI_PPM_INFO_PROTOCOL_GUID": [
        0xD71DB106,
        0xE32D,
        0x4225,
        0xBF,
        0xF4,
        0xDE,
        0x6D,
        0x77,
        0x87,
        0x17,
        0x61,
    ],
    "EFI_PRIMARY_CONSOLE_IN_DEVICE_GUID": [
        0xE451DCBE,
        0x96A1,
        0x4729,
        0xA5,
        0xCF,
        0x6B,
        0x9C,
        0x2C,
        0xFF,
        0x47,
        0xFD,
    ],
    "EFI_PRIMARY_CONSOLE_OUT_DEVICE_GUID": [
        0x62BDF38A,
        0xE3D5,
        0x492C,
        0x95,
        0xC,
        0x23,
        0xA7,
        0xF6,
        0x6E,
        0x67,
        0x2E,
    ],
    "EFI_PRIMARY_STANDARD_ERROR_DEVICE_GUID": [
        0x5A68191B,
        0x9B97,
        0x4752,
        0x99,
        0x46,
        0xE3,
        0x6A,
        0x5D,
        0xA9,
        0x42,
        0xB1,
    ],
    "EFI_PRINT_PROTOCOL_GUID": [
        0xDF2D868E,
        0x32FC,
        0x4CF0,
        0x8E,
        0x6B,
        0xFF,
        0xD9,
        0x5D,
        0x13,
        0x43,
        0xD0,
    ],
    "EFI_PROCESSOR_PRODUCER_GUID": [
        0x1BF06AEA,
        0x5BEC,
        0x4A8D,
        0x95,
        0x76,
        0x74,
        0x9B,
        0x09,
        0x56,
        0x2D,
        0x30,
    ],
    "EFI_PROCESSOR_SUBCLASS_GUID": [
        0x26FDEB7E,
        0xB8AF,
        0x4CCF,
        0xAA,
        0x97,
        0x02,
        0x63,
        0x3C,
        0xE4,
        0x8C,
        0xA7,
    ],
    "EFI_PS2_POLICY_PROTOCOL_GUID": [
        0x4DF19259,
        0xDC71,
        0x4D46,
        0xBE,
        0xF1,
        0x35,
        0x7B,
        0xB5,
        0x78,
        0xC4,
        0x18,
    ],
    "EFI_PXE_BASE_CODE_CALLBACK_PROTOCOL_GUID": [
        0x245DCA21,
        0xFB7B,
        0x11D3,
        0x8F,
        0x01,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_PXE_BASE_CODE_PROTOCOL_GUID": [
        0x03C4E603,
        0xAC28,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_PXE_DHCP4_CALLBACK_PROTOCOL_GUID": [
        0xC1544C01,
        0x92A4,
        0x4198,
        0x8A,
        0x84,
        0x77,
        0x85,
        0x83,
        0xC2,
        0x36,
        0x21,
    ],
    "EFI_PXE_DHCP4_PROTOCOL_GUID": [
        0x03C4E624,
        0xAC28,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x29,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_REAL_TIME_CLOCK_ARCH_PROTOCOL_GUID": [
        0x27CFAC87,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_RESET_ARCH_PROTOCOL_GUID": [
        0x27CFAC88,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_RESET_ARCH_PROTOCOL_GUID": [
        0x27CFAC88,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_S3_SAVE_STATE_PROTOCOL_GUID": [
        0xE857CAF6,
        0xC046,
        0x45DC,
        0xBE,
        0x3F,
        0xEE,
        0x7,
        0x65,
        0xFB,
        0xA8,
        0x87,
    ],
    "EFI_S3_SMM_SAVE_STATE_PROTOCOL_GUID": [
        0x320AFE62,
        0xE593,
        0x49CB,
        0xA9,
        0xF1,
        0xD4,
        0xC2,
        0xF4,
        0xAF,
        0x1,
        0x4C,
    ],
    "EFI_SAL_SYSTEM_TABLE_GUID": [
        0xEB9D2D32,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_SA_INFO_PROTOCOL_GUID": [
        0x493B5BAC,
        0xBB9E,
        0x4BF5,
        0x83,
        0x79,
        0x20,
        0xE2,
        0xAC,
        0xA9,
        0x85,
        0x41,
    ],
    "EFI_SB_PCIE_ERROR_LOG_DISPATCH_PROTOCOL_GUID": [
        0xF281FC6E,
        0xF4C4,
        0x431C,
        0x96,
        0x2B,
        0x2F,
        0x13,
        0xAE,
        0x79,
        0x84,
        0xEC,
    ],
    "EFI_SCSI_IO_PROTOCOL_GUID": [
        0x932F47E6,
        0x2362,
        0x4002,
        0x80,
        0x3E,
        0x3C,
        0xD5,
        0x4B,
        0x13,
        0x8F,
        0x85,
    ],
    "EFI_SCSI_PASS_THRU_PROTOCOL_GUID": [
        0xA59E8FCF,
        0xBDA0,
        0x43BB,
        0x90,
        0xB1,
        0xD3,
        0x73,
        0x2E,
        0xCA,
        0xA8,
        0x77,
    ],
    "EFI_SECTION_EXTRACTION_PROTOCOL_GUID": [
        0x448F5DA4,
        0x6DD7,
        0x4FE1,
        0x93,
        0x07,
        0x69,
        0x22,
        0x41,
        0x92,
        0x21,
        0x5D,
    ],
    "EFI_SECURITY_ARCH_PROTOCOL_GUID": [
        0xA46423E3,
        0x4617,
        0x49F1,
        0xB9,
        0xFF,
        0xD1,
        0xBF,
        0xA9,
        0x11,
        0x58,
        0x39,
    ],
    "EFI_SECURITY_POLICY_PROTOCOL_GUID": [
        0x78E4D245,
        0xCD4D,
        0x4A05,
        0xA2,
        0xBA,
        0x47,
        0x43,
        0xE8,
        0x6C,
        0xFC,
        0xAB,
    ],
    "EFI_SEC_PLATFORM_INFORMATION_GUID": [
        0x6F8C2B35,
        0xFEF4,
        0x448D,
        0x82,
        0x56,
        0xE1,
        0x1B,
        0x19,
        0xD6,
        0x10,
        0x77,
    ],
    "EFI_SEC_SMI_FLASH_GUID": [
        0x3BF4AF16,
        0xAB7C,
        0x4B43,
        0x89,
        0x8D,
        0xAB,
        0x26,
        0xAC,
        0x5D,
        0xDC,
        0x6C,
    ],
    "EFI_SERIAL_GPIO_PROTOCOL_GUID": [
        0xF52C3858,
        0x5EF8,
        0x4D41,
        0x83,
        0x4E,
        0xC3,
        0x9E,
        0xEF,
        0x8A,
        0x45,
        0xA3,
    ],
    "EFI_SERIAL_IO_PROTOCOL_GUID": [
        0xBB25CF6F,
        0xF1D4,
        0x11D2,
        0x9A,
        0x0C,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0xFD,
    ],
    "EFI_SHELL_FILE_GUID": [
        0xC57AD6B7,
        0x0515,
        0x40A8,
        0x9D,
        0x21,
        0x55,
        0x16,
        0x52,
        0x85,
        0x4E,
        0x37,
    ],
    "EFI_SIMPLE_AUDIO_OUT_PROTOCOL_GUID": [
        0xC723F288,
        0x52F9,
        0x4D80,
        0xB6,
        0x33,
        0xE1,
        0x52,
        0xF9,
        0x30,
        0xA0,
        0xDC,
    ],
    "EFI_SIMPLE_FILE_SYSTEM_PROTOCOL_GUID": [
        0x964E5B22,
        0x6459,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_SIMPLE_NETWORK_PROTOCOL_GUID": [
        0xA19832B9,
        0xAC25,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_SIMPLE_TEXT_INPUT_EX_PROTOCOL_GUID": [
        0xDD9E7534,
        0x7762,
        0x4698,
        0x8C,
        0x14,
        0xF5,
        0x85,
        0x17,
        0xA6,
        0x25,
        0xAA,
    ],
    "EFI_SIMPLE_TEXT_INPUT_PROTOCOL_GUID": [
        0x387477C1,
        0x69C7,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_SIMPLE_TEXT_IN_PROTOCOL_GUID": [
        0x387477C1,
        0x69C7,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_SIMPLE_TEXT_OUT_PROTOCOL_GUID": [
        0x387477C2,
        0x69C7,
        0x11D2,
        0x8E,
        0x39,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_SIO_PROTOCOL_GUID": [
        0x215FDD18,
        0xBD50,
        0x4FEB,
        0x89,
        0xB,
        0x58,
        0xCA,
        0xB,
        0x47,
        0x39,
        0xE9,
    ],
    "EFI_SMBIOS_BOARD_PROTOCOL_GUID": [
        0x903DD14,
        0x2CA0,
        0x458A,
        0xB5,
        0xEB,
        0xC,
        0xC,
        0xA3,
        0xD,
        0x78,
        0x5C,
    ],
    "EFI_SMBIOS_DYNAMIC_DATA_GUID": [
        0xE380280C,
        0x4C35,
        0x4AA3,
        0xB9,
        0x61,
        0x7A,
        0xE4,
        0x89,
        0xA2,
        0xB9,
        0x26,
    ],
    "EFI_SMBIOS_NVRAM_DATA_GUID": [
        0x4B3082A3,
        0x80C6,
        0x4D7E,
        0x9C,
        0xD0,
        0x58,
        0x39,
        0x17,
        0x26,
        0x5D,
        0xF1,
    ],
    "EFI_SMBIOS_PROTOCOL_GUID": [
        0x03583FF6,
        0xCB36,
        0x4940,
        0x94,
        0x7E,
        0xB9,
        0xB3,
        0x9F,
        0x4A,
        0xFA,
        0xF7,
    ],
    "EFI_SMBIOS_PROTOCOL_GUID": [
        0x5E90A50D,
        0x6955,
        0x4A49,
        0x90,
        0x32,
        0xDA,
        0x38,
        0x12,
        0xF8,
        0xE8,
        0xE5,
    ],
    "EFI_SMBIOS_STATIC_DATA_GUID": [
        0xDAF4BF89,
        0xCE71,
        0x4917,
        0xB5,
        0x22,
        0xC8,
        0x9D,
        0x32,
        0xFB,
        0xC5,
        0x9F,
    ],
    "EFI_SMBIOS_TABLE_GUID": [
        0xEB9D2D31,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_SMBUS_ARP_MAP_GUID": [
        0x707BE83E,
        0x0BF6,
        0x40A5,
        0xBE,
        0x64,
        0x34,
        0xC0,
        0x3A,
        0xA0,
        0xB8,
        0xE2,
    ],
    "EFI_SMBUS_HC_PROTOCOL_GUID": [
        0xE49D33ED,
        0x513D,
        0x4634,
        0xB6,
        0x98,
        0x6F,
        0x55,
        0xAA,
        0x75,
        0x1C,
        0x1B,
    ],
    "EFI_SMM_ACCESS_PROTOCOL_GUID": [
        0x3792095A,
        0xE309,
        0x4C1E,
        0xAA,
        0x01,
        0x85,
        0xF5,
        0x65,
        0x5A,
        0x17,
        0xF1,
    ],
    "EFI_SMM_BASE_PROTOCOL_GUID": [
        0x1390954D,
        0xDA95,
        0x4227,
        0x93,
        0x28,
        0x72,
        0x82,
        0xC2,
        0x17,
        0xDA,
        0xA8,
    ],
    "EFI_SMM_BIOS_WRITE_DISPATCH_PROTOCOL_GUID": [
        0xE512DFE4,
        0xBF44,
        0x480D,
        0x9B,
        0x7A,
        0x77,
        0x7B,
        0xB,
        0xE3,
        0x27,
        0x75,
    ],
    "EFI_SMM_CMOS_ACCESS_GUID": [
        0xE5D3026A,
        0x1CA5,
        0x40F0,
        0x8F,
        0xB6,
        0x4B,
        0x1A,
        0xFA,
        0x3C,
        0x6E,
        0xAA,
    ],
    "EFI_SMM_COMMUNICATION_PROTOCOL_GUID": [
        0xC68ED8E2,
        0x9DC6,
        0x4CBD,
        0x9D,
        0x94,
        0xDB,
        0x65,
        0xAC,
        0xC5,
        0xC3,
        0x32,
    ],
    "EFI_SMM_CONTROL_PROTOCOL_GUID": [
        0x8D12E231,
        0xC667,
        0x4FD1,
        0x98,
        0xF2,
        0x24,
        0x49,
        0xA7,
        0xE7,
        0xB2,
        0xE5,
    ],
    "EFI_SMM_CPU_IO2_PROTOCOL_GUID": [
        0x3242A9D8,
        0xCE70,
        0x4AA0,
        0x95,
        0x5D,
        0x5E,
        0x7B,
        0x14,
        0x0D,
        0xE4,
        0xD2,
    ],
    "EFI_SMM_CPU_IO_GUID": [
        0x5F439A0B,
        0x45D8,
        0x4682,
        0xA4,
        0xF4,
        0xF0,
        0x57,
        0x6B,
        0x51,
        0x34,
        0x41,
    ],
    "EFI_SMM_CPU_PROTOCOL_GUID": [
        0xEB346B97,
        0x975F,
        0x4A9F,
        0x8B,
        0x22,
        0xF8,
        0xE9,
        0x2B,
        0xB3,
        0xD5,
        0x69,
    ],
    "EFI_SMM_CPU_SAVE_STATE_PROTOCOL_GUID": [
        0x21F302AD,
        0x6E94,
        0x471B,
        0x84,
        0xBC,
        0xB1,
        0x48,
        0x0,
        0x40,
        0x3A,
        0x1D,
    ],
    "EFI_SMM_GPI_DISPATCH2_PROTOCOL_GUID": [
        0x25566B03,
        0xB577,
        0x4CBF,
        0x95,
        0x8C,
        0xED,
        0x66,
        0x3E,
        0xA2,
        0x43,
        0x80,
    ],
    "EFI_SMM_GPI_DISPATCH_PROTOCOL_GUID": [
        0xE0744B81,
        0x9513,
        0x49CD,
        0x8C,
        0xEA,
        0xE9,
        0x24,
        0x5E,
        0x70,
        0x39,
        0xDA,
    ],
    "EFI_SMM_ICHN_DISPATCH_EX_PROTOCOL_GUID": [
        0x3920405B,
        0xC897,
        0x44DA,
        0x88,
        0xF3,
        0x4C,
        0x49,
        0x8A,
        0x6F,
        0xF7,
        0x36,
    ],
    "EFI_SMM_ICHN_DISPATCH_PROTOCOL_GUID": [
        0xC50B323E,
        0x9075,
        0x4F2A,
        0xAC,
        0x8E,
        0xD2,
        0x59,
        0x6A,
        0x10,
        0x85,
        0xCC,
    ],
    "EFI_SMM_IO_TRAP_DISPATCH2_PROTOCOL_GUID": [
        0x58DC368D,
        0x7BFA,
        0x4E77,
        0xAB,
        0xBC,
        0x0E,
        0x29,
        0x41,
        0x8D,
        0xF9,
        0x30,
    ],
    "EFI_SMM_IO_TRAP_DISPATCH2_PROTOCOL_GUID": [
        0x58DC368D,
        0x7BFA,
        0x4E77,
        0xAB,
        0xBC,
        0xE,
        0x29,
        0x41,
        0x8D,
        0xF9,
        0x30,
    ],
    "EFI_SMM_IO_TRAP_DISPATCH2_PROTOCOL_GUID": [
        0xF1507845,
        0x6494,
        0x4377,
        0xA1,
        0x15,
        0x45,
        0xDF,
        0xE6,
        0x5F,
        0x5D,
        0x71,
    ],
    "EFI_SMM_IO_TRAP_DISPATCH_PROTOCOL_GUID": [
        0x58DC368D,
        0x7BFA,
        0x4E77,
        0xAB,
        0xBC,
        0xE,
        0x29,
        0x41,
        0x8D,
        0xF9,
        0x30,
    ],
    "EFI_SMM_IO_TRAP_DISPATCH_PROTOCOL_GUID": [
        0xBD18369D,
        0xC242,
        0x45CA,
        0x82,
        0xAD,
        0x13,
        0x8A,
        0xC2,
        0xE2,
        0x9B,
        0xAB,
    ],
    "EFI_SMM_IO_TRAP_DISPATCH_PROTOCOL_GUID": [
        0xDB7F536B,
        0xEDE4,
        0x4714,
        0xA5,
        0xC8,
        0xE3,
        0x46,
        0xEB,
        0xAA,
        0x20,
        0x1D,
    ],
    "EFI_SMM_PCI_ROOT_BRIDGE_IO_PROTOCOL_GUID": [
        0x8BC1714D,
        0xFFCB,
        0x41C3,
        0x89,
        0xDC,
        0x6C,
        0x74,
        0xD0,
        0x6D,
        0x98,
        0xEA,
    ],
    "EFI_SMM_PERIODIC_TIMER_DISPATCH2_PROTOCOL_GUID": [
        0x4CEC368E,
        0x8E8E,
        0x4D71,
        0x8B,
        0xE1,
        0x95,
        0x8C,
        0x45,
        0xFC,
        0x8A,
        0x53,
    ],
    "EFI_SMM_PERIODIC_TIMER_DISPATCH_PROTOCOL_GUID": [
        0x9CCA03FC,
        0x4C9E,
        0x4A19,
        0x9B,
        0x6,
        0xED,
        0x7B,
        0x47,
        0x9B,
        0xDE,
        0x55,
    ],
    "EFI_SMM_POWER_BUTTON_DISPATCH2_PROTOCOL_GUID": [
        0x1B1183FA,
        0x1823,
        0x46A7,
        0x88,
        0x72,
        0x9C,
        0x57,
        0x87,
        0x55,
        0x40,
        0x9D,
    ],
    "EFI_SMM_POWER_BUTTON_DISPATCH_PROTOCOL_GUID": [
        0xB709EFA0,
        0x47A6,
        0x4B41,
        0xB9,
        0x31,
        0x12,
        0xEC,
        0xE7,
        0xA8,
        0xEE,
        0x56,
    ],
    "EFI_SMM_RC_TO_APTIO_BRIDGE_GUID": [
        0xFCDF7788,
        0x7878,
        0x11FF,
        0xCC,
        0x77,
        0x88,
        0xCC,
        0xCC,
        0x77,
        0x88,
        0xCC,
    ],
    "EFI_SMM_READY_TO_LOCK_PROTOCOL_GUID": [
        0x47B7FA8C,
        0xF4BD,
        0x4AF6,
        0x82,
        0x00,
        0x33,
        0x30,
        0x86,
        0xF0,
        0xD2,
        0xC8,
    ],
    "EFI_SMM_RSC_HANDLER_PROTOCOL_GUID": [
        0x2FF29FA7,
        0x5E80,
        0x4ED9,
        0xB3,
        0x80,
        0x1,
        0x7D,
        0x3C,
        0x55,
        0x4F,
        0xF4,
    ],
    "EFI_SMM_RUNTIME_PROTOCOL_GUID": [
        0xA56897A1,
        0xA77F,
        0x4600,
        0x84,
        0xDB,
        0x22,
        0xB0,
        0xA8,
        0x1,
        0xFA,
        0x9A,
    ],
    "EFI_SMM_RUNTIME_SERVICES_TABLE_GUID": [
        0x395C33FE,
        0x287F,
        0x413E,
        0xA0,
        0x55,
        0x80,
        0x88,
        0xC0,
        0xE1,
        0xD4,
        0x3E,
    ],
    "EFI_SMM_SMBUS_PROTOCOL_GUID": [
        0x72E40094,
        0x2EE1,
        0x497A,
        0x8F,
        0x33,
        0x4C,
        0x93,
        0x4A,
        0x9E,
        0x9C,
        0xC,
    ],
    "EFI_SMM_SPI_PROTOCOL_GUID": [
        0xD9072C35,
        0xEB8F,
        0x43AD,
        0xA2,
        0x20,
        0x34,
        0xD4,
        0x0E,
        0x2A,
        0x82,
        0x85,
    ],
    "EFI_SMM_SPI_PROTOCOL_GUID": [
        0xAFF3BE49,
        0x6D71,
        0x421C,
        0x92,
        0x77,
        0xA0,
        0xB1,
        0x50,
        0x8E,
        0x84,
        0x7D,
    ],
    "EFI_SMM_STANDBY_BUTTON_DISPATCH2_PROTOCOL_GUID": [
        0x7300C4A1,
        0x43F2,
        0x4017,
        0xA5,
        0x1B,
        0xC8,
        0x1A,
        0x7F,
        0x40,
        0x58,
        0x5B,
    ],
    "EFI_SMM_STANDBY_BUTTON_DISPATCH_PROTOCOL_GUID": [
        0x78965B98,
        0xB0BF,
        0x449E,
        0x8B,
        0x22,
        0xD2,
        0x91,
        0x4E,
        0x49,
        0x8A,
        0x98,
    ],
    "EFI_SMM_STATUS_CODE_PROTOCOL_GUID": [
        0x6AFD2B77,
        0x98C1,
        0x4ACD,
        0xA6,
        0xF9,
        0x8A,
        0x94,
        0x39,
        0xDE,
        0xF,
        0xB1,
    ],
    "EFI_SMM_SW_DISPATCH2_PROTOCOL_GUID": [
        0x18A3C6DC,
        0x5EEA,
        0x48C8,
        0xA1,
        0xC1,
        0xB5,
        0x33,
        0x89,
        0xF9,
        0x89,
        0x99,
    ],
    "EFI_SMM_SW_DISPATCH_PROTOCOL_GUID": [
        0xE541B773,
        0xDD11,
        0x420C,
        0xB0,
        0x26,
        0xDF,
        0x99,
        0x36,
        0x53,
        0xF8,
        0xBF,
    ],
    "EFI_SMM_SX_DISPATCH2_PROTOCOL_GUID": [
        0x456D2859,
        0xA84B,
        0x4E47,
        0xA2,
        0xEE,
        0x32,
        0x76,
        0xD8,
        0x86,
        0x99,
        0x7D,
    ],
    "EFI_SMM_TCO_DISPATCH_PROTOCOL_GUID": [
        0xE2D6BB1,
        0xC624,
        0x446D,
        0x99,
        0x82,
        0x69,
        0x3C,
        0xD1,
        0x81,
        0xA6,
        0x7,
    ],
    "EFI_SMM_THUNK_PROTOCOL_GUID": [
        0x2A82FCE6,
        0x8BB6,
        0x413E,
        0xB9,
        0xEB,
        0x45,
        0xDF,
        0xC0,
        0x52,
        0x2D,
        0xF3,
    ],
    "EFI_SMM_USB_DISPATCH2_PROTOCOL_GUID": [
        0xEE9B8D90,
        0xC5A6,
        0x40A2,
        0xBD,
        0xE2,
        0x52,
        0x55,
        0x8D,
        0x33,
        0xCC,
        0xA1,
    ],
    "EFI_SMM_USB_DISPATCH_PROTOCOL_GUID": [
        0xA05B6FFD,
        0x87AF,
        0x4E42,
        0x95,
        0xC9,
        0x62,
        0x28,
        0xB6,
        0x3C,
        0xF3,
        0xF3,
    ],
    "EFI_SMM_VARIABLE_PROTOCOL_GUID": [
        0x3025DA01,
        0xDC5F,
        0x4F59,
        0xBC,
        0xC3,
        0xB3,
        0x77,
        0xC8,
        0x32,
        0x5A,
        0x4A,
    ],
    "EFI_SMRAM_NVS_HEADER_GUID": [
        0xEC7F4FA1,
        0xB217,
        0x42FC,
        0xA7,
        0xF7,
        0x2,
        0xC,
        0x43,
        0x5,
        0xD5,
        0xBA,
    ],
    "EFI_SMTP_PROTOCOL_GUID": [
        0x5F67D40C,
        0x1D06,
        0x4E3E,
        0x8B,
        0x4A,
        0xD2,
        0x71,
        0x3F,
        0x46,
        0xE1,
        0xDC,
    ],
    "EFI_SPEAKER_INTERFACE_PROTOCOL_GUID": [
        0x400B4476,
        0x3081,
        0x11D6,
        0x87,
        0xED,
        0x00,
        0x06,
        0x29,
        0x45,
        0xC3,
        0xB9,
    ],
    "EFI_SPI_PROTOCOL_GUID": [
        0x1156EFC6,
        0xEA32,
        0x4396,
        0xB5,
        0xD5,
        0x26,
        0x93,
        0x2E,
        0x83,
        0xC3,
        0x13,
    ],
    "EFI_SPI_PROTOCOL_GUID": [
        0x1A660D9,
        0x8009,
        0x4330,
        0xBA,
        0x89,
        0x71,
        0xB0,
        0x76,
        0xCD,
        0x5D,
        0xA,
    ],
    "EFI_STANDARD_CALLER_ID_GUID": [
        0xC9DCF469,
        0xA7C4,
        0x11D5,
        0x87,
        0xDA,
        0x00,
        0x06,
        0x29,
        0x45,
        0xC3,
        0xB9,
    ],
    "EFI_STANDARD_ERROR_DEVICE_GUID": [
        0xD3B36F2D,
        0xD551,
        0x11D4,
        0x9A,
        0x46,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_STATUS_CODE_ARCH_PROTOCOL_GUID": [
        0xD98E3EA3,
        0x6F39,
        0x4BE4,
        0x82,
        0xCE,
        0x5A,
        0x89,
        0x0C,
        0xCB,
        0x2C,
        0x95,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_ASSERT_GUID": [
        0xDA571595,
        0x4D99,
        0x487C,
        0x82,
        0x7C,
        0x26,
        0x22,
        0x67,
        0x7D,
        0x33,
        0x07,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_DEBUG_GUID": [
        0x9A4E9246,
        0xD553,
        0x11D5,
        0x87,
        0xE2,
        0x00,
        0x06,
        0x29,
        0x45,
        0xC3,
        0xB9,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_ERROR_GUID": [
        0xAB359CE3,
        0x99B3,
        0xAE18,
        0xC8,
        0x9D,
        0x95,
        0xD3,
        0xB0,
        0x72,
        0xE1,
        0x9B,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_EXCEPTION_HANDLER_GUID": [
        0x3BC2BD12,
        0xAD2E,
        0x11D5,
        0x87,
        0xDD,
        0x00,
        0x06,
        0x29,
        0x45,
        0xC3,
        0xB9,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_PROGRESS_CODE_GUID": [
        0xA356AB39,
        0x35C4,
        0x35DA,
        0xB3,
        0x7A,
        0xF8,
        0xEA,
        0x9E,
        0x8B,
        0x36,
        0xA3,
    ],
    "EFI_STATUS_CODE_DATA_TYPE_STRING_GUID": [
        0x92D11080,
        0x496F,
        0x4D95,
        0xBE,
        0x7E,
        0x03,
        0x74,
        0x88,
        0x38,
        0x2B,
        0x0A,
    ],
    "EFI_STATUS_CODE_GUID": [
        0xD083E94C,
        0x6560,
        0x42E4,
        0xB6,
        0xD4,
        0x2D,
        0xF7,
        0x5A,
        0xDF,
        0x6A,
        0x2A,
    ],
    "EFI_STATUS_CODE_SPECIFIC_DATA_GUID": [
        0x335984BD,
        0xE805,
        0x409A,
        0xB8,
        0xF8,
        0xD2,
        0x7E,
        0xCE,
        0x5F,
        0xF7,
        0xA6,
    ],
    "EFI_STORAGE_SECURITY_COMMAND_PROTOCOL_GUID": [
        0xC88B0B6D,
        0x0DFC,
        0x49A7,
        0x9C,
        0xB4,
        0x49,
        0x7,
        0x4B,
        0x4C,
        0x3A,
        0x78,
    ],
    "EFI_SWAP_ADDRESS_RANGE_PROTOCOL_GUID": [
        0x1259F60D,
        0xB754,
        0x468E,
        0xA7,
        0x89,
        0x4D,
        0xB8,
        0x5D,
        0x55,
        0xE8,
        0x7E,
    ],
    "EFI_SYSTEM_NV_DATA_FV_GUID": [
        0xFFF12B8D,
        0x7696,
        0x4C8B,
        0xA9,
        0x85,
        0x27,
        0x47,
        0x7,
        0x5B,
        0x4F,
        0x50,
    ],
    "EFI_SYSTEM_NV_DATA_HOB_GUID": [
        0xD6E5092D,
        0xC7B2,
        0x4872,
        0xAF,
        0x66,
        0xFD,
        0xC0,
        0xE6,
        0xF9,
        0x5E,
        0x78,
    ],
    "EFI_SYSTEM_TYPE_FRU_GUID": [
        0xAAB16018,
        0x679D,
        0x4461,
        0xBA,
        0x20,
        0xE7,
        0xC,
        0xF7,
        0x86,
        0x6A,
        0x9B,
    ],
    "EFI_TAPE_IO_PROTOCOL_GUID": [
        0x1E93E633,
        0xD65A,
        0x459E,
        0xAB,
        0x84,
        0x93,
        0xD9,
        0xEC,
        0x26,
        0x6D,
        0x18,
    ],
    "EFI_TCG_LOG_HOB_GUID": [
        0x5F7D4E0E,
        0x3D6D,
        0x42BC,
        0xA9,
        0x42,
        0xE,
        0x91,
        0xE8,
        0x3E,
        0x3C,
        0x31,
    ],
    "EFI_TCG_PEI_READ_ONLY_VARIABLE_PPI_GUID": [
        0x3CDC90C6,
        0x13FB,
        0x4A75,
        0x9E,
        0x79,
        0x59,
        0xE9,
        0xDD,
        0x78,
        0xB9,
        0xFA,
    ],
    "EFI_TCG_PLATFORM_PROTOCOL_GUID": [
        0x8C4C9A41,
        0xBF56,
        0x4627,
        0x9E,
        0xA,
        0xC8,
        0x38,
        0x6D,
        0x66,
        0x11,
        0x5C,
    ],
    "EFI_TCG_PRIVATE_INTERFACE_GUID": [
        0x8C4C9A41,
        0xBF56,
        0x4627,
        0x9E,
        0xA,
        0xC8,
        0x38,
        0x6D,
        0x66,
        0x11,
        0x5C,
    ],
    "EFI_TCG_PROTOCOL_GUID": [
        0xF541796D,
        0xA62E,
        0x4954,
        0xA7,
        0x75,
        0x95,
        0x84,
        0xF6,
        0x1B,
        0x9C,
        0xDD,
    ],
    "EFI_TCG_WAKE_EVENT_DATA_HOB_GUID": [
        0xBBB810BB,
        0x5EF0,
        0x4E8F,
        0xB2,
        0x98,
        0xAD,
        0x74,
        0xAA,
        0x50,
        0xEF,
        0x0A,
    ],
    "EFI_TCP4_PROTOCOL_GUID": [
        0x65530BC7,
        0xA359,
        0x410F,
        0xB0,
        0x10,
        0x5A,
        0xAD,
        0xC7,
        0xEC,
        0x2B,
        0x62,
    ],
    "EFI_TCP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0x00720665,
        0x67EB,
        0x4A99,
        0xBA,
        0xF7,
        0xD3,
        0xC3,
        0x3A,
        0x1C,
        0x7C,
        0xC9,
    ],
    "EFI_TCP_PROTOCOL_GUID": [
        0x02B3D5F2,
        0xAC28,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_TCP_SOCK_PROTOCOL_GUID": [
        0x5187359B,
        0x790D,
        0x425B,
        0xA5,
        0x93,
        0xCA,
        0x1C,
        0xDB,
        0x3C,
        0xEB,
        0xAD,
    ],
    "EFI_TDT_PROTOCOL_GUID": [
        0xBF70067,
        0xD53B,
        0x42DF,
        0xB7,
        0x70,
        0xE9,
        0x2C,
        0x91,
        0xC6,
        0x14,
        0x11,
    ],
    "EFI_TELNET_SERVER_PROTOCOL_GUID": [
        0x6D3569D4,
        0x85E5,
        0x4943,
        0xAE,
        0x46,
        0xEE,
        0x67,
        0xA6,
        0xE1,
        0xAB,
        0x5A,
    ],
    "EFI_TIANO_DECOMPRESS_PROTOCOL_GUID": [
        0xE84CF29C,
        0x191F,
        0x4EAE,
        0x96,
        0xE1,
        0xF4,
        0x6A,
        0xEC,
        0xEA,
        0xEA,
        0x0B,
    ],
    "EFI_TIMER_ARCH_PROTOCOL_GUID": [
        0x26BACCB3,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_TIMER_ARCH_PROTOCOL_GUID": [
        0x26BACCB3,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x00,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_TIME_VARIABLE_GUID": [
        0x9D0DA369,
        0x540B,
        0x46F8,
        0x85,
        0xA0,
        0x2B,
        0x5F,
        0x2C,
        0x30,
        0x1E,
        0x15,
    ],
    "EFI_TPM_DEVICE_PROTOCOL_GUID": [
        0xDE161CFE,
        0x1E60,
        0x42A1,
        0x8C,
        0xC3,
        0xEE,
        0x7E,
        0xF0,
        0x73,
        0x52,
        0x12,
    ],
    "EFI_TPM_STATE_INIT_HUB_GUID": [
        0xA0C6D918,
        0x8DEE,
        0x41BB,
        0x9D,
        0x92,
        0x67,
        0x53,
        0xA5,
        0x72,
        0xB6,
        0x52,
    ],
    "EFI_TXT_INFO_PROTOCOL_GUID": [
        0x601211DC,
        0x0B12,
        0x4C09,
        0xAE,
        0x27,
        0xAB,
        0xE,
        0xC9,
        0x69,
        0x24,
        0x68,
    ],
    "EFI_UDP4_PROTOCOL_GUID": [
        0x3AD9DF29,
        0x4501,
        0x478D,
        0xB1,
        0xF8,
        0x7F,
        0x7F,
        0xE7,
        0x0E,
        0x50,
        0xF3,
    ],
    "EFI_UDP4_SERVICE_BINDING_PROTOCOL_GUID": [
        0x83F01464,
        0x99BD,
        0x45E5,
        0xB3,
        0x83,
        0xAF,
        0x63,
        0x05,
        0xD8,
        0xE9,
        0xE6,
    ],
    "EFI_UDP_PROTOCOL_GUID": [
        0xC56FB1B2,
        0x017B,
        0x4984,
        0xA3,
        0xF6,
        0x3F,
        0x73,
        0x4F,
        0xFA,
        0x9E,
        0x33,
    ],
    "EFI_UGA_DRAW_PROTOCOL_GUID": [
        0x982C298B,
        0xF4FA,
        0x41CB,
        0xB8,
        0x38,
        0x77,
        0xAA,
        0x68,
        0x8F,
        0xB8,
        0x39,
    ],
    "EFI_UGA_IO_PROTOCOL_GUID": [
        0x61A4D49E,
        0x6F68,
        0x4F1B,
        0xB9,
        0x22,
        0xA8,
        0x6E,
        0xED,
        0xB,
        0x7,
        0xA2,
    ],
    "EFI_UGA_SPLASH_PROTOCOL_GUID": [
        0xA45B3A0D,
        0x2E55,
        0x4C03,
        0xAD,
        0x9C,
        0x27,
        0xD4,
        0x82,
        0xB,
        0x50,
        0x7E,
    ],
    "EFI_UNICODE_COLLATION2_PROTOCOL_GUID": [
        0xA4C751FC,
        0x23AE,
        0x4C3E,
        0x92,
        0xE9,
        0x49,
        0x64,
        0xCF,
        0x63,
        0xF3,
        0x49,
    ],
    "EFI_UNICODE_COLLATION_PROTOCOL2_GUID": [
        0xA4C751FC,
        0x23AE,
        0x4C3E,
        0x92,
        0xE9,
        0x49,
        0x64,
        0xCF,
        0x63,
        0xF3,
        0x49,
    ],
    "EFI_UNICODE_COLLATION_PROTOCOL_GUID": [
        0x1D85CD7F,
        0xF43D,
        0x11D2,
        0x9A,
        0x0C,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_UNICODE_COLLATION_PROTOCOL_GUID": [
        0x1D85CD7F,
        0xF43D,
        0x11D2,
        0x9A,
        0xC,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_USB2_HC_PROTOCOL_GUID": [
        0x3E745226,
        0x9818,
        0x45B6,
        0xA2,
        0xAC,
        0xD7,
        0xCD,
        0xE,
        0x8B,
        0xA2,
        0xBC,
    ],
    "EFI_USB_ATAPI_PROTOCOL_GUID": [
        0x2B2F68DA,
        0x0CD2,
        0x44CF,
        0x8E,
        0x8B,
        0xBB,
        0xA2,
        0x0B,
        0x1B,
        0x5B,
        0x75,
    ],
    "EFI_USB_HC_PROTOCOL_GUID": [
        0xF5089266,
        0x1AA0,
        0x4953,
        0x97,
        0xD8,
        0x56,
        0x2F,
        0x8A,
        0x73,
        0xB5,
        0x19,
    ],
    "EFI_USB_IO_PROTOCOL_GUID": [
        0x2B2F68D6,
        0x0CD2,
        0x44CF,
        0x8E,
        0x8B,
        0xBB,
        0xA2,
        0x0B,
        0x1B,
        0x5B,
        0x75,
    ],
    "EFI_USB_POLICY_PROTOCOL_GUID": [
        0x5859CB76,
        0x6BEF,
        0x468A,
        0xBE,
        0x2D,
        0xB3,
        0xDD,
        0x1A,
        0x27,
        0xF0,
        0x12,
    ],
    "EFI_USB_PROTOCOL_GUID": [
        0x2AD8E2D2,
        0x2E91,
        0x4CD1,
        0x95,
        0xF5,
        0xE7,
        0x8F,
        0xE5,
        0xEB,
        0xE3,
        0x16,
    ],
    "EFI_USER_CREDENTIAL_PROTOCOL_GUID": [
        0x71EE5E94,
        0x65B9,
        0x45D5,
        0x82,
        0x1A,
        0x3A,
        0x4D,
        0x86,
        0xCF,
        0xE6,
        0xBE,
    ],
    "EFI_USER_INFO_ACCESS_SETUP_ADMIN_GUID": [
        0x85B75607,
        0xF7CE,
        0x471E,
        0xB7,
        0xE4,
        0x2A,
        0xEA,
        0x5F,
        0x72,
        0x32,
        0xEE,
    ],
    "EFI_USER_INFO_ACCESS_SETUP_NORMAL_GUID": [
        0x1DB29AE0,
        0x9DCB,
        0x43BC,
        0x8D,
        0x87,
        0x5D,
        0xA1,
        0x49,
        0x64,
        0xDD,
        0xE2,
    ],
    "EFI_USER_INFO_ACCESS_SETUP_RESTRICTED_GUID": [
        0xBDB38125,
        0x4D63,
        0x49F4,
        0x82,
        0x12,
        0x61,
        0xCF,
        0x5A,
        0x19,
        0x0A,
        0xF8,
    ],
    "EFI_USER_MANAGER_PROTOCOL_GUID": [
        0x6FD5B00C,
        0xD426,
        0x4283,
        0x98,
        0x87,
        0x6C,
        0xF5,
        0xCF,
        0x1C,
        0xB1,
        0xFE,
    ],
    "EFI_VARIABLE_ARCH_PROTOCOL_GUID": [
        0x1E5668E2,
        0x8481,
        0x11D4,
        0xBC,
        0xF1,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_VARIABLE_STORE_PROTOCOL_GUID": [
        0xF088CD91,
        0xA046,
        0x11D2,
        0x8E,
        0x42,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "EFI_VARIABLE_WRITE_ARCH_PROTOCOL_GUID": [
        0x6441F818,
        0x6362,
        0x4E44,
        0xB5,
        0x70,
        0x7D,
        0xBA,
        0x31,
        0xDD,
        0x24,
        0x53,
    ],
    "EFI_VGA_MINI_PORT_PROTOCOL_GUID": [
        0xC7735A2F,
        0x88F5,
        0x4882,
        0xAE,
        0x63,
        0xFA,
        0xAC,
        0x8C,
        0x8B,
        0x86,
        0xB3,
    ],
    "EFI_VIRTUAL_MEMORY_ACCESS_PROTOCOL_GUID": [
        0x745D377A,
        0xB988,
        0x47B2,
        0xB1,
        0x8F,
        0xBB,
        0xC8,
        0xD,
        0xC5,
        0x66,
        0x98,
    ],
    "EFI_VT_100_GUID": [
        0xDFA66065,
        0xB419,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_VT_100_PLUS_GUID": [
        0x7BAEC70B,
        0x57E0,
        0x4C76,
        0x8E,
        0x87,
        0x2F,
        0x9E,
        0x28,
        0x08,
        0x83,
        0x43,
    ],
    "EFI_VT_UTF8_GUID": [
        0xAD15A0D6,
        0x8BEC,
        0x4ACF,
        0xA0,
        0x73,
        0xD0,
        0x1D,
        0xE7,
        0x7E,
        0x2D,
        0x88,
    ],
    "EFI_WATCHDOG_TIMER_ARCH_PROTOCOL_GUID": [
        0x665E3FF5,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_WATCHDOG_TIMER_ARCH_PROTOCOL_GUID": [
        0x665E3FF5,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "EFI_WIN_NT_BUS_DRIVER_IO_PROTOCOL_GUID": [
        0x96EB4AD6,
        0xA32A,
        0x11D4,
        0xBC,
        0xFD,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_SERIAL_PORT_GUID": [
        0xC95A93D,
        0xA006,
        0x11D4,
        0xBC,
        0xFA,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "EFI_WIN_NT_THUNK_PROTOCOL_GUID": [
        0x58C518B1,
        0x76F3,
        0x11D4,
        0xBC,
        0xEA,
        0x0,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "ERROR_MANAGER_GUID": [
        0xADDEBF82,
        0xA560,
        0x46B9,
        0xA2,
        0x80,
        0x78,
        0xC6,
        0xAB,
        0x61,
        0xAE,
        0xDA,
    ],
    "EXIT_FORM_SET_GUID": [
        0xA43B03DC,
        0xC18A,
        0x41B1,
        0x91,
        0xC8,
        0x3F,
        0xF9,
        0xAA,
        0xA2,
        0x57,
        0x13,
    ],
    "EXIT_PAGE_GUID": [
        0xEC87D643,
        0xEBA4,
        0x4BB5,
        0xA1,
        0xE5,
        0x3F,
        0x3E,
        0x36,
        0xB2,
        0x0D,
        0xA9,
    ],
    "FAST_BOOT_TSE_PROTOCOL_GUID": [
        0x0FBA43B8,
        0xACDB,
        0x4EE2,
        0xAB,
        0x31,
        0x0F,
        0xA4,
        0xD5,
        0xB6,
        0xC3,
        0xC5,
    ],
    "FAST_BOOT_VARIABLE_GUID": [
        0xB540A530,
        0x6978,
        0x4DA7,
        0x91,
        0xCB,
        0x72,
        0x7,
        0xD7,
        0x64,
        0xD2,
        0x62,
    ],
    "FID_FFS_SECTION_GUID": [
        0x2EBE0275,
        0x6458,
        0x4AF9,
        0x91,
        0xED,
        0xD3,
        0xF4,
        0xED,
        0xB1,
        0x00,
        0xAA,
    ],
    "FID_TABLE_GUID": [
        0x3FD1D3A2,
        0x99F7,
        0x420B,
        0xBC,
        0x69,
        0x8B,
        0xB1,
        0xD4,
        0x92,
        0xA3,
        0x32,
    ],
    "FID_TABLE_SECTION_GUID": [
        0x2EBE0275,
        0x6458,
        0x4AF9,
        0x91,
        0xED,
        0xD3,
        0xF4,
        0xED,
        0xB1,
        0x00,
        0xAA,
    ],
    "FIRMWARE_PERFORMANCE_PROTOCOL_GUID": [
        0xBC412D75,
        0x2729,
        0x4C3A,
        0xB1,
        0x93,
        0x5B,
        0x9A,
        0x58,
        0x8F,
        0xF6,
        0x6F,
    ],
    "FLASH_PROTOCOL_GUID": [
        0x755B6596,
        0x6896,
        0x4BA3,
        0xB3,
        0xDD,
        0x1C,
        0x62,
        0x9F,
        0xD1,
        0xEA,
        0x88,
    ],
    "FLASH_SMM_PROTOCOL_GUID": [
        0xECB867AB,
        0x8DF4,
        0x492D,
        0x81,
        0x50,
        0xA7,
        0xFD,
        0x1B,
        0x9B,
        0x5A,
        0x75,
    ],
    "FLASH_UPDATE_GUID": [
        0x974231D5,
        0xED4B,
        0x44D1,
        0x88,
        0x70,
        0xCE,
        0x51,
        0x5C,
        0xC1,
        0x4D,
        0x68,
    ],
    "FONT_FFS_FILE_GUID": [
        0xDAC2B117,
        0xB5FB,
        0x4964,
        0xA3,
        0x12,
        0xD,
        0xCC,
        0x77,
        0x6,
        0x1B,
        0x9B,
    ],
    "FPDT_PERFORMANCE_PROTOCOL_GUID": [
        0x444C3203,
        0xF8B1,
        0x42A7,
        0xAB,
        0xE9,
        0x2E,
        0x58,
        0x2,
        0x5B,
        0xE1,
        0x2A,
    ],
    "FRAMEWORK_EFI_FIRMWARE_VOLUME_BLOCK_PROTOCOL_GUID": [
        0xDE28BC59,
        0x6228,
        0x41BD,
        0xBD,
        0xF6,
        0xA3,
        0xB9,
        0xAD,
        0xB5,
        0x8D,
        0xA1,
    ],
    "FW_VERSION_GUID": [
        0xB5C59087,
        0xFEAC,
        0x4B41,
        0x9D,
        0x80,
        0x79,
        0xB,
        0xA5,
        0xAA,
        0x7,
        0xF,
    ],
    "FW_VOLUME_BLOCK_PROTOCOL_GUID": [
        0xDE28BC59,
        0x6228,
        0x41BD,
        0xBD,
        0xF6,
        0xA3,
        0xB9,
        0xAD,
        0xB5,
        0x8D,
        0xA1,
    ],
    "HDD_SECURITY_END_PROTOCOL_GUID": [
        0xAD77AE29,
        0x4C20,
        0x4FDD,
        0x85,
        0x04,
        0x81,
        0x76,
        0x61,
        0x9B,
        0x67,
        0x6A,
    ],
    "HDD_SECURITY_INIT_PROTOCOL_GUID": [
        0xCE6F86BB,
        0xB800,
        0x4C71,
        0xB2,
        0xD1,
        0x38,
        0x97,
        0xA3,
        0xBC,
        0x1D,
        0xAE,
    ],
    "HDD_SMART_INIT_PROTOCOL_GUID": [
        0x9401BD4F,
        0x1A00,
        0x4990,
        0xAB,
        0x56,
        0xDA,
        0xF0,
        0xE4,
        0xE3,
        0x48,
        0xDE,
    ],
    "HDD_UNLOCKED_GUID": [
        0x1FD29BE6,
        0x70D0,
        0x42A4,
        0xA6,
        0xE7,
        0xE5,
        0xD1,
        0xE,
        0x6A,
        0xC3,
        0x76,
    ],
    "HECI_PROTOCOL_GUID": [
        0xCFB33810,
        0x6E87,
        0x4284,
        0xB2,
        0x3,
        0xA6,
        0x6A,
        0xBE,
        0x7,
        0xF6,
        0xE8,
    ],
    "HII_RESOURCES_FFS_SECTION_GUID": [
        0x97E409E6,
        0x4CC1,
        0x11D9,
        0x81,
        0xF6,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    ],
    "HOT_PLUG_DEVICE_GUID": [
        0x220AC432,
        0x1D43,
        0x49E5,
        0xA7,
        0x4F,
        0x4C,
        0x9D,
        0xA6,
        0x7A,
        0xD2,
        0x3B,
    ],
    "ICC_OVERCLOCKING_PROTOCOL_GUID": [
        0x8E8CBC58,
        0x834C,
        0x41E3,
        0xB8,
        0xCA,
        0xF0,
        0x0C,
        0xCF,
        0x5A,
        0x71,
        0x7C,
    ],
    "ICC_PERSISTENT_DATA_GUID": [
        0x64192DCA,
        0xD034,
        0x49D2,
        0xA6,
        0xDE,
        0x65,
        0xA8,
        0x29,
        0xEB,
        0x4C,
        0x74,
    ],
    "ICC_VOLATILE_SETUP_DATA_GUID": [
        0x7B77FB8B,
        0x1E0D,
        0x4D7E,
        0x95,
        0x3F,
        0x39,
        0x80,
        0xA2,
        0x61,
        0xE0,
        0x77,
    ],
    "IDE_BUS_DRIVER_BINDING_PROTOCOL_GUID": [
        0x8AA67071,
        0x8BEC,
        0x47AB,
        0x83,
        0xC8,
        0xCD,
        0x0E,
        0xB7,
        0x23,
        0xD0,
        0x72,
    ],
    "IDE_BUS_INIT_PROTOCOL_GUID": [
        0xE159A956,
        0x3299,
        0x4EE9,
        0x91,
        0x76,
        0x65,
        0x18,
        0x1A,
        0x4E,
        0x5E,
        0x9F,
    ],
    "IDE_CONTROLLER_PROTOCOL_GUID": [
        0x20E28787,
        0xDF32,
        0x4BDA,
        0xB7,
        0xE7,
        0xCB,
        0xBD,
        0xA3,
        0x37,
        0x1E,
        0xF8,
    ],
    "IDE_HPA_INTERFACE_GUID": [
        0x51AA65FC,
        0x82B6,
        0x49E6,
        0x95,
        0xE2,
        0xE6,
        0x82,
        0x7A,
        0x8D,
        0x7D,
        0xB4,
    ],
    "IDE_POWER_MGMT_INTERFACE_GUID": [
        0x67BC3883,
        0x7E79,
        0x4BC1,
        0xA3,
        0x3E,
        0x3A,
        0xF7,
        0xD1,
        0x75,
        0x89,
        0xBA,
    ],
    "IDE_SECURITY_INTERFACE_GUID": [
        0xF4F63529,
        0x281E,
        0x4040,
        0xA3,
        0x13,
        0xC1,
        0xD6,
        0x76,
        0x63,
        0x84,
        0xBE,
    ],
    "IDE_SECURITY_PWNV_GUID": [
        0x69967A8C,
        0x1159,
        0x4522,
        0xAA,
        0x89,
        0x74,
        0xCD,
        0xC6,
        0xE5,
        0x99,
        0xA0,
    ],
    "IDE_SETUP_PROTOCOL_GUID": [
        0x5578AE16,
        0xF1C9,
        0x4E8F,
        0xB1,
        0x29,
        0xBA,
        0x7,
        0xF8,
        0xFC,
        0xF8,
        0x4A,
    ],
    "IDE_SMART_INTERFACE_GUID": [
        0xFFBD9AD2,
        0xF1DB,
        0x4F92,
        0xA6,
        0x49,
        0xEB,
        0x9E,
        0xED,
        0xEA,
        0x86,
        0xB5,
    ],
    "IFFS_ACPI_TABLE_STORAGE_GUID": [
        0x60AC3A8F,
        0x4D66,
        0x4CD4,
        0x89,
        0x5A,
        0xC3,
        0xF0,
        0x6E,
        0x66,
        0x65,
        0xEE,
    ],
    "IFFS_GLOBAL_NVS_AREA_PROTOCOL_GUID": [
        0xA5559F06,
        0x6415,
        0x4759,
        0x88,
        0x69,
        0xDE,
        0x15,
        0xF9,
        0xCD,
        0x9C,
        0x9B,
    ],
    "IFFS_GPT_GUID": [
        0xD3BFE2DE,
        0x3DAF,
        0x11DF,
        0xBA,
        0x40,
        0xE3,
        0xA5,
        0x56,
        0xD8,
        0x95,
        0x93,
    ],
    "IFFS_INFO_PROTOCOL_GUID": [
        0xD231DB5B,
        0x4A9C,
        0x4092,
        0xA8,
        0xC5,
        0x9C,
        0xA0,
        0xBC,
        0x7D,
        0x6A,
        0xA6,
    ],
    "IFFS_PARTITION_STATUS_PROTOCOL_GUID": [
        0x65639144,
        0xD492,
        0x4328,
        0xA4,
        0x98,
        0xF4,
        0xB5,
        0x54,
        0x5E,
        0x4A,
        0x30,
    ],
    "IFFS_PERSISTENT_DATA_GUID": [
        0xF9F0B131,
        0xF346,
        0x4F16,
        0x80,
        0xDD,
        0xF9,
        0x41,
        0x07,
        0x2B,
        0x3A,
        0x7D,
    ],
    "IFFS_PLATFORM_POLICY_PROTOCOL_GUID": [
        0x42BBACA3,
        0x7161,
        0x4891,
        0xAC,
        0x10,
        0xC7,
        0x5E,
        0x2E,
        0x4D,
        0xF6,
        0x14,
    ],
    "IFFS_PPI_GUID": [
        0x3D0E663A,
        0xDC72,
        0x4489,
        0x87,
        0xC5,
        0xE4,
        0x9E,
        0xE7,
        0x73,
        0xA4,
        0x52,
    ],
    "IGD_OPREGION_PROTOCOL_GUID": [
        0xCDC5DDDF,
        0xE79D,
        0x41EC,
        0xA9,
        0xB0,
        0x65,
        0x65,
        0x49,
        0xD,
        0xB9,
        0xD3,
    ],
    "INTEL_MEBX_PROTOCOL_GUID": [
        0x01AB1829,
        0xCECD,
        0x4CFA,
        0xA1,
        0x8C,
        0xEA,
        0x75,
        0xD6,
        0x6F,
        0x3E,
        0x74,
    ],
    "LEGACY_DEV_ORDER_GUID": [
        0xA56074DB,
        0x65FE,
        0x45F7,
        0xBD,
        0x21,
        0x2D,
        0x2B,
        0xDD,
        0x8E,
        0x96,
        0x52,
    ],
    "LOAD_FILE_PROTOCOL_GUID": [
        0x56EC3091,
        0x954C,
        0x11D2,
        0x8E,
        0x3F,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "MAIN_FORM_SET_GUID": [
        0x985EEE91,
        0xBCAC,
        0x4238,
        0x87,
        0x78,
        0x57,
        0xEF,
        0xDC,
        0x93,
        0xF2,
        0x4E,
    ],
    "MDES_STATUS_CODE_PROTOCOL_GUID": [
        0xE5D0875A,
        0xF647,
        0x4E16,
        0xBE,
        0x4D,
        0x95,
        0x02,
        0x40,
        0x29,
        0xCC,
        0x44,
    ],
    "MEBX_FILE_GUID": [
        0x7C81C66A,
        0x4F11,
        0x47AB,
        0x82,
        0xD3,
        0x67,
        0xC4,
        0xD6,
        0x35,
        0xAE,
        0xD1,
    ],
    "MEMORY_ONLY_RESET_CONTROL_GUID": [
        0xE20939BE,
        0x32D4,
        0x41BE,
        0xA1,
        0x50,
        0x89,
        0x7F,
        0x85,
        0xD4,
        0x98,
        0x29,
    ],
    "MEM_INFO_PROTOCOL_GUID": [
        0x6F20F7C8,
        0xE5EF,
        0x4F21,
        0x8D,
        0x19,
        0xED,
        0xC5,
        0xF0,
        0xC4,
        0x96,
        0xAE,
    ],
    "MEUD_ERROR_GUID": [
        0x732BD39,
        0xD6B0,
        0x4039,
        0xB6,
        0xC2,
        0x96,
        0x54,
        0x46,
        0x6D,
        0xE5,
        0x25,
    ],
    "MEUD_FILE_GUID": [
        0xFEAAA7A6,
        0xCB95,
        0x4670,
        0xB4,
        0x99,
        0x87,
        0x7F,
        0xA6,
        0xCA,
        0x6B,
        0xAE,
    ],
    "ME_ALERT_AT_HANDLER_GUID": [
        0xB441DF87,
        0x8D94,
        0x4811,
        0x85,
        0xF7,
        0xF,
        0x9A,
        0x7B,
        0xF8,
        0x9D,
        0x2A,
    ],
    "ME_BIOS_PAYLOAD_DATA_PROTOCOL_GUID": [
        0x71A19494,
        0x2AB6,
        0x4E96,
        0x85,
        0x81,
        0xCF,
        0x34,
        0x25,
        0x42,
        0x73,
        0xFE,
    ],
    "ME_INFO_SETUP_GUID": [
        0x78259433,
        0x7B6D,
        0x4DB3,
        0x9A,
        0xE8,
        0x36,
        0xC4,
        0xC2,
        0xC3,
        0xA1,
        0x7D,
    ],
    "ME_PLATFORM_GET_RESET_TYPE_GUID": [
        0xB8CDCED7,
        0xBDC4,
        0x4464,
        0x9A,
        0x1A,
        0xFF,
        0x3F,
        0xBD,
        0xF7,
        0x48,
        0x69,
    ],
    "MICROCODE_LOADER_PPI_GUID": [
        0x9B6EECF6,
        0xFBDC,
        0x4DB6,
        0x95,
        0x62,
        0xD2,
        0x5F,
        0x40,
        0xD5,
        0x76,
        0x61,
    ],
    "MINI_SETUP_RESOURCE_SECTION_GUID": [
        0x97E409E6,
        0x4CC1,
        0x11D9,
        0x81,
        0xF6,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
        0x0,
    ],
    "MXM30_PEI_GUID": [
        0x2EF1BA1A,
        0xC836,
        0x4A50,
        0xBF,
        0x89,
        0x52,
        0x5F,
        0xF2,
        0x9F,
        0xF7,
        0x87,
    ],
    "MXM3_EFI_GUID": [
        0x4EA9D4FE,
        0xE6F6,
        0x410B,
        0x90,
        0x37,
        0x0F,
        0x98,
        0xB5,
        0x96,
        0x8B,
        0x65,
    ],
    "MXMOEM1_GUID": [
        0x6707536E,
        0x46AF,
        0x42D3,
        0x8F,
        0x6C,
        0x15,
        0xF2,
        0xF2,
        0x2,
        0xC2,
        0x34,
    ],
    "NBCI_EFI_GUID": [
        0x4EA9D4FE,
        0xE6F6,
        0x410B,
        0x80,
        0x37,
        0x0F,
        0x98,
        0xB5,
        0x96,
        0x8B,
        0x65,
    ],
    "NETWORK_STACK_GUID": [
        0xD1405D16,
        0x7AFC,
        0x4695,
        0xBB,
        0x12,
        0x41,
        0x45,
        0x9D,
        0x36,
        0x95,
        0xA2,
    ],
    "NVRAM_HOB_GUID": [
        0xC0EC00FD,
        0xC2F8,
        0x4E47,
        0x90,
        0xEF,
        0x9C,
        0x81,
        0x55,
        0x28,
        0x5B,
        0xEC,
    ],
    "NVRAM_MAILBOX_ADDRESS_VARIABLE_GUID": [
        0x54913A6D,
        0xF4EE,
        0x4CDB,
        0x84,
        0x75,
        0x74,
        0x6,
        0x2B,
        0xFC,
        0xEC,
        0xF5,
    ],
    "OEM_RECOVERY_CAPSULE_GUID": [
        0x595A6EDC,
        0x6D2C,
        0x474A,
        0x90,
        0x82,
        0x3B,
        0x99,
        0x28,
        0x51,
        0xDF,
        0xFE,
    ],
    "OEM_ROM_HOLE_0_GUID": [
        0x05CA01FC,
        0x0FC1,
        0x11DC,
        0x90,
        0x11,
        0x00,
        0x17,
        0x31,
        0x53,
        0xEB,
        0xA8,
    ],
    "OEM_ROM_HOLE_1_GUID": [
        0x05CA01FD,
        0x0FC1,
        0x11DC,
        0x90,
        0x11,
        0x00,
        0x17,
        0x31,
        0x53,
        0xEB,
        0xA8,
    ],
    "OEM_TSE_VAR_GUID": [
        0xF4B2C007,
        0x94A1,
        0x4CD5,
        0xA7,
        0x10,
        0xF4,
        0x14,
        0x1F,
        0xCE,
        0xBC,
        0xA0,
    ],
    "ONBOARD_RAID_GUID": [
        0x5D206DD3,
        0x516A,
        0x47DC,
        0xA1,
        0xBC,
        0x6D,
        0xA2,
        0x4,
        0xAA,
        0xBE,
        0x8,
    ],
    "OPAL_SEC_INIT_PROTOCOL_GUID": [
        0x59AF16B0,
        0x661D,
        0x4865,
        0xA3,
        0x81,
        0x38,
        0xDE,
        0x68,
        0x38,
        0x5D,
        0x8D,
    ],
    "OPROM_START_END_PROTOCOL_GUID": [
        0xF2A128FF,
        0x257B,
        0x456E,
        0x9D,
        0xE8,
        0x63,
        0xE7,
        0xC7,
        0xDC,
        0xDF,
        0xAC,
    ],
    "PARTITION_VARIABLE_GUID": [
        0x8DB699CC,
        0xBC81,
        0x41E2,
        0xAA,
        0xC6,
        0xD8,
        0x1D,
        0x53,
        0x0,
        0xD7,
        0x59,
    ],
    "PASSWORD_HOB_GUID": [
        0x79CE097A,
        0x91AA,
        0x41FF,
        0xB3,
        0xA8,
        0x53,
        0x45,
        0x59,
        0xB3,
        0x0D,
        0xB1,
    ],
    "PCH_DMI_TC_VC_PPI_GUID": [
        0xED097352,
        0x9041,
        0x445A,
        0x80,
        0xB6,
        0xB2,
        0x9D,
        0x50,
        0x9E,
        0x88,
        0x45,
    ],
    "PCH_EFI_RAID_DRIVER_EXECUTION_GUID": [
        0x99D5757C,
        0xD906,
        0x11E0,
        0x8D,
        0x78,
        0x8D,
        0xE4,
        0x48,
        0x24,
        0x01,
        0x9B,
    ],
    "PCH_INIT_PPI_GUID": [
        0xE8C7CE14,
        0x1EED,
        0x48FD,
        0x83,
        0x47,
        0x8E,
        0x55,
        0x41,
        0x10,
        0xC0,
        0xD9,
    ],
    "PCH_INIT_VARIABLE_GUID": [
        0xE6C2F70A,
        0xB604,
        0x4877,
        0x85,
        0xBA,
        0xDE,
        0xEC,
        0x89,
        0xE1,
        0x17,
        0xEB,
    ],
    "PCH_ME_UMA_PPI_GUID": [
        0x8C376010,
        0x2400,
        0x4D7D,
        0xB4,
        0x7B,
        0x9D,
        0x85,
        0x1D,
        0xF3,
        0xC9,
        0xD1,
    ],
    "PCH_PLATFORM_POLICY_PPI_GUID": [
        0x22074E71,
        0xBCCC,
        0x4517,
        0x87,
        0x57,
        0x79,
        0x95,
        0xED,
        0xFD,
        0x80,
        0x32,
    ],
    "PCH_RESET_CALLBACK_PROTOCOL_GUID": [
        0x3A3300AB,
        0xC929,
        0x487D,
        0xAB,
        0x34,
        0x15,
        0x9B,
        0xC1,
        0x35,
        0x62,
        0xC0,
    ],
    "PCH_RESET_PROTOCOL_GUID": [
        0xDB63592C,
        0xB8CC,
        0x44C8,
        0x91,
        0x8C,
        0x51,
        0xF5,
        0x34,
        0x59,
        0x8A,
        0x5A,
    ],
    "PCH_SATA_CONTROLLER_DRIVER_GUID": [
        0xBB929DA9,
        0x68F7,
        0x4035,
        0xB2,
        0x2C,
        0xA3,
        0xBB,
        0x3F,
        0x23,
        0xDA,
        0x55,
    ],
    "PCH_USB_POLICY_PPI_GUID": [
        0xC02B0573,
        0x2B4E,
        0x4A31,
        0xA3,
        0x1A,
        0x94,
        0x56,
        0x7B,
        0x50,
        0x44,
        0x2C,
    ],
    "PEI_AMT_PLATFORM_POLICY_PPI_GUID": [
        0xB4A1208E,
        0x4D9A,
        0x4EA2,
        0x9D,
        0x6B,
        0xE4,
        0x1A,
        0x61,
        0xE6,
        0xC5,
        0xAC,
    ],
    "PEI_AMT_STATUS_CODE_PPI_GUID": [
        0x881807D2,
        0x98D1,
        0x4EC9,
        0xAF,
        0xA0,
        0x77,
        0x46,
        0xC4,
        0x2F,
        0x24,
        0x49,
    ],
    "PEI_AP_STARTUP_FILE_GUID": [
        0xD1E59F50,
        0xE8C3,
        0x4545,
        0xBF,
        0x61,
        0x11,
        0xF0,
        0x02,
        0x23,
        0x3C,
        0x97,
    ],
    "PEI_ATA_CONTROLLER_PPI_GUID": [
        0xA1E2176F,
        0xCBDA,
        0x4F32,
        0x87,
        0x56,
        0x7D,
        0x7A,
        0xE5,
        0x22,
        0xD6,
        0x93,
    ],
    "PEI_ATA_POLICY_PPI_GUID": [
        0x1B8DDEA4,
        0xDEB2,
        0x4152,
        0x91,
        0xC2,
        0xB7,
        0x3C,
        0xB1,
        0x6C,
        0xE4,
        0x64,
    ],
    "PEI_BASE_MEMORY_TEST_GUID": [
        0xB6EC423C,
        0x21D2,
        0x490D,
        0x85,
        0xC6,
        0xDD,
        0x58,
        0x64,
        0xEA,
        0xA6,
        0x74,
    ],
    "PEI_BIOS_ACM_FILE_GUID": [
        0x2D27C618,
        0x7DCD,
        0x41F5,
        0xBB,
        0x10,
        0x21,
        0x16,
        0x6B,
        0xE7,
        0xE1,
        0x43,
    ],
    "PEI_BLOCK_IO_PPI_GUID": [
        0x695D8AA1,
        0x42EE,
        0x4C46,
        0x80,
        0x5C,
        0x6E,
        0xA6,
        0xBC,
        0xE7,
        0x99,
        0xE3,
    ],
    "PEI_BOOT_SCRIPT_DONE_PPI_GUID": [
        0xFD7C4665,
        0x34BE,
        0x426B,
        0xB1,
        0xF8,
        0x3A,
        0xB7,
        0x53,
        0xCE,
        0x44,
        0xB0,
    ],
    "PEI_BOOT_SCRIPT_EXECUTER_PPI_GUID": [
        0xABD42895,
        0x78CF,
        0x4872,
        0x84,
        0x44,
        0x1B,
        0x5C,
        0x18,
        0x0B,
        0xFB,
        0xFF,
    ],
    "PEI_CACHE_PPI_GUID": [
        0x9BE4BC2,
        0x790E,
        0x4DEA,
        0x8B,
        0xDC,
        0x38,
        0x5,
        0x16,
        0x98,
        0x39,
        0x44,
    ],
    "PEI_CACHE_PPI_GUID": [
        0xC153205A,
        0xE898,
        0x4C24,
        0x86,
        0x89,
        0xA4,
        0xB4,
        0xBC,
        0xC5,
        0xC8,
        0xA2,
    ],
    "PEI_CAPSULE_PPI_GUID": [
        0x3ACF33EE,
        0xD892,
        0x40F4,
        0xA2,
        0xFC,
        0x38,
        0x54,
        0xD2,
        0xE1,
        0x32,
        0x3D,
    ],
    "PEI_CPU_IO_PPI_GUID": [
        0xE6AF1F7B,
        0xFC3F,
        0x46DA,
        0xA8,
        0x28,
        0xA3,
        0xB4,
        0x57,
        0xA4,
        0x42,
        0x82,
    ],
    "PEI_CPU_PLATFORM_POLICY_PPI_GUID": [
        0x7B8EE7A1,
        0x4E35,
        0x4556,
        0xBB,
        0x56,
        0x67,
        0x97,
        0xE2,
        0x44,
        0x45,
        0xC2,
    ],
    "PEI_END_OF_PEI_PHASE_PPI_GUID": [
        0x605EA650,
        0xC65C,
        0x42E1,
        0xBA,
        0x80,
        0x91,
        0xA5,
        0x2A,
        0xB6,
        0x18,
        0xC6,
    ],
    "PEI_FLASH_MAP_PPI_GUID": [
        0xF34C2FA0,
        0xDE88,
        0x4270,
        0x84,
        0x14,
        0x96,
        0x12,
        0x22,
        0xF4,
        0x52,
        0x1C,
    ],
    "PEI_HECI_PPI_GUID": [
        0xEE0EA811,
        0xFBD9,
        0x4777,
        0xB9,
        0x5A,
        0xBA,
        0x4F,
        0x71,
        0x10,
        0x1F,
        0x74,
    ],
    "PEI_IDE_RECOVERY_NATIVE_MODE_PPI_GUID": [
        0x7E13637A,
        0xC3F8,
        0x43D1,
        0xB0,
        0x51,
        0xED,
        0x19,
        0xD7,
        0x8,
        0xEC,
        0x7A,
    ],
    "PEI_IFFS_TRANSITION_START_PPI_GUID": [
        0xDE8F2878,
        0x36D5,
        0x498E,
        0xBA,
        0x59,
        0x16,
        0x8C,
        0x26,
        0x47,
        0xB3,
        0x35,
    ],
    "PEI_IN_MEMORY_GUID": [
        0x643B8786,
        0xB417,
        0x48D2,
        0x8F,
        0x5E,
        0x78,
        0x19,
        0x93,
        0x1C,
        0xAE,
        0xD8,
    ],
    "PEI_ME_PLATFORM_POLICY_PPI_GUID": [
        0x7AE3CEB7,
        0x2EE2,
        0x48FA,
        0xAA,
        0x49,
        0x35,
        0x10,
        0xBC,
        0x83,
        0xCA,
        0xBF,
    ],
    "PEI_PCI_CFG_PPI_GUID": [
        0xE1F2EBA0,
        0xF7B9,
        0x4A26,
        0x86,
        0x20,
        0x13,
        0x12,
        0x21,
        0x64,
        0x2A,
        0x90,
    ],
    "PEI_PERMANENT_MEMORY_INSTALLED_PPI_GUID": [
        0xF894643D,
        0xC449,
        0x42D1,
        0x8E,
        0xA8,
        0x85,
        0xBD,
        0xD8,
        0xC6,
        0x5B,
        0xDE,
    ],
    "PEI_PLATFORM_MEMORY_RANGE_PPI_GUID": [
        0x30EB2979,
        0xB0F7,
        0x4D60,
        0xB2,
        0xDC,
        0x1A,
        0x2C,
        0x96,
        0xCE,
        0xB1,
        0xF4,
    ],
    "PEI_PLATFORM_MEMORY_SIZE_PPI_GUID": [
        0x9A7EF41E,
        0xC140,
        0x4BD1,
        0xB8,
        0x84,
        0x1E,
        0x11,
        0x24,
        0xB,
        0x4C,
        0xE6,
    ],
    "PEI_READ_ONLY_VARIABLE_ACCESS_PPI_GUID": [
        0x3CDC90C6,
        0x13FB,
        0x4A75,
        0x9E,
        0x79,
        0x59,
        0xE9,
        0xDD,
        0x78,
        0xB9,
        0xFA,
    ],
    "PEI_RESET_PPI_GUID": [
        0xEF398D58,
        0x9DFD,
        0x4103,
        0xBF,
        0x94,
        0x78,
        0xC6,
        0xF4,
        0xFE,
        0x71,
        0x2F,
    ],
    "PEI_S3_RESUME_PPI_GUID": [
        0x4426CCB2,
        0xE684,
        0x4A8A,
        0xAE,
        0x40,
        0x20,
        0xD4,
        0xB0,
        0x25,
        0xB7,
        0x10,
    ],
    "PEI_SECURITY_PPI_GUID": [
        0x1388066E,
        0x3A57,
        0x4EFA,
        0x98,
        0xF3,
        0xC1,
        0x2F,
        0x3A,
        0x95,
        0x8A,
        0x29,
    ],
    "PEI_SMBUS2_PPI_GUID": [
        0x9CA93627,
        0xB65B,
        0x4324,
        0xA2,
        0x2,
        0xC0,
        0xB4,
        0x61,
        0x76,
        0x45,
        0x43,
    ],
    "PEI_SMBUS_POLICY_PPI_GUID": [
        0x63B6E435,
        0x32BC,
        0x49C6,
        0x81,
        0xBD,
        0xB7,
        0xA1,
        0xA0,
        0xFE,
        0x1A,
        0x6C,
    ],
    "PEI_SMBUS_PPI_GUID": [
        0xABD42895,
        0x78CF,
        0x4872,
        0x84,
        0x44,
        0x1B,
        0x5C,
        0x18,
        0xB,
        0xFB,
        0xDA,
    ],
    "PEI_SMM_ACCESS_PPI_GUID": [
        0x268F33A9,
        0xCCCD,
        0x48BE,
        0x88,
        0x17,
        0x86,
        0x5,
        0x3A,
        0xC3,
        0x2E,
        0xD6,
    ],
    "PEI_SMM_CONTROL_PPI_GUID": [
        0x61C68702,
        0x4D7E,
        0x4F43,
        0x8D,
        0xEF,
        0xA7,
        0x43,
        0x5,
        0xCE,
        0x74,
        0xC5,
    ],
    "PEI_SPI_PPI_GUID": [
        0x64E42E92,
        0xE958,
        0x4E99,
        0x90,
        0xE2,
        0xF7,
        0xFD,
        0x90,
        0xA7,
        0x6C,
        0x59,
    ],
    "PEI_STALL_PPI_GUID": [
        0x1F4C6F90,
        0xB06B,
        0x48D8,
        0xA2,
        0x01,
        0xBA,
        0xE5,
        0xF1,
        0xCD,
        0x7D,
        0x56,
    ],
    "PEI_STATUS_CODE_MEMORY_PPI_GUID": [
        0x26F8AB01,
        0xD3CD,
        0x489C,
        0x98,
        0x4F,
        0xDF,
        0xDE,
        0xF7,
        0x68,
        0x39,
        0x5B,
    ],
    "PEI_STATUS_CODE_PPI_GUID": [
        0x229832D3,
        0x7A30,
        0x4B36,
        0xB8,
        0x27,
        0xF4,
        0xC,
        0xB7,
        0xD4,
        0x54,
        0x36,
    ],
    "PEI_TCG_INTERNAL_FLAGS_GUID": [
        0x70FFF0FF,
        0xA543,
        0x45B9,
        0x8B,
        0xE3,
        0x1B,
        0xDB,
        0x90,
        0x41,
        0x20,
        0x80,
    ],
    "PEI_TCG_PPI_GUID": [
        0x177D39D2,
        0x43B8,
        0x40C8,
        0x9A,
        0xE1,
        0x3C,
        0x51,
        0x98,
        0xD6,
        0x94,
        0x1E,
    ],
    "PEI_TPM_INITIALIZED_PPI_GUID": [
        0xE9DB0D58,
        0xD48D,
        0x47F6,
        0x9C,
        0x6E,
        0x6F,
        0x40,
        0xE8,
        0x6C,
        0x7B,
        0x41,
    ],
    "PEI_TPM_PPI_2_GUID": [
        0xCA4853F4,
        0xE94B,
        0x42B4,
        0x86,
        0x42,
        0xCD,
        0xE2,
        0x8A,
        0x7F,
        0xAC,
        0x2D,
    ],
    "PEI_TPM_PPI_GUID": [
        0xCA4853F4,
        0xE94B,
        0x42B4,
        0x86,
        0x42,
        0xCD,
        0xE2,
        0x8A,
        0x7F,
        0xAC,
        0x2D,
    ],
    "PEI_TPM_PPI_GUID": [
        0xE9DB0D58,
        0xD48D,
        0x47F6,
        0x9C,
        0x6E,
        0x6F,
        0x40,
        0xE8,
        0x6C,
        0x7B,
        0x41,
    ],
    "PEI_TXT_MEMORY_UNLOCKED_PPI_GUID": [
        0x38CDD10B,
        0x767D,
        0x4F6E,
        0xA7,
        0x44,
        0x67,
        0xEE,
        0x1D,
        0xFE,
        0x2F,
        0xA5,
    ],
    "PEI_USB_CONTROLLER_PPI_GUID": [
        0x3BC1F6DE,
        0x693E,
        0x4547,
        0xA3,
        0x0,
        0x21,
        0x82,
        0x3C,
        0xA4,
        0x20,
        0xB2,
    ],
    "PERF_TUNE_PPI_GUID": [
        0xC49189F3,
        0x1D4C,
        0x4AD7,
        0xA4,
        0x39,
        0xD0,
        0x13,
        0xAB,
        0x72,
        0x09,
        0x31,
    ],
    "PERF_TUNE_PROTOCOL_GUID": [
        0xDD6C613A,
        0x5A77,
        0x4B4F,
        0xA6,
        0x1E,
        0x3B,
        0xDD,
        0x2A,
        0xE2,
        0x1D,
        0x81,
    ],
    "PERF_TUNE_WDT_PPI_GUID": [
        0xA7C88FAE,
        0xEBEC,
        0x45ED,
        0xA7,
        0xC5,
        0x5F,
        0xA7,
        0x55,
        0x17,
        0x73,
        0x06,
    ],
    "PERF_TUNE_WDT_PROTOCOL_GUID": [
        0xC0557EED,
        0x9A89,
        0x4770,
        0x96,
        0x26,
        0xFC,
        0xA0,
        0x51,
        0xF2,
        0xBA,
        0x09,
    ],
    "PKPUB_KEY_GUID": [
        0xA6C0E11E,
        0x929E,
        0x42B3,
        0x90,
        0xCC,
        0x4F,
        0x77,
        0x8E,
        0x3,
        0xFF,
        0x57,
    ],
    "PK_PUB_FFS_FILE_EFI_AUTH_VAR_GUID": [
        0x9E625A27,
        0x4840,
        0x47CC,
        0xA6,
        0xB5,
        0x1E,
        0x93,
        0x11,
        0xCF,
        0xC6,
        0x0E,
    ],
    "PLATFORM_IDE_PROTOCOL_GUID": [
        0x6737F69B,
        0xB8CC,
        0x45BC,
        0x93,
        0x27,
        0xCC,
        0xF5,
        0xEE,
        0xF7,
        0xC,
        0xDE,
    ],
    "PLATFORM_ME_HOOK_PPI_GUID": [
        0xE806424F,
        0xD425,
        0x4B1A,
        0xBC,
        0x26,
        0x5F,
        0x69,
        0x03,
        0x89,
        0xA1,
        0x5A,
    ],
    "PLATFORM_ME_HOOK_PROTOCOL_GUID": [
        0xBC52476E,
        0xF67E,
        0x4301,
        0xB2,
        0x62,
        0x36,
        0x9C,
        0x48,
        0x78,
        0xAA,
        0xC2,
    ],
    "POWER_MANAGEMENT_ACPI_TABLE_STORAGE_GUID": [
        0x299141BB,
        0x211A,
        0x48A5,
        0x92,
        0xC0,
        0x6F,
        0x9A,
        0xA,
        0x3A,
        0x0,
        0x6E,
    ],
    "PPM_PLATFORM_POLICY_PROTOCOL_GUID": [
        0x6F27E990,
        0x7BC8,
        0x42C9,
        0x8F,
        0x71,
        0x99,
        0x80,
        0x6,
        0x36,
        0x93,
        0xE9,
    ],
    "PPM_PROCESSOR_SUPPORT_PROTOCOL_3_GUID": [
        0xA60C7DCD,
        0x512F,
        0x4F02,
        0xB1,
        0x80,
        0x52,
        0x2E,
        0x1,
        0x5E,
        0x6,
        0xB7,
    ],
    "PR_KEY_FFS_FILE_RAW_GUID": [
        0x3FEEC852,
        0xF14C,
        0x4E7F,
        0x97,
        0xFD,
        0x4C,
        0x3A,
        0x8C,
        0x5B,
        0xBE,
        0xCC,
    ],
    "PR_KEY_GUID": [
        0x4E0F9BD4,
        0xE338,
        0x4B26,
        0x84,
        0x3E,
        0xBD,
        0x3A,
        0xD9,
        0xB2,
        0x83,
        0x7B,
    ],
    "PTID_FFS_TABLE_STORAGE_GUID": [
        0x95DFCAE5,
        0xBB28,
        0x4D6B,
        0xB1,
        0xE2,
        0x3A,
        0xF3,
        0xA6,
        0xBF,
        0x43,
        0x4F,
    ],
    "RECOVERY_FORM_SET_GUID": [
        0x80E1202E,
        0x2697,
        0x4264,
        0x9C,
        0xC9,
        0x80,
        0x76,
        0x2C,
        0x3E,
        0x58,
        0x63,
    ],
    "ROM_CACHE_ENABLE_PPI_GUID": [
        0x36E835BB,
        0x661D,
        0x4D37,
        0x8D,
        0xE5,
        0x88,
        0x53,
        0x25,
        0xDA,
        0xE9,
        0x10,
    ],
    "ROM_IMAGE_ADDRESS_GUID": [
        0xDDE1BC72,
        0xD45E,
        0x4209,
        0xAB,
        0x85,
        0x14,
        0x46,
        0x2D,
        0x2F,
        0x50,
        0x74,
    ],
    "ROM_IMAGE_MEMORY_HOB_GUID": [
        0xEE2F45D2,
        0x5BA4,
        0x441E,
        0x8A,
        0x1D,
        0xAA,
        0x22,
        0xDF,
        0xA3,
        0xB6,
        0xC5,
    ],
    "ROM_LAYOUT_FFS_GUID": [
        0x0DCA793A,
        0xEA96,
        0x42D8,
        0xBD,
        0x7B,
        0xDC,
        0x7F,
        0x68,
        0x4E,
        0x38,
        0xC1,
    ],
    "ROM_LAYOUT_SECTION_GUID": [
        0x88A15A4F,
        0x977D,
        0x4682,
        0xB1,
        0x7C,
        0xDA,
        0x1F,
        0x31,
        0x6C,
        0x1F,
        0x32,
    ],
    "RSDP_PLUS_PROTOCOL_GUID": [
        0xA33319B5,
        0x8EE1,
        0x45E0,
        0x8C,
        0x9F,
        0x80,
        0x9F,
        0x5B,
        0x9,
        0x2,
        0xCC,
    ],
    "SATA_CONTROLLER_PROTOCOL_GUID": [
        0x2ACB6627,
        0xDF02,
        0x4E23,
        0xB4,
        0xF9,
        0x6A,
        0x93,
        0xFA,
        0x6E,
        0x9D,
        0xA6,
    ],
    "SA_PEG_DATA_HOB_GUID": [
        0x5F5D3502,
        0x8A4B,
        0x40CA,
        0x88,
        0xA2,
        0x23,
        0x05,
        0x42,
        0x7A,
        0x13,
        0x1A,
    ],
    "SA_PEG_DATA_VARIABLE_GUID": [
        0xC4975200,
        0x64F1,
        0x4FB6,
        0x97,
        0x73,
        0xF6,
        0xA9,
        0xF8,
        0x9D,
        0x98,
        0x5E,
    ],
    "SA_PEI_INIT_PPI_GUID": [
        0x9EA8911,
        0xBE0D,
        0x4230,
        0xA0,
        0x3,
        0xED,
        0xC6,
        0x93,
        0xB4,
        0x8E,
        0x11,
    ],
    "SA_PLATFORM_POLICY_PPI_GUID": [
        0x150CE416,
        0xEE63,
        0x46B6,
        0x8B,
        0xA3,
        0x73,
        0x22,
        0xBB,
        0xE0,
        0x46,
        0x37,
    ],
    "SECURITY_FORM_SET_GUID": [
        0x981CEAEE,
        0x931C,
        0x4A17,
        0xB9,
        0xC8,
        0x66,
        0xC7,
        0xBC,
        0xFD,
        0x77,
        0xE1,
    ],
    "SERIAL_RECOVERY_CAPSULE_GUID": [
        0x699ADD70,
        0x8554,
        0x4993,
        0x83,
        0xF6,
        0xD2,
        0xCD,
        0xC0,
        0x81,
        0xDD,
        0x85,
    ],
    "SETUP_DEFAULTS_FFS_GUID": [
        0x9221315B,
        0x30BB,
        0x46B5,
        0x81,
        0x3E,
        0x1B,
        0x1B,
        0xF4,
        0x71,
        0x2B,
        0xD3,
    ],
    "SETUP_GUID": [
        0xEC87D643,
        0xEBA4,
        0x4BB5,
        0xA1,
        0xE5,
        0x3F,
        0x3E,
        0x36,
        0xB2,
        0x0D,
        0xA9,
    ],
    "SGOEM_ACPI_SSDT_GUID": [
        0x5B232086,
        0x350A,
        0x42C7,
        0xA7,
        0x0E,
        0x34,
        0x97,
        0xB5,
        0x76,
        0x5D,
        0x85,
    ],
    "SGTPV_ACPI_SSDT_GUID": [
        0x6A061113,
        0xFE54,
        0x4A07,
        0xA2,
        0x8E,
        0x0A,
        0x69,
        0x35,
        0x9E,
        0xB0,
        0x69,
    ],
    "SG_ACPI_TABLE_STORAGE_GUID": [
        0xCACB3817,
        0x81E6,
        0x497E,
        0x87,
        0xFF,
        0xC8,
        0xFA,
        0x8F,
        0x24,
        0xEC,
        0x28,
    ],
    "SG_INFO_HOB_GUID": [
        0x648CE07B,
        0xAE5D,
        0x4973,
        0xBD,
        0x3C,
        0x8C,
        0x91,
        0x53,
        0xC0,
        0x5D,
        0xC5,
    ],
    "SG_PEI_INIT_PPI_GUID": [
        0xAA40D00E,
        0x5B9B,
        0x4DAD,
        0xA4,
        0x87,
        0xFC,
        0x1B,
        0xCB,
        0xEF,
        0x81,
        0x70,
    ],
    "SG_PLATFORM_POLICY_PPI_GUID": [
        0xA391E822,
        0x7044,
        0x4CF4,
        0xBE,
        0x5B,
        0x34,
        0x5E,
        0x44,
        0xB8,
        0x62,
        0x7C,
    ],
    "SIO_DEV_STATUS_VAR_GUID": [
        0x5820DE98,
        0xFC8E,
        0x4B0B,
        0xA4,
        0xB9,
        0xA,
        0x94,
        0xD,
        0x16,
        0x2A,
        0x7E,
    ],
    "SIO_IO_PROTOCOL_GUID": [
        0x964E5B21,
        0x6000,
        0x23D2,
        0x9E,
        0x39,
        0x1,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "SMBIOS_FLASH_DATA_FFS_GUID": [
        0xFD44820B,
        0xF1AB,
        0x41C0,
        0xAE,
        0x4E,
        0x0C,
        0x55,
        0x55,
        0x6E,
        0xB9,
        0xBD,
    ],
    "SMM_CHILD_DISPATCHER2_GUID": [
        0x950C3A26,
        0xE0C2,
        0x491C,
        0xB6,
        0xB2,
        0x3,
        0x74,
        0xF5,
        0xC7,
        0x3B,
        0x96,
    ],
    "SMM_COMMUNICATE_HEADER_GUID": [
        0xF328E36C,
        0x23B6,
        0x4A95,
        0x85,
        0x4B,
        0x32,
        0xE1,
        0x95,
        0x34,
        0xCD,
        0x75,
    ],
    "SMM_HECI_PROTOCOL_GUID": [
        0xFC9A50C1,
        0x8B3D,
        0x40D0,
        0x99,
        0x12,
        0x6E,
        0x26,
        0xD7,
        0x89,
        0x6C,
        0xBA,
    ],
    "SMRAM_CPU_DATA_HEADER_GUID": [
        0x5848FD2D,
        0xD6AF,
        0x474B,
        0x82,
        0x75,
        0x95,
        0xDD,
        0xE7,
        0x0A,
        0xE8,
        0x23,
    ],
    "SMRAM_CPU_DATA_VARIABLE_GUID": [
        0x429501D9,
        0xE447,
        0x40F4,
        0x86,
        0x7B,
        0x75,
        0xC9,
        0x3A,
        0x1D,
        0xB5,
        0x4E,
    ],
    "SM_BUS_CONTROLLER_IDENTIFIER_GUID": [
        0x882F2546,
        0xEF1F,
        0x4090,
        0x9F,
        0x9C,
        0x93,
        0x84,
        0x5A,
        0xD7,
        0x84,
        0x1C,
    ],
    "SYSTEM_ACCESS_GUID": [
        0xE770BB69,
        0xBCB4,
        0x4D04,
        0x9E,
        0x97,
        0x23,
        0xFF,
        0x94,
        0x56,
        0xFE,
        0xAC,
    ],
    "TCG_EFI_ACPI_TABLE_GUID": [
        0xEB9D2D30,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "TCG_EFI_HOB_LIST_GUID": [
        0x7739F24C,
        0x93D7,
        0x11D4,
        0x9A,
        0x3A,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "TCG_INTERNAL_FLAGS_GUID": [
        0x70FFF0FF,
        0xA543,
        0x45B9,
        0x8B,
        0xE3,
        0x1B,
        0xDB,
        0x90,
        0x41,
        0x20,
        0x80,
    ],
    "TCG_LOCK_DOWN_VAR_GUID": [
        0x6E605536,
        0xA30A,
        0x4D56,
        0x93,
        0x9E,
        0x1C,
        0x37,
        0x3F,
        0x79,
        0x8D,
        0x7B,
    ],
    "TCG_PLATFORM_SETUP_PEI_POLICY_GUID": [
        0xA76B4E22,
        0xB50A,
        0x401D,
        0x8B,
        0x35,
        0x51,
        0x24,
        0xB0,
        0xBA,
        0x41,
        0x4,
    ],
    "TCG_PLATFORM_SETUP_POLICY_GUID": [
        0xBB6CBEFF,
        0xE072,
        0x40D2,
        0xA6,
        0xEB,
        0xBA,
        0xB7,
        0x5B,
        0xDE,
        0x87,
        0xE7,
    ],
    "TCG_PPI_SYNC_FLAG_GUID": [
        0xF3ED95DF,
        0x828E,
        0x41C7,
        0xBC,
        0xA0,
        0x16,
        0xC4,
        0x19,
        0x65,
        0xA6,
        0x34,
    ],
    "TDTHI_PROTOCOL_FIXED_GUID": [
        0xFA8F55E8,
        0xAB22,
        0x42DD,
        0xB9,
        0x16,
        0x7D,
        0xCE,
        0x39,
        0x00,
        0x25,
        0x74,
    ],
    "TDTHI_PROTOCOL_GUID": [
        0x3C4852D6,
        0xD47B,
        0x4F46,
        0xB0,
        0x5E,
        0xB5,
        0xED,
        0xC1,
        0xAA,
        0x43,
        0x0A,
    ],
    "TDT_VOLATILE_SETUP_DATA_GUID": [
        0x7B77FB8B,
        0x1E0D,
        0x4D7E,
        0x95,
        0x3F,
        0x39,
        0x80,
        0xA2,
        0x61,
        0xE0,
        0x76,
    ],
    "TEMPORARY_RAM_SUPPORT_PPI_GUID": [
        0xDBE23AA9,
        0xA345,
        0x4B97,
        0x85,
        0xB6,
        0xB2,
        0x26,
        0xF1,
        0x61,
        0x73,
        0x89,
    ],
    "TERMINAL_VAR_GUID": [
        0x560BF58A,
        0x1E0D,
        0x4D7E,
        0x95,
        0x3F,
        0x29,
        0x80,
        0xA2,
        0x61,
        0xE0,
        0x31,
    ],
    "TPM_BOOT_FLOW_VARIABLE_GUID": [
        0xB6460A49,
        0x0AC1,
        0x484F,
        0xAE,
        0x58,
        0xF1,
        0x6E,
        0xB2,
        0x39,
        0xDB,
        0x3D,
    ],
    "TXT_INFO_HOB_GUID": [
        0x2986883F,
        0x88E0,
        0x48D0,
        0x4B,
        0x82,
        0x20,
        0xC2,
        0x69,
        0x48,
        0xDD,
        0xAC,
    ],
    "TXT_ONE_TOUCH_GUID": [
        0x3D989471,
        0xCFAC,
        0x46B7,
        0x9B,
        0x1C,
        0x8,
        0x43,
        0x1,
        0x9,
        0x40,
        0x2D,
    ],
    "TXT_ONE_TOUCH_OP_PROTOCOL_GUID": [
        0xFA2338AD,
        0x80DF,
        0x49D0,
        0x93,
        0x96,
        0xCF,
        0x71,
        0x45,
        0xD0,
        0x3A,
        0x76,
    ],
    "UNKNOWN_DEVICE_GUID": [
        0xCF31FAC5,
        0xC24E,
        0x11D2,
        0x85,
        0xF3,
        0x0,
        0xA0,
        0xC9,
        0x3E,
        0xC9,
        0x3B,
    ],
    "USB_TIMING_POLICY_PROTOCOL_GUID": [
        0x89E3C1DC,
        0xB5E3,
        0x4D34,
        0xAE,
        0xAD,
        0xDD,
        0x7E,
        0xB2,
        0x82,
        0x8C,
        0x18,
    ],
    "USER_DEFAULTS_GUID": [
        0xC4CC0DE8,
        0x0687,
        0x4422,
        0x99,
        0xC1,
        0x65,
        0x35,
        0x1A,
        0x5D,
        0x5F,
        0x95,
    ],
    "WDT_APP_PROTOCOL_GUID": [
        0x92C7D0BB,
        0x679E,
        0x479D,
        0x87,
        0x8D,
        0xD4,
        0xB8,
        0x29,
        0x68,
        0x57,
        0x8B,
    ],
    "WDT_HOB_GUID": [
        0x65675786,
        0xACCA,
        0x4B11,
        0x8A,
        0xB7,
        0xF8,
        0x43,
        0xAA,
        0x2A,
        0x8B,
        0xEA,
    ],
    "WDT_PERSISTENT_DATA_GUID": [
        0x78CE2354,
        0xCFBC,
        0x4643,
        0xAE,
        0xBA,
        0x7,
        0xA2,
        0x7F,
        0xA8,
        0x92,
        0xBF,
    ],
    "WDT_PPI_GUID": [
        0xF38D1338,
        0xAF7A,
        0x4FB6,
        0x91,
        0xDB,
        0x1A,
        0x9C,
        0x21,
        0x83,
        0x57,
        0x0D,
    ],
    "WDT_PROTOCOL_GUID": [
        0xB42B8D12,
        0x2ACB,
        0x499A,
        0xA9,
        0x20,
        0xDD,
        0x5B,
        0xE6,
        0xCF,
        0x09,
        0xB1,
    ],
}
