# This file was automatically generated with update_edk2_guids.py script
edk2_guids = {
    # Guids from .\edk2\ArmPkg\ArmPkg.dec file
    "gArmTokenSpaceGuid": [
        0xBB11ECFE,
        0x820F,
        0x4968,
        0xBB,
        0xA6,
        0xF7,
        0x6A,
        0xFE,
        0x30,
        0x25,
        0x96,
    ],
    "gArmMpCoreInfoGuid": [
        0xA4EE0728,
        0xE5D7,
        0x4AC5,
        0xB2,
        0x1E,
        0x65,
        0x8E,
        0xD8,
        0x57,
        0xE8,
        0x34,
    ],
    "gArmScmiBaseProtocolGuid": [
        0xD7E5ABE9,
        0x33AB,
        0x418E,
        0x9F,
        0x91,
        0x72,
        0xDA,
        0xE2,
        0xBA,
        0x8E,
        0x2F,
    ],
    "gArmScmiClockProtocolGuid": [
        0x91CE67A8,
        0xE0AA,
        0x4012,
        0xB9,
        0x9F,
        0xB6,
        0xFC,
        0xF3,
        0x4,
        0x8E,
        0xAA,
    ],
    "gArmScmiClock2ProtocolGuid": [
        0xB8D8CAF2,
        0x9E94,
        0x462C,
        0xA8,
        0x34,
        0x6C,
        0x99,
        0xFC,
        0x05,
        0xEF,
        0xCF,
    ],
    "gArmScmiPerformanceProtocolGuid": [
        0x9B8BA84,
        0x3DD3,
        0x49A6,
        0xA0,
        0x5A,
        0x31,
        0x34,
        0xA5,
        0xF0,
        0x7B,
        0xAD,
    ],
    "gArmMpCoreInfoPpiGuid": [
        0x6847CC74,
        0xE9EC,
        0x4F8F,
        0xA2,
        0x9D,
        0xAB,
        0x44,
        0xE7,
        0x54,
        0xA8,
        0xFC,
    ],
    # Guids from .\edk2\ArmPlatformPkg\ArmPlatformPkg.dec file
    "gArmPlatformTokenSpaceGuid": [
        0x9C0AAED4,
        0x74C5,
        0x4043,
        0xB4,
        0x17,
        0xA3,
        0x22,
        0x38,
        0x14,
        0xCE,
        0x76,
    ],
    # Guids from .\edk2\ArmVirtPkg\ArmVirtPkg.dec file
    "gArmVirtTokenSpaceGuid": [
        0x0B6F5CA7,
        0x4F53,
        0x445A,
        0xB7,
        0x6E,
        0x2E,
        0x36,
        0x5B,
        0x80,
        0x63,
        0x66,
    ],
    "gEarlyPL011BaseAddressGuid": [
        0xB199DEA9,
        0xFD5C,
        0x4A84,
        0x80,
        0x82,
        0x2F,
        0x41,
        0x70,
        0x78,
        0x03,
        0x05,
    ],
    "gArmVirtVariableGuid": [
        0x50BEA1E5,
        0xA2C5,
        0x46E9,
        0x9B,
        0x3A,
        0x59,
        0x59,
        0x65,
        0x16,
        0xB0,
        0x0A,
    ],
    "gFdtClientProtocolGuid": [
        0xE11FACA0,
        0x4710,
        0x4C8E,
        0xA7,
        0xA2,
        0x01,
        0xBA,
        0xA2,
        0x59,
        0x1B,
        0x4C,
    ],
    # Guids from .\edk2\CryptoPkg\CryptoPkg.dec file
    "gEdkiiCryptoProtocolGuid": [
        0x2C2275C9,
        0x3A7B,
        0x426F,
        0xBE,
        0x54,
        0x2D,
        0x22,
        0xBD,
        0x9D,
        0x10,
        0x92,
    ],
    "gEdkiiSmmCryptoProtocolGuid": [
        0xF46B2EB2,
        0xE0D7,
        0x4C96,
        0xA3,
        0xB1,
        0xC,
        0x61,
        0xBB,
        0x24,
        0x5C,
        0x42,
    ],
    "gEdkiiCryptoPpiGuid": [
        0x7DCE671B,
        0xC223,
        0x446A,
        0xA7,
        0x05,
        0xED,
        0x63,
        0x7A,
        0xAF,
        0x67,
        0x71,
    ],
    "gEfiCryptoPkgTokenSpaceGuid": [
        0x6BD7DE60,
        0x9EF7,
        0x4899,
        0x97,
        0xD0,
        0xAB,
        0xFF,
        0xFD,
        0xE9,
        0x70,
        0xF2,
    ],
    # Guids from .\edk2\DynamicTablesPkg\DynamicTablesPkg.dec file
    "gEdkiiConfigurationManagerProtocolGuid": [
        0xD85A4835,
        0x5A82,
        0x4894,
        0xAC,
        0x2,
        0x70,
        0x6F,
        0x43,
        0xD5,
        0x97,
        0x8E,
    ],
    "gEdkiiDynamicTableFactoryProtocolGuid": [
        0x91D1E327,
        0xFE5A,
        0x49B8,
        0xAB,
        0x65,
        0xE,
        0xCE,
        0x2D,
        0xDB,
        0x45,
        0xEC,
    ],
    # Guids from .\edk2\EmbeddedPkg\EmbeddedPkg.dec file
    "gEmbeddedTokenSpaceGuid": [
        0xE0D8CA17,
        0x4276,
        0x4386,
        0xBB,
        0x79,
        0x48,
        0xCB,
        0x81,
        0x3D,
        0x3C,
        0x4F,
    ],
    "gFdtTableGuid": [
        0xB1B621D5,
        0xF19C,
        0x41A5,
        0x83,
        0x0B,
        0xD9,
        0x15,
        0x2C,
        0x69,
        0xAA,
        0xE0,
    ],
    "gFdtHobGuid": [
        0x16958446,
        0x19B7,
        0x480B,
        0xB0,
        0x47,
        0x74,
        0x85,
        0xAD,
        0x3F,
        0x71,
        0x6D,
    ],
    "gFdtVariableGuid": [
        0x25A4FD4A,
        0x9703,
        0x4BA9,
        0xA1,
        0x90,
        0xB7,
        0xC8,
        0x4E,
        0xFB,
        0x3E,
        0x57,
    ],
    "gEdkiiPlatformHasDeviceTreeGuid": [
        0x7EBB920D,
        0x1AAF,
        0x46D9,
        0xB2,
        0xAF,
        0x54,
        0x1E,
        0x1D,
        0xCE,
        0x14,
        0x8B,
    ],
    "gDtPlatformFormSetGuid": [
        0x2B7A240D,
        0xD5AD,
        0x4FD6,
        0xBE,
        0x1C,
        0xDF,
        0xA4,
        0x41,
        0x5F,
        0x55,
        0x26,
    ],
    "gDtPlatformDefaultDtbFileGuid": [
        0x25462CDA,
        0x221F,
        0x47DF,
        0xAC,
        0x1D,
        0x25,
        0x9C,
        0xFA,
        0xA4,
        0xE3,
        0x26,
    ],
    "gConsolePrefFormSetGuid": [
        0x2D2358B4,
        0xE96C,
        0x484D,
        0xB2,
        0xDD,
        0x7C,
        0x2E,
        0xDF,
        0xC7,
        0xD5,
        0x6F,
    ],
    "gEdkiiNvVarStoreFormattedGuid": [
        0xD1A86E3F,
        0x0707,
        0x4C35,
        0x83,
        0xCD,
        0xDC,
        0x2C,
        0x29,
        0xC8,
        0x91,
        0xA3,
    ],
    "gHardwareInterruptProtocolGuid": [
        0x2890B3EA,
        0x053D,
        0x1643,
        0xAD,
        0x0C,
        0xD6,
        0x48,
        0x08,
        0xDA,
        0x3F,
        0xF1,
    ],
    "gHardwareInterrupt2ProtocolGuid": [
        0x32898322,
        0x2DA1,
        0x474A,
        0xBA,
        0xAA,
        0xF3,
        0xF7,
        0xCF,
        0x56,
        0x94,
        0x70,
    ],
    "gEmbeddedDeviceGuid": [
        0xBF4B9D10,
        0x13EC,
        0x43DD,
        0x88,
        0x80,
        0xE9,
        0xB,
        0x71,
        0x8F,
        0x27,
        0xDE,
    ],
    "gEmbeddedExternalDeviceProtocolGuid": [
        0x735F8C64,
        0xD696,
        0x44D0,
        0xBD,
        0xF2,
        0x44,
        0x7F,
        0xD0,
        0x5A,
        0x54,
        0x06,
    ],
    "gEmbeddedGpioProtocolGuid": [
        0x17A0A3D7,
        0xC0A5,
        0x4635,
        0xBB,
        0xD5,
        0x07,
        0x21,
        0x87,
        0xDF,
        0xE2,
        0xEE,
    ],
    "gPeCoffLoaderProtocolGuid": [
        0xB323179B,
        0x97FB,
        0x477E,
        0xB0,
        0xFE,
        0xD8,
        0x85,
        0x91,
        0xFA,
        0x11,
        0xAB,
    ],
    "gEmbeddedMmcHostProtocolGuid": [
        0x3E591C00,
        0x9E4A,
        0x11DF,
        0x92,
        0x44,
        0x00,
        0x02,
        0xA5,
        0xD5,
        0xC5,
        0x1B,
    ],
    "gAndroidFastbootTransportProtocolGuid": [
        0x74BD9FE0,
        0x8902,
        0x11E3,
        0xB9,
        0xD3,
        0xF7,
        0x22,
        0x38,
        0xFC,
        0x9A,
        0x31,
    ],
    "gAndroidFastbootPlatformProtocolGuid": [
        0x524685A0,
        0x89A0,
        0x11E3,
        0x9D,
        0x4D,
        0xBF,
        0xA9,
        0xF6,
        0xA4,
        0x03,
        0x08,
    ],
    "gUsbDeviceProtocolGuid": [
        0x021BD2CA,
        0x51D2,
        0x11E3,
        0x8E,
        0x56,
        0xB7,
        0x54,
        0x17,
        0xC7,
        0x0B,
        0x44,
    ],
    "gPlatformBootManagerProtocolGuid": [
        0x7197C8A7,
        0x6559,
        0x4C93,
        0x93,
        0xD5,
        0x8A,
        0x84,
        0xF9,
        0x88,
        0x79,
        0x8B,
    ],
    "gPlatformGpioProtocolGuid": [
        0x52CE9845,
        0x5AF4,
        0x43E2,
        0xBA,
        0xFD,
        0x23,
        0x08,
        0x12,
        0x54,
        0x7A,
        0xC2,
    ],
    "gPlatformVirtualKeyboardProtocolGuid": [
        0x0E3606D2,
        0x1DC3,
        0x4E6F,
        0xBE,
        0x65,
        0x39,
        0x49,
        0x82,
        0xA2,
        0x65,
        0x47,
    ],
    "gAndroidBootImgProtocolGuid": [
        0x9859BB19,
        0x407C,
        0x4F8B,
        0xBC,
        0xE1,
        0xF8,
        0xDA,
        0x65,
        0x65,
        0xF4,
        0xA5,
    ],
    "gEdkiiEmbeddedGpioPpiGuid": [
        0x21C3B115,
        0x4E0B,
        0x470C,
        0x85,
        0xC7,
        0xE1,
        0x05,
        0xA5,
        0x75,
        0xC9,
        0x7B,
    ],
    # Guids from .\edk2\EmulatorPkg\EmulatorPkg.dec file
    "gEmuThunkProtocolGuid": [
        0x5CF32E0B,
        0x8EDF,
        0x2E44,
        0x9C,
        0xDA,
        0x93,
        0x20,
        0x5E,
        0x99,
        0xEC,
        0x1C,
    ],
    "gEmuIoThunkProtocolGuid": [
        0x453368F6,
        0x7C85,
        0x434A,
        0xA9,
        0x8A,
        0x72,
        0xD1,
        0xB7,
        0xFF,
        0xA9,
        0x26,
    ],
    "gEmuGraphicsWindowProtocolGuid": [
        0x30FD316A,
        0x6728,
        0x2E41,
        0xA6,
        0x90,
        0x0D,
        0x13,
        0x33,
        0xD8,
        0xCA,
        0xC1,
    ],
    "gEmuThreadThunkProtocolGuid": [
        0x3B1E4B7C,
        0x09D8,
        0x944F,
        0xA4,
        0x08,
        0x13,
        0x09,
        0xEB,
        0x8B,
        0x44,
        0x27,
    ],
    "gEmuBlockIoProtocolGuid": [
        0x6888A4AE,
        0xAFCE,
        0xE84B,
        0x91,
        0x02,
        0xF7,
        0xB9,
        0xDA,
        0xE6,
        0xA0,
        0x30,
    ],
    "gEmuSnpProtocolGuid": [
        0xFD5FBE54,
        0x8C35,
        0xB345,
        0x8A,
        0x0F,
        0x7A,
        0xC8,
        0xA5,
        0xFD,
        0x05,
        0x21,
    ],
    "gEmuThunkPpiGuid": [
        0xE113F896,
        0x75CF,
        0xF640,
        0x81,
        0x7F,
        0xC8,
        0x5A,
        0x79,
        0xE8,
        0xAE,
        0x67,
    ],
    "gEmulatorPkgTokenSpaceGuid": [
        0x4F792E68,
        0xE8C8,
        0x794E,
        0xB1,
        0xD8,
        0x37,
        0x03,
        0xF3,
        0xF2,
        0xD5,
        0xA5,
    ],
    "gEmuSystemConfigGuid": [
        0xF8626165,
        0x6CEB,
        0x924A,
        0xBA,
        0xFC,
        0xF1,
        0x3A,
        0xB9,
        0xD6,
        0x57,
        0x28,
    ],
    "gEmuVirtualDisksGuid": [
        0xF2BA331A,
        0x8985,
        0x11DB,
        0xA4,
        0x06,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    "gEmuPhysicalDisksGuid": [
        0xF2BDCC96,
        0x8985,
        0x11DB,
        0x87,
        0x19,
        0x00,
        0x40,
        0xD0,
        0x2B,
        0x18,
        0x35,
    ],
    # Guids from .\edk2\FatPkg\FatPkg.dec file
    # Guids from .\edk2\FmpDevicePkg\FmpDevicePkg.dec file
    "gFmpDevicePkgTokenSpaceGuid": [
        0x40B2D964,
        0xFE11,
        0x40DC,
        0x82,
        0x83,
        0x2E,
        0xFB,
        0xDA,
        0x29,
        0x53,
        0x56,
    ],
    "gEdkiiCapsuleUpdatePolicyProtocolGuid": [
        0x487784C5,
        0x6299,
        0x4BA6,
        0xB0,
        0x96,
        0x5C,
        0xC5,
        0x27,
        0x7C,
        0xF7,
        0x57,
    ],
    # Guids from .\edk2\IntelFsp2Pkg\IntelFsp2Pkg.dec file
    "gFspReadyForNotifyPhasePpiGuid": [
        0xCD167C1E,
        0x6E0B,
        0x42B3,
        0x82,
        0xF6,
        0xE3,
        0xE9,
        0x06,
        0x19,
        0x98,
        0x10,
    ],
    "gFspInApiModePpiGuid": [
        0xA1EEAB87,
        0xC859,
        0x479D,
        0x89,
        0xB5,
        0x14,
        0x61,
        0xF4,
        0x06,
        0x1A,
        0x3E,
    ],
    "gFspmArchConfigPpiGuid": [
        0x824D5A3A,
        0xAF92,
        0x4C0C,
        0x9F,
        0x19,
        0x19,
        0x52,
        0x6D,
        0xCA,
        0x4A,
        0xBB,
    ],
    "gFspTempRamExitPpiGuid": [
        0xBC1CFBDB,
        0x7E50,
        0x42BE,
        0xB4,
        0x87,
        0x22,
        0xE0,
        0xA9,
        0x0C,
        0xB0,
        0x52,
    ],
    "gIntelFsp2PkgTokenSpaceGuid": [
        0xED6E0531,
        0xF715,
        0x4A3D,
        0x9B,
        0x12,
        0xC1,
        0xCA,
        0x5E,
        0xF6,
        0x98,
        0xA2,
    ],
    "gFspHeaderFileGuid": [
        0x912740BE,
        0x2284,
        0x4734,
        0xB9,
        0x71,
        0x84,
        0xB0,
        0x27,
        0x35,
        0x3F,
        0x0C,
    ],
    "gFspReservedMemoryResourceHobGuid": [
        0x69A79759,
        0x1373,
        0x4367,
        0xA6,
        0xC4,
        0xC7,
        0xF5,
        0x9E,
        0xFD,
        0x98,
        0x6E,
    ],
    "gFspNonVolatileStorageHobGuid": [
        0x721ACF02,
        0x4D77,
        0x4C2A,
        0xB3,
        0xDC,
        0x27,
        0x0B,
        0x7B,
        0xA9,
        0xE4,
        0xB0,
    ],
    "gFspBootLoaderTolumHobGuid": [
        0x73FF4F56,
        0xAA8E,
        0x4451,
        0xB3,
        0x16,
        0x36,
        0x35,
        0x36,
        0x67,
        0xAD,
        0x44,
    ],
    "gFspPerformanceDataGuid": [
        0x56ED21B6,
        0xBA23,
        0x429E,
        0x89,
        0x32,
        0x37,
        0x6D,
        0x8E,
        0x18,
        0x2E,
        0xE3,
    ],
    "gFspEventEndOfFirmwareGuid": [
        0xBD44F629,
        0xEAE7,
        0x4198,
        0x87,
        0xF1,
        0x39,
        0xFA,
        0xB0,
        0xFD,
        0x71,
        0x7E,
    ],
    # Guids from .\edk2\IntelFsp2WrapperPkg\IntelFsp2WrapperPkg.dec file
    "gIntelFsp2WrapperTokenSpaceGuid": [
        0xA34CF082,
        0xF50,
        0x4F0D,
        0x89,
        0x8A,
        0x3D,
        0x39,
        0x30,
        0x2B,
        0xC5,
        0x1E,
    ],
    "gFspApiPerformanceGuid": [
        0xC9122295,
        0x56ED,
        0x4D4E,
        0x06,
        0xA6,
        0x50,
        0x8D,
        0x89,
        0x4D,
        0x3E,
        0x40,
    ],
    "gFspHobGuid": [
        0x6D86FB36,
        0xBA90,
        0x472C,
        0xB5,
        0x83,
        0x3F,
        0xBE,
        0xD3,
        0xFB,
        0x20,
        0x9A,
    ],
    "gFspSiliconInitDonePpiGuid": [
        0x4EB6E09C,
        0xD256,
        0x4E1E,
        0xB5,
        0x0A,
        0x87,
        0x4B,
        0xD2,
        0x84,
        0xB3,
        0xDE,
    ],
    "gTopOfTemporaryRamPpiGuid": [
        0x2F3962B2,
        0x57C5,
        0x44EC,
        0x9E,
        0xFC,
        0xA6,
        0x9F,
        0xD3,
        0x02,
        0x03,
        0x2B,
    ],
    "gAddPerfRecordProtocolGuid": [
        0xC4A58D6D,
        0x3677,
        0x49CB,
        0xA0,
        0x0A,
        0x94,
        0x70,
        0x76,
        0x5F,
        0xB5,
        0x5E,
    ],
    # Guids from .\edk2\MdeModulePkg\MdeModulePkg.dec file
    "gEfiMdeModulePkgTokenSpaceGuid": [
        0xA1AFF049,
        0xFDEB,
        0x442A,
        0xB3,
        0x20,
        0x13,
        0xAB,
        0x4C,
        0xB7,
        0x2B,
        0xBC,
    ],
    "gPcdDataBaseHobGuid": [
        0xEA296D92,
        0x0B69,
        0x423C,
        0x8C,
        0x28,
        0x33,
        0xB4,
        0xE0,
        0xA9,
        0x12,
        0x68,
    ],
    "gPcdDataBaseSignatureGuid": [
        0x3C7D193C,
        0x682C,
        0x4C14,
        0xA6,
        0x8F,
        0x55,
        0x2D,
        0xEA,
        0x4F,
        0x43,
        0x7E,
    ],
    "gEfiIfrTianoGuid": [
        0xF0B1735,
        0x87A0,
        0x4193,
        0xB2,
        0x66,
        0x53,
        0x8C,
        0x38,
        0xAF,
        0x48,
        0xCE,
    ],
    "gEdkiiIfrBitVarstoreGuid": [
        0x82DDD68B,
        0x9163,
        0x4187,
        0x9B,
        0x27,
        0x20,
        0xA8,
        0xFD,
        0x60,
        0xA7,
        0x1D,
    ],
    "gEfiIfrFrameworkGuid": [
        0x31CA5D1A,
        0xD511,
        0x4931,
        0xB7,
        0x82,
        0xAE,
        0x6B,
        0x2B,
        0x17,
        0x8C,
        0xD7,
    ],
    "gEfiSystemNvDataFvGuid": [
        0xFFF12B8D,
        0x7696,
        0x4C8B,
        0xA9,
        0x85,
        0x27,
        0x47,
        0x07,
        0x5B,
        0x4F,
        0x50,
    ],
    "gEdkiiWorkingBlockSignatureGuid": [
        0x9E58292B,
        0x7C68,
        0x497D,
        0xA0,
        0xCE,
        0x65,
        0x0,
        0xFD,
        0x9F,
        0x1B,
        0x95,
    ],
    "gEdkiiFaultTolerantWriteGuid": [
        0x1D3E9CB8,
        0x43AF,
        0x490B,
        0x83,
        0xA,
        0x35,
        0x16,
        0xAA,
        0x53,
        0x20,
        0x47,
    ],
    "gEfiConsoleOutDeviceGuid": [
        0xD3B36F2C,
        0xD551,
        0x11D4,
        0x9A,
        0x46,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiConsoleInDeviceGuid": [
        0xD3B36F2B,
        0xD551,
        0x11D4,
        0x9A,
        0x46,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiMemoryTypeInformationGuid": [
        0x4C19049F,
        0x4137,
        0x4DD3,
        0x9C,
        0x10,
        0x8B,
        0x97,
        0xA8,
        0x3F,
        0xFD,
        0xFA,
    ],
    "gEfiCapsuleVendorGuid": [
        0x711C703F,
        0xC285,
        0x4B10,
        0xA3,
        0xB0,
        0x36,
        0xEC,
        0xBD,
        0x3C,
        0x8B,
        0xE2,
    ],
    "gEfiStandardErrorDeviceGuid": [
        0xD3B36F2D,
        0xD551,
        0x11D4,
        0x9A,
        0x46,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiVariableGuid": [
        0xDDCF3616,
        0x3275,
        0x4164,
        0x98,
        0xB6,
        0xFE,
        0x85,
        0x70,
        0x7F,
        0xFE,
        0x7D,
    ],
    "gEfiAuthenticatedVariableGuid": [
        0xAAF32C78,
        0x947B,
        0x439A,
        0xA1,
        0x80,
        0x2E,
        0x14,
        0x4E,
        0xC3,
        0x77,
        0x92,
    ],
    "gEfiVariableIndexTableGuid": [
        0x8CFDB8C8,
        0xD6B2,
        0x40F3,
        0x8E,
        0x97,
        0x02,
        0x30,
        0x7C,
        0xC9,
        0x8B,
        0x7C,
    ],
    "gSmmVariableWriteGuid": [
        0x93BA1826,
        0xDFFB,
        0x45DD,
        0x82,
        0xA7,
        0xE7,
        0xDC,
        0xAA,
        0x3B,
        0xBD,
        0xF3,
    ],
    "gPerformanceProtocolGuid": [
        0x76B6BDFA,
        0x2ACD,
        0x4462,
        0x9E,
        0x3F,
        0xCB,
        0x58,
        0xC9,
        0x69,
        0xD9,
        0x37,
    ],
    "gSmmPerformanceProtocolGuid": [
        0xF866226A,
        0xEAA5,
        0x4F5A,
        0xA9,
        0xA,
        0x6C,
        0xFB,
        0xA5,
        0x7C,
        0x58,
        0x8E,
    ],
    "gPerformanceExProtocolGuid": [
        0x1EA81BEC,
        0xF01A,
        0x4D98,
        0xA2,
        0x1,
        0x4A,
        0x61,
        0xCE,
        0x2F,
        0xC0,
        0x22,
    ],
    "gSmmPerformanceExProtocolGuid": [
        0x931FC048,
        0xC71D,
        0x4455,
        0x89,
        0x30,
        0x47,
        0x6,
        0x30,
        0xE3,
        0xE,
        0xE5,
    ],
    "gEdkiiPerformanceMeasurementProtocolGuid": [
        0xC85D06BE,
        0x5F75,
        0x48CE,
        0xA8,
        0x0F,
        0x12,
        0x36,
        0xBA,
        0x3B,
        0x87,
        0xB1,
    ],
    "gEdkiiSmmPerformanceMeasurementProtocolGuid": [
        0xD56B6D73,
        0x1A7B,
        0x4015,
        0x9B,
        0xB4,
        0x7B,
        0x07,
        0x17,
        0x29,
        0xED,
        0x24,
    ],
    "gEfiCrc32GuidedSectionExtractionGuid": [
        0xFC1BCDB0,
        0x7D31,
        0x49AA,
        0x93,
        0x6A,
        0xA4,
        0x60,
        0x0D,
        0x9D,
        0xD0,
        0x83,
    ],
    "gStatusCodeCallbackGuid": [
        0xE701458C,
        0x4900,
        0x4CA5,
        0xB7,
        0x72,
        0x3D,
        0x37,
        0x94,
        0x9F,
        0x79,
        0x27,
    ],
    "gMemoryStatusCodeRecordGuid": [
        0x060CC026,
        0x4C0D,
        0x4DDA,
        0x8F,
        0x41,
        0x59,
        0x5F,
        0xEF,
        0x00,
        0xA5,
        0x02,
    ],
    "gEfiStatusCodeDataTypeDebugGuid": [
        0x9A4E9246,
        0xD553,
        0x11D5,
        0x87,
        0xE2,
        0x00,
        0x06,
        0x29,
        0x45,
        0xC3,
        0xB9,
    ],
    "gLoadFixedAddressConfigurationTableGuid": [
        0x2CA88B53,
        0xD296,
        0x4080,
        0xA4,
        0xA5,
        0xCA,
        0xD9,
        0xBA,
        0xE2,
        0x4B,
        0x9,
    ],
    "gEfiGenericVariableGuid": [
        0x59D1C24F,
        0x50F1,
        0x401A,
        0xB1,
        0x01,
        0xF3,
        0x3E,
        0x0D,
        0xAE,
        0xD4,
        0x43,
    ],
    "gIdleLoopEventGuid": [
        0x3C8D294C,
        0x5FC3,
        0x4451,
        0xBB,
        0x31,
        0xC4,
        0xC0,
        0x32,
        0x29,
        0x5E,
        0x6C,
    ],
    "gRecoveryOnFatUsbDiskGuid": [
        0x0FFBCE19,
        0x324C,
        0x4690,
        0xA0,
        0x09,
        0x98,
        0xC6,
        0xAE,
        0x2E,
        0xB1,
        0x86,
    ],
    "gRecoveryOnFatIdeDiskGuid": [
        0xB38573B6,
        0x6200,
        0x4AC5,
        0xB5,
        0x1D,
        0x82,
        0xE6,
        0x59,
        0x38,
        0xD7,
        0x83,
    ],
    "gRecoveryOnFatFloppyDiskGuid": [
        0x2E3D2E75,
        0x9B2E,
        0x412D,
        0xB4,
        0xB1,
        0x70,
        0x41,
        0x6B,
        0x87,
        0x00,
        0xFF,
    ],
    "gRecoveryOnDataCdGuid": [
        0x5CAC0099,
        0x0DC9,
        0x48E5,
        0x80,
        0x68,
        0xBB,
        0x95,
        0xF5,
        0x40,
        0x0A,
        0x9F,
    ],
    "gRecoveryOnFatNvmeDiskGuid": [
        0xC770A27F,
        0x956A,
        0x497A,
        0x85,
        0x48,
        0xE0,
        0x61,
        0x97,
        0x58,
        0x8B,
        0xF6,
    ],
    "gEfiSmmLockBoxCommunicationGuid": [
        0x2A3CFEBD,
        0x27E8,
        0x4D0A,
        0x8B,
        0x79,
        0xD6,
        0x88,
        0xC2,
        0xA3,
        0xE1,
        0xC0,
    ],
    "gEfiAcpiVariableGuid": [
        0xAF9FFD67,
        0xEC10,
        0x488A,
        0x9D,
        0xFC,
        0x6C,
        0xBF,
        0x5E,
        0xE2,
        0x2C,
        0x2E,
    ],
    "gEfiAcpiS3ContextGuid": [
        0xEF98D3A,
        0x3E33,
        0x497A,
        0xA4,
        0x1,
        0x77,
        0xBE,
        0x3E,
        0xB7,
        0x4F,
        0x38,
    ],
    "gEfiBootScriptExecutorVariableGuid": [
        0x3079818C,
        0x46D4,
        0x4A73,
        0xAE,
        0xF3,
        0xE3,
        0xE4,
        0x6C,
        0xF1,
        0xEE,
        0xDB,
    ],
    "gEfiBootScriptExecutorContextGuid": [
        0x79CB58C4,
        0xAC51,
        0x442F,
        0xAF,
        0xD7,
        0x98,
        0xE4,
        0x7D,
        0x2E,
        0x99,
        0x8,
    ],
    "gUsbKeyboardLayoutPackageGuid": [
        0xC0F3B43,
        0x44DE,
        0x4907,
        0xB4,
        0x78,
        0x22,
        0x5F,
        0x6F,
        0x62,
        0x89,
        0xDC,
    ],
    "gUsbKeyboardLayoutKeyGuid": [
        0x3A4D7A7C,
        0x18A,
        0x4B42,
        0x81,
        0xB3,
        0xDC,
        0x10,
        0xE3,
        0xB5,
        0x91,
        0xBD,
    ],
    "gHiiResourceSamleFormSetGuid": [
        0x4F4EF7F0,
        0xAA29,
        0x4CE9,
        0xBA,
        0x41,
        0x64,
        0x3E,
        0x1,
        0x23,
        0xA9,
        0x9F,
    ],
    "gDriverSampleFormSetGuid": [
        0xA04A27F4,
        0xDF00,
        0x4D42,
        0xB5,
        0x52,
        0x39,
        0x51,
        0x13,
        0x02,
        0x11,
        0x3D,
    ],
    "gDriverSampleInventoryGuid": [
        0xB3F56470,
        0x6141,
        0x4621,
        0x8F,
        0x19,
        0x70,
        0x4E,
        0x57,
        0x7A,
        0xA9,
        0xE8,
    ],
    "gEfiIfrRefreshIdOpGuid": [
        0xF5E655D9,
        0x02A6,
        0x46F2,
        0x9E,
        0x76,
        0xB8,
        0xBE,
        0x8E,
        0x60,
        0xAB,
        0x22,
    ],
    "gPlatformOverridesManagerGuid": [
        0x8614567D,
        0x35BE,
        0x4415,
        0x8D,
        0x88,
        0xBD,
        0x7D,
        0xC,
        0x9C,
        0x70,
        0xC0,
    ],
    "gZeroGuid": [0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0, 0x0],
    "gMtcVendorGuid": [
        0xEB704011,
        0x1402,
        0x11D3,
        0x8E,
        0x77,
        0x0,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiFirmwarePerformanceGuid": [
        0xC095791A,
        0x3001,
        0x47B2,
        0x80,
        0xC9,
        0xEA,
        0xC7,
        0x31,
        0x9F,
        0x2F,
        0xA4,
    ],
    "gFirmwarePerformanceS3PointerGuid": [
        0xDC65ADC,
        0xA973,
        0x4130,
        0x8D,
        0xF0,
        0x2A,
        0xDB,
        0xEB,
        0x9E,
        0x4A,
        0x31,
    ],
    "gEventExitBootServicesFailedGuid": [
        0x4F6C5507,
        0x232F,
        0x4787,
        0xB9,
        0x5E,
        0x72,
        0xF8,
        0x62,
        0x49,
        0xC,
        0xB1,
    ],
    "gConnectConInEventGuid": [
        0xDB4E8151,
        0x57ED,
        0x4BED,
        0x88,
        0x33,
        0x67,
        0x51,
        0xB5,
        0xD1,
        0xA8,
        0xD7,
    ],
    "gEdkiiStatusCodeDataTypeVariableGuid": [
        0xF6EE6DBB,
        0xD67F,
        0x4EA0,
        0x8B,
        0x96,
        0x6A,
        0x71,
        0xB1,
        0x9D,
        0x84,
        0xAD,
    ],
    "gEdkiiMemoryProfileGuid": [
        0x821C9A09,
        0x541A,
        0x40F6,
        0x9F,
        0x43,
        0xA,
        0xD1,
        0x93,
        0xA1,
        0x2C,
        0xFE,
    ],
    "gEdkiiSmmMemoryProfileGuid": [
        0xE22BBCCA,
        0x516A,
        0x46A8,
        0x80,
        0xE2,
        0x67,
        0x45,
        0xE8,
        0x36,
        0x93,
        0xBD,
    ],
    "gEdkiiVarErrorFlagGuid": [
        0x4B37FE8,
        0xF6AE,
        0x480B,
        0xBD,
        0xD5,
        0x37,
        0xD9,
        0x8C,
        0x5E,
        0x89,
        0xAA,
    ],
    "gBrotliCustomDecompressGuid": [
        0x3D532050,
        0x5CDA,
        0x4FD0,
        0x87,
        0x9E,
        0x0F,
        0x7F,
        0x63,
        0x0D,
        0x5A,
        0xFB,
    ],
    "gLzmaCustomDecompressGuid": [
        0xEE4E5898,
        0x3914,
        0x4259,
        0x9D,
        0x6E,
        0xDC,
        0x7B,
        0xD7,
        0x94,
        0x03,
        0xCF,
    ],
    "gLzmaF86CustomDecompressGuid": [
        0xD42AE6BD,
        0x1352,
        0x4BFB,
        0x90,
        0x9A,
        0xCA,
        0x72,
        0xA6,
        0xEA,
        0xE8,
        0x89,
    ],
    "gEfiTtyTermGuid": [
        0x7D916D80,
        0x5BB1,
        0x458C,
        0xA4,
        0x8F,
        0xE2,
        0x5F,
        0xDD,
        0x51,
        0xEF,
        0x94,
    ],
    "gEdkiiLinuxTermGuid": [
        0xE4364A7F,
        0xF825,
        0x430E,
        0x9D,
        0x3A,
        0x9C,
        0x9B,
        0xE6,
        0x81,
        0x7C,
        0xA5,
    ],
    "gEdkiiXtermR6Guid": [
        0xFBFCA56B,
        0xBB36,
        0x4B78,
        0xAA,
        0xAB,
        0xBE,
        0x1B,
        0x97,
        0xEC,
        0x7C,
        0xCB,
    ],
    "gEdkiiVT400Guid": [
        0x8E46DDDD,
        0x3D49,
        0x4A9D,
        0xB8,
        0x75,
        0x3C,
        0x08,
        0x6F,
        0x6A,
        0xA2,
        0xBD,
    ],
    "gEdkiiSCOTermGuid": [
        0xFC7DD6E0,
        0x813C,
        0x434D,
        0xB4,
        0xDA,
        0x3B,
        0xD6,
        0x49,
        0xE9,
        0xE1,
        0x5A,
    ],
    "gEfiIfrBootMaintenanceGuid": [
        0xB2DEDC91,
        0xD59F,
        0x48D2,
        0x89,
        0x8A,
        0x12,
        0x49,
        0xC,
        0x74,
        0xA4,
        0xE0,
    ],
    "gEfiIfrFrontPageGuid": [
        0xE58809F8,
        0xFBC1,
        0x48E2,
        0x88,
        0x3A,
        0xA3,
        0x0F,
        0xDC,
        0x4B,
        0x44,
        0x1E,
    ],
    "gRamDiskFormSetGuid": [
        0x2A46715F,
        0x3581,
        0x4A55,
        0x8E,
        0x73,
        0x2B,
        0x76,
        0x9A,
        0xAA,
        0x30,
        0xC5,
    ],
    "gEdkiiPiSmmCommunicationRegionTableGuid": [
        0x4E28CA50,
        0xD582,
        0x44AC,
        0xA1,
        0x1F,
        0xE3,
        0xD5,
        0x65,
        0x26,
        0xDB,
        0x34,
    ],
    "gEdkiiPiSmmMemoryAttributesTableGuid": [
        0x6B9FD3F7,
        0x16DF,
        0x45E8,
        0xBD,
        0x39,
        0xB9,
        0x4A,
        0x66,
        0x54,
        0x1A,
        0x5D,
    ],
    "gSmiHandlerProfileGuid": [
        0x49174342,
        0x7108,
        0x409B,
        0x8B,
        0xBE,
        0x65,
        0xFD,
        0xA8,
        0x53,
        0x89,
        0xF5,
    ],
    "gEdkiiNonDiscoverableAhciDeviceGuid": [
        0xC7D35798,
        0xE4D2,
        0x4A93,
        0xB1,
        0x45,
        0x54,
        0x88,
        0x9F,
        0x02,
        0x58,
        0x4B,
    ],
    "gEdkiiNonDiscoverableAmbaDeviceGuid": [
        0x94440339,
        0xCC93,
        0x4506,
        0xB4,
        0xC6,
        0xEE,
        0x8D,
        0x0F,
        0x4C,
        0xA1,
        0x91,
    ],
    "gEdkiiNonDiscoverableEhciDeviceGuid": [
        0xEAEE5615,
        0x0CFD,
        0x45FC,
        0x87,
        0x69,
        0xA0,
        0xD8,
        0x56,
        0x95,
        0xAF,
        0x85,
    ],
    "gEdkiiNonDiscoverableNvmeDeviceGuid": [
        0xC5F25542,
        0x2A79,
        0x4A26,
        0x81,
        0xBB,
        0x4E,
        0xA6,
        0x32,
        0x33,
        0xB3,
        0x09,
    ],
    "gEdkiiNonDiscoverableOhciDeviceGuid": [
        0xB20005B0,
        0xBB2D,
        0x496F,
        0x86,
        0x9C,
        0x23,
        0x0B,
        0x44,
        0x79,
        0xE7,
        0xD1,
    ],
    "gEdkiiNonDiscoverableSdhciDeviceGuid": [
        0x1DD1D619,
        0xF9B8,
        0x463E,
        0x86,
        0x81,
        0xD1,
        0xDC,
        0x7C,
        0x07,
        0xB7,
        0x2C,
    ],
    "gEdkiiNonDiscoverableUfsDeviceGuid": [
        0x2EA77912,
        0x80A8,
        0x4947,
        0xBE,
        0x69,
        0xCD,
        0xD0,
        0x0A,
        0xFB,
        0xE5,
        0x56,
    ],
    "gEdkiiNonDiscoverableUhciDeviceGuid": [
        0xA8CDA0A2,
        0x4F37,
        0x4A1B,
        0x8E,
        0x10,
        0x8E,
        0xF3,
        0xCC,
        0x3B,
        0xF3,
        0xA8,
    ],
    "gEdkiiNonDiscoverableXhciDeviceGuid": [
        0xB1BE0BC5,
        0x6C28,
        0x442D,
        0xAA,
        0x37,
        0x15,
        0x1B,
        0x42,
        0x57,
        0xBD,
        0x78,
    ],
    "gEdkiiPlatformHasAcpiGuid": [
        0xF0966B41,
        0xC23F,
        0x41B9,
        0x96,
        0x04,
        0x0F,
        0xF7,
        0xE1,
        0x11,
        0x96,
        0x5A,
    ],
    "gEdkiiFpdtExtendedFirmwarePerformanceGuid": [
        0x3B387BFD,
        0x7ABC,
        0x4CF2,
        0xA0,
        0xCA,
        0xB6,
        0xA1,
        0x6C,
        0x1B,
        0x1B,
        0x25,
    ],
    "gEdkiiEndOfS3ResumeGuid": [
        0x96F5296D,
        0x05F7,
        0x4F3C,
        0x84,
        0x67,
        0xE4,
        0x56,
        0x89,
        0x0E,
        0x0C,
        0xB5,
    ],
    "gEdkiiS3SmmInitDoneGuid": [
        0x8F9D4825,
        0x797D,
        0x48FC,
        0x84,
        0x71,
        0x84,
        0x50,
        0x25,
        0x79,
        0x2E,
        0xF6,
    ],
    "gS3StorageDeviceInitListGuid": [
        0x310E9B8C,
        0xCF90,
        0x421E,
        0x8E,
        0x9B,
        0x9E,
        0xEF,
        0xB6,
        0x17,
        0xC8,
        0xEF,
    ],
    "gEdkiiSerialPortLibVendorGuid": [
        0xD3987D4B,
        0x971A,
        0x435F,
        0x8C,
        0xAF,
        0x49,
        0x67,
        0xEB,
        0x62,
        0x72,
        0x41,
    ],
    "gEdkiiCapsuleOnDiskNameGuid": [
        0x98C80A4F,
        0xE16B,
        0x4D11,
        0x93,
        0x9A,
        0xAB,
        0xE5,
        0x61,
        0x26,
        0x3,
        0x30,
    ],
    "gPeiAtaControllerPpiGuid": [
        0xA45E60D1,
        0xC719,
        0x44AA,
        0xB0,
        0x7A,
        0xAA,
        0x77,
        0x7F,
        0x85,
        0x90,
        0x6D,
    ],
    "gPeiUsbHostControllerPpiGuid": [
        0x652B38A9,
        0x77F4,
        0x453F,
        0x89,
        0xD5,
        0xE7,
        0xBD,
        0xC3,
        0x52,
        0xFC,
        0x53,
    ],
    "gPeiUsb2HostControllerPpiGuid": [
        0xFEDD6305,
        0xE2D7,
        0x4ED5,
        0x9F,
        0xAA,
        0xDA,
        0x8,
        0xE,
        0x33,
        0x6C,
        0x22,
    ],
    "gPeiUsbControllerPpiGuid": [
        0x3BC1F6DE,
        0x693E,
        0x4547,
        0xA3,
        0x00,
        0x21,
        0x82,
        0x3C,
        0xA4,
        0x20,
        0xB2,
    ],
    "gPeiUsbIoPpiGuid": [
        0x7C29785C,
        0x66B9,
        0x49FC,
        0xB7,
        0x97,
        0x1C,
        0xA5,
        0x55,
        0x0E,
        0xF2,
        0x83,
    ],
    "gPeiSecPerformancePpiGuid": [
        0x0ECC666B,
        0x4662,
        0x47F9,
        0x9D,
        0xD5,
        0xD0,
        0x96,
        0xFF,
        0x7D,
        0xA4,
        0x9E,
    ],
    "gEfiPeiSmmCommunicationPpiGuid": [
        0xAE933E1C,
        0xCC47,
        0x4E38,
        0x8F,
        0xE,
        0xE2,
        0xF6,
        0x1D,
        0x26,
        0x5,
        0xDF,
    ],
    "gPeiSmmAccessPpiGuid": [
        0x268F33A9,
        0xCCCD,
        0x48BE,
        0x88,
        0x17,
        0x86,
        0x5,
        0x3A,
        0xC3,
        0x2E,
        0xD6,
    ],
    "gPeiSmmControlPpiGuid": [
        0x61C68702,
        0x4D7E,
        0x4F43,
        0x8D,
        0xEF,
        0xA7,
        0x43,
        0x5,
        0xCE,
        0x74,
        0xC5,
    ],
    "gPeiPostScriptTablePpiGuid": [
        0x88C9D306,
        0x900,
        0x4EB5,
        0x82,
        0x60,
        0x3E,
        0x2D,
        0xBE,
        0xDA,
        0x1F,
        0x89,
    ],
    "gPeiSerialPortPpiGuid": [
        0x490E9D85,
        0x8AEF,
        0x4193,
        0x8E,
        0x56,
        0xF7,
        0x34,
        0xA9,
        0xFF,
        0xAC,
        0x8B,
    ],
    "gEdkiiPeiUfsHostControllerPpiGuid": [
        0xDC54B283,
        0x1A77,
        0x4CD6,
        0x83,
        0xBB,
        0xFD,
        0xDA,
        0x46,
        0x9A,
        0x2E,
        0xC6,
    ],
    "gPeiIpmiPpiGuid": [
        0xA9731431,
        0xD968,
        0x4277,
        0xB7,
        0x52,
        0xA3,
        0xA9,
        0xA6,
        0xAE,
        0x18,
        0x98,
    ],
    "gEdkiiPeiSdMmcHostControllerPpiGuid": [
        0xB30DFEED,
        0x947F,
        0x4396,
        0xB1,
        0x5A,
        0xDF,
        0xBD,
        0xB9,
        0x16,
        0xDC,
        0x24,
    ],
    "gEdkiiIoMmuPpiGuid": [
        0x70B0AF26,
        0xF847,
        0x4BB6,
        0xAA,
        0xB9,
        0xCD,
        0xE8,
        0x4F,
        0xC6,
        0x14,
        0x31,
    ],
    "gEdkiiPlatformSpecificResetFilterPpiGuid": [
        0x8C9F4DE3,
        0x7B90,
        0x47EF,
        0x93,
        0x8,
        0x28,
        0x7C,
        0xEC,
        0xD6,
        0x6D,
        0xE8,
    ],
    "gEdkiiPlatformSpecificResetNotificationPpiGuid": [
        0xE09F355D,
        0xDAE8,
        0x4910,
        0xB1,
        0x4A,
        0x92,
        0x78,
        0xF,
        0xDC,
        0xF7,
        0xCB,
    ],
    "gEdkiiPlatformSpecificResetHandlerPpiGuid": [
        0x75CF14AE,
        0x3441,
        0x49DC,
        0xAA,
        0x10,
        0xBB,
        0x35,
        0xA7,
        0xBA,
        0x8B,
        0xAB,
    ],
    "gEdkiiPeiNvmExpressHostControllerPpiGuid": [
        0xCAE3AA63,
        0x676F,
        0x4DA3,
        0xBD,
        0x50,
        0x6C,
        0xC5,
        0xED,
        0xDE,
        0x9A,
        0xAD,
    ],
    "gEdkiiPeiAtaAhciHostControllerPpiGuid": [
        0x61DD33EA,
        0x421F,
        0x4CC0,
        0x89,
        0x29,
        0xFF,
        0xEE,
        0xA9,
        0xA1,
        0xA2,
        0x61,
    ],
    "gEdkiiPeiStorageSecurityCommandPpiGuid": [
        0x35DE0B4E,
        0x30FB,
        0x46C3,
        0xBD,
        0x84,
        0x1F,
        0xDB,
        0xA1,
        0x58,
        0xBB,
        0x56,
    ],
    "gEdkiiPeiAtaPassThruPpiGuid": [
        0xA16473FD,
        0xD474,
        0x4C89,
        0xAE,
        0xC7,
        0x90,
        0xB8,
        0x3C,
        0x73,
        0x86,
        0x9,
    ],
    "gEdkiiDebugPpiGuid": [
        0x999E699C,
        0xB013,
        0x475E,
        0xB1,
        0x7B,
        0xF3,
        0xA8,
        0xAE,
        0x5C,
        0x48,
        0x75,
    ],
    "gEdkiiPeiNvmExpressPassThruPpiGuid": [
        0x6AF31B2C,
        0x3BE,
        0x46C1,
        0xB1,
        0x2D,
        0xEA,
        0x4A,
        0x36,
        0xDF,
        0xA7,
        0x4C,
    ],
    "gEdkiiPeiCapsuleOnDiskPpiGuid": [
        0x71A9EA61,
        0x5A35,
        0x4A5D,
        0xAC,
        0xEF,
        0x9C,
        0xF8,
        0x6D,
        0x6D,
        0x67,
        0xE0,
    ],
    "gEdkiiPeiBootInCapsuleOnDiskModePpiGuid": [
        0xB08A11E4,
        0xE2B7,
        0x4B75,
        0xB5,
        0x15,
        0xAF,
        0x61,
        0x6,
        0x68,
        0xBF,
        0xD1,
    ],
    "gEfiLoadPeImageProtocolGuid": [
        0x5CB5C776,
        0x60D5,
        0x45EE,
        0x88,
        0x3C,
        0x45,
        0x27,
        0x08,
        0xCD,
        0x74,
        0x3F,
    ],
    "gEfiPrint2ProtocolGuid": [
        0xF05976EF,
        0x83F1,
        0x4F3D,
        0x86,
        0x19,
        0xF7,
        0x59,
        0x5D,
        0x41,
        0xE5,
        0x38,
    ],
    "gEfiPrint2SProtocolGuid": [
        0xCC252D2,
        0xC106,
        0x4661,
        0xB5,
        0xBD,
        0x31,
        0x47,
        0xA4,
        0xF8,
        0x1F,
        0x92,
    ],
    "gEfiGenericMemTestProtocolGuid": [
        0x309DE7F1,
        0x7F5E,
        0x4ACE,
        0xB4,
        0x9C,
        0x53,
        0x1B,
        0xE5,
        0xAA,
        0x95,
        0xEF,
    ],
    "gEfiDebuggerConfigurationProtocolGuid": [
        0x577D959C,
        0xE967,
        0x4546,
        0x86,
        0x20,
        0xC7,
        0x78,
        0xFA,
        0xE5,
        0xDA,
        0x05,
    ],
    "gEfiFaultTolerantWriteProtocolGuid": [
        0x3EBD9E82,
        0x2C78,
        0x4DE6,
        0x97,
        0x86,
        0x8D,
        0x4B,
        0xFC,
        0xB7,
        0xC8,
        0x81,
    ],
    "gEfiSmmFaultTolerantWriteProtocolGuid": [
        0x3868FC3B,
        0x7E45,
        0x43A7,
        0x90,
        0x6C,
        0x4B,
        0xA4,
        0x7D,
        0xE1,
        0x75,
        0x4D,
    ],
    "gEfiSwapAddressRangeProtocolGuid": [
        0x1259F60D,
        0xB754,
        0x468E,
        0xA7,
        0x89,
        0x4D,
        0xB8,
        0x5D,
        0x55,
        0xE8,
        0x7E,
    ],
    "gEfiSmmSwapAddressRangeProtocolGuid": [
        0x67C4F112,
        0x3385,
        0x4E55,
        0x9C,
        0x5B,
        0xC0,
        0x5B,
        0x71,
        0x7C,
        0x42,
        0x28,
    ],
    "gEfiSmmVariableProtocolGuid": [
        0xED32D533,
        0x99E6,
        0x4209,
        0x9C,
        0xC0,
        0x2D,
        0x72,
        0xCD,
        0xD9,
        0x98,
        0xA7,
    ],
    "gEdkiiVariableLockProtocolGuid": [
        0xCD3D0A05,
        0x9E24,
        0x437C,
        0xA8,
        0x91,
        0x1E,
        0xE0,
        0x53,
        0xDB,
        0x76,
        0x38,
    ],
    "gEdkiiVarCheckProtocolGuid": [
        0xAF23B340,
        0x97B4,
        0x4685,
        0x8D,
        0x4F,
        0xA3,
        0xF2,
        0x81,
        0x69,
        0xB2,
        0x1D,
    ],
    "gEdkiiSmmVarCheckProtocolGuid": [
        0xB0D8F3C1,
        0xB7DE,
        0x4C11,
        0xBC,
        0x89,
        0x2F,
        0xB5,
        0x62,
        0xC8,
        0xC4,
        0x11,
    ],
    "gEfiSmmFirmwareVolumeBlockProtocolGuid": [
        0xD326D041,
        0xBD31,
        0x4C01,
        0xB5,
        0xA8,
        0x62,
        0x8B,
        0xE8,
        0x7F,
        0x6,
        0x53,
    ],
    "gEfiDebugMaskProtocolGuid": [
        0x4C8A2451,
        0xC207,
        0x405B,
        0x96,
        0x94,
        0x99,
        0xEA,
        0x13,
        0x25,
        0x13,
        0x41,
    ],
    "gEfiLockBoxProtocolGuid": [
        0xBD445D79,
        0xB7AD,
        0x4F04,
        0x9A,
        0xD8,
        0x29,
        0xBD,
        0x20,
        0x40,
        0xEB,
        0x3C,
    ],
    "gEdkiiFormBrowserExProtocolGuid": [
        0x1F73B18D,
        0x4630,
        0x43C1,
        0xA1,
        0xDE,
        0x6F,
        0x80,
        0x85,
        0x5D,
        0x7D,
        0xA4,
    ],
    "gEfiEbcVmTestProtocolGuid": [
        0xAAEACCFD,
        0xF27B,
        0x4C17,
        0xB6,
        0x10,
        0x75,
        0xCA,
        0x1F,
        0x2D,
        0xFB,
        0x52,
    ],
    "gEfiEbcSimpleDebuggerProtocolGuid": [
        0x2A72D11E,
        0x7376,
        0x40F6,
        0x9C,
        0x68,
        0x23,
        0xFA,
        0x2F,
        0xE3,
        0x63,
        0xF1,
    ],
    "gEfiBootLogoProtocolGuid": [
        0xCDEA2BD3,
        0xFC25,
        0x4C1C,
        0xB9,
        0x7C,
        0xB3,
        0x11,
        0x86,
        0x6,
        0x49,
        0x90,
    ],
    "gEdkiiBootLogo2ProtocolGuid": [
        0x4B5DC1DF,
        0x1EAA,
        0x48B2,
        0xA7,
        0xE9,
        0xEA,
        0xC4,
        0x89,
        0xA0,
        0xB,
        0x5C,
    ],
    "gEdkiiFormDisplayEngineProtocolGuid": [
        0x9BBE29E9,
        0xFDA1,
        0x41EC,
        0xAD,
        0x52,
        0x45,
        0x22,
        0x13,
        0x74,
        0x2D,
        0x2E,
    ],
    "gEdkiiFormBrowserEx2ProtocolGuid": [
        0xA770C357,
        0xB693,
        0x4E6D,
        0xA6,
        0xCF,
        0xD2,
        0x1C,
        0x72,
        0x8E,
        0x55,
        0xB,
    ],
    "gEdkiiUfsHostControllerProtocolGuid": [
        0xEBC01AF5,
        0x7A9,
        0x489E,
        0xB7,
        0xCE,
        0xDC,
        0x8,
        0x9E,
        0x45,
        0x9B,
        0x2F,
    ],
    "gEdkiiUfsHcPlatformProtocolGuid": [
        0x3D18BA13,
        0xD9B1,
        0x4DD4,
        0xB9,
        0x16,
        0xD3,
        0x07,
        0x96,
        0x53,
        0x9E,
        0xD8,
    ],
    "gEsrtManagementProtocolGuid": [
        0xA340C064,
        0x723C,
        0x4A9C,
        0xA4,
        0xDD,
        0xD5,
        0xB4,
        0x7A,
        0x26,
        0xFB,
        0xB0,
    ],
    "gEdkiiSmmExitBootServicesProtocolGuid": [
        0x296EB418,
        0xC4C8,
        0x4E05,
        0xAB,
        0x59,
        0x39,
        0xE8,
        0xAF,
        0x56,
        0xF0,
        0xA,
    ],
    "gEdkiiSmmLegacyBootProtocolGuid": [
        0x85A8AB57,
        0x644,
        0x4110,
        0x85,
        0xF,
        0x98,
        0x13,
        0x22,
        0x4,
        0x70,
        0x70,
    ],
    "gEdkiiSmmReadyToBootProtocolGuid": [
        0x6E057ECF,
        0xFA99,
        0x4F39,
        0x95,
        0xBC,
        0x59,
        0xF9,
        0x92,
        0x1D,
        0x17,
        0xE4,
    ],
    "gEdkiiPlatformLogoProtocolGuid": [
        0x53CD299F,
        0x2BC1,
        0x40C0,
        0x8C,
        0x07,
        0x23,
        0xF6,
        0x4F,
        0xDB,
        0x30,
        0xE0,
    ],
    "gEfiFileExplorerProtocolGuid": [
        0x2C03C536,
        0x4594,
        0x4515,
        0x9E,
        0x7A,
        0xD3,
        0xD2,
        0x04,
        0xFE,
        0x13,
        0x63,
    ],
    "gIpmiProtocolGuid": [
        0xDBC6381F,
        0x5554,
        0x4D14,
        0x8F,
        0xFD,
        0x76,
        0xD7,
        0x87,
        0xB8,
        0xAC,
        0xBF,
    ],
    "gSmmIpmiProtocolGuid": [
        0x5169AF60,
        0x8C5A,
        0x4243,
        0xB3,
        0xE9,
        0x56,
        0xC5,
        0x6D,
        0x18,
        0xEE,
        0x26,
    ],
    "gEfiPs2PolicyProtocolGuid": [
        0x4DF19259,
        0xDC71,
        0x4D46,
        0xBE,
        0xF1,
        0x35,
        0x7B,
        0xB5,
        0x78,
        0xC4,
        0x18,
    ],
    "gEdkiiNonDiscoverableDeviceProtocolGuid": [
        0x0D51905B,
        0xB77E,
        0x452A,
        0xA2,
        0xC0,
        0xEC,
        0xA0,
        0xCC,
        0x8D,
        0x51,
        0x4A,
    ],
    "gEdkiiIoMmuProtocolGuid": [
        0x4E939DE9,
        0xD948,
        0x4B0F,
        0x88,
        0xED,
        0xE6,
        0xE1,
        0xCE,
        0x51,
        0x7C,
        0x1E,
    ],
    "gEdkiiDeviceSecurityProtocolGuid": [
        0x5D6B38C8,
        0x5510,
        0x4458,
        0xB4,
        0x8D,
        0x95,
        0x81,
        0xCF,
        0xA7,
        0xB0,
        0xD,
    ],
    "gEdkiiDeviceIdentifierTypePciGuid": [
        0x2509B2F1,
        0xA022,
        0x4CCA,
        0xAF,
        0x70,
        0xF9,
        0xD3,
        0x21,
        0xFB,
        0x66,
        0x49,
    ],
    "gEdkiiDeviceIdentifierTypeUsbGuid": [
        0x7394F350,
        0x394D,
        0x488C,
        0xBB,
        0x75,
        0xC,
        0xAB,
        0x7B,
        0x12,
        0xA,
        0xC5,
    ],
    "gEdkiiSmmMemoryAttributeProtocolGuid": [
        0x69B792EA,
        0x39CE,
        0x402D,
        0xA2,
        0xA6,
        0xF7,
        0x21,
        0xDE,
        0x35,
        0x1D,
        0xFE,
    ],
    "gEdkiiSdMmcOverrideProtocolGuid": [
        0xEAF9E3C1,
        0xC9CD,
        0x46DB,
        0xA5,
        0xE5,
        0x5A,
        0x12,
        0x4C,
        0x83,
        0x23,
        0x23,
    ],
    "gEdkiiPlatformSpecificResetFilterProtocolGuid": [
        0x695D7835,
        0x8D47,
        0x4C11,
        0xAB,
        0x22,
        0xFA,
        0x8A,
        0xCC,
        0xE7,
        0xAE,
        0x7A,
    ],
    "gEdkiiPlatformSpecificResetHandlerProtocolGuid": [
        0x2DF6BA0B,
        0x7092,
        0x440D,
        0xBD,
        0x4,
        0xFB,
        0x9,
        0x1E,
        0xC3,
        0xF3,
        0xC1,
    ],
    "gEdkiiFirmwareManagementProgressProtocolGuid": [
        0x1849BDA2,
        0x6952,
        0x4E86,
        0xA1,
        0xDB,
        0x55,
        0x9A,
        0x3C,
        0x47,
        0x9D,
        0xF1,
    ],
    "gEdkiiAtaAtapiPolicyProtocolGuid": [
        0xE59CD769,
        0x5083,
        0x4F26,
        0x90,
        0x94,
        0x6C,
        0x91,
        0x9F,
        0x91,
        0x6C,
        0x4E,
    ],
    "gEdkiiPeCoffImageEmulatorProtocolGuid": [
        0x96F46153,
        0x97A7,
        0x4793,
        0xAC,
        0xC1,
        0xFA,
        0x19,
        0xBF,
        0x78,
        0xEA,
        0x97,
    ],
    "gEdkiiPlatformBootManagerProtocolGuid": [
        0xAA17ADD4,
        0x756C,
        0x460D,
        0x94,
        0xB8,
        0x43,
        0x88,
        0xD7,
        0xFB,
        0x3E,
        0x59,
    ],
    # Guids from .\edk2\MdePkg\MdePkg.dec file
    "gEfiGlobalVariableGuid": [
        0x8BE4DF61,
        0x93CA,
        0x11D2,
        0xAA,
        0x0D,
        0x00,
        0xE0,
        0x98,
        0x03,
        0x2B,
        0x8C,
    ],
    "gEfiVT100PlusGuid": [
        0x7BAEC70B,
        0x57E0,
        0x4C76,
        0x8E,
        0x87,
        0x2F,
        0x9E,
        0x28,
        0x08,
        0x83,
        0x43,
    ],
    "gEfiVT100Guid": [
        0xDFA66065,
        0xB419,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiPcAnsiGuid": [
        0xE0C14753,
        0xF9BE,
        0x11D2,
        0x9A,
        0x0C,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiVTUTF8Guid": [
        0xAD15A0D6,
        0x8BEC,
        0x4ACF,
        0xA0,
        0x73,
        0xD0,
        0x1D,
        0xE7,
        0x7E,
        0x2D,
        0x88,
    ],
    "gEfiUartDevicePathGuid": [
        0x37499A9D,
        0x542F,
        0x4C89,
        0xA0,
        0x26,
        0x35,
        0xDA,
        0x14,
        0x20,
        0x94,
        0xE4,
    ],
    "gEfiSasDevicePathGuid": [
        0xD487DDB4,
        0x008B,
        0x11D9,
        0xAF,
        0xDC,
        0x00,
        0x10,
        0x83,
        0xFF,
        0xCA,
        0x4D,
    ],
    "gEfiPartTypeLegacyMbrGuid": [
        0x024DEE41,
        0x33E7,
        0x11D3,
        0x9D,
        0x69,
        0x00,
        0x08,
        0xC7,
        0x81,
        0xF3,
        0x9F,
    ],
    "gEfiPartTypeSystemPartGuid": [
        0xC12A7328,
        0xF81F,
        0x11D2,
        0xBA,
        0x4B,
        0x00,
        0xA0,
        0xC9,
        0x3E,
        0xC9,
        0x3B,
    ],
    "gEfiPartTypeUnusedGuid": [
        0x00000000,
        0x0000,
        0x0000,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
    ],
    "gEfiDebugImageInfoTableGuid": [
        0x49152E77,
        0x1ADA,
        0x4764,
        0xB7,
        0xA2,
        0x7A,
        0xFE,
        0xFE,
        0xD9,
        0x5E,
        0x8B,
    ],
    "gEfiAcpiTableGuid": [
        0x8868E871,
        0xE4F1,
        0x11D3,
        0xBC,
        0x22,
        0x00,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "gEfiAcpi20TableGuid": [
        0x8868E871,
        0xE4F1,
        0x11D3,
        0xBC,
        0x22,
        0x00,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "gEfiAcpi10TableGuid": [
        0xEB9D2D30,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiSmbiosTableGuid": [
        0xEB9D2D31,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiMpsTableGuid": [
        0xEB9D2D2F,
        0x2D88,
        0x11D3,
        0x9A,
        0x16,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiAuthenticationChapLocalGuid": [
        0xC280C73E,
        0x15CA,
        0x11DA,
        0xB0,
        0xCA,
        0x00,
        0x10,
        0x83,
        0xFF,
        0xCA,
        0x4D,
    ],
    "gEfiAuthenticationChapRadiusGuid": [
        0xD6062B50,
        0x15CA,
        0x11DA,
        0x92,
        0x19,
        0x00,
        0x10,
        0x83,
        0xFF,
        0xCA,
        0x4D,
    ],
    "gEfiFileSystemVolumeLabelInfoIdGuid": [
        0xDB47D7D3,
        0xFE81,
        0x11D3,
        0x9A,
        0x35,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiFileSystemInfoGuid": [
        0x09576E93,
        0x6D3F,
        0x11D2,
        0x8E,
        0x39,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiFileInfoGuid": [
        0x09576E92,
        0x6D3F,
        0x11D2,
        0x8E,
        0x39,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gBootObjectAuthorizationParmsetGuid": [
        0xEDD35E31,
        0x07B9,
        0x11D2,
        0x83,
        0xA3,
        0x00,
        0xA0,
        0xC9,
        0x1F,
        0xAD,
        0xCF,
    ],
    "gEfiPlatformToDriverConfigurationClpGuid": [
        0x345ECC0E,
        0xCB6,
        0x4B75,
        0xBB,
        0x57,
        0x1B,
        0x12,
        0x9C,
        0x47,
        0x33,
        0x3E,
    ],
    "gEfiHiiKeyBoardLayoutGuid": [
        0x14982A4F,
        0xB0ED,
        0x45B8,
        0xA8,
        0x11,
        0x5A,
        0x7A,
        0x9B,
        0xC2,
        0x32,
        0xDF,
    ],
    "gEfiHashAlgorithmMD5Guid": [
        0x0AF7C79C,
        0x65B5,
        0x4319,
        0xB0,
        0xAE,
        0x44,
        0xEC,
        0x48,
        0x4E,
        0x4A,
        0xD7,
    ],
    "gEfiHashAlgorithmSha512Guid": [
        0xCAA4381E,
        0x750C,
        0x4770,
        0xB8,
        0x70,
        0x7A,
        0x23,
        0xB4,
        0xE4,
        0x21,
        0x30,
    ],
    "gEfiHashAlgorithmSha384Guid": [
        0xEFA96432,
        0xDE33,
        0x4DD2,
        0xAE,
        0xE6,
        0x32,
        0x8C,
        0x33,
        0xDF,
        0x77,
        0x7A,
    ],
    "gEfiHashAlgorithmSha256Guid": [
        0x51AA59DE,
        0xFDF2,
        0x4EA3,
        0xBC,
        0x63,
        0x87,
        0x5F,
        0xB7,
        0x84,
        0x2E,
        0xE9,
    ],
    "gEfiHashAlgorithmSha224Guid": [
        0x8DF01A06,
        0x9BD5,
        0x4BF7,
        0xB0,
        0x21,
        0xDB,
        0x4F,
        0xD9,
        0xCC,
        0xF4,
        0x5B,
    ],
    "gEfiHashAlgorithmSha1Guid": [
        0x2AE9D80F,
        0x3FB2,
        0x4095,
        0xB7,
        0xB1,
        0xE9,
        0x31,
        0x57,
        0xB9,
        0x46,
        0xB6,
    ],
    "gEfiEventReadyToBootGuid": [
        0x7CE88FB3,
        0x4BD7,
        0x4679,
        0x87,
        0xA8,
        0xA8,
        0xD8,
        0xDE,
        0xE5,
        0x0D,
        0x2B,
    ],
    "gEfiEventMemoryMapChangeGuid": [
        0x78BEE926,
        0x692F,
        0x48FD,
        0x9E,
        0xDB,
        0x01,
        0x42,
        0x2E,
        0xF0,
        0xD7,
        0xAB,
    ],
    "gEfiEventVirtualAddressChangeGuid": [
        0x13FA7698,
        0xC831,
        0x49C7,
        0x87,
        0xEA,
        0x8F,
        0x43,
        0xFC,
        0xC2,
        0x51,
        0x96,
    ],
    "gEfiEventExitBootServicesGuid": [
        0x27ABF055,
        0xB1B8,
        0x4C26,
        0x80,
        0x48,
        0x74,
        0x8F,
        0x37,
        0xBA,
        0xA2,
        0xDF,
    ],
    "gEfiDebugPortVariableGuid": [
        0xEBA4E8D2,
        0x3858,
        0x41EC,
        0xA2,
        0x81,
        0x26,
        0x47,
        0xBA,
        0x96,
        0x60,
        0xD0,
    ],
    "gEfiDebugPortDevicePathGuid": [
        0xEBA4E8D2,
        0x3858,
        0x41EC,
        0xA2,
        0x81,
        0x26,
        0x47,
        0xBA,
        0x96,
        0x60,
        0xD0,
    ],
    "gEfiHiiPlatformSetupFormsetGuid": [
        0x93039971,
        0x8545,
        0x4B04,
        0xB4,
        0x5E,
        0x32,
        0xEB,
        0x83,
        0x26,
        0x04,
        0x0E,
    ],
    "gEfiHiiDriverHealthFormsetGuid": [
        0xF22FC20C,
        0x8CF4,
        0x45EB,
        0x8E,
        0x6,
        0xAD,
        0x4E,
        0x50,
        0xB9,
        0x5D,
        0xD3,
    ],
    "gEfiHiiUserCredentialFormsetGuid": [
        0x337F4407,
        0x5AEE,
        0x4B83,
        0xB2,
        0xA7,
        0x4E,
        0xAD,
        0xCA,
        0x30,
        0x88,
        0xCD,
    ],
    "gEfiHiiStandardFormGuid": [
        0x3BD2F4EC,
        0xE524,
        0x46E4,
        0xA9,
        0xD8,
        0x51,
        0x1,
        0x17,
        0x42,
        0x55,
        0x62,
    ],
    "gEfiMemoryOverwriteControlDataGuid": [
        0xE20939BE,
        0x32D4,
        0x41BE,
        0xA1,
        0x50,
        0x89,
        0x7F,
        0x85,
        0xD4,
        0x98,
        0x29,
    ],
    "gEfiMemoryOverwriteRequestControlLockGuid": [
        0xBB983CCF,
        0x151D,
        0x40E1,
        0xA0,
        0x7B,
        0x4A,
        0x17,
        0xBE,
        0x16,
        0x82,
        0x92,
    ],
    "gEfiCertTypeRsa2048Sha256Guid": [
        0xA7717414,
        0xC616,
        0x4977,
        0x94,
        0x20,
        0x84,
        0x47,
        0x12,
        0xA7,
        0x35,
        0xBF,
    ],
    "gEfiEventNotificationTypeCmcGuid": [
        0x2DCE8BB1,
        0xBDD7,
        0x450E,
        0xB9,
        0xAD,
        0x9C,
        0xF4,
        0xEB,
        0xD4,
        0xF8,
        0x90,
    ],
    "gEfiEventNotificationTypeCpeGuid": [
        0x4E292F96,
        0xD843,
        0x4A55,
        0xA8,
        0xC2,
        0xD4,
        0x81,
        0xF2,
        0x7E,
        0xBE,
        0xEE,
    ],
    "gEfiEventNotificationTypeMceGuid": [
        0xE8F56FFE,
        0x919C,
        0x4CC5,
        0xBA,
        0x88,
        0x65,
        0xAB,
        0xE1,
        0x49,
        0x13,
        0xBB,
    ],
    "gEfiEventNotificationTypePcieGuid": [
        0xCF93C01F,
        0x1A16,
        0x4DFC,
        0xB8,
        0xBC,
        0x9C,
        0x4D,
        0xAF,
        0x67,
        0xC1,
        0x04,
    ],
    "gEfiEventNotificationTypeInitGuid": [
        0xCC5263E8,
        0x9308,
        0x454A,
        0x89,
        0xD0,
        0x34,
        0x0B,
        0xD3,
        0x9B,
        0xC9,
        0x8E,
    ],
    "gEfiEventNotificationTypeNmiGuid": [
        0x5BAD89FF,
        0xB7E6,
        0x42C9,
        0x81,
        0x4A,
        0xCF,
        0x24,
        0x85,
        0xD6,
        0xE9,
        0x8A,
    ],
    "gEfiEventNotificationTypeBootGuid": [
        0x3D61A466,
        0xAB40,
        0x409A,
        0xA6,
        0x98,
        0xF3,
        0x62,
        0xD4,
        0x64,
        0xB3,
        0x8F,
    ],
    "gEfiEventNotificationTypeDmarGuid": [
        0x667DD791,
        0xC6B3,
        0x4C27,
        0x8A,
        0x6B,
        0x0F,
        0x8E,
        0x72,
        0x2D,
        0xEB,
        0x41,
    ],
    "gEfiProcessorGenericErrorSectionGuid": [
        0x9876CCAD,
        0x47B4,
        0x4BDB,
        0xB6,
        0x5E,
        0x16,
        0xF1,
        0x93,
        0xC4,
        0xF3,
        0xDB,
    ],
    "gEfiProcessorSpecificErrorSectionGuid": [
        0xDC3EA0B0,
        0xA144,
        0x4797,
        0xB9,
        0x5B,
        0x53,
        0xFA,
        0x24,
        0x2B,
        0x6E,
        0x1D,
    ],
    "gEfiIa32X64ProcessorErrorSectionGuid": [
        0xDC3EA0B0,
        0xA144,
        0x4797,
        0xB9,
        0x5B,
        0x53,
        0xFA,
        0x24,
        0x2B,
        0x6E,
        0x1D,
    ],
    "gEfiPlatformMemoryErrorSectionGuid": [
        0xA5BC1114,
        0x6F64,
        0x4EDE,
        0xB8,
        0x63,
        0x3E,
        0x83,
        0xED,
        0x7C,
        0x83,
        0xB1,
    ],
    "gEfiPcieErrorSectionGuid": [
        0xD995E954,
        0xBBC1,
        0x430F,
        0xAD,
        0x91,
        0xB4,
        0x4D,
        0xCB,
        0x3C,
        0x6F,
        0x35,
    ],
    "gEfiFirmwareErrorSectionGuid": [
        0x81212A96,
        0x09ED,
        0x4996,
        0x94,
        0x71,
        0x8D,
        0x72,
        0x9C,
        0x8E,
        0x69,
        0xED,
    ],
    "gEfiPciBusErrorSectionGuid": [
        0xC5753963,
        0x3B84,
        0x4095,
        0xBF,
        0x78,
        0xED,
        0xDA,
        0xD3,
        0xF9,
        0xC9,
        0xDD,
    ],
    "gEfiPciDevErrorSectionGuid": [
        0xEB5E4685,
        0xCA66,
        0x4769,
        0xB6,
        0xA2,
        0x26,
        0x06,
        0x8B,
        0x00,
        0x13,
        0x26,
    ],
    "gEfiDMArGenericErrorSectionGuid": [
        0x5B51FEF7,
        0xC79D,
        0x4434,
        0x8F,
        0x1B,
        0xAA,
        0x62,
        0xDE,
        0x3E,
        0x2C,
        0x64,
    ],
    "gEfiDirectedIoDMArErrorSectionGuid": [
        0x71761D37,
        0x32B2,
        0x45CD,
        0xA7,
        0xD0,
        0xB0,
        0xFE,
        0xDD,
        0x93,
        0xE8,
        0xCF,
    ],
    "gEfiIommuDMArErrorSectionGuid": [
        0x036F84E1,
        0x7F37,
        0x428C,
        0xA7,
        0x9E,
        0x57,
        0x5F,
        0xDF,
        0xAA,
        0x84,
        0xEC,
    ],
    "gEfiEventUserProfileChangedGuid": [
        0xBAF1E6DE,
        0x209E,
        0x4ADB,
        0x8D,
        0x96,
        0xFD,
        0x8B,
        0x71,
        0xF3,
        0xF6,
        0x83,
    ],
    "gEfiUserCredentialClassUnknownGuid": [
        0x5CF32E68,
        0x7660,
        0x449B,
        0x80,
        0xE6,
        0x7E,
        0xA3,
        0x6E,
        0x3,
        0xF6,
        0xA8,
    ],
    "gEfiUserCredentialClassPasswordGuid": [
        0xF8E5058C,
        0xCCB6,
        0x4714,
        0xB2,
        0x20,
        0x3F,
        0x7E,
        0x3A,
        0x64,
        0xB,
        0xD1,
    ],
    "gEfiUserCredentialClassSmartCardGuid": [
        0x5F03BA33,
        0x8C6B,
        0x4C24,
        0xAA,
        0x2E,
        0x14,
        0xA2,
        0x65,
        0x7B,
        0xD4,
        0x54,
    ],
    "gEfiUserCredentialClassFingerprintGuid": [
        0x32CBA21F,
        0xF308,
        0x4CBC,
        0x9A,
        0xB5,
        0xF5,
        0xA3,
        0x69,
        0x9F,
        0x4,
        0x4A,
    ],
    "gEfiUserCredentialClassHandprintGuid": [
        0x5917EF16,
        0xF723,
        0x4BB9,
        0xA6,
        0x4B,
        0xD8,
        0xC5,
        0x32,
        0xF4,
        0xD8,
        0xB5,
    ],
    "gEfiUserCredentialClassSecureCardGuid": [
        0x8A6B4A83,
        0x42FE,
        0x45D2,
        0xA2,
        0xEF,
        0x46,
        0xF0,
        0x6C,
        0x7D,
        0x98,
        0x52,
    ],
    "gEfiUserInfoAccessSetupAdminGuid": [
        0x85B75607,
        0xF7CE,
        0x471E,
        0xB7,
        0xE4,
        0x2A,
        0xEA,
        0x5F,
        0x72,
        0x32,
        0xEE,
    ],
    "gEfiUserInfoAccessSetupNormalGuid": [
        0x1DB29AE0,
        0x9DCB,
        0x43BC,
        0x8D,
        0x87,
        0x5D,
        0xA1,
        0x49,
        0x64,
        0xDD,
        0xE2,
    ],
    "gEfiUserInfoAccessSetupRestrictedGuid": [
        0xBDB38125,
        0x4D63,
        0x49F4,
        0x82,
        0x12,
        0x61,
        0xCF,
        0x5A,
        0x19,
        0xA,
        0xF8,
    ],
    "gEfiImageSecurityDatabaseGuid": [
        0xD719B2CB,
        0x3D3A,
        0x4596,
        0xA3,
        0xBC,
        0xDA,
        0xD0,
        0xE,
        0x67,
        0x65,
        0x6F,
    ],
    "gEfiCertSha256Guid": [
        0xC1C41626,
        0x504C,
        0x4092,
        0xAC,
        0xA9,
        0x41,
        0xF9,
        0x36,
        0x93,
        0x43,
        0x28,
    ],
    "gEfiCertRsa2048Guid": [
        0x3C5766E8,
        0x269C,
        0x4E34,
        0xAA,
        0x14,
        0xED,
        0x77,
        0x6E,
        0x85,
        0xB3,
        0xB6,
    ],
    "gEfiCertRsa2048Sha256Guid": [
        0xE2B36190,
        0x879B,
        0x4A3D,
        0xAD,
        0x8D,
        0xF2,
        0xE7,
        0xBB,
        0xA3,
        0x27,
        0x84,
    ],
    "gEfiCertSha1Guid": [
        0x826CA512,
        0xCF10,
        0x4AC9,
        0xB1,
        0x87,
        0xBE,
        0x1,
        0x49,
        0x66,
        0x31,
        0xBD,
    ],
    "gEfiCertRsa2048Sha1Guid": [
        0x67F8444F,
        0x8743,
        0x48F1,
        0xA3,
        0x28,
        0x1E,
        0xAA,
        0xB8,
        0x73,
        0x60,
        0x80,
    ],
    "gEfiCertX509Guid": [
        0xA5C059A1,
        0x94E4,
        0x4AA7,
        0x87,
        0xB5,
        0xAB,
        0x15,
        0x5C,
        0x2B,
        0xF0,
        0x72,
    ],
    "gEfiKmsFormatGeneric128Guid": [
        0xEC8A3D69,
        0x6DDF,
        0x4108,
        0x94,
        0x76,
        0x73,
        0x37,
        0xFC,
        0x52,
        0x21,
        0x36,
    ],
    "gEfiKmsFormatGeneric160Guid": [
        0xA3B3E6F8,
        0xEFCA,
        0x4BC1,
        0x88,
        0xFB,
        0xCB,
        0x87,
        0x33,
        0x9B,
        0x25,
        0x79,
    ],
    "gEfiKmsFormatGeneric256Guid": [
        0x70F64793,
        0xC323,
        0x4261,
        0xAC,
        0x2C,
        0xD8,
        0x76,
        0xF2,
        0x7C,
        0x53,
        0x45,
    ],
    "gEfiKmsFormatGeneric512Guid": [
        0x978FE043,
        0xD7AF,
        0x422E,
        0x8A,
        0x92,
        0x2B,
        0x48,
        0xE4,
        0x63,
        0xBD,
        0xE6,
    ],
    "gEfiKmsFormatGeneric1024Guid": [
        0x43BE0B44,
        0x874B,
        0x4EAD,
        0xB0,
        0x9C,
        0x24,
        0x1A,
        0x4F,
        0xBD,
        0x7E,
        0xB3,
    ],
    "gEfiKmsFormatGeneric2048Guid": [
        0x40093F23,
        0x630C,
        0x4626,
        0x9C,
        0x48,
        0x40,
        0x37,
        0x3B,
        0x19,
        0xCB,
        0xBE,
    ],
    "gEfiKmsFormatGeneric3072Guid": [
        0xB9237513,
        0x6C44,
        0x4411,
        0xA9,
        0x90,
        0x21,
        0xE5,
        0x56,
        0xE0,
        0x5A,
        0xDE,
    ],
    "gEfiKmsFormatMd2128Guid": [
        0x78BE11C4,
        0xEE44,
        0x4A22,
        0x9F,
        0x05,
        0x03,
        0x85,
        0x2E,
        0xC5,
        0xC9,
        0x78,
    ],
    "gEfiKmsFormatMdc2128Guid": [
        0xF7AD60F8,
        0xEFA8,
        0x44A3,
        0x91,
        0x13,
        0x23,
        0x1F,
        0x39,
        0x9E,
        0xB4,
        0xC7,
    ],
    "gEfiKmsFormatMd4128Guid": [
        0xD1C17AA1,
        0xCAC5,
        0x400F,
        0xBE,
        0x17,
        0xE2,
        0xA2,
        0xAE,
        0x06,
        0x67,
        0x7C,
    ],
    "gEfiKmsFormatMdc4128Guid": [
        0x3FA4F847,
        0xD8EB,
        0x4DF4,
        0xBD,
        0x49,
        0x10,
        0x3A,
        0x0A,
        0x84,
        0x7B,
        0xBC,
    ],
    "gEfiKmsFormatMd5128Guid": [
        0xDCBC3662,
        0x9CDA,
        0x4B52,
        0xA0,
        0x4C,
        0x82,
        0xEB,
        0x1D,
        0x23,
        0x48,
        0xC7,
    ],
    "gEfiKmsFormatMd5sha128Guid": [
        0x1C178237,
        0x6897,
        0x459E,
        0x9D,
        0x36,
        0x67,
        0xCE,
        0x8E,
        0xF9,
        0x4F,
        0x76,
    ],
    "gEfiKmsFormatSha1160Guid": [
        0x453C5E5A,
        0x482D,
        0x43F0,
        0x87,
        0xC9,
        0x59,
        0x41,
        0xF3,
        0xA3,
        0x8A,
        0xC2,
    ],
    "gEfiKmsFormatSha256256Guid": [
        0x6BB4F5CD,
        0x8022,
        0x448D,
        0xBC,
        0x6D,
        0x77,
        0x1B,
        0xAE,
        0x93,
        0x5F,
        0xC6,
    ],
    "gEfiKmsFormatSha512512Guid": [
        0x2F240E12,
        0xE14D,
        0x475C,
        0x83,
        0xB0,
        0xEF,
        0xFF,
        0x22,
        0xD7,
        0x7B,
        0xE7,
    ],
    "gEfiKmsFormatAesxts128Guid": [
        0x4776E33F,
        0xDB47,
        0x479A,
        0xA2,
        0x5F,
        0xA1,
        0xCD,
        0x0A,
        0xFA,
        0xB3,
        0x8B,
    ],
    "gEfiKmsFormatAesxts256Guid": [
        0xDC7E8613,
        0xC4BB,
        0x4DB0,
        0x84,
        0x62,
        0x13,
        0x51,
        0x13,
        0x57,
        0xAB,
        0xE2,
    ],
    "gEfiKmsFormatAescbc128Guid": [
        0xA0E8EE6A,
        0x0E92,
        0x44D4,
        0x86,
        0x1B,
        0x0E,
        0xAA,
        0x4A,
        0xCA,
        0x44,
        0xA2,
    ],
    "gEfiKmsFormatAescbc256Guid": [
        0xD7E69789,
        0x1F68,
        0x45E8,
        0x96,
        0xEF,
        0x3B,
        0x64,
        0x07,
        0xA5,
        0xB2,
        0xDC,
    ],
    "gEfiKmsFormatRsasha11024Guid": [
        0x56417BED,
        0x6BBE,
        0x4882,
        0x86,
        0xA0,
        0x3A,
        0xE8,
        0xBB,
        0x17,
        0xF8,
        0xF9,
    ],
    "gEfiKmsFormatRsasha12048Guid": [
        0xF66447D4,
        0x75A6,
        0x463E,
        0xA8,
        0x19,
        0x07,
        0x7F,
        0x2D,
        0xDA,
        0x05,
        0xE9,
    ],
    "gEfiKmsFormatRsasha2562048Guid": [
        0xA477AF13,
        0x877D,
        0x4060,
        0xBA,
        0xA1,
        0x25,
        0xD1,
        0xBE,
        0xA0,
        0x8A,
        0xD3,
    ],
    "gEfiKmsFormatRsasha2563072Guid": [
        0x4E1356C2,
        0xEED,
        0x463F,
        0x81,
        0x47,
        0x99,
        0x33,
        0xAB,
        0xDB,
        0xC7,
        0xD5,
    ],
    "gEfiCertSha224Guid": [
        0xB6E5233,
        0xA65C,
        0x44C9,
        0x94,
        0x7,
        0xD9,
        0xAB,
        0x83,
        0xBF,
        0xC8,
        0xBD,
    ],
    "gEfiCertSha384Guid": [
        0xFF3E5307,
        0x9FD0,
        0x48C9,
        0x85,
        0xF1,
        0x8A,
        0xD5,
        0x6C,
        0x70,
        0x1E,
        0x1,
    ],
    "gEfiCertSha512Guid": [
        0x93E0FAE,
        0xA6C4,
        0x4F50,
        0x9F,
        0x1B,
        0xD4,
        0x1E,
        0x2B,
        0x89,
        0xC1,
        0x9A,
    ],
    "gEfiCertPkcs7Guid": [
        0x4AAFD29D,
        0x68DF,
        0x49EE,
        0x8A,
        0xA9,
        0x34,
        0x7D,
        0x37,
        0x56,
        0x65,
        0xA7,
    ],
    "gEfiHashAlgorithmSha1NoPadGuid": [
        0x24C5DC2F,
        0x53E2,
        0x40CA,
        0x9E,
        0xD6,
        0xA5,
        0xD9,
        0xA4,
        0x9F,
        0x46,
        0x3B,
    ],
    "gEfiHashAlgorithmSha256NoPadGuid": [
        0x8628752A,
        0x6CB7,
        0x4814,
        0x96,
        0xFC,
        0x24,
        0xA8,
        0x15,
        0xAC,
        0x22,
        0x26,
    ],
    "gEfiFmpCapsuleGuid": [
        0x6DCBD5ED,
        0xE82D,
        0x4C44,
        0xBD,
        0xA1,
        0x71,
        0x94,
        0x19,
        0x9A,
        0xD9,
        0x2A,
    ],
    "gEfiCertX509Sha256Guid": [
        0x3BD2A492,
        0x96C0,
        0x4079,
        0xB4,
        0x20,
        0xFC,
        0xF9,
        0x8E,
        0xF1,
        0x03,
        0xED,
    ],
    "gEfiCertX509Sha384Guid": [
        0x7076876E,
        0x80C2,
        0x4EE6,
        0xAA,
        0xD2,
        0x28,
        0xB3,
        0x49,
        0xA6,
        0x86,
        0x5B,
    ],
    "gEfiCertX509Sha512Guid": [
        0x446DBF63,
        0x2502,
        0x4CDA,
        0xBC,
        0xFA,
        0x24,
        0x65,
        0xD2,
        0xB0,
        0xFE,
        0x9D,
    ],
    "gEfiRngAlgorithmSp80090Hash256Guid": [
        0xA7AF67CB,
        0x603B,
        0x4D42,
        0xBA,
        0x21,
        0x70,
        0xBF,
        0xB6,
        0x29,
        0x3F,
        0x96,
    ],
    "gEfiRngAlgorithmSp80090Hmac256Guid": [
        0xC5149B43,
        0xAE85,
        0x4F53,
        0x99,
        0x82,
        0xB9,
        0x43,
        0x35,
        0xD3,
        0xA9,
        0xE7,
    ],
    "gEfiRngAlgorithmSp80090Ctr256Guid": [
        0x44F0DE6E,
        0x4D8C,
        0x4045,
        0xA8,
        0xC7,
        0x4D,
        0xD1,
        0x68,
        0x85,
        0x6B,
        0x9E,
    ],
    "gEfiRngAlgorithmX9313DesGuid": [
        0x63C4785A,
        0xCA34,
        0x4012,
        0xA3,
        0xC8,
        0x0B,
        0x6A,
        0x32,
        0x4F,
        0x55,
        0x46,
    ],
    "gEfiRngAlgorithmX931AesGuid": [
        0xACD03321,
        0x777E,
        0x4D3D,
        0xB1,
        0xC8,
        0x20,
        0xCF,
        0xD8,
        0x88,
        0x20,
        0xC9,
    ],
    "gEfiRngAlgorithmRaw": [
        0xE43176D7,
        0xB6E8,
        0x4827,
        0xB7,
        0x84,
        0x7F,
        0xFD,
        0xC4,
        0xB6,
        0x85,
        0x61,
    ],
    "gEfiAdapterInfoMediaStateGuid": [
        0xD7C74207,
        0xA831,
        0x4A26,
        0xB1,
        0xF5,
        0xD1,
        0x93,
        0x06,
        0x5C,
        0xE8,
        0xB6,
    ],
    "gEfiAdapterInfoNetworkBootGuid": [
        0x1FBD2960,
        0x4130,
        0x41E5,
        0x94,
        0xAC,
        0xD2,
        0xCF,
        0x03,
        0x7F,
        0xB3,
        0x7C,
    ],
    "gEfiAdapterInfoSanMacAddressGuid": [
        0x114DA5EF,
        0x2CF1,
        0x4E12,
        0x9B,
        0xBB,
        0xC4,
        0x70,
        0xB5,
        0x52,
        0x5,
        0xD9,
    ],
    "gEfiCapsuleReportGuid": [
        0x39B68C46,
        0xF7FB,
        0x441B,
        0xB6,
        0xEC,
        0x16,
        0xB0,
        0xF6,
        0x98,
        0x21,
        0xF3,
    ],
    "gEfiSystemResourceTableGuid": [
        0xB122A263,
        0x3661,
        0x4F68,
        0x99,
        0x29,
        0x78,
        0xF8,
        0xB0,
        0xD6,
        0x21,
        0x80,
    ],
    "gEfiAdapterInfoUndiIpv6SupportGuid": [
        0x4BD56BE3,
        0x4975,
        0x4D8A,
        0xA0,
        0xAD,
        0xC4,
        0x91,
        0x20,
        0x4B,
        0x5D,
        0x4D,
    ],
    "gEfiRegexSyntaxTypePosixExtendedGuid": [
        0x5F05B20F,
        0x4A56,
        0xC231,
        0xFA,
        0x0B,
        0xA7,
        0xB1,
        0xF1,
        0x10,
        0x04,
        0x1D,
    ],
    "gEfiRegexSyntaxTypeEcma262Guid": [
        0x9A473A4A,
        0x4CEB,
        0xB95A,
        0x41,
        0x5E,
        0x5B,
        0xA0,
        0xBC,
        0x63,
        0x9B,
        0x2E,
    ],
    "gEfiRegexSyntaxTypePerlGuid": [
        0x63E60A51,
        0x497D,
        0xD427,
        0xC4,
        0xA5,
        0xB8,
        0xAB,
        0xDC,
        0x3A,
        0xAE,
        0xB6,
    ],
    "gEfiPlatformMemory2ErrorSectionGuid": [
        0x61EC04FC,
        0x48E6,
        0xD813,
        0x25,
        0xC9,
        0x8D,
        0xAA,
        0x44,
        0x75,
        0x0B,
        0x12,
    ],
    "gEfiBlockIoCryptoAlgoAesXtsGuid": [
        0x2F87BA6A,
        0x5C04,
        0x4385,
        0xA7,
        0x80,
        0xF3,
        0xBF,
        0x78,
        0xA9,
        0x7B,
        0xEC,
    ],
    "gEfiBlockIoCryptoAlgoAesCbcMsBitlockerGuid": [
        0x689E4C62,
        0x70BF,
        0x4CF3,
        0x88,
        0xBB,
        0x33,
        0xB3,
        0x18,
        0x26,
        0x86,
        0x70,
    ],
    "gEfiPaddingRsassaPkcs1V1P5Guid": [
        0x9317EC24,
        0x7CB0,
        0x4D0E,
        0x8B,
        0x32,
        0x2E,
        0xD9,
        0x20,
        0x9C,
        0xD8,
        0xAF,
    ],
    "gEfiPaddingRsassaPssGuid": [
        0x7B2349E0,
        0x522D,
        0x4F8E,
        0xB9,
        0x27,
        0x69,
        0xD9,
        0x7C,
        0x9E,
        0x79,
        0x5F,
    ],
    "gEfiPaddingNoneGuid": [
        0x3629DDB1,
        0x228C,
        0x452E,
        0xB6,
        0x16,
        0x09,
        0xED,
        0x31,
        0x6A,
        0x97,
        0x00,
    ],
    "gEfiPaddingRsaesPkcs1V1P5Guid": [
        0xE1C1D0A9,
        0x40B1,
        0x4632,
        0xBD,
        0xCC,
        0xD9,
        0xD6,
        0xE5,
        0x29,
        0x56,
        0x31,
    ],
    "gEfiPaddingRsaesOaepGuid": [
        0xC1E63AC4,
        0xD0CF,
        0x4CE6,
        0x83,
        0x5B,
        0xEE,
        0xD0,
        0xE6,
        0xA8,
        0xA4,
        0x5B,
    ],
    "gEfiSmbios3TableGuid": [
        0xF2FD1544,
        0x9794,
        0x4A2C,
        0x99,
        0x2E,
        0xE5,
        0xBB,
        0xCF,
        0x20,
        0xE3,
        0x94,
    ],
    "gEfiBootManagerPolicyConsoleGuid": [
        0xCAB0E94C,
        0xE15F,
        0x11E3,
        0x91,
        0x8D,
        0xB8,
        0xE8,
        0x56,
        0x2C,
        0xBA,
        0xFA,
    ],
    "gEfiBootManagerPolicyNetworkGuid": [
        0xD04159DC,
        0xE15F,
        0x11E3,
        0xB2,
        0x61,
        0xB8,
        0xE8,
        0x56,
        0x2C,
        0xBA,
        0xFA,
    ],
    "gEfiBootManagerPolicyConnectAllGuid": [
        0x113B2126,
        0xFC8A,
        0x11E3,
        0xBD,
        0x6C,
        0xB8,
        0xE8,
        0x56,
        0x2C,
        0xBA,
        0xFA,
    ],
    "gEfiVirtualDiskGuid": [
        0x77AB535A,
        0x45FC,
        0x624B,
        0x55,
        0x60,
        0xF7,
        0xB2,
        0x81,
        0xD1,
        0xF9,
        0x6E,
    ],
    "gEfiVirtualCdGuid": [
        0x3D5ABD30,
        0x4175,
        0x87CE,
        0x6D,
        0x64,
        0xD2,
        0xAD,
        0xE5,
        0x23,
        0xC4,
        0xBB,
    ],
    "gEfiPersistentVirtualDiskGuid": [
        0x5CEA02C9,
        0x4D07,
        0x69D3,
        0x26,
        0x9F,
        0x44,
        0x96,
        0xFB,
        0xE0,
        0x96,
        0xF9,
    ],
    "gEfiPersistentVirtualCdGuid": [
        0x08018188,
        0x42CD,
        0xBB48,
        0x10,
        0x0F,
        0x53,
        0x87,
        0xD5,
        0x3D,
        0xED,
        0x3D,
    ],
    "gEfiMemoryAttributesTableGuid": [
        0xDCFA911D,
        0x26EB,
        0x469F,
        0xA2,
        0x20,
        0x38,
        0xB7,
        0xDC,
        0x46,
        0x12,
        0x20,
    ],
    "gEfiArmProcessorErrorSectionGuid": [
        0xE19E3D16,
        0xBC11,
        0x11E4,
        0x9C,
        0xAA,
        0xC2,
        0x05,
        0x1D,
        0x5D,
        0x46,
        0xB0,
    ],
    "gEfiHiiImageDecoderNameJpegGuid": [
        0xEFEFD093,
        0x0D9B,
        0x46EB,
        0xA8,
        0x56,
        0x48,
        0x35,
        0x07,
        0x00,
        0xC9,
        0x08,
    ],
    "gEfiHiiImageDecoderNamePngGuid": [
        0xAF060190,
        0x5E3A,
        0x4025,
        0xAF,
        0xBD,
        0xE1,
        0xF9,
        0x05,
        0xBF,
        0xAA,
        0x4C,
    ],
    "gEfiBttAbstractionGuid": [
        0x18633BFC,
        0x1735,
        0x4217,
        0x8A,
        0xC9,
        0x17,
        0x23,
        0x92,
        0x82,
        0xD3,
        0xF8,
    ],
    "gPeiAprioriFileNameGuid": [
        0x1B45CC0A,
        0x156A,
        0x428A,
        0xAF,
        0x62,
        0x49,
        0x86,
        0x4D,
        0xA0,
        0xE6,
        0xE6,
    ],
    "gAprioriGuid": [
        0xFC510EE7,
        0xFFDC,
        0x11D4,
        0xBD,
        0x41,
        0x00,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "gEfiFirmwareFileSystem2Guid": [
        0x8C8CE578,
        0x8A3D,
        0x4F1C,
        0x99,
        0x35,
        0x89,
        0x61,
        0x85,
        0xC3,
        0x2D,
        0xD3,
    ],
    "gEfiFirmwareVolumeTopFileGuid": [
        0x1BA0062E,
        0xC779,
        0x4582,
        0x85,
        0x66,
        0x33,
        0x6A,
        0xE8,
        0xF7,
        0x8F,
        0x09,
    ],
    "gEfiHobMemoryAllocModuleGuid": [
        0xF8E21975,
        0x0899,
        0x4F58,
        0xA4,
        0xBE,
        0x55,
        0x25,
        0xA9,
        0xC6,
        0xD7,
        0x7A,
    ],
    "gEfiHobMemoryAllocStackGuid": [
        0x4ED4BF27,
        0x4092,
        0x42E9,
        0x80,
        0x7D,
        0x52,
        0x7B,
        0x1D,
        0x00,
        0xC9,
        0xBD,
    ],
    "gEfiHobMemoryAllocBspStoreGuid": [
        0x564B33CD,
        0xC92A,
        0x4593,
        0x90,
        0xBF,
        0x24,
        0x73,
        0xE4,
        0x3C,
        0x63,
        0x22,
    ],
    "gEfiEventLegacyBootGuid": [
        0x2A571201,
        0x4966,
        0x47F6,
        0x8B,
        0x86,
        0xF3,
        0x1E,
        0x41,
        0xF3,
        0x2F,
        0x10,
    ],
    "gEfiHobListGuid": [
        0x7739F24C,
        0x93D7,
        0x11D4,
        0x9A,
        0x3A,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiDxeServicesTableGuid": [
        0x05AD34BA,
        0x6F02,
        0x4214,
        0x95,
        0x2E,
        0x4D,
        0xA0,
        0x39,
        0x8E,
        0x2B,
        0xB9,
    ],
    "gEfiMdePkgTokenSpaceGuid": [
        0x914AEBE7,
        0x4635,
        0x459B,
        0xAA,
        0x1C,
        0x11,
        0xE2,
        0x19,
        0xB0,
        0x3A,
        0x10,
    ],
    "gEfiHardwareErrorVariableGuid": [
        0x414E6BDD,
        0xE47B,
        0x47CC,
        0xB2,
        0x44,
        0xBB,
        0x61,
        0x02,
        0x0C,
        0xF5,
        0x16,
    ],
    "gEfiEventDxeDispatchGuid": [
        0x7081E22F,
        0xCAC6,
        0x4053,
        0x94,
        0x68,
        0x67,
        0x57,
        0x82,
        0xCF,
        0x88,
        0xE5,
    ],
    "gEfiDiskInfoIdeInterfaceGuid": [
        0x5E948FE3,
        0x26D3,
        0x42B5,
        0xAF,
        0x17,
        0x61,
        0x02,
        0x87,
        0x18,
        0x8D,
        0xEC,
    ],
    "gEfiDiskInfoScsiInterfaceGuid": [
        0x08F74BAA,
        0xEA36,
        0x41D9,
        0x95,
        0x21,
        0x21,
        0xA7,
        0x0F,
        0x87,
        0x80,
        0xBC,
    ],
    "gEfiDiskInfoUsbInterfaceGuid": [
        0xCB871572,
        0xC11A,
        0x47B5,
        0xB4,
        0x92,
        0x67,
        0x5E,
        0xAF,
        0xA7,
        0x77,
        0x27,
    ],
    "gEfiDiskInfoAhciInterfaceGuid": [
        0x9E498932,
        0x4ABC,
        0x45AF,
        0xA3,
        0x4D,
        0x02,
        0x47,
        0x78,
        0x7B,
        0xE7,
        0xC6,
    ],
    "gEfiStatusCodeDataTypeStringGuid": [
        0x92D11080,
        0x496F,
        0x4D95,
        0xBE,
        0x7E,
        0x03,
        0x74,
        0x88,
        0x38,
        0x2B,
        0x0A,
    ],
    "gEfiStatusCodeSpecificDataGuid": [
        0x335984BD,
        0xE805,
        0x409A,
        0xB8,
        0xF8,
        0xD2,
        0x7E,
        0xCE,
        0x5F,
        0xF7,
        0xA6,
    ],
    "gEfiFirmwareFileSystem3Guid": [
        0x5473C07A,
        0x3DCB,
        0x4DCA,
        0xBD,
        0x6F,
        0x1E,
        0x96,
        0x89,
        0xE7,
        0x34,
        0x9A,
    ],
    "gEfiEndOfDxeEventGroupGuid": [
        0x2CE967A,
        0xDD7E,
        0x4FFC,
        0x9E,
        0xE7,
        0x81,
        0xC,
        0xF0,
        0x47,
        0x8,
        0x80,
    ],
    "gEfiFirmwareContentsSignedGuid": [
        0xF9D89E8,
        0x9259,
        0x4F76,
        0xA5,
        0xAF,
        0xC,
        0x89,
        0xE3,
        0x40,
        0x23,
        0xDF,
    ],
    "gEfiVectorHandoffTableGuid": [
        0x996EC11C,
        0x5397,
        0x4E73,
        0xB5,
        0x8F,
        0x82,
        0x7E,
        0x52,
        0x90,
        0x6D,
        0xEF,
    ],
    "gAdapterInfoPlatformSecurityGuid": [
        0x6BE272C7,
        0x1320,
        0x4CCD,
        0x90,
        0x17,
        0xD4,
        0x61,
        0x2C,
        0x01,
        0x2B,
        0x25,
    ],
    "gEfiDiskInfoNvmeInterfaceGuid": [
        0x3AB14680,
        0x5D3F,
        0x4A4D,
        0xBC,
        0xDC,
        0xCC,
        0x38,
        0x0,
        0x18,
        0xC7,
        0xF7,
    ],
    "gEfiGraphicsInfoHobGuid": [
        0x39F62CCE,
        0x6825,
        0x4669,
        0xBB,
        0x56,
        0x54,
        0x1A,
        0xBA,
        0x75,
        0x3A,
        0x07,
    ],
    "gEfiDiskInfoUfsInterfaceGuid": [
        0x4B3029CC,
        0x6B98,
        0x47FB,
        0xBC,
        0x96,
        0x76,
        0xDC,
        0xB8,
        0x4,
        0x41,
        0xF0,
    ],
    "gEfiGraphicsDeviceInfoHobGuid": [
        0xE5CB2AC9,
        0xD35D,
        0x4430,
        0x93,
        0x6E,
        0x1D,
        0xE3,
        0x32,
        0x47,
        0x8D,
        0xE7,
    ],
    "gEfiSmmSmramMemoryGuid": [
        0x6DADF1D1,
        0xD4CC,
        0x4910,
        0xBB,
        0x6E,
        0x82,
        0xB1,
        0xFD,
        0x80,
        0xFF,
        0x3D,
    ],
    "gEfiDiskInfoSdMmcInterfaceGuid": [
        0x8DEEC992,
        0xD39C,
        0x4A5C,
        0xAB,
        0x6B,
        0x98,
        0x6E,
        0x14,
        0x24,
        0x2B,
        0x9D,
    ],
    "gWindowsUxCapsuleGuid": [
        0x3B8C8162,
        0x188C,
        0x46A4,
        0xAE,
        0xC9,
        0xBE,
        0x43,
        0xF1,
        0xD6,
        0x56,
        0x97,
    ],
    "gTianoCustomDecompressGuid": [
        0xA31280AD,
        0x481E,
        0x41B6,
        0x95,
        0xE8,
        0x12,
        0x7F,
        0x4C,
        0x98,
        0x47,
        0x79,
    ],
    "gEfiIa32X64ErrorTypeCacheCheckGuid": [
        0xA55701F5,
        0xE3EF,
        0x43DE,
        0xAC,
        0x72,
        0x24,
        0x9B,
        0x57,
        0x3F,
        0xAD,
        0x2C,
    ],
    "gEfiIa32X64ErrorTypeTlbCheckGuid": [
        0xFC06B535,
        0x5E1F,
        0x4562,
        0x9F,
        0x25,
        0x0A,
        0x3B,
        0x9A,
        0xDB,
        0x63,
        0xC3,
    ],
    "gEfiIa32X64ErrorTypeBusCheckGuid": [
        0x1CF3F8B3,
        0xC5B1,
        0x49A2,
        0xAA,
        0x59,
        0x5E,
        0xEF,
        0x92,
        0xFF,
        0xA6,
        0x3C,
    ],
    "gEfiIa32X64ErrorTypeMsCheckGuid": [
        0x48AB7F57,
        0xDC34,
        0x4F6C,
        0xA7,
        0xD3,
        0xB0,
        0xB5,
        0xB0,
        0xA7,
        0x43,
        0x14,
    ],
    "gEfiPeiMasterBootModePpiGuid": [
        0x7408D748,
        0xFC8C,
        0x4EE6,
        0x92,
        0x88,
        0xC4,
        0xBE,
        0xC0,
        0x92,
        0xA4,
        0x10,
    ],
    "gEfiDxeIplPpiGuid": [
        0xAE8CE5D,
        0xE448,
        0x4437,
        0xA8,
        0xD7,
        0xEB,
        0xF5,
        0xF1,
        0x94,
        0xF7,
        0x31,
    ],
    "gEfiPeiMemoryDiscoveredPpiGuid": [
        0xF894643D,
        0xC449,
        0x42D1,
        0x8E,
        0xA8,
        0x85,
        0xBD,
        0xD8,
        0xC6,
        0x5B,
        0xDE,
    ],
    "gEfiPeiBootInRecoveryModePpiGuid": [
        0x17EE496A,
        0xD8E4,
        0x4B9A,
        0x94,
        0xD1,
        0xCE,
        0x82,
        0x72,
        0x30,
        0x8,
        0x50,
    ],
    "gEfiEndOfPeiSignalPpiGuid": [
        0x605EA650,
        0xC65C,
        0x42E1,
        0xBA,
        0x80,
        0x91,
        0xA5,
        0x2A,
        0xB6,
        0x18,
        0xC6,
    ],
    "gEfiPeiResetPpiGuid": [
        0xEF398D58,
        0x9DFD,
        0x4103,
        0xBF,
        0x94,
        0x78,
        0xC6,
        0xF4,
        0xFE,
        0x71,
        0x2F,
    ],
    "gEfiPeiStatusCodePpiGuid": [
        0x229832D3,
        0x7A30,
        0x4B36,
        0xB8,
        0x27,
        0xF4,
        0xC,
        0xB7,
        0xD4,
        0x54,
        0x36,
    ],
    "gEfiPeiSecurity2PpiGuid": [
        0xDCD0BE23,
        0x9586,
        0x40F4,
        0xB6,
        0x43,
        0x6,
        0x52,
        0x2C,
        0xED,
        0x4E,
        0xDE,
    ],
    "gEfiTemporaryRamSupportPpiGuid": [
        0xDBE23AA9,
        0xA345,
        0x4B97,
        0x85,
        0xB6,
        0xB2,
        0x26,
        0xF1,
        0x61,
        0x73,
        0x89,
    ],
    "gEfiPeiCpuIoPpiInstalledGuid": [
        0xE6AF1F7B,
        0xFC3F,
        0x46DA,
        0xA8,
        0x28,
        0xA3,
        0xB4,
        0x57,
        0xA4,
        0x42,
        0x82,
    ],
    "gEfiPciCfg2PpiGuid": [
        0x57A449A,
        0x1FDC,
        0x4C06,
        0xBF,
        0xC9,
        0xF5,
        0x3F,
        0x6A,
        0x99,
        0xBB,
        0x92,
    ],
    "gEfiPeiStallPpiGuid": [
        0x1F4C6F90,
        0xB06B,
        0x48D8,
        0xA2,
        0x01,
        0xBA,
        0xE5,
        0xF1,
        0xCD,
        0x7D,
        0x56,
    ],
    "gEfiPeiReadOnlyVariable2PpiGuid": [
        0x2AB86EF5,
        0xECB5,
        0x4134,
        0xB5,
        0x56,
        0x38,
        0x54,
        0xCA,
        0x1F,
        0xE1,
        0xB4,
    ],
    "gEfiSecPlatformInformationPpiGuid": [
        0x6F8C2B35,
        0xFEF4,
        0x448D,
        0x82,
        0x56,
        0xE1,
        0x1B,
        0x19,
        0xD6,
        0x10,
        0x77,
    ],
    "gEfiPeiLoadedImagePpiGuid": [
        0xC1FCD448,
        0x6300,
        0x4458,
        0xB8,
        0x64,
        0x28,
        0xDF,
        0x1,
        0x53,
        0x64,
        0xBC,
    ],
    "gEfiPeiSmbus2PpiGuid": [
        0x9CA93627,
        0xB65B,
        0x4324,
        0xA2,
        0x2,
        0xC0,
        0xB4,
        0x61,
        0x76,
        0x45,
        0x43,
    ],
    "gEfiPeiFirmwareVolumeInfoPpiGuid": [
        0x49EDB1C1,
        0xBF21,
        0x4761,
        0xBB,
        0x12,
        0xEB,
        0x0,
        0x31,
        0xAA,
        0xBB,
        0x39,
    ],
    "gEfiPeiLoadFilePpiGuid": [
        0xB9E0ABFE,
        0x5979,
        0x4914,
        0x97,
        0x7F,
        0x6D,
        0xEE,
        0x78,
        0xC2,
        0x78,
        0xA6,
    ],
    "gEfiPeiDecompressPpiGuid": [
        0x1A36E4E7,
        0xFAB6,
        0x476A,
        0x8E,
        0x75,
        0x69,
        0x5A,
        0x5,
        0x76,
        0xFD,
        0xD7,
    ],
    "gPcdPpiGuid": [
        0x6E81C58,
        0x4AD7,
        0x44BC,
        0x83,
        0x90,
        0xF1,
        0x2,
        0x65,
        0xF7,
        0x24,
        0x80,
    ],
    "gGetPcdInfoPpiGuid": [
        0x4D8B155B,
        0xC059,
        0x4C8F,
        0x89,
        0x26,
        0x6,
        0xFD,
        0x43,
        0x31,
        0xDB,
        0x8A,
    ],
    "gEfiPeiRecoveryModulePpiGuid": [
        0xFB6D9542,
        0x612D,
        0x4F45,
        0x87,
        0x2F,
        0x5C,
        0xFF,
        0x52,
        0xE9,
        0x3D,
        0xCF,
    ],
    "gEfiPeiDeviceRecoveryModulePpiGuid": [
        0x0DE2CE25,
        0x446A,
        0x45A7,
        0xBF,
        0xC9,
        0x37,
        0xDA,
        0x26,
        0x34,
        0x4B,
        0x37,
    ],
    "gEfiPeiVirtualBlockIoPpiGuid": [
        0x695D8AA1,
        0x42EE,
        0x4C46,
        0x80,
        0x5C,
        0x6E,
        0xA6,
        0xBC,
        0xE7,
        0x99,
        0xE3,
    ],
    "gEfiPeiS3Resume2PpiGuid": [
        0x6D582DBC,
        0xDB85,
        0x4514,
        0x8F,
        0xCC,
        0x5A,
        0xDF,
        0x62,
        0x27,
        0xB1,
        0x47,
    ],
    "gEfiPeiRscHandlerPpiGuid": [
        0x65D394,
        0x9951,
        0x4144,
        0x82,
        0xA3,
        0xA,
        0xFC,
        0x85,
        0x79,
        0xC2,
        0x51,
    ],
    "gEfiPeiPcdPpiGuid": [
        0x1F34D25,
        0x4DE2,
        0x23AD,
        0x3F,
        0xF3,
        0x36,
        0x35,
        0x3F,
        0xF3,
        0x23,
        0xF1,
    ],
    "gEfiGetPcdInfoPpiGuid": [
        0xA60C6B59,
        0xE459,
        0x425D,
        0x9C,
        0x69,
        0xB,
        0xCC,
        0x9C,
        0xB2,
        0x7D,
        0x81,
    ],
    "gEfiTemporaryRamDonePpiGuid": [
        0xCEAB683C,
        0xEC56,
        0x4A2D,
        0xA9,
        0x6,
        0x40,
        0x53,
        0xFA,
        0x4E,
        0x9C,
        0x16,
    ],
    "gEfiVectorHandoffInfoPpiGuid": [
        0x3CD652B4,
        0x6D33,
        0x4DCE,
        0x89,
        0xDB,
        0x83,
        0xDF,
        0x97,
        0x66,
        0xFC,
        0xCA,
    ],
    "gEfiIsaHcPpiGuid": [
        0x8D48BD70,
        0xC8A3,
        0x4C06,
        0x90,
        0x1B,
        0x74,
        0x79,
        0x46,
        0xAA,
        0xC3,
        0x58,
    ],
    "gEfiSioPpiGuid": [
        0x23A464AD,
        0xCB83,
        0x48B8,
        0x94,
        0xAB,
        0x1A,
        0x6F,
        0xEF,
        0xCF,
        0xE5,
        0x22,
    ],
    "gEfiPeiI2cMasterPpiGuid": [
        0xB3BFAB9B,
        0x9F9C,
        0x4E8B,
        0xAD,
        0x37,
        0x7F,
        0x8C,
        0x51,
        0xFC,
        0x62,
        0x80,
    ],
    "gEfiPeiFirmwareVolumeInfo2PpiGuid": [
        0xEA7CA24B,
        0xDED5,
        0x4DAD,
        0xA3,
        0x89,
        0xBF,
        0x82,
        0x7E,
        0x8F,
        0x9B,
        0x38,
    ],
    "gEfiPeiGraphicsPpiGuid": [
        0x6ECD1463,
        0x4A4A,
        0x461B,
        0xAF,
        0x5F,
        0x5A,
        0x33,
        0xE3,
        0xB2,
        0x16,
        0x2B,
    ],
    "gEfiPeiMpServicesPpiGuid": [
        0xEE16160A,
        0xE8BE,
        0x47A6,
        0x82,
        0xA,
        0xC6,
        0x90,
        0xD,
        0xB0,
        0x25,
        0xA,
    ],
    "gEfiPeiCapsulePpiGuid": [
        0x3ACF33EE,
        0xD892,
        0x40F4,
        0xA2,
        0xFC,
        0x38,
        0x54,
        0xD2,
        0xE1,
        0x32,
        0x3D,
    ],
    "gPeiCapsulePpiGuid": [
        0x3ACF33EE,
        0xD892,
        0x40F4,
        0xA2,
        0xFC,
        0x38,
        0x54,
        0xD2,
        0xE1,
        0x32,
        0x3D,
    ],
    "gEfiPeiReset2PpiGuid": [
        0x6CC45765,
        0xCCE4,
        0x42FD,
        0xBC,
        0x56,
        0x1,
        0x1A,
        0xAA,
        0xC6,
        0xC9,
        0xA8,
    ],
    "gEfiPeiVirtualBlockIo2PpiGuid": [
        0x26CC0FAD,
        0xBEB3,
        0x478A,
        0x91,
        0xB2,
        0xC,
        0x18,
        0x8F,
        0x72,
        0x61,
        0x98,
    ],
    "gEfiSecPlatformInformation2PpiGuid": [
        0x9E9F374B,
        0x8F16,
        0x4230,
        0x98,
        0x24,
        0x58,
        0x46,
        0xEE,
        0x76,
        0x6A,
        0x97,
    ],
    "gEfiSecHobDataPpiGuid": [
        0x3EBDAF20,
        0x6667,
        0x40D8,
        0xB4,
        0xEE,
        0xF5,
        0x99,
        0x9A,
        0xC1,
        0xB7,
        0x1F,
    ],
    "gEfiPeiMmAccessPpiGuid": [
        0x268F33A9,
        0xCCCD,
        0x48BE,
        0x88,
        0x17,
        0x86,
        0x5,
        0x3A,
        0xC3,
        0x2E,
        0xD6,
    ],
    "gEfiPeiMmControlPpiGuid": [
        0x61C68702,
        0x4D7E,
        0x4F43,
        0x8D,
        0xEF,
        0xA7,
        0x43,
        0x5,
        0xCE,
        0x74,
        0xC5,
    ],
    "gEfiPeiCoreFvLocationPpiGuid": [
        0x52888EAE,
        0x5B10,
        0x47D0,
        0xA8,
        0x7F,
        0xB8,
        0x22,
        0xAB,
        0xA0,
        0xCA,
        0xF4,
    ],
    "gPcdProtocolGuid": [
        0x11B34006,
        0xD85B,
        0x4D0A,
        0xA2,
        0x90,
        0xD5,
        0xA5,
        0x71,
        0x31,
        0x0E,
        0xF7,
    ],
    "gGetPcdInfoProtocolGuid": [
        0x5BE40F57,
        0xFA68,
        0x4610,
        0xBB,
        0xBF,
        0xE9,
        0xC5,
        0xFC,
        0xDA,
        0xD3,
        0x65,
    ],
    "gEfiBdsArchProtocolGuid": [
        0x665E3FF6,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiCpuArchProtocolGuid": [
        0x26BACCB1,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x00,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "gEfiMetronomeArchProtocolGuid": [
        0x26BACCB2,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x00,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "gEfiMonotonicCounterArchProtocolGuid": [
        0x1DA97072,
        0xBDDC,
        0x4B30,
        0x99,
        0xF1,
        0x72,
        0xA0,
        0xB5,
        0x6F,
        0xFF,
        0x2A,
    ],
    "gEfiRealTimeClockArchProtocolGuid": [
        0x27CFAC87,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiResetArchProtocolGuid": [
        0x27CFAC88,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiRuntimeArchProtocolGuid": [
        0xB7DFB4E1,
        0x052F,
        0x449F,
        0x87,
        0xBE,
        0x98,
        0x18,
        0xFC,
        0x91,
        0xB7,
        0x33,
    ],
    "gEfiSecurityArchProtocolGuid": [
        0xA46423E3,
        0x4617,
        0x49F1,
        0xB9,
        0xFF,
        0xD1,
        0xBF,
        0xA9,
        0x11,
        0x58,
        0x39,
    ],
    "gEfiSecurityPolicyProtocolGuid": [
        0x78E4D245,
        0xCD4D,
        0x4A05,
        0xA2,
        0xBA,
        0x47,
        0x43,
        0xE8,
        0x6C,
        0xFC,
        0xAB,
    ],
    "gEfiTimerArchProtocolGuid": [
        0x26BACCB3,
        0x6F42,
        0x11D4,
        0xBC,
        0xE7,
        0x00,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "gEfiVariableWriteArchProtocolGuid": [
        0x6441F818,
        0x6362,
        0x4E44,
        0xB5,
        0x70,
        0x7D,
        0xBA,
        0x31,
        0xDD,
        0x24,
        0x53,
    ],
    "gEfiVariableArchProtocolGuid": [
        0x1E5668E2,
        0x8481,
        0x11D4,
        0xBC,
        0xF1,
        0x00,
        0x80,
        0xC7,
        0x3C,
        0x88,
        0x81,
    ],
    "gEfiWatchdogTimerArchProtocolGuid": [
        0x665E3FF5,
        0x46CC,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiStatusCodeRuntimeProtocolGuid": [
        0xD2B2B828,
        0x0826,
        0x48A7,
        0xB3,
        0xDF,
        0x98,
        0x3C,
        0x00,
        0x60,
        0x24,
        0xF0,
    ],
    "gEfiSmbusHcProtocolGuid": [
        0xE49D33ED,
        0x513D,
        0x4634,
        0xB6,
        0x98,
        0x6F,
        0x55,
        0xAA,
        0x75,
        0x1C,
        0x1B,
    ],
    "gEfiFirmwareVolume2ProtocolGuid": [
        0x220E73B6,
        0x6BDB,
        0x4413,
        0x84,
        0x5,
        0xB9,
        0x74,
        0xB1,
        0x8,
        0x61,
        0x9A,
    ],
    "gEfiFirmwareVolumeBlockProtocolGuid": [
        0x8F644FA9,
        0xE850,
        0x4DB1,
        0x9C,
        0xE2,
        0xB,
        0x44,
        0x69,
        0x8E,
        0x8D,
        0xA4,
    ],
    "gEfiCapsuleArchProtocolGuid": [
        0x5053697E,
        0x2CBC,
        0x4819,
        0x90,
        0xD9,
        0x05,
        0x80,
        0xDE,
        0xEE,
        0x57,
        0x54,
    ],
    "gEfiMpServiceProtocolGuid": [
        0x3FDDA605,
        0xA76E,
        0x4F46,
        0xAD,
        0x29,
        0x12,
        0xF4,
        0x53,
        0x1B,
        0x3D,
        0x08,
    ],
    "gEfiPciHostBridgeResourceAllocationProtocolGuid": [
        0xCF8034BE,
        0x6768,
        0x4D8B,
        0xB7,
        0x39,
        0x7C,
        0xCE,
        0x68,
        0x3A,
        0x9F,
        0xBE,
    ],
    "gEfiPciPlatformProtocolGuid": [
        0x07D75280,
        0x27D4,
        0x4D69,
        0x90,
        0xD0,
        0x56,
        0x43,
        0xE2,
        0x38,
        0xB3,
        0x41,
    ],
    "gEfiPciOverrideProtocolGuid": [
        0xB5B35764,
        0x460C,
        0x4A06,
        0x99,
        0xFC,
        0x77,
        0xA1,
        0x7C,
        0x1B,
        0x5C,
        0xEB,
    ],
    "gEfiPciEnumerationCompleteProtocolGuid": [
        0x30CFE3E7,
        0x3DE1,
        0x4586,
        0xBE,
        0x20,
        0xDE,
        0xAB,
        0xA1,
        0xB3,
        0xB7,
        0x93,
    ],
    "gEfiIncompatiblePciDeviceSupportProtocolGuid": [
        0xEB23F55A,
        0x7863,
        0x4AC2,
        0x8D,
        0x3D,
        0x95,
        0x65,
        0x35,
        0xDE,
        0x03,
        0x75,
    ],
    "gEfiPciHotPlugInitProtocolGuid": [
        0xAA0E8BC1,
        0xDABC,
        0x46B0,
        0xA8,
        0x44,
        0x37,
        0xB8,
        0x16,
        0x9B,
        0x2B,
        0xEA,
    ],
    "gEfiPciHotPlugRequestProtocolGuid": [
        0x19CB87AB,
        0x2CB9,
        0x4665,
        0x83,
        0x60,
        0xDD,
        0xCF,
        0x60,
        0x54,
        0xF7,
        0x9D,
    ],
    "gEfiIdeControllerInitProtocolGuid": [
        0xA1E37052,
        0x80D9,
        0x4E65,
        0xA3,
        0x17,
        0x3E,
        0x9A,
        0x55,
        0xC4,
        0x3E,
        0xC9,
    ],
    "gEfiDiskInfoProtocolGuid": [
        0xD432A67F,
        0x14DC,
        0x484B,
        0xB3,
        0xBB,
        0x3F,
        0x02,
        0x91,
        0x84,
        0x93,
        0x27,
    ],
    "gEfiSmbiosProtocolGuid": [
        0x3583FF6,
        0xCB36,
        0x4940,
        0x94,
        0x7E,
        0xB9,
        0xB3,
        0x9F,
        0x4A,
        0xFA,
        0xF7,
    ],
    "gEfiS3SaveStateProtocolGuid": [
        0xE857CAF6,
        0xC046,
        0x45DC,
        0xBE,
        0x3F,
        0xEE,
        0x7,
        0x65,
        0xFB,
        0xA8,
        0x87,
    ],
    "gEfiS3SmmSaveStateProtocolGuid": [
        0x320AFE62,
        0xE593,
        0x49CB,
        0xA9,
        0xF1,
        0xD4,
        0xC2,
        0xF4,
        0xAF,
        0x1,
        0x4C,
    ],
    "gEfiRscHandlerProtocolGuid": [
        0x86212936,
        0xE76,
        0x41C8,
        0xA0,
        0x3A,
        0x2A,
        0xF2,
        0xFC,
        0x1C,
        0x39,
        0xE2,
    ],
    "gEfiSmmRscHandlerProtocolGuid": [
        0x2FF29FA7,
        0x5E80,
        0x4ED9,
        0xB3,
        0x80,
        0x1,
        0x7D,
        0x3C,
        0x55,
        0x4F,
        0xF4,
    ],
    "gEfiAcpiSdtProtocolGuid": [
        0xEB97088E,
        0xCFDF,
        0x49C6,
        0xBE,
        0x4B,
        0xD9,
        0x6,
        0xA5,
        0xB2,
        0xE,
        0x86,
    ],
    "gEfiSioProtocolGuid": [
        0x215FDD18,
        0xBD50,
        0x4FEB,
        0x89,
        0xB,
        0x58,
        0xCA,
        0xB,
        0x47,
        0x39,
        0xE9,
    ],
    "gEfiSmmCpuIo2ProtocolGuid": [
        0x3242A9D8,
        0xCE70,
        0x4AA0,
        0x95,
        0x5D,
        0x5E,
        0x7B,
        0x14,
        0x0D,
        0xE4,
        0xD2,
    ],
    "gEfiSmmBase2ProtocolGuid": [
        0xF4CCBFB7,
        0xF6E0,
        0x47FD,
        0x9D,
        0xD4,
        0x10,
        0xA8,
        0xF1,
        0x50,
        0xC1,
        0x91,
    ],
    "gEfiSmmAccess2ProtocolGuid": [
        0xC2702B74,
        0x800C,
        0x4131,
        0x87,
        0x46,
        0x8F,
        0xB5,
        0xB8,
        0x9C,
        0xE4,
        0xAC,
    ],
    "gEfiSmmControl2ProtocolGuid": [
        0x843DC720,
        0xAB1E,
        0x42CB,
        0x93,
        0x57,
        0x8A,
        0x0,
        0x78,
        0xF3,
        0x56,
        0x1B,
    ],
    "gEfiSmmConfigurationProtocolGuid": [
        0x26EEB3DE,
        0xB689,
        0x492E,
        0x80,
        0xF0,
        0xBE,
        0x8B,
        0xD7,
        0xDA,
        0x4B,
        0xA7,
    ],
    "gEfiSmmReadyToLockProtocolGuid": [
        0x47B7FA8C,
        0xF4BD,
        0x4AF6,
        0x82,
        0x00,
        0x33,
        0x30,
        0x86,
        0xF0,
        0xD2,
        0xC8,
    ],
    "gEfiDxeSmmReadyToLockProtocolGuid": [
        0x60FF8964,
        0xE906,
        0x41D0,
        0xAF,
        0xED,
        0xF2,
        0x41,
        0xE9,
        0x74,
        0xE0,
        0x8E,
    ],
    "gEfiSmmCommunicationProtocolGuid": [
        0xC68ED8E2,
        0x9DC6,
        0x4CBD,
        0x9D,
        0x94,
        0xDB,
        0x65,
        0xAC,
        0xC5,
        0xC3,
        0x32,
    ],
    "gEfiSmmStatusCodeProtocolGuid": [
        0x6AFD2B77,
        0x98C1,
        0x4ACD,
        0xA6,
        0xF9,
        0x8A,
        0x94,
        0x39,
        0xDE,
        0xF,
        0xB1,
    ],
    "gEfiSmmCpuProtocolGuid": [
        0xEB346B97,
        0x975F,
        0x4A9F,
        0x8B,
        0x22,
        0xF8,
        0xE9,
        0x2B,
        0xB3,
        0xD5,
        0x69,
    ],
    "gEfiSmmPciRootBridgeIoProtocolGuid": [
        0x8BC1714D,
        0xFFCB,
        0x41C3,
        0x89,
        0xDC,
        0x6C,
        0x74,
        0xD0,
        0x6D,
        0x98,
        0xEA,
    ],
    "gEfiSmmSwDispatch2ProtocolGuid": [
        0x18A3C6DC,
        0x5EEA,
        0x48C8,
        0xA1,
        0xC1,
        0xB5,
        0x33,
        0x89,
        0xF9,
        0x89,
        0x99,
    ],
    "gEfiSmmSxDispatch2ProtocolGuid": [
        0x456D2859,
        0xA84B,
        0x4E47,
        0xA2,
        0xEE,
        0x32,
        0x76,
        0xD8,
        0x86,
        0x99,
        0x7D,
    ],
    "gEfiSmmPeriodicTimerDispatch2ProtocolGuid": [
        0x4CEC368E,
        0x8E8E,
        0x4D71,
        0x8B,
        0xE1,
        0x95,
        0x8C,
        0x45,
        0xFC,
        0x8A,
        0x53,
    ],
    "gEfiSmmUsbDispatch2ProtocolGuid": [
        0xEE9B8D90,
        0xC5A6,
        0x40A2,
        0xBD,
        0xE2,
        0x52,
        0x55,
        0x8D,
        0x33,
        0xCC,
        0xA1,
    ],
    "gEfiSmmGpiDispatch2ProtocolGuid": [
        0x25566B03,
        0xB577,
        0x4CBF,
        0x95,
        0x8C,
        0xED,
        0x66,
        0x3E,
        0xA2,
        0x43,
        0x80,
    ],
    "gEfiSmmStandbyButtonDispatch2ProtocolGuid": [
        0x7300C4A1,
        0x43F2,
        0x4017,
        0xA5,
        0x1B,
        0xC8,
        0x1A,
        0x7F,
        0x40,
        0x58,
        0x5B,
    ],
    "gEfiSmmPowerButtonDispatch2ProtocolGuid": [
        0x1B1183FA,
        0x1823,
        0x46A7,
        0x88,
        0x72,
        0x9C,
        0x57,
        0x87,
        0x55,
        0x40,
        0x9D,
    ],
    "gEfiSmmIoTrapDispatch2ProtocolGuid": [
        0x58DC368D,
        0x7BFA,
        0x4E77,
        0xAB,
        0xBC,
        0xE,
        0x29,
        0x41,
        0x8D,
        0xF9,
        0x30,
    ],
    "gEfiPcdProtocolGuid": [
        0x13A3F0F6,
        0x264A,
        0x3EF0,
        0xF2,
        0xE0,
        0xDE,
        0xC5,
        0x12,
        0x34,
        0x2F,
        0x34,
    ],
    "gEfiFirmwareVolumeBlock2ProtocolGuid": [
        0x8F644FA9,
        0xE850,
        0x4DB1,
        0x9C,
        0xE2,
        0xB,
        0x44,
        0x69,
        0x8E,
        0x8D,
        0xA4,
    ],
    "gEfiCpuIo2ProtocolGuid": [
        0xAD61F191,
        0xAE5F,
        0x4C0E,
        0xB9,
        0xFA,
        0xE8,
        0x69,
        0xD2,
        0x88,
        0xC6,
        0x4F,
    ],
    "gEfiLegacyRegion2ProtocolGuid": [
        0x70101EAF,
        0x85,
        0x440C,
        0xB3,
        0x56,
        0x8E,
        0xE3,
        0x6F,
        0xEF,
        0x24,
        0xF0,
    ],
    "gEfiSecurity2ArchProtocolGuid": [
        0x94AB2F58,
        0x1438,
        0x4EF1,
        0x91,
        0x52,
        0x18,
        0x94,
        0x1A,
        0x3A,
        0x0E,
        0x68,
    ],
    "gEfiSmmEndOfDxeProtocolGuid": [
        0x24E70042,
        0xD5C5,
        0x4260,
        0x8C,
        0x39,
        0xA,
        0xD3,
        0xAA,
        0x32,
        0xE9,
        0x3D,
    ],
    "gEfiIsaHcProtocolGuid": [
        0xBCDAF080,
        0x1BDE,
        0x4E22,
        0xAE,
        0x6A,
        0x43,
        0x54,
        0x1E,
        0x12,
        0x8E,
        0xC4,
    ],
    "gEfiIsaHcServiceBindingProtocolGuid": [
        0xFAD7933A,
        0x6C21,
        0x4234,
        0xA4,
        0x34,
        0x0A,
        0x8A,
        0x0D,
        0x2B,
        0x07,
        0x81,
    ],
    "gEfiSioControlProtocolGuid": [
        0xB91978DF,
        0x9FC1,
        0x427D,
        0xBB,
        0x5,
        0x4C,
        0x82,
        0x84,
        0x55,
        0xCA,
        0x27,
    ],
    "gEfiGetPcdInfoProtocolGuid": [
        0xFD0F4478,
        0xEFD,
        0x461D,
        0xBA,
        0x2D,
        0xE5,
        0x8C,
        0x45,
        0xFD,
        0x5F,
        0x5E,
    ],
    "gEfiI2cMasterProtocolGuid": [
        0xCD72881F,
        0x45B5,
        0x4FEB,
        0x98,
        0xC8,
        0x31,
        0x3D,
        0xA8,
        0x11,
        0x74,
        0x62,
    ],
    "gEfiI2cIoProtocolGuid": [
        0xB60A3E6B,
        0x18C4,
        0x46E5,
        0xA2,
        0x9A,
        0xC9,
        0xA1,
        0x06,
        0x65,
        0xA2,
        0x8E,
    ],
    "gEfiI2cEnumerateProtocolGuid": [
        0xDA8CD7C4,
        0x1C00,
        0x49E2,
        0x80,
        0x3E,
        0x52,
        0x14,
        0xE7,
        0x01,
        0x89,
        0x4C,
    ],
    "gEfiI2cHostProtocolGuid": [
        0xA5AAB9E3,
        0xC727,
        0x48CD,
        0x8B,
        0xBF,
        0x42,
        0x72,
        0x33,
        0x85,
        0x49,
        0x48,
    ],
    "gEfiI2cBusConfigurationManagementProtocolGuid": [
        0x55B71FB5,
        0x17C6,
        0x410E,
        0xB5,
        0xBD,
        0x5F,
        0xA2,
        0xE3,
        0xD4,
        0x46,
        0x6B,
    ],
    "gEfiMmMpProtocolGuid": [
        0x5D5450D7,
        0x990C,
        0x4180,
        0xA8,
        0x3,
        0x8E,
        0x63,
        0xF0,
        0x60,
        0x83,
        0x7,
    ],
    "gEfiMmEndOfDxeProtocolGuid": [
        0x24E70042,
        0xD5C5,
        0x4260,
        0x8C,
        0x39,
        0xA,
        0xD3,
        0xAA,
        0x32,
        0xE9,
        0x3D,
    ],
    "gEfiMmIoTrapDispatchProtocolGuid": [
        0x58DC368D,
        0x7BFA,
        0x4E77,
        0xAB,
        0xBC,
        0xE,
        0x29,
        0x41,
        0x8D,
        0xF9,
        0x30,
    ],
    "gEfiMmPowerButtonDispatchProtocolGuid": [
        0x1B1183FA,
        0x1823,
        0x46A7,
        0x88,
        0x72,
        0x9C,
        0x57,
        0x87,
        0x55,
        0x40,
        0x9D,
    ],
    "gEfiMmStandbyButtonDispatchProtocolGuid": [
        0x7300C4A1,
        0x43F2,
        0x4017,
        0xA5,
        0x1B,
        0xC8,
        0x1A,
        0x7F,
        0x40,
        0x58,
        0x5B,
    ],
    "gEfiMmGpiDispatchProtocolGuid": [
        0x25566B03,
        0xB577,
        0x4CBF,
        0x95,
        0x8C,
        0xED,
        0x66,
        0x3E,
        0xA2,
        0x43,
        0x80,
    ],
    "gEfiMmUsbDispatchProtocolGuid": [
        0xEE9B8D90,
        0xC5A6,
        0x40A2,
        0xBD,
        0xE2,
        0x52,
        0x55,
        0x8D,
        0x33,
        0xCC,
        0xA1,
    ],
    "gEfiMmPeriodicTimerDispatchProtocolGuid": [
        0x4CEC368E,
        0x8E8E,
        0x4D71,
        0x8B,
        0xE1,
        0x95,
        0x8C,
        0x45,
        0xFC,
        0x8A,
        0x53,
    ],
    "gEfiMmSxDispatchProtocolGuid": [
        0x456D2859,
        0xA84B,
        0x4E47,
        0xA2,
        0xEE,
        0x32,
        0x76,
        0xD8,
        0x86,
        0x99,
        0x7D,
    ],
    "gEfiMmSwDispatchProtocolGuid": [
        0x18A3C6DC,
        0x5EEA,
        0x48C8,
        0xA1,
        0xC1,
        0xB5,
        0x33,
        0x89,
        0xF9,
        0x89,
        0x99,
    ],
    "gEfiMmPciRootBridgeIoProtocolGuid": [
        0x8BC1714D,
        0xFFCB,
        0x41C3,
        0x89,
        0xDC,
        0x6C,
        0x74,
        0xD0,
        0x6D,
        0x98,
        0xEA,
    ],
    "gEfiMmCpuProtocolGuid": [
        0xEB346B97,
        0x975F,
        0x4A9F,
        0x8B,
        0x22,
        0xF8,
        0xE9,
        0x2B,
        0xB3,
        0xD5,
        0x69,
    ],
    "gEfiMmStatusCodeProtocolGuid": [
        0x6AFD2B77,
        0x98C1,
        0x4ACD,
        0xA6,
        0xF9,
        0x8A,
        0x94,
        0x39,
        0xDE,
        0xF,
        0xB1,
    ],
    "gEfiDxeMmReadyToLockProtocolGuid": [
        0x60FF8964,
        0xE906,
        0x41D0,
        0xAF,
        0xED,
        0xF2,
        0x41,
        0xE9,
        0x74,
        0xE0,
        0x8E,
    ],
    "gEfiMmConfigurationProtocolGuid": [
        0x26EEB3DE,
        0xB689,
        0x492E,
        0x80,
        0xF0,
        0xBE,
        0x8B,
        0xD7,
        0xDA,
        0x4B,
        0xA7,
    ],
    "gEfiMmReadyToLockProtocolGuid": [
        0x47B7FA8C,
        0xF4BD,
        0x4AF6,
        0x82,
        0x00,
        0x33,
        0x30,
        0x86,
        0xF0,
        0xD2,
        0xC8,
    ],
    "gEfiMmControlProtocolGuid": [
        0x843DC720,
        0xAB1E,
        0x42CB,
        0x93,
        0x57,
        0x8A,
        0x0,
        0x78,
        0xF3,
        0x56,
        0x1B,
    ],
    "gEfiMmAccessProtocolGuid": [
        0xC2702B74,
        0x800C,
        0x4131,
        0x87,
        0x46,
        0x8F,
        0xB5,
        0xB8,
        0x9C,
        0xE4,
        0xAC,
    ],
    "gEfiMmBaseProtocolGuid": [
        0xF4CCBFB7,
        0xF6E0,
        0x47FD,
        0x9D,
        0xD4,
        0x10,
        0xA8,
        0xF1,
        0x50,
        0xC1,
        0x91,
    ],
    "gEfiMmCpuIoProtocolGuid": [
        0x3242A9D8,
        0xCE70,
        0x4AA0,
        0x95,
        0x5D,
        0x5E,
        0x7B,
        0x14,
        0x0D,
        0xE4,
        0xD2,
    ],
    "gEfiMmRscHandlerProtocolGuid": [
        0x2FF29FA7,
        0x5E80,
        0x4ED9,
        0xB3,
        0x80,
        0x1,
        0x7D,
        0x3C,
        0x55,
        0x4F,
        0xF4,
    ],
    "gEfiMmCommunicationProtocolGuid": [
        0xC68ED8E2,
        0x9DC6,
        0x4CBD,
        0x9D,
        0x94,
        0xDB,
        0x65,
        0xAC,
        0xC5,
        0xC3,
        0x32,
    ],
    "gEfiLegacySpiControllerProtocolGuid": [
        0x39136FC7,
        0x1A11,
        0x49DE,
        0xBF,
        0x35,
        0x0E,
        0x78,
        0xDD,
        0xB5,
        0x24,
        0xFC,
    ],
    "gEfiLegacySpiFlashProtocolGuid": [
        0xF01BED57,
        0x04BC,
        0x4F3F,
        0x96,
        0x60,
        0xD6,
        0xF2,
        0xEA,
        0x22,
        0x82,
        0x59,
    ],
    "gEfiLegacySpiSmmControllerProtocolGuid": [
        0x62331B78,
        0xD8D0,
        0x4C8C,
        0x8C,
        0xCB,
        0xD2,
        0x7D,
        0xFE,
        0x32,
        0xDB,
        0x9B,
    ],
    "gEfiLegacySpiSmmFlashProtocolGuid": [
        0x5E3848D4,
        0x0DB5,
        0x4FC0,
        0x97,
        0x29,
        0x3F,
        0x35,
        0x3D,
        0x4F,
        0x87,
        0x9F,
    ],
    "gEfiSpiConfigurationProtocolGuid": [
        0x85A6D3E6,
        0xB65B,
        0x4AFC,
        0xB3,
        0x8F,
        0xC6,
        0xD5,
        0x4A,
        0xF6,
        0xDD,
        0xC8,
    ],
    "gEfiSpiHcProtocolGuid": [
        0xC74E5DB2,
        0xFA96,
        0x4AE2,
        0xB3,
        0x99,
        0x15,
        0x97,
        0x7F,
        0xE3,
        0x0,
        0x2D,
    ],
    "gEfiSpiNorFlashProtocolGuid": [
        0xB57EC3FE,
        0xF833,
        0x4BA6,
        0x85,
        0x78,
        0x2A,
        0x7D,
        0x6A,
        0x87,
        0x44,
        0x4B,
    ],
    "gEfiSpiSmmConfigurationProtocolGuid": [
        0x995C6ECA,
        0x171B,
        0x45FD,
        0xA3,
        0xAA,
        0xFD,
        0x4C,
        0x9C,
        0x9D,
        0xEF,
        0x59,
    ],
    "gEfiSpiSmmHcProtocolGuid": [
        0xE9F02217,
        0x2093,
        0x4470,
        0x8A,
        0x54,
        0x5C,
        0x2C,
        0xFF,
        0xE7,
        0x3E,
        0xCB,
    ],
    "gEfiSpiSmmNorFlashProtocolGuid": [
        0xAAB18F19,
        0xFE14,
        0x4666,
        0x86,
        0x04,
        0x87,
        0xFF,
        0x6D,
        0x66,
        0x2C,
        0x9A,
    ],
    "gEfiDebugPortProtocolGuid": [
        0xEBA4E8D2,
        0x3858,
        0x41EC,
        0xA2,
        0x81,
        0x26,
        0x47,
        0xBA,
        0x96,
        0x60,
        0xD0,
    ],
    "gEfiDebugSupportProtocolGuid": [
        0x2755590C,
        0x6F3C,
        0x42FA,
        0x9E,
        0xA4,
        0xA3,
        0xBA,
        0x54,
        0x3C,
        0xDA,
        0x25,
    ],
    "gEfiDecompressProtocolGuid": [
        0xD8117CFE,
        0x94A6,
        0x11D4,
        0x9A,
        0x3A,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiDeviceIoProtocolGuid": [
        0xAF6AC311,
        0x84C3,
        0x11D2,
        0x8E,
        0x3C,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiDevicePathProtocolGuid": [
        0x09576E91,
        0x6D3F,
        0x11D2,
        0x8E,
        0x39,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiDevicePathFromTextProtocolGuid": [
        0x05C99A21,
        0xC70F,
        0x4AD2,
        0x8A,
        0x5F,
        0x35,
        0xDF,
        0x33,
        0x43,
        0xF5,
        0x1E,
    ],
    "gEfiDevicePathToTextProtocolGuid": [
        0x8B843E20,
        0x8132,
        0x4852,
        0x90,
        0xCC,
        0x55,
        0x1A,
        0x4E,
        0x4A,
        0x7F,
        0x1C,
    ],
    "gEfiDevicePathUtilitiesProtocolGuid": [
        0x0379BE4E,
        0xD706,
        0x437D,
        0xB0,
        0x37,
        0xED,
        0xB8,
        0x2F,
        0xB7,
        0x72,
        0xA4,
    ],
    "gEfiDriverBindingProtocolGuid": [
        0x18A031AB,
        0xB443,
        0x4D1A,
        0xA5,
        0xC0,
        0x0C,
        0x09,
        0x26,
        0x1E,
        0x9F,
        0x71,
    ],
    "gEfiPlatformDriverOverrideProtocolGuid": [
        0x6B30C738,
        0xA391,
        0x11D4,
        0x9A,
        0x3B,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiDriverFamilyOverrideProtocolGuid": [
        0xB1EE129E,
        0xDA36,
        0x4181,
        0x91,
        0xF8,
        0x4,
        0xA4,
        0x92,
        0x37,
        0x66,
        0xA7,
    ],
    "gEfiBusSpecificDriverOverrideProtocolGuid": [
        0x3BC1B285,
        0x8A15,
        0x4A82,
        0xAA,
        0xBF,
        0x4D,
        0x7D,
        0x13,
        0xFB,
        0x32,
        0x65,
    ],
    "gEfiDriverDiagnostics2ProtocolGuid": [
        0x4D330321,
        0x025F,
        0x4AAC,
        0x90,
        0xD8,
        0x5E,
        0xD9,
        0x00,
        0x17,
        0x3B,
        0x63,
    ],
    "gEfiDriverDiagnosticsProtocolGuid": [
        0x0784924F,
        0xE296,
        0x11D4,
        0x9A,
        0x49,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiComponentName2ProtocolGuid": [
        0x6A7A5CFF,
        0xE8D9,
        0x4F70,
        0xBA,
        0xDA,
        0x75,
        0xAB,
        0x30,
        0x25,
        0xCE,
        0x14,
    ],
    "gEfiComponentNameProtocolGuid": [
        0x107A772C,
        0xD5E1,
        0x11D4,
        0x9A,
        0x46,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiDriverConfiguration2ProtocolGuid": [
        0xBFD7DC1D,
        0x24F1,
        0x40D9,
        0x82,
        0xE7,
        0x2E,
        0x09,
        0xBB,
        0x6B,
        0x4E,
        0xBE,
    ],
    "gEfiDriverConfigurationProtocolGuid": [
        0x107A772B,
        0xD5E1,
        0x11D4,
        0x9A,
        0x46,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiPlatformToDriverConfigurationProtocolGuid": [
        0x642CD590,
        0x8059,
        0x4C0A,
        0xA9,
        0x58,
        0xC5,
        0xEC,
        0x7,
        0xD2,
        0x3C,
        0x4B,
    ],
    "gEfiDriverSupportedEfiVersionProtocolGuid": [
        0x5C198761,
        0x16A8,
        0x4E69,
        0x97,
        0x2C,
        0x89,
        0xD6,
        0x79,
        0x54,
        0xF8,
        0x1D,
    ],
    "gEfiSimpleTextInProtocolGuid": [
        0x387477C1,
        0x69C7,
        0x11D2,
        0x8E,
        0x39,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiSimpleTextInputExProtocolGuid": [
        0xDD9E7534,
        0x7762,
        0x4698,
        0x8C,
        0x14,
        0xF5,
        0x85,
        0x17,
        0xA6,
        0x25,
        0xAA,
    ],
    "gEfiSimpleTextOutProtocolGuid": [
        0x387477C2,
        0x69C7,
        0x11D2,
        0x8E,
        0x39,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiSimplePointerProtocolGuid": [
        0x31878C87,
        0x0B75,
        0x11D5,
        0x9A,
        0x4F,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiAbsolutePointerProtocolGuid": [
        0x8D59D32B,
        0xC655,
        0x4AE9,
        0x9B,
        0x15,
        0xF2,
        0x59,
        0x04,
        0x99,
        0x2A,
        0x43,
    ],
    "gEfiSerialIoProtocolGuid": [
        0xBB25CF6F,
        0xF1D4,
        0x11D2,
        0x9A,
        0x0C,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0xFD,
    ],
    "gEfiGraphicsOutputProtocolGuid": [
        0x9042A9DE,
        0x23DC,
        0x4A38,
        0x96,
        0xFB,
        0x7A,
        0xDE,
        0xD0,
        0x80,
        0x51,
        0x6A,
    ],
    "gEfiEdidDiscoveredProtocolGuid": [
        0x1C0C34F6,
        0xD380,
        0x41FA,
        0xA0,
        0x49,
        0x8A,
        0xD0,
        0x6C,
        0x1A,
        0x66,
        0xAA,
    ],
    "gEfiEdidActiveProtocolGuid": [
        0xBD8C1056,
        0x9F36,
        0x44EC,
        0x92,
        0xA8,
        0xA6,
        0x33,
        0x7F,
        0x81,
        0x79,
        0x86,
    ],
    "gEfiEdidOverrideProtocolGuid": [
        0x48ECB431,
        0xFB72,
        0x45C0,
        0xA9,
        0x22,
        0xF4,
        0x58,
        0xFE,
        0x04,
        0x0B,
        0xD5,
    ],
    "gEfiUgaIoProtocolGuid": [
        0x61A4D49E,
        0x6F68,
        0x4F1B,
        0xB9,
        0x22,
        0xA8,
        0x6E,
        0xED,
        0x0B,
        0x07,
        0xA2,
    ],
    "gEfiUgaDrawProtocolGuid": [
        0x982C298B,
        0xF4FA,
        0x41CB,
        0xB8,
        0x38,
        0x77,
        0xAA,
        0x68,
        0x8F,
        0xB8,
        0x39,
    ],
    "gEfiLoadedImageProtocolGuid": [
        0x5B1B31A1,
        0x9562,
        0x11D2,
        0x8E,
        0x3F,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiLoadedImageDevicePathProtocolGuid": [
        0xBC62157E,
        0x3E33,
        0x4FEC,
        0x99,
        0x20,
        0x2D,
        0x3B,
        0x36,
        0xD7,
        0x50,
        0xDF,
    ],
    "gEfiLoadFileProtocolGuid": [
        0x56EC3091,
        0x954C,
        0x11D2,
        0x8E,
        0x3F,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiLoadFile2ProtocolGuid": [
        0x4006C0C1,
        0xFCB3,
        0x403E,
        0x99,
        0x6D,
        0x4A,
        0x6C,
        0x87,
        0x24,
        0xE0,
        0x6D,
    ],
    "gEfiSimpleFileSystemProtocolGuid": [
        0x964E5B22,
        0x6459,
        0x11D2,
        0x8E,
        0x39,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiTapeIoProtocolGuid": [
        0x1E93E633,
        0xD65A,
        0x459E,
        0xAB,
        0x84,
        0x93,
        0xD9,
        0xEC,
        0x26,
        0x6D,
        0x18,
    ],
    "gEfiDiskIoProtocolGuid": [
        0xCE345171,
        0xBA0B,
        0x11D2,
        0x8E,
        0x4F,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiBlockIoProtocolGuid": [
        0x964E5B21,
        0x6459,
        0x11D2,
        0x8E,
        0x39,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiUnicodeCollationProtocolGuid": [
        0x1D85CD7F,
        0xF43D,
        0x11D2,
        0x9A,
        0x0C,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiUnicodeCollation2ProtocolGuid": [
        0xA4C751FC,
        0x23AE,
        0x4C3E,
        0x92,
        0xE9,
        0x49,
        0x64,
        0xCF,
        0x63,
        0xF3,
        0x49,
    ],
    "gEfiPciRootBridgeIoProtocolGuid": [
        0x2F707EBB,
        0x4A1A,
        0x11D4,
        0x9A,
        0x38,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiPciIoProtocolGuid": [
        0x4CF5B200,
        0x68B8,
        0x4CA5,
        0x9E,
        0xEC,
        0xB2,
        0x3E,
        0x3F,
        0x50,
        0x02,
        0x9A,
    ],
    "gEfiScsiIoProtocolGuid": [
        0x932F47E6,
        0x2362,
        0x4002,
        0x80,
        0x3E,
        0x3C,
        0xD5,
        0x4B,
        0x13,
        0x8F,
        0x85,
    ],
    "gEfiExtScsiPassThruProtocolGuid": [
        0x143B7632,
        0xB81B,
        0x4CB7,
        0xAB,
        0xD3,
        0xB6,
        0x25,
        0xA5,
        0xB9,
        0xBF,
        0xFE,
    ],
    "gEfiScsiPassThruProtocolGuid": [
        0xA59E8FCF,
        0xBDA0,
        0x43BB,
        0x90,
        0xB1,
        0xD3,
        0x73,
        0x2E,
        0xCA,
        0xA8,
        0x77,
    ],
    "gEfiIScsiInitiatorNameProtocolGuid": [
        0x59324945,
        0xEC44,
        0x4C0D,
        0xB1,
        0xCD,
        0x9D,
        0xB1,
        0x39,
        0xDF,
        0x07,
        0x0C,
    ],
    "gEfiUsb2HcProtocolGuid": [
        0x3E745226,
        0x9818,
        0x45B6,
        0xA2,
        0xAC,
        0xD7,
        0xCD,
        0x0E,
        0x8B,
        0xA2,
        0xBC,
    ],
    "gEfiUsbHcProtocolGuid": [
        0xF5089266,
        0x1AA0,
        0x4953,
        0x97,
        0xD8,
        0x56,
        0x2F,
        0x8A,
        0x73,
        0xB5,
        0x19,
    ],
    "gEfiUsbIoProtocolGuid": [
        0x2B2F68D6,
        0x0CD2,
        0x44CF,
        0x8E,
        0x8B,
        0xBB,
        0xA2,
        0x0B,
        0x1B,
        0x5B,
        0x75,
    ],
    "gEfiAcpiTableProtocolGuid": [
        0xFFE06BDD,
        0x6107,
        0x46A6,
        0x7B,
        0xB2,
        0x5A,
        0x9C,
        0x7E,
        0xC5,
        0x27,
        0x5C,
    ],
    "gEfiEbcProtocolGuid": [
        0x13AC6DD1,
        0x73D0,
        0x11D4,
        0xB0,
        0x6B,
        0x00,
        0xAA,
        0x00,
        0xBD,
        0x6D,
        0xE7,
    ],
    "gEfiSimpleNetworkProtocolGuid": [
        0xA19832B9,
        0xAC25,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiNetworkInterfaceIdentifierProtocolGuid_31": [
        0x1ACED566,
        0x76ED,
        0x4218,
        0xBC,
        0x81,
        0x76,
        0x7F,
        0x1F,
        0x97,
        0x7A,
        0x89,
    ],
    "gEfiNetworkInterfaceIdentifierProtocolGuid": [
        0xE18541CD,
        0xF755,
        0x4F73,
        0x92,
        0x8D,
        0x64,
        0x3C,
        0x8A,
        0x79,
        0xB2,
        0x29,
    ],
    "gEfiPxeBaseCodeCallbackProtocolGuid": [
        0x245DCA21,
        0xFB7B,
        0x11D3,
        0x8F,
        0x01,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiPxeBaseCodeProtocolGuid": [
        0x03C4E603,
        0xAC28,
        0x11D3,
        0x9A,
        0x2D,
        0x00,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiBisProtocolGuid": [
        0x0B64AAB0,
        0x5429,
        0x11D4,
        0x98,
        0x16,
        0x00,
        0xA0,
        0xC9,
        0x1F,
        0xAD,
        0xCF,
    ],
    "gEfiManagedNetworkServiceBindingProtocolGuid": [
        0xF36FF770,
        0xA7E1,
        0x42CF,
        0x9E,
        0xD2,
        0x56,
        0xF0,
        0xF2,
        0x71,
        0xF4,
        0x4C,
    ],
    "gEfiManagedNetworkProtocolGuid": [
        0x7AB33A91,
        0xACE5,
        0x4326,
        0xB5,
        0x72,
        0xE7,
        0xEE,
        0x33,
        0xD3,
        0x9F,
        0x16,
    ],
    "gEfiArpServiceBindingProtocolGuid": [
        0xF44C00EE,
        0x1F2C,
        0x4A00,
        0xAA,
        0x09,
        0x1C,
        0x9F,
        0x3E,
        0x08,
        0x00,
        0xA3,
    ],
    "gEfiArpProtocolGuid": [
        0xF4B427BB,
        0xBA21,
        0x4F16,
        0xBC,
        0x4E,
        0x43,
        0xE4,
        0x16,
        0xAB,
        0x61,
        0x9C,
    ],
    "gEfiDhcp4ServiceBindingProtocolGuid": [
        0x9D9A39D8,
        0xBD42,
        0x4A73,
        0xA4,
        0xD5,
        0x8E,
        0xE9,
        0x4B,
        0xE1,
        0x13,
        0x80,
    ],
    "gEfiDhcp4ProtocolGuid": [
        0x8A219718,
        0x4EF5,
        0x4761,
        0x91,
        0xC8,
        0xC0,
        0xF0,
        0x4B,
        0xDA,
        0x9E,
        0x56,
    ],
    "gEfiTcp4ServiceBindingProtocolGuid": [
        0x00720665,
        0x67EB,
        0x4A99,
        0xBA,
        0xF7,
        0xD3,
        0xC3,
        0x3A,
        0x1C,
        0x7C,
        0xC9,
    ],
    "gEfiTcp4ProtocolGuid": [
        0x65530BC7,
        0xA359,
        0x410F,
        0xB0,
        0x10,
        0x5A,
        0xAD,
        0xC7,
        0xEC,
        0x2B,
        0x62,
    ],
    "gEfiIp4ServiceBindingProtocolGuid": [
        0xC51711E7,
        0xB4BF,
        0x404A,
        0xBF,
        0xB8,
        0x0A,
        0x04,
        0x8E,
        0xF1,
        0xFF,
        0xE4,
    ],
    "gEfiIp4ProtocolGuid": [
        0x41D94CD2,
        0x35B6,
        0x455A,
        0x82,
        0x58,
        0xD4,
        0xE5,
        0x13,
        0x34,
        0xAA,
        0xDD,
    ],
    "gEfiIp4ConfigProtocolGuid": [
        0x3B95AA31,
        0x3793,
        0x434B,
        0x86,
        0x67,
        0xC8,
        0x07,
        0x08,
        0x92,
        0xE0,
        0x5E,
    ],
    "gEfiUdp4ServiceBindingProtocolGuid": [
        0x83F01464,
        0x99BD,
        0x45E5,
        0xB3,
        0x83,
        0xAF,
        0x63,
        0x05,
        0xD8,
        0xE9,
        0xE6,
    ],
    "gEfiUdp4ProtocolGuid": [
        0x3AD9DF29,
        0x4501,
        0x478D,
        0xB1,
        0xF8,
        0x7F,
        0x7F,
        0xE7,
        0x0E,
        0x50,
        0xF3,
    ],
    "gEfiMtftp4ServiceBindingProtocolGuid": [
        0x2FE800BE,
        0x8F01,
        0x4AA6,
        0x94,
        0x6B,
        0xD7,
        0x13,
        0x88,
        0xE1,
        0x83,
        0x3F,
    ],
    "gEfiMtftp4ProtocolGuid": [
        0x78247C57,
        0x63DB,
        0x4708,
        0x99,
        0xC2,
        0xA8,
        0xB4,
        0xA9,
        0xA6,
        0x1F,
        0x6B,
    ],
    "gEfiAuthenticationInfoProtocolGuid": [
        0x7671D9D0,
        0x53DB,
        0x4173,
        0xAA,
        0x69,
        0x23,
        0x27,
        0xF2,
        0x1F,
        0x0B,
        0xC7,
    ],
    "gEfiHashServiceBindingProtocolGuid": [
        0x42881C98,
        0xA4F3,
        0x44B0,
        0xA3,
        0x9D,
        0xDF,
        0xA1,
        0x86,
        0x67,
        0xD8,
        0xCD,
    ],
    "gEfiHashProtocolGuid": [
        0xC5184932,
        0xDBA5,
        0x46DB,
        0xA5,
        0xBA,
        0xCC,
        0x0B,
        0xDA,
        0x9C,
        0x14,
        0x35,
    ],
    "gEfiTcgProtocolGuid": [
        0xF541796D,
        0xA62E,
        0x4954,
        0xA7,
        0x75,
        0x95,
        0x84,
        0xF6,
        0x1B,
        0x9C,
        0xDD,
    ],
    "gEfiTrEEProtocolGuid": [
        0x607F766C,
        0x7455,
        0x42BE,
        0x93,
        0x0B,
        0xE4,
        0xD7,
        0x6D,
        0xB2,
        0x72,
        0x0F,
    ],
    "gEfiTcg2ProtocolGuid": [
        0x607F766C,
        0x7455,
        0x42BE,
        0x93,
        0x0B,
        0xE4,
        0xD7,
        0x6D,
        0xB2,
        0x72,
        0x0F,
    ],
    "gEfiTcg2FinalEventsTableGuid": [
        0x1E2ED096,
        0x30E2,
        0x4254,
        0xBD,
        0x89,
        0x86,
        0x3B,
        0xBE,
        0xF8,
        0x23,
        0x25,
    ],
    "gEfiFormBrowser2ProtocolGuid": [
        0xB9D4C360,
        0xBCFB,
        0x4F9B,
        0x92,
        0x98,
        0x53,
        0xC1,
        0x36,
        0x98,
        0x22,
        0x58,
    ],
    "gEfiHiiStringProtocolGuid": [
        0x0FD96974,
        0x23AA,
        0x4CDC,
        0xB9,
        0xCB,
        0x98,
        0xD1,
        0x77,
        0x50,
        0x32,
        0x2A,
    ],
    "gEfiHiiImageProtocolGuid": [
        0x31A6406A,
        0x6BDF,
        0x4E46,
        0xB2,
        0xA2,
        0xEB,
        0xAA,
        0x89,
        0xC4,
        0x09,
        0x20,
    ],
    "gEfiHiiConfigRoutingProtocolGuid": [
        0x587E72D7,
        0xCC50,
        0x4F79,
        0x82,
        0x09,
        0xCA,
        0x29,
        0x1F,
        0xC1,
        0xA1,
        0x0F,
    ],
    "gEfiHiiDatabaseProtocolGuid": [
        0xEF9FC172,
        0xA1B2,
        0x4693,
        0xB3,
        0x27,
        0x6D,
        0x32,
        0xFC,
        0x41,
        0x60,
        0x42,
    ],
    "gEfiHiiFontProtocolGuid": [
        0xE9CA4775,
        0x8657,
        0x47FC,
        0x97,
        0xE7,
        0x7E,
        0xD6,
        0x5A,
        0x08,
        0x43,
        0x24,
    ],
    "gEfiHiiConfigAccessProtocolGuid": [
        0x330D4706,
        0xF2A0,
        0x4E4F,
        0xA3,
        0x69,
        0xB6,
        0x6F,
        0xA8,
        0xD5,
        0x43,
        0x85,
    ],
    "gEfiHiiPackageListProtocolGuid": [
        0x6A1EE763,
        0xD47A,
        0x43B4,
        0xAA,
        0xBE,
        0xEF,
        0x1D,
        0xE2,
        0xAB,
        0x56,
        0xFC,
    ],
    "gEfiIp6ServiceBindingProtocolGuid": [
        0xEC835DD3,
        0xFE0F,
        0x617B,
        0xA6,
        0x21,
        0xB3,
        0x50,
        0xC3,
        0xE1,
        0x33,
        0x88,
    ],
    "gEfiIp6ProtocolGuid": [
        0x2C8759D5,
        0x5C2D,
        0x66EF,
        0x92,
        0x5F,
        0xB6,
        0x6C,
        0x10,
        0x19,
        0x57,
        0xE2,
    ],
    "gEfiIp6ConfigProtocolGuid": [
        0x937FE521,
        0x95AE,
        0x4D1A,
        0x89,
        0x29,
        0x48,
        0xBC,
        0xD9,
        0x0A,
        0xD3,
        0x1A,
    ],
    "gEfiMtftp6ServiceBindingProtocolGuid": [
        0xD9760FF3,
        0x3CCA,
        0x4267,
        0x80,
        0xF9,
        0x75,
        0x27,
        0xFA,
        0xFA,
        0x42,
        0x23,
    ],
    "gEfiMtftp6ProtocolGuid": [
        0xBF0A78BA,
        0xEC29,
        0x49CF,
        0xA1,
        0xC9,
        0x7A,
        0xE5,
        0x4E,
        0xAB,
        0x6A,
        0x51,
    ],
    "gEfiDhcp6ServiceBindingProtocolGuid": [
        0x9FB9A8A1,
        0x2F4A,
        0x43A6,
        0x88,
        0x9C,
        0xD0,
        0xF7,
        0xB6,
        0xC4,
        0x7A,
        0xD5,
    ],
    "gEfiDhcp6ProtocolGuid": [
        0x87C8BAD7,
        0x595,
        0x4053,
        0x82,
        0x97,
        0xDE,
        0xDE,
        0x39,
        0x5F,
        0x5D,
        0x5B,
    ],
    "gEfiUdp6ServiceBindingProtocolGuid": [
        0x66ED4721,
        0x3C98,
        0x4D3E,
        0x81,
        0xE3,
        0xD0,
        0x3D,
        0xD3,
        0x9A,
        0x72,
        0x54,
    ],
    "gEfiUdp6ProtocolGuid": [
        0x4F948815,
        0xB4B9,
        0x43CB,
        0x8A,
        0x33,
        0x90,
        0xE0,
        0x60,
        0xB3,
        0x49,
        0x55,
    ],
    "gEfiTcp6ServiceBindingProtocolGuid": [
        0xEC20EB79,
        0x6C1A,
        0x4664,
        0x9A,
        0x0D,
        0xD2,
        0xE4,
        0xCC,
        0x16,
        0xD6,
        0x64,
    ],
    "gEfiTcp6ProtocolGuid": [
        0x46E44855,
        0xBD60,
        0x4AB7,
        0xAB,
        0x0D,
        0xA6,
        0x79,
        0xB9,
        0x44,
        0x7D,
        0x77,
    ],
    "gEfiVlanConfigProtocolGuid": [
        0x9E23D768,
        0xD2F3,
        0x4366,
        0x9F,
        0xC3,
        0x3A,
        0x7A,
        0xBA,
        0x86,
        0x43,
        0x74,
    ],
    "gEfiEapProtocolGuid": [
        0x5D9F96DB,
        0xE731,
        0x4CAA,
        0xA0,
        0xD,
        0x72,
        0xE1,
        0x87,
        0xCD,
        0x77,
        0x62,
    ],
    "gEfiEapManagementProtocolGuid": [
        0xBB62E663,
        0x625D,
        0x40B2,
        0xA0,
        0x88,
        0xBB,
        0xE8,
        0x36,
        0x23,
        0xA2,
        0x45,
    ],
    "gEfiFtp4ServiceBindingProtocolGuid": [
        0xFAAECB1,
        0x226E,
        0x4782,
        0xAA,
        0xCE,
        0x7D,
        0xB9,
        0xBC,
        0xBF,
        0x4D,
        0xAF,
    ],
    "gEfiFtp4ProtocolGuid": [
        0xEB338826,
        0x681B,
        0x4295,
        0xB3,
        0x56,
        0x2B,
        0x36,
        0x4C,
        0x75,
        0x7B,
        0x9,
    ],
    "gEfiIpSecConfigProtocolGuid": [
        0xCE5E5929,
        0xC7A3,
        0x4602,
        0xAD,
        0x9E,
        0xC9,
        0xDA,
        0xF9,
        0x4E,
        0xBF,
        0xCF,
    ],
    "gEfiDriverHealthProtocolGuid": [
        0x2A534210,
        0x9280,
        0x41D8,
        0xAE,
        0x79,
        0xCA,
        0xDA,
        0x1,
        0xA2,
        0xB1,
        0x27,
    ],
    "gEfiDeferredImageLoadProtocolGuid": [
        0x15853D7C,
        0x3DDF,
        0x43E0,
        0xA1,
        0xCB,
        0xEB,
        0xF8,
        0x5B,
        0x8F,
        0x87,
        0x2C,
    ],
    "gEfiUserCredentialProtocolGuid": [
        0x71EE5E94,
        0x65B9,
        0x45D5,
        0x82,
        0x1A,
        0x3A,
        0x4D,
        0x86,
        0xCF,
        0xE6,
        0xBE,
    ],
    "gEfiUserManagerProtocolGuid": [
        0x6FD5B00C,
        0xD426,
        0x4283,
        0x98,
        0x87,
        0x6C,
        0xF5,
        0xCF,
        0x1C,
        0xB1,
        0xFE,
    ],
    "gEfiAtaPassThruProtocolGuid": [
        0x1D3DE7F0,
        0x807,
        0x424F,
        0xAA,
        0x69,
        0x11,
        0xA5,
        0x4E,
        0x19,
        0xA4,
        0x6F,
    ],
    "gEfiFirmwareManagementProtocolGuid": [
        0x86C77A67,
        0xB97,
        0x4633,
        0xA1,
        0x87,
        0x49,
        0x10,
        0x4D,
        0x6,
        0x85,
        0xC7,
    ],
    "gEfiIpSecProtocolGuid": [
        0xDFB386F7,
        0xE100,
        0x43AD,
        0x9C,
        0x9A,
        0xED,
        0x90,
        0xD0,
        0x8A,
        0x5E,
        0x12,
    ],
    "gEfiIpSec2ProtocolGuid": [
        0xA3979E64,
        0xACE8,
        0x4DDC,
        0xBC,
        0x7,
        0x4D,
        0x66,
        0xB8,
        0xFD,
        0x9,
        0x77,
    ],
    "gEfiKmsProtocolGuid": [
        0xEC3A978D,
        0x7C4E,
        0x48FA,
        0x9A,
        0xBE,
        0x6A,
        0xD9,
        0x1C,
        0xC8,
        0xF8,
        0x11,
    ],
    "gEfiBlockIo2ProtocolGuid": [
        0xA77B2472,
        0xE282,
        0x4E9F,
        0xA2,
        0x45,
        0xC2,
        0xC0,
        0xE2,
        0x7B,
        0xBC,
        0xC1,
    ],
    "gEfiStorageSecurityCommandProtocolGuid": [
        0xC88B0B6D,
        0x0DFC,
        0x49A7,
        0x9C,
        0xB4,
        0x49,
        0x7,
        0x4B,
        0x4C,
        0x3A,
        0x78,
    ],
    "gEfiUserCredential2ProtocolGuid": [
        0xE98ADB03,
        0xB8B9,
        0x4AF8,
        0xBA,
        0x20,
        0x26,
        0xE9,
        0x11,
        0x4C,
        0xBC,
        0xE5,
    ],
    "gEfiDiskIo2ProtocolGuid": [
        0x151C8EAE,
        0x7F2C,
        0x472C,
        0x9E,
        0x54,
        0x98,
        0x28,
        0x19,
        0x4F,
        0x6A,
        0x88,
    ],
    "gEfiTimestampProtocolGuid": [
        0xAFBFDE41,
        0x2E6E,
        0x4262,
        0xBA,
        0x65,
        0x62,
        0xB9,
        0x23,
        0x6E,
        0x54,
        0x95,
    ],
    "gEfiRngProtocolGuid": [
        0x3152BCA5,
        0xEADE,
        0x433D,
        0x86,
        0x2E,
        0xC0,
        0x1C,
        0xDC,
        0x29,
        0x1F,
        0x44,
    ],
    "gEfiAdapterInformationProtocolGuid": [
        0xE5DD1403,
        0xD622,
        0xC24E,
        0x84,
        0x88,
        0xC7,
        0x1B,
        0x17,
        0xF5,
        0xE8,
        0x02,
    ],
    "gEfiNvmExpressPassThruProtocolGuid": [
        0x52C78312,
        0x8EDC,
        0x4233,
        0x98,
        0xF2,
        0x1A,
        0x1A,
        0xA5,
        0xE3,
        0x88,
        0xA5,
    ],
    "gEfiHash2ServiceBindingProtocolGuid": [
        0xDA836F8D,
        0x217F,
        0x4CA0,
        0x99,
        0xC2,
        0x1C,
        0xA4,
        0xE1,
        0x60,
        0x77,
        0xEA,
    ],
    "gEfiHash2ProtocolGuid": [
        0x55B1D734,
        0xC5E1,
        0x49DB,
        0x96,
        0x47,
        0xB1,
        0x6A,
        0xFB,
        0xE,
        0x30,
        0x5B,
    ],
    "gEfiBlockIoCryptoProtocolGuid": [
        0xA00490BA,
        0x3F1A,
        0x4B4C,
        0xAB,
        0x90,
        0x4F,
        0xA9,
        0x97,
        0x26,
        0xA1,
        0xE8,
    ],
    "gEfiSmartCardReaderProtocolGuid": [
        0x2A4D1ADF,
        0x21DC,
        0x4B81,
        0xA4,
        0x2F,
        0x8B,
        0x8E,
        0xE2,
        0x38,
        0x00,
        0x60,
    ],
    "gEfiSmartCardEdgeProtocolGuid": [
        0xD317F29B,
        0xA325,
        0x4712,
        0x9B,
        0xF1,
        0xC6,
        0x19,
        0x54,
        0xDC,
        0x19,
        0x8C,
    ],
    "gEfiUsbFunctionIoProtocolGuid": [
        0x32D2963A,
        0xFE5D,
        0x4F30,
        0xB6,
        0x33,
        0x6E,
        0x5D,
        0xC5,
        0x58,
        0x3,
        0xCC,
    ],
    "gEfiBluetoothHcProtocolGuid": [
        0xB3930571,
        0xBEBA,
        0x4FC5,
        0x92,
        0x3,
        0x94,
        0x27,
        0x24,
        0x2E,
        0x6A,
        0x43,
    ],
    "gEfiBluetoothIoServiceBindingProtocolGuid": [
        0x388278D3,
        0x7B85,
        0x42F0,
        0xAB,
        0xA9,
        0xFB,
        0x4B,
        0xFD,
        0x69,
        0xF5,
        0xAB,
    ],
    "gEfiBluetoothIoProtocolGuid": [
        0x467313DE,
        0x4E30,
        0x43F1,
        0x94,
        0x3E,
        0x32,
        0x3F,
        0x89,
        0x84,
        0x5D,
        0xB5,
    ],
    "gEfiBluetoothConfigProtocolGuid": [
        0x62960CF3,
        0x40FF,
        0x4263,
        0xA7,
        0x7C,
        0xDF,
        0xDE,
        0xBD,
        0x19,
        0x1B,
        0x4B,
    ],
    "gEfiRegularExpressionProtocolGuid": [
        0xB3F79D9A,
        0x436C,
        0xDC11,
        0xB0,
        0x52,
        0xCD,
        0x85,
        0xDF,
        0x52,
        0x4C,
        0xE6,
    ],
    "gEfiBootManagerPolicyProtocolGuid": [
        0xFEDF8E0C,
        0xE147,
        0x11E3,
        0x99,
        0x03,
        0xB8,
        0xE8,
        0x56,
        0x2C,
        0xBA,
        0xFA,
    ],
    "gEfiConfigKeywordHandlerProtocolGuid": [
        0x0A8BADD5,
        0x03B8,
        0x4D19,
        0xB1,
        0x28,
        0x7B,
        0x8F,
        0x0E,
        0xDA,
        0xA5,
        0x96,
    ],
    "gEfiWiFiProtocolGuid": [
        0xDA55BC9,
        0x45F8,
        0x4BB4,
        0x87,
        0x19,
        0x52,
        0x24,
        0xF1,
        0x8A,
        0x4D,
        0x45,
    ],
    "gEfiEapManagement2ProtocolGuid": [
        0x5E93C847,
        0x456D,
        0x40B3,
        0xA6,
        0xB4,
        0x78,
        0xB0,
        0xC9,
        0xCF,
        0x7F,
        0x20,
    ],
    "gEfiEapConfigurationProtocolGuid": [
        0xE5B58DBB,
        0x7688,
        0x44B4,
        0x97,
        0xBF,
        0x5F,
        0x1D,
        0x4B,
        0x7C,
        0xC8,
        0xDB,
    ],
    "gEfiPkcs7VerifyProtocolGuid": [
        0x47889FB2,
        0xD671,
        0x4FAB,
        0xA0,
        0xCA,
        0xDF,
        0x0E,
        0x44,
        0xDF,
        0x70,
        0xD6,
    ],
    "gEfiIp4Config2ProtocolGuid": [
        0x5B446ED1,
        0xE30B,
        0x4FAA,
        0x87,
        0x1A,
        0x36,
        0x54,
        0xEC,
        0xA3,
        0x60,
        0x80,
    ],
    "gEfiDns4ServiceBindingProtocolGuid": [
        0xB625B186,
        0xE063,
        0x44F7,
        0x89,
        0x5,
        0x6A,
        0x74,
        0xDC,
        0x6F,
        0x52,
        0xB4,
    ],
    "gEfiDns4ProtocolGuid": [
        0xAE3D28CC,
        0xE05B,
        0x4FA1,
        0xA0,
        0x11,
        0x7E,
        0xB5,
        0x5A,
        0x3F,
        0x14,
        0x1,
    ],
    "gEfiDns6ServiceBindingProtocolGuid": [
        0x7F1647C8,
        0xB76E,
        0x44B2,
        0xA5,
        0x65,
        0xF7,
        0xF,
        0xF1,
        0x9C,
        0xD1,
        0x9E,
    ],
    "gEfiDns6ProtocolGuid": [
        0xCA37BC1F,
        0xA327,
        0x4AE9,
        0x82,
        0x8A,
        0x8C,
        0x40,
        0xD8,
        0x50,
        0x6A,
        0x17,
    ],
    "gEfiHttpServiceBindingProtocolGuid": [
        0xBDC8E6AF,
        0xD9BC,
        0x4379,
        0xA7,
        0x2A,
        0xE0,
        0xC4,
        0xE7,
        0x5D,
        0xAE,
        0x1C,
    ],
    "gEfiHttpProtocolGuid": [
        0x7A59B29B,
        0x910B,
        0x4171,
        0x82,
        0x42,
        0xA8,
        0x5A,
        0x0D,
        0xF2,
        0x5B,
        0x5B,
    ],
    "gEfiHttpUtilitiesProtocolGuid": [
        0x3E35C163,
        0x4074,
        0x45DD,
        0x43,
        0x1E,
        0x23,
        0x98,
        0x9D,
        0xD8,
        0x6B,
        0x32,
    ],
    "gEfiTlsServiceBindingProtocolGuid": [
        0x952CB795,
        0xFF36,
        0x48CF,
        0xA2,
        0x49,
        0x4D,
        0xF4,
        0x86,
        0xD6,
        0xAB,
        0x8D,
    ],
    "gEfiTlsProtocolGuid": [
        0xCA959F,
        0x6CFA,
        0x4DB1,
        0x95,
        0xBC,
        0xE4,
        0x6C,
        0x47,
        0x51,
        0x43,
        0x90,
    ],
    "gEfiTlsConfigurationProtocolGuid": [
        0x1682FE44,
        0xBD7A,
        0x4407,
        0xB7,
        0xC7,
        0xDC,
        0xA3,
        0x7C,
        0xA3,
        0x92,
        0x2D,
    ],
    "gEfiRestProtocolGuid": [
        0x0DB48A36,
        0x4E54,
        0xEA9C,
        0x9B,
        0x09,
        0x1E,
        0xA5,
        0xBE,
        0x3A,
        0x66,
        0x0B,
    ],
    "gEfiSupplicantServiceBindingProtocolGuid": [
        0x45BCD98E,
        0x59AD,
        0x4174,
        0x95,
        0x46,
        0x34,
        0x4A,
        0x7,
        0x48,
        0x58,
        0x98,
    ],
    "gEfiSupplicantProtocolGuid": [
        0x54FCC43E,
        0xAA89,
        0x4333,
        0x9A,
        0x85,
        0xCD,
        0xEA,
        0x24,
        0x5,
        0x1E,
        0x9E,
    ],
    "gEfiWiFi2ProtocolGuid": [
        0x1B0FB9BF,
        0x699D,
        0x4FDD,
        0xA7,
        0xC3,
        0x25,
        0x46,
        0x68,
        0x1B,
        0xF6,
        0x3B,
    ],
    "gEfiRamDiskProtocolGuid": [
        0xAB38A0DF,
        0x6873,
        0x44A9,
        0x87,
        0xE6,
        0xD4,
        0xEB,
        0x56,
        0x14,
        0x84,
        0x49,
    ],
    "gEfiHiiImageDecoderProtocolGuid": [
        0x9E66F251,
        0x727C,
        0x418C,
        0xBF,
        0xD6,
        0xC2,
        0xB4,
        0x25,
        0x28,
        0x18,
        0xEA,
    ],
    "gEfiHiiImageExProtocolGuid": [
        0x1A1241E6,
        0x8F19,
        0x41A9,
        0xBC,
        0xE,
        0xE8,
        0xEF,
        0x39,
        0xE0,
        0x65,
        0x46,
    ],
    "gEfiSdMmcPassThruProtocolGuid": [
        0x716EF0D9,
        0xFF83,
        0x4F69,
        0x81,
        0xE9,
        0x51,
        0x8B,
        0xD3,
        0x9A,
        0x8E,
        0x70,
    ],
    "gEfiEraseBlockProtocolGuid": [
        0x95A9A93E,
        0xA86E,
        0x4926,
        0xAA,
        0xEF,
        0x99,
        0x18,
        0xE7,
        0x72,
        0xD9,
        0x87,
    ],
    "gEfiBluetoothAttributeProtocolGuid": [
        0x898890E9,
        0x84B2,
        0x4F3A,
        0x8C,
        0x58,
        0xD8,
        0x57,
        0x78,
        0x13,
        0xE0,
        0xAC,
    ],
    "gEfiBluetoothAttributeServiceBindingProtocolGuid": [
        0x5639867A,
        0x8C8E,
        0x408D,
        0xAC,
        0x2F,
        0x4B,
        0x61,
        0xBD,
        0xC0,
        0xBB,
        0xBB,
    ],
    "gEfiBluetoothLeConfigProtocolGuid": [
        0x8F76DA58,
        0x1F99,
        0x4275,
        0xA4,
        0xEC,
        0x47,
        0x56,
        0x51,
        0x5B,
        0x1C,
        0xE8,
    ],
    "gEfiUfsDeviceConfigProtocolGuid": [
        0xB81BFAB0,
        0xEB3,
        0x4CF9,
        0x84,
        0x65,
        0x7F,
        0xA9,
        0x86,
        0x36,
        0x16,
        0x64,
    ],
    "gEfiHttpBootCallbackProtocolGuid": [
        0xBA23B311,
        0x343D,
        0x11E6,
        0x91,
        0x85,
        0x58,
        0x20,
        0xB1,
        0xD6,
        0x52,
        0x99,
    ],
    "gEfiResetNotificationProtocolGuid": [
        0x9DA34AE0,
        0xEAF9,
        0x4BBF,
        0x8E,
        0xC3,
        0xFD,
        0x60,
        0x22,
        0x6C,
        0x44,
        0xBE,
    ],
    "gEfiPartitionInfoProtocolGuid": [
        0x8CF2F62C,
        0xBC9B,
        0x4821,
        0x80,
        0x8D,
        0xEC,
        0x9E,
        0xC4,
        0x21,
        0xA1,
        0xA0,
    ],
    "gEfiHiiPopupProtocolGuid": [
        0x4311EDC0,
        0x6054,
        0x46D4,
        0x9E,
        0x40,
        0x89,
        0x3E,
        0xA9,
        0x52,
        0xFC,
        0xCC,
    ],
    "gEfiNvdimmLabelProtocolGuid": [
        0xD40B6B80,
        0x97D5,
        0x4282,
        0xBB,
        0x1D,
        0x22,
        0x3A,
        0x16,
        0x91,
        0x80,
        0x58,
    ],
    "gEfiShellProtocolGuid": [
        0x6302D008,
        0x7F9B,
        0x4F30,
        0x87,
        0xAC,
        0x60,
        0xC9,
        0xFE,
        0xF5,
        0xDA,
        0x4E,
    ],
    "gEfiShellParametersProtocolGuid": [
        0x752F3136,
        0x4E16,
        0x4FDC,
        0xA2,
        0x2A,
        0xE5,
        0xF4,
        0x68,
        0x12,
        0xF4,
        0xCA,
    ],
    "gEfiShellDynamicCommandProtocolGuid": [
        0x3C7200E9,
        0x005F,
        0x4EA4,
        0x87,
        0xDE,
        0xA3,
        0xDF,
        0xAC,
        0x8A,
        0x27,
        0xC3,
    ],
    # Guids from .\edk2\NetworkPkg\NetworkPkg.dec file
    "gEfiNetworkPkgTokenSpaceGuid": [
        0x40E064B2,
        0x0AE0,
        0x48B1,
        0xA0,
        0x7D,
        0xF8,
        0xCF,
        0x1E,
        0x1A,
        0x23,
        0x10,
    ],
    "gIp6ConfigNvDataGuid": [
        0x2EEA107,
        0x98DB,
        0x400E,
        0x98,
        0x30,
        0x46,
        0xA,
        0x15,
        0x42,
        0xD7,
        0x99,
    ],
    "gIScsiConfigGuid": [
        0x4B47D616,
        0xA8D6,
        0x4552,
        0x9D,
        0x44,
        0xCC,
        0xAD,
        0x2E,
        0xF,
        0x4C,
        0xF9,
    ],
    "gHttpBootConfigGuid": [
        0x4D20583A,
        0x7765,
        0x4E7A,
        0x8A,
        0x67,
        0xDC,
        0xDE,
        0x74,
        0xEE,
        0x3E,
        0xC5,
    ],
    "gTlsAuthConfigGuid": [
        0xB0EAE4F8,
        0x9A04,
        0x4C6D,
        0xA7,
        0x48,
        0x79,
        0x3D,
        0xAA,
        0xF,
        0x65,
        0xDF,
    ],
    "gEfiTlsCaCertificateGuid": [
        0xFD2340D0,
        0x3DAB,
        0x4349,
        0xA6,
        0xC7,
        0x3B,
        0x4F,
        0x12,
        0xB4,
        0x8E,
        0xAE,
    ],
    "gEdkiiHttpTlsCipherListGuid": [
        0x46DDB415,
        0x5244,
        0x49C7,
        0x93,
        0x74,
        0xF0,
        0xE2,
        0x98,
        0xE7,
        0xD3,
        0x86,
    ],
    "gWifiConfigGuid": [
        0x9F94D327,
        0x0B18,
        0x4245,
        0x8F,
        0xF2,
        0x83,
        0x2E,
        0x30,
        0xD,
        0x2C,
        0xEF,
    ],
    "gIp4Config2NvDataGuid": [
        0x9B942747,
        0x154E,
        0x4D29,
        0xA4,
        0x36,
        0xBF,
        0x71,
        0x0,
        0xC8,
        0xB5,
        0x3B,
    ],
    "gVlanConfigFormSetGuid": [
        0xD79DF6B0,
        0xEF44,
        0x43BD,
        0x97,
        0x97,
        0x43,
        0xE9,
        0x3B,
        0xCF,
        0x5F,
        0xA8,
    ],
    "gIp4IScsiConfigGuid": [
        0x6456ED61,
        0x3579,
        0x41C9,
        0x8A,
        0x26,
        0x0A,
        0x0B,
        0xD6,
        0x2B,
        0x78,
        0xFC,
    ],
    "gIScsiCHAPAuthInfoGuid": [
        0x786EC0AC,
        0x65AE,
        0x4D1B,
        0xB1,
        0x37,
        0xD,
        0x11,
        0xA,
        0x48,
        0x37,
        0x97,
    ],
    "gEfiDpcProtocolGuid": [
        0x480F8AE9,
        0xC46,
        0x4AA9,
        0xBC,
        0x89,
        0xDB,
        0x9F,
        0xBA,
        0x61,
        0x98,
        0x6,
    ],
    # Guids from .\edk2\OvmfPkg\OvmfPkg.dec file
    "gUefiOvmfPkgTokenSpaceGuid": [
        0x93BB96AF,
        0xB9F2,
        0x4EB8,
        0x94,
        0x62,
        0xE0,
        0xBA,
        0x74,
        0x56,
        0x42,
        0x36,
    ],
    "gEfiXenInfoGuid": [
        0xD3B46F3B,
        0xD441,
        0x1244,
        0x9A,
        0x12,
        0x0,
        0x12,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gOvmfPkKek1AppPrefixGuid": [
        0x4E32566D,
        0x8E9E,
        0x4F52,
        0x81,
        0xD3,
        0x5B,
        0xB9,
        0x71,
        0x5F,
        0x97,
        0x27,
    ],
    "gOvmfPlatformConfigGuid": [
        0x7235C51C,
        0x0C80,
        0x4CAB,
        0x87,
        0xAC,
        0x3B,
        0x08,
        0x4A,
        0x63,
        0x04,
        0xB1,
    ],
    "gVirtioMmioTransportGuid": [
        0x837DCA9E,
        0xE874,
        0x4D82,
        0xB2,
        0x9A,
        0x23,
        0xFE,
        0x0E,
        0x23,
        0xD1,
        0xE2,
    ],
    "gQemuRamfbGuid": [
        0x557423A1,
        0x63AB,
        0x406C,
        0xBE,
        0x7E,
        0x91,
        0xCD,
        0xBC,
        0x08,
        0xC4,
        0x57,
    ],
    "gXenBusRootDeviceGuid": [
        0xA732241F,
        0x383D,
        0x4D9C,
        0x8A,
        0xE1,
        0x8E,
        0x09,
        0x83,
        0x75,
        0x89,
        0xD7,
    ],
    "gRootBridgesConnectedEventGroupGuid": [
        0x24A2D66F,
        0xEEDD,
        0x4086,
        0x90,
        0x42,
        0xF2,
        0x6E,
        0x47,
        0x97,
        0xEE,
        0x69,
    ],
    "gMicrosoftVendorGuid": [
        0x77FA9ABD,
        0x0359,
        0x4D32,
        0xBD,
        0x60,
        0x28,
        0xF4,
        0xE7,
        0x8F,
        0x78,
        0x4B,
    ],
    "gEfiLegacyBiosGuid": [
        0x2E3044AC,
        0x879F,
        0x490F,
        0x97,
        0x60,
        0xBB,
        0xDF,
        0xAF,
        0x69,
        0x5F,
        0x50,
    ],
    "gEfiLegacyDevOrderVariableGuid": [
        0xA56074DB,
        0x65FE,
        0x45F7,
        0xBD,
        0x21,
        0x2D,
        0x2B,
        0xDD,
        0x8E,
        0x96,
        0x52,
    ],
    "gLinuxEfiInitrdMediaGuid": [
        0x5568E427,
        0x68FC,
        0x4F3D,
        0xAC,
        0x74,
        0xCA,
        0x55,
        0x52,
        0x31,
        0xCC,
        0x68,
    ],
    "gQemuKernelLoaderFsMediaGuid": [
        0x1428F772,
        0xB64A,
        0x441E,
        0xB8,
        0xC3,
        0x9E,
        0xBD,
        0xD7,
        0xF8,
        0x93,
        0xC7,
    ],
    "gOvmfTpmDiscoveredPpiGuid": [
        0xB9A61AD0,
        0x2802,
        0x41F3,
        0xB5,
        0x13,
        0x96,
        0x51,
        0xCE,
        0x6B,
        0xD5,
        0x75,
    ],
    "gVirtioDeviceProtocolGuid": [
        0xFA920010,
        0x6785,
        0x4941,
        0xB6,
        0xEC,
        0x49,
        0x8C,
        0x57,
        0x9F,
        0x16,
        0x0A,
    ],
    "gXenBusProtocolGuid": [
        0x3D3CA290,
        0xB9A5,
        0x11E3,
        0xB7,
        0x5D,
        0xB8,
        0xAC,
        0x6F,
        0x7D,
        0x65,
        0xE6,
    ],
    "gXenIoProtocolGuid": [
        0x6EFAC84F,
        0x0AB0,
        0x4747,
        0x81,
        0xBE,
        0x85,
        0x55,
        0x62,
        0x59,
        0x04,
        0x49,
    ],
    "gIoMmuAbsentProtocolGuid": [
        0xF8775D50,
        0x8ABD,
        0x4ADF,
        0x92,
        0xAC,
        0x85,
        0x3E,
        0x51,
        0xF6,
        0xC8,
        0xDC,
    ],
    "gEfiLegacy8259ProtocolGuid": [
        0x38321DBA,
        0x4FE0,
        0x4E17,
        0x8A,
        0xEC,
        0x41,
        0x30,
        0x55,
        0xEA,
        0xED,
        0xC1,
    ],
    "gEfiFirmwareVolumeProtocolGuid": [
        0x389F751F,
        0x1838,
        0x4388,
        0x83,
        0x90,
        0xCD,
        0x81,
        0x54,
        0xBD,
        0x27,
        0xF8,
    ],
    "gEfiIsaAcpiProtocolGuid": [
        0x64A892DC,
        0x5561,
        0x4536,
        0x92,
        0xC7,
        0x79,
        0x9B,
        0xFC,
        0x18,
        0x33,
        0x55,
    ],
    "gEfiIsaIoProtocolGuid": [
        0x7EE2BD44,
        0x3DA0,
        0x11D4,
        0x9A,
        0x38,
        0x0,
        0x90,
        0x27,
        0x3F,
        0xC1,
        0x4D,
    ],
    "gEfiLegacyBiosProtocolGuid": [
        0xDB9A1E3D,
        0x45CB,
        0x4ABB,
        0x85,
        0x3B,
        0xE5,
        0x38,
        0x7F,
        0xDB,
        0x2E,
        0x2D,
    ],
    "gEfiLegacyBiosPlatformProtocolGuid": [
        0x783658A3,
        0x4172,
        0x4421,
        0xA2,
        0x99,
        0xE0,
        0x09,
        0x07,
        0x9C,
        0x0C,
        0xB4,
    ],
    "gEfiLegacyInterruptProtocolGuid": [
        0x31CE593D,
        0x108A,
        0x485D,
        0xAD,
        0xB2,
        0x78,
        0xF2,
        0x1F,
        0x29,
        0x66,
        0xBE,
    ],
    "gEfiVgaMiniPortProtocolGuid": [
        0xC7735A2F,
        0x88F5,
        0x4882,
        0xAE,
        0x63,
        0xFA,
        0xAC,
        0x8C,
        0x8B,
        0x86,
        0xB3,
    ],
    "gOvmfLoadedX86LinuxKernelProtocolGuid": [
        0xA3EDC05D,
        0xB618,
        0x4FF6,
        0x95,
        0x52,
        0x76,
        0xD7,
        0x88,
        0x63,
        0x43,
        0xC8,
    ],
    # Guids from .\edk2\PcAtChipsetPkg\PcAtChipsetPkg.dec file
    "gPcAtChipsetPkgTokenSpaceGuid": [
        0x326AE723,
        0xAE32,
        0x4589,
        0x98,
        0xB8,
        0xCA,
        0xC2,
        0x3C,
        0xDC,
        0xC1,
        0xB1,
    ],
    # Guids from .\edk2\SecurityPkg\SecurityPkg.dec file
    "gEfiSecurityPkgTokenSpaceGuid": [
        0xD3FB176,
        0x9569,
        0x4D51,
        0xA3,
        0xEF,
        0x7D,
        0x61,
        0xC6,
        0x4F,
        0xEA,
        0xBA,
    ],
    "gEfiSecureBootEnableDisableGuid": [
        0xF0A30BC7,
        0xAF08,
        0x4556,
        0x99,
        0xC4,
        0x0,
        0x10,
        0x9,
        0xC9,
        0x3A,
        0x44,
    ],
    "gEfiCustomModeEnableGuid": [
        0xC076EC0C,
        0x7028,
        0x4399,
        0xA0,
        0x72,
        0x71,
        0xEE,
        0x5C,
        0x44,
        0x8B,
        0x9F,
    ],
    "gEfiVendorKeysNvGuid": [
        0x9073E4E0,
        0x60EC,
        0x4B6E,
        0x99,
        0x3,
        0x4C,
        0x22,
        0x3C,
        0x26,
        0xF,
        0x3C,
    ],
    "gEfiCertDbGuid": [
        0xD9BEE56E,
        0x75DC,
        0x49D9,
        0xB4,
        0xD7,
        0xB5,
        0x34,
        0x21,
        0xF,
        0x63,
        0x7A,
    ],
    "gTcgEventEntryHobGuid": [
        0x2B9FFB52,
        0x1B13,
        0x416F,
        0xA8,
        0x7B,
        0xBC,
        0x93,
        0xD,
        0xEF,
        0x92,
        0xA8,
    ],
    "gTcgEvent2EntryHobGuid": [
        0xD26C221E,
        0x2430,
        0x4C8A,
        0x91,
        0x70,
        0x3F,
        0xCB,
        0x45,
        0x0,
        0x41,
        0x3F,
    ],
    "gTpmErrorHobGuid": [
        0xEF598499,
        0xB25E,
        0x473A,
        0xBF,
        0xAF,
        0xE7,
        0xE5,
        0x7D,
        0xCE,
        0x82,
        0xC4,
    ],
    "gTpm2StartupLocalityHobGuid": [
        0x397B0C9,
        0x22E8,
        0x459E,
        0xA4,
        0xFF,
        0x99,
        0xBC,
        0x65,
        0x27,
        0x9,
        0x29,
    ],
    "gTcg800155PlatformIdEventHobGuid": [
        0xE2C3BC69,
        0x615C,
        0x4B5B,
        0x8E,
        0x5C,
        0xA0,
        0x33,
        0xA9,
        0xC2,
        0x5E,
        0xD6,
    ],
    "gMeasuredFvHobGuid": [
        0xB2360B42,
        0x7173,
        0x420A,
        0x86,
        0x96,
        0x46,
        0xCA,
        0x6B,
        0xAB,
        0x10,
        0x60,
    ],
    "gEfiPhysicalPresenceGuid": [
        0xF6499B1,
        0xE9AD,
        0x493D,
        0xB9,
        0xC2,
        0x2F,
        0x90,
        0x81,
        0x5C,
        0x6C,
        0xBC,
    ],
    "gEfiTcg2PhysicalPresenceGuid": [
        0xAEB9C5C1,
        0x94F1,
        0x4D02,
        0xBF,
        0xD9,
        0x46,
        0x2,
        0xDB,
        0x2D,
        0x3C,
        0x54,
    ],
    "gUserIdentifyManagerGuid": [
        0x3CCD3DD8,
        0x8D45,
        0x4FED,
        0x96,
        0x2D,
        0x2B,
        0x38,
        0xCD,
        0x82,
        0xB3,
        0xC4,
    ],
    "gTcgConfigFormSetGuid": [
        0xB0F901E4,
        0xC424,
        0x45DE,
        0x90,
        0x81,
        0x95,
        0xE2,
        0xB,
        0xDE,
        0x6F,
        0xB5,
    ],
    "gTcg2ConfigFormSetGuid": [
        0x6339D487,
        0x26BA,
        0x424B,
        0x9A,
        0x5D,
        0x68,
        0x7E,
        0x25,
        0xD7,
        0x40,
        0xBC,
    ],
    "gSecureBootConfigFormSetGuid": [
        0x5DAF50A5,
        0xEA81,
        0x4DE2,
        0x8F,
        0x9B,
        0xCA,
        0xBD,
        0xA9,
        0xCF,
        0x5C,
        0x14,
    ],
    "gEfiTpmDeviceInstanceNoneGuid": [
        0x00000000,
        0x0000,
        0x0000,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
        0x00,
    ],
    "gEfiTpmDeviceInstanceTpm12Guid": [
        0x8B01E5B6,
        0x4F19,
        0x46E8,
        0xAB,
        0x93,
        0x1C,
        0x53,
        0x67,
        0x1B,
        0x90,
        0xCC,
    ],
    "gEfiTpmDeviceInstanceTpm20DtpmGuid": [
        0x286BF25A,
        0xC2C3,
        0x408C,
        0xB3,
        0xB4,
        0x25,
        0xE6,
        0x75,
        0x8B,
        0x73,
        0x17,
    ],
    "gEfiTpmDeviceSelectedGuid": [
        0x7F4158D3,
        0x74D,
        0x456D,
        0x8C,
        0xB2,
        0x1,
        0xF9,
        0xC8,
        0xF7,
        0x9D,
        0xAA,
    ],
    "gOpalExtraInfoVariableGuid": [
        0x44A2AD5D,
        0x612C,
        0x47B3,
        0xB0,
        0x6E,
        0xC8,
        0xF5,
        0x0B,
        0xFB,
        0xF0,
        0x7D,
    ],
    "gPeiLockPhysicalPresencePpiGuid": [
        0xEF9AEFE5,
        0x2BD3,
        0x4031,
        0xAF,
        0x7D,
        0x5E,
        0xFE,
        0x5A,
        0xBB,
        0x9A,
        0xD,
    ],
    "gPeiTpmInitializedPpiGuid": [
        0xE9DB0D58,
        0xD48D,
        0x47F6,
        0x9C,
        0x6E,
        0x6F,
        0x40,
        0xE8,
        0x6C,
        0x7B,
        0x41,
    ],
    "gPeiTpmInitializationDonePpiGuid": [
        0xA030D115,
        0x54DD,
        0x447B,
        0x90,
        0x64,
        0xF2,
        0x6,
        0x88,
        0x3D,
        0x7C,
        0xCC,
    ],
    "gEfiPeiFirmwareVolumeInfoMeasurementExcludedPpiGuid": [
        0x6E056FF9,
        0xC695,
        0x4364,
        0x9E,
        0x2C,
        0x61,
        0x26,
        0xF5,
        0xCE,
        0xEA,
        0xAE,
    ],
    "gEdkiiPeiFirmwareVolumeInfoPrehashedFvPpiGuid": [
        0x3CE1E631,
        0x7008,
        0x477C,
        0xAD,
        0xA7,
        0x5D,
        0xCF,
        0xC7,
        0xC1,
        0x49,
        0x4B,
    ],
    "gEdkiiPeiFirmwareVolumeInfoStoredHashFvPpiGuid": [
        0x7F5E4E31,
        0x81B1,
        0x47E5,
        0x9E,
        0x21,
        0x1E,
        0x4B,
        0x5B,
        0xC2,
        0xF6,
        0x1D,
    ],
    # Guids from .\edk2\ShellPkg\ShellPkg.dec file
    "gEfiShellEnvironment2ExtGuid": [
        0xD2C18636,
        0x40E5,
        0x4EB5,
        0xA3,
        0x1B,
        0x36,
        0x69,
        0x5F,
        0xD4,
        0x2C,
        0x87,
    ],
    "gEfiShellPkgTokenSpaceGuid": [
        0x171E9188,
        0x31D3,
        0x40F5,
        0xB1,
        0x0C,
        0x53,
        0x9B,
        0x2D,
        0xB9,
        0x40,
        0xCD,
    ],
    "gShellVariableGuid": [
        0x158DEF5A,
        0xF656,
        0x419C,
        0xB0,
        0x27,
        0x7A,
        0x31,
        0x92,
        0xC0,
        0x79,
        0xD2,
    ],
    "gShellMapGuid": [
        0x51271E13,
        0x7DE3,
        0x43AF,
        0x8B,
        0xC2,
        0x71,
        0xAD,
        0x3B,
        0x82,
        0x43,
        0x25,
    ],
    "gShellAliasGuid": [
        0x0053D9D6,
        0x2659,
        0x4599,
        0xA2,
        0x6B,
        0xEF,
        0x45,
        0x36,
        0xE6,
        0x31,
        0xA9,
    ],
    "gHandleParsingHiiGuid": [
        0xB8969637,
        0x81DE,
        0x43AF,
        0xBC,
        0x9A,
        0x24,
        0xD9,
        0x89,
        0x13,
        0xF2,
        0xF6,
    ],
    "gShellDebug1HiiGuid": [
        0x25F200AA,
        0xD3CB,
        0x470A,
        0xBF,
        0x51,
        0xE7,
        0xD1,
        0x62,
        0xD2,
        0x2E,
        0x6F,
    ],
    "gShellDriver1HiiGuid": [
        0xAF0B742,
        0x63EC,
        0x45BD,
        0x8D,
        0xB6,
        0x71,
        0xAD,
        0x7F,
        0x2F,
        0xE8,
        0xE8,
    ],
    "gShellInstall1HiiGuid": [
        0x7D574D54,
        0xD364,
        0x4D4A,
        0x95,
        0xE3,
        0x49,
        0x45,
        0xDB,
        0x7A,
        0xD3,
        0xEE,
    ],
    "gShellLevel1HiiGuid": [
        0xDEC5DAA4,
        0x6781,
        0x4820,
        0x9C,
        0x63,
        0xA7,
        0xB0,
        0xE4,
        0xF1,
        0xDB,
        0x31,
    ],
    "gShellLevel2HiiGuid": [
        0xF95A7CCC,
        0x4C55,
        0x4426,
        0xA7,
        0xB4,
        0xDC,
        0x89,
        0x61,
        0x95,
        0xB,
        0xAE,
    ],
    "gShellLevel3HiiGuid": [
        0x4344558D,
        0x4EF9,
        0x4725,
        0xB1,
        0xE4,
        0x33,
        0x76,
        0xE8,
        0xD6,
        0x97,
        0x4F,
    ],
    "gShellNetwork1HiiGuid": [
        0xF3D301BB,
        0xF4A5,
        0x45A8,
        0xB0,
        0xB7,
        0xFA,
        0x99,
        0x9C,
        0x62,
        0x37,
        0xAE,
    ],
    "gShellNetwork2HiiGuid": [
        0x174B2B5,
        0xF505,
        0x4B12,
        0xAA,
        0x60,
        0x59,
        0xDF,
        0xF8,
        0xD6,
        0xEA,
        0x37,
    ],
    "gShellTftpHiiGuid": [
        0x738A9314,
        0x82C1,
        0x4592,
        0x8F,
        0xF7,
        0xC1,
        0xBD,
        0xF1,
        0xB2,
        0x0E,
        0xD4,
    ],
    "gShellBcfgHiiGuid": [
        0x5F5F605D,
        0x1583,
        0x4A2D,
        0xA6,
        0xB2,
        0xEB,
        0x12,
        0xDA,
        0xB4,
        0xA2,
        0xB6,
    ],
    "gShellAcpiViewHiiGuid": [
        0xDA8CCDF4,
        0xED8F,
        0x4FFC,
        0xB5,
        0xEF,
        0x2E,
        0xF5,
        0x5E,
        0x24,
        0x93,
        0x2A,
    ],
    "gUefiShellFileGuid": [
        0x7C04A583,
        0x9E3E,
        0x4F1C,
        0xAD,
        0x65,
        0xE0,
        0x52,
        0x68,
        0xD0,
        0xB4,
        0xD1,
    ],
    "gEfiShellEnvironment2Guid": [
        0x47C7B221,
        0xC42A,
        0x11D2,
        0x8E,
        0x57,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    "gEfiShellInterfaceGuid": [
        0x47C7B223,
        0xC42A,
        0x11D2,
        0x8E,
        0x57,
        0x00,
        0xA0,
        0xC9,
        0x69,
        0x72,
        0x3B,
    ],
    # Guids from .\edk2\SignedCapsulePkg\SignedCapsulePkg.dec file
    "gEfiSignedCapsulePkgTokenSpaceGuid": [
        0xE1EB612F,
        0x1C6C,
        0x485D,
        0x9D,
        0x6,
        0x65,
        0x8,
        0x44,
        0x88,
        0x15,
        0x69,
    ],
    "gEdkiiSystemFirmwareImageDescriptorFileGuid": [
        0x90B2B846,
        0xCA6D,
        0x4D6E,
        0xA8,
        0xD3,
        0xC1,
        0x40,
        0xA8,
        0xE1,
        0x10,
        0xAC,
    ],
    "gEdkiiSystemFmpCapsuleConfigFileGuid": [
        0x812136D3,
        0x4D3A,
        0x433A,
        0x94,
        0x18,
        0x29,
        0xBB,
        0x9B,
        0xF7,
        0x8F,
        0x6E,
    ],
    "gEdkiiSystemFmpCapsuleDriverFvFileGuid": [
        0xCE57B167,
        0xB0E4,
        0x41E8,
        0xA8,
        0x97,
        0x5F,
        0x4F,
        0xEB,
        0x78,
        0x1D,
        0x40,
    ],
    # Guids from .\edk2\SourceLevelDebugPkg\SourceLevelDebugPkg.dec file
    "gEfiDebugAgentGuid": [
        0x865A5A9B,
        0xB85D,
        0x474C,
        0x84,
        0x55,
        0x65,
        0xD1,
        0xBE,
        0x84,
        0x4B,
        0xE2,
    ],
    "gEfiSourceLevelDebugPkgTokenSpaceGuid": [
        0x865A5AAB,
        0xB85D,
        0x474C,
        0x84,
        0x55,
        0x65,
        0xD1,
        0xBE,
        0x84,
        0x4B,
        0xE2,
    ],
    # Guids from .\edk2\StandaloneMmPkg\StandaloneMmPkg.dec file
    "gStandaloneMmPkgTokenSpaceGuid": [
        0x18FE7632,
        0xF5C8,
        0x4E63,
        0x8D,
        0xE8,
        0x17,
        0xA5,
        0x5C,
        0x59,
        0x13,
        0xBD,
    ],
    "gMpInformationHobGuid": [
        0xBA33F15D,
        0x4000,
        0x45C1,
        0x8E,
        0x88,
        0xF9,
        0x16,
        0x92,
        0xD4,
        0x57,
        0xE3,
    ],
    "gMmFvDispatchGuid": [
        0xB65694CC,
        0x09E3,
        0x4C3B,
        0xB5,
        0xCD,
        0x05,
        0xF4,
        0x4D,
        0x3C,
        0xDB,
        0xFF,
    ],
    "gMmCoreDataHobGuid": [
        0xA160BF99,
        0x2AA4,
        0x4D7D,
        0x99,
        0x93,
        0x89,
        0x9C,
        0xB1,
        0x2D,
        0xF3,
        0x76,
    ],
    "gEfiMmPeiMmramMemoryReserveGuid": [
        0x0703F912,
        0xBF8D,
        0x4E2A,
        0xBE,
        0x07,
        0xAB,
        0x27,
        0x25,
        0x25,
        0xC5,
        0x92,
    ],
    "gEfiStandaloneMmNonSecureBufferGuid": [
        0xF00497E3,
        0xBFA2,
        0x41A1,
        0x9D,
        0x29,
        0x54,
        0xC2,
        0xE9,
        0x37,
        0x21,
        0xC5,
    ],
    "gEfiArmTfCpuDriverEpDescriptorGuid": [
        0x6ECBD5A1,
        0xC0F8,
        0x4702,
        0x83,
        0x01,
        0x4F,
        0xC2,
        0xC5,
        0x47,
        0x0A,
        0x51,
    ],
    # Guids from .\edk2\UefiCpuPkg\UefiCpuPkg.dec file
    "gUefiCpuPkgTokenSpaceGuid": [
        0xAC05BF33,
        0x995A,
        0x4ED4,
        0xAA,
        0xB8,
        0xEF,
        0x7A,
        0xE8,
        0xF,
        0x5C,
        0xB0,
    ],
    "gMsegSmramGuid": [
        0x5802BCE4,
        0xEEEE,
        0x4E33,
        0xA1,
        0x30,
        0xEB,
        0xAD,
        0x27,
        0xF0,
        0xE4,
        0x39,
    ],
    "gEdkiiCpuFeaturesSetDoneGuid": [
        0xA82485CE,
        0xAD6B,
        0x4101,
        0x99,
        0xD3,
        0xE1,
        0x35,
        0x8C,
        0x9E,
        0x7E,
        0x37,
    ],
    "gEdkiiCpuFeaturesInitDoneGuid": [
        0xC77C3A41,
        0x61AB,
        0x4143,
        0x98,
        0x3E,
        0x33,
        0x39,
        0x28,
        0x6,
        0x28,
        0xE5,
    ],
    "gEdkiiMicrocodePatchHobGuid": [
        0xD178F11D,
        0x8716,
        0x418E,
        0xA1,
        0x31,
        0x96,
        0x7D,
        0x2A,
        0xC4,
        0x28,
        0x43,
    ],
    "gEfiSmmCpuServiceProtocolGuid": [
        0x1D202CAB,
        0xC8AB,
        0x4D5C,
        0x94,
        0xF7,
        0x3C,
        0xFC,
        0xC0,
        0xD3,
        0xD3,
        0x35,
    ],
    "gEfiSmMonitorInitProtocolGuid": [
        0x228F344D,
        0xB3DE,
        0x43BB,
        0xA4,
        0xD7,
        0xEA,
        0x20,
        0xB,
        0x1B,
        0x14,
        0x82,
    ],
    "gEdkiiPeiMpServices2PpiGuid": [
        0x5CB9CB3D,
        0x31A4,
        0x480C,
        0x94,
        0x98,
        0x29,
        0xD2,
        0x69,
        0xBA,
        0xCF,
        0xBA,
    ],
    "gEdkiiPeiShadowMicrocodePpiGuid": [
        0x430F6965,
        0x9A69,
        0x41C5,
        0x93,
        0xED,
        0x8B,
        0xF0,
        0x64,
        0x35,
        0xC1,
        0xC6,
    ],
    # Guids from .\edk2\UefiPayloadPkg\UefiPayloadPkg.dec file
    "gUefiPayloadPkgTokenSpaceGuid": [
        0x1D127EA,
        0xF6F1,
        0x4EF6,
        0x94,
        0x15,
        0x8A,
        0x0,
        0x0,
        0x93,
        0xF8,
        0x9D,
    ],
    "gBmpImageGuid": [
        0x878AC2CC,
        0x5343,
        0x46F2,
        0xB5,
        0x63,
        0x51,
        0xF8,
        0x9D,
        0xAF,
        0x56,
        0xBA,
    ],
    "gUefiSystemTableInfoGuid": [
        0x16C8A6D0,
        0xFE8A,
        0x4082,
        0xA2,
        0x8,
        0xCF,
        0x89,
        0xC4,
        0x29,
        0x4,
        0x33,
    ],
    "gUefiAcpiBoardInfoGuid": [
        0xAD3D31B,
        0xB3D8,
        0x4506,
        0xAE,
        0x71,
        0x2E,
        0xF1,
        0x10,
        0x6,
        0xD9,
        0xF,
    ],
    "gUefiSerialPortInfoGuid": [
        0x6C6872FE,
        0x56A9,
        0x4403,
        0xBB,
        0x98,
        0x95,
        0x8D,
        0x62,
        0xDE,
        0x87,
        0xF1,
    ],
    "gLoaderMemoryMapInfoGuid": [
        0xA1FF7424,
        0x7A1A,
        0x478E,
        0xA9,
        0xE4,
        0x92,
        0xF3,
        0x57,
        0xD1,
        0x28,
        0x32,
    ],
    "gEfiPayLoadHobBasePpiGuid": [
        0xDBE23AA1,
        0xA342,
        0x4B97,
        0x85,
        0xB6,
        0xB2,
        0x26,
        0xF1,
        0x61,
        0x73,
        0x89,
    ],
    "gPlatformGOPPolicyGuid": [
        0xEC2E931B,
        0x3281,
        0x48A5,
        0x81,
        0x07,
        0xDF,
        0x8A,
        0x8B,
        0xED,
        0x3C,
        0x5D,
    ],
    # Guids from .\edk2\UnitTestFrameworkPkg\UnitTestFrameworkPkg.dec file
    "gUnitTestFrameworkPkgTokenSpaceGuid": [
        0x833D3ABA,
        0x39B4,
        0x43A2,
        0xB9,
        0x30,
        0x7A,
        0x34,
        0x53,
        0x39,
        0x31,
        0xB3,
    ],
}