/*
 Navicat Premium Data Transfer

 Source Server         : mariadb-3307
 Source Server Type    : MariaDB
 Source Server Version : 100510
 Source Host           : localhost:3307
 Source Schema         : traceevidencedb

 Target Server Type    : MariaDB
 Target Server Version : 100510
 File Encoding         : 65001

 Date: 25/08/2022 22:40:25
*/

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- Table structure for bc_evidence
-- ----------------------------
DROP TABLE IF EXISTS `bc_evidence`;
CREATE TABLE `bc_evidence`  (
  `ServiceId` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '事务Id',
  `TypeName` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '存证类别',
  `DataValue` varchar(2000) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '存证数据',
  `EvidenceState` int(11) NULL DEFAULT NULL COMMENT '存证状态',
  `Message` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '存证提示信息',
  `TranscationHash` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '交易Hash',
  `OperaEvidenceDate` datetime(0) NULL DEFAULT NULL COMMENT '存证操作时间',
  `BusinessFlowId` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务流程Id',
  `BehaviorTypeId` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '行为类别Id',
  `BusinessFlowName` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '业务流程名称',
  `BehaviorTypeName` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '行为类别名称',
  `CreatorUserId` bigint(20) NULL DEFAULT NULL COMMENT ' 创建ID',
  `CreationTime` datetime(0) NULL DEFAULT NULL COMMENT ' 创建时间',
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `IsActive` bit(1) NULL DEFAULT NULL COMMENT '是否启用标识',
  `IsDeleted` bit(1) NULL DEFAULT NULL COMMENT ' 是否删除标识',
  `TenantId` int(11) NULL DEFAULT NULL COMMENT '租户Id',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 7 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of bc_evidence
-- ----------------------------
INSERT INTO `bc_evidence` VALUES ('21212', '12121', '123123213,\"业务上链用户id\"：1', 1, NULL, '0x49dc66b5c7d5ddfc2f28dd24a25d5b518ba53b71ad80d68edef95ee3cbd28720', '2022-08-25 11:39:15', '6305bc11235a6231f8953993', '47119a01-80ad-4050-b23b-2fcffe7a9d2a', '食品溯源存证流程', '养殖场', 0, NULL, 1, NULL, NULL, NULL);
INSERT INTO `bc_evidence` VALUES ('222', '11222', '111112121,\"业务上链用户id\"：1', 1, NULL, '0x82985eaee1744702e453966a387b03e50786c4b139883b4253e5f292218bfd5c', '2022-08-25 11:48:08', '6305bc11235a6231f8953993', '47119a01-80ad-4050-b23b-2fcffe7a9d2a', '食品溯源存证流程', '养殖场', 0, NULL, 2, NULL, NULL, NULL);
INSERT INTO `bc_evidence` VALUES ('A123', '牛养殖', '牛在养殖中，2022-08-25,\"业务上链用户id\"：1', 1, NULL, '0x9b9d6aee7905cf10463128344dfef249a2db8d73230e6d070fcf1419e821114b', '2022-08-25 17:47:41', '6305bc11235a6231f8953993', '47119a01-80ad-4050-b23b-2fcffe7a9d2a', '食品溯源存证流程', '养殖场', 0, NULL, 3, NULL, NULL, NULL);
INSERT INTO `bc_evidence` VALUES ('A123', '1111', '测试1111,\"业务上链用户id\"：1', 1, NULL, '0x676e1c824e6c734da24ec0f329c75132a5c9c9c3562c4dfb5ad06310b14ad337', '2022-08-25 17:57:01', '6305bc11235a6231f8953993', '3dba7720-9fd8-4f9f-9d36-642f5899e2de', '食品溯源存证流程', 'xx物流运输', 0, NULL, 4, NULL, NULL, NULL);
INSERT INTO `bc_evidence` VALUES ('d_123', '1', '11122,\"业务上链用户id\"：1', 1, NULL, '0xdde66fd225de7ba3f391d946694690dafacc0423f1068034e5ba94e3a65d1a55', '2022-08-25 21:37:02', '63077aa5d00f6c498448c969', '97bde103-2595-4534-ad3b-7ee70e9b4389', '动作流程', '启动', 0, NULL, 5, NULL, NULL, NULL);
INSERT INTO `bc_evidence` VALUES ('NA123456', '牛养殖', '时间：xxxxx\n地点：xxx\n内容说明：xxxxxx,\"业务上链用户id\"：1', 1, NULL, '0xd66af27ead0d48b34317896e09e0c25cd68d333c082fde283c71ab451ed86872', '2022-08-25 22:20:24', '6305bc11235a6231f8953993', '47119a01-80ad-4050-b23b-2fcffe7a9d2a', '食品溯源存证流程', '养殖场', 0, NULL, 6, NULL, NULL, NULL);

-- ----------------------------
-- Table structure for books
-- ----------------------------
DROP TABLE IF EXISTS `books`;
CREATE TABLE `books`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `BookName` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '书名',
  `BookContent` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '内容',
  `Auther` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '作者',
  `PublishDate` datetime(0) NULL DEFAULT NULL COMMENT '出版时间',
  `Price` double NULL DEFAULT NULL COMMENT '价格',
  `CreateDate` datetime(0) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of books
-- ----------------------------
INSERT INTO `books` VALUES (1, '', '111', 'string', '2021-10-31 13:52:41', 10, '2021-10-31 13:52:41');
INSERT INTO `books` VALUES (2, '', '111', 'string', '2021-10-31 13:52:41', 10, '2021-10-31 13:52:41');

-- ----------------------------
-- Table structure for sys_auditlog
-- ----------------------------
DROP TABLE IF EXISTS `sys_auditlog`;
CREATE TABLE `sys_auditlog`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `Key` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '拦截Key',
  `IP` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT 'IP',
  `Browser` varchar(200) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '浏览器',
  `Os` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '操作系统',
  `Device` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '设备',
  `BrowserInfo` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '浏览器信息',
  `ElapsedMilliseconds` bigint(20) NULL DEFAULT NULL COMMENT '耗时（毫秒）',
  `TenantId` int(11) NULL DEFAULT NULL COMMENT '租户Id',
  `UserId` bigint(20) NULL DEFAULT NULL COMMENT '用户id',
  `UserAccount` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '用户账号',
  `ParamsString` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求参数',
  `StartTime` datetime(0) NULL DEFAULT NULL COMMENT '开始执行时间',
  `StopTime` datetime(0) NULL DEFAULT NULL COMMENT '结束执行时间',
  `RequestMethod` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求方式',
  `RequestApi` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '请求Api',
  `CreationTime` datetime(0) NULL DEFAULT NULL COMMENT ' 创建时间',
  `ResponseState` bit(1) NULL DEFAULT NULL,
  `ResponseData` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 27110 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_auditlog
-- ----------------------------
INSERT INTO `sys_auditlog` VALUES (26743, 'b7e8e03d-e78d-49ed-929c-4471036d97c0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 35, 0, 0, NULL, '{}', '2022-01-22 18:05:50', '2022-01-22 18:05:50', 'post', 'api/identity/getguid', '2022-01-22 18:05:50', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26744, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 187, 0, 0, NULL, '{\r\n  \"guidKey\": \"72530d11-182d-4972-8b21-f4c8ef08b250\"\r\n}', '2022-01-22 18:05:50', '2022-01-22 18:05:50', 'get', 'api/identity/getverificationcode', '2022-01-22 18:05:50', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26745, 'e9cdaa33-a685-491e-af68-7e70296d29b9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 95, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"test\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"y37j\",\r\n    \"GuidKey\": \"72530d11-182d-4972-8b21-f4c8ef08b250\"\r\n  }\r\n}', '2022-01-22 18:06:05', '2022-01-22 18:06:05', 'post', 'api/identity/gettokenbylogin', '2022-01-22 18:06:05', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26746, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 33, 0, 0, NULL, '{\r\n  \"guidKey\": \"72530d11-182d-4972-8b21-f4c8ef08b250\"\r\n}', '2022-01-22 18:06:05', '2022-01-22 18:06:05', 'get', 'api/identity/getverificationcode', '2022-01-22 18:06:05', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26747, 'b7e8e03d-e78d-49ed-929c-4471036d97c0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 55, 0, 0, NULL, '{}', '2022-01-22 18:06:05', '2022-01-22 18:06:05', 'post', 'api/identity/getguid', '2022-01-22 18:06:05', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26748, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 42, 0, 0, NULL, '{\r\n  \"guidKey\": \"0d486f47-ad3a-4e52-b5d3-1e46166d2eb1\"\r\n}', '2022-01-22 18:06:05', '2022-01-22 18:06:05', 'get', 'api/identity/getverificationcode', '2022-01-22 18:06:05', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26749, 'e9cdaa33-a685-491e-af68-7e70296d29b9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 52, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"test\",\r\n    \"pwd\": \"123456789\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"w6ui\",\r\n    \"GuidKey\": \"0d486f47-ad3a-4e52-b5d3-1e46166d2eb1\"\r\n  }\r\n}', '2022-01-22 18:06:18', '2022-01-22 18:06:18', 'post', 'api/identity/gettokenbylogin', '2022-01-22 18:06:18', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26750, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 31, 0, 0, NULL, '{\r\n  \"guidKey\": \"0d486f47-ad3a-4e52-b5d3-1e46166d2eb1\"\r\n}', '2022-01-22 18:06:18', '2022-01-22 18:06:18', 'get', 'api/identity/getverificationcode', '2022-01-22 18:06:18', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26751, 'b7e8e03d-e78d-49ed-929c-4471036d97c0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 53, 0, 0, NULL, '{}', '2022-01-22 18:06:18', '2022-01-22 18:06:18', 'post', 'api/identity/getguid', '2022-01-22 18:06:18', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26752, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 37, 0, 0, NULL, '{\r\n  \"guidKey\": \"9f93ae79-187c-41c6-bb4a-b4555ebbd9ca\"\r\n}', '2022-01-22 18:06:18', '2022-01-22 18:06:18', 'get', 'api/identity/getverificationcode', '2022-01-22 18:06:18', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26753, 'e9cdaa33-a685-491e-af68-7e70296d29b9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 224, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"dpxs\",\r\n    \"GuidKey\": \"9f93ae79-187c-41c6-bb4a-b4555ebbd9ca\"\r\n  }\r\n}', '2022-01-22 18:06:30', '2022-01-22 18:06:31', 'post', 'api/identity/gettokenbylogin', '2022-01-22 18:06:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26754, '0ee9d7fa-ede9-4743-ba89-61453bc409a1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 47, 0, 1, 'admin', '{}', '2022-01-22 18:06:32', '2022-01-22 18:06:32', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:06:32', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26755, '0ee9d7fa-ede9-4743-ba89-61453bc409a1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 75, 0, 1, 'admin', '{}', '2022-01-22 18:06:32', '2022-01-22 18:06:32', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:06:32', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26756, '85831d63-2b89-46d5-9eed-6efebd5f9c08', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 77, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-01-22 18:06:33', '2022-01-22 18:06:33', 'post', 'api/sysuser/getpageuserlist', '2022-01-22 18:06:33', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26757, '85831d63-2b89-46d5-9eed-6efebd5f9c08', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 77, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-01-22 18:06:33', '2022-01-22 18:06:33', 'post', 'api/sysuser/getpageuserlist', '2022-01-22 18:06:33', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26758, '85831d63-2b89-46d5-9eed-6efebd5f9c08', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 80, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-01-22 18:06:33', '2022-01-22 18:06:33', 'post', 'api/sysuser/getpageuserlist', '2022-01-22 18:06:33', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26759, '57d89d44-3b52-43b9-bbd7-6066db0913c0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 180, 0, 1, 'admin', '{\r\n  \"id\": 44\r\n}', '2022-01-22 18:06:36', '2022-01-22 18:06:36', 'get', 'api/sysuser/get', '2022-01-22 18:06:36', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26760, '758be1ad-1425-4484-acf7-9ff24c5663db', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 52, 0, 1, 'admin', '{}', '2022-01-22 18:06:36', '2022-01-22 18:06:36', 'get', 'api/sysrole/getsysrolelist', '2022-01-22 18:06:36', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26761, 'b7e8e03d-e78d-49ed-929c-4471036d97c0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 29, 0, 0, NULL, '{}', '2022-01-22 18:07:11', '2022-01-22 18:07:11', 'post', 'api/identity/getguid', '2022-01-22 18:07:11', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26762, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 51, 0, 0, NULL, '{\r\n  \"guidKey\": \"b87b861e-85d5-4ba4-b604-c4a6056ac34e\"\r\n}', '2022-01-22 18:07:11', '2022-01-22 18:07:11', 'get', 'api/identity/getverificationcode', '2022-01-22 18:07:11', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26763, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 41, 0, 0, NULL, '{\r\n  \"guidKey\": \"b87b861e-85d5-4ba4-b604-c4a6056ac34e\"\r\n}', '2022-01-22 18:07:17', '2022-01-22 18:07:17', 'get', 'api/identity/getverificationcode', '2022-01-22 18:07:17', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26764, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 30, 0, 0, NULL, '{\r\n  \"guidKey\": \"b87b861e-85d5-4ba4-b604-c4a6056ac34e\"\r\n}', '2022-01-22 18:07:18', '2022-01-22 18:07:18', 'get', 'api/identity/getverificationcode', '2022-01-22 18:07:18', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26765, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 41, 0, 0, NULL, '{\r\n  \"guidKey\": \"b87b861e-85d5-4ba4-b604-c4a6056ac34e\"\r\n}', '2022-01-22 18:07:20', '2022-01-22 18:07:20', 'get', 'api/identity/getverificationcode', '2022-01-22 18:07:20', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26766, 'e9cdaa33-a685-491e-af68-7e70296d29b9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 81, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"test\",\r\n    \"pwd\": \"123qwe\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"svrm\",\r\n    \"GuidKey\": \"b87b861e-85d5-4ba4-b604-c4a6056ac34e\"\r\n  }\r\n}', '2022-01-22 18:07:24', '2022-01-22 18:07:24', 'post', 'api/identity/gettokenbylogin', '2022-01-22 18:07:24', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26767, '0ee9d7fa-ede9-4743-ba89-61453bc409a1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 94, 0, 44, 'test', '{}', '2022-01-22 18:07:28', '2022-01-22 18:07:28', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:07:28', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26768, '0ee9d7fa-ede9-4743-ba89-61453bc409a1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 111, 0, 44, 'test', '{}', '2022-01-22 18:07:28', '2022-01-22 18:07:28', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:07:28', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26769, 'f86900a9-c55b-4c4a-9949-a2c447ff8978', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 123, 0, 44, 'test', '{\r\n  \"input\": {\r\n    \"Id\": \"44\",\r\n    \"OldPassword\": \"123qwe\",\r\n    \"NewPassword\": \"123456\",\r\n    \"ConfirmPassword\": \"123456\"\r\n  }\r\n}', '2022-01-22 18:07:37', '2022-01-22 18:07:37', 'post', 'api/sysuser/changepassword', '2022-01-22 18:07:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26770, '0ee9d7fa-ede9-4743-ba89-61453bc409a1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 43, 0, 44, 'test', '{}', '2022-01-22 18:07:37', '2022-01-22 18:07:37', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:07:37', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26771, 'b7e8e03d-e78d-49ed-929c-4471036d97c0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 44, 0, 0, NULL, '{}', '2022-01-22 18:07:42', '2022-01-22 18:07:42', 'post', 'api/identity/getguid', '2022-01-22 18:07:42', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26772, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 44, 0, 0, NULL, '{\r\n  \"guidKey\": \"e5d217d2-0ddd-4236-852d-9794c1b3a6af\"\r\n}', '2022-01-22 18:07:42', '2022-01-22 18:07:42', 'get', 'api/identity/getverificationcode', '2022-01-22 18:07:42', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26773, 'e9cdaa33-a685-491e-af68-7e70296d29b9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 34, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"test\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"yh5i\",\r\n    \"GuidKey\": \"e5d217d2-0ddd-4236-852d-9794c1b3a6af\"\r\n  }\r\n}', '2022-01-22 18:07:57', '2022-01-22 18:07:57', 'post', 'api/identity/gettokenbylogin', '2022-01-22 18:07:57', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26774, 'b7e8e03d-e78d-49ed-929c-4471036d97c0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 32, 0, 0, NULL, '{}', '2022-01-22 18:07:57', '2022-01-22 18:07:57', 'post', 'api/identity/getguid', '2022-01-22 18:07:57', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26775, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 55, 0, 0, NULL, '{\r\n  \"guidKey\": \"e5d217d2-0ddd-4236-852d-9794c1b3a6af\"\r\n}', '2022-01-22 18:07:57', '2022-01-22 18:07:57', 'get', 'api/identity/getverificationcode', '2022-01-22 18:07:57', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26776, '4692d0b6-c054-47e5-b998-f6b8dc740286', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 140, 0, 0, NULL, '{\r\n  \"guidKey\": \"29fef19e-bef8-4e1e-ab7b-4f535c1df0de\"\r\n}', '2022-01-22 18:07:57', '2022-01-22 18:07:57', 'get', 'api/identity/getverificationcode', '2022-01-22 18:07:57', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26777, 'e9cdaa33-a685-491e-af68-7e70296d29b9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 51, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"test\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"ps9l\",\r\n    \"GuidKey\": \"29fef19e-bef8-4e1e-ab7b-4f535c1df0de\"\r\n  }\r\n}', '2022-01-22 18:08:06', '2022-01-22 18:08:06', 'post', 'api/identity/gettokenbylogin', '2022-01-22 18:08:06', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26778, '0ee9d7fa-ede9-4743-ba89-61453bc409a1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 94, 0, 44, 'test', '{}', '2022-01-22 18:08:08', '2022-01-22 18:08:08', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:08:08', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26779, '0ee9d7fa-ede9-4743-ba89-61453bc409a1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 174, 0, 44, 'test', '{}', '2022-01-22 18:08:08', '2022-01-22 18:08:08', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:08:08', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26780, 'e4dff45d-7bc7-466b-9dde-bc73a7dc15db', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 219, 0, 44, 'test', '{}', '2022-01-22 18:10:40', '2022-01-22 18:10:41', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:10:41', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26781, 'e4dff45d-7bc7-466b-9dde-bc73a7dc15db', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 219, 0, 44, 'test', '{}', '2022-01-22 18:10:40', '2022-01-22 18:10:41', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:10:41', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26782, '027dbf49-6ea2-4396-820c-bc6d98616952', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 247, 0, 44, 'test', '{}', '2022-01-22 18:12:01', '2022-01-22 18:12:01', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:12:01', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26783, '027dbf49-6ea2-4396-820c-bc6d98616952', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 247, 0, 44, 'test', '{}', '2022-01-22 18:12:01', '2022-01-22 18:12:01', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:12:01', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26784, '6f0fb924-2e59-43cc-9d37-aa6894ab67a5', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 257, 0, 44, 'test', '{}', '2022-01-22 18:13:41', '2022-01-22 18:13:41', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:13:41', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26785, '6f0fb924-2e59-43cc-9d37-aa6894ab67a5', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 257, 0, 44, 'test', '{}', '2022-01-22 18:13:41', '2022-01-22 18:13:41', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:13:41', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26786, '80666a89-64b9-4b79-8f44-ea2f0792b788', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 233, 0, 44, 'test', '{}', '2022-01-22 18:14:21', '2022-01-22 18:14:21', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:14:21', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26787, '80666a89-64b9-4b79-8f44-ea2f0792b788', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 233, 0, 44, 'test', '{}', '2022-01-22 18:14:21', '2022-01-22 18:14:21', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:14:21', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26788, '4f02926f-e08f-4a68-ad23-b62544914094', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 320, 0, 44, 'test', '{}', '2022-01-22 18:16:04', '2022-01-22 18:16:04', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:16:04', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26789, '4f02926f-e08f-4a68-ad23-b62544914094', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 320, 0, 44, 'test', '{}', '2022-01-22 18:16:04', '2022-01-22 18:16:04', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:16:04', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26790, '5e05c284-956d-4c07-a431-1ea980742106', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 254, 0, 44, 'test', '{}', '2022-01-22 18:20:21', '2022-01-22 18:20:22', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:20:22', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26791, '5e05c284-956d-4c07-a431-1ea980742106', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 254, 0, 44, 'test', '{}', '2022-01-22 18:20:21', '2022-01-22 18:20:22', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:20:22', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26792, 'd76acb3a-b6e3-43c6-a072-29851340fb9a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 222, 0, 44, 'test', '{}', '2022-01-22 18:22:39', '2022-01-22 18:22:40', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:22:40', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26793, 'd76acb3a-b6e3-43c6-a072-29851340fb9a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 222, 0, 44, 'test', '{}', '2022-01-22 18:22:39', '2022-01-22 18:22:40', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:22:40', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26794, 'd76acb3a-b6e3-43c6-a072-29851340fb9a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 54, 0, 44, 'test', '{}', '2022-01-22 18:22:54', '2022-01-22 18:22:54', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:22:54', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26795, 'd76acb3a-b6e3-43c6-a072-29851340fb9a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 55, 0, 44, 'test', '{}', '2022-01-22 18:22:54', '2022-01-22 18:22:54', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:22:54', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26796, 'faf83e3c-ef71-4e3f-bf29-c36da1396fb0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 250, 0, 44, 'test', '{}', '2022-01-22 18:25:44', '2022-01-22 18:25:45', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:25:45', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26797, 'faf83e3c-ef71-4e3f-bf29-c36da1396fb0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 250, 0, 44, 'test', '{}', '2022-01-22 18:25:44', '2022-01-22 18:25:45', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:25:45', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26798, 'f40d99a0-b5be-473a-a75a-06c64f391ac0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 6810, 0, 44, 'test', '{}', '2022-01-22 18:27:44', '2022-01-22 18:27:51', 'post', 'api/identity/uploadimage', '2022-01-22 18:27:51', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26799, '1cddc181-2f02-47a6-a642-bfaf8f97a861', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 125, 0, 44, 'test', '{}', '2022-01-22 18:28:08', '2022-01-22 18:28:08', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:28:08', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26800, '1cddc181-2f02-47a6-a642-bfaf8f97a861', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 113, 0, 44, 'test', '{}', '2022-01-22 18:28:08', '2022-01-22 18:28:08', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:28:08', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26801, '1cddc181-2f02-47a6-a642-bfaf8f97a861', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 61, 0, 44, 'test', '{}', '2022-01-22 18:28:13', '2022-01-22 18:28:14', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:28:14', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26802, '1cddc181-2f02-47a6-a642-bfaf8f97a861', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 62, 0, 44, 'test', '{}', '2022-01-22 18:28:13', '2022-01-22 18:28:14', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:28:14', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26803, '19938a70-6d59-42d6-870a-d6424a2a92f7', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 290, 0, 44, 'test', '{}', '2022-01-22 18:30:43', '2022-01-22 18:30:43', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:30:43', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26804, '19938a70-6d59-42d6-870a-d6424a2a92f7', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 290, 0, 44, 'test', '{}', '2022-01-22 18:30:43', '2022-01-22 18:30:43', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:30:43', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26805, '19938a70-6d59-42d6-870a-d6424a2a92f7', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 102, 0, 44, 'test', '{}', '2022-01-22 18:31:09', '2022-01-22 18:31:09', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:31:09', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26806, '19938a70-6d59-42d6-870a-d6424a2a92f7', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 97, 0, 44, 'test', '{}', '2022-01-22 18:31:09', '2022-01-22 18:31:09', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:31:09', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26807, 'aed3d844-964c-4146-a103-c767fc8be9cb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 221, 0, 44, 'test', '{}', '2022-01-22 18:33:39', '2022-01-22 18:33:39', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:33:39', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26808, 'aed3d844-964c-4146-a103-c767fc8be9cb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 221, 0, 44, 'test', '{}', '2022-01-22 18:33:39', '2022-01-22 18:33:39', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:33:39', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26809, 'e34cb3a0-69ab-4469-9080-439b3e225928', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 3379, 0, 44, 'test', '{}', '2022-01-22 18:33:48', '2022-01-22 18:33:51', 'post', 'api/identity/uploadimage', '2022-01-22 18:33:51', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26810, 'aed3d844-964c-4146-a103-c767fc8be9cb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 54, 0, 44, 'test', '{}', '2022-01-22 18:33:59', '2022-01-22 18:33:59', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:33:59', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26811, 'aed3d844-964c-4146-a103-c767fc8be9cb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 54, 0, 44, 'test', '{}', '2022-01-22 18:33:59', '2022-01-22 18:33:59', 'post', 'api/sysuser/getuserinfo', '2022-01-22 18:33:59', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26812, 'e34cb3a0-69ab-4469-9080-439b3e225928', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 1575, 0, 44, 'test', '{}', '2022-01-22 18:34:29', '2022-01-22 18:34:31', 'post', 'api/identity/uploadimage', '2022-01-22 18:34:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26813, 'e34cb3a0-69ab-4469-9080-439b3e225928', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 2112, 0, 44, 'test', '{}', '2022-01-22 18:35:05', '2022-01-22 18:35:07', 'post', 'api/identity/uploadimage', '2022-01-22 18:35:07', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26814, 'e34cb3a0-69ab-4469-9080-439b3e225928', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 1744, 0, 44, 'test', '{}', '2022-01-22 18:35:16', '2022-01-22 18:35:18', 'post', 'api/identity/uploadimage', '2022-01-22 18:35:18', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26815, '8502562d-79e5-4424-9135-d5d82f29ebf5', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 89, 0, 0, NULL, '{}', '2022-01-23 16:00:26', '2022-01-23 16:00:26', 'post', 'api/identity/getguid', '2022-01-23 16:00:26', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26816, '111637b4-e24c-4832-badc-ceb4eae00e14', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 101, 0, 0, NULL, '{\r\n  \"guidKey\": \"67e0cd85-f03a-460c-9862-ab20609dfe41\"\r\n}', '2022-01-23 16:00:26', '2022-01-23 16:00:27', 'get', 'api/identity/getverificationcode', '2022-01-23 16:00:27', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26817, '235c1651-ee8e-437b-b999-f6d681270f1c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 394, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"vqy1\",\r\n    \"GuidKey\": \"67e0cd85-f03a-460c-9862-ab20609dfe41\"\r\n  }\r\n}', '2022-01-23 16:00:34', '2022-01-23 16:00:34', 'post', 'api/identity/gettokenbylogin', '2022-01-23 16:00:34', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26818, 'a80cedc9-ae40-4cb6-8f1a-15b29fa4a5c1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 141, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-01-23 16:00:36', '2022-01-23 16:00:36', 'post', 'api/sysuser/getpageuserlist', '2022-01-23 16:00:36', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26819, 'a80cedc9-ae40-4cb6-8f1a-15b29fa4a5c1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 140, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-01-23 16:00:36', '2022-01-23 16:00:36', 'post', 'api/sysuser/getpageuserlist', '2022-01-23 16:00:36', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26820, '62c1c5b0-f875-4a0f-93de-7726138ca74b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 544, 0, 1, 'admin', '{}', '2022-01-23 16:00:38', '2022-01-23 16:00:38', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:00:38', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26821, '62c1c5b0-f875-4a0f-93de-7726138ca74b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 584, 0, 1, 'admin', '{}', '2022-01-23 16:00:38', '2022-01-23 16:00:38', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:00:38', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26822, '62c1c5b0-f875-4a0f-93de-7726138ca74b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 595, 0, 1, 'admin', '{}', '2022-01-23 16:00:38', '2022-01-23 16:00:38', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:00:38', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26823, '13452878-5756-4773-b207-3ef848383ff4', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 3744, 0, 1, 'admin', '{}', '2022-01-23 16:03:53', '2022-01-23 16:03:56', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:03:56', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26824, '13452878-5756-4773-b207-3ef848383ff4', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 3744, 0, 1, 'admin', '{}', '2022-01-23 16:03:53', '2022-01-23 16:03:56', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:03:56', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26825, '9c1d23c9-c8c2-476c-83dc-1bf37043990e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 220, 0, 1, 'admin', '{}', '2022-01-23 16:23:31', '2022-01-23 16:23:31', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:23:31', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26826, '9c1d23c9-c8c2-476c-83dc-1bf37043990e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 220, 0, 1, 'admin', '{}', '2022-01-23 16:23:31', '2022-01-23 16:23:31', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:23:31', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26827, '3b7c9845-c45c-4bb8-8d3a-333ffec7f040', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 232, 0, 1, 'admin', '{}', '2022-01-23 16:32:33', '2022-01-23 16:32:34', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:32:34', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26828, '3b7c9845-c45c-4bb8-8d3a-333ffec7f040', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 232, 0, 1, 'admin', '{}', '2022-01-23 16:32:33', '2022-01-23 16:32:34', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:32:34', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26829, 'e5f7f52f-4eee-42ed-83d6-8195ab25a4da', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 219, 0, 0, NULL, '{\r\n  \"guidKey\": null\r\n}', '2022-01-23 16:52:46', '2022-01-23 16:52:46', 'get', 'api/identity/getverificationcode', '2022-01-23 16:52:46', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26830, '22ccdf4b-7145-469f-9029-57a0beb63ced', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 233, 0, 0, NULL, '{}', '2022-01-23 16:52:46', '2022-01-23 16:52:46', 'post', 'api/identity/getguid', '2022-01-23 16:52:46', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26831, '22ccdf4b-7145-469f-9029-57a0beb63ced', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 233, 0, 0, NULL, '{}', '2022-01-23 16:52:46', '2022-01-23 16:52:46', 'post', 'api/identity/getguid', '2022-01-23 16:52:46', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26832, '22ccdf4b-7145-469f-9029-57a0beb63ced', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 233, 0, 0, NULL, '{}', '2022-01-23 16:52:46', '2022-01-23 16:52:46', 'post', 'api/identity/getguid', '2022-01-23 16:52:46', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26833, 'e5f7f52f-4eee-42ed-83d6-8195ab25a4da', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 993, 0, 0, NULL, '{\r\n  \"guidKey\": \"fd86912b-13a4-468a-8d7f-232e32704f53\"\r\n}', '2022-01-23 16:52:54', '2022-01-23 16:52:55', 'get', 'api/identity/getverificationcode', '2022-01-23 16:52:55', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26834, 'e5f7f52f-4eee-42ed-83d6-8195ab25a4da', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 962, 0, 0, NULL, '{\r\n  \"guidKey\": \"00e45a45-2348-4fef-a603-eab04d7f414f\"\r\n}', '2022-01-23 16:52:54', '2022-01-23 16:52:55', 'get', 'api/identity/getverificationcode', '2022-01-23 16:52:55', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26835, 'e5f7f52f-4eee-42ed-83d6-8195ab25a4da', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 962, 0, 0, NULL, '{\r\n  \"guidKey\": \"e7d0d59e-9ab8-477d-98df-eed2dcf85bb3\"\r\n}', '2022-01-23 16:52:54', '2022-01-23 16:52:55', 'get', 'api/identity/getverificationcode', '2022-01-23 16:52:55', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26836, 'db23fbb1-f5d6-4c13-bab3-b93fe9ace8e2', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 539, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"l17k\",\r\n    \"GuidKey\": \"fd86912b-13a4-468a-8d7f-232e32704f53\"\r\n  }\r\n}', '2022-01-23 16:53:06', '2022-01-23 16:53:07', 'post', 'api/identity/gettokenbylogin', '2022-01-23 16:53:07', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26837, '8e32cfd6-c0de-41b8-bee6-1fa0a50156d4', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 56, 0, 1, 'admin', '{}', '2022-01-23 16:53:08', '2022-01-23 16:53:08', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:53:08', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26838, '8e32cfd6-c0de-41b8-bee6-1fa0a50156d4', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 56, 0, 1, 'admin', '{}', '2022-01-23 16:53:08', '2022-01-23 16:53:08', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:53:08', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26839, 'cdd2948f-d9c9-4ecb-bf7a-e5804b34270c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 197, 0, 0, NULL, '{}', '2022-01-23 16:54:48', '2022-01-23 16:54:48', 'post', 'api/identity/getguid', '2022-01-23 16:54:48', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26840, 'cdd2948f-d9c9-4ecb-bf7a-e5804b34270c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 197, 0, 0, NULL, '{}', '2022-01-23 16:54:48', '2022-01-23 16:54:48', 'post', 'api/identity/getguid', '2022-01-23 16:54:48', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26841, 'cdd2948f-d9c9-4ecb-bf7a-e5804b34270c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 197, 0, 0, NULL, '{}', '2022-01-23 16:54:48', '2022-01-23 16:54:48', 'post', 'api/identity/getguid', '2022-01-23 16:54:48', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26842, 'a8d3eb05-c5f5-4793-9111-ab78732456ad', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 164, 0, 0, NULL, '{\r\n  \"guidKey\": \"99716a53-a183-43b2-9e40-f1a36aa1ccda\"\r\n}', '2022-01-23 16:54:49', '2022-01-23 16:54:49', 'get', 'api/identity/getverificationcode', '2022-01-23 16:54:49', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26843, 'a8d3eb05-c5f5-4793-9111-ab78732456ad', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 164, 0, 0, NULL, '{\r\n  \"guidKey\": \"94e5de03-796d-4242-af12-add94982c13e\"\r\n}', '2022-01-23 16:54:49', '2022-01-23 16:54:49', 'get', 'api/identity/getverificationcode', '2022-01-23 16:54:49', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26844, 'a8d3eb05-c5f5-4793-9111-ab78732456ad', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 164, 0, 0, NULL, '{\r\n  \"guidKey\": \"86418e33-92e1-4bf2-81d1-e959a4fb58d7\"\r\n}', '2022-01-23 16:54:49', '2022-01-23 16:54:49', 'get', 'api/identity/getverificationcode', '2022-01-23 16:54:49', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26845, 'eb429eea-c81f-434d-a1e7-dddceb7a8ab4', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 444, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"auil\",\r\n    \"GuidKey\": \"86418e33-92e1-4bf2-81d1-e959a4fb58d7\"\r\n  }\r\n}', '2022-01-23 16:54:55', '2022-01-23 16:54:55', 'post', 'api/identity/gettokenbylogin', '2022-01-23 16:54:55', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26846, 'fdc26283-928b-4b7c-a390-8f8cacc6d91e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 73, 0, 1, 'admin', '{}', '2022-01-23 16:54:57', '2022-01-23 16:54:57', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:54:57', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26847, 'fdc26283-928b-4b7c-a390-8f8cacc6d91e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 73, 0, 1, 'admin', '{}', '2022-01-23 16:54:57', '2022-01-23 16:54:57', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:54:57', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26848, '3d2aefad-7bf8-4ba7-a55e-c41a75c424df', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 132, 0, 0, NULL, '{}', '2022-01-23 16:56:30', '2022-01-23 16:56:30', 'post', 'api/identity/getguid', '2022-01-23 16:56:30', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26849, '3d2aefad-7bf8-4ba7-a55e-c41a75c424df', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 132, 0, 0, NULL, '{}', '2022-01-23 16:56:30', '2022-01-23 16:56:30', 'post', 'api/identity/getguid', '2022-01-23 16:56:30', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26850, '182fcb4c-f4c2-43a8-9fd6-49d7ee0ede74', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 294, 0, 1, 'admin', '{}', '2022-01-23 16:56:30', '2022-01-23 16:56:30', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:56:30', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26851, '182fcb4c-f4c2-43a8-9fd6-49d7ee0ede74', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 294, 0, 1, 'admin', '{}', '2022-01-23 16:56:30', '2022-01-23 16:56:30', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:56:30', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26852, '182fcb4c-f4c2-43a8-9fd6-49d7ee0ede74', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 294, 0, 1, 'admin', '{}', '2022-01-23 16:56:30', '2022-01-23 16:56:30', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:56:30', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26853, '182fcb4c-f4c2-43a8-9fd6-49d7ee0ede74', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 294, 0, 1, 'admin', '{}', '2022-01-23 16:56:30', '2022-01-23 16:56:30', 'post', 'api/sysuser/getuserinfo', '2022-01-23 16:56:30', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26854, 'd3de17fe-dfc2-4877-baf2-1494e6edbc1d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 139, 0, 0, NULL, '{\r\n  \"guidKey\": \"642836d8-a881-4107-9bf9-ab4b1c546cf8\"\r\n}', '2022-01-23 16:56:30', '2022-01-23 16:56:31', 'get', 'api/identity/getverificationcode', '2022-01-23 16:56:31', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26855, 'd3de17fe-dfc2-4877-baf2-1494e6edbc1d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 139, 0, 0, NULL, '{\r\n  \"guidKey\": \"d9725e4a-01df-48e3-bdca-6adafa9422ee\"\r\n}', '2022-01-23 16:56:30', '2022-01-23 16:56:31', 'get', 'api/identity/getverificationcode', '2022-01-23 16:56:31', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26856, '619231c4-2c57-424d-9336-a6661d02225d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 626, 0, 0, NULL, '{}', '2022-01-23 17:03:25', '2022-01-23 17:03:25', 'post', 'api/identity/getguid', '2022-01-23 17:03:25', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26857, '619231c4-2c57-424d-9336-a6661d02225d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 9783, 0, 0, NULL, '{}', '2022-01-23 17:03:15', '2022-01-23 17:03:25', 'post', 'api/identity/getguid', '2022-01-23 17:03:25', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26858, '619231c4-2c57-424d-9336-a6661d02225d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 9783, 0, 0, NULL, '{}', '2022-01-23 17:03:15', '2022-01-23 17:03:25', 'post', 'api/identity/getguid', '2022-01-23 17:03:25', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26859, '08044080-2dd0-4c53-90a7-eccc6be7de58', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 3218, 0, 0, NULL, '{\r\n  \"guidKey\": \"4ea88ff6-8fc3-43e7-a06e-eb9779a8e751\"\r\n}', '2022-01-23 17:03:25', '2022-01-23 17:03:29', 'get', 'api/identity/getverificationcode', '2022-01-23 17:03:29', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26860, '08044080-2dd0-4c53-90a7-eccc6be7de58', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 3218, 0, 0, NULL, '{\r\n  \"guidKey\": \"443c759b-e5a9-4e94-b1b2-226d9e0ecf80\"\r\n}', '2022-01-23 17:03:25', '2022-01-23 17:03:29', 'get', 'api/identity/getverificationcode', '2022-01-23 17:03:29', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26861, '08044080-2dd0-4c53-90a7-eccc6be7de58', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 3218, 0, 0, NULL, '{\r\n  \"guidKey\": \"809aaefd-06a3-40d1-8227-44081913357b\"\r\n}', '2022-01-23 17:03:25', '2022-01-23 17:03:29', 'get', 'api/identity/getverificationcode', '2022-01-23 17:03:29', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26862, 'a19fac8d-b6e9-4dbc-a5c4-2544ce88d1cb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 4561, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"fzaq\",\r\n    \"GuidKey\": \"443c759b-e5a9-4e94-b1b2-226d9e0ecf80\"\r\n  }\r\n}', '2022-01-23 17:03:36', '2022-01-23 17:03:41', 'post', 'api/identity/gettokenbylogin', '2022-01-23 17:03:41', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26863, '04c65c48-d2e7-49ac-a77d-3340eed16e2f', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 16120, 0, 1, 'admin', '{}', '2022-01-23 17:03:43', '2022-01-23 17:03:59', 'post', 'api/sysuser/getuserinfo', '2022-01-23 17:03:59', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26864, '04c65c48-d2e7-49ac-a77d-3340eed16e2f', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 16125, 0, 1, 'admin', '{}', '2022-01-23 17:03:43', '2022-01-23 17:03:59', 'post', 'api/sysuser/getuserinfo', '2022-01-23 17:03:59', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26865, '61f8d163-0b2e-4e7b-aa33-cbe89c53d9eb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 6434, 0, 0, NULL, '{}', '2022-01-23 19:31:51', '2022-01-23 19:31:57', 'post', 'api/identity/getguid', '2022-01-23 19:31:57', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26866, 'a9d15ca5-cb59-4c63-811f-acb5d2cdd839', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 9475, 0, 0, NULL, '{\r\n  \"guidKey\": \"5f69baab-0150-4cf7-bc85-bdf5a85204da\"\r\n}', '2022-01-23 19:31:58', '2022-01-23 19:32:07', 'get', 'api/identity/getverificationcode', '2022-01-23 19:32:07', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26867, '61f8d163-0b2e-4e7b-aa33-cbe89c53d9eb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 37, 0, 0, NULL, '{}', '2022-01-23 19:32:11', '2022-01-23 19:32:11', 'post', 'api/identity/getguid', '2022-01-23 19:32:11', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26868, 'a9d15ca5-cb59-4c63-811f-acb5d2cdd839', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 4189, 0, 0, NULL, '{\r\n  \"guidKey\": \"9e9d61cc-15b5-4321-959f-bbf5586e2372\"\r\n}', '2022-01-23 19:32:11', '2022-01-23 19:32:15', 'get', 'api/identity/getverificationcode', '2022-01-23 19:32:15', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26869, '61f8d163-0b2e-4e7b-aa33-cbe89c53d9eb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 41, 0, 0, NULL, '{}', '2022-01-23 19:32:25', '2022-01-23 19:32:25', 'post', 'api/identity/getguid', '2022-01-23 19:32:25', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26870, 'a9d15ca5-cb59-4c63-811f-acb5d2cdd839', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 46, 0, 0, NULL, '{\r\n  \"guidKey\": \"8fda6f97-9bb2-45f0-b679-d9ff30ea58da\"\r\n}', '2022-01-23 19:32:25', '2022-01-23 19:32:25', 'get', 'api/identity/getverificationcode', '2022-01-23 19:32:25', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26871, '61f8d163-0b2e-4e7b-aa33-cbe89c53d9eb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 37, 0, 0, NULL, '{}', '2022-01-23 19:32:27', '2022-01-23 19:32:27', 'post', 'api/identity/getguid', '2022-01-23 19:32:27', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26872, 'a9d15ca5-cb59-4c63-811f-acb5d2cdd839', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 17, 0, 0, NULL, '{\r\n  \"guidKey\": \"6840d168-9eb7-4c36-aa21-01eaf422d16a\"\r\n}', '2022-01-23 19:32:27', '2022-01-23 19:32:27', 'get', 'api/identity/getverificationcode', '2022-01-23 19:32:27', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26873, '61f8d163-0b2e-4e7b-aa33-cbe89c53d9eb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 36, 0, 0, NULL, '{}', '2022-01-23 19:32:29', '2022-01-23 19:32:29', 'post', 'api/identity/getguid', '2022-01-23 19:32:29', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26874, 'a9d15ca5-cb59-4c63-811f-acb5d2cdd839', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 19, 0, 0, NULL, '{\r\n  \"guidKey\": \"ec9d17b4-705e-4d92-8ee4-ed1ce76ad229\"\r\n}', '2022-01-23 19:32:29', '2022-01-23 19:32:29', 'get', 'api/identity/getverificationcode', '2022-01-23 19:32:29', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26875, '64cd7df7-27c8-4223-88b3-4bd2981c4d8a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 126, 0, 0, NULL, '{}', '2022-05-28 10:50:00', '2022-05-28 10:50:00', 'post', 'api/identity/getguid', '2022-05-28 10:50:00', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26876, 'bed67da9-747a-453b-ace5-b675a01090fc', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 117, 0, 0, NULL, '{\r\n  \"guidKey\": \"0e22a482-6ae1-4980-a5a2-bbaa9c601dff\"\r\n}', '2022-05-28 10:50:00', '2022-05-28 10:50:01', 'get', 'api/identity/getverificationcode', '2022-05-28 10:50:01', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26877, '59de51fe-9406-4791-a618-d3519710b1a3', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 501, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"wuw5\",\r\n    \"GuidKey\": \"0e22a482-6ae1-4980-a5a2-bbaa9c601dff\"\r\n  }\r\n}', '2022-05-28 10:50:06', '2022-05-28 10:50:07', 'post', 'api/identity/gettokenbylogin', '2022-05-28 10:50:07', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26878, 'fe4ddd9a-8770-4b73-9f27-7986ea1bdc47', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 103, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:14', '2022-05-28 10:50:14', 'post', 'api/sysdatadictionary/getsysdatadictionarylist', '2022-05-28 10:50:14', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26879, 'fe4ddd9a-8770-4b73-9f27-7986ea1bdc47', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 104, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:14', '2022-05-28 10:50:14', 'post', 'api/sysdatadictionary/getsysdatadictionarylist', '2022-05-28 10:50:14', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26880, 'c5c19046-5c7d-4924-9e34-1849d3d42b2d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 167, 0, 1, 'admin', '{}', '2022-05-28 10:50:17', '2022-05-28 10:50:17', 'post', 'api/sysuser/getuserinfo', '2022-05-28 10:50:17', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26881, 'c5c19046-5c7d-4924-9e34-1849d3d42b2d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 159, 0, 1, 'admin', '{}', '2022-05-28 10:50:17', '2022-05-28 10:50:17', 'post', 'api/sysuser/getuserinfo', '2022-05-28 10:50:17', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26882, 'c5c19046-5c7d-4924-9e34-1849d3d42b2d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 168, 0, 1, 'admin', '{}', '2022-05-28 10:50:17', '2022-05-28 10:50:17', 'post', 'api/sysuser/getuserinfo', '2022-05-28 10:50:17', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26883, '88f385cb-4cf5-4eef-b862-b013ba924f3f', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 100, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:19', '2022-05-28 10:50:19', 'post', 'api/sysuser/getpageuserlist', '2022-05-28 10:50:19', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26884, '88f385cb-4cf5-4eef-b862-b013ba924f3f', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 100, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:19', '2022-05-28 10:50:19', 'post', 'api/sysuser/getpageuserlist', '2022-05-28 10:50:19', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26885, '88f385cb-4cf5-4eef-b862-b013ba924f3f', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 101, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:19', '2022-05-28 10:50:19', 'post', 'api/sysuser/getpageuserlist', '2022-05-28 10:50:19', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26886, '88f385cb-4cf5-4eef-b862-b013ba924f3f', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 107, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:19', '2022-05-28 10:50:19', 'post', 'api/sysuser/getpageuserlist', '2022-05-28 10:50:19', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26887, 'e2644e19-ac50-40af-8711-669467d83799', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 190, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:21', '2022-05-28 10:50:21', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 10:50:21', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26888, 'e2644e19-ac50-40af-8711-669467d83799', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 203, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:21', '2022-05-28 10:50:21', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 10:50:21', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26889, 'e2644e19-ac50-40af-8711-669467d83799', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 222, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:21', '2022-05-28 10:50:21', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 10:50:21', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26890, 'e2644e19-ac50-40af-8711-669467d83799', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 222, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:21', '2022-05-28 10:50:21', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 10:50:21', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26891, 'e2644e19-ac50-40af-8711-669467d83799', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 275, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:21', '2022-05-28 10:50:21', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 10:50:21', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26892, '353bb8cc-4b5a-46bf-8bc1-dacd099339f1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 142, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:31', '2022-05-28 10:50:31', 'post', 'api/sysauditlog/getpagesysauditloglist', '2022-05-28 10:50:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26893, '353bb8cc-4b5a-46bf-8bc1-dacd099339f1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 135, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:31', '2022-05-28 10:50:31', 'post', 'api/sysauditlog/getpagesysauditloglist', '2022-05-28 10:50:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26894, '353bb8cc-4b5a-46bf-8bc1-dacd099339f1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 140, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:31', '2022-05-28 10:50:31', 'post', 'api/sysauditlog/getpagesysauditloglist', '2022-05-28 10:50:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26895, '353bb8cc-4b5a-46bf-8bc1-dacd099339f1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 173, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:31', '2022-05-28 10:50:31', 'post', 'api/sysauditlog/getpagesysauditloglist', '2022-05-28 10:50:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26896, '353bb8cc-4b5a-46bf-8bc1-dacd099339f1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 221, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:31', '2022-05-28 10:50:31', 'post', 'api/sysauditlog/getpagesysauditloglist', '2022-05-28 10:50:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26897, '353bb8cc-4b5a-46bf-8bc1-dacd099339f1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 263, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:50:31', '2022-05-28 10:50:31', 'post', 'api/sysauditlog/getpagesysauditloglist', '2022-05-28 10:50:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26898, '821a5d07-12ca-4584-a14a-8688603844ae', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 181, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:36', '2022-05-28 10:50:37', 'post', 'api/sysorganization/getsysorganizationlist', '2022-05-28 10:50:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26899, '821a5d07-12ca-4584-a14a-8688603844ae', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 181, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:36', '2022-05-28 10:50:37', 'post', 'api/sysorganization/getsysorganizationlist', '2022-05-28 10:50:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26900, '821a5d07-12ca-4584-a14a-8688603844ae', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 181, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:36', '2022-05-28 10:50:37', 'post', 'api/sysorganization/getsysorganizationlist', '2022-05-28 10:50:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26901, '821a5d07-12ca-4584-a14a-8688603844ae', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 181, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:36', '2022-05-28 10:50:37', 'post', 'api/sysorganization/getsysorganizationlist', '2022-05-28 10:50:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26902, '821a5d07-12ca-4584-a14a-8688603844ae', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 183, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:36', '2022-05-28 10:50:37', 'post', 'api/sysorganization/getsysorganizationlist', '2022-05-28 10:50:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26903, '821a5d07-12ca-4584-a14a-8688603844ae', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 181, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:36', '2022-05-28 10:50:37', 'post', 'api/sysorganization/getsysorganizationlist', '2022-05-28 10:50:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26904, '821a5d07-12ca-4584-a14a-8688603844ae', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 181, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:50:36', '2022-05-28 10:50:37', 'post', 'api/sysorganization/getsysorganizationlist', '2022-05-28 10:50:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26905, '8fdb23d2-cea1-407d-b09f-655437115c35', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 112, 0, 0, NULL, '{}', '2022-05-28 10:56:44', '2022-05-28 10:56:45', 'post', 'api/identity/getguid', '2022-05-28 10:56:45', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26906, '490fd45e-a41b-4d7d-8f25-485f5a372410', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 92, 0, 0, NULL, '{\r\n  \"guidKey\": \"9e9462b9-e5ca-4456-9225-d03971a84b7d\"\r\n}', '2022-05-28 10:56:45', '2022-05-28 10:56:45', 'get', 'api/identity/getverificationcode', '2022-05-28 10:56:45', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26907, '31ed0b51-8b6c-489e-ba4f-9e39f7d11902', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 310, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"1vyv\",\r\n    \"GuidKey\": \"9e9462b9-e5ca-4456-9225-d03971a84b7d\"\r\n  }\r\n}', '2022-05-28 10:56:49', '2022-05-28 10:56:50', 'post', 'api/identity/gettokenbylogin', '2022-05-28 10:56:50', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26908, 'c7daf80d-c8be-423e-b7d9-3ac7323fd912', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 63, 0, 1, 'admin', '{}', '2022-05-28 10:56:53', '2022-05-28 10:56:53', 'post', 'api/sysuser/getuserinfo', '2022-05-28 10:56:53', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26909, 'a2fa5a81-4b02-4bdf-9ddc-f33387ee44b5', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 53, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 10:56:55', '2022-05-28 10:56:55', 'post', 'api/sysuser/getpageuserlist', '2022-05-28 10:56:55', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26910, '409af32b-c57b-4679-849a-0f8afe376bba', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 73, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 10:56:56', '2022-05-28 10:56:56', 'post', 'api/sysdatadictionary/getsysdatadictionarylist', '2022-05-28 10:56:56', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26911, '699b6b55-e193-467a-acf7-972444a4be00', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 144, 0, 0, NULL, '{}', '2022-05-28 12:01:05', '2022-05-28 12:01:05', 'post', 'api/identity/getguid', '2022-05-28 12:01:05', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26912, '4cb5947b-8dc7-4aa2-8b0e-df34aa5d1ed6', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 110, 0, 0, NULL, '{\r\n  \"guidKey\": \"d417e158-ed7b-479b-8703-59f5d0e83d16\"\r\n}', '2022-05-28 12:01:05', '2022-05-28 12:01:05', 'get', 'api/identity/getverificationcode', '2022-05-28 12:01:05', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26913, '4cb5947b-8dc7-4aa2-8b0e-df34aa5d1ed6', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 46, 0, 0, NULL, '{\r\n  \"guidKey\": \"d417e158-ed7b-479b-8703-59f5d0e83d16\"\r\n}', '2022-05-28 12:01:30', '2022-05-28 12:01:30', 'get', 'api/identity/getverificationcode', '2022-05-28 12:01:30', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26914, '4cb5947b-8dc7-4aa2-8b0e-df34aa5d1ed6', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 34, 0, 0, NULL, '{\r\n  \"guidKey\": \"d417e158-ed7b-479b-8703-59f5d0e83d16\"\r\n}', '2022-05-28 12:01:32', '2022-05-28 12:01:32', 'get', 'api/identity/getverificationcode', '2022-05-28 12:01:32', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26915, '4cb5947b-8dc7-4aa2-8b0e-df34aa5d1ed6', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 43, 0, 0, NULL, '{\r\n  \"guidKey\": \"d417e158-ed7b-479b-8703-59f5d0e83d16\"\r\n}', '2022-05-28 12:01:34', '2022-05-28 12:01:34', 'get', 'api/identity/getverificationcode', '2022-05-28 12:01:34', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26916, '4cb5947b-8dc7-4aa2-8b0e-df34aa5d1ed6', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 122, 0, 0, NULL, '{\r\n  \"guidKey\": \"d417e158-ed7b-479b-8703-59f5d0e83d16\"\r\n}', '2022-05-28 12:01:35', '2022-05-28 12:01:35', 'get', 'api/identity/getverificationcode', '2022-05-28 12:01:35', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26917, '74df1e0c-62f3-4f18-b2f0-7ba5d03dbbd1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 353, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"fctp\",\r\n    \"GuidKey\": \"d417e158-ed7b-479b-8703-59f5d0e83d16\"\r\n  }\r\n}', '2022-05-28 12:01:41', '2022-05-28 12:01:41', 'post', 'api/identity/gettokenbylogin', '2022-05-28 12:01:41', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26918, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 78, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:01:45', '2022-05-28 12:01:45', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:01:45', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26919, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 49, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:01:47', '2022-05-28 12:01:47', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:01:47', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26920, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 76, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:02:15', '2022-05-28 12:02:15', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:02:15', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26921, 'c15ef2e3-fda9-4a88-81bc-1dfa6723136a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 60, 0, 1, 'admin', '{\r\n  \"id\": 111\r\n}', '2022-05-28 12:02:19', '2022-05-28 12:02:19', 'get', 'api/syspermission/get', '2022-05-28 12:02:19', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26922, '4dd118ec-1124-4878-9fa6-118c37dc2f6a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 50, 0, 1, 'admin', '{\r\n  \"pid\": 111\r\n}', '2022-05-28 12:02:19', '2022-05-28 12:02:20', 'post', 'api/syspermission/getsyspermissionfilterbypid', '2022-05-28 12:02:20', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26923, 'd66124b0-9246-4956-948c-bcecd66206d0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 130, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ParentId\": \"0\",\r\n    \"Label\": \"区块链管理\",\r\n    \"Code\": \"blockChainManager\",\r\n    \"Type\": 1,\r\n    \"View\": \"\",\r\n    \"Api\": \"\",\r\n    \"Path\": \"\",\r\n    \"Icon\": \"fa fa-gg\",\r\n    \"Hidden\": false,\r\n    \"Closable\": true,\r\n    \"Opened\": true,\r\n    \"NewWindow\": true,\r\n    \"External\": true,\r\n    \"Sort\": 0,\r\n    \"Description\": \"\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 12:04:16', '2022-05-28 12:04:16', 'post', 'api/syspermission/createsyspermission', '2022-05-28 12:04:16', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26924, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 39, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:04:16', '2022-05-28 12:04:16', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:04:16', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26925, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 50, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:04:18', '2022-05-28 12:04:18', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:04:18', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26926, 'c15ef2e3-fda9-4a88-81bc-1dfa6723136a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 117, 0, 1, 'admin', '{\r\n  \"id\": 113\r\n}', '2022-05-28 12:04:29', '2022-05-28 12:04:29', 'get', 'api/syspermission/get', '2022-05-28 12:04:29', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26927, '4dd118ec-1124-4878-9fa6-118c37dc2f6a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 43, 0, 1, 'admin', '{\r\n  \"pid\": 113\r\n}', '2022-05-28 12:04:29', '2022-05-28 12:04:29', 'post', 'api/syspermission/getsyspermissionfilterbypid', '2022-05-28 12:04:29', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26928, 'd66124b0-9246-4956-948c-bcecd66206d0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 84, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ParentId\": \"200\",\r\n    \"Label\": \"区块链存证\",\r\n    \"Code\": \"blockChain.EvidenceManager\",\r\n    \"Type\": 2,\r\n    \"View\": \"bCEvidences\",\r\n    \"Api\": \"\",\r\n    \"Path\": \"/bCEvidences\",\r\n    \"Icon\": \"fa fa-wpforms\",\r\n    \"Hidden\": false,\r\n    \"Closable\": true,\r\n    \"Opened\": true,\r\n    \"NewWindow\": true,\r\n    \"External\": true,\r\n    \"Sort\": 9,\r\n    \"Description\": \"\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 12:06:33', '2022-05-28 12:06:33', 'post', 'api/syspermission/createsyspermission', '2022-05-28 12:06:33', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26929, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 35, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:06:33', '2022-05-28 12:06:33', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:06:33', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26930, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 50, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:06:35', '2022-05-28 12:06:35', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:06:35', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26931, 'c15ef2e3-fda9-4a88-81bc-1dfa6723136a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 38, 0, 1, 'admin', '{\r\n  \"id\": 126\r\n}', '2022-05-28 12:06:41', '2022-05-28 12:06:41', 'get', 'api/syspermission/get', '2022-05-28 12:06:41', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26932, '4dd118ec-1124-4878-9fa6-118c37dc2f6a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 49, 0, 1, 'admin', '{\r\n  \"pid\": 126\r\n}', '2022-05-28 12:06:41', '2022-05-28 12:06:41', 'post', 'api/syspermission/getsyspermissionfilterbypid', '2022-05-28 12:06:41', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26933, 'd66124b0-9246-4956-948c-bcecd66206d0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 86, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ParentId\": \"201\",\r\n    \"Label\": \"查看区块链存证列表\",\r\n    \"Code\": \"bCEvidenceManager.viewBCEvidence\",\r\n    \"Type\": 3,\r\n    \"View\": \"\",\r\n    \"Api\": \"BCEvidence/GetPageBCEvidenceList,BCEvidence/Get\",\r\n    \"Path\": \"\",\r\n    \"Icon\": \"\",\r\n    \"Hidden\": false,\r\n    \"Closable\": true,\r\n    \"Opened\": true,\r\n    \"NewWindow\": true,\r\n    \"External\": true,\r\n    \"Sort\": 0,\r\n    \"Description\": \"\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 12:07:39', '2022-05-28 12:07:39', 'post', 'api/syspermission/createsyspermission', '2022-05-28 12:07:39', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26934, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 58, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:07:39', '2022-05-28 12:07:39', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:07:39', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26935, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 33, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:07:41', '2022-05-28 12:07:41', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:07:41', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26936, 'd66124b0-9246-4956-948c-bcecd66206d0', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 86, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ParentId\": \"201\",\r\n    \"Label\": \"新增区块链存证\",\r\n    \"Code\": \"bCEvidenceManager.createBCEvidence\",\r\n    \"Type\": 3,\r\n    \"View\": \"\",\r\n    \"Api\": \"\",\r\n    \"Path\": \"\",\r\n    \"Icon\": \"\",\r\n    \"Hidden\": false,\r\n    \"Closable\": true,\r\n    \"Opened\": true,\r\n    \"NewWindow\": true,\r\n    \"External\": true,\r\n    \"Sort\": 0,\r\n    \"Description\": \"BCEvidence/CreateBCEvidence\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 12:08:09', '2022-05-28 12:08:10', 'post', 'api/syspermission/createsyspermission', '2022-05-28 12:08:10', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26937, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 37, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:08:10', '2022-05-28 12:08:10', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:08:10', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26938, '9f440ed8-b6f1-45a9-b725-d6bad4ef8341', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 74, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:08:21', '2022-05-28 12:08:21', 'post', 'api/sysrole/getpagesysrolelist', '2022-05-28 12:08:21', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26939, 'e30b4015-b6b3-4239-b840-e1c0d05d7b2f', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 62, 0, 1, 'admin', '{\r\n  \"id\": 1\r\n}', '2022-05-28 12:08:25', '2022-05-28 12:08:25', 'get', 'api/sysrole/get', '2022-05-28 12:08:25', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26940, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 38, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:08:28', '2022-05-28 12:08:28', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:08:28', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26941, '7addcc96-e4e6-4c19-874f-b26f5dcdd731', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 65, 0, 1, 'admin', '{}', '2022-05-28 12:08:28', '2022-05-28 12:08:28', 'get', 'api/sysrole/getsysrolelist', '2022-05-28 12:08:28', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26942, '7addcc96-e4e6-4c19-874f-b26f5dcdd731', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 58, 0, 1, 'admin', '{}', '2022-05-28 12:08:32', '2022-05-28 12:08:32', 'get', 'api/sysrole/getsysrolelist', '2022-05-28 12:08:32', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26943, 'f203751f-a442-4a5d-b928-fee98deead05', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 262, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"Id\": \"1\",\r\n    \"PermissionIds\": [\r\n      \"111\",\r\n      \"113\",\r\n      \"126\",\r\n      \"127\",\r\n      \"128\",\r\n      \"129\",\r\n      \"114\",\r\n      \"122\",\r\n      \"123\",\r\n      \"124\",\r\n      \"125\",\r\n      \"130\",\r\n      \"131\",\r\n      \"137\",\r\n      \"116\",\r\n      \"117\",\r\n      \"138\",\r\n      \"200\",\r\n      \"201\",\r\n      \"202\",\r\n      \"203\",\r\n      \"112\",\r\n      \"118\",\r\n      \"119\",\r\n      \"120\",\r\n      \"121\",\r\n      \"115\",\r\n      \"132\",\r\n      \"133\",\r\n      \"134\",\r\n      \"135\",\r\n      \"136\",\r\n      \"139\",\r\n      \"140\",\r\n      \"141\",\r\n      \"142\",\r\n      \"143\",\r\n      \"145\",\r\n      \"146\",\r\n      \"147\",\r\n      \"195\",\r\n      \"196\",\r\n      \"197\",\r\n      \"198\",\r\n      \"199\"\r\n    ]\r\n  }\r\n}', '2022-05-28 12:08:35', '2022-05-28 12:08:35', 'put', 'api/sysrole/updatesysrolepermissions', '2022-05-28 12:08:35', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26944, '699b6b55-e193-467a-acf7-972444a4be00', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 39, 0, 0, NULL, '{}', '2022-05-28 12:08:38', '2022-05-28 12:08:38', 'post', 'api/identity/getguid', '2022-05-28 12:08:38', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26945, '4cb5947b-8dc7-4aa2-8b0e-df34aa5d1ed6', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 46, 0, 0, NULL, '{\r\n  \"guidKey\": \"d84330ab-b5d4-45b9-a447-8117b0252a22\"\r\n}', '2022-05-28 12:08:38', '2022-05-28 12:08:38', 'get', 'api/identity/getverificationcode', '2022-05-28 12:08:38', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26946, '74df1e0c-62f3-4f18-b2f0-7ba5d03dbbd1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 55, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"3c3p\",\r\n    \"GuidKey\": \"d84330ab-b5d4-45b9-a447-8117b0252a22\"\r\n  }\r\n}', '2022-05-28 12:08:46', '2022-05-28 12:08:46', 'post', 'api/identity/gettokenbylogin', '2022-05-28 12:08:46', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26947, '27601006-579a-4143-92f2-a49626d4d150', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 54, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:09:31', '2022-05-28 12:09:31', 'post', 'api/sysdatadictionary/getsysdatadictionarylist', '2022-05-28 12:09:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26948, 'bee71601-14fd-4de4-be05-587eca0b4038', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 46, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:09:33', '2022-05-28 12:09:33', 'post', 'api/sysuser/getpageuserlist', '2022-05-28 12:09:33', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26949, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 43, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:10:19', '2022-05-28 12:10:19', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:10:19', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26950, 'c15ef2e3-fda9-4a88-81bc-1dfa6723136a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 35, 0, 1, 'admin', '{\r\n  \"id\": 200\r\n}', '2022-05-28 12:10:24', '2022-05-28 12:10:24', 'get', 'api/syspermission/get', '2022-05-28 12:10:24', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26951, '4dd118ec-1124-4878-9fa6-118c37dc2f6a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 34, 0, 1, 'admin', '{\r\n  \"pid\": 200\r\n}', '2022-05-28 12:10:24', '2022-05-28 12:10:24', 'post', 'api/syspermission/getsyspermissionfilterbypid', '2022-05-28 12:10:24', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26952, 'c15ef2e3-fda9-4a88-81bc-1dfa6723136a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 41, 0, 1, 'admin', '{\r\n  \"id\": 201\r\n}', '2022-05-28 12:10:35', '2022-05-28 12:10:35', 'get', 'api/syspermission/get', '2022-05-28 12:10:35', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26953, '4dd118ec-1124-4878-9fa6-118c37dc2f6a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 35, 0, 1, 'admin', '{\r\n  \"pid\": 201\r\n}', '2022-05-28 12:10:35', '2022-05-28 12:10:36', 'post', 'api/syspermission/getsyspermissionfilterbypid', '2022-05-28 12:10:36', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26954, '6a5b1ec9-07a3-4651-8b86-8cd29cf0b6f1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 130, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ParentId\": \"200\",\r\n    \"Label\": \"区块链存证\",\r\n    \"Code\": \"bCEvidenceManager\",\r\n    \"Type\": 2,\r\n    \"View\": \"bCEvidences\",\r\n    \"Api\": \"\",\r\n    \"Path\": \"/bCEvidences\",\r\n    \"Icon\": \"fa fa-wpforms\",\r\n    \"Hidden\": false,\r\n    \"Closable\": true,\r\n    \"Opened\": true,\r\n    \"NewWindow\": true,\r\n    \"External\": true,\r\n    \"Sort\": 9,\r\n    \"Description\": \"\",\r\n    \"Id\": \"201\"\r\n  }\r\n}', '2022-05-28 12:10:41', '2022-05-28 12:10:41', 'put', 'api/syspermission/updatesyspermission', '2022-05-28 12:10:41', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26955, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 37, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:10:41', '2022-05-28 12:10:41', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:10:41', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26956, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 47, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:10:51', '2022-05-28 12:10:51', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:10:51', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26957, '7addcc96-e4e6-4c19-874f-b26f5dcdd731', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 51, 0, 1, 'admin', '{}', '2022-05-28 12:10:51', '2022-05-28 12:10:51', 'get', 'api/sysrole/getsysrolelist', '2022-05-28 12:10:51', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26958, 'bee71601-14fd-4de4-be05-587eca0b4038', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 37, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:10:54', '2022-05-28 12:10:54', 'post', 'api/sysuser/getpageuserlist', '2022-05-28 12:10:54', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26959, '7addcc96-e4e6-4c19-874f-b26f5dcdd731', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 38, 0, 1, 'admin', '{}', '2022-05-28 12:10:56', '2022-05-28 12:10:56', 'get', 'api/sysrole/getsysrolelist', '2022-05-28 12:10:56', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26960, 'ed99cca3-a564-4299-899f-6f462fdc0358', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 57, 0, 1, 'admin', '{\r\n  \"id\": 1\r\n}', '2022-05-28 12:10:56', '2022-05-28 12:10:56', 'get', 'api/sysuser/get', '2022-05-28 12:10:56', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26961, '699b6b55-e193-467a-acf7-972444a4be00', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 32, 0, 0, NULL, '{}', '2022-05-28 12:10:59', '2022-05-28 12:10:59', 'post', 'api/identity/getguid', '2022-05-28 12:10:59', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26962, '4cb5947b-8dc7-4aa2-8b0e-df34aa5d1ed6', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 29, 0, 0, NULL, '{\r\n  \"guidKey\": \"071ab810-61a4-4092-b29e-f8d88b36e7bd\"\r\n}', '2022-05-28 12:10:59', '2022-05-28 12:10:59', 'get', 'api/identity/getverificationcode', '2022-05-28 12:10:59', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26963, '74df1e0c-62f3-4f18-b2f0-7ba5d03dbbd1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 91, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"b7gh\",\r\n    \"GuidKey\": \"071ab810-61a4-4092-b29e-f8d88b36e7bd\"\r\n  }\r\n}', '2022-05-28 12:11:10', '2022-05-28 12:11:10', 'post', 'api/identity/gettokenbylogin', '2022-05-28 12:11:10', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26964, 'bee71601-14fd-4de4-be05-587eca0b4038', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 41, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:11:34', '2022-05-28 12:11:34', 'post', 'api/sysuser/getpageuserlist', '2022-05-28 12:11:34', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26965, '9f440ed8-b6f1-45a9-b725-d6bad4ef8341', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 36, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:11:36', '2022-05-28 12:11:36', 'post', 'api/sysrole/getpagesysrolelist', '2022-05-28 12:11:36', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26966, 'bb98ed8d-b565-4093-98f1-7043253f2276', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 47, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:11:37', '2022-05-28 12:11:37', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:11:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26967, 'e3e62393-92c9-4341-8252-8662d6f282c8', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 79, 0, 0, NULL, '{}', '2022-05-28 12:14:01', '2022-05-28 12:14:01', 'post', 'api/identity/getguid', '2022-05-28 12:14:01', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26968, '3c423eaa-2842-4523-96b2-690cd358f7dd', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 83, 0, 0, NULL, '{\r\n  \"guidKey\": \"f32bd862-c4fa-4c17-8812-817d3aacedab\"\r\n}', '2022-05-28 12:14:01', '2022-05-28 12:14:01', 'get', 'api/identity/getverificationcode', '2022-05-28 12:14:01', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26969, 'ebd4b24f-c5c1-43d7-8157-0fed89bd9438', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 328, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"jevx\",\r\n    \"GuidKey\": \"f32bd862-c4fa-4c17-8812-817d3aacedab\"\r\n  }\r\n}', '2022-05-28 12:14:29', '2022-05-28 12:14:29', 'post', 'api/identity/gettokenbylogin', '2022-05-28 12:14:29', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26970, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 102, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:14:31', '2022-05-28 12:14:31', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:14:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26971, 'a1c9d1b5-6189-4709-8fb7-ed48ffc638a7', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 89, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:16:28', '2022-05-28 12:16:28', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:16:28', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26972, 'f92c6307-1408-4417-9e00-af8cfcdac966', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 59, 0, 1, 'admin', '{\r\n  \"id\": 203\r\n}', '2022-05-28 12:16:34', '2022-05-28 12:16:34', 'get', 'api/syspermission/get', '2022-05-28 12:16:34', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26973, '90ccaa06-8b38-41d3-a7ca-d330c866e4ab', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 54, 0, 1, 'admin', '{\r\n  \"pid\": 203\r\n}', '2022-05-28 12:16:34', '2022-05-28 12:16:34', 'post', 'api/syspermission/getsyspermissionfilterbypid', '2022-05-28 12:16:34', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26974, 'd89f4259-2260-4d92-a5ab-0aae100c60af', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 135, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ParentId\": \"201\",\r\n    \"Label\": \"新增区块链存证\",\r\n    \"Code\": \"bCEvidenceManager.createBCEvidence\",\r\n    \"Type\": 3,\r\n    \"View\": \"\",\r\n    \"Api\": \"BCEvidence/CreateBCEvidence\",\r\n    \"Path\": \"\",\r\n    \"Icon\": \"\",\r\n    \"Hidden\": false,\r\n    \"Closable\": true,\r\n    \"Opened\": true,\r\n    \"NewWindow\": true,\r\n    \"External\": true,\r\n    \"Sort\": 0,\r\n    \"Description\": \"\",\r\n    \"Id\": \"203\"\r\n  }\r\n}', '2022-05-28 12:16:41', '2022-05-28 12:16:41', 'put', 'api/syspermission/updatesyspermission', '2022-05-28 12:16:41', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26975, 'a1c9d1b5-6189-4709-8fb7-ed48ffc638a7', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 50, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:16:41', '2022-05-28 12:16:41', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:16:41', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26976, 'e3e62393-92c9-4341-8252-8662d6f282c8', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 60, 0, 0, NULL, '{}', '2022-05-28 12:16:43', '2022-05-28 12:16:43', 'post', 'api/identity/getguid', '2022-05-28 12:16:43', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26977, '3c423eaa-2842-4523-96b2-690cd358f7dd', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 56, 0, 0, NULL, '{\r\n  \"guidKey\": \"b373fce6-e3c8-4315-aa5b-eacdbb41807c\"\r\n}', '2022-05-28 12:16:43', '2022-05-28 12:16:43', 'get', 'api/identity/getverificationcode', '2022-05-28 12:16:43', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26978, 'ebd4b24f-c5c1-43d7-8157-0fed89bd9438', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 60, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"snpg\",\r\n    \"GuidKey\": \"b373fce6-e3c8-4315-aa5b-eacdbb41807c\"\r\n  }\r\n}', '2022-05-28 12:16:47', '2022-05-28 12:16:48', 'post', 'api/identity/gettokenbylogin', '2022-05-28 12:16:48', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26979, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 57, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:16:49', '2022-05-28 12:16:49', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:16:49', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26980, 'f32486a6-ef47-4e7f-b9f7-74248a4ed319', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 78048, 0, 1, 'admin', '{}', '2022-05-28 12:16:56', '2022-05-28 12:18:14', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 12:18:14', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26981, 'f32486a6-ef47-4e7f-b9f7-74248a4ed319', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 806, 0, 1, 'admin', '{}', '2022-05-28 12:18:14', '2022-05-28 12:18:15', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 12:18:15', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26982, 'f32486a6-ef47-4e7f-b9f7-74248a4ed319', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 129406, 0, 1, 'admin', '{}', '2022-05-28 12:18:20', '2022-05-28 12:20:29', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 12:20:29', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26983, 'f32486a6-ef47-4e7f-b9f7-74248a4ed319', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 5608, 0, 1, 'admin', '{}', '2022-05-28 12:20:35', '2022-05-28 12:20:40', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 12:20:40', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (26984, 'f32486a6-ef47-4e7f-b9f7-74248a4ed319', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 99, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"1\",\r\n    \"TypeName\": \"1\",\r\n    \"DataValue\": \"1\",\r\n    \"EvidenceState\": 0,\r\n    \"Message\": \"1\",\r\n    \"TranscationHash\": \"11\",\r\n    \"OperaEvidenceDate\": \"1991-05-12T00:00:00\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 12:20:54', '2022-05-28 12:20:54', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 12:20:54', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26985, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 48, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:20:54', '2022-05-28 12:20:55', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:20:55', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26986, '6488928d-8047-49c7-877a-41b066ba7732', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 69, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:22:30', '2022-05-28 12:22:31', 'post', 'api/sysuser/getpageuserlist', '2022-05-28 12:22:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26987, 'a1c9d1b5-6189-4709-8fb7-ed48ffc638a7', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 46, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:22:40', '2022-05-28 12:22:40', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:22:40', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26988, 'f92c6307-1408-4417-9e00-af8cfcdac966', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 40, 0, 1, 'admin', '{\r\n  \"id\": 111\r\n}', '2022-05-28 12:22:42', '2022-05-28 12:22:42', 'get', 'api/syspermission/get', '2022-05-28 12:22:42', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26989, '90ccaa06-8b38-41d3-a7ca-d330c866e4ab', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 62, 0, 1, 'admin', '{\r\n  \"pid\": 111\r\n}', '2022-05-28 12:22:42', '2022-05-28 12:22:42', 'post', 'api/syspermission/getsyspermissionfilterbypid', '2022-05-28 12:22:42', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26990, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 76, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:25:12', '2022-05-28 12:25:12', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:25:12', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26991, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 66, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:25:17', '2022-05-28 12:25:17', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:25:17', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26992, 'a1c9d1b5-6189-4709-8fb7-ed48ffc638a7', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 48, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 12:26:14', '2022-05-28 12:26:14', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 12:26:14', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26993, 'f92c6307-1408-4417-9e00-af8cfcdac966', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 43, 0, 1, 'admin', '{\r\n  \"id\": 200\r\n}', '2022-05-28 12:26:16', '2022-05-28 12:26:16', 'get', 'api/syspermission/get', '2022-05-28 12:26:16', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26994, '90ccaa06-8b38-41d3-a7ca-d330c866e4ab', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 39, 0, 1, 'admin', '{\r\n  \"pid\": 200\r\n}', '2022-05-28 12:26:16', '2022-05-28 12:26:16', 'post', 'api/syspermission/getsyspermissionfilterbypid', '2022-05-28 12:26:16', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26995, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 52, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:26:52', '2022-05-28 12:26:52', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:26:52', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26996, '392d95ed-9314-4663-bf30-9e9e641b972d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 45, 0, 1, 'admin', '{\r\n  \"id\": 1\r\n}', '2022-05-28 12:26:54', '2022-05-28 12:26:54', 'get', 'api/bcevidence/get', '2022-05-28 12:26:54', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26997, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 54, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:35:12', '2022-05-28 12:35:12', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:35:12', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26998, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 56, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:35:46', '2022-05-28 12:35:46', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:35:46', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (26999, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 50, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:37:12', '2022-05-28 12:37:13', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:37:13', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27000, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 65, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:38:45', '2022-05-28 12:38:45', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:38:45', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27001, '392d95ed-9314-4663-bf30-9e9e641b972d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 42, 0, 1, 'admin', '{\r\n  \"id\": 1\r\n}', '2022-05-28 12:38:46', '2022-05-28 12:38:46', 'get', 'api/bcevidence/get', '2022-05-28 12:38:46', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27002, '392d95ed-9314-4663-bf30-9e9e641b972d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 35, 0, 1, 'admin', '{\r\n  \"id\": 1\r\n}', '2022-05-28 12:38:51', '2022-05-28 12:38:51', 'get', 'api/bcevidence/get', '2022-05-28 12:38:51', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27003, '392d95ed-9314-4663-bf30-9e9e641b972d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 35, 0, 1, 'admin', '{\r\n  \"id\": 1\r\n}', '2022-05-28 12:38:59', '2022-05-28 12:38:59', 'get', 'api/bcevidence/get', '2022-05-28 12:38:59', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27004, 'f32486a6-ef47-4e7f-b9f7-74248a4ed319', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 130, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"2\",\r\n    \"TypeName\": \"2\",\r\n    \"DataValue\": \"2\",\r\n    \"EvidenceState\": 0,\r\n    \"Message\": \"2\",\r\n    \"TranscationHash\": \"2\",\r\n    \"OperaEvidenceDate\": \"2011-01-12T00:00:00\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 12:39:24', '2022-05-28 12:39:24', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 12:39:24', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27005, 'd137e007-a206-4752-8df5-fe24a167754a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 35, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:39:24', '2022-05-28 12:39:24', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:39:24', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27006, '392d95ed-9314-4663-bf30-9e9e641b972d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 34, 0, 1, 'admin', '{\r\n  \"id\": 1\r\n}', '2022-05-28 12:39:26', '2022-05-28 12:39:26', 'get', 'api/bcevidence/get', '2022-05-28 12:39:26', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27007, '392d95ed-9314-4663-bf30-9e9e641b972d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 35, 0, 1, 'admin', '{\r\n  \"id\": 2\r\n}', '2022-05-28 12:39:29', '2022-05-28 12:39:29', 'get', 'api/bcevidence/get', '2022-05-28 12:39:29', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27008, '023869f4-156a-4792-b501-4fed23353877', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 96, 0, 0, NULL, '{}', '2022-05-28 12:57:29', '2022-05-28 12:57:29', 'post', 'api/identity/getguid', '2022-05-28 12:57:29', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27009, '408957e9-df48-4d71-92d8-2f1693a2628e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 95, 0, 0, NULL, '{\r\n  \"guidKey\": \"2dc78aa8-fd1a-402d-9956-f44ae58e1666\"\r\n}', '2022-05-28 12:57:29', '2022-05-28 12:57:29', 'get', 'api/identity/getverificationcode', '2022-05-28 12:57:29', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27010, '408957e9-df48-4d71-92d8-2f1693a2628e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 42, 0, 0, NULL, '{\r\n  \"guidKey\": \"2dc78aa8-fd1a-402d-9956-f44ae58e1666\"\r\n}', '2022-05-28 12:57:30', '2022-05-28 12:57:31', 'get', 'api/identity/getverificationcode', '2022-05-28 12:57:31', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27011, 'bb1e1f22-6378-4209-b5fb-7162aad1bbbb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 404, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"5k8l\",\r\n    \"GuidKey\": \"2dc78aa8-fd1a-402d-9956-f44ae58e1666\"\r\n  }\r\n}', '2022-05-28 12:57:36', '2022-05-28 12:57:37', 'post', 'api/identity/gettokenbylogin', '2022-05-28 12:57:37', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27012, '5c777515-8b99-43ee-a7d2-a8aed626a5d3', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 75, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:57:39', '2022-05-28 12:57:39', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:57:39', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27013, '7c3f7cb7-d061-44fe-831e-73927ccd9133', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 288, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 12:59:30', '2022-05-28 12:59:30', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 12:59:30', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27014, 'bce0a9bb-7b24-46fd-8004-e91271911a52', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 52, 0, 1, 'admin', '{\r\n  \"id\": 2\r\n}', '2022-05-28 12:59:32', '2022-05-28 12:59:32', 'get', 'api/bcevidence/get', '2022-05-28 12:59:32', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27015, 'bce0a9bb-7b24-46fd-8004-e91271911a52', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 46, 0, 1, 'admin', '{\r\n  \"id\": 1\r\n}', '2022-05-28 12:59:36', '2022-05-28 12:59:36', 'get', 'api/bcevidence/get', '2022-05-28 12:59:36', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27016, 'f3883dea-325e-469c-aacf-e9749ff8a295', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 114, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"123\",\r\n    \"TypeName\": \"2123\",\r\n    \"DataValue\": \"123\",\r\n    \"EvidenceState\": 1,\r\n    \"Message\": \"123\",\r\n    \"TranscationHash\": \"123\",\r\n    \"OperaEvidenceDate\": \"2514-02-21T00:00:00\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 13:00:03', '2022-05-28 13:00:03', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 13:00:03', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27017, '7c3f7cb7-d061-44fe-831e-73927ccd9133', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 39, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 13:00:03', '2022-05-28 13:00:03', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 13:00:03', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27018, 'bce0a9bb-7b24-46fd-8004-e91271911a52', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 108, 0, 1, 'admin', '{\r\n  \"id\": 3\r\n}', '2022-05-28 13:00:05', '2022-05-28 13:00:05', 'get', 'api/bcevidence/get', '2022-05-28 13:00:05', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27019, 'bce0a9bb-7b24-46fd-8004-e91271911a52', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 45, 0, 1, 'admin', '{\r\n  \"id\": 1\r\n}', '2022-05-28 13:00:12', '2022-05-28 13:00:12', 'get', 'api/bcevidence/get', '2022-05-28 13:00:12', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27020, 'bce0a9bb-7b24-46fd-8004-e91271911a52', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 37, 0, 1, 'admin', '{\r\n  \"id\": 3\r\n}', '2022-05-28 13:00:14', '2022-05-28 13:00:14', 'get', 'api/bcevidence/get', '2022-05-28 13:00:14', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27021, '7c3f7cb7-d061-44fe-831e-73927ccd9133', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 52, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 14:34:09', '2022-05-28 14:34:09', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 14:34:09', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27022, 'c86505b8-adb8-40a0-a67d-e58ef9cd3a21', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 70, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 14:34:54', '2022-05-28 14:34:54', 'post', 'api/sysdatadictionary/getsysdatadictionarylist', '2022-05-28 14:34:54', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27023, 'a7e7c364-e8ee-4bde-835f-123047d6996f', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 102, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"QueryString\": \"\"\r\n  }\r\n}', '2022-05-28 14:34:57', '2022-05-28 14:34:57', 'post', 'api/syspermission/getsyspermissionlist', '2022-05-28 14:34:57', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27024, 'd2b39a47-717f-47ec-b57d-e8740f586d4b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 62, 0, 1, 'admin', '{\r\n  \"id\": 111\r\n}', '2022-05-28 14:34:59', '2022-05-28 14:34:59', 'get', 'api/syspermission/get', '2022-05-28 14:34:59', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27025, '6b4ed537-070a-4dae-8596-ea30bbc9c68e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 42, 0, 1, 'admin', '{\r\n  \"pid\": 111\r\n}', '2022-05-28 14:34:59', '2022-05-28 14:34:59', 'post', 'api/syspermission/getsyspermissionfilterbypid', '2022-05-28 14:34:59', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27026, '7c3f7cb7-d061-44fe-831e-73927ccd9133', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 75, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 14:36:49', '2022-05-28 14:36:49', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 14:36:49', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27027, 'f3883dea-325e-469c-aacf-e9749ff8a295', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 69, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"2\",\r\n    \"TypeName\": \"3\",\r\n    \"DataValue\": \"423\",\r\n    \"EvidenceState\": 0,\r\n    \"Message\": null,\r\n    \"TranscationHash\": null,\r\n    \"OperaEvidenceDate\": \"0001-01-01T00:00:00\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 14:36:56', '2022-05-28 14:36:56', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 14:36:56', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27028, '7c3f7cb7-d061-44fe-831e-73927ccd9133', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 46, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 14:36:56', '2022-05-28 14:36:56', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 14:36:56', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27029, 'bce0a9bb-7b24-46fd-8004-e91271911a52', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 39, 0, 1, 'admin', '{\r\n  \"id\": 4\r\n}', '2022-05-28 14:37:04', '2022-05-28 14:37:04', 'get', 'api/bcevidence/get', '2022-05-28 14:37:04', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27030, '5cf2e21c-8270-422c-9cb7-2260d3a5f00e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 838, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"999999\",\r\n    \"GuidKey\": \"string\"\r\n  }\r\n}', '2022-05-28 15:12:56', '2022-05-28 15:12:56', 'post', 'api/identity/gettokenbylogin', '2022-05-28 15:12:56', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27031, '1f3568a3-b7b6-4f1b-9d07-f711ceb0ea5e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 642, 0, 0, NULL, '{\r\n  \"loginUserDto\": {\r\n    \"userId\": \"admin\",\r\n    \"pwd\": \"123456\",\r\n    \"TenantId\": 1,\r\n    \"validateCode\": \"999999\",\r\n    \"GuidKey\": \"string\"\r\n  }\r\n}', '2022-05-28 15:24:15', '2022-05-28 15:24:15', 'post', 'api/identity/gettokenbylogin', '2022-05-28 15:24:15', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27032, '1ab5a73b-bede-4330-91a9-3e4ee4ebbffe', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 72302, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"abc\",\r\n    \"TypeName\": \"测试\",\r\n    \"DataValue\": \"\\\"养殖饲料\\\":\\\"牧草\\\",\\\"养殖品类\\\":\\\"奶牛\\\",\\\"养殖时间\\\":\\\"2022-02-11\\\",\",\r\n    \"EvidenceState\": 0,\r\n    \"Message\": \"string\",\r\n    \"TranscationHash\": \"string\",\r\n    \"OperaEvidenceDate\": \"2022-05-28T07:20:09.998Z\",\r\n    \"Id\": \"string\"\r\n  }\r\n}', '2022-05-28 15:24:34', '2022-05-28 15:25:46', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:25:46', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27033, '99cb3288-2e96-497b-9296-332ce693d8c9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 30995, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"abc\",\r\n    \"TypeName\": \"测试\",\r\n    \"DataValue\": \"\\\"养殖饲料\\\":\\\"牧草\\\",\\\"养殖品类\\\":\\\"奶牛\\\",\\\"养殖时间\\\":\\\"2022-02-11\\\",\",\r\n    \"EvidenceState\": 0,\r\n    \"Message\": \"string\",\r\n    \"TranscationHash\": \"string\",\r\n    \"OperaEvidenceDate\": \"2022-05-28T07:20:09.998Z\",\r\n    \"Id\": \"string\"\r\n  }\r\n}', '2022-05-28 15:29:48', '2022-05-28 15:30:19', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:30:19', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27034, 'f2965865-5a91-47ce-b490-63c3ff796526', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 4862, 0, 1, 'admin', '{\r\n  \"serviceId\": \"abc\"\r\n}', '2022-05-28 15:32:34', '2022-05-28 15:32:39', 'post', 'api/bcevidence/validatebcevidencelist', '2022-05-28 15:32:39', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27035, 'f2965865-5a91-47ce-b490-63c3ff796526', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 14718, 0, 1, 'admin', '{\r\n  \"serviceId\": \"abc\"\r\n}', '2022-05-28 15:32:44', '2022-05-28 15:32:59', 'post', 'api/bcevidence/validatebcevidencelist', '2022-05-28 15:32:59', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27036, '59a772e4-90e7-4ced-bc25-e02d30fc1e7e', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 7234, 0, 1, 'admin', '{\r\n  \"serviceId\": \"abc\"\r\n}', '2022-05-28 15:34:27', '2022-05-28 15:34:34', 'post', 'api/bcevidence/validatebcevidencelist', '2022-05-28 15:34:34', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27037, '6d6fbcf4-32ab-4584-a9de-72302cccdfd9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 31421, 0, 1, 'admin', '{\r\n  \"serviceId\": \"abc\"\r\n}', '2022-05-28 15:37:46', '2022-05-28 15:38:18', 'post', 'api/bcevidence/validatebcevidencelist', '2022-05-28 15:38:18', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27038, '0ed60e77-c013-433f-945d-930d587c3435', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 160, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 15:38:30', '2022-05-28 15:38:30', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 15:38:30', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27039, '9d96be96-7824-41cc-83ca-923400bc6f8a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 52, 0, 1, 'admin', '{\r\n  \"id\": 5\r\n}', '2022-05-28 15:38:32', '2022-05-28 15:38:32', 'get', 'api/bcevidence/get', '2022-05-28 15:38:32', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27040, '0ed60e77-c013-433f-945d-930d587c3435', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 57, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 15:39:05', '2022-05-28 15:39:05', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 15:39:05', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27041, '0ed60e77-c013-433f-945d-930d587c3435', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 77, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 15:40:40', '2022-05-28 15:40:40', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 15:40:40', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27042, '9d96be96-7824-41cc-83ca-923400bc6f8a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 45, 0, 1, 'admin', '{\r\n  \"id\": 5\r\n}', '2022-05-28 15:40:43', '2022-05-28 15:40:43', 'get', 'api/bcevidence/get', '2022-05-28 15:40:43', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27043, '0ed60e77-c013-433f-945d-930d587c3435', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 59, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"abc\"\r\n    }\r\n  }\r\n}', '2022-05-28 15:42:01', '2022-05-28 15:42:01', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 15:42:01', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27044, '9d96be96-7824-41cc-83ca-923400bc6f8a', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 43, 0, 1, 'admin', '{\r\n  \"id\": 5\r\n}', '2022-05-28 15:42:03', '2022-05-28 15:42:03', 'get', 'api/bcevidence/get', '2022-05-28 15:42:03', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27045, '3478c7d0-2dfb-4e70-a227-59e0795138fd', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 56532, 0, 1, 'admin', '{}', '2022-05-28 15:43:08', '2022-05-28 15:44:05', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:44:05', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27046, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 14980, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"qqq\",\r\n    \"TypeName\": \"qqq\",\r\n    \"DataValue\": \"恶趣味群翁\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:47:44', '2022-05-28 15:47:59', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:47:59', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27047, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 1740, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"qqq\",\r\n    \"TypeName\": \"qqq\",\r\n    \"DataValue\": \"恶趣味群翁\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:48:11', '2022-05-28 15:48:13', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:48:13', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27048, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 3339, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"qqq\",\r\n    \"TypeName\": \"qqq\",\r\n    \"DataValue\": \"恶趣味群翁\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:48:28', '2022-05-28 15:48:32', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:48:32', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27049, 'b05c397c-cb39-4818-90ad-88b0d1c01e07', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 128, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 15:49:05', '2022-05-28 15:49:06', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 15:49:06', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27050, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 4953, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"fff\",\r\n    \"TypeName\": \"V型从v\",\r\n    \"DataValue\": \"范德萨发达\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:49:14', '2022-05-28 15:49:19', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:49:19', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27051, 'b05c397c-cb39-4818-90ad-88b0d1c01e07', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 56, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 15:49:19', '2022-05-28 15:49:19', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 15:49:19', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27052, '341bed08-f00f-44d5-a290-e8b57515b598', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 52, 0, 1, 'admin', '{\r\n  \"id\": 6\r\n}', '2022-05-28 15:49:23', '2022-05-28 15:49:23', 'get', 'api/bcevidence/get', '2022-05-28 15:49:23', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27053, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 5144, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"V型支持v\",\r\n    \"TypeName\": \"V字形\",\r\n    \"DataValue\": \"V型操作的V字形\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:49:35', '2022-05-28 15:49:40', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:49:40', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27054, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 2005, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"V型支持v\",\r\n    \"TypeName\": \"V字形\",\r\n    \"DataValue\": \"V型操作的V字形\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:49:59', '2022-05-28 15:50:01', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:50:01', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27055, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 2033, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"V型支持v\",\r\n    \"TypeName\": \"V字形\",\r\n    \"DataValue\": \"V型操作的V字形\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:52:14', '2022-05-28 15:52:16', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:52:16', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27056, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 241, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"V型支持v\",\r\n    \"TypeName\": \"V字形\",\r\n    \"DataValue\": \"V型操作的V字形\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:52:26', '2022-05-28 15:52:27', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:52:27', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27057, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 396, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"V型支持v\",\r\n    \"TypeName\": \"V字形\",\r\n    \"DataValue\": \"V型操作的V字形\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:52:29', '2022-05-28 15:52:29', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:52:29', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27058, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 234, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"V型支持v\",\r\n    \"TypeName\": \"V字形\",\r\n    \"DataValue\": \"V型操作的V字形\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:52:30', '2022-05-28 15:52:30', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:52:30', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27059, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 353, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"V型支持v\",\r\n    \"TypeName\": \"胜多负少的\",\r\n    \"DataValue\": \"V型操作的V字形发的算法 \",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:52:37', '2022-05-28 15:52:37', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:52:37', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27060, 'b05c397c-cb39-4818-90ad-88b0d1c01e07', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 78, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 15:54:16', '2022-05-28 15:54:16', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 15:54:16', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27061, 'b05c397c-cb39-4818-90ad-88b0d1c01e07', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 44, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 15:54:24', '2022-05-28 15:54:24', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 15:54:24', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27062, 'b05c397c-cb39-4818-90ad-88b0d1c01e07', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 47, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 15:56:34', '2022-05-28 15:56:34', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 15:56:34', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27063, '4f5cbfe9-4823-45cb-8448-aaca95d975cf', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 349, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"大的\",\r\n    \"TypeName\": \"说到\",\r\n    \"DataValue\": \"发打分的\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 15:56:40', '2022-05-28 15:56:41', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 15:56:41', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27064, 'e780da6a-9942-497a-8146-f3de38d8cf48', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 1251, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"小程序\",\r\n    \"TypeName\": \"修行\",\r\n    \"DataValue\": \"水电费\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:02:56', '2022-05-28 16:02:57', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:02:57', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27065, '3a19b77f-eba3-4d8f-b5fe-0453eccd9263', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 150, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:02:57', '2022-05-28 16:02:57', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:02:57', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27066, '0e6fd589-96a1-446f-9af3-96515fd6d9ca', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 56, 0, 1, 'admin', '{\r\n  \"id\": 7\r\n}', '2022-05-28 16:03:04', '2022-05-28 16:03:04', 'get', 'api/bcevidence/get', '2022-05-28 16:03:04', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27067, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 744, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"打分的发\",\r\n    \"TypeName\": \"发的地方\",\r\n    \"DataValue\": \"防守打法\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:06:35', '2022-05-28 16:06:36', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:06:36', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27068, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 241, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"打分的发\",\r\n    \"TypeName\": \"发的地方\",\r\n    \"DataValue\": \"防守打法\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:06:43', '2022-05-28 16:06:43', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:06:43', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27069, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 233, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"孤鸿寡鹄\",\r\n    \"TypeName\": \"个梵蒂冈水电费\",\r\n    \"DataValue\": \"广东佛山功法\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:06:59', '2022-05-28 16:06:59', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:06:59', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27070, 'ea11bc72-a073-406d-83d5-0b0b54356ffb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 156, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:07:21', '2022-05-28 16:07:21', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:07:21', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27071, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 232, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"V型从v想\",\r\n    \"TypeName\": \"V型从vV型从v想从\",\r\n    \"DataValue\": \"梵蒂冈的风格的风格的房\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:07:30', '2022-05-28 16:07:31', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:07:31', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27072, 'ea11bc72-a073-406d-83d5-0b0b54356ffb', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 72, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:09:02', '2022-05-28 16:09:02', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:09:02', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27073, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 201, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"发生\",\r\n    \"TypeName\": \"福鼎市飞升到\",\r\n    \"DataValue\": \"会让退回退\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:09:09', '2022-05-28 16:09:09', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:09:09', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27074, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 207, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"发生\",\r\n    \"TypeName\": \"福鼎市飞升到\",\r\n    \"DataValue\": \"会让退回退\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:10:53', '2022-05-28 16:10:53', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:10:53', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27075, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 207, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"发生\",\r\n    \"TypeName\": \"福鼎市飞升到\",\r\n    \"DataValue\": \"会让退回退\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:10:54', '2022-05-28 16:10:54', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:10:54', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27076, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 215, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"发生\",\r\n    \"TypeName\": \"福鼎市飞升到\",\r\n    \"DataValue\": \"会让退回退\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:10:54', '2022-05-28 16:10:54', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:10:54', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27077, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 244, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"发生\",\r\n    \"TypeName\": \"福鼎市飞升到\",\r\n    \"DataValue\": \"会让退回退\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:10:55', '2022-05-28 16:10:55', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:10:55', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27078, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 254, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"发生\",\r\n    \"TypeName\": \"福鼎市飞升到\",\r\n    \"DataValue\": \"会让退回退\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:10:55', '2022-05-28 16:10:55', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:10:55', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27079, '2bce6fd1-eb07-494b-b9c6-889e4a90571c', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 234, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"绕弯儿翁\",\r\n    \"TypeName\": \"二万五二\",\r\n    \"DataValue\": \"热任务而威尔VGVB该如何柔荑花翁\",\r\n    \"Id\": \"string\"\r\n  }\r\n}', '2022-05-28 16:11:57', '2022-05-28 16:11:57', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:11:57', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27080, '2cfe9647-64ba-4c31-8f23-ed63a17122d9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 25328, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"发生\",\r\n    \"TypeName\": \"福鼎市飞升到\",\r\n    \"DataValue\": \"会让退回退\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:19:26', '2022-05-28 16:19:51', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:19:51', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27081, '2cfe9647-64ba-4c31-8f23-ed63a17122d9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 4076, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"发生\",\r\n    \"TypeName\": \"vxcv 升到\",\r\n    \"DataValue\": \"\\\"会让退回退\\\":\\\"acc\\\"\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:20:10', '2022-05-28 16:20:14', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:20:14', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27082, '0f447664-b629-46c0-86c8-a27dd5cce836', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 120, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:20:14', '2022-05-28 16:20:14', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:20:14', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27083, '38087d3e-391c-4e29-8772-1045285b64c1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 59, 0, 1, 'admin', '{\r\n  \"id\": 10\r\n}', '2022-05-28 16:20:54', '2022-05-28 16:20:54', 'get', 'api/bcevidence/get', '2022-05-28 16:20:54', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27084, '0f447664-b629-46c0-86c8-a27dd5cce836', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 73, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:22:05', '2022-05-28 16:22:05', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:22:05', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27085, '38087d3e-391c-4e29-8772-1045285b64c1', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 46, 0, 1, 'admin', '{\r\n  \"id\": 10\r\n}', '2022-05-28 16:22:12', '2022-05-28 16:22:12', 'get', 'api/bcevidence/get', '2022-05-28 16:22:12', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27086, '2cfe9647-64ba-4c31-8f23-ed63a17122d9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 4922, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"aaa\",\r\n    \"TypeName\": \"aaa\",\r\n    \"DataValue\": \"\\\"aaa\\\":\\\"aaa\\\"\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:22:45', '2022-05-28 16:22:50', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:22:50', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27087, '0f447664-b629-46c0-86c8-a27dd5cce836', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 46, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:22:50', '2022-05-28 16:22:50', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:22:50', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27088, '2cfe9647-64ba-4c31-8f23-ed63a17122d9', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 2213, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"aaa\",\r\n    \"TypeName\": \"aaa\",\r\n    \"DataValue\": \"\\\"aaa\\\":\\\"aaa\\\"\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:22:56', '2022-05-28 16:22:59', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:22:59', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27089, '7bcf3e36-bfbf-48eb-ba37-724a0e94519b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 19159, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"aaa\",\r\n    \"TypeName\": \"aaa\",\r\n    \"DataValue\": \"\\\"aaa\\\":\\\"aaa\\\"\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:23:45', '2022-05-28 16:24:04', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:24:04', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27090, '7bcf3e36-bfbf-48eb-ba37-724a0e94519b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 7355, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"aaa\",\r\n    \"TypeName\": \"ccc\",\r\n    \"DataValue\": \"fdfd \",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:24:15', '2022-05-28 16:24:22', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:24:22', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27091, '3d25cd44-2a4c-4530-ac00-3df31789c10b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 131, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:24:23', '2022-05-28 16:24:23', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:24:23', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27092, '3d25cd44-2a4c-4530-ac00-3df31789c10b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 51, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"aaa\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:24:28', '2022-05-28 16:24:28', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:24:28', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27093, '71fac3f4-1e81-464a-b87c-e4fced8c7f6d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 76, 0, 1, 'admin', '{\r\n  \"id\": 12\r\n}', '2022-05-28 16:24:30', '2022-05-28 16:24:30', 'get', 'api/bcevidence/get', '2022-05-28 16:24:30', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27094, '71fac3f4-1e81-464a-b87c-e4fced8c7f6d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 42, 0, 1, 'admin', '{\r\n  \"id\": 11\r\n}', '2022-05-28 16:24:33', '2022-05-28 16:24:33', 'get', 'api/bcevidence/get', '2022-05-28 16:24:33', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27095, '3d25cd44-2a4c-4530-ac00-3df31789c10b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 47, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:24:57', '2022-05-28 16:24:57', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:24:57', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27096, '3d25cd44-2a4c-4530-ac00-3df31789c10b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 42, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"aaa\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:25:08', '2022-05-28 16:25:08', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:25:08', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27097, '71fac3f4-1e81-464a-b87c-e4fced8c7f6d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 50, 0, 1, 'admin', '{\r\n  \"id\": 12\r\n}', '2022-05-28 16:25:22', '2022-05-28 16:25:23', 'get', 'api/bcevidence/get', '2022-05-28 16:25:23', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27098, '7bcf3e36-bfbf-48eb-ba37-724a0e94519b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 330, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"ServiceId\": \"dsfsdf\",\r\n    \"TypeName\": \"sdfsdf\",\r\n    \"DataValue\": \"dsfsdfds\",\r\n    \"Id\": \"\"\r\n  }\r\n}', '2022-05-28 16:25:31', '2022-05-28 16:25:31', 'post', 'api/bcevidence/createbcevidence', '2022-05-28 16:25:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27099, '3d25cd44-2a4c-4530-ac00-3df31789c10b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 68, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"aaa\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:25:31', '2022-05-28 16:25:31', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:25:31', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27100, '3d25cd44-2a4c-4530-ac00-3df31789c10b', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 35, 0, 1, 'admin', '{\r\n  \"input\": {\r\n    \"CurrentPage\": 1,\r\n    \"PageSize\": 10,\r\n    \"Filter\": {\r\n      \"QueryString\": \"\"\r\n    }\r\n  }\r\n}', '2022-05-28 16:25:36', '2022-05-28 16:25:36', 'post', 'api/bcevidence/getpagebcevidencelist', '2022-05-28 16:25:36', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27101, '71fac3f4-1e81-464a-b87c-e4fced8c7f6d', '127.0.0.1', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 38, 0, 1, 'admin', '{\r\n  \"id\": 13\r\n}', '2022-05-28 16:25:39', '2022-05-28 16:25:39', 'get', 'api/bcevidence/get', '2022-05-28 16:25:39', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27102, '790c6ff5-4ae8-4443-ba39-2a5fa1eadd27', '192.168.1.8', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 101, 0, 0, NULL, '{}', '2022-08-25 21:04:32', '2022-08-25 21:04:32', 'post', 'api/identity/getguid', '2022-08-25 21:04:33', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27103, '3b374611-0753-45ed-8c21-12cebf1cae8b', '192.168.1.8', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 114, 0, 0, NULL, '{\r\n  \"guidKey\": \"e93d07fe-c7c0-4120-bb52-8f13a6a5480d\"\r\n}', '2022-08-25 21:04:33', '2022-08-25 21:04:33', 'get', 'api/identity/getverificationcode', '2022-08-25 21:04:33', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27104, '790c6ff5-4ae8-4443-ba39-2a5fa1eadd27', '192.168.1.8', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 42, 0, 0, NULL, '{}', '2022-08-25 21:05:04', '2022-08-25 21:05:04', 'post', 'api/identity/getguid', '2022-08-25 21:05:04', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27105, '3b374611-0753-45ed-8c21-12cebf1cae8b', '192.168.1.8', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 56, 0, 0, NULL, '{\r\n  \"guidKey\": \"3da725b2-aba7-4639-9b51-68c8b7c234e2\"\r\n}', '2022-08-25 21:05:04', '2022-08-25 21:05:04', 'get', 'api/identity/getverificationcode', '2022-08-25 21:05:04', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27106, '113c08be-1e3c-4084-ad37-b2e7c72fa190', '192.168.1.8', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 115, 0, 0, NULL, '{}', '2022-08-25 21:06:21', '2022-08-25 21:06:22', 'post', 'api/identity/getguid', '2022-08-25 21:06:22', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27107, 'e0f44c45-6804-4d02-bc38-8c7b5b28f67f', '192.168.1.8', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 99, 0, 0, NULL, '{\r\n  \"guidKey\": \"e38d5ca0-3e50-4e65-a2b3-8e8d635af863\"\r\n}', '2022-08-25 21:06:22', '2022-08-25 21:06:22', 'get', 'api/identity/getverificationcode', '2022-08-25 21:06:22', b'0', NULL);
INSERT INTO `sys_auditlog` VALUES (27108, 'e62bdb78-d5a3-41f6-9c29-d403782957ac', '192.168.1.8', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 110, 0, 0, NULL, '{}', '2022-08-25 21:07:44', '2022-08-25 21:07:44', 'post', 'api/identity/getguid', '2022-08-25 21:07:44', b'1', NULL);
INSERT INTO `sys_auditlog` VALUES (27109, '7e058f1d-a86b-4ec4-a5c1-8574756ab9b7', '192.168.1.8', 'Chrome', 'Windows', '', 'Mozilla/5.0 (Windows NT 10.0; WOW64) AppleWebKit/537.36 (KHTML, like Gecko) Chrome/86.0.4240.198 Safari/537.36', 93, 0, 0, NULL, '{\r\n  \"guidKey\": \"65d1957b-ad2d-4f96-a20d-144431b70926\"\r\n}', '2022-08-25 21:07:45', '2022-08-25 21:07:45', 'get', 'api/identity/getverificationcode', '2022-08-25 21:07:45', b'0', NULL);

-- ----------------------------
-- Table structure for sys_datadictionary
-- ----------------------------
DROP TABLE IF EXISTS `sys_datadictionary`;
CREATE TABLE `sys_datadictionary`  (
  `Key` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `ParentId` bigint(20) NULL DEFAULT NULL COMMENT '父节点',
  `Memoni` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '助记符',
  `Sort` int(11) NULL DEFAULT NULL COMMENT '排序',
  `Value` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `IsActive` bit(1) NULL DEFAULT NULL COMMENT '是否启用标识',
  `IsDeleted` bit(1) NULL DEFAULT NULL COMMENT ' 是否删除标识',
  `CreationTime` datetime(0) NULL DEFAULT NULL COMMENT ' 创建时间',
  `CreatorUserId` bigint(20) NULL DEFAULT NULL COMMENT ' 创建ID',
  `TenantId` int(11) NULL DEFAULT NULL COMMENT '租户名',
  `Type` int(11) NULL DEFAULT NULL COMMENT '类别:0 分组， 1叶子节点',
  `Label` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 4 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_datadictionary
-- ----------------------------
INSERT INTO `sys_datadictionary` VALUES ('MenuType.Common', 2, NULL, NULL, '1', 1, NULL, NULL, NULL, NULL, NULL, NULL, '公共菜单');
INSERT INTO `sys_datadictionary` VALUES ('MenuType', 0, NULL, NULL, NULL, 2, NULL, NULL, NULL, NULL, NULL, 0, '菜单类别');
INSERT INTO `sys_datadictionary` VALUES ('aaaa', 0, '', 0, '', 3, NULL, NULL, NULL, 0, NULL, 0, '1122');

-- ----------------------------
-- Table structure for sys_organization
-- ----------------------------
DROP TABLE IF EXISTS `sys_organization`;
CREATE TABLE `sys_organization`  (
  `Label` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '名称',
  `ParentId` bigint(20) NULL DEFAULT NULL COMMENT '所属上级',
  `OrganType` int(11) NULL DEFAULT NULL COMMENT '节点类型',
  `Sort` int(11) NULL DEFAULT NULL COMMENT '序号',
  `PostId` int(11) NULL DEFAULT NULL COMMENT '岗位编号',
  `Fax` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '传真',
  `Telephone` varchar(16) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '联系电话',
  `Address` varchar(64) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '通讯地址',
  `Memoni` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '助记符',
  `Remark` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '备注',
  `RangeType` int(11) NULL DEFAULT NULL COMMENT '权限',
  `Range` varchar(128) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '权限范围',
  `Linkman` varchar(32) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '联系人',
  `CreatorUserId` bigint(20) NULL DEFAULT NULL COMMENT ' 创建ID',
  `CreationTime` datetime(0) NULL DEFAULT NULL COMMENT ' 创建时间',
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `IsActive` bit(1) NULL DEFAULT NULL COMMENT '是否启用标识',
  `IsDeleted` bit(1) NULL DEFAULT NULL COMMENT ' 是否删除标识',
  `TenantId` int(11) NULL DEFAULT NULL COMMENT '租户名',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 26 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_organization
-- ----------------------------
INSERT INTO `sys_organization` VALUES ('xxx事业部', 0, 0, 2, 0, '', '', '', '', '', 0, '', '', 0, NULL, 22, b'0', b'0', NULL);
INSERT INTO `sys_organization` VALUES ('研发部', 22, 0, 0, 0, '', '', '', '', '', 0, '', '', 0, NULL, 23, b'0', b'0', NULL);
INSERT INTO `sys_organization` VALUES ('企划部', 22, 0, 0, 0, '', '', '', '', '', 0, '', '', 0, NULL, 24, b'0', b'0', NULL);
INSERT INTO `sys_organization` VALUES ('开发一组', 23, 0, 0, 0, '', '', '', '', '', 0, '', '', 0, NULL, 25, b'0', b'0', NULL);

-- ----------------------------
-- Table structure for sys_permission
-- ----------------------------
DROP TABLE IF EXISTS `sys_permission`;
CREATE TABLE `sys_permission`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `ParentId` bigint(20) NOT NULL COMMENT '父级节点',
  `Label` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限名称',
  `Code` varchar(550) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '权限编码',
  `Type` int(11) NOT NULL COMMENT '权限类型',
  `View` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '视图',
  `Api` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '接口',
  `Path` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '菜单访问地址',
  `Icon` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '图标',
  `Hidden` bit(1) NOT NULL COMMENT '隐藏',
  `IsActive` bit(1) NULL DEFAULT b'1' COMMENT '启用',
  `Closable` bit(1) NULL DEFAULT NULL COMMENT '可关闭',
  `Opened` bit(1) NULL DEFAULT NULL COMMENT '打开组',
  `NewWindow` bit(1) NULL DEFAULT NULL COMMENT '打开新窗口',
  `External` bit(1) NULL DEFAULT NULL COMMENT '链接外显',
  `Sort` int(11) NULL DEFAULT 999 COMMENT '排序',
  `Description` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '描述',
  `TenantId` bigint(20) NULL DEFAULT NULL COMMENT '租户Id',
  `IsDeleted` bit(1) NULL DEFAULT NULL COMMENT '是否删除',
  `CreatorUserId` bigint(20) NULL DEFAULT NULL COMMENT '创建者Id',
  `CreationTime` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '创建者',
  `CreatedTime` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  `LastModifierUserId` int(11) NULL DEFAULT NULL COMMENT '修改者Id',
  `LastModificationTime` datetime(3) NULL DEFAULT NULL COMMENT '修改时间',
  PRIMARY KEY (`Id`) USING BTREE,
  UNIQUE INDEX `idx_ad_permission_01`(`ParentId`, `Label`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 212 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '权限' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_permission
-- ----------------------------
INSERT INTO `sys_permission` VALUES (111, 0, '系统管理', 'systemManager', 1, '', '', '', 'el-icon-setting', b'1', b'1', b'1', b'1', b'1', b'1', 8, '', 1, b'0', 1, '2021-05-02 18:35:03.773', NULL, 0, '2021-05-03 11:14:36.306');
INSERT INTO `sys_permission` VALUES (112, 0, '用户管理', 'userManager', 2, 'Users', '', '/users', 'el-icon-user', b'1', b'1', b'1', b'1', b'1', b'1', 3, '', 1, b'0', 1, '2021-05-02 18:37:37.656', NULL, 0, '2021-05-03 10:34:10.192');
INSERT INTO `sys_permission` VALUES (113, 111, '角色管理', 'system.roleManager', 2, 'SysRoles', '', '/sysRoles', 'el-icon-share', b'1', b'1', b'1', b'1', b'1', b'1', 4, '', 1, b'0', 1, '2021-05-02 18:39:33.200', NULL, 0, '2021-05-05 17:08:01.619');
INSERT INTO `sys_permission` VALUES (114, 111, '权限管理', 'permissionManager', 2, 'SysPermissions', '', '/sysPermissions', 'el-icon-s-operation', b'1', b'1', b'1', b'1', b'1', b'1', 5, '', 1, b'0', 1, '2021-05-02 18:40:20.539', NULL, 0, '2021-05-05 17:08:15.478');
INSERT INTO `sys_permission` VALUES (115, 0, '数据字典', 'dataDictionaryManager', 2, 'SysDataDictionarys', '', '/sysDataDictionarys', 'el-icon-share', b'1', b'1', b'1', b'1', b'1', b'1', 6, '', 1, b'0', 1, '2021-05-02 18:41:16.319', NULL, 0, '2021-05-03 11:11:32.678');
INSERT INTO `sys_permission` VALUES (116, 0, '日志管理', 'logManager', 1, '', '', '', 'el-icon-document', b'1', b'1', b'1', b'1', b'1', b'1', 8, '', 1, b'0', 1, '2021-05-02 18:43:29.923', NULL, 0, '2021-05-03 11:14:48.619');
INSERT INTO `sys_permission` VALUES (117, 116, '审计日志', 'sysAuditLogManager', 2, 'SysAuditLogs', '', '/sysAuditLogs', '', b'1', b'1', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-02 18:44:24.935', NULL, 0, '2021-05-05 13:47:54.149');
INSERT INTO `sys_permission` VALUES (118, 112, '新增用户', 'userManager.createUser', 3, '', 'SysUser/CreateUser', '', '', b'1', b'1', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-02 18:46:06.639', NULL, 0, '2021-05-03 10:34:57.215');
INSERT INTO `sys_permission` VALUES (119, 112, '查看用户列表', 'userManager.viewUser', 3, '', 'SysUser/GetPageUserList', '', '', b'1', b'1', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-02 18:50:42.411', NULL, 0, '2021-05-03 10:32:25.995');
INSERT INTO `sys_permission` VALUES (120, 112, '编辑用户', 'userManager.editUser', 3, '', 'SysUser/UpdateUser', '', '', b'1', b'1', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:27:32.738', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (121, 112, '删除用户', 'userManager.deleteUser', 3, '', 'SysUser/DeleteUserById', '', '', b'1', b'1', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:35:40.971', NULL, 0, '2021-05-03 10:35:51.595');
INSERT INTO `sys_permission` VALUES (122, 114, '新增权限', 'permissionManager.createPermission', 3, '', 'SysPermission/CreateSysPermission', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:46:41.669', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (123, 114, '编辑权限', 'permissionManager.editPermission', 3, '', 'SysPermission/UpdateSysPermission', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:47:11.061', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (124, 114, '删除权限', 'permissionManager.deletePermission', 3, '', 'SysPermission/DeleteSysPermissionById', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:47:39.828', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (125, 114, '查看权限列表', 'permissionManager.viewPermission', 3, '', 'SysPermission/GetSysPermissionList,SysPermission/Get,SysPermission/GetSysPermissionFilterByPid', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:49:20.263', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (126, 113, '查看角色列表', 'roleManager.viewRole', 3, '', 'SysRole/GetPageSysRoleList', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:52:19.301', NULL, 0, '2021-05-03 10:55:28.470');
INSERT INTO `sys_permission` VALUES (127, 113, '编辑角色', 'roleManager.editRole', 3, '', 'SysRole/UpdateSysRole', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:53:49.424', NULL, 0, '2021-05-03 10:54:53.629');
INSERT INTO `sys_permission` VALUES (128, 113, '新增角色', 'roleManager.createRole', 3, '', 'SysRole/CreateSysRole', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:54:40.920', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (129, 113, '删除角色', 'roleManager.deleteRole', 3, '', 'SysRole/DeleteSysRoleById', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 10:56:37.772', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (130, 111, '角色权限', 'rolePermissionManager', 2, 'SysRolePermissions', '', '/sysRolePemissions', 'el-icon-share', b'1', b'0', b'1', b'1', b'1', b'1', 7, '', 1, b'0', 1, '2021-05-03 10:59:13.100', NULL, 0, '2021-05-05 17:08:30.991');
INSERT INTO `sys_permission` VALUES (131, 130, '配置角色权限', 'rolePermissionManager.editRolePermission', 3, '', 'SysRole/UpdateSysRolePermissions', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 11:00:38.300', NULL, 0, '2021-05-03 11:08:25.225');
INSERT INTO `sys_permission` VALUES (132, 115, '新增数据字典', 'dataDictionaryManager.createDataDictionary', 3, '', 'SysDataDictionary/CreateSysDataDictionary', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 11:07:23.817', NULL, 0, '2021-05-03 11:08:43.803');
INSERT INTO `sys_permission` VALUES (133, 115, '编辑数据字典', 'dataDictionaryManager.editDataDictionary', 3, '', 'SysDataDictionary/UpdateSysDataDictionary', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 11:09:27.438', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (134, 115, '删除数据字典', 'dataDictionaryManager.deleteDataDictionary', 3, '', 'SysDataDictionary/DeleteSysDataDictionaryById', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 11:10:11.542', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (135, 115, '查看数据字典列表', 'dataDictionaryManager.viewDataDictionary', 3, '', 'SysDataDictionary/GetSysDataDictionaryList,SysDataDictionary/GetSysDataDictionaryFilterByPid', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 11:10:46.715', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (136, 0, '首页', 'welcomePage', 2, 'Welcome', '', '/welcome', 'el-icon-s-home', b'1', b'0', b'1', b'1', b'1', b'1', 1, '', 1, b'0', 1, '2021-05-03 11:16:56.241', NULL, 0, '2021-05-04 15:01:23.987');
INSERT INTO `sys_permission` VALUES (137, 130, '查看角色权限列表', 'rolePermissionManager.viewRolePermission', 3, '', 'SysRole/GetSysRoleList,SysPermission/GetSysPermissionList', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-03 11:19:55.125', NULL, 0, '2021-05-03 11:23:44.581');
INSERT INTO `sys_permission` VALUES (138, 117, '查看审计日志列表', 'sysAuditLogManager.viewSysAuditLog', 3, '', 'SysAuditLog/GetPageSysAuditLogList,SysAuditLog/Get', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-05 12:59:33.332', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (139, 0, '机构管理', 'sysOrganizationManager', 2, 'SysOrganizations', '', '/sysOrganizations', 'el-icon-s-custom', b'1', b'0', b'1', b'1', b'1', b'1', 999, '', 1, b'0', 1, '2021-05-05 17:12:30.131', NULL, 0, '2021-05-05 17:24:55.009');
INSERT INTO `sys_permission` VALUES (140, 139, '查看组织机构列表', 'sysOrganizationManager.viewSysOrganization', 3, '', 'SysOrganization/GetSysOrganizationList,SysOrganization/Get,SysOrganization/GetSysOrganizationFilterByPid', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-05 17:13:51.264', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (141, 139, '新增组织机构', 'sysOrganizationManager.createSysOrganization', 3, '', 'SysOrganization/CreateSysOrganization', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-05 17:14:29.066', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (142, 139, '编辑组织机构', 'sysOrganizationManager.editSysOrganization', 3, '', 'SysOrganization/UpdateSysOrganization', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-05 17:22:03.526', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (143, 139, '删除组织机构', 'sysOrganizationManager.deleteSysOrganization', 3, '', 'SysOrganization/DeleteSysOrganizationById', '', '', b'1', b'0', b'1', b'1', b'1', b'1', 0, '', 1, b'0', 1, '2021-05-05 17:22:51.792', NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (145, 0, '看板', 'Board', 2, 'board', '', '/board', 'el-icon-s-marketing', b'0', b'0', b'1', b'1', b'1', b'1', 2, '', NULL, b'0', 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (146, 0, '个人中心', 'personalPage', 2, 'Personal', '', '/personal', 'el-icon-collection', b'0', NULL, b'1', b'1', b'1', b'1', 3, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (147, 146, '个人中心操作', 'EitPeronal', 3, '', 'SysUser/GetUserInfo,SysUser/ChangePassword,Identity/UploadImage,/api/SysUser/UploadUserAvatar', '', '', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (195, 0, '租户管理', 'system.sysTenantManager', 2, 'SysTenants', '', '/sysTenants', 'fa fa-sitemap', b'0', b'1', b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, '2022-02-16 01:23:34.212', NULL, 0, '2022-02-16 01:23:34.212');
INSERT INTO `sys_permission` VALUES (196, 195, '查看租户管理列表', 'sysTenantManager.viewSysTenant', 3, '', 'SysTenant/GetPageSysTenantList,SysTenant/Get', '', '', b'0', b'1', b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, '2022-02-16 01:23:34.475', NULL, 0, '2022-02-16 01:23:34.475');
INSERT INTO `sys_permission` VALUES (197, 195, '新增租户管理', 'sysTenantManager.createSysTenant', 3, '', 'SysTenant/CreateSysTenant', '', '', b'0', b'1', b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, '2022-02-16 01:23:34.475', NULL, 0, '2022-02-16 01:23:34.475');
INSERT INTO `sys_permission` VALUES (198, 195, '修改租户管理', 'sysTenantManager.editSysTenant', 3, '', 'SysTenant/UpdateSysTenant', '', '', b'0', b'1', b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, '2022-02-16 01:23:34.475', NULL, 0, '2022-02-16 01:23:34.475');
INSERT INTO `sys_permission` VALUES (199, 195, '删除租户管理', 'sysTenantManager.deleteSysTenant', 3, '', 'SysTenant/DeleteSysTenant', '', '', b'0', b'1', b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, '2022-02-16 01:23:34.475', NULL, 0, '2022-02-16 01:23:34.475');
INSERT INTO `sys_permission` VALUES (200, 0, '区块链管理', 'blockChainManager', 1, '', '', '', 'fa fa-gg', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (201, 200, '区块链存证', 'bCEvidenceManager', 2, 'bCEvidences', '', '/bCEvidences', 'fa fa-wpforms', b'0', NULL, b'1', b'1', b'1', b'1', 9, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (202, 201, '查看区块链存证列表', 'bCEvidenceManager.viewBCEvidence', 3, '', 'BCEvidence/GetPageBCEvidenceList,BCEvidence/Get', '', '', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (203, 201, '新增区块链存证', 'bCEvidenceManager.createBCEvidence', 3, '', 'BCEvidence/CreateBCEvidence', '', '', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (204, 0, '自动化引擎', 'automationEngineManager', 1, '', '', '', 'fa fa-codepen', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (205, 204, '流程设计器', 'ContractDesign', 2, '', '', '/graphic', 'fa fa-object-group', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (206, 204, '代码编辑器', 'codeEditorManager', 2, '', '', '/codeEditor', 'fa fa-pencil-square-o', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (207, 204, '流程管理', 'flowManager', 2, 'ProcessFlows', '', '/processFlows', 'fa fa-sitemap', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (208, 207, '查看流程管理列表', 'processFlowManager.viewProcessFlow', 3, '', 'ProcessFlow/GetPageProcessFlowList,ProcessFlow/Get', '', '', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (209, 207, '新增流程管理', 'processFlowManager.createProcessFlow', 3, '', 'ProcessFlow/CreateProcessFlow', '', '', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (210, 207, '编辑流程管理', 'processFlowManager.editProcessFlow', 3, '', 'ProcessFlow/UpdateProcessFlow', '', '', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');
INSERT INTO `sys_permission` VALUES (211, 207, '删除流程管理', 'processFlowManager.deleteProcessFlow', 3, '', 'ProcessFlow/DeleteProcessFlowById', '', '', b'0', NULL, b'1', b'1', b'1', b'1', 0, '', NULL, NULL, 0, NULL, NULL, 0, '0001-01-01 00:00:00.000');

-- ----------------------------
-- Table structure for sys_role
-- ----------------------------
DROP TABLE IF EXISTS `sys_role`;
CREATE TABLE `sys_role`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `Name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '名称',
  `IsActive` tinyint(4) NULL DEFAULT NULL COMMENT '启用',
  `Memoni` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '助记符',
  `Sort` int(11) NULL DEFAULT NULL COMMENT '排序',
  `IsDeleted` tinyint(4) NULL DEFAULT NULL COMMENT '删除标记',
  `LastModificationTime` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `LastModifierUserId` bigint(20) NULL DEFAULT NULL COMMENT '修改人',
  `OrgId` int(11) NULL DEFAULT NULL COMMENT '组织',
  `TenantId` int(11) NULL DEFAULT NULL,
  PRIMARY KEY (`Id`) USING BTREE,
  INDEX `Id`(`Id`) USING BTREE,
  INDEX `Id_2`(`Id`) USING BTREE,
  INDEX `Id_3`(`Id`) USING BTREE,
  INDEX `Id_4`(`Id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 3 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '用户角色' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_role
-- ----------------------------
INSERT INTO `sys_role` VALUES (1, '超级管理员', 0, 'superAdmin', 111, 0, '2021-05-04 12:53:12', 0, NULL, 1);
INSERT INTO `sys_role` VALUES (2, '运维管理员', 0, '222', 2, 0, '2021-05-04 12:53:03', 0, NULL, 1);

-- ----------------------------
-- Table structure for sys_rolepermission
-- ----------------------------
DROP TABLE IF EXISTS `sys_rolepermission`;
CREATE TABLE `sys_rolepermission`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `RoleId` bigint(20) NOT NULL COMMENT '角色Id',
  `PermissionId` bigint(20) NOT NULL COMMENT '权限Id',
  `CreatorUserId` bigint(20) NULL DEFAULT NULL COMMENT '创建者Id',
  `CreationTime` datetime(3) NULL DEFAULT NULL COMMENT '创建时间',
  PRIMARY KEY (`Id`) USING BTREE,
  UNIQUE INDEX `idx_ad_role_permission_01`(`RoleId`, `PermissionId`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1800 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci COMMENT = '角色权限' ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_rolepermission
-- ----------------------------
INSERT INTO `sys_rolepermission` VALUES (1334, 2, 111, 1, '2022-01-18 21:11:32.030');
INSERT INTO `sys_rolepermission` VALUES (1335, 2, 113, 1, '2022-01-18 21:11:32.030');
INSERT INTO `sys_rolepermission` VALUES (1336, 2, 126, 1, '2022-01-18 21:11:32.031');
INSERT INTO `sys_rolepermission` VALUES (1337, 2, 114, 1, '2022-01-18 21:11:32.031');
INSERT INTO `sys_rolepermission` VALUES (1338, 2, 125, 1, '2022-01-18 21:11:32.031');
INSERT INTO `sys_rolepermission` VALUES (1339, 2, 130, 1, '2022-01-18 21:11:32.031');
INSERT INTO `sys_rolepermission` VALUES (1340, 2, 137, 1, '2022-01-18 21:11:32.031');
INSERT INTO `sys_rolepermission` VALUES (1341, 2, 116, 1, '2022-01-18 21:11:32.032');
INSERT INTO `sys_rolepermission` VALUES (1342, 2, 117, 1, '2022-01-18 21:11:32.032');
INSERT INTO `sys_rolepermission` VALUES (1343, 2, 138, 1, '2022-01-18 21:11:32.032');
INSERT INTO `sys_rolepermission` VALUES (1344, 2, 112, 1, '2022-01-18 21:11:32.032');
INSERT INTO `sys_rolepermission` VALUES (1345, 2, 119, 1, '2022-01-18 21:11:32.033');
INSERT INTO `sys_rolepermission` VALUES (1346, 2, 115, 1, '2022-01-18 21:11:32.033');
INSERT INTO `sys_rolepermission` VALUES (1347, 2, 135, 1, '2022-01-18 21:11:32.033');
INSERT INTO `sys_rolepermission` VALUES (1348, 2, 136, 1, '2022-01-18 21:11:32.034');
INSERT INTO `sys_rolepermission` VALUES (1349, 2, 139, 1, '2022-01-18 21:11:32.034');
INSERT INTO `sys_rolepermission` VALUES (1350, 2, 140, 1, '2022-01-18 21:11:32.034');
INSERT INTO `sys_rolepermission` VALUES (1351, 2, 141, 1, '2022-01-18 21:11:32.035');
INSERT INTO `sys_rolepermission` VALUES (1352, 2, 142, 1, '2022-01-18 21:11:32.035');
INSERT INTO `sys_rolepermission` VALUES (1353, 2, 143, 1, '2022-01-18 21:11:32.035');
INSERT INTO `sys_rolepermission` VALUES (1354, 2, 146, 1, '2022-01-18 21:11:32.035');
INSERT INTO `sys_rolepermission` VALUES (1355, 2, 147, 1, '2022-01-18 21:11:32.036');
INSERT INTO `sys_rolepermission` VALUES (1747, 1, 111, 1, '2022-05-31 11:37:41.098');
INSERT INTO `sys_rolepermission` VALUES (1748, 1, 113, 1, '2022-05-31 11:37:41.157');
INSERT INTO `sys_rolepermission` VALUES (1749, 1, 126, 1, '2022-05-31 11:37:41.234');
INSERT INTO `sys_rolepermission` VALUES (1750, 1, 127, 1, '2022-05-31 11:37:41.295');
INSERT INTO `sys_rolepermission` VALUES (1751, 1, 128, 1, '2022-05-31 11:37:41.341');
INSERT INTO `sys_rolepermission` VALUES (1752, 1, 129, 1, '2022-05-31 11:37:41.387');
INSERT INTO `sys_rolepermission` VALUES (1753, 1, 114, 1, '2022-05-31 11:37:41.445');
INSERT INTO `sys_rolepermission` VALUES (1754, 1, 122, 1, '2022-05-31 11:37:41.497');
INSERT INTO `sys_rolepermission` VALUES (1755, 1, 123, 1, '2022-05-31 11:37:41.554');
INSERT INTO `sys_rolepermission` VALUES (1756, 1, 124, 1, '2022-05-31 11:37:41.600');
INSERT INTO `sys_rolepermission` VALUES (1757, 1, 125, 1, '2022-05-31 11:37:41.665');
INSERT INTO `sys_rolepermission` VALUES (1758, 1, 130, 1, '2022-05-31 11:37:41.722');
INSERT INTO `sys_rolepermission` VALUES (1759, 1, 131, 1, '2022-05-31 11:37:41.774');
INSERT INTO `sys_rolepermission` VALUES (1760, 1, 137, 1, '2022-05-31 11:37:41.830');
INSERT INTO `sys_rolepermission` VALUES (1761, 1, 116, 1, '2022-05-31 11:37:41.899');
INSERT INTO `sys_rolepermission` VALUES (1762, 1, 117, 1, '2022-05-31 11:37:41.951');
INSERT INTO `sys_rolepermission` VALUES (1763, 1, 138, 1, '2022-05-31 11:37:42.002');
INSERT INTO `sys_rolepermission` VALUES (1764, 1, 200, 1, '2022-05-31 11:37:42.052');
INSERT INTO `sys_rolepermission` VALUES (1765, 1, 201, 1, '2022-05-31 11:37:42.112');
INSERT INTO `sys_rolepermission` VALUES (1766, 1, 202, 1, '2022-05-31 11:37:42.179');
INSERT INTO `sys_rolepermission` VALUES (1767, 1, 203, 1, '2022-05-31 11:37:42.234');
INSERT INTO `sys_rolepermission` VALUES (1768, 1, 204, 1, '2022-05-31 11:37:42.286');
INSERT INTO `sys_rolepermission` VALUES (1769, 1, 205, 1, '2022-05-31 11:37:42.351');
INSERT INTO `sys_rolepermission` VALUES (1770, 1, 206, 1, '2022-05-31 11:37:42.400');
INSERT INTO `sys_rolepermission` VALUES (1771, 1, 207, 1, '2022-05-31 11:37:42.456');
INSERT INTO `sys_rolepermission` VALUES (1772, 1, 208, 1, '2022-05-31 11:37:42.514');
INSERT INTO `sys_rolepermission` VALUES (1773, 1, 209, 1, '2022-05-31 11:37:42.574');
INSERT INTO `sys_rolepermission` VALUES (1774, 1, 210, 1, '2022-05-31 11:37:42.627');
INSERT INTO `sys_rolepermission` VALUES (1775, 1, 211, 1, '2022-05-31 11:37:42.683');
INSERT INTO `sys_rolepermission` VALUES (1776, 1, 112, 1, '2022-05-31 11:37:42.742');
INSERT INTO `sys_rolepermission` VALUES (1777, 1, 118, 1, '2022-05-31 11:37:42.795');
INSERT INTO `sys_rolepermission` VALUES (1778, 1, 119, 1, '2022-05-31 11:37:42.849');
INSERT INTO `sys_rolepermission` VALUES (1779, 1, 120, 1, '2022-05-31 11:37:42.913');
INSERT INTO `sys_rolepermission` VALUES (1780, 1, 121, 1, '2022-05-31 11:37:42.980');
INSERT INTO `sys_rolepermission` VALUES (1781, 1, 115, 1, '2022-05-31 11:37:43.031');
INSERT INTO `sys_rolepermission` VALUES (1782, 1, 132, 1, '2022-05-31 11:37:43.080');
INSERT INTO `sys_rolepermission` VALUES (1783, 1, 133, 1, '2022-05-31 11:37:43.137');
INSERT INTO `sys_rolepermission` VALUES (1784, 1, 134, 1, '2022-05-31 11:37:43.198');
INSERT INTO `sys_rolepermission` VALUES (1785, 1, 135, 1, '2022-05-31 11:37:43.249');
INSERT INTO `sys_rolepermission` VALUES (1786, 1, 136, 1, '2022-05-31 11:37:43.300');
INSERT INTO `sys_rolepermission` VALUES (1787, 1, 139, 1, '2022-05-31 11:37:43.365');
INSERT INTO `sys_rolepermission` VALUES (1788, 1, 140, 1, '2022-05-31 11:37:43.423');
INSERT INTO `sys_rolepermission` VALUES (1789, 1, 141, 1, '2022-05-31 11:37:43.474');
INSERT INTO `sys_rolepermission` VALUES (1790, 1, 142, 1, '2022-05-31 11:37:43.525');
INSERT INTO `sys_rolepermission` VALUES (1791, 1, 143, 1, '2022-05-31 11:37:43.583');
INSERT INTO `sys_rolepermission` VALUES (1792, 1, 145, 1, '2022-05-31 11:37:43.637');
INSERT INTO `sys_rolepermission` VALUES (1793, 1, 146, 1, '2022-05-31 11:37:43.688');
INSERT INTO `sys_rolepermission` VALUES (1794, 1, 147, 1, '2022-05-31 11:37:43.738');
INSERT INTO `sys_rolepermission` VALUES (1795, 1, 195, 1, '2022-05-31 11:37:43.794');
INSERT INTO `sys_rolepermission` VALUES (1796, 1, 196, 1, '2022-05-31 11:37:43.856');
INSERT INTO `sys_rolepermission` VALUES (1797, 1, 197, 1, '2022-05-31 11:37:43.910');
INSERT INTO `sys_rolepermission` VALUES (1798, 1, 198, 1, '2022-05-31 11:37:43.970');
INSERT INTO `sys_rolepermission` VALUES (1799, 1, 199, 1, '2022-05-31 11:37:44.036');

-- ----------------------------
-- Table structure for sys_tenant
-- ----------------------------
DROP TABLE IF EXISTS `sys_tenant`;
CREATE TABLE `sys_tenant`  (
  `TenantName` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '租户名称',
  `DbType` int(11) NULL DEFAULT NULL COMMENT '数据库类别',
  `DbConnectionString` varchar(300) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '数据库连接字符串',
  `IsDefaultTenant` bit(1) NULL DEFAULT NULL COMMENT '是否默认租户',
  `CreatorUserId` bigint(20) NULL DEFAULT NULL COMMENT ' 创建ID',
  `CreationTime` datetime(0) NULL DEFAULT NULL COMMENT ' 创建时间',
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `IsActive` bit(1) NULL DEFAULT NULL COMMENT '是否启用标识',
  `IsDeleted` bit(1) NULL DEFAULT NULL COMMENT ' 是否删除标识',
  `TenantId` int(11) NULL DEFAULT NULL COMMENT '租户Id',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 10 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_tenant
-- ----------------------------
INSERT INTO `sys_tenant` VALUES (NULL, 0, 'aaa', b'0', 0, NULL, 1, NULL, NULL, 1);
INSERT INTO `sys_tenant` VALUES (NULL, 0, 'bb', b'0', 0, NULL, 2, NULL, NULL, 2);
INSERT INTO `sys_tenant` VALUES (NULL, 0, 'aaa', b'0', 0, NULL, 3, NULL, NULL, 1);
INSERT INTO `sys_tenant` VALUES (NULL, 0, 'bb', b'0', 0, NULL, 4, NULL, NULL, 2);
INSERT INTO `sys_tenant` VALUES (NULL, 0, 'aaa', b'0', 0, NULL, 5, NULL, NULL, 1);
INSERT INTO `sys_tenant` VALUES (NULL, 0, 'bb', b'0', 0, NULL, 6, NULL, NULL, 2);
INSERT INTO `sys_tenant` VALUES (NULL, 0, 'aaa', b'0', 0, NULL, 7, NULL, NULL, 1);
INSERT INTO `sys_tenant` VALUES (NULL, 0, 'aaa', b'0', 0, NULL, 8, NULL, NULL, 1);
INSERT INTO `sys_tenant` VALUES (NULL, 0, 'aaa', b'0', 0, NULL, 9, NULL, NULL, 1);

-- ----------------------------
-- Table structure for sys_user
-- ----------------------------
DROP TABLE IF EXISTS `sys_user`;
CREATE TABLE `sys_user`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '编号',
  `NO` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '员工编号',
  `Name` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '员工名称',
  `Account` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '登录账号',
  `Password` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NOT NULL COMMENT '密码',
  `Sex` tinyint(4) NULL DEFAULT NULL COMMENT '性别',
  `Mobile` varchar(16) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '手机号码',
  `Email` varchar(64) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '信箱',
  `Remark` varchar(128) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '备注',
  `IsActive` tinyint(4) NULL DEFAULT NULL COMMENT '启用',
  `LoginCount` int(11) NULL DEFAULT NULL COMMENT '登录次数',
  `Memoni` varchar(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '助记符',
  `IsDeleted` tinyint(4) NULL DEFAULT NULL COMMENT '删除标记',
  `OrgId` int(11) NULL DEFAULT NULL COMMENT '组织',
  `LastModificationTime` datetime(0) NULL DEFAULT NULL COMMENT '修改时间',
  `ModifyUserId` int(11) NULL DEFAULT NULL COMMENT '修改人',
  `UserType` tinyint(4) NULL DEFAULT NULL,
  `InterDepartmental` tinyint(4) NULL DEFAULT NULL COMMENT '跨部门数据查看',
  `LastModifierUserId` bigint(20) NULL DEFAULT NULL,
  `DeletionTime` datetime(0) NULL DEFAULT NULL,
  `DeleterUserId` int(11) NULL DEFAULT NULL,
  `CreationTime` datetime(0) NULL DEFAULT NULL,
  `CreatorUserId` bigint(20) UNSIGNED ZEROFILL NULL DEFAULT NULL,
  `TenantId` int(11) NULL DEFAULT NULL,
  `Avatar` varchar(500) CHARACTER SET utf8mb4 COLLATE utf8mb4_general_ci NULL DEFAULT NULL COMMENT '头像',
  PRIMARY KEY (`Id`) USING BTREE,
  INDEX `Id`(`Id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 45 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_user
-- ----------------------------
INSERT INTO `sys_user` VALUES (1, 'admin', '超级管理员', 'admin', 'e10adc3949ba59abbe56e057f20f883e', 0, '13699856947', '1@qq.con', 'abc', 1, 6, '234', 0, NULL, '2021-05-04 13:17:00', 1, 0, NULL, 0, NULL, 0, NULL, 00000000000000000000, 1, '/Uploads/2022/202201/20220122/220122055050135264.PNG');
INSERT INTO `sys_user` VALUES (29, NULL, '222', 'aaaaa', 'e10adc3949ba59abbe56e057f20f883e', 0, '13699854789', 'aaaa@wq.com', 'aaaaa', 0, NULL, NULL, 0, NULL, '2021-05-04 13:17:32', NULL, NULL, NULL, 0, NULL, 0, '2021-04-27 16:01:40', 00000000000000000001, 2, NULL);
INSERT INTO `sys_user` VALUES (44, NULL, 'test', 'test', 'e10adc3949ba59abbe56e057f20f883e', 0, '13688745895', 'test@qq.com', '斯蒂芬斯蒂芬', NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, NULL, 0, NULL, 0, NULL, 00000000000000000000, 2, '/Uploads/2022/202201/20220122/220122063518215840.jpg');

-- ----------------------------
-- Table structure for sys_usersysorganization
-- ----------------------------
DROP TABLE IF EXISTS `sys_usersysorganization`;
CREATE TABLE `sys_usersysorganization`  (
  `Id` bigint(20) NOT NULL AUTO_INCREMENT COMMENT '主键Id',
  `SysUser_ID` int(11) NULL DEFAULT NULL COMMENT '用户Id',
  `SysOrganization_ID` int(11) NULL DEFAULT NULL COMMENT '组织Id',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 1 CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_usersysorganization
-- ----------------------------

-- ----------------------------
-- Table structure for sys_usersysrole
-- ----------------------------
DROP TABLE IF EXISTS `sys_usersysrole`;
CREATE TABLE `sys_usersysrole`  (
  `SysRole_ID` bigint(20) NOT NULL,
  `SysUser_ID` bigint(20) NOT NULL,
  `SysRole_Type` bigint(20) NULL DEFAULT NULL,
  `Id` bigint(20) NOT NULL AUTO_INCREMENT,
  PRIMARY KEY (`Id`) USING BTREE,
  INDEX `FK_SYSUSERS_REFERENCE_SYSUSER`(`SysUser_ID`) USING BTREE
) ENGINE = InnoDB AUTO_INCREMENT = 16 CHARACTER SET = utf8mb4 COLLATE = utf8mb4_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of sys_usersysrole
-- ----------------------------
INSERT INTO `sys_usersysrole` VALUES (2, 29, 0, 12);
INSERT INTO `sys_usersysrole` VALUES (2, 44, 0, 13);
INSERT INTO `sys_usersysrole` VALUES (1, 1, 0, 14);
INSERT INTO `sys_usersysrole` VALUES (2, 1, 0, 15);

-- ----------------------------
-- Table structure for wf_processflow
-- ----------------------------
DROP TABLE IF EXISTS `wf_processflow`;
CREATE TABLE `wf_processflow`  (
  `FlowContent` text CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程内容',
  `Type` int(11) NULL DEFAULT NULL COMMENT '流程类别',
  `Name` varchar(50) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT '流程名称',
  `Enabled` bit(1) NULL DEFAULT NULL COMMENT '状态',
  `CreatorUserId` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NULL DEFAULT NULL COMMENT ' 创建ID',
  `CreationTime` datetime(0) NULL DEFAULT NULL COMMENT ' 创建时间',
  `Id` varchar(100) CHARACTER SET utf8 COLLATE utf8_general_ci NOT NULL COMMENT '主键Id',
  `IsActive` bit(1) NULL DEFAULT NULL COMMENT '是否启用标识',
  `IsDeleted` bit(1) NULL DEFAULT NULL COMMENT ' 是否删除标识',
  `TenantId` int(11) NULL DEFAULT NULL COMMENT '租户Id',
  PRIMARY KEY (`Id`) USING BTREE
) ENGINE = InnoDB CHARACTER SET = utf8 COLLATE = utf8_general_ci ROW_FORMAT = Dynamic;

-- ----------------------------
-- Records of wf_processflow
-- ----------------------------
INSERT INTO `wf_processflow` VALUES ('{\r\n  \"nodes\": [\r\n    {\r\n      \"position\": {\r\n        \"x\": 133,\r\n        \"y\": 267\r\n      },\r\n      \"size\": {\r\n        \"width\": 40,\r\n        \"height\": 40\r\n      },\r\n      \"attrs\": {\r\n        \"text\": {\r\n          \"text\": \"开始\"\r\n        }\r\n      },\r\n      \"shape\": \"event\",\r\n      \"ports\": {\r\n        \"groups\": {\r\n          \"top\": {\r\n            \"position\": \"top\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"right\": {\r\n            \"position\": \"right\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"bottom\": {\r\n            \"position\": \"bottom\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"left\": {\r\n            \"position\": \"left\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          }\r\n        },\r\n        \"items\": [\r\n          {\r\n            \"group\": \"top\",\r\n            \"id\": \"7ecbee36-1db3-4de1-9fb5-7c067b83313d\"\r\n          },\r\n          {\r\n            \"group\": \"right\",\r\n            \"id\": \"c396fd7e-00af-4992-9551-25d3662352fe\"\r\n          },\r\n          {\r\n            \"group\": \"bottom\",\r\n            \"id\": \"f292454a-7a24-4e87-a05b-652e5429a05d\"\r\n          },\r\n          {\r\n            \"group\": \"left\",\r\n            \"id\": \"e8e0ec17-5274-4919-9afa-9f41c00cbea3\"\r\n          }\r\n        ]\r\n      },\r\n      \"id\": \"b2a92ac5-62a4-4fa5-91d9-c9b6919cef7c\",\r\n      \"zIndex\": 2\r\n    },\r\n    {\r\n      \"position\": {\r\n        \"x\": 276,\r\n        \"y\": 264.5\r\n      },\r\n      \"size\": {\r\n        \"width\": 80,\r\n        \"height\": 45\r\n      },\r\n      \"attrs\": {\r\n        \"text\": {\r\n          \"text\": \"养殖场\"\r\n        }\r\n      },\r\n      \"shape\": \"activity\",\r\n      \"ports\": {\r\n        \"groups\": {\r\n          \"top\": {\r\n            \"position\": \"top\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"right\": {\r\n            \"position\": \"right\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"bottom\": {\r\n            \"position\": \"bottom\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"left\": {\r\n            \"position\": \"left\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          }\r\n        },\r\n        \"items\": [\r\n          {\r\n            \"group\": \"top\",\r\n            \"id\": \"cebb91c4-a82c-4363-976e-b7af11b410e9\"\r\n          },\r\n          {\r\n            \"group\": \"right\",\r\n            \"id\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n          },\r\n          {\r\n            \"group\": \"bottom\",\r\n            \"id\": \"0d591cf7-3674-4d48-9538-517d4f9cddb8\"\r\n          },\r\n          {\r\n            \"group\": \"left\",\r\n            \"id\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n          }\r\n        ]\r\n      },\r\n      \"id\": \"47119a01-80ad-4050-b23b-2fcffe7a9d2a\",\r\n      \"zIndex\": 3\r\n    },\r\n    {\r\n      \"position\": {\r\n        \"x\": 448,\r\n        \"y\": 267\r\n      },\r\n      \"size\": {\r\n        \"width\": 90,\r\n        \"height\": 40\r\n      },\r\n      \"attrs\": {\r\n        \"text\": {\r\n          \"text\": \"xx物流运输\"\r\n        }\r\n      },\r\n      \"shape\": \"activity\",\r\n      \"ports\": {\r\n        \"groups\": {\r\n          \"top\": {\r\n            \"position\": \"top\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"right\": {\r\n            \"position\": \"right\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"bottom\": {\r\n            \"position\": \"bottom\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"left\": {\r\n            \"position\": \"left\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          }\r\n        },\r\n        \"items\": [\r\n          {\r\n            \"group\": \"top\",\r\n            \"id\": \"cebb91c4-a82c-4363-976e-b7af11b410e9\"\r\n          },\r\n          {\r\n            \"group\": \"right\",\r\n            \"id\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n          },\r\n          {\r\n            \"group\": \"bottom\",\r\n            \"id\": \"0d591cf7-3674-4d48-9538-517d4f9cddb8\"\r\n          },\r\n          {\r\n            \"group\": \"left\",\r\n            \"id\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n          }\r\n        ]\r\n      },\r\n      \"id\": \"3dba7720-9fd8-4f9f-9d36-642f5899e2de\",\r\n      \"zIndex\": 4\r\n    },\r\n    {\r\n      \"position\": {\r\n        \"x\": 610,\r\n        \"y\": 264.5\r\n      },\r\n      \"size\": {\r\n        \"width\": 80,\r\n        \"height\": 45\r\n      },\r\n      \"attrs\": {\r\n        \"text\": {\r\n          \"text\": \"屠宰场\"\r\n        }\r\n      },\r\n      \"shape\": \"activity\",\r\n      \"ports\": {\r\n        \"groups\": {\r\n          \"top\": {\r\n            \"position\": \"top\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"right\": {\r\n            \"position\": \"right\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"bottom\": {\r\n            \"position\": \"bottom\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"left\": {\r\n            \"position\": \"left\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          }\r\n        },\r\n        \"items\": [\r\n          {\r\n            \"group\": \"top\",\r\n            \"id\": \"cebb91c4-a82c-4363-976e-b7af11b410e9\"\r\n          },\r\n          {\r\n            \"group\": \"right\",\r\n            \"id\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n          },\r\n          {\r\n            \"group\": \"bottom\",\r\n            \"id\": \"0d591cf7-3674-4d48-9538-517d4f9cddb8\"\r\n          },\r\n          {\r\n            \"group\": \"left\",\r\n            \"id\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n          }\r\n        ]\r\n      },\r\n      \"id\": \"7f36c577-1619-49d0-a8ee-b157cc39620e\",\r\n      \"zIndex\": 5\r\n    },\r\n    {\r\n      \"position\": {\r\n        \"x\": 772,\r\n        \"y\": 264.5\r\n      },\r\n      \"size\": {\r\n        \"width\": 80,\r\n        \"height\": 45\r\n      },\r\n      \"attrs\": {\r\n        \"text\": {\r\n          \"text\": \"xx物流运输\"\r\n        }\r\n      },\r\n      \"shape\": \"activity\",\r\n      \"ports\": {\r\n        \"groups\": {\r\n          \"top\": {\r\n            \"position\": \"top\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"right\": {\r\n            \"position\": \"right\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"bottom\": {\r\n            \"position\": \"bottom\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"left\": {\r\n            \"position\": \"left\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          }\r\n        },\r\n        \"items\": [\r\n          {\r\n            \"group\": \"top\",\r\n            \"id\": \"cebb91c4-a82c-4363-976e-b7af11b410e9\"\r\n          },\r\n          {\r\n            \"group\": \"right\",\r\n            \"id\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n          },\r\n          {\r\n            \"group\": \"bottom\",\r\n            \"id\": \"0d591cf7-3674-4d48-9538-517d4f9cddb8\"\r\n          },\r\n          {\r\n            \"group\": \"left\",\r\n            \"id\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n          }\r\n        ]\r\n      },\r\n      \"id\": \"4bfa3ff8-2ce7-403a-ab34-dc436da71f38\",\r\n      \"zIndex\": 6\r\n    },\r\n    {\r\n      \"position\": {\r\n        \"x\": 924,\r\n        \"y\": 262\r\n      },\r\n      \"size\": {\r\n        \"width\": 110,\r\n        \"height\": 50\r\n      },\r\n      \"attrs\": {\r\n        \"text\": {\r\n          \"text\": \"生鲜超市售卖\"\r\n        }\r\n      },\r\n      \"shape\": \"activity\",\r\n      \"ports\": {\r\n        \"groups\": {\r\n          \"top\": {\r\n            \"position\": \"top\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"right\": {\r\n            \"position\": \"right\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"bottom\": {\r\n            \"position\": \"bottom\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"left\": {\r\n            \"position\": \"left\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          }\r\n        },\r\n        \"items\": [\r\n          {\r\n            \"group\": \"top\",\r\n            \"id\": \"cebb91c4-a82c-4363-976e-b7af11b410e9\"\r\n          },\r\n          {\r\n            \"group\": \"right\",\r\n            \"id\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n          },\r\n          {\r\n            \"group\": \"bottom\",\r\n            \"id\": \"0d591cf7-3674-4d48-9538-517d4f9cddb8\"\r\n          },\r\n          {\r\n            \"group\": \"left\",\r\n            \"id\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n          }\r\n        ]\r\n      },\r\n      \"id\": \"cf40b609-4581-4860-9ad1-09a4a77ba42b\",\r\n      \"zIndex\": 7\r\n    },\r\n    {\r\n      \"position\": {\r\n        \"x\": 1089,\r\n        \"y\": 267\r\n      },\r\n      \"size\": {\r\n        \"width\": 40,\r\n        \"height\": 40\r\n      },\r\n      \"attrs\": {\r\n        \"text\": {\r\n          \"text\": \"结束\"\r\n        }\r\n      },\r\n      \"shape\": \"event\",\r\n      \"ports\": {\r\n        \"groups\": {\r\n          \"top\": {\r\n            \"position\": \"top\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"right\": {\r\n            \"position\": \"right\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"bottom\": {\r\n            \"position\": \"bottom\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          },\r\n          \"left\": {\r\n            \"position\": \"left\",\r\n            \"attrs\": {\r\n              \"circle\": {\r\n                \"r\": 4,\r\n                \"magnet\": true,\r\n                \"stroke\": \"#5F95FF\",\r\n                \"strokeWidth\": 1,\r\n                \"fill\": \"#fff\",\r\n                \"style\": {\r\n                  \"visibility\": \"hidden\"\r\n                }\r\n              }\r\n            }\r\n          }\r\n        },\r\n        \"items\": [\r\n          {\r\n            \"group\": \"top\",\r\n            \"id\": \"7ecbee36-1db3-4de1-9fb5-7c067b83313d\"\r\n          },\r\n          {\r\n            \"group\": \"right\",\r\n            \"id\": \"c396fd7e-00af-4992-9551-25d3662352fe\"\r\n          },\r\n          {\r\n            \"group\": \"bottom\",\r\n            \"id\": \"f292454a-7a24-4e87-a05b-652e5429a05d\"\r\n          },\r\n          {\r\n            \"group\": \"left\",\r\n            \"id\": \"e8e0ec17-5274-4919-9afa-9f41c00cbea3\"\r\n          }\r\n        ]\r\n      },\r\n      \"id\": \"1ae83b38-66a1-47db-90bf-396674830e9b\",\r\n      \"zIndex\": 8\r\n    }\r\n  ],\r\n  \"edges\": [\r\n    {\r\n      \"shape\": \"edge\",\r\n      \"attrs\": {\r\n        \"line\": {\r\n          \"stroke\": \"#A2B1C3\",\r\n          \"targetMarker\": {\r\n            \"name\": \"block\",\r\n            \"width\": 12,\r\n            \"height\": 8\r\n          }\r\n        }\r\n      },\r\n      \"id\": \"3e58de41-17d3-4c00-a514-373defc8dbb8\",\r\n      \"zIndex\": 0,\r\n      \"source\": {\r\n        \"cell\": \"b2a92ac5-62a4-4fa5-91d9-c9b6919cef7c\",\r\n        \"port\": \"c396fd7e-00af-4992-9551-25d3662352fe\"\r\n      },\r\n      \"target\": {\r\n        \"cell\": \"47119a01-80ad-4050-b23b-2fcffe7a9d2a\",\r\n        \"port\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n      }\r\n    },\r\n    {\r\n      \"shape\": \"edge\",\r\n      \"attrs\": {\r\n        \"line\": {\r\n          \"stroke\": \"#A2B1C3\",\r\n          \"targetMarker\": {\r\n            \"name\": \"block\",\r\n            \"width\": 12,\r\n            \"height\": 8\r\n          }\r\n        }\r\n      },\r\n      \"id\": \"23894bde-e9a3-44a1-919b-4ac998d693bc\",\r\n      \"zIndex\": 0,\r\n      \"source\": {\r\n        \"cell\": \"47119a01-80ad-4050-b23b-2fcffe7a9d2a\",\r\n        \"port\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n      },\r\n      \"target\": {\r\n        \"cell\": \"3dba7720-9fd8-4f9f-9d36-642f5899e2de\",\r\n        \"port\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n      }\r\n    },\r\n    {\r\n      \"shape\": \"edge\",\r\n      \"attrs\": {\r\n        \"line\": {\r\n          \"stroke\": \"#A2B1C3\",\r\n          \"targetMarker\": {\r\n            \"name\": \"block\",\r\n            \"width\": 12,\r\n            \"height\": 8\r\n          }\r\n        }\r\n      },\r\n      \"id\": \"495c9ed3-69ed-463e-90cc-8f96d49a9e67\",\r\n      \"zIndex\": 0,\r\n      \"source\": {\r\n        \"cell\": \"3dba7720-9fd8-4f9f-9d36-642f5899e2de\",\r\n        \"port\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n      },\r\n      \"target\": {\r\n        \"cell\": \"7f36c577-1619-49d0-a8ee-b157cc39620e\",\r\n        \"port\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n      }\r\n    },\r\n    {\r\n      \"shape\": \"edge\",\r\n      \"attrs\": {\r\n        \"line\": {\r\n          \"stroke\": \"#A2B1C3\",\r\n          \"targetMarker\": {\r\n            \"name\": \"block\",\r\n            \"width\": 12,\r\n            \"height\": 8\r\n          }\r\n        }\r\n      },\r\n      \"id\": \"da54d324-33f1-4eab-ab33-1d334a8d4906\",\r\n      \"zIndex\": 0,\r\n      \"source\": {\r\n        \"cell\": \"7f36c577-1619-49d0-a8ee-b157cc39620e\",\r\n        \"port\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n      },\r\n      \"target\": {\r\n        \"cell\": \"4bfa3ff8-2ce7-403a-ab34-dc436da71f38\",\r\n        \"port\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n      }\r\n    },\r\n    {\r\n      \"shape\": \"edge\",\r\n      \"attrs\": {\r\n        \"line\": {\r\n          \"stroke\": \"#A2B1C3\",\r\n          \"targetMarker\": {\r\n            \"name\": \"block\",\r\n            \"width\": 12,\r\n            \"height\": 8\r\n          }\r\n        }\r\n      },\r\n      \"id\": \"2294cb43-6735-4056-b590-cdddde25c358\",\r\n      \"zIndex\": 0,\r\n      \"source\": {\r\n        \"cell\": \"4bfa3ff8-2ce7-403a-ab34-dc436da71f38\",\r\n        \"port\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n      },\r\n      \"target\": {\r\n        \"cell\": \"cf40b609-4581-4860-9ad1-09a4a77ba42b\",\r\n        \"port\": \"89268530-b684-4cd6-94b8-0b7a9ccf0941\"\r\n      }\r\n    },\r\n    {\r\n      \"shape\": \"edge\",\r\n      \"attrs\": {\r\n        \"line\": {\r\n          \"stroke\": \"#A2B1C3\",\r\n          \"targetMarker\": {\r\n            \"name\": \"block\",\r\n            \"width\": 12,\r\n            \"height\": 8\r\n          }\r\n        }\r\n      },\r\n      \"id\": \"fcfaa9f4-088d-44b5-a6f4-8628809f744e\",\r\n      \"zIndex\": 0,\r\n      \"source\": {\r\n        \"cell\": \"cf40b609-4581-4860-9ad1-09a4a77ba42b\",\r\n        \"port\": \"01cd4194-7f80-4537-b0d9-9e897d073e58\"\r\n      },\r\n      \"target\": {\r\n        \"cell\": \"1ae83b38-66a1-47db-90bf-396674830e9b\",\r\n        \"port\": \"e8e0ec17-5274-4919-9afa-9f41c00cbea3\"\r\n      }\r\n    }\r\n  ]\r\n}', 0, '食品溯源存证流程', b'1', NULL, NULL, '6305bc11235a6231f8953993', NULL, NULL, NULL);
INSERT INTO `wf_processflow` VALUES ('{\n    \"nodes\": [\n        {\n            \"position\": {\n                \"x\": 200,\n                \"y\": 290\n            },\n            \"size\": {\n                \"width\": 40,\n                \"height\": 40\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"开始\"\n                }\n            },\n            \"shape\": \"event\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"65b8ce12-5f8e-4c76-acc1-2000c8a5aa42\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"b53b2a75-6a0c-498f-a562-46d048afec73\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"2a87e05d-d775-4c62-b90b-de58d5ea36fc\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"660b9657-668b-44d3-8cc6-5822068dd527\"\n                    }\n                ]\n            },\n            \"id\": \"22977462-60ef-49c8-8a03-8122b35b0bae\",\n            \"zIndex\": 1\n        },\n        {\n            \"position\": {\n                \"x\": 345,\n                \"y\": 288\n            },\n            \"size\": {\n                \"width\": 80,\n                \"height\": 45\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"证据hash\"\n                }\n            },\n            \"shape\": \"activity\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"0dc84bee-14c3-4b4c-b9d6-e71dd9c5e9f5\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"b67d01df-3ee4-4ee9-b4ab-19f28be10efa\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"1bf563ee-a1da-4e00-a7a3-0803bde38dab\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"1bd0f30e-f3c6-4c30-a1f4-4f87cd25e296\"\n                    }\n                ]\n            },\n            \"id\": \"2f3a5370-8dbb-4359-bbe8-c22166ec274f\",\n            \"description\": \"描述文本xxxxxxxxxxx\",\n            \"zIndex\": 2\n        },\n        {\n            \"position\": {\n                \"x\": 487,\n                \"y\": 288\n            },\n            \"size\": {\n                \"width\": 80,\n                \"height\": 45\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"公证处公正\"\n                }\n            },\n            \"shape\": \"activity\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"0dc84bee-14c3-4b4c-b9d6-e71dd9c5e9f5\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"b67d01df-3ee4-4ee9-b4ab-19f28be10efa\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"1bf563ee-a1da-4e00-a7a3-0803bde38dab\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"1bd0f30e-f3c6-4c30-a1f4-4f87cd25e296\"\n                    }\n                ]\n            },\n            \"id\": \"2dd256ce-9a85-47d3-bc69-05659a141dea\",\n            \"description\": \"描述文本xxxxxxxxxxx\",\n            \"zIndex\": 3\n        },\n        {\n            \"position\": {\n                \"x\": 679,\n                \"y\": 290\n            },\n            \"size\": {\n                \"width\": 40,\n                \"height\": 40\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"结束\"\n                }\n            },\n            \"shape\": \"event\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"65b8ce12-5f8e-4c76-acc1-2000c8a5aa42\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"b53b2a75-6a0c-498f-a562-46d048afec73\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"2a87e05d-d775-4c62-b90b-de58d5ea36fc\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"660b9657-668b-44d3-8cc6-5822068dd527\"\n                    }\n                ]\n            },\n            \"id\": \"be4d7c40-8f74-4dab-9603-5e5758d5caa0\",\n            \"zIndex\": 4\n        }\n    ],\n    \"edges\": [\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"839ee069-c089-4615-8e56-ec17dd43d2d1\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"22977462-60ef-49c8-8a03-8122b35b0bae\",\n                \"port\": \"b53b2a75-6a0c-498f-a562-46d048afec73\"\n            },\n            \"target\": {\n                \"cell\": \"2f3a5370-8dbb-4359-bbe8-c22166ec274f\",\n                \"port\": \"1bd0f30e-f3c6-4c30-a1f4-4f87cd25e296\"\n            }\n        },\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"606f8082-d8c0-452b-81a9-27bf582f314e\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"2f3a5370-8dbb-4359-bbe8-c22166ec274f\",\n                \"port\": \"b67d01df-3ee4-4ee9-b4ab-19f28be10efa\"\n            },\n            \"target\": {\n                \"cell\": \"2dd256ce-9a85-47d3-bc69-05659a141dea\",\n                \"port\": \"1bd0f30e-f3c6-4c30-a1f4-4f87cd25e296\"\n            }\n        },\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"90df4c4b-5685-477e-b308-e55cfba70916\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"2dd256ce-9a85-47d3-bc69-05659a141dea\",\n                \"port\": \"b67d01df-3ee4-4ee9-b4ab-19f28be10efa\"\n            },\n            \"target\": {\n                \"cell\": \"be4d7c40-8f74-4dab-9603-5e5758d5caa0\",\n                \"port\": \"660b9657-668b-44d3-8cc6-5822068dd527\"\n            }\n        }\n    ]\n}', 0, '司法取证', b'1', NULL, NULL, '6306321267755364c49ff96b', NULL, NULL, NULL);
INSERT INTO `wf_processflow` VALUES ('{\n    \"nodes\": [\n        {\n            \"position\": {\n                \"x\": 120,\n                \"y\": 300\n            },\n            \"size\": {\n                \"width\": 40,\n                \"height\": 40\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"开始\"\n                }\n            },\n            \"shape\": \"event\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"85df9211-0eb5-47a6-a3bb-95efb4bbc82f\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"3dccbbab-f397-4ad4-b393-777c607d503d\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"be62c979-cfd8-4d3a-b2d0-7ccb66cdbb4c\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"4a51b32b-223d-4c99-91b1-4f2fe6affbbf\"\n                    }\n                ]\n            },\n            \"id\": \"68769619-4c3a-4c6b-9e22-ba0b23852bcd\",\n            \"zIndex\": 1\n        },\n        {\n            \"position\": {\n                \"x\": 237,\n                \"y\": 295\n            },\n            \"size\": {\n                \"width\": 80,\n                \"height\": 45\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"公益售卖\"\n                }\n            },\n            \"shape\": \"activity\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"3aa51e4d-6677-4a60-90df-b8cda3819ecc\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"04d2f24d-c53a-4e5a-b586-7d9dcfdcd9a2\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"b519158d-0c4f-4e53-aa0c-7637ee85784a\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"dc294ef6-db7f-45f7-94c1-f25a8349644f\"\n                    }\n                ]\n            },\n            \"id\": \"e4a1fa1e-ddd3-45e9-b891-3c99efa90a08\",\n            \"description\": \"描述文本xxxxxxxxxxx\",\n            \"zIndex\": 2\n        },\n        {\n            \"position\": {\n                \"x\": 417,\n                \"y\": 297.5\n            },\n            \"size\": {\n                \"width\": 80,\n                \"height\": 45\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"收款\"\n                }\n            },\n            \"shape\": \"activity\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"3aa51e4d-6677-4a60-90df-b8cda3819ecc\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"04d2f24d-c53a-4e5a-b586-7d9dcfdcd9a2\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"b519158d-0c4f-4e53-aa0c-7637ee85784a\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"dc294ef6-db7f-45f7-94c1-f25a8349644f\"\n                    }\n                ]\n            },\n            \"id\": \"61e8bc0b-a8da-47f0-bd29-680494f5bb37\",\n            \"description\": \"描述文本xxxxxxxxxxx\",\n            \"zIndex\": 3\n        },\n        {\n            \"position\": {\n                \"x\": 593,\n                \"y\": 298\n            },\n            \"size\": {\n                \"width\": 80,\n                \"height\": 45\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"存证\"\n                }\n            },\n            \"shape\": \"activity\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"3aa51e4d-6677-4a60-90df-b8cda3819ecc\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"04d2f24d-c53a-4e5a-b586-7d9dcfdcd9a2\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"b519158d-0c4f-4e53-aa0c-7637ee85784a\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"dc294ef6-db7f-45f7-94c1-f25a8349644f\"\n                    }\n                ]\n            },\n            \"id\": \"1a2360a1-e20d-47cd-8b01-7311c9534ba6\",\n            \"description\": \"描述文本xxxxxxxxxxx\",\n            \"zIndex\": 4\n        },\n        {\n            \"position\": {\n                \"x\": 798,\n                \"y\": 300\n            },\n            \"size\": {\n                \"width\": 40,\n                \"height\": 40\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"结束\"\n                }\n            },\n            \"shape\": \"event\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"85df9211-0eb5-47a6-a3bb-95efb4bbc82f\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"3dccbbab-f397-4ad4-b393-777c607d503d\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"be62c979-cfd8-4d3a-b2d0-7ccb66cdbb4c\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"4a51b32b-223d-4c99-91b1-4f2fe6affbbf\"\n                    }\n                ]\n            },\n            \"id\": \"1d0d97b0-6467-4f42-9e1f-b9a7e2e25ee2\",\n            \"zIndex\": 5\n        }\n    ],\n    \"edges\": [\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"44500db3-aba0-4dbd-8df0-464ac9c7b16e\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"68769619-4c3a-4c6b-9e22-ba0b23852bcd\",\n                \"port\": \"3dccbbab-f397-4ad4-b393-777c607d503d\"\n            },\n            \"target\": {\n                \"cell\": \"e4a1fa1e-ddd3-45e9-b891-3c99efa90a08\",\n                \"port\": \"dc294ef6-db7f-45f7-94c1-f25a8349644f\"\n            }\n        },\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"ac543bae-21e8-44d3-ac04-9a8b88ec6693\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"e4a1fa1e-ddd3-45e9-b891-3c99efa90a08\",\n                \"port\": \"04d2f24d-c53a-4e5a-b586-7d9dcfdcd9a2\"\n            },\n            \"target\": {\n                \"cell\": \"61e8bc0b-a8da-47f0-bd29-680494f5bb37\",\n                \"port\": \"dc294ef6-db7f-45f7-94c1-f25a8349644f\"\n            }\n        },\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"7e1d3682-889f-4b1f-9ee4-c914066c795a\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"61e8bc0b-a8da-47f0-bd29-680494f5bb37\",\n                \"port\": \"04d2f24d-c53a-4e5a-b586-7d9dcfdcd9a2\"\n            },\n            \"target\": {\n                \"cell\": \"1a2360a1-e20d-47cd-8b01-7311c9534ba6\",\n                \"port\": \"dc294ef6-db7f-45f7-94c1-f25a8349644f\"\n            }\n        },\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"401693b6-8b3a-4730-a7c4-f8a1ae5fc0e6\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"1a2360a1-e20d-47cd-8b01-7311c9534ba6\",\n                \"port\": \"04d2f24d-c53a-4e5a-b586-7d9dcfdcd9a2\"\n            },\n            \"target\": {\n                \"cell\": \"1d0d97b0-6467-4f42-9e1f-b9a7e2e25ee2\",\n                \"port\": \"4a51b32b-223d-4c99-91b1-4f2fe6affbbf\"\n            }\n        }\n    ]\n}', 0, '公益售卖', b'1', NULL, NULL, '6307435d7aafd60f608c6c75', NULL, NULL, NULL);
INSERT INTO `wf_processflow` VALUES ('{\n    \"nodes\": [\n        {\n            \"position\": {\n                \"x\": -20,\n                \"y\": -10\n            },\n            \"size\": {\n                \"width\": 80,\n                \"height\": 45\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"启动\"\n                }\n            },\n            \"visible\": true,\n            \"shape\": \"activity\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"603fd67e-533f-463a-90a3-5887f068a567\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"74f5fe05-817c-4b3c-bfcc-6655720d5bd1\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"72c8ea84-22dd-45d0-a31a-b4402c4ac992\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"208bfe77-0938-490c-bc78-15cc59ce4349\"\n                    }\n                ]\n            },\n            \"id\": \"97bde103-2595-4534-ad3b-7ee70e9b4389\",\n            \"description\": \"描述文本xxxxxxxxxxx\",\n            \"zIndex\": 1\n        },\n        {\n            \"position\": {\n                \"x\": -135,\n                \"y\": -7\n            },\n            \"size\": {\n                \"width\": 40,\n                \"height\": 40\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"开始\"\n                }\n            },\n            \"visible\": true,\n            \"shape\": \"event\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"16aafa04-8631-4eae-a840-f0758ecbcc50\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"da20070a-4079-455c-9898-d8c25893ac1b\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"0268697c-8ba0-4c3e-a460-ca5c2357395c\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"521ba728-e1a5-4a3d-a438-a572746746c7\"\n                    }\n                ]\n            },\n            \"id\": \"43d16a01-7981-4915-b3f8-3832abe30bae\",\n            \"zIndex\": 2\n        },\n        {\n            \"position\": {\n                \"x\": 110,\n                \"y\": -10\n            },\n            \"size\": {\n                \"width\": 80,\n                \"height\": 45\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"运行\"\n                }\n            },\n            \"visible\": true,\n            \"shape\": \"activity\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"603fd67e-533f-463a-90a3-5887f068a567\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"74f5fe05-817c-4b3c-bfcc-6655720d5bd1\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"72c8ea84-22dd-45d0-a31a-b4402c4ac992\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"208bfe77-0938-490c-bc78-15cc59ce4349\"\n                    }\n                ]\n            },\n            \"id\": \"0ea9b10b-f3c7-4fe7-9525-aad8650b4600\",\n            \"description\": \"描述文本xxxxxxxxxxx\",\n            \"zIndex\": 3\n        },\n        {\n            \"position\": {\n                \"x\": 251,\n                \"y\": -10\n            },\n            \"size\": {\n                \"width\": 80,\n                \"height\": 45\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"停止\"\n                }\n            },\n            \"visible\": true,\n            \"shape\": \"activity\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"603fd67e-533f-463a-90a3-5887f068a567\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"74f5fe05-817c-4b3c-bfcc-6655720d5bd1\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"72c8ea84-22dd-45d0-a31a-b4402c4ac992\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"208bfe77-0938-490c-bc78-15cc59ce4349\"\n                    }\n                ]\n            },\n            \"id\": \"d6390ff1-d832-4e46-b361-6e038a9dd957\",\n            \"description\": \"描述文本xxxxxxxxxxx\",\n            \"zIndex\": 4\n        },\n        {\n            \"position\": {\n                \"x\": 431,\n                \"y\": -7\n            },\n            \"size\": {\n                \"width\": 40,\n                \"height\": 40\n            },\n            \"attrs\": {\n                \"text\": {\n                    \"text\": \"结束\"\n                }\n            },\n            \"visible\": true,\n            \"shape\": \"event\",\n            \"ports\": {\n                \"groups\": {\n                    \"top\": {\n                        \"position\": \"top\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"right\": {\n                        \"position\": \"right\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"bottom\": {\n                        \"position\": \"bottom\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    },\n                    \"left\": {\n                        \"position\": \"left\",\n                        \"attrs\": {\n                            \"circle\": {\n                                \"r\": 4,\n                                \"magnet\": true,\n                                \"stroke\": \"#5F95FF\",\n                                \"strokeWidth\": 1,\n                                \"fill\": \"#fff\",\n                                \"style\": {\n                                    \"visibility\": \"hidden\"\n                                }\n                            }\n                        }\n                    }\n                },\n                \"items\": [\n                    {\n                        \"group\": \"top\",\n                        \"id\": \"16aafa04-8631-4eae-a840-f0758ecbcc50\"\n                    },\n                    {\n                        \"group\": \"right\",\n                        \"id\": \"da20070a-4079-455c-9898-d8c25893ac1b\"\n                    },\n                    {\n                        \"group\": \"bottom\",\n                        \"id\": \"0268697c-8ba0-4c3e-a460-ca5c2357395c\"\n                    },\n                    {\n                        \"group\": \"left\",\n                        \"id\": \"521ba728-e1a5-4a3d-a438-a572746746c7\"\n                    }\n                ]\n            },\n            \"id\": \"8873bcc5-c211-4e34-879c-5b2984ae51a9\",\n            \"zIndex\": 5\n        }\n    ],\n    \"edges\": [\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"66298811-0cc5-494b-921f-5421981f781b\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"43d16a01-7981-4915-b3f8-3832abe30bae\",\n                \"port\": \"da20070a-4079-455c-9898-d8c25893ac1b\"\n            },\n            \"target\": {\n                \"cell\": \"97bde103-2595-4534-ad3b-7ee70e9b4389\",\n                \"port\": \"208bfe77-0938-490c-bc78-15cc59ce4349\"\n            }\n        },\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"9b63c96f-6e52-44df-9aa9-a0013133378d\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"97bde103-2595-4534-ad3b-7ee70e9b4389\",\n                \"port\": \"74f5fe05-817c-4b3c-bfcc-6655720d5bd1\"\n            },\n            \"target\": {\n                \"cell\": \"0ea9b10b-f3c7-4fe7-9525-aad8650b4600\",\n                \"port\": \"208bfe77-0938-490c-bc78-15cc59ce4349\"\n            }\n        },\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"5a0ad749-12ad-4497-9330-b7288728a918\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"0ea9b10b-f3c7-4fe7-9525-aad8650b4600\",\n                \"port\": \"74f5fe05-817c-4b3c-bfcc-6655720d5bd1\"\n            },\n            \"target\": {\n                \"cell\": \"d6390ff1-d832-4e46-b361-6e038a9dd957\",\n                \"port\": \"208bfe77-0938-490c-bc78-15cc59ce4349\"\n            }\n        },\n        {\n            \"shape\": \"edge\",\n            \"attrs\": {\n                \"line\": {\n                    \"stroke\": \"#A2B1C3\",\n                    \"targetMarker\": {\n                        \"name\": \"block\",\n                        \"width\": 12,\n                        \"height\": 8\n                    }\n                }\n            },\n            \"id\": \"d234c070-1f27-4b4b-b689-2f05a277638b\",\n            \"zIndex\": 0,\n            \"source\": {\n                \"cell\": \"d6390ff1-d832-4e46-b361-6e038a9dd957\",\n                \"port\": \"74f5fe05-817c-4b3c-bfcc-6655720d5bd1\"\n            },\n            \"target\": {\n                \"cell\": \"8873bcc5-c211-4e34-879c-5b2984ae51a9\",\n                \"port\": \"521ba728-e1a5-4a3d-a438-a572746746c7\"\n            }\n        }\n    ]\n}', 0, '动作流程', b'1', NULL, NULL, '63077aa5d00f6c498448c969', NULL, NULL, NULL);

SET FOREIGN_KEY_CHECKS = 1;
