using Microsoft.VisualStudio.TestTools.UnitTesting;
using YC.Common;
using YC.CodeGenerate;
using YC.CodeGenerate.Dto;
using YC.Common.ShareUtils;
using System.Collections.Generic;

namespace YC.CodeGenerateTest
{
    [TestClass]
    public class CodeGenerateUnitTest
    {
        [TestMethod]
        public void ChangeJsonTest()
        {
            #region һֱתд룬ʽȽ
            //string dbConfigFilePath = System.Environment.CurrentDirectory + "\\DefaultConfig.json";
            //string tempJson = CodeGenerateConfig.GetConfigJson(dbConfigFilePath);
            //DatabaseConfig DatabaseConfig = CodeGenerateConfig.GetJsonList<DatabaseConfig>(tempJson);
            //DatabaseConfig.DefaultDBConnectionString = DatabaseConfig.DefaultDBConnectionString.Replace("{%dbName%}", "test");
            //bool result = CodeGenerateConfig.SetConfigJson(dbConfigFilePath, DatabaseConfig.ToJson()); 
            #endregion

            #region ڶ֣ʽ
            //string dbConfigFilePath = System.Environment.CurrentDirectory + "\\DefaultConfig.json";
            //string tempJson = CodeGenerateConfig.GetConfigJson(dbConfigFilePath).Replace("{%dbName%}", "test");
            //bool result = CodeGenerateConfig.SetConfigJson(dbConfigFilePath, tempJson);
            #endregion
        }

        /// <summary>
        /// ĬԶݿ
        /// </summary>
        [TestMethod]
        public void CreateDBTest()
        {

            using (CodeGenerateDBService codeGenerateDBRepository = new CodeGenerateDBService())
            {
                string msg = "";
                bool result = codeGenerateDBRepository.CreateDB(out msg);
                Assert.IsTrue(result);
            }

        }

        [TestMethod]
        public void CreateTableTest()
        {
            using (CodeGenerateDBService codeGenerateDBRepository = new CodeGenerateDBService())
            {
                string msg = "";
                GenerateDbTableConfig config = new GenerateDbTableConfig();
                config.GenerateDbTableEntityList = new List<string>();
                config.GenerateDbTableEntityList.Add("BCEvidence");//Ҫɵı
                //config.GenerateDbTableEntityList.Add("SysAuditLog");
                //config.GenerateDbTableEntityList.Add("SysUserSysOrganization");
                bool result = codeGenerateDBRepository.CreateTable(config,out msg, false, "YC.Model");
                Assert.IsTrue(result);
            }
        }  

        /// <summary>
        /// -ɶӦ
        /// </summary>
        [TestMethod]
        public void GenerateCodeTest()
        {
            #region ģɴ·
            TemplateDto templateDto = new TemplateDto();
            templateDto.AddOrEditDtoFilePath = System.AppContext.BaseDirectory + @"CodeTemplate\AddOrEditDtoTemplate.txt";
            templateDto.EntityDtoFilePath = System.AppContext.BaseDirectory + @"CodeTemplate\EntityDtoTemplate.txt";
            templateDto.ServiceFilePath = System.AppContext.BaseDirectory + @"CodeTemplate\AppServiceTemplate.txt";
            templateDto.IServiceFilePath = System.AppContext.BaseDirectory + @"CodeTemplate\IAppServiceTemplate.txt";
            templateDto.VueFilePath = System.AppContext.BaseDirectory + @"CodeTemplate\View\VueTemplate.txt";
            templateDto.TreeServiceFilePath = System.AppContext.BaseDirectory + @"CodeTemplate\TreeAppServiceTemplate.txt";
            templateDto.TreeIServiceFilePath = System.AppContext.BaseDirectory + @"CodeTemplate\TreeIAppServiceTemplate.txt";
            templateDto.TreeVueFilePath = System.AppContext.BaseDirectory + @"CodeTemplate\View\TreeVueTemplate.txt";
            templateDto.SaveDir = System.AppContext.BaseDirectory + "GenerateCode\\";//ɴ뱣λ
            #endregion
            #region Ĭɹ
            List<GenerateCodeEnumType> wantToGenerateCodeTypeList = new List<GenerateCodeEnumType>();
            wantToGenerateCodeTypeList.Add(GenerateCodeEnumType.DefaultAddOrEditDto);//༭Dto
            wantToGenerateCodeTypeList.Add(GenerateCodeEnumType.DefaultEntityDto);//ʵDto

            bool isTree = false;
            wantToGenerateCodeTypeList.Add(GenerateCodeEnumType.OtherCode);
            if (isTree)
            {
                wantToGenerateCodeTypeList.Add(GenerateCodeEnumType.TreeAppService);
                wantToGenerateCodeTypeList.Add(GenerateCodeEnumType.TreeIAppService);
                wantToGenerateCodeTypeList.Add(GenerateCodeEnumType.TreeVuePage);
            }
            else
            {
                wantToGenerateCodeTypeList.Add(GenerateCodeEnumType.DefaultAppService);
                wantToGenerateCodeTypeList.Add(GenerateCodeEnumType.DefaultIAppService);
                wantToGenerateCodeTypeList.Add(GenerateCodeEnumType.DefaultVuePage);
            }
            #endregion

            ///δɺע޸vue
            ///1ֶ޸ķ typeNameǱ
            //2ֶ޸ı༭ ѡݸڵ
            //3Ľڵ ĬʹLabelڵParentId ̶ֶ
            //4ĸڵҪΪ0

            List<string> generateEntityList = new List<string>();
            generateEntityList.Add("BCEvidence");
            GenerateCodeConfig generateCodeConfig = new GenerateCodeConfig();
            generateCodeConfig.Template = templateDto;
            generateCodeConfig.WantToGenerateCodeTypeList = wantToGenerateCodeTypeList;
            generateCodeConfig.GenerateEntityList = generateEntityList;
            generateCodeConfig.IsTree = isTree;
            generateCodeConfig.AssemblyName = "YC.Model";
            GenerateCodeService generateCodeRepository = new GenerateCodeService(generateCodeConfig);
            var result = generateCodeRepository.GenerateWork();
            Assert.IsTrue(result.Success);
        }
        /// <summary>
        /// Mysql-ɶӦģ
        /// </summary>
        [TestMethod]
        public void GenerateEntityCodeTest()
        {
            #region ģɴ·
            string _entityFilePath = System.AppContext.BaseDirectory + @"CodeTemplate\EntityTemplate.txt";
            string _saveDir = System.AppContext.BaseDirectory + "GenerateCode\\";//ɴ뱣λ
            #endregion
            GenerateCodeService generateCodeRepository = new GenerateCodeService();
            HashSet<string> _tables = new HashSet<string>();
            //ȫҪ
            //_tables = null;
            //Ҫ
            _tables.Add("sys_user");
            var result = generateCodeRepository.GenerateEntityCode(_tables, _entityFilePath, _saveDir);
            Assert.IsTrue(result.Success);
        }
    }
}
