﻿Imports System

Namespace Ys.QRCode

    ''' <summary>
    ''' 位置検出パターン
    ''' </summary>
    Friend Module FinderPattern

        Const VAL As Integer = Values.FINDER

        ' 位置検出パターン
        Private ReadOnly _finderPattern as Integer()() = {
            ({VAL,  VAL,  VAL,  VAL,  VAL,  VAL, VAL}),
            ({VAL, -VAL, -VAL, -VAL, -VAL, -VAL, VAL}),
            ({VAL, -VAL,  VAL,  VAL,  VAL, -VAL, VAL}),
            ({VAL, -VAL,  VAL,  VAL,  VAL, -VAL, VAL}),
            ({VAL, -VAL,  VAL,  VAL,  VAL, -VAL, VAL}),
            ({VAL, -VAL, -VAL, -VAL, -VAL, -VAL, VAL}),
            ({VAL,  VAL,  VAL,  VAL,  VAL,  VAL, VAL})
        }

        ''' <summary>
        ''' 位置検出パターンを配置します。
        ''' </summary>
        Public Sub Place(moduleMatrix As Integer()())
            Dim offset As Integer = moduleMatrix.Length - _finderPattern.Length

            For i As Integer = 0 To UBound(_finderPattern)
                For j As Integer = 0 To UBound(_finderPattern(i))
                    Dim v As Integer = _finderPattern(i)(j)

                    moduleMatrix(i)(j) = v
                    moduleMatrix(i)(j + offset) = v
                    moduleMatrix(i + offset)(j) = v
                Next
            Next
        End Sub

    End Module

End Namespace
