﻿Citation
--------

You can cite this repo (or papers) or attach the author information in your work.

```bibtex
@misc{YangL2022,
    title = {PyABSA: Open Framework for Aspect-based Sentiment Analysis},
    author = {Yang, Heng and Li, Ke},
    doi = {10.48550/ARXIV.2208.01368},
    url = {https://arxiv.org/abs/2208.01368},
    keywords = {Computation and Language (cs.CL), FOS: Computer and information sciences, FOS: Computer and information sciences},
    publisher = {arXiv},
    year = {2022},
    copyright = {arXiv.org perpetual, non-exclusive license}
}
```


This repository was first used to host ABSA research code.
It is now an open source framework that supports a variety of tasks. 

PyABSA currently contains model implementations of the following papers, 
If you use any of the following papers, please cite them.

### Aspect sentiment polarity classification models
1. [Back to Reality: Leveraging Pattern-driven Modeling to Enable Affordable Sentiment Dependency Learning](https://arxiv.org/abs/2110.08604) (
   e.g., Fast-LSA, 2020)
2. [Learning for target-dependent sentiment based on local context-aware embedding](https://link.springer.com/article/10.1007/s11227-021-04047-1) (
   e.g., LCA-Net, 2020)
3. [LCF: A Local Context Focus Mechanism for Aspect-Based Sentiment Classification](https://www.mdpi.com/2076-3417/9/16/3389) (
   e.g., LCF-BERT, 2019)



### Aspect sentiment polarity classification & Aspect term extraction models

1. [A multi-task learning model for Chinese-oriented aspect polarity classification and aspect term extraction](https://www.sciencedirect.com/science/article/pii/S0925231220312534)] (
   e.g., Fast-LCF-ATEPC, 2020)
2. [(Arxiv) A multi-task learning model for Chinese-oriented aspect polarity classification and aspect term extraction](https://arxiv.org/pdf/1912.07976.pdf)


