﻿PyABSA - Open Framework for Aspect-based Sentiment Analysis
-----------------------------------------------------------
![PyPI - Python Version](https://img.shields.io/badge/python-3.6-blue.svg)
[![PyPI](https://img.shields.io/pypi/v/pyabsa)](https://pypi.org/project/pyabsa/)
[![Downloads](https://pepy.tech/badge/pyabsa)](https://pepy.tech/project/pyabsa)
[![Downloads](https://pepy.tech/badge/pyabsa/month)](https://pepy.tech/project/pyabsa)
![License](https://img.shields.io/pypi/l/pyabsa?logo=PyABSA)

[![total views](https://raw.githubusercontent.com/yangheng95/PyABSA/traffic/total_views.svg)](https://github.com/yangheng95/PyABSA/tree/traffic#-total-traffic-data-badge)
[![total views per week](https://raw.githubusercontent.com/yangheng95/PyABSA/traffic/total_views_per_week.svg)](https://github.com/yangheng95/PyABSA/tree/traffic#-total-traffic-data-badge)
[![total clones](https://raw.githubusercontent.com/yangheng95/PyABSA/traffic/total_clones.svg)](https://github.com/yangheng95/PyABSA/tree/traffic#-total-traffic-data-badge)
[![total clones per week](https://raw.githubusercontent.com/yangheng95/PyABSA/traffic/total_clones_per_week.svg)](https://github.com/yangheng95/PyABSA/tree/traffic#-total-traffic-data-badge)

[![PWC](https://img.shields.io/endpoint.svg?url=https://paperswithcode.com/badge/back-to-reality-leveraging-pattern-driven/aspect-based-sentiment-analysis-on-semeval)](https://paperswithcode.com/sota/aspect-based-sentiment-analysis-on-semeval?p=back-to-reality-leveraging-pattern-driven)

### Introduction
This documentation is for PyABSA, a Python library for Aspect-Based Sentiment Analysis.
This library is developed by Heng Yang, a PhD student at the University of Exeter, UK.
This document is pending for elaboration.

### Features
This repository provides the same training and evaluation methods and prediction codes for various aspects of sentiment analysis tasks. PyABSA is designed to simplify the ABSC utility process and accelerate research.
PyABSA also provides visualization of evaluation metrics to better understand the performance of the model.
The framework provides, but is not limited to, the following features.
- Unified API for training and evaluation
- Unified API for prediction
- Ensemble inference API for all models 
- Visualization for evaluation metrics
- Manual/automated dataset annotation methods 
- Automated text augmentation methods for classification
- Models for textual adversarial defense
- API for automatic Device selection
- etc...

这个存储库提供同一训练和评估方法和预测代码，用于各种方面的情感分析任务。 PyABSA的宗旨是是为了简化ABSC实用流程和加速研究.
PyABSA还提供评估指标的可视化，以便更好地理解模型的性能。
该框架提供但不限于以下功能：
- 用于训练和评估的统一API
- 用于预测的统一API
- 用于模型融合预测API
- 用于评估指标的可视化
- 用于数据集的人工/自动化标注工具
- 用于分类的自动文本增强方法
- 用于文本对抗性防御的模型
- 用于自动选择Device的API
- etc...

### Contribution

This repository is developed and maintained by HENG YANG ([yangheng95@GitHub](https://github.com/yangheng95)),
with great contribution from community researchers.
We expect that you can help us improve this project, and your contributions are welcome. You can make a contribution in
many ways, including:

- Share your custom dataset in PyABSA and [ABSADatasets](https://github.com/yangheng95/ABSADatasets)
- Integrates your models in PyABSA. (You can share your models whether it is or not based on PyABSA. if you are
  interested, we will help you)
- Raise a bug report while you use PyABSA or review the code (PyABSA is a individual project driven by enthusiasm so
  your help is needed)
- Give us some advice about feature design/refactor (You can advise to improve some feature)
- Correct/Rewrite some error-messages or code comment (The comments are not written by native english speaker, you can
  help us improve documents)
- Create an example script in a particular situation (Such as specify a SpaCy model, pretrained-bert type, some
  hyper-parameters)
- Star this repository to keep it active


### License

PyABSA is released under MIT licence, please cite this repo (or papers) or attach the author information in your work
(repository, blog, product, etc.)
