<?php
namespace php_fsockopenTest;
use php_fsockopen;
use php_fsockopen\fsockopen;
use PHPUnit\Framework\TestCase;
class php_fsockopenTest extends TestCase{

  public function testGet(){
    $Url = "https://raw.githubusercontent.com/yakeing/php_fsockopen/master/tests/return";
    $Referer = "https://github.com";
    $Cookie = '_gat=1';
    $fs = new fsockopen();
    $fs->AcceptEncoding = 'gzip';
    //HTTP/1.1 417 Expectation Failed / HTTP/1.1 100 Continue
    $fs->OnContinue = true;
    $fs->init(10,'tcp',true);
    $ret = $fs->GET($Url, $Referer, $Cookie);
    $this->assertEquals(200, $ret['code']);
    //gzdecode() substr($ret['body'],10,-8)
    $body = gzinflate(substr($ret['body'],10)); 
    $this->assertEquals('Hello world', trim($body));
    return $fs;
  }

  /**
  * @depends testGet
  */
  public function testPost($fs){
    $Cookie = '_gat=1';
    $Referer = "https://github.com";
    $ContentType = 'application/json; charset=utf-8';
    $fs->OnContinue = true;
    //$fs->AcceptEncoding = 'gzip';
    //POST
    $Url = "https://api.github.com/_private/browser/errors";
    $Content = '{"bucket":"github-js-reports","error":{"columnNumber":null,"fileName":null,"lineNumber":null,"message":"ReportingObserverError","stack":"Error: ReportingObserverError"},"url":"https://github.com/about"}';
    $ret = $fs->POST($Url, $Content, $Referer, $Cookie, $ContentType);
    $this->assertEquals(200, $ret['code']);
    /*
    //POST_FILE
    $Url = "https://api.github.com/_private/browser/errors";
    $File = dirname(__FILE__).'/image.jpg';
    $ret = $fs->PUT($Url, $File, $Referer, $Cookie);
    $this->assertEquals(200, $ret['code']);
    */
  }

}
