/* xoreos - A reimplementation of BioWare's Aurora engine
 *
 * xoreos is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Module save data for roster tests.
 */

#include "src/common/error.h"

#ifndef TESTS_ENGINES_NWN2_ROSTER_TESTS_H
#define TESTS_ENGINES_NWN2_ROSTER_TESTS_H

/**
 * NWN2 ROSTER.rst file from the Original Campaign.
 */
static const byte kDataRoster[] = {
	0x52,0x53,0x54,0x20,0x56,0x33,0x2E,0x32,0x38,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0xE0,0x00,0x00,0x00,0x09,0x01,0x00,0x00,0x4C,0x0D,0x00,0x00,0x19,0x00,0x00,0x00,
	0xDC,0x0E,0x00,0x00,0x77,0x03,0x00,0x00,0x53,0x12,0x00,0x00,0x24,0x04,0x00,0x00,
	0x77,0x16,0x00,0x00,0x38,0x00,0x00,0x00,0xFF,0xFF,0xFF,0xFF,0x00,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x14,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xB4,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x01,0x00,0x00,
	0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x54,0x01,0x00,0x00,0x14,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xA4,0x01,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0xF4,0x01,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x44,0x02,0x00,0x00,
	0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x94,0x02,0x00,0x00,0x14,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0xE4,0x02,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x34,0x03,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x84,0x03,0x00,0x00,
	0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0xD4,0x03,0x00,0x00,0x14,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x13,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x29,0x00,0x00,0x00,
	0x0F,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x45,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x27,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x58,0x4A,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x54,0x02,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x63,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x58,0x4A,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x6D,0x02,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x77,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x58,0x4A,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x82,0x02,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x8D,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x04,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x58,0x4A,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x9A,0x02,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0xA7,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x03,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0xB1,0x02,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0xBB,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x09,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x58,0x4A,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0xC6,0x02,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0xD1,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0xDC,0x02,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0xF0,0x02,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0xFB,0x02,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x06,0x03,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x06,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x58,0x4A,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x0E,0x03,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x16,0x03,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x58,0x4A,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x1E,0x03,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x26,0x03,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x08,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x58,0x4A,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x31,0x03,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x42,0x03,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x01,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x2A,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0x58,0x4A,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x4D,0x03,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x58,0x03,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x05,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x05,0x00,0x00,0x00,
	0x09,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,
	0x01,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x02,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x02,0x00,0x00,0x00,
	0x0D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,
	0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x11,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x12,0x00,0x00,0x00,
	0x04,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x16,0x00,0x00,0x00,
	0xC0,0x30,0x00,0x00,0x0A,0x00,0x00,0x00,0x17,0x00,0x00,0x00,0x65,0x03,0x00,0x00,
	0x05,0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x50,
	0x61,0x72,0x74,0x79,0x4C,0x69,0x6D,0x69,0x74,0x00,0x00,0x00,0x50,0x61,0x72,0x74,
	0x79,0x4E,0x61,0x6D,0x65,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x61,0x72,0x74,
	0x79,0x4D,0x6F,0x74,0x74,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x50,0x61,0x72,0x74,
	0x79,0x42,0x69,0x6F,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x4D,
	0x65,0x6D,0x62,0x65,0x72,0x73,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x4E,
	0x61,0x6D,0x65,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x41,
	0x76,0x61,0x69,0x6C,0x61,0x62,0x6C,0x65,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x53,
	0x65,0x6C,0x65,0x63,0x74,0x61,0x62,0x6C,0x65,0x00,0x00,0x00,0x52,0x6F,0x73,0x43,
	0x61,0x6D,0x70,0x61,0x69,0x67,0x6E,0x4E,0x50,0x43,0x00,0x00,0x52,0x6F,0x73,0x52,
	0x65,0x71,0x75,0x69,0x72,0x65,0x64,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x4C,
	0x6F,0x61,0x64,0x65,0x64,0x42,0x65,0x66,0x6F,0x72,0x65,0x00,0x52,0x6F,0x73,0x47,
	0x65,0x6E,0x64,0x65,0x72,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x52,
	0x61,0x63,0x65,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x50,
	0x6F,0x72,0x74,0x72,0x61,0x69,0x74,0x49,0x44,0x00,0x00,0x00,0x52,0x6F,0x73,0x4C,
	0x65,0x76,0x65,0x6C,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x4C,
	0x65,0x76,0x65,0x6C,0x31,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x4C,
	0x65,0x76,0x65,0x6C,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x4C,
	0x65,0x76,0x65,0x6C,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x43,
	0x6C,0x61,0x73,0x73,0x30,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x43,
	0x6C,0x61,0x73,0x73,0x31,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x43,
	0x6C,0x61,0x73,0x73,0x32,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x43,
	0x6C,0x61,0x73,0x73,0x33,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x55,0x6E,0x73,0x70,
	0x61,0x77,0x6E,0x65,0x64,0x58,0x50,0x00,0x00,0x00,0x00,0x00,0x52,0x6F,0x73,0x43,
	0x68,0x61,0x72,0x4E,0x61,0x6D,0x65,0x00,0x00,0x00,0x00,0x00,0x50,0x6C,0x61,0x79,
	0x65,0x72,0x43,0x72,0x65,0x61,0x74,0x65,0x64,0x00,0x00,0x00,0x0F,0x00,0x00,0x00,
	0x54,0x68,0x65,0x20,0x41,0x64,0x76,0x65,0x6E,0x74,0x75,0x72,0x65,0x72,0x73,0x12,
	0x00,0x00,0x00,0x41,0x64,0x76,0x65,0x6E,0x74,0x75,0x72,0x65,0x20,0x6F,0x72,0x20,
	0x42,0x75,0x73,0x74,0x21,0x18,0x02,0x00,0x00,0x54,0x68,0x65,0x20,0x66,0x6F,0x75,
	0x6E,0x64,0x69,0x6E,0x67,0x20,0x6D,0x65,0x6D,0x62,0x65,0x72,0x73,0x20,0x6F,0x66,
	0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x72,0x74,0x79,0x20,0x62,0x61,0x6E,0x64,0x65,
	0x64,0x20,0x74,0x6F,0x67,0x65,0x74,0x68,0x65,0x72,0x20,0x69,0x6E,0x20,0x74,0x68,
	0x65,0x20,0x61,0x66,0x74,0x65,0x72,0x6D,0x61,0x74,0x68,0x20,0x6F,0x66,0x20,0x74,
	0x68,0x65,0x20,0x53,0x68,0x61,0x64,0x6F,0x77,0x20,0x57,0x61,0x72,0x2C,0x20,0x77,
	0x68,0x69,0x63,0x68,0x20,0x6C,0x65,0x66,0x74,0x20,0x6D,0x61,0x6E,0x79,0x20,0x6F,
	0x66,0x20,0x72,0x65,0x73,0x69,0x64,0x65,0x6E,0x74,0x73,0x20,0x6F,0x66,0x20,0x74,
	0x68,0x65,0x20,0x6E,0x6F,0x72,0x74,0x68,0x65,0x72,0x6E,0x20,0x53,0x77,0x6F,0x72,
	0x64,0x20,0x43,0x6F,0x61,0x73,0x74,0x20,0x64,0x65,0x73,0x74,0x69,0x74,0x75,0x74,
	0x65,0x2C,0x20,0x62,0x65,0x72,0x65,0x66,0x74,0x2C,0x20,0x61,0x6E,0x64,0x20,0x64,
	0x69,0x73,0x70,0x6C,0x61,0x63,0x65,0x64,0x2E,0x20,0x54,0x68,0x65,0x73,0x65,0x20,
	0x69,0x6E,0x64,0x69,0x76,0x69,0x64,0x75,0x61,0x6C,0x73,0x20,0x77,0x65,0x72,0x65,
	0x20,0x75,0x6E,0x69,0x74,0x65,0x64,0x20,0x62,0x79,0x20,0x74,0x68,0x65,0x20,0x73,
	0x68,0x61,0x72,0x65,0x64,0x20,0x67,0x6F,0x61,0x6C,0x20,0x6F,0x66,0x20,0x77,0x61,
	0x6E,0x74,0x69,0x6E,0x67,0x20,0x74,0x6F,0x20,0x63,0x72,0x65,0x61,0x74,0x65,0x20,
	0x62,0x65,0x74,0x74,0x65,0x72,0x20,0x6C,0x69,0x76,0x65,0x73,0x20,0x66,0x6F,0x72,
	0x20,0x74,0x68,0x65,0x6D,0x73,0x65,0x6C,0x76,0x65,0x73,0x2E,0x0A,0x0A,0x41,0x66,
	0x74,0x65,0x72,0x20,0x6D,0x61,0x6E,0x79,0x20,0x74,0x65,0x6E,0x64,0x61,0x79,0x73,
	0x20,0x6F,0x66,0x20,0x74,0x72,0x79,0x69,0x6E,0x67,0x20,0x74,0x6F,0x20,0x66,0x69,
	0x6E,0x64,0x20,0x65,0x6D,0x70,0x6C,0x6F,0x79,0x6D,0x65,0x6E,0x74,0x20,0x69,0x6E,
	0x20,0x74,0x68,0x65,0x20,0x4E,0x65,0x76,0x65,0x72,0x77,0x69,0x6E,0x74,0x65,0x72,
	0x20,0x61,0x72,0x65,0x61,0x2C,0x20,0x74,0x68,0x65,0x79,0x20,0x63,0x68,0x61,0x6E,
	0x63,0x65,0x64,0x20,0x74,0x6F,0x20,0x6D,0x65,0x65,0x74,0x20,0x66,0x61,0x6D,0x65,
	0x64,0x20,0x61,0x75,0x74,0x68,0x6F,0x72,0x20,0x61,0x6E,0x64,0x20,0x65,0x78,0x70,
	0x6C,0x6F,0x72,0x65,0x72,0x2C,0x20,0x56,0x6F,0x6C,0x6F,0x74,0x68,0x61,0x6D,0x70,
	0x20,0x47,0x65,0x64,0x64,0x61,0x72,0x6D,0x2E,0x20,0x56,0x6F,0x6C,0x6F,0x2C,0x20,
	0x61,0x73,0x20,0x68,0x65,0x20,0x70,0x72,0x65,0x66,0x65,0x72,0x73,0x20,0x74,0x6F,
	0x20,0x62,0x65,0x20,0x63,0x61,0x6C,0x6C,0x65,0x64,0x2C,0x20,0x6F,0x66,0x66,0x65,
	0x72,0x65,0x64,0x20,0x74,0x68,0x65,0x20,0x70,0x61,0x72,0x74,0x79,0x20,0x61,0x20,
	0x66,0x69,0x72,0x73,0x74,0x20,0x6D,0x69,0x73,0x73,0x69,0x6F,0x6E,0x20,0x2D,0x20,
	0x74,0x6F,0x20,0x61,0x63,0x63,0x6F,0x6D,0x70,0x61,0x6E,0x79,0x20,0x68,0x69,0x6D,
	0x20,0x6F,0x6E,0x20,0x68,0x69,0x73,0x20,0x6C,0x6F,0x6E,0x67,0x20,0x6A,0x6F,0x75,
	0x72,0x6E,0x65,0x79,0x20,0x74,0x6F,0x20,0x53,0x61,0x6D,0x61,0x72,0x61,0x63,0x68,
	0x2E,0x0B,0x00,0x00,0x00,0x61,0x6D,0x6D,0x6F,0x6E,0x5F,0x6A,0x65,0x72,0x72,0x6F,
	0x0B,0x00,0x00,0x00,0x41,0x6D,0x6D,0x6F,0x6E,0x20,0x4A,0x65,0x72,0x72,0x6F,0x06,
	0x00,0x00,0x00,0x62,0x69,0x73,0x68,0x6F,0x70,0x06,0x00,0x00,0x00,0x42,0x69,0x73,
	0x68,0x6F,0x70,0x07,0x00,0x00,0x00,0x63,0x61,0x73,0x61,0x76,0x69,0x72,0x07,0x00,
	0x00,0x00,0x43,0x61,0x73,0x61,0x76,0x69,0x72,0x09,0x00,0x00,0x00,0x63,0x6F,0x6E,
	0x73,0x74,0x72,0x75,0x63,0x74,0x09,0x00,0x00,0x00,0x43,0x6F,0x6E,0x73,0x74,0x72,
	0x75,0x63,0x74,0x06,0x00,0x00,0x00,0x65,0x6C,0x61,0x6E,0x65,0x65,0x06,0x00,0x00,
	0x00,0x45,0x6C,0x61,0x6E,0x65,0x65,0x07,0x00,0x00,0x00,0x67,0x72,0x6F,0x62,0x6E,
	0x61,0x72,0x07,0x00,0x00,0x00,0x47,0x72,0x6F,0x62,0x6E,0x61,0x72,0x07,0x00,0x00,
	0x00,0x6B,0x68,0x65,0x6C,0x67,0x61,0x72,0x10,0x00,0x00,0x00,0x4B,0x68,0x65,0x6C,
	0x67,0x61,0x72,0x20,0x49,0x72,0x6F,0x6E,0x66,0x69,0x73,0x74,0x07,0x00,0x00,0x00,
	0x6E,0x65,0x65,0x73,0x68,0x6B,0x61,0x07,0x00,0x00,0x00,0x4E,0x65,0x65,0x73,0x68,
	0x6B,0x61,0x04,0x00,0x00,0x00,0x71,0x61,0x72,0x61,0x04,0x00,0x00,0x00,0x51,0x61,
	0x72,0x61,0x04,0x00,0x00,0x00,0x73,0x61,0x6E,0x64,0x04,0x00,0x00,0x00,0x53,0x61,
	0x6E,0x64,0x07,0x00,0x00,0x00,0x73,0x68,0x61,0x6E,0x64,0x72,0x61,0x0D,0x00,0x00,
	0x00,0x53,0x68,0x61,0x6E,0x64,0x72,0x61,0x20,0x4A,0x65,0x72,0x72,0x6F,0x07,0x00,
	0x00,0x00,0x7A,0x68,0x6A,0x61,0x65,0x76,0x65,0x07,0x00,0x00,0x00,0x5A,0x68,0x6A,
	0x61,0x65,0x76,0x65,0x09,0x00,0x00,0x00,0x6E,0x70,0x63,0x5F,0x62,0x65,0x76,0x69,
	0x6C,0x0E,0x00,0x00,0x00,0x42,0x65,0x76,0x69,0x6C,0x20,0x53,0x74,0x61,0x72,0x6C,
	0x69,0x6E,0x67,0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x03,
	0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x06,0x00,0x00,0x00,0x07,
	0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x09,0x00,0x00,0x00,0x0A,0x00,0x00,0x00,0x0B,
	0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x0D,0x00,0x00,0x00,0x0E,0x00,0x00,0x00,0x0F,
	0x00,0x00,0x00,0x10,0x00,0x00,0x00,0x11,0x00,0x00,0x00,0x12,0x00,0x00,0x00,0x13,
	0x00,0x00,0x00,0x14,0x00,0x00,0x00,0x15,0x00,0x00,0x00,0x16,0x00,0x00,0x00,0x17,
	0x00,0x00,0x00,0x18,0x00,0x00,0x00,0x19,0x00,0x00,0x00,0x1A,0x00,0x00,0x00,0x1B,
	0x00,0x00,0x00,0x1C,0x00,0x00,0x00,0x1D,0x00,0x00,0x00,0x1E,0x00,0x00,0x00,0x1F,
	0x00,0x00,0x00,0x20,0x00,0x00,0x00,0x21,0x00,0x00,0x00,0x22,0x00,0x00,0x00,0x23,
	0x00,0x00,0x00,0x24,0x00,0x00,0x00,0x25,0x00,0x00,0x00,0x26,0x00,0x00,0x00,0x27,
	0x00,0x00,0x00,0x28,0x00,0x00,0x00,0x29,0x00,0x00,0x00,0x2A,0x00,0x00,0x00,0x2B,
	0x00,0x00,0x00,0x2C,0x00,0x00,0x00,0x2D,0x00,0x00,0x00,0x2E,0x00,0x00,0x00,0x2F,
	0x00,0x00,0x00,0x30,0x00,0x00,0x00,0x31,0x00,0x00,0x00,0x32,0x00,0x00,0x00,0x33,
	0x00,0x00,0x00,0x34,0x00,0x00,0x00,0x35,0x00,0x00,0x00,0x36,0x00,0x00,0x00,0x37,
	0x00,0x00,0x00,0x38,0x00,0x00,0x00,0x39,0x00,0x00,0x00,0x3A,0x00,0x00,0x00,0x3B,
	0x00,0x00,0x00,0x3C,0x00,0x00,0x00,0x3D,0x00,0x00,0x00,0x3E,0x00,0x00,0x00,0x3F,
	0x00,0x00,0x00,0x40,0x00,0x00,0x00,0x41,0x00,0x00,0x00,0x42,0x00,0x00,0x00,0x43,
	0x00,0x00,0x00,0x44,0x00,0x00,0x00,0x45,0x00,0x00,0x00,0x46,0x00,0x00,0x00,0x47,
	0x00,0x00,0x00,0x48,0x00,0x00,0x00,0x49,0x00,0x00,0x00,0x4A,0x00,0x00,0x00,0x4B,
	0x00,0x00,0x00,0x4C,0x00,0x00,0x00,0x4D,0x00,0x00,0x00,0x4E,0x00,0x00,0x00,0x4F,
	0x00,0x00,0x00,0x50,0x00,0x00,0x00,0x51,0x00,0x00,0x00,0x52,0x00,0x00,0x00,0x53,
	0x00,0x00,0x00,0x54,0x00,0x00,0x00,0x55,0x00,0x00,0x00,0x56,0x00,0x00,0x00,0x57,
	0x00,0x00,0x00,0x58,0x00,0x00,0x00,0x59,0x00,0x00,0x00,0x5A,0x00,0x00,0x00,0x5B,
	0x00,0x00,0x00,0x5C,0x00,0x00,0x00,0x5D,0x00,0x00,0x00,0x5E,0x00,0x00,0x00,0x5F,
	0x00,0x00,0x00,0x60,0x00,0x00,0x00,0x61,0x00,0x00,0x00,0x62,0x00,0x00,0x00,0x63,
	0x00,0x00,0x00,0x64,0x00,0x00,0x00,0x65,0x00,0x00,0x00,0x66,0x00,0x00,0x00,0x67,
	0x00,0x00,0x00,0x68,0x00,0x00,0x00,0x69,0x00,0x00,0x00,0x6A,0x00,0x00,0x00,0x6B,
	0x00,0x00,0x00,0x6C,0x00,0x00,0x00,0x6D,0x00,0x00,0x00,0x6E,0x00,0x00,0x00,0x6F,
	0x00,0x00,0x00,0x70,0x00,0x00,0x00,0x71,0x00,0x00,0x00,0x72,0x00,0x00,0x00,0x73,
	0x00,0x00,0x00,0x74,0x00,0x00,0x00,0x75,0x00,0x00,0x00,0x76,0x00,0x00,0x00,0x77,
	0x00,0x00,0x00,0x78,0x00,0x00,0x00,0x79,0x00,0x00,0x00,0x7A,0x00,0x00,0x00,0x7B,
	0x00,0x00,0x00,0x7C,0x00,0x00,0x00,0x7D,0x00,0x00,0x00,0x7E,0x00,0x00,0x00,0x7F,
	0x00,0x00,0x00,0x80,0x00,0x00,0x00,0x81,0x00,0x00,0x00,0x82,0x00,0x00,0x00,0x83,
	0x00,0x00,0x00,0x84,0x00,0x00,0x00,0x85,0x00,0x00,0x00,0x86,0x00,0x00,0x00,0x87,
	0x00,0x00,0x00,0x88,0x00,0x00,0x00,0x89,0x00,0x00,0x00,0x8A,0x00,0x00,0x00,0x8B,
	0x00,0x00,0x00,0x8C,0x00,0x00,0x00,0x8D,0x00,0x00,0x00,0x8E,0x00,0x00,0x00,0x8F,
	0x00,0x00,0x00,0x90,0x00,0x00,0x00,0x91,0x00,0x00,0x00,0x92,0x00,0x00,0x00,0x93,
	0x00,0x00,0x00,0x94,0x00,0x00,0x00,0x95,0x00,0x00,0x00,0x96,0x00,0x00,0x00,0x97,
	0x00,0x00,0x00,0x98,0x00,0x00,0x00,0x99,0x00,0x00,0x00,0x9A,0x00,0x00,0x00,0x9B,
	0x00,0x00,0x00,0x9C,0x00,0x00,0x00,0x9D,0x00,0x00,0x00,0x9E,0x00,0x00,0x00,0x9F,
	0x00,0x00,0x00,0xA0,0x00,0x00,0x00,0xA1,0x00,0x00,0x00,0xA2,0x00,0x00,0x00,0xA3,
	0x00,0x00,0x00,0xA4,0x00,0x00,0x00,0xA5,0x00,0x00,0x00,0xA6,0x00,0x00,0x00,0xA7,
	0x00,0x00,0x00,0xA8,0x00,0x00,0x00,0xA9,0x00,0x00,0x00,0xAA,0x00,0x00,0x00,0xAB,
	0x00,0x00,0x00,0xAC,0x00,0x00,0x00,0xAD,0x00,0x00,0x00,0xAE,0x00,0x00,0x00,0xAF,
	0x00,0x00,0x00,0xB0,0x00,0x00,0x00,0xB1,0x00,0x00,0x00,0xB2,0x00,0x00,0x00,0xB3,
	0x00,0x00,0x00,0xB4,0x00,0x00,0x00,0xB5,0x00,0x00,0x00,0xB6,0x00,0x00,0x00,0xB7,
	0x00,0x00,0x00,0xB8,0x00,0x00,0x00,0xB9,0x00,0x00,0x00,0xBA,0x00,0x00,0x00,0xBB,
	0x00,0x00,0x00,0xBC,0x00,0x00,0x00,0xBD,0x00,0x00,0x00,0xBE,0x00,0x00,0x00,0xBF,
	0x00,0x00,0x00,0xC0,0x00,0x00,0x00,0xC1,0x00,0x00,0x00,0xC2,0x00,0x00,0x00,0xC3,
	0x00,0x00,0x00,0xC4,0x00,0x00,0x00,0xC5,0x00,0x00,0x00,0xC6,0x00,0x00,0x00,0xC7,
	0x00,0x00,0x00,0xC8,0x00,0x00,0x00,0xC9,0x00,0x00,0x00,0xCA,0x00,0x00,0x00,0xCB,
	0x00,0x00,0x00,0xCC,0x00,0x00,0x00,0xCD,0x00,0x00,0x00,0xCE,0x00,0x00,0x00,0xCF,
	0x00,0x00,0x00,0xD0,0x00,0x00,0x00,0xD1,0x00,0x00,0x00,0xD2,0x00,0x00,0x00,0xD3,
	0x00,0x00,0x00,0xD4,0x00,0x00,0x00,0xD5,0x00,0x00,0x00,0xD6,0x00,0x00,0x00,0xD7,
	0x00,0x00,0x00,0xD8,0x00,0x00,0x00,0xD9,0x00,0x00,0x00,0xDA,0x00,0x00,0x00,0xDB,
	0x00,0x00,0x00,0xDC,0x00,0x00,0x00,0xDD,0x00,0x00,0x00,0xDE,0x00,0x00,0x00,0xDF,
	0x00,0x00,0x00,0xE0,0x00,0x00,0x00,0xE1,0x00,0x00,0x00,0xE2,0x00,0x00,0x00,0xE3,
	0x00,0x00,0x00,0xE4,0x00,0x00,0x00,0xE5,0x00,0x00,0x00,0xE6,0x00,0x00,0x00,0xE7,
	0x00,0x00,0x00,0xE8,0x00,0x00,0x00,0xE9,0x00,0x00,0x00,0xEA,0x00,0x00,0x00,0xEB,
	0x00,0x00,0x00,0xEC,0x00,0x00,0x00,0xED,0x00,0x00,0x00,0xEE,0x00,0x00,0x00,0xEF,
	0x00,0x00,0x00,0xF0,0x00,0x00,0x00,0xF1,0x00,0x00,0x00,0xF2,0x00,0x00,0x00,0xF3,
	0x00,0x00,0x00,0xF4,0x00,0x00,0x00,0xF5,0x00,0x00,0x00,0xF6,0x00,0x00,0x00,0xF7,
	0x00,0x00,0x00,0xF8,0x00,0x00,0x00,0xF9,0x00,0x00,0x00,0xFA,0x00,0x00,0x00,0xFB,
	0x00,0x00,0x00,0xFC,0x00,0x00,0x00,0xFD,0x00,0x00,0x00,0xFE,0x00,0x00,0x00,0xFF,
	0x00,0x00,0x00,0x00,0x01,0x00,0x00,0x01,0x01,0x00,0x00,0x02,0x01,0x00,0x00,0x03,
	0x01,0x00,0x00,0x04,0x01,0x00,0x00,0x05,0x01,0x00,0x00,0x06,0x01,0x00,0x00,0x07,
	0x01,0x00,0x00,0x08,0x01,0x00,0x00,0x0D,0x00,0x00,0x00,0x01,0x00,0x00,0x00,0x02,
	0x00,0x00,0x00,0x03,0x00,0x00,0x00,0x04,0x00,0x00,0x00,0x05,0x00,0x00,0x00,0x06,
	0x00,0x00,0x00,0x07,0x00,0x00,0x00,0x08,0x00,0x00,0x00,0x09,0x00,0x00,0x00,0x0A,
	0x00,0x00,0x00,0x0B,0x00,0x00,0x00,0x0C,0x00,0x00,0x00,0x0D,0x00,0x00,0x00,
};

#endif // TESTS_ENGINES_NWN2_ROSTER_TESTS_H
