/* xoreos - A reimplementation of BioWare's Aurora engine
 *
 * xoreos is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Unit tests for our NFOFile class.
 */

#include "gtest/gtest.h"

#include "src/common/memreadstream.h"

#include "src/aurora/nfofile.h"

unsigned char kNFOFile[] = {
		0x4e, 0x46, 0x4f, 0x20, 0x56, 0x33, 0x2e, 0x32, 0x38, 0x00, 0x00, 0x00,
		0x01, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00,
		0xf8, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0xe8, 0x01, 0x00, 0x00,
		0x55, 0x00, 0x00, 0x00, 0x3d, 0x02, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00,
		0x79, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff,
		0x00, 0x00, 0x00, 0x00, 0x0f, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x01, 0x00, 0x00, 0x00, 0x1f, 0x00, 0x00, 0x00, 0x04, 0x00, 0x00, 0x00,
		0x02, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x03, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x04, 0x00, 0x00, 0x00, 0x2c, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x05, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x06, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x07, 0x00, 0x00, 0x00, 0x34, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x08, 0x00, 0x00, 0x00, 0x38, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x09, 0x00, 0x00, 0x00, 0x3c, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x0a, 0x00, 0x00, 0x00, 0x40, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x0b, 0x00, 0x00, 0x00, 0x44, 0x00, 0x00, 0x00, 0x0a, 0x00, 0x00, 0x00,
		0x0c, 0x00, 0x00, 0x00, 0x48, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x0d, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00,
		0x0e, 0x00, 0x00, 0x00, 0x4c, 0x00, 0x00, 0x00, 0x41, 0x52, 0x45, 0x41,
		0x4e, 0x41, 0x4d, 0x45, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x4c, 0x41, 0x53, 0x54, 0x4d, 0x4f, 0x44, 0x55, 0x4c, 0x45, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x54, 0x49, 0x4d, 0x45, 0x50, 0x4c, 0x41, 0x59,
		0x45, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x43, 0x48, 0x45, 0x41,
		0x54, 0x55, 0x53, 0x45, 0x44, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x53, 0x41, 0x56, 0x45, 0x47, 0x41, 0x4d, 0x45, 0x4e, 0x41, 0x4d, 0x45,
		0x00, 0x00, 0x00, 0x00, 0x47, 0x41, 0x4d, 0x45, 0x50, 0x4c, 0x41, 0x59,
		0x48, 0x49, 0x4e, 0x54, 0x00, 0x00, 0x00, 0x00, 0x53, 0x54, 0x4f, 0x52,
		0x59, 0x48, 0x49, 0x4e, 0x54, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x4c, 0x49, 0x56, 0x45, 0x31, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x4c, 0x49, 0x56, 0x45, 0x32, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x49, 0x56, 0x45,
		0x33, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x4c, 0x49, 0x56, 0x45, 0x34, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x4c, 0x49, 0x56, 0x45, 0x35, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x4c, 0x49, 0x56, 0x45,
		0x36, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x4c, 0x49, 0x56, 0x45, 0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x50, 0x4f, 0x52, 0x54, 0x52, 0x41, 0x49, 0x54,
		0x30, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x1b, 0x00, 0x00, 0x00,
		0x45, 0x6e, 0x64, 0x61, 0x72, 0x20, 0x53, 0x70, 0x69, 0x72, 0x65, 0x20,
		0x2d, 0x20, 0x4b, 0x6f, 0x6d, 0x6d, 0x61, 0x6e, 0x64, 0x6f, 0x6d, 0x6f,
		0x64, 0x75, 0x6c, 0x09, 0x00, 0x00, 0x00, 0x45, 0x4e, 0x44, 0x5f, 0x4d,
		0x30, 0x31, 0x41, 0x41, 0x04, 0x00, 0x00, 0x00, 0x74, 0x65, 0x73, 0x74,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
		0x08, 0x70, 0x6f, 0x5f, 0x70, 0x6d, 0x68, 0x61, 0x34, 0x00, 0x00, 0x00,
		0x00, 0x01, 0x00, 0x00, 0x00, 0x02, 0x00, 0x00, 0x00, 0x03, 0x00, 0x00,
		0x00, 0x04, 0x00, 0x00, 0x00, 0x05, 0x00, 0x00, 0x00, 0x06, 0x00, 0x00,
		0x00, 0x07, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, 0x09, 0x00, 0x00,
		0x00, 0x0a, 0x00, 0x00, 0x00, 0x0b, 0x00, 0x00, 0x00, 0x0c, 0x00, 0x00,
		0x00, 0x0d, 0x00, 0x00, 0x00, 0x0e, 0x00, 0x00, 0x00
};

GTEST_TEST(NFOFile, getPortrait) {
	const Aurora::NFOFile nfo(new Common::MemoryReadStream(kNFOFile));

	EXPECT_STREQ(nfo.getPortrait0().c_str(), "po_pmha4");
	EXPECT_TRUE(nfo.getPortrait1().empty());
	EXPECT_TRUE(nfo.getPortrait2().empty());
}

GTEST_TEST(NFOFile, getTimePlayed) {
	const Aurora::NFOFile nfo(new Common::MemoryReadStream(kNFOFile));

	EXPECT_EQ(nfo.getTimePlayed(), 72);
}


GTEST_TEST(NFOFile, getAreaName) {
	const Aurora::NFOFile nfo(new Common::MemoryReadStream(kNFOFile));

	EXPECT_STREQ(nfo.getAreaName().c_str(), "Endar Spire - Kommandomodul");
}

GTEST_TEST(NFOFile, getSaveName) {
	const Aurora::NFOFile nfo(new Common::MemoryReadStream(kNFOFile));

	EXPECT_STREQ(nfo.getSaveName().c_str(), "test");
}
