/* xoreos - A reimplementation of BioWare's Aurora engine
 *
 * xoreos is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  Make the render window display our icon.
 */

#ifdef WIN32
	#define WIN32_LEAN_AND_MEAN
	#include <windows.h>

	#include "src/common/fallthrough.h"
	START_IGNORE_IMPLICIT_FALLTHROUGH
	#include <SDL_syswm.h>
	STOP_IGNORE_IMPLICIT_FALLTHROUGH
#endif

#include <cstring>

#include "src/graphics/icon.h"

namespace Graphics {

#if !defined(MACOSX)
/** Static version of the xoreos icon. */
static const byte kStaticIcon[32 * 32 * 4] = {
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x33,0x33,0x0A,
	0x28,0x28,0x28,0x33,0x28,0x28,0x28,0x33,0x27,0x27,0x27,0x27,0x2B,0x2B,0x2B,0x1E,
	0x00,0x00,0x00,0x02,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x2C,0x2C,0x2C,0x17,0x26,0x26,0x26,0x22,0x28,0x28,0x28,0x33,0x28,0x28,0x28,0x33,
	0x2C,0x2C,0x2C,0x17,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x2A,0x2A,0x31,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xF3,0x28,0x28,0x28,0xBD,0x27,0x27,0x27,0x6F,0x22,0x22,0x22,0x0F,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x40,0x40,0x40,0x04,0x29,0x29,0x29,0x57,0x29,0x29,0x29,0xAA,0x28,0x28,0x28,0xE9,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x29,0x29,0x29,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x2A,0x2A,0x31,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xF1,
	0x27,0x27,0x27,0x75,0x33,0x33,0x33,0x05,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x28,0x28,0x28,0x4D,
	0x28,0x28,0x28,0xDD,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x29,0x29,0x29,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x2A,0x2A,0x31,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xC5,0x27,0x27,0x27,0x1A,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x33,0x33,0x33,0x05,0x28,0x28,0x28,0x94,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x29,0x29,0x29,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x2A,0x2A,0x31,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xE0,0x24,0x24,0x24,0x23,
	0x2B,0x2B,0x2B,0x06,0x28,0x28,0x28,0xB3,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x29,0x29,0x29,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x27,0x27,0x27,0x21,
	0x29,0x29,0x29,0xAA,0x29,0x29,0x29,0xAA,0x29,0x29,0x29,0xB6,0x28,0x28,0x28,0xD1,
	0x28,0x28,0x28,0xFC,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xD5,
	0x29,0x29,0x29,0x9D,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xDD,0x28,0x28,0x28,0xC0,0x29,0x29,0x29,0xAA,0x29,0x29,0x29,0xAA,
	0x29,0x29,0x29,0x4B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x29,0x29,0x29,0x19,0x28,0x28,0x28,0x7E,0x28,0x28,0x28,0xF1,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFB,0x28,0x28,0x28,0x9E,0x29,0x29,0x29,0x2C,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x26,0x26,0x26,0x22,0x28,0x28,0x28,0xD8,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xED,0x27,0x27,0x27,0x42,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x26,0x26,0x26,0x1B,
	0x28,0x28,0x28,0xE3,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xF8,
	0x27,0x27,0x27,0x3B,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x29,0x29,0x29,0x4B,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0x7F,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x29,0x29,0x29,0xD6,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xF9,0x30,0x30,0x30,0x10,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x28,0x28,0x28,0x87,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xC0,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x28,0x28,0x28,0x60,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x29,0x29,0x29,0x9D,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x27,0x27,0x27,0x5C,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0x99,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x27,0x27,0x27,0x7B,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x27,0x27,0x27,0xB5,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x29,0x29,0x29,0xC3,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xF2,0x2B,0x2B,0x2B,0x06,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x28,0x28,0x28,0x2D,0x28,0x28,0x28,0xFD,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x29,0x29,0x29,0x5E,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x40,0x40,0x40,0x04,
	0x28,0x28,0x28,0xC0,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xE4,
	0x24,0x24,0x24,0x15,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x33,0x33,0x33,0x05,0x28,0x28,0x28,0x9E,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x29,0x29,0x29,0xC3,0x28,0x28,0x28,0x13,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x2A,0x2A,0x2A,0x31,0x28,0x28,0x28,0xC6,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xE1,0x29,0x29,0x29,0x51,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2C,0x2C,0x2C,0x17,
	0x29,0x29,0x29,0x77,0x29,0x29,0x29,0x77,0x29,0x29,0x29,0x77,0x28,0x28,0x28,0x8C,
	0x28,0x28,0x28,0xC8,0x28,0x28,0x28,0xFD,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xF0,
	0x28,0x28,0x28,0xCD,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xDB,
	0x29,0x29,0x29,0x97,0x27,0x27,0x27,0x7C,0x29,0x29,0x29,0x77,0x29,0x29,0x29,0x77,
	0x26,0x26,0x26,0x35,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x2A,0x2A,0x31,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xF9,0x29,0x29,0x29,0x4B,
	0x27,0x27,0x27,0x1A,0x28,0x28,0x28,0xE0,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x29,0x29,0x29,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x2A,0x2A,0x31,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xEE,0x29,0x29,0x29,0x45,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x24,0x24,0x24,0x1C,0x27,0x27,0x27,0xCF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x29,0x29,0x29,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x2A,0x2A,0x31,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xB9,0x27,0x27,0x27,0x21,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x1C,0x1C,0x1C,0x09,0x28,0x28,0x28,0x91,
	0x28,0x28,0x28,0xFC,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x29,0x29,0x29,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x2A,0x2A,0x2A,0x31,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xF7,0x28,0x28,0x28,0xB3,0x29,0x29,0x29,0x44,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x25,0x25,0x25,0x29,0x27,0x27,0x27,0x9B,0x28,0x28,0x28,0xEB,0x28,0x28,0x28,0xFF,
	0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,0x28,0x28,0x28,0xFF,
	0x29,0x29,0x29,0x71,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x26,0x26,0x26,0x14,
	0x28,0x28,0x28,0x66,0x28,0x28,0x28,0x66,0x28,0x28,0x28,0x66,0x27,0x27,0x27,0x62,
	0x28,0x28,0x28,0x3A,0x33,0x33,0x33,0x0A,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x03,0x27,0x27,0x27,0x2E,
	0x27,0x27,0x27,0x5B,0x28,0x28,0x28,0x66,0x28,0x28,0x28,0x66,0x28,0x28,0x28,0x66,
	0x28,0x28,0x28,0x2D,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,
	0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00
};

static SDL_Surface *createStaticIconSurface() {
	uint32_t rMask, gMask, bMask, aMask;

#if SDL_BYTEORDER == SDL_BIG_ENDIAN
	rMask = 0xFF000000;
	gMask = 0x00FF0000;
	bMask = 0x0000FF00;
	aMask = 0x000000FF;
#else
	rMask = 0x000000FF;
	gMask = 0x0000FF00;
	bMask = 0x00FF0000;
	aMask = 0xFF000000;
#endif

	SDL_Surface *surface = SDL_CreateRGBSurface(0, 32, 32, 32, rMask, gMask, bMask, aMask);
	memcpy(surface->pixels, kStaticIcon, sizeof(kStaticIcon));

	return surface;
}

static void setStaticIcon(SDL_Window &window) {
	SDL_Surface *icon = createStaticIconSurface();

	SDL_SetWindowIcon(&window, icon);

	SDL_FreeSurface(icon);
}
#endif // MACOSX

#if defined(WIN32)
static bool setWindowsIcon(SDL_Window &window) {
	HMODULE handle = GetModuleHandle(0);
	HICON   ico    = LoadIcon(handle, MAKEINTRESOURCE(1001 /* IDI_ICON */));

	if (!ico)
		return false;

	SDL_SysWMinfo sdlWMInfo;

	SDL_VERSION(&sdlWMInfo.version);
	if (!SDL_GetWindowWMInfo(&window, &sdlWMInfo))
		return false;

	SetClassLongPtr(sdlWMInfo.info.win.window, GCLP_HICON, (ULONG_PTR)ico);

	return GetLastError() == ERROR_SUCCESS;
}
#endif

void setWindowIcon(SDL_Window &window) {
#if defined(WIN32)
	// Try to set the windows icon from the ICO in the resources.
	// If that fails, use the static icon.

	if (!setWindowsIcon(window))
		setStaticIcon(window);

#elif defined(MACOSX)
	(void)window;
	// Do nothing on Mac OS X. The external icon is pulled in by default already.

#else
	/* TODO: We should try setting _NET_WM_ICON on GNU/Linux to get support for scalable
	 *       icons there as well. Additionally, XSetWMHints() should be used for
	 *       window manager that do not support _NET_WM_ICON (like e16).
	 */

	setStaticIcon(window);
#endif
}

} // End of namespace Graphics
