/* xoreos - A reimplementation of BioWare's Aurora engine
 *
 * xoreos is the legal property of its developers, whose names
 * can be found in the AUTHORS file distributed with this source
 * distribution.
 *
 * xoreos is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 3
 * of the License, or (at your option) any later version.
 *
 * xoreos is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with xoreos. If not, see <http://www.gnu.org/licenses/>.
 */

/** @file
 *  All currently known resource file names in Sonic Chronicles: The Dark Brotherhood.
 */

#ifndef ENGINES_SONIC_FILES_H
#define ENGINES_SONIC_FILES_H

namespace Engines {

namespace Sonic {

static const char * const kFiles[] = {
	// test_[efigs].herf
	"attack1_bs.tga",
	"chap10scr_bot.tga",
	"chap1scr_bot.tga",
	"chap2scr_bot.tga",
	"chap3scr_bot.tga",
	"chap4scr_bot.tga",
	"chap5scr_bot.tga",
	"chap6scr_bot.tga",
	"chap7scr_bot.tga",
	"chap8_cha_scr_bot.tga",
	"chap8_scy_scr_bot.tga",
	"chap9_cha_scr_bot.tga",
	"chap9_scy_scr_bot.tga",
	"introscr_bot.tga",
	"introscr_top.tga",
	"cbt_victory.ncgr",
	"cbt_victory.ncer",
	"cbt_victory.nanr",
	"cbt_trapd_ms.ncgr",
	"cbt_trapd_ms.ncer",
	"cbt_trapd_ms.nanr",
	"cbt_rndround0.ncgr",
	"cbt_rndround1.ncgr",

	// test.herf
	"2da.gda",
	"3x3panel64x64.gui",
	"a1c1_amy.dlg",
	"a1c1_amysmash.gff",
	"a1c1_amy_test.dlg",
	"a1c1_blockfall_camera.gff",
	"a1c1_block_fall_1.gff",
	"a1c1_block_fall_2.gff",
	"a1c1_block_fall_3.gff",
	"a1c1_block_fall_4.gff",
	"a1c1_block_fall_5.gff",
	"a1c1_block_fall_hold.gff",
	"a1c1_captain.dlg",
	"a1c1_combat_tutorial.gff",
	"a1c1_cream.dlg",
	"a1c1_dock_face_sw.gff",
	"a1c1_droneenter.gff",
	"a1c1_drones.dlg",
	"a1c1_enemytype_tutorial.gff",
	"a1c1_exitdock.gff",
	"a1c1_explore_tutorial.gff",
	"a1c1_firstcombathold.gff",
	"a1c1_first_enemy.gff",
	"a1c1_first_enemy_defeated.gff",
	"a1c1_first_enemy_hold.gff",
	"a1c1_forceamy.gff",
	"a1c1_forcerouge.gff",
	"a1c1_forcetails.gff",
	"a1c1_journal_tutorial.gff",
	"a1c1_nocturnappear.gff",
	"a1c1_rouge.dlg",
	"a1c1_rougeblock.gff",
	"a1c1_rougetalkcommand.gff",
	"a1c1_rougewalkgun.gff",
	"a1c1_rouge_stronghold.gff",
	"a1c1_rouge_test.dlg",
	"a1c1_scoutattack.gff",
	"a1c1_scoutattackson.gff",
	"a1c1_scout_sonic_backs_off.gff",
	"a1c1_sonicholddrone.gff",
	"a1c1_sonictalkcommand.gff",
	"a1c1_sonicwaitsmash.gff",
	"a1c1_sonicwaitsmash2.gff",
	"a1c1_sonicwalkgun.gff",
	"a1c1_sonic_chase_drone.gff",
	"a1c1_sonic_mainland.gff",
	"a1c1_swatbot_arrive.gff",
	"a1c1_swatbot_arrive_b.gff",
	"a1c1_swatbot_defeated.gff",
	"a1c1_swatbot_move.gff",
	"a1c1_swatboy_camera_pan.gff",
	"a1c1_tails.dlg",
	"a1c1_tails_test.dlg",
	"a1c1_tails_woodsman.dlg",
	"a1c1_woodsman.dlg",
	"a1c2_approachgas.gff",
	"a1c2_approachknuckles.gff",
	"a1c2_bigentrance.gff",
	"a1c2_bigentrance_panto.gff",
	"a1c2_commander.dlg",
	"a1c2_guardiandefeated.gff",
	"a1c2_guardiandefeated_camera.gff",
	"a1c2_gunblock.gff",
	"a1c2_guncommandermission.gff",
	"a1c2_hideoutenemy.gff",
	"a1c2_hideoutenter.gff",
	"a1c2_hideouthold.gff",
	"a1c2_knuckles.dlg",
	"a1c2_knuckles.gff",
	"a1c2_knucklespunch.gff",
	"a1c2_knuckles_bot1.gff",
	"a1c2_knuckles_bot2.gff",
	"a1c2_knuckles_moves.gff",
	"a1c2_mugger_approach.gff",
	"a1c2_mugger_camera.gff",
	"a1c2_prisonescape.gff",
	"a1c2_robot2_dies.gff",
	"a1c2_robot_flies.gff",
	"a1c2_soldiers.dlg",
	"a1c2_soldiers_2.dlg",
	"a1c2_sonic_meets_knuckles.gff",
	"a1c2_startknucklesescape.gff",
	"a1c2_swampsounds.gff",
	"a1c2_waitforbig.gff",
	"a1c3_beforeshadow.gff",
	"a1c3_boy.dlg",
	"a1c3_campan_shadow_1.gff",
	"a1c3_eggman.dlg",
	"a1c3_eggman.gff",
	"a1c3_eggman_bot1.gff",
	"a1c3_eggman_bot2.gff",
	"a1c3_eggman_bot3.gff",
	"a1c3_eggman_hold.gff",
	"a1c3_eggman_warp_workshop.gff",
	"a1c3_forcefield.dlg",
	"a1c3_hide_forcefield.gff",
	"a1c3_reunion_boy.gff",
	"a1c3_reunion_boy2.gff",
	"a1c3_reunion_father.gff",
	"a1c3_reunion_father2.gff",
	"a1c3_reunion_hold.gff",
	"a1c3_reunion_hold2.gff",
	"a1c3_reunion_hold3.gff",
	"a1c3_roadblock_gone.gff",
	"a1c3_salesman.dlg",
	"a1c3_scorpion_attack.gff",
	"a1c3_sentinels_appear.gff",
	"a1c3_sentinels_appear2.gff",
	"a1c3_sentry.gff",
	"a1c3_sentryattack1.gff",
	"a1c3_sentryattack2.gff",
	"a1c3_sentryhint.gff",
	"a1c3_sentryhint2.gff",
	"a1c3_shadow.dlg",
	"a1c3_shadowavoid.gff",
	"a1c3_shadowbattle.gff",
	"a1c3_shadowescape.gff",
	"a1c3_shadowknockdown.gff",
	"a1c3_shadow_avoid_reset.gff",
	"a1c3_shadow_branch.gff",
	"a1c3_shadow_enter.gff",
	"a1c3_shadow_enter_hold.gff",
	"a1c3_shadow_runby.gff",
	"a1c3_shopkeeper.dlg",
	"a1c3_swatbot.dlg",
	"a1c3_swatbot_hold.gff",
	"a1c3_swatbot_move.gff",
	"a1c3_tails_events.dlg",
	"a1c3_tracker_device.gff",
	"a1c3_tracker_device2.gff",
	"a1c4_after_outhouse.gff",
	"a1c4_amytrysmash.gff",
	"a1c4_bathroom_reset.gff",
	"a1c4_blueridge_ice_1.gff",
	"a1c4_blueridge_ice_2.gff",
	"a1c4_brzarrive.gff",
	"a1c4_brz_snowmelt.gff",
	"a1c4_resetsonic.gff",
	"a1c4_reset_party_puzzle.gff",
	"a1c4_shade.dlg",
	"a1c4_shade_enter.gff",
	"a1c4_shade_escape.gff",
	"a1c4_shade_sonichold.gff",
	"a1c4_shadowflee.gff",
	"a1c4_shadowsonicchase.gff",
	"a1c4_shadow_runby.gff",
	"a1c4_shadow_shadowfight.gff",
	"a1c4_shadow_sonichold.gff",
	"a1c4_shadow_sonicrun.gff",
	"a1c4_shadow_turn_around.gff",
	"a1c4_sonic_send_gun.gff",
	"a1c4_tailstalk.gff",
	"a1c4_warptobrz.gff",
	"a1c5p6_tailsstart.gff",
	"a1c5_captainsonichold.gff",
	"a1c5_found_omega.gff",
	"a1c5_ix.dlg",
	"a1c5_omega_party_select.gff",
	"a1c5_p2_end_warp.gff",
	"a1c5_p2_pathblock.gff",
	"a1c5_p2_start.gff",
	"a1c5_p3_airbase_cutscene.gff",
	"a1c5_p3_hijack.gff",
	"a1c5_p4_start.gff",
	"a1c5_p5_camera_pan_marauder.gff",
	"a1c5_p5_camera_pan_sonic.gff",
	"a1c5_p5_captaindefeated.gff",
	"a1c5_p5_captainsonichold.gff",
	"a1c5_p5_captainsoundalarm.gff",
	"a1c5_p5_end.gff",
	"a1c5_p5_shipattacked.gff",
	"a1c5_p5_shipattacked_b.gff",
	"a1c5_p5_shipattacked_c.gff",
	"a1c5_p5_shipcannondestroyed.gff",
	"a1c5_p6_approachcannon.gff",
	"a1c5_p6_begin.gff",
	"a1c5_p6_guardian_defeated.gff",
	"a1c5_p6_guardian_enter.gff",
	"a1c5_p6_guardian_hold.gff",
	"a1c5_p6_repaircannon.gff",
	"a1c5_p6_repaircannontrigger.gff",
	"a1c5_p7_10_scout.gff",
	"a1c5_p7_1_shade.gff",
	"a1c5_p7_2_shade.gff",
	"a1c5_p7_3_ix.gff",
	"a1c5_p7_4_sonic.gff",
	"a1c5_p7_5_knuckles.gff",
	"a1c5_p7_6_shade.gff",
	"a1c5_p7_7_ix.gff",
	"a1c5_p7_8_shade.gff",
	"a1c5_p7_9_gizoid.gff",
	"a1c5_p7_approachix.gff",
	"a1c5_p7_badguys.gff",
	"a1c5_p8_eggmantalk.gff",
	"a1c5_p8_end.gff",
	"a1c5_p8_transition.gff",
	"a1c5_p9_after_shade_movie.gff",
	"a1c5_p9_end.gff",
	"a1c5_p9_gizoiddefeat.gff",
	"a1c5_p9_ixattacks.gff",
	"a1c5_p9_ixruns.gff",
	"a1c5_p9_quakeescape.gff",
	"a1c5_p9_scene1.gff",
	"a1c5_p9_scene2.gff",
	"a1c5_p9_scene2b.gff",
	"a1c5_p9_scene2c.gff",
	"a1c5_p9_scene3.gff",
	"a1c5_p9_scoutremoved_a.gff",
	"a1c5_p9_scoutremoved_b.gff",
	"a1c5_p9_shaderemoved.gff",
	"a1c5_p9_sonicchases.gff",
	"a1c5_p9_sonicemerges.gff",
	"a1c5_partysplit.gff",
	"a1c5_shadow_soniccamerahold.gff",
	"a1c5_sonic.dlg",
	"a1c5_stronghold_enter.gff",
	"a1c8_swatbot_attack.gff",
	"a1intro.dlg",
	"a1s3_sonic_wait_worm3.gff",
	"a1sq_factoryforeman.dlg",
	"a1sq_factoryworker.dlg",
	"a1sq_gangster.dlg",
	"a1sq_gunagent.dlg",
	"a1sq_laddie.dlg",
	"a1sq_official.dlg",
	"a1sq_official.gff",
	"a1sq_official2.gff",
	"a1sq_official3.gff",
	"a1sq_outhouse.dlg",
	"a1sq_projectors.dlg",
	"a1sq_scientist.dlg",
	"a1sq_timmy.dlg",
	"a1sq_waspguy.dlg",
	"a1sq_well.dlg",
	"a1_big.dlg",
	"a1_bigjoinpartyselect.gff",
	"a1_creamjoinpartyselect.gff",
	"a1_findcheese.gff",
	"a1_s1_card_b1.nbfp",
	"a1_s1_card_b1.nbfs",
	"a1_s1_card_t1.nbfp",
	"a1_s1_card_t1.nbfs",
	"a1_s1_card_t2.nbfp",
	"a1_s1_card_t2.nbfs",
	"a1_s1_eggman_lair_enter.gff",
	"a1_s1_ex.are",
	"a1_s1_ex.walk.tga",
	"a1_s1_ex_boatwinchnorth.gff",
	"a1_s1_ex_boatwinchsouth.gff",
	"a1_s1_ex_la.smp",
	"a1_s1_ex_la_soundmap.gda",
	"a1_s1_ex_mm.nbfp",
	"a1_s1_ex_mm.nbfs",
	"a1_s1_ex_mm.nclr",
	"a1_s1_ex_playerwinchnorth.gff",
	"a1_s1_ex_playerwinchsouth.gff",
	"a1_s1_ex_scientist1.gff",
	"a1_s1_ex_scientist2.gff",
	"a1_s1_ex_scientist3.gff",
	"a1_s1_ex_scientist4.gff",
	"a1_s1_ex_scientist5.gff",
	"a1_s1_ex_scientist6.gff",
	"a1_s1_ex_slide1.gff",
	"a1_s1_ex_slide2.gff",
	"a1_s1_ex_slide3.gff",
	"a1_s1_ex_slide4.gff",
	"a1_s1_ex_slide5.gff",
	"a1_s1_ex_slide6.gff",
	"a1_s1_ex_slide7.gff",
	"a1_s1_i01.are",
	"a1_s1_i01.walk.tga",
	"a1_s1_i01_mm.nclr",
	"a1_s1_i01_ts.nbfp",
	"a1_s1_i01_ts.nbfs",
	"a1_s1_i02.are",
	"a1_s1_i02.walk.tga",
	"a1_s1_i02_mm.nclr",
	"a1_s1_i02_ts.nbfp",
	"a1_s1_i02_ts.nbfs",
	"a1_s1_i03.are",
	"a1_s1_i03.walk.tga",
	"a1_s1_i03_mm.nclr",
	"a1_s1_i03_ts.nbfp",
	"a1_s1_i03_ts.nbfs",
	"a1_s1_i04.are",
	"a1_s1_i04.walk.tga",
	"a1_s1_i04_mm.nclr",
	"a1_s1_i04_ts.nbfp",
	"a1_s1_i04_ts.nbfs",
	"a1_s1_i05.are",
	"a1_s1_i05.walk.tga",
	"a1_s1_i05_mm.nclr",
	"a1_s1_i05_ts.nbfp",
	"a1_s1_i05_ts.nbfs",
	"a1_s1_i05_v2.are",
	"a1_s2_card_b1.nbfp",
	"a1_s2_card_b1.nbfs",
	"a1_s2_card_t1.nbfp",
	"a1_s2_card_t1.nbfs",
	"a1_s2_card_t2.nbfp",
	"a1_s2_card_t2.nbfs",
	"a1_s2_ex.are",
	"a1_s2_ex.walk.tga",
	"a1_s2_ex_door1.gff",
	"a1_s2_ex_door2.gff",
	"a1_s2_ex_la.smp",
	"a1_s2_ex_la_soundmap.gda",
	"a1_s2_ex_mm.nbfp",
	"a1_s2_ex_mm.nbfs",
	"a1_s2_ex_mm.nclr",
	"a1_s2_ex_pipe_down.gff",
	"a1_s2_ex_pipe_up.gff",
	"a1_s2_ex_slide1.gff",
	"a1_s2_ex_slide2.gff",
	"a1_s2_ex_slide3.gff",
	"a1_s2_ex_slide4.gff",
	"a1_s2_ex_slide4_down_right.gff",
	"a1_s2_ex_slide5_down_left.gff",
	"a1_s2_ex_slide6.gff",
	"a1_s2_ex_slide7.gff",
	"a1_s2_ex_tails_fly_se_1.gff",
	"a1_s2_i01.are",
	"a1_s2_i01.walk.tga",
	"a1_s2_i01_mm.nclr",
	"a1_s2_i01_ts.nbfp",
	"a1_s2_i01_ts.nbfs",
	"a1_s2_i02_mm.nclr",
	"a1_s2_i02_ts.nbfp",
	"a1_s2_i02_ts.nbfs",
	"a1_s2_i03.are",
	"a1_s2_i03.walk.tga",
	"a1_s2_i03_mm.nclr",
	"a1_s2_i03_ts.nbfp",
	"a1_s2_i03_ts.nbfs",
	"a1_s2_i04.are",
	"a1_s2_i04.walk.tga",
	"a1_s2_i04_mm.nclr",
	"a1_s2_i04_ts.nbfp",
	"a1_s2_i04_ts.nbfs",
	"a1_s2_i05.are",
	"a1_s2_i05.walk.tga",
	"a1_s2_i05_mm.nclr",
	"a1_s2_i05_ts.nbfp",
	"a1_s2_i05_ts.nbfs",
	"a1_s2_i06.are",
	"a1_s2_i06.walk.tga",
	"a1_s2_i06_mm.nclr",
	"a1_s2_i06_ts.nbfp",
	"a1_s2_i06_ts.nbfs",
	"a1_s2_i07.are",
	"a1_s2_i07.walk.tga",
	"a1_s3_card_b1.nbfp",
	"a1_s3_card_b1.nbfs",
	"a1_s3_card_t1.nbfp",
	"a1_s3_card_t1.nbfs",
	"a1_s3_card_t2.nbfp",
	"a1_s3_card_t2.nbfs",
	"a1_s3_ex.are",
	"a1_s3_ex.walk.tga",
	"a1_s3_ex_door1.gff",
	"a1_s3_ex_door2.gff",
	"a1_s3_ex_la.smp",
	"a1_s3_ex_la_soundmap.gda",
	"a1_s3_ex_mm.nbfp",
	"a1_s3_ex_mm.nbfs",
	"a1_s3_ex_mm.nclr",
	"a1_s3_ex_slide1.gff",
	"a1_s3_ex_slide2.gff",
	"a1_s3_ex_slide3.gff",
	"a1_s3_ex_slide4.gff",
	"a1_s3_ex_slide5.gff",
	"a1_s3_ex_slide6.gff",
	"a1_s3_ex_slide7.gff",
	"a1_s3_ex_vent.gff",
	"a1_s3_giantworm1_appear.gff",
	"a1_s3_giantworm1_hold.gff",
	"a1_s3_giantworm2_appear.gff",
	"a1_s3_giantworm2_hold.gff",
	"a1_s3_giantworm3_appear.gff",
	"a1_s3_giantworm3_hold.gff",
	"a1_s3_i01.are",
	"a1_s3_i01.walk.tga",
	"a1_s3_i01_1to2.gff",
	"a1_s3_i01_2to1.gff",
	"a1_s3_i01_2to3.gff",
	"a1_s3_i01_2to4.gff",
	"a1_s3_i01_2to5.gff",
	"a1_s3_i01_3to2.gff",
	"a1_s3_i01_4to2.gff",
	"a1_s3_i01_4to6.gff",
	"a1_s3_i01_5to2.gff",
	"a1_s3_i01_6to4.gff",
	"a1_s3_i02.are",
	"a1_s3_i02.walk.tga",
	"a1_s3_i02_mm.nclr",
	"a1_s3_i02_ts.nbfp",
	"a1_s3_i02_ts.nbfs",
	"a1_s3_i03.are",
	"a1_s3_i03.walk.tga",
	"a1_s4_card_b1.nbfp",
	"a1_s4_card_b1.nbfs",
	"a1_s4_card_t1.nbfp",
	"a1_s4_card_t1.nbfs",
	"a1_s4_card_t2.nbfp",
	"a1_s4_card_t2.nbfs",
	"a1_s4_ex.are",
	"a1_s4_ex.walk.tga",
	"a1_s4_ex_la.smp",
	"a1_s4_ex_la_soundmap.gda",
	"a1_s4_ex_mm.nbfp",
	"a1_s4_ex_mm.nbfs",
	"a1_s4_ex_mm.nclr",
	"a1_s4_ex_slide1.gff",
	"a1_s4_ex_slide2.gff",
	"a1_s4_ex_slide3.gff",
	"a1_s4_ex_slide4.gff",
	"a1_s4_ex_slide5.gff",
	"a1_s4_ex_slide6.gff",
	"a1_s4_ex_slide7.gff",
	"a1_s4_ex_slide8.gff",
	"a1_s4_i01.are",
	"a1_s4_i01.walk.tga",
	"a1_s4_i01_ts.nbfp",
	"a1_s4_i01_ts.nbfs",
	"a1_s5_card_b1.nbfp",
	"a1_s5_card_b1.nbfs",
	"a1_s5_card_b2.nbfp",
	"a1_s5_card_b2.nbfs",
	"a1_s5_card_t1.nbfp",
	"a1_s5_card_t1.nbfs",
	"a1_s5_card_t2.nbfp",
	"a1_s5_card_t2.nbfs",
	"a1_s5_ex.are",
	"a1_s5_ex.walk.tga",
	"a1_s5_ex_escalator_down.gff",
	"a1_s5_ex_escalator_up.gff",
	"a1_s5_ex_la.smp",
	"a1_s5_ex_la_soundmap.gda",
	"a1_s5_ex_mm.nbfp",
	"a1_s5_ex_mm.nbfs",
	"a1_s5_ex_mm.nclr",
	"a1_s5_ex_slide1.gff",
	"a1_s5_ex_slide10.gff",
	"a1_s5_ex_slide11.gff",
	"a1_s5_ex_slide12.gff",
	"a1_s5_ex_slide13.gff",
	"a1_s5_ex_slide14.gff",
	"a1_s5_ex_slide15.gff",
	"a1_s5_ex_slide2.gff",
	"a1_s5_ex_slide3.gff",
	"a1_s5_ex_slide4.gff",
	"a1_s5_ex_slide5.gff",
	"a1_s5_ex_slide6.gff",
	"a1_s5_ex_slide7.gff",
	"a1_s5_ex_slide8.gff",
	"a1_s5_ex_slide9.gff",
	"a1_s5_i01.are",
	"a1_s5_i01.walk.tga",
	"a1_s5_i01b.are",
	"a1_s5_i02.are",
	"a1_s5_i02.walk.tga",
	"a1_s5_i02_ul.nbfp",
	"a1_s5_i02_ul.nbfs",
	"a1_s5_i03.are",
	"a1_s5_i03.walk.tga",
	"a1_s5_i03_ts.nbfp",
	"a1_s5_i03_ts.nbfs",
	"a1_s5_i04.are",
	"a1_s5_i04.walk.tga",
	"a1_s5_i04_ts.nbfp",
	"a1_s5_i04_ts.nbfs",
	"a1_s6_card_b1.nbfp",
	"a1_s6_card_b1.nbfs",
	"a1_s6_card_t1.nbfp",
	"a1_s6_card_t1.nbfs",
	"a1_s6_card_t2.nbfp",
	"a1_s6_card_t2.nbfs",
	"a1_s6_ex.are",
	"a1_s6_ex.walk.tga",
	"a1_s6_ex_la.smp",
	"a1_s6_ex_la_soundmap.gda",
	"a1_s6_ex_mm.nbfp",
	"a1_s6_ex_mm.nbfs",
	"a1_s6_ex_mm.nclr",
	"a1_s6_ex_slide1.gff",
	"a1_s6_underlay.nbfp",
	"a1_s6_underlay.nbfs",
	"a1_shadowjoinpartyselect.gff",
	"a1_w0_ai.nclr",
	"a1_w0_ai_00.ncgr",
	"a1_w0_ai_01.ncgr",
	"a1_w0_ai_10.ncgr",
	"a1_w0_ai_11.ncgr",
	"a1_w0_br.nclr",
	"a1_w0_br_01.ncgr",
	"a1_w0_br_02.ncgr",
	"a1_w0_br_10.ncgr",
	"a1_w0_br_11.ncgr",
	"a1_w0_br_12.ncgr",
	"a1_w0_cc.nclr",
	"a1_w0_cc_00.ncgr",
	"a1_w0_cc_01.ncgr",
	"a1_w0_cc_10.ncgr",
	"a1_w0_cc_11.ncgr",
	"a1_w0_gh.nclr",
	"a1_w0_gh_00.ncgr",
	"a1_w0_gh_01.ncgr",
	"a1_w0_gh_02.ncgr",
	"a1_w0_gh_10.ncgr",
	"a1_w0_gh_11.ncgr",
	"a1_w0_gh_12.ncgr",
	"a1_w0_mr.nclr",
	"a1_w0_mr_00.ncgr",
	"a1_w0_mr_01.ncgr",
	"a1_w0_mt.nclr",
	"a1_w0_mt_00.ncgr",
	"a1_w0_mt_01.ncgr",
	"a1_w0_mt_11.ncgr",
	"a1_w0_ul.nbfp",
	"a1_w0_ul.nbfs",
	"a1_w1_br.nclr",
	"a1_w1_br_01.ncgr",
	"a1_w1_br_02.ncgr",
	"a1_w1_br_10.ncgr",
	"a1_w1_br_11.ncgr",
	"a1_w1_br_12.ncgr",
	"a1_w1_cc.nclr",
	"a1_w1_cc_00.ncgr",
	"a1_w1_cc_01.ncgr",
	"a1_w1_cc_10.ncgr",
	"a1_w1_cc_11.ncgr",
	"a1_w1_gh.nclr",
	"a1_w1_gh_00.ncgr",
	"a1_w1_gh_01.ncgr",
	"a1_w1_gh_02.ncgr",
	"a1_w1_gh_10.ncgr",
	"a1_w1_gh_11.ncgr",
	"a1_w1_gh_12.ncgr",
	"a1_w1_mr.nclr",
	"a1_w1_mr_00.ncgr",
	"a1_w1_mr_01.ncgr",
	"a1_w1_mt.nclr",
	"a1_w1_mt_00.ncgr",
	"a1_w1_mt_01.ncgr",
	"a1_w1_mt_11.ncgr",
	"a1_w1_ul.nbfp",
	"a1_w1_ul.nbfs",
	"a1_w2_ai.nclr",
	"a1_w2_ai_00.ncgr",
	"a1_w2_ai_01.ncgr",
	"a1_w2_ai_10.ncgr",
	"a1_w2_ai_11.ncgr",
	"a1_w2_br.nclr",
	"a1_w2_br_01.ncgr",
	"a1_w2_br_02.ncgr",
	"a1_w2_br_10.ncgr",
	"a1_w2_br_11.ncgr",
	"a1_w2_br_12.ncgr",
	"a1_w2_cc.nclr",
	"a1_w2_cc_00.ncgr",
	"a1_w2_cc_01.ncgr",
	"a1_w2_cc_10.ncgr",
	"a1_w2_cc_11.ncgr",
	"a1_w2_gh.nclr",
	"a1_w2_gh_00.ncgr",
	"a1_w2_gh_01.ncgr",
	"a1_w2_gh_02.ncgr",
	"a1_w2_gh_10.ncgr",
	"a1_w2_gh_11.ncgr",
	"a1_w2_gh_12.ncgr",
	"a1_w2_mr.nclr",
	"a1_w2_mr_00.ncgr",
	"a1_w2_mr_01.ncgr",
	"a1_w2_mt.nclr",
	"a1_w2_mt_00.ncgr",
	"a1_w2_mt_01.ncgr",
	"a1_w2_mt_11.ncgr",
	"a1_w2_ul.nbfp",
	"a1_w2_ul.nbfs",
	"a1_w3_ai.nclr",
	"a1_w3_ai_00.ncgr",
	"a1_w3_ai_01.ncgr",
	"a1_w3_ai_10.ncgr",
	"a1_w3_ai_11.ncgr",
	"a1_w3_br.nclr",
	"a1_w3_br_01.ncgr",
	"a1_w3_br_02.ncgr",
	"a1_w3_br_10.ncgr",
	"a1_w3_br_11.ncgr",
	"a1_w3_br_12.ncgr",
	"a1_w3_cc.nclr",
	"a1_w3_cc_00.ncgr",
	"a1_w3_cc_01.ncgr",
	"a1_w3_cc_10.ncgr",
	"a1_w3_cc_11.ncgr",
	"a1_w3_gh.nclr",
	"a1_w3_gh_00.ncgr",
	"a1_w3_gh_01.ncgr",
	"a1_w3_gh_02.ncgr",
	"a1_w3_gh_10.ncgr",
	"a1_w3_gh_11.ncgr",
	"a1_w3_gh_12.ncgr",
	"a1_w3_mr.nclr",
	"a1_w3_mr_00.ncgr",
	"a1_w3_mr_01.ncgr",
	"a1_w3_mt.nclr",
	"a1_w3_mt_00.ncgr",
	"a1_w3_mt_01.ncgr",
	"a1_w3_mt_11.ncgr",
	"a1_w3_ul.nbfp",
	"a1_w3_ul.nbfs",
	"a2c10_advgizoid1_attack.gff",
	"a2c10_advgizoid1_attack_end.gff",
	"a2c10_advgizoid_1.gff",
	"a2c10_advgizoid_2.gff",
	"a2c10_advgizoid_3.gff",
	"a2c10_advgizoid_4.gff",
	"a2c10_advgizoid_attack_begin.gff",
	"a2c10_arrivenocturn.gff",
	"a2c10_campanemerald.gff",
	"a2c10_charyb.dlg",
	"a2c10_charybarrives.gff",
	"a2c10_charyb_attack_1.gff",
	"a2c10_congress_enter.gff",
	"a2c10_delay_attack_nocturn.gff",
	"a2c10_disableinput.gff",
	"a2c10_emeraldfreed.gff",
	"a2c10_emeraldfreed_end.gff",
	"a2c10_emeraldfreed_ix.gff",
	"a2c10_emeraldfreed_sonic.gff",
	"a2c10_flooded_sewer_start.gff",
	"a2c10_gizoidshimmer1.gff",
	"a2c10_gizoidshimmer2.gff",
	"a2c10_gizoidshimmer3.gff",
	"a2c10_gizoidshutdownatk.gff",
	"a2c10_gizoidtalks.gff",
	"a2c10_hideix.gff",
	"a2c10_hologram_1_appear.gff",
	"a2c10_ix.dlg",
	"a2c10_ix_after_phase_1.gff",
	"a2c10_ix_attack_sonic.gff",
	"a2c10_ix_attack_sonic_2.gff",
	"a2c10_ix_attack_sonic_wait.gff",
	"a2c10_ix_attack_sonic_wait_2.gff",
	"a2c10_ix_disappears_team.gff",
	"a2c10_ix_final_battle.gff",
	"a2c10_ix_final_battle_wait.gff",
	"a2c10_ix_firstattack.gff",
	"a2c10_ix_gone.gff",
	"a2c10_ix_runn_battle.gff",
	"a2c10_ix_screenshake.gff",
	"a2c10_ix_transform_final.gff",
	"a2c10_ix_winning.gff",
	"a2c10_knucklesapproachix.gff",
	"a2c10_knucklesdisappears.gff",
	"a2c10_knucklesdisappears2.gff",
	"a2c10_knuckles_activate.gff",
	"a2c10_knuckles_face_scylla.gff",
	"a2c10_moveplayer.gff",
	"a2c10_nocstop_shake_1.gff",
	"a2c10_nocstop_shake_2.gff",
	"a2c10_nocstop_shake_3.gff",
	"a2c10_noct_stop_move.gff",
	"a2c10_noc_doors_left.gff",
	"a2c10_noc_doors_right.gff",
	"a2c10_noflyzone.gff",
	"a2c10_noflyzone_block.gff",
	"a2c10_noflyzone_cross.gff",
	"a2c10_noflyzone_intro.gff",
	"a2c10_p4_meet_gizoids.gff",
	"a2c10_partyjump.gff",
	"a2c10_remove_phase2_ix.gff",
	"a2c10_reposition_ix.gff",
	"a2c10_reposition_ix_2.gff",
	"a2c10_reposition_knuckles.gff",
	"a2c10_repulsor_dropped.gff",
	"a2c10_scylladefeated.gff",
	"a2c10_scylla_appears.gff",
	"a2c10_scylla_appears_knuckeshold.gff",
	"a2c10_scylla_appears_pan.gff",
	"a2c10_scylla_attacks.gff",
	"a2c10_sewerflood.gff",
	"a2c10_sewer_drain_2.gff",
	"a2c10_sewer_redirect.gff",
	"a2c10_shadedisappears.gff",
	"a2c10_shadedisappears2.gff",
	"a2c10_shadeknockdown.gff",
	"a2c10_shaderuns.gff",
	"a2c10_sonicenterchamber.gff",
	"a2c10_sonichold.gff",
	"a2c10_sonicknockback.gff",
	"a2c10_sonicwalk.gff",
	"a2c10_sonic_face_gizoids.gff",
	"a2c10_splitparty.gff",
	"a2c10_submerged_hack.gff",
	"a2c10_supersonic_revert.gff",
	"a2c10_switch_hack.gff",
	"a2c10_tauntedbygizoids.gff",
	"a2c10_tauntedbygizoids_2.gff",
	"a2c10_taunt_exit_1.gff",
	"a2c10_taunt_exit_2.gff",
	"a2c10_taunt_exit_3.gff",
	"a2c10_turret_destroyed.gff",
	"a2c10_turret_removed.gff",
	"a2c10_were_moving.gff",
	"a2c6_amyshout.gff",
	"a2c6_eggbot.dlg",
	"a2c6_entervault.gff",
	"a2c6_fadein.gff",
	"a2c6_generatorquake.gff",
	"a2c6_generator_bot.gff",
	"a2c6_generator_sonic.gff",
	"a2c6_intro_sonic.gff",
	"a2c6_vaultbot.gff",
	"a2c6_vaultbotattack.gff",
	"a2c6_vaultbotdefeated.gff",
	"a2c7_arrivekron.gff",
	"a2c7_enter_kron_interior.gff",
	"a2c7_exitship.gff",
	"a2c7_factory_door_left.gff",
	"a2c7_factory_door_right.gff",
	"a2c7_firstkrondefeated.gff",
	"a2c7_foremankrag.dlg",
	"a2c7_kronapproach.gff",
	"a2c7_kronapproach_pan.gff",
	"a2c7_kronbreakthrough.gff",
	"a2c7_kronciv.dlg",
	"a2c7_kronshop.dlg",
	"a2c7_kron_emerald_collect.gff",
	"a2c7_kron_soldier.gff",
	"a2c7_ksoldier1.dlg",
	"a2c7_landonkron.gff",
	"a2c7_tailstalkship.gff",
	"a2c7_tailstalkship2.gff",
	"a2c7_tailstalkship3.gff",
	"a2c8_arenaentry_1.gff",
	"a2c8_arenaentry_2.gff",
	"a2c8_arenaentry_3.gff",
	"a2c8_arenaentry_4.gff",
	"a2c8_exit_nrrgal.gff",
	"a2c8_messenger_pan.gff",
	"a2c8_nrrgal_guide.gff",
	"a2c8_scy_arenacomplete.gff",
	"a2c8_scy_arrestedtransition.gff",
	"a2c8_scy_arrestedtransition2.gff",
	"a2c8_scy_exitship.gff",
	"a2c8_scy_gateguardapproach.gff",
	"a2c8_scy_gateguardattack.gff",
	"a2c8_scy_gateguardhold.gff",
	"a2c8_scy_gateguardlead.gff",
	"a2c8_scy_gentleman1defeated.gff",
	"a2c8_scy_gentleman2defeated.gff",
	"a2c8_scy_messengerarrives.gff",
	"a2c8_scy_nrrgalattack1.gff",
	"a2c8_scy_nrrgalattack2.gff",
	"a2c8_scy_nrrgalattack3.gff",
	"a2c8_scy_nrrgalsurround1.gff",
	"a2c8_scy_nrrgalsurround2.gff",
	"a2c8_scy_nrrgalsurround3.gff",
	"a2c8_scy_nrrgalsurround4.gff",
	"a2c8_scy_nrrgalsurround5.gff",
	"a2c8_scy_nrrgalswarmattack.gff",
	"a2c8_scy_queenmorphout1.gff",
	"a2c8_scy_queenmorphout2.gff",
	"a2c8_scy_queenmorphout3.gff",
	"a2c8_scy_queenmorphout4.gff",
	"a2c8_scy_queenmorphout5.gff",
	"a2c8_scy_queenmorphout6.gff",
	"a2c8_scy_queenspawn.gff",
	"a2c8_scy_queenspawnarrive1.gff",
	"a2c8_scy_queenspawnarrive2.gff",
	"a2c8_scy_queenspawnarrive3.gff",
	"a2c8_scy_queenspawnarrive4.gff",
	"a2c8_scy_queenspawnarrive5.gff",
	"a2c8_scy_queenspawnarrive6.gff",
	"a2c8_scy_queenspawnhide.gff",
	"a2c8_scy_queenspawnhide_talk.gff",
	"a2c8_scy_queenspawnvfx.gff",
	"a2c8_scy_queenspawn_pause.gff",
	"a2c8_scy_queenspawn_pre_appear.gff",
	"a2c8_scy_raxosattack.gff",
	"a2c8_scy_raxosdefeated.gff",
	"a2c8_scy_raxosdelay.gff",
	"a2c8_scy_returnnrrgal.gff",
	"a2c8_scy_shiptotyxis.gff",
	"a2c8_scy_sonapproachemerald.gff",
	"a2c8_scy_sonicfollowguard.gff",
	"a2c8_scy_sonicholdmorphout.gff",
	"a2c8_scy_sonicwalkqueen.gff",
	"a2c8_scy_syraxappears.gff",
	"a2c8_scy_syraxapproach.gff",
	"a2c8_scy_tyxisarenaentercbt.gff",
	"a2c8_scy_tyxisarenaentercit.gff",
	"a2c8_scy_tyxisarrival.gff",
	"a2c8_scy_tyxischamberwarpin.gff",
	"a2c8_sonic_approach_guide.gff",
	"a2c8_tyxisarenadone.gff",
	"a2c8_tyxisdoneboardship.gff",
	"a2c9_attacknocturnmovie.gff",
	"a2c9_chest_move.gff",
	"a2ch10_councilenter.gff",
	"a2cha_aequi.dlg",
	"a2cha_alphavoxai.dlg",
	"a2cha_betavoxai.dlg",
	"a2cha_overmindattacks.gff",
	"a2cha_overmind_buddy1_leave.gff",
	"a2cha_overmind_buddy2_leave.gff",
	"a2cha_overmind_buddy3_leave.gff",
	"a2cha_overmind_buddy4_leave.gff",
	"a2cha_overmind_defeated_thebes.gff",
	"a2cha_overmind_sonic1.gff",
	"a2cha_overmind_sonic2.gff",
	"a2cha_overmind_thebes_buddy1.gff",
	"a2cha_overmind_thebes_buddy2.gff",
	"a2cha_overmind_thebes_buddy3.gff",
	"a2cha_overmind_thebes_buddy4.gff",
	"a2cha_overmind_thebes_leave.gff",
	"a2cha_overmind_thug1.gff",
	"a2cha_overmind_thug2.gff",
	"a2cha_teleporter.dlg",
	"a2cha_thebes.dlg",
	"a2cha_voxaib_teleport_fail.gff",
	"a2cha_voxaib_teleport_success.gff",
	"a2scy_drone1.dlg",
	"a2scy_drone2.dlg",
	"a2scy_queen.dlg",
	"a2scy_raxos.dlg",
	"a2scy_shop.dlg",
	"a2scy_swarm1.dlg",
	"a2scy_tyxcivs.dlg",
	"a2scy_tyxgate.dlg",
	"a2scy_tyxhqdoor.dlg",
	"a2scy_tyxshop.dlg",
	"a2scy_tyxwar1.dlg",
	"a2scy_tyxwar2.dlg",
	"a2scy_warrior1.dlg",
	"a2scy_warrior2.dlg",
	"a2sq_briefhistory.dlg",
	"a2sq_dragon.dlg",
	"a2sq_haniman.dlg",
	"a2sq_nestor.dlg",
	"a2sq_nrrgspawn.dlg",
	"a2sq_pirates.dlg",
	"a2sq_sonicstalker.gff",
	"a2sq_stalker2.gff",
	"a2sq_telra.dlg",
	"a2sq_thebeshouse.dlg",
	"a2sq_voxdad.dlg",
	"a2sq_voxnoct.dlg",
	"a2tyx_enemy_enter.gff",
	"a2_amy.dlg",
	"a2_chb_postthelxesonicsnap.gff",
	"a2_chb_thebesexit.gff",
	"a2_chb_thebesintro.gff",
	"a2_chb_thebesleaves.gff",
	"a2_chb_thebes_enters.gff",
	"a2_chb_thebes_zap.gff",
	"a2_chb_thelxeintro.gff",
	"a2_chb_thelxethug1.gff",
	"a2_chb_thelxethug2.gff",
	"a2_chb_thelxe_dies.gff",
	"a2_cream.dlg",
	"a2_ending.dlg",
	"a2_intro.dlg",
	"a2_knuckles.dlg",
	"a2_rouge.dlg",
	"a2_s1_card_b1.nbfp",
	"a2_s1_card_b1.nbfs",
	"a2_s1_card_t1.nbfp",
	"a2_s1_card_t1.nbfs",
	"a2_s1_card_t2.nbfp",
	"a2_s1_card_t2.nbfs",
	"a2_s1_ex.are",
	"a2_s1_ex.walk.tga",
	"a2_s1_ex_la.smp",
	"a2_s1_ex_la_soundmap.gda",
	"a2_s1_ex_mm.nbfp",
	"a2_s1_ex_mm.nbfs",
	"a2_s1_ex_mm.nclr",
	"a2_s1_ex_slide1.gff",
	"a2_s1_ex_slide2.gff",
	"a2_s1_ex_slide3.gff",
	"a2_s1_i01.are",
	"a2_s1_i01.walk.tga",
	"a2_s1_i02.are",
	"a2_s1_i02.walk.tga",
	"a2_s1_i02_ts.nbfp",
	"a2_s1_i02_ts.nbfs",
	"a2_s1_i03.are",
	"a2_s1_i03.walk.tga",
	"a2_s1_i03_ts.nbfp",
	"a2_s1_i03_ts.nbfs",
	"a2_s1_i04.are",
	"a2_s1_i04.walk.tga",
	"a2_s1_i04_ts.nbfp",
	"a2_s1_i04_ts.nbfs",
	"a2_s1_i05.are",
	"a2_s1_i05.walk.tga",
	"a2_s1_i05_ts.nbfp",
	"a2_s1_i05_ts.nbfs",
	"a2_s2_card_b1.nbfp",
	"a2_s2_card_b1.nbfs",
	"a2_s2_card_t1.nbfp",
	"a2_s2_card_t1.nbfs",
	"a2_s2_card_t2.nbfp",
	"a2_s2_card_t2.nbfs",
	"a2_s2_ex.are",
	"a2_s2_ex.walk.tga",
	"a2_s2_ex_la.smp",
	"a2_s2_ex_la_soundmap.gda",
	"a2_s2_ex_mm.nbfp",
	"a2_s2_ex_mm.nbfs",
	"a2_s2_ex_mm.nclr",
	"a2_s2_ex_puzzle100.gff",
	"a2_s2_ex_puzzle25.gff",
	"a2_s2_ex_puzzle50.gff",
	"a2_s2_ex_puzzle75.gff",
	"a2_s2_ex_puzzle_fail_camera.gff",
	"a2_s2_ex_puzzle_walk_back.gff",
	"a2_s2_ex_slide1.gff",
	"a2_s2_i01.are",
	"a2_s2_i01.walk.tga",
	"a2_s2_i01_ts.nbfp",
	"a2_s2_i01_ts.nbfs",
	"a2_s2_i04.are",
	"a2_s2_i04.walk.tga",
	"a2_s2_i05.are",
	"a2_s2_i05.walk.tga",
	"a2_s2_i05_2.are",
	"a2_s2_i05_2.walk.tga",
	"a2_s2_i05_ts.nbfp",
	"a2_s2_i05_ts.nbfs",
	"a2_s3_card_b1.nbfp",
	"a2_s3_card_b1.nbfs",
	"a2_s3_card_b2.nbfp",
	"a2_s3_card_b2.nbfs",
	"a2_s3_card_t1.nbfp",
	"a2_s3_card_t1.nbfs",
	"a2_s3_ex.are",
	"a2_s3_ex.walk.tga",
	"a2_s3_ex_la.smp",
	"a2_s3_ex_la_soundmap.gda",
	"a2_s3_ex_mm.nbfp",
	"a2_s3_ex_mm.nbfs",
	"a2_s3_ex_mm.nclr",
	"a2_s3_ex_slide1.gff",
	"a2_s3_ex_slide2.gff",
	"a2_s3_i01.are",
	"a2_s3_i01.walk.tga",
	"a2_s3_i01_ts.nbfp",
	"a2_s3_i01_ts.nbfs",
	"a2_s4_card_b1.nbfp",
	"a2_s4_card_b1.nbfs",
	"a2_s4_card_b2.nbfp",
	"a2_s4_card_b2.nbfs",
	"a2_s4_card_t1.nbfp",
	"a2_s4_card_t1.nbfs",
	"a2_s4_card_t2.nbfp",
	"a2_s4_card_t2.nbfs",
	"a2_s4_ex.are",
	"a2_s4_ex.walk.tga",
	"a2_s4_ex_la.smp",
	"a2_s4_ex_la_soundmap.gda",
	"a2_s4_ex_mm.nbfp",
	"a2_s4_ex_mm.nbfs",
	"a2_s4_ex_mm.nclr",
	"a2_s4_ex_slide1.gff",
	"a2_s4_ex_slide2.gff",
	"a2_s4_ex_slide3.gff",
	"a2_s4_ex_slide4.gff",
	"a2_s4_i01.are",
	"a2_s4_i01.walk.tga",
	"a2_s4_i03.are",
	"a2_s4_i03.walk.tga",
	"a2_s4_i03_ts.nbfp",
	"a2_s4_i03_ts.nbfs",
	"a2_s4_i04.are",
	"a2_s4_i04.walk.tga",
	"a2_s4_i05.are",
	"a2_s4_i05.walk.tga",
	"a2_s4_i06.are",
	"a2_s4_i06.walk.tga",
	"a2_s4_i07.are",
	"a2_s4_i07.walk.tga",
	"a2_s4_i08.are",
	"a2_s4_i08.walk.tga",
	"a2_s5_card_b1.nbfp",
	"a2_s5_card_b1.nbfs",
	"a2_s5_card_b2.nbfp",
	"a2_s5_card_b2.nbfs",
	"a2_s5_card_t1.nbfp",
	"a2_s5_card_t1.nbfs",
	"a2_s5_card_t2.nbfp",
	"a2_s5_card_t2.nbfs",
	"a2_s5_ex.are",
	"a2_s5_ex.walk.tga",
	"a2_s5_ex_la.smp",
	"a2_s5_ex_la_soundmap.gda",
	"a2_s5_ex_mm.nbfp",
	"a2_s5_ex_mm.nbfs",
	"a2_s5_ex_mm.nclr",
	"a2_s5_ex_slide1.gff",
	"a2_s5_ex_slide2.gff",
	"a2_s5_ex_slide3.gff",
	"a2_s5_ex_teleport1.gff",
	"a2_s5_ex_teleport2.gff",
	"a2_s5_ex_teleport3.gff",
	"a2_s5_ex_teleport4.gff",
	"a2_s5_ex_teleport5.gff",
	"a2_s5_ex_teleport6.gff",
	"a2_s5_ex_teleport7.gff",
	"a2_s5_i01.are",
	"a2_s5_i01.walk.tga",
	"a2_s5_i01_ts.nbfp",
	"a2_s5_i01_ts.nbfs",
	"a2_s5_i02.are",
	"a2_s5_i02.walk.tga",
	"a2_s5_i03.are",
	"a2_s5_i03.walk.tga",
	"a2_s5_i04.are",
	"a2_s5_i04.walk.tga",
	"a2_s5_i05.are",
	"a2_s5_i05.walk.tga",
	"a2_s6_ex.are",
	"a2_s6_ex.walk.tga",
	"a2_s6_ex_la.smp",
	"a2_s6_ex_la_soundmap.gda",
	"a2_s6_ex_mm.nbfp",
	"a2_s6_ex_mm.nbfs",
	"a2_s6_ex_mm.nclr",
	"a2_s7_card_b1.nbfp",
	"a2_s7_card_b1.nbfs",
	"a2_s7_card_b2.nbfp",
	"a2_s7_card_b2.nbfs",
	"a2_s7_card_t1.nbfp",
	"a2_s7_card_t1.nbfs",
	"a2_s7_card_t2.nbfp",
	"a2_s7_card_t2.nbfs",
	"a2_s7_ex.are",
	"a2_s7_ex.walk.tga",
	"a2_s7_ex_la.smp",
	"a2_s7_ex_la_soundmap.gda",
	"a2_s7_ex_mm.nbfp",
	"a2_s7_ex_mm.nbfs",
	"a2_s7_ex_mm.nclr",
	"a2_s7_ex_slide1.gff",
	"a2_s7_ex_slide2.gff",
	"a2_s7_ex_slide3.gff",
	"a2_s7_i01.are",
	"a2_s7_i01.walk.tga",
	"a2_s7_i02.are",
	"a2_s7_i02.walk.tga",
	"a2_s7_i03.are",
	"a2_s7_i03.walk.tga",
	"a2_s7_underlay.nbfp",
	"a2_s7_underlay.nbfs",
	"a2_shade.dlg",
	"a2_shadejoinpartyselect.gff",
	"a2_shadow.dlg",
	"a2_sonic.dlg",
	"a2_tails.dlg",
	"a2_tails_stronghold.dlg",
	"a2_w0_kr.nclr",
	"a2_w0_kr_00.ncgr",
	"a2_w0_kr_01.ncgr",
	"a2_w0_kr_11.ncgr",
	"a2_w0_ng.nclr",
	"a2_w0_ng_00.ncgr",
	"a2_w0_nt.nclr",
	"a2_w0_nt_00.ncgr",
	"a2_w0_nt_01.ncgr",
	"a2_w0_nt_10.ncgr",
	"a2_w0_nt_11.ncgr",
	"a2_w0_nt_20.ncgr",
	"a2_w0_nt_21.ncgr",
	"a2_w0_tx.nclr",
	"a2_w0_tx_00.ncgr",
	"a2_w0_tx_01.ncgr",
	"a2_w0_tx_10.ncgr",
	"a2_w0_tx_11.ncgr",
	"a2_w0_ul.nbfp",
	"a2_w0_ul.nbfs",
	"a2_w0_ul2.nbfp",
	"a2_w0_ul2.nbfs",
	"a2_w0_va.nclr",
	"a2_w0_va_00.ncgr",
	"a2_w0_va_01.ncgr",
	"a2_w0_va_10.ncgr",
	"a2_w0_va_11.ncgr",
	"a2_w0_vb.nclr",
	"a2_w0_vb_00.ncgr",
	"a2_w0_vb_01.ncgr",
	"a2_w0_vb_10.ncgr",
	"abutton.ncgr",
	"act1_world0.are",
	"act1_world0.walk.tga",
	"act1_world1.are",
	"act1_world1.walk.tga",
	"act1_world2.are",
	"act1_world2.walk.tga",
	"act1_world3.are",
	"act1_world3.walk.tga",
	"act2_world0.are",
	"act2_world0.walk.tga",
	"actimaginesplash.tga",
	"adv_amy.gda",
	"adv_big.gda",
	"adv_cream.gda",
	"adv_eggman.gda",
	"adv_knuckles.gda",
	"adv_omega.gda",
	"adv_rouge.gda",
	"adv_shade.gda",
	"adv_shadow.gda",
	"adv_sonic.gda",
	"adv_tails.gda",
	"adv_vfxtester.gda",
	"agile_tutorial01_bs.tga",
	"agile_tutorial01_ts.tga",
	"ambientbutton.gui",
	"ambientlower.gui",
	"ambientupper.gui",
	"amb_convo_bg.nbfp",
	"amb_convo_bg.nbfs",
	"amb_uppertextbubble.gui",
	"amy_aa_p.ncgr",
	"amy_cb_attack.nsbca",
	"amy_cb_attackc.nsbca",
	"amy_cb_attackend.nsbca",
	"amy_cb_block.nsbca",
	"amy_cb_blockc.nsbca",
	"amy_cb_blockd.nsbca",
	"amy_cb_blockin.nsbca",
	"amy_cb_blockout.nsbca",
	"amy_cb_counter.nsbca",
	"amy_cb_dead.nsbca",
	"amy_cb_deadidle.nsbca",
	"amy_cb_idle.nsbca",
	"amy_cb_pattack04.nsbca",
	"amy_cb_pattack05.nsbca",
	"amy_cb_pattack1.nsbca",
	"amy_cb_pattack2.nsbca",
	"amy_cb_rund.nsbca",
	"amy_cb_victory.nsbca",
	"amy_cb_victoryin.nsbca",
	"amy_crush.gff",
	"amy_ex_fall.nsbca",
	"amy_ex_idle.nsbca",
	"amy_ex_jump.nsbca",
	"amy_ex_jumpair.nsbca",
	"amy_ex_run.nsbca",
	"amy_ex_smash.nsbca",
	"amy_ex_twitch.nsbca",
	"amy_ex_walk.nsbca",
	"animationevents.gda",
	"animations.gda",
	"appearances.gda",
	"areamove.gda",
	"areas.gda",
	"arena_act_1.are",
	"arena_act_2.are",
	"armboar_aa.nsbmd",
	"armboar_aa.nsbtx",
	"armboar_ab.nsbmd",
	"armboar_ab.nsbtx",
	"armdiln_aa.nsbmd",
	"armdiln_aa.nsbtx",
	"armdiln_aa_p.ncgr",
	"armdiln_icon.tga",
	"armdilr_aa.nsbmd",
	"armdilr_aa.nsbtx",
	"armdilr_aa_p.ncgr",
	"armdilr_icon.tga",
	"armored_tutorial01_bs.tga",
	"armored_tutorial01_ts.tga",
	"arm_cb_attack.nsbca",
	"arm_cb_attackc.nsbca",
	"arm_cb_attackend.nsbca",
	"arm_cb_counter.nsbca",
	"arm_cb_damage.nsbca",
	"arm_cb_dead.nsbca",
	"arm_cb_getup.nsbca",
	"arm_cb_idle.nsbca",
	"arm_cb_kd.nsbca",
	"arm_cb_pattack.nsbca",
	"arm_ex_damage.nsbca",
	"arm_ex_idle.nsbca",
	"arm_ex_jump.nsbca",
	"arm_ex_land.nsbca",
	"arm_ex_run.nsbca",
	"arm_ex_walk.nsbca",
	"attack.ncgr",
	"attack1_ts.tga",
	"attack2_ts.tga",
	"attack3_bs.tga",
	"attack3_ts.tga",
	"attack4_bs.tga",
	"attack5_bs.tga",
	"attack6_bs.tga",
	"attack6_ts.tga",
	"bal_cb_attack.nsbca",
	"bal_cb_attackc.nsbca",
	"bal_cb_attackend.nsbca",
	"bal_cb_pattack01.nsbca",
	"bal_cb_pattack02.nsbca",
	"bal_ex_dash.nsbca",
	"bal_ex_off.nsbca",
	"bal_ex_spinfall.nsbca",
	"bal_ex_spinjump.nsbca",
	"basiccombattut.gda",
	"bbutton.ncgr",
	"bel_aa.nsbmd",
	"bel_aa.nsbtx",
	"bel_cb_attack.nsbca",
	"bel_cb_attackend.nsbca",
	"bel_cb_counter.nsbca",
	"bel_cb_damage.nsbca",
	"bel_cb_dead.nsbca",
	"bel_cb_getup.nsbca",
	"bel_cb_idle.nsbca",
	"bel_cb_kd.nsbca",
	"bel_cb_pattack.nsbca",
	"bel_ex_idle.nsbca",
	"bel_ex_run.nsbca",
	"bel_ex_walk.nsbca",
	"bfl_aa.nsbmd",
	"bfl_aa.nsbtx",
	"bfl_cb_attack.nsbca",
	"bfl_cb_attackc.nsbca",
	"bfl_cb_attackend.nsbca",
	"bfl_cb_counter.nsbca",
	"bfl_cb_damage.nsbca",
	"bfl_cb_dead.nsbca",
	"bfl_cb_getup.nsbca",
	"bfl_cb_idle.nsbca",
	"bfl_cb_kd.nsbca",
	"bfl_cb_pattack.nsbca",
	"bfl_ex_idle.nsbca",
	"bfl_ex_run.nsbca",
	"bfl_ex_walk.nsbca",
	"bif_amy.nbfp",
	"bif_amy.nbfs",
	"bif_big.nbfp",
	"bif_big.nbfs",
	"bif_cre.nbfp",
	"bif_cre.nbfs",
	"bif_egg.nbfp",
	"bif_egg.nbfs",
	"bif_knu.nbfp",
	"bif_knu.nbfs",
	"bif_ome.nbfp",
	"bif_ome.nbfs",
	"bif_rou.nbfp",
	"bif_rou.nbfs",
	"bif_sha.nbfp",
	"bif_sha.nbfs",
	"bif_she.nbfp",
	"bif_she.nbfs",
	"bif_son.nbfp",
	"bif_son.nbfs",
	"bif_tai.nbfp",
	"bif_tai.nbfs",
	"bif_tia.nbfp",
	"bif_tia.nbfs",
	"big_aa.nsbmd",
	"big_aa.nsbtx",
	"big_cb_attack.nsbca",
	"big_cb_attackc.nsbca",
	"big_cb_attackend.nsbca",
	"big_cb_blockc.nsbca",
	"big_cb_blockd.nsbca",
	"big_cb_blockidle.nsbca",
	"big_cb_blockin.nsbca",
	"big_cb_blockout.nsbca",
	"big_cb_counter.nsbca",
	"big_cb_damage.nsbca",
	"big_cb_dead.nsbca",
	"big_cb_getup.nsbca",
	"big_cb_idle.nsbca",
	"big_cb_kd.nsbca",
	"big_cb_pattack01.nsbca",
	"big_cb_pattack02.nsbca",
	"big_cb_pattack03.nsbca",
	"big_cb_pattack04.nsbca",
	"big_cb_pattack06.nsbca",
	"big_cb_rund.nsbca",
	"big_cb_stunned.nsbca",
	"big_cb_victory.nsbca",
	"big_cb_victoryin.nsbca",
	"big_ex_damage.nsbca",
	"big_ex_fall.nsbca",
	"big_ex_idle.nsbca",
	"big_ex_jump.nsbca",
	"big_ex_jumpair.nsbca",
	"big_ex_run.nsbca",
	"big_ex_twitch.nsbca",
	"big_ex_walk.nsbca",
	"black6464.ncgr",
	"block_walkmesh.tga",
	"bmp_aa.nsbmd",
	"bmp_aa.nsbtx",
	"bmp_aa_rld.nsbta",
	"bmp_cb_attack.nsbca",
	"bmp_cb_attackend.nsbca",
	"bmp_cb_counter.nsbca",
	"bmp_cb_dead.nsbca",
	"bmp_cb_getup.nsbca",
	"bmp_cb_idle.nsbca",
	"bmp_cb_kd.nsbca",
	"bmp_cb_pattack.nsbca",
	"bmp_cb_reload.nsbta",
	"bmp_ex_damage.nsbca",
	"bmp_ex_idle.nsbca",
	"bmp_ex_run.nsbca",
	"bmp_ex_walk.nsbca",
	"brdrhk_aa.nsbmd",
	"brdrhk_aa.nsbtx",
	"briantestfx01.emit",
	"briantestfx01.nsbtp",
	"bridge.gda",
	"bridgeplank_wm1.tga",
	"bridgeplank_wm2.tga",
	"bridgeplank_wm3.tga",
	"bridgeplank_wm4.tga",
	"brz_hintguy.dlg",
	"brz_met.gff",
	"bsc_aa.nsbmd",
	"bsc_aa.nsbtx",
	"bsc_cb_attack.nsbca",
	"bsc_cb_attackc.nsbca",
	"bsc_cb_attackend.nsbca",
	"bsc_cb_counter.nsbca",
	"bsc_cb_damage.nsbca",
	"bsc_cb_dead.nsbca",
	"bsc_cb_getup.nsbca",
	"bsc_cb_idle.nsbca",
	"bsc_cb_kd.nsbca",
	"bsc_cb_pattack01.nsbca",
	"bsl_aa.nsbmd",
	"bsl_aa.nsbtx",
	"bsl_cb_attack.nsbca",
	"bsl_cb_attackend.nsbca",
	"bsl_cb_damage.nsbca",
	"bsl_cb_dead.nsbca",
	"bsl_cb_getup.nsbca",
	"bsl_cb_idle.nsbca",
	"bsl_cb_kd.nsbca",
	"bsl_cb_pattack.nsbca",
	"bsl_ex_counter.nsbca",
	"bsl_ex_idle.nsbca",
	"bsl_ex_run.nsbca",
	"bsl_ex_walk.nsbca",
	"btn_arrowdn_of.ncgr",
	"btn_arrowdn_on.ncgr",
	"btn_arrowup_of.ncgr",
	"btn_arrowup_on.ncgr",
	"btn_arrow_00.ncgr",
	"btn_back_e_of.ncgr",
	"btn_back_e_on.ncgr",
	"btn_back_of.ncgr",
	"btn_back_on.ncgr",
	"btn_bar_00.ncgr",
	"btn_bar_01.ncgr",
	"btn_buton_of.ncgr",
	"btn_buton_on.ncgr",
	"btn_help_of.ncgr",
	"btn_help_on.ncgr",
	"btn_l_bar_of00.ncgr",
	"btn_l_bar_of01.ncgr",
	"btn_l_bar_on00.ncgr",
	"btn_l_bar_on01.ncgr",
	"btn_l_lftarw_of.ncgr",
	"btn_l_lftarw_on.ncgr",
	"btn_l_rtarw_of.ncgr",
	"btn_l_rtarw_on.ncgr",
	"btn_menu_of.ncgr",
	"btn_menu_on.ncgr",
	"btn_puzz_off.ncgr",
	"btn_puzz_on.ncgr",
	"btn_scrll_di.ncgr",
	"btn_scrll_hi.ncgr",
	"btn_s_bar_of00.ncgr",
	"btn_s_bar_of01.ncgr",
	"btn_s_bar_of02.ncgr",
	"btn_s_bar_on00.ncgr",
	"btn_s_bar_on01.ncgr",
	"btn_s_bar_on02.ncgr",
	"btn_s_lftarw_of.ncgr",
	"btn_s_lftarw_on.ncgr",
	"btn_s_rtarw_of.ncgr",
	"btn_s_rtarw_on.ncgr",
	"button.tga",
	"button_pressed.tga",
	"buzwasn_aa_p.ncgr",
	"buzwasn_ab.nsbmd",
	"buzwasn_ab.nsbtx",
	"buzwasr_aa_p.ncgr",
	"buzwasr_icon.tga",
	"buz_cb_attack.nsbca",
	"buz_cb_attackc.nsbca",
	"buz_cb_attackend.nsbca",
	"buz_cb_counter.nsbca",
	"buz_cb_damage.nsbca",
	"buz_cb_getup.nsbca",
	"buz_cb_idle.nsbca",
	"buz_cb_kd.nsbca",
	"buz_cb_kdidle.nsbca",
	"buz_cb_pattack.nsbca",
	"buz_ex_damage.nsbca",
	"buz_ex_fall.nsbca",
	"buz_ex_idle.nsbca",
	"buz_ex_jump.nsbca",
	"buz_ex_run.nsbca",
	"buz_ex_walk.nsbca",
	"cameapantyxsis.gff",
	"camerahacknocturne.gff",
	"camerahacknocturne2.gff",
	"camerapanangel.gff",
	"camerapanangel_intro.gff",
	"camerapanblueridge.gff",
	"camerapanblueridge_intro.gff",
	"camerapancentralcity.gff",
	"camerapancentralcity_intro.gff",
	"camerapangreenhill.gff",
	"camerapankron.gff",
	"camerapankronforcefield.gff",
	"camerapanmetropolis.gff",
	"camerapanmysticruins.gff",
	"camerapannocturne.gff",
	"camerapannrrgal.gff",
	"camerapantyxsis.gff",
	"camerapanvoxaia.gff",
	"camerapanvoxaib.gff",
	"cavalry.gda",
	"cbtmenubg_00.ncgr",
	"cbtmenubg_01.ncgr",
	"cbtmenubg_10.ncgr",
	"cbtmenubg_11.ncgr",
	"cbt_ambush.ncgr",
	"cbt_ambushed.ncgr",
	"cbt_black_lower.nanr",
	"cbt_black_lower.ncer",
	"cbt_black_lower.ncgr",
	"cbt_black_upper.nanr",
	"cbt_black_upper.ncer",
	"cbt_black_upper.ncgr",
	"cbt_btn_break.gui",
	"cbt_btn_extra.ncgr",
	"cbt_btn_failure.gui",
	"cbt_btn_left.ncgr",
	"cbt_btn_left_of.ncgr",
	"cbt_btn_left_on.ncgr",
	"cbt_btn_mid.ncgr",
	"cbt_btn_pathbut.gui",
	"cbt_btn_pathdot.gui",
	"cbt_btn_right.ncgr",
	"cbt_btn_right_of.ncgr",
	"cbt_btn_right_on.ncgr",
	"cbt_btn_standard.gui",
	"cbt_btn_success.gui",
	"cbt_buttonleft_00.ncgr",
	"cbt_buttonright_00.ncgr",
	"cbt_buttonright_01.ncgr",
	"cbt_charpointer.ncgr",
	"cbt_chaseenemy.ncgr",
	"cbt_chasegauge_00.ncgr",
	"cbt_chasegauge_01.ncgr",
	"cbt_chasegauge_02.ncgr",
	"cbt_chaseplayer.ncgr",
	"cbt_cmddnoff.ncgr",
	"cbt_cmddnon.ncgr",
	"cbt_cmdframe00.ncgr",
	"cbt_cmdframe01.ncgr",
	"cbt_cmdframe11.ncgr",
	"cbt_cmdframe12.ncgr",
	"cbt_cmdframe13.ncgr",
	"cbt_cmdframe14.ncgr",
	"cbt_cmdhlthfat.ncgr",
	"cbt_cmdhlthfat0.ncgr",
	"cbt_cmdhlthfat1.ncgr",
	"cbt_cmdovricon.ncgr",
	"cbt_cmdslot.ncgr",
	"cbt_cmdslothighlight.ncgr",
	"cbt_cmdupoff.ncgr",
	"cbt_cmdupon.ncgr",
	"cbt_cornr_ms00.ncgr",
	"cbt_dgrnt_ms00.ncgr",
	"cbt_dredt_ms00.ncgr",
	"cbt_dyelt_ms00.ncgr",
	"cbt_elem_an_fire.nanr",
	"cbt_elem_an_fire.ncer",
	"cbt_elem_an_fire.ncgr",
	"cbt_elem_earth.ncgr",
	"cbt_elem_fire.ncgr",
	"cbt_elem_ice.ncgr",
	"cbt_elem_lgtng.ncgr",
	"cbt_elem_redx.ncgr",
	"cbt_elem_water.ncgr",
	"cbt_elem_wind.ncgr",
	"cbt_enemyframe.ncgr",
	"cbt_enemy_ambush.nanr",
	"cbt_enemy_ambush.ncer",
	"cbt_enemy_ambush.ncgr",
	"cbt_explo_ms00.ncgr",
	"cbt_fatiguebar.ncgr",
	"cbt_fatiguebar_s.ncgr",
	"cbt_fatig_00.ncgr",
	"cbt_flcght_0.ncgr",
	"cbt_flcght_1.ncgr",
	"cbt_flescp_0.ncgr",
	"cbt_flescp_1.ncgr",
	"cbt_flgetm_0.ncgr",
	"cbt_flgetm_1.ncgr",
	"cbt_floatybg.ncgr",
	"cbt_flruna_0.ncgr",
	"cbt_flruna_1.ncgr",
	"cbt_focusbad.nanr",
	"cbt_focusbad.ncer",
	"cbt_focusbad.ncgr",
	"cbt_focusbreak.nanr",
	"cbt_focusbreak.ncer",
	"cbt_focusbreak.ncgr",
	"cbt_focusgood.nanr",
	"cbt_focusgood.ncer",
	"cbt_focusgood.ncgr",
	"cbt_focusring.nanr",
	"cbt_focusring.ncer",
	"cbt_focusring.ncgr",
	"cbt_focusringb.nanr",
	"cbt_focusringb.ncer",
	"cbt_focusringb.ncgr",
	"cbt_focusringc.nanr",
	"cbt_focusringc.ncer",
	"cbt_focusringc.ncgr",
	"cbt_focus_button.ncgr",
	"cbt_focus_button_correct.ncgr",
	"cbt_focus_button_failure.ncgr",
	"cbt_focus_button_path.ncgr",
	"cbt_focus_button_pathfail.ncgr",
	"cbt_focus_rpdbg.nanr",
	"cbt_focus_rpdbg.ncer",
	"cbt_focus_rpdbg.ncgr",
	"cbt_follow_button.nanr",
	"cbt_follow_button.ncer",
	"cbt_follow_button.ncgr",
	"cbt_follow_transition.nanr",
	"cbt_follow_transition.ncer",
	"cbt_follow_transition.ncgr",
	"cbt_healthbar.ncgr",
	"cbt_healthbar_s.ncgr",
	"cbt_healt_00.ncgr",
	"cbt_horiz_ms00.ncgr",
	"cbt_info_slide.nanr",
	"cbt_info_slide.ncer",
	"cbt_info_slide.ncgr",
	"cbt_inprofatbar.ncgr",
	"cbt_inproftbar_s.ncgr",
	"cbt_lgrnt_ms00.ncgr",
	"cbt_lredt_ms00.ncgr",
	"cbt_lyelt_ms00.ncgr",
	"cbt_menubg_00.ncgr",
	"cbt_menubg_01.ncgr",
	"cbt_menubg_10.ncgr",
	"cbt_menubg_11.ncgr",
	"cbt_menu_arrowdown.ncgr",
	"cbt_menu_arrowup.ncgr",
	"cbt_menu_backbutton.ncgr",
	"cbt_menu_backbutton_of.ncgr",
	"cbt_menu_backbutton_on.ncgr",
	"cbt_menu_button_of00.ncgr",
	"cbt_menu_button_of01.ncgr",
	"cbt_menu_button_of02.ncgr",
	"cbt_menu_button_on00.ncgr",
	"cbt_menu_button_on01.ncgr",
	"cbt_menu_button_on02.ncgr",
	"cbt_menu_down_of.ncgr",
	"cbt_menu_down_on.ncgr",
	"cbt_menu_info.ncgr",
	"cbt_menu_resetbutton_of.ncgr",
	"cbt_menu_resetbutton_on.ncgr",
	"cbt_menu_up_of.ncgr",
	"cbt_menu_up_on.ncgr",
	"cbt_pathdot.ncgr",
	"cbt_pathdot2.ncgr",
	"cbt_pathdotanim.nanr",
	"cbt_pathdotanim.ncer",
	"cbt_pathdotanim.ncgr",
	"cbt_playerframe.ncgr",
	"cbt_player_ambush.nanr",
	"cbt_player_ambush.ncer",
	"cbt_player_ambush.ncgr",
	"cbt_portr_00.ncgr",
	"cbt_rdring_ms00.ncgr",
	"cbt_rndnum0.ncgr",
	"cbt_rndnum1.ncgr",
	"cbt_rndnum2.ncgr",
	"cbt_rndnum3.ncgr",
	"cbt_rndnum4.ncgr",
	"cbt_rndnum5.ncgr",
	"cbt_rndnum6.ncgr",
	"cbt_rndnum7.ncgr",
	"cbt_rndnum8.ncgr",
	"cbt_rndnum9.ncgr",
	"cbt_round_slide.nanr",
	"cbt_round_slide.ncer",
	"cbt_round_slide.ncgr",
	"cbt_rttarget.ncgr",
	"cbt_sidebar.nanr",
	"cbt_sidebar.ncer",
	"cbt_sidebar.ncgr",
	"cbt_sonichead.ncgr",
	"cbt_sonneutral.ncgr",
	"cbt_sonsatisf.ncgr",
	"cbt_sonsurprise.ncgr",
	"cbt_test.gff",
	"cbt_title_slide.nanr",
	"cbt_title_slide.ncer",
	"cbt_title_slide.ncgr",
	"cbt_usfat_00.ncgr",
	"cbt_verti_ms00.ncgr",
	"cbt_victory_star.nanr",
	"cbt_victory_star.ncer",
	"cbt_victory_star.ncgr",
	"cbt_victory_star2.nanr",
	"cbt_victory_star2.ncer",
	"cbt_victory_star2.ncgr",
	"cbt_xpball.ncgr",
	"cbt_xpbar.ncgr",
	"cbt_xpbar_s.ncgr",
	"cbt_ystar_ms00.ncgr",
	"cct1_minimap.nclr",
	"ccw_e_n.gff",
	"ccw_ne_nw.gff",
	"ccw_nw_sw.gff",
	"ccw_n_w.gff",
	"ccw_se_ne.gff",
	"ccw_sw_se.gff",
	"ccw_s_e.gff",
	"ccw_w_s.gff",
	"ccz_ghz.gff",
	"ccz_hintguy.dlg",
	"ccz_mrz.gff",
	"cfx_acdp1.nsbmd",
	"cfx_acdp1.nsbtp",
	"cfx_acdp1.nsbtx",
	"cfx_acdp1_acd.emit",
	"cfx_acdp1_slm.emit",
	"cfx_acdp1_slp.emit",
	"cfx_aslt_mf.nsbmd",
	"cfx_aslt_mf.nsbta",
	"cfx_aslt_mf.nsbtp",
	"cfx_aslt_mf.nsbtx",
	"cfx_atkp1.nsbmd",
	"cfx_atkp1.nsbtp",
	"cfx_atkp1.nsbtx",
	"cfx_atkp1_fls.emit",
	"cfx_aurp1.nsbmd",
	"cfx_aurp1.nsbtp",
	"cfx_aurp1.nsbtx",
	"cfx_aurp1_aur.emit",
	"cfx_basp1.nsbmd",
	"cfx_basp1.nsbtp",
	"cfx_basp1.nsbtx",
	"cfx_basp1_fls.emit",
	"cfx_bub1.nsbmd",
	"cfx_bub1.nsbtp",
	"cfx_bub1.nsbtx",
	"cfx_bub1_pt1.emit",
	"cfx_bub1_pt2.emit",
	"cfx_bub1_zon.emit",
	"cfx_bugp1.nsbmd",
	"cfx_bugp1.nsbtp",
	"cfx_bugp1.nsbtx",
	"cfx_bugp1_glt.emit",
	"cfx_calp1.nsbmd",
	"cfx_calp1.nsbtp",
	"cfx_calp1.nsbtx",
	"cfx_calp1_glw.emit",
	"cfx_ccap1.nsbmd",
	"cfx_ccap1.nsbtp",
	"cfx_ccap1.nsbtx",
	"cfx_ccap1_cca.emit",
	"cfx_ccup1.nsbmd",
	"cfx_ccup1.nsbtp",
	"cfx_ccup1.nsbtx",
	"cfx_ccup1_spk.emit",
	"cfx_cgrp1.nsbmd",
	"cfx_cgrp1.nsbtp",
	"cfx_cgrp1.nsbtx",
	"cfx_cgrp1_brk.emit",
	"cfx_ch1.nsbmd",
	"cfx_ch1.nsbtp",
	"cfx_ch1.nsbtx",
	"cfx_ch1_spkp1.emit",
	"cfx_ch2.nsbmd",
	"cfx_ch2.nsbtp",
	"cfx_ch2.nsbtx",
	"cfx_ch2_spkp1.emit",
	"cfx_ch3.nsbmd",
	"cfx_ch3.nsbtp",
	"cfx_ch3.nsbtx",
	"cfx_ch3_spkp1.emit",
	"cfx_ch4.nsbmd",
	"cfx_ch4.nsbtp",
	"cfx_ch4.nsbtx",
	"cfx_ch4_spkp1.emit",
	"cfx_ch5.nsbmd",
	"cfx_ch5.nsbtp",
	"cfx_ch5.nsbtx",
	"cfx_ch5_spkp1.emit",
	"cfx_ch6.nsbmd",
	"cfx_ch6.nsbtp",
	"cfx_ch6.nsbtx",
	"cfx_ch6_spkp1.emit",
	"cfx_ch7.nsbmd",
	"cfx_ch7.nsbtp",
	"cfx_ch7.nsbtx",
	"cfx_ch7_spkp1.emit",
	"cfx_chlp1.nsbmd",
	"cfx_chlp1.nsbtp",
	"cfx_chlp1.nsbtx",
	"cfx_chlp1_hea.emit",
	"cfx_clup1.nsbmd",
	"cfx_clup1.nsbtp",
	"cfx_clup1.nsbtx",
	"cfx_clup1_luc.emit",
	"cfx_crsp1.nsbmd",
	"cfx_crsp1.nsbtp",
	"cfx_crsp1.nsbtx",
	"cfx_crsp1_smk.emit",
	"cfx_crtp1.nsbmd",
	"cfx_crtp1.nsbtp",
	"cfx_crtp1.nsbtx",
	"cfx_crtp1_fls.emit",
	"cfx_crup1.nsbmd",
	"cfx_crup1.nsbtp",
	"cfx_crup1.nsbtx",
	"cfx_crup1_roc.emit",
	"cfx_crvp1.nsbmd",
	"cfx_crvp1.nsbtp",
	"cfx_crvp1.nsbtx",
	"cfx_crvp1_rev.emit",
	"cfx_crzbns.emit",
	"cfx_crzbns.nsbmd",
	"cfx_crzbns.nsbtp",
	"cfx_crzbns.nsbtx",
	"cfx_curp1.nsbmd",
	"cfx_curp1.nsbtp",
	"cfx_curp1.nsbtx",
	"cfx_curp1_glt.emit",
	"cfx_ddsp1_dds.emit",
	"cfx_disp1.nsbmd",
	"cfx_disp1.nsbtp",
	"cfx_disp1.nsbtx",
	"cfx_disp1_pop.emit",
	"cfx_dstp1.nsbmd",
	"cfx_dstp1.nsbtp",
	"cfx_dstp1.nsbtx",
	"cfx_dstp1_dst.emit",
	"cfx_dusp1.nsbmd",
	"cfx_dusp1.nsbtp",
	"cfx_dusp1.nsbtx",
	"cfx_dusp1_slm.emit",
	"cfx_dusp2.nsbmd",
	"cfx_dusp2.nsbtp",
	"cfx_dusp2.nsbtx",
	"cfx_dusp2_slm.emit",
	"cfx_egbt_mf.nsbmd",
	"cfx_egbt_mf.nsbta",
	"cfx_egbt_mf.nsbtp",
	"cfx_egbt_mf.nsbtx",
	"cfx_egip1.nsbmd",
	"cfx_egip1.nsbtp",
	"cfx_egip1.nsbtx",
	"cfx_egip1_lgt.emit",
	"cfx_empp1.nsbmd",
	"cfx_empp1.nsbtp",
	"cfx_empp1.nsbtx",
	"cfx_empp1_bem.emit",
	"cfx_ertp1.nsbmd",
	"cfx_ertp1.nsbtp",
	"cfx_ertp1.nsbtx",
	"cfx_ertp1_roc.emit",
	"cfx_exbp1.nsbmd",
	"cfx_exbp1.nsbtp",
	"cfx_exbp1.nsbtx",
	"cfx_exbp1_exb.emit",
	"cfx_exbp2_exb.emit",
	"cfx_exbp3.nsbmd",
	"cfx_exbp3.nsbtp",
	"cfx_exbp3.nsbtx",
	"cfx_exbp3_exb.emit",
	"cfx_expp1_exp.emit",
	"cfx_expp1_min.emit",
	"cfx_expp1_rkv.emit",
	"cfx_expp2.nsbmd",
	"cfx_expp2.nsbtx",
	"cfx_expp2_exp.emit",
	"cfx_expp2_min.emit",
	"cfx_fatp1.nsbmd",
	"cfx_fatp1.nsbtp",
	"cfx_fatp1.nsbtx",
	"cfx_fatp1_glw.emit",
	"cfx_ferp1.nsbmd",
	"cfx_ferp1.nsbtp",
	"cfx_ferp1.nsbtx",
	"cfx_ferp1_roc.emit",
	"cfx_ffrp1.nsbmd",
	"cfx_ffrp1.nsbtp",
	"cfx_ffrp1.nsbtx",
	"cfx_ffrp1_flm.emit",
	"cfx_fglp1.nsbmd",
	"cfx_fglp1.nsbtp",
	"cfx_fglp1.nsbtx",
	"cfx_fglp1_glw.emit",
	"cfx_fgrp1.nsbmd",
	"cfx_fgrp1.nsbtp",
	"cfx_fgrp1.nsbtx",
	"cfx_fgrp1_frr.emit",
	"cfx_fgrp2.nsbmd",
	"cfx_fgrp2.nsbtp",
	"cfx_fgrp2.nsbtx",
	"cfx_fgrp2_dst.emit",
	"cfx_fgrp3.nsbmd",
	"cfx_fgrp3.nsbtp",
	"cfx_fgrp3.nsbtx",
	"cfx_fgrp3_fgj.emit",
	"cfx_ficp1.nsbmd",
	"cfx_ficp1.nsbtp",
	"cfx_ficp1.nsbtx",
	"cfx_ficp1_ice.emit",
	"cfx_firp1.nsbmd",
	"cfx_firp1.nsbtp",
	"cfx_firp1.nsbtx",
	"cfx_firp1_flm.emit",
	"cfx_flap1.nsbmd",
	"cfx_flap1.nsbtp",
	"cfx_flap1.nsbtx",
	"cfx_flap1_fla.emit",
	"cfx_flmp1.nsbmd",
	"cfx_flmp1.nsbtp",
	"cfx_flmp1.nsbtx",
	"cfx_flmp1_flm.emit",
	"cfx_fltp1.nsbmd",
	"cfx_fltp1.nsbtp",
	"cfx_fltp1.nsbtx",
	"cfx_fltp1_lgt.emit",
	"cfx_focp1.nsbmd",
	"cfx_focp1.nsbtp",
	"cfx_focp1.nsbtx",
	"cfx_focp1_foc.emit",
	"cfx_frgy.nsbmd",
	"cfx_frgy.nsbtx",
	"cfx_fthr_drt.nsbmd",
	"cfx_fthr_drt.nsbtx",
	"cfx_ftpp1.nsbmd",
	"cfx_ftpp1.nsbtp",
	"cfx_ftpp1.nsbtx",
	"cfx_ftpp1_pls.emit",
	"cfx_fwnp1.nsbmd",
	"cfx_fwnp1.nsbtp",
	"cfx_fwnp1.nsbtx",
	"cfx_fwnp1_win.emit",
	"cfx_fwtp1.nsbmd",
	"cfx_fwtp1.nsbtp",
	"cfx_fwtp1.nsbtx",
	"cfx_fwtp1_wat.emit",
	"cfx_gasp1_gas.emit",
	"cfx_gfir_prj.nsbmd",
	"cfx_gfir_prj.nsbta",
	"cfx_gfir_prj.nsbtp",
	"cfx_gfir_prj.nsbtx",
	"cfx_gfir_pu.nsbca",
	"cfx_gfir_pu.nsbmd",
	"cfx_gfir_pu.nsbta",
	"cfx_gfir_pu.nsbtp",
	"cfx_gfir_pu.nsbtx",
	"cfx_ghlp1.nsbmd",
	"cfx_ghlp1.nsbtp",
	"cfx_ghlp1.nsbtx",
	"cfx_glw_canp1.emit",
	"cfx_glw_drkp1.emit",
	"cfx_glw_ghlp1.emit",
	"cfx_glw_ghrp1.emit",
	"cfx_glw_ghsp1.emit",
	"cfx_glw_gump1.emit",
	"cfx_glw_gyzp1.emit",
	"cfx_glw_medp1.emit",
	"cfx_glw_rezp1.emit",
	"cfx_glw_rlfp1.emit",
	"cfx_glw_wavp1.emit",
	"cfx_gtpp1.nsbmd",
	"cfx_gtpp1.nsbtp",
	"cfx_gtpp1.nsbtx",
	"cfx_gtpp1_brk.emit",
	"cfx_gwtr_prj.nsbmd",
	"cfx_gwtr_prj.nsbta",
	"cfx_gwtr_prj.nsbtp",
	"cfx_gwtr_prj.nsbtx",
	"cfx_gwtr_pu.nsbca",
	"cfx_gwtr_pu.nsbmd",
	"cfx_gwtr_pu.nsbta",
	"cfx_gwtr_pu.nsbtp",
	"cfx_gwtr_pu.nsbtx",
	"cfx_gyzp1.nsbmd",
	"cfx_gyzp1.nsbtp",
	"cfx_gyzp1.nsbtx",
	"cfx_hazp1_fal.emit",
	"cfx_hdsp1.nsbmd",
	"cfx_hdsp1.nsbtp",
	"cfx_hdsp1.nsbtx",
	"cfx_hdsp1_hds.emit",
	"cfx_heap1.nsbmd",
	"cfx_heap1.nsbtp",
	"cfx_heap1.nsbtx",
	"cfx_heap1_crs.emit",
	"cfx_hstp1.nsbmd",
	"cfx_hstp1.nsbtp",
	"cfx_hstp1.nsbtx",
	"cfx_hstp1_slt.emit",
	"cfx_hypp1.nsbmd",
	"cfx_hypp1.nsbtp",
	"cfx_hypp1.nsbtx",
	"cfx_hypp1_twl.emit",
	"cfx_ibep1.nsbmd",
	"cfx_ibep1.nsbtp",
	"cfx_ibep1.nsbtx",
	"cfx_ibep1_fls.emit",
	"cfx_icep1.nsbmd",
	"cfx_icep1.nsbtp",
	"cfx_icep1.nsbtx",
	"cfx_icep1_ice.emit",
	"cfx_ixdp1.nsbmd",
	"cfx_ixdp1.nsbtp",
	"cfx_ixdp1.nsbtx",
	"cfx_ixdp2.nsbmd",
	"cfx_ixdp2.nsbtp",
	"cfx_ixdp2.nsbtx",
	"cfx_ixmp1.nsbmd",
	"cfx_ixmp1.nsbtp",
	"cfx_ixmp1.nsbtx",
	"cfx_ixmp1_ixd.emit",
	"cfx_ixmp1_ixm.emit",
	"cfx_ixmp1_ixt.emit",
	"cfx_ixmp2_ixd.emit",
	"cfx_javp1.nsbmd",
	"cfx_javp1.nsbtp",
	"cfx_javp1.nsbtx",
	"cfx_javp1_jav.emit",
	"cfx_jwl1.nsbmd",
	"cfx_jwl1.nsbtp",
	"cfx_jwl1.nsbtx",
	"cfx_jwl1_jwl.emit",
	"cfx_kipp1.nsbmd",
	"cfx_kipp1.nsbtp",
	"cfx_kipp1.nsbtx",
	"cfx_kipp1_hrt.emit",
	"cfx_levp1.nsbmd",
	"cfx_levp1.nsbtp",
	"cfx_levp1.nsbtx",
	"cfx_levp1_lev.emit",
	"cfx_ltgp1.nsbmd",
	"cfx_ltgp1.nsbtp",
	"cfx_ltgp1.nsbtx",
	"cfx_ltgp1_ltg.emit",
	"cfx_lucp1.nsbmd",
	"cfx_lucp1.nsbtp",
	"cfx_lucp1.nsbtx",
	"cfx_lucp1_clv.emit",
	"cfx_mas.nsbmd",
	"cfx_mas.nsbtp",
	"cfx_mas.nsbtx",
	"cfx_mas_spkp1.emit",
	"cfx_mexp1.nsbmd",
	"cfx_mexp1.nsbtp",
	"cfx_mexp1.nsbtx",
	"cfx_mexp1_mex.emit",
	"cfx_mexp2.nsbmd",
	"cfx_mexp2.nsbtp",
	"cfx_mexp2.nsbtx",
	"cfx_mexp2_mex.emit",
	"cfx_mexp3_mex.emit",
	"cfx_mg_prj.nsbmd",
	"cfx_mg_prj.nsbtx",
	"cfx_mst1_fiz.emit",
	"cfx_mst1_tor.emit",
	"cfx_nflp1.nsbmd",
	"cfx_nflp1.nsbtp",
	"cfx_nflp1.nsbtx",
	"cfx_nflp1_fls.emit",
	"cfx_nocp1.nsbmd",
	"cfx_nocp1.nsbtp",
	"cfx_nocp1.nsbtx",
	"cfx_nocp1_spk.emit",
	"cfx_nrgp1.nsbmd",
	"cfx_nrgp1.nsbtp",
	"cfx_nrgp1.nsbtx",
	"cfx_nrgp1_glt.emit",
	"cfx_nrg_slsh.nsbmd",
	"cfx_nrg_slsh.nsbta",
	"cfx_nrg_slsh.nsbtx",
	"cfx_omga_mf.nsbmd",
	"cfx_omga_mf.nsbta",
	"cfx_omga_mf.nsbtp",
	"cfx_omga_mf.nsbtx",
	"cfx_pfbp1.nsbmd",
	"cfx_pfbp1.nsbtp",
	"cfx_pfbp1.nsbtx",
	"cfx_pfbp1_bng.emit",
	"cfx_pfbp2.nsbmd",
	"cfx_pfbp2.nsbtp",
	"cfx_pfbp2.nsbtx",
	"cfx_pfbp2_srd.emit",
	"cfx_pjkp1.nsbmd",
	"cfx_pjkp1.nsbtp",
	"cfx_pjkp1.nsbtx",
	"cfx_pjkp1_lps.emit",
	"cfx_pksp1.nsbmd",
	"cfx_pksp1.nsbtp",
	"cfx_pksp1.nsbtx",
	"cfx_pksp1_pks.emit",
	"cfx_pmip1.nsbmd",
	"cfx_pmip1.nsbtp",
	"cfx_pmip1.nsbtx",
	"cfx_pmip1_pma.emit",
	"cfx_poip1.nsbmd",
	"cfx_poip1.nsbtp",
	"cfx_poip1.nsbtx",
	"cfx_poip1_skl.emit",
	"cfx_prj_min.nsbmd",
	"cfx_prj_min.nsbtp",
	"cfx_prj_min.nsbtx",
	"cfx_pswp1.nsbmd",
	"cfx_pswp1.nsbtp",
	"cfx_pswp1.nsbtx",
	"cfx_pswp1_psw.emit",
	"cfx_pwup1.nsbmd",
	"cfx_pwup1.nsbtp",
	"cfx_pwup1.nsbtx",
	"cfx_pwup1_lgt.emit",
	"cfx_rbep1.nsbmd",
	"cfx_rbep1.nsbtp",
	"cfx_rbep1.nsbtx",
	"cfx_rbep1_exp.emit",
	"cfx_rckp1.nsbmd",
	"cfx_rckp1.nsbtp",
	"cfx_rckp1.nsbtx",
	"cfx_rckp1_rck.emit",
	"cfx_rckp2.nsbmd",
	"cfx_rckp2.nsbtp",
	"cfx_rckp2.nsbtx",
	"cfx_rckp2_rck.emit",
	"cfx_revp1.nsbmd",
	"cfx_revp1.nsbtp",
	"cfx_revp1.nsbtx",
	"cfx_revp1_glw.emit",
	"cfx_rezp1.nsbmd",
	"cfx_rezp1.nsbtp",
	"cfx_rezp1.nsbtx",
	"cfx_rfgp1.nsbmd",
	"cfx_rfgp1.nsbtp",
	"cfx_rfgp1.nsbtx",
	"cfx_rfgp1_rfg.emit",
	"cfx_rfgp2_rfg.emit",
	"cfx_rfpp1.nsbmd",
	"cfx_rfpp1.nsbtp",
	"cfx_rfpp1.nsbtx",
	"cfx_rfpp1_rfp.emit",
	"cfx_rfpp2_rfp.emit",
	"cfx_rtbp1.nsbmd",
	"cfx_rtbp1.nsbtp",
	"cfx_rtbp1.nsbtx",
	"cfx_rtcp1.nsbmd",
	"cfx_rtcp1.nsbtp",
	"cfx_rtcp1.nsbtx",
	"cfx_rtip1.nsbmd",
	"cfx_rtip1.nsbtp",
	"cfx_rtip1.nsbtx",
	"cfx_rtip1_rta.emit",
	"cfx_rtip1_rtb.emit",
	"cfx_rtip1_rtc.emit",
	"cfx_rtip1_rtd.emit",
	"cfx_rtip1_rte.emit",
	"cfx_scap1.nsbmd",
	"cfx_scap1.nsbtp",
	"cfx_scap1.nsbtx",
	"cfx_scap1_sca.emit",
	"cfx_shcp1.nsbmd",
	"cfx_shcp1.nsbtp",
	"cfx_shcp1.nsbtx",
	"cfx_shcp1_shc.emit",
	"cfx_shgp1.nsbmd",
	"cfx_shgp1.nsbtp",
	"cfx_shgp1.nsbtx",
	"cfx_shgp1_shg.emit",
	"cfx_slgp1.nsbmd",
	"cfx_slgp1.nsbtp",
	"cfx_slgp1.nsbtx",
	"cfx_slgp1_slg.emit",
	"cfx_slpp1.nsbmd",
	"cfx_slpp1.nsbtp",
	"cfx_slpp1.nsbtx",
	"cfx_slpp1_zee.emit",
	"cfx_smgp1_smg.emit",
	"cfx_smk1.nsbmd",
	"cfx_smk1.nsbtx",
	"cfx_smk1_hismk.emit",
	"cfx_smk1_smk.emit",
	"cfx_snry_mf.nsbmd",
	"cfx_snry_mf.nsbta",
	"cfx_snry_mf.nsbtp",
	"cfx_snry_mf.nsbtx",
	"cfx_spbp1.nsbmd",
	"cfx_spbp1.nsbtp",
	"cfx_spbp1.nsbtx",
	"cfx_spbp1_shb.emit",
	"cfx_spbp1_spb.emit",
	"cfx_spcp1.nsbmd",
	"cfx_spcp1.nsbtp",
	"cfx_spcp1.nsbtx",
	"cfx_spcp1_crd.emit",
	"cfx_spk1.nsbmd",
	"cfx_spk1.nsbtp",
	"cfx_spk1.nsbtx",
	"cfx_spkp1_exc.emit",
	"cfx_spkp1_grt.emit",
	"cfx_spkp1_gud.emit",
	"cfx_spkp1_per.emit",
	"cfx_spkp1_trl.emit",
	"cfx_spk_cr1p1.emit",
	"cfx_spk_cr2p1.emit",
	"cfx_spk_cr3p1.emit",
	"cfx_spk_cr4p1.emit",
	"cfx_spk_cu0p1.emit",
	"cfx_spt_acd.nsbmd",
	"cfx_spt_acd.nsbta",
	"cfx_spt_acd.nsbtx",
	"cfx_spt_slm.nsbmd",
	"cfx_spt_slm.nsbta",
	"cfx_spt_slm.nsbtx",
	"cfx_srkp1.nsbmd",
	"cfx_srkp1.nsbtp",
	"cfx_srkp1.nsbtx",
	"cfx_srkp1_rng.emit",
	"cfx_sson_blast.emit",
	"cfx_sson_burn.emit",
	"cfx_sson_flare.emit",
	"cfx_sson_flare.nsbmd",
	"cfx_sson_flare.nsbtp",
	"cfx_sson_flare.nsbtx",
	"cfx_stngr.nsbmd",
	"cfx_stngr.nsbtx",
	"cfx_strp1.nsbmd",
	"cfx_strp1.nsbtp",
	"cfx_strp1.nsbtx",
	"cfx_strp1_rng.emit",
	"cfx_tabp1.nsbmd",
	"cfx_tabp1.nsbtp",
	"cfx_tabp1.nsbtx",
	"cfx_tabp1_spk.emit",
	"cfx_vulp1.nsbmd",
	"cfx_vulp1.nsbtp",
	"cfx_vulp1.nsbtx",
	"cfx_vulp1_glw.emit",
	"cfx_watp1.nsbmd",
	"cfx_watp1.nsbtp",
	"cfx_watp1.nsbtx",
	"cfx_watp1_drp.emit",
	"cfx_weap1.nsbmd",
	"cfx_weap1.nsbtp",
	"cfx_weap1.nsbtx",
	"cfx_weap1_glw.emit",
	"cfx_wndp1.nsbmd",
	"cfx_wndp1.nsbtp",
	"cfx_wndp1.nsbtx",
	"cfx_wndp1_wnd.emit",
	"cfx_wptp1.nsbmd",
	"cfx_wptp1.nsbtp",
	"cfx_wptp1.nsbtx",
	"cfx_wptp1_trl.emit",
	"ch10_cavalry_st.gda",
	"ch10_councilapproach.gff",
	"ch10_cyclone.gda",
	"ch10_ending_st.gda",
	"ch10_ixexplains.gda",
	"ch10_ix_explains.gda",
	"ch10_observationcam.gff",
	"ch10_plan.gda",
	"ch10_playmovie.gff",
	"ch1_intro.gda",
	"ch1_intro_st.gda",
	"ch1_panintrocam.gff",
	"ch1_rainforest_st.gda",
	"ch1_tutorialislandcam.gff",
	"ch2_islandgone.gda",
	"ch2_islandgone_st.gda",
	"ch4_shadeappears.gda",
	"ch4_shadeblockade.gda",
	"ch5_airbase.gda",
	"ch5_islandfalls.gda",
	"ch5_ixescapes.gda",
	"ch5_ixintro.gda",
	"ch5_ixpissed.gda",
	"ch5_ixpissed_st.gda",
	"ch5_permission.gda",
	"ch5_teleport.gda",
	"ch5_wormhole.gda",
	"ch6_egglab.gda",
	"ch6_egglab_st.gda",
	"ch6_introcam.gff",
	"ch6_shadesave.gda",
	"ch6_vaultentrycam.gff",
	"ch8_scylla_approachemerald.gff",
	"ch8_scylla_arenafadein.gff",
	"ch8_scylla_entertyxisbase.gff",
	"ch8_scylla_gentlemanpan.gff",
	"ch8_scylla_tyxisfadeintoarena.gff",
	"ch8_scylla_tyxisshipattack.gff",
	"ch8_scylla_tyxisshipcrash.gff",
	"chaodescription.gui",
	"chaogarden.gda",
	"chaogarden.nsbmd",
	"chaogarden.nsbta",
	"chaogarden.nsbtp",
	"chaogarden.nsbtx",
	"chaogarden_expbot.gui",
	"chaogarden_lower.gui",
	"chaogarden_newlyhatched.gui",
	"chaogarden_top.gui",
	"chaogarden_top2.gui",
	"chaogarden_tut.nbfp",
	"chaogarden_tut.nbfs",
	"chaogarden_wireicons.gui",
	"chaopickuptut.gda",
	"chaoportait.gui",
	"chaos.gda",
	"chao_aa_0.ncgr",
	"chao_aa_1.ncgr",
	"chao_aa_2.ncgr",
	"chao_aa_3.ncgr",
	"chao_aa_g.nsbmd",
	"chao_aa_g.nsbtp",
	"chao_aa_g.nsbtx",
	"chao_aa_gard.nsbmd",
	"chao_aa_gard.nsbtp",
	"chao_aa_gard.nsbtx",
	"chao_aa_r.nsbmd",
	"chao_aa_r.nsbtp",
	"chao_aa_r.nsbtx",
	"chao_aa_turn.nsbmd",
	"chao_aa_turn.nsbtp",
	"chao_aa_turn.nsbtx",
	"chao_ab_gard.nsbmd",
	"chao_ab_gard.nsbtp",
	"chao_ab_gard.nsbtx",
	"chao_ab_turn.nsbmd",
	"chao_ab_turn.nsbtp",
	"chao_ab_turn.nsbtx",
	"chao_ba_0.ncgr",
	"chao_ba_1.ncgr",
	"chao_ba_2.ncgr",
	"chao_ba_3.ncgr",
	"chao_ba_g.nsbmd",
	"chao_ba_g.nsbtp",
	"chao_ba_g.nsbtx",
	"chao_ba_r.nsbmd",
	"chao_ba_r.nsbtp",
	"chao_ba_r.nsbtx",
	"chao_ca_0.ncgr",
	"chao_ca_1.ncgr",
	"chao_ca_2.ncgr",
	"chao_ca_3.ncgr",
	"chao_ca_g.nsbmd",
	"chao_ca_g.nsbtp",
	"chao_ca_g.nsbtx",
	"chao_ca_r.nsbmd",
	"chao_ca_r.nsbtp",
	"chao_ca_r.nsbtx",
	"chao_ch_0.ncgr",
	"chao_ch_1.ncgr",
	"chao_ch_2.ncgr",
	"chao_ch_3.ncgr",
	"chao_da_0.ncgr",
	"chao_da_1.ncgr",
	"chao_da_2.ncgr",
	"chao_da_3.ncgr",
	"chao_da_g.nsbmd",
	"chao_da_g.nsbtp",
	"chao_da_g.nsbtx",
	"chao_da_r.nsbmd",
	"chao_da_r.nsbtp",
	"chao_da_r.nsbtx",
	"chao_ea_0.ncgr",
	"chao_ea_1.ncgr",
	"chao_ea_2.ncgr",
	"chao_ea_3.ncgr",
	"chao_ea_g.nsbmd",
	"chao_ea_g.nsbtp",
	"chao_ea_g.nsbtx",
	"chao_ea_r.nsbmd",
	"chao_ea_r.nsbtp",
	"chao_ea_r.nsbtx",
	"chao_fa_0.ncgr",
	"chao_fa_1.ncgr",
	"chao_fa_2.ncgr",
	"chao_fa_3.ncgr",
	"chao_fa_g.nsbmd",
	"chao_fa_g.nsbtp",
	"chao_fa_g.nsbtx",
	"chao_fa_r.nsbmd",
	"chao_fa_r.nsbtp",
	"chao_fa_r.nsbtx",
	"chao_fb_0.ncgr",
	"chao_fb_1.ncgr",
	"chao_fb_2.ncgr",
	"chao_fb_3.ncgr",
	"chao_fb_g.nsbmd",
	"chao_fb_g.nsbtp",
	"chao_fb_g.nsbtx",
	"chao_fb_r.nsbmd",
	"chao_fb_r.nsbtp",
	"chao_fb_r.nsbtx",
	"chao_fc_0.ncgr",
	"chao_fc_1.ncgr",
	"chao_fc_2.ncgr",
	"chao_fc_3.ncgr",
	"chao_fc_g.nsbmd",
	"chao_fc_g.nsbtp",
	"chao_fc_g.nsbtx",
	"chao_fc_r.nsbmd",
	"chao_fc_r.nsbtp",
	"chao_fc_r.nsbtx",
	"chao_fd_0.ncgr",
	"chao_fd_1.ncgr",
	"chao_fd_2.ncgr",
	"chao_fd_3.ncgr",
	"chao_fd_g.nsbmd",
	"chao_fd_g.nsbtp",
	"chao_fd_g.nsbtx",
	"chao_fd_r.nsbmd",
	"chao_fd_r.nsbtp",
	"chao_fd_r.nsbtx",
	"chao_fe_0.ncgr",
	"chao_fe_1.ncgr",
	"chao_fe_2.ncgr",
	"chao_fe_3.ncgr",
	"chao_fe_g.nsbmd",
	"chao_fe_g.nsbtp",
	"chao_fe_g.nsbtx",
	"chao_fe_r.nsbmd",
	"chao_fe_r.nsbtp",
	"chao_fe_r.nsbtx",
	"chao_ff_0.ncgr",
	"chao_ga_0.ncgr",
	"chao_ga_1.ncgr",
	"chao_ga_2.ncgr",
	"chao_ga_3.ncgr",
	"chao_ga_g.nsbmd",
	"chao_ga_g.nsbtp",
	"chao_ga_g.nsbtx",
	"chao_ga_r.nsbmd",
	"chao_ga_r.nsbtp",
	"chao_ga_r.nsbtx",
	"chao_gb_0.ncgr",
	"chao_gb_1.ncgr",
	"chao_gb_2.ncgr",
	"chao_gb_3.ncgr",
	"chao_gb_g.nsbmd",
	"chao_gb_g.nsbtp",
	"chao_gb_g.nsbtx",
	"chao_gb_r.nsbmd",
	"chao_gb_r.nsbtp",
	"chao_gb_r.nsbtx",
	"chao_gc_0.ncgr",
	"chao_gc_1.ncgr",
	"chao_gc_2.ncgr",
	"chao_gc_3.ncgr",
	"chao_gc_g.nsbmd",
	"chao_gc_g.nsbtp",
	"chao_gc_g.nsbtx",
	"chao_gc_r.nsbmd",
	"chao_gc_r.nsbtp",
	"chao_gc_r.nsbtx",
	"chao_gd_0.ncgr",
	"chao_gd_1.ncgr",
	"chao_gd_2.ncgr",
	"chao_gd_3.ncgr",
	"chao_gd_g.nsbmd",
	"chao_gd_g.nsbtp",
	"chao_gd_g.nsbtx",
	"chao_gd_r.nsbmd",
	"chao_gd_r.nsbtp",
	"chao_gd_r.nsbtx",
	"chao_ge_0.ncgr",
	"chao_ge_1.ncgr",
	"chao_ge_2.ncgr",
	"chao_ge_3.ncgr",
	"chao_ge_g.nsbmd",
	"chao_ge_g.nsbtp",
	"chao_ge_g.nsbtx",
	"chao_ge_r.nsbmd",
	"chao_ge_r.nsbtp",
	"chao_ge_r.nsbtx",
	"chao_ha_0.ncgr",
	"chao_ha_1.ncgr",
	"chao_ha_2.ncgr",
	"chao_ha_3.ncgr",
	"chao_ha_g.nsbmd",
	"chao_ha_g.nsbtp",
	"chao_ha_g.nsbtx",
	"chao_ha_r.nsbmd",
	"chao_ha_r.nsbtp",
	"chao_ha_r.nsbtx",
	"chao_hb_0.ncgr",
	"chao_hb_1.ncgr",
	"chao_hb_2.ncgr",
	"chao_hb_3.ncgr",
	"chao_hb_g.nsbmd",
	"chao_hb_g.nsbtp",
	"chao_hb_g.nsbtx",
	"chao_hb_r.nsbmd",
	"chao_hb_r.nsbtp",
	"chao_hb_r.nsbtx",
	"chao_hc_0.ncgr",
	"chao_hc_1.ncgr",
	"chao_hc_2.ncgr",
	"chao_hc_3.ncgr",
	"chao_hc_g.nsbmd",
	"chao_hc_g.nsbtp",
	"chao_hc_g.nsbtx",
	"chao_hc_r.nsbmd",
	"chao_hc_r.nsbtp",
	"chao_hc_r.nsbtx",
	"chao_hd_0.ncgr",
	"chao_hd_1.ncgr",
	"chao_hd_2.ncgr",
	"chao_hd_3.ncgr",
	"chao_hd_g.nsbmd",
	"chao_hd_g.nsbtp",
	"chao_hd_g.nsbtx",
	"chao_hd_r.nsbmd",
	"chao_hd_r.nsbtp",
	"chao_hd_r.nsbtx",
	"chao_he_0.ncgr",
	"chao_he_1.ncgr",
	"chao_he_2.ncgr",
	"chao_he_3.ncgr",
	"chao_he_g.nsbmd",
	"chao_he_g.nsbtp",
	"chao_he_g.nsbtx",
	"chao_he_r.nsbmd",
	"chao_he_r.nsbtp",
	"chao_he_r.nsbtx",
	"chao_ia_0.ncgr",
	"chao_ia_1.ncgr",
	"chao_ia_2.ncgr",
	"chao_ia_3.ncgr",
	"chao_ia_g.nsbmd",
	"chao_ia_g.nsbtp",
	"chao_ia_g.nsbtx",
	"chao_ia_r.nsbmd",
	"chao_ia_r.nsbtp",
	"chao_ia_r.nsbtx",
	"chao_ib_0.ncgr",
	"chao_ib_1.ncgr",
	"chao_ib_2.ncgr",
	"chao_ib_3.ncgr",
	"chao_ib_g.nsbmd",
	"chao_ib_g.nsbtp",
	"chao_ib_g.nsbtx",
	"chao_ib_r.nsbmd",
	"chao_ib_r.nsbtp",
	"chao_ib_r.nsbtx",
	"chao_ic_0.ncgr",
	"chao_ic_1.ncgr",
	"chao_ic_2.ncgr",
	"chao_ic_3.ncgr",
	"chao_ic_g.nsbmd",
	"chao_ic_g.nsbtp",
	"chao_ic_g.nsbtx",
	"chao_ic_r.nsbmd",
	"chao_ic_r.nsbtp",
	"chao_ic_r.nsbtx",
	"chao_id_0.ncgr",
	"chao_id_1.ncgr",
	"chao_id_2.ncgr",
	"chao_id_3.ncgr",
	"chao_id_g.nsbmd",
	"chao_id_g.nsbtp",
	"chao_id_g.nsbtx",
	"chao_id_r.nsbmd",
	"chao_id_r.nsbtp",
	"chao_id_r.nsbtx",
	"chao_ie_0.ncgr",
	"chao_ie_1.ncgr",
	"chao_ie_2.ncgr",
	"chao_ie_3.ncgr",
	"chao_ie_g.nsbmd",
	"chao_ie_g.nsbtp",
	"chao_ie_g.nsbtx",
	"chao_ie_r.nsbmd",
	"chao_ie_r.nsbtp",
	"chao_ie_r.nsbtx",
	"chao_ja_0.ncgr",
	"chao_ja_1.ncgr",
	"chao_ja_2.ncgr",
	"chao_ja_3.ncgr",
	"chao_ja_g.nsbmd",
	"chao_ja_g.nsbtp",
	"chao_ja_g.nsbtx",
	"chao_ja_r.nsbmd",
	"chao_ja_r.nsbtp",
	"chao_ja_r.nsbtx",
	"chao_jb_0.ncgr",
	"chao_jb_1.ncgr",
	"chao_jb_2.ncgr",
	"chao_jb_3.ncgr",
	"chao_jb_g.nsbmd",
	"chao_jb_g.nsbtp",
	"chao_jb_g.nsbtx",
	"chao_jb_r.nsbmd",
	"chao_jb_r.nsbtp",
	"chao_jb_r.nsbtx",
	"chao_jc_0.ncgr",
	"chao_jc_1.ncgr",
	"chao_jc_2.ncgr",
	"chao_jc_3.ncgr",
	"chao_jc_g.nsbmd",
	"chao_jc_g.nsbtp",
	"chao_jc_g.nsbtx",
	"chao_jc_r.nsbmd",
	"chao_jc_r.nsbtp",
	"chao_jc_r.nsbtx",
	"chao_jd_0.ncgr",
	"chao_jd_1.ncgr",
	"chao_jd_2.ncgr",
	"chao_jd_3.ncgr",
	"chao_jd_g.nsbmd",
	"chao_jd_g.nsbtp",
	"chao_jd_g.nsbtx",
	"chao_jd_r.nsbmd",
	"chao_jd_r.nsbtp",
	"chao_jd_r.nsbtx",
	"chao_je_0.ncgr",
	"chao_je_1.ncgr",
	"chao_je_2.ncgr",
	"chao_je_3.ncgr",
	"chao_je_g.nsbmd",
	"chao_je_g.nsbtp",
	"chao_je_g.nsbtx",
	"chao_je_r.nsbmd",
	"chao_je_r.nsbtp",
	"chao_je_r.nsbtx",
	"chao_jf_0.ncgr",
	"chao_jf_1.ncgr",
	"chao_jf_2.ncgr",
	"chao_jf_3.ncgr",
	"chao_jf_g.nsbmd",
	"chao_jf_g.nsbtp",
	"chao_jf_g.nsbtx",
	"chao_jf_r.nsbmd",
	"chao_jf_r.nsbtp",
	"chao_jf_r.nsbtx",
	"chao_jg_0.ncgr",
	"chao_jg_1.ncgr",
	"chao_jg_2.ncgr",
	"chao_jg_3.ncgr",
	"chao_jg_g.nsbmd",
	"chao_jg_g.nsbtp",
	"chao_jg_g.nsbtx",
	"chao_jg_r.nsbmd",
	"chao_jg_r.nsbtp",
	"chao_jg_r.nsbtx",
	"chao_jh_0.ncgr",
	"chao_jh_1.ncgr",
	"chao_jh_2.ncgr",
	"chao_jh_3.ncgr",
	"chao_jh_g.nsbmd",
	"chao_jh_g.nsbtp",
	"chao_jh_g.nsbtx",
	"chao_jh_r.nsbmd",
	"chao_jh_r.nsbtp",
	"chao_jh_r.nsbtx",
	"chao_ji_0.ncgr",
	"chao_ji_1.ncgr",
	"chao_ji_2.ncgr",
	"chao_ji_3.ncgr",
	"chao_ji_g.nsbmd",
	"chao_ji_g.nsbtp",
	"chao_ji_g.nsbtx",
	"chao_ji_r.nsbmd",
	"chao_ji_r.nsbtp",
	"chao_ji_r.nsbtx",
	"chao_jj_0.ncgr",
	"chao_jj_1.ncgr",
	"chao_jj_2.ncgr",
	"chao_jj_3.ncgr",
	"chao_jj_g.nsbmd",
	"chao_jj_g.nsbtp",
	"chao_jj_g.nsbtx",
	"chao_jj_r.nsbmd",
	"chao_jj_r.nsbtp",
	"chao_jj_r.nsbtx",
	"chao_jk_0.ncgr",
	"chao_jk_1.ncgr",
	"chao_jk_2.ncgr",
	"chao_jk_3.ncgr",
	"chao_jk_g.nsbmd",
	"chao_jk_g.nsbtp",
	"chao_jk_g.nsbtx",
	"chao_jk_r.nsbmd",
	"chao_jk_r.nsbtp",
	"chao_jk_r.nsbtx",
	"chao_jl_0.ncgr",
	"chao_jl_1.ncgr",
	"chao_jl_2.ncgr",
	"chao_jl_3.ncgr",
	"chao_jl_g.nsbmd",
	"chao_jl_g.nsbtp",
	"chao_jl_g.nsbtx",
	"chao_jl_r.nsbmd",
	"chao_jl_r.nsbtp",
	"chao_jl_r.nsbtx",
	"chao_jm_0.ncgr",
	"chao_jm_1.ncgr",
	"chao_jm_2.ncgr",
	"chao_jm_3.ncgr",
	"chao_jm_g.nsbmd",
	"chao_jm_g.nsbtp",
	"chao_jm_g.nsbtx",
	"chao_jm_r.nsbmd",
	"chao_jm_r.nsbtp",
	"chao_jm_r.nsbtx",
	"chao_jn_0.ncgr",
	"chao_jn_1.ncgr",
	"chao_jn_2.ncgr",
	"chao_jn_3.ncgr",
	"chao_jn_g.nsbmd",
	"chao_jn_g.nsbtp",
	"chao_jn_g.nsbtx",
	"chao_jn_r.nsbmd",
	"chao_jn_r.nsbtp",
	"chao_jn_r.nsbtx",
	"chao_jo_0.ncgr",
	"chao_jo_1.ncgr",
	"chao_jo_2.ncgr",
	"chao_jo_3.ncgr",
	"chao_jo_g.nsbmd",
	"chao_jo_g.nsbtp",
	"chao_jo_g.nsbtx",
	"chao_jo_r.nsbmd",
	"chao_jo_r.nsbtp",
	"chao_jo_r.nsbtx",
	"chao_jp_0.ncgr",
	"chao_jp_1.ncgr",
	"chao_jp_2.ncgr",
	"chao_jp_3.ncgr",
	"chao_jp_g.nsbmd",
	"chao_jp_g.nsbtp",
	"chao_jp_g.nsbtx",
	"chao_jp_r.nsbmd",
	"chao_jp_r.nsbtp",
	"chao_jp_r.nsbtx",
	"chao_jq_0.ncgr",
	"chao_jq_1.ncgr",
	"chao_jq_2.ncgr",
	"chao_jq_3.ncgr",
	"chao_jq_g.nsbmd",
	"chao_jq_g.nsbtp",
	"chao_jq_g.nsbtx",
	"chao_jq_r.nsbmd",
	"chao_jq_r.nsbtp",
	"chao_jq_r.nsbtx",
	"chao_jr_0.ncgr",
	"chao_jr_1.ncgr",
	"chao_jr_2.ncgr",
	"chao_jr_3.ncgr",
	"chao_jr_g.nsbmd",
	"chao_jr_g.nsbtp",
	"chao_jr_g.nsbtx",
	"chao_jr_r.nsbmd",
	"chao_jr_r.nsbtp",
	"chao_jr_r.nsbtx",
	"chao_js_0.ncgr",
	"chao_js_1.ncgr",
	"chao_js_2.ncgr",
	"chao_js_3.ncgr",
	"chao_js_g.nsbmd",
	"chao_js_g.nsbtp",
	"chao_js_g.nsbtx",
	"chao_js_r.nsbmd",
	"chao_js_r.nsbtp",
	"chao_js_r.nsbtx",
	"chao_jt_0.ncgr",
	"chao_jt_1.ncgr",
	"chao_jt_2.ncgr",
	"chao_jt_3.ncgr",
	"chao_jt_g.nsbmd",
	"chao_jt_g.nsbtp",
	"chao_jt_g.nsbtx",
	"chao_jt_r.nsbmd",
	"chao_jt_r.nsbtp",
	"chao_jt_r.nsbtx",
	"chap0scr_bot.tga",
	"chap10scr_top.tga",
	"chap1scr_top.tga",
	"chap2scr_top.tga",
	"chap3scr_top.tga",
	"chap4scr_top.tga",
	"chap5scr_top.tga",
	"chap6scr_top.tga",
	"chap7scr_top.tga",
	"chap8scr_top.tga",
	"chap9scr_top.tga",
	"chapter0.gda",
	"chapter1.gda",
	"chapter10.gda",
	"chapter10nocturne.gff",
	"chapter10nocturne3.gff",
	"chapter10nocturne_p7.gff",
	"chapter10warp.gff",
	"chapter2.gda",
	"chapter2ruinswarp.gff",
	"chapter2warp.gff",
	"chapter3.gda",
	"chapter3warp.gff",
	"chapter4.gda",
	"chapter4warp.gff",
	"chapter5.gda",
	"chapter5warp.gff",
	"chapter5warp2.gff",
	"chapter5warp3.gff",
	"chapter5warp4.gff",
	"chapter5warp5.gff",
	"chapter5warp6.gff",
	"chapter5warp7.gff",
	"chapter5warp8.gff",
	"chapter5warp9.gff",
	"chapter6.gda",
	"chapter6warp.gff",
	"chapter7.gda",
	"chapter7warp.gff",
	"chapter8charyb.gda",
	"chapter8charyb.gff",
	"chapter8scylla.gda",
	"chapter8scylla.gff",
	"chapter9charyb.gda",
	"chapter9scylla.gda",
	"chapters.gda",
	"charpip.ncgr",
	"charpro_amy.nclr",
	"charpro_amy0.ncgr",
	"charpro_amy1.ncgr",
	"charpro_amy2.ncgr",
	"charpro_amy3.ncgr",
	"charpro_amy4.ncgr",
	"charpro_amy5.ncgr",
	"charpro_back.ncgr",
	"charpro_backon.ncgr",
	"charpro_bar00.ncgr",
	"charpro_bar01.ncgr",
	"charpro_bar02.ncgr",
	"charpro_bar03.ncgr",
	"charpro_barlit00.ncgr",
	"charpro_barlit01.ncgr",
	"charpro_barlit02.ncgr",
	"charpro_barlit03.ncgr",
	"charpro_big.nclr",
	"charpro_big0.ncgr",
	"charpro_big1.ncgr",
	"charpro_big2.ncgr",
	"charpro_big3.ncgr",
	"charpro_big4.ncgr",
	"charpro_big5.ncgr",
	"charpro_bs_a00.ncgr",
	"charpro_bs_a01.ncgr",
	"charpro_bs_a02.ncgr",
	"charpro_bs_a03a.ncgr",
	"charpro_bs_a03b.ncgr",
	"charpro_bs_b00.ncgr",
	"charpro_bs_b01.ncgr",
	"charpro_bs_b02.ncgr",
	"charpro_bs_b03.ncgr",
	"charpro_bs_b04.ncgr",
	"charpro_bs_b05.ncgr",
	"charpro_bs_c00.ncgr",
	"charpro_bs_c01.ncgr",
	"charpro_bs_c02.ncgr",
	"charpro_bs_c03.ncgr",
	"charpro_bs_c10.ncgr",
	"charpro_bs_c11.ncgr",
	"charpro_bs_c12.ncgr",
	"charpro_bs_c13.ncgr",
	"charpro_bs_c14.ncgr",
	"charpro_bs_c15.ncgr",
	"charpro_cre.nclr",
	"charpro_cre0.ncgr",
	"charpro_cre1.ncgr",
	"charpro_cre2.ncgr",
	"charpro_cre3.ncgr",
	"charpro_cre4.ncgr",
	"charpro_cre5.ncgr",
	"charpro_egg.nclr",
	"charpro_egg0.ncgr",
	"charpro_egg1.ncgr",
	"charpro_egg2.ncgr",
	"charpro_egg3.ncgr",
	"charpro_egg4.ncgr",
	"charpro_egg5.ncgr",
	"charpro_knu.nclr",
	"charpro_knu0.ncgr",
	"charpro_knu1.ncgr",
	"charpro_knu2.ncgr",
	"charpro_knu3.ncgr",
	"charpro_knu4.ncgr",
	"charpro_knu5.ncgr",
	"charpro_ome.nclr",
	"charpro_ome0.ncgr",
	"charpro_ome1.ncgr",
	"charpro_ome2.ncgr",
	"charpro_ome3.ncgr",
	"charpro_ome4.ncgr",
	"charpro_ome5.ncgr",
	"charpro_rou.nclr",
	"charpro_rou0.ncgr",
	"charpro_rou1.ncgr",
	"charpro_rou2.ncgr",
	"charpro_rou3.ncgr",
	"charpro_rou4.ncgr",
	"charpro_rou5.ncgr",
	"charpro_sdw.nclr",
	"charpro_sdw0.ncgr",
	"charpro_sdw1.ncgr",
	"charpro_sdw2.ncgr",
	"charpro_sdw3.ncgr",
	"charpro_sdw4.ncgr",
	"charpro_sdw5.ncgr",
	"charpro_she.nclr",
	"charpro_she0.ncgr",
	"charpro_she1.ncgr",
	"charpro_she2.ncgr",
	"charpro_she3.ncgr",
	"charpro_she4.ncgr",
	"charpro_she5.ncgr",
	"charpro_son.nclr",
	"charpro_son0.ncgr",
	"charpro_son1.ncgr",
	"charpro_son2.ncgr",
	"charpro_son3.ncgr",
	"charpro_son4.ncgr",
	"charpro_son5.ncgr",
	"charpro_stat00.ncgr",
	"charpro_stat01.ncgr",
	"charpro_stat10.ncgr",
	"charpro_stat11.ncgr",
	"charpro_stat20.ncgr",
	"charpro_stat21.ncgr",
	"charpro_stat30.ncgr",
	"charpro_stat31.ncgr",
	"charpro_stat_tab1.ncgr",
	"charpro_stat_tab2.ncgr",
	"charpro_stat_tab3.ncgr",
	"charpro_stat_tab4.ncgr",
	"charpro_stat_tablit1.ncgr",
	"charpro_stat_tablit2.ncgr",
	"charpro_stat_tablit3.ncgr",
	"charpro_stat_tablit4.ncgr",
	"charpro_tai.nclr",
	"charpro_tai0.ncgr",
	"charpro_tai1.ncgr",
	"charpro_tai2.ncgr",
	"charpro_tai3.ncgr",
	"charpro_tai4.ncgr",
	"charpro_tai5.ncgr",
	"charpro_ts_a00.ncgr",
	"charpro_ts_a01.ncgr",
	"charpro_ts_a02.ncgr",
	"charpro_ts_a10.ncgr",
	"charpro_ts_a11.ncgr",
	"charpro_ts_a12.ncgr",
	"charpro_ts_a13.ncgr",
	"charpro_ts_a14.ncgr",
	"charpro_ts_b00.ncgr",
	"charpro_ts_b01.ncgr",
	"charpro_ts_b02.ncgr",
	"charpro_ts_b10.ncgr",
	"charpro_ts_b11.ncgr",
	"charpro_ts_b12.ncgr",
	"chasechapter1.gda",
	"chaseduo.gda",
	"chaseix.gda",
	"chaseshadow.gda",
	"chasesolo.gda",
	"chasestandard1.gda",
	"chasestandard2.gda",
	"chasestandard3.gda",
	"chasestandard4.gda",
	"chasestandard5.gda",
	"chasestandard6.gda",
	"chasetrio.gda",
	"chasetutorial.gda",
	"cho_lgbtn_di00.ncgr",
	"cho_lgbtn_di01.ncgr",
	"cho_lgbtn_di02.ncgr",
	"cho_lgbtn_di03.ncgr",
	"cho_lgbtn_hi00.ncgr",
	"cho_lgbtn_hi01.ncgr",
	"cho_lgbtn_hi02.ncgr",
	"cho_lgbtn_hi03.ncgr",
	"cho_smbtn_of00.ncgr",
	"cho_smbtn_on00.ncgr",
	"cho_tlgbx_ms00.ncgr",
	"cho_tlgbx_ms01.ncgr",
	"cho_tlgbx_ms02.ncgr",
	"cho_tlgbx_ms10.ncgr",
	"cho_tlgbx_ms11.ncgr",
	"cho_tlgbx_ms12.ncgr",
	"cho_tmbt2_of02.ncgr",
	"cho_tmbt2_on02.ncgr",
	"cho_tmbtn_of00.ncgr",
	"cho_tmbtn_of01.ncgr",
	"cho_tmbtn_of02.ncgr",
	"cho_tmbtn_on00.ncgr",
	"cho_tmbtn_on01.ncgr",
	"cho_tmbtn_on02.ncgr",
	"cho_tradeoverlay.gui",
	"cho_tsmbx_ms00.ncgr",
	"cho_tsmbx_ms01.ncgr",
	"cho_tsmbx_ms02.ncgr",
	"cho_ts_00.ncgr",
	"cho_ts_01.ncgr",
	"cho_ts_02.ncgr",
	"cho_ts_03.ncgr",
	"cho_ts_10.ncgr",
	"cho_ts_11.ncgr",
	"cho_ts_12.ncgr",
	"cho_ts_13.ncgr",
	"cho_ts_20.ncgr",
	"cho_ts_21.ncgr",
	"cho_ts_22.ncgr",
	"cho_ts_23.ncgr",
	"classes.gda",
	"cmbtbg_a1_i01.nsbca",
	"cmbtbg_a1_i01.nsbmd",
	"cmbtbg_a1_i01.nsbta",
	"cmbtbg_a1_i01.nsbtx",
	"cmbtbg_a1_i02.nsbca",
	"cmbtbg_a1_i02.nsbmd",
	"cmbtbg_a1_i02.nsbta",
	"cmbtbg_a1_i02.nsbtx",
	"cmbtbg_a1_s1.nsbca",
	"cmbtbg_a1_s1.nsbmd",
	"cmbtbg_a1_s1.nsbta",
	"cmbtbg_a1_s1.nsbtx",
	"cmbtbg_a1_s2.nsbca",
	"cmbtbg_a1_s2.nsbmd",
	"cmbtbg_a1_s2.nsbta",
	"cmbtbg_a1_s2.nsbtx",
	"cmbtbg_a1_s3.nsbca",
	"cmbtbg_a1_s3.nsbmd",
	"cmbtbg_a1_s3.nsbta",
	"cmbtbg_a1_s3.nsbtx",
	"cmbtbg_a1_s4.nsbmd",
	"cmbtbg_a1_s4.nsbta",
	"cmbtbg_a1_s4.nsbtx",
	"cmbtbg_a1_s5.nsbmd",
	"cmbtbg_a1_s5.nsbta",
	"cmbtbg_a1_s5.nsbtx",
	"cmbtbg_a1_s6.nsbmd",
	"cmbtbg_a1_s6.nsbta",
	"cmbtbg_a1_s6.nsbtx",
	"cmbtbg_a2_s1.nsbmd",
	"cmbtbg_a2_s1.nsbta",
	"cmbtbg_a2_s1.nsbtx",
	"cmbtbg_a2_s2.nsbmd",
	"cmbtbg_a2_s2.nsbta",
	"cmbtbg_a2_s2.nsbtx",
	"cmbtbg_a2_s3.nsbmd",
	"cmbtbg_a2_s3.nsbta",
	"cmbtbg_a2_s3.nsbtx",
	"cmbtbg_a2_s4.nsbmd",
	"cmbtbg_a2_s4.nsbta",
	"cmbtbg_a2_s4.nsbtx",
	"cmbtbg_a2_s5.nsbmd",
	"cmbtbg_a2_s5.nsbta",
	"cmbtbg_a2_s5.nsbtx",
	"cmbtbg_a2_s6.nsbmd",
	"cmbtbg_a2_s6.nsbta",
	"cmbtbg_a2_s6.nsbtx",
	"cmbtbg_a2_s7.nsbmd",
	"cmbtbg_a2_s7.nsbta",
	"cmbtbg_a2_s7.nsbtx",
	"cmbtbg_a2_s7_i01.nsbmd",
	"cmbtbg_a2_s7_i01.nsbta",
	"cmbtbg_a2_s7_i01.nsbtx",
	"cmbtbg_a2_s7_i02.nsbmd",
	"cmbtbg_a2_s7_i02.nsbta",
	"cmbtbg_a2_s7_i02.nsbtx",
	"cmbtbg_a2_s7_i03.nsbmd",
	"cmbtbg_a2_s7_i03.nsbta",
	"cmbtbg_a2_s7_i03.nsbtx",
	"cmbtbg_ts_ghz1.nclr",
	"cmbtbg_ts_ghz100.ncgr",
	"cmbtbg_ts_ghz101.ncgr",
	"cmbtbg_ts_ghz102.ncgr",
	"cmbtbg_ts_ghz103.ncgr",
	"cmbtbg_ts_ghz110.ncgr",
	"cmbtbg_ts_ghz111.ncgr",
	"cmbtbg_ts_ghz112.ncgr",
	"cmbtbg_ts_ghz113.ncgr",
	"cmbtbg_ts_ghz120.ncgr",
	"cmbtbg_ts_ghz121.ncgr",
	"cmbtbg_ts_ghz122.ncgr",
	"cmbtbg_ts_ghz123.ncgr",
	"cmra_aim.nsbmd",
	"cmra_aim.nsbtx",
	"combatactions.gda",
	"combatai.gda",
	"combatfinished.gui",
	"combatgui.nclr",
	"combatguib.nclr",
	"combatguic.nclr",
	"combatguigrey.nclr",
	"combatguilayout.gui",
	"combatinputs.nclr",
	"combatportraitlayout.gui",
	"combatqueue.gui",
	"combatrules.gda",
	"combatsounds.gda",
	"combattopscreen.gui",
	"combo.gda",
	"combo2.ncgr",
	"combo3.ncgr",
	"combo4.ncgr",
	"commandselectionring.gui",
	"commandselectionringmanual.gui",
	"compoundevents.gda",
	"conversationicons.gda",
	"conversationlower.gui",
	"conversationreplies.gui",
	"conversations.gda",
	"conversationupper.gui",
	"conversation_lower.nclr",
	"conversation_upper.nclr",
	"convo.nftr",
	"convo2.nftr",
	"convoshadow.nftr",
	"conv_ambient_bkgd.nbfp",
	"conv_ambient_bkgd.nbfs",
	"conv_ambient_bkgd.tga",
	"conv_arrow_of00.ncgr",
	"conv_arrow_on00.ncgr",
	"conv_bark_bs00.ncgr",
	"conv_bark_bs01.ncgr",
	"conv_bark_bs02.ncgr",
	"conv_bark_bs03.ncgr",
	"conv_bubbles.nclr",
	"conv_bubble_amb00.ncgr",
	"conv_bubble_amb01.ncgr",
	"conv_bubble_amb02.ncgr",
	"conv_bubble_amb03.ncgr",
	"conv_bubble_bs00.ncgr",
	"conv_bubble_bs01.ncgr",
	"conv_bubble_bs02.ncgr",
	"conv_bubble_bs10.ncgr",
	"conv_bubble_bs11.ncgr",
	"conv_bubble_bs12.ncgr",
	"conv_bubble_tab01.ncgr",
	"conv_bubble_tab02.ncgr",
	"conv_bubble_tab03.ncgr",
	"conv_bubble_tab04.ncgr",
	"conv_bubble_ts00.ncgr",
	"conv_bubble_ts01.ncgr",
	"conv_bubble_ts02.ncgr",
	"conv_bubble_ts03.ncgr",
	"conv_bubble_ts10.ncgr",
	"conv_bubble_ts11.ncgr",
	"conv_bubble_ts12.ncgr",
	"conv_bubble_ts13.ncgr",
	"conv_check_of00.ncgr",
	"conv_check_on00.ncgr",
	"conv_icon01.ncgr",
	"conv_icon02.ncgr",
	"conv_icon03.ncgr",
	"conv_icon04.ncgr",
	"conv_icon05.ncgr",
	"conv_icon06.ncgr",
	"conv_icon07.ncgr",
	"conv_icon08.ncgr",
	"conv_icon09.ncgr",
	"conv_iconblank.ncgr",
	"conv_icons.nclr",
	"conv_portr_00.ncgr",
	"conv_portr_01.ncgr",
	"conv_portr_10.ncgr",
	"conv_portr_11.ncgr",
	"conv_portr_12.ncgr",
	"conv_portr_20.ncgr",
	"conv_portr_21.ncgr",
	"conv_portr_22.ncgr",
	"creaturepositions.gda",
	"creatures.gda",
	"creaturetypetut.gda",
	"credits.dlg",
	"credits_reset.gff",
	"crm_cb_attack.nsbca",
	"crm_cb_attackend.nsbca",
	"crm_cb_block.nsbca",
	"crm_cb_blockc.nsbca",
	"crm_cb_blockd.nsbca",
	"crm_cb_blockin.nsbca",
	"crm_cb_blockout.nsbca",
	"crm_cb_counter.nsbca",
	"crm_cb_damage.nsbca",
	"crm_cb_dead.nsbca",
	"crm_cb_getup.nsbca",
	"crm_cb_idle.nsbca",
	"crm_cb_kd.nsbca",
	"crm_cb_pattack01.nsbca",
	"crm_cb_pattack02.nsbca",
	"crm_cb_pattack03.nsbca",
	"crm_cb_pattack04.nsbca",
	"crm_cb_pattack05.nsbca",
	"crm_cb_pattack06.nsbca",
	"crm_cb_rund.nsbca",
	"crm_cb_stunned.nsbca",
	"crm_cb_victory.nsbca",
	"crm_cb_victoryin.nsbca",
	"crm_ex_damage.nsbca",
	"crm_ex_fall.nsbca",
	"crm_ex_fly.nsbca",
	"crm_ex_flyin.nsbca",
	"crm_ex_flyout.nsbca",
	"crm_ex_idle.nsbca",
	"crm_ex_jump.nsbca",
	"crm_ex_jumpair.nsbca",
	"crm_ex_run.nsbca",
	"crm_ex_twitch.nsbca",
	"crm_ex_walk.nsbca",
	"cw_e_s.gff",
	"cw_ne_se.gff",
	"cw_nw_ne.gff",
	"cw_n_e.gff",
	"cw_se_sw.gff",
	"cw_sw_nw.gff",
	"cw_s_w.gff",
	"cw_w_n.gff",
	"cyclone_kron.are",
	"cyclone_nocturn.are",
	"cyclone_nrrgal.are",
	"cyclone_voxai.are",
	"cyclone_zoah.are",
	"c_ambicr_am.nsbca",
	"c_ambicr_bi.nsbca",
	"c_ambicr_cr.nsbca",
	"c_amcr_am.nsbca",
	"c_amcr_cr.nsbca",
	"c_knshashe_kn.nsbca",
	"c_knshashe_sha.nsbca",
	"c_knshashe_she.nsbca",
	"c_knshe_kn.nsbca",
	"c_knshe_she.nsbca",
	"c_ombi_bi.nsbca",
	"c_ombi_om.nsbca",
	"c_omro_om.nsbca",
	"c_omro_ro.nsbca",
	"c_rokn_kn.nsbca",
	"c_rokn_ro.nsbca",
	"c_shakn_kn.nsbca",
	"c_shakn_sha.nsbca",
	"c_shaom_om.nsbca",
	"c_shaom_sha.nsbca",
	"c_sharoom_om.nsbca",
	"c_sharoom_ro.nsbca",
	"c_sharoom_sha.nsbca",
	"c_sheso_sb.nsbca",
	"c_sheso_she.nsbca",
	"c_sheso_so.nsbca",
	"c_soam_am.nsbca",
	"c_soam_sb.nsbca",
	"c_soam_so.nsbca",
	"c_soknamta_am.nsbca",
	"c_soknamta_kn.nsbca",
	"c_soknamta_sb.nsbca",
	"c_soknamta_so.nsbca",
	"c_soknamta_ta.nsbca",
	"c_soknam_am.nsbca",
	"c_soknam_kn.nsbca",
	"c_soknam_so.nsbca",
	"c_soknta_kn.nsbca",
	"c_soknta_sb.nsbca",
	"c_soknta_so.nsbca",
	"c_soknta_ta.nsbca",
	"c_sokn_kn.nsbca",
	"c_sokn_sb.nsbca",
	"c_sokn_so.nsbca",
	"c_sosh_sb.nsbca",
	"c_sosh_sh.nsbca",
	"c_sosh_shab.nsbca",
	"c_sosh_so.nsbca",
	"c_sotaamkn_1_am.nsbca",
	"c_sotaamkn_1_am1.nsbca",
	"c_sotaamkn_1_am2.nsbca",
	"c_sotaamkn_1_kn.nsbca",
	"c_sotaamkn_1_kn1.nsbca",
	"c_sotaamkn_1_kn2.nsbca",
	"c_sotaamkn_1_sb.nsbca",
	"c_sotaamkn_1_sb2.nsbca",
	"c_sotaamkn_1_so.nsbca",
	"c_sotaamkn_1_so1.nsbca",
	"c_sotaamkn_1_so2.nsbca",
	"c_sotaamkn_1_ta.nsbca",
	"c_sotaamkn_1_ta1.nsbca",
	"c_sotaamkn_1_ta2.nsbca",
	"c_sota_sb.nsbca",
	"c_sota_so.nsbca",
	"c_sota_ta.nsbca",
	"c_taeg_eg.nsbca",
	"c_taeg_ta.nsbca",
	"debug.gda",
	"debugaccessories.gda",
	"debugarea.gda",
	"debugarea2.gda",
	"debugarea3.gda",
	"debugchao1.gda",
	"debugchao2.gda",
	"debugcreatechao.gda",
	"debugcreateitems.gda",
	"debugcreaturestats.gda",
	"debugfootwear.gda",
	"debuggamespeed.gda",
	"debuggloves.gda",
	"debuglevelup.gda",
	"debuglevelup2.gda",
	"debugloadslots.gda",
	"debugparty.gda",
	"debugqa.gda",
	"debugqastats.gda",
	"debugrecoveryitems.gda",
	"debugsave.gda",
	"debugsplash.gda",
	"debugstatusitems.gda",
	"debuguseitems.gda",
	"defeat.nbfp",
	"defeat.nbfs",
	"defeattip.gui",
	"defend.ncgr",
	"demo_loop_1_a.gff",
	"demo_loop_1_b.gff",
	"demo_loop_2.gff",
	"demo_loop_3.gff",
	"dft_scr_00.ncgr",
	"dft_scr_01.ncgr",
	"dft_scr_02.ncgr",
	"dft_scr_10.ncgr",
	"dft_scr_11.ncgr",
	"dft_scr_12.ncgr",
	"drnass_aa.nsbmd",
	"drnass_aa.nsbtx",
	"drnass_cb_attack.nsbca",
	"drna_cb_attacken.nsbca",
	"drnlaz_aa.nsbmd",
	"drnlaz_aa.nsbtx",
	"drnlaz_cb_attack.nsbca",
	"drnlaz_ex_idle.nsbca",
	"drnl_cb_attacken.nsbca",
	"drnsen_aa.nsbmd",
	"drnsen_aa.nsbtx",
	"drnsui_aa.nsbmd",
	"drnsui_aa.nsbtx",
	"drnsui_cb_attack.nsbca",
	"drnsui_cb_off.nsbca",
	"drnsui_ex_idle.nsbca",
	"drn_cb_counter.nsbca",
	"drn_cb_dead.nsbca",
	"drn_cb_getup.nsbca",
	"drn_cb_kd.nsbca",
	"drn_cb_pattack.nsbca",
	"drn_ex_damage.nsbca",
	"drn_ex_run.nsbca",
	"drn_ex_walk.nsbca",
	"dungeons.nbfp",
	"dungeons.nbfs",
	"ecm_aa.nsbmd",
	"ecm_aa.nsbtx",
	"ecm_cb_pattack.nsbca",
	"ecm_fx_mflash.nsbtp",
	"edgecolors.gda",
	"effectspalette.nclr",
	"effectspalette.nclr",
	"egb_aa.nsbmd",
	"egb_aa.nsbtx",
	"egb_cb_attack.nsbca",
	"egb_cb_attackend.nsbca",
	"egb_cb_blockc.nsbca",
	"egb_cb_blockd.nsbca",
	"egb_cb_blockidle.nsbca",
	"egb_cb_blockin.nsbca",
	"egb_cb_blockout.nsbca",
	"egb_cb_counter.nsbca",
	"egb_cb_damage.nsbca",
	"egb_cb_dead.nsbca",
	"egb_cb_getup.nsbca",
	"egb_cb_idle.nsbca",
	"egb_cb_kd.nsbca",
	"egb_cb_pattack.nsbca",
	"egb_ex_idle.nsbca",
	"egb_ex_run.nsbca",
	"egb_ex_walk.nsbca",
	"egm_aa.nsbmd",
	"egm_aa.nsbtx",
	"egm_cb_attack.nsbca",
	"egm_cb_attackend.nsbca",
	"egm_cb_blockc.nsbca",
	"egm_cb_blockd.nsbca",
	"egm_cb_blockidle.nsbca",
	"egm_cb_blockin.nsbca",
	"egm_cb_blockout.nsbca",
	"egm_cb_counter.nsbca",
	"egm_cb_damage.nsbca",
	"egm_cb_dead.nsbca",
	"egm_cb_getup.nsbca",
	"egm_cb_idle.nsbca",
	"egm_cb_kd.nsbca",
	"egm_cb_pattack01.nsbca",
	"egm_cb_rund.nsbca",
	"egm_cb_stunned.nsbca",
	"egm_cb_victory.nsbca",
	"egm_cb_victoryin.nsbca",
	"egm_ex_damage.nsbca",
	"egm_ex_fall.nsbca",
	"egm_ex_idle.nsbca",
	"egm_ex_jump.nsbca",
	"egm_ex_jumpair.nsbca",
	"egm_ex_run.nsbca",
	"egm_ex_twitch.nsbca",
	"egm_ex_walk.nsbca",
	"ehd_blbar_ms00.ncgr",
	"ehd_blbox_ms00.ncgr",
	"ehd_circl_hi00.ncgr",
	"ehd_fow_f.ncgr",
	"ehd_fow_fu.ncgr",
	"ehd_fow_huh.ncgr",
	"ehd_fow_huv.ncgr",
	"ehd_fow_mu.ncgr",
	"ehd_fow_ou.ncgr",
	"ehd_fow_qc.ncgr",
	"ehd_fow_qu.ncgr",
	"ehd_tbbox_ms00.ncgr",
	"ehd_tbbox_ms01.ncgr",
	"ehd_tbbox_ms02.ncgr",
	"ehd_tbbx2_ms00.ncgr",
	"ehd_tbbx2_ms01.ncgr",
	"ehd_tbbx2_ms02.ncgr",
	"ehd_tftge_ms00.ncgr",
	"ehd_thlth_ms00.ncgr",
	"ehd_tmana_ms00.ncgr",
	"ehd_ylbar_ms00.ncgr",
	"emeralds.gda",
	"ending_movie.gff",
	"endpart1.gda",
	"endpart2.gda",
	"endscreen_bs1.tga",
	"endscreen_bs2.tga",
	"endscreen_ts.tga",
	"enter_twilight.gda",
	"erf.dict",
	"exclamation.tga",
	"exl_altbx_ms00.ncgr",
	"exl_altet_ms00.ncgr",
	"exl_altet_ms10.ncgr",
	"exl_altft_ms00.ncgr",
	"exl_altft_ms10.ncgr",
	"exl_alttp_ms00.ncgr",
	"exl_arwin_of.ncgr",
	"exl_arwin_on.ncgr",
	"exl_arwut_of.ncgr",
	"exl_arwut_on.ncgr",
	"exl_barow_ms00.ncgr",
	"exl_barow_ms01.ncgr",
	"exl_barow_ms10.ncgr",
	"exl_barow_ms11.ncgr",
	"exl_bchao_ms0.ncgr",
	"exl_bchao_ms1.ncgr",
	"exl_bchao_ms2.ncgr",
	"exl_bchao_ms3.ncgr",
	"exl_buttn_ms00.ncgr",
	"exl_buttn_ms01.ncgr",
	"exl_circe_ms00.ncgr",
	"exl_circe_ms10.ncgr",
	"exl_circe_ms11.ncgr",
	"exl_circe_ms12.ncgr",
	"exl_circe_ms20.ncgr",
	"exl_circe_ms21.ncgr",
	"exl_circe_ms30.ncgr",
	"exl_circe_ms31.ncgr",
	"exl_circe_ms32.ncgr",
	"exl_circl_ms00.ncgr",
	"exl_circl_ms10.ncgr",
	"exl_circl_ms11.ncgr",
	"exl_circl_ms12.ncgr",
	"exl_circl_ms20.ncgr",
	"exl_circl_ms21.ncgr",
	"exl_circl_ms30.ncgr",
	"exl_circl_ms31.ncgr",
	"exl_circl_ms32.ncgr",
	"exl_flash_ms0.ncgr",
	"exl_flash_ms1.ncgr",
	"exl_flash_ms2.ncgr",
	"exl_flash_ms3.ncgr",
	"exl_globe_ms0.ncgr",
	"exl_globe_ms1.ncgr",
	"exl_globe_ms2.ncgr",
	"exl_globe_ms3.ncgr",
	"exl_jurnl_ms0.ncgr",
	"exl_jurnl_ms1.ncgr",
	"exl_jurnl_ms2.ncgr",
	"exl_jurnl_ms3.ncgr",
	"exl_lrgbt_hl.nanr",
	"exl_lrgbt_hl.ncer",
	"exl_lrgbt_hl.ncgr",
	"exl_lrgbt_of00.ncgr",
	"exl_lrgbt_on00.ncgr",
	"exl_menub_of00.ncgr",
	"exl_menub_on00.ncgr",
	"exl_menui_ms00.ncgr",
	"exl_menui_ms01.ncgr",
	"exl_menui_ms10.ncgr",
	"exl_menui_ms11.ncgr",
	"exl_qcirc_ms00.ncgr",
	"exl_qcrce_ms00.ncgr",
	"exl_shoes.ncgr",
	"exl_shoes_ms0.ncgr",
	"exl_shoes_ms1.ncgr",
	"exl_shoes_ms2.ncgr",
	"exl_shoes_ms3.ncgr",
	"exl_smbtn_hi00.ncgr",
	"exl_smbtn_hi01.ncgr",
	"exl_smbtn_hi10.ncgr",
	"exl_smbtn_hi11.ncgr",
	"exl_smbtn_of00.ncgr",
	"exl_smbtn_of01.ncgr",
	"exl_smbtn_of10.ncgr",
	"exl_smbtn_of11.ncgr",
	"exl_smbtn_on00.ncgr",
	"exl_smbtn_on01.ncgr",
	"exl_smbtn_on10.ncgr",
	"exl_smbtn_on11.ncgr",
	"exl_sonic_ms0.ncgr",
	"exl_sonic_ms1.ncgr",
	"exl_sonic_ms2.ncgr",
	"exl_sonic_ms3.ncgr",
	"explorehudmenumax.gui",
	"explorehudmenumin.gui",
	"explorehudmenupuzzle.gui",
	"explorehudroot.gui",
	"exploreminimapradar.gui",
	"exploreportraitdisabled.gui",
	"exploreportraitlayout.gui",
	"exp_cct1_mm00.ncgr",
	"exp_cct1_mm01.ncgr",
	"exp_cct1_mm02.ncgr",
	"exp_cct1_mm03.ncgr",
	"exp_cct1_mm10.ncgr",
	"exp_cct1_mm11.ncgr",
	"exp_cct1_mm12.ncgr",
	"exp_cct1_mm13.ncgr",
	"exp_cct1_mm20.ncgr",
	"exp_cct1_mm21.ncgr",
	"exp_cct1_mm22.ncgr",
	"exp_cct1_mm23.ncgr",
	"exp_cct1_mm30.ncgr",
	"exp_cct1_mm31.ncgr",
	"exp_cct1_mm32.ncgr",
	"exp_cct1_mm33.ncgr",
	"exp_charfrm_ns.ncgr",
	"exp_charfrm_s.ncgr",
	"exp_fatiguebar.ncgr",
	"exp_fogofwar.ncgr",
	"exp_ghq1_mm.nclr",
	"exp_ghq1_mm00.ncgr",
	"exp_ghq1_mm01.ncgr",
	"exp_ghq1_mm02.ncgr",
	"exp_ghq1_mm03.ncgr",
	"exp_ghq1_mm10.ncgr",
	"exp_ghq1_mm11.ncgr",
	"exp_ghq1_mm12.ncgr",
	"exp_ghq1_mm13.ncgr",
	"exp_ghq1_mm20.ncgr",
	"exp_ghq1_mm21.ncgr",
	"exp_ghq1_mm22.ncgr",
	"exp_ghq1_mm23.ncgr",
	"exp_ghz1_fw00.ncgr",
	"exp_ghz1_fw01.ncgr",
	"exp_ghz1_fw02.ncgr",
	"exp_ghz1_fw03.ncgr",
	"exp_ghz1_fw10.ncgr",
	"exp_ghz1_fw11.ncgr",
	"exp_ghz1_fw12.ncgr",
	"exp_ghz1_fw13.ncgr",
	"exp_ghz1_fw20.ncgr",
	"exp_ghz1_fw21.ncgr",
	"exp_ghz1_fw22.ncgr",
	"exp_ghz1_fw23.ncgr",
	"exp_ghz1_fw30.ncgr",
	"exp_ghz1_fw31.ncgr",
	"exp_ghz1_fw32.ncgr",
	"exp_ghz1_fw33.ncgr",
	"exp_ghz1_mm.nclr",
	"exp_ghz1_mm00.ncgr",
	"exp_ghz1_mm01.ncgr",
	"exp_ghz1_mm02.ncgr",
	"exp_ghz1_mm03.ncgr",
	"exp_ghz1_mm10.ncgr",
	"exp_ghz1_mm11.ncgr",
	"exp_ghz1_mm12.ncgr",
	"exp_ghz1_mm13.ncgr",
	"exp_ghz1_mm20.ncgr",
	"exp_ghz1_mm21.ncgr",
	"exp_ghz1_mm22.ncgr",
	"exp_ghz1_mm23.ncgr",
	"exp_ghz1_mm30.ncgr",
	"exp_ghz1_mm31.ncgr",
	"exp_ghz1_mm32.ncgr",
	"exp_ghz1_mm33.ncgr",
	"exp_ghz2_mm00.ncgr",
	"exp_ghz2_mm01.ncgr",
	"exp_ghz2_mm02.ncgr",
	"exp_ghz2_mm03.ncgr",
	"exp_ghz2_mm10.ncgr",
	"exp_ghz2_mm11.ncgr",
	"exp_ghz2_mm12.ncgr",
	"exp_ghz2_mm13.ncgr",
	"exp_ghz2_mm20.ncgr",
	"exp_ghz2_mm21.ncgr",
	"exp_ghz2_mm22.ncgr",
	"exp_ghz2_mm23.ncgr",
	"exp_ghz2_mm30.ncgr",
	"exp_ghz2_mm31.ncgr",
	"exp_ghz2_mm32.ncgr",
	"exp_ghz2_mm33.ncgr",
	"exp_healthbar.ncgr",
	"exp_mappin.ncgr",
	"exp_mappinq.ncgr",
	"exp_playerframe.ncgr",
	"exp_playerframe0.ncgr",
	"exp_playerframe1.ncgr",
	"exp_qstcheck.ncgr",
	"exp_qstexclm.ncgr",
	"exp_qststar.ncgr",
	"exp_ringfrm0.ncgr",
	"exp_ringfrm1.ncgr",
	"exp_topframe.ncgr",
	"exp_topframe0.ncgr",
	"exp_topframe1.ncgr",
	"exp_topframe2.ncgr",
	"exp_tws1_mm.nclr",
	"exp_tws1_mm00.ncgr",
	"exp_tws1_mm01.ncgr",
	"exp_tws1_mm02.ncgr",
	"exp_tws1_mm03.ncgr",
	"exp_tws1_mm10.ncgr",
	"exp_tws1_mm11.ncgr",
	"exp_tws1_mm12.ncgr",
	"exp_tws1_mm13.ncgr",
	"exp_tws1_mm20.ncgr",
	"exp_tws1_mm21.ncgr",
	"exp_tws1_mm22.ncgr",
	"exp_tws1_mm23.ncgr",
	"exp_underbar.ncgr",
	"exp_wel1_mm.nclr",
	"exp_wel1_mm00.ncgr",
	"exp_wel1_mm01.ncgr",
	"exp_wel1_mm02.ncgr",
	"exp_wel1_mm03.ncgr",
	"exp_wel1_mm10.ncgr",
	"exp_wel1_mm11.ncgr",
	"exp_wel1_mm12.ncgr",
	"exp_wel1_mm13.ncgr",
	"exp_wel1_mm20.ncgr",
	"exp_wel1_mm21.ncgr",
	"exp_wel1_mm22.ncgr",
	"exp_wel1_mm23.ncgr",
	"exp_xpbar.ncgr",
	"exu_blbar_ms00.ncgr",
	"exu_blbox_ms00.ncgr",
	"exu_circl_hi00.ncgr",
	"exu_tbbox_ms00.ncgr",
	"exu_tbbox_ms10.ncgr",
	"exu_tbbox_ms11.ncgr",
	"exu_tftge_ms00.ncgr",
	"exu_thlth_ms00.ncgr",
	"exu_tmana_ms00.ncgr",
	"exu_ylbar_ms00.ncgr",
	"ex_bloop_left.nsbca",
	"ex_bloop_right.nsbca",
	"e_w.gff",
	"fadeout.gda",
	"fadetest.gda",
	"fatigue.ncgr",
	"flee.ncgr",
	"flee01_bs.tga",
	"flee01_ts.tga",
	"flee02_bs.tga",
	"flee02_ts.tga",
	"flee03_bs.tga",
	"flee04_bs.tga",
	"flee05_bs.tga",
	"fleechapter1.gda",
	"fleeduo.gda",
	"fleeobstacles.gda",
	"fleesolo.gda",
	"fleestandard1.gda",
	"fleestandard2.gda",
	"fleestandard3.gda",
	"fleetrio.gda",
	"fleetut.gda",
	"floaty.nftr",
	"froggy.nsbca",
	"froggy.nsbmd",
	"froggy.nsbtx",
	"front_jurnl_top.gui",
	"front_readingcard.gui",
	"front_selectaslot.gui",
	"front_slotclick.gui",
	"front_slotselected.gui",
	"fullscreenimagepanel64x64.gui",
	"fx_a1_s1_ex_env.nsbmd",
	"fx_a1_s1_ex_env.nsbta",
	"fx_a1_s1_ex_env.nsbtp",
	"fx_a1_s1_ex_env.nsbtx",
	"fx_a1_s1_ex_wtrf.nsbmd",
	"fx_a1_s1_ex_wtrf.nsbta",
	"fx_a1_s1_ex_wtrf.nsbtp",
	"fx_a1_s1_ex_wtrf.nsbtx",
	"fx_a1_s2_ex_env.nsbmd",
	"fx_a1_s2_ex_env.nsbta",
	"fx_a1_s2_ex_env.nsbtp",
	"fx_a1_s2_ex_env.nsbtx",
	"fx_a1_s3_ex_env.nsbmd",
	"fx_a1_s3_ex_env.nsbta",
	"fx_a1_s3_ex_env.nsbtp",
	"fx_a1_s3_ex_env.nsbtx",
	"fx_a1_s4_ex_env.nsbmd",
	"fx_a1_s4_ex_env.nsbtp",
	"fx_a1_s4_ex_env.nsbtx",
	"fx_a1_s4_icb.nsbmd",
	"fx_a1_s4_icb.nsbtx",
	"fx_a1_s4_icb_bob.nsbca",
	"fx_a1_s4_icb_bp.nsbca",
	"fx_a1_s4_ics.nsbmd",
	"fx_a1_s4_ics.nsbtx",
	"fx_a1_s4_ics_bob.nsbca",
	"fx_a1_s4_ics_bp.nsbca",
	"fx_a1_s5_ex_env.nsbmd",
	"fx_a1_s5_ex_env.nsbta",
	"fx_a1_s5_ex_env.nsbtp",
	"fx_a1_s5_ex_env.nsbtx",
	"fx_a1_s6_ex_env.nsbmd",
	"fx_a1_s6_ex_env.nsbta",
	"fx_a1_s6_ex_env.nsbtp",
	"fx_a1_s6_ex_env.nsbtx",
	"fx_a2_s1_ex_env.nsbmd",
	"fx_a2_s1_ex_env.nsbta",
	"fx_a2_s1_ex_env.nsbtp",
	"fx_a2_s1_ex_env.nsbtx",
	"fx_a2_s2_ex_env.nsbmd",
	"fx_a2_s2_ex_env.nsbtx",
	"fx_a2_s3_ex_cld.nsbmd",
	"fx_a2_s3_ex_cld.nsbta",
	"fx_a2_s3_ex_cld.nsbtx",
	"fx_a2_s3_ex_flt.nsbtx",
	"fx_a2_s3_ex_nrg.nsbca",
	"fx_a2_s3_ex_nrg.nsbmd",
	"fx_a2_s3_ex_nrg.nsbta",
	"fx_a2_s3_ex_nrg.nsbtp",
	"fx_a2_s3_ex_nrg.nsbtx",
	"fx_a2_s4_ex_env.nsbmd",
	"fx_a2_s4_ex_env.nsbta",
	"fx_a2_s4_ex_env.nsbtx",
	"fx_a2_s4_ex_ff.nsbmd",
	"fx_a2_s4_ex_ff.nsbta",
	"fx_a2_s4_ex_ff.nsbtx",
	"fx_a2_s5_env.nsbmd",
	"fx_a2_s5_env.nsbta",
	"fx_a2_s5_env.nsbtx",
	"fx_a2_s7_env.nsbmd",
	"fx_a2_s7_env.nsbta",
	"fx_a2_s7_env.nsbtp",
	"fx_a2_s7_env.nsbtx",
	"fx_a2_s7_i03.nsbmd",
	"fx_a2_s7_i03.nsbta",
	"fx_a2_s7_i03.nsbtp",
	"fx_a2_s7_i03.nsbtx",
	"fx_a2_s7_i03_wv.nsbca",
	"fx_amy_whirl.nsbmd",
	"fx_amy_whirl.nsbta",
	"fx_amy_whirl.nsbtx",
	"fx_arm_whirl.nsbmd",
	"fx_arm_whirl.nsbta",
	"fx_arm_whirl.nsbtx",
	"fx_bird.emit",
	"fx_bird.nsbmd",
	"fx_bird.nsbtp",
	"fx_bird.nsbtx",
	"fx_blobshadow.nsbmd",
	"fx_blobshadow.nsbtx",
	"fx_bubbles.emit",
	"fx_bubbles.nsbmd",
	"fx_bubbles.nsbtp",
	"fx_bubbles.nsbtx",
	"fx_cheese_prj.nsbca",
	"fx_cheese_prj.nsbmd",
	"fx_cheese_prj.nsbtx",
	"fx_drn_lzr_beam.nsbmd",
	"fx_drn_lzr_beam.nsbta",
	"fx_drn_lzr_beam.nsbtx",
	"fx_drn_lzr_muz.nsbmd",
	"fx_drn_lzr_muz.nsbta",
	"fx_drn_lzr_muz.nsbtp",
	"fx_drn_lzr_muz.nsbtx",
	"fx_drn_lzr_prj.nsbmd",
	"fx_drn_lzr_prj.nsbta",
	"fx_drn_lzr_prj.nsbtx",
	"fx_dummyobj.nsbmd",
	"fx_dummyobj.nsbtx",
	"fx_dustpuff.nanr",
	"fx_dustpuff.ncer",
	"fx_dustpuff.ncgr",
	"fx_egb_beam.nsbmd",
	"fx_egb_beam.nsbta",
	"fx_egb_beam.nsbtx",
	"fx_egg_wrc_prj.nsbca",
	"fx_egg_wrc_prj.nsbmd",
	"fx_egg_wrc_prj.nsbtx",
	"fx_els_en_aa.nsbmd",
	"fx_els_en_aa.nsbta",
	"fx_els_en_aa.nsbtp",
	"fx_els_en_aa.nsbtx",
	"fx_els_er_aa.nsbmd",
	"fx_els_er_aa.nsbta",
	"fx_els_er_aa.nsbtp",
	"fx_els_er_aa.nsbtx",
	"fx_els_fr_aa.nsbmd",
	"fx_els_fr_aa.nsbta",
	"fx_els_fr_aa.nsbtp",
	"fx_els_fr_aa.nsbtx",
	"fx_els_ic_aa.nsbmd",
	"fx_els_ic_aa.nsbta",
	"fx_els_ic_aa.nsbtx",
	"fx_els_lt_aa.nsbmd",
	"fx_els_lt_aa.nsbta",
	"fx_els_lt_aa.nsbtp",
	"fx_els_lt_aa.nsbtx",
	"fx_els_wn_aa.nsbmd",
	"fx_els_wn_aa.nsbta",
	"fx_els_wn_aa.nsbtp",
	"fx_els_wn_aa.nsbtx",
	"fx_els_wt_aa.nsbmd",
	"fx_els_wt_aa.nsbta",
	"fx_els_wt_aa.nsbtx",
	"fx_exclamation.nsbmd",
	"fx_exclamation.nsbtp",
	"fx_exclamation.nsbtx",
	"fx_flash_layout.ncgr",
	"fx_footprint.nsbmd",
	"fx_footprint.nsbtx",
	"fx_frcfld.nsbmd",
	"fx_frcfld.nsbta",
	"fx_frcfld.nsbtx",
	"fx_gas.emit",
	"fx_gas.nsbmd",
	"fx_gas.nsbtp",
	"fx_gas.nsbtx",
	"fx_giz_lzr_muz.nsbmd",
	"fx_giz_lzr_muz.nsbta",
	"fx_giz_lzr_muz.nsbtp",
	"fx_giz_lzr_muz.nsbtx",
	"fx_giz_lzr_prj.nsbmd",
	"fx_giz_lzr_prj.nsbta",
	"fx_giz_lzr_prj.nsbtx",
	"fx_gnp_beam.nsbmd",
	"fx_gnp_beam.nsbta",
	"fx_gnp_beam.nsbtx",
	"fx_gnp_bullet.nsbmd",
	"fx_gnp_bullet.nsbta",
	"fx_gnp_bullet.nsbtx",
	"fx_gnp_himissile.nsbmd",
	"fx_gnp_himissile.nsbta",
	"fx_gnp_himissile.nsbtx",
	"fx_gnp_mflash.nsbmd",
	"fx_gnp_mflash.nsbta",
	"fx_gnp_mflash.nsbtx",
	"fx_gnp_missile.nsbmd",
	"fx_gnp_missile.nsbta",
	"fx_gnp_missile.nsbtx",
	"fx_greenpuff.nsbmd",
	"fx_greenpuff.nsbtp",
	"fx_greenpuff.nsbtx",
	"fx_gren_noc.nsbmd",
	"fx_gren_noc.nsbtx",
	"fx_gren_rou.nsbmd",
	"fx_gren_rou.nsbtx",
	"fx_gren_sha.nsbmd",
	"fx_gren_sha.nsbtx",
	"fx_gren_tal.nsbmd",
	"fx_gren_tal.nsbtx",
	"fx_gun_scrn.nsbmd",
	"fx_gun_scrn.nsbta",
	"fx_gun_scrn.nsbtp",
	"fx_gun_scrn.nsbtx",
	"fx_gust.emit",
	"fx_gust.nsbmd",
	"fx_gust.nsbtx",
	"fx_impactflash.nanr",
	"fx_impactflash.ncer",
	"fx_impactflash.ncgr",
	"fx_ix_beam.nsbmd",
	"fx_ix_beam.nsbta",
	"fx_ix_beam.nsbtx",
	"fx_ix_beamlg.nsbmd",
	"fx_ix_beamlg.nsbta",
	"fx_ix_beamlg.nsbtx",
	"fx_ix_bhol.nsbmd",
	"fx_ix_bhol.nsbtx",
	"fx_ix_bhol_imp.nsbca",
	"fx_ix_bhol_imp.nsbta",
	"fx_ix_bhol_muz.nsbca",
	"fx_ix_bhol_muz.nsbta",
	"fx_ix_bhol_prj.nsbca",
	"fx_ix_bhol_prj.nsbta",
	"fx_ix_flash.nsbmd",
	"fx_ix_flash.nsbta",
	"fx_ix_flash.nsbtx",
	"fx_ix_orb.nsbmd",
	"fx_ix_orb.nsbta",
	"fx_ix_orb.nsbtx",
	"fx_ix_proj.nsbmd",
	"fx_ix_proj.nsbta",
	"fx_ix_proj.nsbtx",
	"fx_leaf.emit",
	"fx_leaf.nsbmd",
	"fx_leaf.nsbtp",
	"fx_leaf.nsbtx",
	"fx_leafdn.emit",
	"fx_leafdn.nsbmd",
	"fx_leafdn.nsbtp",
	"fx_leafdn.nsbtx",
	"fx_mflash.nsbmd",
	"fx_mflash.nsbtp",
	"fx_mflash.nsbtx",
	"fx_noc_beam.nsbmd",
	"fx_noc_beam.nsbta",
	"fx_noc_beam.nsbtx",
	"fx_noc_jav.nsbmd",
	"fx_noc_jav.nsbtx",
	"fx_noc_jav_muz.nsbta",
	"fx_noc_jav_prj.nsbta",
	"fx_noc_tele.nsbmd",
	"fx_noc_tele.nsbtx",
	"fx_noc_tele_from.nsbta",
	"fx_noc_tele_to.nsbta",
	"fx_ome_beam.nsbmd",
	"fx_ome_beam.nsbta",
	"fx_ome_beam.nsbtx",
	"fx_ome_missile.nsbmd",
	"fx_ome_missile.nsbta",
	"fx_ome_missile.nsbtx",
	"fx_prjpulse.nsbmd",
	"fx_prjpulse.nsbtp",
	"fx_prjpulse.nsbtx",
	"fx_puff_layout.ncgr",
	"fx_shadbeam.nsbmd",
	"fx_shadbeam.nsbta",
	"fx_shadbeam.nsbtx",
	"fx_shadtele.nsbmd",
	"fx_shadtele.nsbtx",
	"fx_shadtelefrom.nsbta",
	"fx_shadteleto.nsbta",
	"fx_shason_atom.nsbca",
	"fx_shason_atom.nsbmd",
	"fx_shason_atom.nsbta",
	"fx_shason_atom.nsbtx",
	"fx_shason_nuke.nsbca",
	"fx_shason_nuke.nsbmd",
	"fx_shason_nuke.nsbta",
	"fx_shason_nuke.nsbtx",
	"fx_sha_jav.nsbmd",
	"fx_sha_jav.nsbtx",
	"fx_sha_jav_muz.nsbta",
	"fx_sha_jav_prj.nsbta",
	"fx_sha_rift.nsbmd",
	"fx_sha_rift.nsbtx",
	"fx_sha_rift_imp.nsbca",
	"fx_sha_rift_imp.nsbta",
	"fx_sha_rift_muz.nsbca",
	"fx_sha_rift_muz.nsbta",
	"fx_sha_rift_prj.nsbca",
	"fx_sha_rift_prj.nsbta",
	"fx_sha_shock.nsbmd",
	"fx_sha_shock.nsbta",
	"fx_sha_shock.nsbtx",
	"fx_she_shkwv.nsbmd",
	"fx_she_shkwv.nsbta",
	"fx_she_shkwv.nsbtx",
	"fx_smokepuff.nsbmd",
	"fx_smokepuff.nsbtp",
	"fx_smokepuff.nsbtx",
	"fx_sonicring.nsbtp",
	"fx_son_shock.nsbmd",
	"fx_son_shock.nsbta",
	"fx_son_shock.nsbtx",
	"fx_son_whirl.nsbca",
	"fx_son_whirl.nsbmd",
	"fx_son_whirl.nsbta",
	"fx_son_whirl.nsbtx",
	"fx_spark.nsbmd",
	"fx_spark.nsbtp",
	"fx_spark.nsbtx",
	"fx_steam.emit",
	"fx_steam.nsbmd",
	"fx_steam.nsbtx",
	"fx_tal_mbot.nsbmd",
	"fx_tal_mbot.nsbta",
	"fx_tal_mbot.nsbtx",
	"fx_tal_sbot.nsbmd",
	"fx_tal_sbot.nsbta",
	"fx_tal_sbot.nsbtx",
	"fx_tal_spn.nsbmd",
	"fx_tal_spn.nsbta",
	"fx_tal_spn.nsbtx",
	"fx_tyx_beam.nsbmd",
	"fx_tyx_beam.nsbta",
	"fx_tyx_beam.nsbtx",
	"fx_tyx_prj.nsbmd",
	"fx_tyx_prj.nsbta",
	"fx_tyx_prj.nsbtx",
	"fx_vox_b_ea_l.nsbmd",
	"fx_vox_b_ea_l.nsbta",
	"fx_vox_b_ea_l.nsbtx",
	"fx_vox_b_ea_m.nsbmd",
	"fx_vox_b_ea_m.nsbta",
	"fx_vox_b_ea_m.nsbtx",
	"fx_vox_b_ea_r.nsbmd",
	"fx_vox_b_ea_r.nsbta",
	"fx_vox_b_ea_r.nsbtx",
	"fx_vox_b_ea_s.nsbmd",
	"fx_vox_b_ea_s.nsbta",
	"fx_vox_b_ea_s.nsbtx",
	"fx_vox_b_es.nsbmd",
	"fx_vox_b_es.nsbta",
	"fx_vox_b_es.nsbtx",
	"fx_vox_g_ea_l.nsbmd",
	"fx_vox_g_ea_l.nsbta",
	"fx_vox_g_ea_l.nsbtx",
	"fx_vox_g_ea_m.nsbmd",
	"fx_vox_g_ea_m.nsbta",
	"fx_vox_g_ea_m.nsbtx",
	"fx_vox_g_ea_r.nsbmd",
	"fx_vox_g_ea_r.nsbta",
	"fx_vox_g_ea_r.nsbtx",
	"fx_vox_g_ea_s.nsbmd",
	"fx_vox_g_ea_s.nsbta",
	"fx_vox_g_ea_s.nsbtx",
	"fx_vox_g_es.nsbmd",
	"fx_vox_g_es.nsbta",
	"fx_vox_g_es.nsbtx",
	"fx_vox_p_ea_l.nsbmd",
	"fx_vox_p_ea_l.nsbta",
	"fx_vox_p_ea_l.nsbtx",
	"fx_vox_p_ea_m.nsbmd",
	"fx_vox_p_ea_m.nsbta",
	"fx_vox_p_ea_m.nsbtx",
	"fx_vox_p_ea_r.nsbmd",
	"fx_vox_p_ea_r.nsbta",
	"fx_vox_p_ea_r.nsbtx",
	"fx_vox_p_ea_s.nsbmd",
	"fx_vox_p_ea_s.nsbta",
	"fx_vox_p_ea_s.nsbtx",
	"fx_vox_p_es.nsbmd",
	"fx_vox_p_es.nsbta",
	"fx_vox_p_es.nsbtx",
	"fx_vox_r_ea_l.nsbmd",
	"fx_vox_r_ea_l.nsbta",
	"fx_vox_r_ea_l.nsbtx",
	"fx_vox_r_ea_m.nsbmd",
	"fx_vox_r_ea_m.nsbta",
	"fx_vox_r_ea_m.nsbtx",
	"fx_vox_r_ea_r.nsbmd",
	"fx_vox_r_ea_r.nsbta",
	"fx_vox_r_ea_r.nsbtx",
	"fx_vox_r_ea_s.nsbmd",
	"fx_vox_r_ea_s.nsbta",
	"fx_vox_r_ea_s.nsbtx",
	"fx_vox_r_es.nsbmd",
	"fx_vox_r_es.nsbta",
	"fx_vox_r_es.nsbtx",
	"fx_vox_y_ea_l.nsbmd",
	"fx_vox_y_ea_l.nsbta",
	"fx_vox_y_ea_l.nsbtx",
	"fx_vox_y_ea_m.nsbmd",
	"fx_vox_y_ea_m.nsbta",
	"fx_vox_y_ea_m.nsbtx",
	"fx_vox_y_ea_r.nsbmd",
	"fx_vox_y_ea_r.nsbta",
	"fx_vox_y_ea_r.nsbtx",
	"fx_vox_y_ea_s.nsbmd",
	"fx_vox_y_ea_s.nsbta",
	"fx_vox_y_ea_s.nsbtx",
	"fx_vox_y_es.nsbmd",
	"fx_vox_y_es.nsbta",
	"fx_vox_y_es.nsbtx",
	"fx_windsock.nsbmd",
	"fx_windsock.nsbtp",
	"fx_windsock.nsbtx",
	"fx_wtrfl_mist.nsbmd",
	"fx_wtrfl_mist.nsbta",
	"fx_wtrfl_mist.nsbtp",
	"fx_wtrfl_mist.nsbtx",
	"fx_wtrfl_splsh.nsbmd",
	"fx_wtrfl_splsh.nsbtp",
	"fx_wtrfl_splsh.nsbtx",
	"fx_wtrfl_sprkl.nsbmd",
	"fx_wtrfl_sprkl.nsbtp",
	"fx_wtrfl_sprkl.nsbtx",
	"fx_wtrfl_strk.nsbmd",
	"fx_wtrfl_strk.nsbta",
	"fx_wtrfl_strk.nsbtx",
	"fx_wtrfl_wtrfl.nsbmd",
	"fx_wtrfl_wtrfl.nsbta",
	"fx_wtrfl_wtrfl.nsbtp",
	"fx_wtrfl_wtrfl.nsbtx",
	"gameattract.gda",
	"genamyn_aa.nsbmd",
	"genamyn_aa.nsbtx",
	"gencrm_aa.nsbmd",
	"gencrm_aa.nsbtx",
	"genknun_aa.nsbmd",
	"genknun_aa.nsbtx",
	"genl_walkmesh.tga",
	"gennpc1b_aa.nsbmd",
	"gennpc1b_aa.nsbtx",
	"gennpc1_aa.nsbmd",
	"gennpc1_aa.nsbtx",
	"gennpc2_aa.nsbmd",
	"gennpc2_aa.nsbtx",
	"gennpc3b_aa.nsbmd",
	"gennpc3b_aa.nsbtx",
	"gennpc3_aa.nsbmd",
	"gennpc3_aa.nsbtx",
	"genroun_aa.nsbmd",
	"genroun_aa.nsbtx",
	"genroun_st.nsbmd",
	"genroun_st.nsbtx",
	"gensha_aa.nsbmd",
	"gensha_aa.nsbtx",
	"gensonn_aa.nsbmd",
	"gensonn_aa.nsbtx",
	"gens_walkmesh.tga",
	"gentain_aa.nsbmd",
	"gentain_aa.nsbtx",
	"gentitle.gui",
	"gen_aa.nsbmd",
	"gen_aa.nsbtx",
	"gen_buttns_of00.ncgr",
	"gen_buttns_on00.ncgr",
	"gen_cb_attack.nsbca",
	"gen_cb_attackend.nsbca",
	"gen_cb_damage.nsbca",
	"gen_cb_idle.nsbca",
	"gen_cb_pattack.nsbca",
	"gen_ex_run.nsbca",
	"gen_ex_walk.nsbca",
	"gen_titlebar_00.ncgr",
	"gen_titlebar_01.ncgr",
	"ghq1_minimap.nclr",
	"ghz1_fowmap.nclr",
	"ghz1_minimap.nclr",
	"ghz2_minimap.nclr",
	"ghz_ccz.gff",
	"ghz_demo.are",
	"ghz_hintguy.dlg",
	"gnp_aa.nsbmd",
	"gnp_aa.nsbtx",
	"gnp_cb_attack.nsbca",
	"gnp_cb_attackend.nsbca",
	"gnp_cb_counter.nsbca",
	"gnp_cb_damage.nsbca",
	"gnp_cb_dead.nsbca",
	"gnp_cb_getup.nsbca",
	"gnp_cb_idle.nsbca",
	"gnp_cb_kd.nsbca",
	"gnp_cb_pattack01.nsbca",
	"gnp_cb_pattack02.nsbca",
	"gnp_ex_damage.nsbca",
	"gnp_ex_fall.nsbca",
	"gnp_ex_idle.nsbca",
	"gnp_ex_jump.nsbca",
	"gnp_ex_run.nsbca",
	"gnp_ex_walk.nsbca",
	"gtest.are",
	"guianims.gda",
	"guianim_cha.gda",
	"guianim_com.gda",
	"guianim_con.gda",
	"guianim_exp.gda",
	"guianim_inv.gda",
	"guianim_jrl.gda",
	"guianim_linear.gda",
	"guianim_lvl.gda",
	"guianim_pro.gda",
	"guianim_rew.gda",
	"guianim_sha.gda",
	"guianim_slo.gda",
	"guianim_sto.gda",
	"guianim_switch.gda",
	"guianim_wmp.gda",
	"guiframeelements.nclr",
	"guis.gda",
	"gui_buttons.nclr",
	"gui_buttonsgrey.nclr",
	"gui_chaogard.nclr",
	"gui_chaogardts.nclr",
	"gui_chao_a.nclr",
	"gui_chao_f.nclr",
	"gui_chao_g.nclr",
	"gui_chao_h.nclr",
	"gui_chao_i.nclr",
	"gui_chao_j1.nclr",
	"gui_chao_j2.nclr",
	"gui_chao_j3.nclr",
	"gui_chao_j4.nclr",
	"gui_charpro.nclr",
	"gui_charprofile.nclr",
	"gui_combat.nclr",
	"gui_combat2.nclr",
	"gui_combatelem.nclr",
	"gui_combatloc.nclr",
	"gui_combatmenu.nclr",
	"gui_combatmenugrey.nclr",
	"gui_combatport.nclr",
	"gui_conv_arrows.nclr",
	"gui_conv_portraits.nclr",
	"gui_defeatscreen.nclr",
	"gui_explore.nclr",
	"gui_explorea.nclr",
	"gui_exploreagr.nclr",
	"gui_explorealtgr.nclr",
	"gui_exploreb.nclr",
	"gui_explorec.nclr",
	"gui_fleetext.nclr",
	"gui_fow.nclr",
	"gui_icons.nclr",
	"gui_iconsdkgrey.nclr",
	"gui_iconsgrey.nclr",
	"gui_inventory.nclr",
	"gui_items_accessories.nclr",
	"gui_items_accessories2.nclr",
	"gui_items_accessories3.nclr",
	"gui_items_accessories4.nclr",
	"gui_items_chaoegg.nclr",
	"gui_items_chsemerald.nclr",
	"gui_items_gloves.nclr",
	"gui_itm_fot.nclr",
	"gui_jrnl.nclr",
	"gui_jurnl.nclr",
	"gui_levelup.nclr",
	"gui_levelup2.nclr",
	"gui_main_icodk.nclr",
	"gui_main_icon.nclr",
	"gui_main_pnl.nclr",
	"gui_man.nclr",
	"gui_popupbox.nclr",
	"gui_portraits01.nclr",
	"gui_portraits02.nclr",
	"gui_portraits03.nclr",
	"gui_portraits06.nclr",
	"gui_portraits07.nclr",
	"gui_portraits08.nclr",
	"gui_portraits09.nclr",
	"gui_portraitsouthouse.nclr",
	"gui_portraitssal.nclr",
	"gui_portraitsskp.nclr",
	"gui_portraitstal.nclr",
	"gui_profile.nclr",
	"gui_rewardbox.nclr",
	"gui_ssf.nclr",
	"gui_stronghold.nclr",
	"gui_tutorial_in_1bs.tga",
	"gui_tutorial_in_bs.tga",
	"gui_tutorial_out_bs.tga",
	"gui_tutorial_ts.tga",
	"gui_tutorial_ts_2.tga",
	"gui_victory.nclr",
	"gui_worldmap.nclr",
	"gup_aa.nsbmd",
	"gup_aa.nsbtx",
	"gup_aa_shid.nsbta",
	"gup_aa_shin.nsbta",
	"gup_aa_shno.nsbta",
	"gup_aa_shot.nsbta",
	"gup_cb_counter.nsbca",
	"gup_cb_damage.nsbca",
	"gup_cb_dead.nsbca",
	"gup_cb_getup.nsbca",
	"gup_cb_idle.nsbca",
	"gup_cb_kd.nsbca",
	"gup_cb_pattack01.nsbca",
	"gup_cb_shieldd.nsbca",
	"gup_cb_shieldidl.nsbca",
	"gup_cb_shieldin.nsbca",
	"gup_cb_shieldout.nsbca",
	"gup_ex_damage.nsbca",
	"gup_ex_fall.nsbca",
	"gup_ex_idle.nsbca",
	"gup_ex_jump.nsbca",
	"gup_ex_run.nsbca",
	"gup_ex_walk.nsbca",
	"gwr_aa.nsbmd",
	"gwr_aa.nsbtx",
	"gwr_cb_attack.nsbca",
	"gwr_cb_attackc.nsbca",
	"gwr_cb_attackend.nsbca",
	"gwr_cb_counter.nsbca",
	"gwr_cb_damage.nsbca",
	"gwr_cb_dead.nsbca",
	"gwr_cb_getup.nsbca",
	"gwr_cb_idle.nsbca",
	"gwr_cb_kd.nsbca",
	"gwr_cb_pattack01.nsbca",
	"gwr_cb_pattack02.nsbca",
	"gwr_ex_enter.nsbca",
	"gwr_ex_idle.nsbca",
	"gwr_ex_off.nsbca",
	"gwr_ex_run.nsbca",
	"gwr_ex_walk.nsbca",
	"gwr_hf.nsbmd",
	"gwr_hf.nsbtx",
	"gwr_lt.nsbta",
	"gzc_aa.nsbmd",
	"gzc_aa.nsbtx",
	"gzc_cb_attack.nsbca",
	"gzc_cb_attackend.nsbca",
	"gzc_cb_counter.nsbca",
	"gzc_cb_damage.nsbca",
	"gzc_cb_dead.nsbca",
	"gzc_cb_getup.nsbca",
	"gzc_cb_idle.nsbca",
	"gzc_cb_kd.nsbca",
	"gzc_cb_pattack.nsbca",
	"gzc_ex_idle.nsbca",
	"gzc_ex_run.nsbca",
	"gzc_ex_walk.nsbca",
	"gzd_aa.nsbmd",
	"gzd_aa.nsbtx",
	"gzd_cb_attack.nsbca",
	"gzd_cb_attackc.nsbca",
	"gzd_cb_attackend.nsbca",
	"gzd_cb_counter.nsbca",
	"gzd_cb_damage.nsbca",
	"gzd_cb_dead.nsbca",
	"gzd_cb_getup.nsbca",
	"gzd_cb_idle.nsbca",
	"gzd_cb_kd.nsbca",
	"gzd_ex_idle.nsbca",
	"gzd_ex_run.nsbca",
	"gzd_ex_walk.nsbca",
	"gzg_aa.nsbmd",
	"gzg_aa.nsbtx",
	"gzg_cb_attack.nsbca",
	"gzg_cb_attackc.nsbca",
	"gzg_cb_attackend.nsbca",
	"gzg_cb_counter.nsbca",
	"gzg_cb_damage.nsbca",
	"gzg_cb_dead.nsbca",
	"gzg_cb_getup.nsbca",
	"gzg_cb_idle.nsbca",
	"gzg_cb_kd.nsbca",
	"gzg_cb_pattack.nsbca",
	"gzg_ex_idle.nsbca",
	"gzg_ex_run.nsbca",
	"gzg_ex_walk.nsbca",
	"gzs_aa.nsbmd",
	"gzs_aa.nsbtx",
	"gzs_cb_pattack.nsbca",
	"health.ncgr",
	"health.tga",
	"healthbar.tga",
	"hnpc_bcap_aa.nsbmd",
	"hnpc_bcap_aa.nsbtx",
	"hnpc_bcap_idle.nsbca",
	"hnpc_bcap_twit.nsbca",
	"hnpc_con_aa.nsbmd",
	"hnpc_con_aa.nsbtx",
	"hnpc_cop_aa.nsbmd",
	"hnpc_cop_aa.nsbtx",
	"hnpc_cop_idle.nsbca",
	"hnpc_for_aa.nsbmd",
	"hnpc_for_aa.nsbtx",
	"hnpc_gen_idle.nsbca",
	"hnpc_gen_walk.nsbca",
	"hnpc_gunco_aa.nsbmd",
	"hnpc_gunco_aa.nsbtx",
	"hnpc_gunof_aa.nsbmd",
	"hnpc_gunof_aa.nsbtx",
	"hnpc_kid_aa.nsbmd",
	"hnpc_kid_aa.nsbtx",
	"hnpc_kid_idle.nsbca",
	"hnpc_kid_walk.nsbca",
	"hnpc_mug_aa.nsbmd",
	"hnpc_mug_aa.nsbtx",
	"hnpc_mug_idle.nsbca",
	"hnpc_mug_walk.nsbca",
	"hnpc_sci_aa.nsbmd",
	"hnpc_sci_aa.nsbtx",
	"hnpc_sci_idle.nsbca",
	"hnpc_tdad_aa.nsbmd",
	"hnpc_tdad_aa.nsbtx",
	"hnpc_tim_aa.nsbmd",
	"hnpc_tim_aa.nsbtx",
	"hnpc_wdmn_aa.nsbmd",
	"hnpc_wdmn_aa.nsbtx",
	"hnpc_wdmn_idle.nsbca",
	"howtoinventory.gda",
	"howtojournal.gda",
	"howtosave.gda",
	"hud_lvlnum0.ncgr",
	"hud_lvlnum1.ncgr",
	"hud_lvlnum2.ncgr",
	"hud_lvlnum3.ncgr",
	"hud_lvlnum4.ncgr",
	"hud_lvlnum5.ncgr",
	"hud_lvlnum6.ncgr",
	"hud_lvlnum7.ncgr",
	"hud_lvlnum8.ncgr",
	"hud_lvlnum9.ncgr",
	"icn_l_automatic.ncgr",
	"icn_l_barwof.ncgr",
	"icn_l_barwofcho.ncgr",
	"icn_l_barwofjrl.ncgr",
	"icn_l_barwoflvl.ncgr",
	"icn_l_barwofprf.ncgr",
	"icn_l_barwofrwd.ncgr",
	"icn_l_barwofstr.ncgr",
	"icn_l_barwon.ncgr",
	"icn_l_barwoncho.ncgr",
	"icn_l_barwonjrl.ncgr",
	"icn_l_barwonlvl.ncgr",
	"icn_l_barwonprf.ncgr",
	"icn_l_barwonrwd.ncgr",
	"icn_l_barwonstr.ncgr",
	"icn_l_baseatk.ncgr",
	"icn_l_bugspray.ncgr",
	"icn_l_catk_at.ncgr",
	"icn_l_catk_ka.ncgr",
	"icn_l_catk_kat.ncgr",
	"icn_l_catk_kt.ncgr",
	"icn_l_catk_sa.ncgr",
	"icn_l_catk_sak.ncgr",
	"icn_l_catk_sat.ncgr",
	"icn_l_catk_sk.ncgr",
	"icn_l_catk_st.ncgr",
	"icn_l_catk_stk.ncgr",
	"icn_l_chkjrl.ncgr",
	"icn_l_comboatk.ncgr",
	"icn_l_defend.ncgr",
	"icn_l_flee.ncgr",
	"icn_l_larwofjrl.ncgr",
	"icn_l_larwofstr.ncgr",
	"icn_l_larwonjrl.ncgr",
	"icn_l_larwonstr.ncgr",
	"icn_l_manual.ncgr",
	"icn_l_medkit.ncgr",
	"icn_l_mm_airport.ncgr",
	"icn_l_mm_cyclone.ncgr",
	"icn_l_mm_tornado.ncgr",
	"icn_l_onbash1.ncgr",
	"icn_l_onbash2.ncgr",
	"icn_l_onbash3.ncgr",
	"icn_l_onclimb.ncgr",
	"icn_l_ondash1.ncgr",
	"icn_l_ondash2.ncgr",
	"icn_l_ondash3.ncgr",
	"icn_l_ondoor.ncgr",
	"icn_l_onfly1.ncgr",
	"icn_l_onfly2.ncgr",
	"icn_l_onfly3.ncgr",
	"icn_l_ongen.ncgr",
	"icn_l_oninv1.ncgr",
	"icn_l_oninv2.ncgr",
	"icn_l_oninv3.ncgr",
	"icn_l_onjump.ncgr",
	"icn_l_ontalk.ncgr",
	"icn_l_onteleport.ncgr",
	"icn_l_patkamy.ncgr",
	"icn_l_patkknu.ncgr",
	"icn_l_patkson.ncgr",
	"icn_l_patktai.ncgr",
	"icn_l_rarwofjrl.ncgr",
	"icn_l_rarwofstr.ncgr",
	"icn_l_rarwonjrl.ncgr",
	"icn_l_rarwonstr.ncgr",
	"icn_l_replay.ncgr",
	"icn_l_select.ncgr",
	"icn_l_snglatk.ncgr",
	"icn_l_useitem.ncgr",
	"icn_l_utbash1.ncgr",
	"icn_l_utbash2.ncgr",
	"icn_l_utbash3.ncgr",
	"icn_l_utclimb.ncgr",
	"icn_l_utdash1.ncgr",
	"icn_l_utdash2.ncgr",
	"icn_l_utdash3.ncgr",
	"icn_l_utdoor.ncgr",
	"icn_l_utfly1.ncgr",
	"icn_l_utfly2.ncgr",
	"icn_l_utfly3.ncgr",
	"icn_l_utgen.ncgr",
	"icn_l_utinv1.ncgr",
	"icn_l_utinv2.ncgr",
	"icn_l_utinv3.ncgr",
	"icn_l_utjump.ncgr",
	"icn_l_utstlth.ncgr",
	"icn_l_uttalk.ncgr",
	"icn_l_utteleport.ncgr",
	"icn_l_victory0.ncgr",
	"icn_l_victory1.ncgr",
	"icn_l_victory2.ncgr",
	"icn_l_victory3.ncgr",
	"icn_l_wmp_airport.ncgr",
	"icn_l_wmp_airport.nclr",
	"icn_l_wmp_cyclone.ncgr",
	"icn_l_wmp_cyclone.nclr",
	"icn_l_wmp_tornado.ncgr",
	"icn_l_wmp_tornado.nclr",
	"icn_s_automatic.ncgr",
	"icn_s_baseatk.ncgr",
	"icn_s_bash1.ncgr",
	"icn_s_bash2.ncgr",
	"icn_s_bash3.ncgr",
	"icn_s_bugspray.ncgr",
	"icn_s_catk_at.ncgr",
	"icn_s_catk_ca.ncgr",
	"icn_s_catk_cab.ncgr",
	"icn_s_catk_et.ncgr",
	"icn_s_catk_hk.ncgr",
	"icn_s_catk_hs.ncgr",
	"icn_s_catk_ka.ncgr",
	"icn_s_catk_kat.ncgr",
	"icn_s_catk_ks.ncgr",
	"icn_s_catk_ksa.ncgr",
	"icn_s_catk_kt.ncgr",
	"icn_s_catk_kw.ncgr",
	"icn_s_catk_kwh.ncgr",
	"icn_s_catk_ob.ncgr",
	"icn_s_catk_or.ncgr",
	"icn_s_catk_rk.ncgr",
	"icn_s_catk_sa.ncgr",
	"icn_s_catk_sak.ncgr",
	"icn_s_catk_sat.ncgr",
	"icn_s_catk_sk.ncgr",
	"icn_s_catk_skt.ncgr",
	"icn_s_catk_skta.ncgr",
	"icn_s_catk_st.ncgr",
	"icn_s_catk_stk.ncgr",
	"icn_s_catk_wo.ncgr",
	"icn_s_catk_wro.ncgr",
	"icn_s_catk_ws.ncgr",
	"icn_s_chaocho.ncgr",
	"icn_s_chkstr.ncgr",
	"icn_s_climb.ncgr",
	"icn_s_comboatk.ncgr",
	"icn_s_dash1.ncgr",
	"icn_s_dash2.ncgr",
	"icn_s_dash3.ncgr",
	"icn_s_defend.ncgr",
	"icn_s_ds.ncgr",
	"icn_s_flee.ncgr",
	"icn_s_fly1.ncgr",
	"icn_s_fly2.ncgr",
	"icn_s_fly3.ncgr",
	"icn_s_grnchcho.ncgr",
	"icn_s_gstarwmp.ncgr",
	"icn_s_inv1.ncgr",
	"icn_s_inv2.ncgr",
	"icn_s_inv3.ncgr",
	"icn_s_jump.ncgr",
	"icn_s_larwoflvl.ncgr",
	"icn_s_larwonlvl.ncgr",
	"icn_s_manual.ncgr",
	"icn_s_medkit.ncgr",
	"icn_s_mm_airport.ncgr",
	"icn_s_mm_cyclone.ncgr",
	"icn_s_mm_store.ncgr",
	"icn_s_mm_tornado.ncgr",
	"icn_s_moonwmp.ncgr",
	"icn_s_patkamy.ncgr",
	"icn_s_patkknu.ncgr",
	"icn_s_patkson.ncgr",
	"icn_s_patktai.ncgr",
	"icn_s_patk_amy1.ncgr",
	"icn_s_patk_amy2.ncgr",
	"icn_s_patk_amy3.ncgr",
	"icn_s_patk_amy4.ncgr",
	"icn_s_patk_big1.ncgr",
	"icn_s_patk_big2.ncgr",
	"icn_s_patk_big3.ncgr",
	"icn_s_patk_big4.ncgr",
	"icn_s_patk_big5.ncgr",
	"icn_s_patk_big6.ncgr",
	"icn_s_patk_cre1.ncgr",
	"icn_s_patk_cre2.ncgr",
	"icn_s_patk_cre3.ncgr",
	"icn_s_patk_cre4.ncgr",
	"icn_s_patk_cre5.ncgr",
	"icn_s_patk_cre6.ncgr",
	"icn_s_patk_egg1.ncgr",
	"icn_s_patk_knu1.ncgr",
	"icn_s_patk_knu2.ncgr",
	"icn_s_patk_ome1.ncgr",
	"icn_s_patk_ome2.ncgr",
	"icn_s_patk_ome3.ncgr",
	"icn_s_patk_ome4.ncgr",
	"icn_s_patk_rou1.ncgr",
	"icn_s_patk_rou2.ncgr",
	"icn_s_patk_rou3.ncgr",
	"icn_s_patk_rou4.ncgr",
	"icn_s_patk_rou5.ncgr",
	"icn_s_patk_sha1.ncgr",
	"icn_s_patk_sha2.ncgr",
	"icn_s_patk_sha3.ncgr",
	"icn_s_patk_she1.ncgr",
	"icn_s_patk_she2.ncgr",
	"icn_s_patk_son1.ncgr",
	"icn_s_patk_son2.ncgr",
	"icn_s_patk_tai1.ncgr",
	"icn_s_patk_tai2.ncgr",
	"icn_s_patk_tai3.ncgr",
	"icn_s_patk_tai4.ncgr",
	"icn_s_patk_tai5.ncgr",
	"icn_s_patk_tai6.ncgr",
	"icn_s_rarwoflvl.ncgr",
	"icn_s_rarwonlvl.ncgr",
	"icn_s_rbtnwmp.ncgr",
	"icn_s_redxcho.ncgr",
	"icn_s_replay.ncgr",
	"icn_s_select.ncgr",
	"icn_s_shipwmp.ncgr",
	"icn_s_snglatk.ncgr",
	"icn_s_statbs.ncgr",
	"icn_s_statcur.ncgr",
	"icn_s_statdis.ncgr",
	"icn_s_statdt.ncgr",
	"icn_s_statemp.ncgr",
	"icn_s_statfoc.ncgr",
	"icn_s_statfor.ncgr",
	"icn_s_stathyp.ncgr",
	"icn_s_statluc.ncgr",
	"icn_s_statpoi.ncgr",
	"icn_s_statsc.ncgr",
	"icn_s_statslu.ncgr",
	"icn_s_statstu.ncgr",
	"icn_s_statvul.ncgr",
	"icn_s_statwea.ncgr",
	"icn_s_stealth.ncgr",
	"icn_s_str_chao.ncgr",
	"icn_s_str_char.ncgr",
	"icn_s_str_equip.ncgr",
	"icn_s_str_move.ncgr",
	"icn_s_str_tech.ncgr",
	"icn_s_taphrexl.ncgr",
	"icn_s_taphrmin.ncgr",
	"icn_s_teleport.ncgr",
	"icn_s_useitem.ncgr",
	"icn_s_wsl0bcho.ncgr",
	"icn_s_wsl0wcho.ncgr",
	"icn_s_wsl1bcho.ncgr",
	"icn_s_wsl1wcho.ncgr",
	"icn_s_wsl2bcho.ncgr",
	"icn_s_wsl2wcho.ncgr",
	"icn_s_wsl3bcho.ncgr",
	"icn_s_wsl3wcho.ncgr",
	"infoframe_c.ncgr",
	"infoframe_l.ncgr",
	"infoframe_r.ncgr",
	"introbridge.gda",
	"intromovies.gda",
	"intro_rainforest.gda",
	"int_drone.spl",
	"inventorycharactertab.gui",
	"inventorydatabackground.gui",
	"inventoryequipmentdata.gui",
	"inventorygui_bs_01.tga",
	"inventorygui_bs_02.tga",
	"inventorygui_ts_01.tga",
	"inventorylist.gui",
	"inventorylistbackground.gui",
	"inventorylowerbuttons.gui",
	"inventorymaintab.gui",
	"inventory_ts.gui",
	"invent_bar00.ncgr",
	"invent_bar01.ncgr",
	"invent_bar02.ncgr",
	"invent_bar03.ncgr",
	"invent_barlit00.ncgr",
	"invent_barlit01.ncgr",
	"invent_barlit02.ncgr",
	"invent_barlit03.ncgr",
	"invent_icon_ass.ncgr",
	"invent_icon_att.ncgr",
	"invent_icon_boo.ncgr",
	"invent_icon_cho.ncgr",
	"invent_icon_dow.ncgr",
	"invent_icon_eml.ncgr",
	"invent_icon_glv.ncgr",
	"invent_icon_rev.ncgr",
	"invent_icon_sta.ncgr",
	"invent_icon_up.ncgr",
	"invent_list00.ncgr",
	"invent_list01.ncgr",
	"invent_list02.ncgr",
	"invent_list10.ncgr",
	"invent_list11.ncgr",
	"invent_list12.ncgr",
	"invent_prt_blank.ncgr",
	"invent_scroll_00.ncgr",
	"invent_scroll_01.ncgr",
	"invent_scroll_02.ncgr",
	"invent_scroll_03.ncgr",
	"invent_stat00.ncgr",
	"invent_stat10.ncgr",
	"invent_stat_tab1.ncgr",
	"invent_stat_tab2.ncgr",
	"invent_stat_tab3.ncgr",
	"invent_stat_tab4.ncgr",
	"invent_stat_tablit1.ncgr",
	"invent_stat_tablit2.ncgr",
	"invent_stat_tablit3.ncgr",
	"invent_stat_tablit4.ncgr",
	"invent_title00.ncgr",
	"invent_title01.ncgr",
	"invent_titlelit00.ncgr",
	"invent_titlelit01.ncgr",
	"invent_ts_panel.nbfp",
	"invent_ts_panel.nbfs",
	"invent_ts_panel.tga",
	"inv_blank_8x8.ncgr",
	"item1.itm",
	"item10.itm",
	"item100.itm",
	"item101.itm",
	"item102.itm",
	"item103.itm",
	"item104.itm",
	"item105.itm",
	"item106.itm",
	"item107.itm",
	"item108.itm",
	"item109.itm",
	"item11.itm",
	"item110.itm",
	"item111.itm",
	"item112.itm",
	"item113.itm",
	"item114.itm",
	"item115.itm",
	"item116.itm",
	"item117.itm",
	"item118.itm",
	"item119.itm",
	"item12.itm",
	"item120.itm",
	"item121.itm",
	"item122.itm",
	"item123.itm",
	"item124.itm",
	"item125.itm",
	"item126.itm",
	"item127.itm",
	"item128.itm",
	"item129.itm",
	"item13.itm",
	"item130.itm",
	"item131.itm",
	"item132.itm",
	"item133.itm",
	"item134.itm",
	"item135.itm",
	"item136.itm",
	"item137.itm",
	"item138.itm",
	"item139.itm",
	"item14.itm",
	"item140.itm",
	"item141.itm",
	"item142.itm",
	"item143.itm",
	"item144.itm",
	"item145.itm",
	"item146.itm",
	"item147.itm",
	"item148.itm",
	"item149.itm",
	"item15.itm",
	"item150.itm",
	"item151.itm",
	"item152.itm",
	"item153.itm",
	"item154.itm",
	"item155.itm",
	"item156.itm",
	"item157.itm",
	"item158.itm",
	"item159.itm",
	"item16.itm",
	"item160.itm",
	"item161.itm",
	"item162.itm",
	"item163.itm",
	"item164.itm",
	"item165.itm",
	"item166.itm",
	"item167.itm",
	"item168.itm",
	"item169.itm",
	"item17.itm",
	"item170.itm",
	"item171.itm",
	"item172.itm",
	"item173.itm",
	"item174.itm",
	"item175.itm",
	"item176.itm",
	"item177.itm",
	"item178.itm",
	"item179.itm",
	"item18.itm",
	"item180.itm",
	"item181.itm",
	"item182.itm",
	"item183.itm",
	"item184.itm",
	"item185.itm",
	"item186.itm",
	"item187.itm",
	"item188.itm",
	"item189.itm",
	"item19.itm",
	"item190.itm",
	"item191.itm",
	"item192.itm",
	"item193.itm",
	"item194.itm",
	"item195.itm",
	"item196.itm",
	"item197.itm",
	"item198.itm",
	"item199.itm",
	"item2.itm",
	"item20.itm",
	"item200.itm",
	"item201.itm",
	"item202.itm",
	"item203.itm",
	"item204.itm",
	"item205.itm",
	"item206.itm",
	"item207.itm",
	"item208.itm",
	"item209.itm",
	"item21.itm",
	"item210.itm",
	"item211.itm",
	"item212.itm",
	"item213.itm",
	"item214.itm",
	"item215.itm",
	"item216.itm",
	"item217.itm",
	"item218.itm",
	"item219.itm",
	"item22.itm",
	"item23.itm",
	"item24.itm",
	"item25.itm",
	"item26.itm",
	"item27.itm",
	"item28.itm",
	"item29.itm",
	"item3.itm",
	"item30.itm",
	"item31.itm",
	"item32.itm",
	"item33.itm",
	"item34.itm",
	"item35.itm",
	"item36.itm",
	"item37.itm",
	"item38.itm",
	"item39.itm",
	"item4.itm",
	"item40.itm",
	"item41.itm",
	"item42.itm",
	"item43.itm",
	"item44.itm",
	"item45.itm",
	"item46.itm",
	"item47.itm",
	"item48.itm",
	"item49.itm",
	"item5.itm",
	"item50.itm",
	"item51.itm",
	"item52.itm",
	"item53.itm",
	"item54.itm",
	"item55.itm",
	"item56.itm",
	"item57.itm",
	"item58.itm",
	"item59.itm",
	"item6.itm",
	"item60.itm",
	"item61.itm",
	"item62.itm",
	"item63.itm",
	"item64.itm",
	"item65.itm",
	"item66.itm",
	"item67.itm",
	"item68.itm",
	"item69.itm",
	"item7.itm",
	"item70.itm",
	"item71.itm",
	"item72.itm",
	"item73.itm",
	"item74.itm",
	"item75.itm",
	"item76.itm",
	"item77.itm",
	"item78.itm",
	"item79.itm",
	"item8.itm",
	"item80.itm",
	"item81.itm",
	"item82.itm",
	"item83.itm",
	"item84.itm",
	"item85.itm",
	"item86.itm",
	"item87.itm",
	"item88.itm",
	"item89.itm",
	"item9.itm",
	"item90.itm",
	"item91.itm",
	"item92.itm",
	"item93.itm",
	"item94.itm",
	"item95.itm",
	"item96.itm",
	"item97.itm",
	"item98.itm",
	"item99.itm",
	"items.gda",
	"itm_accangam_0.ncgr",
	"itm_accangam_1.ncgr",
	"itm_accangam_2.ncgr",
	"itm_accangam_3.ncgr",
	"itm_accearng_0.ncgr",
	"itm_accearng_1.ncgr",
	"itm_accearng_2.ncgr",
	"itm_accearng_3.ncgr",
	"itm_accnewsp_0.ncgr",
	"itm_accnewsp_1.ncgr",
	"itm_accnewsp_2.ncgr",
	"itm_accnewsp_3.ncgr",
	"itm_accrfrsh_0.ncgr",
	"itm_accrfrsh_1.ncgr",
	"itm_accrfrsh_2.ncgr",
	"itm_accrfrsh_3.ncgr",
	"itm_accspkam_0.ncgr",
	"itm_accspkam_1.ncgr",
	"itm_accspkam_2.ncgr",
	"itm_accspkam_3.ncgr",
	"itm_accwnrng_0.ncgr",
	"itm_accwnrng_1.ncgr",
	"itm_accwnrng_2.ncgr",
	"itm_accwnrng_3.ncgr",
	"itm_accwtrng_0.ncgr",
	"itm_accwtrng_1.ncgr",
	"itm_accwtrng_2.ncgr",
	"itm_accwtrng_3.ncgr",
	"itm_ace_antid_0.ncgr",
	"itm_ace_antid_1.ncgr",
	"itm_ace_antid_2.ncgr",
	"itm_ace_antid_3.ncgr",
	"itm_ace_beaca_0.ncgr",
	"itm_ace_beaca_1.ncgr",
	"itm_ace_beaca_2.ncgr",
	"itm_ace_beaca_3.ncgr",
	"itm_ace_boy_0.ncgr",
	"itm_ace_boy_1.ncgr",
	"itm_ace_boy_2.ncgr",
	"itm_ace_boy_3.ncgr",
	"itm_ace_bugsp_0.ncgr",
	"itm_ace_bugsp_1.ncgr",
	"itm_ace_bugsp_2.ncgr",
	"itm_ace_bugsp_3.ncgr",
	"itm_ace_candy_0.ncgr",
	"itm_ace_candy_1.ncgr",
	"itm_ace_candy_2.ncgr",
	"itm_ace_candy_3.ncgr",
	"itm_ace_clovej_0.ncgr",
	"itm_ace_clovej_1.ncgr",
	"itm_ace_clovej_2.ncgr",
	"itm_ace_clovej_3.ncgr",
	"itm_ace_commu_0.ncgr",
	"itm_ace_commu_1.ncgr",
	"itm_ace_commu_2.ncgr",
	"itm_ace_commu_3.ncgr",
	"itm_ace_crzbn_0.ncgr",
	"itm_ace_crzbn_1.ncgr",
	"itm_ace_crzbn_2.ncgr",
	"itm_ace_crzbn_3.ncgr",
	"itm_ace_cural_0.ncgr",
	"itm_ace_cural_1.ncgr",
	"itm_ace_cural_2.ncgr",
	"itm_ace_cural_3.ncgr",
	"itm_ace_delux_0.ncgr",
	"itm_ace_delux_1.ncgr",
	"itm_ace_delux_2.ncgr",
	"itm_ace_delux_3.ncgr",
	"itm_ace_dimbu_0.ncgr",
	"itm_ace_dimbu_1.ncgr",
	"itm_ace_dimbu_2.ncgr",
	"itm_ace_dimbu_3.ncgr",
	"itm_ace_drink_0.ncgr",
	"itm_ace_drink_1.ncgr",
	"itm_ace_drink_2.ncgr",
	"itm_ace_drink_3.ncgr",
	"itm_ace_echid_0.ncgr",
	"itm_ace_echid_1.ncgr",
	"itm_ace_echid_2.ncgr",
	"itm_ace_echid_3.ncgr",
	"itm_ace_eggmd_0.ncgr",
	"itm_ace_eggmd_1.ncgr",
	"itm_ace_eggmd_2.ncgr",
	"itm_ace_eggmd_3.ncgr",
	"itm_ace_fire_0.ncgr",
	"itm_ace_fire_1.ncgr",
	"itm_ace_fire_2.ncgr",
	"itm_ace_fire_3.ncgr",
	"itm_ace_fragm_0.ncgr",
	"itm_ace_fragm_1.ncgr",
	"itm_ace_fragm_2.ncgr",
	"itm_ace_fragm_3.ncgr",
	"itm_ace_goggl_0.ncgr",
	"itm_ace_goggl_1.ncgr",
	"itm_ace_goggl_2.ncgr",
	"itm_ace_goggl_3.ncgr",
	"itm_ace_goldr_0.ncgr",
	"itm_ace_goldr_1.ncgr",
	"itm_ace_goldr_2.ncgr",
	"itm_ace_goldr_3.ncgr",
	"itm_ace_grapp_0.ncgr",
	"itm_ace_grapp_1.ncgr",
	"itm_ace_grapp_2.ncgr",
	"itm_ace_grapp_3.ncgr",
	"itm_ace_gum_0.ncgr",
	"itm_ace_gum_1.ncgr",
	"itm_ace_gum_2.ncgr",
	"itm_ace_gum_3.ncgr",
	"itm_ace_gunof_0.ncgr",
	"itm_ace_gunof_1.ncgr",
	"itm_ace_gunof_2.ncgr",
	"itm_ace_gunof_3.ncgr",
	"itm_ace_ice_0.ncgr",
	"itm_ace_ice_1.ncgr",
	"itm_ace_ice_2.ncgr",
	"itm_ace_ice_3.ncgr",
	"itm_ace_immun_0.ncgr",
	"itm_ace_immun_1.ncgr",
	"itm_ace_immun_2.ncgr",
	"itm_ace_immun_3.ncgr",
	"itm_ace_ironw_0.ncgr",
	"itm_ace_ironw_1.ncgr",
	"itm_ace_ironw_2.ncgr",
	"itm_ace_ironw_3.ncgr",
	"itm_ace_jammr_0.ncgr",
	"itm_ace_jammr_1.ncgr",
	"itm_ace_jammr_2.ncgr",
	"itm_ace_jammr_3.ncgr",
	"itm_ace_kevlr_0.ncgr",
	"itm_ace_kevlr_1.ncgr",
	"itm_ace_kevlr_2.ncgr",
	"itm_ace_kevlr_3.ncgr",
	"itm_ace_kron_0.ncgr",
	"itm_ace_kron_1.ncgr",
	"itm_ace_kron_2.ncgr",
	"itm_ace_kron_3.ncgr",
	"itm_ace_leaf_0.ncgr",
	"itm_ace_leaf_1.ncgr",
	"itm_ace_leaf_2.ncgr",
	"itm_ace_leaf_3.ncgr",
	"itm_ace_lghtn_0.ncgr",
	"itm_ace_lghtn_1.ncgr",
	"itm_ace_lghtn_2.ncgr",
	"itm_ace_lghtn_3.ncgr",
	"itm_ace_life.ncgr",
	"itm_ace_life_0.ncgr",
	"itm_ace_life_1.ncgr",
	"itm_ace_life_2.ncgr",
	"itm_ace_life_3.ncgr",
	"itm_ace_medem_0.ncgr",
	"itm_ace_medem_1.ncgr",
	"itm_ace_medem_2.ncgr",
	"itm_ace_medem_3.ncgr",
	"itm_ace_medkt_0.ncgr",
	"itm_ace_medkt_1.ncgr",
	"itm_ace_medkt_2.ncgr",
	"itm_ace_medkt_3.ncgr",
	"itm_ace_noctn_0.ncgr",
	"itm_ace_noctn_1.ncgr",
	"itm_ace_noctn_2.ncgr",
	"itm_ace_noctn_3.ncgr",
	"itm_ace_nrgal_0.ncgr",
	"itm_ace_nrgal_1.ncgr",
	"itm_ace_nrgal_2.ncgr",
	"itm_ace_nrgal_3.ncgr",
	"itm_ace_power_0.ncgr",
	"itm_ace_power_1.ncgr",
	"itm_ace_power_2.ncgr",
	"itm_ace_power_3.ncgr",
	"itm_ace_pring_0.ncgr",
	"itm_ace_pring_1.ncgr",
	"itm_ace_pring_2.ncgr",
	"itm_ace_pring_3.ncgr",
	"itm_ace_prune_0.ncgr",
	"itm_ace_prune_1.ncgr",
	"itm_ace_prune_2.ncgr",
	"itm_ace_prune_3.ncgr",
	"itm_ace_psych_0.ncgr",
	"itm_ace_psych_1.ncgr",
	"itm_ace_psych_2.ncgr",
	"itm_ace_psych_3.ncgr",
	"itm_ace_radio_0.ncgr",
	"itm_ace_radio_1.ncgr",
	"itm_ace_radio_2.ncgr",
	"itm_ace_radio_3.ncgr",
	"itm_ace_rejuv_0.ncgr",
	"itm_ace_rejuv_1.ncgr",
	"itm_ace_rejuv_2.ncgr",
	"itm_ace_rejuv_3.ncgr",
	"itm_ace_resur_0.ncgr",
	"itm_ace_resur_1.ncgr",
	"itm_ace_resur_2.ncgr",
	"itm_ace_resur_3.ncgr",
	"itm_ace_rocks_0.ncgr",
	"itm_ace_rocks_1.ncgr",
	"itm_ace_rocks_2.ncgr",
	"itm_ace_rocks_3.ncgr",
	"itm_ace_root_0.ncgr",
	"itm_ace_root_1.ncgr",
	"itm_ace_root_2.ncgr",
	"itm_ace_root_3.ncgr",
	"itm_ace_scan_0.ncgr",
	"itm_ace_scan_1.ncgr",
	"itm_ace_scan_2.ncgr",
	"itm_ace_scan_3.ncgr",
	"itm_ace_seed_0.ncgr",
	"itm_ace_seed_1.ncgr",
	"itm_ace_seed_2.ncgr",
	"itm_ace_seed_3.ncgr",
	"itm_ace_shipm_0.ncgr",
	"itm_ace_shipm_1.ncgr",
	"itm_ace_shipm_2.ncgr",
	"itm_ace_shipm_3.ncgr",
	"itm_ace_shld_0.ncgr",
	"itm_ace_shld_1.ncgr",
	"itm_ace_shld_2.ncgr",
	"itm_ace_shld_3.ncgr",
	"itm_ace_spdbr_0.ncgr",
	"itm_ace_spdbr_1.ncgr",
	"itm_ace_spdbr_2.ncgr",
	"itm_ace_spdbr_3.ncgr",
	"itm_ace_staplr_0.ncgr",
	"itm_ace_staplr_1.ncgr",
	"itm_ace_staplr_2.ncgr",
	"itm_ace_staplr_3.ncgr",
	"itm_ace_sturd_0.ncgr",
	"itm_ace_sturd_1.ncgr",
	"itm_ace_sturd_2.ncgr",
	"itm_ace_sturd_3.ncgr",
	"itm_ace_tablt_0.ncgr",
	"itm_ace_tablt_1.ncgr",
	"itm_ace_tablt_2.ncgr",
	"itm_ace_tablt_3.ncgr",
	"itm_ace_timmy_0.ncgr",
	"itm_ace_timmy_1.ncgr",
	"itm_ace_timmy_2.ncgr",
	"itm_ace_timmy_3.ncgr",
	"itm_ace_tools_0.ncgr",
	"itm_ace_tools_1.ncgr",
	"itm_ace_tools_2.ncgr",
	"itm_ace_tools_3.ncgr",
	"itm_ace_tyxis_0.ncgr",
	"itm_ace_tyxis_1.ncgr",
	"itm_ace_tyxis_2.ncgr",
	"itm_ace_tyxis_3.ncgr",
	"itm_ace_voxai_0.ncgr",
	"itm_ace_voxai_1.ncgr",
	"itm_ace_voxai_2.ncgr",
	"itm_ace_voxai_3.ncgr",
	"itm_ace_wpnp1_0.ncgr",
	"itm_ace_wpnp1_1.ncgr",
	"itm_ace_wpnp1_2.ncgr",
	"itm_ace_wpnp1_3.ncgr",
	"itm_ace_wpnp2_0.ncgr",
	"itm_ace_wpnp2_1.ncgr",
	"itm_ace_wpnp2_2.ncgr",
	"itm_ace_wpnp2_3.ncgr",
	"itm_act2_chaos1_0.ncgr",
	"itm_act2_chaos1_1.ncgr",
	"itm_act2_chaos1_2.ncgr",
	"itm_act2_chaos1_3.ncgr",
	"itm_act2_chaos2_0.ncgr",
	"itm_act2_chaos2_1.ncgr",
	"itm_act2_chaos2_2.ncgr",
	"itm_act2_chaos2_3.ncgr",
	"itm_act2_chaos3_0.ncgr",
	"itm_act2_chaos3_1.ncgr",
	"itm_act2_chaos3_2.ncgr",
	"itm_act2_chaos3_3.ncgr",
	"itm_act2_chaos4_0.ncgr",
	"itm_act2_chaos4_1.ncgr",
	"itm_act2_chaos4_2.ncgr",
	"itm_act2_chaos4_3.ncgr",
	"itm_act2_chaos5_0.ncgr",
	"itm_act2_chaos5_1.ncgr",
	"itm_act2_chaos5_2.ncgr",
	"itm_act2_chaos5_3.ncgr",
	"itm_act2_chaos6_0.ncgr",
	"itm_act2_chaos6_1.ncgr",
	"itm_act2_chaos6_2.ncgr",
	"itm_act2_chaos6_3.ncgr",
	"itm_act2_chaos7_0.ncgr",
	"itm_act2_chaos7_1.ncgr",
	"itm_act2_chaos7_2.ncgr",
	"itm_act2_chaos7_3.ncgr",
	"itm_act2_mastr_0.ncgr",
	"itm_act2_mastr_1.ncgr",
	"itm_act2_mastr_2.ncgr",
	"itm_act2_mastr_3.ncgr",
	"itm_chao_egg_0.ncgr",
	"itm_chao_egg_1.ncgr",
	"itm_chao_egg_2.ncgr",
	"itm_chao_egg_3.ncgr",
	"itm_fotgrshy_0.ncgr",
	"itm_fotgrshy_1.ncgr",
	"itm_fotgrshy_2.ncgr",
	"itm_fotgrshy_3.ncgr",
	"itm_fotirnhy_0.ncgr",
	"itm_fotirnhy_1.ncgr",
	"itm_fotirnhy_2.ncgr",
	"itm_fotirnhy_3.ncgr",
	"itm_fotkevbt_0.ncgr",
	"itm_fotkevbt_1.ncgr",
	"itm_fotkevbt_2.ncgr",
	"itm_fotkevbt_3.ncgr",
	"itm_fotlgtbt_0.ncgr",
	"itm_fotlgtbt_1.ncgr",
	"itm_fotlgtbt_2.ncgr",
	"itm_fotlgtbt_3.ncgr",
	"itm_fotrnfhy_0.ncgr",
	"itm_fotrnfhy_1.ncgr",
	"itm_fotrnfhy_2.ncgr",
	"itm_fotrnfhy_3.ncgr",
	"itm_fotrsthy_0.ncgr",
	"itm_fotrsthy_1.ncgr",
	"itm_fotrsthy_2.ncgr",
	"itm_fotrsthy_3.ncgr",
	"itm_fotrunkb_0.ncgr",
	"itm_fotrunkb_1.ncgr",
	"itm_fotrunkb_2.ncgr",
	"itm_fotrunkb_3.ncgr",
	"itm_fotrunkv_0.ncgr",
	"itm_fotrunkv_1.ncgr",
	"itm_fotrunkv_2.ncgr",
	"itm_fotrunkv_3.ncgr",
	"itm_fotrunrg_0.ncgr",
	"itm_fotrunrg_1.ncgr",
	"itm_fotrunrg_2.ncgr",
	"itm_fotrunrg_3.ncgr",
	"itm_fotrunsl_0.ncgr",
	"itm_fotrunsl_1.ncgr",
	"itm_fotrunsl_2.ncgr",
	"itm_fotrunsl_3.ncgr",
	"itm_fotrunsp_0.ncgr",
	"itm_fotrunsp_1.ncgr",
	"itm_fotrunsp_2.ncgr",
	"itm_fotrunsp_3.ncgr",
	"itm_fotslpdk_0.ncgr",
	"itm_fotslpdk_1.ncgr",
	"itm_fotslpdk_2.ncgr",
	"itm_fotslpdk_3.ncgr",
	"itm_fotslpgr_0.ncgr",
	"itm_fotslpgr_1.ncgr",
	"itm_fotslpgr_2.ncgr",
	"itm_fotslpgr_3.ncgr",
	"itm_fotslplt_0.ncgr",
	"itm_fotslplt_1.ncgr",
	"itm_fotslplt_2.ncgr",
	"itm_fotslplt_3.ncgr",
	"itm_fotslpnm_0.ncgr",
	"itm_fotslpnm_1.ncgr",
	"itm_fotslpnm_2.ncgr",
	"itm_fotslpnm_3.ncgr",
	"itm_fotslprg_0.ncgr",
	"itm_fotslprg_1.ncgr",
	"itm_fotslprg_2.ncgr",
	"itm_fotslprg_3.ncgr",
	"itm_fotsnkel_0.ncgr",
	"itm_fotsnkel_1.ncgr",
	"itm_fotsnkel_2.ncgr",
	"itm_fotsnkel_3.ncgr",
	"itm_fotsnkkb_0.ncgr",
	"itm_fotsnkkb_1.ncgr",
	"itm_fotsnkkb_2.ncgr",
	"itm_fotsnkkb_3.ncgr",
	"itm_fotsnklt_0.ncgr",
	"itm_fotsnklt_1.ncgr",
	"itm_fotsnklt_2.ncgr",
	"itm_fotsnklt_3.ncgr",
	"itm_fotsnkrg_0.ncgr",
	"itm_fotsnkrg_1.ncgr",
	"itm_fotsnkrg_2.ncgr",
	"itm_fotsnkrg_3.ncgr",
	"itm_fotsnksh_0.ncgr",
	"itm_fotsnksh_1.ncgr",
	"itm_fotsnksh_2.ncgr",
	"itm_fotsnksh_3.ncgr",
	"itm_fotstlbt_0.ncgr",
	"itm_fotstlbt_1.ncgr",
	"itm_fotstlbt_2.ncgr",
	"itm_fotstlbt_3.ncgr",
	"itm_fotswtbt_0.ncgr",
	"itm_fotswtbt_1.ncgr",
	"itm_fotswtbt_2.ncgr",
	"itm_fotswtbt_3.ncgr",
	"itm_fotttnhy_0.ncgr",
	"itm_fotttnhy_1.ncgr",
	"itm_fotttnhy_2.ncgr",
	"itm_fotttnhy_3.ncgr",
	"itm_fotwrkbt_0.ncgr",
	"itm_fotwrkbt_1.ncgr",
	"itm_fotwrkbt_2.ncgr",
	"itm_fotwrkbt_3.ncgr",
	"itm_glvblncl_0.ncgr",
	"itm_glvblncl_1.ncgr",
	"itm_glvblncl_2.ncgr",
	"itm_glvblncl_3.ncgr",
	"itm_glvcrscl_0.ncgr",
	"itm_glvcrscl_1.ncgr",
	"itm_glvcrscl_2.ncgr",
	"itm_glvcrscl_3.ncgr",
	"itm_glvgrpcl_0.ncgr",
	"itm_glvgrpcl_1.ncgr",
	"itm_glvgrpcl_2.ncgr",
	"itm_glvgrpcl_3.ncgr",
	"itm_glvirncl_0.ncgr",
	"itm_glvirncl_1.ncgr",
	"itm_glvirncl_2.ncgr",
	"itm_glvirncl_3.ncgr",
	"itm_glvsercl_0.ncgr",
	"itm_glvsercl_1.ncgr",
	"itm_glvsercl_2.ncgr",
	"itm_glvsercl_3.ncgr",
	"itm_glvspncl_0.ncgr",
	"itm_glvspncl_1.ncgr",
	"itm_glvspncl_2.ncgr",
	"itm_glvspncl_3.ncgr",
	"itm_glvttncl_0.ncgr",
	"itm_glvttncl_1.ncgr",
	"itm_glvttncl_2.ncgr",
	"itm_glvttncl_3.ncgr",
	"itm_glv_cloth_0.ncgr",
	"itm_glv_cloth_1.ncgr",
	"itm_glv_cloth_2.ncgr",
	"itm_glv_cloth_3.ncgr",
	"itm_glv_crystal0.ncgr",
	"itm_glv_crystal1.ncgr",
	"itm_glv_crystal2.ncgr",
	"itm_glv_crystal3.ncgr",
	"itm_glv_dark_0.ncgr",
	"itm_glv_dark_1.ncgr",
	"itm_glv_dark_2.ncgr",
	"itm_glv_dark_3.ncgr",
	"itm_glv_fire_0.ncgr",
	"itm_glv_fire_1.ncgr",
	"itm_glv_fire_2.ncgr",
	"itm_glv_fire_3.ncgr",
	"itm_glv_gold_0.ncgr",
	"itm_glv_gold_1.ncgr",
	"itm_glv_gold_2.ncgr",
	"itm_glv_gold_3.ncgr",
	"itm_glv_grip_0.ncgr",
	"itm_glv_grip_1.ncgr",
	"itm_glv_grip_2.ncgr",
	"itm_glv_grip_3.ncgr",
	"itm_glv_ice_0.ncgr",
	"itm_glv_ice_1.ncgr",
	"itm_glv_ice_2.ncgr",
	"itm_glv_ice_3.ncgr",
	"itm_glv_light_0.ncgr",
	"itm_glv_light_1.ncgr",
	"itm_glv_light_2.ncgr",
	"itm_glv_light_3.ncgr",
	"itm_glv_lucky_0.ncgr",
	"itm_glv_lucky_1.ncgr",
	"itm_glv_lucky_2.ncgr",
	"itm_glv_lucky_3.ncgr",
	"itm_glv_metal_0.ncgr",
	"itm_glv_metal_1.ncgr",
	"itm_glv_metal_2.ncgr",
	"itm_glv_metal_3.ncgr",
	"itm_glv_midnt_0.ncgr",
	"itm_glv_midnt_1.ncgr",
	"itm_glv_midnt_2.ncgr",
	"itm_glv_midnt_3.ncgr",
	"itm_glv_power_0.ncgr",
	"itm_glv_power_1.ncgr",
	"itm_glv_power_2.ncgr",
	"itm_glv_power_3.ncgr",
	"itm_glv_rock_0.ncgr",
	"itm_glv_rock_1.ncgr",
	"itm_glv_rock_2.ncgr",
	"itm_glv_rock_3.ncgr",
	"itm_glv_rub_0.ncgr",
	"itm_glv_rub_1.ncgr",
	"itm_glv_rub_2.ncgr",
	"itm_glv_rub_3.ncgr",
	"itm_glv_rug_0.ncgr",
	"itm_glv_rug_1.ncgr",
	"itm_glv_rug_2.ncgr",
	"itm_glv_rug_3.ncgr",
	"itm_glv_spark_0.ncgr",
	"itm_glv_spark_1.ncgr",
	"itm_glv_spark_2.ncgr",
	"itm_glv_spark_3.ncgr",
	"itm_glv_spike_0.ncgr",
	"itm_glv_spike_1.ncgr",
	"itm_glv_spike_2.ncgr",
	"itm_glv_spike_3.ncgr",
	"itm_glv_stealth0.ncgr",
	"itm_glv_stealth1.ncgr",
	"itm_glv_stealth2.ncgr",
	"itm_glv_stealth3.ncgr",
	"itm_glv_strong_0.ncgr",
	"itm_glv_strong_1.ncgr",
	"itm_glv_strong_2.ncgr",
	"itm_glv_strong_3.ncgr",
	"itm_glv_work_0.ncgr",
	"itm_glv_work_1.ncgr",
	"itm_glv_work_2.ncgr",
	"itm_glv_work_3.ncgr",
	"itm_place64.ncgr",
	"ixa_aa.nsbmd",
	"ixa_aa.nsbtx",
	"ixa_cb_pattack1.nsbca",
	"ixa_cb_pattack2.nsbca",
	"ixb_aa.nsbmd",
	"ixb_aa.nsbtx",
	"ixb_cb_attack1.nsbca",
	"ixb_cb_attack2.nsbca",
	"ixb_cb_counter.nsbca",
	"ixb_cb_damage.nsbca",
	"ixb_cb_dead.nsbca",
	"ixb_cb_getup.nsbca",
	"ixb_cb_idle.nsbca",
	"ixb_cb_kd.nsbca",
	"ixb_cb_rise.nsbca",
	"ixb_ex_idle.nsbca",
	"ix_aa.nsbmd",
	"ix_aa.nsbtx",
	"ix_cb_attack.nsbca",
	"ix_cb_attackc.nsbca",
	"ix_cb_attackend.nsbca",
	"ix_cb_counter.nsbca",
	"ix_cb_damage.nsbca",
	"ix_cb_dead.nsbca",
	"ix_cb_finale.nsbca",
	"ix_cb_getup.nsbca",
	"ix_cb_idle.nsbca",
	"ix_cb_kd.nsbca",
	"ix_cb_pattack1.nsbca",
	"ix_cb_rise.nsbca",
	"ix_ex_idle.nsbca",
	"ix_ex_run.nsbca",
	"ix_ex_walk.nsbca",
	"jay_test.are",
	"jillcan12ol.nftr",
	"jillcan12rg.nftr",
	"jillcan12sh.nftr",
	"jillcan13bdol.nftr",
	"jillcan13bdrg.nftr",
	"jillcan13bdsh.nftr",
	"jillcan13ol.nftr",
	"jillcan13rg.nftr",
	"jillcan13sh.nftr",
	"journalbackbutton.gui",
	"journalbackground.gui",
	"journalbuttons.gui",
	"journalcodexentry.gui",
	"journalcredits.gda",
	"journalgui_bs_01.tga",
	"journalgui_bs_02.tga",
	"journalgui_bs_blur.tga",
	"journalgui_ts_01.tga",
	"journalgui_ts_blur.tga",
	"journalinfo.gui",
	"journallist.gui",
	"journaloverhangpanel.gui",
	"journalrules.gda",
	"journaltab.gui",
	"journal_ts.gui",
	"jrl_arrow_00.ncgr",
	"jrl_buttn_of00.ncgr",
	"jrl_buttn_on00.ncgr",
	"jrl_check_00.ncgr",
	"jrl_circl_tb00.ncgr",
	"jrl_scrll_tk00.ncgr",
	"jrl_scrll_tk10.ncgr",
	"jrl_scrll_tk20.ncgr",
	"jrl_tlgbr_of00.ncgr",
	"jrl_tlgbr_of01.ncgr",
	"jrl_tlgbr_of02.ncgr",
	"jrl_tlgbr_on00.ncgr",
	"jrl_tlgbr_on01.ncgr",
	"jrl_tlgbr_on02.ncgr",
	"jrl_tlgbx_ms00.ncgr",
	"jrl_tlgbx_ms01.ncgr",
	"jrl_tlgbx_ms02.ncgr",
	"jrl_tlgbx_ms10.ncgr",
	"jrl_tlgbx_ms11.ncgr",
	"jrl_tlgbx_ms12.ncgr",
	"jrl_tlgbx_ms20.ncgr",
	"jrl_tlgbx_ms21.ncgr",
	"jrl_tlgbx_ms22.ncgr",
	"jrl_tlgbx_ms30.ncgr",
	"jrl_tlgbx_ms31.ncgr",
	"jrl_tlgbx_ms32.ncgr",
	"jrl_tlgbx_ms40.ncgr",
	"jrl_tlgbx_ms41.ncgr",
	"jrl_tlgbx_ms42.ncgr",
	"jrl_tmbox_ms00.ncgr",
	"jrl_tmbox_ms01.ncgr",
	"jrl_tmbox_ms02.ncgr",
	"jrl_tmbox_ms10.ncgr",
	"jrl_tmbox_ms11.ncgr",
	"jrl_tmbox_ms12.ncgr",
	"jrl_tmbox_ms20.ncgr",
	"jrl_tmbox_ms21.ncgr",
	"jrl_tmbox_ms22.ncgr",
	"jrl_tsmbr_of00.ncgr",
	"jrl_tsmbr_of01.ncgr",
	"jrl_tsmbr_of02.ncgr",
	"jrl_tsmbr_of10.ncgr",
	"jrl_tsmbr_of11.ncgr",
	"jrl_tsmbr_of12.ncgr",
	"jrl_tsmbr_on00.ncgr",
	"jrl_tsmbr_on01.ncgr",
	"jrl_tsmbr_on02.ncgr",
	"jrl_tsmbr_on_10.ncgr",
	"jrl_tsmbr_on_11.ncgr",
	"jrl_tsmbr_on_12.ncgr",
	"jurnl_arrowb.ncgr",
	"jurnl_arrowblit.ncgr",
	"jurnl_arrowcodb.ncgr",
	"jurnl_arrowcodn.ncgr",
	"jurnl_arrown.ncgr",
	"jurnl_arrownlit.ncgr",
	"jurnl_bs00.ncgr",
	"jurnl_bs01.ncgr",
	"jurnl_bs02.ncgr",
	"jurnl_bs03.ncgr",
	"jurnl_cod00.ncgr",
	"jurnl_cod01.ncgr",
	"jurnl_cod02.ncgr",
	"jurnl_cod03.ncgr",
	"jurnl_cod_line00.ncgr",
	"jurnl_cod_line01.ncgr",
	"jurnl_cod_line02.ncgr",
	"jurnl_cod_line03.ncgr",
	"jurnl_cod_line04.ncgr",
	"jurnl_cod_linelit00.ncgr",
	"jurnl_cod_linelit01.ncgr",
	"jurnl_cod_linelit02.ncgr",
	"jurnl_cod_linelit03.ncgr",
	"jurnl_cod_linelit04.ncgr",
	"jurnl_mis00.ncgr",
	"jurnl_mis01.ncgr",
	"jurnl_mis02.ncgr",
	"jurnl_mis03.ncgr",
	"jurnl_mis_line00.ncgr",
	"jurnl_mis_line01.ncgr",
	"jurnl_mis_line02.ncgr",
	"jurnl_mis_line03.ncgr",
	"jurnl_mis_line04.ncgr",
	"jurnl_mis_line05.ncgr",
	"jurnl_mis_linelit00.ncgr",
	"jurnl_mis_linelit01.ncgr",
	"jurnl_mis_linelit02.ncgr",
	"jurnl_mis_linelit03.ncgr",
	"jurnl_mis_linelit04.ncgr",
	"jurnl_mis_linelit05.ncgr",
	"jurnl_pnl00.ncgr",
	"jurnl_pnl01.ncgr",
	"jurnl_pnl02.ncgr",
	"jurnl_pnl03.ncgr",
	"jurnl_pnl10.ncgr",
	"jurnl_pnl11.ncgr",
	"jurnl_pnl12.ncgr",
	"jurnl_pnl13.ncgr",
	"jurnl_scroll.ncgr",
	"jurnl_ts00.ncgr",
	"jurnl_ts01.ncgr",
	"jurnl_ts02.ncgr",
	"jurnl_ts03.ncgr",
	"jurnl_ts10.ncgr",
	"jurnl_ts11.ncgr",
	"jurnl_ts12.ncgr",
	"jurnl_ts13.ncgr",
	"jurnl_ts20.ncgr",
	"jurnl_ts21.ncgr",
	"jurnl_ts22.ncgr",
	"jurnl_ts23.ncgr",
	"kdr_cb_attack.nsbca",
	"kdr_cb_attackc.nsbca",
	"kdr_cb_attackend.nsbca",
	"kdr_cb_counter.nsbca",
	"kdr_cb_damage.nsbca",
	"kdr_cb_dead.nsbca",
	"kdr_cb_getup.nsbca",
	"kdr_cb_idle.nsbca",
	"kdr_cb_kd.nsbca",
	"kdr_cb_pattack.nsbca",
	"kdr_ex_damage.nsbca",
	"kdr_ex_fall.nsbca",
	"kdr_ex_idle.nsbca",
	"kdr_ex_jump.nsbca",
	"kdr_ex_run.nsbca",
	"kdr_ex_walk.nsbca",
	"kme_aa.nsbmd",
	"kme_aa.nsbtx",
	"knuckles_aa_p.ncgr",
	"knu_cb_attack.nsbca",
	"knu_cb_attackc.nsbca",
	"knu_cb_attackend.nsbca",
	"knu_cb_block.nsbca",
	"knu_cb_blockc.nsbca",
	"knu_cb_blockd.nsbca",
	"knu_cb_blockin.nsbca",
	"knu_cb_blockout.nsbca",
	"knu_cb_counter.nsbca",
	"knu_cb_dead.nsbca",
	"knu_cb_deadidle.nsbca",
	"knu_cb_idle.nsbca",
	"knu_cb_pattack1.nsbca",
	"knu_cb_pattack2.nsbca",
	"knu_cb_pattack3.nsbca",
	"knu_cb_rund.nsbca",
	"knu_cb_victory.nsbca",
	"knu_cb_victoryin.nsbca",
	"knu_ex_climb.nsbca",
	"knu_ex_fall.nsbca",
	"knu_ex_fly.nsbca",
	"knu_ex_flyin.nsbca",
	"knu_ex_flyout.nsbca",
	"knu_ex_idle.nsbca",
	"knu_ex_jump.nsbca",
	"knu_ex_run.nsbca",
	"knu_ex_smash.nsbca",
	"knu_ex_twitch.nsbca",
	"knu_ex_walk.nsbca",
	"knu_uppercut.gff",
	"krn_hintguy.dlg",
	"kron_store.dlg",
	"kro_cb_attack.nsbca",
	"kro_cb_attackc.nsbca",
	"kro_cb_attackend.nsbca",
	"kro_cb_counter.nsbca",
	"kro_cb_damage.nsbca",
	"kro_cb_dead.nsbca",
	"kro_cb_getup.nsbca",
	"kro_cb_idle.nsbca",
	"kro_cb_kd.nsbca",
	"kro_cb_pattack.nsbca",
	"kro_ex_damage.nsbca",
	"kro_ex_fall.nsbca",
	"kro_ex_idle.nsbca",
	"kro_ex_jump.nsbca",
	"kro_ex_run.nsbca",
	"kro_ex_walk.nsbca",
	"largeportrait.gui",
	"levels.gda",
	"levelup1_bs.tga",
	"levelup1_ts.tga",
	"levelup2_bs.tga",
	"levelup2_ts.tga",
	"levelupbonuslower.gui",
	"levelupbonusupper.gui",
	"leveluplowerbuttons.gui",
	"levelupportrait.gui",
	"leveluptechlower.gui",
	"leveluptechupper.gui",
	"levelup_bonus_lower.gui",
	"levelup_bonus_top.gui",
	"levelup_tech_lower.gui",
	"levelup_tech_top.gui",
	"lights.gda",
	"lizkdra_aa.nsbmd",
	"lizkdra_aa.nsbtx",
	"lizscor_aa.nsbmd",
	"lizscor_aa.nsbtx",
	"loc_abshd_dt0.ncgr",
	"loc_abshd_dt1.ncgr",
	"loc_abshd_es0.ncgr",
	"loc_abshd_es1.ncgr",
	"loc_abshd_fr0.ncgr",
	"loc_abshd_fr1.ncgr",
	"loc_abshd_it0.ncgr",
	"loc_abshd_it1.ncgr",
	"loc_ambsh_dt0.ncgr",
	"loc_ambsh_dt1.ncgr",
	"loc_ambsh_es0.ncgr",
	"loc_ambsh_es1.ncgr",
	"loc_ambsh_fr0.ncgr",
	"loc_ambsh_fr1.ncgr",
	"loc_ambsh_it0.ncgr",
	"loc_ambsh_it1.ncgr",
	"loc_round_dt0.ncgr",
	"loc_round_dt1.ncgr",
	"loc_round_es0.ncgr",
	"loc_round_es1.ncgr",
	"loc_round_fr0.ncgr",
	"loc_round_fr1.ncgr",
	"loc_round_it0.ncgr",
	"loc_round_it1.ncgr",
	"loc_trppd_dt0.ncgr",
	"loc_trppd_dt1.ncgr",
	"loc_trppd_es0.ncgr",
	"loc_trppd_es1.ncgr",
	"loc_trppd_fr0.ncgr",
	"loc_trppd_fr1.ncgr",
	"loc_trppd_it0.ncgr",
	"loc_trppd_it1.ncgr",
	"loc_victr_dt0.ncgr",
	"loc_victr_dt1.ncgr",
	"loc_victr_es0.ncgr",
	"loc_victr_es1.ncgr",
	"loc_victr_fr0.ncgr",
	"loc_victr_fr1.ncgr",
	"loc_victr_it0.ncgr",
	"loc_victr_it1.ncgr",
	"lootgui.gui",
	"lose.gui",
	"lowertextbubble.gui",
	"lowertextbutton.gui",
	"lowertextselected.gui",
	"lower_bg_00.ncgr",
	"lower_bg_01.ncgr",
	"lower_bg_02.ncgr",
	"lower_bg_03.ncgr",
	"lower_bg_04.ncgr",
	"lower_bg_05.ncgr",
	"lower_bg_06.ncgr",
	"lower_bg_07.ncgr",
	"lower_bg_08.ncgr",
	"lower_bg_09.ncgr",
	"lower_bg_10.ncgr",
	"lower_bg_11.ncgr",
	"lower_big_ball.ncgr",
	"lower_blue_ring_00.ncgr",
	"lower_blue_ring_01.ncgr",
	"lower_blue_ring_02.ncgr",
	"lower_blue_ring_03.ncgr",
	"lower_blue_ring_04.ncgr",
	"lower_bubblebox_00.ncgr",
	"lower_bubblebox_01.ncgr",
	"lower_green_ring_00.ncgr",
	"lower_green_ring_01.ncgr",
	"lower_green_ring_02.ncgr",
	"lower_green_ring_03.ncgr",
	"lower_small_ball.ncgr",
	"lower_sonic_portrait_00.ncgr",
	"lower_sonic_portrait_01.ncgr",
	"lower_sonic_portrait_02.ncgr",
	"lower_sonic_portrait_03.ncgr",
	"lower_textbox_00.ncgr",
	"lower_textbox_01.ncgr",
	"lower_textbox_02.ncgr",
	"lower_textbox_03.ncgr",
	"lower_textbox_04.ncgr",
	"lower_textbox_05.ncgr",
	"lower_textbox_06.ncgr",
	"lower_textbox_07.ncgr",
	"lower_textbox_arrow.ncgr",
	"lvl_but_back.ncgr",
	"lvl_but_bg.ncgr",
	"lvl_but_bglit.ncgr",
	"lvl_but_next.ncgr",
	"lvl_lrgbt_of00.ncgr",
	"lvl_lrgbt_of01.ncgr",
	"lvl_lrgbt_of02.ncgr",
	"lvl_lrgbt_on00.ncgr",
	"lvl_lrgbt_on01.ncgr",
	"lvl_lrgbt_on02.ncgr",
	"lvl_pow_bspnl00.ncgr",
	"lvl_pow_bspnl01.ncgr",
	"lvl_pow_bspnl02.ncgr",
	"lvl_pow_bspnl03.ncgr",
	"lvl_pow_bspnl10.ncgr",
	"lvl_pow_bspnl11.ncgr",
	"lvl_pow_bspnl12.ncgr",
	"lvl_pow_bspnl13.ncgr",
	"lvl_pow_bspnl20.ncgr",
	"lvl_pow_bspnl21.ncgr",
	"lvl_pow_bspnl22.ncgr",
	"lvl_pow_pointoff.ncgr",
	"lvl_pow_pointon.ncgr",
	"lvl_pow_tspnl00.ncgr",
	"lvl_pow_tspnl01.ncgr",
	"lvl_pow_tspnl02.ncgr",
	"lvl_pow_tspnl03.ncgr",
	"lvl_pow_tspnl10.ncgr",
	"lvl_pow_tspnl11.ncgr",
	"lvl_pow_tspnl12.ncgr",
	"lvl_pow_tspnl13.ncgr",
	"lvl_pow_tspnl20.ncgr",
	"lvl_pow_tspnl21.ncgr",
	"lvl_pow_tspnl22.ncgr",
	"lvl_pow_tspnl23.ncgr",
	"lvl_smlbt_di00.ncgr",
	"lvl_smlbt_hi00.ncgr",
	"lvl_smlbt_of00.ncgr",
	"lvl_smlbt_on00.ncgr",
	"lvl_stat_bspnl00.ncgr",
	"lvl_stat_bspnl01.ncgr",
	"lvl_stat_bspnl02.ncgr",
	"lvl_stat_bspnl10.ncgr",
	"lvl_stat_bspnl11.ncgr",
	"lvl_stat_bspnl12.ncgr",
	"lvl_stat_bspnl20.ncgr",
	"lvl_stat_bspnl21.ncgr",
	"lvl_stat_bspnl22.ncgr",
	"lvl_stat_but_auto01.ncgr",
	"lvl_stat_but_auto01lit.ncgr",
	"lvl_stat_but_auto02.ncgr",
	"lvl_stat_but_auto02lit.ncgr",
	"lvl_stat_dash_off.ncgr",
	"lvl_stat_dash_on.ncgr",
	"lvl_stat_lb.ncgr",
	"lvl_stat_lblit.ncgr",
	"lvl_stat_rb.ncgr",
	"lvl_stat_rblit.ncgr",
	"lvl_stat_smpnl00.ncgr",
	"lvl_stat_smpnl01.ncgr",
	"lvl_stat_smpnl10.ncgr",
	"lvl_stat_smpnl11.ncgr",
	"lvl_stat_tspnl00.ncgr",
	"lvl_stat_tspnl01.ncgr",
	"lvl_stat_tspnl02.ncgr",
	"lvl_stat_tspnl10.ncgr",
	"lvl_stat_tspnl11.ncgr",
	"lvl_stat_tspnl12.ncgr",
	"lvl_stat_tspnl20.ncgr",
	"lvl_stat_tspnl21.ncgr",
	"lvl_stat_tspnl22.ncgr",
	"lvl_tdbld_ms00.ncgr",
	"lvl_tdbld_ms01.ncgr",
	"lvl_tdbld_ms02.ncgr",
	"lvl_tdbld_ms03.ncgr",
	"lvl_tdbld_ms04.ncgr",
	"lvl_tdbld_ms10.ncgr",
	"lvl_tdbld_ms11.ncgr",
	"lvl_tdbld_ms12.ncgr",
	"lvl_tdbld_ms13.ncgr",
	"lvl_tdbld_ms14.ncgr",
	"lvl_tdbld_ms20.ncgr",
	"lvl_tdbld_ms21.ncgr",
	"lvl_tdbld_ms22.ncgr",
	"lvl_tdbld_ms23.ncgr",
	"lvl_tdbld_ms24.ncgr",
	"lvl_tlgbx_ms00.ncgr",
	"lvl_tlgbx_ms01.ncgr",
	"lvl_tlgbx_ms02.ncgr",
	"lvl_tlgbx_ms10.ncgr",
	"lvl_tlgbx_ms11.ncgr",
	"lvl_tlgbx_ms12.ncgr",
	"lvl_tlgbx_ms20.ncgr",
	"lvl_tlgbx_ms21.ncgr",
	"lvl_tlgbx_ms22.ncgr",
	"lvl_tmstr_ms00.ncgr",
	"lvl_tmstr_ms01.ncgr",
	"lvl_tmstr_ms02.ncgr",
	"lvl_tmstr_ms10.ncgr",
	"lvl_tmstr_ms11.ncgr",
	"lvl_tmstr_ms12.ncgr",
	"lvl_tmstr_ms20.ncgr",
	"lvl_tmstr_ms21.ncgr",
	"lvl_tmstr_ms22.ncgr",
	"lvl_tsstr_ms00.ncgr",
	"lvl_tsstr_ms01.ncgr",
	"lvl_tsstr_ms02.ncgr",
	"lvl_tsstr_ms10.ncgr",
	"lvl_tsstr_ms11.ncgr",
	"lvl_tsstr_ms12.ncgr",
	"lvl_txbar_di00.ncgr",
	"lvl_txbar_di01.ncgr",
	"lvl_txbar_hi00.ncgr",
	"lvl_txbar_hi01.ncgr",
	"main_action00.ncgr",
	"main_action01.ncgr",
	"main_action_on00.ncgr",
	"main_action_on01.ncgr",
	"main_icon_grey.nclr",
	"main_pnl_backoff.ncgr",
	"main_pnl_backon.ncgr",
	"main_pnl_big00.ncgr",
	"main_pnl_big01.ncgr",
	"main_pnl_big02.ncgr",
	"main_pnl_big03.ncgr",
	"main_pnl_big04a.ncgr",
	"main_pnl_big04b.ncgr",
	"main_pnl_big10.ncgr",
	"main_pnl_big11.ncgr",
	"main_pnl_big12.ncgr",
	"main_pnl_big13.ncgr",
	"main_pnl_big14.ncgr",
	"main_pnl_big15.ncgr",
	"main_pnl_big16.ncgr",
	"main_pnl_big17.ncgr",
	"main_pnl_off00.ncgr",
	"main_pnl_off01.ncgr",
	"main_pnl_off02.ncgr",
	"main_pnl_off03.ncgr",
	"main_pnl_off04.ncgr",
	"main_pnl_off10.ncgr",
	"main_pnl_off11.ncgr",
	"main_pnl_off12.ncgr",
	"main_pnl_off13.ncgr",
	"main_pnl_off14.ncgr",
	"main_pnl_off15.ncgr",
	"main_pnl_off16.ncgr",
	"main_pnl_off17.ncgr",
	"main_pnl_on00.ncgr",
	"main_pnl_on01.ncgr",
	"main_pnl_on02.ncgr",
	"main_pnl_on03.ncgr",
	"main_pnl_on04.ncgr",
	"main_pnl_on10.ncgr",
	"main_pnl_on11.ncgr",
	"main_pnl_on12.ncgr",
	"main_pnl_on13.ncgr",
	"main_pnl_on14.ncgr",
	"main_pnl_on15.ncgr",
	"main_pnl_on16.ncgr",
	"main_pnl_on17.ncgr",
	"main_slt_off00.ncgr",
	"main_slt_off01.ncgr",
	"main_slt_on00.ncgr",
	"main_slt_on01.ncgr",
	"man_bkbtn_of00.ncgr",
	"man_bkbtn_on00.ncgr",
	"man_strbt_of00.ncgr",
	"man_strbt_of01.ncgr",
	"man_strbt_of02.ncgr",
	"man_strbt_of03.ncgr",
	"man_strbt_of10.ncgr",
	"man_strbt_of11.ncgr",
	"man_strbt_of12.ncgr",
	"man_strbt_of13.ncgr",
	"man_strbt_on00.ncgr",
	"man_strbt_on01.ncgr",
	"man_strbt_on02.ncgr",
	"man_strbt_on03.ncgr",
	"man_strbt_on10.ncgr",
	"man_strbt_on11.ncgr",
	"man_strbt_on12.ncgr",
	"man_strbt_on13.ncgr",
	"man_tdlcp_of00.ncgr",
	"man_tdlcp_of01.ncgr",
	"man_tdlcp_of02.ncgr",
	"man_tdlcp_on00.ncgr",
	"man_tdlcp_on01.ncgr",
	"man_tdlcp_on02.ncgr",
	"man_tsvin_00.ncgr",
	"man_tsvin_01.ncgr",
	"man_tsvin_02.ncgr",
	"man_tsvin_03.ncgr",
	"man_tsvin_10.ncgr",
	"man_tsvin_20.ncgr",
	"man_tsvin_21.ncgr",
	"man_tsvin_22.ncgr",
	"man_tsvst_of00.ncgr",
	"man_tsvst_of01.ncgr",
	"man_tsvst_of02.ncgr",
	"man_tsvst_of10.ncgr",
	"man_tsvst_of11.ncgr",
	"man_tsvst_of12.ncgr",
	"man_tsvst_on00.ncgr",
	"man_tsvst_on01.ncgr",
	"man_tsvst_on02.ncgr",
	"man_tsvst_on10.ncgr",
	"man_tsvst_on11.ncgr",
	"man_tsvst_on12.ncgr",
	"mappins.gda",
	"mer_aa.nsbmd",
	"mer_aa.nsbtx",
	"miles_test.are",
	"minimapgui01_ts.tga",
	"minimapgui02_ts.tga",
	"minimapgui_bs.tga",
	"min_circl_ms00.ncgr",
	"min_circl_ms10.ncgr",
	"min_circl_ms11.ncgr",
	"min_circl_ms20.ncgr",
	"min_circl_ms21.ncgr",
	"min_circl_ms30.ncgr",
	"min_circl_ms31.ncgr",
	"mmp_globe_0.ncgr",
	"mmp_globe_1.ncgr",
	"mmp_globe_2.ncgr",
	"mmp_globe_3.ncgr",
	"mmp_lgbar_00.ncgr",
	"mmp_lgbar_01.ncgr",
	"mmp_lgbar_02.ncgr",
	"mmp_smbar_00.ncgr",
	"mmp_smbar_01.ncgr",
	"movement.gda",
	"movement00_bs.tga",
	"movement01_bs.tga",
	"movement01_ts.tga",
	"movement02_bs.tga",
	"movement03_bs.tga",
	"movement04_bs.tga",
	"movement06_bs.tga",
	"movement07_bs.tga",
	"movement08_bs.tga",
	"movement09_bs.tga",
	"movement10_bs.tga",
	"movementsounds.gda",
	"movementtutorial.gda",
	"movementtutorial2.gda",
	"movielist.gda",
	"movies.gda",
	"mrz_ccz.gff",
	"mrz_hintguy.dlg",
	"mtz_hintguy.dlg",
	"mut_btton_of00.ncgr",
	"mut_btton_on00.ncgr",
	"mut_chaob_ms00.ncgr",
	"mut_chaob_ms01.ncgr",
	"mut_chaob_ms10.ncgr",
	"mut_chaob_ms11.ncgr",
	"mut_circl_ms00.ncgr",
	"mut_circl_ms01.ncgr",
	"mut_circl_ms10.ncgr",
	"mut_circl_ms11.ncgr",
	"mut_circl_ms12.ncgr",
	"mut_circl_ms20.ncgr",
	"mut_circl_ms21a.ncgr",
	"mut_circl_ms21b.ncgr",
	"mut_circl_ms30.ncgr",
	"mut_circl_ms31.ncgr",
	"mut_circl_ms32.ncgr",
	"mut_circl_ms40.ncgr",
	"mut_circl_ms41.ncgr",
	"mut_flash_ms00.ncgr",
	"mut_flash_ms01.ncgr",
	"mut_flash_ms10.ncgr",
	"mut_flash_ms11.ncgr",
	"mut_globe_ms00.ncgr",
	"mut_globe_ms01.ncgr",
	"mut_globe_ms10.ncgr",
	"mut_globe_ms11.ncgr",
	"mut_ocrna_ms00.ncgr",
	"mut_ocrna_ms01.ncgr",
	"mut_ocrna_ms10.ncgr",
	"mut_shoes_ms00.ncgr",
	"mut_shoes_ms01.ncgr",
	"mut_shoes_ms10.ncgr",
	"mut_shoes_ms11.ncgr",
	"mut_sonic_ms00.ncgr",
	"mut_sonic_ms01.ncgr",
	"mut_sonic_ms10.ncgr",
	"mut_sonic_ms11.ncgr",
	"n2da.gda",
	"nes_aa.nsbmd",
	"nes_aa.nsbtx",
	"nes_ex_idle.nsbca",
	"nes_ex_run.nsbca",
	"nes_ex_walk.nsbca",
	"ne_sw.gff",
	"nintendosplash.tga",
	"nrg_aa.nsbmd",
	"nrg_aa.nsbtx",
	"nrg_aa_slm.nsbta",
	"nrg_ab.nsbmd",
	"nrg_ab.nsbtx",
	"nrg_ab_slm.nsbta",
	"nrg_ac.nsbmd",
	"nrg_ac.nsbtx",
	"nrg_cb_attack.nsbca",
	"nrg_cb_attack2.nsbca",
	"nrg_cb_attackc.nsbca",
	"nrg_cb_attackc2.nsbca",
	"nrg_cb_attacken2.nsbca",
	"nrg_cb_attackend.nsbca",
	"nrg_cb_counter.nsbca",
	"nrg_cb_damage.nsbca",
	"nrg_cb_dead.nsbca",
	"nrg_cb_getup.nsbca",
	"nrg_cb_idle.nsbca",
	"nrg_cb_kd.nsbca",
	"nrg_cb_pattack01.nsbca",
	"nrg_cb_pattack02.nsbca",
	"nrg_ex_idle.nsbca",
	"nrg_ex_run.nsbca",
	"nrg_ex_walk.nsbca",
	"nsw_aa.nsbmd",
	"nsw_aa.nsbta",
	"nsw_aa.nsbtx",
	"nsw_ex_idle.nsbca",
	"nsw_ex_run.nsbca",
	"nsw_ex_walk.nsbca",
	"numericaltest.gda",
	"nw_se.gff",
	"n_s.gff",
	"omg_aa.nsbmd",
	"omg_aa.nsbtx",
	"omg_cb_attack.nsbca",
	"omg_cb_attackend.nsbca",
	"omg_cb_block.nsbca",
	"omg_cb_blockc.nsbca",
	"omg_cb_blockd.nsbca",
	"omg_cb_blockin.nsbca",
	"omg_cb_blockout.nsbca",
	"omg_cb_counter.nsbca",
	"omg_cb_damage.nsbca",
	"omg_cb_dead.nsbca",
	"omg_cb_getup.nsbca",
	"omg_cb_idle.nsbca",
	"omg_cb_kd.nsbca",
	"omg_cb_pattack01.nsbca",
	"omg_cb_pattack02.nsbca",
	"omg_cb_pattack03.nsbca",
	"omg_cb_pattack04.nsbca",
	"omg_cb_rund.nsbca",
	"omg_cb_stunned.nsbca",
	"omg_cb_victory.nsbca",
	"omg_cb_victoryin.nsbca",
	"omg_ex_damage.nsbca",
	"omg_ex_fall.nsbca",
	"omg_ex_idle.nsbca",
	"omg_ex_jump.nsbca",
	"omg_ex_jumpair.nsbca",
	"omg_ex_run.nsbca",
	"omg_ex_twitch.nsbca",
	"omg_ex_walk.nsbca",
	"overmind_distracted.spl",
	"overmind_sluggish.spl",
	"party.gda",
	"partyselgui_bs.tga",
	"party_switch.gff",
	"pfx_air1_air.emit",
	"pfx_alm1.nsbmd",
	"pfx_alm1.nsbtp",
	"pfx_alm1.nsbtx",
	"pfx_alm1_alm.emit",
	"pfx_arnietest01.emit",
	"pfx_arnietest01.nsbmd",
	"pfx_arnietest01.nsbtp",
	"pfx_arnietest01.nsbtx",
	"pfx_arnietest02.emit",
	"pfx_arnietest02.nsbmd",
	"pfx_arnietest02.nsbtp",
	"pfx_arnietest02.nsbtx",
	"pfx_arnietest03.emit",
	"pfx_arnietest03.nsbmd",
	"pfx_arnietest03.nsbtp",
	"pfx_arnietest03.nsbtx",
	"pfx_ash1.nsbmd",
	"pfx_ash1.nsbtp",
	"pfx_ash1.nsbtx",
	"pfx_ash1_krn.emit",
	"pfx_ash1_noc.emit",
	"pfx_aur1.nsbmd",
	"pfx_aur1.nsbtp",
	"pfx_aur1.nsbtx",
	"pfx_aur1_aur.emit",
	"pfx_bfy1.nsbmd",
	"pfx_bfy1.nsbtp",
	"pfx_bfy1.nsbtx",
	"pfx_bfy1_bfy.emit",
	"pfx_briantest01.emit",
	"pfx_briantest01.nsbmd",
	"pfx_briantest01.nsbtp",
	"pfx_briantest01.nsbtx",
	"pfx_briantest02.emit",
	"pfx_briantest02.nsbmd",
	"pfx_briantest02.nsbtp",
	"pfx_briantest02.nsbtx",
	"pfx_briantest03.emit",
	"pfx_briantest03.nsbmd",
	"pfx_briantest03.nsbtp",
	"pfx_briantest03.nsbtx",
	"pfx_bub1.nsbmd",
	"pfx_bub1.nsbtp",
	"pfx_bub1.nsbtx",
	"pfx_bub1_bub.emit",
	"pfx_bub2.nsbmd",
	"pfx_bub2.nsbtp",
	"pfx_bub2.nsbtx",
	"pfx_bub2_tox.emit",
	"pfx_bub3.nsbmd",
	"pfx_bub3.nsbtp",
	"pfx_bub3.nsbtx",
	"pfx_bub3_lav.emit",
	"pfx_dop1.nsbmd",
	"pfx_dop1.nsbtp",
	"pfx_dop1.nsbtx",
	"pfx_dop1_dop.emit",
	"pfx_dop1_tox.emit",
	"pfx_drp1.nsbmd",
	"pfx_drp1.nsbtp",
	"pfx_drp1.nsbtx",
	"pfx_drp1_drp.emit",
	"pfx_drp1_tox.emit",
	"pfx_fls1.nsbmd",
	"pfx_fls1.nsbtp",
	"pfx_fls1.nsbtx",
	"pfx_fls1_fls.emit",
	"pfx_flyby.emit",
	"pfx_flyby.nsbmd",
	"pfx_flyby.nsbtp",
	"pfx_flyby.nsbtx",
	"pfx_gas1.nsbmd",
	"pfx_gas1.nsbtp",
	"pfx_gas1.nsbtx",
	"pfx_gas1_gas.emit",
	"pfx_glf1.nsbmd",
	"pfx_glf1.nsbtp",
	"pfx_glf1.nsbtx",
	"pfx_glf1_glf.emit",
	"pfx_glo1.nsbmd",
	"pfx_glo1.nsbtp",
	"pfx_glo1.nsbtx",
	"pfx_glo1_blu.emit",
	"pfx_glo1_glo.emit",
	"pfx_glo1_red.emit",
	"pfx_grs1.nsbmd",
	"pfx_grs1.nsbtp",
	"pfx_grs1.nsbtx",
	"pfx_grs1_grs.emit",
	"pfx_gul1.nsbmd",
	"pfx_gul1.nsbtp",
	"pfx_gul1.nsbtx",
	"pfx_gul1_cro.emit",
	"pfx_gul1_gul.emit",
	"pfx_gus1.nsbmd",
	"pfx_gus1.nsbtp",
	"pfx_gus1.nsbtx",
	"pfx_gus1_gus.emit",
	"pfx_haz1.nsbmd",
	"pfx_haz1.nsbtp",
	"pfx_haz1.nsbtx",
	"pfx_haz1_blu.emit",
	"pfx_haz1_pnk.emit",
	"pfx_haz1_smk.emit",
	"pfx_invin.emit",
	"pfx_invin.nsbmd",
	"pfx_invin.nsbtp",
	"pfx_invin.nsbtx",
	"pfx_lef1.nsbmd",
	"pfx_lef1.nsbtp",
	"pfx_lef1.nsbtx",
	"pfx_lef1_lef.emit",
	"pfx_lef2.nsbmd",
	"pfx_lef2.nsbtp",
	"pfx_lef2.nsbtx",
	"pfx_lef2_lef.emit",
	"pfx_lzg1.nsbmd",
	"pfx_lzg1.nsbtp",
	"pfx_lzg1.nsbtx",
	"pfx_lzg1_lzg.emit",
	"pfx_lzr1.nsbmd",
	"pfx_lzr1.nsbtp",
	"pfx_lzr1.nsbtx",
	"pfx_lzr1_lzr.emit",
	"pfx_mot1.nsbmd",
	"pfx_mot1.nsbtp",
	"pfx_mot1.nsbtx",
	"pfx_mot1_blu.emit",
	"pfx_mot1_pnk.emit",
	"pfx_mot1_sno.emit",
	"pfx_mot1_sta.emit",
	"pfx_mot1_tlp.emit",
	"pfx_mst1.nsbmd",
	"pfx_mst1.nsbtp",
	"pfx_mst1.nsbtx",
	"pfx_mst1_blu.emit",
	"pfx_mst1_dsh.emit",
	"pfx_mst1_mst.emit",
	"pfx_mst1_pnk.emit",
	"pfx_mst1_skf.emit",
	"pfx_mst1_stm.emit",
	"pfx_mst1_wfl.emit",
	"pfx_mst1_yel.emit",
	"pfx_nicktest01.emit",
	"pfx_nicktest01.nsbmd",
	"pfx_nicktest01.nsbtp",
	"pfx_nicktest01.nsbtx",
	"pfx_nicktest02.emit",
	"pfx_nicktest02.nsbmd",
	"pfx_nicktest02.nsbtp",
	"pfx_nicktest02.nsbtx",
	"pfx_nicktest03.emit",
	"pfx_nicktest03.nsbmd",
	"pfx_nicktest03.nsbtp",
	"pfx_nicktest03.nsbtx",
	"pfx_nrg1_chw.emit",
	"pfx_nrg1_gas.emit",
	"pfx_orb.nsbmd",
	"pfx_orb.nsbtp",
	"pfx_orb.nsbtx",
	"pfx_orb1_orb.emit",
	"pfx_ppr1.nsbmd",
	"pfx_ppr1.nsbtp",
	"pfx_ppr1.nsbtx",
	"pfx_ppr1_ppr.emit",
	"pfx_puring.emit",
	"pfx_puring.nsbmd",
	"pfx_puring.nsbtp",
	"pfx_puring.nsbtx",
	"pfx_rip1.nsbmd",
	"pfx_rip1.nsbtp",
	"pfx_rip1.nsbtx",
	"pfx_rip1_rip.emit",
	"pfx_rng1.nsbmd",
	"pfx_rng1.nsbtp",
	"pfx_rng1.nsbtx",
	"pfx_rng1_rng.emit",
	"pfx_rok1.nsbmd",
	"pfx_rok1.nsbtp",
	"pfx_rok1.nsbtx",
	"pfx_rok1_rok.emit",
	"pfx_smd1.nsbmd",
	"pfx_smd1.nsbtp",
	"pfx_smd1.nsbtx",
	"pfx_smd1_smd.emit",
	"pfx_smk1.nsbmd",
	"pfx_smk1.nsbtp",
	"pfx_smk1.nsbtx",
	"pfx_smk1_bst.emit",
	"pfx_smk1_col.emit",
	"pfx_smk1_krn.emit",
	"pfx_smk2.nsbmd",
	"pfx_smk2.nsbtp",
	"pfx_smk2.nsbtx",
	"pfx_smk2_dsh.emit",
	"pfx_sms1.nsbmd",
	"pfx_sms1.nsbtp",
	"pfx_sms1.nsbtx",
	"pfx_sms1_sms.emit",
	"pfx_spark.emit",
	"pfx_spark.nsbmd",
	"pfx_spark.nsbtp",
	"pfx_spark.nsbtx",
	"pfx_spk1.nsbmd",
	"pfx_spk1.nsbtp",
	"pfx_spk1.nsbtx",
	"pfx_spk1_shk.emit",
	"pfx_spk1_spk.emit",
	"pfx_tlp1.nsbmd",
	"pfx_tlp1.nsbtp",
	"pfx_tlp1.nsbtx",
	"pfx_tlp1_tlp.emit",
	"pig_cb_attack.nsbca",
	"pig_cb_attackc.nsbca",
	"pig_cb_attackend.nsbca",
	"pig_cb_counter.nsbca",
	"pig_cb_damage.nsbca",
	"pig_cb_dead.nsbca",
	"pig_cb_getup.nsbca",
	"pig_cb_idle.nsbca",
	"pig_cb_kd.nsbca",
	"pig_cb_pattack.nsbca",
	"pig_ex_damage.nsbca",
	"pig_ex_fall.nsbca",
	"pig_ex_idle.nsbca",
	"pig_ex_jump.nsbca",
	"pig_ex_run.nsbca",
	"pig_ex_walk.nsbca",
	"pil_aa.nsbmd",
	"pil_aa.nsbtx",
	"pil_cb_attack.nsbca",
	"pil_cb_attackend.nsbca",
	"pil_cb_damage.nsbca",
	"pil_cb_dead.nsbca",
	"pil_cb_getup.nsbca",
	"pil_cb_idle.nsbca",
	"pil_cb_kd.nsbca",
	"pirates_hack.gff",
	"pirates_player_entry.gff",
	"pirates_teleport.gff",
	"placeablestates.gda",
	"plotflags.gda",
	"plots.gda",
	"plt_a1sq_factory.plo",
	"plt_a1sq_muggers.plo",
	"plt_a1sq_occupado.plo",
	"plt_a1sq_official.plo",
	"plt_a1sq_omgwasps.plo",
	"plt_a1sq_scientist.plo",
	"plt_a1sq_timmy.plo",
	"plt_a1_amy.plo",
	"plt_a2sq_clues.plo",
	"plt_a2sq_haniman.plo",
	"plt_a2sq_interference.plo",
	"plt_a2sq_knicknacks.plo",
	"plt_a2sq_nrrgalshipment.plo",
	"plt_a2sq_pirates.plo",
	"plt_a2sq_spawningpool.plo",
	"plt_a2sq_stalker.plo",
	"plt_a2sq_stronghold.plo",
	"plt_a2sq_telra.plo",
	"plt_a2sq_tyxcivs.plo",
	"plt_a2_stronghold.plo",
	"plt_a2_worldmap.plo",
	"plt_ch10_main.plo",
	"plt_ch1_main.plo",
	"plt_ch1_tutorial.plo",
	"plt_ch1_woodsman.plo",
	"plt_ch2_main.plo",
	"plt_ch3_boy.plo",
	"plt_ch3_eggbot.plo",
	"plt_ch3_main.plo",
	"plt_ch3_parts.plo",
	"plt_ch3_roboanimals.plo",
	"plt_ch3_shadow.plo",
	"plt_ch3_shopkeeper.plo",
	"plt_ch4_main.plo",
	"plt_ch5_main.plo",
	"plt_ch6_main.plo",
	"plt_ch7_main.plo",
	"plt_charyb_main.plo",
	"plt_cod_amy.plo",
	"plt_cod_angelisland.plo",
	"plt_cod_argus.plo",
	"plt_cod_argusevent.plo",
	"plt_cod_big.plo",
	"plt_cod_chao.plo",
	"plt_cod_chaosemerald.plo",
	"plt_cod_cream.plo",
	"plt_cod_eggman.plo",
	"plt_cod_fgciv.plo",
	"plt_cod_gizoids.plo",
	"plt_cod_gun.plo",
	"plt_cod_ix.plo",
	"plt_cod_knuckles.plo",
	"plt_cod_knucklesclan.plo",
	"plt_cod_kron.plo",
	"plt_cod_marauders.plo",
	"plt_cod_masteremerald.plo",
	"plt_cod_nocturnusclan.plo",
	"plt_cod_nrrgal.plo",
	"plt_cod_omega.plo",
	"plt_cod_perfectchaos.plo",
	"plt_cod_precursors.plo",
	"plt_cod_robotnik.plo",
	"plt_cod_rouge.plo",
	"plt_cod_shade.plo",
	"plt_cod_shadow.plo",
	"plt_cod_sonic.plo",
	"plt_cod_tails.plo",
	"plt_cod_twilightcage.plo",
	"plt_cod_tyxsis.plo",
	"plt_cod_voxai.plo",
	"plt_credits.plo",
	"plt_fpa2_amy.plo",
	"plt_fpa2_big.plo",
	"plt_fpa2_cream.plo",
	"plt_fpa2_knuckles.plo",
	"plt_fpa2_omega.plo",
	"plt_fpa2_rouge.plo",
	"plt_fpa2_shade.plo",
	"plt_fpa2_shadow.plo",
	"plt_fpa2_tails.plo",
	"plt_fp_amy.plo",
	"plt_fp_big.plo",
	"plt_fp_cream.plo",
	"plt_fp_eggman.plo",
	"plt_fp_knuckles.plo",
	"plt_fp_omega.plo",
	"plt_fp_rouge.plo",
	"plt_fp_shade.plo",
	"plt_fp_shadow.plo",
	"plt_fp_tails.plo",
	"plt_gbl_inparty.plo",
	"plt_gbl_misc.plo",
	"plt_gbl_puzzles.plo",
	"plt_lo_gun.plo",
	"plt_lo_kron.plo",
	"plt_lo_nocturnus.plo",
	"plt_lo_sectorcharyb.plo",
	"plt_lo_sectorscylla.plo",
	"plt_lo_voxai.plo",
	"plt_lo_warpbelts.plo",
	"plt_plot1.plo",
	"plt_plot2.plo",
	"plt_plot3.plo",
	"plt_scylla_main.plo",
	"plt_scylla_or_charyb.plo",
	"plt_storysofar.plo",
	"plt_teatest.plo",
	"pl_am_met_gbp.nsbca",
	"pl_am_met_gfl.nsbca",
	"pl_am_met_gfr.nsbca",
	"pl_am_met_gun.nsbmd",
	"pl_am_met_gun.nsbtp",
	"pl_am_met_gun.nsbtx",
	"pl_am_met_gup.nsbca",
	"pl_am_noc_gcb.nsbca",
	"pl_am_noc_gcf.nsbca",
	"pl_am_noc_gch.nsbca",
	"pl_am_noc_gco.nsbca",
	"pl_am_noc_gco.nsbta",
	"pl_am_noc_gco.nsbtp",
	"pl_am_noc_gcsf.nsbta",
	"pl_am_noc_gcsf.nsbtp",
	"pl_am_noc_gcsn.nsbta",
	"pl_am_noc_gcsn.nsbtp",
	"pl_am_noc_gct.nsbca",
	"pl_am_noc_gct.nsbta",
	"pl_am_noc_gct.nsbtp",
	"pl_am_noc_ghl.nsbca",
	"pl_am_noc_ghr.nsbca",
	"pl_am_noc_gnf.nsbta",
	"pl_am_noc_gnf.nsbtp",
	"pl_am_noc_gsl.nsbca",
	"pl_am_noc_gslr.nsbca",
	"pl_am_noc_gslr.nsbta",
	"pl_am_noc_gslr.nsbtp",
	"pl_am_noc_gsr.nsbca",
	"pl_am_noc_gun.nsbmd",
	"pl_am_noc_gun.nsbtx",
	"pl_am_rdr_aa.nsbmd",
	"pl_am_rdr_aa.nsbtp",
	"pl_am_rdr_aa.nsbtx",
	"pl_am_rdr_act.nsbca",
	"pl_am_rdr_dct.nsbca",
	"pl_am_rdr_off.nsbca",
	"pl_am_tyx_gbp.nsbca",
	"pl_am_tyx_gdn.nsbca",
	"pl_am_tyx_gfr.nsbca",
	"pl_am_tyx_gun.nsbmd",
	"pl_am_tyx_gun.nsbtx",
	"pl_mov_arw_aa.nsbca",
	"pl_mov_arw_aa.nsbmd",
	"pl_mov_arw_aa.nsbta",
	"pl_mov_arw_aa.nsbtx",
	"pl_mov_arw_ab.nsbta",
	"pl_mov_arw_in.nsbca",
	"pl_mov_arw_yw.nsbmd",
	"pl_mov_arw_yw.nsbtx",
	"pl_mv_boa_aa.nsbmd",
	"pl_mv_boa_aa.nsbta",
	"pl_mv_boa_aa.nsbtx",
	"pl_mv_boa_bp.nsbca",
	"pl_mv_boa_flt.nsbca",
	"pl_mv_boa_pd.nsbca",
	"pl_mv_boa_row.nsbca",
	"pl_mv_bop_aa.nsbmd",
	"pl_mv_bop_aa.nsbtx",
	"pl_mv_bop_bon.nsbca",
	"pl_mv_cyc_aa.nsbmd",
	"pl_mv_cyc_aa.nsbtx",
	"pl_mv_cyc_crs.nsbca",
	"pl_mv_cyc_crs.nsbta",
	"pl_mv_cyc_fly.nsbca",
	"pl_mv_cyc_fly.nsbta",
	"pl_mv_cyc_prk.nsbca",
	"pl_mv_cyc_prk.nsbta",
	"pl_mv_cyc_sm.nsbmd",
	"pl_mv_cyc_sm.nsbtx",
	"pl_mv_cyc_to.nsbca",
	"pl_mv_cyc_to.nsbta",
	"pl_mv_tor_aa.nsbmd",
	"pl_mv_tor_aa.nsbtx",
	"pl_mv_tor_fly.nsbca",
	"pl_mv_tor_oi.nsbmd",
	"pl_mv_tor_oi.nsbtx",
	"pl_mv_tor_prk.nsbca",
	"pl_mv_tor_to.nsbca",
	"pl_mv_wnc_aa.nsbmd",
	"pl_mv_wnc_aa.nsbta",
	"pl_mv_wnc_aa.nsbtx",
	"pl_mv_wnc_bp.nsbca",
	"pl_mv_wnc_on.nsbca",
	"pl_mv_zip.nsbmd",
	"pl_mv_zip.nsbta",
	"pl_mv_zip.nsbtx",
	"pl_ob_bdr_aa.nsbmd",
	"pl_ob_bdr_aa.nsbtx",
	"pl_ob_blkb_cb.nsbmd",
	"pl_ob_blkb_cb.nsbtx",
	"pl_ob_blkb_co.nsbmd",
	"pl_ob_blkb_co.nsbtx",
	"pl_ob_blkb_cr.nsbmd",
	"pl_ob_blkb_cr.nsbtx",
	"pl_ob_blkb_mb.nsbmd",
	"pl_ob_blkb_mb.nsbtx",
	"pl_ob_blkb_mo.nsbmd",
	"pl_ob_blkb_mo.nsbtx",
	"pl_ob_blkb_mr.nsbmd",
	"pl_ob_blkb_mr.nsbtx",
	"pl_ob_blkb_sb.nsbmd",
	"pl_ob_blkb_sb.nsbtx",
	"pl_ob_blkb_so.nsbmd",
	"pl_ob_blkb_so.nsbtx",
	"pl_ob_blkb_sr.nsbmd",
	"pl_ob_blkb_sr.nsbtx",
	"pl_ob_blkn_cb.nsbmd",
	"pl_ob_blkn_cb.nsbtx",
	"pl_ob_blkn_co.nsbmd",
	"pl_ob_blkn_co.nsbtx",
	"pl_ob_blkn_cr.nsbmd",
	"pl_ob_blkn_cr.nsbtx",
	"pl_ob_blkn_mb.nsbmd",
	"pl_ob_blkn_mb.nsbtx",
	"pl_ob_blkn_mo.nsbmd",
	"pl_ob_blkn_mo.nsbtx",
	"pl_ob_blkn_mr.nsbmd",
	"pl_ob_blkn_mr.nsbtx",
	"pl_ob_blkn_sb.nsbmd",
	"pl_ob_blkn_sb.nsbtx",
	"pl_ob_blkn_so.nsbmd",
	"pl_ob_blkn_so.nsbtx",
	"pl_ob_blkn_sr.nsbmd",
	"pl_ob_blkn_sr.nsbtx",
	"pl_ob_blk_aa.nsbmd",
	"pl_ob_blk_aa.nsbtx",
	"pl_ob_blk_bkn.nsbca",
	"pl_ob_blk_brk.nsbca",
	"pl_ob_blk_fall.nsbca",
	"pl_ob_blk_nb.nsbmd",
	"pl_ob_blk_nb.nsbtx",
	"pl_ob_spk_aa.nsbmd",
	"pl_ob_spk_aa.nsbtx",
	"pl_ob_spk_dn.nsbca",
	"pl_ob_spk_hdn.nsbca",
	"pl_ob_spk_hup.nsbca",
	"pl_ob_spk_up.nsbca",
	"pl_pu_cao_egg.nsbmd",
	"pl_pu_cao_egg.nsbtx",
	"pl_pu_cao_nst.nsbmd",
	"pl_pu_cao_nst.nsbtx",
	"pl_pu_cha_egg.nsbmd",
	"pl_pu_cha_egg.nsbtp",
	"pl_pu_cha_egg.nsbtx",
	"pl_pu_cha_nst.nsbtp",
	"pl_pu_chst_aa.nsbmd",
	"pl_pu_chst_aa.nsbtp",
	"pl_pu_chst_aa.nsbtx",
	"pl_pu_chst_bp.nsbca",
	"pl_pu_chst_oa.nsbca",
	"pl_pu_chst_oh.nsbca",
	"pl_pu_emrld.nsbca",
	"pl_pu_emrld1.nsbmd",
	"pl_pu_emrld1.nsbtx",
	"pl_pu_emrld2.nsbmd",
	"pl_pu_emrld2.nsbtx",
	"pl_pu_emrld3.nsbmd",
	"pl_pu_emrld3.nsbtx",
	"pl_pu_emrld4.nsbmd",
	"pl_pu_emrld4.nsbtx",
	"pl_pu_emrld5.nsbmd",
	"pl_pu_emrld5.nsbtx",
	"pl_pu_emrld6.nsbmd",
	"pl_pu_emrld6.nsbtx",
	"pl_pu_emrld7.nsbmd",
	"pl_pu_emrld7.nsbtx",
	"pl_pu_memrld.nsbmd",
	"pl_pu_memrld.nsbtx",
	"pl_pu_rngshad.nsbmd",
	"pl_pu_rngshad.nsbtp",
	"pl_pu_rngshad.nsbtx",
	"pl_pu_rng_aa.nsbmd",
	"pl_pu_rng_aa.nsbtx",
	"pl_pu_rng_spn.nsbtp",
	"pl_pu_scr_bg.nsbca",
	"pl_pu_scr_bn.nsbca",
	"pl_pu_scr_ghs_bg.nsbmd",
	"pl_pu_scr_ghs_bg.nsbtx",
	"pl_pz_brd_1dn.nsbca",
	"pl_pz_brd_1hd.nsbca",
	"pl_pz_brd_1up.nsbca",
	"pl_pz_brd_2dn.nsbca",
	"pl_pz_brd_2hd.nsbca",
	"pl_pz_brd_2up.nsbca",
	"pl_pz_brd_3dn.nsbca",
	"pl_pz_brd_3hd.nsbca",
	"pl_pz_brd_3up.nsbca",
	"pl_pz_brd_4dn.nsbca",
	"pl_pz_brd_aa.nsbmd",
	"pl_pz_brd_aa.nsbtx",
	"pl_pz_brd_end.nsbca",
	"pl_pz_brd_idl.nsbca",
	"pl_pz_brg_rg.nsbtp",
	"pl_pz_cav_bp.nsbca",
	"pl_pz_cav_dr.nsbmd",
	"pl_pz_cav_dr.nsbtx",
	"pl_pz_cav_dr_01.nsbta",
	"pl_pz_cav_end.nsbca",
	"pl_pz_cav_scrn.nsbmd",
	"pl_pz_cav_scrn.nsbtp",
	"pl_pz_cav_scrn.nsbtx",
	"pl_pz_cav_snow.nsbca",
	"pl_pz_cav_snow.nsbmd",
	"pl_pz_cav_snow.nsbtx",
	"pl_pz_crn_aa.nsbmd",
	"pl_pz_crn_aa.nsbtp",
	"pl_pz_crn_aa.nsbtx",
	"pl_pz_crn_end.nsbca",
	"pl_pz_crn_hang.nsbca",
	"pl_pz_crn_start.nsbca",
	"pl_pz_crn_stopb.nsbca",
	"pl_pz_crn_tu.nsbmd",
	"pl_pz_crn_tu.nsbtp",
	"pl_pz_crn_tu.nsbtx",
	"pl_pz_crn_turnb.nsbca",
	"pl_pz_crn_turnf.nsbca",
	"pl_pz_fanlt_rg.nsbmd",
	"pl_pz_fanlt_rg.nsbtp",
	"pl_pz_fanlt_rg.nsbtx",
	"pl_pz_fan_aa.nsbmd",
	"pl_pz_fan_aa.nsbtx",
	"pl_pz_fan_spn.nsbta",
	"pl_pz_gen_aa.nsbmd",
	"pl_pz_gen_aa.nsbtx",
	"pl_pz_gen_bp.nsbca",
	"pl_pz_gen_on.nsbca",
	"pl_pz_mem_box.nsbmd",
	"pl_pz_mem_box.nsbtp",
	"pl_pz_mem_box.nsbtx",
	"pl_pz_mem_bp.nsbca",
	"pl_pz_mem_end.nsbca",
	"pl_pz_mem_lts.nsbmd",
	"pl_pz_mem_lts.nsbtp",
	"pl_pz_mem_lts.nsbtx",
	"pl_pz_mem_tmr.nsbtp",
	"pl_pz_mem_trd.nsbmd",
	"pl_pz_mem_trd.nsbta",
	"pl_pz_mem_trd.nsbtx",
	"pl_pz_mem_xtnd.nsbca",
	"pl_pz_pod_aa.nsbmd",
	"pl_pz_pod_aa.nsbtx",
	"pl_pz_pod_bat.nsbca",
	"pl_pz_pod_bat.nsbmd",
	"pl_pz_pod_bat.nsbtx",
	"pl_pz_pod_dn.nsbca",
	"pl_pz_pod_dr.nsbtp",
	"pl_pz_pod_pd.nsbca",
	"pl_pz_pod_pu.nsbca",
	"pl_pz_pod_up.nsbca",
	"pl_pz_ppd_aa.nsbmd",
	"pl_pz_ppd_aa.nsbtx",
	"pl_pz_ppd_dn.nsbca",
	"pl_pz_ppd_dn.nsbta",
	"pl_pz_ppd_dn.nsbtp",
	"pl_pz_ppd_pdn.nsbca",
	"pl_pz_ppd_pup.nsbca",
	"pl_pz_ppd_rg.nsbtp",
	"pl_pz_ppd_up.nsbca",
	"pl_pz_ppd_up.nsbta",
	"pl_pz_ppd_up.nsbtp",
	"pl_pz_ppv_aa.nsbmd",
	"pl_pz_ppv_aa.nsbtx",
	"pl_pz_ppv_dn.nsbca",
	"pl_pz_ppv_dn.nsbta",
	"pl_pz_ppv_dn.nsbtp",
	"pl_pz_ppv_up.nsbca",
	"pl_pz_ppv_up.nsbta",
	"pl_pz_ppv_up.nsbtp",
	"pl_pz_rc_cd1.nsbca",
	"pl_pz_rc_cd2.nsbca",
	"pl_pz_rc_cd3.nsbca",
	"pl_pz_rc_cdh.nsbca",
	"pl_pz_rc_crs.nsbmd",
	"pl_pz_rc_crs.nsbtp",
	"pl_pz_rc_crs.nsbtx",
	"pl_pz_rc_sw.nsbmd",
	"pl_pz_rc_sw.nsbtp",
	"pl_pz_rc_sw.nsbtx",
	"pl_pz_rc_trd.nsbmd",
	"pl_pz_rc_trd.nsbtx",
	"pl_pz_swc_aa.nsbmd",
	"pl_pz_swc_aa.nsbtx",
	"pl_pz_swc_dm.nsbmd",
	"pl_pz_swc_dm.nsbtp",
	"pl_pz_swc_dm.nsbtx",
	"pl_pz_swc_rg.nsbtp",
	"pl_pz_tyx_ans.nsbmd",
	"pl_pz_tyx_ans.nsbtx",
	"pl_pz_tyx_num.nsbmd",
	"pl_pz_tyx_num.nsbtp",
	"pl_pz_tyx_num.nsbtx",
	"pl_pz_tyx_ptn.nsbmd",
	"pl_pz_tyx_ptn.nsbtx",
	"pl_pz_vox_lb.nsbmd",
	"pl_pz_vox_lb.nsbtp",
	"pl_pz_vox_lb.nsbtx",
	"pl_pz_vox_lr.nsbmd",
	"pl_pz_vox_lr.nsbtp",
	"pl_pz_vox_lr.nsbtx",
	"pl_pz_vox_lts.nsbtp",
	"pl_pz_vox_ly.nsbmd",
	"pl_pz_vox_ly.nsbtp",
	"pl_pz_vox_ly.nsbtx",
	"pl_pz_vox_ppt.nsbmd",
	"pl_pz_vox_ppt.nsbtp",
	"pl_pz_vox_ppt.nsbtx",
	"pl_pz_vox_pth.nsbmd",
	"pl_pz_vox_pth.nsbta",
	"pl_pz_vox_pth.nsbtp",
	"pl_pz_vox_pth.nsbtx",
	"pl_pz_vox_swc.nsbmd",
	"pl_pz_vox_swc.nsbtp",
	"pl_pz_vox_swc.nsbtx",
	"pl_pz_vox_wll.nsbmd",
	"pl_pz_vox_wll.nsbta",
	"pl_pz_vox_wll.nsbtx",
	"pl_pz_wod_aa.nsbmd",
	"pl_pz_wod_aa.nsbtx",
	"pl_pz_wod_chp.nsbca",
	"pl_pz_wod_neu.nsbca",
	"poison.spl",
	"popupdialog.gui",
	"pop_lgbox_ms00.ncgr",
	"pop_lgbox_ms01.ncgr",
	"pop_lgbox_ms02.ncgr",
	"pop_lgbox_ms03.ncgr",
	"pop_lgbox_ms04.ncgr",
	"pop_lgbox_ms05.ncgr",
	"pop_lgbox_ms06.ncgr",
	"pop_lgbox_ms07.ncgr",
	"pop_tggle_of00.ncgr",
	"pop_tggle_of01.ncgr",
	"pop_tggle_of02.ncgr",
	"pop_tggle_of03.ncgr",
	"pop_tggle_on00.ncgr",
	"pop_tggle_on01.ncgr",
	"pop_tggle_on02.ncgr",
	"pop_tggle_on03.ncgr",
	"portrait.tga",
	"portraitguilayout.gui",
	"power.ncgr",
	"pow_base.nbfp",
	"pow_base.nbfs",
	"pow_base.tga",
	"prf_chrbx_di00.ncgr",
	"prf_chrbx_di01.ncgr",
	"prf_chrbx_di10.ncgr",
	"prf_chrbx_di11.ncgr",
	"prf_chrbx_di20.ncgr",
	"prf_chrbx_di21.ncgr",
	"prf_crtba_hi00.ncgr",
	"prf_crtbb_hi00.ncgr",
	"prf_crtbc_hi00.ncgr",
	"prf_crtbd_hi00.ncgr",
	"prf_smarw_of00.ncgr",
	"prf_smarw_on00.ncgr",
	"prf_tboxa_ms00.ncgr",
	"prf_tboxa_ms01.ncgr",
	"prf_tboxa_ms02.ncgr",
	"prf_tboxa_ms10.ncgr",
	"prf_tboxa_ms11.ncgr",
	"prf_tboxa_ms12.ncgr",
	"prf_tboxb_ms00.ncgr",
	"prf_tboxb_ms01.ncgr",
	"prf_tboxb_ms02.ncgr",
	"prf_tboxb_ms10.ncgr",
	"prf_tboxb_ms11.ncgr",
	"prf_tboxb_ms12.ncgr",
	"prf_tlbar_ms00.ncgr",
	"prf_tlbar_ms01.ncgr",
	"prf_tlbar_ms02.ncgr",
	"prf_tmbar_of00.ncgr",
	"prf_tmbar_of01.ncgr",
	"prf_tmbar_of02.ncgr",
	"prf_tmbar_on00.ncgr",
	"prf_tmbar_on01.ncgr",
	"prf_tmbar_on02.ncgr",
	"prf_tpanl_ms00.ncgr",
	"prf_tpanl_ms01.ncgr",
	"prf_tpanl_ms02.ncgr",
	"prf_tpanl_ms10.ncgr",
	"prf_tpanl_ms11.ncgr",
	"prf_tpanl_ms12.ncgr",
	"prf_tpanl_ms20.ncgr",
	"prf_tpanl_ms21.ncgr",
	"prf_tpanl_ms22.ncgr",
	"profilecreaturepanel.gui",
	"profilegui_tut_bs.tga",
	"profile_bottom_detail.gui",
	"profile_bottom_equip.gui",
	"profile_bottom_static.gui",
	"profile_bottom_summary.gui",
	"profile_ts.gui",
	"projectiles.gda",
	"prologue.gda",
	"prologueb.gda",
	"pro_back_of00.ncgr",
	"pro_back_on00.ncgr",
	"pro_bar_of00.ncgr",
	"pro_bar_of01.ncgr",
	"pro_bar_of02.ncgr",
	"pro_bar_on00.ncgr",
	"pro_bar_on01.ncgr",
	"pro_bar_on02.ncgr",
	"pro_circle_hi00.ncgr",
	"pro_help_of00.ncgr",
	"pro_help_on00.ncgr",
	"pro_lrgbx_00.ncgr",
	"pro_lrgbx_01.ncgr",
	"pro_lrgbx_02.ncgr",
	"pro_lrgbx_10.ncgr",
	"pro_lrgbx_11.ncgr",
	"pro_lrgbx_12.ncgr",
	"pro_lrgbx_20.ncgr",
	"pro_lrgbx_21.ncgr",
	"pro_lrgbx_22.ncgr",
	"pro_medbx_00.ncgr",
	"pro_medbx_01.ncgr",
	"pro_medbx_02.ncgr",
	"pro_medbx_10.ncgr",
	"pro_medbx_11.ncgr",
	"pro_medbx_12.ncgr",
	"pro_medbx_20.ncgr",
	"pro_medbx_21.ncgr",
	"pro_medbx_22.ncgr",
	"pro_medbx_30.ncgr",
	"pro_medbx_31.ncgr",
	"pro_medbx_32.ncgr",
	"pro_sidbx_00.ncgr",
	"pro_sidbx_01.ncgr",
	"pro_sidbx_10.ncgr",
	"pro_sidbx_11.ncgr",
	"pro_sidbx_20.ncgr",
	"pro_sidbx_30.ncgr",
	"pro_smbox_00.ncgr",
	"pro_smbox_01.ncgr",
	"pro_smbox_02.ncgr",
	"pro_smbox_10.ncgr",
	"pro_smbox_11.ncgr",
	"pro_smbox_12.ncgr",
	"pro_tab_00.ncgr",
	"pro_tab_10.ncgr",
	"pro_tab_20.ncgr",
	"pro_tab_30.ncgr",
	"prtl_aeqgen_0.ncgr",
	"prtl_aeqgen_1.ncgr",
	"prtl_aeqgen_2.ncgr",
	"prtl_aeqgen_3.ncgr",
	"prtl_aeqhap_0.ncgr",
	"prtl_aeqhap_1.ncgr",
	"prtl_aeqhap_2.ncgr",
	"prtl_aeqhap_3.ncgr",
	"prtl_aeqsec_0.ncgr",
	"prtl_aeqsec_1.ncgr",
	"prtl_aeqsec_2.ncgr",
	"prtl_aeqsec_3.ncgr",
	"prtl_agzgen_0.ncgr",
	"prtl_agzgen_1.ncgr",
	"prtl_agzgen_2.ncgr",
	"prtl_agzgen_3.ncgr",
	"prtl_amy.nclr",
	"prtl_amydet_0.ncgr",
	"prtl_amydet_1.ncgr",
	"prtl_amydet_2.ncgr",
	"prtl_amydet_3.ncgr",
	"prtl_amydrm_0.ncgr",
	"prtl_amydrm_1.ncgr",
	"prtl_amydrm_2.ncgr",
	"prtl_amydrm_3.ncgr",
	"prtl_amygen_0.ncgr",
	"prtl_amygen_1.ncgr",
	"prtl_amygen_2.ncgr",
	"prtl_amygen_3.ncgr",
	"prtl_amyhap_0.ncgr",
	"prtl_amyhap_1.ncgr",
	"prtl_amyhap_2.ncgr",
	"prtl_amyhap_3.ncgr",
	"prtl_amymad_0.ncgr",
	"prtl_amymad_1.ncgr",
	"prtl_amymad_2.ncgr",
	"prtl_amymad_3.ncgr",
	"prtl_amyoff_0.ncgr",
	"prtl_amyoff_1.ncgr",
	"prtl_amyoff_2.ncgr",
	"prtl_amyoff_3.ncgr",
	"prtl_amysad_0.ncgr",
	"prtl_amysad_1.ncgr",
	"prtl_amysad_2.ncgr",
	"prtl_amysad_3.ncgr",
	"prtl_amysca_0.ncgr",
	"prtl_amysca_1.ncgr",
	"prtl_amysca_2.ncgr",
	"prtl_amysca_3.ncgr",
	"prtl_amysmg_0.ncgr",
	"prtl_amysmg_1.ncgr",
	"prtl_amysmg_2.ncgr",
	"prtl_amysmg_3.ncgr",
	"prtl_amysus_0.ncgr",
	"prtl_amysus_1.ncgr",
	"prtl_amysus_2.ncgr",
	"prtl_amysus_3.ncgr",
	"prtl_biggen_0.ncgr",
	"prtl_biggen_1.ncgr",
	"prtl_biggen_2.ncgr",
	"prtl_biggen_3.ncgr",
	"prtl_bighap_0.ncgr",
	"prtl_bighap_1.ncgr",
	"prtl_bighap_2.ncgr",
	"prtl_bighap_3.ncgr",
	"prtl_bigsnz_0.ncgr",
	"prtl_bigsnz_1.ncgr",
	"prtl_bigsnz_2.ncgr",
	"prtl_bigsnz_3.ncgr",
	"prtl_bigtht_0.ncgr",
	"prtl_bigtht_1.ncgr",
	"prtl_bigtht_2.ncgr",
	"prtl_bigtht_3.ncgr",
	"prtl_boy.nclr",
	"prtl_boyhap_0.ncgr",
	"prtl_boyhap_1.ncgr",
	"prtl_boyhap_2.ncgr",
	"prtl_boyhap_3.ncgr",
	"prtl_boysca_0.ncgr",
	"prtl_boysca_1.ncgr",
	"prtl_boysca_2.ncgr",
	"prtl_boysca_3.ncgr",
	"prtl_cap.nclr",
	"prtl_caphap_0.ncgr",
	"prtl_caphap_1.ncgr",
	"prtl_caphap_2.ncgr",
	"prtl_caphap_3.ncgr",
	"prtl_charyb.nclr",
	"prtl_chbgen_0.ncgr",
	"prtl_chbgen_1.ncgr",
	"prtl_chbgen_2.ncgr",
	"prtl_chbgen_3.ncgr",
	"prtl_cre.nclr",
	"prtl_credet_0.ncgr",
	"prtl_credet_1.ncgr",
	"prtl_credet_2.ncgr",
	"prtl_credet_3.ncgr",
	"prtl_crehap_0.ncgr",
	"prtl_crehap_1.ncgr",
	"prtl_crehap_2.ncgr",
	"prtl_crehap_3.ncgr",
	"prtl_cresad_0.ncgr",
	"prtl_cresad_1.ncgr",
	"prtl_cresad_2.ncgr",
	"prtl_cresad_3.ncgr",
	"prtl_cresca_0.ncgr",
	"prtl_cresca_1.ncgr",
	"prtl_cresca_2.ncgr",
	"prtl_cresca_3.ncgr",
	"prtl_csxgen_0.ncgr",
	"prtl_csxgen_1.ncgr",
	"prtl_csxmad_0.ncgr",
	"prtl_csxmad_1.ncgr",
	"prtl_dad.nclr",
	"prtl_dadrel_0.ncgr",
	"prtl_dadrel_1.ncgr",
	"prtl_dadrel_2.ncgr",
	"prtl_dadrel_3.ncgr",
	"prtl_drone.nclr",
	"prtl_dronegen_0.ncgr",
	"prtl_dronegen_1.ncgr",
	"prtl_dronegen_2.ncgr",
	"prtl_dronegen_3.ncgr",
	"prtl_egb.nclr",
	"prtl_egbgen_0.ncgr",
	"prtl_egbgen_1.ncgr",
	"prtl_egbgen_2.ncgr",
	"prtl_egbgen_3.ncgr",
	"prtl_egg.nclr",
	"prtl_eggaha_0.ncgr",
	"prtl_eggaha_1.ncgr",
	"prtl_eggaha_2.ncgr",
	"prtl_eggaha_3.ncgr",
	"prtl_egggen_0.ncgr",
	"prtl_egggen_1.ncgr",
	"prtl_egggen_2.ncgr",
	"prtl_egggen_3.ncgr",
	"prtl_egghum_0.ncgr",
	"prtl_egghum_1.ncgr",
	"prtl_egghum_2.ncgr",
	"prtl_egghum_3.ncgr",
	"prtl_egginq_0.ncgr",
	"prtl_egginq_1.ncgr",
	"prtl_egginq_2.ncgr",
	"prtl_egginq_3.ncgr",
	"prtl_egglaf_0.ncgr",
	"prtl_egglaf_1.ncgr",
	"prtl_egglaf_2.ncgr",
	"prtl_egglaf_3.ncgr",
	"prtl_eggmad_0.ncgr",
	"prtl_eggmad_1.ncgr",
	"prtl_eggmad_2.ncgr",
	"prtl_eggmad_3.ncgr",
	"prtl_eggsmg_0.ncgr",
	"prtl_eggsmg_1.ncgr",
	"prtl_eggsmg_2.ncgr",
	"prtl_eggsmg_3.ncgr",
	"prtl_eixamu_0.ncgr",
	"prtl_eixamu_1.ncgr",
	"prtl_eixamu_2.ncgr",
	"prtl_eixamu_3.ncgr",
	"prtl_eixfm1_0.ncgr",
	"prtl_eixfm1_1.ncgr",
	"prtl_eixfm1_2.ncgr",
	"prtl_eixfm1_3.ncgr",
	"prtl_eixfm3_0.ncgr",
	"prtl_eixfm3_1.ncgr",
	"prtl_eixfm3_2.ncgr",
	"prtl_eixfm3_3.ncgr",
	"prtl_eixlaf_0.ncgr",
	"prtl_eixlaf_1.ncgr",
	"prtl_eixlaf_2.ncgr",
	"prtl_eixlaf_3.ncgr",
	"prtl_eixmad_0.ncgr",
	"prtl_eixmad_1.ncgr",
	"prtl_eixmad_2.ncgr",
	"prtl_eixmad_3.ncgr",
	"prtl_eixprd_0.ncgr",
	"prtl_eixprd_1.ncgr",
	"prtl_eixprd_2.ncgr",
	"prtl_eixprd_3.ncgr",
	"prtl_eixthrngen_0.ncgr",
	"prtl_eixthrngen_1.ncgr",
	"prtl_eixthrngen_2.ncgr",
	"prtl_eixthrngen_3.ncgr",
	"prtl_eixthrnvar_0.ncgr",
	"prtl_eixthrnvar_1.ncgr",
	"prtl_eixthrnvar_2.ncgr",
	"prtl_eixthrnvar_3.ncgr",
	"prtl_factwork.nclr",
	"prtl_ffmcon_0.ncgr",
	"prtl_ffmcon_1.ncgr",
	"prtl_ffmcon_2.ncgr",
	"prtl_ffmcon_3.ncgr",
	"prtl_ffmmad_0.ncgr",
	"prtl_ffmmad_1.ncgr",
	"prtl_ffmmad_2.ncgr",
	"prtl_ffmmad_3.ncgr",
	"prtl_ffmrel_0.ncgr",
	"prtl_ffmrel_1.ncgr",
	"prtl_fmnang_0.ncgr",
	"prtl_fmnang_1.ncgr",
	"prtl_fmnang_2.ncgr",
	"prtl_fmnang_3.ncgr",
	"prtl_fmncon_0.ncgr",
	"prtl_fmncon_1.ncgr",
	"prtl_fmncon_2.ncgr",
	"prtl_fmncon_3.ncgr",
	"prtl_fmnrel_0.ncgr",
	"prtl_fmnrel_1.ncgr",
	"prtl_fmnrel_2.ncgr",
	"prtl_fmnrel_3.ncgr",
	"prtl_foreman.nclr",
	"prtl_fsggen_0.ncgr",
	"prtl_fsggen_1.ncgr",
	"prtl_fsgmad_0.ncgr",
	"prtl_fsgmad_1.ncgr",
	"prtl_fwrgen_0.ncgr",
	"prtl_fwrgen_1.ncgr",
	"prtl_fwrgen_2.ncgr",
	"prtl_fwrgen_3.ncgr",
	"prtl_fwrmad_0.ncgr",
	"prtl_fwrmad_1.ncgr",
	"prtl_fwrrel_0.ncgr",
	"prtl_fwrrel_1.ncgr",
	"prtl_general.nclr",
	"prtl_generic_2.ncgr",
	"prtl_generic_3.ncgr",
	"prtl_gglgen_0.ncgr",
	"prtl_gglgen_1.ncgr",
	"prtl_gglugh_0.ncgr",
	"prtl_gglugh_1.ncgr",
	"prtl_gizgen_0.ncgr",
	"prtl_gizgen_1.ncgr",
	"prtl_gizgen_2.ncgr",
	"prtl_gizgen_3.ncgr",
	"prtl_gizoid.nclr",
	"prtl_gnagen_0.ncgr",
	"prtl_gnagen_1.ncgr",
	"prtl_gnahap_0.ncgr",
	"prtl_gnahap_1.ncgr",
	"prtl_gnasht_0.ncgr",
	"prtl_gnasht_1.ncgr",
	"prtl_gnggen_0.ncgr",
	"prtl_gnggen_1.ncgr",
	"prtl_gnogen_0.ncgr",
	"prtl_gnogen_1.ncgr",
	"prtl_gnogen_2.ncgr",
	"prtl_gnogen_3.ncgr",
	"prtl_grxgen_0.ncgr",
	"prtl_grxgen_1.ncgr",
	"prtl_grxhum_0.ncgr",
	"prtl_grxhum_1.ncgr",
	"prtl_guncoang_0.ncgr",
	"prtl_guncoang_1.ncgr",
	"prtl_guncoang_2.ncgr",
	"prtl_guncoang_3.ncgr",
	"prtl_guncodet_0.ncgr",
	"prtl_guncodet_1.ncgr",
	"prtl_guncodet_2.ncgr",
	"prtl_guncodet_3.ncgr",
	"prtl_guncodis_0.ncgr",
	"prtl_guncodis_1.ncgr",
	"prtl_guncodis_2.ncgr",
	"prtl_guncodis_3.ncgr",
	"prtl_guncosmg_0.ncgr",
	"prtl_guncosmg_1.ncgr",
	"prtl_guncosmg_2.ncgr",
	"prtl_guncosmg_3.ncgr",
	"prtl_gungen_0.ncgr",
	"prtl_gungen_1.ncgr",
	"prtl_gungen_2.ncgr",
	"prtl_gungen_3.ncgr",
	"prtl_gunhap_0.ncgr",
	"prtl_gunhap_1.ncgr",
	"prtl_gunoff.nclr",
	"prtl_gunsca_0.ncgr",
	"prtl_gunsca_1.ncgr",
	"prtl_hangen_0.ncgr",
	"prtl_hangen_1.ncgr",
	"prtl_hanmad_0.ncgr",
	"prtl_hanmad_1.ncgr",
	"prtl_hansad_0.ncgr",
	"prtl_hansad_1.ncgr",
	"prtl_hczgen_0.ncgr",
	"prtl_hczgen_1.ncgr",
	"prtl_hczgen_2.ncgr",
	"prtl_hczgen_3.ncgr",
	"prtl_humcit.nclr",
	"prtl_ix.nclr",
	"prtl_knuckgen_0.ncgr",
	"prtl_knuckgen_1.ncgr",
	"prtl_knuckgen_2.ncgr",
	"prtl_knuckgen_3.ncgr",
	"prtl_knudet_0.ncgr",
	"prtl_knudet_1.ncgr",
	"prtl_knudet_2.ncgr",
	"prtl_knudet_3.ncgr",
	"prtl_knuexh_0.ncgr",
	"prtl_knuexh_1.ncgr",
	"prtl_knuexh_2.ncgr",
	"prtl_knuexh_3.ncgr",
	"prtl_knugen_0.ncgr",
	"prtl_knugen_1.ncgr",
	"prtl_knugen_2.ncgr",
	"prtl_knugen_3.ncgr",
	"prtl_knuk.nclr",
	"prtl_knumad_0.ncgr",
	"prtl_knumad_1.ncgr",
	"prtl_knumad_2.ncgr",
	"prtl_knumad_3.ncgr",
	"prtl_knusad_0.ncgr",
	"prtl_knusad_1.ncgr",
	"prtl_knusad_2.ncgr",
	"prtl_knusad_3.ncgr",
	"prtl_knusmg_0.ncgr",
	"prtl_knusmg_1.ncgr",
	"prtl_knusmg_2.ncgr",
	"prtl_knusmg_3.ncgr",
	"prtl_knustb_0.ncgr",
	"prtl_knustb_1.ncgr",
	"prtl_knustb_2.ncgr",
	"prtl_knustb_3.ncgr",
	"prtl_krgang_0.ncgr",
	"prtl_krgang_1.ncgr",
	"prtl_krgang_2.ncgr",
	"prtl_krgang_3.ncgr",
	"prtl_krggen_0.ncgr",
	"prtl_krggen_1.ncgr",
	"prtl_krggen_2.ncgr",
	"prtl_krggen_3.ncgr",
	"prtl_krngen_0.ncgr",
	"prtl_krngen_1.ncgr",
	"prtl_krngen_2.ncgr",
	"prtl_krngen_3.ncgr",
	"prtl_kron.nclr",
	"prtl_krs.nclr",
	"prtl_krscon_0.ncgr",
	"prtl_krscon_1.ncgr",
	"prtl_krscon_2.ncgr",
	"prtl_krscon_3.ncgr",
	"prtl_krsgen_0.ncgr",
	"prtl_krsgen_1.ncgr",
	"prtl_krsgen_2.ncgr",
	"prtl_krsgen_3.ncgr",
	"prtl_krshap_0.ncgr",
	"prtl_krshap_1.ncgr",
	"prtl_krshap_2.ncgr",
	"prtl_krshap_3.ncgr",
	"prtl_krsmad_0.ncgr",
	"prtl_krsmad_1.ncgr",
	"prtl_krsmad_2.ncgr",
	"prtl_krsmad_3.ncgr",
	"prtl_krwcon_0.ncgr",
	"prtl_krwcon_1.ncgr",
	"prtl_krwcon_2.ncgr",
	"prtl_krwcon_3.ncgr",
	"prtl_krwgen_0.ncgr",
	"prtl_krwgen_1.ncgr",
	"prtl_krwgen_2.ncgr",
	"prtl_krwgen_3.ncgr",
	"prtl_leucosia.nclr",
	"prtl_ligaia.nclr",
	"prtl_ncs.nclr",
	"prtl_ncsgen_0.ncgr",
	"prtl_ncsgen_1.ncgr",
	"prtl_ncsgen_2.ncgr",
	"prtl_ncsgen_3.ncgr",
	"prtl_nesgen_0.ncgr",
	"prtl_nesgen_1.ncgr",
	"prtl_nesgen_2.ncgr",
	"prtl_nesgen_3.ncgr",
	"prtl_nesinq_0.ncgr",
	"prtl_nesinq_1.ncgr",
	"prtl_nesinq_2.ncgr",
	"prtl_nesinq_3.ncgr",
	"prtl_nessca_0.ncgr",
	"prtl_nessca_1.ncgr",
	"prtl_nessca_2.ncgr",
	"prtl_nessca_3.ncgr",
	"prtl_nestor.nclr",
	"prtl_nrdge2_0.ncgr",
	"prtl_nrdge2_1.ncgr",
	"prtl_nrdge2_2.ncgr",
	"prtl_nrdge2_3.ncgr",
	"prtl_nrmge2_0.ncgr",
	"prtl_nrmge2_1.ncgr",
	"prtl_nrmge2_2.ncgr",
	"prtl_nrmge2_3.ncgr",
	"prtl_nrqge2_0.ncgr",
	"prtl_nrqge2_1.ncgr",
	"prtl_nrqge2_2.ncgr",
	"prtl_nrqge2_3.ncgr",
	"prtl_nrrgal.nclr",
	"prtl_nrsge2_0.ncgr",
	"prtl_nrsge2_1.ncgr",
	"prtl_nrsge2_2.ncgr",
	"prtl_nrsge2_3.ncgr",
	"prtl_oldman.nclr",
	"prtl_omega.nclr",
	"prtl_omggen_0.ncgr",
	"prtl_omggen_1.ncgr",
	"prtl_omggen_2.ncgr",
	"prtl_omggen_3.ncgr",
	"prtl_outhos_0.ncgr",
	"prtl_outhos_1.ncgr",
	"prtl_outhos_2.ncgr",
	"prtl_outhos_3.ncgr",
	"prtl_pilgen_0.ncgr",
	"prtl_pilgen_1.ncgr",
	"prtl_pilgen_2.ncgr",
	"prtl_pilgen_3.ncgr",
	"prtl_pilmad_1.ncgr",
	"prtl_pilsad_0.ncgr",
	"prtl_piratel.nclr",
	"prtl_place.nclr",
	"prtl_riadne.nclr",
	"prtl_rou.nclr",
	"prtl_rougedis_0.ncgr",
	"prtl_rougedis_1.ncgr",
	"prtl_rougedis_2.ncgr",
	"prtl_rougedis_3.ncgr",
	"prtl_rougegen_0.ncgr",
	"prtl_rougegen_1.ncgr",
	"prtl_rougegen_2.ncgr",
	"prtl_rougegen_3.ncgr",
	"prtl_rougeinq_0.ncgr",
	"prtl_rougeinq_1.ncgr",
	"prtl_rougeinq_2.ncgr",
	"prtl_rougeinq_3.ncgr",
	"prtl_rougeoff_0.ncgr",
	"prtl_rougeoff_1.ncgr",
	"prtl_rougeoff_2.ncgr",
	"prtl_rougeoff_3.ncgr",
	"prtl_rougesmg_0.ncgr",
	"prtl_rougesmg_1.ncgr",
	"prtl_rougesmg_2.ncgr",
	"prtl_rougesmg_3.ncgr",
	"prtl_sal.nclr",
	"prtl_salegen_0.ncgr",
	"prtl_salegen_1.ncgr",
	"prtl_salegen_2.ncgr",
	"prtl_salegen_3.ncgr",
	"prtl_salesca_0.ncgr",
	"prtl_salesca_1.ncgr",
	"prtl_salesca_2.ncgr",
	"prtl_salesca_3.ncgr",
	"prtl_salesmg_0.ncgr",
	"prtl_salesmg_1.ncgr",
	"prtl_salesmg_2.ncgr",
	"prtl_salesmg_3.ncgr",
	"prtl_sbtgen_0.ncgr",
	"prtl_sbtgen_1.ncgr",
	"prtl_sbtgen_2.ncgr",
	"prtl_sbtgen_3.ncgr",
	"prtl_sbtmad_0.ncgr",
	"prtl_sbtmad_1.ncgr",
	"prtl_sbtmad_2.ncgr",
	"prtl_sbtmad_3.ncgr",
	"prtl_scientist.nclr",
	"prtl_sciexh_0.ncgr",
	"prtl_sciexh_1.ncgr",
	"prtl_sciexh_2.ncgr",
	"prtl_sciexh_3.ncgr",
	"prtl_scihap_0.ncgr",
	"prtl_scihap_1.ncgr",
	"prtl_scihap_2.ncgr",
	"prtl_scihap_3.ncgr",
	"prtl_scyclm_0.ncgr",
	"prtl_scyclm_1.ncgr",
	"prtl_scyclm_2.ncgr",
	"prtl_scyclm_3.ncgr",
	"prtl_scygen_0.ncgr",
	"prtl_scygen_1.ncgr",
	"prtl_scygen_2.ncgr",
	"prtl_scygen_3.ncgr",
	"prtl_scylla.nclr",
	"prtl_sdwdef_0.ncgr",
	"prtl_sdwdef_1.ncgr",
	"prtl_sdwdef_2.ncgr",
	"prtl_sdwdef_3.ncgr",
	"prtl_sdwgen_0.ncgr",
	"prtl_sdwgen_1.ncgr",
	"prtl_sdwgen_2.ncgr",
	"prtl_sdwgen_3.ncgr",
	"prtl_sdwmad_0.ncgr",
	"prtl_sdwmad_1.ncgr",
	"prtl_sdwmad_2.ncgr",
	"prtl_sdwmad_3.ncgr",
	"prtl_sdwsmg_0.ncgr",
	"prtl_sdwsmg_1.ncgr",
	"prtl_sdwsmg_2.ncgr",
	"prtl_sdwsmg_3.ncgr",
	"prtl_shade.nclr",
	"prtl_shadow.nclr",
	"prtl_shddef_0.ncgr",
	"prtl_shddef_1.ncgr",
	"prtl_shddef_2.ncgr",
	"prtl_shddef_3.ncgr",
	"prtl_shddet_0.ncgr",
	"prtl_shddet_1.ncgr",
	"prtl_shddet_2.ncgr",
	"prtl_shddet_3.ncgr",
	"prtl_shdgen_0.ncgr",
	"prtl_shdgen_1.ncgr",
	"prtl_shdgen_2.ncgr",
	"prtl_shdgen_3.ncgr",
	"prtl_shdhel_0.ncgr",
	"prtl_shdhel_1.ncgr",
	"prtl_shdhel_2.ncgr",
	"prtl_shdhel_3.ncgr",
	"prtl_shdint_0.ncgr",
	"prtl_shdint_1.ncgr",
	"prtl_shdint_2.ncgr",
	"prtl_shdint_3.ncgr",
	"prtl_shdmad_0.ncgr",
	"prtl_shdmad_1.ncgr",
	"prtl_shdmad_2.ncgr",
	"prtl_shdmad_3.ncgr",
	"prtl_shdsht_0.ncgr",
	"prtl_shdsht_1.ncgr",
	"prtl_shdsht_2.ncgr",
	"prtl_shdsht_3.ncgr",
	"prtl_shdstg_0.ncgr",
	"prtl_shdstg_1.ncgr",
	"prtl_shdstg_2.ncgr",
	"prtl_shdstg_3.ncgr",
	"prtl_shdtht_0.ncgr",
	"prtl_shdtht_1.ncgr",
	"prtl_shdtht_2.ncgr",
	"prtl_shdtht_3.ncgr",
	"prtl_shopkeeper.nclr",
	"prtl_skpcon_0.ncgr",
	"prtl_skpcon_1.ncgr",
	"prtl_skpcon_2.ncgr",
	"prtl_skpcon_3.ncgr",
	"prtl_skpgen_0.ncgr",
	"prtl_skpgen_1.ncgr",
	"prtl_skpgen_2.ncgr",
	"prtl_skpgen_3.ncgr",
	"prtl_skphap_0.ncgr",
	"prtl_skphap_1.ncgr",
	"prtl_skphap_2.ncgr",
	"prtl_skphap_3.ncgr",
	"prtl_sonic.nclr",
	"prtl_sonicamu_0.ncgr",
	"prtl_sonicamu_1.ncgr",
	"prtl_sonicamu_2.ncgr",
	"prtl_sonicamu_3.ncgr",
	"prtl_soniccon_0.ncgr",
	"prtl_soniccon_1.ncgr",
	"prtl_soniccon_2.ncgr",
	"prtl_soniccon_3.ncgr",
	"prtl_sonicdet_0.ncgr",
	"prtl_sonicdet_1.ncgr",
	"prtl_sonicdet_2.ncgr",
	"prtl_sonicdet_3.ncgr",
	"prtl_sonicdis_0.ncgr",
	"prtl_sonicdis_1.ncgr",
	"prtl_sonicdis_2.ncgr",
	"prtl_sonicdis_3.ncgr",
	"prtl_sonicgen_0.ncgr",
	"prtl_sonicgen_1.ncgr",
	"prtl_sonicgen_2.ncgr",
	"prtl_sonicgen_3.ncgr",
	"prtl_sonicimp_0.ncgr",
	"prtl_sonicimp_1.ncgr",
	"prtl_sonicimp_2.ncgr",
	"prtl_sonicimp_3.ncgr",
	"prtl_sonicinq_0.ncgr",
	"prtl_sonicinq_1.ncgr",
	"prtl_sonicinq_2.ncgr",
	"prtl_sonicinq_3.ncgr",
	"prtl_sonicmad_0.ncgr",
	"prtl_sonicmad_1.ncgr",
	"prtl_sonicmad_2.ncgr",
	"prtl_sonicmad_3.ncgr",
	"prtl_sonicsle_0.ncgr",
	"prtl_sonicsle_1.ncgr",
	"prtl_sonicsle_2.ncgr",
	"prtl_sonicsle_3.ncgr",
	"prtl_sonicsmg_0.ncgr",
	"prtl_sonicsmg_1.ncgr",
	"prtl_sonicsmg_2.ncgr",
	"prtl_sonicsmg_3.ncgr",
	"prtl_swatbot.nclr",
	"prtl_syraxgen_0.ncgr",
	"prtl_syraxgen_1.ncgr",
	"prtl_syraxgen_2.ncgr",
	"prtl_syraxgen_3.ncgr",
	"prtl_tailscon_0.ncgr",
	"prtl_tailscon_1.ncgr",
	"prtl_tailscon_2.ncgr",
	"prtl_tailscon_3.ncgr",
	"prtl_tailsdet_0.ncgr",
	"prtl_tailsdet_1.ncgr",
	"prtl_tailsdet_2.ncgr",
	"prtl_tailsdet_3.ncgr",
	"prtl_tailsexc_0.ncgr",
	"prtl_tailsexc_1.ncgr",
	"prtl_tailsexc_2.ncgr",
	"prtl_tailsexc_3.ncgr",
	"prtl_tailsgen_0.ncgr",
	"prtl_tailsgen_1.ncgr",
	"prtl_tailsgen_2.ncgr",
	"prtl_tailsgen_3.ncgr",
	"prtl_tailsinq_0.ncgr",
	"prtl_tailsinq_1.ncgr",
	"prtl_tailsinq_2.ncgr",
	"prtl_tailsinq_3.ncgr",
	"prtl_tailssca_0.ncgr",
	"prtl_tailssca_1.ncgr",
	"prtl_tailssca_2.ncgr",
	"prtl_tailssca_3.ncgr",
	"prtl_tailsugh_0.ncgr",
	"prtl_tailsugh_1.ncgr",
	"prtl_tailsugh_2.ncgr",
	"prtl_tailsugh_3.ncgr",
	"prtl_tal.nclr",
	"prtl_tdad.nclr",
	"prtl_tdadgen_0.ncgr",
	"prtl_tdadgen_1.ncgr",
	"prtl_tdadgen_2.ncgr",
	"prtl_tdadgen_3.ncgr",
	"prtl_tdadhap_0.ncgr",
	"prtl_tdadhap_1.ncgr",
	"prtl_tdadhap_2.ncgr",
	"prtl_tdadhap_3.ncgr",
	"prtl_tdadsad_0.ncgr",
	"prtl_tdadsad_1.ncgr",
	"prtl_tdadsad_2.ncgr",
	"prtl_tdadsad_3.ncgr",
	"prtl_tdadsca_0.ncgr",
	"prtl_tdadsca_1.ncgr",
	"prtl_tdadsca_2.ncgr",
	"prtl_tdadsca_3.ncgr",
	"prtl_telgen_0.ncgr",
	"prtl_telgen_1.ncgr",
	"prtl_telmad_0.ncgr",
	"prtl_telmad_1.ncgr",
	"prtl_thbgen_0.ncgr",
	"prtl_thbgen_1.ncgr",
	"prtl_thbgen_2.ncgr",
	"prtl_thbgen_3.ncgr",
	"prtl_thbhap_0.ncgr",
	"prtl_thbhap_1.ncgr",
	"prtl_thbhap_2.ncgr",
	"prtl_thbhap_3.ncgr",
	"prtl_thbovr_0.ncgr",
	"prtl_thbovr_1.ncgr",
	"prtl_thbovr_2.ncgr",
	"prtl_thbovr_3.ncgr",
	"prtl_thbsad_0.ncgr",
	"prtl_thbsad_1.ncgr",
	"prtl_thbsad_2.ncgr",
	"prtl_thbsad_3.ncgr",
	"prtl_thxdef_0.ncgr",
	"prtl_thxdef_1.ncgr",
	"prtl_thxdef_2.ncgr",
	"prtl_thxdef_3.ncgr",
	"prtl_thxgen_0.ncgr",
	"prtl_thxgen_1.ncgr",
	"prtl_thxgen_2.ncgr",
	"prtl_thxgen_3.ncgr",
	"prtl_tim.nclr",
	"prtl_timcal_0.ncgr",
	"prtl_timcal_1.ncgr",
	"prtl_timcal_2.ncgr",
	"prtl_timcal_3.ncgr",
	"prtl_timgen_0.ncgr",
	"prtl_timgen_1.ncgr",
	"prtl_timgen_2.ncgr",
	"prtl_timgen_3.ncgr",
	"prtl_timsca_0.ncgr",
	"prtl_timsca_1.ncgr",
	"prtl_timsca_2.ncgr",
	"prtl_timsca_3.ncgr",
	"prtl_txcgen_0.ncgr",
	"prtl_txcgen_1.ncgr",
	"prtl_txcgen_2.ncgr",
	"prtl_txcgen_3.ncgr",
	"prtl_txm.nclr",
	"prtl_txmgen_0.ncgr",
	"prtl_txmgen_1.ncgr",
	"prtl_txmgen_2.ncgr",
	"prtl_txmgen_3.ncgr",
	"prtl_txmmad_0.ncgr",
	"prtl_txmmad_1.ncgr",
	"prtl_txmmad_2.ncgr",
	"prtl_txmmad_3.ncgr",
	"prtl_txmvar_0.ncgr",
	"prtl_txmvar_1.ncgr",
	"prtl_txmvar_2.ncgr",
	"prtl_txmvar_3.ncgr",
	"prtl_txrgen_0.ncgr",
	"prtl_txrgen_1.ncgr",
	"prtl_txrgen_2.ncgr",
	"prtl_txrgen_3.ncgr",
	"prtl_txrhap_0.ncgr",
	"prtl_txrhap_1.ncgr",
	"prtl_txrhap_2.ncgr",
	"prtl_txrhap_3.ncgr",
	"prtl_txrhum_0.ncgr",
	"prtl_txrhum_1.ncgr",
	"prtl_txrhum_2.ncgr",
	"prtl_txrhum_3.ncgr",
	"prtl_txsgen_0.ncgr",
	"prtl_txsgen_1.ncgr",
	"prtl_txsgen_2.ncgr",
	"prtl_txsgen_3.ncgr",
	"prtl_tyxis.nclr",
	"prtl_vecgen_0.ncgr",
	"prtl_vecgen_1.ncgr",
	"prtl_vecgen_2.ncgr",
	"prtl_vecgen_3.ncgr",
	"prtl_vector.nclr",
	"prtl_voxai01.nclr",
	"prtl_voxai02.nclr",
	"prtl_voxmerc.nclr",
	"prtl_vxcbadgen_0.ncgr",
	"prtl_vxcbadgen_1.ncgr",
	"prtl_vxcbadgen_2.ncgr",
	"prtl_vxcbadgen_3.ncgr",
	"prtl_vxccitgen_0.ncgr",
	"prtl_vxccitgen_1.ncgr",
	"prtl_vxccitgen_2.ncgr",
	"prtl_vxccitgen_3.ncgr",
	"prtl_vxcleugen_0.ncgr",
	"prtl_vxcleugen_1.ncgr",
	"prtl_vxcleugen_2.ncgr",
	"prtl_vxcleugen_3.ncgr",
	"prtl_vxcliggen_0.ncgr",
	"prtl_vxcliggen_1.ncgr",
	"prtl_vxcliggen_2.ncgr",
	"prtl_vxcliggen_3.ncgr",
	"prtl_vxcrblgen_0.ncgr",
	"prtl_vxcrblgen_1.ncgr",
	"prtl_vxcrblgen_2.ncgr",
	"prtl_vxcrblgen_3.ncgr",
	"prtl_vxcriagen_0.ncgr",
	"prtl_vxcriagen_1.ncgr",
	"prtl_vxcriagen_2.ncgr",
	"prtl_vxcriagen_3.ncgr",
	"prtl_vxmgen_0.ncgr",
	"prtl_vxmgen_1.ncgr",
	"prtl_vxmgen_2.ncgr",
	"prtl_vxmgen_3.ncgr",
	"prtl_wdmnexh_0.ncgr",
	"prtl_wdmnexh_1.ncgr",
	"prtl_wdmnexh_2.ncgr",
	"prtl_wdmnexh_3.ncgr",
	"prtl_wdmnhap_0.ncgr",
	"prtl_wdmnhap_1.ncgr",
	"prtl_wdmnhap_2.ncgr",
	"prtl_wdmnhap_3.ncgr",
	"prtl_wkrrel_0.ncgr",
	"prtl_wkrrel_1.ncgr",
	"prtl_wkrrel_2.ncgr",
	"prtl_wkrrel_3.ncgr",
	"prtl_wkrsca_0.ncgr",
	"prtl_wkrsca_1.ncgr",
	"prtl_wkrsca_2.ncgr",
	"prtl_wkrsca_3.ncgr",
	"prtl_wkrstu_0.ncgr",
	"prtl_wkrstu_1.ncgr",
	"prtl_wkrstu_2.ncgr",
	"prtl_wkrstu_3.ncgr",
	"prtl_wsgrel_0.ncgr",
	"prtl_wsgrel_1.ncgr",
	"prtl_wsgrel_2.ncgr",
	"prtl_wsgrel_3.ncgr",
	"prtl_wsgsca_0.ncgr",
	"prtl_wsgsca_1.ncgr",
	"prtl_wsgsca_2.ncgr",
	"prtl_wsgsca_3.ncgr",
	"prtl_wsprel_0.ncgr",
	"prtl_wsprel_1.ncgr",
	"prtl_wspsad_0.ncgr",
	"prtl_wspsad_1.ncgr",
	"prtl_wspsca_0.ncgr",
	"prtl_wspsca_1.ncgr",
	"prt_ce_blu.ncgr",
	"prt_ce_cyn.ncgr",
	"prt_ce_gre.ncgr",
	"prt_ce_gry.ncgr",
	"prt_ce_mag.ncgr",
	"prt_ce_org.ncgr",
	"prt_ce_pul.ncgr",
	"prt_ce_red.ncgr",
	"prt_ce_yel.ncgr",
	"prt_mp_amy.ncgr",
	"prt_mp_big.ncgr",
	"prt_mp_egg.ncgr",
	"prt_mp_knu.ncgr",
	"prt_mp_rou.ncgr",
	"prt_mp_sdw.ncgr",
	"prt_mp_son.ncgr",
	"prt_mp_tai.ncgr",
	"prt_se_arm.ncgr",
	"prt_se_armdn.ncgr",
	"prt_se_armdr.ncgr",
	"prt_se_astdr.ncgr",
	"prt_se_bboar.ncgr",
	"prt_se_bmbpw.ncgr",
	"prt_se_boar.ncgr",
	"prt_se_brdrh.ncgr",
	"prt_se_chary.ncgr",
	"prt_se_ecm.ncgr",
	"prt_se_eggbt.ncgr",
	"prt_se_evshd.ncgr",
	"prt_se_gentl.ncgr",
	"prt_se_gizda.ncgr",
	"prt_se_gizdb.ncgr",
	"prt_se_grdpw.ncgr",
	"prt_se_gtwrm.ncgr",
	"prt_se_gunpw.ncgr",
	"prt_se_kobed.ncgr",
	"prt_se_kro.ncgr",
	"prt_se_lazdr.ncgr",
	"prt_se_leuco.ncgr",
	"prt_se_ligia.ncgr",
	"prt_se_mllpd.ncgr",
	"prt_se_nctel.ncgr",
	"prt_se_nctfl.ncgr",
	"prt_se_nctsc.ncgr",
	"prt_se_nctsl.ncgr",
	"prt_se_nrrwa.ncgr",
	"prt_se_nrrwo.ncgr",
	"prt_se_prixa.ncgr",
	"prt_se_prixb.ncgr",
	"prt_se_pylon.ncgr",
	"prt_se_raidn.ncgr",
	"prt_se_rhk.ncgr",
	"prt_se_robar.ncgr",
	"prt_se_sbt.ncgr",
	"prt_se_scorp.ncgr",
	"prt_se_scyla.ncgr",
	"prt_se_shp.ncgr",
	"prt_se_stdrn.ncgr",
	"prt_se_sudrn.ncgr",
	"prt_se_swatb.ncgr",
	"prt_se_swt.ncgr",
	"prt_se_thelx.ncgr",
	"prt_se_tyxwa.ncgr",
	"prt_se_voxct.ncgr",
	"prt_se_voxel.ncgr",
	"prt_se_wasn.ncgr",
	"prt_se_wasp.ncgr",
	"prt_se_wasq.ncgr",
	"prt_sp_amy.ncgr",
	"prt_sp_big.ncgr",
	"prt_sp_cre.ncgr",
	"prt_sp_egg.ncgr",
	"prt_sp_knu.ncgr",
	"prt_sp_ome.ncgr",
	"prt_sp_rou.ncgr",
	"prt_sp_sdw.ncgr",
	"prt_sp_she.ncgr",
	"prt_sp_son.ncgr",
	"prt_sp_ssn.ncgr",
	"prt_sp_tai.ncgr",
	"prt_tp_amy.ncgr",
	"prt_tp_big.ncgr",
	"prt_tp_chao.ncgr",
	"prt_tp_che.ncgr",
	"prt_tp_cre.ncgr",
	"prt_tp_egg.ncgr",
	"prt_tp_e_amy.ncgr",
	"prt_tp_e_big.ncgr",
	"prt_tp_e_chao.ncgr",
	"prt_tp_e_che.ncgr",
	"prt_tp_e_cre.ncgr",
	"prt_tp_e_egg.ncgr",
	"prt_tp_e_knu.ncgr",
	"prt_tp_e_ome.ncgr",
	"prt_tp_e_rng.ncgr",
	"prt_tp_e_rou.ncgr",
	"prt_tp_e_sdw.ncgr",
	"prt_tp_e_she.ncgr",
	"prt_tp_e_son.ncgr",
	"prt_tp_e_tai.ncgr",
	"prt_tp_knu.ncgr",
	"prt_tp_m_amy.ncgr",
	"prt_tp_m_big.ncgr",
	"prt_tp_m_cre.ncgr",
	"prt_tp_m_egg.ncgr",
	"prt_tp_m_knu.ncgr",
	"prt_tp_m_ome.ncgr",
	"prt_tp_m_rou.ncgr",
	"prt_tp_m_sdw.ncgr",
	"prt_tp_m_she.ncgr",
	"prt_tp_m_son.ncgr",
	"prt_tp_m_tai.ncgr",
	"prt_tp_ome.ncgr",
	"prt_tp_rng.ncgr",
	"prt_tp_rou.ncgr",
	"prt_tp_sdw.ncgr",
	"prt_tp_she.ncgr",
	"prt_tp_son.ncgr",
	"prt_tp_tai.ncgr",
	"puzzlemode.gda",
	"pzl_bridgeestablish.gff",
	"pzl_craneestablish.gff",
	"pzl_cranerotend.gff",
	"pzl_kronestablish.gff",
	"pzl_metroestablish.gff",
	"pzl_monitorestablish.gff",
	"pzl_ventsestablish.gff",
	"pzl_voxestablish.gff",
	"pzl_zoahestablish.gff",
	"questlogselectiongui.gui",
	"que_aa.nsbmd",
	"que_aa.nsbta",
	"que_aa.nsbtx",
	"que_ex_idle.nsbca",
	"que_transform.nsbca",
	"que_trfm_1.nsbca",
	"que_trfm_2.nsbca",
	"randitems.gda",
	"rax_aa.nsbmd",
	"rax_aa.nsbtx",
	"rax_cb_attack.nsbca",
	"rax_cb_attackend.nsbca",
	"rax_cb_blockin.nsbca",
	"rax_cb_blockout.nsbca",
	"rax_cb_counter.nsbca",
	"rax_cb_damage.nsbca",
	"rax_cb_dead.nsbca",
	"rax_cb_getup.nsbca",
	"rax_cb_idle.nsbca",
	"rax_cb_kd.nsbca",
	"rax_cb_pattack.nsbca",
	"rax_ex_idle.nsbca",
	"rax_ex_run.nsbca",
	"rax_ex_walk.nsbca",
	"realtime.gda",
	"realtimebuttons.gui",
	"realtimetutone.gda",
	"realtimetutthree.gda",
	"realtimetuttwo.gda",
	"realtimewidgets.gda",
	"realtime_tutorial_bg_invert.tga",
	"realtime_tutorial_follow_bg.tga",
	"realtime_tutorial_smash_bg.tga",
	"realtime_tutorial_touch_bg.tga",
	"reward.gui",
	"rewardanims.gda",
	"rewardchest_hold.nbfp",
	"rewardchest_hold.nbfs",
	"rewardlist.gui",
	"rewards.gda",
	"reward_bg.tga",
	"reward_scrollbg.tga",
	"reward_ts.gui",
	"rhk_cb_attack.nsbca",
	"rhk_cb_attackc.nsbca",
	"rhk_cb_attackend.nsbca",
	"rhk_cb_counter.nsbca",
	"rhk_cb_damage.nsbca",
	"rhk_cb_dead.nsbca",
	"rhk_cb_getup.nsbca",
	"rhk_cb_idle.nsbca",
	"rhk_cb_kd.nsbca",
	"rhk_cb_pattack.nsbca",
	"rhk_cb_pattack2.nsbca",
	"rhk_ex_damage.nsbca",
	"rhk_ex_fall.nsbca",
	"rhk_ex_glide.nsbca",
	"rhk_ex_idle.nsbca",
	"rhk_ex_jump.nsbca",
	"rhk_ex_liftoff.nsbca",
	"rhk_ex_run.nsbca",
	"rhk_ex_walk.nsbca",
	"ringsitems.gui",
	"roundstart.gui",
	"roundstarttop.gui",
	"rou_cb_attack.nsbca",
	"rou_cb_attackc.nsbca",
	"rou_cb_attackend.nsbca",
	"rou_cb_blockc.nsbca",
	"rou_cb_blockin.nsbca",
	"rou_cb_blockout.nsbca",
	"rou_cb_counter.nsbca",
	"rou_cb_damage.nsbca",
	"rou_cb_dead.nsbca",
	"rou_cb_getup.nsbca",
	"rou_cb_idle.nsbca",
	"rou_cb_kd.nsbca",
	"rou_cb_pattack01.nsbca",
	"rou_cb_pattack02.nsbca",
	"rou_cb_rund.nsbca",
	"rou_cb_stunned.nsbca",
	"rou_cb_support01.nsbca",
	"rou_cb_support02.nsbca",
	"rou_cb_support03.nsbca",
	"rou_cb_victory.nsbca",
	"rou_cb_victoryin.nsbca",
	"rou_ex_fall.nsbca",
	"rou_ex_fly.nsbca",
	"rou_ex_flyin.nsbca",
	"rou_ex_flyout.nsbca",
	"rou_ex_idle.nsbca",
	"rou_ex_run.nsbca",
	"rou_ex_twitch.nsbca",
	"rou_ex_walk.nsbca",
	"rpg_buttonbg.ncgr",
	"rpg_crosscircle.ncgr",
	"rpg_downarrow.ncgr",
	"rpg_opencircle.ncgr",
	"rpg_redrightarrow.ncgr",
	"rpg_uparrow.ncgr",
	"rpg_whiterightarrow.ncgr",
	"runaway.gui",
	"rwd_lgbtn_di00.ncgr",
	"rwd_lgbtn_di01.ncgr",
	"rwd_lgbtn_hi00.ncgr",
	"rwd_lgbtn_hi01.ncgr",
	"rwd_tlgbx_ms00.ncgr",
	"rwd_tlgbx_ms01.ncgr",
	"rwd_tlgbx_ms02.ncgr",
	"rwd_tlgbx_ms10.ncgr",
	"rwd_tlgbx_ms11.ncgr",
	"rwd_tlgbx_ms12.ncgr",
	"rwd_tsmbx_of00.ncgr",
	"rwd_tsmbx_of01.ncgr",
	"rwd_tsmbx_of02.ncgr",
	"rwd_tsmbx_on00.ncgr",
	"rwd_tsmbx_on01.ncgr",
	"rwd_tsmbx_on02.ncgr",
	"rwd_ttxtb_ms00.ncgr",
	"rwd_ttxtb_ms01.ncgr",
	"rwd_ttxtb_ms02.ncgr",
	"savegui_bs_01.tga",
	"savegui_bs_02.tga",
	"savegui_ts_01.tga",
	"sbg.are",
	"sco_cb_attack.nsbca",
	"sco_cb_attackc.nsbca",
	"sco_cb_attackend.nsbca",
	"sco_cb_counter.nsbca",
	"sco_cb_damage.nsbca",
	"sco_cb_dead.nsbca",
	"sco_cb_getup.nsbca",
	"sco_cb_idle.nsbca",
	"sco_cb_kd.nsbca",
	"sco_cb_pattack.nsbca",
	"sco_ex_damage.nsbca",
	"sco_ex_fall.nsbca",
	"sco_ex_jump.nsbca",
	"sco_ex_run.nsbca",
	"sco_ex_walk.nsbca",
	"screenwipe.gui",
	"screenwipewhite.gui",
	"scrollbg01.tga",
	"scrollingbg.gda",
	"se_nw.gff",
	"shaball_aa.nsbmd",
	"shaball_aa.nsbtx",
	"shadball.nsbta",
	"shadball.nsbtp",
	"sha_cb_attack.nsbca",
	"sha_cb_attackc.nsbca",
	"sha_cb_attackend.nsbca",
	"sha_cb_block.nsbca",
	"sha_cb_blockc.nsbca",
	"sha_cb_blockd.nsbca",
	"sha_cb_blockin.nsbca",
	"sha_cb_blockout.nsbca",
	"sha_cb_counter.nsbca",
	"sha_cb_damage.nsbca",
	"sha_cb_dead.nsbca",
	"sha_cb_getup.nsbca",
	"sha_cb_idle.nsbca",
	"sha_cb_kd.nsbca",
	"sha_cb_pattack.nsbca",
	"sha_cb_pattack01.nsbca",
	"sha_cb_pattack02.nsbca",
	"sha_cb_pattack03.nsbca",
	"sha_cb_rund.nsbca",
	"sha_cb_stunned.nsbca",
	"sha_cb_victory.nsbca",
	"sha_cb_victoryin.nsbca",
	"sha_ex_fall.nsbca",
	"sha_ex_idle.nsbca",
	"sha_ex_jump.nsbca",
	"sha_ex_jumpair.nsbca",
	"sha_ex_run.nsbca",
	"sha_ex_twitch.nsbca",
	"sha_ex_walk.nsbca",
	"she_aa.nsbmd",
	"she_aa.nsbtx",
	"she_ab.nsbmd",
	"she_ab.nsbtx",
	"she_cb_attack.nsbca",
	"she_cb_attackc.nsbca",
	"she_cb_attackend.nsbca",
	"she_cb_blockc.nsbca",
	"she_cb_blockin.nsbca",
	"she_cb_blockout.nsbca",
	"she_cb_counter.nsbca",
	"she_cb_damage.nsbca",
	"she_cb_dead.nsbca",
	"she_cb_getup.nsbca",
	"she_cb_idle.nsbca",
	"she_cb_kd.nsbca",
	"she_cb_pattack01.nsbca",
	"she_cb_pattack02.nsbca",
	"she_cb_rund.nsbca",
	"she_cb_stunned.nsbca",
	"she_cb_victory.nsbca",
	"she_cb_victoryin.nsbca",
	"she_ex_fall.nsbca",
	"she_ex_idle.nsbca",
	"she_ex_run.nsbca",
	"she_ex_stealth.nsbca",
	"she_ex_twitch.nsbca",
	"she_ex_walk.nsbca",
	"she_sta.nsbmd",
	"she_sta.nsbtx",
	"she_stb.nsbmd",
	"she_stb.nsbtx",
	"shpkron_aa.nsbmd",
	"shpkron_aa.nsbtx",
	"shp_aa.nsbmd",
	"shp_aa.nsbtx",
	"shp_cb_attack.nsbca",
	"shp_cb_attackc.nsbca",
	"shp_cb_attackend.nsbca",
	"shp_cb_blockent.nsbca",
	"shp_cb_blockexit.nsbca",
	"shp_cb_blockhit.nsbca",
	"shp_cb_blockidle.nsbca",
	"shp_cb_counter.nsbca",
	"shp_cb_damage.nsbca",
	"shp_cb_dead.nsbca",
	"shp_cb_death.nsbca",
	"shp_cb_getup.nsbca",
	"shp_cb_idle.nsbca",
	"shp_cb_kd.nsbca",
	"shp_cb_pattack.nsbca",
	"shp_ex_damage.nsbca",
	"shp_ex_fall.nsbca",
	"shp_ex_idle.nsbca",
	"shp_ex_jump.nsbca",
	"shp_ex_run.nsbca",
	"shp_ex_walk.nsbca",
	"singlescreencamera.gff",
	"slg_aa.nsbmd",
	"slg_aa.nsbtx",
	"slg_cb_attack.nsbca",
	"slg_cb_attackend.nsbca",
	"slg_cb_counter.nsbca",
	"slg_cb_damage.nsbca",
	"slg_cb_dead.nsbca",
	"slg_cb_getup.nsbca",
	"slg_cb_idle.nsbca",
	"slg_cb_kd.nsbca",
	"slg_cb_pattack.nsbca",
	"slg_ex_idle.nsbca",
	"slg_ex_run.nsbca",
	"slg_ex_walk.nsbca",
	"slg_walk.nsbtp",
	"sonic.gda",
	"sonic_aa_p.ncgr",
	"son_atomicstrike.gff",
	"son_axekick.gff",
	"son_bluebomber.gff",
	"son_bluebomber_0.gff",
	"son_bluebomber_1.gff",
	"son_cb_attack.nsbca",
	"son_cb_attackc.nsbca",
	"son_cb_attackend.nsbca",
	"son_cb_block.nsbca",
	"son_cb_blockc.nsbca",
	"son_cb_blockd.nsbca",
	"son_cb_blockin.nsbca",
	"son_cb_blockout.nsbca",
	"son_cb_counter.nsbca",
	"son_cb_damage.nsbca",
	"son_cb_dead.nsbca",
	"son_cb_deadidle.nsbca",
	"son_cb_getup.nsbca",
	"son_cb_idle.nsbca",
	"son_cb_kd.nsbca",
	"son_cb_pattack01.nsbca",
	"son_cb_pattack02.nsbca",
	"son_cb_rund.nsbca",
	"son_cb_stunned.nsbca",
	"son_cb_victory.nsbca",
	"son_cb_victoryin.nsbca",
	"son_ex_bounce.nsbca",
	"son_ex_climb.nsbca",
	"son_ex_dash.nsbca",
	"son_ex_death.nsbca",
	"son_ex_fall.nsbca",
	"son_ex_give.nsbca",
	"son_ex_happy.nsbca",
	"son_ex_idle.nsbca",
	"son_ex_jump.nsbca",
	"son_ex_jumpair.nsbca",
	"son_ex_loop.nsbca",
	"son_ex_off.nsbca",
	"son_ex_run.nsbca",
	"son_ex_sad.nsbca",
	"son_ex_slideidle.nsbca",
	"son_ex_slidein.nsbca",
	"son_ex_slideout.nsbca",
	"son_ex_stealth.nsbca",
	"son_ex_twitch.nsbca",
	"son_ex_walk.nsbca",
	"son_whirlwind.gff",
	"son_whirlwind_1.gff",
	"son_whirlwind_3.gff",
	"spell1.spl",
	"spell10.spl",
	"spell11.spl",
	"spell12.spl",
	"spell13.spl",
	"spell14.spl",
	"spell15.spl",
	"spell16.spl",
	"spell17.spl",
	"spell18.spl",
	"spell19.spl",
	"spell2.spl",
	"spell20.spl",
	"spell21.spl",
	"spell22.spl",
	"spell23.spl",
	"spell24.spl",
	"spell25.spl",
	"spell26.spl",
	"spell27.spl",
	"spell28.spl",
	"spell29.spl",
	"spell3.spl",
	"spell30.spl",
	"spell31.spl",
	"spell32.spl",
	"spell33.spl",
	"spell4.spl",
	"spell5.spl",
	"spell6.spl",
	"spell7.spl",
	"spell8.spl",
	"spell9.spl",
	"spells.gda",
	"spell_adrenaline.spl",
	"spell_adrenaline_2.spl",
	"spell_adrenaline_3.spl",
	"spell_antidote_all.spl",
	"spell_antidote_all_2.spl",
	"spell_antidote_all_3.spl",
	"spell_big_regen.spl",
	"spell_big_regen_2.spl",
	"spell_big_regen_3.spl",
	"spell_blowkiss.spl",
	"spell_blowkiss_2.spl",
	"spell_blowkiss_3.spl",
	"spell_cloak.spl",
	"spell_cloak_2.spl",
	"spell_cloak_3.spl",
	"spell_coverd.spl",
	"spell_coverd_2.spl",
	"spell_coverd_3.spl",
	"spell_covero.spl",
	"spell_covero_2.spl",
	"spell_covero_3.spl",
	"spell_cure_all.spl",
	"spell_cure_all_2.spl",
	"spell_cure_all_3.spl",
	"spell_cursed.spl",
	"spell_cursed_2.spl",
	"spell_cursed_3.spl",
	"spell_death.spl",
	"spell_distracted.spl",
	"spell_distracted_2.spl",
	"spell_distracted_3.spl",
	"spell_distracted_all.spl",
	"spell_distracted_all_2.spl",
	"spell_distracted_all_3.spl",
	"spell_empowered.spl",
	"spell_empowered_2.spl",
	"spell_empowered_3.spl",
	"spell_flashbang.spl",
	"spell_flashbang_2.spl",
	"spell_flashbang_3.spl",
	"spell_focussed.spl",
	"spell_focussed_2.spl",
	"spell_focussed_3.spl",
	"spell_fortified.spl",
	"spell_fortified_2.spl",
	"spell_fortified_3.spl",
	"spell_hyper.spl",
	"spell_hyper_2.spl",
	"spell_hyper_3.spl",
	"spell_immunity.spl",
	"spell_int_animal_fly.spl",
	"spell_int_animal_land.spl",
	"spell_int_charyb_water.spl",
	"spell_int_final_ix.spl",
	"spell_int_gizoidshield.spl",
	"spell_int_kron.spl",
	"spell_int_nocturn_water.spl",
	"spell_int_nrrgal.spl",
	"spell_int_robot_fly.spl",
	"spell_int_robot_land.spl",
	"spell_int_super_sonic.spl",
	"spell_int_voxai.spl",
	"spell_int_zoah.spl",
	"spell_lucky.spl",
	"spell_lucky_2.spl",
	"spell_lucky_3.spl",
	"spell_lucky_all.spl",
	"spell_lucky_all_2.spl",
	"spell_lucky_all_3.spl",
	"spell_medibot.spl",
	"spell_medibot_2.spl",
	"spell_medibot_3.spl",
	"spell_medibot_timed.spl",
	"spell_medibot_timed_2.spl",
	"spell_medibot_timed_3.spl",
	"spell_poison.spl",
	"spell_poison_dart.spl",
	"spell_refresh_all.spl",
	"spell_refresh_all_2.spl",
	"spell_refresh_all_3.spl",
	"spell_reverse_engineer.spl",
	"spell_reverse_engineer_2.spl",
	"spell_reverse_engineer_3.spl",
	"spell_revive_all.spl",
	"spell_revive_all_2.spl",
	"spell_revive_all_3.spl",
	"spell_shieldbot.spl",
	"spell_shieldbot_2.spl",
	"spell_shieldbot_3.spl",
	"spell_sluggish.spl",
	"spell_sluggish_2.spl",
	"spell_sluggish_3.spl",
	"spell_steal_ring.spl",
	"spell_stun.spl",
	"spell_stun_all.spl",
	"spell_stun_distracted.spl",
	"spell_target_all.spl",
	"spell_temporalfield.spl",
	"spell_temporalfield_2.spl",
	"spell_temporalfield_3.spl",
	"spell_tinker.spl",
	"spell_tinker_2.spl",
	"spell_tinker_3.spl",
	"spell_tough.spl",
	"spell_tough_2.spl",
	"spell_tough_3.spl",
	"spell_vulnerable.spl",
	"spell_vulnerable_2.spl",
	"spell_vulnerable_3.spl",
	"spell_weakened.spl",
	"spell_weakened_2.spl",
	"spell_weakened_3.spl",
	"spell_weakened_all.spl",
	"spell_weakened_distracted.spl",
	"spinball.nsbmd",
	"spinball.nsbta",
	"spinball.nsbtp",
	"spinball.nsbtx",
	"splashbuttons.gui",
	"splashlists.gda",
	"splash_version.gui",
	"squads.gda",
	"ssb_aa.nsbmd",
	"ssb_aa.nsbta",
	"ssb_aa.nsbtp",
	"ssb_aa.nsbtx",
	"ssb_cb_pattack.nsbca",
	"ssf_tlgbx_ms00.ncgr",
	"ssf_tlgbx_ms01.ncgr",
	"ssf_tlgbx_ms02.ncgr",
	"ssf_tlgbx_ms10.ncgr",
	"ssf_tlgbx_ms11.ncgr",
	"ssf_tlgbx_ms12.ncgr",
	"ssf_tlgbx_ms20.ncgr",
	"ssf_tlgbx_ms21.ncgr",
	"ssf_tlgbx_ms22.ncgr",
	"ssf_tlgbx_ms30.ncgr",
	"ssf_tlgbx_ms31.ncgr",
	"ssf_tlgbx_ms32.ncgr",
	"sso_aa.nsbmd",
	"sso_aa.nsbtx",
	"sso_cb_idle.nsbca",
	"sso_cb_pattack.nsbca",
	"sso_ex_idle.nsbca",
	"sso_ex_run.nsbca",
	"sso_ex_walk.nsbca",
	"startupscrbot.tga",
	"startupscreenwotxt.tga",
	"star_and_check.gui",
	"statinfos.gda",
	"statredirect.gda",
	"statsinfocreature.gda",
	"statsinfoprojectile.gda",
	"statsinfosquad.gda",
	"statsinfotest.gda",
	"statsinfotrigger.gda",
	"statusbar.ncgr",
	"statuses.gda",
	"statusframe_l.ncgr",
	"statusframe_r.ncgr",
	"store1.gda",
	"store2.gda",
	"store3.gda",
	"store4.gda",
	"store5.gda",
	"storecharactertab.gui",
	"storedatabackground.gui",
	"storeequipmentdata.gui",
	"storegui_bs.tga",
	"storelist.gui",
	"storelistbackground.gui",
	"storelowerbuttons.gui",
	"storemaintab.gui",
	"stores.gda",
	"store_1_bg.tga",
	"store_2_bg.tga",
	"store_3_bg.tga",
	"store_4_bg.tga",
	"store_5_bg.tga",
	"store_ts.gui",
	"stotitle.gui",
	"strongholdbuttons.gui",
	"strongholdparty.gui",
	"strongholdreserve.gui",
	"strongholdtutorial.gda",
	"stronghold_ts.tga",
	"stronghold_tut_bs.tga",
	"stronghold_tut_ts.tga",
	"str_arrow_00.ncgr",
	"str_blank_ms00.ncgr",
	"str_box_hi00.ncgr",
	"str_buttn_of00.ncgr",
	"str_buttn_on00.ncgr",
	"str_helpb_of00.ncgr",
	"str_helpb_on00.ncgr",
	"str_party_ms00.ncgr",
	"str_party_ms10.ncgr",
	"str_resrv_ms00.ncgr",
	"str_resrv_ms10.ncgr",
	"str_resrv_ms20.ncgr",
	"str_tab_00.ncgr",
	"str_tab_01.ncgr",
	"str_tab_02.ncgr",
	"str_tlgbx_ms00.ncgr",
	"str_tlgbx_ms01.ncgr",
	"str_tlgbx_ms02.ncgr",
	"str_tlgbx_ms10.ncgr",
	"str_tlgbx_ms11.ncgr",
	"str_tlgbx_ms12.ncgr",
	"str_tlgbx_ms20.ncgr",
	"str_tlgbx_ms21.ncgr",
	"str_tlgbx_ms22.ncgr",
	"str_tmdbx_ms00.ncgr",
	"str_tmdbx_ms01.ncgr",
	"str_tmdbx_ms02.ncgr",
	"str_tmdbx_ms10.ncgr",
	"str_tmdbx_ms11.ncgr",
	"str_tmdbx_ms12.ncgr",
	"str_trigl_00.ncgr",
	"str_tsmbr_of00.ncgr",
	"str_tsmbr_of01.ncgr",
	"str_tsmbr_of02.ncgr",
	"str_tsmbr_on00.ncgr",
	"str_tsmbr_on01.ncgr",
	"str_tsmbr_on02.ncgr",
	"str_tsmbx_ms00.ncgr",
	"str_tsmbx_ms01.ncgr",
	"str_tsmbx_ms02.ncgr",
	"str_tsmbx_ms10.ncgr",
	"str_tsmbx_ms11.ncgr",
	"str_tsmbx_ms12.ncgr",
	"str_tsmbx_ms20.ncgr",
	"str_tsmbx_ms21.ncgr",
	"str_tsmbx_ms22.ncgr",
	"str_tsmbx_ms23.ncgr",
	"str_txtbr_di00.ncgr",
	"str_txtbr_di01.ncgr",
	"str_txtbr_di02.ncgr",
	"str_txtbr_hi00.ncgr",
	"str_txtbr_hi01.ncgr",
	"str_txtbr_hi02.ncgr",
	"str_vertl_ms00.ncgr",
	"str_vertl_ms10.ncgr",
	"str_vertw_ms00.ncgr",
	"str_vertw_ms10.ncgr",
	"subtitle_test.gda",
	"supersonic.gda",
	"swan_aa.nsbmd",
	"swan_aa.nsbtx",
	"swa_cb_attack.nsbca",
	"swa_cb_attackc.nsbca",
	"swa_cb_attackend.nsbca",
	"swa_cb_counter.nsbca",
	"swa_cb_damage.nsbca",
	"swa_cb_dead.nsbca",
	"swa_cb_getup.nsbca",
	"swa_cb_idle.nsbca",
	"swa_cb_kd.nsbca",
	"swa_cb_pattack.nsbca",
	"swa_ex_damage.nsbca",
	"swa_ex_idle.nsbca",
	"swa_ex_jump.nsbca",
	"swa_ex_run.nsbca",
	"swa_ex_walk.nsbca",
	"swtsbot_aa.nsbmd",
	"swtsbot_aa.nsbtx",
	"swtsbot_eye.nsbta",
	"swt_cb_attack.nsbca",
	"swt_cb_attackc.nsbca",
	"swt_cb_attackend.nsbca",
	"swt_cb_counter.nsbca",
	"swt_cb_damage.nsbca",
	"swt_cb_dead.nsbca",
	"swt_cb_getup.nsbca",
	"swt_cb_idle.nsbca",
	"swt_cb_kd.nsbca",
	"swt_cb_pattack.nsbca",
	"swt_ex_damage.nsbca",
	"swt_ex_fall.nsbca",
	"swt_ex_idle.nsbca",
	"swt_ex_jump.nsbca",
	"swt_ex_run.nsbca",
	"swt_ex_walk.nsbca",
	"sw_ne.gff",
	"syr_aa.nsbmd",
	"syr_aa.nsbtx",
	"syr_cb_attack.nsbca",
	"syr_cb_attackc.nsbca",
	"syr_cb_attackend.nsbca",
	"syr_cb_pattack.nsbca",
	"s_n.gff",
	"tabbedcharacterdisplay.gui",
	"tails_aa_p.ncgr",
	"tai_cb_attack.nsbca",
	"tai_cb_attackc.nsbca",
	"tai_cb_attackend.nsbca",
	"tai_cb_block.nsbca",
	"tai_cb_blockc.nsbca",
	"tai_cb_blockd.nsbca",
	"tai_cb_blockin.nsbca",
	"tai_cb_blockout.nsbca",
	"tai_cb_counter.nsbca",
	"tai_cb_dead.nsbca",
	"tai_cb_deadidle.nsbca",
	"tai_cb_idle.nsbca",
	"tai_cb_rund.nsbca",
	"tai_cb_support01.nsbca",
	"tai_cb_support02.nsbca",
	"tai_cb_support03.nsbca",
	"tai_cb_support05.nsbca",
	"tai_cb_support06.nsbca",
	"tai_cb_victory.nsbca",
	"tai_cb_victoryin.nsbca",
	"tai_ex_fall.nsbca",
	"tai_ex_flight.nsbca",
	"tai_ex_idle.nsbca",
	"tai_ex_jump.nsbca",
	"tai_ex_land.nsbca",
	"tai_ex_run.nsbca",
	"tai_ex_twitch.nsbca",
	"tai_ex_walk.nsbca",
	"targetring.ncgr",
	"targetting.gui",
	"temppartyadd.gff",
	"test.gui",
	"test.nftr",
	"texcache.gda",
	"textureanimations.gda",
	"tutorial.gui",
	"tut_flee.gda",
	"tut_follow.gda",
	"tut_inven.tga",
	"tut_item.gda",
	"tut_jump.gda",
	"tut_smash.gda",
	"tut_touch.gda",
	"tws1_minimap.nclr",
	"tyxis_arena_exit_stronghold.gff",
	"tyxis_arena_gentleman1_teleport.gff",
	"tyxis_arena_gentleman2_teleport.gff",
	"tyxis_arena_reset_sonic.gff",
	"tyx_aa.nsbmd",
	"tyx_aa.nsbtx",
	"tyx_aa_nrg.nsbta",
	"tyx_aa_sld.nsbta",
	"tyx_cb_attack.nsbca",
	"tyx_cb_attackc.nsbca",
	"tyx_cb_attackend.nsbca",
	"tyx_cb_blockc.nsbca",
	"tyx_cb_blockd.nsbca",
	"tyx_cb_blockidle.nsbca",
	"tyx_cb_blockin.nsbca",
	"tyx_cb_blockout.nsbca",
	"tyx_cb_counter.nsbca",
	"tyx_cb_damage.nsbca",
	"tyx_cb_dead.nsbca",
	"tyx_cb_getup.nsbca",
	"tyx_cb_idle.nsbca",
	"tyx_cb_kd.nsbca",
	"tyx_cb_pattack.nsbca",
	"tyx_ex_idle.nsbca",
	"tyx_ex_run.nsbca",
	"tyx_ex_walk.nsbca",
	"universaltool.gui",
	"uppertextbubble.gui",
	"upper_bg_00.ncgr",
	"upper_bg_01.ncgr",
	"upper_bg_02.ncgr",
	"upper_bg_03.ncgr",
	"upper_bg_04.ncgr",
	"upper_bg_05.ncgr",
	"upper_bg_06.ncgr",
	"upper_bg_07.ncgr",
	"upper_bg_08.ncgr",
	"upper_bg_09.ncgr",
	"upper_bg_10.ncgr",
	"upper_bg_11.ncgr",
	"upper_green_ring_00.ncgr",
	"upper_green_ring_01.ncgr",
	"upper_green_ring_02.ncgr",
	"upper_green_ring_03.ncgr",
	"upper_portrait_00.ncgr",
	"upper_portrait_01.ncgr",
	"upper_portrait_02.ncgr",
	"upper_portrait_03.ncgr",
	"upper_portrait_04.ncgr",
	"upper_portrait_05.ncgr",
	"upper_red_ring_00.ncgr",
	"upper_red_ring_01.ncgr",
	"upper_red_ring_02.ncgr",
	"upper_red_ring_03.ncgr",
	"upper_red_ring_04.ncgr",
	"upper_textbox_00.ncgr",
	"upper_textbox_01.ncgr",
	"upper_textbox_02.ncgr",
	"upper_textbox_03.ncgr",
	"upper_textbox_04.ncgr",
	"upper_textbox_05.ncgr",
	"upper_textbox_06.ncgr",
	"upper_textbox_07.ncgr",
	"upper_textbox_arrow_00.ncgr",
	"usehealth.ncgr",
	"useitem.ncgr",
	"vci_cb_attack.nsbca",
	"vci_cb_attackc.nsbca",
	"vci_cb_attackend.nsbca",
	"vel_cb_attack.nsbca",
	"vel_cb_attackc.nsbca",
	"vel_cb_attackend.nsbca",
	"version.txt",
	"vfx.gda",
	"victory.gui",
	"victorygui.gui",
	"voa_vob.gff",
	"vob_voa.gff",
	"vom_cb_attack.nsbca",
	"vom_cb_attackc.nsbca",
	"vom_cb_attackend.nsbca",
	"vom_cb_pattack1.nsbca",
	"vom_cb_pattack2.nsbca",
	"vom_cb_pattack3.nsbca",
	"voxai_alpha_climb_down.gff",
	"vox_aa.nsbmd",
	"vox_aa.nsbtx",
	"vox_cb_counter.nsbca",
	"vox_cb_damage.nsbca",
	"vox_cb_dead.nsbca",
	"vox_cb_getup.nsbca",
	"vox_cb_idle.nsbca",
	"vox_cb_kd.nsbca",
	"vox_cb_pattack1.nsbca",
	"vox_cb_pattack2.nsbca",
	"vox_cb_pattack3.nsbca",
	"vox_cb_pattack4.nsbca",
	"vox_ex_idle.nsbca",
	"vox_ex_run.nsbca",
	"vox_ex_walk.nsbca",
	"vox_hintguy.dlg",
	"vox_leu_aa.nsbmd",
	"vox_leu_aa.nsbtx",
	"vox_lig_aa.nsbmd",
	"vox_lig_aa.nsbtx",
	"vox_ove_aa.nsbmd",
	"vox_ove_aa.nsbtx",
	"vox_ovl_aa.nsbmd",
	"vox_ovl_aa.nsbtx",
	"vox_rbe_aa.nsbmd",
	"vox_rbe_aa.nsbtx",
	"vox_ria_aa.nsbmd",
	"vox_ria_aa.nsbtx",
	"vox_the_aa.nsbmd",
	"vox_the_aa.nsbtx",
	"walkmeshdebug.ncgr",
	"walkmesh_sized.raw",
	"waterslides.gda",
	"wel1_minimap.nclr",
	"well.are",
	"white6464.ncgr",
	"wmptitle.gui",
	"wmptutorial.gui",
	"wmp_airp_of00.ncgr",
	"wmp_airp_of01.ncgr",
	"wmp_airp_of10.ncgr",
	"wmp_airp_of11.ncgr",
	"wmp_airp_on00.ncgr",
	"wmp_airp_on01.ncgr",
	"wmp_airp_on10.ncgr",
	"wmp_airp_on11.ncgr",
	"wmp_ballo.ncgr",
	"wmp_indydot.ncgr",
	"wmp_l_airpo_00.ncgr",
	"wmp_l_airpo_00b.ncgr",
	"wmp_l_airpo_01.ncgr",
	"wmp_l_airpo_01b.ncgr",
	"wmp_l_airpo_02.ncgr",
	"wmp_l_airpo_02b.ncgr",
	"wmp_l_bridge.ncgr",
	"wmp_l_redpn00.ncgr",
	"wmp_space_of00.ncgr",
	"wmp_space_of01.ncgr",
	"wmp_space_of10.ncgr",
	"wmp_space_of11.ncgr",
	"wmp_space_on00.ncgr",
	"wmp_space_on01.ncgr",
	"wmp_space_on10.ncgr",
	"wmp_space_on11.ncgr",
	"wmp_s_airpo.ncgr",
	"wmp_s_bridge.ncgr",
	"wmp_s_ceggb.ncgr",
	"wmp_s_chaob.ncgr",
	"wmp_s_pin0.ncgr",
	"wmp_s_pin1.ncgr",
	"wmp_s_radar.nanr",
	"wmp_s_radar.ncer",
	"wmp_s_radar.ncgr",
	"wmp_s_redx.ncgr",
	"wmp_s_ringb.ncgr",
	"wmp_s_sonich.ncgr",
	"wmp_s_star.ncgr",
	"wmp_s_starb.ncgr",
	"wmp_trv_02_73.gff",
	"wmp_trv_03_04.gff",
	"wmp_trv_03_08.gff",
	"wmp_trv_03_18.gff",
	"wmp_trv_04_03.gff",
	"wmp_trv_04_08.gff",
	"wmp_trv_04_18.gff",
	"wmp_trv_08_03.gff",
	"wmp_trv_08_04.gff",
	"wmp_trv_08_18.gff",
	"wmp_trv_12_73.gff",
	"wmp_trv_14_13.gff",
	"wmp_trv_18_03.gff",
	"wmp_trv_18_04.gff",
	"wmp_trv_18_08.gff",
	"wmp_trv_72_73.gff",
	"wmp_trv_72_74.gff",
	"wmp_trv_72_75.gff",
	"wmp_trv_73_72.gff",
	"wmp_trv_73_74.gff",
	"wmp_trv_73_75.gff",
	"wmp_trv_74_72.gff",
	"wmp_trv_74_73.gff",
	"wmp_trv_74_75.gff",
	"wmp_trv_75_72.gff",
	"wmp_trv_75_73.gff",
	"wmp_trv_75_74.gff",
	"wmp_txtbr_tx00.ncgr",
	"wmp_txtbr_tx01.ncgr",
	"wmp_txtbr_tx02.ncgr",
	"wmp_txtbr_tx03.ncgr",
	"wmp_txtbr_tx04.ncgr",
	"wmp_txtbr_tx05.ncgr",
	"wmp_txtbr_tx06.ncgr",
	"wmp_txtbr_tx07.ncgr",
	"wm_cav_dr.tga",
	"wm_cav_drft.tga",
	"wm_crn_stc.tga",
	"wm_trndo_dn.tga",
	"wm_trndo_up.tga",
	"worldmap.gda",
	"worldmap_airbutton.gui",
	"worldmap_areaindicator.gui",
	"worldmap_backbutton.gui",
	"worldmap_maptitle.gui",
	"worldmap_pathdot.gui",
	"worldmap_sonicicon.gui",
	"worldmap_soniciconnopin.gui",
	"worldmap_spacebutton.gui",
	"worldmap_top1.gui",
	"worldmap_travelicon.gui",
	"worldmap_traveliconnopin.gui",
	"worldmap_tut.nbfp",
	"worldmap_tut.nbfs",
	"worldmap_tut_bs.tga",
	"worldmap_wslideend.gui",
	"wstest2.gff",
	"w_e.gff",
	"xbutton.ncgr",
	"ybutton.ncgr",
	"youarenotdoneyet.gda",
	"zoh_hintguy.dlg",
	"zz_greenhillzone.are",
	"zz_jaytest.dlg",
	"zz_well.are",
	"_blank.dlg",
	"_debug.dlg",
	"_resetinput.gff",
	"_typhoonnavigator.dlg"
};

} // End of namespace Sonic

} // End of namespace Engines

#endif // ENGINES_SONIC_FILES_H
